import{s as fo,o as go,n as Je}from"../chunks/scheduler.25b97de1.js";import{S as _o,i as bo,g as d,s as a,r as p,A as yo,h as l,f as o,c as s,j as L,u as h,x as m,k as P,y as r,a as i,v as f,d as g,t as _,w as b}from"../chunks/index.d9030fc9.js";import{T as ct}from"../chunks/Tip.baa67368.js";import{D as Z}from"../chunks/Docstring.e257edda.js";import{C as Nt}from"../chunks/CodeBlock.e6cd0d95.js";import{E as ho}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as Be,E as vo}from"../chunks/EditOnGithub.91d95064.js";function ko(M){let n,u;return n=new Nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN0YXJjb2RlcjJNb2RlbCUyQyUyMFN0YXJjb2RlcjJDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU3RhcmNvZGVyMiUyMDdCJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFN0YXJjb2RlcjJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBTdGFyY29kZXIyJTIwN0IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFN0YXJjb2RlcjJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Starcoder2Model, Starcoder2Config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Starcoder2 7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Starcoder2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Starcoder2 7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Starcoder2Model(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){p(n.$$.fragment)},l(c){h(n.$$.fragment,c)},m(c,y){f(n,c,y),u=!0},p:Je,i(c){u||(g(n.$$.fragment,c),u=!0)},o(c){_(n.$$.fragment,c),u=!1},d(c){b(n,c)}}}function To(M){let n,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=u},l(c){n=l(c,"P",{"data-svelte-h":!0}),m(n)!=="svelte-fincs2"&&(n.innerHTML=u)},m(c,y){i(c,n,y)},p:Je,d(c){c&&o(n)}}}function wo(M){let n,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=u},l(c){n=l(c,"P",{"data-svelte-h":!0}),m(n)!=="svelte-fincs2"&&(n.innerHTML=u)},m(c,y){i(c,n,y)},p:Je,d(c){c&&o(n)}}}function Mo(M){let n,u="Example:",c,y,z;return y=new Nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTdGFyY29kZXIyRm9yQ2F1c2FsTE0lMEElMEFtb2RlbCUyMCUzRCUyMFN0YXJjb2RlcjJGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRnN0YXJjb2RlcjItN2JfMTZrJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ2NvZGUlMkZzdGFyY29kZXIyLTdiXzE2ayUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QzMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Starcoder2ForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Starcoder2ForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder2-7b_16k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder2-7b_16k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){n=d("p"),n.textContent=u,c=a(),p(y.$$.fragment)},l(v){n=l(v,"P",{"data-svelte-h":!0}),m(n)!=="svelte-11lpom8"&&(n.textContent=u),c=s(v),h(y.$$.fragment,v)},m(v,F){i(v,n,F),i(v,c,F),f(y,v,F),z=!0},p:Je,i(v){z||(g(y.$$.fragment,v),z=!0)},o(v){_(y.$$.fragment,v),z=!1},d(v){v&&(o(n),o(c)),b(y,v)}}}function Co(M){let n,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=u},l(c){n=l(c,"P",{"data-svelte-h":!0}),m(n)!=="svelte-fincs2"&&(n.innerHTML=u)},m(c,y){i(c,n,y)},p:Je,d(c){c&&o(n)}}}function So(M){let n,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=u},l(c){n=l(c,"P",{"data-svelte-h":!0}),m(n)!=="svelte-fincs2"&&(n.innerHTML=u)},m(c,y){i(c,n,y)},p:Je,d(c){c&&o(n)}}}function $o(M){let n,u,c,y,z,v,F,Re,V,Jt='StarCoder2 is a family of open LLMs for code and comes in 3 different sizes with 3B, 7B and 15B parameters. The flagship StarCoder2-15B model is trained on over 4 trillion tokens and 600+ programming languages from The Stack v2. All models use Grouped Query Attention, a context window of 16,384 tokens with a sliding window attention of 4,096 tokens, and were trained using the Fill-in-the-Middle objective. The models have been released with the paper <a href="https://arxiv.org/abs/2402.19173" rel="nofollow">StarCoder 2 and The Stack v2: The Next Generation</a> by Anton Lozhkov, Raymond Li, Loubna Ben Allal, Federico Cassano, Joel Lamy-Poirier, Nouamane Tazi, Ao Tang, Dmytro Pykhtar, Jiawei Liu, Yuxiang Wei, Tianyang Liu, Max Tian, Denis Kocetkov, Arthur Zucker, Younes Belkada, Zijian Wang, Qian Liu, Dmitry Abulkhanov, Indraneil Paul, Zhuang Li, Wen-Ding Li, Megan Risdal, Jia Li, Jian Zhu, Terry Yue Zhuo, Evgenii Zheltonozhskii, Nii Osae Osae Dade, Wenhao Yu, Lucas Krauß, Naman Jain, Yixuan Su, Xuanli He, Manan Dey, Edoardo Abati, Yekun Chai, Niklas Muennighoff, Xiangru Tang, Muhtasham Oblokulov, Christopher Akiki, Marc Marone, Chenghao Mou, Mayank Mishra, Alex Gu, Binyuan Hui, Tri Dao, Armel Zebaze, Olivier Dehaene, Nicolas Patry, Canwen Xu, Julian McAuley, Han Hu, Torsten Scholak, Sebastien Paquet, Jennifer Robinson, Carolyn Jane Anderson, Nicolas Chapados, Mostofa Patwary, Nima Tajbakhsh, Yacine Jernite, Carlos Muñoz Ferrandis, Lingming Zhang, Sean Hughes, Thomas Wolf, Arjun Guha, Leandro von Werra, and Harm de Vries.',Ge,Y,Zt="The abstract of the paper is the following:",Ae,B,ve,Bt="The BigCode project, an open-scientific collaboration focused on the responsible development of Large Language Models for Code (Code LLMs), introduces StarCoder2. In partnership with Software Heritage (SWH), we build The Stack v2 on top of the digital commons of their source code archive. Alongside the SWH repositories spanning 619 programming languages, we carefully select other high-quality data sources, such as GitHub pull requests, Kaggle notebooks, and code documentation. This results in a training set that is 4x larger than the first StarCoder dataset. We train StarCoder2 models with 3B, 7B, and 15B parameters on 3.3 to 4.3 trillion tokens and thoroughly evaluate them on a comprehensive set of Code LLM benchmarks. We find that our small model, StarCoder2-3B, outperforms other Code LLMs of similar size on most benchmarks, and also outperforms StarCoderBase-15B. Our large model, StarCoder2- 15B, significantly outperforms other models of comparable size. In addition, it matches or outperforms CodeLlama-34B, a model more than twice its size. Although DeepSeekCoder- 33B is the best-performing model at code completion for high-resource languages, we find that StarCoder2-15B outperforms it on math and code reasoning benchmarks, as well as several low-resource languages. We make the model weights available under an OpenRAIL license and ensure full transparency regarding the training data by releasing the SoftWare Heritage persistent IDentifiers (SWHIDs) of the source code data.",mt,D,Oe,Q,Rt='The models are licensed under the <a href="https://huggingface.co/spaces/bigcode/bigcode-model-license-agreement" rel="nofollow">BigCode OpenRAIL-M v1 license agreement</a>.',Ee,K,Xe,ee,Gt='The StarCoder2 models can be found in the <a href="https://huggingface.co/collections/bigcode/starcoder2-65de6da6e87db3383572be1a" rel="nofollow">HuggingFace hub</a>. You can find some examples for inference and fine-tuning in StarCoder2’s <a href="https://github.com/bigcode-project/starcoder2" rel="nofollow">GitHub repo</a>.',Ve,te,At="These ready-to-use checkpoints can be downloaded and used via the HuggingFace Hub:",Ye,oe,De,ne,Qe,S,ae,ut,ke,Ot=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2Model">Starcoder2Model</a>. It is used to instantiate a
Starcoder2 model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/bigcode/starcoder2-7b_16k" rel="nofollow">bigcode/starcoder2-7b_16k</a> model.`,pt,Te,Et=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ht,R,Ke,se,Xt="## Starcoder2Model[[transformers.Starcoder2Model]]",et,T,re,ft,we,Vt=`The bare Starcoder2 Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,gt,Me,Yt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,_t,Ce,Dt="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>Starcoder2DecoderLayer</code>",bt,q,ie,yt,Se,Qt='The <a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2Model">Starcoder2Model</a> forward method, overrides the <code>__call__</code> special method.',vt,G,tt,de,Kt="## Starcoder2ForCausalLM[[transformers.Starcoder2ForCausalLM]]",ot,N,le,kt,x,ce,Tt,$e,eo='The <a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2ForCausalLM">Starcoder2ForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',wt,A,Mt,O,nt,me,to="## Starcoder2ForSequenceClassification[[transformers.Starcoder2ForSequenceClassification]]",at,k,ue,Ct,ze,oo="The Starcoder2 Model transformer with a sequence classification head on top (linear layer).",St,xe,no=`<a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2ForSequenceClassification">Starcoder2ForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,$t,Le,ao=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,zt,Fe,so=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,xt,Ie,ro=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Lt,U,pe,Ft,je,io='The <a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2ForSequenceClassification">Starcoder2ForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',It,E,st,he,lo="## Starcoder2ForTokenClassification[[transformers.Starcoder2ForTokenClassification]]",rt,w,fe,jt,Pe,co=`The Starcoder2 Model transformer with a token classification head on top (a linear layer on top of the hidden-states
output) e.g. for Named-Entity-Recognition (NER) tasks.`,Pt,qe,mo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,qt,Ue,uo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ut,H,ge,Ht,He,po='The <a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2ForTokenClassification">Starcoder2ForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',Wt,X,it,_e,dt,Ze,lt;return z=new Be({props:{title:"Starcoder2",local:"starcoder2",headingTag:"h1"}}),F=new Be({props:{title:"Overview",local:"overview",headingTag:"h2"}}),D=new Be({props:{title:"License",local:"license",headingTag:"h2"}}),K=new Be({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),oe=new Nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ2NvZGUlMkZzdGFyY29kZXIyLTdiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRnN0YXJjb2RlcjItN2IlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZGVmJTIwcHJpbnRfaGVsbG9fd29ybGQoKSUzQSUyMiUwQSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUJwcm9tcHQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder2-7b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder2-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;def print_hello_world():&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([prompt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">10</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;def print_hello_world():\\n    print(&quot;Hello World!&quot;)\\n\\ndef print&#x27;</span>`,wrap:!1}}),ne=new Be({props:{title:"Starcoder2Config",local:"transformers.Starcoder2Config",headingTag:"h2"}}),ae=new Z({props:{name:"class transformers.Starcoder2Config",anchor:"transformers.Starcoder2Config",parameters:[{name:"vocab_size",val:" = 49152"},{name:"hidden_size",val:" = 3072"},{name:"intermediate_size",val:" = 12288"},{name:"num_hidden_layers",val:" = 30"},{name:"num_attention_heads",val:" = 24"},{name:"num_key_value_heads",val:" = 2"},{name:"hidden_act",val:" = 'gelu_pytorch_tanh'"},{name:"max_position_embeddings",val:" = 4096"},{name:"initializer_range",val:" = 0.018042"},{name:"norm_epsilon",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"bos_token_id",val:" = 50256"},{name:"eos_token_id",val:" = 50256"},{name:"rope_theta",val:" = 10000.0"},{name:"sliding_window",val:" = None"},{name:"attention_dropout",val:" = 0.0"},{name:"residual_dropout",val:" = 0.0"},{name:"embedding_dropout",val:" = 0.0"},{name:"use_bias",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Starcoder2Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 49152) &#x2014;
Vocabulary size of the Starcoder2 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2Model">Starcoder2Model</a>`,name:"vocab_size"},{anchor:"transformers.Starcoder2Config.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.Starcoder2Config.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 12288) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.Starcoder2Config.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 30) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Starcoder2Config.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Starcoder2Config.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1 the model will use Multi Query Attention (MQA) otherwise GQA is used. When converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed by meanpooling all the original heads within that group. For more details checkout [this paper](https://arxiv.org/pdf/2305.13245.pdf). If it is not specified, will default to </code>8\`.`,name:"num_key_value_heads"},{anchor:"transformers.Starcoder2Config.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu_pytorch_tanh&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.Starcoder2Config.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
The maximum sequence length that this model might ever be used with. Starcoder2&#x2019;s sliding window attention
allows sequence of up to 4096*32 tokens.`,name:"max_position_embeddings"},{anchor:"transformers.Starcoder2Config.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Starcoder2Config.norm_epsilon",description:`<strong>norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
Epsilon value for the layer norm`,name:"norm_epsilon"},{anchor:"transformers.Starcoder2Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.Starcoder2Config.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 50256) &#x2014;
The id of the &#x201C;beginning-of-sequence&#x201D; token.`,name:"bos_token_id"},{anchor:"transformers.Starcoder2Config.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 50256) &#x2014;
The id of the &#x201C;end-of-sequence&#x201D; token.`,name:"eos_token_id"},{anchor:"transformers.Starcoder2Config.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.Starcoder2Config.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Sliding window attention window size. If not specified, will default to <code>None</code> (no sliding window).`,name:"sliding_window"},{anchor:"transformers.Starcoder2Config.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Starcoder2Config.residual_dropout",description:`<strong>residual_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Residual connection dropout value.`,name:"residual_dropout"},{anchor:"transformers.Starcoder2Config.embedding_dropout",description:`<strong>embedding_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Embedding dropout.`,name:"embedding_dropout"},{anchor:"transformers.Starcoder2Config.use_bias",description:`<strong>use_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias term on linear layers of the model.`,name:"use_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/starcoder2/configuration_starcoder2.py#L24"}}),R=new ho({props:{anchor:"transformers.Starcoder2Config.example",$$slots:{default:[ko]},$$scope:{ctx:M}}}),re=new Z({props:{name:"class transformers.Starcoder2Model",anchor:"transformers.Starcoder2Model",parameters:[{name:"config",val:": Starcoder2Config"}],parametersDescription:[{anchor:"transformers.Starcoder2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2Config">Starcoder2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; Starcoder2Config`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/starcoder2/modeling_starcoder2.py#L877"}}),ie=new Z({props:{name:"forward",anchor:"transformers.Starcoder2Model.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Starcoder2Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Starcoder2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Starcoder2Model.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Starcoder2Model.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Starcoder2Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Starcoder2Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Starcoder2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Starcoder2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Starcoder2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/starcoder2/modeling_starcoder2.py#L911"}}),G=new ct({props:{$$slots:{default:[To]},$$scope:{ctx:M}}}),le=new Z({props:{name:"class transformers.Starcoder2ForCausalLM",anchor:"transformers.Starcoder2ForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/starcoder2/modeling_starcoder2.py#L1062"}}),ce=new Z({props:{name:"forward",anchor:"transformers.Starcoder2ForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Starcoder2ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Starcoder2ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Starcoder2ForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Starcoder2ForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Starcoder2ForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Starcoder2ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Starcoder2ForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Starcoder2ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Starcoder2ForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/starcoder2/modeling_starcoder2.py#L1092",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2Config"
>Starcoder2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new ct({props:{$$slots:{default:[wo]},$$scope:{ctx:M}}}),O=new ho({props:{anchor:"transformers.Starcoder2ForCausalLM.forward.example",$$slots:{default:[Mo]},$$scope:{ctx:M}}}),ue=new Z({props:{name:"class transformers.Starcoder2ForSequenceClassification",anchor:"transformers.Starcoder2ForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Starcoder2ForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2Config">Starcoder2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/starcoder2/modeling_starcoder2.py#L1247"}}),pe=new Z({props:{name:"forward",anchor:"transformers.Starcoder2ForSequenceClassification.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Union = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Starcoder2ForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Starcoder2ForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/starcoder2/modeling_starcoder2.py#L1279"}}),E=new ct({props:{$$slots:{default:[Co]},$$scope:{ctx:M}}}),fe=new Z({props:{name:"class transformers.Starcoder2ForTokenClassification",anchor:"transformers.Starcoder2ForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Starcoder2ForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/starcoder2#transformers.Starcoder2Config">Starcoder2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/starcoder2/modeling_starcoder2.py#L1371"}}),ge=new Z({props:{name:"forward",anchor:"transformers.Starcoder2ForTokenClassification.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Starcoder2ForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Starcoder2ForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/starcoder2/modeling_starcoder2.py#L1402"}}),X=new ct({props:{$$slots:{default:[So]},$$scope:{ctx:M}}}),_e=new vo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/starcoder2.md"}}),{c(){n=d("meta"),u=a(),c=d("p"),y=a(),p(z.$$.fragment),v=a(),p(F.$$.fragment),Re=a(),V=d("p"),V.innerHTML=Jt,Ge=a(),Y=d("p"),Y.textContent=Zt,Ae=a(),B=d("blockquote"),ve=d("p"),ve.textContent=Bt,mt=a(),p(D.$$.fragment),Oe=a(),Q=d("p"),Q.innerHTML=Rt,Ee=a(),p(K.$$.fragment),Xe=a(),ee=d("p"),ee.innerHTML=Gt,Ve=a(),te=d("p"),te.textContent=At,Ye=a(),p(oe.$$.fragment),De=a(),p(ne.$$.fragment),Qe=a(),S=d("div"),p(ae.$$.fragment),ut=a(),ke=d("p"),ke.innerHTML=Ot,pt=a(),Te=d("p"),Te.innerHTML=Et,ht=a(),p(R.$$.fragment),Ke=a(),se=d("p"),se.textContent=Xt,et=a(),T=d("div"),p(re.$$.fragment),ft=a(),we=d("p"),we.innerHTML=Vt,gt=a(),Me=d("p"),Me.innerHTML=Yt,_t=a(),Ce=d("p"),Ce.innerHTML=Dt,bt=a(),q=d("div"),p(ie.$$.fragment),yt=a(),Se=d("p"),Se.innerHTML=Qt,vt=a(),p(G.$$.fragment),tt=a(),de=d("p"),de.textContent=Kt,ot=a(),N=d("div"),p(le.$$.fragment),kt=a(),x=d("div"),p(ce.$$.fragment),Tt=a(),$e=d("p"),$e.innerHTML=eo,wt=a(),p(A.$$.fragment),Mt=a(),p(O.$$.fragment),nt=a(),me=d("p"),me.textContent=to,at=a(),k=d("div"),p(ue.$$.fragment),Ct=a(),ze=d("p"),ze.textContent=oo,St=a(),xe=d("p"),xe.innerHTML=no,$t=a(),Le=d("p"),Le.innerHTML=ao,zt=a(),Fe=d("p"),Fe.innerHTML=so,xt=a(),Ie=d("p"),Ie.innerHTML=ro,Lt=a(),U=d("div"),p(pe.$$.fragment),Ft=a(),je=d("p"),je.innerHTML=io,It=a(),p(E.$$.fragment),st=a(),he=d("p"),he.textContent=lo,rt=a(),w=d("div"),p(fe.$$.fragment),jt=a(),Pe=d("p"),Pe.textContent=co,Pt=a(),qe=d("p"),qe.innerHTML=mo,qt=a(),Ue=d("p"),Ue.innerHTML=uo,Ut=a(),H=d("div"),p(ge.$$.fragment),Ht=a(),He=d("p"),He.innerHTML=po,Wt=a(),p(X.$$.fragment),it=a(),p(_e.$$.fragment),dt=a(),Ze=d("p"),this.h()},l(e){const t=yo("svelte-u9bgzb",document.head);n=l(t,"META",{name:!0,content:!0}),t.forEach(o),u=s(e),c=l(e,"P",{}),L(c).forEach(o),y=s(e),h(z.$$.fragment,e),v=s(e),h(F.$$.fragment,e),Re=s(e),V=l(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1n8n0dk"&&(V.innerHTML=Jt),Ge=s(e),Y=l(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-wu27l3"&&(Y.textContent=Zt),Ae=s(e),B=l(e,"BLOCKQUOTE",{});var be=L(B);ve=l(be,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-1cdgnq1"&&(ve.textContent=Bt),mt=s(be),h(D.$$.fragment,be),be.forEach(o),Oe=s(e),Q=l(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1289i3b"&&(Q.innerHTML=Rt),Ee=s(e),h(K.$$.fragment,e),Xe=s(e),ee=l(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-1gol27n"&&(ee.innerHTML=Gt),Ve=s(e),te=l(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-a5tlwb"&&(te.textContent=At),Ye=s(e),h(oe.$$.fragment,e),De=s(e),h(ne.$$.fragment,e),Qe=s(e),S=l(e,"DIV",{class:!0});var I=L(S);h(ae.$$.fragment,I),ut=s(I),ke=l(I,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-xjwqhv"&&(ke.innerHTML=Ot),pt=s(I),Te=l(I,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-mby5n"&&(Te.innerHTML=Et),ht=s(I),h(R.$$.fragment,I),I.forEach(o),Ke=s(e),se=l(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-v53k4"&&(se.textContent=Xt),et=s(e),T=l(e,"DIV",{class:!0});var $=L(T);h(re.$$.fragment,$),ft=s($),we=l($,"P",{"data-svelte-h":!0}),m(we)!=="svelte-1nly081"&&(we.innerHTML=Vt),gt=s($),Me=l($,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1ydu1el"&&(Me.innerHTML=Yt),_t=s($),Ce=l($,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-1inq57c"&&(Ce.innerHTML=Dt),bt=s($),q=l($,"DIV",{class:!0});var J=L(q);h(ie.$$.fragment,J),yt=s(J),Se=l(J,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-1965gxa"&&(Se.innerHTML=Qt),vt=s(J),h(G.$$.fragment,J),J.forEach(o),$.forEach(o),tt=s(e),de=l(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-1c8liqc"&&(de.textContent=Kt),ot=s(e),N=l(e,"DIV",{class:!0});var ye=L(N);h(le.$$.fragment,ye),kt=s(ye),x=l(ye,"DIV",{class:!0});var j=L(x);h(ce.$$.fragment,j),Tt=s(j),$e=l(j,"P",{"data-svelte-h":!0}),m($e)!=="svelte-g7j5y6"&&($e.innerHTML=eo),wt=s(j),h(A.$$.fragment,j),Mt=s(j),h(O.$$.fragment,j),j.forEach(o),ye.forEach(o),nt=s(e),me=l(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-1qnsuw0"&&(me.textContent=to),at=s(e),k=l(e,"DIV",{class:!0});var C=L(k);h(ue.$$.fragment,C),Ct=s(C),ze=l(C,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-pjsk7t"&&(ze.textContent=oo),St=s(C),xe=l(C,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-vnp4s3"&&(xe.innerHTML=no),$t=s(C),Le=l(C,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-10ugs3m"&&(Le.innerHTML=ao),zt=s(C),Fe=l(C,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-7tllb6"&&(Fe.innerHTML=so),xt=s(C),Ie=l(C,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-1ydu1el"&&(Ie.innerHTML=ro),Lt=s(C),U=l(C,"DIV",{class:!0});var We=L(U);h(pe.$$.fragment,We),Ft=s(We),je=l(We,"P",{"data-svelte-h":!0}),m(je)!=="svelte-t9i0m2"&&(je.innerHTML=io),It=s(We),h(E.$$.fragment,We),We.forEach(o),C.forEach(o),st=s(e),he=l(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-1tm14i"&&(he.textContent=lo),rt=s(e),w=l(e,"DIV",{class:!0});var W=L(w);h(fe.$$.fragment,W),jt=s(W),Pe=l(W,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-cif3t8"&&(Pe.textContent=co),Pt=s(W),qe=l(W,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-7tllb6"&&(qe.innerHTML=mo),qt=s(W),Ue=l(W,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-1ydu1el"&&(Ue.innerHTML=uo),Ut=s(W),H=l(W,"DIV",{class:!0});var Ne=L(H);h(ge.$$.fragment,Ne),Ht=s(Ne),He=l(Ne,"P",{"data-svelte-h":!0}),m(He)!=="svelte-78rozg"&&(He.innerHTML=po),Wt=s(Ne),h(X.$$.fragment,Ne),Ne.forEach(o),W.forEach(o),it=s(e),h(_e.$$.fragment,e),dt=s(e),Ze=l(e,"P",{}),L(Ze).forEach(o),this.h()},h(){P(n,"name","hf:doc:metadata"),P(n,"content",zo),P(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,n),i(e,u,t),i(e,c,t),i(e,y,t),f(z,e,t),i(e,v,t),f(F,e,t),i(e,Re,t),i(e,V,t),i(e,Ge,t),i(e,Y,t),i(e,Ae,t),i(e,B,t),r(B,ve),r(B,mt),f(D,B,null),i(e,Oe,t),i(e,Q,t),i(e,Ee,t),f(K,e,t),i(e,Xe,t),i(e,ee,t),i(e,Ve,t),i(e,te,t),i(e,Ye,t),f(oe,e,t),i(e,De,t),f(ne,e,t),i(e,Qe,t),i(e,S,t),f(ae,S,null),r(S,ut),r(S,ke),r(S,pt),r(S,Te),r(S,ht),f(R,S,null),i(e,Ke,t),i(e,se,t),i(e,et,t),i(e,T,t),f(re,T,null),r(T,ft),r(T,we),r(T,gt),r(T,Me),r(T,_t),r(T,Ce),r(T,bt),r(T,q),f(ie,q,null),r(q,yt),r(q,Se),r(q,vt),f(G,q,null),i(e,tt,t),i(e,de,t),i(e,ot,t),i(e,N,t),f(le,N,null),r(N,kt),r(N,x),f(ce,x,null),r(x,Tt),r(x,$e),r(x,wt),f(A,x,null),r(x,Mt),f(O,x,null),i(e,nt,t),i(e,me,t),i(e,at,t),i(e,k,t),f(ue,k,null),r(k,Ct),r(k,ze),r(k,St),r(k,xe),r(k,$t),r(k,Le),r(k,zt),r(k,Fe),r(k,xt),r(k,Ie),r(k,Lt),r(k,U),f(pe,U,null),r(U,Ft),r(U,je),r(U,It),f(E,U,null),i(e,st,t),i(e,he,t),i(e,rt,t),i(e,w,t),f(fe,w,null),r(w,jt),r(w,Pe),r(w,Pt),r(w,qe),r(w,qt),r(w,Ue),r(w,Ut),r(w,H),f(ge,H,null),r(H,Ht),r(H,He),r(H,Wt),f(X,H,null),i(e,it,t),f(_e,e,t),i(e,dt,t),i(e,Ze,t),lt=!0},p(e,[t]){const be={};t&2&&(be.$$scope={dirty:t,ctx:e}),R.$set(be);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),G.$set(I);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),A.$set($);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),O.$set(J);const ye={};t&2&&(ye.$$scope={dirty:t,ctx:e}),E.$set(ye);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),X.$set(j)},i(e){lt||(g(z.$$.fragment,e),g(F.$$.fragment,e),g(D.$$.fragment,e),g(K.$$.fragment,e),g(oe.$$.fragment,e),g(ne.$$.fragment,e),g(ae.$$.fragment,e),g(R.$$.fragment,e),g(re.$$.fragment,e),g(ie.$$.fragment,e),g(G.$$.fragment,e),g(le.$$.fragment,e),g(ce.$$.fragment,e),g(A.$$.fragment,e),g(O.$$.fragment,e),g(ue.$$.fragment,e),g(pe.$$.fragment,e),g(E.$$.fragment,e),g(fe.$$.fragment,e),g(ge.$$.fragment,e),g(X.$$.fragment,e),g(_e.$$.fragment,e),lt=!0)},o(e){_(z.$$.fragment,e),_(F.$$.fragment,e),_(D.$$.fragment,e),_(K.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(R.$$.fragment,e),_(re.$$.fragment,e),_(ie.$$.fragment,e),_(G.$$.fragment,e),_(le.$$.fragment,e),_(ce.$$.fragment,e),_(A.$$.fragment,e),_(O.$$.fragment,e),_(ue.$$.fragment,e),_(pe.$$.fragment,e),_(E.$$.fragment,e),_(fe.$$.fragment,e),_(ge.$$.fragment,e),_(X.$$.fragment,e),_(_e.$$.fragment,e),lt=!1},d(e){e&&(o(u),o(c),o(y),o(v),o(Re),o(V),o(Ge),o(Y),o(Ae),o(B),o(Oe),o(Q),o(Ee),o(Xe),o(ee),o(Ve),o(te),o(Ye),o(De),o(Qe),o(S),o(Ke),o(se),o(et),o(T),o(tt),o(de),o(ot),o(N),o(nt),o(me),o(at),o(k),o(st),o(he),o(rt),o(w),o(it),o(dt),o(Ze)),o(n),b(z,e),b(F,e),b(D),b(K,e),b(oe,e),b(ne,e),b(ae),b(R),b(re),b(ie),b(G),b(le),b(ce),b(A),b(O),b(ue),b(pe),b(E),b(fe),b(ge),b(X),b(_e,e)}}}const zo='{"title":"Starcoder2","local":"starcoder2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"License","local":"license","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Starcoder2Config","local":"transformers.Starcoder2Config","sections":[],"depth":2}],"depth":1}';function xo(M){return go(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ho extends _o{constructor(n){super(),bo(this,n,xo,$o,fo,{})}}export{Ho as component};
