import{s as Fn,o as Qn,n as xn}from"../chunks/scheduler.182ea377.js";import{S as Yn,i as Ln,g as r,s as a,r as c,A as Dn,h as s,f as n,c as i,j as rn,u as o,x as d,k as Nn,y as T,a as l,v as p,d as g,t as m,w as h}from"../chunks/index.abf12888.js";import{T as An}from"../chunks/Tip.230e2334.js";import{C as J}from"../chunks/CodeBlock.57fe6e13.js";import{H as M}from"../chunks/Heading.16916d63.js";function qn(Et){let f,U='Learn more about other ways PyTorch 2.0 can help optimize your model in the <a href="../tutorials/fast_diffusion">Accelerate inference of text-to-image diffusion models</a> tutorial.';return{c(){f=r("p"),f.innerHTML=U},l(y){f=s(y,"P",{"data-svelte-h":!0}),d(f)!=="svelte-5loj68"&&(f.innerHTML=U)},m(y,zt){l(y,f,zt)},p:xn,d(y){y&&n(f)}}}function Pn(Et){let f,U,y,zt,j,Nt,Z,sn='🤗 Diffusers supports the latest optimizations from <a href="https://pytorch.org/get-started/pytorch-2.0/" rel="nofollow">PyTorch 2.0</a> which include:',Ft,B,dn='<li>A memory-efficient attention implementation, scaled dot product attention, without requiring any extra dependencies such as xFormers.</li> <li><a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow"><code>torch.compile</code></a>, a just-in-time (JIT) compiler to provide an extra performance boost when individual models are compiled.</li>',Qt,$,cn="Both of these optimizations require PyTorch 2.0 or later and 🤗 Diffusers > 0.13.0.",xt,W,Yt,X,Lt,G,on='<a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention" rel="nofollow"><code>torch.nn.functional.scaled_dot_product_attention</code></a> (SDPA) is an optimized and memory-efficient attention (similar to xFormers) that automatically enables several other optimizations depending on the model inputs and GPU type. SDPA is enabled by default if you’re using PyTorch 2.0 and the latest version of 🤗 Diffusers, so you don’t need to add anything to your code.',Dt,R,pn='However, if you want to explicitly enable it, you can set a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to use <a href="/docs/diffusers/main/en/api/attnprocessor#diffusers.models.attention_processor.AttnProcessor2_0">AttnProcessor2_0</a>:',At,S,qt,v,gn='SDPA should be as fast and memory efficient as <code>xFormers</code>; check the <a href="#benchmark">benchmark</a> for more details.',Pt,_,mn='In some cases - such as making the pipeline more deterministic or converting it to other formats - it may be helpful to use the vanilla attention processor, <a href="/docs/diffusers/main/en/api/attnprocessor#diffusers.models.attention_processor.AttnProcessor">AttnProcessor</a>. To revert to <a href="/docs/diffusers/main/en/api/attnprocessor#diffusers.models.attention_processor.AttnProcessor">AttnProcessor</a>, call the <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel.set_default_attn_processor">set_default_attn_processor()</a> function on the pipeline:',Kt,I,Ot,V,te,C,hn="The <code>torch.compile</code> function can often provide an additional speed-up to your PyTorch code. In 🤗 Diffusers, it is usually best to wrap the UNet with <code>torch.compile</code> because it does most of the heavy lifting in the pipeline.",ee,k,ne,z,Mn="Depending on GPU type, <code>torch.compile</code> can provide an <em>additional speed-up</em> of <strong>5-300x</strong> on top of SDPA! If you’re using more recent GPU architectures such as Ampere (A100, 3090), Ada (4090), and Hopper (H100), <code>torch.compile</code> is able to squeeze even more performance out of these GPUs.",le,H,bn="Compilation requires some time to complete, so it is best suited for situations where you prepare your pipeline once and then perform the same type of inference operations multiple times. For example, calling the compiled pipeline on a different image size triggers compilation again which can be expensive.",ae,E,un='For more information and different options about <code>torch.compile</code>, refer to the <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow"><code>torch_compile</code></a> tutorial.',ie,w,re,N,se,F,fn='We conducted a comprehensive benchmark with PyTorch 2.0’s efficient attention implementation and <code>torch.compile</code> across different GPUs and batch sizes for five of our most used pipelines. The code is benchmarked on 🤗 Diffusers v0.17.0.dev0 to optimize <code>torch.compile</code> usage (see <a href="https://github.com/huggingface/diffusers/pull/3313" rel="nofollow">here</a> for more details).',de,Q,yn="Expand the dropdown below to find the code used to benchmark each pipeline:",ce,b,x,qe,Y,Pe,L,Ke,D,Oe,A,tn,q,en,P,nn,K,ln,O,an,tt,oe,et,Tn='The graph below highlights the relative speed-ups for the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> across five GPU families with PyTorch 2.0 and <code>torch.compile</code> enabled. The benchmarks for the following graphs are measured in <em>number of iterations/second</em>.',pe,nt,Jn='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/pt2_benchmarks/t2i_speedup.png" alt="t2i_speedup"/>',ge,lt,wn=`To give you an even better idea of how this speed-up holds for the other pipelines, consider the following
graph for an A100 with PyTorch 2.0 and <code>torch.compile</code>:`,me,at,Un='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/pt2_benchmarks/a100_numbers.png" alt="a100_numbers"/>',he,it,jn="In the following tables, we report our findings in terms of the <em>number of iterations/second</em>.",Me,rt,be,st,Zn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">21.66</td> <td align="center">23.13</td> <td align="center">44.03</td> <td align="center">49.74</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">21.81</td> <td align="center">22.40</td> <td align="center">43.92</td> <td align="center">46.32</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">22.24</td> <td align="center">23.23</td> <td align="center">43.76</td> <td align="center">49.25</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">15.02</td> <td align="center">15.82</td> <td align="center">32.13</td> <td align="center">36.08</td></tr> <tr><td align="center">IF</td> <td align="center">20.21 / <br/>13.84 / <br/>24.00</td> <td align="center">20.12 / <br/>13.70 / <br/>24.03</td> <td align="center">❌</td> <td align="center">97.34 / <br/>27.23 / <br/>111.66</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">8.64</td> <td align="center">9.9</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',ue,dt,fe,ct,Bn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">11.6</td> <td align="center">13.12</td> <td align="center">14.62</td> <td align="center">17.27</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">11.47</td> <td align="center">13.06</td> <td align="center">14.66</td> <td align="center">17.25</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">11.67</td> <td align="center">13.31</td> <td align="center">14.88</td> <td align="center">17.48</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">8.28</td> <td align="center">9.38</td> <td align="center">10.51</td> <td align="center">12.41</td></tr> <tr><td align="center">IF</td> <td align="center">25.02</td> <td align="center">18.04</td> <td align="center">❌</td> <td align="center">48.47</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">2.44</td> <td align="center">2.74</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',ye,ot,Te,pt,$n='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">3.04</td> <td align="center">3.6</td> <td align="center">3.83</td> <td align="center">4.68</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">2.98</td> <td align="center">3.58</td> <td align="center">3.83</td> <td align="center">4.67</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">3.04</td> <td align="center">3.66</td> <td align="center">3.9</td> <td align="center">4.76</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">2.15</td> <td align="center">2.58</td> <td align="center">2.74</td> <td align="center">3.35</td></tr> <tr><td align="center">IF</td> <td align="center">8.78</td> <td align="center">9.82</td> <td align="center">❌</td> <td align="center">16.77</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">0.64</td> <td align="center">0.72</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',Je,gt,we,mt,Wn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">18.99</td> <td align="center">19.14</td> <td align="center">20.95</td> <td align="center">22.17</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">18.56</td> <td align="center">19.18</td> <td align="center">20.95</td> <td align="center">22.11</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">19.14</td> <td align="center">19.06</td> <td align="center">21.08</td> <td align="center">22.20</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">13.48</td> <td align="center">13.93</td> <td align="center">15.18</td> <td align="center">15.88</td></tr> <tr><td align="center">IF</td> <td align="center">20.01 / <br/>9.08 / <br/>23.34</td> <td align="center">19.79 / <br/>8.98 / <br/>24.10</td> <td align="center">❌</td> <td align="center">55.75 / <br/>11.57 / <br/>57.67</td></tr></tbody>',Ue,ht,je,Mt,Xn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">5.96</td> <td align="center">5.89</td> <td align="center">6.83</td> <td align="center">6.86</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">5.90</td> <td align="center">5.91</td> <td align="center">6.81</td> <td align="center">6.82</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">5.99</td> <td align="center">6.03</td> <td align="center">6.93</td> <td align="center">6.95</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">4.26</td> <td align="center">4.29</td> <td align="center">4.92</td> <td align="center">4.93</td></tr> <tr><td align="center">IF</td> <td align="center">15.41</td> <td align="center">14.76</td> <td align="center">❌</td> <td align="center">22.95</td></tr></tbody>',Ze,bt,Be,ut,Gn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">1.66</td> <td align="center">1.66</td> <td align="center">1.92</td> <td align="center">1.90</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">1.65</td> <td align="center">1.65</td> <td align="center">1.91</td> <td align="center">1.89</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">1.69</td> <td align="center">1.69</td> <td align="center">1.95</td> <td align="center">1.93</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">1.19</td> <td align="center">1.19</td> <td align="center">OOM after warmup</td> <td align="center">1.36</td></tr> <tr><td align="center">IF</td> <td align="center">5.43</td> <td align="center">5.29</td> <td align="center">❌</td> <td align="center">7.06</td></tr></tbody>',$e,ft,We,yt,Rn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">6.9</td> <td align="center">6.95</td> <td align="center">7.3</td> <td align="center">7.56</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">6.84</td> <td align="center">6.99</td> <td align="center">7.04</td> <td align="center">7.55</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">6.91</td> <td align="center">6.7</td> <td align="center">7.01</td> <td align="center">7.37</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">4.89</td> <td align="center">4.86</td> <td align="center">5.35</td> <td align="center">5.48</td></tr> <tr><td align="center">IF</td> <td align="center">17.42 / <br/>2.47 / <br/>18.52</td> <td align="center">16.96 / <br/>2.45 / <br/>18.69</td> <td align="center">❌</td> <td align="center">24.63 / <br/>2.47 / <br/>23.39</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">1.15</td> <td align="center">1.16</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',Xe,Tt,Ge,Jt,Sn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">1.79</td> <td align="center">1.79</td> <td align="center">2.03</td> <td align="center">1.99</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">1.77</td> <td align="center">1.77</td> <td align="center">2.05</td> <td align="center">2.04</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">1.81</td> <td align="center">1.82</td> <td align="center">2.09</td> <td align="center">2.09</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">1.34</td> <td align="center">1.27</td> <td align="center">1.47</td> <td align="center">1.46</td></tr> <tr><td align="center">IF</td> <td align="center">5.79</td> <td align="center">5.61</td> <td align="center">❌</td> <td align="center">7.39</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">0.288</td> <td align="center">0.289</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',Re,wt,Se,Ut,vn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">2.34s</td> <td align="center">2.30s</td> <td align="center">OOM after 2nd iteration</td> <td align="center">1.99s</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">2.35s</td> <td align="center">2.31s</td> <td align="center">OOM after warmup</td> <td align="center">2.00s</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">2.30s</td> <td align="center">2.26s</td> <td align="center">OOM after 2nd iteration</td> <td align="center">1.95s</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">OOM after 2nd iteration</td> <td align="center">OOM after 2nd iteration</td> <td align="center">OOM after warmup</td> <td align="center">OOM after warmup</td></tr> <tr><td align="center">IF *</td> <td align="center">1.44</td> <td align="center">1.44</td> <td align="center">❌</td> <td align="center">1.94</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">OOM</td> <td align="center">OOM</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',ve,jt,_e,Zt,_n='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">22.56</td> <td align="center">22.84</td> <td align="center">23.84</td> <td align="center">25.69</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">22.25</td> <td align="center">22.61</td> <td align="center">24.1</td> <td align="center">25.83</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">22.22</td> <td align="center">22.54</td> <td align="center">24.26</td> <td align="center">26.02</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">16.03</td> <td align="center">16.33</td> <td align="center">17.38</td> <td align="center">18.56</td></tr> <tr><td align="center">IF</td> <td align="center">27.08 / <br/>9.07 / <br/>31.23</td> <td align="center">26.75 / <br/>8.92 / <br/>31.47</td> <td align="center">❌</td> <td align="center">68.08 / <br/>11.16 / <br/>65.29</td></tr></tbody>',Ie,Bt,Ve,$t,In='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">6.46</td> <td align="center">6.35</td> <td align="center">7.29</td> <td align="center">7.3</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">6.33</td> <td align="center">6.27</td> <td align="center">7.31</td> <td align="center">7.26</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">6.47</td> <td align="center">6.4</td> <td align="center">7.44</td> <td align="center">7.39</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">4.59</td> <td align="center">4.54</td> <td align="center">5.27</td> <td align="center">5.26</td></tr> <tr><td align="center">IF</td> <td align="center">16.81</td> <td align="center">16.62</td> <td align="center">❌</td> <td align="center">21.57</td></tr></tbody>',Ce,Wt,ke,Xt,Vn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">1.7</td> <td align="center">1.69</td> <td align="center">1.93</td> <td align="center">1.91</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">1.68</td> <td align="center">1.67</td> <td align="center">1.93</td> <td align="center">1.9</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">1.72</td> <td align="center">1.71</td> <td align="center">1.97</td> <td align="center">1.94</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">1.23</td> <td align="center">1.22</td> <td align="center">1.4</td> <td align="center">1.38</td></tr> <tr><td align="center">IF</td> <td align="center">5.01</td> <td align="center">5.00</td> <td align="center">❌</td> <td align="center">6.33</td></tr></tbody>',ze,Gt,He,Rt,Cn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">40.5</td> <td align="center">41.89</td> <td align="center">44.65</td> <td align="center">49.81</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">40.39</td> <td align="center">41.95</td> <td align="center">44.46</td> <td align="center">49.8</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">40.51</td> <td align="center">41.88</td> <td align="center">44.58</td> <td align="center">49.72</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">29.27</td> <td align="center">30.29</td> <td align="center">32.26</td> <td align="center">36.03</td></tr> <tr><td align="center">IF</td> <td align="center">69.71 / <br/>18.78 / <br/>85.49</td> <td align="center">69.13 / <br/>18.80 / <br/>85.56</td> <td align="center">❌</td> <td align="center">124.60 / <br/>26.37 / <br/>138.79</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">6.8</td> <td align="center">8.18</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',Ee,St,Ne,vt,kn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">12.62</td> <td align="center">12.84</td> <td align="center">15.32</td> <td align="center">15.59</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">12.61</td> <td align="center">12,.79</td> <td align="center">15.35</td> <td align="center">15.66</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">12.65</td> <td align="center">12.81</td> <td align="center">15.3</td> <td align="center">15.58</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">9.1</td> <td align="center">9.25</td> <td align="center">11.03</td> <td align="center">11.22</td></tr> <tr><td align="center">IF</td> <td align="center">31.88</td> <td align="center">31.14</td> <td align="center">❌</td> <td align="center">43.92</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">2.19</td> <td align="center">2.35</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',Fe,_t,Qe,It,zn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">3.17</td> <td align="center">3.2</td> <td align="center">3.84</td> <td align="center">3.85</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">3.16</td> <td align="center">3.2</td> <td align="center">3.84</td> <td align="center">3.85</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">3.17</td> <td align="center">3.2</td> <td align="center">3.85</td> <td align="center">3.85</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">2.23</td> <td align="center">2.3</td> <td align="center">2.7</td> <td align="center">2.75</td></tr> <tr><td align="center">IF</td> <td align="center">9.26</td> <td align="center">9.2</td> <td align="center">❌</td> <td align="center">13.31</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">0.52</td> <td align="center">0.53</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',xe,Vt,Ye,Ct,Hn='<li>Follow this <a href="https://github.com/huggingface/diffusers/pull/3313" rel="nofollow">PR</a> for more details on the environment used for conducting the benchmarks.</li> <li>For the DeepFloyd IF pipeline where batch sizes &gt; 1, we only used a batch size of &gt; 1 in the first IF pipeline for text-to-image generation and NOT for upscaling. That means the two upscaling pipelines received a batch size of 1.</li>',Le,kt,En='<em>Thanks to <a href="https://github.com/Chillee" rel="nofollow">Horace He</a> from the PyTorch team for their support in improving our support of <code>torch.compile()</code> in Diffusers.</em>',De,Ht,Ae;return j=new M({props:{title:"PyTorch 2.0",local:"pytorch-20",headingTag:"h1"}}),W=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHRvcmNoJTIwZGlmZnVzZXJz",highlighted:"pip install --upgrade torch diffusers",wrap:!1}}),X=new M({props:{title:"Scaled dot product attention",local:"scaled-dot-product-attention",headingTag:"h2"}}),S=new J({props:{code:"JTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMjAlMjBmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMkIlMjBmcm9tJTIwZGlmZnVzZXJzLm1vZGVscy5hdHRlbnRpb25fcHJvY2Vzc29yJTIwaW1wb3J0JTIwQXR0blByb2Nlc3NvcjJfMCUwQSUwQSUyMCUyMHBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMjJjdWRhJTIyKSUwQSUyQiUyMHBpcGUudW5ldC5zZXRfYXR0bl9wcm9jZXNzb3IoQXR0blByb2Nlc3NvcjJfMCgpKSUwQSUwQSUyMCUyMHByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEElMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`  import torch
  from diffusers import DiffusionPipeline
<span class="hljs-addition">+ from diffusers.models.attention_processor import AttnProcessor2_0</span>

  pipe = DiffusionPipeline.from_pretrained(&quot;runwayml/stable-diffusion-v1-5&quot;, torch_dtype=torch.float16, use_safetensors=True).to(&quot;cuda&quot;)
<span class="hljs-addition">+ pipe.unet.set_attn_processor(AttnProcessor2_0())</span>

  prompt = &quot;a photo of an astronaut riding a horse on mars&quot;
  image = pipe(prompt).images[0]`,wrap:!1}}),I=new J({props:{code:"JTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMjAlMjBmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEElMjAlMjBwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSkudG8oJTIyY3VkYSUyMiklMEElMkIlMjBwaXBlLnVuZXQuc2V0X2RlZmF1bHRfYXR0bl9wcm9jZXNzb3IoKSUwQSUwQSUyMCUyMHByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEElMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`  import torch
  from diffusers import DiffusionPipeline

  pipe = DiffusionPipeline.from_pretrained(&quot;runwayml/stable-diffusion-v1-5&quot;, torch_dtype=torch.float16, use_safetensors=True).to(&quot;cuda&quot;)
<span class="hljs-addition">+ pipe.unet.set_default_attn_processor()</span>

  prompt = &quot;a photo of an astronaut riding a horse on mars&quot;
  image = pipe(prompt).images[0]`,wrap:!1}}),V=new M({props:{title:"torch.compile",local:"torchcompile",headingTag:"h2"}}),k=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSkudG8oJTIyY3VkYSUyMiklMEFwaXBlLnVuZXQlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGUudW5ldCUyQyUyMG1vZGUlM0QlMjJyZWR1Y2Utb3ZlcmhlYWQlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKSUwQWltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRHN0ZXBzJTJDJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEYmF0Y2hfc2l6ZSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
images = pipe(prompt, num_inference_steps=steps, num_images_per_prompt=batch_size).images[<span class="hljs-number">0</span>]`,wrap:!1}}),w=new An({props:{warning:!1,$$slots:{default:[qn]},$$scope:{ctx:Et}}}),N=new M({props:{title:"Benchmark",local:"benchmark",headingTag:"h2"}}),x=new M({props:{title:"Stable Diffusion text-to-image",local:"stable-diffusion-text-to-image",headingTag:"h3"}}),Y=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwYXRoJTIwJTNEJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEElMEFydW5fY29tcGlsZSUyMCUzRCUyMFRydWUlMjAlMjAlMjMlMjBTZXQlMjBUcnVlJTIwJTJGJTIwRmFsc2UlMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHBhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS51bmV0LnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KSUwQSUwQWlmJTIwcnVuX2NvbXBpbGUlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJSdW4lMjB0b3JjaCUyMGNvbXBpbGUlMjIpJTBBJTIwJTIwJTIwJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJnaGlibGklMjBzdHlsZSUyQyUyMGElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTIwd2l0aCUyMGNhc3RsZXMlMjIlMEElMEFmb3IlMjBfJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0KS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

run_compile = <span class="hljs-literal">True</span>  <span class="hljs-comment"># Set True / False</span>

pipe = DiffusionPipeline.from_pretrained(path, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.to(memory_format=torch.channels_last)

<span class="hljs-keyword">if</span> run_compile:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Run torch compile&quot;</span>)
    pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with castles&quot;</span>

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    images = pipe(prompt=prompt).images`,wrap:!1}}),L=new M({props:{title:"Stable Diffusion image-to-image",local:"stable-diffusion-image-to-image",headingTag:"h3"}}),D=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcGF0aCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBJTBBcnVuX2NvbXBpbGUlMjAlM0QlMjBUcnVlJTIwJTIwJTIzJTIwU2V0JTIwVHJ1ZSUyMCUyRiUyMEZhbHNlJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEFwaXBlLnVuZXQudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTBBJTBBaWYlMjBydW5fY29tcGlsZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMlJ1biUyMHRvcmNoJTIwY29tcGlsZSUyMiklMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGUudW5ldCUyQyUyMG1vZGUlM0QlMjJyZWR1Y2Utb3ZlcmhlYWQlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmdoaWJsaSUyMHN0eWxlJTJDJTIwYSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMjB3aXRoJTIwY2FzdGxlcyUyMiUwQSUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

init_image = load_image(url)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

run_compile = <span class="hljs-literal">True</span>  <span class="hljs-comment"># Set True / False</span>

pipe = StableDiffusionImg2ImgPipeline.from_pretrained(path, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.to(memory_format=torch.channels_last)

<span class="hljs-keyword">if</span> run_compile:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Run torch compile&quot;</span>)
    pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with castles&quot;</span>

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),A=new M({props:{title:"Stable Diffusion inpainting",local:"stable-diffusion-inpainting",headingTag:"h3"}}),q=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW8ucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1b19tYXNrLnBuZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXBhdGglMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUwQSUwQXJ1bl9jb21waWxlJTIwJTNEJTIwVHJ1ZSUyMCUyMCUyMyUyMFNldCUyMFRydWUlMjAlMkYlMjBGYWxzZSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnBhaW50UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHBhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS51bmV0LnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KSUwQSUwQWlmJTIwcnVuX2NvbXBpbGUlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJSdW4lMjB0b3JjaCUyMGNvbXBpbGUlMjIpJTBBJTIwJTIwJTIwJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJnaGlibGklMjBzdHlsZSUyQyUyMGElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTIwd2l0aCUyMGNhc3RsZXMlMjIlMEElMEFmb3IlMjBfJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = load_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = load_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

path = <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>

run_compile = <span class="hljs-literal">True</span>  <span class="hljs-comment"># Set True / False</span>

pipe = StableDiffusionInpaintPipeline.from_pretrained(path, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.to(memory_format=torch.channels_last)

<span class="hljs-keyword">if</span> run_compile:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Run torch compile&quot;</span>)
    pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with castles&quot;</span>

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    image = pipe(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),P=new M({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),K=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcGF0aCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBJTBBcnVuX2NvbXBpbGUlMjAlM0QlMjBUcnVlJTIwJTIwJTIzJTIwU2V0JTIwVHJ1ZSUyMCUyRiUyMEZhbHNlJTBBY29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybGxseWFzdmllbCUyRnNkLWNvbnRyb2xuZXQtY2FubnklMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Db250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMHBhdGglMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEFwaXBlLnVuZXQudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTBBcGlwZS5jb250cm9sbmV0LnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KSUwQSUwQWlmJTIwcnVuX2NvbXBpbGUlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJSdW4lMjB0b3JjaCUyMGNvbXBpbGUlMjIpJTBBJTIwJTIwJTIwJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBwaXBlLmNvbnRyb2xuZXQlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGUuY29udHJvbG5ldCUyQyUyMG1vZGUlM0QlMjJyZWR1Y2Utb3ZlcmhlYWQlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmdoaWJsaSUyMHN0eWxlJTJDJTIwYSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMjB3aXRoJTIwY2FzdGxlcyUyMiUwQSUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

init_image = load_image(url)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

run_compile = <span class="hljs-literal">True</span>  <span class="hljs-comment"># Set True / False</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    path, controlnet=controlnet, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)

pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.to(memory_format=torch.channels_last)
pipe.controlnet.to(memory_format=torch.channels_last)

<span class="hljs-keyword">if</span> run_compile:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Run torch compile&quot;</span>)
    pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    pipe.controlnet = torch.<span class="hljs-built_in">compile</span>(pipe.controlnet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with castles&quot;</span>

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),O=new M({props:{title:"DeepFloyd IF text-to-image + upscaling",local:"deepfloyd-if-text-to-image--upscaling",headingTag:"h3"}}),tt=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

run_compile = <span class="hljs-literal">True</span>  <span class="hljs-comment"># Set True / False</span>

pipe_1 = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;DeepFloyd/IF-I-M-v1.0&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, text_encoder=<span class="hljs-literal">None</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe_1.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe_2 = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;DeepFloyd/IF-II-M-v1.0&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, text_encoder=<span class="hljs-literal">None</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe_2.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe_3 = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-x4-upscaler&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe_3.to(<span class="hljs-string">&quot;cuda&quot;</span>)


pipe_1.unet.to(memory_format=torch.channels_last)
pipe_2.unet.to(memory_format=torch.channels_last)
pipe_3.unet.to(memory_format=torch.channels_last)

<span class="hljs-keyword">if</span> run_compile:
    pipe_1.unet = torch.<span class="hljs-built_in">compile</span>(pipe_1.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    pipe_2.unet = torch.<span class="hljs-built_in">compile</span>(pipe_2.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    pipe_3.unet = torch.<span class="hljs-built_in">compile</span>(pipe_3.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;the blue hulk&quot;</span>

prompt_embeds = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">4096</span>), dtype=torch.float16)
neg_prompt_embeds = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">4096</span>), dtype=torch.float16)

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    image_1 = pipe_1(prompt_embeds=prompt_embeds, negative_prompt_embeds=neg_prompt_embeds, output_type=<span class="hljs-string">&quot;pt&quot;</span>).images
    image_2 = pipe_2(image=image_1, prompt_embeds=prompt_embeds, negative_prompt_embeds=neg_prompt_embeds, output_type=<span class="hljs-string">&quot;pt&quot;</span>).images
    image_3 = pipe_3(prompt=prompt, image=image_1, noise_level=<span class="hljs-number">100</span>).images`,wrap:!1}}),rt=new M({props:{title:"A100 (batch size: 1)",local:"a100-batch-size-1",headingTag:"h3"}}),dt=new M({props:{title:"A100 (batch size: 4)",local:"a100-batch-size-4",headingTag:"h3"}}),ot=new M({props:{title:"A100 (batch size: 16)",local:"a100-batch-size-16",headingTag:"h3"}}),gt=new M({props:{title:"V100 (batch size: 1)",local:"v100-batch-size-1",headingTag:"h3"}}),ht=new M({props:{title:"V100 (batch size: 4)",local:"v100-batch-size-4",headingTag:"h3"}}),bt=new M({props:{title:"V100 (batch size: 16)",local:"v100-batch-size-16",headingTag:"h3"}}),ft=new M({props:{title:"T4 (batch size: 1)",local:"t4-batch-size-1",headingTag:"h3"}}),Tt=new M({props:{title:"T4 (batch size: 4)",local:"t4-batch-size-4",headingTag:"h3"}}),wt=new M({props:{title:"T4 (batch size: 16)",local:"t4-batch-size-16",headingTag:"h3"}}),jt=new M({props:{title:"RTX 3090 (batch size: 1)",local:"rtx-3090-batch-size-1",headingTag:"h3"}}),Bt=new M({props:{title:"RTX 3090 (batch size: 4)",local:"rtx-3090-batch-size-4",headingTag:"h3"}}),Wt=new M({props:{title:"RTX 3090 (batch size: 16)",local:"rtx-3090-batch-size-16",headingTag:"h3"}}),Gt=new M({props:{title:"RTX 4090 (batch size: 1)",local:"rtx-4090-batch-size-1",headingTag:"h3"}}),St=new M({props:{title:"RTX 4090 (batch size: 4)",local:"rtx-4090-batch-size-4",headingTag:"h3"}}),_t=new M({props:{title:"RTX 4090 (batch size: 16)",local:"rtx-4090-batch-size-16",headingTag:"h3"}}),Vt=new M({props:{title:"Notes",local:"notes",headingTag:"h2"}}),{c(){f=r("meta"),U=a(),y=r("p"),zt=a(),c(j.$$.fragment),Nt=a(),Z=r("p"),Z.innerHTML=sn,Ft=a(),B=r("ol"),B.innerHTML=dn,Qt=a(),$=r("p"),$.textContent=cn,xt=a(),c(W.$$.fragment),Yt=a(),c(X.$$.fragment),Lt=a(),G=r("p"),G.innerHTML=on,Dt=a(),R=r("p"),R.innerHTML=pn,At=a(),c(S.$$.fragment),qt=a(),v=r("p"),v.innerHTML=gn,Pt=a(),_=r("p"),_.innerHTML=mn,Kt=a(),c(I.$$.fragment),Ot=a(),c(V.$$.fragment),te=a(),C=r("p"),C.innerHTML=hn,ee=a(),c(k.$$.fragment),ne=a(),z=r("p"),z.innerHTML=Mn,le=a(),H=r("p"),H.textContent=bn,ae=a(),E=r("p"),E.innerHTML=un,ie=a(),c(w.$$.fragment),re=a(),c(N.$$.fragment),se=a(),F=r("p"),F.innerHTML=fn,de=a(),Q=r("p"),Q.textContent=yn,ce=a(),b=r("details"),c(x.$$.fragment),qe=a(),c(Y.$$.fragment),Pe=a(),c(L.$$.fragment),Ke=a(),c(D.$$.fragment),Oe=a(),c(A.$$.fragment),tn=a(),c(q.$$.fragment),en=a(),c(P.$$.fragment),nn=a(),c(K.$$.fragment),ln=a(),c(O.$$.fragment),an=a(),c(tt.$$.fragment),oe=a(),et=r("p"),et.innerHTML=Tn,pe=a(),nt=r("p"),nt.innerHTML=Jn,ge=a(),lt=r("p"),lt.innerHTML=wn,me=a(),at=r("p"),at.innerHTML=Un,he=a(),it=r("p"),it.innerHTML=jn,Me=a(),c(rt.$$.fragment),be=a(),st=r("table"),st.innerHTML=Zn,ue=a(),c(dt.$$.fragment),fe=a(),ct=r("table"),ct.innerHTML=Bn,ye=a(),c(ot.$$.fragment),Te=a(),pt=r("table"),pt.innerHTML=$n,Je=a(),c(gt.$$.fragment),we=a(),mt=r("table"),mt.innerHTML=Wn,Ue=a(),c(ht.$$.fragment),je=a(),Mt=r("table"),Mt.innerHTML=Xn,Ze=a(),c(bt.$$.fragment),Be=a(),ut=r("table"),ut.innerHTML=Gn,$e=a(),c(ft.$$.fragment),We=a(),yt=r("table"),yt.innerHTML=Rn,Xe=a(),c(Tt.$$.fragment),Ge=a(),Jt=r("table"),Jt.innerHTML=Sn,Re=a(),c(wt.$$.fragment),Se=a(),Ut=r("table"),Ut.innerHTML=vn,ve=a(),c(jt.$$.fragment),_e=a(),Zt=r("table"),Zt.innerHTML=_n,Ie=a(),c(Bt.$$.fragment),Ve=a(),$t=r("table"),$t.innerHTML=In,Ce=a(),c(Wt.$$.fragment),ke=a(),Xt=r("table"),Xt.innerHTML=Vn,ze=a(),c(Gt.$$.fragment),He=a(),Rt=r("table"),Rt.innerHTML=Cn,Ee=a(),c(St.$$.fragment),Ne=a(),vt=r("table"),vt.innerHTML=kn,Fe=a(),c(_t.$$.fragment),Qe=a(),It=r("table"),It.innerHTML=zn,xe=a(),c(Vt.$$.fragment),Ye=a(),Ct=r("ul"),Ct.innerHTML=Hn,Le=a(),kt=r("p"),kt.innerHTML=En,De=a(),Ht=r("p"),this.h()},l(t){const e=Dn("svelte-u9bgzb",document.head);f=s(e,"META",{name:!0,content:!0}),e.forEach(n),U=i(t),y=s(t,"P",{}),rn(y).forEach(n),zt=i(t),o(j.$$.fragment,t),Nt=i(t),Z=s(t,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-15wmwhw"&&(Z.innerHTML=sn),Ft=i(t),B=s(t,"OL",{"data-svelte-h":!0}),d(B)!=="svelte-19p82dc"&&(B.innerHTML=dn),Qt=i(t),$=s(t,"P",{"data-svelte-h":!0}),d($)!=="svelte-1u908i1"&&($.textContent=cn),xt=i(t),o(W.$$.fragment,t),Yt=i(t),o(X.$$.fragment,t),Lt=i(t),G=s(t,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1bb69gh"&&(G.innerHTML=on),Dt=i(t),R=s(t,"P",{"data-svelte-h":!0}),d(R)!=="svelte-17rfy2v"&&(R.innerHTML=pn),At=i(t),o(S.$$.fragment,t),qt=i(t),v=s(t,"P",{"data-svelte-h":!0}),d(v)!=="svelte-psbnvm"&&(v.innerHTML=gn),Pt=i(t),_=s(t,"P",{"data-svelte-h":!0}),d(_)!=="svelte-rccjls"&&(_.innerHTML=mn),Kt=i(t),o(I.$$.fragment,t),Ot=i(t),o(V.$$.fragment,t),te=i(t),C=s(t,"P",{"data-svelte-h":!0}),d(C)!=="svelte-1vjh5md"&&(C.innerHTML=hn),ee=i(t),o(k.$$.fragment,t),ne=i(t),z=s(t,"P",{"data-svelte-h":!0}),d(z)!=="svelte-mm2mnz"&&(z.innerHTML=Mn),le=i(t),H=s(t,"P",{"data-svelte-h":!0}),d(H)!=="svelte-19iy5vt"&&(H.textContent=bn),ae=i(t),E=s(t,"P",{"data-svelte-h":!0}),d(E)!=="svelte-yz7oqo"&&(E.innerHTML=un),ie=i(t),o(w.$$.fragment,t),re=i(t),o(N.$$.fragment,t),se=i(t),F=s(t,"P",{"data-svelte-h":!0}),d(F)!=="svelte-km3nc0"&&(F.innerHTML=fn),de=i(t),Q=s(t,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-pe5bn7"&&(Q.textContent=yn),ce=i(t),b=s(t,"DETAILS",{});var u=rn(b);o(x.$$.fragment,u),qe=i(u),o(Y.$$.fragment,u),Pe=i(u),o(L.$$.fragment,u),Ke=i(u),o(D.$$.fragment,u),Oe=i(u),o(A.$$.fragment,u),tn=i(u),o(q.$$.fragment,u),en=i(u),o(P.$$.fragment,u),nn=i(u),o(K.$$.fragment,u),ln=i(u),o(O.$$.fragment,u),an=i(u),o(tt.$$.fragment,u),u.forEach(n),oe=i(t),et=s(t,"P",{"data-svelte-h":!0}),d(et)!=="svelte-1m6hgn1"&&(et.innerHTML=Tn),pe=i(t),nt=s(t,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-1sjwyaz"&&(nt.innerHTML=Jn),ge=i(t),lt=s(t,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-1zzsz7"&&(lt.innerHTML=wn),me=i(t),at=s(t,"P",{"data-svelte-h":!0}),d(at)!=="svelte-19p9vzv"&&(at.innerHTML=Un),he=i(t),it=s(t,"P",{"data-svelte-h":!0}),d(it)!=="svelte-18iwyus"&&(it.innerHTML=jn),Me=i(t),o(rt.$$.fragment,t),be=i(t),st=s(t,"TABLE",{"data-svelte-h":!0}),d(st)!=="svelte-14f48w"&&(st.innerHTML=Zn),ue=i(t),o(dt.$$.fragment,t),fe=i(t),ct=s(t,"TABLE",{"data-svelte-h":!0}),d(ct)!=="svelte-19bbd89"&&(ct.innerHTML=Bn),ye=i(t),o(ot.$$.fragment,t),Te=i(t),pt=s(t,"TABLE",{"data-svelte-h":!0}),d(pt)!=="svelte-cd9a2o"&&(pt.innerHTML=$n),Je=i(t),o(gt.$$.fragment,t),we=i(t),mt=s(t,"TABLE",{"data-svelte-h":!0}),d(mt)!=="svelte-9j8rj7"&&(mt.innerHTML=Wn),Ue=i(t),o(ht.$$.fragment,t),je=i(t),Mt=s(t,"TABLE",{"data-svelte-h":!0}),d(Mt)!=="svelte-1xs3uwi"&&(Mt.innerHTML=Xn),Ze=i(t),o(bt.$$.fragment,t),Be=i(t),ut=s(t,"TABLE",{"data-svelte-h":!0}),d(ut)!=="svelte-1elkjwp"&&(ut.innerHTML=Gn),$e=i(t),o(ft.$$.fragment,t),We=i(t),yt=s(t,"TABLE",{"data-svelte-h":!0}),d(yt)!=="svelte-sqqgka"&&(yt.innerHTML=Rn),Xe=i(t),o(Tt.$$.fragment,t),Ge=i(t),Jt=s(t,"TABLE",{"data-svelte-h":!0}),d(Jt)!=="svelte-15f755w"&&(Jt.innerHTML=Sn),Re=i(t),o(wt.$$.fragment,t),Se=i(t),Ut=s(t,"TABLE",{"data-svelte-h":!0}),d(Ut)!=="svelte-uuno4d"&&(Ut.innerHTML=vn),ve=i(t),o(jt.$$.fragment,t),_e=i(t),Zt=s(t,"TABLE",{"data-svelte-h":!0}),d(Zt)!=="svelte-1hbo08l"&&(Zt.innerHTML=_n),Ie=i(t),o(Bt.$$.fragment,t),Ve=i(t),$t=s(t,"TABLE",{"data-svelte-h":!0}),d($t)!=="svelte-abi9u4"&&($t.innerHTML=In),Ce=i(t),o(Wt.$$.fragment,t),ke=i(t),Xt=s(t,"TABLE",{"data-svelte-h":!0}),d(Xt)!=="svelte-11m8i0f"&&(Xt.innerHTML=Vn),ze=i(t),o(Gt.$$.fragment,t),He=i(t),Rt=s(t,"TABLE",{"data-svelte-h":!0}),d(Rt)!=="svelte-1i4s3fg"&&(Rt.innerHTML=Cn),Ee=i(t),o(St.$$.fragment,t),Ne=i(t),vt=s(t,"TABLE",{"data-svelte-h":!0}),d(vt)!=="svelte-13cqeai"&&(vt.innerHTML=kn),Fe=i(t),o(_t.$$.fragment,t),Qe=i(t),It=s(t,"TABLE",{"data-svelte-h":!0}),d(It)!=="svelte-16al08t"&&(It.innerHTML=zn),xe=i(t),o(Vt.$$.fragment,t),Ye=i(t),Ct=s(t,"UL",{"data-svelte-h":!0}),d(Ct)!=="svelte-1xg6qk7"&&(Ct.innerHTML=Hn),Le=i(t),kt=s(t,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-7zliwv"&&(kt.innerHTML=En),De=i(t),Ht=s(t,"P",{}),rn(Ht).forEach(n),this.h()},h(){Nn(f,"name","hf:doc:metadata"),Nn(f,"content",Kn)},m(t,e){T(document.head,f),l(t,U,e),l(t,y,e),l(t,zt,e),p(j,t,e),l(t,Nt,e),l(t,Z,e),l(t,Ft,e),l(t,B,e),l(t,Qt,e),l(t,$,e),l(t,xt,e),p(W,t,e),l(t,Yt,e),p(X,t,e),l(t,Lt,e),l(t,G,e),l(t,Dt,e),l(t,R,e),l(t,At,e),p(S,t,e),l(t,qt,e),l(t,v,e),l(t,Pt,e),l(t,_,e),l(t,Kt,e),p(I,t,e),l(t,Ot,e),p(V,t,e),l(t,te,e),l(t,C,e),l(t,ee,e),p(k,t,e),l(t,ne,e),l(t,z,e),l(t,le,e),l(t,H,e),l(t,ae,e),l(t,E,e),l(t,ie,e),p(w,t,e),l(t,re,e),p(N,t,e),l(t,se,e),l(t,F,e),l(t,de,e),l(t,Q,e),l(t,ce,e),l(t,b,e),p(x,b,null),T(b,qe),p(Y,b,null),T(b,Pe),p(L,b,null),T(b,Ke),p(D,b,null),T(b,Oe),p(A,b,null),T(b,tn),p(q,b,null),T(b,en),p(P,b,null),T(b,nn),p(K,b,null),T(b,ln),p(O,b,null),T(b,an),p(tt,b,null),l(t,oe,e),l(t,et,e),l(t,pe,e),l(t,nt,e),l(t,ge,e),l(t,lt,e),l(t,me,e),l(t,at,e),l(t,he,e),l(t,it,e),l(t,Me,e),p(rt,t,e),l(t,be,e),l(t,st,e),l(t,ue,e),p(dt,t,e),l(t,fe,e),l(t,ct,e),l(t,ye,e),p(ot,t,e),l(t,Te,e),l(t,pt,e),l(t,Je,e),p(gt,t,e),l(t,we,e),l(t,mt,e),l(t,Ue,e),p(ht,t,e),l(t,je,e),l(t,Mt,e),l(t,Ze,e),p(bt,t,e),l(t,Be,e),l(t,ut,e),l(t,$e,e),p(ft,t,e),l(t,We,e),l(t,yt,e),l(t,Xe,e),p(Tt,t,e),l(t,Ge,e),l(t,Jt,e),l(t,Re,e),p(wt,t,e),l(t,Se,e),l(t,Ut,e),l(t,ve,e),p(jt,t,e),l(t,_e,e),l(t,Zt,e),l(t,Ie,e),p(Bt,t,e),l(t,Ve,e),l(t,$t,e),l(t,Ce,e),p(Wt,t,e),l(t,ke,e),l(t,Xt,e),l(t,ze,e),p(Gt,t,e),l(t,He,e),l(t,Rt,e),l(t,Ee,e),p(St,t,e),l(t,Ne,e),l(t,vt,e),l(t,Fe,e),p(_t,t,e),l(t,Qe,e),l(t,It,e),l(t,xe,e),p(Vt,t,e),l(t,Ye,e),l(t,Ct,e),l(t,Le,e),l(t,kt,e),l(t,De,e),l(t,Ht,e),Ae=!0},p(t,[e]){const u={};e&2&&(u.$$scope={dirty:e,ctx:t}),w.$set(u)},i(t){Ae||(g(j.$$.fragment,t),g(W.$$.fragment,t),g(X.$$.fragment,t),g(S.$$.fragment,t),g(I.$$.fragment,t),g(V.$$.fragment,t),g(k.$$.fragment,t),g(w.$$.fragment,t),g(N.$$.fragment,t),g(x.$$.fragment,t),g(Y.$$.fragment,t),g(L.$$.fragment,t),g(D.$$.fragment,t),g(A.$$.fragment,t),g(q.$$.fragment,t),g(P.$$.fragment,t),g(K.$$.fragment,t),g(O.$$.fragment,t),g(tt.$$.fragment,t),g(rt.$$.fragment,t),g(dt.$$.fragment,t),g(ot.$$.fragment,t),g(gt.$$.fragment,t),g(ht.$$.fragment,t),g(bt.$$.fragment,t),g(ft.$$.fragment,t),g(Tt.$$.fragment,t),g(wt.$$.fragment,t),g(jt.$$.fragment,t),g(Bt.$$.fragment,t),g(Wt.$$.fragment,t),g(Gt.$$.fragment,t),g(St.$$.fragment,t),g(_t.$$.fragment,t),g(Vt.$$.fragment,t),Ae=!0)},o(t){m(j.$$.fragment,t),m(W.$$.fragment,t),m(X.$$.fragment,t),m(S.$$.fragment,t),m(I.$$.fragment,t),m(V.$$.fragment,t),m(k.$$.fragment,t),m(w.$$.fragment,t),m(N.$$.fragment,t),m(x.$$.fragment,t),m(Y.$$.fragment,t),m(L.$$.fragment,t),m(D.$$.fragment,t),m(A.$$.fragment,t),m(q.$$.fragment,t),m(P.$$.fragment,t),m(K.$$.fragment,t),m(O.$$.fragment,t),m(tt.$$.fragment,t),m(rt.$$.fragment,t),m(dt.$$.fragment,t),m(ot.$$.fragment,t),m(gt.$$.fragment,t),m(ht.$$.fragment,t),m(bt.$$.fragment,t),m(ft.$$.fragment,t),m(Tt.$$.fragment,t),m(wt.$$.fragment,t),m(jt.$$.fragment,t),m(Bt.$$.fragment,t),m(Wt.$$.fragment,t),m(Gt.$$.fragment,t),m(St.$$.fragment,t),m(_t.$$.fragment,t),m(Vt.$$.fragment,t),Ae=!1},d(t){t&&(n(U),n(y),n(zt),n(Nt),n(Z),n(Ft),n(B),n(Qt),n($),n(xt),n(Yt),n(Lt),n(G),n(Dt),n(R),n(At),n(qt),n(v),n(Pt),n(_),n(Kt),n(Ot),n(te),n(C),n(ee),n(ne),n(z),n(le),n(H),n(ae),n(E),n(ie),n(re),n(se),n(F),n(de),n(Q),n(ce),n(b),n(oe),n(et),n(pe),n(nt),n(ge),n(lt),n(me),n(at),n(he),n(it),n(Me),n(be),n(st),n(ue),n(fe),n(ct),n(ye),n(Te),n(pt),n(Je),n(we),n(mt),n(Ue),n(je),n(Mt),n(Ze),n(Be),n(ut),n($e),n(We),n(yt),n(Xe),n(Ge),n(Jt),n(Re),n(Se),n(Ut),n(ve),n(_e),n(Zt),n(Ie),n(Ve),n($t),n(Ce),n(ke),n(Xt),n(ze),n(He),n(Rt),n(Ee),n(Ne),n(vt),n(Fe),n(Qe),n(It),n(xe),n(Ye),n(Ct),n(Le),n(kt),n(De),n(Ht)),n(f),h(j,t),h(W,t),h(X,t),h(S,t),h(I,t),h(V,t),h(k,t),h(w,t),h(N,t),h(x),h(Y),h(L),h(D),h(A),h(q),h(P),h(K),h(O),h(tt),h(rt,t),h(dt,t),h(ot,t),h(gt,t),h(ht,t),h(bt,t),h(ft,t),h(Tt,t),h(wt,t),h(jt,t),h(Bt,t),h(Wt,t),h(Gt,t),h(St,t),h(_t,t),h(Vt,t)}}}const Kn='{"title":"PyTorch 2.0","local":"pytorch-20","sections":[{"title":"Scaled dot product attention","local":"scaled-dot-product-attention","sections":[],"depth":2},{"title":"torch.compile","local":"torchcompile","sections":[],"depth":2},{"title":"Benchmark","local":"benchmark","sections":[{"title":"Stable Diffusion text-to-image","local":"stable-diffusion-text-to-image","sections":[],"depth":3},{"title":"Stable Diffusion image-to-image","local":"stable-diffusion-image-to-image","sections":[],"depth":3},{"title":"Stable Diffusion inpainting","local":"stable-diffusion-inpainting","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3},{"title":"DeepFloyd IF text-to-image + upscaling","local":"deepfloyd-if-text-to-image--upscaling","sections":[],"depth":3},{"title":"A100 (batch size: 1)","local":"a100-batch-size-1","sections":[],"depth":3},{"title":"A100 (batch size: 4)","local":"a100-batch-size-4","sections":[],"depth":3},{"title":"A100 (batch size: 16)","local":"a100-batch-size-16","sections":[],"depth":3},{"title":"V100 (batch size: 1)","local":"v100-batch-size-1","sections":[],"depth":3},{"title":"V100 (batch size: 4)","local":"v100-batch-size-4","sections":[],"depth":3},{"title":"V100 (batch size: 16)","local":"v100-batch-size-16","sections":[],"depth":3},{"title":"T4 (batch size: 1)","local":"t4-batch-size-1","sections":[],"depth":3},{"title":"T4 (batch size: 4)","local":"t4-batch-size-4","sections":[],"depth":3},{"title":"T4 (batch size: 16)","local":"t4-batch-size-16","sections":[],"depth":3},{"title":"RTX 3090 (batch size: 1)","local":"rtx-3090-batch-size-1","sections":[],"depth":3},{"title":"RTX 3090 (batch size: 4)","local":"rtx-3090-batch-size-4","sections":[],"depth":3},{"title":"RTX 3090 (batch size: 16)","local":"rtx-3090-batch-size-16","sections":[],"depth":3},{"title":"RTX 4090 (batch size: 1)","local":"rtx-4090-batch-size-1","sections":[],"depth":3},{"title":"RTX 4090 (batch size: 4)","local":"rtx-4090-batch-size-4","sections":[],"depth":3},{"title":"RTX 4090 (batch size: 16)","local":"rtx-4090-batch-size-16","sections":[],"depth":3}],"depth":2},{"title":"Notes","local":"notes","sections":[],"depth":2}],"depth":1}';function On(Et){return Qn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends Yn{constructor(f){super(),Ln(this,f,On,Pn,Fn,{})}}export{il as component};
