import{s as ad,n as nd,o as cd}from"../chunks/scheduler.b108d059.js";import{S as pd,i as hd,g as d,s as r,r as c,A as fd,h as o,f as i,c as u,j as n,u as p,x as s,k as a,y as md,a as l,v as h,d as f,t as m,w as T}from"../chunks/index.008de539.js";import{H as $,E as Td}from"../chunks/EditOnGithub.d1c48e3d.js";function $d(Jr){let _,qt,Nt,Rt,y,gt,k,It,L,Xr="Custom data structures.",zt,v,Yr=`These are only used internally, meaning an end-user shouldn’t
need to access anything here.`,Kt,x,Zr='<li><a href="#module_utils/data-structures">utils/data-structures</a><ul><li><em>static</em><ul><li><a href="#module_utils/data-structures.PriorityQueue">.PriorityQueue</a><ul><li><a href="#new_module_utils/data-structures.PriorityQueue_new"><code>new PriorityQueue(comparator)</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+size"><code>.size</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+isEmpty"><code>.isEmpty()</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+peek"><code>.peek()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+push"><code>.push(...values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+extend"><code>.extend(values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+pop"><code>.pop()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+replace"><code>.replace(value)</code></a> ⇒ <code>*</code></li></ul></li> <li><a href="#module_utils/data-structures.CharTrie">.CharTrie</a><ul><li><a href="#module_utils/data-structures.CharTrie+extend"><code>.extend(texts)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+push"><code>.push(text)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+commonPrefixSearch"><code>.commonPrefixSearch(text)</code></a></li></ul></li> <li><a href="#module_utils/data-structures.TokenLattice">.TokenLattice</a><ul><li><a href="#new_module_utils/data-structures.TokenLattice_new"><code>new TokenLattice(sentence, bosTokenId, eosTokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+insert"><code>.insert(pos, length, score, tokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+viterbi"><code>.viterbi()</code></a> ⇒ <code>Array.&lt;TokenLatticeNode&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+piece"><code>.piece(node)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokens"><code>.tokens()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokenIds"><code>.tokenIds()</code></a> ⇒ <code>Array</code></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/data-structures..CharTrieNode">~CharTrieNode</a><ul><li><a href="#new_module_utils/data-structures..CharTrieNode_new"><code>new CharTrieNode(isLeaf, children)</code></a></li> <li><a href="#module_utils/data-structures..CharTrieNode.default"><code>.default()</code></a> ⇒ <code>CharTrieNode</code></li></ul></li> <li><a href="#module_utils/data-structures..TokenLatticeNode">~TokenLatticeNode</a><ul><li><a href="#new_module_utils/data-structures..TokenLatticeNode_new"><code>new TokenLatticeNode(tokenId, nodeId, pos, length, score)</code></a></li> <li><a href="#module_utils/data-structures..TokenLatticeNode+clone"><code>.clone()</code></a> ⇒ <code>TokenLatticeNode</code></li></ul></li></ul></li></ul></li>',jt,Dt,Bt,C,St,b,Ut,P,eu=`Efficient Heap-based Implementation of a Priority Queue.
It uses an array-based binary heap, where the root is at index <code>0</code>, and the
children of node <code>i</code> are located at indices <code>2i + 1</code> and <code>2i + 2</code>, respectively.`,Gt,H,tu="Adapted from the following sources:",Ot,w,iu='<li><a href="https://stackoverflow.com/a/42919752/13989043" rel="nofollow">https://stackoverflow.com/a/42919752/13989043</a> (original)</li> <li><a href="https://github.com/belladoreai/llama-tokenizer-js" rel="nofollow">https://github.com/belladoreai/llama-tokenizer-js</a> (minor improvements)</li>',Vt,M,lu='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Wt,A,ru='<li><a href="#module_utils/data-structures.PriorityQueue">.PriorityQueue</a><ul><li><a href="#new_module_utils/data-structures.PriorityQueue_new"><code>new PriorityQueue(comparator)</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+size"><code>.size</code></a></li> <li><a href="#module_utils/data-structures.PriorityQueue+isEmpty"><code>.isEmpty()</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+peek"><code>.peek()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+push"><code>.push(...values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+extend"><code>.extend(values)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+pop"><code>.pop()</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/data-structures.PriorityQueue+replace"><code>.replace(value)</code></a> ⇒ <code>*</code></li></ul></li>',Ft,Jt,Xt,Q,Yt,N,Zt,E,uu="Create a new PriorityQueue.",ei,q,du="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>comparator</td><td><code>function</code></td><td><p>Comparator function to determine priority. Defaults to a MaxHeap.</p></td></tr></tbody>",ti,ii,li,R,ri,g,ui,I,ou="The size of the queue",di,z,su='<strong>Kind</strong>: instance property of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a>',oi,si,ai,K,ni,j,ci,D,au="Check if the queue is empty.",pi,B,nu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - <code>true</code> if the queue is empty, <code>false</code> otherwise.',hi,fi,mi,S,Ti,U,$i,G,cu="Return the element with the highest priority in the queue.",_i,O,pu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>any</code> - The highest priority element in the queue.',yi,ki,Li,V,vi,W,xi,F,hu="Add one or more elements to the queue.",Ci,J,fu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>number</code> - The new size of the queue.',bi,X,mu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...values</td><td><code>any</code></td><td><p>The values to push into the queue.</p></td></tr></tbody>",Pi,Hi,wi,Y,Mi,Z,Ai,ee,Tu="Add multiple elements to the queue.",Qi,te,$u='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>number</code> - The new size of the queue.',Ni,ie,_u="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>values</td><td><code>Array.&lt;any&gt;</code></td><td><p>The values to push into the queue.</p></td></tr></tbody>",Ei,qi,Ri,le,gi,re,Ii,ue,yu="Remove and return the element with the highest priority in the queue.",zi,de,ku='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>any</code> - The element with the highest priority in the queue.',Ki,ji,Di,oe,Bi,se,Si,ae,Lu="Replace the element with the highest priority in the queue with a new value.",Ui,ne,vu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.PriorityQueue"><code>PriorityQueue</code></a><br/> <strong>Returns</strong>: <code>*</code> - The replaced value.',Gi,ce,xu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>value</td><td><code>*</code></td><td><p>The new value.</p></td></tr></tbody>",Oi,Vi,Wi,pe,Fi,he,Ji,fe,Cu="A trie structure to efficiently store and search for strings.",Xi,me,bu='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Yi,Te,Pu='<li><a href="#module_utils/data-structures.CharTrie">.CharTrie</a><ul><li><a href="#module_utils/data-structures.CharTrie+extend"><code>.extend(texts)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+push"><code>.push(text)</code></a></li> <li><a href="#module_utils/data-structures.CharTrie+commonPrefixSearch"><code>.commonPrefixSearch(text)</code></a></li></ul></li>',Zi,el,tl,$e,il,_e,ll,ye,Hu="Adds one or more <code>texts</code> to the trie.",rl,ke,wu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',ul,Le,Mu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>Array.&lt;string&gt;</code></td><td><p>The strings to add to the trie.</p></td></tr></tbody>",dl,ol,sl,ve,al,xe,nl,Ce,Au="Adds text to the trie.",cl,be,Qu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',pl,Pe,Nu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>text</td><td><code>string</code></td><td><p>The string to add to the trie.</p></td></tr></tbody>",hl,fl,ml,He,Tl,we,$l,Me,Eu="Searches the trie for all strings with a common prefix of <code>text</code>.",_l,Ae,qu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.CharTrie"><code>CharTrie</code></a>',yl,Qe,Ru="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>text</td><td><code>string</code></td><td><p>The common prefix to search for.</p></td></tr></tbody>",kl,Ll,vl,Ne,xl,Ee,Cl,qe,gu="A lattice data structure to be used for tokenization.",bl,Re,Iu='<strong>Kind</strong>: static class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Pl,ge,zu='<li><a href="#module_utils/data-structures.TokenLattice">.TokenLattice</a><ul><li><a href="#new_module_utils/data-structures.TokenLattice_new"><code>new TokenLattice(sentence, bosTokenId, eosTokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+insert"><code>.insert(pos, length, score, tokenId)</code></a></li> <li><a href="#module_utils/data-structures.TokenLattice+viterbi"><code>.viterbi()</code></a> ⇒ <code>Array.&lt;TokenLatticeNode&gt;</code></li> <li><a href="#module_utils/data-structures.TokenLattice+piece"><code>.piece(node)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokens"><code>.tokens()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/data-structures.TokenLattice+tokenIds"><code>.tokenIds()</code></a> ⇒ <code>Array</code></li></ul></li>',Hl,wl,Ml,Ie,Al,ze,Ql,Ke,Ku="Creates a new TokenLattice instance.",Nl,je,ju="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>sentence</td><td><code>string</code></td><td><p>The input sentence to be tokenized.</p></td> </tr><tr><td>bosTokenId</td><td><code>number</code></td><td><p>The beginning-of-sequence token ID.</p></td> </tr><tr><td>eosTokenId</td><td><code>number</code></td><td><p>The end-of-sequence token ID.</p></td></tr></tbody>",El,ql,Rl,De,gl,Be,Il,Se,Du="Inserts a new token node into the token lattice.",zl,Ue,Bu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a>',Kl,Ge,Su="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pos</td><td><code>number</code></td><td><p>The starting position of the token.</p></td> </tr><tr><td>length</td><td><code>number</code></td><td><p>The length of the token.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score of the token.</p></td> </tr><tr><td>tokenId</td><td><code>number</code></td><td><p>The token ID of the token.</p></td></tr></tbody>",jl,Dl,Bl,Oe,Sl,Ve,Ul,We,Uu="Implements the Viterbi algorithm to compute the most likely sequence of tokens.",Gl,Fe,Gu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;TokenLatticeNode&gt;</code> - The array of nodes representing the most likely sequence of tokens.',Ol,Vl,Wl,Je,Fl,Xe,Jl,Ye,Ou='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>string</code> - The array of nodes representing the most likely sequence of tokens.',Xl,Ze,Vu="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>node</td><td><code>TokenLatticeNode</code></td></tr></tbody>",Yl,Zl,er,et,tr,tt,ir,it,Wu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array</code> - The array of nodes representing the most likely sequence of tokens.',lr,rr,ur,lt,dr,rt,or,ut,Fu='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures.TokenLattice"><code>TokenLattice</code></a><br/> <strong>Returns</strong>: <code>Array</code> - The array of nodes representing the most likely sequence of tokens.',sr,ar,nr,dt,cr,ot,pr,st,Ju="Represents a node in a character trie.",hr,at,Xu='<strong>Kind</strong>: inner class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',fr,nt,Yu='<li><a href="#module_utils/data-structures..CharTrieNode">~CharTrieNode</a><ul><li><a href="#new_module_utils/data-structures..CharTrieNode_new"><code>new CharTrieNode(isLeaf, children)</code></a></li> <li><a href="#module_utils/data-structures..CharTrieNode.default"><code>.default()</code></a> ⇒ <code>CharTrieNode</code></li></ul></li>',mr,Tr,$r,ct,_r,pt,yr,ht,Zu="Create a new CharTrieNode.",kr,ft,ed="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>isLeaf</td><td><code>boolean</code></td><td><p>Whether the node is a leaf node or not.</p></td> </tr><tr><td>children</td><td><code>Map.&lt;string, CharTrieNode&gt;</code></td><td><p>A map containing the node&#39;s children, where the key is a character and the value is a <code>CharTrieNode</code>.</p></td></tr></tbody>",Lr,vr,xr,mt,Cr,Tt,br,$t,td="Returns a new <code>CharTrieNode</code> instance with default values.",Pr,_t,id='<strong>Kind</strong>: static method of <a href="#module_utils/data-structures..CharTrieNode"><code>CharTrieNode</code></a><br/> <strong>Returns</strong>: <code>CharTrieNode</code> - A new <code>CharTrieNode</code> instance with <code>isLeaf</code> set to <code>false</code> and an empty <code>children</code> map.',Hr,wr,Mr,yt,Ar,kt,Qr,Lt,ld='<strong>Kind</strong>: inner class of <a href="#module_utils/data-structures"><code>utils/data-structures</code></a>',Nr,vt,rd='<li><a href="#module_utils/data-structures..TokenLatticeNode">~TokenLatticeNode</a><ul><li><a href="#new_module_utils/data-structures..TokenLatticeNode_new"><code>new TokenLatticeNode(tokenId, nodeId, pos, length, score)</code></a></li> <li><a href="#module_utils/data-structures..TokenLatticeNode+clone"><code>.clone()</code></a> ⇒ <code>TokenLatticeNode</code></li></ul></li>',Er,qr,Rr,xt,gr,Ct,Ir,bt,ud="Represents a node in a token lattice for a given sentence.",zr,Pt,dd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tokenId</td><td><code>number</code></td><td><p>The ID of the token associated with this node.</p></td> </tr><tr><td>nodeId</td><td><code>number</code></td><td><p>The ID of this node.</p></td> </tr><tr><td>pos</td><td><code>number</code></td><td><p>The starting position of the token in the sentence.</p></td> </tr><tr><td>length</td><td><code>number</code></td><td><p>The length of the token.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score associated with the token.</p></td></tr></tbody>",Kr,jr,Dr,Ht,Br,wt,Sr,Mt,od="Returns a clone of this node.",Ur,At,sd='<strong>Kind</strong>: instance method of <a href="#module_utils/data-structures..TokenLatticeNode"><code>TokenLatticeNode</code></a><br/> <strong>Returns</strong>: <code>TokenLatticeNode</code> - A clone of this node.',Gr,Or,Vr,Qt,Wr,Et,Fr;return k=new $({props:{title:"utils/data-structures",local:"utilsdata-structures",headingTag:"h1"}}),b=new $({props:{title:"utils/data-structures.PriorityQueue",local:"utilsdata-structurespriorityqueue",headingTag:"h2"}}),N=new $({props:{title:"new PriorityQueue(comparator)",local:"new-priorityqueuecomparator",headingTag:"h3"}}),g=new $({props:{title:"priorityQueue.size",local:"priorityqueuesize",headingTag:"h3"}}),j=new $({props:{title:"priorityQueue.isEmpty() ⇒ <code> boolean </code>",local:"priorityqueueisempty--code-boolean-code",headingTag:"h3"}}),U=new $({props:{title:"priorityQueue.peek() ⇒ <code> any </code>",local:"priorityqueuepeek--code-any-code",headingTag:"h3"}}),W=new $({props:{title:"priorityQueue.push(...values) ⇒ <code> number </code>",local:"priorityqueuepushvalues--code-number-code",headingTag:"h3"}}),Z=new $({props:{title:"priorityQueue.extend(values) ⇒ <code> number </code>",local:"priorityqueueextendvalues--code-number-code",headingTag:"h3"}}),re=new $({props:{title:"priorityQueue.pop() ⇒ <code> any </code>",local:"priorityqueuepop--code-any-code",headingTag:"h3"}}),se=new $({props:{title:"priorityQueue.replace(value) ⇒ <code> * </code>",local:"priorityqueuereplacevalue--code--code",headingTag:"h3"}}),he=new $({props:{title:"utils/data-structures.CharTrie",local:"utilsdata-structureschartrie",headingTag:"h2"}}),_e=new $({props:{title:"charTrie.extend(texts)",local:"chartrieextendtexts",headingTag:"h3"}}),xe=new $({props:{title:"charTrie.push(text)",local:"chartriepushtext",headingTag:"h3"}}),we=new $({props:{title:"charTrie.commonPrefixSearch(text)",local:"chartriecommonprefixsearchtext",headingTag:"h3"}}),Ee=new $({props:{title:"utils/data-structures.TokenLattice",local:"utilsdata-structurestokenlattice",headingTag:"h2"}}),ze=new $({props:{title:"new TokenLattice(sentence, bosTokenId, eosTokenId)",local:"new-tokenlatticesentence-bostokenid-eostokenid",headingTag:"h3"}}),Be=new $({props:{title:"tokenLattice.insert(pos, length, score, tokenId)",local:"tokenlatticeinsertpos-length-score-tokenid",headingTag:"h3"}}),Ve=new $({props:{title:"tokenLattice.viterbi() ⇒ <code> Array. < TokenLatticeNode > </code>",local:"tokenlatticeviterbi--code-array--tokenlatticenode--code",headingTag:"h3"}}),Xe=new $({props:{title:"tokenLattice.piece(node) ⇒ <code> string </code>",local:"tokenlatticepiecenode--code-string-code",headingTag:"h3"}}),tt=new $({props:{title:"tokenLattice.tokens() ⇒ <code> Array </code>",local:"tokenlatticetokens--code-array-code",headingTag:"h3"}}),rt=new $({props:{title:"tokenLattice.tokenIds() ⇒ <code> Array </code>",local:"tokenlatticetokenids--code-array-code",headingTag:"h3"}}),ot=new $({props:{title:"utils/data-structures~CharTrieNode",local:"utilsdata-structureschartrienode",headingTag:"h2"}}),pt=new $({props:{title:"new CharTrieNode(isLeaf, children)",local:"new-chartrienodeisleaf-children",headingTag:"h3"}}),Tt=new $({props:{title:"CharTrieNode.default() ⇒ <code> CharTrieNode </code>",local:"chartrienodedefault--code-chartrienode-code",headingTag:"h3"}}),kt=new $({props:{title:"utils/data-structures~TokenLatticeNode",local:"utilsdata-structurestokenlatticenode",headingTag:"h2"}}),Ct=new $({props:{title:"new TokenLatticeNode(tokenId, nodeId, pos, length, score)",local:"new-tokenlatticenodetokenid-nodeid-pos-length-score",headingTag:"h3"}}),wt=new $({props:{title:"tokenLatticeNode.clone() ⇒ <code> TokenLatticeNode </code>",local:"tokenlatticenodeclone--code-tokenlatticenode-code",headingTag:"h3"}}),Qt=new Td({props:{source:"https://github.com/xenova/transformers.js/blob/v2.17.2/docs/source/api/utils/data-structures.md"}}),{c(){_=d("meta"),qt=r(),Nt=d("p"),Rt=r(),y=d("a"),gt=r(),c(k.$$.fragment),It=r(),L=d("p"),L.textContent=Xr,zt=r(),v=d("p"),v.textContent=Yr,Kt=r(),x=d("ul"),x.innerHTML=Zr,jt=r(),Dt=d("hr"),Bt=r(),C=d("a"),St=r(),c(b.$$.fragment),Ut=r(),P=d("p"),P.innerHTML=eu,Gt=r(),H=d("p"),H.textContent=tu,Ot=r(),w=d("ul"),w.innerHTML=iu,Vt=r(),M=d("p"),M.innerHTML=lu,Wt=r(),A=d("ul"),A.innerHTML=ru,Ft=r(),Jt=d("hr"),Xt=r(),Q=d("a"),Yt=r(),c(N.$$.fragment),Zt=r(),E=d("p"),E.textContent=uu,ei=r(),q=d("table"),q.innerHTML=du,ti=r(),ii=d("hr"),li=r(),R=d("a"),ri=r(),c(g.$$.fragment),ui=r(),I=d("p"),I.textContent=ou,di=r(),z=d("p"),z.innerHTML=su,oi=r(),si=d("hr"),ai=r(),K=d("a"),ni=r(),c(j.$$.fragment),ci=r(),D=d("p"),D.textContent=au,pi=r(),B=d("p"),B.innerHTML=nu,hi=r(),fi=d("hr"),mi=r(),S=d("a"),Ti=r(),c(U.$$.fragment),$i=r(),G=d("p"),G.textContent=cu,_i=r(),O=d("p"),O.innerHTML=pu,yi=r(),ki=d("hr"),Li=r(),V=d("a"),vi=r(),c(W.$$.fragment),xi=r(),F=d("p"),F.textContent=hu,Ci=r(),J=d("p"),J.innerHTML=fu,bi=r(),X=d("table"),X.innerHTML=mu,Pi=r(),Hi=d("hr"),wi=r(),Y=d("a"),Mi=r(),c(Z.$$.fragment),Ai=r(),ee=d("p"),ee.textContent=Tu,Qi=r(),te=d("p"),te.innerHTML=$u,Ni=r(),ie=d("table"),ie.innerHTML=_u,Ei=r(),qi=d("hr"),Ri=r(),le=d("a"),gi=r(),c(re.$$.fragment),Ii=r(),ue=d("p"),ue.textContent=yu,zi=r(),de=d("p"),de.innerHTML=ku,Ki=r(),ji=d("hr"),Di=r(),oe=d("a"),Bi=r(),c(se.$$.fragment),Si=r(),ae=d("p"),ae.textContent=Lu,Ui=r(),ne=d("p"),ne.innerHTML=vu,Gi=r(),ce=d("table"),ce.innerHTML=xu,Oi=r(),Vi=d("hr"),Wi=r(),pe=d("a"),Fi=r(),c(he.$$.fragment),Ji=r(),fe=d("p"),fe.textContent=Cu,Xi=r(),me=d("p"),me.innerHTML=bu,Yi=r(),Te=d("ul"),Te.innerHTML=Pu,Zi=r(),el=d("hr"),tl=r(),$e=d("a"),il=r(),c(_e.$$.fragment),ll=r(),ye=d("p"),ye.innerHTML=Hu,rl=r(),ke=d("p"),ke.innerHTML=wu,ul=r(),Le=d("table"),Le.innerHTML=Mu,dl=r(),ol=d("hr"),sl=r(),ve=d("a"),al=r(),c(xe.$$.fragment),nl=r(),Ce=d("p"),Ce.textContent=Au,cl=r(),be=d("p"),be.innerHTML=Qu,pl=r(),Pe=d("table"),Pe.innerHTML=Nu,hl=r(),fl=d("hr"),ml=r(),He=d("a"),Tl=r(),c(we.$$.fragment),$l=r(),Me=d("p"),Me.innerHTML=Eu,_l=r(),Ae=d("p"),Ae.innerHTML=qu,yl=r(),Qe=d("table"),Qe.innerHTML=Ru,kl=r(),Ll=d("hr"),vl=r(),Ne=d("a"),xl=r(),c(Ee.$$.fragment),Cl=r(),qe=d("p"),qe.textContent=gu,bl=r(),Re=d("p"),Re.innerHTML=Iu,Pl=r(),ge=d("ul"),ge.innerHTML=zu,Hl=r(),wl=d("hr"),Ml=r(),Ie=d("a"),Al=r(),c(ze.$$.fragment),Ql=r(),Ke=d("p"),Ke.textContent=Ku,Nl=r(),je=d("table"),je.innerHTML=ju,El=r(),ql=d("hr"),Rl=r(),De=d("a"),gl=r(),c(Be.$$.fragment),Il=r(),Se=d("p"),Se.textContent=Du,zl=r(),Ue=d("p"),Ue.innerHTML=Bu,Kl=r(),Ge=d("table"),Ge.innerHTML=Su,jl=r(),Dl=d("hr"),Bl=r(),Oe=d("a"),Sl=r(),c(Ve.$$.fragment),Ul=r(),We=d("p"),We.textContent=Uu,Gl=r(),Fe=d("p"),Fe.innerHTML=Gu,Ol=r(),Vl=d("hr"),Wl=r(),Je=d("a"),Fl=r(),c(Xe.$$.fragment),Jl=r(),Ye=d("p"),Ye.innerHTML=Ou,Xl=r(),Ze=d("table"),Ze.innerHTML=Vu,Yl=r(),Zl=d("hr"),er=r(),et=d("a"),tr=r(),c(tt.$$.fragment),ir=r(),it=d("p"),it.innerHTML=Wu,lr=r(),rr=d("hr"),ur=r(),lt=d("a"),dr=r(),c(rt.$$.fragment),or=r(),ut=d("p"),ut.innerHTML=Fu,sr=r(),ar=d("hr"),nr=r(),dt=d("a"),cr=r(),c(ot.$$.fragment),pr=r(),st=d("p"),st.textContent=Ju,hr=r(),at=d("p"),at.innerHTML=Xu,fr=r(),nt=d("ul"),nt.innerHTML=Yu,mr=r(),Tr=d("hr"),$r=r(),ct=d("a"),_r=r(),c(pt.$$.fragment),yr=r(),ht=d("p"),ht.textContent=Zu,kr=r(),ft=d("table"),ft.innerHTML=ed,Lr=r(),vr=d("hr"),xr=r(),mt=d("a"),Cr=r(),c(Tt.$$.fragment),br=r(),$t=d("p"),$t.innerHTML=td,Pr=r(),_t=d("p"),_t.innerHTML=id,Hr=r(),wr=d("hr"),Mr=r(),yt=d("a"),Ar=r(),c(kt.$$.fragment),Qr=r(),Lt=d("p"),Lt.innerHTML=ld,Nr=r(),vt=d("ul"),vt.innerHTML=rd,Er=r(),qr=d("hr"),Rr=r(),xt=d("a"),gr=r(),c(Ct.$$.fragment),Ir=r(),bt=d("p"),bt.textContent=ud,zr=r(),Pt=d("table"),Pt.innerHTML=dd,Kr=r(),jr=d("hr"),Dr=r(),Ht=d("a"),Br=r(),c(wt.$$.fragment),Sr=r(),Mt=d("p"),Mt.textContent=od,Ur=r(),At=d("p"),At.innerHTML=sd,Gr=r(),Or=d("hr"),Vr=r(),c(Qt.$$.fragment),Wr=r(),Et=d("p"),this.h()},l(e){const t=fd("svelte-u9bgzb",document.head);_=o(t,"META",{name:!0,content:!0}),t.forEach(i),qt=u(e),Nt=o(e,"P",{}),n(Nt).forEach(i),Rt=u(e),y=o(e,"A",{id:!0,class:!0}),n(y).forEach(i),gt=u(e),p(k.$$.fragment,e),It=u(e),L=o(e,"P",{"data-svelte-h":!0}),s(L)!=="svelte-1aeeeid"&&(L.textContent=Xr),zt=u(e),v=o(e,"P",{"data-svelte-h":!0}),s(v)!=="svelte-1r3ntfo"&&(v.textContent=Yr),Kt=u(e),x=o(e,"UL",{"data-svelte-h":!0}),s(x)!=="svelte-j4gs7t"&&(x.innerHTML=Zr),jt=u(e),Dt=o(e,"HR",{}),Bt=u(e),C=o(e,"A",{id:!0,class:!0}),n(C).forEach(i),St=u(e),p(b.$$.fragment,e),Ut=u(e),P=o(e,"P",{"data-svelte-h":!0}),s(P)!=="svelte-1ux83uj"&&(P.innerHTML=eu),Gt=u(e),H=o(e,"P",{"data-svelte-h":!0}),s(H)!=="svelte-vi2pz9"&&(H.textContent=tu),Ot=u(e),w=o(e,"UL",{"data-svelte-h":!0}),s(w)!=="svelte-qlvgg9"&&(w.innerHTML=iu),Vt=u(e),M=o(e,"P",{"data-svelte-h":!0}),s(M)!=="svelte-1saulos"&&(M.innerHTML=lu),Wt=u(e),A=o(e,"UL",{"data-svelte-h":!0}),s(A)!=="svelte-1306bmq"&&(A.innerHTML=ru),Ft=u(e),Jt=o(e,"HR",{}),Xt=u(e),Q=o(e,"A",{id:!0,class:!0}),n(Q).forEach(i),Yt=u(e),p(N.$$.fragment,e),Zt=u(e),E=o(e,"P",{"data-svelte-h":!0}),s(E)!=="svelte-1dgukb8"&&(E.textContent=uu),ei=u(e),q=o(e,"TABLE",{"data-svelte-h":!0}),s(q)!=="svelte-15lsmj7"&&(q.innerHTML=du),ti=u(e),ii=o(e,"HR",{}),li=u(e),R=o(e,"A",{id:!0,class:!0}),n(R).forEach(i),ri=u(e),p(g.$$.fragment,e),ui=u(e),I=o(e,"P",{"data-svelte-h":!0}),s(I)!=="svelte-19ll7y9"&&(I.textContent=ou),di=u(e),z=o(e,"P",{"data-svelte-h":!0}),s(z)!=="svelte-1spompf"&&(z.innerHTML=su),oi=u(e),si=o(e,"HR",{}),ai=u(e),K=o(e,"A",{id:!0,class:!0}),n(K).forEach(i),ni=u(e),p(j.$$.fragment,e),ci=u(e),D=o(e,"P",{"data-svelte-h":!0}),s(D)!=="svelte-iwo0ja"&&(D.textContent=au),pi=u(e),B=o(e,"P",{"data-svelte-h":!0}),s(B)!=="svelte-usw3zo"&&(B.innerHTML=nu),hi=u(e),fi=o(e,"HR",{}),mi=u(e),S=o(e,"A",{id:!0,class:!0}),n(S).forEach(i),Ti=u(e),p(U.$$.fragment,e),$i=u(e),G=o(e,"P",{"data-svelte-h":!0}),s(G)!=="svelte-1g38rzl"&&(G.textContent=cu),_i=u(e),O=o(e,"P",{"data-svelte-h":!0}),s(O)!=="svelte-1jn2os3"&&(O.innerHTML=pu),yi=u(e),ki=o(e,"HR",{}),Li=u(e),V=o(e,"A",{id:!0,class:!0}),n(V).forEach(i),vi=u(e),p(W.$$.fragment,e),xi=u(e),F=o(e,"P",{"data-svelte-h":!0}),s(F)!=="svelte-1o3p42d"&&(F.textContent=hu),Ci=u(e),J=o(e,"P",{"data-svelte-h":!0}),s(J)!=="svelte-1hty3q7"&&(J.innerHTML=fu),bi=u(e),X=o(e,"TABLE",{"data-svelte-h":!0}),s(X)!=="svelte-19plha1"&&(X.innerHTML=mu),Pi=u(e),Hi=o(e,"HR",{}),wi=u(e),Y=o(e,"A",{id:!0,class:!0}),n(Y).forEach(i),Mi=u(e),p(Z.$$.fragment,e),Ai=u(e),ee=o(e,"P",{"data-svelte-h":!0}),s(ee)!=="svelte-1rf8gmz"&&(ee.textContent=Tu),Qi=u(e),te=o(e,"P",{"data-svelte-h":!0}),s(te)!=="svelte-1hty3q7"&&(te.innerHTML=$u),Ni=u(e),ie=o(e,"TABLE",{"data-svelte-h":!0}),s(ie)!=="svelte-txh99d"&&(ie.innerHTML=_u),Ei=u(e),qi=o(e,"HR",{}),Ri=u(e),le=o(e,"A",{id:!0,class:!0}),n(le).forEach(i),gi=u(e),p(re.$$.fragment,e),Ii=u(e),ue=o(e,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-1l3oksc"&&(ue.textContent=yu),zi=u(e),de=o(e,"P",{"data-svelte-h":!0}),s(de)!=="svelte-vpswb8"&&(de.innerHTML=ku),Ki=u(e),ji=o(e,"HR",{}),Di=u(e),oe=o(e,"A",{id:!0,class:!0}),n(oe).forEach(i),Bi=u(e),p(se.$$.fragment,e),Si=u(e),ae=o(e,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-7s4t0d"&&(ae.textContent=Lu),Ui=u(e),ne=o(e,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-ckytvb"&&(ne.innerHTML=vu),Gi=u(e),ce=o(e,"TABLE",{"data-svelte-h":!0}),s(ce)!=="svelte-1xv2m9q"&&(ce.innerHTML=xu),Oi=u(e),Vi=o(e,"HR",{}),Wi=u(e),pe=o(e,"A",{id:!0,class:!0}),n(pe).forEach(i),Fi=u(e),p(he.$$.fragment,e),Ji=u(e),fe=o(e,"P",{"data-svelte-h":!0}),s(fe)!=="svelte-nklgrc"&&(fe.textContent=Cu),Xi=u(e),me=o(e,"P",{"data-svelte-h":!0}),s(me)!=="svelte-1saulos"&&(me.innerHTML=bu),Yi=u(e),Te=o(e,"UL",{"data-svelte-h":!0}),s(Te)!=="svelte-1yt2jf0"&&(Te.innerHTML=Pu),Zi=u(e),el=o(e,"HR",{}),tl=u(e),$e=o(e,"A",{id:!0,class:!0}),n($e).forEach(i),il=u(e),p(_e.$$.fragment,e),ll=u(e),ye=o(e,"P",{"data-svelte-h":!0}),s(ye)!=="svelte-moeq8l"&&(ye.innerHTML=Hu),rl=u(e),ke=o(e,"P",{"data-svelte-h":!0}),s(ke)!=="svelte-33rax3"&&(ke.innerHTML=wu),ul=u(e),Le=o(e,"TABLE",{"data-svelte-h":!0}),s(Le)!=="svelte-18dtsnv"&&(Le.innerHTML=Mu),dl=u(e),ol=o(e,"HR",{}),sl=u(e),ve=o(e,"A",{id:!0,class:!0}),n(ve).forEach(i),al=u(e),p(xe.$$.fragment,e),nl=u(e),Ce=o(e,"P",{"data-svelte-h":!0}),s(Ce)!=="svelte-4q846v"&&(Ce.textContent=Au),cl=u(e),be=o(e,"P",{"data-svelte-h":!0}),s(be)!=="svelte-33rax3"&&(be.innerHTML=Qu),pl=u(e),Pe=o(e,"TABLE",{"data-svelte-h":!0}),s(Pe)!=="svelte-hqwgb9"&&(Pe.innerHTML=Nu),hl=u(e),fl=o(e,"HR",{}),ml=u(e),He=o(e,"A",{id:!0,class:!0}),n(He).forEach(i),Tl=u(e),p(we.$$.fragment,e),$l=u(e),Me=o(e,"P",{"data-svelte-h":!0}),s(Me)!=="svelte-bmaw98"&&(Me.innerHTML=Eu),_l=u(e),Ae=o(e,"P",{"data-svelte-h":!0}),s(Ae)!=="svelte-33rax3"&&(Ae.innerHTML=qu),yl=u(e),Qe=o(e,"TABLE",{"data-svelte-h":!0}),s(Qe)!=="svelte-18qxh0x"&&(Qe.innerHTML=Ru),kl=u(e),Ll=o(e,"HR",{}),vl=u(e),Ne=o(e,"A",{id:!0,class:!0}),n(Ne).forEach(i),xl=u(e),p(Ee.$$.fragment,e),Cl=u(e),qe=o(e,"P",{"data-svelte-h":!0}),s(qe)!=="svelte-1xkinx1"&&(qe.textContent=gu),bl=u(e),Re=o(e,"P",{"data-svelte-h":!0}),s(Re)!=="svelte-1saulos"&&(Re.innerHTML=Iu),Pl=u(e),ge=o(e,"UL",{"data-svelte-h":!0}),s(ge)!=="svelte-svgbr"&&(ge.innerHTML=zu),Hl=u(e),wl=o(e,"HR",{}),Ml=u(e),Ie=o(e,"A",{id:!0,class:!0}),n(Ie).forEach(i),Al=u(e),p(ze.$$.fragment,e),Ql=u(e),Ke=o(e,"P",{"data-svelte-h":!0}),s(Ke)!=="svelte-ziiz62"&&(Ke.textContent=Ku),Nl=u(e),je=o(e,"TABLE",{"data-svelte-h":!0}),s(je)!=="svelte-1h8dv5n"&&(je.innerHTML=ju),El=u(e),ql=o(e,"HR",{}),Rl=u(e),De=o(e,"A",{id:!0,class:!0}),n(De).forEach(i),gl=u(e),p(Be.$$.fragment,e),Il=u(e),Se=o(e,"P",{"data-svelte-h":!0}),s(Se)!=="svelte-1hzq3te"&&(Se.textContent=Du),zl=u(e),Ue=o(e,"P",{"data-svelte-h":!0}),s(Ue)!=="svelte-1bjyh7n"&&(Ue.innerHTML=Bu),Kl=u(e),Ge=o(e,"TABLE",{"data-svelte-h":!0}),s(Ge)!=="svelte-1a01i2a"&&(Ge.innerHTML=Su),jl=u(e),Dl=o(e,"HR",{}),Bl=u(e),Oe=o(e,"A",{id:!0,class:!0}),n(Oe).forEach(i),Sl=u(e),p(Ve.$$.fragment,e),Ul=u(e),We=o(e,"P",{"data-svelte-h":!0}),s(We)!=="svelte-jv0r"&&(We.textContent=Uu),Gl=u(e),Fe=o(e,"P",{"data-svelte-h":!0}),s(Fe)!=="svelte-1gfck0d"&&(Fe.innerHTML=Gu),Ol=u(e),Vl=o(e,"HR",{}),Wl=u(e),Je=o(e,"A",{id:!0,class:!0}),n(Je).forEach(i),Fl=u(e),p(Xe.$$.fragment,e),Jl=u(e),Ye=o(e,"P",{"data-svelte-h":!0}),s(Ye)!=="svelte-1n9zjoi"&&(Ye.innerHTML=Ou),Xl=u(e),Ze=o(e,"TABLE",{"data-svelte-h":!0}),s(Ze)!=="svelte-6nufyb"&&(Ze.innerHTML=Vu),Yl=u(e),Zl=o(e,"HR",{}),er=u(e),et=o(e,"A",{id:!0,class:!0}),n(et).forEach(i),tr=u(e),p(tt.$$.fragment,e),ir=u(e),it=o(e,"P",{"data-svelte-h":!0}),s(it)!=="svelte-1oso32i"&&(it.innerHTML=Wu),lr=u(e),rr=o(e,"HR",{}),ur=u(e),lt=o(e,"A",{id:!0,class:!0}),n(lt).forEach(i),dr=u(e),p(rt.$$.fragment,e),or=u(e),ut=o(e,"P",{"data-svelte-h":!0}),s(ut)!=="svelte-1oso32i"&&(ut.innerHTML=Fu),sr=u(e),ar=o(e,"HR",{}),nr=u(e),dt=o(e,"A",{id:!0,class:!0}),n(dt).forEach(i),cr=u(e),p(ot.$$.fragment,e),pr=u(e),st=o(e,"P",{"data-svelte-h":!0}),s(st)!=="svelte-1auz3rh"&&(st.textContent=Ju),hr=u(e),at=o(e,"P",{"data-svelte-h":!0}),s(at)!=="svelte-1p9ver0"&&(at.innerHTML=Xu),fr=u(e),nt=o(e,"UL",{"data-svelte-h":!0}),s(nt)!=="svelte-4v7sww"&&(nt.innerHTML=Yu),mr=u(e),Tr=o(e,"HR",{}),$r=u(e),ct=o(e,"A",{id:!0,class:!0}),n(ct).forEach(i),_r=u(e),p(pt.$$.fragment,e),yr=u(e),ht=o(e,"P",{"data-svelte-h":!0}),s(ht)!=="svelte-mt1jex"&&(ht.textContent=Zu),kr=u(e),ft=o(e,"TABLE",{"data-svelte-h":!0}),s(ft)!=="svelte-nk427c"&&(ft.innerHTML=ed),Lr=u(e),vr=o(e,"HR",{}),xr=u(e),mt=o(e,"A",{id:!0,class:!0}),n(mt).forEach(i),Cr=u(e),p(Tt.$$.fragment,e),br=u(e),$t=o(e,"P",{"data-svelte-h":!0}),s($t)!=="svelte-9cjdkj"&&($t.innerHTML=td),Pr=u(e),_t=o(e,"P",{"data-svelte-h":!0}),s(_t)!=="svelte-3pigfy"&&(_t.innerHTML=id),Hr=u(e),wr=o(e,"HR",{}),Mr=u(e),yt=o(e,"A",{id:!0,class:!0}),n(yt).forEach(i),Ar=u(e),p(kt.$$.fragment,e),Qr=u(e),Lt=o(e,"P",{"data-svelte-h":!0}),s(Lt)!=="svelte-1p9ver0"&&(Lt.innerHTML=ld),Nr=u(e),vt=o(e,"UL",{"data-svelte-h":!0}),s(vt)!=="svelte-r6qh2h"&&(vt.innerHTML=rd),Er=u(e),qr=o(e,"HR",{}),Rr=u(e),xt=o(e,"A",{id:!0,class:!0}),n(xt).forEach(i),gr=u(e),p(Ct.$$.fragment,e),Ir=u(e),bt=o(e,"P",{"data-svelte-h":!0}),s(bt)!=="svelte-vrhdhn"&&(bt.textContent=ud),zr=u(e),Pt=o(e,"TABLE",{"data-svelte-h":!0}),s(Pt)!=="svelte-5ahzuq"&&(Pt.innerHTML=dd),Kr=u(e),jr=o(e,"HR",{}),Dr=u(e),Ht=o(e,"A",{id:!0,class:!0}),n(Ht).forEach(i),Br=u(e),p(wt.$$.fragment,e),Sr=u(e),Mt=o(e,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-34g670"&&(Mt.textContent=od),Ur=u(e),At=o(e,"P",{"data-svelte-h":!0}),s(At)!=="svelte-7303j9"&&(At.innerHTML=sd),Gr=u(e),Or=o(e,"HR",{}),Vr=u(e),p(Qt.$$.fragment,e),Wr=u(e),Et=o(e,"P",{}),n(Et).forEach(i),this.h()},h(){a(_,"name","hf:doc:metadata"),a(_,"content",_d),a(y,"id","module_utils/data-structures"),a(y,"class","group"),a(C,"id","module_utils/data-structures.PriorityQueue"),a(C,"class","group"),a(Q,"id","new_module_utils/data-structures.PriorityQueue_new"),a(Q,"class","group"),a(R,"id","module_utils/data-structures.PriorityQueue+size"),a(R,"class","group"),a(K,"id","module_utils/data-structures.PriorityQueue+isEmpty"),a(K,"class","group"),a(S,"id","module_utils/data-structures.PriorityQueue+peek"),a(S,"class","group"),a(V,"id","module_utils/data-structures.PriorityQueue+push"),a(V,"class","group"),a(Y,"id","module_utils/data-structures.PriorityQueue+extend"),a(Y,"class","group"),a(le,"id","module_utils/data-structures.PriorityQueue+pop"),a(le,"class","group"),a(oe,"id","module_utils/data-structures.PriorityQueue+replace"),a(oe,"class","group"),a(pe,"id","module_utils/data-structures.CharTrie"),a(pe,"class","group"),a($e,"id","module_utils/data-structures.CharTrie+extend"),a($e,"class","group"),a(ve,"id","module_utils/data-structures.CharTrie+push"),a(ve,"class","group"),a(He,"id","module_utils/data-structures.CharTrie+commonPrefixSearch"),a(He,"class","group"),a(Ne,"id","module_utils/data-structures.TokenLattice"),a(Ne,"class","group"),a(Ie,"id","new_module_utils/data-structures.TokenLattice_new"),a(Ie,"class","group"),a(De,"id","module_utils/data-structures.TokenLattice+insert"),a(De,"class","group"),a(Oe,"id","module_utils/data-structures.TokenLattice+viterbi"),a(Oe,"class","group"),a(Je,"id","module_utils/data-structures.TokenLattice+piece"),a(Je,"class","group"),a(et,"id","module_utils/data-structures.TokenLattice+tokens"),a(et,"class","group"),a(lt,"id","module_utils/data-structures.TokenLattice+tokenIds"),a(lt,"class","group"),a(dt,"id","module_utils/data-structures..CharTrieNode"),a(dt,"class","group"),a(ct,"id","new_module_utils/data-structures..CharTrieNode_new"),a(ct,"class","group"),a(mt,"id","module_utils/data-structures..CharTrieNode.default"),a(mt,"class","group"),a(yt,"id","module_utils/data-structures..TokenLatticeNode"),a(yt,"class","group"),a(xt,"id","new_module_utils/data-structures..TokenLatticeNode_new"),a(xt,"class","group"),a(Ht,"id","module_utils/data-structures..TokenLatticeNode+clone"),a(Ht,"class","group")},m(e,t){md(document.head,_),l(e,qt,t),l(e,Nt,t),l(e,Rt,t),l(e,y,t),l(e,gt,t),h(k,e,t),l(e,It,t),l(e,L,t),l(e,zt,t),l(e,v,t),l(e,Kt,t),l(e,x,t),l(e,jt,t),l(e,Dt,t),l(e,Bt,t),l(e,C,t),l(e,St,t),h(b,e,t),l(e,Ut,t),l(e,P,t),l(e,Gt,t),l(e,H,t),l(e,Ot,t),l(e,w,t),l(e,Vt,t),l(e,M,t),l(e,Wt,t),l(e,A,t),l(e,Ft,t),l(e,Jt,t),l(e,Xt,t),l(e,Q,t),l(e,Yt,t),h(N,e,t),l(e,Zt,t),l(e,E,t),l(e,ei,t),l(e,q,t),l(e,ti,t),l(e,ii,t),l(e,li,t),l(e,R,t),l(e,ri,t),h(g,e,t),l(e,ui,t),l(e,I,t),l(e,di,t),l(e,z,t),l(e,oi,t),l(e,si,t),l(e,ai,t),l(e,K,t),l(e,ni,t),h(j,e,t),l(e,ci,t),l(e,D,t),l(e,pi,t),l(e,B,t),l(e,hi,t),l(e,fi,t),l(e,mi,t),l(e,S,t),l(e,Ti,t),h(U,e,t),l(e,$i,t),l(e,G,t),l(e,_i,t),l(e,O,t),l(e,yi,t),l(e,ki,t),l(e,Li,t),l(e,V,t),l(e,vi,t),h(W,e,t),l(e,xi,t),l(e,F,t),l(e,Ci,t),l(e,J,t),l(e,bi,t),l(e,X,t),l(e,Pi,t),l(e,Hi,t),l(e,wi,t),l(e,Y,t),l(e,Mi,t),h(Z,e,t),l(e,Ai,t),l(e,ee,t),l(e,Qi,t),l(e,te,t),l(e,Ni,t),l(e,ie,t),l(e,Ei,t),l(e,qi,t),l(e,Ri,t),l(e,le,t),l(e,gi,t),h(re,e,t),l(e,Ii,t),l(e,ue,t),l(e,zi,t),l(e,de,t),l(e,Ki,t),l(e,ji,t),l(e,Di,t),l(e,oe,t),l(e,Bi,t),h(se,e,t),l(e,Si,t),l(e,ae,t),l(e,Ui,t),l(e,ne,t),l(e,Gi,t),l(e,ce,t),l(e,Oi,t),l(e,Vi,t),l(e,Wi,t),l(e,pe,t),l(e,Fi,t),h(he,e,t),l(e,Ji,t),l(e,fe,t),l(e,Xi,t),l(e,me,t),l(e,Yi,t),l(e,Te,t),l(e,Zi,t),l(e,el,t),l(e,tl,t),l(e,$e,t),l(e,il,t),h(_e,e,t),l(e,ll,t),l(e,ye,t),l(e,rl,t),l(e,ke,t),l(e,ul,t),l(e,Le,t),l(e,dl,t),l(e,ol,t),l(e,sl,t),l(e,ve,t),l(e,al,t),h(xe,e,t),l(e,nl,t),l(e,Ce,t),l(e,cl,t),l(e,be,t),l(e,pl,t),l(e,Pe,t),l(e,hl,t),l(e,fl,t),l(e,ml,t),l(e,He,t),l(e,Tl,t),h(we,e,t),l(e,$l,t),l(e,Me,t),l(e,_l,t),l(e,Ae,t),l(e,yl,t),l(e,Qe,t),l(e,kl,t),l(e,Ll,t),l(e,vl,t),l(e,Ne,t),l(e,xl,t),h(Ee,e,t),l(e,Cl,t),l(e,qe,t),l(e,bl,t),l(e,Re,t),l(e,Pl,t),l(e,ge,t),l(e,Hl,t),l(e,wl,t),l(e,Ml,t),l(e,Ie,t),l(e,Al,t),h(ze,e,t),l(e,Ql,t),l(e,Ke,t),l(e,Nl,t),l(e,je,t),l(e,El,t),l(e,ql,t),l(e,Rl,t),l(e,De,t),l(e,gl,t),h(Be,e,t),l(e,Il,t),l(e,Se,t),l(e,zl,t),l(e,Ue,t),l(e,Kl,t),l(e,Ge,t),l(e,jl,t),l(e,Dl,t),l(e,Bl,t),l(e,Oe,t),l(e,Sl,t),h(Ve,e,t),l(e,Ul,t),l(e,We,t),l(e,Gl,t),l(e,Fe,t),l(e,Ol,t),l(e,Vl,t),l(e,Wl,t),l(e,Je,t),l(e,Fl,t),h(Xe,e,t),l(e,Jl,t),l(e,Ye,t),l(e,Xl,t),l(e,Ze,t),l(e,Yl,t),l(e,Zl,t),l(e,er,t),l(e,et,t),l(e,tr,t),h(tt,e,t),l(e,ir,t),l(e,it,t),l(e,lr,t),l(e,rr,t),l(e,ur,t),l(e,lt,t),l(e,dr,t),h(rt,e,t),l(e,or,t),l(e,ut,t),l(e,sr,t),l(e,ar,t),l(e,nr,t),l(e,dt,t),l(e,cr,t),h(ot,e,t),l(e,pr,t),l(e,st,t),l(e,hr,t),l(e,at,t),l(e,fr,t),l(e,nt,t),l(e,mr,t),l(e,Tr,t),l(e,$r,t),l(e,ct,t),l(e,_r,t),h(pt,e,t),l(e,yr,t),l(e,ht,t),l(e,kr,t),l(e,ft,t),l(e,Lr,t),l(e,vr,t),l(e,xr,t),l(e,mt,t),l(e,Cr,t),h(Tt,e,t),l(e,br,t),l(e,$t,t),l(e,Pr,t),l(e,_t,t),l(e,Hr,t),l(e,wr,t),l(e,Mr,t),l(e,yt,t),l(e,Ar,t),h(kt,e,t),l(e,Qr,t),l(e,Lt,t),l(e,Nr,t),l(e,vt,t),l(e,Er,t),l(e,qr,t),l(e,Rr,t),l(e,xt,t),l(e,gr,t),h(Ct,e,t),l(e,Ir,t),l(e,bt,t),l(e,zr,t),l(e,Pt,t),l(e,Kr,t),l(e,jr,t),l(e,Dr,t),l(e,Ht,t),l(e,Br,t),h(wt,e,t),l(e,Sr,t),l(e,Mt,t),l(e,Ur,t),l(e,At,t),l(e,Gr,t),l(e,Or,t),l(e,Vr,t),h(Qt,e,t),l(e,Wr,t),l(e,Et,t),Fr=!0},p:nd,i(e){Fr||(f(k.$$.fragment,e),f(b.$$.fragment,e),f(N.$$.fragment,e),f(g.$$.fragment,e),f(j.$$.fragment,e),f(U.$$.fragment,e),f(W.$$.fragment,e),f(Z.$$.fragment,e),f(re.$$.fragment,e),f(se.$$.fragment,e),f(he.$$.fragment,e),f(_e.$$.fragment,e),f(xe.$$.fragment,e),f(we.$$.fragment,e),f(Ee.$$.fragment,e),f(ze.$$.fragment,e),f(Be.$$.fragment,e),f(Ve.$$.fragment,e),f(Xe.$$.fragment,e),f(tt.$$.fragment,e),f(rt.$$.fragment,e),f(ot.$$.fragment,e),f(pt.$$.fragment,e),f(Tt.$$.fragment,e),f(kt.$$.fragment,e),f(Ct.$$.fragment,e),f(wt.$$.fragment,e),f(Qt.$$.fragment,e),Fr=!0)},o(e){m(k.$$.fragment,e),m(b.$$.fragment,e),m(N.$$.fragment,e),m(g.$$.fragment,e),m(j.$$.fragment,e),m(U.$$.fragment,e),m(W.$$.fragment,e),m(Z.$$.fragment,e),m(re.$$.fragment,e),m(se.$$.fragment,e),m(he.$$.fragment,e),m(_e.$$.fragment,e),m(xe.$$.fragment,e),m(we.$$.fragment,e),m(Ee.$$.fragment,e),m(ze.$$.fragment,e),m(Be.$$.fragment,e),m(Ve.$$.fragment,e),m(Xe.$$.fragment,e),m(tt.$$.fragment,e),m(rt.$$.fragment,e),m(ot.$$.fragment,e),m(pt.$$.fragment,e),m(Tt.$$.fragment,e),m(kt.$$.fragment,e),m(Ct.$$.fragment,e),m(wt.$$.fragment,e),m(Qt.$$.fragment,e),Fr=!1},d(e){e&&(i(qt),i(Nt),i(Rt),i(y),i(gt),i(It),i(L),i(zt),i(v),i(Kt),i(x),i(jt),i(Dt),i(Bt),i(C),i(St),i(Ut),i(P),i(Gt),i(H),i(Ot),i(w),i(Vt),i(M),i(Wt),i(A),i(Ft),i(Jt),i(Xt),i(Q),i(Yt),i(Zt),i(E),i(ei),i(q),i(ti),i(ii),i(li),i(R),i(ri),i(ui),i(I),i(di),i(z),i(oi),i(si),i(ai),i(K),i(ni),i(ci),i(D),i(pi),i(B),i(hi),i(fi),i(mi),i(S),i(Ti),i($i),i(G),i(_i),i(O),i(yi),i(ki),i(Li),i(V),i(vi),i(xi),i(F),i(Ci),i(J),i(bi),i(X),i(Pi),i(Hi),i(wi),i(Y),i(Mi),i(Ai),i(ee),i(Qi),i(te),i(Ni),i(ie),i(Ei),i(qi),i(Ri),i(le),i(gi),i(Ii),i(ue),i(zi),i(de),i(Ki),i(ji),i(Di),i(oe),i(Bi),i(Si),i(ae),i(Ui),i(ne),i(Gi),i(ce),i(Oi),i(Vi),i(Wi),i(pe),i(Fi),i(Ji),i(fe),i(Xi),i(me),i(Yi),i(Te),i(Zi),i(el),i(tl),i($e),i(il),i(ll),i(ye),i(rl),i(ke),i(ul),i(Le),i(dl),i(ol),i(sl),i(ve),i(al),i(nl),i(Ce),i(cl),i(be),i(pl),i(Pe),i(hl),i(fl),i(ml),i(He),i(Tl),i($l),i(Me),i(_l),i(Ae),i(yl),i(Qe),i(kl),i(Ll),i(vl),i(Ne),i(xl),i(Cl),i(qe),i(bl),i(Re),i(Pl),i(ge),i(Hl),i(wl),i(Ml),i(Ie),i(Al),i(Ql),i(Ke),i(Nl),i(je),i(El),i(ql),i(Rl),i(De),i(gl),i(Il),i(Se),i(zl),i(Ue),i(Kl),i(Ge),i(jl),i(Dl),i(Bl),i(Oe),i(Sl),i(Ul),i(We),i(Gl),i(Fe),i(Ol),i(Vl),i(Wl),i(Je),i(Fl),i(Jl),i(Ye),i(Xl),i(Ze),i(Yl),i(Zl),i(er),i(et),i(tr),i(ir),i(it),i(lr),i(rr),i(ur),i(lt),i(dr),i(or),i(ut),i(sr),i(ar),i(nr),i(dt),i(cr),i(pr),i(st),i(hr),i(at),i(fr),i(nt),i(mr),i(Tr),i($r),i(ct),i(_r),i(yr),i(ht),i(kr),i(ft),i(Lr),i(vr),i(xr),i(mt),i(Cr),i(br),i($t),i(Pr),i(_t),i(Hr),i(wr),i(Mr),i(yt),i(Ar),i(Qr),i(Lt),i(Nr),i(vt),i(Er),i(qr),i(Rr),i(xt),i(gr),i(Ir),i(bt),i(zr),i(Pt),i(Kr),i(jr),i(Dr),i(Ht),i(Br),i(Sr),i(Mt),i(Ur),i(At),i(Gr),i(Or),i(Vr),i(Wr),i(Et)),i(_),T(k,e),T(b,e),T(N,e),T(g,e),T(j,e),T(U,e),T(W,e),T(Z,e),T(re,e),T(se,e),T(he,e),T(_e,e),T(xe,e),T(we,e),T(Ee,e),T(ze,e),T(Be,e),T(Ve,e),T(Xe,e),T(tt,e),T(rt,e),T(ot,e),T(pt,e),T(Tt,e),T(kt,e),T(Ct,e),T(wt,e),T(Qt,e)}}}const _d='{"title":"utils/data-structures","local":"utilsdata-structures","sections":[{"title":"utils/data-structures.PriorityQueue","local":"utilsdata-structurespriorityqueue","sections":[{"title":"new PriorityQueue(comparator)","local":"new-priorityqueuecomparator","sections":[],"depth":3},{"title":"priorityQueue.size","local":"priorityqueuesize","sections":[],"depth":3},{"title":"priorityQueue.isEmpty() ⇒ <code> boolean </code>","local":"priorityqueueisempty--code-boolean-code","sections":[],"depth":3},{"title":"priorityQueue.peek() ⇒ <code> any </code>","local":"priorityqueuepeek--code-any-code","sections":[],"depth":3},{"title":"priorityQueue.push(...values) ⇒ <code> number </code>","local":"priorityqueuepushvalues--code-number-code","sections":[],"depth":3},{"title":"priorityQueue.extend(values) ⇒ <code> number </code>","local":"priorityqueueextendvalues--code-number-code","sections":[],"depth":3},{"title":"priorityQueue.pop() ⇒ <code> any </code>","local":"priorityqueuepop--code-any-code","sections":[],"depth":3},{"title":"priorityQueue.replace(value) ⇒ <code> * </code>","local":"priorityqueuereplacevalue--code--code","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures.CharTrie","local":"utilsdata-structureschartrie","sections":[{"title":"charTrie.extend(texts)","local":"chartrieextendtexts","sections":[],"depth":3},{"title":"charTrie.push(text)","local":"chartriepushtext","sections":[],"depth":3},{"title":"charTrie.commonPrefixSearch(text)","local":"chartriecommonprefixsearchtext","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures.TokenLattice","local":"utilsdata-structurestokenlattice","sections":[{"title":"new TokenLattice(sentence, bosTokenId, eosTokenId)","local":"new-tokenlatticesentence-bostokenid-eostokenid","sections":[],"depth":3},{"title":"tokenLattice.insert(pos, length, score, tokenId)","local":"tokenlatticeinsertpos-length-score-tokenid","sections":[],"depth":3},{"title":"tokenLattice.viterbi() ⇒ <code> Array. < TokenLatticeNode > </code>","local":"tokenlatticeviterbi--code-array--tokenlatticenode--code","sections":[],"depth":3},{"title":"tokenLattice.piece(node) ⇒ <code> string </code>","local":"tokenlatticepiecenode--code-string-code","sections":[],"depth":3},{"title":"tokenLattice.tokens() ⇒ <code> Array </code>","local":"tokenlatticetokens--code-array-code","sections":[],"depth":3},{"title":"tokenLattice.tokenIds() ⇒ <code> Array </code>","local":"tokenlatticetokenids--code-array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures~CharTrieNode","local":"utilsdata-structureschartrienode","sections":[{"title":"new CharTrieNode(isLeaf, children)","local":"new-chartrienodeisleaf-children","sections":[],"depth":3},{"title":"CharTrieNode.default() ⇒ <code> CharTrieNode </code>","local":"chartrienodedefault--code-chartrienode-code","sections":[],"depth":3}],"depth":2},{"title":"utils/data-structures~TokenLatticeNode","local":"utilsdata-structurestokenlatticenode","sections":[{"title":"new TokenLatticeNode(tokenId, nodeId, pos, length, score)","local":"new-tokenlatticenodetokenid-nodeid-pos-length-score","sections":[],"depth":3},{"title":"tokenLatticeNode.clone() ⇒ <code> TokenLatticeNode </code>","local":"tokenlatticenodeclone--code-tokenlatticenode-code","sections":[],"depth":3}],"depth":2}],"depth":1}';function yd(Jr){return cd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xd extends pd{constructor(_){super(),hd(this,_,yd,$d,ad,{})}}export{xd as component};
