import{s as ee,o as le}from"../chunks/scheduler.56730f09.js";import{S as se,i as ne,g as p,s as n,r as J,A as ae,h as i,f as l,c as a,j as Yt,u as T,x as y,k as Kt,y as pe,a as s,v as c,d as o,t as r,w as u,m as Ot,n as te}from"../chunks/index.1f144517.js";import{H as L,g as ie}from"../chunks/Heading.5c5b0b2d.js";import{T as Dt}from"../chunks/Tip.41e845e5.js";import{C as bt}from"../chunks/CodeBlock.738eeccb.js";function we(F){let w;return{c(){w=Ot('추론 엔진을 만드는 것은 복잡한 주제이며, "최선의" 솔루션은 문제 공간에 따라 달라질 가능성이 높습니다. CPU 또는 GPU를 사용하는지에 따라 다르고 낮은 지연 시간을 원하는지, 높은 처리량을 원하는지, 다양한 모델을 지원할 수 있길 원하는지, 하나의 특정 모델을 고도로 최적화하길 원하는지 등에 따라 달라집니다. 이 주제를 해결하는 방법에는 여러 가지가 있으므로, 이 장에서 제시하는 것은 처음 시도해 보기에 좋은 출발점일 수는 있지만, 이 장을 읽는 여러분이 필요로 하는 최적의 솔루션은 아닐 수 있습니다.')},l(M){w=te(M,'추론 엔진을 만드는 것은 복잡한 주제이며, "최선의" 솔루션은 문제 공간에 따라 달라질 가능성이 높습니다. CPU 또는 GPU를 사용하는지에 따라 다르고 낮은 지연 시간을 원하는지, 높은 처리량을 원하는지, 다양한 모델을 지원할 수 있길 원하는지, 하나의 특정 모델을 고도로 최적화하길 원하는지 등에 따라 달라집니다. 이 주제를 해결하는 방법에는 여러 가지가 있으므로, 이 장에서 제시하는 것은 처음 시도해 보기에 좋은 출발점일 수는 있지만, 이 장을 읽는 여러분이 필요로 하는 최적의 솔루션은 아닐 수 있습니다.')},m(M,m){s(M,w,m)},d(M){M&&l(w)}}}function ye(F){let w;return{c(){w=Ot(`코드는 의도적으로 가독성을 위해 의사 코드처럼 작성되었습니다!
아래 코드를 작동시키기 전에 시스템 자원이 충분한지 확인하세요!`)},l(M){w=te(M,`코드는 의도적으로 가독성을 위해 의사 코드처럼 작성되었습니다!
아래 코드를 작동시키기 전에 시스템 자원이 충분한지 확인하세요!`)},m(M,m){s(M,w,m)},d(M){M&&l(w)}}}function Me(F){let w,M,m,K,f,D,U,O,C,gt='핵심적으로 이해해야 할 점은 <a href="pipeline_tutorial#using-pipelines-on-a-dataset">dataset</a>를 다룰 때와 마찬가지로 반복자를 사용 가능하다는 것입니다. 왜냐하면, 웹 서버는 기본적으로 요청을 기다리고 들어오는 대로 처리하는 시스템이기 때문입니다.',tt,j,xt="보통 웹 서버는 다양한 요청을 동시에 다루기 위해 매우 다중화된 구조(멀티 스레딩, 비동기 등)를 지니고 있습니다. 반면에, 파이프라인(대부분 파이프라인 안에 있는 모델)은 병렬처리에 그다지 좋지 않습니다. 왜냐하면 파이프라인은 많은 RAM을 차지하기 때문입니다. 따라서, 파이프라인이 실행 중이거나 계산 집약적인 작업 중일 때 모든 사용 가능한 리소스를 제공하는 것이 가장 좋습니다.",et,$,kt=`이 문제를 우리는 웹 서버가 요청을 받고 보내는 가벼운 부하를 처리하고, 실제 작업을 처리하는 단일 스레드를 갖는 방법으로 해결할 것입니다. 이 예제는 <code>starlette</code> 라이브러리를 사용합니다.
실제 프레임워크는 중요하지 않지만, 다른 프레임워크를 사용하는 경우 동일한 효과를 보기 위해선 코드를 조정하거나 변경해야 할 수 있습니다.`,lt,I,Nt="<code>server.py</code>를 생성하세요:",st,h,nt,_,Qt="이제 다음 명령어로 실행시킬 수 있습니다:",at,B,pt,v,qt="이제 쿼리를 날려볼 수 있습니다:",it,b,wt,g,Xt="자, 이제 웹 서버를 만드는 방법에 대한 좋은 개념을 알게 되었습니다!",yt,x,Zt=`중요한 점은 모델을 <strong>한 번만</strong> 가져온다는 것입니다. 따라서 웹 서버에는 모델의 사본이 없습니다. 이런 방식은 불필요한 RAM이 사용되지 않습니다. 그런 다음 큐 메커니즘을 사용하면, 다음과 같은
동적 배치를 사용하기 위해 추론 전 단계에 몇 개의 항목을 축적하는 것과 같은 멋진 작업을 할 수 있습니다:`,Mt,d,Jt,k,Tt,N,Et=`다시 말씀 드리자면, 제안된 코드는 가독성을 위해 최적화되었으며, 최상의 코드는 아닙니다.
첫째, 배치 크기 제한이 없으며 이는 일반적으로 좋은 방식이 아닙니다.
둘째, 모든 큐 가져오기에서 타임아웃이 재설정되므로 추론을 실행하기 전에 1ms보다 훨씬 오래 기다릴 수 있습니다(첫 번째 요청을 그만큼 지연시킴).`,ct,Q,Ht="단일 1ms 길이의 데드라인을 두는 편이 더 좋습니다.",ot,q,Vt=`이 방식을 사용하면 큐가 비어 있어도 항상 1ms를 기다리게 될 것입니다.
큐에 아무것도 없을 때 추론을 원하는 경우에는 최선의 방법이 아닐 수 있습니다.
하지만 배치 작업이 사용례에 따라 정말로 중요하다면 의미가 있을 수도 있습니다.
다시 말하지만, 최상의 솔루션은 없습니다.`,rt,X,ut,Z,mt,E,Gt=`프로덕션 환경에서는 문제가 발생할 여지가 많습니다.
메모리가 모자라거나, 공간이 부족하거나, 모델을 가져오는 데에 실패하거나, 쿼리가 잘못되었거나, 쿼리는 정확해도 모델 설정이 잘못되어 실행에 실패하는 등등 많은 경우가 존재합니다.`,Ut,H,St=`일반적으로 서버가 사용자에게 오류를 출력하는 것이 좋으므로
오류를 표시하기 위해 <code>try...except</code> 문을 많이 추가하는 것이 좋습니다.
하지만 보안 상황에 따라 모든 오류를 표시하는 것은 보안상 위험할 수도 있다는 점을 명심해야합니다.`,dt,V,ft,G,Rt=`웹 서버는 일반적으로 서킷 브레이킹을 수행할 때 더 나은 상황에 직면합니다.
즉, 이는 서버가 쿼리를 무기한 기다리는 대신 과부하 상태일 때 적절한 오류를 반환하는 것을 의미합니다.
서버가 매우 오랜 시간 동안 대기하거나 적당한 시간이 지난 후에 504 에러를 반환하는 대신 503 에러를 빠르게 반환하게 하는 것입니다.`,Ct,S,Wt=`제안된 코드에는 단일 큐가 있으므로 구현하기가 비교적 쉽습니다.
큐 크기를 확인하는 것은 웹 서버가 과부하 상항 하에 있을 때 에러를 반환하기 위한 가장 기초적인 작업입니다.`,jt,R,$t,W,zt=`현재 PyTorch는 비동기 처리를 지원하지 않으며, 실행 중에는 메인 스레드가 차단됩니다.
따라서 PyTorch를 별도의 스레드/프로세스에서 실행하도록 강제하는 것이 좋습니다.
여기서는 이 작업이 수행되지 않았습니다. 왜냐하면 코드가 훨씬 더 복잡하기 때문입니다(주로 스레드, 비동기 처리, 큐가 서로 잘 맞지 않기 때문입니다).
하지만 궁극적으로는 같은 작업을 수행하는 것입니다.`,It,z,At="단일 항목의 추론이 오래 걸린다면 (> 1초), 메인 쓰레드를 차단하는 것은 중요할 수 있습니다. 왜냐하면 이 경우 추론 중 모든 쿼리는 오류를 받기 전에 1초를 기다려야 하기 때문입니다.",ht,A,_t,P,Pt=`일반적으로, 배치 처리가 1개 항목을 한 번에 전달하는 것에 비해 반드시 성능 향상이 있는 것은 아닙니다(자세한 내용은 <a href="./main_classes/pipelines#pipeline-batching"><code>batching details</code></a>을 참고하세요).
하지만 올바른 설정에서 사용하면 매우 효과적일 수 있습니다.
API에는 기본적으로 속도 저하의 가능성이 매우 높기 때문에 동적 배치 처리가 없습니다.
하지만 매우 큰 모델인 BLOOM 추론의 경우 동적 배치 처리는 모든 사람에게 적절한 경험을 제공하는 데 <strong>필수</strong>입니다.`,Bt,Y,vt;return f=new L({props:{title:"웹 서버를 위한 파이프라인 사용하기",local:"using_pipelines_for_a_webserver",headingTag:"h1"}}),U=new Dt({props:{$$slots:{default:[we]},$$scope:{ctx:F}}}),h=new bt({props:{code:"ZnJvbSUyMHN0YXJsZXR0ZS5hcHBsaWNhdGlvbnMlMjBpbXBvcnQlMjBTdGFybGV0dGUlMEFmcm9tJTIwc3RhcmxldHRlLnJlc3BvbnNlcyUyMGltcG9ydCUyMEpTT05SZXNwb25zZSUwQWZyb20lMjBzdGFybGV0dGUucm91dGluZyUyMGltcG9ydCUyMFJvdXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwYXN5bmNpbyUwQSUwQSUwQWFzeW5jJTIwZGVmJTIwaG9tZXBhZ2UocmVxdWVzdCklM0ElMEElMjAlMjAlMjAlMjBwYXlsb2FkJTIwJTNEJTIwYXdhaXQlMjByZXF1ZXN0LmJvZHkoKSUwQSUyMCUyMCUyMCUyMHN0cmluZyUyMCUzRCUyMHBheWxvYWQuZGVjb2RlKCUyMnV0Zi04JTIyKSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlX3ElMjAlM0QlMjBhc3luY2lvLlF1ZXVlKCklMEElMjAlMjAlMjAlMjBhd2FpdCUyMHJlcXVlc3QuYXBwLm1vZGVsX3F1ZXVlLnB1dCgoc3RyaW5nJTJDJTIwcmVzcG9uc2VfcSkpJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjByZXNwb25zZV9xLmdldCgpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwSlNPTlJlc3BvbnNlKG91dHB1dCklMEElMEElMEFhc3luYyUyMGRlZiUyMHNlcnZlcl9sb29wKHEpJTNBJTBBJTIwJTIwJTIwJTIwcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBJTIwJTIwJTIwJTIwd2hpbGUlMjBUcnVlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKHN0cmluZyUyQyUyMHJlc3BvbnNlX3EpJTIwJTNEJTIwYXdhaXQlMjBxLmdldCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwcGlwZShzdHJpbmcpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXdhaXQlMjByZXNwb25zZV9xLnB1dChvdXQpJTBBJTBBJTBBYXBwJTIwJTNEJTIwU3RhcmxldHRlKCUwQSUyMCUyMCUyMCUyMHJvdXRlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJvdXRlKCUyMiUyRiUyMiUyQyUyMGhvbWVwYWdlJTJDJTIwbWV0aG9kcyUzRCU1QiUyMlBPU1QlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBKSUwQSUwQSUwQSU0MGFwcC5vbl9ldmVudCglMjJzdGFydHVwJTIyKSUwQWFzeW5jJTIwZGVmJTIwc3RhcnR1cF9ldmVudCgpJTNBJTBBJTIwJTIwJTIwJTIwcSUyMCUzRCUyMGFzeW5jaW8uUXVldWUoKSUwQSUyMCUyMCUyMCUyMGFwcC5tb2RlbF9xdWV1ZSUyMCUzRCUyMHElMEElMjAlMjAlMjAlMjBhc3luY2lvLmNyZWF0ZV90YXNrKHNlcnZlcl9sb29wKHEpKQ==",highlighted:`<span class="hljs-keyword">from</span> starlette.applications <span class="hljs-keyword">import</span> Starlette
<span class="hljs-keyword">from</span> starlette.responses <span class="hljs-keyword">import</span> JSONResponse
<span class="hljs-keyword">from</span> starlette.routing <span class="hljs-keyword">import</span> Route
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> asyncio


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">homepage</span>(<span class="hljs-params">request</span>):
    payload = <span class="hljs-keyword">await</span> request.body()
    string = payload.decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
    response_q = asyncio.Queue()
    <span class="hljs-keyword">await</span> request.app.model_queue.put((string, response_q))
    output = <span class="hljs-keyword">await</span> response_q.get()
    <span class="hljs-keyword">return</span> JSONResponse(output)


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">server_loop</span>(<span class="hljs-params">q</span>):
    pipe = pipeline(model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
        (string, response_q) = <span class="hljs-keyword">await</span> q.get()
        out = pipe(string)
        <span class="hljs-keyword">await</span> response_q.put(out)


app = Starlette(
    routes=[
        Route(<span class="hljs-string">&quot;/&quot;</span>, homepage, methods=[<span class="hljs-string">&quot;POST&quot;</span>]),
    ],
)


<span class="hljs-meta">@app.on_event(<span class="hljs-params"><span class="hljs-string">&quot;startup&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">startup_event</span>():
    q = asyncio.Queue()
    app.model_queue = q
    asyncio.create_task(server_loop(q))`,wrap:!1}}),B=new bt({props:{code:"dXZpY29ybiUyMHNlcnZlciUzQWFwcA==",highlighted:"uvicorn server:app",wrap:!1}}),b=new bt({props:{code:"Y3VybCUyMC1YJTIwUE9TVCUyMC1kJTIwJTIydGVzdCUyMCU1Qk1BU0slNUQlMjIlMjBodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBODAwMCUyRiUwQSUyMyU1QiU3QiUyMnNjb3JlJTIyJTNBMC43NzQyOTM2MDE1MTI5MDg5JTJDJTIydG9rZW4lMjIlM0ExMDEyJTJDJTIydG9rZW5fc3RyJTIyJTNBJTIyLiUyMiUyQyUyMnNlcXVlbmNlJTIyJTNBJTIydGVzdC4lMjIlN0QlMkMuLi4lNUQ=",highlighted:`curl -X POST -d <span class="hljs-string">&quot;test [MASK]&quot;</span> http://localhost:8000/
<span class="hljs-comment">#[{&quot;score&quot;:0.7742936015129089,&quot;token&quot;:1012,&quot;token_str&quot;:&quot;.&quot;,&quot;sequence&quot;:&quot;test.&quot;},...]</span>`,wrap:!1}}),d=new Dt({props:{warning:!0,$$slots:{default:[ye]},$$scope:{ctx:F}}}),k=new bt({props:{code:"KHN0cmluZyUyQyUyMHJxKSUyMCUzRCUyMGF3YWl0JTIwcS5nZXQoKSUwQXN0cmluZ3MlMjAlM0QlMjAlNUIlNUQlMEFxdWV1ZXMlMjAlM0QlMjAlNUIlNUQlMEF3aGlsZSUyMFRydWUlM0ElMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoc3RyaW5nJTJDJTIwcnEpJTIwJTNEJTIwYXdhaXQlMjBhc3luY2lvLndhaXRfZm9yKHEuZ2V0KCklMkMlMjB0aW1lb3V0JTNEMC4wMDEpJTIwJTIwJTIzJTIwMW1zJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwYXN5bmNpby5leGNlcHRpb25zLlRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTIwJTIwJTIwJTIwc3RyaW5ncy5hcHBlbmQoc3RyaW5nKSUwQSUyMCUyMCUyMCUyMHF1ZXVlcy5hcHBlbmQocnEpJTBBc3RyaW5ncyUwQW91dHMlMjAlM0QlMjBwaXBlKHN0cmluZ3MlMkMlMjBiYXRjaF9zaXplJTNEbGVuKHN0cmluZ3MpKSUwQWZvciUyMHJxJTJDJTIwb3V0JTIwaW4lMjB6aXAocXVldWVzJTJDJTIwb3V0cyklM0ElMEElMjAlMjAlMjAlMjBhd2FpdCUyMHJxLnB1dChvdXQp",highlighted:`(string, rq) = <span class="hljs-keyword">await</span> q.get()
strings = []
queues = []
<span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
    <span class="hljs-keyword">try</span>:
        (string, rq) = <span class="hljs-keyword">await</span> asyncio.wait_for(q.get(), timeout=<span class="hljs-number">0.001</span>)  <span class="hljs-comment"># 1ms</span>
    <span class="hljs-keyword">except</span> asyncio.exceptions.TimeoutError:
        <span class="hljs-keyword">break</span>
    strings.append(string)
    queues.append(rq)
strings
outs = pipe(strings, batch_size=<span class="hljs-built_in">len</span>(strings))
<span class="hljs-keyword">for</span> rq, out <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(queues, outs):
    <span class="hljs-keyword">await</span> rq.put(out)`,wrap:!1}}),X=new L({props:{title:"고려해야 할 몇 가지 사항",local:"few_things_you_might want_to_consider",headingTag:"h2"}}),Z=new L({props:{title:"에러 확인",local:"error_checking",headingTag:"h3"}}),V=new L({props:{title:"서킷 브레이킹",local:"circuit_breaking",headingTag:"h3"}}),R=new L({props:{title:"메인 쓰레드 차단",local:"blocking_the_main_thread",headingTag:"h3"}}),A=new L({props:{title:"동적 배치",local:"dynamic_batching",headingTag:"h3"}}),{c(){w=p("meta"),M=n(),m=p("p"),K=n(),J(f.$$.fragment),D=n(),J(U.$$.fragment),O=n(),C=p("p"),C.innerHTML=gt,tt=n(),j=p("p"),j.textContent=xt,et=n(),$=p("p"),$.innerHTML=kt,lt=n(),I=p("p"),I.innerHTML=Nt,st=n(),J(h.$$.fragment),nt=n(),_=p("p"),_.textContent=Qt,at=n(),J(B.$$.fragment),pt=n(),v=p("p"),v.textContent=qt,it=n(),J(b.$$.fragment),wt=n(),g=p("p"),g.textContent=Xt,yt=n(),x=p("p"),x.innerHTML=Zt,Mt=n(),J(d.$$.fragment),Jt=n(),J(k.$$.fragment),Tt=n(),N=p("p"),N.textContent=Et,ct=n(),Q=p("p"),Q.textContent=Ht,ot=n(),q=p("p"),q.textContent=Vt,rt=n(),J(X.$$.fragment),ut=n(),J(Z.$$.fragment),mt=n(),E=p("p"),E.textContent=Gt,Ut=n(),H=p("p"),H.innerHTML=St,dt=n(),J(V.$$.fragment),ft=n(),G=p("p"),G.textContent=Rt,Ct=n(),S=p("p"),S.textContent=Wt,jt=n(),J(R.$$.fragment),$t=n(),W=p("p"),W.textContent=zt,It=n(),z=p("p"),z.textContent=At,ht=n(),J(A.$$.fragment),_t=n(),P=p("p"),P.innerHTML=Pt,Bt=n(),Y=p("p"),this.h()},l(t){const e=ae("svelte-u9bgzb",document.head);w=i(e,"META",{name:!0,content:!0}),e.forEach(l),M=a(t),m=i(t,"P",{}),Yt(m).forEach(l),K=a(t),T(f.$$.fragment,t),D=a(t),T(U.$$.fragment,t),O=a(t),C=i(t,"P",{"data-svelte-h":!0}),y(C)!=="svelte-ndln2x"&&(C.innerHTML=gt),tt=a(t),j=i(t,"P",{"data-svelte-h":!0}),y(j)!=="svelte-yac9g1"&&(j.textContent=xt),et=a(t),$=i(t,"P",{"data-svelte-h":!0}),y($)!=="svelte-pzqeyp"&&($.innerHTML=kt),lt=a(t),I=i(t,"P",{"data-svelte-h":!0}),y(I)!=="svelte-1i0axl"&&(I.innerHTML=Nt),st=a(t),T(h.$$.fragment,t),nt=a(t),_=i(t,"P",{"data-svelte-h":!0}),y(_)!=="svelte-1m7mqzu"&&(_.textContent=Qt),at=a(t),T(B.$$.fragment,t),pt=a(t),v=i(t,"P",{"data-svelte-h":!0}),y(v)!=="svelte-1rviv8t"&&(v.textContent=qt),it=a(t),T(b.$$.fragment,t),wt=a(t),g=i(t,"P",{"data-svelte-h":!0}),y(g)!=="svelte-1u3j384"&&(g.textContent=Xt),yt=a(t),x=i(t,"P",{"data-svelte-h":!0}),y(x)!=="svelte-3dg4lo"&&(x.innerHTML=Zt),Mt=a(t),T(d.$$.fragment,t),Jt=a(t),T(k.$$.fragment,t),Tt=a(t),N=i(t,"P",{"data-svelte-h":!0}),y(N)!=="svelte-ucxnl"&&(N.textContent=Et),ct=a(t),Q=i(t,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-kbhszz"&&(Q.textContent=Ht),ot=a(t),q=i(t,"P",{"data-svelte-h":!0}),y(q)!=="svelte-ifjgqf"&&(q.textContent=Vt),rt=a(t),T(X.$$.fragment,t),ut=a(t),T(Z.$$.fragment,t),mt=a(t),E=i(t,"P",{"data-svelte-h":!0}),y(E)!=="svelte-ltauee"&&(E.textContent=Gt),Ut=a(t),H=i(t,"P",{"data-svelte-h":!0}),y(H)!=="svelte-6i9o5n"&&(H.innerHTML=St),dt=a(t),T(V.$$.fragment,t),ft=a(t),G=i(t,"P",{"data-svelte-h":!0}),y(G)!=="svelte-ws5azw"&&(G.textContent=Rt),Ct=a(t),S=i(t,"P",{"data-svelte-h":!0}),y(S)!=="svelte-jscs29"&&(S.textContent=Wt),jt=a(t),T(R.$$.fragment,t),$t=a(t),W=i(t,"P",{"data-svelte-h":!0}),y(W)!=="svelte-zclv6q"&&(W.textContent=zt),It=a(t),z=i(t,"P",{"data-svelte-h":!0}),y(z)!=="svelte-16ewq9g"&&(z.textContent=At),ht=a(t),T(A.$$.fragment,t),_t=a(t),P=i(t,"P",{"data-svelte-h":!0}),y(P)!=="svelte-b7iv88"&&(P.innerHTML=Pt),Bt=a(t),Y=i(t,"P",{}),Yt(Y).forEach(l),this.h()},h(){Kt(w,"name","hf:doc:metadata"),Kt(w,"content",Je)},m(t,e){pe(document.head,w),s(t,M,e),s(t,m,e),s(t,K,e),c(f,t,e),s(t,D,e),c(U,t,e),s(t,O,e),s(t,C,e),s(t,tt,e),s(t,j,e),s(t,et,e),s(t,$,e),s(t,lt,e),s(t,I,e),s(t,st,e),c(h,t,e),s(t,nt,e),s(t,_,e),s(t,at,e),c(B,t,e),s(t,pt,e),s(t,v,e),s(t,it,e),c(b,t,e),s(t,wt,e),s(t,g,e),s(t,yt,e),s(t,x,e),s(t,Mt,e),c(d,t,e),s(t,Jt,e),c(k,t,e),s(t,Tt,e),s(t,N,e),s(t,ct,e),s(t,Q,e),s(t,ot,e),s(t,q,e),s(t,rt,e),c(X,t,e),s(t,ut,e),c(Z,t,e),s(t,mt,e),s(t,E,e),s(t,Ut,e),s(t,H,e),s(t,dt,e),c(V,t,e),s(t,ft,e),s(t,G,e),s(t,Ct,e),s(t,S,e),s(t,jt,e),c(R,t,e),s(t,$t,e),s(t,W,e),s(t,It,e),s(t,z,e),s(t,ht,e),c(A,t,e),s(t,_t,e),s(t,P,e),s(t,Bt,e),s(t,Y,e),vt=!0},p(t,[e]){const Ft={};e&2&&(Ft.$$scope={dirty:e,ctx:t}),U.$set(Ft);const Lt={};e&2&&(Lt.$$scope={dirty:e,ctx:t}),d.$set(Lt)},i(t){vt||(o(f.$$.fragment,t),o(U.$$.fragment,t),o(h.$$.fragment,t),o(B.$$.fragment,t),o(b.$$.fragment,t),o(d.$$.fragment,t),o(k.$$.fragment,t),o(X.$$.fragment,t),o(Z.$$.fragment,t),o(V.$$.fragment,t),o(R.$$.fragment,t),o(A.$$.fragment,t),vt=!0)},o(t){r(f.$$.fragment,t),r(U.$$.fragment,t),r(h.$$.fragment,t),r(B.$$.fragment,t),r(b.$$.fragment,t),r(d.$$.fragment,t),r(k.$$.fragment,t),r(X.$$.fragment,t),r(Z.$$.fragment,t),r(V.$$.fragment,t),r(R.$$.fragment,t),r(A.$$.fragment,t),vt=!1},d(t){t&&(l(M),l(m),l(K),l(D),l(O),l(C),l(tt),l(j),l(et),l($),l(lt),l(I),l(st),l(nt),l(_),l(at),l(pt),l(v),l(it),l(wt),l(g),l(yt),l(x),l(Mt),l(Jt),l(Tt),l(N),l(ct),l(Q),l(ot),l(q),l(rt),l(ut),l(mt),l(E),l(Ut),l(H),l(dt),l(ft),l(G),l(Ct),l(S),l(jt),l($t),l(W),l(It),l(z),l(ht),l(_t),l(P),l(Bt),l(Y)),l(w),u(f,t),u(U,t),u(h,t),u(B,t),u(b,t),u(d,t),u(k,t),u(X,t),u(Z,t),u(V,t),u(R,t),u(A,t)}}}const Je='{"title":"웹 서버를 위한 파이프라인 사용하기","local":"using_pipelines_for_a_webserver","sections":[{"title":"고려해야 할 몇 가지 사항","local":"few_things_you_might want_to_consider","sections":[{"title":"에러 확인","local":"error_checking","sections":[],"depth":3},{"title":"서킷 브레이킹","local":"circuit_breaking","sections":[],"depth":3},{"title":"메인 쓰레드 차단","local":"blocking_the_main_thread","sections":[],"depth":3},{"title":"동적 배치","local":"dynamic_batching","sections":[],"depth":3}],"depth":2}],"depth":1}';function Te(F){return le(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=ie}),[]}class Ue extends se{constructor(w){super(),ne(this,w,Te,Me,ee,{})}}export{Ue as component};
