import{s as T$,n as h$,o as _$}from"../chunks/scheduler.0219f8bd.js";import{S as $$,i as b$,g as r,s as o,r as u,A as v$,h as i,f as l,c as n,j as h,u as m,x as d,k as a,y as y$,a as s,v as p,d as c,t as f,w as T}from"../chunks/index.f61edf3b.js";import{C as tr}from"../chunks/CodeBlock.15473de1.js";import{H as _,E as M$}from"../chunks/index.563c4cba.js";function x$(AT){let $,or,lr,nr,b,rr,v,ir,y,gT="Helper module for <code>Tensor</code> processing.",dr,M,PT=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,ar,x,zT='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+map"><code>.map(callback)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+map_"><code>.map_(callback)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sub"><code>.sub(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sub_"><code>.sub_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+clone"><code>.clone()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+slice"><code>.slice(...slices)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+gt"><code>.gt(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+lt"><code>.lt(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li></ul></li> <li><a href="#module_utils/tensor.permute"><code>.permute(tensor, axes)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.interpolate_4d"><code>.interpolate_4d(input, options)</code></a> ⇒ <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.matmul"><code>.matmul(a, b)</code></a> ⇒ <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.rfft"><code>.rfft(x, a)</code></a> ⇒ <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.topk"><code>.topk(x, [k])</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/tensor.slice"><code>.slice(data:, starts:, ends:, axes:, [steps])</code></a> ⇒ <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.layer_norm"><code>.layer_norm(input, normalized_shape, options)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <a href="#Tensor"><code>Array.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.full"><code>.full(size, fill_value)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.ones"><code>.ones(size)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.ones_like"><code>.ones_like(tensor)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.zeros"><code>.zeros(size)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.zeros_like"><code>.zeros_like(tensor)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.rand"><code>.rand(size)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.quantize_embeddings"><code>.quantize_embeddings(tensor, precision)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..args%5B0%5D"><code>~args[0]</code></a> : <code>ONNXTensor</code></li> <li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..reduce_helper"><code>~reduce_helper(callbackfn, input, dim, keepdim)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',ur,mr,pr,C,cr,H,fr,L,RT='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Tr,w,kT='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <a href="#DataType"><code>DataType</code></a></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+location"><code>.location</code></a> : <code>string</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+map"><code>.map(callback)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+map_"><code>.map_(callback)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+div"><code>.div(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+div_"><code>.div_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sub"><code>.sub(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sub_"><code>.sub_(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+clone"><code>.clone()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+slice"><code>.slice(...slices)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+gt"><code>.gt(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+lt"><code>.lt(val)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <a href="#Tensor"><code>Tensor</code></a></li></ul></li>',hr,_r,$r,A,br,g,vr,P,UT="Create a new Tensor or copy an existing Tensor.",yr,z,ET="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",Mr,xr,Cr,R,Hr,k,Lr,U,jT="Dimensions of the tensor.",wr,E,JT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Ar,gr,Pr,j,zr,J,Rr,D,DT="Type of the tensor.",kr,q,qT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Ur,Er,jr,I,Jr,K,Dr,B,IT="The data stored in the tensor.",qr,N,KT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Ir,Kr,Br,Q,Nr,V,Qr,S,BT="The number of elements in the tensor.",Vr,O,NT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Sr,Or,Fr,F,Yr,Y,Wr,W,QT="The location of the tensor data.",Gr,G,VT='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Xr,Zr,ei,X,ti,Z,li,ee,ST=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,si,te,OT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',oi,ni,ri,le,ii,se,di,oe,FT="Index into a Tensor object.",ai,ne,YT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The data at the specified index.',ui,re,WT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",mi,pi,ci,ie,fi,de,Ti,ae,GT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',hi,ue,XT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",_i,$i,bi,me,vi,pe,yi,ce,ZT='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Mi,fe,eh="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",xi,Ci,Hi,Te,Li,he,wi,_e,th=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,Ai,$e,lh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> | <code>bigint</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',gi,be,sh="<li><code>Error</code> If the tensor has more than one element.</li>",Pi,zi,Ri,ve,ki,ye,Ui,Me,oh="Convert tensor data to a n-dimensional JS list",Ei,xe,nh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',ji,Ji,Di,Ce,qi,He,Ii,Le,rh="Return a new Tensor with the sigmoid function applied to each element.",Ki,we,ih='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The tensor with the sigmoid function applied.',Bi,Ni,Qi,Ae,Vi,ge,Si,Pe,dh="Applies the sigmoid function to the tensor in place.",Oi,ze,ah='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',Fi,Yi,Wi,Re,Gi,ke,Xi,Ue,uh="Return a new Tensor with a callback function applied to each element.",Zi,Ee,mh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A new Tensor with the callback function applied to each element.',ed,je,ph=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>callback</td><td><code>function</code></td><td><p>The function to apply to each element. It should take three arguments:
                             the current element, its index, and the tensor&#39;s data array.</p></td></tr></tbody>`,td,ld,sd,Je,od,De,nd,qe,ch="Apply a callback function to each element of the tensor in place.",rd,Ie,fh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',id,Ke,Th=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>callback</td><td><code>function</code></td><td><p>The function to apply to each element. It should take three arguments:
                             the current element, its index, and the tensor&#39;s data array.</p></td></tr></tbody>`,dd,ad,ud,Be,md,Ne,pd,Qe,hh="Return a new Tensor with every element multiplied by a constant.",cd,Ve,_h='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The new tensor.',fd,Se,$h="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",Td,hd,_d,Oe,$d,Fe,bd,Ye,bh="Multiply the tensor by a constant in place.",vd,We,vh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',yd,Ge,yh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",Md,xd,Cd,Xe,Hd,Ze,Ld,et,Mh="Return a new Tensor with every element divided by a constant.",wd,tt,xh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The new tensor.',Ad,lt,Ch="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",gd,Pd,zd,st,Rd,ot,kd,nt,Hh="Divide the tensor by a constant in place.",Ud,rt,Lh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',Ed,it,wh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to divide by.</p></td></tr></tbody>",jd,Jd,Dd,dt,qd,at,Id,ut,Ah="Return a new Tensor with every element added by a constant.",Kd,mt,gh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The new tensor.',Bd,pt,Ph="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",Nd,Qd,Vd,ct,Sd,ft,Od,Tt,zh="Add the tensor by a constant in place.",Fd,ht,Rh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',Yd,_t,kh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",Wd,Gd,Xd,$t,Zd,bt,ea,vt,Uh="Return a new Tensor with every element subtracted by a constant.",ta,yt,Eh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The new tensor.',la,Mt,jh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to subtract by.</p></td></tr></tbody>",sa,oa,na,xt,ra,Ct,ia,Ht,Jh="Subtract the tensor by a constant in place.",da,Lt,Dh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns <code>this</code>.',aa,wt,qh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to subtract by.</p></td></tr></tbody>",ua,ma,pa,At,ca,gt,fa,Pt,Ih="Creates a deep copy of the current Tensor.",Ta,zt,Kh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A new Tensor with the same type, data, and dimensions as the original.',ha,_a,$a,Rt,ba,kt,va,Ut,Bh="Performs a slice operation on the Tensor along specified dimensions.",ya,Et,Nh="Consider a Tensor that has a dimension of [4, 7]:",Ma,jt,xa,Jt,Qh=`We can slice against the two dims of row and column, for instance in this
case we can start at the second element, and return to the second last,
like this:`,Ca,Dt,Ha,qt,Vh="which would return:",La,It,wa,Kt,Sh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A new Tensor containing the selected elements.<br/> <strong>Throws</strong>:',Aa,Bt,Oh="<li><code>Error</code> If the slice input is invalid.</li>",ga,Nt,Fh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...slices</td><td><code>number</code> | <code>Array&lt;number&gt;</code> | <code>null</code></td><td><p>The slice specifications for each dimension.</p> <ul><li>If a number is given, then a single element is selected.</li> <li>If an array of two numbers is given, then a range of elements [start, end (exclusive)] is selected.</li> <li>If null is given, then the entire dimension is selected.</li></ul></td></tr></tbody>",Pa,za,Ra,Qt,ka,Vt,Ua,St,Yh="Return a permuted version of this Tensor, according to the provided dimensions.",Ea,Ot,Wh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The permuted tensor.',ja,Ft,Gh="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to permute.</p></td></tr></tbody>",Ja,Da,qa,Yt,Ia,Wt,Ka,Gt,Xh="Returns the sum of each row of the input tensor in the given dimension dim.",Ba,Xt,Zh='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',Na,Zt,e1="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",Qa,Va,Sa,el,Oa,tl,Fa,ll,t1="Returns the matrix norm or vector norm of a given tensor.",Ya,sl,l1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The norm of the tensor.',Wa,ol,s1=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,Ga,Xa,Za,nl,eu,rl,tu,il,o1="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",lu,dl,n1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - <code>this</code> for operation chaining.',su,al,r1="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",ou,nu,ru,ul,iu,ml,du,pl,i1="Performs <code>L_p</code> normalization of inputs over specified dimension.",au,cl,d1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The normalized tensor.',uu,fl,a1="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",mu,pu,cu,Tl,fu,hl,Tu,_l,u1=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,hu,$l,m1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',_u,$u,bu,bl,vu,vl,yu,yl,p1="Returns a tensor with all specified dimensions of input of size 1 removed.",Mu,Ml,c1=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,xu,xl,f1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The squeezed tensor',Cu,Cl,T1="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",Hu,Lu,wu,Hl,Au,Ll,gu,wl,h1='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',Pu,Al,_1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',zu,Ru,ku,gl,Uu,Pl,Eu,zl,$1="Returns a new tensor with a dimension of size one inserted at the specified position.",ju,Rl,b1="NOTE: The returned tensor shares the same underlying data with this tensor.",Ju,kl,v1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The unsqueezed tensor',Du,Ul,y1="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",qu,Iu,Ku,El,Bu,jl,Nu,Jl,M1='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',Qu,Dl,x1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Vu,Su,Ou,ql,Fu,Il,Yu,Kl,C1='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',Wu,Bl,H1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Gu,Xu,Zu,Nl,em,Ql,tm,Vl,L1=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,lm,Sl,w1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The flattened tensor.',sm,Ol,A1="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",om,nm,rm,Fl,im,Yl,dm,Wl,g1="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",am,Gl,P1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The tensor with the same data but different shape',um,Xl,z1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",mm,pm,cm,Zl,fm,es,Tm,ts,R1="Computes input > val element-wise.",hm,ls,k1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A boolean tensor that is <code>true</code> where input is greater than other and <code>false</code> elsewhere.',_m,ss,U1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to compare with.</p></td></tr></tbody>",$m,bm,vm,os,ym,ns,Mm,rs,E1="Computes input < val element-wise.",xm,is,j1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A boolean tensor that is <code>true</code> where input is less than other and <code>false</code> elsewhere.',Cm,ds,J1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to compare with.</p></td></tr></tbody>",Hm,Lm,wm,as,Am,us,gm,ms,D1='In-place version of @see <a href="Tensor.clamp">Tensor.clamp</a>',Pm,ps,q1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',zm,Rm,km,cs,Um,fs,Em,Ts,I1="Clamps all elements in input into the range [ min, max ]",jm,hs,K1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - the output tensor.',Jm,_s,B1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min</td><td><code>number</code></td><td><p>lower-bound of the range to be clamped to</p></td> </tr><tr><td>max</td><td><code>number</code></td><td><p>upper-bound of the range to be clamped to</p></td></tr></tbody>",Dm,qm,Im,$s,Km,bs,Bm,vs,N1='In-place version of @see <a href="Tensor.round">Tensor.round</a>',Nm,ys,Q1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Qm,Vm,Sm,Ms,Om,xs,Fm,Cs,V1="Rounds elements of input to the nearest integer.",Ym,Hs,S1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - the output tensor.',Wm,Gm,Xm,Ls,Zm,ws,ep,As,O1="Performs Tensor dtype conversion.",tp,gs,F1='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The converted tensor.',lp,Ps,Y1='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>type</td><td><code><a href="#DataType">DataType</a></code></td><td><p>The desired data type.</p></td></tr></tbody>',sp,op,np,zs,rp,Rs,ip,ks,W1="Permutes a tensor according to the provided axes.",dp,Us,G1='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The permuted tensor.',ap,Es,X1="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to permute.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to permute the tensor along.</p></td></tr></tbody>",up,mp,pp,js,cp,Js,fp,Ds,Z1="Interpolates an Tensor to the given size.",Tp,qs,e_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The interpolated tensor.',hp,Is,t_='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>',_p,$p,bp,Ks,vp,Bs,yp,Ns,l_=`Down/up samples the input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.nn.functional.interpolate.html</a>.`,Mp,Qs,s_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a> - The interpolated tensor.',xp,Vs,o_='<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td></td><td><p>the input tensor</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>the options for the interpolation</p></td> </tr><tr><td>[options.size]</td><td><code>*</code></td><td><code></code></td><td><p>output spatial size.</p></td> </tr><tr><td>[options.mode]</td><td><code>&quot;nearest&quot;</code> | <code>&quot;bilinear&quot;</code> | <code>&quot;bicubic&quot;</code></td><td><code>&#39;bilinear&#39;</code></td><td><p>algorithm used for upsampling</p></td></tr></tbody>',Cp,Hp,Lp,Ss,wp,Os,Ap,Fs,n_=`Matrix product of two tensors.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.matmul.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.matmul.html</a>`,gp,Ys,r_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a> - The matrix product of the two tensors.',Pp,Ws,i_='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>a</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the first tensor to be multiplied</p></td> </tr><tr><td>b</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the second tensor to be multiplied</p></td></tr></tbody>',zp,Rp,kp,Gs,Up,Xs,Ep,Zs,d_=`Computes the one dimensional Fourier transform of real-valued input.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.fft.rfft.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.fft.rfft.html</a>`,jp,eo,a_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a> - the output tensor.',Jp,to,u_='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the real input tensor</p></td> </tr><tr><td>a</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The dimension along which to take the one dimensional real FFT.</p></td></tr></tbody>',Dp,qp,Ip,lo,Kp,so,Bp,oo,m_=`Returns the k largest elements of the given input tensor.
Inspired by <a href="https://pytorch.org/docs/stable/generated/torch.topk.html" rel="nofollow">https://pytorch.org/docs/stable/generated/torch.topk.html</a>`,Np,no,p_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - the output tuple of (Tensor, LongTensor) of top-k elements and their indices.',Qp,ro,c_='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the input tensor</p></td> </tr><tr><td>[k]</td><td><code>number</code></td><td><p>the k in &quot;top-k&quot;</p></td></tr></tbody>',Vp,Sp,Op,io,Fp,ao,Yp,uo,f_="Slice a multidimensional float32 tensor.",Wp,mo,T_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a> - Sliced data tensor.',Gp,po,h_='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data:</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>Tensor of data to extract slices from</p></td> </tr><tr><td>starts:</td><td><code>Array.&lt;number&gt;</code></td><td><p>1-D array of starting indices of corresponding axis in axes</p></td> </tr><tr><td>ends:</td><td><code>Array.&lt;number&gt;</code></td><td><p>1-D array of ending indices (exclusive) of corresponding axis in axes</p></td> </tr><tr><td>axes:</td><td><code>Array.&lt;number&gt;</code></td><td><p>1-D array of axes that starts and ends apply to</p></td> </tr><tr><td>[steps]</td><td><code>Array.&lt;number&gt;</code></td><td><p>1-D array of slice step of corresponding axis in axes.</p></td></tr></tbody>',Xp,Zp,ec,co,tc,fo,lc,To,__="Perform mean pooling of the last hidden state followed by a normalization step.",sc,ho,$_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - Returns a new Tensor of shape [batchSize, embedDim].',oc,_o,b_='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>',nc,rc,ic,$o,dc,bo,ac,vo,v_="Apply Layer Normalization for last certain number of dimensions.",uc,yo,y_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The normalized tensor.',mc,Mo,M_='<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td></td><td><p>The input tensor</p></td> </tr><tr><td>normalized_shape</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>input shape from an expected input of size</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the layer normalization</p></td> </tr><tr><td>[options.eps]</td><td><code>number</code></td><td><code>1e-5</code></td><td><p>A value added to the denominator for numerical stability.</p></td></tr></tbody>',pc,cc,fc,xo,Tc,Co,hc,Ho,x_="Concatenates an array of tensors along a specified dimension.",_c,Lo,C_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The concatenated tensor.',$c,wo,H_='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code><a href="#Tensor">Array.&lt;Tensor&gt;</a></code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>',bc,vc,yc,Ao,Mc,go,xc,Po,L_="Stack an array of tensors along a specified dimension.",Cc,zo,w_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The stacked tensor.',Hc,Ro,A_='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code><a href="#Tensor">Array.&lt;Tensor&gt;</a></code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>',Lc,wc,Ac,ko,gc,Uo,Pc,Eo,g_="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",zc,jo,P_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Array.&lt;Tensor&gt;</code></a> - A tuple of (std, mean) tensors.',Rc,Jo,z_='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>',kc,Uc,Ec,Do,jc,qo,Jc,Io,R_="Returns the mean value of each row of the input tensor in the given dimension dim.",Dc,Ko,k_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - A new tensor with means taken along the specified dimension.',qc,Bo,U_='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>',Ic,Kc,Bc,No,Nc,Qo,Qc,Vo,E_="Creates a tensor of size size filled with fill_value. The tensor’s dtype is inferred from fill_value.",Vc,So,j_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The filled tensor.',Sc,Oo,J_="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td> </tr><tr><td>fill_value</td><td><code>number</code> | <code>bigint</code> | <code>boolean</code></td><td><p>The value to fill the output tensor with.</p></td></tr></tbody>",Oc,Fc,Yc,Fo,Wc,Yo,Gc,Wo,D_="Returns a tensor filled with the scalar value 1, with the shape defined by the variable argument size.",Xc,Go,q_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The ones tensor.',Zc,Xo,I_="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",ef,tf,lf,Zo,sf,en,of,tn,K_="Returns a tensor filled with the scalar value 1, with the same size as input.",nf,ln,B_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The ones tensor.',rf,sn,N_='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>',df,af,uf,on,mf,nn,pf,rn,Q_="Returns a tensor filled with the scalar value 0, with the shape defined by the variable argument size.",cf,dn,V_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The zeros tensor.',ff,an,S_="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Tf,hf,_f,un,$f,mn,bf,pn,O_="Returns a tensor filled with the scalar value 0, with the same size as input.",vf,cn,F_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The zeros tensor.',yf,fn,Y_='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>',Mf,xf,Cf,Tn,Hf,hn,Lf,_n,W_="Returns a tensor filled with random numbers from a uniform distribution on the interval [0, 1)",wf,$n,G_='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The random tensor.',Af,bn,X_="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",gf,Pf,zf,vn,Rf,yn,kf,Mn,Z_="Quantizes the embeddings tensor to binary or unsigned binary precision.",Uf,xn,e$='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Tensor</code></a> - The quantized tensor.',Ef,Cn,t$='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code><a href="#Tensor">Tensor</a></code></td><td><p>The tensor to quantize.</p></td> </tr><tr><td>precision</td><td><code>&#39;binary&#39;</code> | <code>&#39;ubinary&#39;</code></td><td><p>The precision to use for quantization.</p></td></tr></tbody>',jf,Jf,Df,Hn,qf,Ln,If,wn,l$='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Kf,Bf,Nf,An,Qf,gn,Vf,Pn,s$="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",Sf,zn,o$='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',Of,Rn,n$="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array&lt;T&gt;</code> | <code>DataArray</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",Ff,kn,r$="<strong>Example</strong>",Yf,Un,Wf,Gf,Xf,En,Zf,jn,eT,Jn,i$='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',tT,lT,sT,Dn,oT,qn,nT,In,d$='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reduced tensor data.',rT,Kn,a$='<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>callbackfn</td><td><code>*</code></td><td></td><td></td> </tr><tr><td>input</td><td><code><a href="#Tensor">Tensor</a></code></td><td></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><code></code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>',iT,dT,aT,Bn,uT,Nn,mT,Qn,u$='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',pT,cT,fT,Vn,TT,Sn,hT,On,m$="This creates a nested array of a given type and depth (see examples).",_T,Fn,p$='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',$T,Yn,bT,Wn,c$="<strong>Example</strong>",vT,Gn,yT,Xn,f$="<strong>Example</strong>",MT,Zn,xT,CT,HT,er,LT,sr,wT;return v=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),g=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),k=new _({props:{title:"tensor.dims : <code> Array. < number > </code>",local:"tensordims--code-array--number--code",headingTag:"h3"}}),J=new _({props:{title:"tensor.type : <code> DataType </code>",local:"tensortype--code-datatype-code",headingTag:"h3"}}),K=new _({props:{title:"tensor.data : <code> DataArray </code>",local:"tensordata--code-dataarray-code",headingTag:"h3"}}),V=new _({props:{title:"tensor.size : <code> number </code>",local:"tensorsize--code-number-code",headingTag:"h3"}}),Y=new _({props:{title:"tensor.location : <code> string </code>",local:"tensorlocation--code-string-code",headingTag:"h3"}}),Z=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),se=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),de=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),pe=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),he=new _({props:{title:"tensor.item() ⇒ <code> number </code> | <code> bigint </code>",local:"tensoritem--code-number-code--code-bigint-code",headingTag:"h3"}}),ye=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),He=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ge=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ke=new _({props:{title:"tensor.map(callback) ⇒ <code> Tensor </code>",local:"tensormapcallback--code-tensor-code",headingTag:"h3"}}),De=new _({props:{title:"tensor.map_(callback) ⇒ <code> Tensor </code>",local:"tensormapcallback--code-tensor-code",headingTag:"h3"}}),Ne=new _({props:{title:"tensor.mul(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Fe=new _({props:{title:"tensor.mul_(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Ze=new _({props:{title:"tensor.div(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),ot=new _({props:{title:"tensor.div_(val) ⇒ <code> Tensor </code>",local:"tensordivval--code-tensor-code",headingTag:"h3"}}),at=new _({props:{title:"tensor.add(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),ft=new _({props:{title:"tensor.add_(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),bt=new _({props:{title:"tensor.sub(val) ⇒ <code> Tensor </code>",local:"tensorsubval--code-tensor-code",headingTag:"h3"}}),Ct=new _({props:{title:"tensor.sub_(val) ⇒ <code> Tensor </code>",local:"tensorsubval--code-tensor-code",headingTag:"h3"}}),gt=new _({props:{title:"tensor.clone() ⇒ <code> Tensor </code>",local:"tensorclone--code-tensor-code",headingTag:"h3"}}),kt=new _({props:{title:"tensor.slice(...slices) ⇒ <code> Tensor </code>",local:"tensorsliceslices--code-tensor-code",headingTag:"h3"}}),jt=new tr({props:{code:"JTVCJTIwMSUyQyUyMCUyMDIlMkMlMjAlMjAzJTJDJTIwJTIwNCUyQyUyMCUyMDUlMkMlMjAlMjA2JTJDJTIwJTIwNyU1RCUwQSU1QiUyMDglMkMlMjAlMjA5JTJDJTIwMTAlMkMlMjAxMSUyQyUyMDEyJTJDJTIwMTMlMkMlMjAxNCU1RCUwQSU1QjE1JTJDJTIwMTYlMkMlMjAxNyUyQyUyMDE4JTJDJTIwMTklMkMlMjAyMCUyQyUyMDIxJTVEJTBBJTVCMjIlMkMlMjAyMyUyQyUyMDI0JTJDJTIwMjUlMkMlMjAyNiUyQyUyMDI3JTJDJTIwMjglNUQ=",highlighted:`<span class="hljs-string">[ 1,  2,  3,  4,  5,  6,  7]</span>
<span class="hljs-string">[ 8,  9, 10, 11, 12, 13, 14]</span>
<span class="hljs-string">[15, 16, 17, 18, 19, 20, 21]</span>
<span class="hljs-string">[22, 23, 24, 25, 26, 27, 28]</span>`,wrap:!1}}),Dt=new tr({props:{code:"dGVuc29yLnNsaWNlKCU1QjElMkMlMjAtMSU1RCUyQyUyMCU1QjElMkMlMjAtMSU1RCklM0I=",highlighted:'<span class="hljs-attribute">tensor</span>.slice([<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>],<span class="hljs-meta"> [1, -1]);</span>',wrap:!1}}),It=new tr({props:{code:"JTVCJTIwJTIwOSUyQyUyMDEwJTJDJTIwMTElMkMlMjAxMiUyQyUyMDEzJTIwJTVEJTBBJTVCJTIwMTYlMkMlMjAxNyUyQyUyMDE4JTJDJTIwMTklMkMlMjAyMCUyMCU1RA==",highlighted:`<span class="hljs-string">[  9, 10, 11, 12, 13 ]</span>
<span class="hljs-string">[ 16, 17, 18, 19, 20 ]</span>`,wrap:!1}}),Vt=new _({props:{title:"tensor.permute(...dims) ⇒ <code> Tensor </code>",local:"tensorpermutedims--code-tensor-code",headingTag:"h3"}}),Wt=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),tl=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),rl=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),ml=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),hl=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),vl=new _({props:{title:"tensor.squeeze([dim]) ⇒ <code> Tensor </code>",local:"tensorsqueezedim--code-tensor-code",headingTag:"h3"}}),Ll=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),Pl=new _({props:{title:"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>",local:"tensorunsqueezedim--code-tensor-code",headingTag:"h3"}}),jl=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),Il=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),Ql=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>",local:"tensorflattenstartdim-enddim--code-tensor-code",headingTag:"h3"}}),Yl=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),es=new _({props:{title:"tensor.gt(val) ⇒ <code> Tensor </code>",local:"tensorgtval--code-tensor-code",headingTag:"h3"}}),ns=new _({props:{title:"tensor.lt(val) ⇒ <code> Tensor </code>",local:"tensorltval--code-tensor-code",headingTag:"h3"}}),us=new _({props:{title:"tensor.clamp_()",local:"tensorclamp",headingTag:"h3"}}),fs=new _({props:{title:"tensor.clamp(min, max) ⇒ <code> Tensor </code>",local:"tensorclampmin-max--code-tensor-code",headingTag:"h3"}}),bs=new _({props:{title:"tensor.round_()",local:"tensorround",headingTag:"h3"}}),xs=new _({props:{title:"tensor.round() ⇒ <code> Tensor </code>",local:"tensorround--code-tensor-code",headingTag:"h3"}}),ws=new _({props:{title:"tensor.to(type) ⇒ <code> Tensor </code>",local:"tensortotype--code-tensor-code",headingTag:"h3"}}),Rs=new _({props:{title:"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensorpermutetensor-axes--code-tensor-code",headingTag:"h2"}}),Js=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),Bs=new _({props:{title:"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorinterpolate4dinput-options--code-promise--tensor--code",headingTag:"h2"}}),Os=new _({props:{title:"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensormatmula-b--code-promise--tensor--code",headingTag:"h2"}}),Xs=new _({props:{title:"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorrfftx-a--code-promise--tensor--code",headingTag:"h2"}}),so=new _({props:{title:"utils/tensor.topk(x, [k]) ⇒ <code> * </code>",local:"utilstensortopkx-k--code--code",headingTag:"h2"}}),ao=new _({props:{title:"utils/tensor.slice(data:, starts:, ends:, axes:, [steps]) ⇒ <code> Promise. < Tensor > </code>",local:"utilstensorslicedata-starts-ends-axes-steps--code-promise--tensor--code",headingTag:"h2"}}),fo=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),bo=new _({props:{title:"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>",local:"utilstensorlayernorminput-normalizedshape-options--code-tensor-code",headingTag:"h2"}}),Co=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),go=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),Uo=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),qo=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>",local:"utilstensormeaninput-dim-keepdim--code-tensor-code",headingTag:"h2"}}),Qo=new _({props:{title:"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>",local:"utilstensorfullsize-fillvalue--code-tensor-code",headingTag:"h2"}}),Yo=new _({props:{title:"utils/tensor.ones(size) ⇒ <code> Tensor </code>",local:"utilstensoronessize--code-tensor-code",headingTag:"h2"}}),en=new _({props:{title:"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensoronesliketensor--code-tensor-code",headingTag:"h2"}}),nn=new _({props:{title:"utils/tensor.zeros(size) ⇒ <code> Tensor </code>",local:"utilstensorzerossize--code-tensor-code",headingTag:"h2"}}),mn=new _({props:{title:"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>",local:"utilstensorzerosliketensor--code-tensor-code",headingTag:"h2"}}),hn=new _({props:{title:"utils/tensor.rand(size) ⇒ <code> Tensor </code>",local:"utilstensorrandsize--code-tensor-code",headingTag:"h2"}}),yn=new _({props:{title:"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>",local:"utilstensorquantizeembeddingstensor-precision--code-tensor-code",headingTag:"h2"}}),Ln=new _({props:{title:"utils/tensor~args[0] : <code> ONNXTensor </code>",local:"utilstensorargs0--code-onnxtensor-code",headingTag:"h2"}}),gn=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),Un=new tr({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),jn=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),qn=new _({props:{title:"utils/tensor~reduce_helper(callbackfn, input, dim, keepdim) ⇒ <code> * </code>",local:"utilstensorreducehelpercallbackfn-input-dim-keepdim--code--code",headingTag:"h2"}}),Nn=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),Sn=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),Yn=new tr({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),Gn=new tr({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),Zn=new tr({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),er=new M$({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/tensor.md"}}),{c(){$=r("meta"),or=o(),lr=r("p"),nr=o(),b=r("a"),rr=o(),u(v.$$.fragment),ir=o(),y=r("p"),y.innerHTML=gT,dr=o(),M=r("p"),M.textContent=PT,ar=o(),x=r("ul"),x.innerHTML=zT,ur=o(),mr=r("hr"),pr=o(),C=r("a"),cr=o(),u(H.$$.fragment),fr=o(),L=r("p"),L.innerHTML=RT,Tr=o(),w=r("ul"),w.innerHTML=kT,hr=o(),_r=r("hr"),$r=o(),A=r("a"),br=o(),u(g.$$.fragment),vr=o(),P=r("p"),P.textContent=UT,yr=o(),z=r("table"),z.innerHTML=ET,Mr=o(),xr=r("hr"),Cr=o(),R=r("a"),Hr=o(),u(k.$$.fragment),Lr=o(),U=r("p"),U.textContent=jT,wr=o(),E=r("p"),E.innerHTML=JT,Ar=o(),gr=r("hr"),Pr=o(),j=r("a"),zr=o(),u(J.$$.fragment),Rr=o(),D=r("p"),D.textContent=DT,kr=o(),q=r("p"),q.innerHTML=qT,Ur=o(),Er=r("hr"),jr=o(),I=r("a"),Jr=o(),u(K.$$.fragment),Dr=o(),B=r("p"),B.textContent=IT,qr=o(),N=r("p"),N.innerHTML=KT,Ir=o(),Kr=r("hr"),Br=o(),Q=r("a"),Nr=o(),u(V.$$.fragment),Qr=o(),S=r("p"),S.textContent=BT,Vr=o(),O=r("p"),O.innerHTML=NT,Sr=o(),Or=r("hr"),Fr=o(),F=r("a"),Yr=o(),u(Y.$$.fragment),Wr=o(),W=r("p"),W.textContent=QT,Gr=o(),G=r("p"),G.innerHTML=VT,Xr=o(),Zr=r("hr"),ei=o(),X=r("a"),ti=o(),u(Z.$$.fragment),li=o(),ee=r("p"),ee.textContent=ST,si=o(),te=r("p"),te.innerHTML=OT,oi=o(),ni=r("hr"),ri=o(),le=r("a"),ii=o(),u(se.$$.fragment),di=o(),oe=r("p"),oe.textContent=FT,ai=o(),ne=r("p"),ne.innerHTML=YT,ui=o(),re=r("table"),re.innerHTML=WT,mi=o(),pi=r("hr"),ci=o(),ie=r("a"),fi=o(),u(de.$$.fragment),Ti=o(),ae=r("p"),ae.innerHTML=GT,hi=o(),ue=r("table"),ue.innerHTML=XT,_i=o(),$i=r("hr"),bi=o(),me=r("a"),vi=o(),u(pe.$$.fragment),yi=o(),ce=r("p"),ce.innerHTML=ZT,Mi=o(),fe=r("table"),fe.innerHTML=eh,xi=o(),Ci=r("hr"),Hi=o(),Te=r("a"),Li=o(),u(he.$$.fragment),wi=o(),_e=r("p"),_e.innerHTML=th,Ai=o(),$e=r("p"),$e.innerHTML=lh,gi=o(),be=r("ul"),be.innerHTML=sh,Pi=o(),zi=r("hr"),Ri=o(),ve=r("a"),ki=o(),u(ye.$$.fragment),Ui=o(),Me=r("p"),Me.textContent=oh,Ei=o(),xe=r("p"),xe.innerHTML=nh,ji=o(),Ji=r("hr"),Di=o(),Ce=r("a"),qi=o(),u(He.$$.fragment),Ii=o(),Le=r("p"),Le.textContent=rh,Ki=o(),we=r("p"),we.innerHTML=ih,Bi=o(),Ni=r("hr"),Qi=o(),Ae=r("a"),Vi=o(),u(ge.$$.fragment),Si=o(),Pe=r("p"),Pe.textContent=dh,Oi=o(),ze=r("p"),ze.innerHTML=ah,Fi=o(),Yi=r("hr"),Wi=o(),Re=r("a"),Gi=o(),u(ke.$$.fragment),Xi=o(),Ue=r("p"),Ue.textContent=uh,Zi=o(),Ee=r("p"),Ee.innerHTML=mh,ed=o(),je=r("table"),je.innerHTML=ph,td=o(),ld=r("hr"),sd=o(),Je=r("a"),od=o(),u(De.$$.fragment),nd=o(),qe=r("p"),qe.textContent=ch,rd=o(),Ie=r("p"),Ie.innerHTML=fh,id=o(),Ke=r("table"),Ke.innerHTML=Th,dd=o(),ad=r("hr"),ud=o(),Be=r("a"),md=o(),u(Ne.$$.fragment),pd=o(),Qe=r("p"),Qe.textContent=hh,cd=o(),Ve=r("p"),Ve.innerHTML=_h,fd=o(),Se=r("table"),Se.innerHTML=$h,Td=o(),hd=r("hr"),_d=o(),Oe=r("a"),$d=o(),u(Fe.$$.fragment),bd=o(),Ye=r("p"),Ye.textContent=bh,vd=o(),We=r("p"),We.innerHTML=vh,yd=o(),Ge=r("table"),Ge.innerHTML=yh,Md=o(),xd=r("hr"),Cd=o(),Xe=r("a"),Hd=o(),u(Ze.$$.fragment),Ld=o(),et=r("p"),et.textContent=Mh,wd=o(),tt=r("p"),tt.innerHTML=xh,Ad=o(),lt=r("table"),lt.innerHTML=Ch,gd=o(),Pd=r("hr"),zd=o(),st=r("a"),Rd=o(),u(ot.$$.fragment),kd=o(),nt=r("p"),nt.textContent=Hh,Ud=o(),rt=r("p"),rt.innerHTML=Lh,Ed=o(),it=r("table"),it.innerHTML=wh,jd=o(),Jd=r("hr"),Dd=o(),dt=r("a"),qd=o(),u(at.$$.fragment),Id=o(),ut=r("p"),ut.textContent=Ah,Kd=o(),mt=r("p"),mt.innerHTML=gh,Bd=o(),pt=r("table"),pt.innerHTML=Ph,Nd=o(),Qd=r("hr"),Vd=o(),ct=r("a"),Sd=o(),u(ft.$$.fragment),Od=o(),Tt=r("p"),Tt.textContent=zh,Fd=o(),ht=r("p"),ht.innerHTML=Rh,Yd=o(),_t=r("table"),_t.innerHTML=kh,Wd=o(),Gd=r("hr"),Xd=o(),$t=r("a"),Zd=o(),u(bt.$$.fragment),ea=o(),vt=r("p"),vt.textContent=Uh,ta=o(),yt=r("p"),yt.innerHTML=Eh,la=o(),Mt=r("table"),Mt.innerHTML=jh,sa=o(),oa=r("hr"),na=o(),xt=r("a"),ra=o(),u(Ct.$$.fragment),ia=o(),Ht=r("p"),Ht.textContent=Jh,da=o(),Lt=r("p"),Lt.innerHTML=Dh,aa=o(),wt=r("table"),wt.innerHTML=qh,ua=o(),ma=r("hr"),pa=o(),At=r("a"),ca=o(),u(gt.$$.fragment),fa=o(),Pt=r("p"),Pt.textContent=Ih,Ta=o(),zt=r("p"),zt.innerHTML=Kh,ha=o(),_a=r("hr"),$a=o(),Rt=r("a"),ba=o(),u(kt.$$.fragment),va=o(),Ut=r("p"),Ut.textContent=Bh,ya=o(),Et=r("p"),Et.textContent=Nh,Ma=o(),u(jt.$$.fragment),xa=o(),Jt=r("p"),Jt.textContent=Qh,Ca=o(),u(Dt.$$.fragment),Ha=o(),qt=r("p"),qt.textContent=Vh,La=o(),u(It.$$.fragment),wa=o(),Kt=r("p"),Kt.innerHTML=Sh,Aa=o(),Bt=r("ul"),Bt.innerHTML=Oh,ga=o(),Nt=r("table"),Nt.innerHTML=Fh,Pa=o(),za=r("hr"),Ra=o(),Qt=r("a"),ka=o(),u(Vt.$$.fragment),Ua=o(),St=r("p"),St.textContent=Yh,Ea=o(),Ot=r("p"),Ot.innerHTML=Wh,ja=o(),Ft=r("table"),Ft.innerHTML=Gh,Ja=o(),Da=r("hr"),qa=o(),Yt=r("a"),Ia=o(),u(Wt.$$.fragment),Ka=o(),Gt=r("p"),Gt.textContent=Xh,Ba=o(),Xt=r("p"),Xt.innerHTML=Zh,Na=o(),Zt=r("table"),Zt.innerHTML=e1,Qa=o(),Va=r("hr"),Sa=o(),el=r("a"),Oa=o(),u(tl.$$.fragment),Fa=o(),ll=r("p"),ll.textContent=t1,Ya=o(),sl=r("p"),sl.innerHTML=l1,Wa=o(),ol=r("table"),ol.innerHTML=s1,Ga=o(),Xa=r("hr"),Za=o(),nl=r("a"),eu=o(),u(rl.$$.fragment),tu=o(),il=r("p"),il.innerHTML=o1,lu=o(),dl=r("p"),dl.innerHTML=n1,su=o(),al=r("table"),al.innerHTML=r1,ou=o(),nu=r("hr"),ru=o(),ul=r("a"),iu=o(),u(ml.$$.fragment),du=o(),pl=r("p"),pl.innerHTML=i1,au=o(),cl=r("p"),cl.innerHTML=d1,uu=o(),fl=r("table"),fl.innerHTML=a1,mu=o(),pu=r("hr"),cu=o(),Tl=r("a"),fu=o(),u(hl.$$.fragment),Tu=o(),_l=r("p"),_l.textContent=u1,hu=o(),$l=r("p"),$l.innerHTML=m1,_u=o(),$u=r("hr"),bu=o(),bl=r("a"),vu=o(),u(vl.$$.fragment),yu=o(),yl=r("p"),yl.textContent=p1,Mu=o(),Ml=r("p"),Ml.innerHTML=c1,xu=o(),xl=r("p"),xl.innerHTML=f1,Cu=o(),Cl=r("table"),Cl.innerHTML=T1,Hu=o(),Lu=r("hr"),wu=o(),Hl=r("a"),Au=o(),u(Ll.$$.fragment),gu=o(),wl=r("p"),wl.innerHTML=h1,Pu=o(),Al=r("p"),Al.innerHTML=_1,zu=o(),Ru=r("hr"),ku=o(),gl=r("a"),Uu=o(),u(Pl.$$.fragment),Eu=o(),zl=r("p"),zl.textContent=$1,ju=o(),Rl=r("p"),Rl.textContent=b1,Ju=o(),kl=r("p"),kl.innerHTML=v1,Du=o(),Ul=r("table"),Ul.innerHTML=y1,qu=o(),Iu=r("hr"),Ku=o(),El=r("a"),Bu=o(),u(jl.$$.fragment),Nu=o(),Jl=r("p"),Jl.innerHTML=M1,Qu=o(),Dl=r("p"),Dl.innerHTML=x1,Vu=o(),Su=r("hr"),Ou=o(),ql=r("a"),Fu=o(),u(Il.$$.fragment),Yu=o(),Kl=r("p"),Kl.innerHTML=C1,Wu=o(),Bl=r("p"),Bl.innerHTML=H1,Gu=o(),Xu=r("hr"),Zu=o(),Nl=r("a"),em=o(),u(Ql.$$.fragment),tm=o(),Vl=r("p"),Vl.innerHTML=L1,lm=o(),Sl=r("p"),Sl.innerHTML=w1,sm=o(),Ol=r("table"),Ol.innerHTML=A1,om=o(),nm=r("hr"),rm=o(),Fl=r("a"),im=o(),u(Yl.$$.fragment),dm=o(),Wl=r("p"),Wl.innerHTML=g1,am=o(),Gl=r("p"),Gl.innerHTML=P1,um=o(),Xl=r("table"),Xl.innerHTML=z1,mm=o(),pm=r("hr"),cm=o(),Zl=r("a"),fm=o(),u(es.$$.fragment),Tm=o(),ts=r("p"),ts.textContent=R1,hm=o(),ls=r("p"),ls.innerHTML=k1,_m=o(),ss=r("table"),ss.innerHTML=U1,$m=o(),bm=r("hr"),vm=o(),os=r("a"),ym=o(),u(ns.$$.fragment),Mm=o(),rs=r("p"),rs.textContent=E1,xm=o(),is=r("p"),is.innerHTML=j1,Cm=o(),ds=r("table"),ds.innerHTML=J1,Hm=o(),Lm=r("hr"),wm=o(),as=r("a"),Am=o(),u(us.$$.fragment),gm=o(),ms=r("p"),ms.innerHTML=D1,Pm=o(),ps=r("p"),ps.innerHTML=q1,zm=o(),Rm=r("hr"),km=o(),cs=r("a"),Um=o(),u(fs.$$.fragment),Em=o(),Ts=r("p"),Ts.textContent=I1,jm=o(),hs=r("p"),hs.innerHTML=K1,Jm=o(),_s=r("table"),_s.innerHTML=B1,Dm=o(),qm=r("hr"),Im=o(),$s=r("a"),Km=o(),u(bs.$$.fragment),Bm=o(),vs=r("p"),vs.innerHTML=N1,Nm=o(),ys=r("p"),ys.innerHTML=Q1,Qm=o(),Vm=r("hr"),Sm=o(),Ms=r("a"),Om=o(),u(xs.$$.fragment),Fm=o(),Cs=r("p"),Cs.textContent=V1,Ym=o(),Hs=r("p"),Hs.innerHTML=S1,Wm=o(),Gm=r("hr"),Xm=o(),Ls=r("a"),Zm=o(),u(ws.$$.fragment),ep=o(),As=r("p"),As.textContent=O1,tp=o(),gs=r("p"),gs.innerHTML=F1,lp=o(),Ps=r("table"),Ps.innerHTML=Y1,sp=o(),op=r("hr"),np=o(),zs=r("a"),rp=o(),u(Rs.$$.fragment),ip=o(),ks=r("p"),ks.textContent=W1,dp=o(),Us=r("p"),Us.innerHTML=G1,ap=o(),Es=r("table"),Es.innerHTML=X1,up=o(),mp=r("hr"),pp=o(),js=r("a"),cp=o(),u(Js.$$.fragment),fp=o(),Ds=r("p"),Ds.textContent=Z1,Tp=o(),qs=r("p"),qs.innerHTML=e_,hp=o(),Is=r("table"),Is.innerHTML=t_,_p=o(),$p=r("hr"),bp=o(),Ks=r("a"),vp=o(),u(Bs.$$.fragment),yp=o(),Ns=r("p"),Ns.innerHTML=l_,Mp=o(),Qs=r("p"),Qs.innerHTML=s_,xp=o(),Vs=r("table"),Vs.innerHTML=o_,Cp=o(),Hp=r("hr"),Lp=o(),Ss=r("a"),wp=o(),u(Os.$$.fragment),Ap=o(),Fs=r("p"),Fs.innerHTML=n_,gp=o(),Ys=r("p"),Ys.innerHTML=r_,Pp=o(),Ws=r("table"),Ws.innerHTML=i_,zp=o(),Rp=r("hr"),kp=o(),Gs=r("a"),Up=o(),u(Xs.$$.fragment),Ep=o(),Zs=r("p"),Zs.innerHTML=d_,jp=o(),eo=r("p"),eo.innerHTML=a_,Jp=o(),to=r("table"),to.innerHTML=u_,Dp=o(),qp=r("hr"),Ip=o(),lo=r("a"),Kp=o(),u(so.$$.fragment),Bp=o(),oo=r("p"),oo.innerHTML=m_,Np=o(),no=r("p"),no.innerHTML=p_,Qp=o(),ro=r("table"),ro.innerHTML=c_,Vp=o(),Sp=r("hr"),Op=o(),io=r("a"),Fp=o(),u(ao.$$.fragment),Yp=o(),uo=r("p"),uo.textContent=f_,Wp=o(),mo=r("p"),mo.innerHTML=T_,Gp=o(),po=r("table"),po.innerHTML=h_,Xp=o(),Zp=r("hr"),ec=o(),co=r("a"),tc=o(),u(fo.$$.fragment),lc=o(),To=r("p"),To.textContent=__,sc=o(),ho=r("p"),ho.innerHTML=$_,oc=o(),_o=r("table"),_o.innerHTML=b_,nc=o(),rc=r("hr"),ic=o(),$o=r("a"),dc=o(),u(bo.$$.fragment),ac=o(),vo=r("p"),vo.textContent=v_,uc=o(),yo=r("p"),yo.innerHTML=y_,mc=o(),Mo=r("table"),Mo.innerHTML=M_,pc=o(),cc=r("hr"),fc=o(),xo=r("a"),Tc=o(),u(Co.$$.fragment),hc=o(),Ho=r("p"),Ho.textContent=x_,_c=o(),Lo=r("p"),Lo.innerHTML=C_,$c=o(),wo=r("table"),wo.innerHTML=H_,bc=o(),vc=r("hr"),yc=o(),Ao=r("a"),Mc=o(),u(go.$$.fragment),xc=o(),Po=r("p"),Po.textContent=L_,Cc=o(),zo=r("p"),zo.innerHTML=w_,Hc=o(),Ro=r("table"),Ro.innerHTML=A_,Lc=o(),wc=r("hr"),Ac=o(),ko=r("a"),gc=o(),u(Uo.$$.fragment),Pc=o(),Eo=r("p"),Eo.innerHTML=g_,zc=o(),jo=r("p"),jo.innerHTML=P_,Rc=o(),Jo=r("table"),Jo.innerHTML=z_,kc=o(),Uc=r("hr"),Ec=o(),Do=r("a"),jc=o(),u(qo.$$.fragment),Jc=o(),Io=r("p"),Io.textContent=R_,Dc=o(),Ko=r("p"),Ko.innerHTML=k_,qc=o(),Bo=r("table"),Bo.innerHTML=U_,Ic=o(),Kc=r("hr"),Bc=o(),No=r("a"),Nc=o(),u(Qo.$$.fragment),Qc=o(),Vo=r("p"),Vo.textContent=E_,Vc=o(),So=r("p"),So.innerHTML=j_,Sc=o(),Oo=r("table"),Oo.innerHTML=J_,Oc=o(),Fc=r("hr"),Yc=o(),Fo=r("a"),Wc=o(),u(Yo.$$.fragment),Gc=o(),Wo=r("p"),Wo.textContent=D_,Xc=o(),Go=r("p"),Go.innerHTML=q_,Zc=o(),Xo=r("table"),Xo.innerHTML=I_,ef=o(),tf=r("hr"),lf=o(),Zo=r("a"),sf=o(),u(en.$$.fragment),of=o(),tn=r("p"),tn.textContent=K_,nf=o(),ln=r("p"),ln.innerHTML=B_,rf=o(),sn=r("table"),sn.innerHTML=N_,df=o(),af=r("hr"),uf=o(),on=r("a"),mf=o(),u(nn.$$.fragment),pf=o(),rn=r("p"),rn.textContent=Q_,cf=o(),dn=r("p"),dn.innerHTML=V_,ff=o(),an=r("table"),an.innerHTML=S_,Tf=o(),hf=r("hr"),_f=o(),un=r("a"),$f=o(),u(mn.$$.fragment),bf=o(),pn=r("p"),pn.textContent=O_,vf=o(),cn=r("p"),cn.innerHTML=F_,yf=o(),fn=r("table"),fn.innerHTML=Y_,Mf=o(),xf=r("hr"),Cf=o(),Tn=r("a"),Hf=o(),u(hn.$$.fragment),Lf=o(),_n=r("p"),_n.textContent=W_,wf=o(),$n=r("p"),$n.innerHTML=G_,Af=o(),bn=r("table"),bn.innerHTML=X_,gf=o(),Pf=r("hr"),zf=o(),vn=r("a"),Rf=o(),u(yn.$$.fragment),kf=o(),Mn=r("p"),Mn.textContent=Z_,Uf=o(),xn=r("p"),xn.innerHTML=e$,Ef=o(),Cn=r("table"),Cn.innerHTML=t$,jf=o(),Jf=r("hr"),Df=o(),Hn=r("a"),qf=o(),u(Ln.$$.fragment),If=o(),wn=r("p"),wn.innerHTML=l$,Kf=o(),Bf=r("hr"),Nf=o(),An=r("a"),Qf=o(),u(gn.$$.fragment),Vf=o(),Pn=r("p"),Pn.textContent=s$,Sf=o(),zn=r("p"),zn.innerHTML=o$,Of=o(),Rn=r("table"),Rn.innerHTML=n$,Ff=o(),kn=r("p"),kn.innerHTML=r$,Yf=o(),u(Un.$$.fragment),Wf=o(),Gf=r("hr"),Xf=o(),En=r("a"),Zf=o(),u(jn.$$.fragment),eT=o(),Jn=r("p"),Jn.innerHTML=i$,tT=o(),lT=r("hr"),sT=o(),Dn=r("a"),oT=o(),u(qn.$$.fragment),nT=o(),In=r("p"),In.innerHTML=d$,rT=o(),Kn=r("table"),Kn.innerHTML=a$,iT=o(),dT=r("hr"),aT=o(),Bn=r("a"),uT=o(),u(Nn.$$.fragment),mT=o(),Qn=r("p"),Qn.innerHTML=u$,pT=o(),cT=r("hr"),fT=o(),Vn=r("a"),TT=o(),u(Sn.$$.fragment),hT=o(),On=r("p"),On.textContent=m$,_T=o(),Fn=r("p"),Fn.innerHTML=p$,$T=o(),u(Yn.$$.fragment),bT=o(),Wn=r("p"),Wn.innerHTML=c$,vT=o(),u(Gn.$$.fragment),yT=o(),Xn=r("p"),Xn.innerHTML=f$,MT=o(),u(Zn.$$.fragment),xT=o(),CT=r("hr"),HT=o(),u(er.$$.fragment),LT=o(),sr=r("p"),this.h()},l(e){const t=v$("svelte-u9bgzb",document.head);$=i(t,"META",{name:!0,content:!0}),t.forEach(l),or=n(e),lr=i(e,"P",{}),h(lr).forEach(l),nr=n(e),b=i(e,"A",{id:!0,class:!0}),h(b).forEach(l),rr=n(e),m(v.$$.fragment,e),ir=n(e),y=i(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-uw4y1m"&&(y.innerHTML=gT),dr=n(e),M=i(e,"P",{"data-svelte-h":!0}),d(M)!=="svelte-il3kl8"&&(M.textContent=PT),ar=n(e),x=i(e,"UL",{"data-svelte-h":!0}),d(x)!=="svelte-1w60b35"&&(x.innerHTML=zT),ur=n(e),mr=i(e,"HR",{}),pr=n(e),C=i(e,"A",{id:!0,class:!0}),h(C).forEach(l),cr=n(e),m(H.$$.fragment,e),fr=n(e),L=i(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1ugrfrw"&&(L.innerHTML=RT),Tr=n(e),w=i(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-mralx4"&&(w.innerHTML=kT),hr=n(e),_r=i(e,"HR",{}),$r=n(e),A=i(e,"A",{id:!0,class:!0}),h(A).forEach(l),br=n(e),m(g.$$.fragment,e),vr=n(e),P=i(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-55wecd"&&(P.textContent=UT),yr=n(e),z=i(e,"TABLE",{"data-svelte-h":!0}),d(z)!=="svelte-ee7emz"&&(z.innerHTML=ET),Mr=n(e),xr=i(e,"HR",{}),Cr=n(e),R=i(e,"A",{id:!0,class:!0}),h(R).forEach(l),Hr=n(e),m(k.$$.fragment,e),Lr=n(e),U=i(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1gc2rt4"&&(U.textContent=jT),wr=n(e),E=i(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-10qzguj"&&(E.innerHTML=JT),Ar=n(e),gr=i(e,"HR",{}),Pr=n(e),j=i(e,"A",{id:!0,class:!0}),h(j).forEach(l),zr=n(e),m(J.$$.fragment,e),Rr=n(e),D=i(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-81y0bb"&&(D.textContent=DT),kr=n(e),q=i(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-10qzguj"&&(q.innerHTML=qT),Ur=n(e),Er=i(e,"HR",{}),jr=n(e),I=i(e,"A",{id:!0,class:!0}),h(I).forEach(l),Jr=n(e),m(K.$$.fragment,e),Dr=n(e),B=i(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1eqabt7"&&(B.textContent=IT),qr=n(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-10qzguj"&&(N.innerHTML=KT),Ir=n(e),Kr=i(e,"HR",{}),Br=n(e),Q=i(e,"A",{id:!0,class:!0}),h(Q).forEach(l),Nr=n(e),m(V.$$.fragment,e),Qr=n(e),S=i(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-krrt97"&&(S.textContent=BT),Vr=n(e),O=i(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-10qzguj"&&(O.innerHTML=NT),Sr=n(e),Or=i(e,"HR",{}),Fr=n(e),F=i(e,"A",{id:!0,class:!0}),h(F).forEach(l),Yr=n(e),m(Y.$$.fragment,e),Wr=n(e),W=i(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1iaptgl"&&(W.textContent=QT),Gr=n(e),G=i(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-10qzguj"&&(G.innerHTML=VT),Xr=n(e),Zr=i(e,"HR",{}),ei=n(e),X=i(e,"A",{id:!0,class:!0}),h(X).forEach(l),ti=n(e),m(Z.$$.fragment,e),li=n(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1adn56z"&&(ee.textContent=ST),si=n(e),te=i(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1gxgvk6"&&(te.innerHTML=OT),oi=n(e),ni=i(e,"HR",{}),ri=n(e),le=i(e,"A",{id:!0,class:!0}),h(le).forEach(l),ii=n(e),m(se.$$.fragment,e),di=n(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1u97xg1"&&(oe.textContent=FT),ai=n(e),ne=i(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1fs0j1e"&&(ne.innerHTML=YT),ui=n(e),re=i(e,"TABLE",{"data-svelte-h":!0}),d(re)!=="svelte-1kq04ga"&&(re.innerHTML=WT),mi=n(e),pi=i(e,"HR",{}),ci=n(e),ie=i(e,"A",{id:!0,class:!0}),h(ie).forEach(l),fi=n(e),m(de.$$.fragment,e),Ti=n(e),ae=i(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1cg22af"&&(ae.innerHTML=GT),hi=n(e),ue=i(e,"TABLE",{"data-svelte-h":!0}),d(ue)!=="svelte-1hful42"&&(ue.innerHTML=XT),_i=n(e),$i=i(e,"HR",{}),bi=n(e),me=i(e,"A",{id:!0,class:!0}),h(me).forEach(l),vi=n(e),m(pe.$$.fragment,e),yi=n(e),ce=i(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1mr58c3"&&(ce.innerHTML=ZT),Mi=n(e),fe=i(e,"TABLE",{"data-svelte-h":!0}),d(fe)!=="svelte-153ftfy"&&(fe.innerHTML=eh),xi=n(e),Ci=i(e,"HR",{}),Hi=n(e),Te=i(e,"A",{id:!0,class:!0}),h(Te).forEach(l),Li=n(e),m(he.$$.fragment,e),wi=n(e),_e=i(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-13nzfs3"&&(_e.innerHTML=th),Ai=n(e),$e=i(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-11rv1mu"&&($e.innerHTML=lh),gi=n(e),be=i(e,"UL",{"data-svelte-h":!0}),d(be)!=="svelte-5t2sg3"&&(be.innerHTML=sh),Pi=n(e),zi=i(e,"HR",{}),Ri=n(e),ve=i(e,"A",{id:!0,class:!0}),h(ve).forEach(l),ki=n(e),m(ye.$$.fragment,e),Ui=n(e),Me=i(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-87xdyr"&&(Me.textContent=oh),Ei=n(e),xe=i(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-1mr58c3"&&(xe.innerHTML=nh),ji=n(e),Ji=i(e,"HR",{}),Di=n(e),Ce=i(e,"A",{id:!0,class:!0}),h(Ce).forEach(l),qi=n(e),m(He.$$.fragment,e),Ii=n(e),Le=i(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-2wti2w"&&(Le.textContent=rh),Ki=n(e),we=i(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1y8z3p1"&&(we.innerHTML=ih),Bi=n(e),Ni=i(e,"HR",{}),Qi=n(e),Ae=i(e,"A",{id:!0,class:!0}),h(Ae).forEach(l),Vi=n(e),m(ge.$$.fragment,e),Si=n(e),Pe=i(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1edu6c8"&&(Pe.textContent=dh),Oi=n(e),ze=i(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1t595qz"&&(ze.innerHTML=ah),Fi=n(e),Yi=i(e,"HR",{}),Wi=n(e),Re=i(e,"A",{id:!0,class:!0}),h(Re).forEach(l),Gi=n(e),m(ke.$$.fragment,e),Xi=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-az0crx"&&(Ue.textContent=uh),Zi=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-w5myiy"&&(Ee.innerHTML=mh),ed=n(e),je=i(e,"TABLE",{"data-svelte-h":!0}),d(je)!=="svelte-1ok4yhn"&&(je.innerHTML=ph),td=n(e),ld=i(e,"HR",{}),sd=n(e),Je=i(e,"A",{id:!0,class:!0}),h(Je).forEach(l),od=n(e),m(De.$$.fragment,e),nd=n(e),qe=i(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-jlfq15"&&(qe.textContent=ch),rd=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1t595qz"&&(Ie.innerHTML=fh),id=n(e),Ke=i(e,"TABLE",{"data-svelte-h":!0}),d(Ke)!=="svelte-1ok4yhn"&&(Ke.innerHTML=Th),dd=n(e),ad=i(e,"HR",{}),ud=n(e),Be=i(e,"A",{id:!0,class:!0}),h(Be).forEach(l),md=n(e),m(Ne.$$.fragment,e),pd=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-xg80lg"&&(Qe.textContent=hh),cd=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-9qu32j"&&(Ve.innerHTML=_h),fd=n(e),Se=i(e,"TABLE",{"data-svelte-h":!0}),d(Se)!=="svelte-1tbtmqd"&&(Se.innerHTML=$h),Td=n(e),hd=i(e,"HR",{}),_d=n(e),Oe=i(e,"A",{id:!0,class:!0}),h(Oe).forEach(l),$d=n(e),m(Fe.$$.fragment,e),bd=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1i12x1s"&&(Ye.textContent=bh),vd=n(e),We=i(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1t595qz"&&(We.innerHTML=vh),yd=n(e),Ge=i(e,"TABLE",{"data-svelte-h":!0}),d(Ge)!=="svelte-1tbtmqd"&&(Ge.innerHTML=yh),Md=n(e),xd=i(e,"HR",{}),Cd=n(e),Xe=i(e,"A",{id:!0,class:!0}),h(Xe).forEach(l),Hd=n(e),m(Ze.$$.fragment,e),Ld=n(e),et=i(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-45kvaw"&&(et.textContent=Mh),wd=n(e),tt=i(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-9qu32j"&&(tt.innerHTML=xh),Ad=n(e),lt=i(e,"TABLE",{"data-svelte-h":!0}),d(lt)!=="svelte-46t58i"&&(lt.innerHTML=Ch),gd=n(e),Pd=i(e,"HR",{}),zd=n(e),st=i(e,"A",{id:!0,class:!0}),h(st).forEach(l),Rd=n(e),m(ot.$$.fragment,e),kd=n(e),nt=i(e,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-6s524n"&&(nt.textContent=Hh),Ud=n(e),rt=i(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1t595qz"&&(rt.innerHTML=Lh),Ed=n(e),it=i(e,"TABLE",{"data-svelte-h":!0}),d(it)!=="svelte-46t58i"&&(it.innerHTML=wh),jd=n(e),Jd=i(e,"HR",{}),Dd=n(e),dt=i(e,"A",{id:!0,class:!0}),h(dt).forEach(l),qd=n(e),m(at.$$.fragment,e),Id=n(e),ut=i(e,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-1hl64jn"&&(ut.textContent=Ah),Kd=n(e),mt=i(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-9qu32j"&&(mt.innerHTML=gh),Bd=n(e),pt=i(e,"TABLE",{"data-svelte-h":!0}),d(pt)!=="svelte-1p5444"&&(pt.innerHTML=Ph),Nd=n(e),Qd=i(e,"HR",{}),Vd=n(e),ct=i(e,"A",{id:!0,class:!0}),h(ct).forEach(l),Sd=n(e),m(ft.$$.fragment,e),Od=n(e),Tt=i(e,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-bbf4x3"&&(Tt.textContent=zh),Fd=n(e),ht=i(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1t595qz"&&(ht.innerHTML=Rh),Yd=n(e),_t=i(e,"TABLE",{"data-svelte-h":!0}),d(_t)!=="svelte-1p5444"&&(_t.innerHTML=kh),Wd=n(e),Gd=i(e,"HR",{}),Xd=n(e),$t=i(e,"A",{id:!0,class:!0}),h($t).forEach(l),Zd=n(e),m(bt.$$.fragment,e),ea=n(e),vt=i(e,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-wbrx6g"&&(vt.textContent=Uh),ta=n(e),yt=i(e,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-9qu32j"&&(yt.innerHTML=Eh),la=n(e),Mt=i(e,"TABLE",{"data-svelte-h":!0}),d(Mt)!=="svelte-flm2g1"&&(Mt.innerHTML=jh),sa=n(e),oa=i(e,"HR",{}),na=n(e),xt=i(e,"A",{id:!0,class:!0}),h(xt).forEach(l),ra=n(e),m(Ct.$$.fragment,e),ia=n(e),Ht=i(e,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-wqxtec"&&(Ht.textContent=Jh),da=n(e),Lt=i(e,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1t595qz"&&(Lt.innerHTML=Dh),aa=n(e),wt=i(e,"TABLE",{"data-svelte-h":!0}),d(wt)!=="svelte-flm2g1"&&(wt.innerHTML=qh),ua=n(e),ma=i(e,"HR",{}),pa=n(e),At=i(e,"A",{id:!0,class:!0}),h(At).forEach(l),ca=n(e),m(gt.$$.fragment,e),fa=n(e),Pt=i(e,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-zftqbb"&&(Pt.textContent=Ih),Ta=n(e),zt=i(e,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-1mgj1au"&&(zt.innerHTML=Kh),ha=n(e),_a=i(e,"HR",{}),$a=n(e),Rt=i(e,"A",{id:!0,class:!0}),h(Rt).forEach(l),ba=n(e),m(kt.$$.fragment,e),va=n(e),Ut=i(e,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-yalim1"&&(Ut.textContent=Bh),ya=n(e),Et=i(e,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-v4sb1d"&&(Et.textContent=Nh),Ma=n(e),m(jt.$$.fragment,e),xa=n(e),Jt=i(e,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-1qggjsc"&&(Jt.textContent=Qh),Ca=n(e),m(Dt.$$.fragment,e),Ha=n(e),qt=i(e,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-gtrr4w"&&(qt.textContent=Vh),La=n(e),m(It.$$.fragment,e),wa=n(e),Kt=i(e,"P",{"data-svelte-h":!0}),d(Kt)!=="svelte-15hbb4u"&&(Kt.innerHTML=Sh),Aa=n(e),Bt=i(e,"UL",{"data-svelte-h":!0}),d(Bt)!=="svelte-2ixnrf"&&(Bt.innerHTML=Oh),ga=n(e),Nt=i(e,"TABLE",{"data-svelte-h":!0}),d(Nt)!=="svelte-xutatr"&&(Nt.innerHTML=Fh),Pa=n(e),za=i(e,"HR",{}),Ra=n(e),Qt=i(e,"A",{id:!0,class:!0}),h(Qt).forEach(l),ka=n(e),m(Vt.$$.fragment,e),Ua=n(e),St=i(e,"P",{"data-svelte-h":!0}),d(St)!=="svelte-1g8ouql"&&(St.textContent=Yh),Ea=n(e),Ot=i(e,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-19cc47x"&&(Ot.innerHTML=Wh),ja=n(e),Ft=i(e,"TABLE",{"data-svelte-h":!0}),d(Ft)!=="svelte-1p49qvp"&&(Ft.innerHTML=Gh),Ja=n(e),Da=i(e,"HR",{}),qa=n(e),Yt=i(e,"A",{id:!0,class:!0}),h(Yt).forEach(l),Ia=n(e),m(Wt.$$.fragment,e),Ka=n(e),Gt=i(e,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-yjryb1"&&(Gt.textContent=Xh),Ba=n(e),Xt=i(e,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-xtr8tc"&&(Xt.innerHTML=Zh),Na=n(e),Zt=i(e,"TABLE",{"data-svelte-h":!0}),d(Zt)!=="svelte-6xvdso"&&(Zt.innerHTML=e1),Qa=n(e),Va=i(e,"HR",{}),Sa=n(e),el=i(e,"A",{id:!0,class:!0}),h(el).forEach(l),Oa=n(e),m(tl.$$.fragment,e),Fa=n(e),ll=i(e,"P",{"data-svelte-h":!0}),d(ll)!=="svelte-1okfsqx"&&(ll.textContent=t1),Ya=n(e),sl=i(e,"P",{"data-svelte-h":!0}),d(sl)!=="svelte-bqi4bh"&&(sl.innerHTML=l1),Wa=n(e),ol=i(e,"TABLE",{"data-svelte-h":!0}),d(ol)!=="svelte-13m2wni"&&(ol.innerHTML=s1),Ga=n(e),Xa=i(e,"HR",{}),Za=n(e),nl=i(e,"A",{id:!0,class:!0}),h(nl).forEach(l),eu=n(e),m(rl.$$.fragment,e),tu=n(e),il=i(e,"P",{"data-svelte-h":!0}),d(il)!=="svelte-1htpbrk"&&(il.innerHTML=o1),lu=n(e),dl=i(e,"P",{"data-svelte-h":!0}),d(dl)!=="svelte-13o8e7b"&&(dl.innerHTML=n1),su=n(e),al=i(e,"TABLE",{"data-svelte-h":!0}),d(al)!=="svelte-1qi99pl"&&(al.innerHTML=r1),ou=n(e),nu=i(e,"HR",{}),ru=n(e),ul=i(e,"A",{id:!0,class:!0}),h(ul).forEach(l),iu=n(e),m(ml.$$.fragment,e),du=n(e),pl=i(e,"P",{"data-svelte-h":!0}),d(pl)!=="svelte-1ztgqp"&&(pl.innerHTML=i1),au=n(e),cl=i(e,"P",{"data-svelte-h":!0}),d(cl)!=="svelte-oa1qug"&&(cl.innerHTML=d1),uu=n(e),fl=i(e,"TABLE",{"data-svelte-h":!0}),d(fl)!=="svelte-1qi99pl"&&(fl.innerHTML=a1),mu=n(e),pu=i(e,"HR",{}),cu=n(e),Tl=i(e,"A",{id:!0,class:!0}),h(Tl).forEach(l),fu=n(e),m(hl.$$.fragment,e),Tu=n(e),_l=i(e,"P",{"data-svelte-h":!0}),d(_l)!=="svelte-1a7u185"&&(_l.textContent=u1),hu=n(e),$l=i(e,"P",{"data-svelte-h":!0}),d($l)!=="svelte-1eu3doh"&&($l.innerHTML=m1),_u=n(e),$u=i(e,"HR",{}),bu=n(e),bl=i(e,"A",{id:!0,class:!0}),h(bl).forEach(l),vu=n(e),m(vl.$$.fragment,e),yu=n(e),yl=i(e,"P",{"data-svelte-h":!0}),d(yl)!=="svelte-qls17b"&&(yl.textContent=p1),Mu=n(e),Ml=i(e,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-5nabmy"&&(Ml.innerHTML=c1),xu=n(e),xl=i(e,"P",{"data-svelte-h":!0}),d(xl)!=="svelte-1fl56ed"&&(xl.innerHTML=f1),Cu=n(e),Cl=i(e,"TABLE",{"data-svelte-h":!0}),d(Cl)!=="svelte-16crpd3"&&(Cl.innerHTML=T1),Hu=n(e),Lu=i(e,"HR",{}),wu=n(e),Hl=i(e,"A",{id:!0,class:!0}),h(Hl).forEach(l),Au=n(e),m(Ll.$$.fragment,e),gu=n(e),wl=i(e,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-19w0pic"&&(wl.innerHTML=h1),Pu=n(e),Al=i(e,"P",{"data-svelte-h":!0}),d(Al)!=="svelte-1mr58c3"&&(Al.innerHTML=_1),zu=n(e),Ru=i(e,"HR",{}),ku=n(e),gl=i(e,"A",{id:!0,class:!0}),h(gl).forEach(l),Uu=n(e),m(Pl.$$.fragment,e),Eu=n(e),zl=i(e,"P",{"data-svelte-h":!0}),d(zl)!=="svelte-18ws76n"&&(zl.textContent=$1),ju=n(e),Rl=i(e,"P",{"data-svelte-h":!0}),d(Rl)!=="svelte-1tnr5gm"&&(Rl.textContent=b1),Ju=n(e),kl=i(e,"P",{"data-svelte-h":!0}),d(kl)!=="svelte-13m9nag"&&(kl.innerHTML=v1),Du=n(e),Ul=i(e,"TABLE",{"data-svelte-h":!0}),d(Ul)!=="svelte-1u9lyxp"&&(Ul.innerHTML=y1),qu=n(e),Iu=i(e,"HR",{}),Ku=n(e),El=i(e,"A",{id:!0,class:!0}),h(El).forEach(l),Bu=n(e),m(jl.$$.fragment,e),Nu=n(e),Jl=i(e,"P",{"data-svelte-h":!0}),d(Jl)!=="svelte-1b9ygao"&&(Jl.innerHTML=M1),Qu=n(e),Dl=i(e,"P",{"data-svelte-h":!0}),d(Dl)!=="svelte-1mr58c3"&&(Dl.innerHTML=x1),Vu=n(e),Su=i(e,"HR",{}),Ou=n(e),ql=i(e,"A",{id:!0,class:!0}),h(ql).forEach(l),Fu=n(e),m(Il.$$.fragment,e),Yu=n(e),Kl=i(e,"P",{"data-svelte-h":!0}),d(Kl)!=="svelte-1vkr5xo"&&(Kl.innerHTML=C1),Wu=n(e),Bl=i(e,"P",{"data-svelte-h":!0}),d(Bl)!=="svelte-1mr58c3"&&(Bl.innerHTML=H1),Gu=n(e),Xu=i(e,"HR",{}),Zu=n(e),Nl=i(e,"A",{id:!0,class:!0}),h(Nl).forEach(l),em=n(e),m(Ql.$$.fragment,e),tm=n(e),Vl=i(e,"P",{"data-svelte-h":!0}),d(Vl)!=="svelte-1gguudf"&&(Vl.innerHTML=L1),lm=n(e),Sl=i(e,"P",{"data-svelte-h":!0}),d(Sl)!=="svelte-1vf2xxu"&&(Sl.innerHTML=w1),sm=n(e),Ol=i(e,"TABLE",{"data-svelte-h":!0}),d(Ol)!=="svelte-z6whez"&&(Ol.innerHTML=A1),om=n(e),nm=i(e,"HR",{}),rm=n(e),Fl=i(e,"A",{id:!0,class:!0}),h(Fl).forEach(l),im=n(e),m(Yl.$$.fragment,e),dm=n(e),Wl=i(e,"P",{"data-svelte-h":!0}),d(Wl)!=="svelte-d6gvut"&&(Wl.innerHTML=g1),am=n(e),Gl=i(e,"P",{"data-svelte-h":!0}),d(Gl)!=="svelte-1ueenyl"&&(Gl.innerHTML=P1),um=n(e),Xl=i(e,"TABLE",{"data-svelte-h":!0}),d(Xl)!=="svelte-jj58dd"&&(Xl.innerHTML=z1),mm=n(e),pm=i(e,"HR",{}),cm=n(e),Zl=i(e,"A",{id:!0,class:!0}),h(Zl).forEach(l),fm=n(e),m(es.$$.fragment,e),Tm=n(e),ts=i(e,"P",{"data-svelte-h":!0}),d(ts)!=="svelte-1tydf2w"&&(ts.textContent=R1),hm=n(e),ls=i(e,"P",{"data-svelte-h":!0}),d(ls)!=="svelte-m0druy"&&(ls.innerHTML=k1),_m=n(e),ss=i(e,"TABLE",{"data-svelte-h":!0}),d(ss)!=="svelte-nwcu77"&&(ss.innerHTML=U1),$m=n(e),bm=i(e,"HR",{}),vm=n(e),os=i(e,"A",{id:!0,class:!0}),h(os).forEach(l),ym=n(e),m(ns.$$.fragment,e),Mm=n(e),rs=i(e,"P",{"data-svelte-h":!0}),d(rs)!=="svelte-j2lp5o"&&(rs.textContent=E1),xm=n(e),is=i(e,"P",{"data-svelte-h":!0}),d(is)!=="svelte-b96ihv"&&(is.innerHTML=j1),Cm=n(e),ds=i(e,"TABLE",{"data-svelte-h":!0}),d(ds)!=="svelte-nwcu77"&&(ds.innerHTML=J1),Hm=n(e),Lm=i(e,"HR",{}),wm=n(e),as=i(e,"A",{id:!0,class:!0}),h(as).forEach(l),Am=n(e),m(us.$$.fragment,e),gm=n(e),ms=i(e,"P",{"data-svelte-h":!0}),d(ms)!=="svelte-1adolpg"&&(ms.innerHTML=D1),Pm=n(e),ps=i(e,"P",{"data-svelte-h":!0}),d(ps)!=="svelte-1mr58c3"&&(ps.innerHTML=q1),zm=n(e),Rm=i(e,"HR",{}),km=n(e),cs=i(e,"A",{id:!0,class:!0}),h(cs).forEach(l),Um=n(e),m(fs.$$.fragment,e),Em=n(e),Ts=i(e,"P",{"data-svelte-h":!0}),d(Ts)!=="svelte-1hm8vtj"&&(Ts.textContent=I1),jm=n(e),hs=i(e,"P",{"data-svelte-h":!0}),d(hs)!=="svelte-1mnx14"&&(hs.innerHTML=K1),Jm=n(e),_s=i(e,"TABLE",{"data-svelte-h":!0}),d(_s)!=="svelte-9ff0sy"&&(_s.innerHTML=B1),Dm=n(e),qm=i(e,"HR",{}),Im=n(e),$s=i(e,"A",{id:!0,class:!0}),h($s).forEach(l),Km=n(e),m(bs.$$.fragment,e),Bm=n(e),vs=i(e,"P",{"data-svelte-h":!0}),d(vs)!=="svelte-1e6kzks"&&(vs.innerHTML=N1),Nm=n(e),ys=i(e,"P",{"data-svelte-h":!0}),d(ys)!=="svelte-1mr58c3"&&(ys.innerHTML=Q1),Qm=n(e),Vm=i(e,"HR",{}),Sm=n(e),Ms=i(e,"A",{id:!0,class:!0}),h(Ms).forEach(l),Om=n(e),m(xs.$$.fragment,e),Fm=n(e),Cs=i(e,"P",{"data-svelte-h":!0}),d(Cs)!=="svelte-t5k6jp"&&(Cs.textContent=V1),Ym=n(e),Hs=i(e,"P",{"data-svelte-h":!0}),d(Hs)!=="svelte-1mnx14"&&(Hs.innerHTML=S1),Wm=n(e),Gm=i(e,"HR",{}),Xm=n(e),Ls=i(e,"A",{id:!0,class:!0}),h(Ls).forEach(l),Zm=n(e),m(ws.$$.fragment,e),ep=n(e),As=i(e,"P",{"data-svelte-h":!0}),d(As)!=="svelte-avw2a1"&&(As.textContent=O1),tp=n(e),gs=i(e,"P",{"data-svelte-h":!0}),d(gs)!=="svelte-3w87vv"&&(gs.innerHTML=F1),lp=n(e),Ps=i(e,"TABLE",{"data-svelte-h":!0}),d(Ps)!=="svelte-jj5vaa"&&(Ps.innerHTML=Y1),sp=n(e),op=i(e,"HR",{}),np=n(e),zs=i(e,"A",{id:!0,class:!0}),h(zs).forEach(l),rp=n(e),m(Rs.$$.fragment,e),ip=n(e),ks=i(e,"P",{"data-svelte-h":!0}),d(ks)!=="svelte-167n5bd"&&(ks.textContent=W1),dp=n(e),Us=i(e,"P",{"data-svelte-h":!0}),d(Us)!=="svelte-74oixn"&&(Us.innerHTML=G1),ap=n(e),Es=i(e,"TABLE",{"data-svelte-h":!0}),d(Es)!=="svelte-1oyadc3"&&(Es.innerHTML=X1),up=n(e),mp=i(e,"HR",{}),pp=n(e),js=i(e,"A",{id:!0,class:!0}),h(js).forEach(l),cp=n(e),m(Js.$$.fragment,e),fp=n(e),Ds=i(e,"P",{"data-svelte-h":!0}),d(Ds)!=="svelte-fju8tm"&&(Ds.textContent=Z1),Tp=n(e),qs=i(e,"P",{"data-svelte-h":!0}),d(qs)!=="svelte-16503uw"&&(qs.innerHTML=e_),hp=n(e),Is=i(e,"TABLE",{"data-svelte-h":!0}),d(Is)!=="svelte-1no2z7v"&&(Is.innerHTML=t_),_p=n(e),$p=i(e,"HR",{}),bp=n(e),Ks=i(e,"A",{id:!0,class:!0}),h(Ks).forEach(l),vp=n(e),m(Bs.$$.fragment,e),yp=n(e),Ns=i(e,"P",{"data-svelte-h":!0}),d(Ns)!=="svelte-18v04la"&&(Ns.innerHTML=l_),Mp=n(e),Qs=i(e,"P",{"data-svelte-h":!0}),d(Qs)!=="svelte-14kv4rj"&&(Qs.innerHTML=s_),xp=n(e),Vs=i(e,"TABLE",{"data-svelte-h":!0}),d(Vs)!=="svelte-1almd9d"&&(Vs.innerHTML=o_),Cp=n(e),Hp=i(e,"HR",{}),Lp=n(e),Ss=i(e,"A",{id:!0,class:!0}),h(Ss).forEach(l),wp=n(e),m(Os.$$.fragment,e),Ap=n(e),Fs=i(e,"P",{"data-svelte-h":!0}),d(Fs)!=="svelte-1yvow13"&&(Fs.innerHTML=n_),gp=n(e),Ys=i(e,"P",{"data-svelte-h":!0}),d(Ys)!=="svelte-fexugp"&&(Ys.innerHTML=r_),Pp=n(e),Ws=i(e,"TABLE",{"data-svelte-h":!0}),d(Ws)!=="svelte-1t0kp7i"&&(Ws.innerHTML=i_),zp=n(e),Rp=i(e,"HR",{}),kp=n(e),Gs=i(e,"A",{id:!0,class:!0}),h(Gs).forEach(l),Up=n(e),m(Xs.$$.fragment,e),Ep=n(e),Zs=i(e,"P",{"data-svelte-h":!0}),d(Zs)!=="svelte-19dtamh"&&(Zs.innerHTML=d_),jp=n(e),eo=i(e,"P",{"data-svelte-h":!0}),d(eo)!=="svelte-1q9jl83"&&(eo.innerHTML=a_),Jp=n(e),to=i(e,"TABLE",{"data-svelte-h":!0}),d(to)!=="svelte-po861j"&&(to.innerHTML=u_),Dp=n(e),qp=i(e,"HR",{}),Ip=n(e),lo=i(e,"A",{id:!0,class:!0}),h(lo).forEach(l),Kp=n(e),m(so.$$.fragment,e),Bp=n(e),oo=i(e,"P",{"data-svelte-h":!0}),d(oo)!=="svelte-bd7moq"&&(oo.innerHTML=m_),Np=n(e),no=i(e,"P",{"data-svelte-h":!0}),d(no)!=="svelte-jyg3bg"&&(no.innerHTML=p_),Qp=n(e),ro=i(e,"TABLE",{"data-svelte-h":!0}),d(ro)!=="svelte-15nix8z"&&(ro.innerHTML=c_),Vp=n(e),Sp=i(e,"HR",{}),Op=n(e),io=i(e,"A",{id:!0,class:!0}),h(io).forEach(l),Fp=n(e),m(ao.$$.fragment,e),Yp=n(e),uo=i(e,"P",{"data-svelte-h":!0}),d(uo)!=="svelte-9z0ni1"&&(uo.textContent=f_),Wp=n(e),mo=i(e,"P",{"data-svelte-h":!0}),d(mo)!=="svelte-av0ptf"&&(mo.innerHTML=T_),Gp=n(e),po=i(e,"TABLE",{"data-svelte-h":!0}),d(po)!=="svelte-1bqi98p"&&(po.innerHTML=h_),Xp=n(e),Zp=i(e,"HR",{}),ec=n(e),co=i(e,"A",{id:!0,class:!0}),h(co).forEach(l),tc=n(e),m(fo.$$.fragment,e),lc=n(e),To=i(e,"P",{"data-svelte-h":!0}),d(To)!=="svelte-11ei68w"&&(To.textContent=__),sc=n(e),ho=i(e,"P",{"data-svelte-h":!0}),d(ho)!=="svelte-f0cseu"&&(ho.innerHTML=$_),oc=n(e),_o=i(e,"TABLE",{"data-svelte-h":!0}),d(_o)!=="svelte-1lgev2y"&&(_o.innerHTML=b_),nc=n(e),rc=i(e,"HR",{}),ic=n(e),$o=i(e,"A",{id:!0,class:!0}),h($o).forEach(l),dc=n(e),m(bo.$$.fragment,e),ac=n(e),vo=i(e,"P",{"data-svelte-h":!0}),d(vo)!=="svelte-7ivim4"&&(vo.textContent=v_),uc=n(e),yo=i(e,"P",{"data-svelte-h":!0}),d(yo)!=="svelte-1t7ypd0"&&(yo.innerHTML=y_),mc=n(e),Mo=i(e,"TABLE",{"data-svelte-h":!0}),d(Mo)!=="svelte-1lmecr"&&(Mo.innerHTML=M_),pc=n(e),cc=i(e,"HR",{}),fc=n(e),xo=i(e,"A",{id:!0,class:!0}),h(xo).forEach(l),Tc=n(e),m(Co.$$.fragment,e),hc=n(e),Ho=i(e,"P",{"data-svelte-h":!0}),d(Ho)!=="svelte-k6p1db"&&(Ho.textContent=x_),_c=n(e),Lo=i(e,"P",{"data-svelte-h":!0}),d(Lo)!=="svelte-6qi3ne"&&(Lo.innerHTML=C_),$c=n(e),wo=i(e,"TABLE",{"data-svelte-h":!0}),d(wo)!=="svelte-2flruf"&&(wo.innerHTML=H_),bc=n(e),vc=i(e,"HR",{}),yc=n(e),Ao=i(e,"A",{id:!0,class:!0}),h(Ao).forEach(l),Mc=n(e),m(go.$$.fragment,e),xc=n(e),Po=i(e,"P",{"data-svelte-h":!0}),d(Po)!=="svelte-8afo9v"&&(Po.textContent=L_),Cc=n(e),zo=i(e,"P",{"data-svelte-h":!0}),d(zo)!=="svelte-fnpm0s"&&(zo.innerHTML=w_),Hc=n(e),Ro=i(e,"TABLE",{"data-svelte-h":!0}),d(Ro)!=="svelte-1m3fin1"&&(Ro.innerHTML=A_),Lc=n(e),wc=i(e,"HR",{}),Ac=n(e),ko=i(e,"A",{id:!0,class:!0}),h(ko).forEach(l),gc=n(e),m(Uo.$$.fragment,e),Pc=n(e),Eo=i(e,"P",{"data-svelte-h":!0}),d(Eo)!=="svelte-11plveb"&&(Eo.innerHTML=g_),zc=n(e),jo=i(e,"P",{"data-svelte-h":!0}),d(jo)!=="svelte-1k0sd0r"&&(jo.innerHTML=P_),Rc=n(e),Jo=i(e,"TABLE",{"data-svelte-h":!0}),d(Jo)!=="svelte-xda5g6"&&(Jo.innerHTML=z_),kc=n(e),Uc=i(e,"HR",{}),Ec=n(e),Do=i(e,"A",{id:!0,class:!0}),h(Do).forEach(l),jc=n(e),m(qo.$$.fragment,e),Jc=n(e),Io=i(e,"P",{"data-svelte-h":!0}),d(Io)!=="svelte-17f4oxi"&&(Io.textContent=R_),Dc=n(e),Ko=i(e,"P",{"data-svelte-h":!0}),d(Ko)!=="svelte-j8mnym"&&(Ko.innerHTML=k_),qc=n(e),Bo=i(e,"TABLE",{"data-svelte-h":!0}),d(Bo)!=="svelte-8q2rcx"&&(Bo.innerHTML=U_),Ic=n(e),Kc=i(e,"HR",{}),Bc=n(e),No=i(e,"A",{id:!0,class:!0}),h(No).forEach(l),Nc=n(e),m(Qo.$$.fragment,e),Qc=n(e),Vo=i(e,"P",{"data-svelte-h":!0}),d(Vo)!=="svelte-10qu7f7"&&(Vo.textContent=E_),Vc=n(e),So=i(e,"P",{"data-svelte-h":!0}),d(So)!=="svelte-18rka45"&&(So.innerHTML=j_),Sc=n(e),Oo=i(e,"TABLE",{"data-svelte-h":!0}),d(Oo)!=="svelte-1xtb381"&&(Oo.innerHTML=J_),Oc=n(e),Fc=i(e,"HR",{}),Yc=n(e),Fo=i(e,"A",{id:!0,class:!0}),h(Fo).forEach(l),Wc=n(e),m(Yo.$$.fragment,e),Gc=n(e),Wo=i(e,"P",{"data-svelte-h":!0}),d(Wo)!=="svelte-1ayje0f"&&(Wo.textContent=D_),Xc=n(e),Go=i(e,"P",{"data-svelte-h":!0}),d(Go)!=="svelte-154ckak"&&(Go.innerHTML=q_),Zc=n(e),Xo=i(e,"TABLE",{"data-svelte-h":!0}),d(Xo)!=="svelte-gyxne1"&&(Xo.innerHTML=I_),ef=n(e),tf=i(e,"HR",{}),lf=n(e),Zo=i(e,"A",{id:!0,class:!0}),h(Zo).forEach(l),sf=n(e),m(en.$$.fragment,e),of=n(e),tn=i(e,"P",{"data-svelte-h":!0}),d(tn)!=="svelte-1wvb8sq"&&(tn.textContent=K_),nf=n(e),ln=i(e,"P",{"data-svelte-h":!0}),d(ln)!=="svelte-154ckak"&&(ln.innerHTML=B_),rf=n(e),sn=i(e,"TABLE",{"data-svelte-h":!0}),d(sn)!=="svelte-esxgyf"&&(sn.innerHTML=N_),df=n(e),af=i(e,"HR",{}),uf=n(e),on=i(e,"A",{id:!0,class:!0}),h(on).forEach(l),mf=n(e),m(nn.$$.fragment,e),pf=n(e),rn=i(e,"P",{"data-svelte-h":!0}),d(rn)!=="svelte-1798kaw"&&(rn.textContent=Q_),cf=n(e),dn=i(e,"P",{"data-svelte-h":!0}),d(dn)!=="svelte-ue1j5m"&&(dn.innerHTML=V_),ff=n(e),an=i(e,"TABLE",{"data-svelte-h":!0}),d(an)!=="svelte-gyxne1"&&(an.innerHTML=S_),Tf=n(e),hf=i(e,"HR",{}),_f=n(e),un=i(e,"A",{id:!0,class:!0}),h(un).forEach(l),$f=n(e),m(mn.$$.fragment,e),bf=n(e),pn=i(e,"P",{"data-svelte-h":!0}),d(pn)!=="svelte-9nnpip"&&(pn.textContent=O_),vf=n(e),cn=i(e,"P",{"data-svelte-h":!0}),d(cn)!=="svelte-ue1j5m"&&(cn.innerHTML=F_),yf=n(e),fn=i(e,"TABLE",{"data-svelte-h":!0}),d(fn)!=="svelte-esxgyf"&&(fn.innerHTML=Y_),Mf=n(e),xf=i(e,"HR",{}),Cf=n(e),Tn=i(e,"A",{id:!0,class:!0}),h(Tn).forEach(l),Hf=n(e),m(hn.$$.fragment,e),Lf=n(e),_n=i(e,"P",{"data-svelte-h":!0}),d(_n)!=="svelte-106iz9p"&&(_n.textContent=W_),wf=n(e),$n=i(e,"P",{"data-svelte-h":!0}),d($n)!=="svelte-1uu5d6"&&($n.innerHTML=G_),Af=n(e),bn=i(e,"TABLE",{"data-svelte-h":!0}),d(bn)!=="svelte-gyxne1"&&(bn.innerHTML=X_),gf=n(e),Pf=i(e,"HR",{}),zf=n(e),vn=i(e,"A",{id:!0,class:!0}),h(vn).forEach(l),Rf=n(e),m(yn.$$.fragment,e),kf=n(e),Mn=i(e,"P",{"data-svelte-h":!0}),d(Mn)!=="svelte-185sm1b"&&(Mn.textContent=Z_),Uf=n(e),xn=i(e,"P",{"data-svelte-h":!0}),d(xn)!=="svelte-1a5fo0"&&(xn.innerHTML=e$),Ef=n(e),Cn=i(e,"TABLE",{"data-svelte-h":!0}),d(Cn)!=="svelte-rf6ukr"&&(Cn.innerHTML=t$),jf=n(e),Jf=i(e,"HR",{}),Df=n(e),Hn=i(e,"A",{id:!0,class:!0}),h(Hn).forEach(l),qf=n(e),m(Ln.$$.fragment,e),If=n(e),wn=i(e,"P",{"data-svelte-h":!0}),d(wn)!=="svelte-12loz97"&&(wn.innerHTML=l$),Kf=n(e),Bf=i(e,"HR",{}),Nf=n(e),An=i(e,"A",{id:!0,class:!0}),h(An).forEach(l),Qf=n(e),m(gn.$$.fragment,e),Vf=n(e),Pn=i(e,"P",{"data-svelte-h":!0}),d(Pn)!=="svelte-40isdg"&&(Pn.textContent=s$),Sf=n(e),zn=i(e,"P",{"data-svelte-h":!0}),d(zn)!=="svelte-tlsa2h"&&(zn.innerHTML=o$),Of=n(e),Rn=i(e,"TABLE",{"data-svelte-h":!0}),d(Rn)!=="svelte-17343p6"&&(Rn.innerHTML=n$),Ff=n(e),kn=i(e,"P",{"data-svelte-h":!0}),d(kn)!=="svelte-1aswmub"&&(kn.innerHTML=r$),Yf=n(e),m(Un.$$.fragment,e),Wf=n(e),Gf=i(e,"HR",{}),Xf=n(e),En=i(e,"A",{id:!0,class:!0}),h(En).forEach(l),Zf=n(e),m(jn.$$.fragment,e),eT=n(e),Jn=i(e,"P",{"data-svelte-h":!0}),d(Jn)!=="svelte-kp31r8"&&(Jn.innerHTML=i$),tT=n(e),lT=i(e,"HR",{}),sT=n(e),Dn=i(e,"A",{id:!0,class:!0}),h(Dn).forEach(l),oT=n(e),m(qn.$$.fragment,e),nT=n(e),In=i(e,"P",{"data-svelte-h":!0}),d(In)!=="svelte-1w8khqx"&&(In.innerHTML=d$),rT=n(e),Kn=i(e,"TABLE",{"data-svelte-h":!0}),d(Kn)!=="svelte-fhsoia"&&(Kn.innerHTML=a$),iT=n(e),dT=i(e,"HR",{}),aT=n(e),Bn=i(e,"A",{id:!0,class:!0}),h(Bn).forEach(l),uT=n(e),m(Nn.$$.fragment,e),mT=n(e),Qn=i(e,"P",{"data-svelte-h":!0}),d(Qn)!=="svelte-1fs9no9"&&(Qn.innerHTML=u$),pT=n(e),cT=i(e,"HR",{}),fT=n(e),Vn=i(e,"A",{id:!0,class:!0}),h(Vn).forEach(l),TT=n(e),m(Sn.$$.fragment,e),hT=n(e),On=i(e,"P",{"data-svelte-h":!0}),d(On)!=="svelte-2mif9c"&&(On.textContent=m$),_T=n(e),Fn=i(e,"P",{"data-svelte-h":!0}),d(Fn)!=="svelte-1jas2kw"&&(Fn.innerHTML=p$),$T=n(e),m(Yn.$$.fragment,e),bT=n(e),Wn=i(e,"P",{"data-svelte-h":!0}),d(Wn)!=="svelte-1aswmub"&&(Wn.innerHTML=c$),vT=n(e),m(Gn.$$.fragment,e),yT=n(e),Xn=i(e,"P",{"data-svelte-h":!0}),d(Xn)!=="svelte-1aswmub"&&(Xn.innerHTML=f$),MT=n(e),m(Zn.$$.fragment,e),xT=n(e),CT=i(e,"HR",{}),HT=n(e),m(er.$$.fragment,e),LT=n(e),sr=i(e,"P",{}),h(sr).forEach(l),this.h()},h(){a($,"name","hf:doc:metadata"),a($,"content",C$),a(b,"id","module_utils/tensor"),a(b,"class","group"),a(C,"id","module_utils/tensor.Tensor"),a(C,"class","group"),a(A,"id","new_module_utils/tensor.Tensor_new"),a(A,"class","group"),a(R,"id","module_utils/tensor.Tensor+dims"),a(R,"class","group"),a(j,"id","module_utils/tensor.Tensor+type"),a(j,"class","group"),a(I,"id","module_utils/tensor.Tensor+data"),a(I,"class","group"),a(Q,"id","module_utils/tensor.Tensor+size"),a(Q,"class","group"),a(F,"id","module_utils/tensor.Tensor+location"),a(F,"class","group"),a(X,"id","module_utils/tensor.Tensor+Symbol.iterator"),a(X,"class","group"),a(le,"id","module_utils/tensor.Tensor+_getitem"),a(le,"class","group"),a(ie,"id","module_utils/tensor.Tensor+indexOf"),a(ie,"class","group"),a(me,"id","module_utils/tensor.Tensor+_subarray"),a(me,"class","group"),a(Te,"id","module_utils/tensor.Tensor+item"),a(Te,"class","group"),a(ve,"id","module_utils/tensor.Tensor+tolist"),a(ve,"class","group"),a(Ce,"id","module_utils/tensor.Tensor+sigmoid"),a(Ce,"class","group"),a(Ae,"id","module_utils/tensor.Tensor+sigmoid_"),a(Ae,"class","group"),a(Re,"id","module_utils/tensor.Tensor+map"),a(Re,"class","group"),a(Je,"id","module_utils/tensor.Tensor+map_"),a(Je,"class","group"),a(Be,"id","module_utils/tensor.Tensor+mul"),a(Be,"class","group"),a(Oe,"id","module_utils/tensor.Tensor+mul_"),a(Oe,"class","group"),a(Xe,"id","module_utils/tensor.Tensor+div"),a(Xe,"class","group"),a(st,"id","module_utils/tensor.Tensor+div_"),a(st,"class","group"),a(dt,"id","module_utils/tensor.Tensor+add"),a(dt,"class","group"),a(ct,"id","module_utils/tensor.Tensor+add_"),a(ct,"class","group"),a($t,"id","module_utils/tensor.Tensor+sub"),a($t,"class","group"),a(xt,"id","module_utils/tensor.Tensor+sub_"),a(xt,"class","group"),a(At,"id","module_utils/tensor.Tensor+clone"),a(At,"class","group"),a(Rt,"id","module_utils/tensor.Tensor+slice"),a(Rt,"class","group"),a(Qt,"id","module_utils/tensor.Tensor+permute"),a(Qt,"class","group"),a(Yt,"id","module_utils/tensor.Tensor+sum"),a(Yt,"class","group"),a(el,"id","module_utils/tensor.Tensor+norm"),a(el,"class","group"),a(nl,"id","module_utils/tensor.Tensor+normalize_"),a(nl,"class","group"),a(ul,"id","module_utils/tensor.Tensor+normalize"),a(ul,"class","group"),a(Tl,"id","module_utils/tensor.Tensor+stride"),a(Tl,"class","group"),a(bl,"id","module_utils/tensor.Tensor+squeeze"),a(bl,"class","group"),a(Hl,"id","module_utils/tensor.Tensor+squeeze_"),a(Hl,"class","group"),a(gl,"id","module_utils/tensor.Tensor+unsqueeze"),a(gl,"class","group"),a(El,"id","module_utils/tensor.Tensor+unsqueeze_"),a(El,"class","group"),a(ql,"id","module_utils/tensor.Tensor+flatten_"),a(ql,"class","group"),a(Nl,"id","module_utils/tensor.Tensor+flatten"),a(Nl,"class","group"),a(Fl,"id","module_utils/tensor.Tensor+view"),a(Fl,"class","group"),a(Zl,"id","module_utils/tensor.Tensor+gt"),a(Zl,"class","group"),a(os,"id","module_utils/tensor.Tensor+lt"),a(os,"class","group"),a(as,"id","module_utils/tensor.Tensor+clamp_"),a(as,"class","group"),a(cs,"id","module_utils/tensor.Tensor+clamp"),a(cs,"class","group"),a($s,"id","module_utils/tensor.Tensor+round_"),a($s,"class","group"),a(Ms,"id","module_utils/tensor.Tensor+round"),a(Ms,"class","group"),a(Ls,"id","module_utils/tensor.Tensor+to"),a(Ls,"class","group"),a(zs,"id","module_utils/tensor.permute"),a(zs,"class","group"),a(js,"id","module_utils/tensor.interpolate"),a(js,"class","group"),a(Ks,"id","module_utils/tensor.interpolate_4d"),a(Ks,"class","group"),a(Ss,"id","module_utils/tensor.matmul"),a(Ss,"class","group"),a(Gs,"id","module_utils/tensor.rfft"),a(Gs,"class","group"),a(lo,"id","module_utils/tensor.topk"),a(lo,"class","group"),a(io,"id","module_utils/tensor.slice"),a(io,"class","group"),a(co,"id","module_utils/tensor.mean_pooling"),a(co,"class","group"),a($o,"id","module_utils/tensor.layer_norm"),a($o,"class","group"),a(xo,"id","module_utils/tensor.cat"),a(xo,"class","group"),a(Ao,"id","module_utils/tensor.stack"),a(Ao,"class","group"),a(ko,"id","module_utils/tensor.std_mean"),a(ko,"class","group"),a(Do,"id","module_utils/tensor.mean"),a(Do,"class","group"),a(No,"id","module_utils/tensor.full"),a(No,"class","group"),a(Fo,"id","module_utils/tensor.ones"),a(Fo,"class","group"),a(Zo,"id","module_utils/tensor.ones_like"),a(Zo,"class","group"),a(on,"id","module_utils/tensor.zeros"),a(on,"class","group"),a(un,"id","module_utils/tensor.zeros_like"),a(un,"class","group"),a(Tn,"id","module_utils/tensor.rand"),a(Tn,"class","group"),a(vn,"id","module_utils/tensor.quantize_embeddings"),a(vn,"class","group"),a(Hn,"id","module_utils/tensor..args[0]"),a(Hn,"class","group"),a(An,"id","module_utils/tensor..reshape"),a(An,"class","group"),a(En,"id","module_utils/tensor..reshape..reshapedArray"),a(En,"class","group"),a(Dn,"id","module_utils/tensor..reduce_helper"),a(Dn,"class","group"),a(Bn,"id","module_utils/tensor..DataArray"),a(Bn,"class","group"),a(Vn,"id","module_utils/tensor..NestArray"),a(Vn,"class","group")},m(e,t){y$(document.head,$),s(e,or,t),s(e,lr,t),s(e,nr,t),s(e,b,t),s(e,rr,t),p(v,e,t),s(e,ir,t),s(e,y,t),s(e,dr,t),s(e,M,t),s(e,ar,t),s(e,x,t),s(e,ur,t),s(e,mr,t),s(e,pr,t),s(e,C,t),s(e,cr,t),p(H,e,t),s(e,fr,t),s(e,L,t),s(e,Tr,t),s(e,w,t),s(e,hr,t),s(e,_r,t),s(e,$r,t),s(e,A,t),s(e,br,t),p(g,e,t),s(e,vr,t),s(e,P,t),s(e,yr,t),s(e,z,t),s(e,Mr,t),s(e,xr,t),s(e,Cr,t),s(e,R,t),s(e,Hr,t),p(k,e,t),s(e,Lr,t),s(e,U,t),s(e,wr,t),s(e,E,t),s(e,Ar,t),s(e,gr,t),s(e,Pr,t),s(e,j,t),s(e,zr,t),p(J,e,t),s(e,Rr,t),s(e,D,t),s(e,kr,t),s(e,q,t),s(e,Ur,t),s(e,Er,t),s(e,jr,t),s(e,I,t),s(e,Jr,t),p(K,e,t),s(e,Dr,t),s(e,B,t),s(e,qr,t),s(e,N,t),s(e,Ir,t),s(e,Kr,t),s(e,Br,t),s(e,Q,t),s(e,Nr,t),p(V,e,t),s(e,Qr,t),s(e,S,t),s(e,Vr,t),s(e,O,t),s(e,Sr,t),s(e,Or,t),s(e,Fr,t),s(e,F,t),s(e,Yr,t),p(Y,e,t),s(e,Wr,t),s(e,W,t),s(e,Gr,t),s(e,G,t),s(e,Xr,t),s(e,Zr,t),s(e,ei,t),s(e,X,t),s(e,ti,t),p(Z,e,t),s(e,li,t),s(e,ee,t),s(e,si,t),s(e,te,t),s(e,oi,t),s(e,ni,t),s(e,ri,t),s(e,le,t),s(e,ii,t),p(se,e,t),s(e,di,t),s(e,oe,t),s(e,ai,t),s(e,ne,t),s(e,ui,t),s(e,re,t),s(e,mi,t),s(e,pi,t),s(e,ci,t),s(e,ie,t),s(e,fi,t),p(de,e,t),s(e,Ti,t),s(e,ae,t),s(e,hi,t),s(e,ue,t),s(e,_i,t),s(e,$i,t),s(e,bi,t),s(e,me,t),s(e,vi,t),p(pe,e,t),s(e,yi,t),s(e,ce,t),s(e,Mi,t),s(e,fe,t),s(e,xi,t),s(e,Ci,t),s(e,Hi,t),s(e,Te,t),s(e,Li,t),p(he,e,t),s(e,wi,t),s(e,_e,t),s(e,Ai,t),s(e,$e,t),s(e,gi,t),s(e,be,t),s(e,Pi,t),s(e,zi,t),s(e,Ri,t),s(e,ve,t),s(e,ki,t),p(ye,e,t),s(e,Ui,t),s(e,Me,t),s(e,Ei,t),s(e,xe,t),s(e,ji,t),s(e,Ji,t),s(e,Di,t),s(e,Ce,t),s(e,qi,t),p(He,e,t),s(e,Ii,t),s(e,Le,t),s(e,Ki,t),s(e,we,t),s(e,Bi,t),s(e,Ni,t),s(e,Qi,t),s(e,Ae,t),s(e,Vi,t),p(ge,e,t),s(e,Si,t),s(e,Pe,t),s(e,Oi,t),s(e,ze,t),s(e,Fi,t),s(e,Yi,t),s(e,Wi,t),s(e,Re,t),s(e,Gi,t),p(ke,e,t),s(e,Xi,t),s(e,Ue,t),s(e,Zi,t),s(e,Ee,t),s(e,ed,t),s(e,je,t),s(e,td,t),s(e,ld,t),s(e,sd,t),s(e,Je,t),s(e,od,t),p(De,e,t),s(e,nd,t),s(e,qe,t),s(e,rd,t),s(e,Ie,t),s(e,id,t),s(e,Ke,t),s(e,dd,t),s(e,ad,t),s(e,ud,t),s(e,Be,t),s(e,md,t),p(Ne,e,t),s(e,pd,t),s(e,Qe,t),s(e,cd,t),s(e,Ve,t),s(e,fd,t),s(e,Se,t),s(e,Td,t),s(e,hd,t),s(e,_d,t),s(e,Oe,t),s(e,$d,t),p(Fe,e,t),s(e,bd,t),s(e,Ye,t),s(e,vd,t),s(e,We,t),s(e,yd,t),s(e,Ge,t),s(e,Md,t),s(e,xd,t),s(e,Cd,t),s(e,Xe,t),s(e,Hd,t),p(Ze,e,t),s(e,Ld,t),s(e,et,t),s(e,wd,t),s(e,tt,t),s(e,Ad,t),s(e,lt,t),s(e,gd,t),s(e,Pd,t),s(e,zd,t),s(e,st,t),s(e,Rd,t),p(ot,e,t),s(e,kd,t),s(e,nt,t),s(e,Ud,t),s(e,rt,t),s(e,Ed,t),s(e,it,t),s(e,jd,t),s(e,Jd,t),s(e,Dd,t),s(e,dt,t),s(e,qd,t),p(at,e,t),s(e,Id,t),s(e,ut,t),s(e,Kd,t),s(e,mt,t),s(e,Bd,t),s(e,pt,t),s(e,Nd,t),s(e,Qd,t),s(e,Vd,t),s(e,ct,t),s(e,Sd,t),p(ft,e,t),s(e,Od,t),s(e,Tt,t),s(e,Fd,t),s(e,ht,t),s(e,Yd,t),s(e,_t,t),s(e,Wd,t),s(e,Gd,t),s(e,Xd,t),s(e,$t,t),s(e,Zd,t),p(bt,e,t),s(e,ea,t),s(e,vt,t),s(e,ta,t),s(e,yt,t),s(e,la,t),s(e,Mt,t),s(e,sa,t),s(e,oa,t),s(e,na,t),s(e,xt,t),s(e,ra,t),p(Ct,e,t),s(e,ia,t),s(e,Ht,t),s(e,da,t),s(e,Lt,t),s(e,aa,t),s(e,wt,t),s(e,ua,t),s(e,ma,t),s(e,pa,t),s(e,At,t),s(e,ca,t),p(gt,e,t),s(e,fa,t),s(e,Pt,t),s(e,Ta,t),s(e,zt,t),s(e,ha,t),s(e,_a,t),s(e,$a,t),s(e,Rt,t),s(e,ba,t),p(kt,e,t),s(e,va,t),s(e,Ut,t),s(e,ya,t),s(e,Et,t),s(e,Ma,t),p(jt,e,t),s(e,xa,t),s(e,Jt,t),s(e,Ca,t),p(Dt,e,t),s(e,Ha,t),s(e,qt,t),s(e,La,t),p(It,e,t),s(e,wa,t),s(e,Kt,t),s(e,Aa,t),s(e,Bt,t),s(e,ga,t),s(e,Nt,t),s(e,Pa,t),s(e,za,t),s(e,Ra,t),s(e,Qt,t),s(e,ka,t),p(Vt,e,t),s(e,Ua,t),s(e,St,t),s(e,Ea,t),s(e,Ot,t),s(e,ja,t),s(e,Ft,t),s(e,Ja,t),s(e,Da,t),s(e,qa,t),s(e,Yt,t),s(e,Ia,t),p(Wt,e,t),s(e,Ka,t),s(e,Gt,t),s(e,Ba,t),s(e,Xt,t),s(e,Na,t),s(e,Zt,t),s(e,Qa,t),s(e,Va,t),s(e,Sa,t),s(e,el,t),s(e,Oa,t),p(tl,e,t),s(e,Fa,t),s(e,ll,t),s(e,Ya,t),s(e,sl,t),s(e,Wa,t),s(e,ol,t),s(e,Ga,t),s(e,Xa,t),s(e,Za,t),s(e,nl,t),s(e,eu,t),p(rl,e,t),s(e,tu,t),s(e,il,t),s(e,lu,t),s(e,dl,t),s(e,su,t),s(e,al,t),s(e,ou,t),s(e,nu,t),s(e,ru,t),s(e,ul,t),s(e,iu,t),p(ml,e,t),s(e,du,t),s(e,pl,t),s(e,au,t),s(e,cl,t),s(e,uu,t),s(e,fl,t),s(e,mu,t),s(e,pu,t),s(e,cu,t),s(e,Tl,t),s(e,fu,t),p(hl,e,t),s(e,Tu,t),s(e,_l,t),s(e,hu,t),s(e,$l,t),s(e,_u,t),s(e,$u,t),s(e,bu,t),s(e,bl,t),s(e,vu,t),p(vl,e,t),s(e,yu,t),s(e,yl,t),s(e,Mu,t),s(e,Ml,t),s(e,xu,t),s(e,xl,t),s(e,Cu,t),s(e,Cl,t),s(e,Hu,t),s(e,Lu,t),s(e,wu,t),s(e,Hl,t),s(e,Au,t),p(Ll,e,t),s(e,gu,t),s(e,wl,t),s(e,Pu,t),s(e,Al,t),s(e,zu,t),s(e,Ru,t),s(e,ku,t),s(e,gl,t),s(e,Uu,t),p(Pl,e,t),s(e,Eu,t),s(e,zl,t),s(e,ju,t),s(e,Rl,t),s(e,Ju,t),s(e,kl,t),s(e,Du,t),s(e,Ul,t),s(e,qu,t),s(e,Iu,t),s(e,Ku,t),s(e,El,t),s(e,Bu,t),p(jl,e,t),s(e,Nu,t),s(e,Jl,t),s(e,Qu,t),s(e,Dl,t),s(e,Vu,t),s(e,Su,t),s(e,Ou,t),s(e,ql,t),s(e,Fu,t),p(Il,e,t),s(e,Yu,t),s(e,Kl,t),s(e,Wu,t),s(e,Bl,t),s(e,Gu,t),s(e,Xu,t),s(e,Zu,t),s(e,Nl,t),s(e,em,t),p(Ql,e,t),s(e,tm,t),s(e,Vl,t),s(e,lm,t),s(e,Sl,t),s(e,sm,t),s(e,Ol,t),s(e,om,t),s(e,nm,t),s(e,rm,t),s(e,Fl,t),s(e,im,t),p(Yl,e,t),s(e,dm,t),s(e,Wl,t),s(e,am,t),s(e,Gl,t),s(e,um,t),s(e,Xl,t),s(e,mm,t),s(e,pm,t),s(e,cm,t),s(e,Zl,t),s(e,fm,t),p(es,e,t),s(e,Tm,t),s(e,ts,t),s(e,hm,t),s(e,ls,t),s(e,_m,t),s(e,ss,t),s(e,$m,t),s(e,bm,t),s(e,vm,t),s(e,os,t),s(e,ym,t),p(ns,e,t),s(e,Mm,t),s(e,rs,t),s(e,xm,t),s(e,is,t),s(e,Cm,t),s(e,ds,t),s(e,Hm,t),s(e,Lm,t),s(e,wm,t),s(e,as,t),s(e,Am,t),p(us,e,t),s(e,gm,t),s(e,ms,t),s(e,Pm,t),s(e,ps,t),s(e,zm,t),s(e,Rm,t),s(e,km,t),s(e,cs,t),s(e,Um,t),p(fs,e,t),s(e,Em,t),s(e,Ts,t),s(e,jm,t),s(e,hs,t),s(e,Jm,t),s(e,_s,t),s(e,Dm,t),s(e,qm,t),s(e,Im,t),s(e,$s,t),s(e,Km,t),p(bs,e,t),s(e,Bm,t),s(e,vs,t),s(e,Nm,t),s(e,ys,t),s(e,Qm,t),s(e,Vm,t),s(e,Sm,t),s(e,Ms,t),s(e,Om,t),p(xs,e,t),s(e,Fm,t),s(e,Cs,t),s(e,Ym,t),s(e,Hs,t),s(e,Wm,t),s(e,Gm,t),s(e,Xm,t),s(e,Ls,t),s(e,Zm,t),p(ws,e,t),s(e,ep,t),s(e,As,t),s(e,tp,t),s(e,gs,t),s(e,lp,t),s(e,Ps,t),s(e,sp,t),s(e,op,t),s(e,np,t),s(e,zs,t),s(e,rp,t),p(Rs,e,t),s(e,ip,t),s(e,ks,t),s(e,dp,t),s(e,Us,t),s(e,ap,t),s(e,Es,t),s(e,up,t),s(e,mp,t),s(e,pp,t),s(e,js,t),s(e,cp,t),p(Js,e,t),s(e,fp,t),s(e,Ds,t),s(e,Tp,t),s(e,qs,t),s(e,hp,t),s(e,Is,t),s(e,_p,t),s(e,$p,t),s(e,bp,t),s(e,Ks,t),s(e,vp,t),p(Bs,e,t),s(e,yp,t),s(e,Ns,t),s(e,Mp,t),s(e,Qs,t),s(e,xp,t),s(e,Vs,t),s(e,Cp,t),s(e,Hp,t),s(e,Lp,t),s(e,Ss,t),s(e,wp,t),p(Os,e,t),s(e,Ap,t),s(e,Fs,t),s(e,gp,t),s(e,Ys,t),s(e,Pp,t),s(e,Ws,t),s(e,zp,t),s(e,Rp,t),s(e,kp,t),s(e,Gs,t),s(e,Up,t),p(Xs,e,t),s(e,Ep,t),s(e,Zs,t),s(e,jp,t),s(e,eo,t),s(e,Jp,t),s(e,to,t),s(e,Dp,t),s(e,qp,t),s(e,Ip,t),s(e,lo,t),s(e,Kp,t),p(so,e,t),s(e,Bp,t),s(e,oo,t),s(e,Np,t),s(e,no,t),s(e,Qp,t),s(e,ro,t),s(e,Vp,t),s(e,Sp,t),s(e,Op,t),s(e,io,t),s(e,Fp,t),p(ao,e,t),s(e,Yp,t),s(e,uo,t),s(e,Wp,t),s(e,mo,t),s(e,Gp,t),s(e,po,t),s(e,Xp,t),s(e,Zp,t),s(e,ec,t),s(e,co,t),s(e,tc,t),p(fo,e,t),s(e,lc,t),s(e,To,t),s(e,sc,t),s(e,ho,t),s(e,oc,t),s(e,_o,t),s(e,nc,t),s(e,rc,t),s(e,ic,t),s(e,$o,t),s(e,dc,t),p(bo,e,t),s(e,ac,t),s(e,vo,t),s(e,uc,t),s(e,yo,t),s(e,mc,t),s(e,Mo,t),s(e,pc,t),s(e,cc,t),s(e,fc,t),s(e,xo,t),s(e,Tc,t),p(Co,e,t),s(e,hc,t),s(e,Ho,t),s(e,_c,t),s(e,Lo,t),s(e,$c,t),s(e,wo,t),s(e,bc,t),s(e,vc,t),s(e,yc,t),s(e,Ao,t),s(e,Mc,t),p(go,e,t),s(e,xc,t),s(e,Po,t),s(e,Cc,t),s(e,zo,t),s(e,Hc,t),s(e,Ro,t),s(e,Lc,t),s(e,wc,t),s(e,Ac,t),s(e,ko,t),s(e,gc,t),p(Uo,e,t),s(e,Pc,t),s(e,Eo,t),s(e,zc,t),s(e,jo,t),s(e,Rc,t),s(e,Jo,t),s(e,kc,t),s(e,Uc,t),s(e,Ec,t),s(e,Do,t),s(e,jc,t),p(qo,e,t),s(e,Jc,t),s(e,Io,t),s(e,Dc,t),s(e,Ko,t),s(e,qc,t),s(e,Bo,t),s(e,Ic,t),s(e,Kc,t),s(e,Bc,t),s(e,No,t),s(e,Nc,t),p(Qo,e,t),s(e,Qc,t),s(e,Vo,t),s(e,Vc,t),s(e,So,t),s(e,Sc,t),s(e,Oo,t),s(e,Oc,t),s(e,Fc,t),s(e,Yc,t),s(e,Fo,t),s(e,Wc,t),p(Yo,e,t),s(e,Gc,t),s(e,Wo,t),s(e,Xc,t),s(e,Go,t),s(e,Zc,t),s(e,Xo,t),s(e,ef,t),s(e,tf,t),s(e,lf,t),s(e,Zo,t),s(e,sf,t),p(en,e,t),s(e,of,t),s(e,tn,t),s(e,nf,t),s(e,ln,t),s(e,rf,t),s(e,sn,t),s(e,df,t),s(e,af,t),s(e,uf,t),s(e,on,t),s(e,mf,t),p(nn,e,t),s(e,pf,t),s(e,rn,t),s(e,cf,t),s(e,dn,t),s(e,ff,t),s(e,an,t),s(e,Tf,t),s(e,hf,t),s(e,_f,t),s(e,un,t),s(e,$f,t),p(mn,e,t),s(e,bf,t),s(e,pn,t),s(e,vf,t),s(e,cn,t),s(e,yf,t),s(e,fn,t),s(e,Mf,t),s(e,xf,t),s(e,Cf,t),s(e,Tn,t),s(e,Hf,t),p(hn,e,t),s(e,Lf,t),s(e,_n,t),s(e,wf,t),s(e,$n,t),s(e,Af,t),s(e,bn,t),s(e,gf,t),s(e,Pf,t),s(e,zf,t),s(e,vn,t),s(e,Rf,t),p(yn,e,t),s(e,kf,t),s(e,Mn,t),s(e,Uf,t),s(e,xn,t),s(e,Ef,t),s(e,Cn,t),s(e,jf,t),s(e,Jf,t),s(e,Df,t),s(e,Hn,t),s(e,qf,t),p(Ln,e,t),s(e,If,t),s(e,wn,t),s(e,Kf,t),s(e,Bf,t),s(e,Nf,t),s(e,An,t),s(e,Qf,t),p(gn,e,t),s(e,Vf,t),s(e,Pn,t),s(e,Sf,t),s(e,zn,t),s(e,Of,t),s(e,Rn,t),s(e,Ff,t),s(e,kn,t),s(e,Yf,t),p(Un,e,t),s(e,Wf,t),s(e,Gf,t),s(e,Xf,t),s(e,En,t),s(e,Zf,t),p(jn,e,t),s(e,eT,t),s(e,Jn,t),s(e,tT,t),s(e,lT,t),s(e,sT,t),s(e,Dn,t),s(e,oT,t),p(qn,e,t),s(e,nT,t),s(e,In,t),s(e,rT,t),s(e,Kn,t),s(e,iT,t),s(e,dT,t),s(e,aT,t),s(e,Bn,t),s(e,uT,t),p(Nn,e,t),s(e,mT,t),s(e,Qn,t),s(e,pT,t),s(e,cT,t),s(e,fT,t),s(e,Vn,t),s(e,TT,t),p(Sn,e,t),s(e,hT,t),s(e,On,t),s(e,_T,t),s(e,Fn,t),s(e,$T,t),p(Yn,e,t),s(e,bT,t),s(e,Wn,t),s(e,vT,t),p(Gn,e,t),s(e,yT,t),s(e,Xn,t),s(e,MT,t),p(Zn,e,t),s(e,xT,t),s(e,CT,t),s(e,HT,t),p(er,e,t),s(e,LT,t),s(e,sr,t),wT=!0},p:h$,i(e){wT||(c(v.$$.fragment,e),c(H.$$.fragment,e),c(g.$$.fragment,e),c(k.$$.fragment,e),c(J.$$.fragment,e),c(K.$$.fragment,e),c(V.$$.fragment,e),c(Y.$$.fragment,e),c(Z.$$.fragment,e),c(se.$$.fragment,e),c(de.$$.fragment,e),c(pe.$$.fragment,e),c(he.$$.fragment,e),c(ye.$$.fragment,e),c(He.$$.fragment,e),c(ge.$$.fragment,e),c(ke.$$.fragment,e),c(De.$$.fragment,e),c(Ne.$$.fragment,e),c(Fe.$$.fragment,e),c(Ze.$$.fragment,e),c(ot.$$.fragment,e),c(at.$$.fragment,e),c(ft.$$.fragment,e),c(bt.$$.fragment,e),c(Ct.$$.fragment,e),c(gt.$$.fragment,e),c(kt.$$.fragment,e),c(jt.$$.fragment,e),c(Dt.$$.fragment,e),c(It.$$.fragment,e),c(Vt.$$.fragment,e),c(Wt.$$.fragment,e),c(tl.$$.fragment,e),c(rl.$$.fragment,e),c(ml.$$.fragment,e),c(hl.$$.fragment,e),c(vl.$$.fragment,e),c(Ll.$$.fragment,e),c(Pl.$$.fragment,e),c(jl.$$.fragment,e),c(Il.$$.fragment,e),c(Ql.$$.fragment,e),c(Yl.$$.fragment,e),c(es.$$.fragment,e),c(ns.$$.fragment,e),c(us.$$.fragment,e),c(fs.$$.fragment,e),c(bs.$$.fragment,e),c(xs.$$.fragment,e),c(ws.$$.fragment,e),c(Rs.$$.fragment,e),c(Js.$$.fragment,e),c(Bs.$$.fragment,e),c(Os.$$.fragment,e),c(Xs.$$.fragment,e),c(so.$$.fragment,e),c(ao.$$.fragment,e),c(fo.$$.fragment,e),c(bo.$$.fragment,e),c(Co.$$.fragment,e),c(go.$$.fragment,e),c(Uo.$$.fragment,e),c(qo.$$.fragment,e),c(Qo.$$.fragment,e),c(Yo.$$.fragment,e),c(en.$$.fragment,e),c(nn.$$.fragment,e),c(mn.$$.fragment,e),c(hn.$$.fragment,e),c(yn.$$.fragment,e),c(Ln.$$.fragment,e),c(gn.$$.fragment,e),c(Un.$$.fragment,e),c(jn.$$.fragment,e),c(qn.$$.fragment,e),c(Nn.$$.fragment,e),c(Sn.$$.fragment,e),c(Yn.$$.fragment,e),c(Gn.$$.fragment,e),c(Zn.$$.fragment,e),c(er.$$.fragment,e),wT=!0)},o(e){f(v.$$.fragment,e),f(H.$$.fragment,e),f(g.$$.fragment,e),f(k.$$.fragment,e),f(J.$$.fragment,e),f(K.$$.fragment,e),f(V.$$.fragment,e),f(Y.$$.fragment,e),f(Z.$$.fragment,e),f(se.$$.fragment,e),f(de.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(ye.$$.fragment,e),f(He.$$.fragment,e),f(ge.$$.fragment,e),f(ke.$$.fragment,e),f(De.$$.fragment,e),f(Ne.$$.fragment,e),f(Fe.$$.fragment,e),f(Ze.$$.fragment,e),f(ot.$$.fragment,e),f(at.$$.fragment,e),f(ft.$$.fragment,e),f(bt.$$.fragment,e),f(Ct.$$.fragment,e),f(gt.$$.fragment,e),f(kt.$$.fragment,e),f(jt.$$.fragment,e),f(Dt.$$.fragment,e),f(It.$$.fragment,e),f(Vt.$$.fragment,e),f(Wt.$$.fragment,e),f(tl.$$.fragment,e),f(rl.$$.fragment,e),f(ml.$$.fragment,e),f(hl.$$.fragment,e),f(vl.$$.fragment,e),f(Ll.$$.fragment,e),f(Pl.$$.fragment,e),f(jl.$$.fragment,e),f(Il.$$.fragment,e),f(Ql.$$.fragment,e),f(Yl.$$.fragment,e),f(es.$$.fragment,e),f(ns.$$.fragment,e),f(us.$$.fragment,e),f(fs.$$.fragment,e),f(bs.$$.fragment,e),f(xs.$$.fragment,e),f(ws.$$.fragment,e),f(Rs.$$.fragment,e),f(Js.$$.fragment,e),f(Bs.$$.fragment,e),f(Os.$$.fragment,e),f(Xs.$$.fragment,e),f(so.$$.fragment,e),f(ao.$$.fragment,e),f(fo.$$.fragment,e),f(bo.$$.fragment,e),f(Co.$$.fragment,e),f(go.$$.fragment,e),f(Uo.$$.fragment,e),f(qo.$$.fragment,e),f(Qo.$$.fragment,e),f(Yo.$$.fragment,e),f(en.$$.fragment,e),f(nn.$$.fragment,e),f(mn.$$.fragment,e),f(hn.$$.fragment,e),f(yn.$$.fragment,e),f(Ln.$$.fragment,e),f(gn.$$.fragment,e),f(Un.$$.fragment,e),f(jn.$$.fragment,e),f(qn.$$.fragment,e),f(Nn.$$.fragment,e),f(Sn.$$.fragment,e),f(Yn.$$.fragment,e),f(Gn.$$.fragment,e),f(Zn.$$.fragment,e),f(er.$$.fragment,e),wT=!1},d(e){e&&(l(or),l(lr),l(nr),l(b),l(rr),l(ir),l(y),l(dr),l(M),l(ar),l(x),l(ur),l(mr),l(pr),l(C),l(cr),l(fr),l(L),l(Tr),l(w),l(hr),l(_r),l($r),l(A),l(br),l(vr),l(P),l(yr),l(z),l(Mr),l(xr),l(Cr),l(R),l(Hr),l(Lr),l(U),l(wr),l(E),l(Ar),l(gr),l(Pr),l(j),l(zr),l(Rr),l(D),l(kr),l(q),l(Ur),l(Er),l(jr),l(I),l(Jr),l(Dr),l(B),l(qr),l(N),l(Ir),l(Kr),l(Br),l(Q),l(Nr),l(Qr),l(S),l(Vr),l(O),l(Sr),l(Or),l(Fr),l(F),l(Yr),l(Wr),l(W),l(Gr),l(G),l(Xr),l(Zr),l(ei),l(X),l(ti),l(li),l(ee),l(si),l(te),l(oi),l(ni),l(ri),l(le),l(ii),l(di),l(oe),l(ai),l(ne),l(ui),l(re),l(mi),l(pi),l(ci),l(ie),l(fi),l(Ti),l(ae),l(hi),l(ue),l(_i),l($i),l(bi),l(me),l(vi),l(yi),l(ce),l(Mi),l(fe),l(xi),l(Ci),l(Hi),l(Te),l(Li),l(wi),l(_e),l(Ai),l($e),l(gi),l(be),l(Pi),l(zi),l(Ri),l(ve),l(ki),l(Ui),l(Me),l(Ei),l(xe),l(ji),l(Ji),l(Di),l(Ce),l(qi),l(Ii),l(Le),l(Ki),l(we),l(Bi),l(Ni),l(Qi),l(Ae),l(Vi),l(Si),l(Pe),l(Oi),l(ze),l(Fi),l(Yi),l(Wi),l(Re),l(Gi),l(Xi),l(Ue),l(Zi),l(Ee),l(ed),l(je),l(td),l(ld),l(sd),l(Je),l(od),l(nd),l(qe),l(rd),l(Ie),l(id),l(Ke),l(dd),l(ad),l(ud),l(Be),l(md),l(pd),l(Qe),l(cd),l(Ve),l(fd),l(Se),l(Td),l(hd),l(_d),l(Oe),l($d),l(bd),l(Ye),l(vd),l(We),l(yd),l(Ge),l(Md),l(xd),l(Cd),l(Xe),l(Hd),l(Ld),l(et),l(wd),l(tt),l(Ad),l(lt),l(gd),l(Pd),l(zd),l(st),l(Rd),l(kd),l(nt),l(Ud),l(rt),l(Ed),l(it),l(jd),l(Jd),l(Dd),l(dt),l(qd),l(Id),l(ut),l(Kd),l(mt),l(Bd),l(pt),l(Nd),l(Qd),l(Vd),l(ct),l(Sd),l(Od),l(Tt),l(Fd),l(ht),l(Yd),l(_t),l(Wd),l(Gd),l(Xd),l($t),l(Zd),l(ea),l(vt),l(ta),l(yt),l(la),l(Mt),l(sa),l(oa),l(na),l(xt),l(ra),l(ia),l(Ht),l(da),l(Lt),l(aa),l(wt),l(ua),l(ma),l(pa),l(At),l(ca),l(fa),l(Pt),l(Ta),l(zt),l(ha),l(_a),l($a),l(Rt),l(ba),l(va),l(Ut),l(ya),l(Et),l(Ma),l(xa),l(Jt),l(Ca),l(Ha),l(qt),l(La),l(wa),l(Kt),l(Aa),l(Bt),l(ga),l(Nt),l(Pa),l(za),l(Ra),l(Qt),l(ka),l(Ua),l(St),l(Ea),l(Ot),l(ja),l(Ft),l(Ja),l(Da),l(qa),l(Yt),l(Ia),l(Ka),l(Gt),l(Ba),l(Xt),l(Na),l(Zt),l(Qa),l(Va),l(Sa),l(el),l(Oa),l(Fa),l(ll),l(Ya),l(sl),l(Wa),l(ol),l(Ga),l(Xa),l(Za),l(nl),l(eu),l(tu),l(il),l(lu),l(dl),l(su),l(al),l(ou),l(nu),l(ru),l(ul),l(iu),l(du),l(pl),l(au),l(cl),l(uu),l(fl),l(mu),l(pu),l(cu),l(Tl),l(fu),l(Tu),l(_l),l(hu),l($l),l(_u),l($u),l(bu),l(bl),l(vu),l(yu),l(yl),l(Mu),l(Ml),l(xu),l(xl),l(Cu),l(Cl),l(Hu),l(Lu),l(wu),l(Hl),l(Au),l(gu),l(wl),l(Pu),l(Al),l(zu),l(Ru),l(ku),l(gl),l(Uu),l(Eu),l(zl),l(ju),l(Rl),l(Ju),l(kl),l(Du),l(Ul),l(qu),l(Iu),l(Ku),l(El),l(Bu),l(Nu),l(Jl),l(Qu),l(Dl),l(Vu),l(Su),l(Ou),l(ql),l(Fu),l(Yu),l(Kl),l(Wu),l(Bl),l(Gu),l(Xu),l(Zu),l(Nl),l(em),l(tm),l(Vl),l(lm),l(Sl),l(sm),l(Ol),l(om),l(nm),l(rm),l(Fl),l(im),l(dm),l(Wl),l(am),l(Gl),l(um),l(Xl),l(mm),l(pm),l(cm),l(Zl),l(fm),l(Tm),l(ts),l(hm),l(ls),l(_m),l(ss),l($m),l(bm),l(vm),l(os),l(ym),l(Mm),l(rs),l(xm),l(is),l(Cm),l(ds),l(Hm),l(Lm),l(wm),l(as),l(Am),l(gm),l(ms),l(Pm),l(ps),l(zm),l(Rm),l(km),l(cs),l(Um),l(Em),l(Ts),l(jm),l(hs),l(Jm),l(_s),l(Dm),l(qm),l(Im),l($s),l(Km),l(Bm),l(vs),l(Nm),l(ys),l(Qm),l(Vm),l(Sm),l(Ms),l(Om),l(Fm),l(Cs),l(Ym),l(Hs),l(Wm),l(Gm),l(Xm),l(Ls),l(Zm),l(ep),l(As),l(tp),l(gs),l(lp),l(Ps),l(sp),l(op),l(np),l(zs),l(rp),l(ip),l(ks),l(dp),l(Us),l(ap),l(Es),l(up),l(mp),l(pp),l(js),l(cp),l(fp),l(Ds),l(Tp),l(qs),l(hp),l(Is),l(_p),l($p),l(bp),l(Ks),l(vp),l(yp),l(Ns),l(Mp),l(Qs),l(xp),l(Vs),l(Cp),l(Hp),l(Lp),l(Ss),l(wp),l(Ap),l(Fs),l(gp),l(Ys),l(Pp),l(Ws),l(zp),l(Rp),l(kp),l(Gs),l(Up),l(Ep),l(Zs),l(jp),l(eo),l(Jp),l(to),l(Dp),l(qp),l(Ip),l(lo),l(Kp),l(Bp),l(oo),l(Np),l(no),l(Qp),l(ro),l(Vp),l(Sp),l(Op),l(io),l(Fp),l(Yp),l(uo),l(Wp),l(mo),l(Gp),l(po),l(Xp),l(Zp),l(ec),l(co),l(tc),l(lc),l(To),l(sc),l(ho),l(oc),l(_o),l(nc),l(rc),l(ic),l($o),l(dc),l(ac),l(vo),l(uc),l(yo),l(mc),l(Mo),l(pc),l(cc),l(fc),l(xo),l(Tc),l(hc),l(Ho),l(_c),l(Lo),l($c),l(wo),l(bc),l(vc),l(yc),l(Ao),l(Mc),l(xc),l(Po),l(Cc),l(zo),l(Hc),l(Ro),l(Lc),l(wc),l(Ac),l(ko),l(gc),l(Pc),l(Eo),l(zc),l(jo),l(Rc),l(Jo),l(kc),l(Uc),l(Ec),l(Do),l(jc),l(Jc),l(Io),l(Dc),l(Ko),l(qc),l(Bo),l(Ic),l(Kc),l(Bc),l(No),l(Nc),l(Qc),l(Vo),l(Vc),l(So),l(Sc),l(Oo),l(Oc),l(Fc),l(Yc),l(Fo),l(Wc),l(Gc),l(Wo),l(Xc),l(Go),l(Zc),l(Xo),l(ef),l(tf),l(lf),l(Zo),l(sf),l(of),l(tn),l(nf),l(ln),l(rf),l(sn),l(df),l(af),l(uf),l(on),l(mf),l(pf),l(rn),l(cf),l(dn),l(ff),l(an),l(Tf),l(hf),l(_f),l(un),l($f),l(bf),l(pn),l(vf),l(cn),l(yf),l(fn),l(Mf),l(xf),l(Cf),l(Tn),l(Hf),l(Lf),l(_n),l(wf),l($n),l(Af),l(bn),l(gf),l(Pf),l(zf),l(vn),l(Rf),l(kf),l(Mn),l(Uf),l(xn),l(Ef),l(Cn),l(jf),l(Jf),l(Df),l(Hn),l(qf),l(If),l(wn),l(Kf),l(Bf),l(Nf),l(An),l(Qf),l(Vf),l(Pn),l(Sf),l(zn),l(Of),l(Rn),l(Ff),l(kn),l(Yf),l(Wf),l(Gf),l(Xf),l(En),l(Zf),l(eT),l(Jn),l(tT),l(lT),l(sT),l(Dn),l(oT),l(nT),l(In),l(rT),l(Kn),l(iT),l(dT),l(aT),l(Bn),l(uT),l(mT),l(Qn),l(pT),l(cT),l(fT),l(Vn),l(TT),l(hT),l(On),l(_T),l(Fn),l($T),l(bT),l(Wn),l(vT),l(yT),l(Xn),l(MT),l(xT),l(CT),l(HT),l(LT),l(sr)),l($),T(v,e),T(H,e),T(g,e),T(k,e),T(J,e),T(K,e),T(V,e),T(Y,e),T(Z,e),T(se,e),T(de,e),T(pe,e),T(he,e),T(ye,e),T(He,e),T(ge,e),T(ke,e),T(De,e),T(Ne,e),T(Fe,e),T(Ze,e),T(ot,e),T(at,e),T(ft,e),T(bt,e),T(Ct,e),T(gt,e),T(kt,e),T(jt,e),T(Dt,e),T(It,e),T(Vt,e),T(Wt,e),T(tl,e),T(rl,e),T(ml,e),T(hl,e),T(vl,e),T(Ll,e),T(Pl,e),T(jl,e),T(Il,e),T(Ql,e),T(Yl,e),T(es,e),T(ns,e),T(us,e),T(fs,e),T(bs,e),T(xs,e),T(ws,e),T(Rs,e),T(Js,e),T(Bs,e),T(Os,e),T(Xs,e),T(so,e),T(ao,e),T(fo,e),T(bo,e),T(Co,e),T(go,e),T(Uo,e),T(qo,e),T(Qo,e),T(Yo,e),T(en,e),T(nn,e),T(mn,e),T(hn,e),T(yn,e),T(Ln,e),T(gn,e),T(Un,e),T(jn,e),T(qn,e),T(Nn,e),T(Sn,e),T(Yn,e),T(Gn,e),T(Zn,e),T(er,e)}}}const C$='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.dims : <code> Array. < number > </code>","local":"tensordims--code-array--number--code","sections":[],"depth":3},{"title":"tensor.type : <code> DataType </code>","local":"tensortype--code-datatype-code","sections":[],"depth":3},{"title":"tensor.data : <code> DataArray </code>","local":"tensordata--code-dataarray-code","sections":[],"depth":3},{"title":"tensor.size : <code> number </code>","local":"tensorsize--code-number-code","sections":[],"depth":3},{"title":"tensor.location : <code> string </code>","local":"tensorlocation--code-string-code","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code> | <code> bigint </code>","local":"tensoritem--code-number-code--code-bigint-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.map(callback) ⇒ <code> Tensor </code>","local":"tensormapcallback--code-tensor-code","sections":[],"depth":3},{"title":"tensor.map_(callback) ⇒ <code> Tensor </code>","local":"tensormapcallback--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul_(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.div_(val) ⇒ <code> Tensor </code>","local":"tensordivval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add_(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sub(val) ⇒ <code> Tensor </code>","local":"tensorsubval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sub_(val) ⇒ <code> Tensor </code>","local":"tensorsubval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clone() ⇒ <code> Tensor </code>","local":"tensorclone--code-tensor-code","sections":[],"depth":3},{"title":"tensor.slice(...slices) ⇒ <code> Tensor </code>","local":"tensorsliceslices--code-tensor-code","sections":[],"depth":3},{"title":"tensor.permute(...dims) ⇒ <code> Tensor </code>","local":"tensorpermutedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒ <code> Tensor </code>","local":"tensorsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒ <code> Tensor </code>","local":"tensorunsqueezedim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒ <code> Tensor </code>","local":"tensorflattenstartdim-enddim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.gt(val) ⇒ <code> Tensor </code>","local":"tensorgtval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.lt(val) ⇒ <code> Tensor </code>","local":"tensorltval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clamp_()","local":"tensorclamp","sections":[],"depth":3},{"title":"tensor.clamp(min, max) ⇒ <code> Tensor </code>","local":"tensorclampmin-max--code-tensor-code","sections":[],"depth":3},{"title":"tensor.round_()","local":"tensorround","sections":[],"depth":3},{"title":"tensor.round() ⇒ <code> Tensor </code>","local":"tensorround--code-tensor-code","sections":[],"depth":3},{"title":"tensor.to(type) ⇒ <code> Tensor </code>","local":"tensortotype--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensorpermutetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate_4d(input, options) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorinterpolate4dinput-options--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.matmul(a, b) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensormatmula-b--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.rfft(x, a) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorrfftx-a--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.topk(x, [k]) ⇒ <code> * </code>","local":"utilstensortopkx-k--code--code","sections":[],"depth":2},{"title":"utils/tensor.slice(data:, starts:, ends:, axes:, [steps]) ⇒ <code> Promise. < Tensor > </code>","local":"utilstensorslicedata-starts-ends-axes-steps--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>","local":"utilstensorlayernorminput-normalizedshape-options--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒ <code> Tensor </code>","local":"utilstensormeaninput-dim-keepdim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.full(size, fill_value) ⇒ <code> Tensor </code>","local":"utilstensorfullsize-fillvalue--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones(size) ⇒ <code> Tensor </code>","local":"utilstensoronessize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.ones_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensoronesliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros(size) ⇒ <code> Tensor </code>","local":"utilstensorzerossize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.zeros_like(tensor) ⇒ <code> Tensor </code>","local":"utilstensorzerosliketensor--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.rand(size) ⇒ <code> Tensor </code>","local":"utilstensorrandsize--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>","local":"utilstensorquantizeembeddingstensor-precision--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor~args[0] : <code> ONNXTensor </code>","local":"utilstensorargs0--code-onnxtensor-code","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~reduce_helper(callbackfn, input, dim, keepdim) ⇒ <code> * </code>","local":"utilstensorreducehelpercallbackfn-input-dim-keepdim--code--code","sections":[],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function H$(AT){return _$(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class P$ extends $${constructor($){super(),b$(this,$,H$,x$,T$,{})}}export{P$ as component};
