import{s as Ll,o as ql,n as al}from"../chunks/scheduler.182ea377.js";import{S as Kl,i as Pl,g as h,s as d,r as T,A as Ol,h as y,f as s,c as u,j as Hl,u as b,x as W,k as zl,y as le,a,v as w,d as f,t as j,w as U,m as ee,n as se}from"../chunks/index.abf12888.js";import{T as Cl}from"../chunks/Tip.230e2334.js";import{C as I}from"../chunks/CodeBlock.57fe6e13.js";import{D as ae}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as sl}from"../chunks/Heading.16916d63.js";import{H as xl,a as il}from"../chunks/HfOption.fc88c804.js";function te(G){let e,m='For more technical details of TCD, please refer to the <a href="https://arxiv.org/abs/2402.19159" rel="nofollow">paper</a> or official <a href="https://mhh0318.github.io/tcd/" rel="nofollow">project page</a>).';return{c(){e=h("p"),e.innerHTML=m},l(t){e=y(t,"P",{"data-svelte-h":!0}),W(e)!=="svelte-1apoih8"&&(e.innerHTML=m)},m(t,M){a(t,e,M)},p:al,d(t){t&&s(e)}}}function ne(G){let e,m,t,M='<img src="https://github.com/jabir-zheng/TCD/raw/main/assets/demo_image.png"/>',p;return e=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyMFRDRFNjaGVkdWxlciUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFiYXNlX21vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBdGNkX2xvcmFfaWQlMjAlM0QlMjAlMjJoMXQlMkZUQ0QtU0RYTC1Mb1JBJTIyJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMikudG8oZGV2aWNlKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwVENEU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKHRjZF9sb3JhX2lkKSUwQXBpcGUuZnVzZV9sb3JhKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJQYWludGluZyUyMG9mJTIwdGhlJTIwb3JhbmdlJTIwY2F0JTIwT3R0byUyMHZvbiUyMEdhcmZpZWxkJTJDJTIwQ291bnQlMjBvZiUyMEJpc21hcmNrLVNjaCVDMyVCNm5oYXVzZW4lMkMlMjBEdWtlJTIwb2YlMjBMYXVlbmJ1cmclMkMlMjBNaW5pc3Rlci1QcmVzaWRlbnQlMjBvZiUyMFBydXNzaWEuJTIwRGVwaWN0ZWQlMjB3ZWFyaW5nJTIwYSUyMFBydXNzaWFuJTIwUGlja2VsaGF1YmUlMjBhbmQlMjBlYXRpbmclMjBoaXMlMjBmYXZvcml0ZSUyMG1lYWwlMjAtJTIwbGFzYWduYS4lMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAlMkMlMEElMjAlMjAlMjAlMjBldGElM0QwLjMlMkMlMjAlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEZGV2aWNlKS5tYW51YWxfc2VlZCgwKSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, TCDScheduler

device = <span class="hljs-string">&quot;cuda&quot;</span>
base_model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
tcd_lora_id = <span class="hljs-string">&quot;h1t/TCD-SDXL-LoRA&quot;</span>

pipe = StableDiffusionXLPipeline.from_pretrained(base_model_id, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>).to(device)
pipe.scheduler = TCDScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(tcd_lora_id)
pipe.fuse_lora()

prompt = <span class="hljs-string">&quot;Painting of the orange cat Otto von Garfield, Count of Bismarck-Schönhausen, Duke of Lauenburg, Minister-President of Prussia. Depicted wearing a Prussian Pickelhaube and eating his favorite meal - lasagna.&quot;</span>

image = pipe(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">0</span>,
    eta=<span class="hljs-number">0.3</span>, 
    generator=torch.Generator(device=device).manual_seed(<span class="hljs-number">0</span>),
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){T(e.$$.fragment),m=d(),t=h("p"),t.innerHTML=M},l(i){b(e.$$.fragment,i),m=u(i),t=y(i,"P",{"data-svelte-h":!0}),W(t)!=="svelte-nuvmzb"&&(t.innerHTML=M)},m(i,o){w(e,i,o),a(i,m,o),a(i,t,o),p=!0},p:al,i(i){p||(f(e.$$.fragment,i),p=!0)},o(i){j(e.$$.fragment,i),p=!1},d(i){i&&(s(m),s(t)),U(e,i)}}}function ie(G){let e,m,t,M='<img src="https://github.com/jabir-zheng/TCD/raw/main/assets/inpainting_tcd.png"/>',p;return e=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting, TCDScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

device = <span class="hljs-string">&quot;cuda&quot;</span>
base_model_id = <span class="hljs-string">&quot;diffusers/stable-diffusion-xl-1.0-inpainting-0.1&quot;</span>
tcd_lora_id = <span class="hljs-string">&quot;h1t/TCD-SDXL-LoRA&quot;</span>

pipe = AutoPipelineForInpainting.from_pretrained(base_model_id, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>).to(device)
pipe.scheduler = TCDScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(tcd_lora_id)
pipe.fuse_lora()

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = load_image(img_url).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))
mask_image = load_image(mask_url).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))

prompt = <span class="hljs-string">&quot;a tiger sitting on a park bench&quot;</span>

image = pipe(
  prompt=prompt,
  image=init_image,
  mask_image=mask_image,
  num_inference_steps=<span class="hljs-number">8</span>,
  guidance_scale=<span class="hljs-number">0</span>,
  eta=<span class="hljs-number">0.3</span>,
  strength=<span class="hljs-number">0.99</span>,  <span class="hljs-comment"># make sure to use \`strength\` below 1.0</span>
  generator=torch.Generator(device=device).manual_seed(<span class="hljs-number">0</span>),
).images[<span class="hljs-number">0</span>]

grid_image = make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),{c(){T(e.$$.fragment),m=d(),t=h("p"),t.innerHTML=M},l(i){b(e.$$.fragment,i),m=u(i),t=y(i,"P",{"data-svelte-h":!0}),W(t)!=="svelte-wsv6yl"&&(t.innerHTML=M)},m(i,o){w(e,i,o),a(i,m,o),a(i,t,o),p=!0},p:al,i(i){p||(f(e.$$.fragment,i),p=!0)},o(i){j(e.$$.fragment,i),p=!1},d(i){i&&(s(m),s(t)),U(e,i)}}}function pe(G){let e,m,t,M;return e=new il({props:{id:"tasks",option:"text-to-image",$$slots:{default:[ne]},$$scope:{ctx:G}}}),t=new il({props:{id:"tasks",option:"inpainting",$$slots:{default:[ie]},$$scope:{ctx:G}}}),{c(){T(e.$$.fragment),m=d(),T(t.$$.fragment)},l(p){b(e.$$.fragment,p),m=u(p),b(t.$$.fragment,p)},m(p,i){w(e,p,i),a(p,m,i),w(t,p,i),M=!0},p(p,i){const o={};i&2&&(o.$$scope={dirty:i,ctx:p}),e.$set(o);const J={};i&2&&(J.$$scope={dirty:i,ctx:p}),t.$set(J)},i(p){M||(f(e.$$.fragment,p),f(t.$$.fragment,p),M=!0)},o(p){j(e.$$.fragment,p),j(t.$$.fragment,p),M=!1},d(p){p&&s(m),U(e,p),U(t,p)}}}function oe(G){let e,m='Check out the <a href="merge_loras">Merge LoRAs</a> guide to learn more about efficient merging methods.';return{c(){e=h("p"),e.innerHTML=m},l(t){e=y(t,"P",{"data-svelte-h":!0}),W(e)!=="svelte-4z0umm"&&(e.innerHTML=m)},m(t,M){a(t,e,M)},p:al,d(t){t&&s(e)}}}function re(G){let e;return{c(){e=ee("The inference parameters in this example might not work for all examples, so we recommend you to try different values for `num_inference_steps`, `guidance_scale`, `controlnet_conditioning_scale` and `cross_attention_kwargs` parameters and choose the best one.")},l(m){e=se(m,"The inference parameters in this example might not work for all examples, so we recommend you to try different values for `num_inference_steps`, `guidance_scale`, `controlnet_conditioning_scale` and `cross_attention_kwargs` parameters and choose the best one.")},m(m,t){a(m,e,t)},d(m){m&&s(e)}}}function ce(G){let e,m,t,M,p,i='<img src="https://github.com/jabir-zheng/TCD/raw/main/assets/controlnet_depth_tcd.png"/>',o,J,r,Z,R,C,tl='<img src="https://github.com/jabir-zheng/TCD/raw/main/assets/controlnet_canny_tcd.png"/>',_,B,E;return e=new sl({props:{title:"Depth ControlNet",local:"depth-controlnet",headingTag:"h3"}}),t=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DPTFeatureExtractor, DPTForDepthEstimation
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel, StableDiffusionXLControlNetPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> scheduling_tcd <span class="hljs-keyword">import</span> TCDScheduler 

device = <span class="hljs-string">&quot;cuda&quot;</span>
depth_estimator = DPTForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-hybrid-midas&quot;</span>).to(device)
feature_extractor = DPTFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-hybrid-midas&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_depth_map</span>(<span class="hljs-params">image</span>):
    image = feature_extractor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values.to(device)
    <span class="hljs-keyword">with</span> torch.no_grad(), torch.autocast(device):
        depth_map = depth_estimator(image).predicted_depth

    depth_map = torch.nn.functional.interpolate(
        depth_map.unsqueeze(<span class="hljs-number">1</span>),
        size=(<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>),
        mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
        align_corners=<span class="hljs-literal">False</span>,
    )
    depth_min = torch.amin(depth_map, dim=[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>], keepdim=<span class="hljs-literal">True</span>)
    depth_max = torch.amax(depth_map, dim=[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>], keepdim=<span class="hljs-literal">True</span>)
    depth_map = (depth_map - depth_min) / (depth_max - depth_min)
    image = torch.cat([depth_map] * <span class="hljs-number">3</span>, dim=<span class="hljs-number">1</span>)

    image = image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>).cpu().numpy()[<span class="hljs-number">0</span>]
    image = Image.fromarray((image * <span class="hljs-number">255.0</span>).clip(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>).astype(np.uint8))
    <span class="hljs-keyword">return</span> image

base_model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
controlnet_id = <span class="hljs-string">&quot;diffusers/controlnet-depth-sdxl-1.0&quot;</span>
tcd_lora_id = <span class="hljs-string">&quot;h1t/TCD-SDXL-LoRA&quot;</span>

controlnet = ControlNetModel.from_pretrained(
    controlnet_id,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(device)
pipe = StableDiffusionXLControlNetPipeline.from_pretrained(
    base_model_id,
    controlnet=controlnet,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(device)
pipe.enable_model_cpu_offload()

pipe.scheduler = TCDScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(tcd_lora_id)
pipe.fuse_lora()

prompt = <span class="hljs-string">&quot;stormtrooper lecture, photorealistic&quot;</span>

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/lllyasviel/sd-controlnet-depth/resolve/main/images/stormtrooper.png&quot;</span>)
depth_image = get_depth_map(image)

controlnet_conditioning_scale = <span class="hljs-number">0.5</span>  <span class="hljs-comment"># recommended for good generalization</span>

image = pipe(
    prompt, 
    image=depth_image, 
    num_inference_steps=<span class="hljs-number">4</span>, 
    guidance_scale=<span class="hljs-number">0</span>,
    eta=<span class="hljs-number">0.3</span>,
    controlnet_conditioning_scale=controlnet_conditioning_scale,
    generator=torch.Generator(device=device).manual_seed(<span class="hljs-number">0</span>),
).images[<span class="hljs-number">0</span>]

grid_image = make_image_grid([depth_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),J=new sl({props:{title:"Canny ControlNet",local:"canny-controlnet",headingTag:"h3"}}),Z=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel, StableDiffusionXLControlNetPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> scheduling_tcd <span class="hljs-keyword">import</span> TCDScheduler 

device = <span class="hljs-string">&quot;cuda&quot;</span>
base_model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
controlnet_id = <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>
tcd_lora_id = <span class="hljs-string">&quot;h1t/TCD-SDXL-LoRA&quot;</span>

controlnet = ControlNetModel.from_pretrained(
    controlnet_id,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(device)
pipe = StableDiffusionXLControlNetPipeline.from_pretrained(
    base_model_id,
    controlnet=controlnet,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(device)
pipe.enable_model_cpu_offload()

pipe.scheduler = TCDScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(tcd_lora_id)
pipe.fuse_lora()

prompt = <span class="hljs-string">&quot;ultrarealistic shot of a furry blue bird&quot;</span>

canny_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/bird_canny.png&quot;</span>)

controlnet_conditioning_scale = <span class="hljs-number">0.5</span>  <span class="hljs-comment"># recommended for good generalization</span>

image = pipe(
    prompt, 
    image=canny_image, 
    num_inference_steps=<span class="hljs-number">4</span>, 
    guidance_scale=<span class="hljs-number">0</span>,
    eta=<span class="hljs-number">0.3</span>,
    controlnet_conditioning_scale=controlnet_conditioning_scale,
    generator=torch.Generator(device=device).manual_seed(<span class="hljs-number">0</span>),
).images[<span class="hljs-number">0</span>]

grid_image = make_image_grid([canny_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),B=new Cl({props:{$$slots:{default:[re]},$$scope:{ctx:G}}}),{c(){T(e.$$.fragment),m=d(),T(t.$$.fragment),M=d(),p=h("p"),p.innerHTML=i,o=d(),T(J.$$.fragment),r=d(),T(Z.$$.fragment),R=d(),C=h("p"),C.innerHTML=tl,_=d(),T(B.$$.fragment)},l(c){b(e.$$.fragment,c),m=u(c),b(t.$$.fragment,c),M=u(c),p=y(c,"P",{"data-svelte-h":!0}),W(p)!=="svelte-jfsnb4"&&(p.innerHTML=i),o=u(c),b(J.$$.fragment,c),r=u(c),b(Z.$$.fragment,c),R=u(c),C=y(c,"P",{"data-svelte-h":!0}),W(C)!=="svelte-x8em4a"&&(C.innerHTML=tl),_=u(c),b(B.$$.fragment,c)},m(c,g){w(e,c,g),a(c,m,g),w(t,c,g),a(c,M,g),a(c,p,g),a(c,o,g),w(J,c,g),a(c,r,g),w(Z,c,g),a(c,R,g),a(c,C,g),a(c,_,g),w(B,c,g),E=!0},p(c,g){const Q={};g&2&&(Q.$$scope={dirty:g,ctx:c}),B.$set(Q)},i(c){E||(f(e.$$.fragment,c),f(t.$$.fragment,c),f(J.$$.fragment,c),f(Z.$$.fragment,c),f(B.$$.fragment,c),E=!0)},o(c){j(e.$$.fragment,c),j(t.$$.fragment,c),j(J.$$.fragment,c),j(Z.$$.fragment,c),j(B.$$.fragment,c),E=!1},d(c){c&&(s(m),s(M),s(p),s(o),s(r),s(R),s(C),s(_)),U(e,c),U(t,c),U(J,c),U(Z,c),U(B,c)}}}function me(G){let e,m='This example shows how to use the TCD-LoRA with the <a href="https://github.com/tencent-ailab/IP-Adapter/tree/main" rel="nofollow">IP-Adapter</a> and SDXL.',t,M,p,i,o='<img src="https://github.com/jabir-zheng/TCD/raw/main/assets/ip_adapter.png"/>',J;return M=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-keyword">from</span> ip_adapter <span class="hljs-keyword">import</span> IPAdapterXL
<span class="hljs-keyword">from</span> scheduling_tcd <span class="hljs-keyword">import</span> TCDScheduler 

device = <span class="hljs-string">&quot;cuda&quot;</span>
base_model_path = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
image_encoder_path = <span class="hljs-string">&quot;sdxl_models/image_encoder&quot;</span>
ip_ckpt = <span class="hljs-string">&quot;sdxl_models/ip-adapter_sdxl.bin&quot;</span>
tcd_lora_id = <span class="hljs-string">&quot;h1t/TCD-SDXL-LoRA&quot;</span>

pipe = StableDiffusionXLPipeline.from_pretrained(
    base_model_path, 
    torch_dtype=torch.float16, 
    variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe.scheduler = TCDScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(tcd_lora_id)
pipe.fuse_lora()

ip_model = IPAdapterXL(pipe, image_encoder_path, ip_ckpt, device)

ref_image = load_image(<span class="hljs-string">&quot;https://raw.githubusercontent.com/tencent-ailab/IP-Adapter/main/assets/images/woman.png&quot;</span>).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;best quality, high quality, wearing sunglasses&quot;</span>

image = ip_model.generate(
    pil_image=ref_image, 
    prompt=prompt,
    scale=<span class="hljs-number">0.5</span>,
    num_samples=<span class="hljs-number">1</span>, 
    num_inference_steps=<span class="hljs-number">4</span>, 
    guidance_scale=<span class="hljs-number">0</span>,
    eta=<span class="hljs-number">0.3</span>, 
    seed=<span class="hljs-number">0</span>,
)[<span class="hljs-number">0</span>]

grid_image = make_image_grid([ref_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),{c(){e=h("p"),e.innerHTML=m,t=d(),T(M.$$.fragment),p=d(),i=h("p"),i.innerHTML=o},l(r){e=y(r,"P",{"data-svelte-h":!0}),W(e)!=="svelte-fqwnz0"&&(e.innerHTML=m),t=u(r),b(M.$$.fragment,r),p=u(r),i=y(r,"P",{"data-svelte-h":!0}),W(i)!=="svelte-1nkh4zf"&&(i.innerHTML=o)},m(r,Z){a(r,e,Z),a(r,t,Z),w(M,r,Z),a(r,p,Z),a(r,i,Z),J=!0},p:al,i(r){J||(f(M.$$.fragment,r),J=!0)},o(r){j(M.$$.fragment,r),J=!1},d(r){r&&(s(e),s(t),s(p),s(i)),U(M,r)}}}function Me(G){let e,m="<code>AnimateDiff</code> allows animating images using Stable Diffusion models. TCD-LoRA can substantially accelerate the process without degrading image quality. The quality of animation with TCD-LoRA and AnimateDiff has a more lucid outcome.",t,M,p,i,o='<img src="https://github.com/jabir-zheng/TCD/raw/main/assets/animation_example.gif"/>',J;return M=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter, AnimateDiffPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> scheduling_tcd <span class="hljs-keyword">import</span> TCDScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5&quot;</span>)
pipe = AnimateDiffPipeline.from_pretrained(
    <span class="hljs-string">&quot;frankjoshua/toonyou_beta6&quot;</span>,
    motion_adapter=adapter,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># set TCDScheduler</span>
pipe.scheduler = TCDScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># load TCD LoRA</span>
pipe.load_lora_weights(<span class="hljs-string">&quot;h1t/TCD-SD15-LoRA&quot;</span>, adapter_name=<span class="hljs-string">&quot;tcd&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;guoyww/animatediff-motion-lora-zoom-in&quot;</span>, weight_name=<span class="hljs-string">&quot;diffusion_pytorch_model.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;motion-lora&quot;</span>)

pipe.set_adapters([<span class="hljs-string">&quot;tcd&quot;</span>, <span class="hljs-string">&quot;motion-lora&quot;</span>], adapter_weights=[<span class="hljs-number">1.0</span>, <span class="hljs-number">1.2</span>])

prompt = <span class="hljs-string">&quot;best quality, masterpiece, 1girl, looking at viewer, blurry background, upper body, contemporary, dress&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
frames = pipe(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">5</span>,
    guidance_scale=<span class="hljs-number">0</span>,
    cross_attention_kwargs={<span class="hljs-string">&quot;scale&quot;</span>: <span class="hljs-number">1</span>},
    num_frames=<span class="hljs-number">24</span>,
    eta=<span class="hljs-number">0.3</span>,
    generator=generator
).frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),{c(){e=h("p"),e.innerHTML=m,t=d(),T(M.$$.fragment),p=d(),i=h("p"),i.innerHTML=o},l(r){e=y(r,"P",{"data-svelte-h":!0}),W(e)!=="svelte-nxio7r"&&(e.innerHTML=m),t=u(r),b(M.$$.fragment,r),p=u(r),i=y(r,"P",{"data-svelte-h":!0}),W(i)!=="svelte-it1yry"&&(i.innerHTML=o)},m(r,Z){a(r,e,Z),a(r,t,Z),w(M,r,Z),a(r,p,Z),a(r,i,Z),J=!0},p:al,i(r){J||(f(M.$$.fragment,r),J=!0)},o(r){j(M.$$.fragment,r),J=!1},d(r){r&&(s(e),s(t),s(p),s(i)),U(M,r)}}}function de(G){let e,m,t,M,p,i;return e=new il({props:{id:"adapters",option:"ControlNet",$$slots:{default:[ce]},$$scope:{ctx:G}}}),t=new il({props:{id:"adapters",option:"IP-Adapter",$$slots:{default:[me]},$$scope:{ctx:G}}}),p=new il({props:{id:"adapters",option:"AnimateDiff",$$slots:{default:[Me]},$$scope:{ctx:G}}}),{c(){T(e.$$.fragment),m=d(),T(t.$$.fragment),M=d(),T(p.$$.fragment)},l(o){b(e.$$.fragment,o),m=u(o),b(t.$$.fragment,o),M=u(o),b(p.$$.fragment,o)},m(o,J){w(e,o,J),a(o,m,J),w(t,o,J),a(o,M,J),w(p,o,J),i=!0},p(o,J){const r={};J&2&&(r.$$scope={dirty:J,ctx:o}),e.$set(r);const Z={};J&2&&(Z.$$scope={dirty:J,ctx:o}),t.$set(Z);const R={};J&2&&(R.$$scope={dirty:J,ctx:o}),p.$set(R)},i(o){i||(f(e.$$.fragment,o),f(t.$$.fragment,o),f(p.$$.fragment,o),i=!0)},o(o){j(e.$$.fragment,o),j(t.$$.fragment,o),j(p.$$.fragment,o),i=!1},d(o){o&&(s(m),s(M)),U(e,o),U(t,o),U(p,o)}}}function ue(G){let e,m,t,M,p,i,o,J,r,Z="Trajectory Consistency Distillation (TCD) enables a model to generate higher quality and more detailed images with fewer steps. Moreover, owing to the effective error mitigation during the distillation process, TCD demonstrates superior performance even under conditions of large inference steps.",R,C,tl="The major advantages of TCD are:",_,B,E='<li><p>Better than Teacher: TCD demonstrates superior generative quality at both small and large inference steps and exceeds the performance of <a href="../../api/schedulers/multistep_dpm_solver">DPM-Solver++(2S)</a> with Stable Diffusion XL (SDXL). There is no additional discriminator or LPIPS supervision included during TCD training.</p></li> <li><p>Flexible Inference Steps: The inference steps for TCD sampling can be freely adjusted without adversely affecting the image quality.</p></li> <li><p>Freely change detail level: During inference, the level of detail in the image can be adjusted with a single hyperparameter, <em>gamma</em>.</p></li>',c,g,Q,Y,Rl='For large models like SDXL, TCD is trained with <a href="https://huggingface.co/docs/peft/conceptual_guides/adapter#low-rank-adaptation-lora" rel="nofollow">LoRA</a> to reduce memory usage. This is also useful because you can reuse LoRAs between different finetuned models, as long as they share the same base model, without further training.',pl,v,_l="This guide will show you how to perform inference with TCD-LoRAs for a variety of tasks like text-to-image and inpainting, as well as how you can easily combine TCD-LoRAs with other adapters. Choose one of the supported base model and it’s corresponding TCD-LoRA checkpoint from the table below to get started.",ol,F,Il='<thead><tr><th>Base model</th> <th>TCD-LoRA checkpoint</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">stable-diffusion-v1-5</a></td> <td><a href="https://huggingface.co/h1t/TCD-SD15-LoRA" rel="nofollow">TCD-SD15</a></td></tr> <tr><td><a href="https://huggingface.co/stabilityai/stable-diffusion-2-1-base" rel="nofollow">stable-diffusion-2-1-base</a></td> <td><a href="https://huggingface.co/h1t/TCD-SD21-base-LoRA" rel="nofollow">TCD-SD21-base</a></td></tr> <tr><td><a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stable-diffusion-xl-base-1.0</a></td> <td><a href="https://huggingface.co/h1t/TCD-SDXL-LoRA" rel="nofollow">TCD-SDXL</a></td></tr></tbody>',rl,N,Xl='Make sure you have <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT</a> installed for better LoRA support.',cl,S,ml,$,Ml,A,kl='In this guide, let’s use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> and the <a href="/docs/diffusers/main/en/api/schedulers/tcd#diffusers.TCDScheduler">TCDScheduler</a>. Use the <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> method to load the SDXL-compatible TCD-LoRA weights.',dl,D,Vl="A few tips to keep in mind for TCD-LoRA inference are to:",ul,H,El='<li>Keep the <code>num_inference_steps</code> between 4 and 50</li> <li>Set <code>eta</code> (used to control stochasticity at each step) between 0 and 1. You should use a higher <code>eta</code> when increasing the number of inference steps, but the downside is that a larger <code>eta</code> in <a href="/docs/diffusers/main/en/api/schedulers/tcd#diffusers.TCDScheduler">TCDScheduler</a> leads to blurrier images. A value of 0.3 is recommended to produce good results.</li>',Jl,X,hl,z,yl,x,Ql='TCD-LoRA also works with many community finetuned models and plugins. For example, load the <a href="https://huggingface.co/cagliostrolab/animagine-xl-3.0" rel="nofollow">animagine-xl-3.0</a> checkpoint which is a community finetuned version of SDXL for generating anime images.',Tl,L,bl,q,Yl='<img src="https://github.com/jabir-zheng/TCD/raw/main/assets/animagine_xl.png"/>',wl,K,vl='TCD-LoRA also supports other LoRAs trained on different styles. For example, let’s load the <a href="https://huggingface.co/TheLastBen/Papercut_SDXL" rel="nofollow">TheLastBen/Papercut_SDXL</a> LoRA and fuse it with the TCD-LoRA with the <a href="/docs/diffusers/main/en/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters">set_adapters()</a> method.',fl,k,jl,P,Ul,O,Fl='<img src="https://github.com/jabir-zheng/TCD/raw/main/assets/styled_lora.png"/>',Zl,ll,gl,el,Nl="TCD-LoRA is very versatile, and it can be combined with other adapter types like ControlNets, IP-Adapter, and AnimateDiff.",Wl,V,Gl,nl,Bl;return p=new ae({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/inference_with_tcd_lora.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/inference_with_tcd_lora.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/inference_with_tcd_lora.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/inference_with_tcd_lora.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/inference_with_tcd_lora.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/inference_with_tcd_lora.ipynb"}]}}),o=new sl({props:{title:"Trajectory Consistency Distillation-LoRA",local:"trajectory-consistency-distillation-lora",headingTag:"h1"}}),g=new Cl({props:{warning:!1,$$slots:{default:[te]},$$scope:{ctx:G}}}),S=new I({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwcGVmdA==",highlighted:"pip install -U peft",wrap:!1}}),$=new sl({props:{title:"General tasks",local:"general-tasks",headingTag:"h2"}}),X=new xl({props:{id:"tasks",options:["text-to-image","inpainting"],$$slots:{default:[pe]},$$scope:{ctx:G}}}),z=new sl({props:{title:"Community models",local:"community-models",headingTag:"h2"}}),L=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyMFRDRFNjaGVkdWxlciUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFiYXNlX21vZGVsX2lkJTIwJTNEJTIwJTIyY2FnbGlvc3Ryb2xhYiUyRmFuaW1hZ2luZS14bC0zLjAlMjIlMEF0Y2RfbG9yYV9pZCUyMCUzRCUyMCUyMmgxdCUyRlRDRC1TRFhMLUxvUkElMjIlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoYmFzZV9tb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKS50byhkZXZpY2UpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBUQ0RTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHModGNkX2xvcmFfaWQpJTBBcGlwZS5mdXNlX2xvcmEoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBtYW4lMkMlMjBjbGFkJTIwaW4lMjBhJTIwbWV0aWN1bG91c2x5JTIwdGFpbG9yZWQlMjBtaWxpdGFyeSUyMHVuaWZvcm0lMkMlMjBzdGFuZHMlMjB3aXRoJTIwdW53YXZlcmluZyUyMHJlc29sdmUuJTIwVGhlJTIwdW5pZm9ybSUyMGJvYXN0cyUyMGludHJpY2F0ZSUyMGRldGFpbHMlMkMlMjBhbmQlMjBoaXMlMjBleWVzJTIwZ2xlYW0lMjB3aXRoJTIwZGV0ZXJtaW5hdGlvbi4lMjBTdHJhbmRzJTIwb2YlMjB2aWJyYW50JTJDJTIwd2luZHN3ZXB0JTIwaGFpciUyMHBlZWslMjBvdXQlMjBmcm9tJTIwYmVuZWF0aCUyMHRoZSUyMGJyaW0lMjBvZiUyMGhpcyUyMGNhcC4lMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDglMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAlMkMlMEElMjAlMjAlMjAlMjBldGElM0QwLjMlMkMlMjAlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEZGV2aWNlKS5tYW51YWxfc2VlZCgwKSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, TCDScheduler

device = <span class="hljs-string">&quot;cuda&quot;</span>
base_model_id = <span class="hljs-string">&quot;cagliostrolab/animagine-xl-3.0&quot;</span>
tcd_lora_id = <span class="hljs-string">&quot;h1t/TCD-SDXL-LoRA&quot;</span>

pipe = StableDiffusionXLPipeline.from_pretrained(base_model_id, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>).to(device)
pipe.scheduler = TCDScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(tcd_lora_id)
pipe.fuse_lora()

prompt = <span class="hljs-string">&quot;A man, clad in a meticulously tailored military uniform, stands with unwavering resolve. The uniform boasts intricate details, and his eyes gleam with determination. Strands of vibrant, windswept hair peek out from beneath the brim of his cap.&quot;</span>

image = pipe(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">8</span>,
    guidance_scale=<span class="hljs-number">0</span>,
    eta=<span class="hljs-number">0.3</span>, 
    generator=torch.Generator(device=device).manual_seed(<span class="hljs-number">0</span>),
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),k=new Cl({props:{warning:!1,$$slots:{default:[oe]},$$scope:{ctx:G}}}),P=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQWZyb20lMjBzY2hlZHVsaW5nX3RjZCUyMGltcG9ydCUyMFRDRFNjaGVkdWxlciUyMCUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEFiYXNlX21vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBdGNkX2xvcmFfaWQlMjAlM0QlMjAlMjJoMXQlMkZUQ0QtU0RYTC1Mb1JBJTIyJTBBc3R5bGVkX2xvcmFfaWQlMjAlM0QlMjAlMjJUaGVMYXN0QmVuJTJGUGFwZXJjdXRfU0RYTCUyMiUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpLnRvKGRldmljZSklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMFRDRFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBJTBBcGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyh0Y2RfbG9yYV9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnRjZCUyMiklMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKHN0eWxlZF9sb3JhX2lkJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyc3R5bGUlMjIpJTBBcGlwZS5zZXRfYWRhcHRlcnMoJTVCJTIydGNkJTIyJTJDJTIwJTIyc3R5bGUlMjIlNUQlMkMlMjBhZGFwdGVyX3dlaWdodHMlM0QlNUIxLjAlMkMlMjAxLjAlNUQpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIycGFwZXJjdXQlMjBvZiUyMGElMjB3aW50ZXIlMjBtb3VudGFpbiUyQyUyMHNub3clMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAlMkMlMEElMjAlMjAlMjAlMjBldGElM0QwLjMlMkMlMjAlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEZGV2aWNlKS5tYW51YWxfc2VlZCgwKSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">from</span> scheduling_tcd <span class="hljs-keyword">import</span> TCDScheduler 

device = <span class="hljs-string">&quot;cuda&quot;</span>
base_model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
tcd_lora_id = <span class="hljs-string">&quot;h1t/TCD-SDXL-LoRA&quot;</span>
styled_lora_id = <span class="hljs-string">&quot;TheLastBen/Papercut_SDXL&quot;</span>

pipe = StableDiffusionXLPipeline.from_pretrained(base_model_id, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>).to(device)
pipe.scheduler = TCDScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(tcd_lora_id, adapter_name=<span class="hljs-string">&quot;tcd&quot;</span>)
pipe.load_lora_weights(styled_lora_id, adapter_name=<span class="hljs-string">&quot;style&quot;</span>)
pipe.set_adapters([<span class="hljs-string">&quot;tcd&quot;</span>, <span class="hljs-string">&quot;style&quot;</span>], adapter_weights=[<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>])

prompt = <span class="hljs-string">&quot;papercut of a winter mountain, snow&quot;</span>

image = pipe(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">0</span>,
    eta=<span class="hljs-number">0.3</span>, 
    generator=torch.Generator(device=device).manual_seed(<span class="hljs-number">0</span>),
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ll=new sl({props:{title:"Adapters",local:"adapters",headingTag:"h2"}}),V=new xl({props:{id:"adapters",options:["ControlNet","IP-Adapter","AnimateDiff"],$$slots:{default:[de]},$$scope:{ctx:G}}}),{c(){e=h("meta"),m=d(),t=h("p"),M=d(),T(p.$$.fragment),i=d(),T(o.$$.fragment),J=d(),r=h("p"),r.textContent=Z,R=d(),C=h("p"),C.textContent=tl,_=d(),B=h("ul"),B.innerHTML=E,c=d(),T(g.$$.fragment),Q=d(),Y=h("p"),Y.innerHTML=Rl,pl=d(),v=h("p"),v.textContent=_l,ol=d(),F=h("table"),F.innerHTML=Il,rl=d(),N=h("p"),N.innerHTML=Xl,cl=d(),T(S.$$.fragment),ml=d(),T($.$$.fragment),Ml=d(),A=h("p"),A.innerHTML=kl,dl=d(),D=h("p"),D.textContent=Vl,ul=d(),H=h("ul"),H.innerHTML=El,Jl=d(),T(X.$$.fragment),hl=d(),T(z.$$.fragment),yl=d(),x=h("p"),x.innerHTML=Ql,Tl=d(),T(L.$$.fragment),bl=d(),q=h("p"),q.innerHTML=Yl,wl=d(),K=h("p"),K.innerHTML=vl,fl=d(),T(k.$$.fragment),jl=d(),T(P.$$.fragment),Ul=d(),O=h("p"),O.innerHTML=Fl,Zl=d(),T(ll.$$.fragment),gl=d(),el=h("p"),el.textContent=Nl,Wl=d(),T(V.$$.fragment),Gl=d(),nl=h("p"),this.h()},l(l){const n=Ol("svelte-u9bgzb",document.head);e=y(n,"META",{name:!0,content:!0}),n.forEach(s),m=u(l),t=y(l,"P",{}),Hl(t).forEach(s),M=u(l),b(p.$$.fragment,l),i=u(l),b(o.$$.fragment,l),J=u(l),r=y(l,"P",{"data-svelte-h":!0}),W(r)!=="svelte-1ipiy2w"&&(r.textContent=Z),R=u(l),C=y(l,"P",{"data-svelte-h":!0}),W(C)!=="svelte-lghdda"&&(C.textContent=tl),_=u(l),B=y(l,"UL",{"data-svelte-h":!0}),W(B)!=="svelte-s8ifhe"&&(B.innerHTML=E),c=u(l),b(g.$$.fragment,l),Q=u(l),Y=y(l,"P",{"data-svelte-h":!0}),W(Y)!=="svelte-ss6l19"&&(Y.innerHTML=Rl),pl=u(l),v=y(l,"P",{"data-svelte-h":!0}),W(v)!=="svelte-4sxfqt"&&(v.textContent=_l),ol=u(l),F=y(l,"TABLE",{"data-svelte-h":!0}),W(F)!=="svelte-1fsvavz"&&(F.innerHTML=Il),rl=u(l),N=y(l,"P",{"data-svelte-h":!0}),W(N)!=="svelte-18m9u5y"&&(N.innerHTML=Xl),cl=u(l),b(S.$$.fragment,l),ml=u(l),b($.$$.fragment,l),Ml=u(l),A=y(l,"P",{"data-svelte-h":!0}),W(A)!=="svelte-vxhz5z"&&(A.innerHTML=kl),dl=u(l),D=y(l,"P",{"data-svelte-h":!0}),W(D)!=="svelte-49ynuh"&&(D.textContent=Vl),ul=u(l),H=y(l,"UL",{"data-svelte-h":!0}),W(H)!=="svelte-8y919q"&&(H.innerHTML=El),Jl=u(l),b(X.$$.fragment,l),hl=u(l),b(z.$$.fragment,l),yl=u(l),x=y(l,"P",{"data-svelte-h":!0}),W(x)!=="svelte-188pw20"&&(x.innerHTML=Ql),Tl=u(l),b(L.$$.fragment,l),bl=u(l),q=y(l,"P",{"data-svelte-h":!0}),W(q)!=="svelte-iffd98"&&(q.innerHTML=Yl),wl=u(l),K=y(l,"P",{"data-svelte-h":!0}),W(K)!=="svelte-2dsdn0"&&(K.innerHTML=vl),fl=u(l),b(k.$$.fragment,l),jl=u(l),b(P.$$.fragment,l),Ul=u(l),O=y(l,"P",{"data-svelte-h":!0}),W(O)!=="svelte-64b3tk"&&(O.innerHTML=Fl),Zl=u(l),b(ll.$$.fragment,l),gl=u(l),el=y(l,"P",{"data-svelte-h":!0}),W(el)!=="svelte-jvx8ap"&&(el.textContent=Nl),Wl=u(l),b(V.$$.fragment,l),Gl=u(l),nl=y(l,"P",{}),Hl(nl).forEach(s),this.h()},h(){zl(e,"name","hf:doc:metadata"),zl(e,"content",Je)},m(l,n){le(document.head,e),a(l,m,n),a(l,t,n),a(l,M,n),w(p,l,n),a(l,i,n),w(o,l,n),a(l,J,n),a(l,r,n),a(l,R,n),a(l,C,n),a(l,_,n),a(l,B,n),a(l,c,n),w(g,l,n),a(l,Q,n),a(l,Y,n),a(l,pl,n),a(l,v,n),a(l,ol,n),a(l,F,n),a(l,rl,n),a(l,N,n),a(l,cl,n),w(S,l,n),a(l,ml,n),w($,l,n),a(l,Ml,n),a(l,A,n),a(l,dl,n),a(l,D,n),a(l,ul,n),a(l,H,n),a(l,Jl,n),w(X,l,n),a(l,hl,n),w(z,l,n),a(l,yl,n),a(l,x,n),a(l,Tl,n),w(L,l,n),a(l,bl,n),a(l,q,n),a(l,wl,n),a(l,K,n),a(l,fl,n),w(k,l,n),a(l,jl,n),w(P,l,n),a(l,Ul,n),a(l,O,n),a(l,Zl,n),w(ll,l,n),a(l,gl,n),a(l,el,n),a(l,Wl,n),w(V,l,n),a(l,Gl,n),a(l,nl,n),Bl=!0},p(l,[n]){const Sl={};n&2&&(Sl.$$scope={dirty:n,ctx:l}),g.$set(Sl);const $l={};n&2&&($l.$$scope={dirty:n,ctx:l}),X.$set($l);const Al={};n&2&&(Al.$$scope={dirty:n,ctx:l}),k.$set(Al);const Dl={};n&2&&(Dl.$$scope={dirty:n,ctx:l}),V.$set(Dl)},i(l){Bl||(f(p.$$.fragment,l),f(o.$$.fragment,l),f(g.$$.fragment,l),f(S.$$.fragment,l),f($.$$.fragment,l),f(X.$$.fragment,l),f(z.$$.fragment,l),f(L.$$.fragment,l),f(k.$$.fragment,l),f(P.$$.fragment,l),f(ll.$$.fragment,l),f(V.$$.fragment,l),Bl=!0)},o(l){j(p.$$.fragment,l),j(o.$$.fragment,l),j(g.$$.fragment,l),j(S.$$.fragment,l),j($.$$.fragment,l),j(X.$$.fragment,l),j(z.$$.fragment,l),j(L.$$.fragment,l),j(k.$$.fragment,l),j(P.$$.fragment,l),j(ll.$$.fragment,l),j(V.$$.fragment,l),Bl=!1},d(l){l&&(s(m),s(t),s(M),s(i),s(J),s(r),s(R),s(C),s(_),s(B),s(c),s(Q),s(Y),s(pl),s(v),s(ol),s(F),s(rl),s(N),s(cl),s(ml),s(Ml),s(A),s(dl),s(D),s(ul),s(H),s(Jl),s(hl),s(yl),s(x),s(Tl),s(bl),s(q),s(wl),s(K),s(fl),s(jl),s(Ul),s(O),s(Zl),s(gl),s(el),s(Wl),s(Gl),s(nl)),s(e),U(p,l),U(o,l),U(g,l),U(S,l),U($,l),U(X,l),U(z,l),U(L,l),U(k,l),U(P,l),U(ll,l),U(V,l)}}}const Je='{"title":"Trajectory Consistency Distillation-LoRA","local":"trajectory-consistency-distillation-lora","sections":[{"title":"General tasks","local":"general-tasks","sections":[],"depth":2},{"title":"Community models","local":"community-models","sections":[],"depth":2},{"title":"Adapters","local":"adapters","sections":[{"title":"Depth ControlNet","local":"depth-controlnet","sections":[],"depth":3},{"title":"Canny ControlNet","local":"canny-controlnet","sections":[],"depth":3}],"depth":2}],"depth":1}';function he(G){return ql(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends Kl{constructor(e){super(),Pl(this,e,he,ue,Ll,{})}}export{Ze as component};
