import{s as Yt,o as St,n as $}from"../chunks/scheduler.182ea377.js";import{S as qt,i as xt,g as r,s as a,r as y,A as Dt,h as f,f as l,c as p,j as Nt,u as h,x as u,k as is,y as Ft,a as t,v as U,d as T,t as J,w as b}from"../chunks/index.abf12888.js";import{T as Rl}from"../chunks/Tip.230e2334.js";import{C as Z}from"../chunks/CodeBlock.57fe6e13.js";import{D as zt}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as _}from"../chunks/Heading.16916d63.js";import{H as Xl,a as ns}from"../chunks/HfOption.fc88c804.js";function At(w){let i,M='Skip to the <a href="#diffusionpipeline-explained">DiffusionPipeline explained</a> section if you’re interested in an explanation about how the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class works.';return{c(){i=r("p"),i.innerHTML=M},l(n){i=f(n,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1u8oykr"&&(i.innerHTML=M)},m(n,d){t(n,i,d)},p:$,d(n){n&&l(i)}}}function Ht(w){let i,M='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class is a simple and generic way to load the latest trending diffusion model from the <a href="https://huggingface.co/models?library=diffusers&amp;sort=trending" rel="nofollow">Hub</a>. It uses the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method to automatically detect the correct pipeline class for a task from the checkpoint, downloads and caches all the required configuration and weight files, and returns a pipeline ready for inference.',n,d,o,c,j='This same checkpoint can also be used for an image-to-image task. The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class can handle any task as long as you provide the appropriate inputs. For example, for an image-to-image task, you need to pass an initial image to the pipeline.',g,I,v;return d=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),I=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>)
prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=r("p"),i.innerHTML=M,n=a(),y(d.$$.fragment),o=a(),c=r("p"),c.innerHTML=j,g=a(),y(I.$$.fragment)},l(m){i=f(m,"P",{"data-svelte-h":!0}),u(i)!=="svelte-193oq91"&&(i.innerHTML=M),n=p(m),h(d.$$.fragment,m),o=p(m),c=f(m,"P",{"data-svelte-h":!0}),u(c)!=="svelte-1thtl5s"&&(c.innerHTML=j),g=p(m),h(I.$$.fragment,m)},m(m,C){t(m,i,C),t(m,n,C),U(d,m,C),t(m,o,C),t(m,c,C),t(m,g,C),U(I,m,C),v=!0},p:$,i(m){v||(T(d.$$.fragment,m),T(I.$$.fragment,m),v=!0)},o(m){J(d.$$.fragment,m),J(I.$$.fragment,m),v=!1},d(m){m&&(l(i),l(n),l(o),l(c),l(g)),b(d,m),b(I,m)}}}function Et(w){let i,M='Checkpoints can be loaded by their specific pipeline class if you already know it. For example, to load a Stable Diffusion model, use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> class.',n,d,o,c,j='This same checkpoint may also be used for another task like image-to-image. To differentiate what task you want to use the checkpoint for, you have to use the corresponding task-specific pipeline class. For example, to use the same checkpoint for image-to-image, use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a> class.',g,I,v;return d=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),I=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline

pipeline = StableDiffusionImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){i=r("p"),i.innerHTML=M,n=a(),y(d.$$.fragment),o=a(),c=r("p"),c.innerHTML=j,g=a(),y(I.$$.fragment)},l(m){i=f(m,"P",{"data-svelte-h":!0}),u(i)!=="svelte-b1p9rv"&&(i.innerHTML=M),n=p(m),h(d.$$.fragment,m),o=p(m),c=f(m,"P",{"data-svelte-h":!0}),u(c)!=="svelte-14muyt8"&&(c.innerHTML=j),g=p(m),h(I.$$.fragment,m)},m(m,C){t(m,i,C),t(m,n,C),U(d,m,C),t(m,o,C),t(m,c,C),t(m,g,C),U(I,m,C),v=!0},p:$,i(m){v||(T(d.$$.fragment,m),T(I.$$.fragment,m),v=!0)},o(m){J(d.$$.fragment,m),J(I.$$.fragment,m),v=!1},d(m){m&&(l(i),l(n),l(o),l(c),l(g)),b(d,m),b(I,m)}}}function Lt(w){let i,M,n,d;return i=new ns({props:{id:"pipelines",option:"generic pipeline",$$slots:{default:[Ht]},$$scope:{ctx:w}}}),n=new ns({props:{id:"pipelines",option:"specific pipeline",$$slots:{default:[Et]},$$scope:{ctx:w}}}),{c(){y(i.$$.fragment),M=a(),y(n.$$.fragment)},l(o){h(i.$$.fragment,o),M=p(o),h(n.$$.fragment,o)},m(o,c){U(i,o,c),t(o,M,c),U(n,o,c),d=!0},p(o,c){const j={};c&2&&(j.$$scope={dirty:c,ctx:o}),i.$set(j);const g={};c&2&&(g.$$scope={dirty:c,ctx:o}),n.$set(g)},i(o){d||(T(i.$$.fragment,o),T(n.$$.fragment,o),d=!0)},o(o){J(i.$$.fragment,o),J(n.$$.fragment,o),d=!1},d(o){o&&l(M),b(i,o),b(n,o)}}}function Pt(w){let i,M='Some pipeline methods may not function properly on new pipelines created with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a>. For instance, the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> method installs hooks on the model components based on a unique offloading sequence for each pipeline. If the models are executed in a different order in the new pipeline, the CPU offloading may not work correctly.',n,d,o='To ensure everything works as expected, we recommend re-applying a pipeline method on a new pipeline created with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a>.';return{c(){i=r("p"),i.innerHTML=M,n=a(),d=r("p"),d.innerHTML=o},l(c){i=f(c,"P",{"data-svelte-h":!0}),u(i)!=="svelte-150boki"&&(i.innerHTML=M),n=p(c),d=f(c,"P",{"data-svelte-h":!0}),u(d)!=="svelte-gydtfi"&&(d.innerHTML=o)},m(c,j){t(c,i,j),t(c,n,j),t(c,d,j)},p:$,d(c){c&&(l(i),l(n),l(d))}}}function Ot(w){let i,M='When the checkpoints have identical model structures, but they were trained on different datasets and with a different training setup, they should be stored in separate repositories. For example, <a href="https://hf.co/stabilityai/stable-diffusion-2" rel="nofollow">stabilityai/stable-diffusion-2</a> and <a href="https://hf.co/stabilityai/stable-diffusion-2-1" rel="nofollow">stabilityai/stable-diffusion-2-1</a> are stored in separate repositories.';return{c(){i=r("p"),i.innerHTML=M},l(n){i=f(n,"P",{"data-svelte-h":!0}),u(i)!=="svelte-11b88rc"&&(i.innerHTML=M)},m(n,d){t(n,i,d)},p:$,d(n){n&&l(i)}}}function Kt(w){let i,M;return i=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),{c(){y(i.$$.fragment)},l(n){h(i.$$.fragment,n)},m(n,d){U(i,n,d),M=!0},p:$,i(n){M||(T(i.$$.fragment,n),M=!0)},o(n){J(i.$$.fragment,n),M=!1},d(n){b(i,n)}}}function ei(w){let i,M;return i=new Z({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIybm9uX2VtYSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),{c(){y(i.$$.fragment)},l(n){h(i.$$.fragment,n)},m(n,d){U(i,n,d),M=!0},p:$,i(n){M||(T(i.$$.fragment,n),M=!0)},o(n){J(i.$$.fragment,n),M=!1},d(n){b(i,n)}}}function si(w){let i,M,n,d;return i=new ns({props:{id:"variants",option:"fp16",$$slots:{default:[Kt]},$$scope:{ctx:w}}}),n=new ns({props:{id:"variants",option:"non-EMA",$$slots:{default:[ei]},$$scope:{ctx:w}}}),{c(){y(i.$$.fragment),M=a(),y(n.$$.fragment)},l(o){h(i.$$.fragment,o),M=p(o),h(n.$$.fragment,o)},m(o,c){U(i,o,c),t(o,M,c),U(n,o,c),d=!0},p(o,c){const j={};c&2&&(j.$$scope={dirty:c,ctx:o}),i.$set(j);const g={};c&2&&(g.$$scope={dirty:c,ctx:o}),n.$set(g)},i(o){d||(T(i.$$.fragment,o),T(n.$$.fragment,o),d=!0)},o(o){J(i.$$.fragment,o),J(n.$$.fragment,o),d=!1},d(o){o&&l(M),b(i,o),b(n,o)}}}function li(w){let i,M;return i=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline.save_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)`,wrap:!1}}),{c(){y(i.$$.fragment)},l(n){h(i.$$.fragment,n)},m(n,d){U(i,n,d),M=!0},p:$,i(n){M||(T(i.$$.fragment,n),M=!0)},o(n){J(i.$$.fragment,n),M=!1},d(n){b(i,n)}}}function ti(w){let i,M;return i=new Z({props:{code:"cGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdmFyaWFudCUzRCUyMm5vbl9lbWElMjIp",highlighted:'pipeline.save_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)',wrap:!1}}),{c(){y(i.$$.fragment)},l(n){h(i.$$.fragment,n)},m(n,d){U(i,n,d),M=!0},p:$,i(n){M||(T(i.$$.fragment,n),M=!0)},o(n){J(i.$$.fragment,n),M=!1},d(n){b(i,n)}}}function ii(w){let i,M,n,d;return i=new ns({props:{id:"save",option:"fp16",$$slots:{default:[li]},$$scope:{ctx:w}}}),n=new ns({props:{id:"save",option:"non_ema",$$slots:{default:[ti]},$$scope:{ctx:w}}}),{c(){y(i.$$.fragment),M=a(),y(n.$$.fragment)},l(o){h(i.$$.fragment,o),M=p(o),h(n.$$.fragment,o)},m(o,c){U(i,o,c),t(o,M,c),U(n,o,c),d=!0},p(o,c){const j={};c&2&&(j.$$scope={dirty:c,ctx:o}),i.$set(j);const g={};c&2&&(g.$$scope={dirty:c,ctx:o}),n.$set(g)},i(o){d||(T(i.$$.fragment,o),T(n.$$.fragment,o),d=!0)},o(o){J(i.$$.fragment,o),J(n.$$.fragment,o),d=!1},d(o){o&&l(M),b(i,o),b(n,o)}}}function ni(w){let i,M,n,d,o,c,j,g,I,v='Diffusion systems consist of multiple components like parameterized models and schedulers that interact in complex ways. That is why we designed the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to wrap the complexity of the entire diffusion system into an easy-to-use API. At the same time, the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is entirely customizable so you can modify each component to build a diffusion system for your use case.',m,C,Ql="This guide will show you how to load:",ps,q,Nl="<li>pipelines from the Hub and locally</li> <li>different components into a pipeline</li> <li>multiple pipelines without increasing memory usage</li> <li>checkpoint variants such as different floating point types or non-exponential mean averaged (EMA) weights</li>",os,x,rs,G,fs,D,Yl="There are two ways to load a pipeline for a task:",us,F,Sl='<li>Load the generic <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class and allow it to automatically detect the correct pipeline class from the checkpoint.</li> <li>Load a specific pipeline class for a specific task.</li>',cs,V,ms,z,ql="Use the Space below to gauge a pipeline’s memory requirements before you download and load it to see if it runs on your hardware.",ds,k,xl='<iframe src="https://diffusers-compute-pipeline-size.hf.space?__theme=light" width="850" height="1600"></iframe>',Ms,W,Dl='<iframe src="https://diffusers-compute-pipeline-size.hf.space?__theme=dark" width="850" height="1600"></iframe>',ys,A,hs,H,Fl='To load a pipeline locally, use <a href="https://git-lfs.github.com/" rel="nofollow">git-lfs</a> to manually download a checkpoint to your local disk.',Us,E,Ts,L,zl='This creates a local folder, ./stable-diffusion-v1-5, on your disk and you should pass its path to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a>.',Js,P,bs,O,Al='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method won’t download files from the Hub when it detects a local path, but this also means it won’t download and cache the latest changes to a checkpoint.',ws,K,js,ee,Hl="You can customize a pipeline by loading different components into it. This is important because you can:",Zs,se,El="<li>change to a scheduler with faster generation speed or higher generation quality depending on your needs (call the <code>scheduler.compatibles</code> method on your pipeline to see compatible schedulers)</li> <li>change a default pipeline component to a newer and better performing one</li>",gs,le,Ll='For example, let’s customize the default <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> checkpoint with:',Is,te,Pl='<li>The <a href="/docs/diffusers/main/en/api/schedulers/heun#diffusers.HeunDiscreteScheduler">HeunDiscreteScheduler</a> to generate higher quality images at the expense of slower generation speed. You must pass the <code>subfolder=&quot;scheduler&quot;</code> parameter in <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">from_pretrained()</a> to load the scheduler configuration into the correct <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0/tree/main/scheduler" rel="nofollow">subfolder</a> of the pipeline repository.</li> <li>A more stable VAE that runs in fp16.</li>',Cs,ie,vs,ne,Ol='Now pass the new scheduler and VAE to the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>.',_s,ae,$s,pe,Gs,oe,Kl="When you load multiple pipelines that share the same model components, it makes sense to reuse the shared components instead of reloading everything into memory again, especially if your hardware is memory-constrained. For example:",Vs,re,et='<li>You generated an image with the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> but you want to improve its quality with the <a href="/docs/diffusers/main/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a>. Both of these pipelines share the same pretrained model, so it’d be a waste of memory to load the same model twice.</li> <li>You want to add a model component, like a <a href="../api/pipelines/animatediff#animatediffpipeline"><code>MotionAdapter</code></a>, to <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> which was instantiated from an existing <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>. Again, both pipelines share the same pretrained model, so it’d be a waste of memory to load an entirely new pipeline again.</li>',ks,fe,st='With the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">DiffusionPipeline.from_pipe()</a> API, you can switch between multiple pipelines to take advantage of their different features without increasing memory-usage. It is similar to turning on and off a feature in your pipeline. To switch between tasks, use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> method with the <a href="../api/pipelines/auto_pipeline"><code>AutoPipeline</code></a> class, which automatically identifies the pipeline class based on the task (learn more in the <a href="../tutorials/autopipeline">AutoPipeline</a> tutorial).',Ws,ue,lt='Let’s start with a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> and then reuse the loaded model components to create a <a href="/docs/diffusers/main/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a> to increase generation quality. You’ll use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> with an <a href="./ip_adapter">IP-Adapter</a> to generate a bear eating pizza.',Bs,ce,Rs,B,tt='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_sd_0.png"/>',Xs,me,it="For reference, you can check how much memory this process consumed.",Qs,de,Ns,Me,nt='Now, reuse the same pipeline components from <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> in <a href="/docs/diffusers/main/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a> with the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> method.',Ys,R,Ss,ye,qs,X,at='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_sag_1.png"/>',xs,he,pt='If you check the memory usage, you’ll see it remains the same as before because <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> and <a href="/docs/diffusers/main/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a> are sharing the same pipeline components. This allows you to use them interchangeably without any additional memory overhead.',Ds,Ue,Fs,Te,ot='Let’s animate the image with the <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> and also add a <code>MotionAdapter</code> module to the pipeline. For the <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>, you need to unload the IP-Adapter first and reload it <em>after</em> you’ve created your new pipeline (this only applies to the <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>).',zs,Je,As,Q,rt='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_animate_3.gif"/>',Hs,be,ft='The <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> is more memory-intensive and consumes 15GB of memory (see the <a href="#memory-usage-of-from_pipe">Memory-usage of from_pipe</a> section to learn what this means for your memory-usage).',Es,we,Ls,je,Ps,Ze,ut='Pipelines loaded with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> can be customized with different model components or methods. However, whenever you modify the <em>state</em> of the model components, it affects all the other pipelines that share the same components. For example, if you call <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.unload_ip_adapter">unload_ip_adapter()</a> on the <a href="/docs/diffusers/main/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a>, you won’t be able to use IP-Adapter with the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> because it’s been removed from their shared components.',Os,ge,Ks,Ie,el,Ce,ct='The memory requirement of loading multiple pipelines with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> is determined by the pipeline with the highest memory-usage regardless of the number of pipelines you create.',sl,ve,mt="<thead><tr><th>Pipeline</th> <th>Memory usage (GB)</th></tr></thead> <tbody><tr><td>StableDiffusionPipeline</td> <td>4.400</td></tr> <tr><td>StableDiffusionSAGPipeline</td> <td>4.400</td></tr> <tr><td>AnimateDiffPipeline</td> <td>15.178</td></tr></tbody>",ll,_e,dt='The <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> has the highest memory requirement, so the <em>total memory-usage</em> is based only on the <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>. Your memory-usage will not increase if you create additional pipelines as long as their memory requirements doesn’t exceed that of the <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>. Each pipeline can be used interchangeably without any additional memory overhead.',tl,$e,il,Ge,Mt='Diffusers implements a <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow">safety checker</a> for Stable Diffusion models which can generate harmful content. The safety checker screens the generated output against known hardcoded not-safe-for-work (NSFW) content. If for whatever reason you’d like to disable the safety checker, pass <code>safety_checker=None</code> to the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method.',nl,Ve,al,ke,pl,We,yt="A checkpoint variant is usually a checkpoint whose weights are:",ol,Be,ht='<li>Stored in a different floating point type, such as <a href="https://pytorch.org/docs/stable/tensors.html#data-types" rel="nofollow">torch.float16</a>, because it only requires half the bandwidth and storage to download. You can’t use this variant if you’re continuing training or using a CPU.</li> <li>Non-exponential mean averaged (EMA) weights which shouldn’t be used for inference. You should use this variant to continue finetuning a model.</li>',rl,N,fl,Re,Ut='Otherwise, a variant is <strong>identical</strong> to the original checkpoint. They have exactly the same serialization format (like <a href="./using_safetensors">safetensors</a>), model structure, and their weights have identical tensor shapes.',ul,Xe,Tt="<thead><tr><th><strong>checkpoint type</strong></th> <th><strong>weight name</strong></th> <th><strong>argument for loading weights</strong></th></tr></thead> <tbody><tr><td>original</td> <td>diffusion_pytorch_model.safetensors</td> <td></td></tr> <tr><td>floating point</td> <td>diffusion_pytorch_model.fp16.safetensors</td> <td><code>variant</code>, <code>torch_dtype</code></td></tr> <tr><td>non-EMA</td> <td>diffusion_pytorch_model.non_ema.safetensors</td> <td><code>variant</code></td></tr></tbody>",cl,Qe,Jt="There are two important arguments for loading variants:",ml,Ne,bt='<li><p><code>torch_dtype</code> specifies the floating point precision of the loaded checkpoint. For example, if you want to save bandwidth by loading a fp16 variant, you should set <code>variant=&quot;fp16&quot;</code> and <code>torch_dtype=torch.float16</code> to <em>convert the weights</em> to fp16. Otherwise, the fp16 weights are converted to the default fp32 precision.</p> <p>If you only set <code>torch_dtype=torch.float16</code>, the default fp32 weights are downloaded first and then converted to fp16.</p></li> <li><p><code>variant</code> specifies which files should be loaded from the repository. For example, if you want to load a non-EMA variant of a UNet from <a href="https://hf.co/runwayml/stable-diffusion-v1-5/tree/main/unet" rel="nofollow">runwayml/stable-diffusion-v1-5</a>, set <code>variant=&quot;non_ema&quot;</code> to download the <code>non_ema</code> file.</p></li>',dl,Y,Ml,Ye,wt='Use the <code>variant</code> parameter in the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">DiffusionPipeline.save_pretrained()</a> method to save a checkpoint as a different floating point type or as a non-EMA variant. You should try save a variant to the same folder as the original checkpoint, so you have the option of loading both from the same folder.',yl,S,hl,Se,jt="If you don’t save the variant to an existing folder, you must specify the <code>variant</code> argument otherwise it’ll throw an <code>Exception</code> because it can’t find the original checkpoint.",Ul,qe,Tl,xe,Jl,De,Zt='As a class method, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> is responsible for two things:',bl,Fe,gt='<li>Download the latest version of the folder structure required for inference and cache it. If the latest folder structure is available in the local cache, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> reuses the cache and won’t redownload the files.</li> <li>Load the cached weights into the correct pipeline <a href="../api/pipelines/overview#diffusers-summary">class</a> - retrieved from the <code>model_index.json</code> file - and return an instance of it.</li>',wl,ze,It='The pipelines’ underlying folder structure corresponds directly with their class instances. For example, the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> corresponds to the folder structure in <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>.',jl,Ae,Zl,He,Ct='You’ll see pipeline is an instance of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, which consists of seven components:',gl,Ee,vt='<li><code>&quot;feature_extractor&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a> from 🤗 Transformers.</li> <li><code>&quot;safety_checker&quot;</code>: a <a href="https://github.com/huggingface/diffusers/blob/e55687e1e15407f60f32242027b7bb8170e58266/src/diffusers/pipelines/stable_diffusion/safety_checker.py#L32" rel="nofollow">component</a> for screening against harmful content.</li> <li><code>&quot;scheduler&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.</li> <li><code>&quot;text_encoder&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a> from 🤗 Transformers.</li> <li><code>&quot;tokenizer&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> from 🤗 Transformers.</li> <li><code>&quot;unet&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>.</li> <li><code>&quot;vae&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>.</li>',Il,Le,Cl,Pe,_t='Compare the components of the pipeline instance to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> folder structure, and you’ll see there is a separate folder for each of the components in the repository:',vl,Oe,_l,Ke,$t="You can access each of the components of the pipeline as an attribute to view its configuration:",$l,es,Gl,ss,Gt='Every pipeline expects a <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code></a> file that tells the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',Vl,ls,Vt="<li>which pipeline class to load from <code>_class_name</code></li> <li>which version of 🧨 Diffusers was used to create the model in <code>_diffusers_version</code></li> <li>what components from which library are stored in the subfolders (<code>name</code> corresponds to the component and subfolder name, <code>library</code> corresponds to the name of the library to load the class from, and <code>class</code> corresponds to the class name)</li>",kl,ts,Wl,as,Bl;return o=new _({props:{title:"Load pipelines",local:"load-pipelines",headingTag:"h1"}}),j=new zt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"}]}}),x=new _({props:{title:"Load a pipeline",local:"load-a-pipeline",headingTag:"h2"}}),G=new Rl({props:{warning:!1,$$slots:{default:[At]},$$scope:{ctx:w}}}),V=new Xl({props:{id:"pipelines",options:["generic pipeline","specific pipeline"],$$slots:{default:[Lt]},$$scope:{ctx:w}}}),A=new _({props:{title:"Local pipeline",local:"local-pipeline",headingTag:"h3"}}),E=new Z({props:{code:"Z2l0LWxmcyUyMGluc3RhbGwlMEFnaXQlMjBjbG9uZSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNQ==",highlighted:`git-lfs install
git <span class="hljs-built_in">clone</span> https://huggingface.co/runwayml/stable-diffusion-v1-5`,wrap:!1}}),P=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjIuJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

stable_diffusion = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),K=new _({props:{title:"Customize a pipeline",local:"customize-a-pipeline",headingTag:"h2"}}),ie=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBIZXVuRGlzY3JldGVTY2hlZHVsZXIlMkMlMjBBdXRvZW5jb2RlcktMJTBBaW1wb3J0JTIwdG9yY2glMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBIZXVuRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJtYWRlYnlvbGxpbiUyRnNkeGwtdmFlLWZwMTYtZml4JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, HeunDiscreteScheduler, AutoencoderKL
<span class="hljs-keyword">import</span> torch

scheduler = HeunDiscreteScheduler.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),ae=new Z({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjAlMEElMjAlMjBzY2hlZHVsZXIlM0RzY2hlZHVsZXIlMkMlMjAlMEElMjAlMjB2YWUlM0R2YWUlMkMlMjAlMEElMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjAlMEElMjAlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMCUwQSUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIp",highlighted:`pipeline = StableDiffusionXLPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, 
  scheduler=scheduler, 
  vae=vae, 
  torch_dtype=torch.float16, 
  variant=<span class="hljs-string">&quot;fp16&quot;</span>, 
  use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),pe=new _({props:{title:"Reuse a pipeline",local:"reuse-a-pipeline",headingTag:"h2"}}),ce=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uU0FHUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMGdjJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMGNvbXB1dGVfbW9kdWxlX3NpemVzJTBBJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmxvYWRfbmVnX2VtYmVkLnBuZyUyMiklMEElMEFwaXBlX3NkJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlNHMTYxMjIyJTJGUmVhbGlzdGljX1Zpc2lvbl9WNi4wX0IxX25vVkFFJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVfc2QubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJtb2RlbHMlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMmlwLWFkYXB0ZXJfc2QxNS5iaW4lMjIpJTBBcGlwZV9zZC5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYpJTBBcGlwZV9zZC50byglMjJjdWRhJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDMzKSUwQW91dF9zZCUyMCUzRCUyMHBpcGVfc2QoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVhciUyMGVhdHMlMjBwaXp6YSUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMndyb25nJTIwd2hpdGUlMjBiYWxhbmNlJTJDJTIwZGFyayUyQyUyMHNrZXRjaGVzJTJDd29yc3QlMjBxdWFsaXR5JTJDbG93JTIwcXVhbGl0eSUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQW91dF9zZA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, StableDiffusionSAGPipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> gc
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> compute_module_sizes

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/load_neg_embed.png&quot;</span>)

pipe_sd = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>, torch_dtype=torch.float16)
pipe_sd.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipe_sd.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)
pipe_sd.to(<span class="hljs-string">&quot;cuda&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
out_sd = pipe_sd(
    prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>, 
    ip_adapter_image=image,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
out_sd`,wrap:!1}}),de=new Z({props:{code:"ZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUwQXByaW50KGYlMjJNYXglMjBtZW1vcnklMjBhbGxvY2F0ZWQlM0ElMjAlN0JieXRlc190b19naWdhX2J5dGVzKHRvcmNoLmN1ZGEubWF4X21lbW9yeV9hbGxvY2F0ZWQoKSklN0QlMjBHQiUyMiklMEElMjJNYXglMjBtZW1vcnklMjBhbGxvY2F0ZWQlM0ElMjA0LjQwNjIxMzI4MzUzODgxOCUyMEdCJTIy",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">bytes_to_giga_bytes</span>(<span class="hljs-params"><span class="hljs-built_in">bytes</span></span>):
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">bytes</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory allocated: <span class="hljs-subst">{bytes_to_giga_bytes(torch.cuda.max_memory_allocated())}</span> GB&quot;</span>)
<span class="hljs-string">&quot;Max memory allocated: 4.406213283538818 GB&quot;</span>`,wrap:!1}}),R=new Rl({props:{warning:!0,$$slots:{default:[Pt]},$$scope:{ctx:w}}}),ye=new Z({props:{code:"cGlwZV9zYWclMjAlM0QlMjBTdGFibGVEaWZmdXNpb25TQUdQaXBlbGluZS5mcm9tX3BpcGUoJTBBJTIwJTIwJTIwJTIwcGlwZV9zZCUwQSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgzMyklMEFvdXRfc2FnJTIwJTNEJTIwcGlwZV9zYWcoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVhciUyMGVhdHMlMjBwaXp6YSUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMndyb25nJTIwd2hpdGUlMjBiYWxhbmNlJTJDJTIwZGFyayUyQyUyMHNrZXRjaGVzJTJDd29yc3QlMjBxdWFsaXR5JTJDbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMS4wJTJDJTBBJTIwJTIwJTIwJTIwc2FnX3NjYWxlJTNEMC43NSUwQSkuaW1hZ2VzJTVCMCU1RCUwQW91dF9zYWc=",highlighted:`pipe_sag = StableDiffusionSAGPipeline.from_pipe(
    pipe_sd
)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
out_sag = pipe_sag(
    prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>,
    ip_adapter_image=image,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
    guidance_scale=<span class="hljs-number">1.0</span>,
    sag_scale=<span class="hljs-number">0.75</span>
).images[<span class="hljs-number">0</span>]
out_sag`,wrap:!1}}),Ue=new Z({props:{code:"cHJpbnQoZiUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMCU3QmJ5dGVzX3RvX2dpZ2FfYnl0ZXModG9yY2guY3VkYS5tYXhfbWVtb3J5X2FsbG9jYXRlZCgpKSU3RCUyMEdCJTIyKSUwQSUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMDQuNDA2MjEzMjgzNTM4ODE4JTIwR0IlMjI=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory allocated: <span class="hljs-subst">{bytes_to_giga_bytes(torch.cuda.max_memory_allocated())}</span> GB&quot;</span>)
<span class="hljs-string">&quot;Max memory allocated: 4.406213283538818 GB&quot;</span>`,wrap:!1}}),Je=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEFuaW1hdGVEaWZmUGlwZWxpbmUlMkMlMjBNb3Rpb25BZGFwdGVyJTJDJTIwRERJTVNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fZ2lmJTBBJTBBcGlwZV9zYWcudW5sb2FkX2lwX2FkYXB0ZXIoKSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tYWRhcHRlci12MS01LTIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBJTBBcGlwZV9hbmltYXRlJTIwJTNEJTIwQW5pbWF0ZURpZmZQaXBlbGluZS5mcm9tX3BpcGUocGlwZV9zZCUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciklMEFwaXBlX2FuaW1hdGUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlX2FuaW1hdGUuc2NoZWR1bGVyLmNvbmZpZyUyQyUyMGJldGFfc2NoZWR1bGUlM0QlMjJsaW5lYXIlMjIpJTBBJTIzJTIwbG9hZCUyMElQLUFkYXB0ZXIlMjBhbmQlMjBMb1JBJTIwd2VpZ2h0cyUyMGFnYWluJTBBcGlwZV9hbmltYXRlLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVfYW5pbWF0ZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tbG9yYS16b29tLW91dCUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnpvb20tb3V0JTIyKSUwQXBpcGVfYW5pbWF0ZS50byglMjJjdWRhJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDMzKSUwQXBpcGVfYW5pbWF0ZS5zZXRfYWRhcHRlcnMoJTIyem9vbS1vdXQlMjIlMkMlMjBhZGFwdGVyX3dlaWdodHMlM0QwLjc1KSUwQW91dCUyMCUzRCUyMHBpcGVfYW5pbWF0ZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJiZWFyJTIwZWF0cyUyMHBpenphJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX2dpZihvdXQlMkMlMjAlMjJvdXRfYW5pbWF0ZS5naWYlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, MotionAdapter, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

pipe_sag.unload_ip_adapter()
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)

pipe_animate = AnimateDiffPipeline.from_pipe(pipe_sd, motion_adapter=adapter)
pipe_animate.scheduler = DDIMScheduler.from_config(pipe_animate.scheduler.config, beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>)
<span class="hljs-comment"># load IP-Adapter and LoRA weights again</span>
pipe_animate.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipe_animate.load_lora_weights(<span class="hljs-string">&quot;guoyww/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>)
pipe_animate.to(<span class="hljs-string">&quot;cuda&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
pipe_animate.set_adapters(<span class="hljs-string">&quot;zoom-out&quot;</span>, adapter_weights=<span class="hljs-number">0.75</span>)
out = pipe_animate(
    prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    ip_adapter_image=image,
    generator=generator,
).frames[<span class="hljs-number">0</span>]
export_to_gif(out, <span class="hljs-string">&quot;out_animate.gif&quot;</span>)`,wrap:!1}}),we=new Z({props:{code:"cHJpbnQoZiUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMCU3QmJ5dGVzX3RvX2dpZ2FfYnl0ZXModG9yY2guY3VkYS5tYXhfbWVtb3J5X2FsbG9jYXRlZCgpKSU3RCUyMEdCJTIyKSUwQSUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMDE1LjE3ODY2NDIwNzQ1ODQ5NiUyMEdCJTIy",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory allocated: <span class="hljs-subst">{bytes_to_giga_bytes(torch.cuda.max_memory_allocated())}</span> GB&quot;</span>)
<span class="hljs-string">&quot;Max memory allocated: 15.178664207458496 GB&quot;</span>`,wrap:!1}}),je=new _({props:{title:"Modify from_pipe components",local:"modify-frompipe-components",headingTag:"h3"}}),ge=new Z({props:{code:"cGlwZS5zYWdfdW5sb2FkX2lwX2FkYXB0ZXIoKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDMzKSUwQW91dF9zZCUyMCUzRCUyMHBpcGVfc2QoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVhciUyMGVhdHMlMjBwaXp6YSUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMndyb25nJTIwd2hpdGUlMjBiYWxhbmNlJTJDJTIwZGFyayUyQyUyMHNrZXRjaGVzJTJDd29yc3QlMjBxdWFsaXR5JTJDbG93JTIwcXVhbGl0eSUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUyMkF0dHJpYnV0ZUVycm9yJTNBJTIwJ05vbmVUeXBlJyUyMG9iamVjdCUyMGhhcyUyMG5vJTIwYXR0cmlidXRlJTIwJ2ltYWdlX3Byb2plY3Rpb25fbGF5ZXJzJyUyMg==",highlighted:`pipe.sag_unload_ip_adapter()

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
out_sd = pipe_sd(
    prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>, 
    ip_adapter_image=image,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;AttributeError: &#x27;NoneType&#x27; object has no attribute &#x27;image_projection_layers&#x27;&quot;</span>`,wrap:!1}}),Ie=new _({props:{title:"Memory usage of from_pipe",local:"memory-usage-of-frompipe",headingTag:"h3"}}),$e=new _({props:{title:"Safety checker",local:"safety-checker",headingTag:"h2"}}),Ve=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBzYWZldHlfY2hlY2tlciUzRE5vbmUlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQSUyMiUyMiUyMiUwQVlvdSUyMGhhdmUlMjBkaXNhYmxlZCUyMHRoZSUyMHNhZmV0eSUyMGNoZWNrZXIlMjBmb3IlMjAlM0NjbGFzcyUyMCdkaWZmdXNlcnMucGlwZWxpbmVzLnN0YWJsZV9kaWZmdXNpb24ucGlwZWxpbmVfc3RhYmxlX2RpZmZ1c2lvbi5TdGFibGVEaWZmdXNpb25QaXBlbGluZSclM0UlMjBieSUyMHBhc3NpbmclMjAlNjBzYWZldHlfY2hlY2tlciUzRE5vbmUlNjAuJTIwRW5zdXJlJTIwdGhhdCUyMHlvdSUyMGFiaWRlJTIwYnklMjB0aGUlMjBjb25kaXRpb25zJTIwb2YlMjB0aGUlMjBTdGFibGUlMjBEaWZmdXNpb24lMjBsaWNlbnNlJTIwYW5kJTIwZG8lMjBub3QlMjBleHBvc2UlMjB1bmZpbHRlcmVkJTIwcmVzdWx0cyUyMGluJTIwc2VydmljZXMlMjBvciUyMGFwcGxpY2F0aW9ucyUyMG9wZW4lMjB0byUyMHRoZSUyMHB1YmxpYy4lMjBCb3RoJTIwdGhlJTIwZGlmZnVzZXJzJTIwdGVhbSUyMGFuZCUyMEh1Z2dpbmclMjBGYWNlJTIwc3Ryb25nbHklMjByZWNvbW1lbmQlMjBrZWVwaW5nJTIwdGhlJTIwc2FmZXR5JTIwZmlsdGVyJTIwZW5hYmxlZCUyMGluJTIwYWxsJTIwcHVibGljLWZhY2luZyUyMGNpcmN1bXN0YW5jZXMlMkMlMjBkaXNhYmxpbmclMjBpdCUyMG9ubHklMjBmb3IlMjB1c2UlMjBjYXNlcyUyMHRoYXQlMjBpbnZvbHZlJTIwYW5hbHl6aW5nJTIwbmV0d29yayUyMGJlaGF2aW9yJTIwb3IlMjBhdWRpdGluZyUyMGl0cyUyMHJlc3VsdHMuJTIwRm9yJTIwbW9yZSUyMGluZm9ybWF0aW9uJTJDJTIwcGxlYXNlJTIwaGF2ZSUyMGElMjBsb29rJTIwYXQlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUyRnB1bGwlMkYyNTQlMjAuJTBBJTIyJTIyJTIy",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, safety_checker=<span class="hljs-literal">None</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;
You have disabled the safety checker for &lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt; by passing \`safety_checker=None\`. Ensure that you abide by the conditions of the Stable Diffusion license and do not expose unfiltered results in services or applications open to the public. Both the diffusers team and Hugging Face strongly recommend keeping the safety filter enabled in all public-facing circumstances, disabling it only for use cases that involve analyzing network behavior or auditing its results. For more information, please have a look at https://github.com/huggingface/diffusers/pull/254 .
&quot;&quot;&quot;</span>`,wrap:!1}}),ke=new _({props:{title:"Checkpoint variants",local:"checkpoint-variants",headingTag:"h2"}}),N=new Rl({props:{warning:!1,$$slots:{default:[Ot]},$$scope:{ctx:w}}}),Y=new Xl({props:{id:"variants",options:["fp16","non-EMA"],$$slots:{default:[si]},$$scope:{ctx:w}}}),S=new Xl({props:{id:"save",options:["fp16","non_ema"],$$slots:{default:[ii]},$$scope:{ctx:w}}}),qe=new Z({props:{code:"JTIzJTIwJUYwJTlGJTkxJThFJTIwdGhpcyUyMHdvbid0JTIwd29yayUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQSUyMyUyMCVGMCU5RiU5MSU4RCUyMHRoaXMlMjB3b3JrcyUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-comment"># 👎 this won&#x27;t work</span>
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-comment"># 👍 this works</span>
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),xe=new _({props:{title:"DiffusionPipeline explained",local:"diffusionpipeline-explained",headingTag:"h2"}}),Ae=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcHJpbnQocGlwZWxpbmUp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(pipeline)`,wrap:!1}}),Le=new Z({props:{code:"U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMjAlN0IlMEElMjAlMjAlMjJmZWF0dXJlX2V4dHJhY3RvciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBJbWFnZVByb2Nlc3NvciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnNhZmV0eV9jaGVja2VyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlN0YWJsZURpZmZ1c2lvblNhZmV0eUNoZWNrZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzY2hlZHVsZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJQTkRNU2NoZWR1bGVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQ0xJUFRleHRNb2RlbCUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRva2VuaXplciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUb2tlbml6ZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ1bmV0JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVU5ldDJEQ29uZGl0aW9uTW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ2YWUlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBdXRvZW5jb2RlcktMJTIyJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`StableDiffusionPipeline <span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Oe=new Z({props:{code:"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",highlighted:`.
├── feature_extractor
│   └── preprocessor_config.json
├── model_index.json
├── safety_checker
│   ├── config.json
|<span class="hljs-string">   ├── model.fp16.safetensors
│   ├── model.safetensors
│   ├── pytorch_model.bin
</span>|<span class="hljs-string">   └── pytorch_model.fp16.bin
├── scheduler
│   └── scheduler_config.json
├── text_encoder
│   ├── config.json
</span>|<span class="hljs-string">   ├── model.fp16.safetensors
│   ├── model.safetensors
│   </span>|<span class="hljs-string">── pytorch_model.bin
</span>|<span class="hljs-string">   └── pytorch_model.fp16.bin
├── tokenizer
│   ├── merges.txt
│   ├── special_tokens_map.json
│   ├── tokenizer_config.json
│   └── vocab.json
├── unet
│   ├── config.json
│   ├── diffusion_pytorch_model.bin
</span>|<span class="hljs-string">   </span>|<span class="hljs-string">── diffusion_pytorch_model.fp16.bin
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.f16.safetensors
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.non_ema.bin
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.non_ema.safetensors
│   └── diffusion_pytorch_model.safetensors
</span>|<span class="hljs-string">── vae
.   ├── config.json
.   ├── diffusion_pytorch_model.bin
    ├── diffusion_pytorch_model.fp16.bin
    ├── diffusion_pytorch_model.fp16.safetensors
    └── diffusion_pytorch_model.safetensors</span>`,wrap:!1}}),es=new Z({props:{code:"cGlwZWxpbmUudG9rZW5pemVyJTBBQ0xJUFRva2VuaXplciglMEElMjAlMjAlMjAlMjBuYW1lX29yX3BhdGglM0QlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXJ1bndheW1sLS1zdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzbmFwc2hvdHMlMkYzOTU5M2Q1NjUwMTEyYjRjYzU4MDQzM2Y2YjA0MzUzODU4ODJkODE5JTJGdG9rZW5pemVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDQ5NDA4JTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfbWF4X2xlbmd0aCUzRDc3JTJDJTBBJTIwJTIwJTIwJTIwaXNfZmFzdCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZ19zaWRlJTNEJTIycmlnaHQlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uX3NpZGUlM0QlMjJyaWdodCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwZWNpYWxfdG9rZW5zJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYm9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NzdGFydG9mdGV4dCU3QyUzRSUyMiUyQyUyMHJzdHJpcCUzREZhbHNlJTJDJTIwbHN0cmlwJTNERmFsc2UlMkMlMjBzaW5nbGVfd29yZCUzREZhbHNlJTJDJTIwbm9ybWFsaXplZCUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMjByc3RyaXAlM0RGYWxzZSUyQyUyMGxzdHJpcCUzREZhbHNlJTJDJTIwc2luZ2xlX3dvcmQlM0RGYWxzZSUyQyUyMG5vcm1hbGl6ZWQlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVua190b2tlbiUyMiUzQSUyMEFkZGVkVG9rZW4oJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTIwcnN0cmlwJTNERmFsc2UlMkMlMjBsc3RyaXAlM0RGYWxzZSUyQyUyMHNpbmdsZV93b3JkJTNERmFsc2UlMkMlMjBub3JtYWxpemVkJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYWRfdG9rZW4lMjIlM0ElMjAlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNEVHJ1ZSUwQSk=",highlighted:`pipeline.tokenizer
CLIPTokenizer(
    name_or_path=<span class="hljs-string">&quot;/root/.cache/huggingface/hub/models--runwayml--stable-diffusion-v1-5/snapshots/39593d5650112b4cc580433f6b0435385882d819/tokenizer&quot;</span>,
    vocab_size=<span class="hljs-number">49408</span>,
    model_max_length=<span class="hljs-number">77</span>,
    is_fast=<span class="hljs-literal">False</span>,
    padding_side=<span class="hljs-string">&quot;right&quot;</span>,
    truncation_side=<span class="hljs-string">&quot;right&quot;</span>,
    special_tokens={
        <span class="hljs-string">&quot;bos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|startoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;eos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;unk_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;pad_token&quot;</span>: <span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    },
    clean_up_tokenization_spaces=<span class="hljs-literal">True</span>
)`,wrap:!1}}),ts=new Z({props:{code:"JTdCJTBBJTIwJTIwJTIyX2NsYXNzX25hbWUlMjIlM0ElMjAlMjJTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyMiUyQyUwQSUyMCUyMCUyMl9kaWZmdXNlcnNfdmVyc2lvbiUyMiUzQSUyMCUyMjAuNi4wJTIyJTJDJTBBJTIwJTIwJTIyZmVhdHVyZV9leHRyYWN0b3IlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQSW1hZ2VQcm9jZXNzb3IlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzYWZldHlfY2hlY2tlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZV9kaWZmdXNpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJTdGFibGVEaWZmdXNpb25TYWZldHlDaGVja2VyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyUE5ETVNjaGVkdWxlciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRleHRfZW5jb2RlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUZXh0TW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ0b2tlbml6ZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQVG9rZW5pemVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydW5ldCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlVOZXQyRENvbmRpdGlvbk1vZGVsJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydmFlJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQXV0b2VuY29kZXJLTCUyMiUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;_class_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;StableDiffusionPipeline&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;_diffusers_version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;0.6.0&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),{c(){i=r("meta"),M=a(),n=r("p"),d=a(),y(o.$$.fragment),c=a(),y(j.$$.fragment),g=a(),I=r("p"),I.innerHTML=v,m=a(),C=r("p"),C.textContent=Ql,ps=a(),q=r("ul"),q.innerHTML=Nl,os=a(),y(x.$$.fragment),rs=a(),y(G.$$.fragment),fs=a(),D=r("p"),D.textContent=Yl,us=a(),F=r("ol"),F.innerHTML=Sl,cs=a(),y(V.$$.fragment),ms=a(),z=r("p"),z.textContent=ql,ds=a(),k=r("div"),k.innerHTML=xl,Ms=a(),W=r("div"),W.innerHTML=Dl,ys=a(),y(A.$$.fragment),hs=a(),H=r("p"),H.innerHTML=Fl,Us=a(),y(E.$$.fragment),Ts=a(),L=r("p"),L.innerHTML=zl,Js=a(),y(P.$$.fragment),bs=a(),O=r("p"),O.innerHTML=Al,ws=a(),y(K.$$.fragment),js=a(),ee=r("p"),ee.textContent=Hl,Zs=a(),se=r("ul"),se.innerHTML=El,gs=a(),le=r("p"),le.innerHTML=Ll,Is=a(),te=r("ul"),te.innerHTML=Pl,Cs=a(),y(ie.$$.fragment),vs=a(),ne=r("p"),ne.innerHTML=Ol,_s=a(),y(ae.$$.fragment),$s=a(),y(pe.$$.fragment),Gs=a(),oe=r("p"),oe.textContent=Kl,Vs=a(),re=r("ol"),re.innerHTML=et,ks=a(),fe=r("p"),fe.innerHTML=st,Ws=a(),ue=r("p"),ue.innerHTML=lt,Bs=a(),y(ce.$$.fragment),Rs=a(),B=r("div"),B.innerHTML=tt,Xs=a(),me=r("p"),me.textContent=it,Qs=a(),y(de.$$.fragment),Ns=a(),Me=r("p"),Me.innerHTML=nt,Ys=a(),y(R.$$.fragment),Ss=a(),y(ye.$$.fragment),qs=a(),X=r("div"),X.innerHTML=at,xs=a(),he=r("p"),he.innerHTML=pt,Ds=a(),y(Ue.$$.fragment),Fs=a(),Te=r("p"),Te.innerHTML=ot,zs=a(),y(Je.$$.fragment),As=a(),Q=r("div"),Q.innerHTML=rt,Hs=a(),be=r("p"),be.innerHTML=ft,Es=a(),y(we.$$.fragment),Ls=a(),y(je.$$.fragment),Ps=a(),Ze=r("p"),Ze.innerHTML=ut,Os=a(),y(ge.$$.fragment),Ks=a(),y(Ie.$$.fragment),el=a(),Ce=r("p"),Ce.innerHTML=ct,sl=a(),ve=r("table"),ve.innerHTML=mt,ll=a(),_e=r("p"),_e.innerHTML=dt,tl=a(),y($e.$$.fragment),il=a(),Ge=r("p"),Ge.innerHTML=Mt,nl=a(),y(Ve.$$.fragment),al=a(),y(ke.$$.fragment),pl=a(),We=r("p"),We.textContent=yt,ol=a(),Be=r("ul"),Be.innerHTML=ht,rl=a(),y(N.$$.fragment),fl=a(),Re=r("p"),Re.innerHTML=Ut,ul=a(),Xe=r("table"),Xe.innerHTML=Tt,cl=a(),Qe=r("p"),Qe.textContent=Jt,ml=a(),Ne=r("ul"),Ne.innerHTML=bt,dl=a(),y(Y.$$.fragment),Ml=a(),Ye=r("p"),Ye.innerHTML=wt,yl=a(),y(S.$$.fragment),hl=a(),Se=r("p"),Se.innerHTML=jt,Ul=a(),y(qe.$$.fragment),Tl=a(),y(xe.$$.fragment),Jl=a(),De=r("p"),De.innerHTML=Zt,bl=a(),Fe=r("ul"),Fe.innerHTML=gt,wl=a(),ze=r("p"),ze.innerHTML=It,jl=a(),y(Ae.$$.fragment),Zl=a(),He=r("p"),He.innerHTML=Ct,gl=a(),Ee=r("ul"),Ee.innerHTML=vt,Il=a(),y(Le.$$.fragment),Cl=a(),Pe=r("p"),Pe.innerHTML=_t,vl=a(),y(Oe.$$.fragment),_l=a(),Ke=r("p"),Ke.textContent=$t,$l=a(),y(es.$$.fragment),Gl=a(),ss=r("p"),ss.innerHTML=Gt,Vl=a(),ls=r("ul"),ls.innerHTML=Vt,kl=a(),y(ts.$$.fragment),Wl=a(),as=r("p"),this.h()},l(e){const s=Dt("svelte-u9bgzb",document.head);i=f(s,"META",{name:!0,content:!0}),s.forEach(l),M=p(e),n=f(e,"P",{}),Nt(n).forEach(l),d=p(e),h(o.$$.fragment,e),c=p(e),h(j.$$.fragment,e),g=p(e),I=f(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1mjzpt7"&&(I.innerHTML=v),m=p(e),C=f(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-b6mpdv"&&(C.textContent=Ql),ps=p(e),q=f(e,"UL",{"data-svelte-h":!0}),u(q)!=="svelte-1eibdva"&&(q.innerHTML=Nl),os=p(e),h(x.$$.fragment,e),rs=p(e),h(G.$$.fragment,e),fs=p(e),D=f(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-1fp1qkh"&&(D.textContent=Yl),us=p(e),F=f(e,"OL",{"data-svelte-h":!0}),u(F)!=="svelte-1hgg7us"&&(F.innerHTML=Sl),cs=p(e),h(V.$$.fragment,e),ms=p(e),z=f(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-x1hybx"&&(z.textContent=ql),ds=p(e),k=f(e,"DIV",{class:!0,"data-svelte-h":!0}),u(k)!=="svelte-1eacg44"&&(k.innerHTML=xl),Ms=p(e),W=f(e,"DIV",{class:!0,"data-svelte-h":!0}),u(W)!=="svelte-1scmarz"&&(W.innerHTML=Dl),ys=p(e),h(A.$$.fragment,e),hs=p(e),H=f(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-19d3ik7"&&(H.innerHTML=Fl),Us=p(e),h(E.$$.fragment,e),Ts=p(e),L=f(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-13irge8"&&(L.innerHTML=zl),Js=p(e),h(P.$$.fragment,e),bs=p(e),O=f(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-g0yd3u"&&(O.innerHTML=Al),ws=p(e),h(K.$$.fragment,e),js=p(e),ee=f(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-1ifrszd"&&(ee.textContent=Hl),Zs=p(e),se=f(e,"UL",{"data-svelte-h":!0}),u(se)!=="svelte-1ln6l0l"&&(se.innerHTML=El),gs=p(e),le=f(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-pkpme0"&&(le.innerHTML=Ll),Is=p(e),te=f(e,"UL",{"data-svelte-h":!0}),u(te)!=="svelte-niwzp6"&&(te.innerHTML=Pl),Cs=p(e),h(ie.$$.fragment,e),vs=p(e),ne=f(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-1tnhj53"&&(ne.innerHTML=Ol),_s=p(e),h(ae.$$.fragment,e),$s=p(e),h(pe.$$.fragment,e),Gs=p(e),oe=f(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-14g5ay7"&&(oe.textContent=Kl),Vs=p(e),re=f(e,"OL",{"data-svelte-h":!0}),u(re)!=="svelte-1vxntr0"&&(re.innerHTML=et),ks=p(e),fe=f(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-gmkfd5"&&(fe.innerHTML=st),Ws=p(e),ue=f(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-1urnmn2"&&(ue.innerHTML=lt),Bs=p(e),h(ce.$$.fragment,e),Rs=p(e),B=f(e,"DIV",{class:!0,"data-svelte-h":!0}),u(B)!=="svelte-ye42mk"&&(B.innerHTML=tt),Xs=p(e),me=f(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-1u6h93y"&&(me.textContent=it),Qs=p(e),h(de.$$.fragment,e),Ns=p(e),Me=f(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-1cvgfbk"&&(Me.innerHTML=nt),Ys=p(e),h(R.$$.fragment,e),Ss=p(e),h(ye.$$.fragment,e),qs=p(e),X=f(e,"DIV",{class:!0,"data-svelte-h":!0}),u(X)!=="svelte-5lltp7"&&(X.innerHTML=at),xs=p(e),he=f(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-1js9yxv"&&(he.innerHTML=pt),Ds=p(e),h(Ue.$$.fragment,e),Fs=p(e),Te=f(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-1wtawsa"&&(Te.innerHTML=ot),zs=p(e),h(Je.$$.fragment,e),As=p(e),Q=f(e,"DIV",{class:!0,"data-svelte-h":!0}),u(Q)!=="svelte-cbprhg"&&(Q.innerHTML=rt),Hs=p(e),be=f(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-1hscc5j"&&(be.innerHTML=ft),Es=p(e),h(we.$$.fragment,e),Ls=p(e),h(je.$$.fragment,e),Ps=p(e),Ze=f(e,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-1dz1nqo"&&(Ze.innerHTML=ut),Os=p(e),h(ge.$$.fragment,e),Ks=p(e),h(Ie.$$.fragment,e),el=p(e),Ce=f(e,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-3tn4b0"&&(Ce.innerHTML=ct),sl=p(e),ve=f(e,"TABLE",{"data-svelte-h":!0}),u(ve)!=="svelte-170u8iz"&&(ve.innerHTML=mt),ll=p(e),_e=f(e,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-1w0v69h"&&(_e.innerHTML=dt),tl=p(e),h($e.$$.fragment,e),il=p(e),Ge=f(e,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-1dz5d7t"&&(Ge.innerHTML=Mt),nl=p(e),h(Ve.$$.fragment,e),al=p(e),h(ke.$$.fragment,e),pl=p(e),We=f(e,"P",{"data-svelte-h":!0}),u(We)!=="svelte-144ljdh"&&(We.textContent=yt),ol=p(e),Be=f(e,"UL",{"data-svelte-h":!0}),u(Be)!=="svelte-86xcrp"&&(Be.innerHTML=ht),rl=p(e),h(N.$$.fragment,e),fl=p(e),Re=f(e,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-naaguo"&&(Re.innerHTML=Ut),ul=p(e),Xe=f(e,"TABLE",{"data-svelte-h":!0}),u(Xe)!=="svelte-1xwvx35"&&(Xe.innerHTML=Tt),cl=p(e),Qe=f(e,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-9nwb1f"&&(Qe.textContent=Jt),ml=p(e),Ne=f(e,"UL",{"data-svelte-h":!0}),u(Ne)!=="svelte-1uxhl8j"&&(Ne.innerHTML=bt),dl=p(e),h(Y.$$.fragment,e),Ml=p(e),Ye=f(e,"P",{"data-svelte-h":!0}),u(Ye)!=="svelte-k0wnr6"&&(Ye.innerHTML=wt),yl=p(e),h(S.$$.fragment,e),hl=p(e),Se=f(e,"P",{"data-svelte-h":!0}),u(Se)!=="svelte-s6vvaz"&&(Se.innerHTML=jt),Ul=p(e),h(qe.$$.fragment,e),Tl=p(e),h(xe.$$.fragment,e),Jl=p(e),De=f(e,"P",{"data-svelte-h":!0}),u(De)!=="svelte-nr77qh"&&(De.innerHTML=Zt),bl=p(e),Fe=f(e,"UL",{"data-svelte-h":!0}),u(Fe)!=="svelte-17dcgvz"&&(Fe.innerHTML=gt),wl=p(e),ze=f(e,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-jme5sm"&&(ze.innerHTML=It),jl=p(e),h(Ae.$$.fragment,e),Zl=p(e),He=f(e,"P",{"data-svelte-h":!0}),u(He)!=="svelte-102ytrs"&&(He.innerHTML=Ct),gl=p(e),Ee=f(e,"UL",{"data-svelte-h":!0}),u(Ee)!=="svelte-1e5gxzy"&&(Ee.innerHTML=vt),Il=p(e),h(Le.$$.fragment,e),Cl=p(e),Pe=f(e,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-173hqz7"&&(Pe.innerHTML=_t),vl=p(e),h(Oe.$$.fragment,e),_l=p(e),Ke=f(e,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-5jik9b"&&(Ke.textContent=$t),$l=p(e),h(es.$$.fragment,e),Gl=p(e),ss=f(e,"P",{"data-svelte-h":!0}),u(ss)!=="svelte-1uoxyh2"&&(ss.innerHTML=Gt),Vl=p(e),ls=f(e,"UL",{"data-svelte-h":!0}),u(ls)!=="svelte-hr84vt"&&(ls.innerHTML=Vt),kl=p(e),h(ts.$$.fragment,e),Wl=p(e),as=f(e,"P",{}),Nt(as).forEach(l),this.h()},h(){is(i,"name","hf:doc:metadata"),is(i,"content",ai),is(k,"class","block dark:hidden"),is(W,"class","hidden dark:block"),is(B,"class","flex justify-center"),is(X,"class","flex justify-center"),is(Q,"class","flex justify-center")},m(e,s){Ft(document.head,i),t(e,M,s),t(e,n,s),t(e,d,s),U(o,e,s),t(e,c,s),U(j,e,s),t(e,g,s),t(e,I,s),t(e,m,s),t(e,C,s),t(e,ps,s),t(e,q,s),t(e,os,s),U(x,e,s),t(e,rs,s),U(G,e,s),t(e,fs,s),t(e,D,s),t(e,us,s),t(e,F,s),t(e,cs,s),U(V,e,s),t(e,ms,s),t(e,z,s),t(e,ds,s),t(e,k,s),t(e,Ms,s),t(e,W,s),t(e,ys,s),U(A,e,s),t(e,hs,s),t(e,H,s),t(e,Us,s),U(E,e,s),t(e,Ts,s),t(e,L,s),t(e,Js,s),U(P,e,s),t(e,bs,s),t(e,O,s),t(e,ws,s),U(K,e,s),t(e,js,s),t(e,ee,s),t(e,Zs,s),t(e,se,s),t(e,gs,s),t(e,le,s),t(e,Is,s),t(e,te,s),t(e,Cs,s),U(ie,e,s),t(e,vs,s),t(e,ne,s),t(e,_s,s),U(ae,e,s),t(e,$s,s),U(pe,e,s),t(e,Gs,s),t(e,oe,s),t(e,Vs,s),t(e,re,s),t(e,ks,s),t(e,fe,s),t(e,Ws,s),t(e,ue,s),t(e,Bs,s),U(ce,e,s),t(e,Rs,s),t(e,B,s),t(e,Xs,s),t(e,me,s),t(e,Qs,s),U(de,e,s),t(e,Ns,s),t(e,Me,s),t(e,Ys,s),U(R,e,s),t(e,Ss,s),U(ye,e,s),t(e,qs,s),t(e,X,s),t(e,xs,s),t(e,he,s),t(e,Ds,s),U(Ue,e,s),t(e,Fs,s),t(e,Te,s),t(e,zs,s),U(Je,e,s),t(e,As,s),t(e,Q,s),t(e,Hs,s),t(e,be,s),t(e,Es,s),U(we,e,s),t(e,Ls,s),U(je,e,s),t(e,Ps,s),t(e,Ze,s),t(e,Os,s),U(ge,e,s),t(e,Ks,s),U(Ie,e,s),t(e,el,s),t(e,Ce,s),t(e,sl,s),t(e,ve,s),t(e,ll,s),t(e,_e,s),t(e,tl,s),U($e,e,s),t(e,il,s),t(e,Ge,s),t(e,nl,s),U(Ve,e,s),t(e,al,s),U(ke,e,s),t(e,pl,s),t(e,We,s),t(e,ol,s),t(e,Be,s),t(e,rl,s),U(N,e,s),t(e,fl,s),t(e,Re,s),t(e,ul,s),t(e,Xe,s),t(e,cl,s),t(e,Qe,s),t(e,ml,s),t(e,Ne,s),t(e,dl,s),U(Y,e,s),t(e,Ml,s),t(e,Ye,s),t(e,yl,s),U(S,e,s),t(e,hl,s),t(e,Se,s),t(e,Ul,s),U(qe,e,s),t(e,Tl,s),U(xe,e,s),t(e,Jl,s),t(e,De,s),t(e,bl,s),t(e,Fe,s),t(e,wl,s),t(e,ze,s),t(e,jl,s),U(Ae,e,s),t(e,Zl,s),t(e,He,s),t(e,gl,s),t(e,Ee,s),t(e,Il,s),U(Le,e,s),t(e,Cl,s),t(e,Pe,s),t(e,vl,s),U(Oe,e,s),t(e,_l,s),t(e,Ke,s),t(e,$l,s),U(es,e,s),t(e,Gl,s),t(e,ss,s),t(e,Vl,s),t(e,ls,s),t(e,kl,s),U(ts,e,s),t(e,Wl,s),t(e,as,s),Bl=!0},p(e,[s]){const kt={};s&2&&(kt.$$scope={dirty:s,ctx:e}),G.$set(kt);const Wt={};s&2&&(Wt.$$scope={dirty:s,ctx:e}),V.$set(Wt);const Bt={};s&2&&(Bt.$$scope={dirty:s,ctx:e}),R.$set(Bt);const Rt={};s&2&&(Rt.$$scope={dirty:s,ctx:e}),N.$set(Rt);const Xt={};s&2&&(Xt.$$scope={dirty:s,ctx:e}),Y.$set(Xt);const Qt={};s&2&&(Qt.$$scope={dirty:s,ctx:e}),S.$set(Qt)},i(e){Bl||(T(o.$$.fragment,e),T(j.$$.fragment,e),T(x.$$.fragment,e),T(G.$$.fragment,e),T(V.$$.fragment,e),T(A.$$.fragment,e),T(E.$$.fragment,e),T(P.$$.fragment,e),T(K.$$.fragment,e),T(ie.$$.fragment,e),T(ae.$$.fragment,e),T(pe.$$.fragment,e),T(ce.$$.fragment,e),T(de.$$.fragment,e),T(R.$$.fragment,e),T(ye.$$.fragment,e),T(Ue.$$.fragment,e),T(Je.$$.fragment,e),T(we.$$.fragment,e),T(je.$$.fragment,e),T(ge.$$.fragment,e),T(Ie.$$.fragment,e),T($e.$$.fragment,e),T(Ve.$$.fragment,e),T(ke.$$.fragment,e),T(N.$$.fragment,e),T(Y.$$.fragment,e),T(S.$$.fragment,e),T(qe.$$.fragment,e),T(xe.$$.fragment,e),T(Ae.$$.fragment,e),T(Le.$$.fragment,e),T(Oe.$$.fragment,e),T(es.$$.fragment,e),T(ts.$$.fragment,e),Bl=!0)},o(e){J(o.$$.fragment,e),J(j.$$.fragment,e),J(x.$$.fragment,e),J(G.$$.fragment,e),J(V.$$.fragment,e),J(A.$$.fragment,e),J(E.$$.fragment,e),J(P.$$.fragment,e),J(K.$$.fragment,e),J(ie.$$.fragment,e),J(ae.$$.fragment,e),J(pe.$$.fragment,e),J(ce.$$.fragment,e),J(de.$$.fragment,e),J(R.$$.fragment,e),J(ye.$$.fragment,e),J(Ue.$$.fragment,e),J(Je.$$.fragment,e),J(we.$$.fragment,e),J(je.$$.fragment,e),J(ge.$$.fragment,e),J(Ie.$$.fragment,e),J($e.$$.fragment,e),J(Ve.$$.fragment,e),J(ke.$$.fragment,e),J(N.$$.fragment,e),J(Y.$$.fragment,e),J(S.$$.fragment,e),J(qe.$$.fragment,e),J(xe.$$.fragment,e),J(Ae.$$.fragment,e),J(Le.$$.fragment,e),J(Oe.$$.fragment,e),J(es.$$.fragment,e),J(ts.$$.fragment,e),Bl=!1},d(e){e&&(l(M),l(n),l(d),l(c),l(g),l(I),l(m),l(C),l(ps),l(q),l(os),l(rs),l(fs),l(D),l(us),l(F),l(cs),l(ms),l(z),l(ds),l(k),l(Ms),l(W),l(ys),l(hs),l(H),l(Us),l(Ts),l(L),l(Js),l(bs),l(O),l(ws),l(js),l(ee),l(Zs),l(se),l(gs),l(le),l(Is),l(te),l(Cs),l(vs),l(ne),l(_s),l($s),l(Gs),l(oe),l(Vs),l(re),l(ks),l(fe),l(Ws),l(ue),l(Bs),l(Rs),l(B),l(Xs),l(me),l(Qs),l(Ns),l(Me),l(Ys),l(Ss),l(qs),l(X),l(xs),l(he),l(Ds),l(Fs),l(Te),l(zs),l(As),l(Q),l(Hs),l(be),l(Es),l(Ls),l(Ps),l(Ze),l(Os),l(Ks),l(el),l(Ce),l(sl),l(ve),l(ll),l(_e),l(tl),l(il),l(Ge),l(nl),l(al),l(pl),l(We),l(ol),l(Be),l(rl),l(fl),l(Re),l(ul),l(Xe),l(cl),l(Qe),l(ml),l(Ne),l(dl),l(Ml),l(Ye),l(yl),l(hl),l(Se),l(Ul),l(Tl),l(Jl),l(De),l(bl),l(Fe),l(wl),l(ze),l(jl),l(Zl),l(He),l(gl),l(Ee),l(Il),l(Cl),l(Pe),l(vl),l(_l),l(Ke),l($l),l(Gl),l(ss),l(Vl),l(ls),l(kl),l(Wl),l(as)),l(i),b(o,e),b(j,e),b(x,e),b(G,e),b(V,e),b(A,e),b(E,e),b(P,e),b(K,e),b(ie,e),b(ae,e),b(pe,e),b(ce,e),b(de,e),b(R,e),b(ye,e),b(Ue,e),b(Je,e),b(we,e),b(je,e),b(ge,e),b(Ie,e),b($e,e),b(Ve,e),b(ke,e),b(N,e),b(Y,e),b(S,e),b(qe,e),b(xe,e),b(Ae,e),b(Le,e),b(Oe,e),b(es,e),b(ts,e)}}}const ai='{"title":"Load pipelines","local":"load-pipelines","sections":[{"title":"Load a pipeline","local":"load-a-pipeline","sections":[{"title":"Local pipeline","local":"local-pipeline","sections":[],"depth":3}],"depth":2},{"title":"Customize a pipeline","local":"customize-a-pipeline","sections":[],"depth":2},{"title":"Reuse a pipeline","local":"reuse-a-pipeline","sections":[{"title":"Modify from_pipe components","local":"modify-frompipe-components","sections":[],"depth":3},{"title":"Memory usage of from_pipe","local":"memory-usage-of-frompipe","sections":[],"depth":3}],"depth":2},{"title":"Safety checker","local":"safety-checker","sections":[],"depth":2},{"title":"Checkpoint variants","local":"checkpoint-variants","sections":[],"depth":2},{"title":"DiffusionPipeline explained","local":"diffusionpipeline-explained","sections":[],"depth":2}],"depth":1}';function pi(w){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mi extends qt{constructor(i){super(),xt(this,i,pi,ni,Yt,{})}}export{Mi as component};
