import{s as ss,o as rs,n as H}from"../chunks/scheduler.9bc65507.js";import{S as ls,i as is,g as c,s,r as u,A as cs,h as d,f as i,c as r,j as C,u as f,x as h,k as $,y as a,a as p,v as g,d as _,t as v,w as b}from"../chunks/index.707bf1b6.js";import{T as vt}from"../chunks/Tip.c2ecdbf4.js";import{D as F}from"../chunks/Docstring.17db21ae.js";import{C as kt}from"../chunks/CodeBlock.54a9f38d.js";import{F as ds,M as qn}from"../chunks/Markdown.fef84341.js";import{E as Ct}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{P as ns}from"../chunks/PipelineTag.44585822.js";import{H as we}from"../chunks/Heading.342b1fa6.js";function ps(x){let e,y="Example:",n,l,w;return l=new kt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdhdjJWZWMyQ29uZmlnJTJDJTIwV2F2MlZlYzJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBXYXYyVmVjMiUyMGZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS05NjBoJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFdhdjJWZWMyQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS05NjBoJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBXYXYyVmVjMk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Wav2Vec2Config, Wav2Vec2Model

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Wav2Vec2 facebook/wav2vec2-base-960h style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Wav2Vec2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the facebook/wav2vec2-base-960h style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Wav2Vec2Model(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){e=c("p"),e.textContent=y,n=s(),u(l.$$.fragment)},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=y),n=r(o),f(l.$$.fragment,o)},m(o,M){p(o,e,M),p(o,n,M),g(l,o,M),w=!0},p:H,i(o){w||(_(l.$$.fragment,o),w=!0)},o(o){v(l.$$.fragment,o),w=!1},d(o){o&&(i(e),i(n)),b(l,o)}}}function ms(x){let e,y="Example:",n,l,w;return l=new kt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s see how to retrieve time steps for a model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoFeatureExtractor, AutoModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> datasets
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># import model, feature extractor, tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load first sample of English common_voice</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;mozilla-foundation/common_voice_11_0&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, datasets.Audio(sampling_rate=<span class="hljs-number">16_000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_iter = <span class="hljs-built_in">iter</span>(dataset)
<span class="hljs-meta">&gt;&gt;&gt; </span>sample = <span class="hljs-built_in">next</span>(dataset_iter)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward sample through model to get greedily predicted transcription ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = feature_extractor(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_values
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(input_values).logits[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_ids = torch.argmax(logits, axis=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># retrieve word stamps (analogous commands for \`output_char_offsets\`)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.decode(pred_ids, output_word_offsets=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute \`time_offset\` in seconds as product of downsampling ratio and sampling_rate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>time_offset = model.config.inputs_to_logits_ratio / feature_extractor.sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>word_offsets = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;word&quot;</span>: d[<span class="hljs-string">&quot;word&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;start_time&quot;</span>: <span class="hljs-built_in">round</span>(d[<span class="hljs-string">&quot;start_offset&quot;</span>] * time_offset, <span class="hljs-number">2</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;end_time&quot;</span>: <span class="hljs-built_in">round</span>(d[<span class="hljs-string">&quot;end_offset&quot;</span>] * time_offset, <span class="hljs-number">2</span>),
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> outputs.word_offsets
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compare word offsets with audio \`en_train_0/common_voice_en_19121553.mp3\` online on the dataset viewer:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># https://huggingface.co/datasets/mozilla-foundation/common_voice_11_0/viewer/en</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>word_offsets[:<span class="hljs-number">3</span>]
[{<span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;THE&#x27;</span>, <span class="hljs-string">&#x27;start_time&#x27;</span>: <span class="hljs-number">0.7</span>, <span class="hljs-string">&#x27;end_time&#x27;</span>: <span class="hljs-number">0.78</span>}, {<span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;TRICK&#x27;</span>, <span class="hljs-string">&#x27;start_time&#x27;</span>: <span class="hljs-number">0.88</span>, <span class="hljs-string">&#x27;end_time&#x27;</span>: <span class="hljs-number">1.08</span>}, {<span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;APPEARS&#x27;</span>, <span class="hljs-string">&#x27;start_time&#x27;</span>: <span class="hljs-number">1.2</span>, <span class="hljs-string">&#x27;end_time&#x27;</span>: <span class="hljs-number">1.64</span>}]`,wrap:!1}}),{c(){e=c("p"),e.textContent=y,n=s(),u(l.$$.fragment)},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=y),n=r(o),f(l.$$.fragment,o)},m(o,M){p(o,e,M),p(o,n,M),g(l,o,M),w=!0},p:H,i(o){w||(_(l.$$.fragment,o),w=!0)},o(o){v(l.$$.fragment,o),w=!1},d(o){o&&(i(e),i(n)),b(l,o)}}}function hs(x){let e,y=`This class method is simply calling <a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){e=c("p"),e.innerHTML=y},l(n){e=d(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-1qvfzw2"&&(e.innerHTML=y)},m(n,l){p(n,e,l)},p:H,d(n){n&&i(e)}}}function us(x){let e,y=`This class method is simply calling Wav2Vec2FeatureExtractor’s
<a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, Wav2Vec2CTCTokenizer’s
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.from_pretrained">from_pretrained()</a>, and
<code>pyctcdecode.BeamSearchDecoderCTC.load_from_hf_hub</code>.`,n,l,w="Please refer to the docstrings of the methods above for more information.";return{c(){e=c("p"),e.innerHTML=y,n=s(),l=c("p"),l.textContent=w},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-1njkgj5"&&(e.innerHTML=y),n=r(o),l=d(o,"P",{"data-svelte-h":!0}),h(l)!=="svelte-1v5a8ev"&&(l.textContent=w)},m(o,M){p(o,e,M),p(o,n,M),p(o,l,M)},p:H,d(o){o&&(i(e),i(n),i(l))}}}function fs(x){let e,y=`This function makes use of Python’s multiprocessing. Currently, multiprocessing is available only on Unix
systems (see this <a href="https://github.com/kensho-technologies/pyctcdecode/issues/65" rel="nofollow">issue</a>).`,n,l,w=`If you are decoding multiple batches, consider creating a <code>Pool</code> and passing it to <code>batch_decode</code>. Otherwise,
<code>batch_decode</code> will be very slow since it will create a fresh <code>Pool</code> for each call. See usage example below.`;return{c(){e=c("p"),e.innerHTML=y,n=s(),l=c("p"),l.innerHTML=w},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-mir1wd"&&(e.innerHTML=y),n=r(o),l=d(o,"P",{"data-svelte-h":!0}),h(l)!=="svelte-4v42s1"&&(l.innerHTML=w)},m(o,M){p(o,e,M),p(o,n,M),p(o,l,M)},p:H,d(o){o&&(i(e),i(n),i(l))}}}function gs(x){let e,y="Example:",n,l,w;return l=new kt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s see how to retrieve time steps for a model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoProcessor, AutoModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> datasets
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># import model, feature extractor, tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;patrickvonplaten/wav2vec2-base-100h-with-lm&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;patrickvonplaten/wav2vec2-base-100h-with-lm&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load first sample of English common_voice</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;mozilla-foundation/common_voice_11_0&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, datasets.Audio(sampling_rate=<span class="hljs-number">16_000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_iter = <span class="hljs-built_in">iter</span>(dataset)
<span class="hljs-meta">&gt;&gt;&gt; </span>sample = <span class="hljs-built_in">next</span>(dataset_iter)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward sample through model to get greedily predicted transcription ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = processor(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_values
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(input_values).logits[<span class="hljs-number">0</span>].cpu().numpy()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># retrieve word stamps (analogous commands for \`output_char_offsets\`)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.decode(logits, output_word_offsets=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute \`time_offset\` in seconds as product of downsampling ratio and sampling_rate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>time_offset = model.config.inputs_to_logits_ratio / processor.feature_extractor.sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>word_offsets = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;word&quot;</span>: d[<span class="hljs-string">&quot;word&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;start_time&quot;</span>: <span class="hljs-built_in">round</span>(d[<span class="hljs-string">&quot;start_offset&quot;</span>] * time_offset, <span class="hljs-number">2</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;end_time&quot;</span>: <span class="hljs-built_in">round</span>(d[<span class="hljs-string">&quot;end_offset&quot;</span>] * time_offset, <span class="hljs-number">2</span>),
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> outputs.word_offsets
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compare word offsets with audio \`en_train_0/common_voice_en_19121553.mp3\` online on the dataset viewer:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># https://huggingface.co/datasets/mozilla-foundation/common_voice_11_0/viewer/en</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>word_offsets[:<span class="hljs-number">4</span>]
[{<span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;THE&#x27;</span>, <span class="hljs-string">&#x27;start_time&#x27;</span>: <span class="hljs-number">0.68</span>, <span class="hljs-string">&#x27;end_time&#x27;</span>: <span class="hljs-number">0.78</span>}, {<span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;TRACK&#x27;</span>, <span class="hljs-string">&#x27;start_time&#x27;</span>: <span class="hljs-number">0.88</span>, <span class="hljs-string">&#x27;end_time&#x27;</span>: <span class="hljs-number">1.1</span>}, {<span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;APPEARS&#x27;</span>, <span class="hljs-string">&#x27;start_time&#x27;</span>: <span class="hljs-number">1.18</span>, <span class="hljs-string">&#x27;end_time&#x27;</span>: <span class="hljs-number">1.66</span>}, {<span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;ON&#x27;</span>, <span class="hljs-string">&#x27;start_time&#x27;</span>: <span class="hljs-number">1.86</span>, <span class="hljs-string">&#x27;end_time&#x27;</span>: <span class="hljs-number">1.92</span>}]`,wrap:!1}}),{c(){e=c("p"),e.textContent=y,n=s(),u(l.$$.fragment)},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=y),n=r(o),f(l.$$.fragment,o)},m(o,M){p(o,e,M),p(o,n,M),g(l,o,M),w=!0},p:H,i(o){w||(_(l.$$.fragment,o),w=!0)},o(o){v(l.$$.fragment,o),w=!1},d(o){o&&(i(e),i(n)),b(l,o)}}}function _s(x){let e,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=y},l(n){e=d(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=y)},m(n,l){p(n,e,l)},p:H,d(n){n&&i(e)}}}function vs(x){let e,y="Example:",n,l,w;return l=new kt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXYXYyVmVjMk1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1iYXNlLTk2MGglMjIpJTBBbW9kZWwlMjAlM0QlMjBXYXYyVmVjMk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UtOTYwaCUyMiklMEElMEElMjMlMjBhdWRpbyUyMGZpbGUlMjBpcyUyMGRlY29kZWQlMjBvbiUyMHRoZSUyMGZseSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihkYXRhc2V0JTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Wav2Vec2Model
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Wav2Vec2Model.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">292</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){e=c("p"),e.textContent=y,n=s(),u(l.$$.fragment)},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=y),n=r(o),f(l.$$.fragment,o)},m(o,M){p(o,e,M),p(o,n,M),g(l,o,M),w=!0},p:H,i(o){w||(_(l.$$.fragment,o),w=!0)},o(o){v(l.$$.fragment,o),w=!1},d(o){o&&(i(e),i(n)),b(l,o)}}}function bs(x){let e,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=y},l(n){e=d(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=y)},m(n,l){p(n,e,l)},p:H,d(n){n&&i(e)}}}function ys(x){let e,y="Example:",n,l,w;return l=new kt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXYXYyVmVjMkZvckNUQyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS05NjBoJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2F2MlZlYzJGb3JDVEMuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS05NjBoJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTBBJTIzJTIwdHJhbnNjcmliZSUyMHNwZWVjaCUwQXRyYW5zY3JpcHRpb24lMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKHByZWRpY3RlZF9pZHMpJTBBdHJhbnNjcmlwdGlvbiU1QjAlNUQlMEElMEFpbnB1dHMlNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRGRhdGFzZXQlNUIwJTVEJTVCJTIydGV4dCUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcyUwQSUwQSUyMyUyMGNvbXB1dGUlMjBsb3NzJTBBbG9zcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb3NzJTBBcm91bmQobG9zcy5pdGVtKCklMkMlMjAyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Wav2Vec2ForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Wav2Vec2ForCTC.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># transcribe speech</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;MISTER QUILTER IS THE APOSTLE OF THE MIDDLE CLASSES AND WE ARE GLAD TO WELCOME HIS GOSPEL&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;labels&quot;</span>] = processor(text=dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">53.48</span>`,wrap:!1}}),{c(){e=c("p"),e.textContent=y,n=s(),u(l.$$.fragment)},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=y),n=r(o),f(l.$$.fragment,o)},m(o,M){p(o,e,M),p(o,n,M),g(l,o,M),w=!0},p:H,i(o){w||(_(l.$$.fragment,o),w=!0)},o(o){v(l.$$.fragment,o),w=!1},d(o){o&&(i(e),i(n)),b(l,o)}}}function ws(x){let e,y=`Activate the special <a href="https://huggingface.co/transformers/installation.html#offline-mode" rel="nofollow">“offline-mode”</a> to
use this method in a firewalled environment.`;return{c(){e=c("p"),e.innerHTML=y},l(n){e=d(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-13hahdn"&&(e.innerHTML=y)},m(n,l){p(n,e,l)},p:H,d(n){n&&i(e)}}}function Ms(x){let e,y="Examples:",n,l,w;return l=new kt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdhdjJWZWMyRm9yQ1RDJTJDJTIwQXV0b1Byb2Nlc3NvciUwQSUwQWNrcHQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm1tcy0xYi1hbGwlMjIlMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChja3B0KSUwQW1vZGVsJTIwJTNEJTIwV2F2MlZlYzJGb3JDVEMuZnJvbV9wcmV0cmFpbmVkKGNrcHQlMkMlMjB0YXJnZXRfbGFuZyUzRCUyMmVuZyUyMiklMEElMjMlMjBzZXQlMjBzcGVjaWZpYyUyMGxhbmd1YWdlJTBBcHJvY2Vzc29yLnRva2VuaXplci5zZXRfdGFyZ2V0X2xhbmcoJTIyc3BhJTIyKSUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJzcGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Wav2Vec2ForCTC, AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>ckpt = <span class="hljs-string">&quot;facebook/mms-1b-all&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(ckpt)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Wav2Vec2ForCTC.from_pretrained(ckpt, target_lang=<span class="hljs-string">&quot;eng&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set specific language</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.tokenizer.set_target_lang(<span class="hljs-string">&quot;spa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.load_adapter(<span class="hljs-string">&quot;spa&quot;</span>)`,wrap:!1}}),{c(){e=c("p"),e.textContent=y,n=s(),u(l.$$.fragment)},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-kvfsh7"&&(e.textContent=y),n=r(o),f(l.$$.fragment,o)},m(o,M){p(o,e,M),p(o,n,M),g(l,o,M),w=!0},p:H,i(o){w||(_(l.$$.fragment,o),w=!0)},o(o){v(l.$$.fragment,o),w=!1},d(o){o&&(i(e),i(n)),b(l,o)}}}function Ts(x){let e,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=y},l(n){e=d(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=y)},m(n,l){p(n,e,l)},p:H,d(n){n&&i(e)}}}function js(x){let e,y="Example:",n,l,w;return l=new kt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwV2F2MlZlYzJGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyc3VwZXJiJTJGd2F2MnZlYzItYmFzZS1zdXBlcmIta3MlMjIpJTBBbW9kZWwlMjAlM0QlMjBXYXYyVmVjMkZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnN1cGVyYiUyRndhdjJ2ZWMyLWJhc2Utc3VwZXJiLWtzJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSkuaXRlbSgpJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkcyU1RCUwQXByZWRpY3RlZF9sYWJlbCUwQSUwQSUyMyUyMGNvbXB1dGUlMjBsb3NzJTIwLSUyMHRhcmdldF9sYWJlbCUyMGlzJTIwZS5nLiUyMCUyMmRvd24lMjIlMEF0YXJnZXRfbGFiZWwlMjAlM0QlMjBtb2RlbC5jb25maWcuaWQybGFiZWwlNUIwJTVEJTBBaW5wdXRzJTVCJTIybGFiZWxzJTIyJTVEJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qm1vZGVsLmNvbmZpZy5sYWJlbDJpZCU1QnRhcmdldF9sYWJlbCU1RCU1RCklMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvc3MlMEFyb3VuZChsb3NzLml0ZW0oKSUyQyUyMDIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, Wav2Vec2ForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;superb/wav2vec2-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Wav2Vec2ForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;superb/wav2vec2-base-superb-ks&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label
<span class="hljs-string">&#x27;_unknown_&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss - target_label is e.g. &quot;down&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_label = model.config.id2label[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;labels&quot;</span>] = torch.tensor([model.config.label2id[target_label]])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">6.54</span>`,wrap:!1}}),{c(){e=c("p"),e.textContent=y,n=s(),u(l.$$.fragment)},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=y),n=r(o),f(l.$$.fragment,o)},m(o,M){p(o,e,M),p(o,n,M),g(l,o,M),w=!0},p:H,i(o){w||(_(l.$$.fragment,o),w=!0)},o(o){v(l.$$.fragment,o),w=!1},d(o){o&&(i(e),i(n)),b(l,o)}}}function ks(x){let e,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=y},l(n){e=d(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=y)},m(n,l){p(n,e,l)},p:H,d(n){n&&i(e)}}}function Ws(x){let e,y="Example:",n,l,w;return l=new kt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwV2F2MlZlYzJGb3JBdWRpb0ZyYW1lQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJhbnRvbi1sJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc2QlMjIpJTBBbW9kZWwlMjAlM0QlMjBXYXYyVmVjMkZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYW50b24tbCUyRndhdjJ2ZWMyLWJhc2Utc3VwZXJiLXNkJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzJTVCMCU1RCklMEElMjMlMjBsYWJlbHMlMjBpcyUyMGElMjBvbmUtaG90JTIwYXJyYXklMjBvZiUyMHNoYXBlJTIwKG51bV9mcmFtZXMlMkMlMjBudW1fc3BlYWtlcnMpJTBBbGFiZWxzJTIwJTNEJTIwKHByb2JhYmlsaXRpZXMlMjAlM0UlMjAwLjUpLmxvbmcoKSUwQWxhYmVscyU1QjAlNUQudG9saXN0KCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, Wav2Vec2ForAudioFrameClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;anton-l/wav2vec2-base-superb-sd&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Wav2Vec2ForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;anton-l/wav2vec2-base-superb-sd&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, sampling_rate=sampling_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.sigmoid(logits[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># labels is a one-hot array of shape (num_frames, num_speakers)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = (probabilities &gt; <span class="hljs-number">0.5</span>).long()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[<span class="hljs-number">0</span>].tolist()
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>]`,wrap:!1}}),{c(){e=c("p"),e.textContent=y,n=s(),u(l.$$.fragment)},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=y),n=r(o),f(l.$$.fragment,o)},m(o,M){p(o,e,M),p(o,n,M),g(l,o,M),w=!0},p:H,i(o){w||(_(l.$$.fragment,o),w=!0)},o(o){v(l.$$.fragment,o),w=!1},d(o){o&&(i(e),i(n)),b(l,o)}}}function xs(x){let e,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=y},l(n){e=d(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=y)},m(n,l){p(n,e,l)},p:H,d(n){n&&i(e)}}}function Vs(x){let e,y="Example:",n,l,w;return l=new kt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwV2F2MlZlYzJGb3JYVmVjdG9yJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyYW50b24tbCUyRndhdjJ2ZWMyLWJhc2Utc3VwZXJiLXN2JTIyKSUwQW1vZGVsJTIwJTNEJTIwV2F2MlZlYzJGb3JYVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJhbnRvbi1sJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc3YlMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvciglMEElMjAlMjAlMjAlMjAlNUJkJTVCJTIyYXJyYXklMjIlNUQlMjBmb3IlMjBkJTIwaW4lMjBkYXRhc2V0JTVCJTNBMiU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykuZW1iZWRkaW5ncyUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLm5vcm1hbGl6ZShlbWJlZGRpbmdzJTJDJTIwZGltJTNELTEpLmNwdSgpJTBBJTBBJTIzJTIwdGhlJTIwcmVzdWx0aW5nJTIwZW1iZWRkaW5ncyUyMGNhbiUyMGJlJTIwdXNlZCUyMGZvciUyMGNvc2luZSUyMHNpbWlsYXJpdHktYmFzZWQlMjByZXRyaWV2YWwlMEFjb3NpbmVfc2ltJTIwJTNEJTIwdG9yY2gubm4uQ29zaW5lU2ltaWxhcml0eShkaW0lM0QtMSklMEFzaW1pbGFyaXR5JTIwJTNEJTIwY29zaW5lX3NpbShlbWJlZGRpbmdzJTVCMCU1RCUyQyUyMGVtYmVkZGluZ3MlNUIxJTVEKSUwQXRocmVzaG9sZCUyMCUzRCUyMDAuNyUyMCUyMCUyMyUyMHRoZSUyMG9wdGltYWwlMjB0aHJlc2hvbGQlMjBpcyUyMGRhdGFzZXQtZGVwZW5kZW50JTBBaWYlMjBzaW1pbGFyaXR5JTIwJTNDJTIwdGhyZXNob2xkJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyU3BlYWtlcnMlMjBhcmUlMjBub3QlMjB0aGUlMjBzYW1lISUyMiklMEFyb3VuZChzaW1pbGFyaXR5Lml0ZW0oKSUyQyUyMDIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, Wav2Vec2ForXVector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;anton-l/wav2vec2-base-superb-sv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Wav2Vec2ForXVector.from_pretrained(<span class="hljs-string">&quot;anton-l/wav2vec2-base-superb-sv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    [d[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;audio&quot;</span>]], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    embeddings = model(**inputs).embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = torch.nn.functional.normalize(embeddings, dim=-<span class="hljs-number">1</span>).cpu()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the resulting embeddings can be used for cosine similarity-based retrieval</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.nn.CosineSimilarity(dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>similarity = cosine_sim(embeddings[<span class="hljs-number">0</span>], embeddings[<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>threshold = <span class="hljs-number">0.7</span>  <span class="hljs-comment"># the optimal threshold is dataset-dependent</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> similarity &lt; threshold:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Speakers are not the same!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(similarity.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">0.98</span>`,wrap:!1}}),{c(){e=c("p"),e.textContent=y,n=s(),u(l.$$.fragment)},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=y),n=r(o),f(l.$$.fragment,o)},m(o,M){p(o,e,M),p(o,n,M),g(l,o,M),w=!0},p:H,i(o){w||(_(l.$$.fragment,o),w=!0)},o(o){v(l.$$.fragment,o),w=!1},d(o){o&&(i(e),i(n)),b(l,o)}}}function Js(x){let e,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=y},l(n){e=d(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=y)},m(n,l){p(n,e,l)},p:H,d(n){n&&i(e)}}}function Cs(x){let e,y="Example:",n,l,w;return l=new kt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, Wav2Vec2ForPreTraining
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.models.wav2vec2.modeling_wav2vec2 <span class="hljs-keyword">import</span> _compute_mask_indices, _sample_negative_indices
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Wav2Vec2ForPreTraining.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = feature_extractor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_values  <span class="hljs-comment"># Batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute masked indices</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size, raw_sequence_length = input_values.shape
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_length = model._get_feat_extract_output_lengths(raw_sequence_length).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_time_indices = _compute_mask_indices(
<span class="hljs-meta">... </span>    shape=(batch_size, sequence_length), mask_prob=<span class="hljs-number">0.2</span>, mask_length=<span class="hljs-number">2</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampled_negative_indices = _sample_negative_indices(
<span class="hljs-meta">... </span>    features_shape=(batch_size, sequence_length),
<span class="hljs-meta">... </span>    num_negatives=model.config.num_negatives,
<span class="hljs-meta">... </span>    mask_time_indices=mask_time_indices,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_time_indices = torch.tensor(data=mask_time_indices, device=input_values.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampled_negative_indices = torch.tensor(
<span class="hljs-meta">... </span>    data=sampled_negative_indices, device=input_values.device, dtype=torch.long
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(input_values, mask_time_indices=mask_time_indices)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute cosine similarity between predicted (=projected_states) and target (=projected_quantized_states)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.cosine_similarity(outputs.projected_states, outputs.projected_quantized_states, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># show that cosine similarity is much higher than random</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim[mask_time_indices.to(torch.<span class="hljs-built_in">bool</span>)].mean() &gt; <span class="hljs-number">0.5</span>
tensor(<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># for contrastive loss training model should be put into train mode</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = model.train()
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(
<span class="hljs-meta">... </span>    input_values, mask_time_indices=mask_time_indices, sampled_negative_indices=sampled_negative_indices
<span class="hljs-meta">... </span>).loss`,wrap:!1}}),{c(){e=c("p"),e.textContent=y,n=s(),u(l.$$.fragment)},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=y),n=r(o),f(l.$$.fragment,o)},m(o,M){p(o,e,M),p(o,n,M),g(l,o,M),w=!0},p:H,i(o){w||(_(l.$$.fragment,o),w=!0)},o(o){v(l.$$.fragment,o),w=!1},d(o){o&&(i(e),i(n)),b(l,o)}}}function $s(x){let e,y,n,l,w,o,M=`The bare Wav2Vec2 Model transformer outputting raw hidden-states without any specific head on top.
Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,Me,B,K=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,Te,X,ee=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,je,W,R,re,Q,Qt='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a> forward method, overrides the <code>__call__</code> special method.',Ne,Y,Ze,S,Ke,he,Je,I,ue,le,fe,ke=`Wav2Vec2 Model with a <code>language modeling</code> head on top for Connectionist Temporal Classification (CTC).
Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,ze,z,et=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,Ie,oe,O=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ve,ae,We,tt,Be,ht='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a> forward method, overrides the <code>__call__</code> special method.',ot,xe,at,be,qe,G,ye,N,A,It="Load a language adapter model from a pre-trained adapter model.",Ce,$e,$t,E,Fe,P,Ve,T,V,Z,ne,Ye=`Wav2Vec2 Model with a sequence classification head on top (a linear layer over the pooled output) for tasks like
SUPERB Keyword Spotting.`,D,ie,bt=`Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,Bt,Xt,Wt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,nt,Gt,Rt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Nt,He,st,rt,qt,Le='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForSequenceClassification">Wav2Vec2ForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',ge,Xe,Ft,lt,to,it,yt,ce,de,St,k,U="Wav2Vec2 Model with a frame classification head on top for tasks like Speaker Diarization.",Ee,L,ut=`Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,pe,te,Yt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,Qo,Ht,La=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Bo,Ge,At,ft,Ut,wa='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForAudioFrameClassification">Wav2Vec2ForAudioFrameClassification</a> forward method, overrides the <code>__call__</code> special method.',bo,oo,So,xt,Ao,ao,Lt,me,no,yo,Jo,Do="Wav2Vec2 Model with an XVector feature extraction head on top for tasks like Speaker Verification.",so,ro,se=`Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,lo,wo,Co=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,Ma,Mo,$o=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ta,wt,Mt,io,To,Fo='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForXVector">Wav2Vec2ForXVector</a> forward method, overrides the <code>__call__</code> special method.',ja,Dt,Ot,Tt,Xo,Zt,Oo,Pe,zt,co,jo,Et=`Wav2Vec2 Model with a quantizer and <code>VQ</code> head on top.
Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,po,ko,Uo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving etc.).`,ka,Wo,mo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ko,Ue,Vt,ea,Pt,Ea='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForPreTraining">Wav2Vec2ForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',ta,gt,ho,Kt,uo;return e=new we({props:{title:"Wav2Vec2Model",local:"transformers.Wav2Vec2Model",headingTag:"h2"}}),l=new F({props:{name:"class transformers.Wav2Vec2Model",anchor:"transformers.Wav2Vec2Model",parameters:[{name:"config",val:": Wav2Vec2Config"}],parametersDescription:[{anchor:"transformers.Wav2Vec2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L1441"}}),R=new F({props:{name:"forward",anchor:"transformers.Wav2Vec2Model.forward",parameters:[{name:"input_values",val:": Optional"},{name:"attention_mask",val:": Optional = None"},{name:"mask_time_indices",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Wav2Vec2Model.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.Wav2Vec2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.Wav2Vec2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Wav2Vec2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Wav2Vec2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L1531",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.modeling_outputs.Wav2Vec2BaseModelOutput"
>transformers.modeling_outputs.Wav2Vec2BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config"
>Wav2Vec2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>extract_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, conv_dim[-1])</code>) — Sequence of extracted feature vectors of the last convolutional layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.modeling_outputs.Wav2Vec2BaseModelOutput"
>transformers.modeling_outputs.Wav2Vec2BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Y=new vt({props:{$$slots:{default:[_s]},$$scope:{ctx:x}}}),S=new Ct({props:{anchor:"transformers.Wav2Vec2Model.forward.example",$$slots:{default:[vs]},$$scope:{ctx:x}}}),he=new we({props:{title:"Wav2Vec2ForCTC",local:"transformers.Wav2Vec2ForCTC",headingTag:"h2"}}),ue=new F({props:{name:"class transformers.Wav2Vec2ForCTC",anchor:"transformers.Wav2Vec2ForCTC",parameters:[{name:"config",val:""},{name:"target_lang",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForCTC.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.Wav2Vec2ForCTC.target_lang",description:`<strong>target_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Language id of adapter weights. Adapter weights are stored in the format adapter.<lang>.safetensors or
adapter.<lang>.bin. Only relevant when using an instance of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a> with adapters. Uses &#x2018;eng&#x2019; by
default.</lang></lang>`,name:"target_lang"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L1860"}}),We=new F({props:{name:"forward",anchor:"transformers.Wav2Vec2ForCTC.forward",parameters:[{name:"input_values",val:": Optional"},{name:"attention_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"labels",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.Wav2Vec2ForCTC.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.Wav2Vec2ForCTC.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Wav2Vec2ForCTC.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Wav2Vec2ForCTC.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Wav2Vec2ForCTC.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_length)</code>, <em>optional</em>) &#x2014;
Labels for connectionist temporal classification. Note that <code>target_length</code> has to be smaller or equal to
the sequence length of the output logits. Indices are selected in <code>[-100, 0, ..., config.vocab_size - 1]</code>.
All labels set to <code>-100</code> are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L1942",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config"
>Wav2Vec2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),xe=new vt({props:{$$slots:{default:[bs]},$$scope:{ctx:x}}}),be=new Ct({props:{anchor:"transformers.Wav2Vec2ForCTC.forward.example",$$slots:{default:[ys]},$$scope:{ctx:x}}}),ye=new F({props:{name:"load_adapter",anchor:"transformers.Wav2Vec2ForCTC.load_adapter",parameters:[{name:"target_lang",val:": str"},{name:"force_load",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.target_lang",description:`<strong>target_lang</strong> (<code>str</code>) &#x2014;
Has to be a language id of an existing adapter weight. Adapter weights are stored in the format
adapter.<lang>.safetensors or adapter.<lang>.bin</lang></lang>`,name:"target_lang"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.force_load",description:`<strong>force_load</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether the weights shall be loaded even if <code>target_lang</code> matches <code>self.target_lang</code>.`,name:"force_load"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (i.e., do not try to download the model).`,name:"local_files_only(bool,"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, or not specified, will use
the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass \`revision=&#x201C;refs/pr/<pr_number>&#x201C;.</pr_number></p>

					</div>`,name:"revision"},{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to accelerate downloads in China. If you are from China and have an accessibility
problem, you can set this option to resolve it. Note that we do not guarantee the timeliness or safety.
Please refer to the mirror site for more information.`,name:"mirror"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L1192"}}),$e=new vt({props:{$$slots:{default:[ws]},$$scope:{ctx:x}}}),E=new Ct({props:{anchor:"transformers.Wav2Vec2ForCTC.load_adapter.example",$$slots:{default:[Ms]},$$scope:{ctx:x}}}),P=new we({props:{title:"Wav2Vec2ForSequenceClassification",local:"transformers.Wav2Vec2ForSequenceClassification",headingTag:"h2"}}),V=new F({props:{name:"class transformers.Wav2Vec2ForSequenceClassification",anchor:"transformers.Wav2Vec2ForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L2022"}}),st=new F({props:{name:"forward",anchor:"transformers.Wav2Vec2ForSequenceClassification.forward",parameters:[{name:"input_values",val:": Optional"},{name:"attention_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"labels",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForSequenceClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.Wav2Vec2ForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.Wav2Vec2ForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Wav2Vec2ForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Wav2Vec2ForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Wav2Vec2ForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L2074",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config"
>Wav2Vec2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Xe=new vt({props:{$$slots:{default:[Ts]},$$scope:{ctx:x}}}),lt=new Ct({props:{anchor:"transformers.Wav2Vec2ForSequenceClassification.forward.example",$$slots:{default:[js]},$$scope:{ctx:x}}}),it=new we({props:{title:"Wav2Vec2ForAudioFrameClassification",local:"transformers.Wav2Vec2ForAudioFrameClassification",headingTag:"h2"}}),de=new F({props:{name:"class transformers.Wav2Vec2ForAudioFrameClassification",anchor:"transformers.Wav2Vec2ForAudioFrameClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForAudioFrameClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L2145"}}),At=new F({props:{name:"forward",anchor:"transformers.Wav2Vec2ForAudioFrameClassification.forward",parameters:[{name:"input_values",val:": Optional"},{name:"attention_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForAudioFrameClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.Wav2Vec2ForAudioFrameClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.Wav2Vec2ForAudioFrameClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Wav2Vec2ForAudioFrameClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Wav2Vec2ForAudioFrameClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Wav2Vec2ForAudioFrameClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L2195",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config"
>Wav2Vec2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),oo=new vt({props:{$$slots:{default:[ks]},$$scope:{ctx:x}}}),xt=new Ct({props:{anchor:"transformers.Wav2Vec2ForAudioFrameClassification.forward.example",$$slots:{default:[Ws]},$$scope:{ctx:x}}}),ao=new we({props:{title:"Wav2Vec2ForXVector",local:"transformers.Wav2Vec2ForXVector",headingTag:"h2"}}),no=new F({props:{name:"class transformers.Wav2Vec2ForXVector",anchor:"transformers.Wav2Vec2ForXVector",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForXVector.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L2311"}}),Mt=new F({props:{name:"forward",anchor:"transformers.Wav2Vec2ForXVector.forward",parameters:[{name:"input_values",val:": Optional"},{name:"attention_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"labels",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForXVector.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.Wav2Vec2ForXVector.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.Wav2Vec2ForXVector.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Wav2Vec2ForXVector.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Wav2Vec2ForXVector.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Wav2Vec2ForXVector.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L2379",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.XVectorOutput"
>transformers.modeling_outputs.XVectorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config"
>Wav2Vec2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.xvector_output_dim)</code>) — Classification hidden states before AMSoftmax.</p>
</li>
<li>
<p><strong>embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.xvector_output_dim)</code>) — Utterance embeddings used for vector similarity-based retrieval.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.XVectorOutput"
>transformers.modeling_outputs.XVectorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Dt=new vt({props:{$$slots:{default:[xs]},$$scope:{ctx:x}}}),Tt=new Ct({props:{anchor:"transformers.Wav2Vec2ForXVector.forward.example",$$slots:{default:[Vs]},$$scope:{ctx:x}}}),Zt=new we({props:{title:"Wav2Vec2ForPreTraining",local:"transformers.Wav2Vec2ForPreTraining",headingTag:"h2"}}),zt=new F({props:{name:"class transformers.Wav2Vec2ForPreTraining",anchor:"transformers.Wav2Vec2ForPreTraining",parameters:[{name:"config",val:": Wav2Vec2Config"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L1592"}}),Vt=new F({props:{name:"forward",anchor:"transformers.Wav2Vec2ForPreTraining.forward",parameters:[{name:"input_values",val:": Optional"},{name:"attention_mask",val:": Optional = None"},{name:"mask_time_indices",val:": Optional = None"},{name:"sampled_negative_indices",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ForPreTraining.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.Wav2Vec2ForPreTraining.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p><code>attention_mask</code> should only be passed if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.</p>

					</div>`,name:"attention_mask"},{anchor:"transformers.Wav2Vec2ForPreTraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Wav2Vec2ForPreTraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Wav2Vec2ForPreTraining.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Wav2Vec2ForPreTraining.forward.mask_time_indices",description:`<strong>mask_time_indices</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices to mask extracted features for contrastive loss. When in training mode, model learns to predict
masked extracted features in <em>config.proj_codevector_dim</em> space.`,name:"mask_time_indices"},{anchor:"transformers.Wav2Vec2ForPreTraining.forward.sampled_negative_indices",description:`<strong>sampled_negative_indices</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_negatives)</code>, <em>optional</em>) &#x2014;
Indices indicating which quantized target vectors are used as negative sampled vectors in contrastive loss.
Required input for pre-training.`,name:"sampled_negative_indices"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L1653",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput"
>transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config"
>Wav2Vec2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<em>optional</em>, returned when <code>sample_negative_indices</code> are passed, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) — Total loss as the sum of the contrastive loss (L_m) and the diversity loss (L_d) as stated in the <a
  href="https://arxiv.org/pdf/2006.11477.pdf"
  rel="nofollow"
>official
paper</a> . (classification) loss.</p>
</li>
<li>
<p><strong>projected_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) — Hidden-states of the model projected to <em>config.proj_codevector_dim</em> that can be used to predict the masked
projected quantized states.</p>
</li>
<li>
<p><strong>projected_quantized_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) — Quantized extracted feature vectors projected to <em>config.proj_codevector_dim</em> representing the positive
target vectors for contrastive loss.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>contrastive_loss</strong> (<em>optional</em>, returned when <code>sample_negative_indices</code> are passed, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) — The contrastive loss (L_m) as stated in the <a
  href="https://arxiv.org/pdf/2006.11477.pdf"
  rel="nofollow"
>official paper</a> .</p>
</li>
<li>
<p><strong>diversity_loss</strong> (<em>optional</em>, returned when <code>sample_negative_indices</code> are passed, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) — The diversity loss (L_d) as stated in the <a
  href="https://arxiv.org/pdf/2006.11477.pdf"
  rel="nofollow"
>official paper</a> .</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput"
>transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),gt=new vt({props:{$$slots:{default:[Js]},$$scope:{ctx:x}}}),Kt=new Ct({props:{anchor:"transformers.Wav2Vec2ForPreTraining.forward.example",$$slots:{default:[Cs]},$$scope:{ctx:x}}}),{c(){u(e.$$.fragment),y=s(),n=c("div"),u(l.$$.fragment),w=s(),o=c("p"),o.innerHTML=M,Me=s(),B=c("p"),B.innerHTML=K,Te=s(),X=c("p"),X.innerHTML=ee,je=s(),W=c("div"),u(R.$$.fragment),re=s(),Q=c("p"),Q.innerHTML=Qt,Ne=s(),u(Y.$$.fragment),Ze=s(),u(S.$$.fragment),Ke=s(),u(he.$$.fragment),Je=s(),I=c("div"),u(ue.$$.fragment),le=s(),fe=c("p"),fe.innerHTML=ke,ze=s(),z=c("p"),z.innerHTML=et,Ie=s(),oe=c("p"),oe.innerHTML=O,ve=s(),ae=c("div"),u(We.$$.fragment),tt=s(),Be=c("p"),Be.innerHTML=ht,ot=s(),u(xe.$$.fragment),at=s(),u(be.$$.fragment),qe=s(),G=c("div"),u(ye.$$.fragment),N=s(),A=c("p"),A.textContent=It,Ce=s(),u($e.$$.fragment),$t=s(),u(E.$$.fragment),Fe=s(),u(P.$$.fragment),Ve=s(),T=c("div"),u(V.$$.fragment),Z=s(),ne=c("p"),ne.textContent=Ye,D=s(),ie=c("p"),ie.innerHTML=bt,Bt=s(),Xt=c("p"),Xt.innerHTML=Wt,nt=s(),Gt=c("p"),Gt.innerHTML=Rt,Nt=s(),He=c("div"),u(st.$$.fragment),rt=s(),qt=c("p"),qt.innerHTML=Le,ge=s(),u(Xe.$$.fragment),Ft=s(),u(lt.$$.fragment),to=s(),u(it.$$.fragment),yt=s(),ce=c("div"),u(de.$$.fragment),St=s(),k=c("p"),k.textContent=U,Ee=s(),L=c("p"),L.innerHTML=ut,pe=s(),te=c("p"),te.innerHTML=Yt,Qo=s(),Ht=c("p"),Ht.innerHTML=La,Bo=s(),Ge=c("div"),u(At.$$.fragment),ft=s(),Ut=c("p"),Ut.innerHTML=wa,bo=s(),u(oo.$$.fragment),So=s(),u(xt.$$.fragment),Ao=s(),u(ao.$$.fragment),Lt=s(),me=c("div"),u(no.$$.fragment),yo=s(),Jo=c("p"),Jo.textContent=Do,so=s(),ro=c("p"),ro.innerHTML=se,lo=s(),wo=c("p"),wo.innerHTML=Co,Ma=s(),Mo=c("p"),Mo.innerHTML=$o,Ta=s(),wt=c("div"),u(Mt.$$.fragment),io=s(),To=c("p"),To.innerHTML=Fo,ja=s(),u(Dt.$$.fragment),Ot=s(),u(Tt.$$.fragment),Xo=s(),u(Zt.$$.fragment),Oo=s(),Pe=c("div"),u(zt.$$.fragment),co=s(),jo=c("p"),jo.innerHTML=Et,po=s(),ko=c("p"),ko.innerHTML=Uo,ka=s(),Wo=c("p"),Wo.innerHTML=mo,Ko=s(),Ue=c("div"),u(Vt.$$.fragment),ea=s(),Pt=c("p"),Pt.innerHTML=Ea,ta=s(),u(gt.$$.fragment),ho=s(),u(Kt.$$.fragment),this.h()},l(m){f(e.$$.fragment,m),y=r(m),n=d(m,"DIV",{class:!0});var J=C(n);f(l.$$.fragment,J),w=r(J),o=d(J,"P",{"data-svelte-h":!0}),h(o)!=="svelte-te9mu1"&&(o.innerHTML=M),Me=r(J),B=d(J,"P",{"data-svelte-h":!0}),h(B)!=="svelte-1c8p9n2"&&(B.innerHTML=K),Te=r(J),X=d(J,"P",{"data-svelte-h":!0}),h(X)!=="svelte-68lg8f"&&(X.innerHTML=ee),je=r(J),W=d(J,"DIV",{class:!0});var Qe=C(W);f(R.$$.fragment,Qe),re=r(Qe),Q=d(Qe,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-wrinab"&&(Q.innerHTML=Qt),Ne=r(Qe),f(Y.$$.fragment,Qe),Ze=r(Qe),f(S.$$.fragment,Qe),Qe.forEach(i),J.forEach(i),Ke=r(m),f(he.$$.fragment,m),Je=r(m),I=d(m,"DIV",{class:!0});var Re=C(I);f(ue.$$.fragment,Re),le=r(Re),fe=d(Re,"P",{"data-svelte-h":!0}),h(fe)!=="svelte-1p0g25y"&&(fe.innerHTML=ke),ze=r(Re),z=d(Re,"P",{"data-svelte-h":!0}),h(z)!=="svelte-1c8p9n2"&&(z.innerHTML=et),Ie=r(Re),oe=d(Re,"P",{"data-svelte-h":!0}),h(oe)!=="svelte-68lg8f"&&(oe.innerHTML=O),ve=r(Re),ae=d(Re,"DIV",{class:!0});var q=C(ae);f(We.$$.fragment,q),tt=r(q),Be=d(q,"P",{"data-svelte-h":!0}),h(Be)!=="svelte-pev92p"&&(Be.innerHTML=ht),ot=r(q),f(xe.$$.fragment,q),at=r(q),f(be.$$.fragment,q),q.forEach(i),qe=r(Re),G=d(Re,"DIV",{class:!0});var Se=C(G);f(ye.$$.fragment,Se),N=r(Se),A=d(Se,"P",{"data-svelte-h":!0}),h(A)!=="svelte-1uzynjt"&&(A.textContent=It),Ce=r(Se),f($e.$$.fragment,Se),$t=r(Se),f(E.$$.fragment,Se),Se.forEach(i),Re.forEach(i),Fe=r(m),f(P.$$.fragment,m),Ve=r(m),T=d(m,"DIV",{class:!0});var Ae=C(T);f(V.$$.fragment,Ae),Z=r(Ae),ne=d(Ae,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-dzph96"&&(ne.textContent=Ye),D=r(Ae),ie=d(Ae,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-q3avhg"&&(ie.innerHTML=bt),Bt=r(Ae),Xt=d(Ae,"P",{"data-svelte-h":!0}),h(Xt)!=="svelte-1c8p9n2"&&(Xt.innerHTML=Wt),nt=r(Ae),Gt=d(Ae,"P",{"data-svelte-h":!0}),h(Gt)!=="svelte-68lg8f"&&(Gt.innerHTML=Rt),Nt=r(Ae),He=d(Ae,"DIV",{class:!0});var ct=C(He);f(st.$$.fragment,ct),rt=r(ct),qt=d(ct,"P",{"data-svelte-h":!0}),h(qt)!=="svelte-12eo633"&&(qt.innerHTML=Le),ge=r(ct),f(Xe.$$.fragment,ct),Ft=r(ct),f(lt.$$.fragment,ct),ct.forEach(i),Ae.forEach(i),to=r(m),f(it.$$.fragment,m),yt=r(m),ce=d(m,"DIV",{class:!0});var dt=C(ce);f(de.$$.fragment,dt),St=r(dt),k=d(dt,"P",{"data-svelte-h":!0}),h(k)!=="svelte-1jplo9i"&&(k.textContent=U),Ee=r(dt),L=d(dt,"P",{"data-svelte-h":!0}),h(L)!=="svelte-q3avhg"&&(L.innerHTML=ut),pe=r(dt),te=d(dt,"P",{"data-svelte-h":!0}),h(te)!=="svelte-1c8p9n2"&&(te.innerHTML=Yt),Qo=r(dt),Ht=d(dt,"P",{"data-svelte-h":!0}),h(Ht)!=="svelte-68lg8f"&&(Ht.innerHTML=La),Bo=r(dt),Ge=d(dt,"DIV",{class:!0});var Jt=C(Ge);f(At.$$.fragment,Jt),ft=r(Jt),Ut=d(Jt,"P",{"data-svelte-h":!0}),h(Ut)!=="svelte-13qqpjf"&&(Ut.innerHTML=wa),bo=r(Jt),f(oo.$$.fragment,Jt),So=r(Jt),f(xt.$$.fragment,Jt),Jt.forEach(i),dt.forEach(i),Ao=r(m),f(ao.$$.fragment,m),Lt=r(m),me=d(m,"DIV",{class:!0});var _e=C(me);f(no.$$.fragment,_e),yo=r(_e),Jo=d(_e,"P",{"data-svelte-h":!0}),h(Jo)!=="svelte-nregqm"&&(Jo.textContent=Do),so=r(_e),ro=d(_e,"P",{"data-svelte-h":!0}),h(ro)!=="svelte-q3avhg"&&(ro.innerHTML=se),lo=r(_e),wo=d(_e,"P",{"data-svelte-h":!0}),h(wo)!=="svelte-1c8p9n2"&&(wo.innerHTML=Co),Ma=r(_e),Mo=d(_e,"P",{"data-svelte-h":!0}),h(Mo)!=="svelte-68lg8f"&&(Mo.innerHTML=$o),Ta=r(_e),wt=d(_e,"DIV",{class:!0});var De=C(wt);f(Mt.$$.fragment,De),io=r(De),To=d(De,"P",{"data-svelte-h":!0}),h(To)!=="svelte-15h6ynb"&&(To.innerHTML=Fo),ja=r(De),f(Dt.$$.fragment,De),Ot=r(De),f(Tt.$$.fragment,De),De.forEach(i),_e.forEach(i),Xo=r(m),f(Zt.$$.fragment,m),Oo=r(m),Pe=d(m,"DIV",{class:!0});var _t=C(Pe);f(zt.$$.fragment,_t),co=r(_t),jo=d(_t,"P",{"data-svelte-h":!0}),h(jo)!=="svelte-wn7jg8"&&(jo.innerHTML=Et),po=r(_t),ko=d(_t,"P",{"data-svelte-h":!0}),h(ko)!=="svelte-1c8p9n2"&&(ko.innerHTML=Uo),ka=r(_t),Wo=d(_t,"P",{"data-svelte-h":!0}),h(Wo)!=="svelte-68lg8f"&&(Wo.innerHTML=mo),Ko=r(_t),Ue=d(_t,"DIV",{class:!0});var pt=C(Ue);f(Vt.$$.fragment,pt),ea=r(pt),Pt=d(pt,"P",{"data-svelte-h":!0}),h(Pt)!=="svelte-19gumb7"&&(Pt.innerHTML=Ea),ta=r(pt),f(gt.$$.fragment,pt),ho=r(pt),f(Kt.$$.fragment,pt),pt.forEach(i),_t.forEach(i),this.h()},h(){$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(m,J){g(e,m,J),p(m,y,J),p(m,n,J),g(l,n,null),a(n,w),a(n,o),a(n,Me),a(n,B),a(n,Te),a(n,X),a(n,je),a(n,W),g(R,W,null),a(W,re),a(W,Q),a(W,Ne),g(Y,W,null),a(W,Ze),g(S,W,null),p(m,Ke,J),g(he,m,J),p(m,Je,J),p(m,I,J),g(ue,I,null),a(I,le),a(I,fe),a(I,ze),a(I,z),a(I,Ie),a(I,oe),a(I,ve),a(I,ae),g(We,ae,null),a(ae,tt),a(ae,Be),a(ae,ot),g(xe,ae,null),a(ae,at),g(be,ae,null),a(I,qe),a(I,G),g(ye,G,null),a(G,N),a(G,A),a(G,Ce),g($e,G,null),a(G,$t),g(E,G,null),p(m,Fe,J),g(P,m,J),p(m,Ve,J),p(m,T,J),g(V,T,null),a(T,Z),a(T,ne),a(T,D),a(T,ie),a(T,Bt),a(T,Xt),a(T,nt),a(T,Gt),a(T,Nt),a(T,He),g(st,He,null),a(He,rt),a(He,qt),a(He,ge),g(Xe,He,null),a(He,Ft),g(lt,He,null),p(m,to,J),g(it,m,J),p(m,yt,J),p(m,ce,J),g(de,ce,null),a(ce,St),a(ce,k),a(ce,Ee),a(ce,L),a(ce,pe),a(ce,te),a(ce,Qo),a(ce,Ht),a(ce,Bo),a(ce,Ge),g(At,Ge,null),a(Ge,ft),a(Ge,Ut),a(Ge,bo),g(oo,Ge,null),a(Ge,So),g(xt,Ge,null),p(m,Ao,J),g(ao,m,J),p(m,Lt,J),p(m,me,J),g(no,me,null),a(me,yo),a(me,Jo),a(me,so),a(me,ro),a(me,lo),a(me,wo),a(me,Ma),a(me,Mo),a(me,Ta),a(me,wt),g(Mt,wt,null),a(wt,io),a(wt,To),a(wt,ja),g(Dt,wt,null),a(wt,Ot),g(Tt,wt,null),p(m,Xo,J),g(Zt,m,J),p(m,Oo,J),p(m,Pe,J),g(zt,Pe,null),a(Pe,co),a(Pe,jo),a(Pe,po),a(Pe,ko),a(Pe,ka),a(Pe,Wo),a(Pe,Ko),a(Pe,Ue),g(Vt,Ue,null),a(Ue,ea),a(Ue,Pt),a(Ue,ta),g(gt,Ue,null),a(Ue,ho),g(Kt,Ue,null),uo=!0},p(m,J){const Qe={};J&2&&(Qe.$$scope={dirty:J,ctx:m}),Y.$set(Qe);const Re={};J&2&&(Re.$$scope={dirty:J,ctx:m}),S.$set(Re);const q={};J&2&&(q.$$scope={dirty:J,ctx:m}),xe.$set(q);const Se={};J&2&&(Se.$$scope={dirty:J,ctx:m}),be.$set(Se);const Ae={};J&2&&(Ae.$$scope={dirty:J,ctx:m}),$e.$set(Ae);const ct={};J&2&&(ct.$$scope={dirty:J,ctx:m}),E.$set(ct);const dt={};J&2&&(dt.$$scope={dirty:J,ctx:m}),Xe.$set(dt);const Jt={};J&2&&(Jt.$$scope={dirty:J,ctx:m}),lt.$set(Jt);const _e={};J&2&&(_e.$$scope={dirty:J,ctx:m}),oo.$set(_e);const De={};J&2&&(De.$$scope={dirty:J,ctx:m}),xt.$set(De);const _t={};J&2&&(_t.$$scope={dirty:J,ctx:m}),Dt.$set(_t);const pt={};J&2&&(pt.$$scope={dirty:J,ctx:m}),Tt.$set(pt);const Pa={};J&2&&(Pa.$$scope={dirty:J,ctx:m}),gt.$set(Pa);const Wa={};J&2&&(Wa.$$scope={dirty:J,ctx:m}),Kt.$set(Wa)},i(m){uo||(_(e.$$.fragment,m),_(l.$$.fragment,m),_(R.$$.fragment,m),_(Y.$$.fragment,m),_(S.$$.fragment,m),_(he.$$.fragment,m),_(ue.$$.fragment,m),_(We.$$.fragment,m),_(xe.$$.fragment,m),_(be.$$.fragment,m),_(ye.$$.fragment,m),_($e.$$.fragment,m),_(E.$$.fragment,m),_(P.$$.fragment,m),_(V.$$.fragment,m),_(st.$$.fragment,m),_(Xe.$$.fragment,m),_(lt.$$.fragment,m),_(it.$$.fragment,m),_(de.$$.fragment,m),_(At.$$.fragment,m),_(oo.$$.fragment,m),_(xt.$$.fragment,m),_(ao.$$.fragment,m),_(no.$$.fragment,m),_(Mt.$$.fragment,m),_(Dt.$$.fragment,m),_(Tt.$$.fragment,m),_(Zt.$$.fragment,m),_(zt.$$.fragment,m),_(Vt.$$.fragment,m),_(gt.$$.fragment,m),_(Kt.$$.fragment,m),uo=!0)},o(m){v(e.$$.fragment,m),v(l.$$.fragment,m),v(R.$$.fragment,m),v(Y.$$.fragment,m),v(S.$$.fragment,m),v(he.$$.fragment,m),v(ue.$$.fragment,m),v(We.$$.fragment,m),v(xe.$$.fragment,m),v(be.$$.fragment,m),v(ye.$$.fragment,m),v($e.$$.fragment,m),v(E.$$.fragment,m),v(P.$$.fragment,m),v(V.$$.fragment,m),v(st.$$.fragment,m),v(Xe.$$.fragment,m),v(lt.$$.fragment,m),v(it.$$.fragment,m),v(de.$$.fragment,m),v(At.$$.fragment,m),v(oo.$$.fragment,m),v(xt.$$.fragment,m),v(ao.$$.fragment,m),v(no.$$.fragment,m),v(Mt.$$.fragment,m),v(Dt.$$.fragment,m),v(Tt.$$.fragment,m),v(Zt.$$.fragment,m),v(zt.$$.fragment,m),v(Vt.$$.fragment,m),v(gt.$$.fragment,m),v(Kt.$$.fragment,m),uo=!1},d(m){m&&(i(y),i(n),i(Ke),i(Je),i(I),i(Fe),i(Ve),i(T),i(to),i(yt),i(ce),i(Ao),i(Lt),i(me),i(Xo),i(Oo),i(Pe)),b(e,m),b(l),b(R),b(Y),b(S),b(he,m),b(ue),b(We),b(xe),b(be),b(ye),b($e),b(E),b(P,m),b(V),b(st),b(Xe),b(lt),b(it,m),b(de),b(At),b(oo),b(xt),b(ao,m),b(no),b(Mt),b(Dt),b(Tt),b(Zt,m),b(zt),b(Vt),b(gt),b(Kt)}}}function Fs(x){let e,y;return e=new qn({props:{$$slots:{default:[$s]},$$scope:{ctx:x}}}),{c(){u(e.$$.fragment)},l(n){f(e.$$.fragment,n)},m(n,l){g(e,n,l),y=!0},p(n,l){const w={};l&2&&(w.$$scope={dirty:l,ctx:n}),e.$set(w)},i(n){y||(_(e.$$.fragment,n),y=!0)},o(n){v(e.$$.fragment,n),y=!1},d(n){b(e,n)}}}function Us(x){let e,y="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,l,w="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,M,Me=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,B,K,Te=`<li>a single Tensor with <code>input_values</code> only and nothing else: <code>model(input_values)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_values, attention_mask])</code> or <code>model([input_values, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_values&quot;: input_values, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,X,ee,je=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=c("p"),e.innerHTML=y,n=s(),l=c("ul"),l.innerHTML=w,o=s(),M=c("p"),M.innerHTML=Me,B=s(),K=c("ul"),K.innerHTML=Te,X=s(),ee=c("p"),ee.innerHTML=je},l(W){e=d(W,"P",{"data-svelte-h":!0}),h(e)!=="svelte-1ajbfxg"&&(e.innerHTML=y),n=r(W),l=d(W,"UL",{"data-svelte-h":!0}),h(l)!=="svelte-qm1t26"&&(l.innerHTML=w),o=r(W),M=d(W,"P",{"data-svelte-h":!0}),h(M)!=="svelte-1v9qsc5"&&(M.innerHTML=Me),B=r(W),K=d(W,"UL",{"data-svelte-h":!0}),h(K)!=="svelte-1x9eg56"&&(K.innerHTML=Te),X=r(W),ee=d(W,"P",{"data-svelte-h":!0}),h(ee)!=="svelte-1an3odd"&&(ee.innerHTML=je)},m(W,R){p(W,e,R),p(W,n,R),p(W,l,R),p(W,o,R),p(W,M,R),p(W,B,R),p(W,K,R),p(W,X,R),p(W,ee,R)},p:H,d(W){W&&(i(e),i(n),i(l),i(o),i(M),i(B),i(K),i(X),i(ee))}}}function Zs(x){let e,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=y},l(n){e=d(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=y)},m(n,l){p(n,e,l)},p:H,d(n){n&&i(e)}}}function zs(x){let e,y="Example:",n,l,w;return l=new kt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBURldhdjJWZWMyTW9kZWwlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjBzb3VuZGZpbGUlMjBhcyUyMHNmJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1iYXNlLTk2MGglMjIpJTBBbW9kZWwlMjAlM0QlMjBURldhdjJWZWMyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS05NjBoJTIyKSUwQSUwQSUwQWRlZiUyMG1hcF90b19hcnJheShiYXRjaCklM0ElMEElMjAlMjAlMjAlMjBzcGVlY2glMkMlMjBfJTIwJTNEJTIwc2YucmVhZChiYXRjaCU1QiUyMmZpbGUlMjIlNUQpJTBBJTIwJTIwJTIwJTIwYmF0Y2glNUIlMjJzcGVlY2glMjIlNUQlMjAlM0QlMjBzcGVlY2glMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaCUwQSUwQSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkcyUyMCUzRCUyMGRzLm1hcChtYXBfdG9fYXJyYXkpJTBBJTBBaW5wdXRfdmFsdWVzJTIwJTNEJTIwcHJvY2Vzc29yKGRzJTVCJTIyc3BlZWNoJTIyJTVEJTVCMCU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpLmlucHV0X3ZhbHVlcyUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFoaWRkZW5fc3RhdGVzJTIwJTNEJTIwbW9kZWwoaW5wdXRfdmFsdWVzKS5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, TFWav2Vec2Model
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFWav2Vec2Model.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    speech, _ = sf.read(batch[<span class="hljs-string">&quot;file&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = speech
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.<span class="hljs-built_in">map</span>(map_to_array)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = processor(ds[<span class="hljs-string">&quot;speech&quot;</span>][<span class="hljs-number">0</span>], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).input_values  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_states = model(input_values).last_hidden_state`,wrap:!1}}),{c(){e=c("p"),e.textContent=y,n=s(),u(l.$$.fragment)},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=y),n=r(o),f(l.$$.fragment,o)},m(o,M){p(o,e,M),p(o,n,M),g(l,o,M),w=!0},p:H,i(o){w||(_(l.$$.fragment,o),w=!0)},o(o){v(l.$$.fragment,o),w=!1},d(o){o&&(i(e),i(n)),b(l,o)}}}function Is(x){let e,y="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,l,w="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,M,Me=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,B,K,Te=`<li>a single Tensor with <code>input_values</code> only and nothing else: <code>model(input_values)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_values, attention_mask])</code> or <code>model([input_values, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_values&quot;: input_values, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,X,ee,je=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=c("p"),e.innerHTML=y,n=s(),l=c("ul"),l.innerHTML=w,o=s(),M=c("p"),M.innerHTML=Me,B=s(),K=c("ul"),K.innerHTML=Te,X=s(),ee=c("p"),ee.innerHTML=je},l(W){e=d(W,"P",{"data-svelte-h":!0}),h(e)!=="svelte-1ajbfxg"&&(e.innerHTML=y),n=r(W),l=d(W,"UL",{"data-svelte-h":!0}),h(l)!=="svelte-qm1t26"&&(l.innerHTML=w),o=r(W),M=d(W,"P",{"data-svelte-h":!0}),h(M)!=="svelte-1v9qsc5"&&(M.innerHTML=Me),B=r(W),K=d(W,"UL",{"data-svelte-h":!0}),h(K)!=="svelte-1x9eg56"&&(K.innerHTML=Te),X=r(W),ee=d(W,"P",{"data-svelte-h":!0}),h(ee)!=="svelte-1an3odd"&&(ee.innerHTML=je)},m(W,R){p(W,e,R),p(W,n,R),p(W,l,R),p(W,o,R),p(W,M,R),p(W,B,R),p(W,K,R),p(W,X,R),p(W,ee,R)},p:H,d(W){W&&(i(e),i(n),i(l),i(o),i(M),i(B),i(K),i(X),i(ee))}}}function Bs(x){let e,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=y},l(n){e=d(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=y)},m(n,l){p(n,e,l)},p:H,d(n){n&&i(e)}}}function Xs(x){let e,y="Example:",n,l,w;return l=new kt({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFRGV2F2MlZlYzJGb3JDVEMlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjBzb3VuZGZpbGUlMjBhcyUyMHNmJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1iYXNlLTk2MGglMjIpJTBBbW9kZWwlMjAlM0QlMjBURldhdjJWZWMyRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UtOTYwaCUyMiklMEElMEElMEFkZWYlMjBtYXBfdG9fYXJyYXkoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwc3BlZWNoJTJDJTIwXyUyMCUzRCUyMHNmLnJlYWQoYmF0Y2glNUIlMjJmaWxlJTIyJTVEKSUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIyc3BlZWNoJTIyJTVEJTIwJTNEJTIwc3BlZWNoJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2glMEElMEElMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZHMlMjAlM0QlMjBkcy5tYXAobWFwX3RvX2FycmF5KSUwQSUwQWlucHV0X3ZhbHVlcyUyMCUzRCUyMHByb2Nlc3NvcihkcyU1QiUyMnNwZWVjaCUyMiU1RCU1QjAlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKS5pbnB1dF92YWx1ZXMlMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfdmFsdWVzKS5sb2dpdHMlMEFwcmVkaWN0ZWRfaWRzJTIwJTNEJTIwdGYuYXJnbWF4KGxvZ2l0cyUyQyUyMGF4aXMlM0QtMSklMEElMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmRlY29kZShwcmVkaWN0ZWRfaWRzJTVCMCU1RCklMEElMEElMjMlMjBjb21wdXRlJTIwbG9zcyUwQXRhcmdldF90cmFuc2NyaXB0aW9uJTIwJTNEJTIwJTIyQSUyME1BTiUyMFNBSUQlMjBUTyUyMFRIRSUyMFVOSVZFUlNFJTIwU0lSJTIwSSUyMEVYSVNUJTIyJTBBJTBBJTIzJTIwUGFzcyUyMHRyYW5zY3JpcHRpb24lMjBhcyUyMCU2MHRleHQlNjAlMjB0byUyMGVuY29kZSUyMGxhYmVscyUwQWxhYmVscyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdHJhbnNjcmlwdGlvbiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpLmlucHV0X2lkcyUwQSUwQWxvc3MlMjAlM0QlMjBtb2RlbChpbnB1dF92YWx1ZXMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, TFWav2Vec2ForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFWav2Vec2ForCTC.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    speech, _ = sf.read(batch[<span class="hljs-string">&quot;file&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = speech
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.<span class="hljs-built_in">map</span>(map_to_array)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = processor(ds[<span class="hljs-string">&quot;speech&quot;</span>][<span class="hljs-number">0</span>], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).input_values  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(input_values).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = tf.argmax(logits, axis=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.decode(predicted_ids[<span class="hljs-number">0</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_transcription = <span class="hljs-string">&quot;A MAN SAID TO THE UNIVERSE SIR I EXIST&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pass transcription as \`text\` to encode labels</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = processor(text=transcription, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(input_values, labels=labels).loss`,wrap:!1}}),{c(){e=c("p"),e.textContent=y,n=s(),u(l.$$.fragment)},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=y),n=r(o),f(l.$$.fragment,o)},m(o,M){p(o,e,M),p(o,n,M),g(l,o,M),w=!0},p:H,i(o){w||(_(l.$$.fragment,o),w=!0)},o(o){v(l.$$.fragment,o),w=!1},d(o){o&&(i(e),i(n)),b(l,o)}}}function Gs(x){let e,y,n,l,w,o,M="The bare TFWav2Vec2 Model transformer outputing raw hidden-states without any specific head on top.",Me,B,K=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Te,X,ee=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,je,W,R,re,Q,Qt,Ne,Y='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.TFWav2Vec2Model">TFWav2Vec2Model</a> forward method, overrides the <code>__call__</code> special method.',Ze,S,Ke,he,Je,I,ue,le,fe,ke,ze,z,et,Ie,oe,O,ve,ae,We,tt="TFWav2Vec2 Model with a <code>language modeling</code> head on top for Connectionist Temporal Classification (CTC).",Be,ht,ot=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,xe,at,be=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,qe,G,ye,N,A,It,Ce,$e='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.TFWav2Vec2ForCTC">TFWav2Vec2ForCTC</a> forward method, overrides the <code>__call__</code> special method.',$t,E,Fe,P,Ve;return e=new we({props:{title:"TFWav2Vec2Model",local:"transformers.TFWav2Vec2Model",headingTag:"h2"}}),l=new F({props:{name:"class transformers.TFWav2Vec2Model",anchor:"transformers.TFWav2Vec2Model",parameters:[{name:"config",val:": Wav2Vec2Config"},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFWav2Vec2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_tf_wav2vec2.py#L1506"}}),W=new vt({props:{$$slots:{default:[Us]},$$scope:{ctx:x}}}),Q=new F({props:{name:"call",anchor:"transformers.TFWav2Vec2Model.call",parameters:[{name:"input_values",val:": tf.Tensor"},{name:"attention_mask",val:": tf.Tensor | None = None"},{name:"token_type_ids",val:": tf.Tensor | None = None"},{name:"position_ids",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"inputs_embeds",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFWav2Vec2Model.call.input_values",description:`<strong>input_values</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> <code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>({0})</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_values"},{anchor:"transformers.TFWav2Vec2Model.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFWav2Vec2Model.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFWav2Vec2Model.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFWav2Vec2Model.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFWav2Vec2Model.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0}, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_values</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_values</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFWav2Vec2Model.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFWav2Vec2Model.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFWav2Vec2Model.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFWav2Vec2Model.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_tf_wav2vec2.py#L1516",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutput"
>transformers.modeling_tf_outputs.TFBaseModelOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config"
>Wav2Vec2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutput"
>transformers.modeling_tf_outputs.TFBaseModelOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),S=new vt({props:{$$slots:{default:[Zs]},$$scope:{ctx:x}}}),he=new Ct({props:{anchor:"transformers.TFWav2Vec2Model.call.example",$$slots:{default:[zs]},$$scope:{ctx:x}}}),I=new we({props:{title:"TFWav2Vec2ForSequenceClassification",local:"transformers.TFWav2Vec2ForSequenceClassification",headingTag:"h2"}}),fe=new F({props:{name:"class transformers.TFWav2Vec2ForSequenceClassification",anchor:"transformers.TFWav2Vec2ForSequenceClassification",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_tf_wav2vec2.py#L1755"}}),z=new F({props:{name:"call",anchor:"transformers.TFWav2Vec2ForSequenceClassification.call",parameters:[{name:"input_values",val:": tf.Tensor"},{name:"attention_mask",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": bool | None = None"},{name:"output_hidden_states",val:": bool | None = None"},{name:"return_dict",val:": bool | None = None"},{name:"labels",val:": tf.Tensor | None = None"},{name:"training",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_tf_wav2vec2.py#L1796"}}),Ie=new we({props:{title:"TFWav2Vec2ForCTC",local:"transformers.TFWav2Vec2ForCTC",headingTag:"h2"}}),ve=new F({props:{name:"class transformers.TFWav2Vec2ForCTC",anchor:"transformers.TFWav2Vec2ForCTC",parameters:[{name:"config",val:": Wav2Vec2Config"},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFWav2Vec2ForCTC.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_tf_wav2vec2.py#L1588"}}),G=new vt({props:{$$slots:{default:[Is]},$$scope:{ctx:x}}}),A=new F({props:{name:"call",anchor:"transformers.TFWav2Vec2ForCTC.call",parameters:[{name:"input_values",val:": tf.Tensor"},{name:"attention_mask",val:": tf.Tensor | None = None"},{name:"token_type_ids",val:": tf.Tensor | None = None"},{name:"position_ids",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"inputs_embeds",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"labels",val:": tf.Tensor | None = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFWav2Vec2ForCTC.call.input_values",description:`<strong>input_values</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> <code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>({0})</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_values"},{anchor:"transformers.TFWav2Vec2ForCTC.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFWav2Vec2ForCTC.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFWav2Vec2ForCTC.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFWav2Vec2ForCTC.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFWav2Vec2ForCTC.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0}, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_values</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_values</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFWav2Vec2ForCTC.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFWav2Vec2ForCTC.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFWav2Vec2ForCTC.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFWav2Vec2ForCTC.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFWav2Vec2ForCTC.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> or <code>np.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_values</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked),
the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_tf_wav2vec2.py#L1622",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutput"
>transformers.modeling_tf_outputs.TFCausalLMOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config"
>Wav2Vec2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutput"
>transformers.modeling_tf_outputs.TFCausalLMOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),E=new vt({props:{$$slots:{default:[Bs]},$$scope:{ctx:x}}}),P=new Ct({props:{anchor:"transformers.TFWav2Vec2ForCTC.call.example",$$slots:{default:[Xs]},$$scope:{ctx:x}}}),{c(){u(e.$$.fragment),y=s(),n=c("div"),u(l.$$.fragment),w=s(),o=c("p"),o.textContent=M,Me=s(),B=c("p"),B.innerHTML=K,Te=s(),X=c("p"),X.innerHTML=ee,je=s(),u(W.$$.fragment),R=s(),re=c("div"),u(Q.$$.fragment),Qt=s(),Ne=c("p"),Ne.innerHTML=Y,Ze=s(),u(S.$$.fragment),Ke=s(),u(he.$$.fragment),Je=s(),u(I.$$.fragment),ue=s(),le=c("div"),u(fe.$$.fragment),ke=s(),ze=c("div"),u(z.$$.fragment),et=s(),u(Ie.$$.fragment),oe=s(),O=c("div"),u(ve.$$.fragment),ae=s(),We=c("p"),We.innerHTML=tt,Be=s(),ht=c("p"),ht.innerHTML=ot,xe=s(),at=c("p"),at.innerHTML=be,qe=s(),u(G.$$.fragment),ye=s(),N=c("div"),u(A.$$.fragment),It=s(),Ce=c("p"),Ce.innerHTML=$e,$t=s(),u(E.$$.fragment),Fe=s(),u(P.$$.fragment),this.h()},l(T){f(e.$$.fragment,T),y=r(T),n=d(T,"DIV",{class:!0});var V=C(n);f(l.$$.fragment,V),w=r(V),o=d(V,"P",{"data-svelte-h":!0}),h(o)!=="svelte-7z1r57"&&(o.textContent=M),Me=r(V),B=d(V,"P",{"data-svelte-h":!0}),h(B)!=="svelte-1qaxm70"&&(B.innerHTML=K),Te=r(V),X=d(V,"P",{"data-svelte-h":!0}),h(X)!=="svelte-1be7e3c"&&(X.innerHTML=ee),je=r(V),f(W.$$.fragment,V),R=r(V),re=d(V,"DIV",{class:!0});var Z=C(re);f(Q.$$.fragment,Z),Qt=r(Z),Ne=d(Z,"P",{"data-svelte-h":!0}),h(Ne)!=="svelte-1jsjtaf"&&(Ne.innerHTML=Y),Ze=r(Z),f(S.$$.fragment,Z),Ke=r(Z),f(he.$$.fragment,Z),Z.forEach(i),V.forEach(i),Je=r(T),f(I.$$.fragment,T),ue=r(T),le=d(T,"DIV",{class:!0});var ne=C(le);f(fe.$$.fragment,ne),ke=r(ne),ze=d(ne,"DIV",{class:!0});var Ye=C(ze);f(z.$$.fragment,Ye),Ye.forEach(i),ne.forEach(i),et=r(T),f(Ie.$$.fragment,T),oe=r(T),O=d(T,"DIV",{class:!0});var D=C(O);f(ve.$$.fragment,D),ae=r(D),We=d(D,"P",{"data-svelte-h":!0}),h(We)!=="svelte-uqrpa"&&(We.innerHTML=tt),Be=r(D),ht=d(D,"P",{"data-svelte-h":!0}),h(ht)!=="svelte-1qaxm70"&&(ht.innerHTML=ot),xe=r(D),at=d(D,"P",{"data-svelte-h":!0}),h(at)!=="svelte-1be7e3c"&&(at.innerHTML=be),qe=r(D),f(G.$$.fragment,D),ye=r(D),N=d(D,"DIV",{class:!0});var ie=C(N);f(A.$$.fragment,ie),It=r(ie),Ce=d(ie,"P",{"data-svelte-h":!0}),h(Ce)!=="svelte-1kxw0at"&&(Ce.innerHTML=$e),$t=r(ie),f(E.$$.fragment,ie),Fe=r(ie),f(P.$$.fragment,ie),ie.forEach(i),D.forEach(i),this.h()},h(){$(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(T,V){g(e,T,V),p(T,y,V),p(T,n,V),g(l,n,null),a(n,w),a(n,o),a(n,Me),a(n,B),a(n,Te),a(n,X),a(n,je),g(W,n,null),a(n,R),a(n,re),g(Q,re,null),a(re,Qt),a(re,Ne),a(re,Ze),g(S,re,null),a(re,Ke),g(he,re,null),p(T,Je,V),g(I,T,V),p(T,ue,V),p(T,le,V),g(fe,le,null),a(le,ke),a(le,ze),g(z,ze,null),p(T,et,V),g(Ie,T,V),p(T,oe,V),p(T,O,V),g(ve,O,null),a(O,ae),a(O,We),a(O,Be),a(O,ht),a(O,xe),a(O,at),a(O,qe),g(G,O,null),a(O,ye),a(O,N),g(A,N,null),a(N,It),a(N,Ce),a(N,$t),g(E,N,null),a(N,Fe),g(P,N,null),Ve=!0},p(T,V){const Z={};V&2&&(Z.$$scope={dirty:V,ctx:T}),W.$set(Z);const ne={};V&2&&(ne.$$scope={dirty:V,ctx:T}),S.$set(ne);const Ye={};V&2&&(Ye.$$scope={dirty:V,ctx:T}),he.$set(Ye);const D={};V&2&&(D.$$scope={dirty:V,ctx:T}),G.$set(D);const ie={};V&2&&(ie.$$scope={dirty:V,ctx:T}),E.$set(ie);const bt={};V&2&&(bt.$$scope={dirty:V,ctx:T}),P.$set(bt)},i(T){Ve||(_(e.$$.fragment,T),_(l.$$.fragment,T),_(W.$$.fragment,T),_(Q.$$.fragment,T),_(S.$$.fragment,T),_(he.$$.fragment,T),_(I.$$.fragment,T),_(fe.$$.fragment,T),_(z.$$.fragment,T),_(Ie.$$.fragment,T),_(ve.$$.fragment,T),_(G.$$.fragment,T),_(A.$$.fragment,T),_(E.$$.fragment,T),_(P.$$.fragment,T),Ve=!0)},o(T){v(e.$$.fragment,T),v(l.$$.fragment,T),v(W.$$.fragment,T),v(Q.$$.fragment,T),v(S.$$.fragment,T),v(he.$$.fragment,T),v(I.$$.fragment,T),v(fe.$$.fragment,T),v(z.$$.fragment,T),v(Ie.$$.fragment,T),v(ve.$$.fragment,T),v(G.$$.fragment,T),v(A.$$.fragment,T),v(E.$$.fragment,T),v(P.$$.fragment,T),Ve=!1},d(T){T&&(i(y),i(n),i(Je),i(ue),i(le),i(et),i(oe),i(O)),b(e,T),b(l),b(W),b(Q),b(S),b(he),b(I,T),b(fe),b(z),b(Ie,T),b(ve),b(G),b(A),b(E),b(P)}}}function Rs(x){let e,y;return e=new qn({props:{$$slots:{default:[Gs]},$$scope:{ctx:x}}}),{c(){u(e.$$.fragment)},l(n){f(e.$$.fragment,n)},m(n,l){g(e,n,l),y=!0},p(n,l){const w={};l&2&&(w.$$scope={dirty:l,ctx:n}),e.$set(w)},i(n){y||(_(e.$$.fragment,n),y=!0)},o(n){v(e.$$.fragment,n),y=!1},d(n){b(e,n)}}}function Ns(x){let e,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=y},l(n){e=d(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=y)},m(n,l){p(n,e,l)},p:H,d(n){n&&i(e)}}}function qs(x){let e,y="Example:",n,l,w;return l=new kt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBGbGF4V2F2MlZlYzJNb2RlbCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHNvdW5kZmlsZSUyMGFzJTIwc2YlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLWx2NjAlMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4V2F2MlZlYzJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1sYXJnZS1sdjYwJTIyKSUwQSUwQSUwQWRlZiUyMG1hcF90b19hcnJheShiYXRjaCklM0ElMEElMjAlMjAlMjAlMjBzcGVlY2glMkMlMjBfJTIwJTNEJTIwc2YucmVhZChiYXRjaCU1QiUyMmZpbGUlMjIlNUQpJTBBJTIwJTIwJTIwJTIwYmF0Y2glNUIlMjJzcGVlY2glMjIlNUQlMjAlM0QlMjBzcGVlY2glMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaCUwQSUwQSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkcyUyMCUzRCUyMGRzLm1hcChtYXBfdG9fYXJyYXkpJTBBJTBBaW5wdXRfdmFsdWVzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMGRzJTVCJTIyc3BlZWNoJTIyJTVEJTVCMCU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0QxNl8wMDAlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyJTBBKS5pbnB1dF92YWx1ZXMlMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG1vZGVsKGlucHV0X3ZhbHVlcykubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, FlaxWav2Vec2Model
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-large-lv60&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxWav2Vec2Model.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-large-lv60&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    speech, _ = sf.read(batch[<span class="hljs-string">&quot;file&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = speech
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.<span class="hljs-built_in">map</span>(map_to_array)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = processor(
<span class="hljs-meta">... </span>    ds[<span class="hljs-string">&quot;speech&quot;</span>][<span class="hljs-number">0</span>], sampling_rate=<span class="hljs-number">16_000</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>
<span class="hljs-meta">... </span>).input_values  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_states = model(input_values).last_hidden_state`,wrap:!1}}),{c(){e=c("p"),e.textContent=y,n=s(),u(l.$$.fragment)},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=y),n=r(o),f(l.$$.fragment,o)},m(o,M){p(o,e,M),p(o,n,M),g(l,o,M),w=!0},p:H,i(o){w||(_(l.$$.fragment,o),w=!0)},o(o){v(l.$$.fragment,o),w=!1},d(o){o&&(i(e),i(n)),b(l,o)}}}function Ys(x){let e,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=y},l(n){e=d(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=y)},m(n,l){p(n,e,l)},p:H,d(n){n&&i(e)}}}function Hs(x){let e,y="Example:",n,l,w;return l=new kt({props:{code:"aW1wb3J0JTIwamF4Lm51bXB5JTIwYXMlMjBqbnAlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEZsYXhXYXYyVmVjMkZvckNUQyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHNvdW5kZmlsZSUyMGFzJTIwc2YlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhXYXYyVmVjMkZvckNUQy5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1sYXJnZS05NjBoLWx2NjAlMjIpJTBBJTBBJTBBZGVmJTIwbWFwX3RvX2FycmF5KGJhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMHNwZWVjaCUyQyUyMF8lMjAlM0QlMjBzZi5yZWFkKGJhdGNoJTVCJTIyZmlsZSUyMiU1RCklMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnNwZWVjaCUyMiU1RCUyMCUzRCUyMHNwZWVjaCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJhdGNoJTBBJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRzJTIwJTNEJTIwZHMubWFwKG1hcF90b19hcnJheSklMEElMEFpbnB1dF92YWx1ZXMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwZHMlNUIlMjJzcGVlY2glMjIlNUQlNUIwJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIlMEEpLmlucHV0X3ZhbHVlcyUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFsb2dpdHMlMjAlM0QlMjBtb2RlbChpbnB1dF92YWx1ZXMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjBqbnAuYXJnbWF4KGxvZ2l0cyUyQyUyMGF4aXMlM0QtMSklMEElMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmRlY29kZShwcmVkaWN0ZWRfaWRzJTVCMCU1RCklMEElMjMlMjBzaG91bGQlMjBnaXZlJTNBJTIwJTIwJTIyQSUyME1BTiUyMFNBSUQlMjBUTyUyMFRIRSUyMFVOSVZFUlNFJTIwU0lSJTIwSSUyMEVYSVNUJTIy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax.numpy <span class="hljs-keyword">as</span> jnp
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, FlaxWav2Vec2ForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-large-960h-lv60&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxWav2Vec2ForCTC.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-large-960h-lv60&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    speech, _ = sf.read(batch[<span class="hljs-string">&quot;file&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = speech
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.<span class="hljs-built_in">map</span>(map_to_array)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = processor(
<span class="hljs-meta">... </span>    ds[<span class="hljs-string">&quot;speech&quot;</span>][<span class="hljs-number">0</span>], sampling_rate=<span class="hljs-number">16_000</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>
<span class="hljs-meta">... </span>).input_values  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(input_values).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = jnp.argmax(logits, axis=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.decode(predicted_ids[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># should give:  &quot;A MAN SAID TO THE UNIVERSE SIR I EXIST&quot;</span>`,wrap:!1}}),{c(){e=c("p"),e.textContent=y,n=s(),u(l.$$.fragment)},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=y),n=r(o),f(l.$$.fragment,o)},m(o,M){p(o,e,M),p(o,n,M),g(l,o,M),w=!0},p:H,i(o){w||(_(l.$$.fragment,o),w=!0)},o(o){v(l.$$.fragment,o),w=!1},d(o){o&&(i(e),i(n)),b(l,o)}}}function Ls(x){let e,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=y},l(n){e=d(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=y)},m(n,l){p(n,e,l)},p:H,d(n){n&&i(e)}}}function Es(x){let e,y="Example:",n,l,w;return l=new kt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> optax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax.numpy <span class="hljs-keyword">as</span> jnp
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, FlaxWav2Vec2ForPreTraining
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.models.wav2vec2.modeling_flax_wav2vec2 <span class="hljs-keyword">import</span> _compute_mask_indices
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-large-lv60&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxWav2Vec2ForPreTraining.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-large-lv60&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    speech, _ = sf.read(batch[<span class="hljs-string">&quot;file&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = speech
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.<span class="hljs-built_in">map</span>(map_to_array)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = feature_extractor(ds[<span class="hljs-string">&quot;speech&quot;</span>][<span class="hljs-number">0</span>], return_tensors=<span class="hljs-string">&quot;np&quot;</span>).input_values  <span class="hljs-comment"># Batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute masked indices</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size, raw_sequence_length = input_values.shape
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_length = model._get_feat_extract_output_lengths(raw_sequence_length)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_time_indices = _compute_mask_indices((batch_size, sequence_length), mask_prob=<span class="hljs-number">0.2</span>, mask_length=<span class="hljs-number">2</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_values, mask_time_indices=mask_time_indices)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute cosine similarity between predicted (=projected_states) and target (=projected_quantized_states)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = optax.cosine_similarity(outputs.projected_states, outputs.projected_quantized_states)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># show that cosine similarity is much higher than random</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> np.asarray(cosine_sim)[mask_time_indices].mean() &gt; <span class="hljs-number">0.5</span>`,wrap:!1}}),{c(){e=c("p"),e.textContent=y,n=s(),u(l.$$.fragment)},l(o){e=d(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=y),n=r(o),f(l.$$.fragment,o)},m(o,M){p(o,e,M),p(o,n,M),g(l,o,M),w=!0},p:H,i(o){w||(_(l.$$.fragment,o),w=!0)},o(o){v(l.$$.fragment,o),w=!1},d(o){o&&(i(e),i(n)),b(l,o)}}}function Ps(x){let e,y,n,l,w,o,M=`The bare Wav2Vec2 Model transformer outputting raw hidden-states without any specific head on top.
Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,Me,B,K=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Te,X,ee=`This model is also a Flax Linen
<a href="https://flax.readthedocs.io/en/latest/_autosummary/flax.nn.module.html" rel="nofollow">flax.nn.Module</a> subclass. Use it as a
regular Flax Module and refer to the Flax documentation for all matter related to general usage and behavior.`,je,W,R="Finally, this model supports inherent JAX features such as:",re,Q,Qt='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Ne,Y,Ze,S,Ke,he="The <code>FlaxWav2Vec2PreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",Je,I,ue,le,fe,ke,ze,z,et,Ie,oe,O=`Wav2Vec2 Model with a <code>language modeling</code> head on top for Connectionist Temporal Classification (CTC).
Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,ve,ae,We=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,tt,Be,ht=`This model is also a Flax Linen
<a href="https://flax.readthedocs.io/en/latest/_autosummary/flax.nn.module.html" rel="nofollow">flax.nn.Module</a> subclass. Use it as a
regular Flax Module and refer to the Flax documentation for all matter related to general usage and behavior.`,ot,xe,at="Finally, this model supports inherent JAX features such as:",be,qe,G='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',ye,N,A,It,Ce,$e="The <code>FlaxWav2Vec2PreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",$t,E,Fe,P,Ve,T,V,Z,ne,Ye,D,ie=`Wav2Vec2 Model with a quantizer and <code>VQ</code> head on top.
Wav2Vec2 was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech
Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael
Auli.`,bt,Bt,Xt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Wt,nt,Gt=`This model is also a Flax Linen
<a href="https://flax.readthedocs.io/en/latest/_autosummary/flax.nn.module.html" rel="nofollow">flax.nn.Module</a> subclass. Use it as a
regular Flax Module and refer to the Flax documentation for all matter related to general usage and behavior.`,Rt,Nt,He="Finally, this model supports inherent JAX features such as:",st,rt,qt='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Le,ge,Xe,Ft,lt,to='The <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.FlaxWav2Vec2ForPreTraining">FlaxWav2Vec2ForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',it,yt,ce,de,St;return e=new we({props:{title:"FlaxWav2Vec2Model",local:"transformers.FlaxWav2Vec2Model",headingTag:"h2"}}),l=new F({props:{name:"class transformers.FlaxWav2Vec2Model",anchor:"transformers.FlaxWav2Vec2Model",parameters:[{name:"config",val:": Wav2Vec2Config"},{name:"input_shape",val:": Tuple = (1, 1024)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxWav2Vec2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxWav2Vec2Model.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_flax_wav2vec2.py#L1051"}}),Ze=new F({props:{name:"__call__",anchor:"transformers.FlaxWav2Vec2Model.__call__",parameters:[{name:"input_values",val:""},{name:"attention_mask",val:" = None"},{name:"mask_time_indices",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"freeze_feature_encoder",val:": bool = False"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FlaxWav2Vec2Model.__call__.input_values",description:`<strong>input_values</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>jnp.ndarray</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.FlaxWav2Vec2Model.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a> .. warning:: <code>attention_mask</code> should only be passed
if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor
has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.`,name:"attention_mask"},{anchor:"transformers.FlaxWav2Vec2Model.__call__.mask_time_indices",description:`<strong>mask_time_indices</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices to mask extracted features for contrastive loss. When in training mode, model learns to predict
masked extracted features in <em>config.proj_codevector_dim</em> space.`,name:"mask_time_indices"},{anchor:"transformers.FlaxWav2Vec2Model.__call__.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FlaxWav2Vec2Model.__call__.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxWav2Vec2Model.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_flax_wav2vec2.py#L888",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput"
>transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.wav2vec2.configuration_wav2vec2.Wav2Vec2Config'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>extract_features</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, last_conv_dim)</code>) — Sequence of extracted feature vectors of the last convolutional layer of the model with <code>last_conv_dim</code>
being the dimension of the last convolutional layer.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput"
>transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),I=new vt({props:{$$slots:{default:[Ns]},$$scope:{ctx:x}}}),le=new Ct({props:{anchor:"transformers.FlaxWav2Vec2Model.__call__.example",$$slots:{default:[qs]},$$scope:{ctx:x}}}),ke=new we({props:{title:"FlaxWav2Vec2ForCTC",local:"transformers.FlaxWav2Vec2ForCTC",headingTag:"h2"}}),et=new F({props:{name:"class transformers.FlaxWav2Vec2ForCTC",anchor:"transformers.FlaxWav2Vec2ForCTC",parameters:[{name:"config",val:": Wav2Vec2Config"},{name:"input_shape",val:": Tuple = (1, 1024)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxWav2Vec2ForCTC.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxWav2Vec2ForCTC.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_flax_wav2vec2.py#L1169"}}),A=new F({props:{name:"__call__",anchor:"transformers.FlaxWav2Vec2ForCTC.__call__",parameters:[{name:"input_values",val:""},{name:"attention_mask",val:" = None"},{name:"mask_time_indices",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"freeze_feature_encoder",val:": bool = False"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FlaxWav2Vec2ForCTC.__call__.input_values",description:`<strong>input_values</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>jnp.ndarray</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.FlaxWav2Vec2ForCTC.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a> .. warning:: <code>attention_mask</code> should only be passed
if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor
has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.`,name:"attention_mask"},{anchor:"transformers.FlaxWav2Vec2ForCTC.__call__.mask_time_indices",description:`<strong>mask_time_indices</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices to mask extracted features for contrastive loss. When in training mode, model learns to predict
masked extracted features in <em>config.proj_codevector_dim</em> space.`,name:"mask_time_indices"},{anchor:"transformers.FlaxWav2Vec2ForCTC.__call__.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FlaxWav2Vec2ForCTC.__call__.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxWav2Vec2ForCTC.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_flax_wav2vec2.py#L888",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxMaskedLMOutput"
>transformers.modeling_flax_outputs.FlaxMaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.wav2vec2.configuration_wav2vec2.Wav2Vec2Config'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxMaskedLMOutput"
>transformers.modeling_flax_outputs.FlaxMaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new vt({props:{$$slots:{default:[Ys]},$$scope:{ctx:x}}}),P=new Ct({props:{anchor:"transformers.FlaxWav2Vec2ForCTC.__call__.example",$$slots:{default:[Hs]},$$scope:{ctx:x}}}),T=new we({props:{title:"FlaxWav2Vec2ForPreTraining",local:"transformers.FlaxWav2Vec2ForPreTraining",headingTag:"h2"}}),ne=new F({props:{name:"class transformers.FlaxWav2Vec2ForPreTraining",anchor:"transformers.FlaxWav2Vec2ForPreTraining",parameters:[{name:"config",val:": Wav2Vec2Config"},{name:"input_shape",val:": Tuple = (1, 1024)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxWav2Vec2ForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Config">Wav2Vec2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxWav2Vec2ForPreTraining.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_flax_wav2vec2.py#L1318"}}),Xe=new F({props:{name:"__call__",anchor:"transformers.FlaxWav2Vec2ForPreTraining.__call__",parameters:[{name:"input_values",val:""},{name:"attention_mask",val:" = None"},{name:"mask_time_indices",val:" = None"},{name:"gumbel_temperature",val:": int = 1"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": PRNGKey = None"},{name:"gumbel_rng",val:": PRNGKey = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"freeze_feature_encoder",val:": bool = False"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FlaxWav2Vec2ForPreTraining.__call__.input_values",description:`<strong>input_values</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>jnp.ndarray</code>. See <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__">Wav2Vec2Processor.<strong>call</strong>()</a> for details.`,name:"input_values"},{anchor:"transformers.FlaxWav2Vec2ForPreTraining.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a> .. warning:: <code>attention_mask</code> should only be passed
if the corresponding processor has <code>config.return_attention_mask == True</code>. For all models whose processor
has <code>config.return_attention_mask == False</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, <code>attention_mask</code> should <strong>not</strong> be
passed to avoid degraded performance when doing batched inference. For such models <code>input_values</code> should
simply be padded with 0 and passed without <code>attention_mask</code>. Be aware that these models also yield slightly
different results depending on whether <code>input_values</code> is padded or not.`,name:"attention_mask"},{anchor:"transformers.FlaxWav2Vec2ForPreTraining.__call__.mask_time_indices",description:`<strong>mask_time_indices</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices to mask extracted features for contrastive loss. When in training mode, model learns to predict
masked extracted features in <em>config.proj_codevector_dim</em> space.`,name:"mask_time_indices"},{anchor:"transformers.FlaxWav2Vec2ForPreTraining.__call__.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FlaxWav2Vec2ForPreTraining.__call__.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxWav2Vec2ForPreTraining.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_flax_wav2vec2.py#L1322",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput"
>transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.wav2vec2.configuration_wav2vec2.Wav2Vec2Config'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<em>optional</em>, returned when model is in train mode, <code>jnp.ndarray</code> of shape <code>(1,)</code>) — Total loss as the sum of the contrastive loss (L_m) and the diversity loss (L_d) as stated in the <a
  href="https://arxiv.org/pdf/2006.11477.pdf"
  rel="nofollow"
>official
paper</a> . (classification) loss.</p>
</li>
<li>
<p><strong>projected_states</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) — Hidden-states of the model projected to <em>config.proj_codevector_dim</em> that can be used to predict the masked
projected quantized states.</p>
</li>
<li>
<p><strong>projected_quantized_states</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) — Quantized extracted feature vectors projected to <em>config.proj_codevector_dim</em> representing the positive
target vectors for contrastive loss.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput"
>transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),yt=new vt({props:{$$slots:{default:[Ls]},$$scope:{ctx:x}}}),de=new Ct({props:{anchor:"transformers.FlaxWav2Vec2ForPreTraining.__call__.example",$$slots:{default:[Es]},$$scope:{ctx:x}}}),{c(){u(e.$$.fragment),y=s(),n=c("div"),u(l.$$.fragment),w=s(),o=c("p"),o.innerHTML=M,Me=s(),B=c("p"),B.innerHTML=K,Te=s(),X=c("p"),X.innerHTML=ee,je=s(),W=c("p"),W.textContent=R,re=s(),Q=c("ul"),Q.innerHTML=Qt,Ne=s(),Y=c("div"),u(Ze.$$.fragment),S=s(),Ke=c("p"),Ke.innerHTML=he,Je=s(),u(I.$$.fragment),ue=s(),u(le.$$.fragment),fe=s(),u(ke.$$.fragment),ze=s(),z=c("div"),u(et.$$.fragment),Ie=s(),oe=c("p"),oe.innerHTML=O,ve=s(),ae=c("p"),ae.innerHTML=We,tt=s(),Be=c("p"),Be.innerHTML=ht,ot=s(),xe=c("p"),xe.textContent=at,be=s(),qe=c("ul"),qe.innerHTML=G,ye=s(),N=c("div"),u(A.$$.fragment),It=s(),Ce=c("p"),Ce.innerHTML=$e,$t=s(),u(E.$$.fragment),Fe=s(),u(P.$$.fragment),Ve=s(),u(T.$$.fragment),V=s(),Z=c("div"),u(ne.$$.fragment),Ye=s(),D=c("p"),D.innerHTML=ie,bt=s(),Bt=c("p"),Bt.innerHTML=Xt,Wt=s(),nt=c("p"),nt.innerHTML=Gt,Rt=s(),Nt=c("p"),Nt.textContent=He,st=s(),rt=c("ul"),rt.innerHTML=qt,Le=s(),ge=c("div"),u(Xe.$$.fragment),Ft=s(),lt=c("p"),lt.innerHTML=to,it=s(),u(yt.$$.fragment),ce=s(),u(de.$$.fragment),this.h()},l(k){f(e.$$.fragment,k),y=r(k),n=d(k,"DIV",{class:!0});var U=C(n);f(l.$$.fragment,U),w=r(U),o=d(U,"P",{"data-svelte-h":!0}),h(o)!=="svelte-te9mu1"&&(o.innerHTML=M),Me=r(U),B=d(U,"P",{"data-svelte-h":!0}),h(B)!=="svelte-18ki9f4"&&(B.innerHTML=K),Te=r(U),X=d(U,"P",{"data-svelte-h":!0}),h(X)!=="svelte-idybz1"&&(X.innerHTML=ee),je=r(U),W=d(U,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1pplc4a"&&(W.textContent=R),re=r(U),Q=d(U,"UL",{"data-svelte-h":!0}),h(Q)!=="svelte-1w7z84m"&&(Q.innerHTML=Qt),Ne=r(U),Y=d(U,"DIV",{class:!0});var Ee=C(Y);f(Ze.$$.fragment,Ee),S=r(Ee),Ke=d(Ee,"P",{"data-svelte-h":!0}),h(Ke)!=="svelte-dpjknz"&&(Ke.innerHTML=he),Je=r(Ee),f(I.$$.fragment,Ee),ue=r(Ee),f(le.$$.fragment,Ee),Ee.forEach(i),U.forEach(i),fe=r(k),f(ke.$$.fragment,k),ze=r(k),z=d(k,"DIV",{class:!0});var L=C(z);f(et.$$.fragment,L),Ie=r(L),oe=d(L,"P",{"data-svelte-h":!0}),h(oe)!=="svelte-1p0g25y"&&(oe.innerHTML=O),ve=r(L),ae=d(L,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-18ki9f4"&&(ae.innerHTML=We),tt=r(L),Be=d(L,"P",{"data-svelte-h":!0}),h(Be)!=="svelte-idybz1"&&(Be.innerHTML=ht),ot=r(L),xe=d(L,"P",{"data-svelte-h":!0}),h(xe)!=="svelte-1pplc4a"&&(xe.textContent=at),be=r(L),qe=d(L,"UL",{"data-svelte-h":!0}),h(qe)!=="svelte-1w7z84m"&&(qe.innerHTML=G),ye=r(L),N=d(L,"DIV",{class:!0});var ut=C(N);f(A.$$.fragment,ut),It=r(ut),Ce=d(ut,"P",{"data-svelte-h":!0}),h(Ce)!=="svelte-dpjknz"&&(Ce.innerHTML=$e),$t=r(ut),f(E.$$.fragment,ut),Fe=r(ut),f(P.$$.fragment,ut),ut.forEach(i),L.forEach(i),Ve=r(k),f(T.$$.fragment,k),V=r(k),Z=d(k,"DIV",{class:!0});var pe=C(Z);f(ne.$$.fragment,pe),Ye=r(pe),D=d(pe,"P",{"data-svelte-h":!0}),h(D)!=="svelte-wn7jg8"&&(D.innerHTML=ie),bt=r(pe),Bt=d(pe,"P",{"data-svelte-h":!0}),h(Bt)!=="svelte-18ki9f4"&&(Bt.innerHTML=Xt),Wt=r(pe),nt=d(pe,"P",{"data-svelte-h":!0}),h(nt)!=="svelte-idybz1"&&(nt.innerHTML=Gt),Rt=r(pe),Nt=d(pe,"P",{"data-svelte-h":!0}),h(Nt)!=="svelte-1pplc4a"&&(Nt.textContent=He),st=r(pe),rt=d(pe,"UL",{"data-svelte-h":!0}),h(rt)!=="svelte-1w7z84m"&&(rt.innerHTML=qt),Le=r(pe),ge=d(pe,"DIV",{class:!0});var te=C(ge);f(Xe.$$.fragment,te),Ft=r(te),lt=d(te,"P",{"data-svelte-h":!0}),h(lt)!=="svelte-tug4cx"&&(lt.innerHTML=to),it=r(te),f(yt.$$.fragment,te),ce=r(te),f(de.$$.fragment,te),te.forEach(i),pe.forEach(i),this.h()},h(){$(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(k,U){g(e,k,U),p(k,y,U),p(k,n,U),g(l,n,null),a(n,w),a(n,o),a(n,Me),a(n,B),a(n,Te),a(n,X),a(n,je),a(n,W),a(n,re),a(n,Q),a(n,Ne),a(n,Y),g(Ze,Y,null),a(Y,S),a(Y,Ke),a(Y,Je),g(I,Y,null),a(Y,ue),g(le,Y,null),p(k,fe,U),g(ke,k,U),p(k,ze,U),p(k,z,U),g(et,z,null),a(z,Ie),a(z,oe),a(z,ve),a(z,ae),a(z,tt),a(z,Be),a(z,ot),a(z,xe),a(z,be),a(z,qe),a(z,ye),a(z,N),g(A,N,null),a(N,It),a(N,Ce),a(N,$t),g(E,N,null),a(N,Fe),g(P,N,null),p(k,Ve,U),g(T,k,U),p(k,V,U),p(k,Z,U),g(ne,Z,null),a(Z,Ye),a(Z,D),a(Z,bt),a(Z,Bt),a(Z,Wt),a(Z,nt),a(Z,Rt),a(Z,Nt),a(Z,st),a(Z,rt),a(Z,Le),a(Z,ge),g(Xe,ge,null),a(ge,Ft),a(ge,lt),a(ge,it),g(yt,ge,null),a(ge,ce),g(de,ge,null),St=!0},p(k,U){const Ee={};U&2&&(Ee.$$scope={dirty:U,ctx:k}),I.$set(Ee);const L={};U&2&&(L.$$scope={dirty:U,ctx:k}),le.$set(L);const ut={};U&2&&(ut.$$scope={dirty:U,ctx:k}),E.$set(ut);const pe={};U&2&&(pe.$$scope={dirty:U,ctx:k}),P.$set(pe);const te={};U&2&&(te.$$scope={dirty:U,ctx:k}),yt.$set(te);const Yt={};U&2&&(Yt.$$scope={dirty:U,ctx:k}),de.$set(Yt)},i(k){St||(_(e.$$.fragment,k),_(l.$$.fragment,k),_(Ze.$$.fragment,k),_(I.$$.fragment,k),_(le.$$.fragment,k),_(ke.$$.fragment,k),_(et.$$.fragment,k),_(A.$$.fragment,k),_(E.$$.fragment,k),_(P.$$.fragment,k),_(T.$$.fragment,k),_(ne.$$.fragment,k),_(Xe.$$.fragment,k),_(yt.$$.fragment,k),_(de.$$.fragment,k),St=!0)},o(k){v(e.$$.fragment,k),v(l.$$.fragment,k),v(Ze.$$.fragment,k),v(I.$$.fragment,k),v(le.$$.fragment,k),v(ke.$$.fragment,k),v(et.$$.fragment,k),v(A.$$.fragment,k),v(E.$$.fragment,k),v(P.$$.fragment,k),v(T.$$.fragment,k),v(ne.$$.fragment,k),v(Xe.$$.fragment,k),v(yt.$$.fragment,k),v(de.$$.fragment,k),St=!1},d(k){k&&(i(y),i(n),i(fe),i(ze),i(z),i(Ve),i(V),i(Z)),b(e,k),b(l),b(Ze),b(I),b(le),b(ke,k),b(et),b(A),b(E),b(P),b(T,k),b(ne),b(Xe),b(yt),b(de)}}}function Qs(x){let e,y;return e=new qn({props:{$$slots:{default:[Ps]},$$scope:{ctx:x}}}),{c(){u(e.$$.fragment)},l(n){f(e.$$.fragment,n)},m(n,l){g(e,n,l),y=!0},p(n,l){const w={};l&2&&(w.$$scope={dirty:l,ctx:n}),e.$set(w)},i(n){y||(_(e.$$.fragment,n),y=!0)},o(n){v(e.$$.fragment,n),y=!1},d(n){b(e,n)}}}function Ss(x){let e,y,n,l,w,o,M,Me,B,K='The Wav2Vec2 model was proposed in <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael Auli.',Te,X,ee="The abstract from the paper is the following:",je,W,R=`<em>We show for the first time that learning powerful representations from speech audio alone followed by fine-tuning on
transcribed speech can outperform the best semi-supervised methods while being conceptually simpler. wav2vec 2.0 masks
the speech input in the latent space and solves a contrastive task defined over a quantization of the latent
representations which are jointly learned. Experiments using all labeled data of Librispeech achieve 1.8/3.3 WER on the
clean/other test sets. When lowering the amount of labeled data to one hour, wav2vec 2.0 outperforms the previous state
of the art on the 100 hour subset while using 100 times less labeled data. Using just ten minutes of labeled data and
pre-training on 53k hours of unlabeled data still achieves 4.8/8.2 WER. This demonstrates the feasibility of speech
recognition with limited amounts of labeled data.</em>`,re,Q,Qt='This model was contributed by <a href="https://huggingface.co/patrickvonplaten" rel="nofollow">patrickvonplaten</a>.',Ne,Y,Ze,S,Ke=`<li>Wav2Vec2 is a speech model that accepts a float array corresponding to the raw waveform of the speech signal.</li> <li>Wav2Vec2 model was trained using connectionist temporal classification (CTC) so the model output has to be decoded
using <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a>.</li>`,he,Je,I,ue,le="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Wav2Vec2. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",fe,ke,ze,z,et='<li>A notebook on how to <a href="https://colab.research.google.com/github/m3hrdadfi/soxan/blob/main/notebooks/Emotion_recognition_in_Greek_speech_using_Wav2Vec2.ipynb" rel="nofollow">leverage a pretrained Wav2Vec2 model for emotion classification</a>. 🌎</li> <li><a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/audio-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/audio_classification.ipynb" rel="nofollow">notebook</a>.</li> <li><a href="../tasks/audio_classification">Audio classification task guide</a></li>',Ie,oe,O,ve,ae='<li>A blog post on <a href="https://huggingface.co/blog/wav2vec2-with-ngram" rel="nofollow">boosting Wav2Vec2 with n-grams in 🤗 Transformers</a>.</li> <li>A blog post on how to <a href="https://huggingface.co/blog/fine-tune-wav2vec2-english" rel="nofollow">finetune Wav2Vec2 for English ASR with 🤗 Transformers</a>.</li> <li>A blog post on <a href="https://huggingface.co/blog/fine-tune-xlsr-wav2vec2" rel="nofollow">finetuning XLS-R for Multi-Lingual ASR with 🤗 Transformers</a>.</li> <li>A notebook on how to <a href="https://colab.research.google.com/github/Muennighoff/ytclipcc/blob/main/wav2vec_youtube_captions.ipynb" rel="nofollow">create YouTube captions from any video by transcribing audio with Wav2Vec2</a>. 🌎</li> <li><a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a> is supported by a notebook on <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/speech_recognition.ipynb" rel="nofollow">how to finetune a speech recognition model in English</a>, and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/multi_lingual_speech_recognition.ipynb" rel="nofollow">how to finetune a speech recognition model in any language</a>.</li> <li><a href="../tasks/asr">Automatic speech recognition task guide</a></li>',We,tt,Be="🚀 Deploy",ht,ot,xe='<li>A blog post on how to deploy Wav2Vec2 for <a href="https://www.philschmid.de/automatic-speech-recognition-sagemaker" rel="nofollow">Automatic Speech Recognition with Hugging Face’s Transformers &amp; Amazon SageMaker</a>.</li>',at,be,qe,G,ye,N,A,It=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a>. It is used to instantiate an
Wav2Vec2 model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Wav2Vec2
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">facebook/wav2vec2-base-960h</a> architecture.`,Ce,$e,$t=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,E,Fe,P,Ve,T,V,Z,ne,Ye,D="Constructs a Wav2Vec2CTC tokenizer.",ie,bt,Bt=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains some of the main methods. Users should refer to
the superclass for more information regarding such methods.`,Xt,Wt,nt,Gt,Rt,Nt=`Main method to tokenize and prepare for the model one or several sequence(s) or one or several pair(s) of
sequences.`,He,st,rt,qt,Le,ge,Xe,Ft,lt=`Converts a sequence of ids in a string, using the tokenizer and vocabulary with options to remove special
tokens and clean up tokenization spaces.`,to,it,yt="Similar to doing <code>self.convert_tokens_to_string(self.convert_ids_to_tokens(token_ids))</code>.",ce,de,St,k,U,Ee,L,ut="Convert a list of lists of token ids into a list of strings by calling decode.",pe,te,Yt,Qo,Ht,La="Set the target language of a nested multi-lingual dictionary",Bo,Ge,At,ft,Ut,wa,bo,oo="Constructs a Wav2Vec2 feature extractor.",So,xt,Ao=`This feature extractor inherits from <a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.SequenceFeatureExtractor">SequenceFeatureExtractor</a> which contains
most of the main methods. Users should refer to this superclass for more information regarding those methods.`,ao,Lt,me,no,yo,Jo="Main method to featurize and prepare for the model one or several sequence(s).",Do,so,ro,se,lo,wo,Co,Ma=`Constructs a Wav2Vec2 processor which wraps a Wav2Vec2 feature extractor and a Wav2Vec2 CTC tokenizer into a single
processor.`,Mo,$o,Ta=`<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor">Wav2Vec2Processor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a> and <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.
See the docstring of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.__call__"><strong>call</strong>()</a> and <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Processor.decode">decode()</a> for more information.`,wt,Mt,io,To,Fo,ja=`When used in normal mode, this method forwards all its arguments to Wav2Vec2FeatureExtractor’s
<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor.__call__"><strong>call</strong>()</a> and returns its output. If used in the context
<code>as_target_processor()</code> this method forwards all its arguments to PreTrainedTokenizer’s
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__"><strong>call</strong>()</a>. Please refer to the docstring of the above two methods for more information.`,Dt,Ot,Tt,Xo,Zt,Oo=`When used in normal mode, this method forwards all its arguments to Wav2Vec2FeatureExtractor’s
<a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.SequenceFeatureExtractor.pad">pad()</a> and returns its output. If used in the context
<code>as_target_processor()</code> this method forwards all its arguments to PreTrainedTokenizer’s
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.pad">pad()</a>. Please refer to the docstring of the above two methods for more information.`,Pe,zt,co,jo,Et,po,ko,Uo,ka=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/main/en/model_doc/donut#transformers.DonutProcessor.from_pretrained">from_pretrained()</a> method.`,Wo,mo,Ko,Ue,Vt,ea,Pt,Ea=`This method forwards all its arguments to PreTrainedTokenizer’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,ta,gt,ho,Kt,uo,m=`This method forwards all its arguments to PreTrainedTokenizer’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer
to the docstring of this method for more information.`,J,Qe,Re,q,Se,Ae,ct,dt=`Constructs a Wav2Vec2 processor which wraps a Wav2Vec2 feature extractor, a Wav2Vec2 CTC tokenizer and a decoder
with language model support into a single processor for language model boosted speech recognition decoding.`,Jt,_e,De,_t,pt,Pa=`When used in normal mode, this method forwards all its arguments to Wav2Vec2FeatureExtractor’s
<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor.__call__"><strong>call</strong>()</a> and returns its output. If used in the context
<code>as_target_processor()</code> this method forwards all its arguments to
Wav2Vec2CTCTokenizer’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__"><strong>call</strong>()</a>. Please refer to the docstring of the above two
methods for more information.`,Wa,Go,oa,wn,xa,Yn=`When used in normal mode, this method forwards all its arguments to Wav2Vec2FeatureExtractor’s
<a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.SequenceFeatureExtractor.pad">pad()</a> and returns its output. If used in the context
<code>as_target_processor()</code> this method forwards all its arguments to
Wav2Vec2CTCTokenizer’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.pad">pad()</a>. Please refer to the docstring of the above two methods
for more information.`,Mn,xo,aa,Tn,Va,Hn='Instantiate a <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ProcessorWithLM">Wav2Vec2ProcessorWithLM</a> from a pretrained Wav2Vec2 processor.',jn,Ro,kn,Ja,na,Wn,eo,sa,xn,Ca,Ln="Batch decode output logits to audio transcription with language model support.",Vn,No,Jn,$a,En=`Example:
See <a href="#decoding-multiple-audios">Decoding multiple audios</a>.`,Cn,Vo,ra,$n,Fa,Pn="Decode output logits to audio transcription with language model support.",Fn,qo,Aa,la,Da,ia,Qn=`If you are planning to decode multiple batches of audios, you should consider using <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ProcessorWithLM.batch_decode">batch_decode()</a> and passing an instantiated <code>multiprocessing.Pool</code>.
Otherwise, <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ProcessorWithLM.batch_decode">batch_decode()</a> performance will be slower than calling <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ProcessorWithLM.decode">decode()</a> for each audio individually, as it internally instantiates a new <code>Pool</code> for every call. See the example below:`,Oa,ca,Ka,da,en,Zo,pa,Un,Ua,Sn="Output type of <code>Wav2Vec2DecoderWithLM</code>, with transcription.",tn,zo,ma,Zn,Za,An="Base class for models that have been trained with the Wav2Vec2 loss objective.",on,Io,ha,zn,za,Dn='Output type of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForPreTraining">Wav2Vec2ForPreTraining</a>, with potential hidden states and attentions.',an,fo,ua,In,Ia,On="Output type of <code>FlaxWav2Vec2BaseModelOutput</code>, with potential hidden states and attentions.",Bn,Yo,fa,Xn,Ba,Kn="“Returns a new object replacing the specified fields with new values.",nn,go,ga,Gn,Xa,es="Output type of <code>FlaxWav2Vec2ForPreTrainingOutput</code>, with potential hidden states and attentions.",Rn,Ho,_a,Nn,Ga,ts="“Returns a new object replacing the specified fields with new values.",sn,Lo,rn,Qa,ln;return w=new we({props:{title:"Wav2Vec2",local:"wav2vec2",headingTag:"h1"}}),M=new we({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Y=new we({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),Je=new we({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ke=new ns({props:{pipeline:"audio-classification"}}),oe=new ns({props:{pipeline:"automatic-speech-recognition"}}),be=new we({props:{title:"Wav2Vec2Config",local:"transformers.Wav2Vec2Config",headingTag:"h2"}}),ye=new F({props:{name:"class transformers.Wav2Vec2Config",anchor:"transformers.Wav2Vec2Config",parameters:[{name:"vocab_size",val:" = 32"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout",val:" = 0.1"},{name:"activation_dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.1"},{name:"feat_proj_dropout",val:" = 0.0"},{name:"feat_quantizer_dropout",val:" = 0.0"},{name:"final_dropout",val:" = 0.1"},{name:"layerdrop",val:" = 0.1"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"feat_extract_norm",val:" = 'group'"},{name:"feat_extract_activation",val:" = 'gelu'"},{name:"conv_dim",val:" = (512, 512, 512, 512, 512, 512, 512)"},{name:"conv_stride",val:" = (5, 2, 2, 2, 2, 2, 2)"},{name:"conv_kernel",val:" = (10, 3, 3, 3, 3, 2, 2)"},{name:"conv_bias",val:" = False"},{name:"num_conv_pos_embeddings",val:" = 128"},{name:"num_conv_pos_embedding_groups",val:" = 16"},{name:"do_stable_layer_norm",val:" = False"},{name:"apply_spec_augment",val:" = True"},{name:"mask_time_prob",val:" = 0.05"},{name:"mask_time_length",val:" = 10"},{name:"mask_time_min_masks",val:" = 2"},{name:"mask_feature_prob",val:" = 0.0"},{name:"mask_feature_length",val:" = 10"},{name:"mask_feature_min_masks",val:" = 0"},{name:"num_codevectors_per_group",val:" = 320"},{name:"num_codevector_groups",val:" = 2"},{name:"contrastive_logits_temperature",val:" = 0.1"},{name:"num_negatives",val:" = 100"},{name:"codevector_dim",val:" = 256"},{name:"proj_codevector_dim",val:" = 256"},{name:"diversity_loss_weight",val:" = 0.1"},{name:"ctc_loss_reduction",val:" = 'sum'"},{name:"ctc_zero_infinity",val:" = False"},{name:"use_weighted_layer_sum",val:" = False"},{name:"classifier_proj_size",val:" = 256"},{name:"tdnn_dim",val:" = (512, 512, 512, 512, 1500)"},{name:"tdnn_kernel",val:" = (5, 3, 3, 1, 1)"},{name:"tdnn_dilation",val:" = (1, 2, 3, 1, 1)"},{name:"xvector_output_dim",val:" = 512"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"add_adapter",val:" = False"},{name:"adapter_kernel_size",val:" = 3"},{name:"adapter_stride",val:" = 2"},{name:"num_adapter_layers",val:" = 3"},{name:"output_hidden_size",val:" = None"},{name:"adapter_attn_dim",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Vocabulary size of the Wav2Vec2 model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a> or <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.TFWav2Vec2Model">TFWav2Vec2Model</a>. Vocabulary size of the
model. Defines the different tokens that can be represented by the <em>inputs_ids</em> passed to the forward
method of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a>.`,name:"vocab_size"},{anchor:"transformers.Wav2Vec2Config.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.Wav2Vec2Config.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Wav2Vec2Config.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Wav2Vec2Config.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.Wav2Vec2Config.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.Wav2Vec2Config.hidden_dropout",description:`<strong>hidden_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout"},{anchor:"transformers.Wav2Vec2Config.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.Wav2Vec2Config.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Wav2Vec2Config.final_dropout",description:`<strong>final_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for the final projection layer of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a>.`,name:"final_dropout"},{anchor:"transformers.Wav2Vec2Config.layerdrop",description:`<strong>layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The LayerDrop probability. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>) for more
details.`,name:"layerdrop"},{anchor:"transformers.Wav2Vec2Config.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Wav2Vec2Config.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.Wav2Vec2Config.feat_extract_norm",description:`<strong>feat_extract_norm</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;group&quot;</code>) &#x2014;
The norm to be applied to 1D convolutional layers in feature encoder. One of <code>&quot;group&quot;</code> for group
normalization of only the first 1D convolutional layer or <code>&quot;layer&quot;</code> for layer normalization of all 1D
convolutional layers.`,name:"feat_extract_norm"},{anchor:"transformers.Wav2Vec2Config.feat_proj_dropout",description:`<strong>feat_proj_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for output of the feature encoder.`,name:"feat_proj_dropout"},{anchor:"transformers.Wav2Vec2Config.feat_extract_activation",description:"<strong>feat_extract_activation</strong> (<code>str, </code>optional<code>, defaults to </code>&#x201C;gelu&#x201D;<code>) -- The non-linear activation function (function or string) in the 1D convolutional layers of the feature extractor. If string, </code>&#x201C;gelu&#x201D;<code>, </code>&#x201C;relu&#x201D;<code>, </code>&#x201C;selu&#x201D;<code>and</code>&#x201C;gelu_new&#x201D;` are supported.",name:"feat_extract_activation"},{anchor:"transformers.Wav2Vec2Config.feat_quantizer_dropout",description:`<strong>feat_quantizer_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for quantized feature encoder states.`,name:"feat_quantizer_dropout"},{anchor:"transformers.Wav2Vec2Config.conv_dim",description:`<strong>conv_dim</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(512, 512, 512, 512, 512, 512, 512)</code>) &#x2014;
A tuple of integers defining the number of input and output channels of each 1D convolutional layer in the
feature encoder. The length of <em>conv_dim</em> defines the number of 1D convolutional layers.`,name:"conv_dim"},{anchor:"transformers.Wav2Vec2Config.conv_stride",description:`<strong>conv_stride</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(5, 2, 2, 2, 2, 2, 2)</code>) &#x2014;
A tuple of integers defining the stride of each 1D convolutional layer in the feature encoder. The length
of <em>conv_stride</em> defines the number of convolutional layers and has to match the length of <em>conv_dim</em>.`,name:"conv_stride"},{anchor:"transformers.Wav2Vec2Config.conv_kernel",description:`<strong>conv_kernel</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(10, 3, 3, 3, 3, 3, 3)</code>) &#x2014;
A tuple of integers defining the kernel size of each 1D convolutional layer in the feature encoder. The
length of <em>conv_kernel</em> defines the number of convolutional layers and has to match the length of
<em>conv_dim</em>.`,name:"conv_kernel"},{anchor:"transformers.Wav2Vec2Config.conv_bias",description:`<strong>conv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the 1D convolutional layers have a bias.`,name:"conv_bias"},{anchor:"transformers.Wav2Vec2Config.num_conv_pos_embeddings",description:`<strong>num_conv_pos_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Number of convolutional positional embeddings. Defines the kernel size of 1D convolutional positional
embeddings layer.`,name:"num_conv_pos_embeddings"},{anchor:"transformers.Wav2Vec2Config.num_conv_pos_embedding_groups",description:`<strong>num_conv_pos_embedding_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of groups of 1D convolutional positional embeddings layer.`,name:"num_conv_pos_embedding_groups"},{anchor:"transformers.Wav2Vec2Config.do_stable_layer_norm",description:`<strong>do_stable_layer_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply <em>stable</em> layer norm architecture of the Transformer encoder. <code>do_stable_layer_norm is True</code> corresponds to applying layer norm before the attention layer, whereas <code>do_stable_layer_norm is False</code> corresponds to applying layer norm after the attention layer.`,name:"do_stable_layer_norm"},{anchor:"transformers.Wav2Vec2Config.apply_spec_augment",description:`<strong>apply_spec_augment</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to apply <em>SpecAugment</em> data augmentation to the outputs of the feature encoder. For reference see
<a href="https://arxiv.org/abs/1904.08779" rel="nofollow">SpecAugment: A Simple Data Augmentation Method for Automatic Speech
Recognition</a>.`,name:"apply_spec_augment"},{anchor:"transformers.Wav2Vec2Config.mask_time_prob",description:`<strong>mask_time_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.05) &#x2014;
Percentage (between 0 and 1) of all feature vectors along the time axis which will be masked. The masking
procecure generates &#x201D;mask_time_prob<em>len(time_axis)/mask_time_length&#x201D; independent masks over the axis. If
reasoning from the propability of each feature vector to be chosen as the start of the vector span to be
masked, </em>mask_time_prob<em> should be \`prob_vector_start</em>mask_time_length<code>. Note that overlap may decrease the actual percentage of masked vectors. This is only relevant if </code>apply_spec_augment is True\`.`,name:"mask_time_prob"},{anchor:"transformers.Wav2Vec2Config.mask_time_length",description:`<strong>mask_time_length</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Length of vector span along the time axis.`,name:"mask_time_length"},{anchor:"transformers.Wav2Vec2Config.mask_time_min_masks",description:`<strong>mask_time_min_masks</strong> (<code>int</code>, <em>optional</em>, defaults to 2), &#x2014;
The minimum number of masks of length <code>mask_feature_length</code> generated along the time axis, each time step,
irrespectively of <code>mask_feature_prob</code>. Only relevant if &#x201D;mask_time_prob*len(time_axis)/mask_time_length &lt;
mask_time_min_masks&#x201D;`,name:"mask_time_min_masks"},{anchor:"transformers.Wav2Vec2Config.mask_feature_prob",description:`<strong>mask_feature_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Percentage (between 0 and 1) of all feature vectors along the feature axis which will be masked. The
masking procecure generates &#x201D;mask_feature_prob<em>len(feature_axis)/mask_time_length&#x201D; independent masks over
the axis. If reasoning from the propability of each feature vector to be chosen as the start of the vector
span to be masked, </em>mask_feature_prob<em> should be \`prob_vector_start</em>mask_feature_length<code>. Note that overlap may decrease the actual percentage of masked vectors. This is only relevant if </code>apply_spec_augment is
True\`.`,name:"mask_feature_prob"},{anchor:"transformers.Wav2Vec2Config.mask_feature_length",description:`<strong>mask_feature_length</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Length of vector span along the feature axis.`,name:"mask_feature_length"},{anchor:"transformers.Wav2Vec2Config.mask_feature_min_masks",description:`<strong>mask_feature_min_masks</strong> (<code>int</code>, <em>optional</em>, defaults to 0), &#x2014;
The minimum number of masks of length <code>mask_feature_length</code> generated along the feature axis, each time
step, irrespectively of <code>mask_feature_prob</code>. Only relevant if
&#x201D;mask_feature_prob*len(feature_axis)/mask_feature_length &lt; mask_feature_min_masks&#x201D;`,name:"mask_feature_min_masks"},{anchor:"transformers.Wav2Vec2Config.num_codevectors_per_group",description:`<strong>num_codevectors_per_group</strong> (<code>int</code>, <em>optional</em>, defaults to 320) &#x2014;
Number of entries in each quantization codebook (group).`,name:"num_codevectors_per_group"},{anchor:"transformers.Wav2Vec2Config.num_codevector_groups",description:`<strong>num_codevector_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of codevector groups for product codevector quantization.`,name:"num_codevector_groups"},{anchor:"transformers.Wav2Vec2Config.contrastive_logits_temperature",description:`<strong>contrastive_logits_temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The temperature <em>kappa</em> in the contrastive loss.`,name:"contrastive_logits_temperature"},{anchor:"transformers.Wav2Vec2Config.feat_quantizer_dropout",description:`<strong>feat_quantizer_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for the output of the feature encoder that&#x2019;s used by the quantizer.`,name:"feat_quantizer_dropout"},{anchor:"transformers.Wav2Vec2Config.num_negatives",description:`<strong>num_negatives</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Number of negative samples for the contrastive loss.`,name:"num_negatives"},{anchor:"transformers.Wav2Vec2Config.codevector_dim",description:`<strong>codevector_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the quantized feature vectors.`,name:"codevector_dim"},{anchor:"transformers.Wav2Vec2Config.proj_codevector_dim",description:`<strong>proj_codevector_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the final projection of both the quantized and the transformer features.`,name:"proj_codevector_dim"},{anchor:"transformers.Wav2Vec2Config.diversity_loss_weight",description:`<strong>diversity_loss_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The weight of the codebook diversity loss component.`,name:"diversity_loss_weight"},{anchor:"transformers.Wav2Vec2Config.ctc_loss_reduction",description:`<strong>ctc_loss_reduction</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sum&quot;</code>) &#x2014;
Specifies the reduction to apply to the output of <code>torch.nn.CTCLoss</code>. Only relevant when training an
instance of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a>.`,name:"ctc_loss_reduction"},{anchor:"transformers.Wav2Vec2Config.ctc_zero_infinity",description:`<strong>ctc_zero_infinity</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to zero infinite losses and the associated gradients of <code>torch.nn.CTCLoss</code>. Infinite losses mainly
occur when the inputs are too short to be aligned to the targets. Only relevant when training an instance
of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a>.`,name:"ctc_zero_infinity"},{anchor:"transformers.Wav2Vec2Config.use_weighted_layer_sum",description:`<strong>use_weighted_layer_sum</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a weighted average of layer outputs with learned weights. Only relevant when using an
instance of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForSequenceClassification">Wav2Vec2ForSequenceClassification</a>.`,name:"use_weighted_layer_sum"},{anchor:"transformers.Wav2Vec2Config.classifier_proj_size",description:`<strong>classifier_proj_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the projection before token mean-pooling for classification.`,name:"classifier_proj_size"},{anchor:"transformers.Wav2Vec2Config.tdnn_dim",description:`<strong>tdnn_dim</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(512, 512, 512, 512, 1500)</code>) &#x2014;
A tuple of integers defining the number of output channels of each 1D convolutional layer in the <em>TDNN</em>
module of the <em>XVector</em> model. The length of <em>tdnn_dim</em> defines the number of <em>TDNN</em> layers.`,name:"tdnn_dim"},{anchor:"transformers.Wav2Vec2Config.tdnn_kernel",description:`<strong>tdnn_kernel</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(5, 3, 3, 1, 1)</code>) &#x2014;
A tuple of integers defining the kernel size of each 1D convolutional layer in the <em>TDNN</em> module of the
<em>XVector</em> model. The length of <em>tdnn_kernel</em> has to match the length of <em>tdnn_dim</em>.`,name:"tdnn_kernel"},{anchor:"transformers.Wav2Vec2Config.tdnn_dilation",description:`<strong>tdnn_dilation</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(1, 2, 3, 1, 1)</code>) &#x2014;
A tuple of integers defining the dilation factor of each 1D convolutional layer in <em>TDNN</em> module of the
<em>XVector</em> model. The length of <em>tdnn_dilation</em> has to match the length of <em>tdnn_dim</em>.`,name:"tdnn_dilation"},{anchor:"transformers.Wav2Vec2Config.xvector_output_dim",description:`<strong>xvector_output_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of the <em>XVector</em> embedding vectors.`,name:"xvector_output_dim"},{anchor:"transformers.Wav2Vec2Config.add_adapter",description:`<strong>add_adapter</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether a convolutional network should be stacked on top of the Wav2Vec2 Encoder. Can be very useful for
warm-starting Wav2Vec2 for SpeechEncoderDecoder models.`,name:"add_adapter"},{anchor:"transformers.Wav2Vec2Config.adapter_kernel_size",description:`<strong>adapter_kernel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Kernel size of the convolutional layers in the adapter network. Only relevant if <code>add_adapter is True</code>.`,name:"adapter_kernel_size"},{anchor:"transformers.Wav2Vec2Config.adapter_stride",description:`<strong>adapter_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Stride of the convolutional layers in the adapter network. Only relevant if <code>add_adapter is True</code>.`,name:"adapter_stride"},{anchor:"transformers.Wav2Vec2Config.num_adapter_layers",description:`<strong>num_adapter_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of convolutional layers that should be used in the adapter network. Only relevant if <code>add_adapter is True</code>.`,name:"num_adapter_layers"},{anchor:"transformers.Wav2Vec2Config.adapter_attn_dim",description:`<strong>adapter_attn_dim</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension of the attention adapter weights to be used in each attention block. An example of a model using
attention adapters is <a href="https://huggingface.co/facebook/mms-1b-all" rel="nofollow">facebook/mms-1b-all</a>.`,name:"adapter_attn_dim"},{anchor:"transformers.Wav2Vec2Config.output_hidden_size",description:`<strong>output_hidden_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimensionality of the encoder output layer. If not defined, this defaults to <em>hidden-size</em>. Only relevant
if <code>add_adapter is True</code>.`,name:"output_hidden_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/configuration_wav2vec2.py#L32"}}),Fe=new Ct({props:{anchor:"transformers.Wav2Vec2Config.example",$$slots:{default:[ps]},$$scope:{ctx:x}}}),Ve=new we({props:{title:"Wav2Vec2CTCTokenizer",local:"transformers.Wav2Vec2CTCTokenizer",headingTag:"h2"}}),Z=new F({props:{name:"class transformers.Wav2Vec2CTCTokenizer",anchor:"transformers.Wav2Vec2CTCTokenizer",parameters:[{name:"vocab_file",val:""},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"word_delimiter_token",val:" = '|'"},{name:"replace_word_delimiter_char",val:" = ' '"},{name:"do_lower_case",val:" = False"},{name:"target_lang",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2CTCTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.Wav2Vec2CTCTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sentence token.`,name:"bos_token"},{anchor:"transformers.Wav2Vec2CTCTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sentence token.`,name:"eos_token"},{anchor:"transformers.Wav2Vec2CTCTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.Wav2Vec2CTCTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.Wav2Vec2CTCTokenizer.word_delimiter_token",description:`<strong>word_delimiter_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;|&quot;</code>) &#x2014;
The token used for defining the end of a word.`,name:"word_delimiter_token"},{anchor:"transformers.Wav2Vec2CTCTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to accept lowercase input and lowercase the output when decoding.`,name:"do_lower_case"},{anchor:"transformers.Wav2Vec2CTCTokenizer.target_lang",description:`<strong>target_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A target language the tokenizer should set by default. <code>target_lang</code> has to be defined for multi-lingual,
nested vocabulary such as <a href="https://huggingface.co/facebook/mms-1b-all" rel="nofollow">facebook/mms-1b-all</a>.</p>
<p>**kwargs &#x2014;
Additional keyword arguments passed along to <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>`,name:"target_lang"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/tokenization_wav2vec2.py#L127"}}),nt=new F({props:{name:"__call__",anchor:"transformers.Wav2Vec2CTCTokenizer.__call__",parameters:[{name:"text",val:": Union = None"},{name:"text_pair",val:": Union = None"},{name:"text_target",val:": Union = None"},{name:"text_pair_target",val:": Union = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": Union = False"},{name:"truncation",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"stride",val:": int = 0"},{name:"is_split_into_words",val:": bool = False"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"return_token_type_ids",val:": Optional = None"},{name:"return_attention_mask",val:": Optional = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.text_pair",description:`<strong>text_pair</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.text_target",description:`<strong>text_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_target"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.text_pair_target",description:`<strong>text_pair_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair_target"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add special tokens when encoding the sequences. This will use the underlying
<code>PretrainedTokenizerBase.build_inputs_with_special_tokens</code> function, which defines which tokens are
automatically added to the input ids. This is usefull if you want to add <code>bos</code> or <code>eos</code> tokens
automatically.`,name:"add_special_tokens"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. Requires <code>padding</code> to be activated.
This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.return_token_type_ids",description:`<strong>return_token_type_ids</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return token type IDs. If left to the default, will return the token type IDs according to
the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"return_token_type_ids"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return the attention mask. If left to the default, will return the attention mask according
to the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"return_attention_mask"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.return_overflowing_tokens",description:`<strong>return_overflowing_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return overflowing token sequences. If a pair of sequences of input ids (or a batch
of pairs) is provided with <code>truncation_strategy = longest_first</code> or <code>True</code>, an error is raised instead
of returning overflowing tokens.`,name:"return_overflowing_tokens"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.return_special_tokens_mask",description:`<strong>return_special_tokens_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return special tokens mask information.`,name:"return_special_tokens_mask"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.return_offsets_mapping",description:`<strong>return_offsets_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return <code>(char_start, char_end)</code> for each token.</p>
<p>This is only available on fast tokenizers inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a>, if using
Python&#x2019;s tokenizer, this method will raise <code>NotImplementedError</code>.`,name:"return_offsets_mapping"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.return_length",description:`<strong>return_length</strong>  (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the lengths of the encoded inputs.`,name:"return_length"},{anchor:"transformers.Wav2Vec2CTCTokenizer.__call__.verbose",description:`<strong>verbose</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to print more information and warnings.
**kwargs &#x2014; passed to the <code>self.tokenize()</code> method`,name:"verbose"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L2766",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a> with the following fields:</p>
<ul>
<li>
<p><strong>input_ids</strong> — List of token ids to be fed to a model.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
</li>
<li>
<p><strong>token_type_ids</strong> — List of token type ids to be fed to a model (when <code>return_token_type_ids=True</code> or
if <em>“token_type_ids”</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a></p>
</li>
<li>
<p><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
</li>
<li>
<p><strong>overflowing_tokens</strong> — List of overflowing tokens sequences (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>num_truncated_tokens</strong> — Number of tokens truncated (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>special_tokens_mask</strong> — List of 0s and 1s, with 1 specifying added special tokens and 0 specifying
regular sequence tokens (when <code>add_special_tokens=True</code> and <code>return_special_tokens_mask=True</code>).</p>
</li>
<li>
<p><strong>length</strong> — The length of the inputs (when <code>return_length=True</code>)</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a></p>
`}}),rt=new F({props:{name:"save_vocabulary",anchor:"transformers.Wav2Vec2CTCTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/tokenization_wav2vec2.py#L646"}}),ge=new F({props:{name:"decode",anchor:"transformers.Wav2Vec2CTCTokenizer.decode",parameters:[{name:"token_ids",val:": Union"},{name:"skip_special_tokens",val:": bool = False"},{name:"clean_up_tokenization_spaces",val:": bool = None"},{name:"output_char_offsets",val:": bool = False"},{name:"output_word_offsets",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2CTCTokenizer.decode.token_ids",description:`<strong>token_ids</strong> (<code>Union[int, List[int], np.ndarray, torch.Tensor, tf.Tensor]</code>) &#x2014;
List of tokenized input ids. Can be obtained using the <code>__call__</code> method.`,name:"token_ids"},{anchor:"transformers.Wav2Vec2CTCTokenizer.decode.skip_special_tokens",description:`<strong>skip_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to remove special tokens in the decoding.`,name:"skip_special_tokens"},{anchor:"transformers.Wav2Vec2CTCTokenizer.decode.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to clean up the tokenization spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.Wav2Vec2CTCTokenizer.decode.output_char_offsets",description:`<strong>output_char_offsets</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to output character offsets. Character offsets can be used in combination with the
sampling rate and model downsampling rate to compute the time-stamps of transcribed characters.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Please take a look at the example below to better understand how to make use of <code>output_char_offsets</code>.</p>

					</div>`,name:"output_char_offsets"},{anchor:"transformers.Wav2Vec2CTCTokenizer.decode.output_word_offsets",description:`<strong>output_word_offsets</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to output word offsets. Word offsets can be used in combination with the sampling rate
and model downsampling rate to compute the time-stamps of transcribed words.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Please take a look at the example below to better understand how to make use of <code>output_word_offsets</code>.</p>

					</div>`,name:"output_word_offsets"},{anchor:"transformers.Wav2Vec2CTCTokenizer.decode.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Will be passed to the underlying model specific decode method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/tokenization_wav2vec2.py#L541",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The list of decoded
sentences. Will be a <code>Wav2Vec2CTCTokenizerOutput</code> when
<code>output_char_offsets == True</code> or <code>output_word_offsets == True</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code> or <code>Wav2Vec2CTCTokenizerOutput</code></p>
`}}),de=new Ct({props:{anchor:"transformers.Wav2Vec2CTCTokenizer.decode.example",$$slots:{default:[ms]},$$scope:{ctx:x}}}),U=new F({props:{name:"batch_decode",anchor:"transformers.Wav2Vec2CTCTokenizer.batch_decode",parameters:[{name:"sequences",val:": Union"},{name:"skip_special_tokens",val:": bool = False"},{name:"clean_up_tokenization_spaces",val:": bool = None"},{name:"output_char_offsets",val:": bool = False"},{name:"output_word_offsets",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2CTCTokenizer.batch_decode.sequences",description:`<strong>sequences</strong> (<code>Union[List[int], List[List[int]], np.ndarray, torch.Tensor, tf.Tensor]</code>) &#x2014;
List of tokenized input ids. Can be obtained using the <code>__call__</code> method.`,name:"sequences"},{anchor:"transformers.Wav2Vec2CTCTokenizer.batch_decode.skip_special_tokens",description:`<strong>skip_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to remove special tokens in the decoding.`,name:"skip_special_tokens"},{anchor:"transformers.Wav2Vec2CTCTokenizer.batch_decode.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to clean up the tokenization spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.Wav2Vec2CTCTokenizer.batch_decode.output_char_offsets",description:`<strong>output_char_offsets</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to output character offsets. Character offsets can be used in combination with the
sampling rate and model downsampling rate to compute the time-stamps of transcribed characters.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Please take a look at the Example of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer.decode">decode()</a> to better understand how to make
use of <code>output_char_offsets</code>. <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer.batch_decode">batch_decode()</a> works the same way with batched
output.</p>

					</div>`,name:"output_char_offsets"},{anchor:"transformers.Wav2Vec2CTCTokenizer.batch_decode.output_word_offsets",description:`<strong>output_word_offsets</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to output word offsets. Word offsets can be used in combination with the sampling rate
and model downsampling rate to compute the time-stamps of transcribed words.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Please take a look at the Example of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer.decode">decode()</a> to better understand how to make
use of <code>output_word_offsets</code>. <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer.batch_decode">batch_decode()</a> works the same way with batched
output.</p>

					</div>`,name:"output_word_offsets"},{anchor:"transformers.Wav2Vec2CTCTokenizer.batch_decode.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Will be passed to the underlying model specific decode method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/tokenization_wav2vec2.py#L471",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The list of decoded
sentences. Will be a <code>Wav2Vec2CTCTokenizerOutput</code> when
<code>output_char_offsets == True</code> or <code>output_word_offsets == True</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code> or <code>Wav2Vec2CTCTokenizerOutput</code></p>
`}}),Yt=new F({props:{name:"set_target_lang",anchor:"transformers.Wav2Vec2CTCTokenizer.set_target_lang",parameters:[{name:"target_lang",val:": str"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/tokenization_wav2vec2.py#L213"}}),Ge=new we({props:{title:"Wav2Vec2FeatureExtractor",local:"transformers.Wav2Vec2FeatureExtractor",headingTag:"h2"}}),Ut=new F({props:{name:"class transformers.Wav2Vec2FeatureExtractor",anchor:"transformers.Wav2Vec2FeatureExtractor",parameters:[{name:"feature_size",val:" = 1"},{name:"sampling_rate",val:" = 16000"},{name:"padding_value",val:" = 0.0"},{name:"return_attention_mask",val:" = False"},{name:"do_normalize",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2FeatureExtractor.feature_size",description:`<strong>feature_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The feature dimension of the extracted features.`,name:"feature_size"},{anchor:"transformers.Wav2Vec2FeatureExtractor.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, defaults to 16000) &#x2014;
The sampling rate at which the audio files should be digitalized expressed in hertz (Hz).`,name:"sampling_rate"},{anchor:"transformers.Wav2Vec2FeatureExtractor.padding_value",description:`<strong>padding_value</strong> (<code>float</code>, defaults to 0.0) &#x2014;
The value that is used to fill the padding values.`,name:"padding_value"},{anchor:"transformers.Wav2Vec2FeatureExtractor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to zero-mean unit-variance normalize the input. Normalizing can help to significantly
improve the performance for some models, <em>e.g.</em>,
<a href="https://huggingface.co/models?search=lv60" rel="nofollow">wav2vec2-lv60</a>.`,name:"do_normalize"},{anchor:"transformers.Wav2Vec2FeatureExtractor.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor.__call__"><strong>call</strong>()</a> should return <code>attention_mask</code>.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Wav2Vec2 models that have set <code>config.feat_extract_norm == &quot;group&quot;</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, have <strong>not</strong> been trained using
<code>attention_mask</code>. For such models, <code>input_values</code> should simply be padded with 0 and no <code>attention_mask</code>
should be passed.</p>
<p>For Wav2Vec2 models that have set <code>config.feat_extract_norm == &quot;layer&quot;</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-large-960h-lv60-self" rel="nofollow">wav2vec2-lv60</a>, <code>attention_mask</code> should be
passed for batched inference.</p>

					</div>`,name:"return_attention_mask"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/feature_extraction_wav2vec2.py#L31"}}),me=new F({props:{name:"__call__",anchor:"transformers.Wav2Vec2FeatureExtractor.__call__",parameters:[{name:"raw_speech",val:": Union"},{name:"padding",val:": Union = False"},{name:"max_length",val:": Optional = None"},{name:"truncation",val:": bool = False"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"return_attention_mask",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"sampling_rate",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.raw_speech",description:`<strong>raw_speech</strong> (<code>np.ndarray</code>, <code>List[float]</code>, <code>List[np.ndarray]</code>, <code>List[List[float]]</code>) &#x2014;
The sequence or batch of sequences to be padded. Each sequence can be a numpy array, a list of float
values, a list of numpy arrays or a list of list of float values. Must be mono channel audio, not
stereo, i.e. single float per timestep.`,name:"raw_speech"},{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Select a strategy to pad the returned sequences (according to the model&#x2019;s padding side and padding
index) among:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum length of the returned list and optionally padding length (see above).`,name:"max_length"},{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>) &#x2014;
Activates truncation to cut input sequences longer than <em>max_length</em> to <em>max_length</em>.`,name:"truncation"},{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value.</p>
<p>This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta), or on TPUs which benefit from having sequence lengths be a multiple of 128.`,name:"pad_to_multiple_of"},{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return the attention mask. If left to the default, will return the attention mask according
to the specific feature_extractor&#x2019;s default.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Wav2Vec2 models that have set <code>config.feat_extract_norm == &quot;group&quot;</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">wav2vec2-base</a>, have <strong>not</strong> been trained using
<code>attention_mask</code>. For such models, <code>input_values</code> should simply be padded with 0 and no
<code>attention_mask</code> should be passed.</p>
<p>For Wav2Vec2 models that have set <code>config.feat_extract_norm == &quot;layer&quot;</code>, such as
<a href="https://huggingface.co/facebook/wav2vec2-large-960h-lv60-self" rel="nofollow">wav2vec2-lv60</a>, <code>attention_mask</code> should
be passed for batched inference.</p>

					</div>`,name:"return_attention_mask"},{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The sampling rate at which the <code>raw_speech</code> input was sampled. It is strongly recommended to pass
<code>sampling_rate</code> at the forward call to prevent silent errors.`,name:"sampling_rate"},{anchor:"transformers.Wav2Vec2FeatureExtractor.__call__.padding_value",description:"<strong>padding_value</strong> (<code>float</code>, defaults to 0.0) &#x2014;",name:"padding_value"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/feature_extraction_wav2vec2.py#L102"}}),so=new we({props:{title:"Wav2Vec2Processor",local:"transformers.Wav2Vec2Processor",headingTag:"h2"}}),lo=new F({props:{name:"class transformers.Wav2Vec2Processor",anchor:"transformers.Wav2Vec2Processor",parameters:[{name:"feature_extractor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2Processor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>Wav2Vec2FeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.Wav2Vec2Processor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
An instance of <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/processing_wav2vec2.py#L26"}}),io=new F({props:{name:"__call__",anchor:"transformers.Wav2Vec2Processor.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/processing_wav2vec2.py#L68"}}),Tt=new F({props:{name:"pad",anchor:"transformers.Wav2Vec2Processor.pad",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/processing_wav2vec2.py#L106"}}),co=new F({props:{name:"from_pretrained",anchor:"transformers.Wav2Vec2Processor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/processing_wav2vec2.py#L49"}}),po=new F({props:{name:"save_pretrained",anchor:"transformers.Wav2Vec2Processor.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2Processor.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.Wav2Vec2Processor.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.Wav2Vec2Processor.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L167"}}),mo=new vt({props:{$$slots:{default:[hs]},$$scope:{ctx:x}}}),Vt=new F({props:{name:"batch_decode",anchor:"transformers.Wav2Vec2Processor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/processing_wav2vec2.py#L136"}}),ho=new F({props:{name:"decode",anchor:"transformers.Wav2Vec2Processor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/processing_wav2vec2.py#L143"}}),Qe=new we({props:{title:"Wav2Vec2ProcessorWithLM",local:"transformers.Wav2Vec2ProcessorWithLM",headingTag:"h2"}}),Se=new F({props:{name:"class transformers.Wav2Vec2ProcessorWithLM",anchor:"transformers.Wav2Vec2ProcessorWithLM",parameters:[{name:"feature_extractor",val:": FeatureExtractionMixin"},{name:"tokenizer",val:": PreTrainedTokenizerBase"},{name:"decoder",val:": BeamSearchDecoderCTC"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ProcessorWithLM.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2FeatureExtractor">Wav2Vec2FeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a>. The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decoder",description:`<strong>decoder</strong> (<code>pyctcdecode.BeamSearchDecoderCTC</code>) &#x2014;
An instance of <code>pyctcdecode.BeamSearchDecoderCTC</code>. The decoder is a required input.`,name:"decoder"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2_with_lm/processing_wav2vec2_with_lm.py#L67"}}),De=new F({props:{name:"__call__",anchor:"transformers.Wav2Vec2ProcessorWithLM.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2_with_lm/processing_wav2vec2_with_lm.py#L214"}}),oa=new F({props:{name:"pad",anchor:"transformers.Wav2Vec2ProcessorWithLM.pad",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2_with_lm/processing_wav2vec2_with_lm.py#L253"}}),aa=new F({props:{name:"from_pretrained",anchor:"transformers.Wav2Vec2ProcessorWithLM.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Wav2Vec2ProcessorWithLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both <a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.SequenceFeatureExtractor">SequenceFeatureExtractor</a> and
<a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a></li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2_with_lm/processing_wav2vec2_with_lm.py#L113"}}),Ro=new vt({props:{$$slots:{default:[us]},$$scope:{ctx:x}}}),na=new F({props:{name:"save_pretrained",anchor:"transformers.Wav2Vec2ProcessorWithLM.save_pretrained",parameters:[{name:"save_directory",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2_with_lm/processing_wav2vec2_with_lm.py#L109"}}),sa=new F({props:{name:"batch_decode",anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode",parameters:[{name:"logits",val:": ndarray"},{name:"pool",val:": Optional = None"},{name:"num_processes",val:": Optional = None"},{name:"beam_width",val:": Optional = None"},{name:"beam_prune_logp",val:": Optional = None"},{name:"token_min_logp",val:": Optional = None"},{name:"hotwords",val:": Optional = None"},{name:"hotword_weight",val:": Optional = None"},{name:"alpha",val:": Optional = None"},{name:"beta",val:": Optional = None"},{name:"unk_score_offset",val:": Optional = None"},{name:"lm_score_boundary",val:": Optional = None"},{name:"output_word_offsets",val:": bool = False"},{name:"n_best",val:": int = 1"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.logits",description:`<strong>logits</strong> (<code>np.ndarray</code>) &#x2014;
The logits output vector of the model representing the log probabilities for each token.`,name:"logits"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.pool",description:`<strong>pool</strong> (<code>multiprocessing.Pool</code>, <em>optional</em>) &#x2014;
An optional user-managed pool. If not set, one will be automatically created and closed. The pool
should be instantiated <em>after</em> <code>Wav2Vec2ProcessorWithLM</code>. Otherwise, the LM won&#x2019;t be available to the
pool&#x2019;s sub-processes.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Currently, only pools created with a &#x2018;fork&#x2019; context can be used. If a &#x2018;spawn&#x2019; pool is passed, it will
be ignored and sequential decoding will be used instead.</p>

					</div>`,name:"pool"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.num_processes",description:`<strong>num_processes</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If <code>pool</code> is not set, number of processes on which the function should be parallelized over. Defaults
to the number of available CPUs.`,name:"num_processes"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.beam_width",description:`<strong>beam_width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of beams at each step in decoding. Defaults to pyctcdecode&#x2019;s DEFAULT_BEAM_WIDTH.`,name:"beam_width"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.beam_prune_logp",description:`<strong>beam_prune_logp</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Beams that are much worse than best beam will be pruned Defaults to pyctcdecode&#x2019;s DEFAULT_PRUNE_LOGP.`,name:"beam_prune_logp"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.token_min_logp",description:`<strong>token_min_logp</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Tokens below this logp are skipped unless they are argmax of frame Defaults to pyctcdecode&#x2019;s
DEFAULT_MIN_TOKEN_LOGP.`,name:"token_min_logp"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.hotwords",description:`<strong>hotwords</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of words with extra importance, can be OOV for LM`,name:"hotwords"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.hotword_weight",description:`<strong>hotword_weight</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Weight factor for hotword importance Defaults to pyctcdecode&#x2019;s DEFAULT_HOTWORD_WEIGHT.`,name:"hotword_weight"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.alpha",description:`<strong>alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Weight for language model during shallow fusion`,name:"alpha"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Weight for length score adjustment of during scoring`,name:"beta"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.unk_score_offset",description:`<strong>unk_score_offset</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Amount of log score offset for unknown tokens`,name:"unk_score_offset"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.lm_score_boundary",description:`<strong>lm_score_boundary</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to have kenlm respect boundaries when scoring`,name:"lm_score_boundary"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.output_word_offsets",description:`<strong>output_word_offsets</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to output word offsets. Word offsets can be used in combination with the sampling rate
and model downsampling rate to compute the time-stamps of transcribed words.`,name:"output_word_offsets"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.batch_decode.n_best",description:`<strong>n_best</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number of best hypotheses to return. If <code>n_best</code> is greater than 1, the returned <code>text</code> will be a list
of lists of strings, <code>logit_score</code> will be a list of lists of floats, and <code>lm_score</code> will be a list of
lists of floats, where the length of the outer list will correspond to the batch size and the length of
the inner list will correspond to the number of returned hypotheses . The value should be &gt;= 1.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Please take a look at the Example of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ProcessorWithLM.decode">decode()</a> to better understand how to
make use of <code>output_word_offsets</code>. <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ProcessorWithLM.batch_decode">batch_decode()</a> works the same way with
batched output.</p>

					</div>`,name:"n_best"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2_with_lm/processing_wav2vec2_with_lm.py#L284",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~models.wav2vec2.Wav2Vec2DecoderWithLMOutput</code>.</p>
`}}),No=new vt({props:{$$slots:{default:[fs]},$$scope:{ctx:x}}}),ra=new F({props:{name:"decode",anchor:"transformers.Wav2Vec2ProcessorWithLM.decode",parameters:[{name:"logits",val:": ndarray"},{name:"beam_width",val:": Optional = None"},{name:"beam_prune_logp",val:": Optional = None"},{name:"token_min_logp",val:": Optional = None"},{name:"hotwords",val:": Optional = None"},{name:"hotword_weight",val:": Optional = None"},{name:"alpha",val:": Optional = None"},{name:"beta",val:": Optional = None"},{name:"unk_score_offset",val:": Optional = None"},{name:"lm_score_boundary",val:": Optional = None"},{name:"output_word_offsets",val:": bool = False"},{name:"n_best",val:": int = 1"}],parametersDescription:[{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.logits",description:`<strong>logits</strong> (<code>np.ndarray</code>) &#x2014;
The logits output vector of the model representing the log probabilities for each token.`,name:"logits"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.beam_width",description:`<strong>beam_width</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of beams at each step in decoding. Defaults to pyctcdecode&#x2019;s DEFAULT_BEAM_WIDTH.`,name:"beam_width"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.beam_prune_logp",description:`<strong>beam_prune_logp</strong> (<code>int</code>, <em>optional</em>) &#x2014;
A threshold to prune beams with log-probs less than best_beam_logp + beam_prune_logp. The value should
be &lt;= 0. Defaults to pyctcdecode&#x2019;s DEFAULT_PRUNE_LOGP.`,name:"beam_prune_logp"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.token_min_logp",description:`<strong>token_min_logp</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Tokens with log-probs below token_min_logp are skipped unless they are have the maximum log-prob for an
utterance. Defaults to pyctcdecode&#x2019;s DEFAULT_MIN_TOKEN_LOGP.`,name:"token_min_logp"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.hotwords",description:`<strong>hotwords</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of words with extra importance which can be missing from the LM&#x2019;s vocabulary, e.g. [&#x201C;huggingface&#x201D;]`,name:"hotwords"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.hotword_weight",description:`<strong>hotword_weight</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Weight multiplier that boosts hotword scores. Defaults to pyctcdecode&#x2019;s DEFAULT_HOTWORD_WEIGHT.`,name:"hotword_weight"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.alpha",description:`<strong>alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Weight for language model during shallow fusion`,name:"alpha"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Weight for length score adjustment of during scoring`,name:"beta"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.unk_score_offset",description:`<strong>unk_score_offset</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Amount of log score offset for unknown tokens`,name:"unk_score_offset"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.lm_score_boundary",description:`<strong>lm_score_boundary</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to have kenlm respect boundaries when scoring`,name:"lm_score_boundary"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.output_word_offsets",description:`<strong>output_word_offsets</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to output word offsets. Word offsets can be used in combination with the sampling rate
and model downsampling rate to compute the time-stamps of transcribed words.`,name:"output_word_offsets"},{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.n_best",description:`<strong>n_best</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number of best hypotheses to return. If <code>n_best</code> is greater than 1, the returned <code>text</code> will be a list
of strings, <code>logit_score</code> will be a list of floats, and <code>lm_score</code> will be a list of floats, where the
length of these lists will correspond to the number of returned hypotheses. The value should be &gt;= 1.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>Please take a look at the example below to better understand how to make use of <code>output_word_offsets</code>.</p>

					</div>`,name:"n_best"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2_with_lm/processing_wav2vec2_with_lm.py#L469",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~models.wav2vec2.Wav2Vec2DecoderWithLMOutput</code>.</p>
`}}),qo=new Ct({props:{anchor:"transformers.Wav2Vec2ProcessorWithLM.decode.example",$$slots:{default:[gs]},$$scope:{ctx:x}}}),la=new we({props:{title:"Decoding multiple audios",local:"decoding-multiple-audios",headingTag:"h3"}}),ca=new kt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s see how to use a user-managed pool for batch decoding multiple audios</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> multiprocessing <span class="hljs-keyword">import</span> get_context
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoProcessor, AutoModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> datasets
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># import model, feature extractor, tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;patrickvonplaten/wav2vec2-base-100h-with-lm&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;patrickvonplaten/wav2vec2-base-100h-with-lm&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load example dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, datasets.Audio(sampling_rate=<span class="hljs-number">16_000</span>))


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = batch[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare speech data for batch inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(map_to_array, remove_columns=[<span class="hljs-string">&quot;audio&quot;</span>])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_pred</span>(<span class="hljs-params">batch, pool</span>):
<span class="hljs-meta">... </span>    inputs = processor(batch[<span class="hljs-string">&quot;speech&quot;</span>], sampling_rate=<span class="hljs-number">16_000</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>    inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        logits = model(**inputs).logits

<span class="hljs-meta">... </span>    transcription = processor.batch_decode(logits.cpu().numpy(), pool).text
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;transcription&quot;</span>] = transcription
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># note: pool should be instantiated *after* \`Wav2Vec2ProcessorWithLM\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment">#       otherwise, the LM won&#x27;t be available to the pool&#x27;s sub-processes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># select number of processes and batch_size based on number of CPU cores available and on dataset size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> get_context(<span class="hljs-string">&quot;fork&quot;</span>).Pool(processes=<span class="hljs-number">2</span>) <span class="hljs-keyword">as</span> pool:
<span class="hljs-meta">... </span>    result = dataset.<span class="hljs-built_in">map</span>(
<span class="hljs-meta">... </span>        map_to_pred, batched=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">2</span>, fn_kwargs={<span class="hljs-string">&quot;pool&quot;</span>: pool}, remove_columns=[<span class="hljs-string">&quot;speech&quot;</span>]
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">&gt;&gt;&gt; </span>result[<span class="hljs-string">&quot;transcription&quot;</span>][:<span class="hljs-number">2</span>]
[<span class="hljs-string">&#x27;MISTER QUILTER IS THE APOSTLE OF THE MIDDLE CLASSES AND WE ARE GLAD TO WELCOME HIS GOSPEL&#x27;</span>, <span class="hljs-string">&quot;NOR IS MISTER COULTER&#x27;S MANNER LESS INTERESTING THAN HIS MATTER&quot;</span>]`,wrap:!1}}),da=new we({props:{title:"Wav2Vec2 specific outputs",local:"transformers.models.wav2vec2_with_lm.processing_wav2vec2_with_lm.Wav2Vec2DecoderWithLMOutput",headingTag:"h2"}}),pa=new F({props:{name:"class transformers.models.wav2vec2_with_lm.processing_wav2vec2_with_lm.Wav2Vec2DecoderWithLMOutput",anchor:"transformers.models.wav2vec2_with_lm.processing_wav2vec2_with_lm.Wav2Vec2DecoderWithLMOutput",parameters:[{name:"text",val:": Union"},{name:"logit_score",val:": Union = None"},{name:"lm_score",val:": Union = None"},{name:"word_offsets",val:": Union = None"}],parametersDescription:[{anchor:"transformers.models.wav2vec2_with_lm.processing_wav2vec2_with_lm.Wav2Vec2DecoderWithLMOutput.text",description:`<strong>text</strong> (list of <code>str</code> or <code>str</code>) &#x2014;
Decoded logits in text from. Usually the speech transcription.`,name:"text"},{anchor:"transformers.models.wav2vec2_with_lm.processing_wav2vec2_with_lm.Wav2Vec2DecoderWithLMOutput.logit_score",description:`<strong>logit_score</strong> (list of <code>float</code> or <code>float</code>) &#x2014;
Total logit score of the beams associated with produced text.`,name:"logit_score"},{anchor:"transformers.models.wav2vec2_with_lm.processing_wav2vec2_with_lm.Wav2Vec2DecoderWithLMOutput.lm_score",description:`<strong>lm_score</strong> (list of <code>float</code>) &#x2014;
Fused lm_score of the beams associated with produced text.`,name:"lm_score"},{anchor:"transformers.models.wav2vec2_with_lm.processing_wav2vec2_with_lm.Wav2Vec2DecoderWithLMOutput.word_offsets",description:`<strong>word_offsets</strong> (list of <code>List[Dict[str, Union[int, str]]]</code> or <code>List[Dict[str, Union[int, str]]]</code>) &#x2014;
Offsets of the decoded words. In combination with sampling rate and model downsampling rate word offsets
can be used to compute time stamps for each word.`,name:"word_offsets"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2_with_lm/processing_wav2vec2_with_lm.py#L44"}}),ma=new F({props:{name:"class transformers.modeling_outputs.Wav2Vec2BaseModelOutput",anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"extract_features",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.extract_features",description:`<strong>extract_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, conv_dim[-1])</code>) &#x2014;
Sequence of extracted feature vectors of the last convolutional layer of the model.`,name:"extract_features"},{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/modeling_outputs.py#L1376"}}),ha=new F({props:{name:"class transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput",anchor:"transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"projected_states",val:": FloatTensor = None"},{name:"projected_quantized_states",val:": FloatTensor = None"},{name:"codevector_perplexity",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"contrastive_loss",val:": Optional = None"},{name:"diversity_loss",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput.loss",description:`<strong>loss</strong> (<em>optional</em>, returned when <code>sample_negative_indices</code> are passed, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) &#x2014;
Total loss as the sum of the contrastive loss (L_m) and the diversity loss (L_d) as stated in the <a href="https://arxiv.org/pdf/2006.11477.pdf" rel="nofollow">official
paper</a> . (classification) loss.`,name:"loss"},{anchor:"transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput.projected_states",description:`<strong>projected_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) &#x2014;
Hidden-states of the model projected to <em>config.proj_codevector_dim</em> that can be used to predict the masked
projected quantized states.`,name:"projected_states"},{anchor:"transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput.projected_quantized_states",description:`<strong>projected_quantized_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) &#x2014;
Quantized extracted feature vectors projected to <em>config.proj_codevector_dim</em> representing the positive
target vectors for contrastive loss.`,name:"projected_quantized_states"},{anchor:"transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput.contrastive_loss",description:`<strong>contrastive_loss</strong> (<em>optional</em>, returned when <code>sample_negative_indices</code> are passed, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) &#x2014;
The contrastive loss (L_m) as stated in the <a href="https://arxiv.org/pdf/2006.11477.pdf" rel="nofollow">official paper</a> .`,name:"contrastive_loss"},{anchor:"transformers.models.wav2vec2.modeling_wav2vec2.Wav2Vec2ForPreTrainingOutput.diversity_loss",description:`<strong>diversity_loss</strong> (<em>optional</em>, returned when <code>sample_negative_indices</code> are passed, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) &#x2014;
The diversity loss (L_d) as stated in the <a href="https://arxiv.org/pdf/2006.11477.pdf" rel="nofollow">official paper</a> .`,name:"diversity_loss"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_wav2vec2.py#L101"}}),ua=new F({props:{name:"class transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput",anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"extract_features",val:": Array = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput.extract_features",description:`<strong>extract_features</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, last_conv_dim)</code>) &#x2014;
Sequence of extracted feature vectors of the last convolutional layer of the model with <code>last_conv_dim</code>
being the dimension of the last convolutional layer.`,name:"extract_features"},{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_flax_wav2vec2.py#L44"}}),fa=new F({props:{name:"replace",anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2BaseModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),ga=new F({props:{name:"class transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput",anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput",parameters:[{name:"projected_states",val:": Array = None"},{name:"projected_quantized_states",val:": Array = None"},{name:"codevector_perplexity",val:": Array = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput.loss",description:`<strong>loss</strong> (<em>optional</em>, returned when model is in train mode, <code>jnp.ndarray</code> of shape <code>(1,)</code>) &#x2014;
Total loss as the sum of the contrastive loss (L_m) and the diversity loss (L_d) as stated in the <a href="https://arxiv.org/pdf/2006.11477.pdf" rel="nofollow">official
paper</a> . (classification) loss.`,name:"loss"},{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput.projected_states",description:`<strong>projected_states</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) &#x2014;
Hidden-states of the model projected to <em>config.proj_codevector_dim</em> that can be used to predict the masked
projected quantized states.`,name:"projected_states"},{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput.projected_quantized_states",description:`<strong>projected_quantized_states</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.proj_codevector_dim)</code>) &#x2014;
Quantized extracted feature vectors projected to <em>config.proj_codevector_dim</em> representing the positive
target vectors for contrastive loss.`,name:"projected_quantized_states"},{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/wav2vec2/modeling_flax_wav2vec2.py#L74"}}),_a=new F({props:{name:"replace",anchor:"transformers.models.wav2vec2.modeling_flax_wav2vec2.FlaxWav2Vec2ForPreTrainingOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),Lo=new ds({props:{pytorch:!0,tensorflow:!0,jax:!0,$$slots:{jax:[Qs],tensorflow:[Rs],pytorch:[Fs]},$$scope:{ctx:x}}}),{c(){e=c("meta"),y=s(),n=c("p"),l=s(),u(w.$$.fragment),o=s(),u(M.$$.fragment),Me=s(),B=c("p"),B.innerHTML=K,Te=s(),X=c("p"),X.textContent=ee,je=s(),W=c("p"),W.innerHTML=R,re=s(),Q=c("p"),Q.innerHTML=Qt,Ne=s(),u(Y.$$.fragment),Ze=s(),S=c("ul"),S.innerHTML=Ke,he=s(),u(Je.$$.fragment),I=s(),ue=c("p"),ue.textContent=le,fe=s(),u(ke.$$.fragment),ze=s(),z=c("ul"),z.innerHTML=et,Ie=s(),u(oe.$$.fragment),O=s(),ve=c("ul"),ve.innerHTML=ae,We=s(),tt=c("p"),tt.textContent=Be,ht=s(),ot=c("ul"),ot.innerHTML=xe,at=s(),u(be.$$.fragment),qe=s(),G=c("div"),u(ye.$$.fragment),N=s(),A=c("p"),A.innerHTML=It,Ce=s(),$e=c("p"),$e.innerHTML=$t,E=s(),u(Fe.$$.fragment),P=s(),u(Ve.$$.fragment),T=s(),V=c("div"),u(Z.$$.fragment),ne=s(),Ye=c("p"),Ye.textContent=D,ie=s(),bt=c("p"),bt.innerHTML=Bt,Xt=s(),Wt=c("div"),u(nt.$$.fragment),Gt=s(),Rt=c("p"),Rt.textContent=Nt,He=s(),st=c("div"),u(rt.$$.fragment),qt=s(),Le=c("div"),u(ge.$$.fragment),Xe=s(),Ft=c("p"),Ft.textContent=lt,to=s(),it=c("p"),it.innerHTML=yt,ce=s(),u(de.$$.fragment),St=s(),k=c("div"),u(U.$$.fragment),Ee=s(),L=c("p"),L.textContent=ut,pe=s(),te=c("div"),u(Yt.$$.fragment),Qo=s(),Ht=c("p"),Ht.textContent=La,Bo=s(),u(Ge.$$.fragment),At=s(),ft=c("div"),u(Ut.$$.fragment),wa=s(),bo=c("p"),bo.textContent=oo,So=s(),xt=c("p"),xt.innerHTML=Ao,ao=s(),Lt=c("div"),u(me.$$.fragment),no=s(),yo=c("p"),yo.textContent=Jo,Do=s(),u(so.$$.fragment),ro=s(),se=c("div"),u(lo.$$.fragment),wo=s(),Co=c("p"),Co.textContent=Ma,Mo=s(),$o=c("p"),$o.innerHTML=Ta,wt=s(),Mt=c("div"),u(io.$$.fragment),To=s(),Fo=c("p"),Fo.innerHTML=ja,Dt=s(),Ot=c("div"),u(Tt.$$.fragment),Xo=s(),Zt=c("p"),Zt.innerHTML=Oo,Pe=s(),zt=c("div"),u(co.$$.fragment),jo=s(),Et=c("div"),u(po.$$.fragment),ko=s(),Uo=c("p"),Uo.innerHTML=ka,Wo=s(),u(mo.$$.fragment),Ko=s(),Ue=c("div"),u(Vt.$$.fragment),ea=s(),Pt=c("p"),Pt.innerHTML=Ea,ta=s(),gt=c("div"),u(ho.$$.fragment),Kt=s(),uo=c("p"),uo.innerHTML=m,J=s(),u(Qe.$$.fragment),Re=s(),q=c("div"),u(Se.$$.fragment),Ae=s(),ct=c("p"),ct.textContent=dt,Jt=s(),_e=c("div"),u(De.$$.fragment),_t=s(),pt=c("p"),pt.innerHTML=Pa,Wa=s(),Go=c("div"),u(oa.$$.fragment),wn=s(),xa=c("p"),xa.innerHTML=Yn,Mn=s(),xo=c("div"),u(aa.$$.fragment),Tn=s(),Va=c("p"),Va.innerHTML=Hn,jn=s(),u(Ro.$$.fragment),kn=s(),Ja=c("div"),u(na.$$.fragment),Wn=s(),eo=c("div"),u(sa.$$.fragment),xn=s(),Ca=c("p"),Ca.textContent=Ln,Vn=s(),u(No.$$.fragment),Jn=s(),$a=c("p"),$a.innerHTML=En,Cn=s(),Vo=c("div"),u(ra.$$.fragment),$n=s(),Fa=c("p"),Fa.textContent=Pn,Fn=s(),u(qo.$$.fragment),Aa=s(),u(la.$$.fragment),Da=s(),ia=c("p"),ia.innerHTML=Qn,Oa=s(),u(ca.$$.fragment),Ka=s(),u(da.$$.fragment),en=s(),Zo=c("div"),u(pa.$$.fragment),Un=s(),Ua=c("p"),Ua.innerHTML=Sn,tn=s(),zo=c("div"),u(ma.$$.fragment),Zn=s(),Za=c("p"),Za.textContent=An,on=s(),Io=c("div"),u(ha.$$.fragment),zn=s(),za=c("p"),za.innerHTML=Dn,an=s(),fo=c("div"),u(ua.$$.fragment),In=s(),Ia=c("p"),Ia.innerHTML=On,Bn=s(),Yo=c("div"),u(fa.$$.fragment),Xn=s(),Ba=c("p"),Ba.textContent=Kn,nn=s(),go=c("div"),u(ga.$$.fragment),Gn=s(),Xa=c("p"),Xa.innerHTML=es,Rn=s(),Ho=c("div"),u(_a.$$.fragment),Nn=s(),Ga=c("p"),Ga.textContent=ts,sn=s(),u(Lo.$$.fragment),rn=s(),Qa=c("p"),this.h()},l(t){const j=cs("svelte-u9bgzb",document.head);e=d(j,"META",{name:!0,content:!0}),j.forEach(i),y=r(t),n=d(t,"P",{}),C(n).forEach(i),l=r(t),f(w.$$.fragment,t),o=r(t),f(M.$$.fragment,t),Me=r(t),B=d(t,"P",{"data-svelte-h":!0}),h(B)!=="svelte-1an18c0"&&(B.innerHTML=K),Te=r(t),X=d(t,"P",{"data-svelte-h":!0}),h(X)!=="svelte-vfdo9a"&&(X.textContent=ee),je=r(t),W=d(t,"P",{"data-svelte-h":!0}),h(W)!=="svelte-11lu23i"&&(W.innerHTML=R),re=r(t),Q=d(t,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1t6iyb9"&&(Q.innerHTML=Qt),Ne=r(t),f(Y.$$.fragment,t),Ze=r(t),S=d(t,"UL",{"data-svelte-h":!0}),h(S)!=="svelte-15bmgs8"&&(S.innerHTML=Ke),he=r(t),f(Je.$$.fragment,t),I=r(t),ue=d(t,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-x9q80l"&&(ue.textContent=le),fe=r(t),f(ke.$$.fragment,t),ze=r(t),z=d(t,"UL",{"data-svelte-h":!0}),h(z)!=="svelte-v956il"&&(z.innerHTML=et),Ie=r(t),f(oe.$$.fragment,t),O=r(t),ve=d(t,"UL",{"data-svelte-h":!0}),h(ve)!=="svelte-k10sov"&&(ve.innerHTML=ae),We=r(t),tt=d(t,"P",{"data-svelte-h":!0}),h(tt)!=="svelte-lk14e4"&&(tt.textContent=Be),ht=r(t),ot=d(t,"UL",{"data-svelte-h":!0}),h(ot)!=="svelte-wbd9h3"&&(ot.innerHTML=xe),at=r(t),f(be.$$.fragment,t),qe=r(t),G=d(t,"DIV",{class:!0});var _o=C(G);f(ye.$$.fragment,_o),N=r(_o),A=d(_o,"P",{"data-svelte-h":!0}),h(A)!=="svelte-xd7oth"&&(A.innerHTML=It),Ce=r(_o),$e=d(_o,"P",{"data-svelte-h":!0}),h($e)!=="svelte-o55m63"&&($e.innerHTML=$t),E=r(_o),f(Fe.$$.fragment,_o),_o.forEach(i),P=r(t),f(Ve.$$.fragment,t),T=r(t),V=d(t,"DIV",{class:!0});var Oe=C(V);f(Z.$$.fragment,Oe),ne=r(Oe),Ye=d(Oe,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-gxvlja"&&(Ye.textContent=D),ie=r(Oe),bt=d(Oe,"P",{"data-svelte-h":!0}),h(bt)!=="svelte-1tlp8g2"&&(bt.innerHTML=Bt),Xt=r(Oe),Wt=d(Oe,"DIV",{class:!0});var va=C(Wt);f(nt.$$.fragment,va),Gt=r(va),Rt=d(va,"P",{"data-svelte-h":!0}),h(Rt)!=="svelte-kpxj0c"&&(Rt.textContent=Nt),va.forEach(i),He=r(Oe),st=d(Oe,"DIV",{class:!0});var Sa=C(st);f(rt.$$.fragment,Sa),Sa.forEach(i),qt=r(Oe),Le=d(Oe,"DIV",{class:!0});var vo=C(Le);f(ge.$$.fragment,vo),Xe=r(vo),Ft=d(vo,"P",{"data-svelte-h":!0}),h(Ft)!=="svelte-vbfkpu"&&(Ft.textContent=lt),to=r(vo),it=d(vo,"P",{"data-svelte-h":!0}),h(it)!=="svelte-125uxon"&&(it.innerHTML=yt),ce=r(vo),f(de.$$.fragment,vo),vo.forEach(i),St=r(Oe),k=d(Oe,"DIV",{class:!0});var ba=C(k);f(U.$$.fragment,ba),Ee=r(ba),L=d(ba,"P",{"data-svelte-h":!0}),h(L)!=="svelte-1deng2j"&&(L.textContent=ut),ba.forEach(i),pe=r(Oe),te=d(Oe,"DIV",{class:!0});var ya=C(te);f(Yt.$$.fragment,ya),Qo=r(ya),Ht=d(ya,"P",{"data-svelte-h":!0}),h(Ht)!=="svelte-1cp5sz1"&&(Ht.textContent=La),ya.forEach(i),Oe.forEach(i),Bo=r(t),f(Ge.$$.fragment,t),At=r(t),ft=d(t,"DIV",{class:!0});var Eo=C(ft);f(Ut.$$.fragment,Eo),wa=r(Eo),bo=d(Eo,"P",{"data-svelte-h":!0}),h(bo)!=="svelte-10lmbzj"&&(bo.textContent=oo),So=r(Eo),xt=d(Eo,"P",{"data-svelte-h":!0}),h(xt)!=="svelte-3gz575"&&(xt.innerHTML=Ao),ao=r(Eo),Lt=d(Eo,"DIV",{class:!0});var cn=C(Lt);f(me.$$.fragment,cn),no=r(cn),yo=d(cn,"P",{"data-svelte-h":!0}),h(yo)!=="svelte-1a6wgfx"&&(yo.textContent=Jo),cn.forEach(i),Eo.forEach(i),Do=r(t),f(so.$$.fragment,t),ro=r(t),se=d(t,"DIV",{class:!0});var mt=C(se);f(lo.$$.fragment,mt),wo=r(mt),Co=d(mt,"P",{"data-svelte-h":!0}),h(Co)!=="svelte-2ag3qy"&&(Co.textContent=Ma),Mo=r(mt),$o=d(mt,"P",{"data-svelte-h":!0}),h($o)!=="svelte-1tei9vm"&&($o.innerHTML=Ta),wt=r(mt),Mt=d(mt,"DIV",{class:!0});var dn=C(Mt);f(io.$$.fragment,dn),To=r(dn),Fo=d(dn,"P",{"data-svelte-h":!0}),h(Fo)!=="svelte-12jtark"&&(Fo.innerHTML=ja),dn.forEach(i),Dt=r(mt),Ot=d(mt,"DIV",{class:!0});var pn=C(Ot);f(Tt.$$.fragment,pn),Xo=r(pn),Zt=d(pn,"P",{"data-svelte-h":!0}),h(Zt)!=="svelte-1cr3zei"&&(Zt.innerHTML=Oo),pn.forEach(i),Pe=r(mt),zt=d(mt,"DIV",{class:!0});var os=C(zt);f(co.$$.fragment,os),os.forEach(i),jo=r(mt),Et=d(mt,"DIV",{class:!0});var Ra=C(Et);f(po.$$.fragment,Ra),ko=r(Ra),Uo=d(Ra,"P",{"data-svelte-h":!0}),h(Uo)!=="svelte-hvkzav"&&(Uo.innerHTML=ka),Wo=r(Ra),f(mo.$$.fragment,Ra),Ra.forEach(i),Ko=r(mt),Ue=d(mt,"DIV",{class:!0});var mn=C(Ue);f(Vt.$$.fragment,mn),ea=r(mn),Pt=d(mn,"P",{"data-svelte-h":!0}),h(Pt)!=="svelte-oplyi9"&&(Pt.innerHTML=Ea),mn.forEach(i),ta=r(mt),gt=d(mt,"DIV",{class:!0});var hn=C(gt);f(ho.$$.fragment,hn),Kt=r(hn),uo=d(hn,"P",{"data-svelte-h":!0}),h(uo)!=="svelte-1vvtk2v"&&(uo.innerHTML=m),hn.forEach(i),mt.forEach(i),J=r(t),f(Qe.$$.fragment,t),Re=r(t),q=d(t,"DIV",{class:!0});var jt=C(q);f(Se.$$.fragment,jt),Ae=r(jt),ct=d(jt,"P",{"data-svelte-h":!0}),h(ct)!=="svelte-tn9a17"&&(ct.textContent=dt),Jt=r(jt),_e=d(jt,"DIV",{class:!0});var un=C(_e);f(De.$$.fragment,un),_t=r(un),pt=d(un,"P",{"data-svelte-h":!0}),h(pt)!=="svelte-160vhkm"&&(pt.innerHTML=Pa),un.forEach(i),Wa=r(jt),Go=d(jt,"DIV",{class:!0});var fn=C(Go);f(oa.$$.fragment,fn),wn=r(fn),xa=d(fn,"P",{"data-svelte-h":!0}),h(xa)!=="svelte-140d9lq"&&(xa.innerHTML=Yn),fn.forEach(i),Mn=r(jt),xo=d(jt,"DIV",{class:!0});var Na=C(xo);f(aa.$$.fragment,Na),Tn=r(Na),Va=d(Na,"P",{"data-svelte-h":!0}),h(Va)!=="svelte-1endixv"&&(Va.innerHTML=Hn),jn=r(Na),f(Ro.$$.fragment,Na),Na.forEach(i),kn=r(jt),Ja=d(jt,"DIV",{class:!0});var as=C(Ja);f(na.$$.fragment,as),as.forEach(i),Wn=r(jt),eo=d(jt,"DIV",{class:!0});var Po=C(eo);f(sa.$$.fragment,Po),xn=r(Po),Ca=d(Po,"P",{"data-svelte-h":!0}),h(Ca)!=="svelte-1xixice"&&(Ca.textContent=Ln),Vn=r(Po),f(No.$$.fragment,Po),Jn=r(Po),$a=d(Po,"P",{"data-svelte-h":!0}),h($a)!=="svelte-1g4be31"&&($a.innerHTML=En),Po.forEach(i),Cn=r(jt),Vo=d(jt,"DIV",{class:!0});var qa=C(Vo);f(ra.$$.fragment,qa),$n=r(qa),Fa=d(qa,"P",{"data-svelte-h":!0}),h(Fa)!=="svelte-1e03u9y"&&(Fa.textContent=Pn),Fn=r(qa),f(qo.$$.fragment,qa),qa.forEach(i),jt.forEach(i),Aa=r(t),f(la.$$.fragment,t),Da=r(t),ia=d(t,"P",{"data-svelte-h":!0}),h(ia)!=="svelte-zjid7d"&&(ia.innerHTML=Qn),Oa=r(t),f(ca.$$.fragment,t),Ka=r(t),f(da.$$.fragment,t),en=r(t),Zo=d(t,"DIV",{class:!0});var gn=C(Zo);f(pa.$$.fragment,gn),Un=r(gn),Ua=d(gn,"P",{"data-svelte-h":!0}),h(Ua)!=="svelte-amzs60"&&(Ua.innerHTML=Sn),gn.forEach(i),tn=r(t),zo=d(t,"DIV",{class:!0});var _n=C(zo);f(ma.$$.fragment,_n),Zn=r(_n),Za=d(_n,"P",{"data-svelte-h":!0}),h(Za)!=="svelte-1tmia4b"&&(Za.textContent=An),_n.forEach(i),on=r(t),Io=d(t,"DIV",{class:!0});var vn=C(Io);f(ha.$$.fragment,vn),zn=r(vn),za=d(vn,"P",{"data-svelte-h":!0}),h(za)!=="svelte-9z8jpr"&&(za.innerHTML=Dn),vn.forEach(i),an=r(t),fo=d(t,"DIV",{class:!0});var Ya=C(fo);f(ua.$$.fragment,Ya),In=r(Ya),Ia=d(Ya,"P",{"data-svelte-h":!0}),h(Ia)!=="svelte-11w6tdr"&&(Ia.innerHTML=On),Bn=r(Ya),Yo=d(Ya,"DIV",{class:!0});var bn=C(Yo);f(fa.$$.fragment,bn),Xn=r(bn),Ba=d(bn,"P",{"data-svelte-h":!0}),h(Ba)!=="svelte-5ihtpa"&&(Ba.textContent=Kn),bn.forEach(i),Ya.forEach(i),nn=r(t),go=d(t,"DIV",{class:!0});var Ha=C(go);f(ga.$$.fragment,Ha),Gn=r(Ha),Xa=d(Ha,"P",{"data-svelte-h":!0}),h(Xa)!=="svelte-ldrfqp"&&(Xa.innerHTML=es),Rn=r(Ha),Ho=d(Ha,"DIV",{class:!0});var yn=C(Ho);f(_a.$$.fragment,yn),Nn=r(yn),Ga=d(yn,"P",{"data-svelte-h":!0}),h(Ga)!=="svelte-5ihtpa"&&(Ga.textContent=ts),yn.forEach(i),Ha.forEach(i),sn=r(t),f(Lo.$$.fragment,t),rn=r(t),Qa=d(t,"P",{}),C(Qa).forEach(i),this.h()},h(){$(e,"name","hf:doc:metadata"),$(e,"content",As),$(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Go,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(xo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Ja,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(eo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Vo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Zo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(zo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Io,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Yo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(fo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Ho,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(go,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,j){a(document.head,e),p(t,y,j),p(t,n,j),p(t,l,j),g(w,t,j),p(t,o,j),g(M,t,j),p(t,Me,j),p(t,B,j),p(t,Te,j),p(t,X,j),p(t,je,j),p(t,W,j),p(t,re,j),p(t,Q,j),p(t,Ne,j),g(Y,t,j),p(t,Ze,j),p(t,S,j),p(t,he,j),g(Je,t,j),p(t,I,j),p(t,ue,j),p(t,fe,j),g(ke,t,j),p(t,ze,j),p(t,z,j),p(t,Ie,j),g(oe,t,j),p(t,O,j),p(t,ve,j),p(t,We,j),p(t,tt,j),p(t,ht,j),p(t,ot,j),p(t,at,j),g(be,t,j),p(t,qe,j),p(t,G,j),g(ye,G,null),a(G,N),a(G,A),a(G,Ce),a(G,$e),a(G,E),g(Fe,G,null),p(t,P,j),g(Ve,t,j),p(t,T,j),p(t,V,j),g(Z,V,null),a(V,ne),a(V,Ye),a(V,ie),a(V,bt),a(V,Xt),a(V,Wt),g(nt,Wt,null),a(Wt,Gt),a(Wt,Rt),a(V,He),a(V,st),g(rt,st,null),a(V,qt),a(V,Le),g(ge,Le,null),a(Le,Xe),a(Le,Ft),a(Le,to),a(Le,it),a(Le,ce),g(de,Le,null),a(V,St),a(V,k),g(U,k,null),a(k,Ee),a(k,L),a(V,pe),a(V,te),g(Yt,te,null),a(te,Qo),a(te,Ht),p(t,Bo,j),g(Ge,t,j),p(t,At,j),p(t,ft,j),g(Ut,ft,null),a(ft,wa),a(ft,bo),a(ft,So),a(ft,xt),a(ft,ao),a(ft,Lt),g(me,Lt,null),a(Lt,no),a(Lt,yo),p(t,Do,j),g(so,t,j),p(t,ro,j),p(t,se,j),g(lo,se,null),a(se,wo),a(se,Co),a(se,Mo),a(se,$o),a(se,wt),a(se,Mt),g(io,Mt,null),a(Mt,To),a(Mt,Fo),a(se,Dt),a(se,Ot),g(Tt,Ot,null),a(Ot,Xo),a(Ot,Zt),a(se,Pe),a(se,zt),g(co,zt,null),a(se,jo),a(se,Et),g(po,Et,null),a(Et,ko),a(Et,Uo),a(Et,Wo),g(mo,Et,null),a(se,Ko),a(se,Ue),g(Vt,Ue,null),a(Ue,ea),a(Ue,Pt),a(se,ta),a(se,gt),g(ho,gt,null),a(gt,Kt),a(gt,uo),p(t,J,j),g(Qe,t,j),p(t,Re,j),p(t,q,j),g(Se,q,null),a(q,Ae),a(q,ct),a(q,Jt),a(q,_e),g(De,_e,null),a(_e,_t),a(_e,pt),a(q,Wa),a(q,Go),g(oa,Go,null),a(Go,wn),a(Go,xa),a(q,Mn),a(q,xo),g(aa,xo,null),a(xo,Tn),a(xo,Va),a(xo,jn),g(Ro,xo,null),a(q,kn),a(q,Ja),g(na,Ja,null),a(q,Wn),a(q,eo),g(sa,eo,null),a(eo,xn),a(eo,Ca),a(eo,Vn),g(No,eo,null),a(eo,Jn),a(eo,$a),a(q,Cn),a(q,Vo),g(ra,Vo,null),a(Vo,$n),a(Vo,Fa),a(Vo,Fn),g(qo,Vo,null),p(t,Aa,j),g(la,t,j),p(t,Da,j),p(t,ia,j),p(t,Oa,j),g(ca,t,j),p(t,Ka,j),g(da,t,j),p(t,en,j),p(t,Zo,j),g(pa,Zo,null),a(Zo,Un),a(Zo,Ua),p(t,tn,j),p(t,zo,j),g(ma,zo,null),a(zo,Zn),a(zo,Za),p(t,on,j),p(t,Io,j),g(ha,Io,null),a(Io,zn),a(Io,za),p(t,an,j),p(t,fo,j),g(ua,fo,null),a(fo,In),a(fo,Ia),a(fo,Bn),a(fo,Yo),g(fa,Yo,null),a(Yo,Xn),a(Yo,Ba),p(t,nn,j),p(t,go,j),g(ga,go,null),a(go,Gn),a(go,Xa),a(go,Rn),a(go,Ho),g(_a,Ho,null),a(Ho,Nn),a(Ho,Ga),p(t,sn,j),g(Lo,t,j),p(t,rn,j),p(t,Qa,j),ln=!0},p(t,[j]){const _o={};j&2&&(_o.$$scope={dirty:j,ctx:t}),Fe.$set(_o);const Oe={};j&2&&(Oe.$$scope={dirty:j,ctx:t}),de.$set(Oe);const va={};j&2&&(va.$$scope={dirty:j,ctx:t}),mo.$set(va);const Sa={};j&2&&(Sa.$$scope={dirty:j,ctx:t}),Ro.$set(Sa);const vo={};j&2&&(vo.$$scope={dirty:j,ctx:t}),No.$set(vo);const ba={};j&2&&(ba.$$scope={dirty:j,ctx:t}),qo.$set(ba);const ya={};j&2&&(ya.$$scope={dirty:j,ctx:t}),Lo.$set(ya)},i(t){ln||(_(w.$$.fragment,t),_(M.$$.fragment,t),_(Y.$$.fragment,t),_(Je.$$.fragment,t),_(ke.$$.fragment,t),_(oe.$$.fragment,t),_(be.$$.fragment,t),_(ye.$$.fragment,t),_(Fe.$$.fragment,t),_(Ve.$$.fragment,t),_(Z.$$.fragment,t),_(nt.$$.fragment,t),_(rt.$$.fragment,t),_(ge.$$.fragment,t),_(de.$$.fragment,t),_(U.$$.fragment,t),_(Yt.$$.fragment,t),_(Ge.$$.fragment,t),_(Ut.$$.fragment,t),_(me.$$.fragment,t),_(so.$$.fragment,t),_(lo.$$.fragment,t),_(io.$$.fragment,t),_(Tt.$$.fragment,t),_(co.$$.fragment,t),_(po.$$.fragment,t),_(mo.$$.fragment,t),_(Vt.$$.fragment,t),_(ho.$$.fragment,t),_(Qe.$$.fragment,t),_(Se.$$.fragment,t),_(De.$$.fragment,t),_(oa.$$.fragment,t),_(aa.$$.fragment,t),_(Ro.$$.fragment,t),_(na.$$.fragment,t),_(sa.$$.fragment,t),_(No.$$.fragment,t),_(ra.$$.fragment,t),_(qo.$$.fragment,t),_(la.$$.fragment,t),_(ca.$$.fragment,t),_(da.$$.fragment,t),_(pa.$$.fragment,t),_(ma.$$.fragment,t),_(ha.$$.fragment,t),_(ua.$$.fragment,t),_(fa.$$.fragment,t),_(ga.$$.fragment,t),_(_a.$$.fragment,t),_(Lo.$$.fragment,t),ln=!0)},o(t){v(w.$$.fragment,t),v(M.$$.fragment,t),v(Y.$$.fragment,t),v(Je.$$.fragment,t),v(ke.$$.fragment,t),v(oe.$$.fragment,t),v(be.$$.fragment,t),v(ye.$$.fragment,t),v(Fe.$$.fragment,t),v(Ve.$$.fragment,t),v(Z.$$.fragment,t),v(nt.$$.fragment,t),v(rt.$$.fragment,t),v(ge.$$.fragment,t),v(de.$$.fragment,t),v(U.$$.fragment,t),v(Yt.$$.fragment,t),v(Ge.$$.fragment,t),v(Ut.$$.fragment,t),v(me.$$.fragment,t),v(so.$$.fragment,t),v(lo.$$.fragment,t),v(io.$$.fragment,t),v(Tt.$$.fragment,t),v(co.$$.fragment,t),v(po.$$.fragment,t),v(mo.$$.fragment,t),v(Vt.$$.fragment,t),v(ho.$$.fragment,t),v(Qe.$$.fragment,t),v(Se.$$.fragment,t),v(De.$$.fragment,t),v(oa.$$.fragment,t),v(aa.$$.fragment,t),v(Ro.$$.fragment,t),v(na.$$.fragment,t),v(sa.$$.fragment,t),v(No.$$.fragment,t),v(ra.$$.fragment,t),v(qo.$$.fragment,t),v(la.$$.fragment,t),v(ca.$$.fragment,t),v(da.$$.fragment,t),v(pa.$$.fragment,t),v(ma.$$.fragment,t),v(ha.$$.fragment,t),v(ua.$$.fragment,t),v(fa.$$.fragment,t),v(ga.$$.fragment,t),v(_a.$$.fragment,t),v(Lo.$$.fragment,t),ln=!1},d(t){t&&(i(y),i(n),i(l),i(o),i(Me),i(B),i(Te),i(X),i(je),i(W),i(re),i(Q),i(Ne),i(Ze),i(S),i(he),i(I),i(ue),i(fe),i(ze),i(z),i(Ie),i(O),i(ve),i(We),i(tt),i(ht),i(ot),i(at),i(qe),i(G),i(P),i(T),i(V),i(Bo),i(At),i(ft),i(Do),i(ro),i(se),i(J),i(Re),i(q),i(Aa),i(Da),i(ia),i(Oa),i(Ka),i(en),i(Zo),i(tn),i(zo),i(on),i(Io),i(an),i(fo),i(nn),i(go),i(sn),i(rn),i(Qa)),i(e),b(w,t),b(M,t),b(Y,t),b(Je,t),b(ke,t),b(oe,t),b(be,t),b(ye),b(Fe),b(Ve,t),b(Z),b(nt),b(rt),b(ge),b(de),b(U),b(Yt),b(Ge,t),b(Ut),b(me),b(so,t),b(lo),b(io),b(Tt),b(co),b(po),b(mo),b(Vt),b(ho),b(Qe,t),b(Se),b(De),b(oa),b(aa),b(Ro),b(na),b(sa),b(No),b(ra),b(qo),b(la,t),b(ca,t),b(da,t),b(pa),b(ma),b(ha),b(ua),b(fa),b(ga),b(_a),b(Lo,t)}}}const As='{"title":"Wav2Vec2","local":"wav2vec2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Wav2Vec2Config","local":"transformers.Wav2Vec2Config","sections":[],"depth":2},{"title":"Wav2Vec2CTCTokenizer","local":"transformers.Wav2Vec2CTCTokenizer","sections":[],"depth":2},{"title":"Wav2Vec2FeatureExtractor","local":"transformers.Wav2Vec2FeatureExtractor","sections":[],"depth":2},{"title":"Wav2Vec2Processor","local":"transformers.Wav2Vec2Processor","sections":[],"depth":2},{"title":"Wav2Vec2ProcessorWithLM","local":"transformers.Wav2Vec2ProcessorWithLM","sections":[{"title":"Decoding multiple audios","local":"decoding-multiple-audios","sections":[],"depth":3}],"depth":2},{"title":"Wav2Vec2 specific outputs","local":"transformers.models.wav2vec2_with_lm.processing_wav2vec2_with_lm.Wav2Vec2DecoderWithLMOutput","sections":[],"depth":2},{"title":"Wav2Vec2Model","local":"transformers.Wav2Vec2Model","sections":[],"depth":2},{"title":"Wav2Vec2ForCTC","local":"transformers.Wav2Vec2ForCTC","sections":[],"depth":2},{"title":"Wav2Vec2ForSequenceClassification","local":"transformers.Wav2Vec2ForSequenceClassification","sections":[],"depth":2},{"title":"Wav2Vec2ForAudioFrameClassification","local":"transformers.Wav2Vec2ForAudioFrameClassification","sections":[],"depth":2},{"title":"Wav2Vec2ForXVector","local":"transformers.Wav2Vec2ForXVector","sections":[],"depth":2},{"title":"Wav2Vec2ForPreTraining","local":"transformers.Wav2Vec2ForPreTraining","sections":[],"depth":2},{"title":"TFWav2Vec2Model","local":"transformers.TFWav2Vec2Model","sections":[],"depth":2},{"title":"TFWav2Vec2ForSequenceClassification","local":"transformers.TFWav2Vec2ForSequenceClassification","sections":[],"depth":2},{"title":"TFWav2Vec2ForCTC","local":"transformers.TFWav2Vec2ForCTC","sections":[],"depth":2},{"title":"FlaxWav2Vec2Model","local":"transformers.FlaxWav2Vec2Model","sections":[],"depth":2},{"title":"FlaxWav2Vec2ForCTC","local":"transformers.FlaxWav2Vec2ForCTC","sections":[],"depth":2},{"title":"FlaxWav2Vec2ForPreTraining","local":"transformers.FlaxWav2Vec2ForPreTraining","sections":[],"depth":2}],"depth":1}';function Ds(x){return rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lr extends ls{constructor(e){super(),is(this,e,Ds,Ss,ss,{})}}export{lr as component};
