import{s as Cn,n as Hn,o as Rn}from"../chunks/scheduler.0219f8bd.js";import{S as Ln,i as wn,g as s,s as o,r as p,A as Fn,h as n,f as l,c as d,j as a,u as c,x as r,k as u,y as An,a as i,v as f,d as h,t as m,w as b}from"../chunks/index.f61edf3b.js";import{H as g,E as En}from"../chunks/getInferenceSnippets.8735cf23.js";function jn(Qd){let _,il,tl,ol,$,dl,T,sl,v,Xd='Utility functions to interact with the Hugging Face Hub (<a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>)',nl,P,Zd='<li><a href="#module_utils/hub">utils/hub</a><ul><li><em>static</em><ul><li><a href="#module_utils/hub.getFile"><code>.getFile(urlOrPath)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response)&gt;</code></li> <li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options], [return_path])</code></a> ⇒ <code>Promise.&lt;(string|Uint8Array)&gt;</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li> <li><a href="#module_utils/hub.getModelFile..buffer"><code>~buffer</code></a> : <code>Uint8Array</code></li></ul></li> <li><a href="#module_utils/hub.getModelText"><code>.getModelText(modelPath, fileName, [fatal], [options])</code></a> ⇒ <code>Promise.&lt;(string|null)&gt;</code></li> <li><a href="#module_utils/hub.getModelJSON"><code>.getModelJSON(modelPath, fileName, [fatal], [options])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response, [progress_callback])</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li> <li><a href="#module_utils/hub..CONTENT_TYPE_MAP"><code>~CONTENT_TYPE_MAP</code></a></li> <li><a href="#module_utils/hub..isValidUrl"><code>~isValidUrl(string, [protocols], [validHosts])</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/hub..isValidHfModelId"><code>~isValidHfModelId(string)</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/hub..handleError"><code>~handleError(status, remoteURL, fatal)</code></a> ⇒ <code>null</code></li> <li><a href="#module_utils/hub..tryCache"><code>~tryCache(cache, ...names)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code></li> <li><a href="#module_utils/hub..readResponse"><code>~readResponse(response, progress_callback)</code></a> ⇒ <code>Promise.&lt;Uint8Array&gt;</code></li> <li><a href="#module_utils/hub..pathJoin"><code>~pathJoin(...parts)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/hub..ExternalData"><code>~ExternalData</code></a> : <code>boolean</code> | <code>number</code></li> <li><a href="#module_utils/hub..PretrainedOptions"><code>~PretrainedOptions</code></a> : <code>Object</code></li> <li><a href="#module_utils/hub..ModelSpecificPretrainedOptions"><code>~ModelSpecificPretrainedOptions</code></a> : <code>Object</code></li> <li><a href="#module_utils/hub..PretrainedModelOptions"><code>~PretrainedModelOptions</code></a> : <code>*</code></li></ul></li></ul></li>',rl,ul,al,y,pl,M,cl,x,es="Helper function to get a file, using either the Fetch API or FileSystem API.",fl,C,ts='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response)&gt;</code> - A promise that resolves to a FileResponse object (if the file is retrieved using the FileSystem API), or a Response object (if the file is retrieved using the Fetch API).',hl,H,ls="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>urlOrPath</td><td><code>URL</code> | <code>string</code></td><td><p>The URL/path of the file to get.</p></td></tr></tbody>",ml,bl,gl,R,_l,L,$l,w,is=`Retrieves a file from either a remote URL using the Fetch API or from the local file system using the FileSystem API.
If the filesystem is available and <code>env.useCache = true</code>, the file will be downloaded and cached.`,Tl,F,os='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(string|Uint8Array)&gt;</code> - A Promise that resolves with the file content as a Uint8Array if <code>return_path</code> is false, or the file path as a string if <code>return_path</code> is true.<br/> <strong>Throws</strong>:',vl,A,ds="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",Pl,E,ss="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>path_or_repo_id</td><td><code>string</code></td><td></td><td><p>This can be either:</p> <ul><li>a string, the <em>model id</em> of a model repo on huggingface.co.</li> <li>a path to a <em>directory</em> potentially containing the file.</li></ul></td> </tr><tr><td>filename</td><td><code>string</code></td><td></td><td><p>The name of the file to locate in <code>path_or_repo</code>.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td> </tr><tr><td>[return_path]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to return the path of the file instead of the file content.</p></td></tr></tbody>",yl,j,ns='<li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options], [return_path])</code></a> ⇒ <code>Promise.&lt;(string|Uint8Array)&gt;</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li> <li><a href="#module_utils/hub.getModelFile..buffer"><code>~buffer</code></a> : <code>Uint8Array</code></li></ul></li>',Ml,xl,Cl,O,Hl,U,Rl,B,rs='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',Ll,wl,Fl,K,Al,I,El,k,us='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',jl,Ol,Ul,D,Bl,N,Kl,q,as='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',Il,kl,Dl,S,Nl,z,ql,J,ps="Fetches a text file from a given path and file name.",Sl,W,cs='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(string|null)&gt;</code> - The text content of the file.<br/> <strong>Throws</strong>:',zl,V,fs="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",Jl,Y,hs="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>modelPath</td><td><code>string</code></td><td></td><td><p>The path to the directory containing the file.</p></td> </tr><tr><td>fileName</td><td><code>string</code></td><td></td><td><p>The name of the file to fetch.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td></tr></tbody>",Wl,Vl,Yl,G,Gl,Q,Ql,X,ms="Fetches a JSON file from a given path and file name.",Xl,Z,bs='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - The JSON data parsed into a JavaScript object.<br/> <strong>Throws</strong>:',Zl,ee,gs="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",ei,te,_s="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>modelPath</td><td><code>string</code></td><td></td><td><p>The path to the directory containing the file.</p></td> </tr><tr><td>fileName</td><td><code>string</code></td><td></td><td><p>The name of the file to fetch.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td></tr></tbody>",ti,li,ii,le,oi,ie,di,oe,$s='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',si,de,Ts='<li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',ni,ri,ui,se,ai,ne,pi,re,vs="Creates a new <code>FileResponse</code> object.",ci,ue,Ps="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>filePath</td><td><code>string</code></td></tr></tbody>",fi,hi,mi,ae,bi,pe,gi,ce,ys=`Updates the ‘content-type’ header property of the response based on the extension of
the file specified by the filePath property of the current object.`,_i,fe,Ms='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a>',$i,Ti,vi,he,Pi,me,yi,be,xs="Clone the current FileResponse object.",Mi,ge,Cs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>FileResponse</code> - A new FileResponse object with the same properties as the current object.',xi,Ci,Hi,_e,Ri,$e,Li,Te,Hs=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with an ArrayBuffer containing the file’s contents.`,wi,ve,Rs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ArrayBuffer&gt;</code> - A Promise that resolves with an ArrayBuffer containing the file’s contents.<br/> <strong>Throws</strong>:',Fi,Pe,Ls="<li><code>Error</code> If the file cannot be read.</li>",Ai,Ei,ji,ye,Oi,Me,Ui,xe,ws=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a Blob containing the file’s contents.`,Bi,Ce,Fs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Blob&gt;</code> - A Promise that resolves with a Blob containing the file’s contents.<br/> <strong>Throws</strong>:',Ki,He,As="<li><code>Error</code> If the file cannot be read.</li>",Ii,ki,Di,Re,Ni,Le,qi,we,Es=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a string containing the file’s contents.`,Si,Fe,js='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;string&gt;</code> - A Promise that resolves with a string containing the file’s contents.<br/> <strong>Throws</strong>:',zi,Ae,Os="<li><code>Error</code> If the file cannot be read.</li>",Ji,Wi,Vi,Ee,Yi,je,Gi,Oe,Us=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a parsed JavaScript object containing the file’s contents.`,Qi,Ue,Bs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - A Promise that resolves with a parsed JavaScript object containing the file’s contents.<br/> <strong>Throws</strong>:',Xi,Be,Ks="<li><code>Error</code> If the file cannot be read.</li>",Zi,eo,to,Ke,lo,Ie,io,ke,Is='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',oo,De,ks='<li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response, [progress_callback])</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li>',so,no,ro,Ne,uo,qe,ao,Se,Ds="Instantiate a <code>FileCache</code> object.",po,ze,Ns="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td></tr></tbody>",co,fo,ho,Je,mo,We,bo,Ve,qs="Checks whether the given request is in the cache.",go,Ye,Ss='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',_o,Ge,zs="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td></tr></tbody>",$o,To,vo,Qe,Po,Xe,yo,Ze,Js="Adds the given response to the cache.",Mo,et,Ws='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',xo,tt,Vs=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td><td></td> </tr><tr><td>response</td><td><code>Response</code></td><td></td> </tr><tr><td>[progress_callback]</td><td><code>*</code></td><td><p>Optional.
The function to call with progress updates</p></td></tr></tbody>`,Co,Ho,Ro,lt,Lo,it,wo,ot,Ys="Mapping from file extensions to MIME types.",Fo,dt,Gs='<strong>Kind</strong>: inner constant of <a href="#module_utils/hub"><code>utils/hub</code></a>',Ao,Eo,jo,st,Oo,nt,Uo,rt,Qs="Determines whether the given string is a valid URL.",Bo,ut,Xs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - True if the string is a valid URL, false otherwise.',Ko,at,Zs="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>string</td><td><code>string</code> | <code>URL</code></td><td></td><td><p>The string to test for validity as an URL.</p></td> </tr><tr><td>[protocols]</td><td><code>Array.&lt;string&gt;</code></td><td><code></code></td><td><p>A list of valid protocols. If specified, the protocol must be in this list.</p></td> </tr><tr><td>[validHosts]</td><td><code>Array.&lt;string&gt;</code></td><td><code></code></td><td><p>A list of valid hostnames. If specified, the URL&#39;s hostname must be in this list.</p></td></tr></tbody>",Io,ko,Do,pt,No,ct,qo,ft,en=`Tests whether a string is a valid Hugging Face model ID or not.
Adapted from <a href="https://github.com/huggingface/huggingface_hub/blob/6378820ebb03f071988a96c7f3268f5bdf8f9449/src/huggingface_hub/utils/_validators.py#L119-L170" rel="nofollow">https://github.com/huggingface/huggingface_hub/blob/6378820ebb03f071988a96c7f3268f5bdf8f9449/src/huggingface_hub/utils/_validators.py#L119-L170</a>`,So,ht,tn='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - True if the string is a valid model ID, false otherwise.',zo,mt,ln="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>string</td><td><code>string</code></td><td><p>The string to test</p></td></tr></tbody>",Jo,Wo,Vo,bt,Yo,gt,Go,_t,on="Helper method to handle fatal errors that occur while trying to load a file from the Hugging Face Hub.",Qo,$t,dn='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>null</code> - Returns <code>null</code> if <code>fatal = true</code>.<br/> <strong>Throws</strong>:',Xo,Tt,sn="<li><code>Error</code> If `fatal = false`.</li>",Zo,vt,nn="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>status</td><td><code>number</code></td><td><p>The HTTP status code of the error.</p></td> </tr><tr><td>remoteURL</td><td><code>string</code></td><td><p>The URL of the file that could not be loaded.</p></td> </tr><tr><td>fatal</td><td><code>boolean</code></td><td><p>Whether to raise an error if the file could not be loaded.</p></td></tr></tbody>",ed,td,ld,Pt,id,yt,od,Mt,rn='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code> - The item from the cache, or undefined if not found.',dd,xt,un="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>cache</td><td><code>FileCache</code> | <code>Cache</code></td><td><p>The cache to search</p></td> </tr><tr><td>...names</td><td><code>Array.&lt;string&gt;</code></td><td><p>The names of the item to search for</p></td></tr></tbody>",sd,nd,rd,Ct,ud,Ht,ad,Rt,an="Read and track progress when reading a Response object",pd,Lt,pn='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Uint8Array&gt;</code> - A Promise that resolves with the Uint8Array buffer',cd,wt,cn="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>response</td><td><code>Response</code> | <code>FileResponse</code></td><td><p>The Response object to read</p></td> </tr><tr><td>progress_callback</td><td><code>*</code></td><td><p>The function to call with progress updates</p></td></tr></tbody>",fd,hd,md,Ft,bd,At,gd,Et,fn="Joins multiple parts of a path into a single path, while handling leading and trailing slashes.",_d,jt,hn='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>string</code> - A string representing the joined path.',$d,Ot,mn="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...parts</td><td><code>string</code></td><td><p>Multiple parts of a path.</p></td></tr></tbody>",Td,vd,Pd,Ut,yd,Bt,Md,Kt,bn=`Whether to load the model using the external data format (used for models &gt;= 2GB in size).
If <code>true</code>, the model will be loaded using the external data format.
If a number, this many chunks will be loaded using the external data format (of the form: “model.onnx<em>data[</em>{chunk_number}]”).`,xd,It,gn='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a>',Cd,Hd,Rd,kt,Ld,Dt,wd,Nt,_n="Options for loading a pretrained model.",Fd,qt,$n='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Properties</strong>',Ad,St,Tn=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[progress_callback]</td><td><code>*</code></td><td><code></code></td><td><p>If specified, this function will be called during model construction, to provide the user with progress updates.</p></td> </tr><tr><td>[config]</td><td><code>*</code></td><td><code></code></td><td><p>Configuration for the model to use instead of an automatically loaded configuration. Configuration can be automatically loaded when:</p> <ul><li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained model).</li> <li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a configuration JSON file named <em>config.json</em> is found in the directory.</li></ul></td> </tr><tr><td>[cache_dir]</td><td><code>string</code></td><td><code>null</code></td><td><p>Path to a directory in which a downloaded pretrained model configuration should be cached if the standard cache should not be used.</p></td> </tr><tr><td>[local_files_only]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to only look at local files (e.g., not try downloading the model).</p></td> </tr><tr><td>[revision]</td><td><code>string</code></td><td><code>&quot;&#39;main&#39;&quot;</code></td><td><p>The specific model version to use. It can be a branch name, a tag name, or a commit id,
since we use a git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier allowed by git.
NOTE: This setting is ignored for local requests.</p></td></tr></tbody>`,Ed,jd,Od,zt,Ud,Jt,Bd,Wt,vn="Options for loading a pretrained model.",Kd,Vt,Pn='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Properties</strong>',Id,Yt,yn=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[subfolder]</td><td><code>string</code></td><td><code>&quot;&#39;onnx&#39;&quot;</code></td><td><p>In case the relevant files are located inside a subfolder of the model repo on huggingface.co,
you can specify the folder name here.</p></td> </tr><tr><td>[model_file_name]</td><td><code>string</code></td><td><code>null</code></td><td><p>If specified, load the model with this name (excluding the .onnx suffix). Currently only valid for encoder- or decoder-only models.</p></td> </tr><tr><td>[device]</td><td><code>*</code></td><td><code></code></td><td><p>The device to run the model on. If not specified, the device will be chosen from the environment settings.</p></td> </tr><tr><td>[dtype]</td><td><code>*</code></td><td><code></code></td><td><p>The data type to use for the model. If not specified, the data type will be chosen from the environment settings.</p></td> </tr><tr><td>[use_external_data_format]</td><td><code>ExternalData</code> | <code>Record&lt;string, ExternalData&gt;</code></td><td><code>false</code></td><td><p>Whether to load the model using the external data format (used for models &gt;= 2GB in size).</p></td> </tr><tr><td>[session_options]</td><td><code>*</code></td><td></td><td><p>(Optional) User-specified session options passed to the runtime. If not provided, suitable defaults will be chosen.</p></td></tr></tbody>`,kd,Dd,Nd,Gt,qd,Qt,Sd,Xt,Mn="Options for loading a pretrained model.",zd,Zt,xn='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a>',Jd,Wd,Vd,el,Yd,ll,Gd;return T=new g({props:{title:"utils/hub",local:"utilshub",headingTag:"h1"}}),M=new g({props:{title:"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>",local:"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code",headingTag:"h2"}}),L=new g({props:{title:"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options], [return_path]) ⇒ <code> Promise. < (string|Uint8Array) > </code>",local:"utilshubgetmodelfilepathorrepoid-filename-fatal-options-returnpath--code-promise--stringuint8array--code",headingTag:"h2"}}),U=new g({props:{title:"getModelFile~cacheKey : <code> string </code>",local:"getmodelfilecachekey--code-string-code",headingTag:"h3"}}),I=new g({props:{title:"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>",local:"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code",headingTag:"h3"}}),N=new g({props:{title:"getModelFile~buffer : <code> Uint8Array </code>",local:"getmodelfilebuffer--code-uint8array-code",headingTag:"h3"}}),z=new g({props:{title:"utils/hub.getModelText(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < (string|null) > </code>",local:"utilshubgetmodeltextmodelpath-filename-fatal-options--code-promise--stringnull--code",headingTag:"h2"}}),Q=new g({props:{title:"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>",local:"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code",headingTag:"h2"}}),ie=new g({props:{title:"utils/hub~FileResponse",local:"utilshubfileresponse",headingTag:"h2"}}),ne=new g({props:{title:"new FileResponse(filePath)",local:"new-fileresponsefilepath",headingTag:"h3"}}),pe=new g({props:{title:"fileResponse.updateContentType() ⇒ <code> void </code>",local:"fileresponseupdatecontenttype--code-void-code",headingTag:"h3"}}),me=new g({props:{title:"fileResponse.clone() ⇒ <code> FileResponse </code>",local:"fileresponseclone--code-fileresponse-code",headingTag:"h3"}}),$e=new g({props:{title:"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>",local:"fileresponsearraybuffer--code-promise--arraybuffer--code",headingTag:"h3"}}),Me=new g({props:{title:"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>",local:"fileresponseblob--code-promise--blob--code",headingTag:"h3"}}),Le=new g({props:{title:"fileResponse.text() ⇒ <code> Promise. < string > </code>",local:"fileresponsetext--code-promise--string--code",headingTag:"h3"}}),je=new g({props:{title:"fileResponse.json() ⇒ <code> Promise. < Object > </code>",local:"fileresponsejson--code-promise--object--code",headingTag:"h3"}}),Ie=new g({props:{title:"utils/hub~FileCache",local:"utilshubfilecache",headingTag:"h2"}}),qe=new g({props:{title:"new FileCache(path)",local:"new-filecachepath",headingTag:"h3"}}),We=new g({props:{title:"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>",local:"filecachematchrequest--code-promise--fileresponseundefined--code",headingTag:"h3"}}),Xe=new g({props:{title:"fileCache.put(request, response, [progress_callback]) ⇒ <code> Promise. < void > </code>",local:"filecacheputrequest-response-progresscallback--code-promise--void--code",headingTag:"h3"}}),it=new g({props:{title:"utils/hub~CONTENT_TYPE_MAP",local:"utilshubcontenttypemap",headingTag:"h2"}}),nt=new g({props:{title:"utils/hub~isValidUrl(string, [protocols], [validHosts]) ⇒ <code> boolean </code>",local:"utilshubisvalidurlstring-protocols-validhosts--code-boolean-code",headingTag:"h2"}}),ct=new g({props:{title:"utils/hub~isValidHfModelId(string) ⇒ <code> boolean </code>",local:"utilshubisvalidhfmodelidstring--code-boolean-code",headingTag:"h2"}}),gt=new g({props:{title:"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>",local:"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code",headingTag:"h2"}}),yt=new g({props:{title:"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>",local:"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code",headingTag:"h2"}}),Ht=new g({props:{title:"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>",local:"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code",headingTag:"h2"}}),At=new g({props:{title:"utils/hub~pathJoin(...parts) ⇒ <code> string </code>",local:"utilshubpathjoinparts--code-string-code",headingTag:"h2"}}),Bt=new g({props:{title:"utils/hub~ExternalData : <code> boolean </code> | <code> number </code>",local:"utilshubexternaldata--code-boolean-code--code-number-code",headingTag:"h2"}}),Dt=new g({props:{title:"utils/hub~PretrainedOptions : <code> Object </code>",local:"utilshubpretrainedoptions--code-object-code",headingTag:"h2"}}),Jt=new g({props:{title:"utils/hub~ModelSpecificPretrainedOptions : <code> Object </code>",local:"utilshubmodelspecificpretrainedoptions--code-object-code",headingTag:"h2"}}),Qt=new g({props:{title:"utils/hub~PretrainedModelOptions : <code> * </code>",local:"utilshubpretrainedmodeloptions--code--code",headingTag:"h2"}}),el=new En({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/hub.md"}}),{c(){_=s("meta"),il=o(),tl=s("p"),ol=o(),$=s("a"),dl=o(),p(T.$$.fragment),sl=o(),v=s("p"),v.innerHTML=Xd,nl=o(),P=s("ul"),P.innerHTML=Zd,rl=o(),ul=s("hr"),al=o(),y=s("a"),pl=o(),p(M.$$.fragment),cl=o(),x=s("p"),x.textContent=es,fl=o(),C=s("p"),C.innerHTML=ts,hl=o(),H=s("table"),H.innerHTML=ls,ml=o(),bl=s("hr"),gl=o(),R=s("a"),_l=o(),p(L.$$.fragment),$l=o(),w=s("p"),w.innerHTML=is,Tl=o(),F=s("p"),F.innerHTML=os,vl=o(),A=s("ul"),A.innerHTML=ds,Pl=o(),E=s("table"),E.innerHTML=ss,yl=o(),j=s("ul"),j.innerHTML=ns,Ml=o(),xl=s("hr"),Cl=o(),O=s("a"),Hl=o(),p(U.$$.fragment),Rl=o(),B=s("p"),B.innerHTML=rs,Ll=o(),wl=s("hr"),Fl=o(),K=s("a"),Al=o(),p(I.$$.fragment),El=o(),k=s("p"),k.innerHTML=us,jl=o(),Ol=s("hr"),Ul=o(),D=s("a"),Bl=o(),p(N.$$.fragment),Kl=o(),q=s("p"),q.innerHTML=as,Il=o(),kl=s("hr"),Dl=o(),S=s("a"),Nl=o(),p(z.$$.fragment),ql=o(),J=s("p"),J.textContent=ps,Sl=o(),W=s("p"),W.innerHTML=cs,zl=o(),V=s("ul"),V.innerHTML=fs,Jl=o(),Y=s("table"),Y.innerHTML=hs,Wl=o(),Vl=s("hr"),Yl=o(),G=s("a"),Gl=o(),p(Q.$$.fragment),Ql=o(),X=s("p"),X.textContent=ms,Xl=o(),Z=s("p"),Z.innerHTML=bs,Zl=o(),ee=s("ul"),ee.innerHTML=gs,ei=o(),te=s("table"),te.innerHTML=_s,ti=o(),li=s("hr"),ii=o(),le=s("a"),oi=o(),p(ie.$$.fragment),di=o(),oe=s("p"),oe.innerHTML=$s,si=o(),de=s("ul"),de.innerHTML=Ts,ni=o(),ri=s("hr"),ui=o(),se=s("a"),ai=o(),p(ne.$$.fragment),pi=o(),re=s("p"),re.innerHTML=vs,ci=o(),ue=s("table"),ue.innerHTML=Ps,fi=o(),hi=s("hr"),mi=o(),ae=s("a"),bi=o(),p(pe.$$.fragment),gi=o(),ce=s("p"),ce.textContent=ys,_i=o(),fe=s("p"),fe.innerHTML=Ms,$i=o(),Ti=s("hr"),vi=o(),he=s("a"),Pi=o(),p(me.$$.fragment),yi=o(),be=s("p"),be.textContent=xs,Mi=o(),ge=s("p"),ge.innerHTML=Cs,xi=o(),Ci=s("hr"),Hi=o(),_e=s("a"),Ri=o(),p($e.$$.fragment),Li=o(),Te=s("p"),Te.textContent=Hs,wi=o(),ve=s("p"),ve.innerHTML=Rs,Fi=o(),Pe=s("ul"),Pe.innerHTML=Ls,Ai=o(),Ei=s("hr"),ji=o(),ye=s("a"),Oi=o(),p(Me.$$.fragment),Ui=o(),xe=s("p"),xe.textContent=ws,Bi=o(),Ce=s("p"),Ce.innerHTML=Fs,Ki=o(),He=s("ul"),He.innerHTML=As,Ii=o(),ki=s("hr"),Di=o(),Re=s("a"),Ni=o(),p(Le.$$.fragment),qi=o(),we=s("p"),we.textContent=Es,Si=o(),Fe=s("p"),Fe.innerHTML=js,zi=o(),Ae=s("ul"),Ae.innerHTML=Os,Ji=o(),Wi=s("hr"),Vi=o(),Ee=s("a"),Yi=o(),p(je.$$.fragment),Gi=o(),Oe=s("p"),Oe.textContent=Us,Qi=o(),Ue=s("p"),Ue.innerHTML=Bs,Xi=o(),Be=s("ul"),Be.innerHTML=Ks,Zi=o(),eo=s("hr"),to=o(),Ke=s("a"),lo=o(),p(Ie.$$.fragment),io=o(),ke=s("p"),ke.innerHTML=Is,oo=o(),De=s("ul"),De.innerHTML=ks,so=o(),no=s("hr"),ro=o(),Ne=s("a"),uo=o(),p(qe.$$.fragment),ao=o(),Se=s("p"),Se.innerHTML=Ds,po=o(),ze=s("table"),ze.innerHTML=Ns,co=o(),fo=s("hr"),ho=o(),Je=s("a"),mo=o(),p(We.$$.fragment),bo=o(),Ve=s("p"),Ve.textContent=qs,go=o(),Ye=s("p"),Ye.innerHTML=Ss,_o=o(),Ge=s("table"),Ge.innerHTML=zs,$o=o(),To=s("hr"),vo=o(),Qe=s("a"),Po=o(),p(Xe.$$.fragment),yo=o(),Ze=s("p"),Ze.textContent=Js,Mo=o(),et=s("p"),et.innerHTML=Ws,xo=o(),tt=s("table"),tt.innerHTML=Vs,Co=o(),Ho=s("hr"),Ro=o(),lt=s("a"),Lo=o(),p(it.$$.fragment),wo=o(),ot=s("p"),ot.textContent=Ys,Fo=o(),dt=s("p"),dt.innerHTML=Gs,Ao=o(),Eo=s("hr"),jo=o(),st=s("a"),Oo=o(),p(nt.$$.fragment),Uo=o(),rt=s("p"),rt.textContent=Qs,Bo=o(),ut=s("p"),ut.innerHTML=Xs,Ko=o(),at=s("table"),at.innerHTML=Zs,Io=o(),ko=s("hr"),Do=o(),pt=s("a"),No=o(),p(ct.$$.fragment),qo=o(),ft=s("p"),ft.innerHTML=en,So=o(),ht=s("p"),ht.innerHTML=tn,zo=o(),mt=s("table"),mt.innerHTML=ln,Jo=o(),Wo=s("hr"),Vo=o(),bt=s("a"),Yo=o(),p(gt.$$.fragment),Go=o(),_t=s("p"),_t.textContent=on,Qo=o(),$t=s("p"),$t.innerHTML=dn,Xo=o(),Tt=s("ul"),Tt.innerHTML=sn,Zo=o(),vt=s("table"),vt.innerHTML=nn,ed=o(),td=s("hr"),ld=o(),Pt=s("a"),id=o(),p(yt.$$.fragment),od=o(),Mt=s("p"),Mt.innerHTML=rn,dd=o(),xt=s("table"),xt.innerHTML=un,sd=o(),nd=s("hr"),rd=o(),Ct=s("a"),ud=o(),p(Ht.$$.fragment),ad=o(),Rt=s("p"),Rt.textContent=an,pd=o(),Lt=s("p"),Lt.innerHTML=pn,cd=o(),wt=s("table"),wt.innerHTML=cn,fd=o(),hd=s("hr"),md=o(),Ft=s("a"),bd=o(),p(At.$$.fragment),gd=o(),Et=s("p"),Et.textContent=fn,_d=o(),jt=s("p"),jt.innerHTML=hn,$d=o(),Ot=s("table"),Ot.innerHTML=mn,Td=o(),vd=s("hr"),Pd=o(),Ut=s("a"),yd=o(),p(Bt.$$.fragment),Md=o(),Kt=s("p"),Kt.innerHTML=bn,xd=o(),It=s("p"),It.innerHTML=gn,Cd=o(),Hd=s("hr"),Rd=o(),kt=s("a"),Ld=o(),p(Dt.$$.fragment),wd=o(),Nt=s("p"),Nt.textContent=_n,Fd=o(),qt=s("p"),qt.innerHTML=$n,Ad=o(),St=s("table"),St.innerHTML=Tn,Ed=o(),jd=s("hr"),Od=o(),zt=s("a"),Ud=o(),p(Jt.$$.fragment),Bd=o(),Wt=s("p"),Wt.textContent=vn,Kd=o(),Vt=s("p"),Vt.innerHTML=Pn,Id=o(),Yt=s("table"),Yt.innerHTML=yn,kd=o(),Dd=s("hr"),Nd=o(),Gt=s("a"),qd=o(),p(Qt.$$.fragment),Sd=o(),Xt=s("p"),Xt.textContent=Mn,zd=o(),Zt=s("p"),Zt.innerHTML=xn,Jd=o(),Wd=s("hr"),Vd=o(),p(el.$$.fragment),Yd=o(),ll=s("p"),this.h()},l(e){const t=Fn("svelte-u9bgzb",document.head);_=n(t,"META",{name:!0,content:!0}),t.forEach(l),il=d(e),tl=n(e,"P",{}),a(tl).forEach(l),ol=d(e),$=n(e,"A",{id:!0,class:!0}),a($).forEach(l),dl=d(e),c(T.$$.fragment,e),sl=d(e),v=n(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1jxl61c"&&(v.innerHTML=Xd),nl=d(e),P=n(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-h32g5a"&&(P.innerHTML=Zd),rl=d(e),ul=n(e,"HR",{}),al=d(e),y=n(e,"A",{id:!0,class:!0}),a(y).forEach(l),pl=d(e),c(M.$$.fragment,e),cl=d(e),x=n(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-10mshiw"&&(x.textContent=es),fl=d(e),C=n(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1jj7eze"&&(C.innerHTML=ts),hl=d(e),H=n(e,"TABLE",{"data-svelte-h":!0}),r(H)!=="svelte-pbwhgs"&&(H.innerHTML=ls),ml=d(e),bl=n(e,"HR",{}),gl=d(e),R=n(e,"A",{id:!0,class:!0}),a(R).forEach(l),_l=d(e),c(L.$$.fragment,e),$l=d(e),w=n(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1l3bjq3"&&(w.innerHTML=is),Tl=d(e),F=n(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1j9rqit"&&(F.innerHTML=os),vl=d(e),A=n(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-jl6z4b"&&(A.innerHTML=ds),Pl=d(e),E=n(e,"TABLE",{"data-svelte-h":!0}),r(E)!=="svelte-bcbvl9"&&(E.innerHTML=ss),yl=d(e),j=n(e,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-1g40dlc"&&(j.innerHTML=ns),Ml=d(e),xl=n(e,"HR",{}),Cl=d(e),O=n(e,"A",{id:!0,class:!0}),a(O).forEach(l),Hl=d(e),c(U.$$.fragment,e),Rl=d(e),B=n(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ys3w38"&&(B.innerHTML=rs),Ll=d(e),wl=n(e,"HR",{}),Fl=d(e),K=n(e,"A",{id:!0,class:!0}),a(K).forEach(l),Al=d(e),c(I.$$.fragment,e),El=d(e),k=n(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1ys3w38"&&(k.innerHTML=us),jl=d(e),Ol=n(e,"HR",{}),Ul=d(e),D=n(e,"A",{id:!0,class:!0}),a(D).forEach(l),Bl=d(e),c(N.$$.fragment,e),Kl=d(e),q=n(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1ys3w38"&&(q.innerHTML=as),Il=d(e),kl=n(e,"HR",{}),Dl=d(e),S=n(e,"A",{id:!0,class:!0}),a(S).forEach(l),Nl=d(e),c(z.$$.fragment,e),ql=d(e),J=n(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-csw6h7"&&(J.textContent=ps),Sl=d(e),W=n(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-130mlcm"&&(W.innerHTML=cs),zl=d(e),V=n(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-jl6z4b"&&(V.innerHTML=fs),Jl=d(e),Y=n(e,"TABLE",{"data-svelte-h":!0}),r(Y)!=="svelte-1iel3tk"&&(Y.innerHTML=hs),Wl=d(e),Vl=n(e,"HR",{}),Yl=d(e),G=n(e,"A",{id:!0,class:!0}),a(G).forEach(l),Gl=d(e),c(Q.$$.fragment,e),Ql=d(e),X=n(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1en2wh4"&&(X.textContent=ms),Xl=d(e),Z=n(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1l5qo0i"&&(Z.innerHTML=bs),Zl=d(e),ee=n(e,"UL",{"data-svelte-h":!0}),r(ee)!=="svelte-jl6z4b"&&(ee.innerHTML=gs),ei=d(e),te=n(e,"TABLE",{"data-svelte-h":!0}),r(te)!=="svelte-1iel3tk"&&(te.innerHTML=_s),ti=d(e),li=n(e,"HR",{}),ii=d(e),le=n(e,"A",{id:!0,class:!0}),a(le).forEach(l),oi=d(e),c(ie.$$.fragment,e),di=d(e),oe=n(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-16uuos4"&&(oe.innerHTML=$s),si=d(e),de=n(e,"UL",{"data-svelte-h":!0}),r(de)!=="svelte-olh855"&&(de.innerHTML=Ts),ni=d(e),ri=n(e,"HR",{}),ui=d(e),se=n(e,"A",{id:!0,class:!0}),a(se).forEach(l),ai=d(e),c(ne.$$.fragment,e),pi=d(e),re=n(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-zzl0lp"&&(re.innerHTML=vs),ci=d(e),ue=n(e,"TABLE",{"data-svelte-h":!0}),r(ue)!=="svelte-19a8ff4"&&(ue.innerHTML=Ps),fi=d(e),hi=n(e,"HR",{}),mi=d(e),ae=n(e,"A",{id:!0,class:!0}),a(ae).forEach(l),bi=d(e),c(pe.$$.fragment,e),gi=d(e),ce=n(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1u1tjx3"&&(ce.textContent=ys),_i=d(e),fe=n(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1sowe6d"&&(fe.innerHTML=Ms),$i=d(e),Ti=n(e,"HR",{}),vi=d(e),he=n(e,"A",{id:!0,class:!0}),a(he).forEach(l),Pi=d(e),c(me.$$.fragment,e),yi=d(e),be=n(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-d8j2xp"&&(be.textContent=xs),Mi=d(e),ge=n(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-8jlahc"&&(ge.innerHTML=Cs),xi=d(e),Ci=n(e,"HR",{}),Hi=d(e),_e=n(e,"A",{id:!0,class:!0}),a(_e).forEach(l),Ri=d(e),c($e.$$.fragment,e),Li=d(e),Te=n(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1a8fecx"&&(Te.textContent=Hs),wi=d(e),ve=n(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-v2f2ae"&&(ve.innerHTML=Rs),Fi=d(e),Pe=n(e,"UL",{"data-svelte-h":!0}),r(Pe)!=="svelte-1f4f3jw"&&(Pe.innerHTML=Ls),Ai=d(e),Ei=n(e,"HR",{}),ji=d(e),ye=n(e,"A",{id:!0,class:!0}),a(ye).forEach(l),Oi=d(e),c(Me.$$.fragment,e),Ui=d(e),xe=n(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-h3zv97"&&(xe.textContent=ws),Bi=d(e),Ce=n(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1e723py"&&(Ce.innerHTML=Fs),Ki=d(e),He=n(e,"UL",{"data-svelte-h":!0}),r(He)!=="svelte-1f4f3jw"&&(He.innerHTML=As),Ii=d(e),ki=n(e,"HR",{}),Di=d(e),Re=n(e,"A",{id:!0,class:!0}),a(Re).forEach(l),Ni=d(e),c(Le.$$.fragment,e),qi=d(e),we=n(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-jd4zuh"&&(we.textContent=Es),Si=d(e),Fe=n(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-1ozy582"&&(Fe.innerHTML=js),zi=d(e),Ae=n(e,"UL",{"data-svelte-h":!0}),r(Ae)!=="svelte-1f4f3jw"&&(Ae.innerHTML=Os),Ji=d(e),Wi=n(e,"HR",{}),Vi=d(e),Ee=n(e,"A",{id:!0,class:!0}),a(Ee).forEach(l),Yi=d(e),c(je.$$.fragment,e),Gi=d(e),Oe=n(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-cd4397"&&(Oe.textContent=Us),Qi=d(e),Ue=n(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-j83voe"&&(Ue.innerHTML=Bs),Xi=d(e),Be=n(e,"UL",{"data-svelte-h":!0}),r(Be)!=="svelte-1f4f3jw"&&(Be.innerHTML=Ks),Zi=d(e),eo=n(e,"HR",{}),to=d(e),Ke=n(e,"A",{id:!0,class:!0}),a(Ke).forEach(l),lo=d(e),c(Ie.$$.fragment,e),io=d(e),ke=n(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-16uuos4"&&(ke.innerHTML=Is),oo=d(e),De=n(e,"UL",{"data-svelte-h":!0}),r(De)!=="svelte-13rgwxm"&&(De.innerHTML=ks),so=d(e),no=n(e,"HR",{}),ro=d(e),Ne=n(e,"A",{id:!0,class:!0}),a(Ne).forEach(l),uo=d(e),c(qe.$$.fragment,e),ao=d(e),Se=n(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-pake4r"&&(Se.innerHTML=Ds),po=d(e),ze=n(e,"TABLE",{"data-svelte-h":!0}),r(ze)!=="svelte-f03x1m"&&(ze.innerHTML=Ns),co=d(e),fo=n(e,"HR",{}),ho=d(e),Je=n(e,"A",{id:!0,class:!0}),a(Je).forEach(l),mo=d(e),c(We.$$.fragment,e),bo=d(e),Ve=n(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-13oc2rp"&&(Ve.textContent=qs),go=d(e),Ye=n(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1wxlxpn"&&(Ye.innerHTML=Ss),_o=d(e),Ge=n(e,"TABLE",{"data-svelte-h":!0}),r(Ge)!=="svelte-2kmk06"&&(Ge.innerHTML=zs),$o=d(e),To=n(e,"HR",{}),vo=d(e),Qe=n(e,"A",{id:!0,class:!0}),a(Qe).forEach(l),Po=d(e),c(Xe.$$.fragment,e),yo=d(e),Ze=n(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-bwoz3v"&&(Ze.textContent=Js),Mo=d(e),et=n(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1wxlxpn"&&(et.innerHTML=Ws),xo=d(e),tt=n(e,"TABLE",{"data-svelte-h":!0}),r(tt)!=="svelte-14il7x7"&&(tt.innerHTML=Vs),Co=d(e),Ho=n(e,"HR",{}),Ro=d(e),lt=n(e,"A",{id:!0,class:!0}),a(lt).forEach(l),Lo=d(e),c(it.$$.fragment,e),wo=d(e),ot=n(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-15u13r6"&&(ot.textContent=Ys),Fo=d(e),dt=n(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1tftvai"&&(dt.innerHTML=Gs),Ao=d(e),Eo=n(e,"HR",{}),jo=d(e),st=n(e,"A",{id:!0,class:!0}),a(st).forEach(l),Oo=d(e),c(nt.$$.fragment,e),Uo=d(e),rt=n(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-fkm19c"&&(rt.textContent=Qs),Bo=d(e),ut=n(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-xyh2rt"&&(ut.innerHTML=Xs),Ko=d(e),at=n(e,"TABLE",{"data-svelte-h":!0}),r(at)!=="svelte-mnoe75"&&(at.innerHTML=Zs),Io=d(e),ko=n(e,"HR",{}),Do=d(e),pt=n(e,"A",{id:!0,class:!0}),a(pt).forEach(l),No=d(e),c(ct.$$.fragment,e),qo=d(e),ft=n(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1xsms0j"&&(ft.innerHTML=en),So=d(e),ht=n(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1xbcdo6"&&(ht.innerHTML=tn),zo=d(e),mt=n(e,"TABLE",{"data-svelte-h":!0}),r(mt)!=="svelte-mbdqas"&&(mt.innerHTML=ln),Jo=d(e),Wo=n(e,"HR",{}),Vo=d(e),bt=n(e,"A",{id:!0,class:!0}),a(bt).forEach(l),Yo=d(e),c(gt.$$.fragment,e),Go=d(e),_t=n(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-112gzs0"&&(_t.textContent=on),Qo=d(e),$t=n(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-9i72aw"&&($t.innerHTML=dn),Xo=d(e),Tt=n(e,"UL",{"data-svelte-h":!0}),r(Tt)!=="svelte-w7pu3"&&(Tt.innerHTML=sn),Zo=d(e),vt=n(e,"TABLE",{"data-svelte-h":!0}),r(vt)!=="svelte-bpbhxc"&&(vt.innerHTML=nn),ed=d(e),td=n(e,"HR",{}),ld=d(e),Pt=n(e,"A",{id:!0,class:!0}),a(Pt).forEach(l),id=d(e),c(yt.$$.fragment,e),od=d(e),Mt=n(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1h1o1yf"&&(Mt.innerHTML=rn),dd=d(e),xt=n(e,"TABLE",{"data-svelte-h":!0}),r(xt)!=="svelte-17sk6uf"&&(xt.innerHTML=un),sd=d(e),nd=n(e,"HR",{}),rd=d(e),Ct=n(e,"A",{id:!0,class:!0}),a(Ct).forEach(l),ud=d(e),c(Ht.$$.fragment,e),ad=d(e),Rt=n(e,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-1tqccie"&&(Rt.textContent=an),pd=d(e),Lt=n(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-dyyw29"&&(Lt.innerHTML=pn),cd=d(e),wt=n(e,"TABLE",{"data-svelte-h":!0}),r(wt)!=="svelte-9lzswd"&&(wt.innerHTML=cn),fd=d(e),hd=n(e,"HR",{}),md=d(e),Ft=n(e,"A",{id:!0,class:!0}),a(Ft).forEach(l),bd=d(e),c(At.$$.fragment,e),gd=d(e),Et=n(e,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-7vbcne"&&(Et.textContent=fn),_d=d(e),jt=n(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-wjfx67"&&(jt.innerHTML=hn),$d=d(e),Ot=n(e,"TABLE",{"data-svelte-h":!0}),r(Ot)!=="svelte-61qi9d"&&(Ot.innerHTML=mn),Td=d(e),vd=n(e,"HR",{}),Pd=d(e),Ut=n(e,"A",{id:!0,class:!0}),a(Ut).forEach(l),yd=d(e),c(Bt.$$.fragment,e),Md=d(e),Kt=n(e,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-1l14wsh"&&(Kt.innerHTML=bn),xd=d(e),It=n(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-ghvp2p"&&(It.innerHTML=gn),Cd=d(e),Hd=n(e,"HR",{}),Rd=d(e),kt=n(e,"A",{id:!0,class:!0}),a(kt).forEach(l),Ld=d(e),c(Dt.$$.fragment,e),wd=d(e),Nt=n(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-1oi15lr"&&(Nt.textContent=_n),Fd=d(e),qt=n(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-121rdz"&&(qt.innerHTML=$n),Ad=d(e),St=n(e,"TABLE",{"data-svelte-h":!0}),r(St)!=="svelte-lhkacd"&&(St.innerHTML=Tn),Ed=d(e),jd=n(e,"HR",{}),Od=d(e),zt=n(e,"A",{id:!0,class:!0}),a(zt).forEach(l),Ud=d(e),c(Jt.$$.fragment,e),Bd=d(e),Wt=n(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-1oi15lr"&&(Wt.textContent=vn),Kd=d(e),Vt=n(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-121rdz"&&(Vt.innerHTML=Pn),Id=d(e),Yt=n(e,"TABLE",{"data-svelte-h":!0}),r(Yt)!=="svelte-3nlj0u"&&(Yt.innerHTML=yn),kd=d(e),Dd=n(e,"HR",{}),Nd=d(e),Gt=n(e,"A",{id:!0,class:!0}),a(Gt).forEach(l),qd=d(e),c(Qt.$$.fragment,e),Sd=d(e),Xt=n(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-1oi15lr"&&(Xt.textContent=Mn),zd=d(e),Zt=n(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-ghvp2p"&&(Zt.innerHTML=xn),Jd=d(e),Wd=n(e,"HR",{}),Vd=d(e),c(el.$$.fragment,e),Yd=d(e),ll=n(e,"P",{}),a(ll).forEach(l),this.h()},h(){u(_,"name","hf:doc:metadata"),u(_,"content",On),u($,"id","module_utils/hub"),u($,"class","group"),u(y,"id","module_utils/hub.getFile"),u(y,"class","group"),u(R,"id","module_utils/hub.getModelFile"),u(R,"class","group"),u(O,"id","module_utils/hub.getModelFile..cacheKey"),u(O,"class","group"),u(K,"id","module_utils/hub.getModelFile..response"),u(K,"class","group"),u(D,"id","module_utils/hub.getModelFile..buffer"),u(D,"class","group"),u(S,"id","module_utils/hub.getModelText"),u(S,"class","group"),u(G,"id","module_utils/hub.getModelJSON"),u(G,"class","group"),u(le,"id","module_utils/hub..FileResponse"),u(le,"class","group"),u(se,"id","new_module_utils/hub..FileResponse_new"),u(se,"class","group"),u(ae,"id","module_utils/hub..FileResponse+updateContentType"),u(ae,"class","group"),u(he,"id","module_utils/hub..FileResponse+clone"),u(he,"class","group"),u(_e,"id","module_utils/hub..FileResponse+arrayBuffer"),u(_e,"class","group"),u(ye,"id","module_utils/hub..FileResponse+blob"),u(ye,"class","group"),u(Re,"id","module_utils/hub..FileResponse+text"),u(Re,"class","group"),u(Ee,"id","module_utils/hub..FileResponse+json"),u(Ee,"class","group"),u(Ke,"id","module_utils/hub..FileCache"),u(Ke,"class","group"),u(Ne,"id","new_module_utils/hub..FileCache_new"),u(Ne,"class","group"),u(Je,"id","module_utils/hub..FileCache+match"),u(Je,"class","group"),u(Qe,"id","module_utils/hub..FileCache+put"),u(Qe,"class","group"),u(lt,"id","module_utils/hub..CONTENT_TYPE_MAP"),u(lt,"class","group"),u(st,"id","module_utils/hub..isValidUrl"),u(st,"class","group"),u(pt,"id","module_utils/hub..isValidHfModelId"),u(pt,"class","group"),u(bt,"id","module_utils/hub..handleError"),u(bt,"class","group"),u(Pt,"id","module_utils/hub..tryCache"),u(Pt,"class","group"),u(Ct,"id","module_utils/hub..readResponse"),u(Ct,"class","group"),u(Ft,"id","module_utils/hub..pathJoin"),u(Ft,"class","group"),u(Ut,"id","module_utils/hub..ExternalData"),u(Ut,"class","group"),u(kt,"id","module_utils/hub..PretrainedOptions"),u(kt,"class","group"),u(zt,"id","module_utils/hub..ModelSpecificPretrainedOptions"),u(zt,"class","group"),u(Gt,"id","module_utils/hub..PretrainedModelOptions"),u(Gt,"class","group")},m(e,t){An(document.head,_),i(e,il,t),i(e,tl,t),i(e,ol,t),i(e,$,t),i(e,dl,t),f(T,e,t),i(e,sl,t),i(e,v,t),i(e,nl,t),i(e,P,t),i(e,rl,t),i(e,ul,t),i(e,al,t),i(e,y,t),i(e,pl,t),f(M,e,t),i(e,cl,t),i(e,x,t),i(e,fl,t),i(e,C,t),i(e,hl,t),i(e,H,t),i(e,ml,t),i(e,bl,t),i(e,gl,t),i(e,R,t),i(e,_l,t),f(L,e,t),i(e,$l,t),i(e,w,t),i(e,Tl,t),i(e,F,t),i(e,vl,t),i(e,A,t),i(e,Pl,t),i(e,E,t),i(e,yl,t),i(e,j,t),i(e,Ml,t),i(e,xl,t),i(e,Cl,t),i(e,O,t),i(e,Hl,t),f(U,e,t),i(e,Rl,t),i(e,B,t),i(e,Ll,t),i(e,wl,t),i(e,Fl,t),i(e,K,t),i(e,Al,t),f(I,e,t),i(e,El,t),i(e,k,t),i(e,jl,t),i(e,Ol,t),i(e,Ul,t),i(e,D,t),i(e,Bl,t),f(N,e,t),i(e,Kl,t),i(e,q,t),i(e,Il,t),i(e,kl,t),i(e,Dl,t),i(e,S,t),i(e,Nl,t),f(z,e,t),i(e,ql,t),i(e,J,t),i(e,Sl,t),i(e,W,t),i(e,zl,t),i(e,V,t),i(e,Jl,t),i(e,Y,t),i(e,Wl,t),i(e,Vl,t),i(e,Yl,t),i(e,G,t),i(e,Gl,t),f(Q,e,t),i(e,Ql,t),i(e,X,t),i(e,Xl,t),i(e,Z,t),i(e,Zl,t),i(e,ee,t),i(e,ei,t),i(e,te,t),i(e,ti,t),i(e,li,t),i(e,ii,t),i(e,le,t),i(e,oi,t),f(ie,e,t),i(e,di,t),i(e,oe,t),i(e,si,t),i(e,de,t),i(e,ni,t),i(e,ri,t),i(e,ui,t),i(e,se,t),i(e,ai,t),f(ne,e,t),i(e,pi,t),i(e,re,t),i(e,ci,t),i(e,ue,t),i(e,fi,t),i(e,hi,t),i(e,mi,t),i(e,ae,t),i(e,bi,t),f(pe,e,t),i(e,gi,t),i(e,ce,t),i(e,_i,t),i(e,fe,t),i(e,$i,t),i(e,Ti,t),i(e,vi,t),i(e,he,t),i(e,Pi,t),f(me,e,t),i(e,yi,t),i(e,be,t),i(e,Mi,t),i(e,ge,t),i(e,xi,t),i(e,Ci,t),i(e,Hi,t),i(e,_e,t),i(e,Ri,t),f($e,e,t),i(e,Li,t),i(e,Te,t),i(e,wi,t),i(e,ve,t),i(e,Fi,t),i(e,Pe,t),i(e,Ai,t),i(e,Ei,t),i(e,ji,t),i(e,ye,t),i(e,Oi,t),f(Me,e,t),i(e,Ui,t),i(e,xe,t),i(e,Bi,t),i(e,Ce,t),i(e,Ki,t),i(e,He,t),i(e,Ii,t),i(e,ki,t),i(e,Di,t),i(e,Re,t),i(e,Ni,t),f(Le,e,t),i(e,qi,t),i(e,we,t),i(e,Si,t),i(e,Fe,t),i(e,zi,t),i(e,Ae,t),i(e,Ji,t),i(e,Wi,t),i(e,Vi,t),i(e,Ee,t),i(e,Yi,t),f(je,e,t),i(e,Gi,t),i(e,Oe,t),i(e,Qi,t),i(e,Ue,t),i(e,Xi,t),i(e,Be,t),i(e,Zi,t),i(e,eo,t),i(e,to,t),i(e,Ke,t),i(e,lo,t),f(Ie,e,t),i(e,io,t),i(e,ke,t),i(e,oo,t),i(e,De,t),i(e,so,t),i(e,no,t),i(e,ro,t),i(e,Ne,t),i(e,uo,t),f(qe,e,t),i(e,ao,t),i(e,Se,t),i(e,po,t),i(e,ze,t),i(e,co,t),i(e,fo,t),i(e,ho,t),i(e,Je,t),i(e,mo,t),f(We,e,t),i(e,bo,t),i(e,Ve,t),i(e,go,t),i(e,Ye,t),i(e,_o,t),i(e,Ge,t),i(e,$o,t),i(e,To,t),i(e,vo,t),i(e,Qe,t),i(e,Po,t),f(Xe,e,t),i(e,yo,t),i(e,Ze,t),i(e,Mo,t),i(e,et,t),i(e,xo,t),i(e,tt,t),i(e,Co,t),i(e,Ho,t),i(e,Ro,t),i(e,lt,t),i(e,Lo,t),f(it,e,t),i(e,wo,t),i(e,ot,t),i(e,Fo,t),i(e,dt,t),i(e,Ao,t),i(e,Eo,t),i(e,jo,t),i(e,st,t),i(e,Oo,t),f(nt,e,t),i(e,Uo,t),i(e,rt,t),i(e,Bo,t),i(e,ut,t),i(e,Ko,t),i(e,at,t),i(e,Io,t),i(e,ko,t),i(e,Do,t),i(e,pt,t),i(e,No,t),f(ct,e,t),i(e,qo,t),i(e,ft,t),i(e,So,t),i(e,ht,t),i(e,zo,t),i(e,mt,t),i(e,Jo,t),i(e,Wo,t),i(e,Vo,t),i(e,bt,t),i(e,Yo,t),f(gt,e,t),i(e,Go,t),i(e,_t,t),i(e,Qo,t),i(e,$t,t),i(e,Xo,t),i(e,Tt,t),i(e,Zo,t),i(e,vt,t),i(e,ed,t),i(e,td,t),i(e,ld,t),i(e,Pt,t),i(e,id,t),f(yt,e,t),i(e,od,t),i(e,Mt,t),i(e,dd,t),i(e,xt,t),i(e,sd,t),i(e,nd,t),i(e,rd,t),i(e,Ct,t),i(e,ud,t),f(Ht,e,t),i(e,ad,t),i(e,Rt,t),i(e,pd,t),i(e,Lt,t),i(e,cd,t),i(e,wt,t),i(e,fd,t),i(e,hd,t),i(e,md,t),i(e,Ft,t),i(e,bd,t),f(At,e,t),i(e,gd,t),i(e,Et,t),i(e,_d,t),i(e,jt,t),i(e,$d,t),i(e,Ot,t),i(e,Td,t),i(e,vd,t),i(e,Pd,t),i(e,Ut,t),i(e,yd,t),f(Bt,e,t),i(e,Md,t),i(e,Kt,t),i(e,xd,t),i(e,It,t),i(e,Cd,t),i(e,Hd,t),i(e,Rd,t),i(e,kt,t),i(e,Ld,t),f(Dt,e,t),i(e,wd,t),i(e,Nt,t),i(e,Fd,t),i(e,qt,t),i(e,Ad,t),i(e,St,t),i(e,Ed,t),i(e,jd,t),i(e,Od,t),i(e,zt,t),i(e,Ud,t),f(Jt,e,t),i(e,Bd,t),i(e,Wt,t),i(e,Kd,t),i(e,Vt,t),i(e,Id,t),i(e,Yt,t),i(e,kd,t),i(e,Dd,t),i(e,Nd,t),i(e,Gt,t),i(e,qd,t),f(Qt,e,t),i(e,Sd,t),i(e,Xt,t),i(e,zd,t),i(e,Zt,t),i(e,Jd,t),i(e,Wd,t),i(e,Vd,t),f(el,e,t),i(e,Yd,t),i(e,ll,t),Gd=!0},p:Hn,i(e){Gd||(h(T.$$.fragment,e),h(M.$$.fragment,e),h(L.$$.fragment,e),h(U.$$.fragment,e),h(I.$$.fragment,e),h(N.$$.fragment,e),h(z.$$.fragment,e),h(Q.$$.fragment,e),h(ie.$$.fragment,e),h(ne.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h($e.$$.fragment,e),h(Me.$$.fragment,e),h(Le.$$.fragment,e),h(je.$$.fragment,e),h(Ie.$$.fragment,e),h(qe.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(it.$$.fragment,e),h(nt.$$.fragment,e),h(ct.$$.fragment,e),h(gt.$$.fragment,e),h(yt.$$.fragment,e),h(Ht.$$.fragment,e),h(At.$$.fragment,e),h(Bt.$$.fragment,e),h(Dt.$$.fragment,e),h(Jt.$$.fragment,e),h(Qt.$$.fragment,e),h(el.$$.fragment,e),Gd=!0)},o(e){m(T.$$.fragment,e),m(M.$$.fragment,e),m(L.$$.fragment,e),m(U.$$.fragment,e),m(I.$$.fragment,e),m(N.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(ie.$$.fragment,e),m(ne.$$.fragment,e),m(pe.$$.fragment,e),m(me.$$.fragment,e),m($e.$$.fragment,e),m(Me.$$.fragment,e),m(Le.$$.fragment,e),m(je.$$.fragment,e),m(Ie.$$.fragment,e),m(qe.$$.fragment,e),m(We.$$.fragment,e),m(Xe.$$.fragment,e),m(it.$$.fragment,e),m(nt.$$.fragment,e),m(ct.$$.fragment,e),m(gt.$$.fragment,e),m(yt.$$.fragment,e),m(Ht.$$.fragment,e),m(At.$$.fragment,e),m(Bt.$$.fragment,e),m(Dt.$$.fragment,e),m(Jt.$$.fragment,e),m(Qt.$$.fragment,e),m(el.$$.fragment,e),Gd=!1},d(e){e&&(l(il),l(tl),l(ol),l($),l(dl),l(sl),l(v),l(nl),l(P),l(rl),l(ul),l(al),l(y),l(pl),l(cl),l(x),l(fl),l(C),l(hl),l(H),l(ml),l(bl),l(gl),l(R),l(_l),l($l),l(w),l(Tl),l(F),l(vl),l(A),l(Pl),l(E),l(yl),l(j),l(Ml),l(xl),l(Cl),l(O),l(Hl),l(Rl),l(B),l(Ll),l(wl),l(Fl),l(K),l(Al),l(El),l(k),l(jl),l(Ol),l(Ul),l(D),l(Bl),l(Kl),l(q),l(Il),l(kl),l(Dl),l(S),l(Nl),l(ql),l(J),l(Sl),l(W),l(zl),l(V),l(Jl),l(Y),l(Wl),l(Vl),l(Yl),l(G),l(Gl),l(Ql),l(X),l(Xl),l(Z),l(Zl),l(ee),l(ei),l(te),l(ti),l(li),l(ii),l(le),l(oi),l(di),l(oe),l(si),l(de),l(ni),l(ri),l(ui),l(se),l(ai),l(pi),l(re),l(ci),l(ue),l(fi),l(hi),l(mi),l(ae),l(bi),l(gi),l(ce),l(_i),l(fe),l($i),l(Ti),l(vi),l(he),l(Pi),l(yi),l(be),l(Mi),l(ge),l(xi),l(Ci),l(Hi),l(_e),l(Ri),l(Li),l(Te),l(wi),l(ve),l(Fi),l(Pe),l(Ai),l(Ei),l(ji),l(ye),l(Oi),l(Ui),l(xe),l(Bi),l(Ce),l(Ki),l(He),l(Ii),l(ki),l(Di),l(Re),l(Ni),l(qi),l(we),l(Si),l(Fe),l(zi),l(Ae),l(Ji),l(Wi),l(Vi),l(Ee),l(Yi),l(Gi),l(Oe),l(Qi),l(Ue),l(Xi),l(Be),l(Zi),l(eo),l(to),l(Ke),l(lo),l(io),l(ke),l(oo),l(De),l(so),l(no),l(ro),l(Ne),l(uo),l(ao),l(Se),l(po),l(ze),l(co),l(fo),l(ho),l(Je),l(mo),l(bo),l(Ve),l(go),l(Ye),l(_o),l(Ge),l($o),l(To),l(vo),l(Qe),l(Po),l(yo),l(Ze),l(Mo),l(et),l(xo),l(tt),l(Co),l(Ho),l(Ro),l(lt),l(Lo),l(wo),l(ot),l(Fo),l(dt),l(Ao),l(Eo),l(jo),l(st),l(Oo),l(Uo),l(rt),l(Bo),l(ut),l(Ko),l(at),l(Io),l(ko),l(Do),l(pt),l(No),l(qo),l(ft),l(So),l(ht),l(zo),l(mt),l(Jo),l(Wo),l(Vo),l(bt),l(Yo),l(Go),l(_t),l(Qo),l($t),l(Xo),l(Tt),l(Zo),l(vt),l(ed),l(td),l(ld),l(Pt),l(id),l(od),l(Mt),l(dd),l(xt),l(sd),l(nd),l(rd),l(Ct),l(ud),l(ad),l(Rt),l(pd),l(Lt),l(cd),l(wt),l(fd),l(hd),l(md),l(Ft),l(bd),l(gd),l(Et),l(_d),l(jt),l($d),l(Ot),l(Td),l(vd),l(Pd),l(Ut),l(yd),l(Md),l(Kt),l(xd),l(It),l(Cd),l(Hd),l(Rd),l(kt),l(Ld),l(wd),l(Nt),l(Fd),l(qt),l(Ad),l(St),l(Ed),l(jd),l(Od),l(zt),l(Ud),l(Bd),l(Wt),l(Kd),l(Vt),l(Id),l(Yt),l(kd),l(Dd),l(Nd),l(Gt),l(qd),l(Sd),l(Xt),l(zd),l(Zt),l(Jd),l(Wd),l(Vd),l(Yd),l(ll)),l(_),b(T,e),b(M,e),b(L,e),b(U,e),b(I,e),b(N,e),b(z,e),b(Q,e),b(ie,e),b(ne,e),b(pe,e),b(me,e),b($e,e),b(Me,e),b(Le,e),b(je,e),b(Ie,e),b(qe,e),b(We,e),b(Xe,e),b(it,e),b(nt,e),b(ct,e),b(gt,e),b(yt,e),b(Ht,e),b(At,e),b(Bt,e),b(Dt,e),b(Jt,e),b(Qt,e),b(el,e)}}}const On='{"title":"utils/hub","local":"utilshub","sections":[{"title":"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>","local":"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code","sections":[],"depth":2},{"title":"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options], [return_path]) ⇒ <code> Promise. < (string|Uint8Array) > </code>","local":"utilshubgetmodelfilepathorrepoid-filename-fatal-options-returnpath--code-promise--stringuint8array--code","sections":[{"title":"getModelFile~cacheKey : <code> string </code>","local":"getmodelfilecachekey--code-string-code","sections":[],"depth":3},{"title":"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>","local":"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code","sections":[],"depth":3},{"title":"getModelFile~buffer : <code> Uint8Array </code>","local":"getmodelfilebuffer--code-uint8array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub.getModelText(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < (string|null) > </code>","local":"utilshubgetmodeltextmodelpath-filename-fatal-options--code-promise--stringnull--code","sections":[],"depth":2},{"title":"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>","local":"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code","sections":[],"depth":2},{"title":"utils/hub~FileResponse","local":"utilshubfileresponse","sections":[{"title":"new FileResponse(filePath)","local":"new-fileresponsefilepath","sections":[],"depth":3},{"title":"fileResponse.updateContentType() ⇒ <code> void </code>","local":"fileresponseupdatecontenttype--code-void-code","sections":[],"depth":3},{"title":"fileResponse.clone() ⇒ <code> FileResponse </code>","local":"fileresponseclone--code-fileresponse-code","sections":[],"depth":3},{"title":"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>","local":"fileresponsearraybuffer--code-promise--arraybuffer--code","sections":[],"depth":3},{"title":"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>","local":"fileresponseblob--code-promise--blob--code","sections":[],"depth":3},{"title":"fileResponse.text() ⇒ <code> Promise. < string > </code>","local":"fileresponsetext--code-promise--string--code","sections":[],"depth":3},{"title":"fileResponse.json() ⇒ <code> Promise. < Object > </code>","local":"fileresponsejson--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~FileCache","local":"utilshubfilecache","sections":[{"title":"new FileCache(path)","local":"new-filecachepath","sections":[],"depth":3},{"title":"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>","local":"filecachematchrequest--code-promise--fileresponseundefined--code","sections":[],"depth":3},{"title":"fileCache.put(request, response, [progress_callback]) ⇒ <code> Promise. < void > </code>","local":"filecacheputrequest-response-progresscallback--code-promise--void--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~CONTENT_TYPE_MAP","local":"utilshubcontenttypemap","sections":[],"depth":2},{"title":"utils/hub~isValidUrl(string, [protocols], [validHosts]) ⇒ <code> boolean </code>","local":"utilshubisvalidurlstring-protocols-validhosts--code-boolean-code","sections":[],"depth":2},{"title":"utils/hub~isValidHfModelId(string) ⇒ <code> boolean </code>","local":"utilshubisvalidhfmodelidstring--code-boolean-code","sections":[],"depth":2},{"title":"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>","local":"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code","sections":[],"depth":2},{"title":"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>","local":"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code","sections":[],"depth":2},{"title":"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>","local":"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code","sections":[],"depth":2},{"title":"utils/hub~pathJoin(...parts) ⇒ <code> string </code>","local":"utilshubpathjoinparts--code-string-code","sections":[],"depth":2},{"title":"utils/hub~ExternalData : <code> boolean </code> | <code> number </code>","local":"utilshubexternaldata--code-boolean-code--code-number-code","sections":[],"depth":2},{"title":"utils/hub~PretrainedOptions : <code> Object </code>","local":"utilshubpretrainedoptions--code-object-code","sections":[],"depth":2},{"title":"utils/hub~ModelSpecificPretrainedOptions : <code> Object </code>","local":"utilshubmodelspecificpretrainedoptions--code-object-code","sections":[],"depth":2},{"title":"utils/hub~PretrainedModelOptions : <code> * </code>","local":"utilshubpretrainedmodeloptions--code--code","sections":[],"depth":2}],"depth":1}';function Un(Qd){return Rn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kn extends Ln{constructor(_){super(),wn(this,_,Un,jn,Cn,{})}}export{kn as component};
