import{s as ms,n as ys,o as js}from"../chunks/scheduler.0219f8bd.js";import{S as Js,i as us,g as o,s as t,r as I,A as hs,h as p,f as a,c as n,j as ss,u as B,x as d,k as K,y as ls,a as e,v as Z,d as Q,t as k,w as C}from"../chunks/index.f61edf3b.js";import{C as as}from"../chunks/CodeBlock.15473de1.js";import{H as es,E as Ts}from"../chunks/getInferenceSnippets.8735cf23.js";function Us(ts){let c,N,W,R,m,E,y,ns="Before Transformers.js v3, we used the <code>quantized</code> option to specify whether to use a quantized (q8) or full-precision (fp32) variant of the model by setting <code>quantized</code> to <code>true</code> or <code>false</code>, respectively. Now, we’ve added the ability to select from a much larger list with the <code>dtype</code> parameter.",_,j,os="The list of available quantizations depends on the model, but some common ones are: full-precision (<code>&quot;fp32&quot;</code>), half-precision (<code>&quot;fp16&quot;</code>), 8-bit (<code>&quot;q8&quot;</code>, <code>&quot;int8&quot;</code>, <code>&quot;uint8&quot;</code>), and 4-bit (<code>&quot;q4&quot;</code>, <code>&quot;bnb4&quot;</code>, <code>&quot;q4f16&quot;</code>).",X,i,ps='<picture><source media="(prefers-color-scheme: dark)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/transformersjs-v3/dtypes-dark.jpg" style="max-width: 100%;"/> <source media="(prefers-color-scheme: light)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/transformersjs-v3/dtypes-light.jpg" style="max-width: 100%;"/> <img alt="Available dtypes for mixedbread-ai/mxbai-embed-xsmall-v1" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/transformersjs-v3/dtypes-dark.jpg" style="max-width: 100%;"/></picture> <a href="https://huggingface.co/mixedbread-ai/mxbai-embed-xsmall-v1/tree/main/onnx">(e.g., mixedbread-ai/mxbai-embed-xsmall-v1)</a>',q,J,z,u,cs='<strong>Example:</strong> Run Qwen2.5-0.5B-Instruct in 4-bit quantization (<a href="https://v2.scrimba.com/s0dlcpv0ci" rel="nofollow">demo</a>)',Y,h,A,T,V,U,is="Some encoder-decoder models, like Whisper or Florence-2, are extremely sensitive to quantization settings: especially of the encoder. For this reason, we added the ability to select per-module dtypes, which can be done by providing a mapping from module name to dtype.",x,w,rs='<strong>Example:</strong> Run Florence-2 on WebGPU (<a href="https://v2.scrimba.com/s0pdm485fo" rel="nofollow">demo</a>)',S,b,F,r,Ms='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/transformersjs-v3/florence-2-webgpu.gif" alt="Florence-2 running on WebGPU"/>',H,M,v,ds="See full code example",O,f,$,g,L,G,P;return m=new es({props:{title:"Using quantized models (dtypes)",local:"using-quantized-models-dtypes",headingTag:"h1"}}),J=new es({props:{title:"Basic usage",local:"basic-usage",headingTag:"h2"}}),h=new as({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMjIlM0IlMEElMEElMkYlMkYlMjBDcmVhdGUlMjBhJTIwdGV4dCUyMGdlbmVyYXRpb24lMjBwaXBlbGluZSUwQWNvbnN0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSglMEElMjAlMjAlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjJvbm54LWNvbW11bml0eSUyRlF3ZW4yLjUtMC41Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCU3QiUyMGR0eXBlJTNBJTIwJTIycTQlMjIlMkMlMjBkZXZpY2UlM0ElMjAlMjJ3ZWJncHUlMjIlMjAlN0QlMkMlMEEpJTNCJTBBJTBBJTJGJTJGJTIwRGVmaW5lJTIwdGhlJTIwbGlzdCUyMG9mJTIwbWVzc2FnZXMlMEFjb25zdCUyMG1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTdCJTIwcm9sZSUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMGNvbnRlbnQlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlMjAlN0QlMkMlMEElMjAlMjAlN0IlMjByb2xlJTNBJTIwJTIydXNlciUyMiUyQyUyMGNvbnRlbnQlM0ElMjAlMjJUZWxsJTIwbWUlMjBhJTIwZnVubnklMjBqb2tlLiUyMiUyMCU3RCUyQyUwQSU1RCUzQiUwQSUwQSUyRiUyRiUyMEdlbmVyYXRlJTIwYSUyMHJlc3BvbnNlJTBBY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGdlbmVyYXRvcihtZXNzYWdlcyUyQyUyMCU3QiUyMG1heF9uZXdfdG9rZW5zJTNBJTIwMTI4JTIwJTdEKSUzQiUwQWNvbnNvbGUubG9nKG91dHB1dCU1QjAlNUQuZ2VuZXJhdGVkX3RleHQuYXQoLTEpLmNvbnRlbnQpJTNC",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/transformers&quot;</span>;

<span class="hljs-comment">// Create a text generation pipeline</span>
<span class="hljs-keyword">const</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(
  <span class="hljs-string">&quot;text-generation&quot;</span>,
  <span class="hljs-string">&quot;onnx-community/Qwen2.5-0.5B-Instruct&quot;</span>,
  { <span class="hljs-attr">dtype</span>: <span class="hljs-string">&quot;q4&quot;</span>, <span class="hljs-attr">device</span>: <span class="hljs-string">&quot;webgpu&quot;</span> },
);

<span class="hljs-comment">// Define the list of messages</span>
<span class="hljs-keyword">const</span> messages = [
  { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
  { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Tell me a funny joke.&quot;</span> },
];

<span class="hljs-comment">// Generate a response</span>
<span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(messages, { <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">128</span> });
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output[<span class="hljs-number">0</span>].<span class="hljs-property">generated_text</span>.<span class="hljs-title function_">at</span>(-<span class="hljs-number">1</span>).<span class="hljs-property">content</span>);`,wrap:!1}}),T=new es({props:{title:"Per-module dtypes",local:"per-module-dtypes",headingTag:"h2"}}),b=new as({props:{code:"aW1wb3J0JTIwJTdCJTIwRmxvcmVuY2UyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJTIyJTNCJTBBJTBBY29uc3QlMjBtb2RlbCUyMCUzRCUyMGF3YWl0JTIwRmxvcmVuY2UyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJvbm54LWNvbW11bml0eSUyRkZsb3JlbmNlLTItYmFzZS1mdCUyMiUyQyUwQSUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMGR0eXBlJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwZW1iZWRfdG9rZW5zJTNBJTIwJTIyZnAxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHZpc2lvbl9lbmNvZGVyJTNBJTIwJTIyZnAxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVuY29kZXJfbW9kZWwlM0ElMjAlMjJxNCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGRlY29kZXJfbW9kZWxfbWVyZ2VkJTNBJTIwJTIycTQlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2UlM0ElMjAlMjJ3ZWJncHUlMjIlMkMlMEElMjAlMjAlN0QlMkMlMEEpJTNC",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">Florence2ForConditionalGeneration</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/transformers&quot;</span>;

<span class="hljs-keyword">const</span> model = <span class="hljs-keyword">await</span> <span class="hljs-title class_">Florence2ForConditionalGeneration</span>.<span class="hljs-title function_">from_pretrained</span>(
  <span class="hljs-string">&quot;onnx-community/Florence-2-base-ft&quot;</span>,
  {
    <span class="hljs-attr">dtype</span>: {
      <span class="hljs-attr">embed_tokens</span>: <span class="hljs-string">&quot;fp16&quot;</span>,
      <span class="hljs-attr">vision_encoder</span>: <span class="hljs-string">&quot;fp16&quot;</span>,
      <span class="hljs-attr">encoder_model</span>: <span class="hljs-string">&quot;q4&quot;</span>,
      <span class="hljs-attr">decoder_model_merged</span>: <span class="hljs-string">&quot;q4&quot;</span>,
    },
    <span class="hljs-attr">device</span>: <span class="hljs-string">&quot;webgpu&quot;</span>,
  },
);`,wrap:!1}}),f=new as({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> {
  <span class="hljs-title class_">Florence2ForConditionalGeneration</span>,
  <span class="hljs-title class_">AutoProcessor</span>,
  <span class="hljs-title class_">AutoTokenizer</span>,
  <span class="hljs-title class_">RawImage</span>,
} <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/transformers&quot;</span>;

<span class="hljs-comment">// Load model, processor, and tokenizer</span>
<span class="hljs-keyword">const</span> model_id = <span class="hljs-string">&quot;onnx-community/Florence-2-base-ft&quot;</span>;
<span class="hljs-keyword">const</span> model = <span class="hljs-keyword">await</span> <span class="hljs-title class_">Florence2ForConditionalGeneration</span>.<span class="hljs-title function_">from_pretrained</span>(
  model_id,
  {
    <span class="hljs-attr">dtype</span>: {
      <span class="hljs-attr">embed_tokens</span>: <span class="hljs-string">&quot;fp16&quot;</span>,
      <span class="hljs-attr">vision_encoder</span>: <span class="hljs-string">&quot;fp16&quot;</span>,
      <span class="hljs-attr">encoder_model</span>: <span class="hljs-string">&quot;q4&quot;</span>,
      <span class="hljs-attr">decoder_model_merged</span>: <span class="hljs-string">&quot;q4&quot;</span>,
    },
    <span class="hljs-attr">device</span>: <span class="hljs-string">&quot;webgpu&quot;</span>,
  },
);
<span class="hljs-keyword">const</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(model_id);
<span class="hljs-keyword">const</span> tokenizer = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoTokenizer</span>.<span class="hljs-title function_">from_pretrained</span>(model_id);

<span class="hljs-comment">// Load image and prepare vision inputs</span>
<span class="hljs-keyword">const</span> url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/car.jpg&quot;</span>;
<span class="hljs-keyword">const</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">fromURL</span>(url);
<span class="hljs-keyword">const</span> vision_inputs = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(image);

<span class="hljs-comment">// Specify task and prepare text inputs</span>
<span class="hljs-keyword">const</span> task = <span class="hljs-string">&quot;&lt;MORE_DETAILED_CAPTION&gt;&quot;</span>;
<span class="hljs-keyword">const</span> prompts = processor.<span class="hljs-title function_">construct_prompts</span>(task);
<span class="hljs-keyword">const</span> text_inputs = <span class="hljs-title function_">tokenizer</span>(prompts);

<span class="hljs-comment">// Generate text</span>
<span class="hljs-keyword">const</span> generated_ids = <span class="hljs-keyword">await</span> model.<span class="hljs-title function_">generate</span>({
  ...text_inputs,
  ...vision_inputs,
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">100</span>,
});

<span class="hljs-comment">// Decode generated text</span>
<span class="hljs-keyword">const</span> generated_text = tokenizer.<span class="hljs-title function_">batch_decode</span>(generated_ids, {
  <span class="hljs-attr">skip_special_tokens</span>: <span class="hljs-literal">false</span>,
})[<span class="hljs-number">0</span>];

<span class="hljs-comment">// Post-process the generated text</span>
<span class="hljs-keyword">const</span> result = processor.<span class="hljs-title function_">post_process_generation</span>(
  generated_text,
  task,
  image.<span class="hljs-property">size</span>,
);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(result);
<span class="hljs-comment">// { &#x27;&lt;MORE_DETAILED_CAPTION&gt;&#x27;: &#x27;A green car is parked in front of a tan building. The building has a brown door and two brown windows. The car is a two door and the door is closed. The green car has black tires.&#x27; }</span>`,wrap:!1}}),g=new Ts({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/guides/dtypes.md"}}),{c(){c=o("meta"),N=t(),W=o("p"),R=t(),I(m.$$.fragment),E=t(),y=o("p"),y.innerHTML=ns,_=t(),j=o("p"),j.innerHTML=os,X=t(),i=o("p"),i.innerHTML=ps,q=t(),I(J.$$.fragment),z=t(),u=o("p"),u.innerHTML=cs,Y=t(),I(h.$$.fragment),A=t(),I(T.$$.fragment),V=t(),U=o("p"),U.textContent=is,x=t(),w=o("p"),w.innerHTML=rs,S=t(),I(b.$$.fragment),F=t(),r=o("p"),r.innerHTML=Ms,H=t(),M=o("details"),v=o("summary"),v.textContent=ds,O=t(),I(f.$$.fragment),$=t(),I(g.$$.fragment),L=t(),G=o("p"),this.h()},l(s){const l=hs("svelte-u9bgzb",document.head);c=p(l,"META",{name:!0,content:!0}),l.forEach(a),N=n(s),W=p(s,"P",{}),ss(W).forEach(a),R=n(s),B(m.$$.fragment,s),E=n(s),y=p(s,"P",{"data-svelte-h":!0}),d(y)!=="svelte-jvrgvt"&&(y.innerHTML=ns),_=n(s),j=p(s,"P",{"data-svelte-h":!0}),d(j)!=="svelte-vokppa"&&(j.innerHTML=os),X=n(s),i=p(s,"P",{align:!0,"data-svelte-h":!0}),d(i)!=="svelte-10et6vw"&&(i.innerHTML=ps),q=n(s),B(J.$$.fragment,s),z=n(s),u=p(s,"P",{"data-svelte-h":!0}),d(u)!=="svelte-1emxfy4"&&(u.innerHTML=cs),Y=n(s),B(h.$$.fragment,s),A=n(s),B(T.$$.fragment,s),V=n(s),U=p(s,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1hza90f"&&(U.textContent=is),x=n(s),w=p(s,"P",{"data-svelte-h":!0}),d(w)!=="svelte-1fk7m3h"&&(w.innerHTML=rs),S=n(s),B(b.$$.fragment,s),F=n(s),r=p(s,"P",{align:!0,"data-svelte-h":!0}),d(r)!=="svelte-fnk7kx"&&(r.innerHTML=Ms),H=n(s),M=p(s,"DETAILS",{});var D=ss(M);v=p(D,"SUMMARY",{"data-svelte-h":!0}),d(v)!=="svelte-1lrja8l"&&(v.textContent=ds),O=n(D),B(f.$$.fragment,D),D.forEach(a),$=n(s),B(g.$$.fragment,s),L=n(s),G=p(s,"P",{}),ss(G).forEach(a),this.h()},h(){K(c,"name","hf:doc:metadata"),K(c,"content",ws),K(i,"align","center"),K(r,"align","middle")},m(s,l){ls(document.head,c),e(s,N,l),e(s,W,l),e(s,R,l),Z(m,s,l),e(s,E,l),e(s,y,l),e(s,_,l),e(s,j,l),e(s,X,l),e(s,i,l),e(s,q,l),Z(J,s,l),e(s,z,l),e(s,u,l),e(s,Y,l),Z(h,s,l),e(s,A,l),Z(T,s,l),e(s,V,l),e(s,U,l),e(s,x,l),e(s,w,l),e(s,S,l),Z(b,s,l),e(s,F,l),e(s,r,l),e(s,H,l),e(s,M,l),ls(M,v),ls(M,O),Z(f,M,null),e(s,$,l),Z(g,s,l),e(s,L,l),e(s,G,l),P=!0},p:ys,i(s){P||(Q(m.$$.fragment,s),Q(J.$$.fragment,s),Q(h.$$.fragment,s),Q(T.$$.fragment,s),Q(b.$$.fragment,s),Q(f.$$.fragment,s),Q(g.$$.fragment,s),P=!0)},o(s){k(m.$$.fragment,s),k(J.$$.fragment,s),k(h.$$.fragment,s),k(T.$$.fragment,s),k(b.$$.fragment,s),k(f.$$.fragment,s),k(g.$$.fragment,s),P=!1},d(s){s&&(a(N),a(W),a(R),a(E),a(y),a(_),a(j),a(X),a(i),a(q),a(z),a(u),a(Y),a(A),a(V),a(U),a(x),a(w),a(S),a(F),a(r),a(H),a(M),a($),a(L),a(G)),a(c),C(m,s),C(J,s),C(h,s),C(T,s),C(b,s),C(f),C(g,s)}}}const ws='{"title":"Using quantized models (dtypes)","local":"using-quantized-models-dtypes","sections":[{"title":"Basic usage","local":"basic-usage","sections":[],"depth":2},{"title":"Per-module dtypes","local":"per-module-dtypes","sections":[],"depth":2}],"depth":1}';function bs(ts){return js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zs extends Js{constructor(c){super(),us(this,c,bs,Us,ms,{})}}export{Zs as component};
