import{s as kn,n as Cn,o as Gn}from"../chunks/scheduler.f7e1785c.js";import{S as qn,i as Rn,g as o,s as l,r as p,m as J,H as bt,A as Vn,h as i,f as t,c as a,j as kt,u,x as r,n as j,E as gt,k as Qe,y as U,a as n,v as d,d as c,t as m,w as M}from"../chunks/index.9f8f0838.js";import{C as y}from"../chunks/CodeBlock.b3510e34.js";import{H as ze}from"../chunks/Heading.6643a2f7.js";function $n(Ct){let w,Xe,Le,Ae,v,Pe,I,Gt=`Dans cette section, nous verrons comment utiliser le <code>pipeline()</code> pour tirer parti des modèles pré-entraînés pour la reconnaissance automatique de la parole. Dans l’[unité 2](.. /chapter2/asr_pipeline), nous avons introduit le <code>pipeline()</code> comme un moyen facile d’exécuter des tâches de reconnaissance de la parole, avec tout le prétraitement et le post-traitement gérés sous le capot et la flexibilité d’expérimenter rapidement avec n’importe quel <em>checkpoint</em> pré-entraîné disponible sur le <em>Hub</em>.
Dans cette unité, nous irons plus loin et explorerons les différents attributs des modèles de reconnaissance automatique de la parole et comment nous pouvons les utiliser pour aborder une gamme de tâches différentes.`,Oe,S,qt="Comme détaillé dans l’unité 3, le modèle de reconnaissance automatique de la parole se divise généralement dans l’une des deux catégories suivantes :",De,x,Rt="<li>Modèle avec Classification temporelle connexionniste (CTC) : modèles avec que l’encodeur du <em>transformer</em> avec une tête de classification linéaire sur le dessus</li> <li>Modèle de séquence à séquence (Seq2Seq) : modèles encodeur-décodeur, avec un mécanisme d’attention croisée entre l’encodeur et le décodeur</li>",Ke,B,Vt=`Avant 2022, la variante avec CTC était la plus populaire des deux architectures, avec des modèles tels que Wav2Vec2, HuBERT et XLSR réalisant des percées dans le paradigme de pré-entraînement / <em>finetuning</em> de la parole.
De grandes entreprises, telles que Meta et Microsoft, ont pré-entraîné l’encodeur sur de grandes quantités de données audio non étiquetées pendant plusieurs jours ou semaines.
Les utilisateurs pouvent ensuite prendre un <em>checkpoint</em> pré-entraîné et le finetuner avec une tête CTC sur à peine <strong>10 minutes</strong> de données audio étiquetées pour obtenir de solides performances sur une tâche en aval de reconnaissance automatique de la parole.
Cependant, les modèles CTC ont des lacunes. L’ajout d’une simple couche linéaire à un encodeur donne un petit modèle global rapide, mais peut être sujet à des fautes d’orthographe phonétiques. Nous allons le démontrer ci-dessous pour le modèle Wav2Vec2.`,es,E,ss,k,$t='Chargeons un petit extrait du jeu de données <a href="hf-internal-testing/librispeech_asr_dummy">LibriSpeech ASR</a> pour démontrer les capacités de transcription de Wav2Vec2 :',ts,C,ns,G,Ft="<strong>Sortie :</strong>",ls,q,as,R,Wt="Nous pouvons choisir l’un des 73 échantillons audio et en inspecter l’audio ainsi que la transcription :",os,V,is,$,Zt="<strong>Sortie :</strong>",rs,F,ps,W,Ht=`Noël et rôti de bœuf, ça sonne bien! 🎄 Après avoir choisi un échantillon de données, nous chargeons maintenant un <em>checkpoint</em> <em>finetuné</em> dans le <code>pipeline()</code>.
Pour cela, nous utiliserons le <em>checkpoint</em> officiel [base Wav2Vec2] (facebook/wav2vec2-base-100h) <em>finetuné</em> sur 100 heures de données LibriSpeech :`,us,Z,ds,H,Nt=`Ensuite, nous allons prendre un exemple du jeu de données et transmettre ses données brutes au pipeline.
Puisque le pipeline <em>consomme</em> n’importe quel dictionnaire que nous lui passons (ce qui signifie qu’il ne peut pas être réutilisé), nous transmettrons une copie des données. De cette façon, nous pouvons réutiliser en toute sécurité le même échantillon audio dans les exemples suivants:`,cs,N,ms,Y,Yt=`Nous pouvons voir que le modèle Wav2Vec2 fait un assez bon travail pour transcrire cet échantillon. A première vue, il semble généralement correct.
Mettons la cible et la prédiction côte à côte et mettons en évidence les différences:`,Ms,Q,hs,L,Qt="En comparant le texte cible à la transcription prévue, nous pouvons voir que tous les mots <em>sonnent</em> correctement mais que certains ne sont pas orthographiés avec précision. Par exemple :",ys,_,Lt=`<li><em>CHRISTMAUS</em> vs. <em>CHRISTMAS</em></li> <li><em>ROSE</em> vs. <em>ROAST</em></li> <li><em>SIMALYIS</em> vs. <em>SIMILES</em>
Cela met en évidence les lacunes d’un modèle CTC. Un modèle CTC est essentiellement uniquement un modèle « acoustique» : il se compose d’un encodeur qui forme des représentations d’états cachés à partir des entrées audio, et d’une couche linéaire qui associe les états cachés aux caractères :</li>`,Ts,b,_t='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/wav2vec2-ctc.png" alt="Transformer encoder with a CTC head on top"/>',Us,z,zt=`Cela signifie que le système base presque entièrement sa prédiction sur l’entrée acoustique qui lui a été donnée (les sons phonétiques de l’audio), et a donc tendance à transcrire l’audio de manière phonétique.
Il donne moins d’importance au contexte de modélisation linguistique des lettres précédentes et successives, et est donc sujet aux fautes d’orthographe phonétique.
Un modèle plus intelligent identifierait que <em>CHRISTMAUS</em> n’est pas un mot valide dans le vocabulaire anglais, et le corrigerait en <em>CHRISTMAS</em> lors de ses prédictions. Il nous manque également deux grandes fonctionnalités dans notre prédiction, la casse et la ponctuation, ce qui limite l’utilité des transcriptions du modèle aux applications réelles.`,Js,X,js,A,Xt=`Comme indiqué dans l’unité 3, les modèles Seq2Seq sont formés d’un codeur et d’un décodeur reliés par un mécanisme d’attention croisée. L’encodeur joue le même rôle qu’auparavant, calculant des représentations d’états cachés des entrées audio, tandis que le décodeur joue le rôle d’un <strong>modèle de langage</strong>. Le décodeur traite toute la séquence de représentations d’états cachés de l’encodeur et génère les transcriptions de texte correspondantes. Avec le contexte global de l’entrée audio, le décodeur est capable d’utiliser le contexte du modèle de langage lorsqu’il fait ses prédictions, corrigeant les fautes d’orthographe à la volée et contournant ainsi le problème des prédictions phonétiques.
Les modèles Seq2Seq présentent deux inconvénients :`,ws,P,At="<li>Ils sont intrinsèquement plus lents lors du décodage puisqu’il se produit une étape à la fois, plutôt que tout à la fois 2. Ils nécessitent beaucoup plus de données d’entraînement pour converger</li>",bs,O,Pt=`Le besoin de grandes quantités de données d’apprentissage a été un goulot d’étranglement dans l’avancement des architectures Seq2Seq pour la parole. Les données audios étiquetées sont difficiles à obtenir, les plus grands jeux de données annotées à l’époque ne totalisant que 10 000 heures. Tout cela a changé en 2022 avec la sortie de <strong>Whisper</strong>. Whisper est un modèle pré-entraîné pour la reconnaissance automatique de la parole publié en <a href="https://openai.com/blog/whisper/" rel="nofollow">septembre 2022</a> par Alec Radford et al. d’OpenAI. Contrairement à ses prédécesseurs CTC, qui étaient entièrement pré-entraînés sur des données audio <strong>non étiquetées</strong>, Whisper est pré-entraîné sur une grande quantité de données de transcription audio <strong>étiquetées</strong>, 680 000 heures pour être précis.
Il s’agit d’un ordre de grandeur de données plus grand que les données audio non étiquetées utilisées pour entraîner Wav2Vec 2.0 (60 000 heures). De plus, 117 000 heures de ces données de pré-entraînement sont des données multilingues. Il en résulte des <em>checkpoints</em> qui peuvent être appliqués à plus de 96 langues, dont beaucoup sont considérées comme <em>à faible ressource</em>.
Lorsqu’ils sont passés à l’échelle, les modèles Whisper démontrent une forte capacité à généraliser sur de nombreux jeux de données et domaines. Obtenant des résultats compétitifs de pointe, avec un taux d’erreur de mots (WER) de près de 3% sur le sous-ensemble de test LibriSpeech et de 4,7% WER  sur le sous-ensemble de test TED-LIUM (<em>cf.</em> Tableau 8 du <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">papier de Whisper</a>).
La capacité de Whisper à gérer de longs échantillons audio, sa robustesse au bruit et sa capacité à prédire les transcriptions en casse et ponctuées revêtent une importance particulière. Cela en fait un candidat viable pour les systèmes de reconnaissance automatique de la parole du monde réel.
Le reste de cette section vous montrera comment utiliser les modèles Whisper pré-entraînés pour la reconnaissance automatique de la parole à l’aide de 🤗 <em>Transformers</em>. Dans de nombreuses situations, les <em>checkpoints</em> pré-entraînés sont extrêmement performants et donnent d’excellents résultats, nous vous encourageons donc à essayer de les utiliser comme première étape pour résoudre tout problème de reconnaissance automatique de la parole.
Grâce à un <em>finetuning</em>, les <em>checkpoints</em> peuvent être adaptés à des jeux de données et à des langues spécifiques afin d’améliorer encore ces résultats. Nous montrerons comment faire cela dans la section sur <a href="fine-tuning">le <em>finetuning</em></a>.
Whisper est disponible en cinq tailles différentes de modèles. Les quatre plus petits sont entraînés soit sur des données en anglais soit sur des données multilingues. Le <em>checkpoint</em> le plus grand est uniquement multilingue. Les neuf <em>checkpoints</em> pré-entraînés sont disponibles sur le <a href="https://huggingface.co/models?search=openai/whisper" rel="nofollow"><em>Hub</em></a>. Ils sont résumés dans le tableau suivant. « VRAM » indique la mémoire GPU requise pour exécuter le modèle avec une taille de batch minimale de 1. « <em>Rel Speed</em> » est la vitesse relative d’un <em>checkpoint</em> par rapport au plus grand modèle.
Sur la base de ces informations, vous pouvez sélectionner le <em>checkpoint</em> le plus adapté à votre matériel.`,gs,D,Ot='<thead><tr><th>Taille</th> <th>Paramètres</th> <th>VRAM / Go</th> <th><em>Rel Speed</em></th> <th>Anglais</th> <th>Multilingue</th></tr></thead> <tbody><tr><td>tiny</td> <td>39 M</td> <td>1.4</td> <td>32</td> <td><a href="https://huggingface.co/openai/whisper-tiny.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-tiny" rel="nofollow">✓</a></td></tr> <tr><td>base</td> <td>74 M</td> <td>1.5</td> <td>16</td> <td><a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-base" rel="nofollow">✓</a></td></tr> <tr><td>small</td> <td>244 M</td> <td>2.3</td> <td>6</td> <td><a href="https://huggingface.co/openai/whisper-small.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-small" rel="nofollow">✓</a></td></tr> <tr><td>medium</td> <td>769 M</td> <td>4.2</td> <td>2</td> <td><a href="https://huggingface.co/openai/whisper-medium.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-medium" rel="nofollow">✓</a></td></tr> <tr><td>large</td> <td>1550 M</td> <td>7.5</td> <td>1</td> <td>x</td> <td><a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">✓</a></td></tr></tbody>',fs,K,Dt='Chargeons le <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a>, qui est de taille comparable au Wav2Vec2 que nous avons utilisé précédemment. Anticipant notre passage à la reconnaissance automatique de la parole multilingue, nous allons charger la variante multilingue du <em>checkpoint</em> de base. Nous chargons également le modèle sur le GPU s’il est disponible, ou sur le CPU dans le cas contraire. Le <code>pipeline()</code> se chargera ensuite de déplacer toutes les entrées / sorties du CPU vers le GPU selon les besoins:',vs,ee,Is,se,Kt="Bien, maintenant, transcrivons l’audio comme avant. Le seul changement que nous apportons est de passer un argument supplémentaire, <code>max_new_tokens</code>, qui indique au modèle le nombre maximum de <em>tokens</em> à générer lors de sa prédiction :",Ss,te,xs,ne,en="<strong>Sortie :</strong>",Bs,le,Es,ae,sn="La première chose que vous remarquerez est la présence de la casse et de la ponctuation. Cela rend immédiatement la transcription plus facile à lire par rapport à la transcription non casée et non ponctuée de Wav2Vec2. Mettons la transcription côte à côte avec la cible :",ks,oe,Cs,ie,tn=`Whisper a fait un excellent travail pour corriger les erreurs phonétiques que nous avons vues avec Wav2Vec2 : <em>Christmas</em> et <em>roast</em> sont orthographiés correctement. Nous voyons que le modèle a encore du mal avec <em>SIMILES</em>, étant incorrectement transcrit comme <em>similarly</em>, mais cette fois la prédiction est un mot valide du vocabulaire anglais. L’utilisation d’un Whisper plus grand peut aider à réduire davantage les erreurs de transcription, au détriment d’un calcul plus important et d’un temps de transcription plus long.
On nous a promis un modèle capable de gérer 96 langues, alors passons à de la reconnaissance automatique multilingue 🌎 !
Le jeu de données <a href="https://huggingface.co/datasets/facebook/multilingual_librispeech" rel="nofollow">Multilingual LibriSpeech</a> (MLS) est l’équivalent multilingue du jeu de données LibriSpeech, avec des données audio étiquetées en six langues. Nous allons charger un échantillon de l’échantillon espagnol de MLS, en utilisant le mode <em>streaming</em> afin de ne pas avoir à télécharger l’ensemble de données :`,Gs,re,qs,pe,nn="Encore une fois, nous allons inspecter la transcription du texte et écouter le segment audio:",Rs,ue,Vs,de,ln="<strong>Sortie :</strong>",$s,ce,Fs,me,an="C’est le texte cible que nous visons avec notre transcription Whisper. Bien que nous sachions maintenant que nous pouvons probablement faire mieux, puisque notre modèle va aussi prédire la ponctuation et la casse, qui ne sont pas présents dans la référence. Transmettons l’échantillon audio au pipeline pour obtenir notre prédiction de texte. Une chose à noter est que le pipeline <em>consomme</em> le dictionnaire des entrées audio que nous entrons, ce qui signifie que le dictionnaire ne peut pas être réutilisé. Pour contourner ce problème, nous allons passer une <em>copie</em> de l’échantillon audio, afin de pouvoir réutiliser le même échantillon audio dans les exemples de code suivants :",Ws,Me,Zs,he,on="<strong>Sortie :</strong>",Hs,ye,Ns,Te,rn="Super, cela ressemble énormément à notre texte de référence (sans doute mieux car il a une ponctuation et une casse !). Vous remarquerez que nous avons transféré <code>&quot;task&quot;</code> en tant que <em>generate kwarg</em>. Définir la <code>&quot;task&quot;</code> à <code>&quot;transcribe&quot;</code> oblige Whisper à effectuer la tâche de reconnaissance de la parole, où l’audio est transcrit dans la même langue que le discours a été prononcé. Whisper est également capable d’effectuer la tâche étroitement liée de traduction de la parole, où l’audio en espagnol peut être traduit en texte en anglais. Pour y parvenir, nous définissons la <code>&quot;task&quot;</code> sur <code>&quot;translate&quot;</code> :",Ys,Ue,Qs,Je,pn="<strong>Sortie :</strong>",Ls,je,_s,we,un=`Maintenant que nous savons que nous pouvons basculer entre la reconnaissance automatique de la parole et la traduction de la parole, nous pouvons choisir notre tâche en fonction de nos besoins. Soit nous reconnaissons l’audio dans la langue X vers le texte dans la même langue X (par exemple, l’audio espagnol vers le texte espagnol), soit nous traduisons de l’audio dans n’importe quelle langue X vers du texte en anglais (par exemple, l’audio espagnol vers le texte anglais).
Pour en savoir plus sur la façon dont l’argument <code>&quot;task&quot;</code> est utilisé pour contrôler les propriétés du texte généré, reportez-vous à la <a href="https://huggingface.co/openai/whisper-base#usage" rel="nofollow">carte de modèle</a> pour le modèle Whisper base.`,zs,be,Xs,ge,dn=`Jusqu’à présent, nous nous sommes concentrés sur la transcription de courts échantillons audio de moins de 30 secondes. Nous avons mentionné que l’un des attraits de Whisper était sa capacité à travailler sur de longs échantillons audio. Nous allons nous attaquer à cette tâche ici !
Créons un long fichier audio en concaténant des échantillons successifs à partir du jeu de données MLS. Étant donné que MLS est organisé en divisant de longs enregistrements de livres audio en segments plus courts, la concaténation d’échantillons est un moyen de reconstruire des passages de livres audio plus longs. Par conséquent, l’audio résultant doit être cohérent sur l’ensemble de l’échantillon. Nous allons définir notre durée audio cible sur 5 minutes et arrêter de concaténer des échantillons une fois que nous aurons atteint cette valeur :`,As,fe,Ps,ve,cn="<strong>Sortie :</strong>",Os,Ie,Ds,Se,mn="5 minutes et 17 secondes d’audio à transcrire. Le transfert de ce long échantillon audio directement vers le modèle pose deux problèmes :",Ks,xe,Mn=`<li>Whisper est intrinsèquement conçu pour fonctionner avec des échantillons de 30 secondes. Tout ce qui est inférieur à 30s est rembourré à 30s avec du silence, et tout ce qui dépasse 30s est tronqué à 30s en coupant l’audio excédentaire. Donc si nous passons notre audio directement, nous n’obtiendrons la transcription que pour les 30 premières secondes</li> <li>La mémoire dans un <em>transformer</em> évolue quadratiquement avec la longueur de séquence a : doubler la longueur d’entrée quadruple le besoin en mémoire, de sorte que le passage de fichiers audio très longs entraînera inévitablement une erreur de mémoire insuffisante (OOM : out-of-memory)
La transcription de longs audio fonctionne dans 🤗 <em>Transformers</em> en segmentant l’audio d’entrée en segments plus petits et plus faciles à gérer.
Chaque segment a un petit chevauchement avec le précédent. Cela nous permet de recoudre avec précision les segments aux bornes, car nous pouvons trouver le chevauchement entre les segments et fusionner les transcriptions en conséquence :</li>`,et,g,hn='<img src="https://huggingface.co/blog/assets/49_asr_chunking/Striding.png" alt="🤗 Transformers chunking algorithm. Source: https://huggingface.co/blog/asr-chunking."/>',st,h,ft,tt,Sn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',nt,lt,xn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',at,We,yn="sans états",vt,ot,Bn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',it,rt,En='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',pt,Ze,Tn="batch",It,He,Un="Transformers",St,f,Jn="https://huggingface.co/blog/asr-chunking",xt,Ne,jn="chunk_length_s",Bt,Ye,wn="batch_size",Et,ut,Be,dt,Ee,bn="<strong>Sortie :</strong>",ct,ke,mt,Ce,gn=`Nous n’affichons pas toute la sortie ici car elle est assez longue (312 mots au total). Sur un GPU V100 de 16 Go, vous pouvez vous attendre à ce que la ligne ci-dessus prenne environ 3,45 secondes à s’éxécuter, ce qui est assez bon pour un échantillon audio de 317 secondes. Sur un CPU, attendez-vous à plus de 30 secondes.
Whisper est également capable de prédire les <em>horodatages</em> au niveau du segment pour les données audio. Ces horodatages indiquent l’heure de début et de fin d’un court passage audio et sont particulièrement utiles pour aligner une transcription avec l’audio d’entrée. Supposons que nous voulions fournir des sous-titres pour une vidéo. Nous avons besoin de ces horodatages pour savoir quelle partie de la transcription correspond à un certain segment de vidéo, afin d’afficher la transcription correcte pour cette heure.
L’activation de la prédiction d’horodatage est simple, il suffit de définir l’argument <code>return_timestamps=True</code>. Les horodatages sont compatibles avec les méthodes de segmentation et de traitement par batchs que nous avons utilisées précédemment. Nous pouvons donc simplement ajouter l’argument timestamp à notre code précédent :`,Mt,Ge,ht,qe,fn="<strong>Sortie :</strong>",yt,Re,Tt,Ve,vn="Et le tour est joué ! Nous avons notre texte prédit ainsi que les horodatages correspondants.",Ut,$e,Jt,Fe,In=`Whisper est un modèle pré-entraîné solide pour la reconnaissance automatique de la parole et la traduction. Par rapport à Wav2Vec2, il a une plus grande précision de transcription, avec des sorties qui contiennent la ponctuation et la casse. Il peut être utilisé pour transcrire la parole en anglais ainsi que dans 96 autres langues, à la fois sur des segments audio courts et des segments plus longs par le biais de  la segmentation. Ces attributs en font un modèle viable pour de nombreuses tâches de reconnaissance automatique de la parole et de traduction sans avoir besoin d’être <em>finetuné</em>. La méthode <code>pipeline()</code> fournit un moyen facile d’inférer en une ligne de code avec un contrôle sur les prédictions générées.
Bien que le modèle Whisper fonctionne extrêmement bien sur de nombreuses langues à ressources élevées, il a une précision de transcription et de traduction plus faible sur les langues à faibles ressources, c’est-à-dire celles pour lesquelles les données d’apprentissage sont moins facilement disponibles. Les performances varient également selon les accents et dialectes de certaines langues, y compris une précision moindre pour les locuteurs de différents sexes, races, âges ou autres critères démographiques (<em>cf.</em> le papier de <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper</a>).
Pour améliorer les performances sur les langues, les accents ou les dialectes à faibles ressources, nous pouvons prendre le modèle Whisper pré-entraîné et l’entraîner sur un petit corpus de données sélectionnées de manière appropriée, dans un processus appelé <em><em>finetuning</em></em>. Nous montrerons qu’avec seulement dix heures de données supplémentaires, nous pouvons améliorer les performances du modèle Whisper de plus de 100% sur une langue à faibles ressources. Dans la section suivante, nous aborderons le processus de sélection d’un jeu de données à <em>finetuner</em>.`,jt,_e,wt;return v=new ze({props:{title:"Modèles pré-entraînés pour la reconnaissance automatique de la parole",local:"modèles-pré-entraînés-pour-la-reconnaissance-automatique-de-la-parole",headingTag:"h1"}}),E=new ze({props:{title:"Sonder les modèles CTC",local:"sonder-les-modèles-ctc",headingTag:"h2"}}),C=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMEEpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(
    <span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>
)
dataset`,wrap:!1}}),q=new y({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidmaWxlJyUyQyUyMCdhdWRpbyclMkMlMjAndGV4dCclMkMlMjAnc3BlYWtlcl9pZCclMkMlMjAnY2hhcHRlcl9pZCclMkMlMjAnaWQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA3MyUwQSU3RCk=",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;speaker_id&#x27;</span>, <span class="hljs-string">&#x27;chapter_id&#x27;</span>, <span class="hljs-string">&#x27;id&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">73</span>
})`,wrap:!1}}),V=new y({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjIlNUQlMEElMEFwcmludChzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEKSUwQUF1ZGlvKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByYXRlJTNEc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sample = dataset[<span class="hljs-number">2</span>]

<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),F=new y({props:{code:"SEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5E",highlighted:'HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND',wrap:!1}}),Z=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS0xMDBoJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;facebook/wav2vec2-base-100h&quot;</span>)`,wrap:!1}}),N=new y({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCkpJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMCUyMkhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMENIUklTVE1BVVMlMjBBTkQlMjBST1NFJTIwQkVFRiUyMExPT01JTkclMjBCRUZPUkUlMjBVUyUyMFNJTUFMWUlTJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQlMjIlMEElN0Q=",highlighted:`pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())
{
    <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;HE TELLS US THAT AT THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAUS AND ROSE BEEF LOOMING BEFORE US SIMALYIS DRAWN FROM EATING AND ITS RESULTS OCCUR MOST READILY TO THE MIND&quot;</span>
}`,wrap:!1}}),Q=new y({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMCUyMEhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMCoqQ0hSSVNUTUFVUyoqJTIwQU5EJTIwKipST1NFKiolMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwKipTSU1BTFlJUyoqJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQ=",highlighted:`<span class="hljs-symbol">Target:</span>      HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span>  HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH **CHRISTMAUS** <span class="hljs-keyword">AND </span>**ROSE** <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US **SIMALYIS** DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND`,wrap:!1}}),X=new ze({props:{title:"Passage à Seq2Seq",local:"passage-à-seq2seq",headingTag:"h2"}}),ee=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`,wrap:!1}}),te=new y({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>)',wrap:!1}}),le=new y({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMENocmlzdG1hcyUyMGFuZCUyMHJvYXN0JTIwYmVlZiUyMGxvb21pbmclMjBiZWZvcmUlMjB1cyUyQyUyMHNpbWlsYXJseSUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQuJyU3RA==",highlighted:'{&#x27;<span class="hljs-built_in">text</span>&#x27;: &#x27; He tells us <span class="hljs-keyword">that</span> <span class="hljs-keyword">at</span> this festive season <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span>, <span class="hljs-keyword">with</span> Christmas <span class="hljs-keyword">and</span> roast beef looming <span class="hljs-keyword">before</span> us, similarly <span class="hljs-keyword">is</span> drawn <span class="hljs-keyword">from</span> eating <span class="hljs-keyword">and</span> <span class="hljs-keyword">its</span> results occur most readily <span class="hljs-keyword">to</span> <span class="hljs-keyword">the</span> mind.&#x27;}',wrap:!1}}),oe=new y({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMCoqQ2hyaXN0bWFzKiolMjBhbmQlMjAqKnJvYXN0KiolMjBiZWVmJTIwbG9vbWluZyUyMGJlZm9yZSUyMHVzJTJDJTIwKipzaW1pbGFybHkqKiUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQu",highlighted:`<span class="hljs-symbol">Target:</span>     HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span> He tells us that <span class="hljs-built_in">at</span> this festive season of the year, with **Christmas** <span class="hljs-keyword">and </span>**roast** <span class="hljs-keyword">beef </span>looming <span class="hljs-keyword">before </span>us, **similarly** is drawn from eating <span class="hljs-keyword">and </span>its results occur most readily to the mind.`,wrap:!1}}),re=new y({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm11bHRpbGluZ3VhbF9saWJyaXNwZWVjaCUyMiUyQyUyMCUyMnNwYW5pc2glMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTBBKSUwQXNhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSk=",highlighted:`dataset = load_dataset(
    <span class="hljs-string">&quot;facebook/multilingual_librispeech&quot;</span>, <span class="hljs-string">&quot;spanish&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`,wrap:!1}}),ue=new y({props:{code:"cHJpbnQoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMEFBdWRpbyhzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmF0ZSUzRHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),ce=new y({props:{code:"ZW50b25jZXMlMjB0ZSUyMGRlbGVsaXRhciVDMyVBMXMlMjBlbiUyMGplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjAlQzMlQTElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwamFjb2IlMjB0dSUyMHBhZHJlJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBqZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRv",highlighted:'entonces <span class="hljs-keyword">te</span> delelitarás <span class="hljs-keyword">en</span> jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré á comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> jehová lo ha hablado',wrap:!1}}),Me=new y({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiUyQyUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMnRhc2slMjIlM0ElMjAlMjJ0cmFuc2NyaWJlJTIyJTdEKQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy(), max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>})',wrap:!1}}),ye=new y({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUyMGhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4nJTdE",highlighted:'{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> Jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado.&#x27;}',wrap:!1}}),Ue=new y({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zbGF0ZSUyMiU3RCk=",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})',wrap:!1}}),je=new y({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMFNvJTIweW91JTIwd2lsbCUyMGNob29zZSUyMGluJTIwSmVob3ZhaCUyMGFuZCUyMEklMjB3aWxsJTIwcmFpc2UlMjB5b3UlMjBvbiUyMHRoZSUyMGhlaWdodHMlMjBvZiUyMHRoZSUyMGVhcnRoJTIwYW5kJTIwSSUyMHdpbGwlMjBnaXZlJTIweW91JTIwdGhlJTIwaG9ub3IlMjBvZiUyMEphY29iJTIwdG8lMjB5b3VyJTIwZmF0aGVyJTIwYmVjYXVzZSUyMHRoZSUyMHZvaWNlJTIwb2YlMjBKZWhvdmFoJTIwaGFzJTIwc3Bva2VuJTIwdG8lMjB5b3UuJyU3RA==",highlighted:'<span class="hljs-comment">{&#x27;text&#x27;: &#x27; So you will choose in Jehovah and I will raise you on the heights of the earth and I will give you the honor of Jacob to your father because the voice of Jehovah has spoken to you.&#x27;}</span>',wrap:!1}}),be=new ze({props:{title:"Longue transcription et horodatage",local:"longue-transcription-et-horodatage",headingTag:"h2"}}),fe=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBdGFyZ2V0X2xlbmd0aF9pbl9tJTIwJTNEJTIwNSUwQSUwQSUyMyUyMGNvbnZlcnRpciUyMGxlcyUyMG1pbnV0ZXMlMjBlbiUyMHNlY29uZGVzJTIwKColMjA2MCklMjBlbiUyMG5vbWJyZSUyMGQnJUMzJUE5Y2hhbnRpbGxvbnMlMjAoKiUyMHRhdXglMjBkJyVDMyVBOWNoYW50aWxsb25uYWdlKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBwaXBlLmZlYXR1cmVfZXh0cmFjdG9yLnNhbXBsaW5nX3JhdGUlMEF0YXJnZXRfbGVuZ3RoX2luX3NhbXBsZXMlMjAlM0QlMjB0YXJnZXRfbGVuZ3RoX2luX20lMjAqJTIwNjAlMjAqJTIwc2FtcGxpbmdfcmF0ZSUwQSUwQSUyMyUyMGl0JUMzJUE5cmVyJTIwc3VyJTIwbm90cmUlMjBqZXUlMjBkZSUyMGRvbm4lQzMlQTllcyUyMGVuJTIwc3RyZWFtaW5nJTJDJTIwZW4lMjBjb25jYXQlQzMlQTluYW50JTIwbGVzJTIwJUMzJUE5Y2hhbnRpbGxvbnMlMjBqdXNxdSclQzMlQTAlMjBjZSUyMHF1ZSUyMG5vdXMlMjBhdHRlaWduaW9ucyUyMG5vdHJlJTIwY2libGUlMEFsb25nX2F1ZGlvJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwc2FtcGxlJTIwaW4lMjBkYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwbG9uZ19hdWRpby5leHRlbmQoc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCklMEElMjAlMjAlMjAlMjBpZiUyMGxlbihsb25nX2F1ZGlvKSUyMCUzRSUyMHRhcmdldF9sZW5ndGhfaW5fc2FtcGxlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBbG9uZ19hdWRpbyUyMCUzRCUyMG5wLmFzYXJyYXkobG9uZ19hdWRpbyklMEElMEElMjMlMjBSJUMzJUE5c3VsdGF0JTBBc2Vjb25kcyUyMCUzRCUyMGxlbihsb25nX2F1ZGlvKSUyMCUyRiUyMDE2MDAwJTBBbWludXRlcyUyQyUyMHNlY29uZHMlMjAlM0QlMjBkaXZtb2Qoc2Vjb25kcyUyQyUyMDYwKSUwQXByaW50KGYlMjJMZW5ndGglMjBvZiUyMGF1ZGlvJTIwc2FtcGxlJTIwaXMlMjAlN0JtaW51dGVzJTdEJTIwbWludXRlcyUyMCU3QnNlY29uZHMlM0EuMmYlN0QlMjBzZWNvbmRzJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_length_in_m = <span class="hljs-number">5</span>

<span class="hljs-comment"># convertir les minutes en secondes (* 60) en nombre d&#x27;échantillons (* taux d&#x27;échantillonnage)</span>
sampling_rate = pipe.feature_extractor.sampling_rate
target_length_in_samples = target_length_in_m * <span class="hljs-number">60</span> * sampling_rate

<span class="hljs-comment"># itérer sur notre jeu de données en streaming, en concaténant les échantillons jusqu&#x27;à ce que nous atteignions notre cible</span>
long_audio = []
<span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> dataset:
    long_audio.extend(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(long_audio) &gt; target_length_in_samples:
        <span class="hljs-keyword">break</span>

long_audio = np.asarray(long_audio)

<span class="hljs-comment"># Résultat</span>
seconds = <span class="hljs-built_in">len</span>(long_audio) / <span class="hljs-number">16000</span>
minutes, seconds = <span class="hljs-built_in">divmod</span>(seconds, <span class="hljs-number">60</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Length of audio sample is <span class="hljs-subst">{minutes}</span> minutes <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)`,wrap:!1}}),Ie=new y({props:{code:"TGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwNS4wJTIwbWludXRlcyUyMDE3LjIyJTIwc2Vjb25kcw==",highlighted:'<span class="hljs-attribute">Length</span> of audio sample is <span class="hljs-number">5</span>.<span class="hljs-number">0</span> minutes <span class="hljs-number">17</span>.<span class="hljs-number">22</span> seconds',wrap:!1}}),Be=new y({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
)`,wrap:!1}}),ke=new y({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTJDJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMkMlMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUwQWhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyQyUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4lMjBub3NvdHJvcyUyMGN1cmFkb3MuJTIwVG9kb3MlMjBub3NvdHJvcyUyMG5vcyUyMGRlc2NhcnJpYW1vcyUwQWNvbW8lMjBiZWphcyUyQyUyMGNhZGElMjBjdWFsJTIwc2UlMjBhcGFydCVDMyVCMyUyMHBvciUyMHN1JTIwY2FtaW5vJTJDJTIwbWFzJTIwSmVob3YlQzMlQTElMjBjYXJnJUMzJUIzJTIwZW4lMjAlQzMlQTlsJTIwZWwlMjBwZWNhZG8lMjBkZSUyMHRvZG9zJTIwbm9zb3Ryb3MuLi4=",highlighted:`{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová, y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra, y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span>
heredad <span class="hljs-keyword">de</span> Jacob tu padre, porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos
como bejas, cada cual <span class="hljs-keyword">se</span> apartó por <span class="hljs-keyword">su</span> camino, mas Jehová cargó <span class="hljs-keyword">en</span> é<span class="hljs-keyword">l</span> el pecado <span class="hljs-keyword">de</span> todos nosotros...`,wrap:!1}}),Ge=new y({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSUyQyUwQSklNUIlMjJjaHVua3MlMjIlNUQ=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
    return_timestamps=<span class="hljs-literal">True</span>,
)[<span class="hljs-string">&quot;chunks&quot;</span>]`,wrap:!1}}),Re=new y({props:{code:"JTVCJTdCJ3RpbWVzdGFtcCclM0ElMjAoMC4wJTJDJTIwMjYuNCklMkMlMEElMjAlMjAndGV4dCclM0ElMjAnJTIwRW50b25jZXMlMjB0ZSUyMGRlbGVpdGFyJUMzJUExcyUyMGVuJTIwSmVob3YlQzMlQTElMkMlMjB5JTIweW8lMjB0ZSUyMGhhciVDMyVBOSUyMHN1YmlyJTIwc29icmUlMjBsYXMlMjBhbHR1cmFzJTIwZGUlMjBsYSUyMHRpZXJyYSUyQyUyMHklMjB0ZSUyMGRhciVDMyVBOSUyMGElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwSmFjb2IlMjB0dSUyMHBhZHJlJTJDJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBKZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRvLiUyMG5vc290cm9zJTIwY3VyYWRvcy4lMjBUb2RvcyUyMG5vc290cm9zJTIwbm9zJTIwZGVzY2FycmlhbW9zJTIwY29tbyUyMGJlamFzJTJDJTIwY2FkYSUyMGN1YWwlMjBzZSUyMGFwYXJ0JUMzJUIzJTIwcG9yJTIwc3UlMjBjYW1pbm8lMkMnJTdEJTJDJTBBJTIwJTdCJ3RpbWVzdGFtcCclM0ElMjAoMjYuNCUyQyUyMDMyLjQ4KSUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCclMjBtYXMlMjBKZWhvdiVDMyVBMSUyMGNhcmclQzMlQjMlMjBlbiUyMCVDMyVBOWwlMjBlbCUyMHBlY2FkbyUyMGRlJTIwdG9kb3MlMjBub3NvdHJvcy4lMjBObyUyMGVzJTIwcXVlJTIwcGFydGFzJTIwdHUlMjBwYW4lMjBjb24lMjBlbCclN0QlMkMlMEElMjAlN0IndGltZXN0YW1wJyUzQSUyMCgzMi40OCUyQyUyMDM4LjQpJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyUyMGhhbWJyaWVudG8lMjB5JTIwYSUyMGxvcyUyMGhvbWJyZXMlMjBoZXJyYW50ZXMlMjBtZXRhcyUyMGVuJTIwY2FzYSUyQyUyMHF1ZSUyMGN1YW5kbyUyMHZpZXJlcyUyMGFsJTIwZGVzbnVkbyUyMGxvJTIwY3VicmFzJTIweSUyMG5vJyU3RCUyQyUwQSUyMC4uLg==",highlighted:`[{<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">0.0</span>, <span class="hljs-number">26.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; Entonces te deleitarás en Jehová, y yo te haré subir sobre las alturas de la tierra, y te daré a comer la heredad de Jacob tu padre, porque la boca de Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos como bejas, cada cual se apartó por su camino,&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">26.4</span>, <span class="hljs-number">32.48</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; mas Jehová cargó en él el pecado de todos nosotros. No es que partas tu pan con el&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">32.48</span>, <span class="hljs-number">38.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; hambriento y a los hombres herrantes metas en casa, que cuando vieres al desnudo lo cubras y no&#x27;},
 ...`,wrap:!1}}),$e=new ze({props:{title:"Résumé",local:"résumé",headingTag:"h2"}}),{c(){w=o("meta"),Xe=l(),Le=o("p"),Ae=l(),p(v.$$.fragment),Pe=l(),I=o("p"),I.innerHTML=Gt,Oe=l(),S=o("p"),S.textContent=qt,De=l(),x=o("ol"),x.innerHTML=Rt,Ke=l(),B=o("p"),B.innerHTML=Vt,es=l(),p(E.$$.fragment),ss=l(),k=o("p"),k.innerHTML=$t,ts=l(),p(C.$$.fragment),ns=l(),G=o("p"),G.innerHTML=Ft,ls=l(),p(q.$$.fragment),as=l(),R=o("p"),R.textContent=Wt,os=l(),p(V.$$.fragment),is=l(),$=o("p"),$.innerHTML=Zt,rs=l(),p(F.$$.fragment),ps=l(),W=o("p"),W.innerHTML=Ht,us=l(),p(Z.$$.fragment),ds=l(),H=o("p"),H.innerHTML=Nt,cs=l(),p(N.$$.fragment),ms=l(),Y=o("p"),Y.textContent=Yt,Ms=l(),p(Q.$$.fragment),hs=l(),L=o("p"),L.innerHTML=Qt,ys=l(),_=o("ul"),_.innerHTML=Lt,Ts=l(),b=o("div"),b.innerHTML=_t,Us=l(),z=o("p"),z.innerHTML=zt,Js=l(),p(X.$$.fragment),js=l(),A=o("p"),A.innerHTML=Xt,ws=l(),P=o("ol"),P.innerHTML=At,bs=l(),O=o("p"),O.innerHTML=Pt,gs=l(),D=o("table"),D.innerHTML=Ot,fs=l(),K=o("p"),K.innerHTML=Dt,vs=l(),p(ee.$$.fragment),Is=l(),se=o("p"),se.innerHTML=Kt,Ss=l(),p(te.$$.fragment),xs=l(),ne=o("p"),ne.innerHTML=en,Bs=l(),p(le.$$.fragment),Es=l(),ae=o("p"),ae.textContent=sn,ks=l(),p(oe.$$.fragment),Cs=l(),ie=o("p"),ie.innerHTML=tn,Gs=l(),p(re.$$.fragment),qs=l(),pe=o("p"),pe.textContent=nn,Rs=l(),p(ue.$$.fragment),Vs=l(),de=o("p"),de.innerHTML=ln,$s=l(),p(ce.$$.fragment),Fs=l(),me=o("p"),me.innerHTML=an,Ws=l(),p(Me.$$.fragment),Zs=l(),he=o("p"),he.innerHTML=on,Hs=l(),p(ye.$$.fragment),Ns=l(),Te=o("p"),Te.innerHTML=rn,Ys=l(),p(Ue.$$.fragment),Qs=l(),Je=o("p"),Je.innerHTML=pn,Ls=l(),p(je.$$.fragment),_s=l(),we=o("p"),we.innerHTML=un,zs=l(),p(be.$$.fragment),Xs=l(),ge=o("p"),ge.textContent=dn,As=l(),p(fe.$$.fragment),Ps=l(),ve=o("p"),ve.innerHTML=cn,Os=l(),p(Ie.$$.fragment),Ds=l(),Se=o("p"),Se.textContent=mn,Ks=l(),xe=o("ol"),xe.innerHTML=Mn,et=l(),g=o("div"),g.innerHTML=hn,st=l(),h=o("p"),ft=J("L’avantage de segmenter les échantillons est que nous n’avons pas besoin du résultat du bloc "),tt=new bt(!1),nt=J(" pour transcrire le morceau suivant "),lt=new bt(!1),at=J(". La couture est effectuée après que nous ayons transcrit tous les morceaux aux bornes des morceaux. Donc peu importe l’ordre dans lequel nous transcrivons les morceaux. L’algorithme est entièrement "),We=o("strong"),We.textContent=yn,vt=J(", donc nous pouvons même faire du découpage sur "),ot=new bt(!1),it=J(" en même temps que du découpage sur "),rt=new bt(!1),pt=J(" ! Cela nous permet de former des "),Ze=o("em"),Ze.textContent=Tn,It=J(" de morceaux et de les exécuter dans le modèle en parallèle, offrant une grande accélération de calcul par rapport à leur transcription séquentielle. Pour en savoir plus sur la segmentation d’audio dans 🤗 "),He=o("em"),He.textContent=Un,St=J(", vous pouvez vous référer à cet [article de blog] ("),f=o("a"),f.textContent=Jn,xt=J(`) (en anglais).
Pour activer les longues transcriptions, nous devons ajouter un argument supplémentaire lorsque nous appelons le pipeline. Cet argument, `),Ne=o("code"),Ne.textContent=jn,Bt=J(`, contrôle la longueur des segments divisés en secondes. Pour Whisper, des morceaux de 30 secondes sont optimaux, car cela correspond à la longueur d’entrée attendue par Whisper.
Pour activer le traitement par batch, nous devons passer l’argument `),Ye=o("code"),Ye.textContent=wn,Et=J(" au pipeline. En mettant tout cela ensemble, nous pouvons transcrire le long échantillon audio comme suit:"),ut=l(),p(Be.$$.fragment),dt=l(),Ee=o("p"),Ee.innerHTML=bn,ct=l(),p(ke.$$.fragment),mt=l(),Ce=o("p"),Ce.innerHTML=gn,Mt=l(),p(Ge.$$.fragment),ht=l(),qe=o("p"),qe.innerHTML=fn,yt=l(),p(Re.$$.fragment),Tt=l(),Ve=o("p"),Ve.textContent=vn,Ut=l(),p($e.$$.fragment),Jt=l(),Fe=o("p"),Fe.innerHTML=In,jt=l(),_e=o("p"),this.h()},l(e){const s=Vn("svelte-u9bgzb",document.head);w=i(s,"META",{name:!0,content:!0}),s.forEach(t),Xe=a(e),Le=i(e,"P",{}),kt(Le).forEach(t),Ae=a(e),u(v.$$.fragment,e),Pe=a(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-3vbmup"&&(I.innerHTML=Gt),Oe=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1hil8d"&&(S.textContent=qt),De=a(e),x=i(e,"OL",{"data-svelte-h":!0}),r(x)!=="svelte-1n4dhmh"&&(x.innerHTML=Rt),Ke=a(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1u61o1g"&&(B.innerHTML=Vt),es=a(e),u(E.$$.fragment,e),ss=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1gr743m"&&(k.innerHTML=$t),ts=a(e),u(C.$$.fragment,e),ns=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-dbzevp"&&(G.innerHTML=Ft),ls=a(e),u(q.$$.fragment,e),as=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1a8dqyk"&&(R.textContent=Wt),os=a(e),u(V.$$.fragment,e),is=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-dbzevp"&&($.innerHTML=Zt),rs=a(e),u(F.$$.fragment,e),ps=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-dkq6xg"&&(W.innerHTML=Ht),us=a(e),u(Z.$$.fragment,e),ds=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1anz7jf"&&(H.innerHTML=Nt),cs=a(e),u(N.$$.fragment,e),ms=a(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1qo7344"&&(Y.textContent=Yt),Ms=a(e),u(Q.$$.fragment,e),hs=a(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-rp0hzj"&&(L.innerHTML=Qt),ys=a(e),_=i(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-64w2eh"&&(_.innerHTML=Lt),Ts=a(e),b=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-koi3b6"&&(b.innerHTML=_t),Us=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-13smvyy"&&(z.innerHTML=zt),Js=a(e),u(X.$$.fragment,e),js=a(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-ybukjk"&&(A.innerHTML=Xt),ws=a(e),P=i(e,"OL",{"data-svelte-h":!0}),r(P)!=="svelte-m4uc4o"&&(P.innerHTML=At),bs=a(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-19vk3ts"&&(O.innerHTML=Pt),gs=a(e),D=i(e,"TABLE",{"data-svelte-h":!0}),r(D)!=="svelte-1gqxr00"&&(D.innerHTML=Ot),fs=a(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1gihkbk"&&(K.innerHTML=Dt),vs=a(e),u(ee.$$.fragment,e),Is=a(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1ycfnts"&&(se.innerHTML=Kt),Ss=a(e),u(te.$$.fragment,e),xs=a(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-dbzevp"&&(ne.innerHTML=en),Bs=a(e),u(le.$$.fragment,e),Es=a(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1lwymx8"&&(ae.textContent=sn),ks=a(e),u(oe.$$.fragment,e),Cs=a(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-99semi"&&(ie.innerHTML=tn),Gs=a(e),u(re.$$.fragment,e),qs=a(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1e3nkoe"&&(pe.textContent=nn),Rs=a(e),u(ue.$$.fragment,e),Vs=a(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-dbzevp"&&(de.innerHTML=ln),$s=a(e),u(ce.$$.fragment,e),Fs=a(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1vlpheo"&&(me.innerHTML=an),Ws=a(e),u(Me.$$.fragment,e),Zs=a(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-dbzevp"&&(he.innerHTML=on),Hs=a(e),u(ye.$$.fragment,e),Ns=a(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1kcg18j"&&(Te.innerHTML=rn),Ys=a(e),u(Ue.$$.fragment,e),Qs=a(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-dbzevp"&&(Je.innerHTML=pn),Ls=a(e),u(je.$$.fragment,e),_s=a(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1yhnauy"&&(we.innerHTML=un),zs=a(e),u(be.$$.fragment,e),Xs=a(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-vcnxm4"&&(ge.textContent=dn),As=a(e),u(fe.$$.fragment,e),Ps=a(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-dbzevp"&&(ve.innerHTML=cn),Os=a(e),u(Ie.$$.fragment,e),Ds=a(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1y5e1ug"&&(Se.textContent=mn),Ks=a(e),xe=i(e,"OL",{"data-svelte-h":!0}),r(xe)!=="svelte-1qi514d"&&(xe.innerHTML=Mn),et=a(e),g=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-dbmn5s"&&(g.innerHTML=hn),st=a(e),h=i(e,"P",{});var T=kt(h);ft=j(T,"L’avantage de segmenter les échantillons est que nous n’avons pas besoin du résultat du bloc "),tt=gt(T,!1),nt=j(T," pour transcrire le morceau suivant "),lt=gt(T,!1),at=j(T,". La couture est effectuée après que nous ayons transcrit tous les morceaux aux bornes des morceaux. Donc peu importe l’ordre dans lequel nous transcrivons les morceaux. L’algorithme est entièrement "),We=i(T,"STRONG",{"data-svelte-h":!0}),r(We)!=="svelte-1kau282"&&(We.textContent=yn),vt=j(T,", donc nous pouvons même faire du découpage sur "),ot=gt(T,!1),it=j(T," en même temps que du découpage sur "),rt=gt(T,!1),pt=j(T," ! Cela nous permet de former des "),Ze=i(T,"EM",{"data-svelte-h":!0}),r(Ze)!=="svelte-1swb9sm"&&(Ze.textContent=Tn),It=j(T," de morceaux et de les exécuter dans le modèle en parallèle, offrant une grande accélération de calcul par rapport à leur transcription séquentielle. Pour en savoir plus sur la segmentation d’audio dans 🤗 "),He=i(T,"EM",{"data-svelte-h":!0}),r(He)!=="svelte-1c497z6"&&(He.textContent=Un),St=j(T,", vous pouvez vous référer à cet [article de blog] ("),f=i(T,"A",{href:!0,rel:!0,"data-svelte-h":!0}),r(f)!=="svelte-wh64se"&&(f.textContent=Jn),xt=j(T,`) (en anglais).
Pour activer les longues transcriptions, nous devons ajouter un argument supplémentaire lorsque nous appelons le pipeline. Cet argument, `),Ne=i(T,"CODE",{"data-svelte-h":!0}),r(Ne)!=="svelte-1ihfftk"&&(Ne.textContent=jn),Bt=j(T,`, contrôle la longueur des segments divisés en secondes. Pour Whisper, des morceaux de 30 secondes sont optimaux, car cela correspond à la longueur d’entrée attendue par Whisper.
Pour activer le traitement par batch, nous devons passer l’argument `),Ye=i(T,"CODE",{"data-svelte-h":!0}),r(Ye)!=="svelte-1grlmso"&&(Ye.textContent=wn),Et=j(T," au pipeline. En mettant tout cela ensemble, nous pouvons transcrire le long échantillon audio comme suit:"),T.forEach(t),ut=a(e),u(Be.$$.fragment,e),dt=a(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-dbzevp"&&(Ee.innerHTML=bn),ct=a(e),u(ke.$$.fragment,e),mt=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-zgfrlv"&&(Ce.innerHTML=gn),Mt=a(e),u(Ge.$$.fragment,e),ht=a(e),qe=i(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-dbzevp"&&(qe.innerHTML=fn),yt=a(e),u(Re.$$.fragment,e),Tt=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1q3v7dp"&&(Ve.textContent=vn),Ut=a(e),u($e.$$.fragment,e),Jt=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-2z7mlq"&&(Fe.innerHTML=In),jt=a(e),_e=i(e,"P",{}),kt(_e).forEach(t),this.h()},h(){Qe(w,"name","hf:doc:metadata"),Qe(w,"content",Fn),Qe(b,"class","flex justify-center"),Qe(g,"class","flex justify-center"),tt.a=nt,lt.a=at,ot.a=it,rt.a=pt,Qe(f,"href","https://huggingface.co/blog/asr-chunking"),Qe(f,"rel","nofollow")},m(e,s){U(document.head,w),n(e,Xe,s),n(e,Le,s),n(e,Ae,s),d(v,e,s),n(e,Pe,s),n(e,I,s),n(e,Oe,s),n(e,S,s),n(e,De,s),n(e,x,s),n(e,Ke,s),n(e,B,s),n(e,es,s),d(E,e,s),n(e,ss,s),n(e,k,s),n(e,ts,s),d(C,e,s),n(e,ns,s),n(e,G,s),n(e,ls,s),d(q,e,s),n(e,as,s),n(e,R,s),n(e,os,s),d(V,e,s),n(e,is,s),n(e,$,s),n(e,rs,s),d(F,e,s),n(e,ps,s),n(e,W,s),n(e,us,s),d(Z,e,s),n(e,ds,s),n(e,H,s),n(e,cs,s),d(N,e,s),n(e,ms,s),n(e,Y,s),n(e,Ms,s),d(Q,e,s),n(e,hs,s),n(e,L,s),n(e,ys,s),n(e,_,s),n(e,Ts,s),n(e,b,s),n(e,Us,s),n(e,z,s),n(e,Js,s),d(X,e,s),n(e,js,s),n(e,A,s),n(e,ws,s),n(e,P,s),n(e,bs,s),n(e,O,s),n(e,gs,s),n(e,D,s),n(e,fs,s),n(e,K,s),n(e,vs,s),d(ee,e,s),n(e,Is,s),n(e,se,s),n(e,Ss,s),d(te,e,s),n(e,xs,s),n(e,ne,s),n(e,Bs,s),d(le,e,s),n(e,Es,s),n(e,ae,s),n(e,ks,s),d(oe,e,s),n(e,Cs,s),n(e,ie,s),n(e,Gs,s),d(re,e,s),n(e,qs,s),n(e,pe,s),n(e,Rs,s),d(ue,e,s),n(e,Vs,s),n(e,de,s),n(e,$s,s),d(ce,e,s),n(e,Fs,s),n(e,me,s),n(e,Ws,s),d(Me,e,s),n(e,Zs,s),n(e,he,s),n(e,Hs,s),d(ye,e,s),n(e,Ns,s),n(e,Te,s),n(e,Ys,s),d(Ue,e,s),n(e,Qs,s),n(e,Je,s),n(e,Ls,s),d(je,e,s),n(e,_s,s),n(e,we,s),n(e,zs,s),d(be,e,s),n(e,Xs,s),n(e,ge,s),n(e,As,s),d(fe,e,s),n(e,Ps,s),n(e,ve,s),n(e,Os,s),d(Ie,e,s),n(e,Ds,s),n(e,Se,s),n(e,Ks,s),n(e,xe,s),n(e,et,s),n(e,g,s),n(e,st,s),n(e,h,s),U(h,ft),tt.m(Sn,h),U(h,nt),lt.m(xn,h),U(h,at),U(h,We),U(h,vt),ot.m(Bn,h),U(h,it),rt.m(En,h),U(h,pt),U(h,Ze),U(h,It),U(h,He),U(h,St),U(h,f),U(h,xt),U(h,Ne),U(h,Bt),U(h,Ye),U(h,Et),n(e,ut,s),d(Be,e,s),n(e,dt,s),n(e,Ee,s),n(e,ct,s),d(ke,e,s),n(e,mt,s),n(e,Ce,s),n(e,Mt,s),d(Ge,e,s),n(e,ht,s),n(e,qe,s),n(e,yt,s),d(Re,e,s),n(e,Tt,s),n(e,Ve,s),n(e,Ut,s),d($e,e,s),n(e,Jt,s),n(e,Fe,s),n(e,jt,s),n(e,_e,s),wt=!0},p:Cn,i(e){wt||(c(v.$$.fragment,e),c(E.$$.fragment,e),c(C.$$.fragment,e),c(q.$$.fragment,e),c(V.$$.fragment,e),c(F.$$.fragment,e),c(Z.$$.fragment,e),c(N.$$.fragment,e),c(Q.$$.fragment,e),c(X.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(ue.$$.fragment,e),c(ce.$$.fragment,e),c(Me.$$.fragment,e),c(ye.$$.fragment,e),c(Ue.$$.fragment,e),c(je.$$.fragment,e),c(be.$$.fragment,e),c(fe.$$.fragment,e),c(Ie.$$.fragment,e),c(Be.$$.fragment,e),c(ke.$$.fragment,e),c(Ge.$$.fragment,e),c(Re.$$.fragment,e),c($e.$$.fragment,e),wt=!0)},o(e){m(v.$$.fragment,e),m(E.$$.fragment,e),m(C.$$.fragment,e),m(q.$$.fragment,e),m(V.$$.fragment,e),m(F.$$.fragment,e),m(Z.$$.fragment,e),m(N.$$.fragment,e),m(Q.$$.fragment,e),m(X.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(ue.$$.fragment,e),m(ce.$$.fragment,e),m(Me.$$.fragment,e),m(ye.$$.fragment,e),m(Ue.$$.fragment,e),m(je.$$.fragment,e),m(be.$$.fragment,e),m(fe.$$.fragment,e),m(Ie.$$.fragment,e),m(Be.$$.fragment,e),m(ke.$$.fragment,e),m(Ge.$$.fragment,e),m(Re.$$.fragment,e),m($e.$$.fragment,e),wt=!1},d(e){e&&(t(Xe),t(Le),t(Ae),t(Pe),t(I),t(Oe),t(S),t(De),t(x),t(Ke),t(B),t(es),t(ss),t(k),t(ts),t(ns),t(G),t(ls),t(as),t(R),t(os),t(is),t($),t(rs),t(ps),t(W),t(us),t(ds),t(H),t(cs),t(ms),t(Y),t(Ms),t(hs),t(L),t(ys),t(_),t(Ts),t(b),t(Us),t(z),t(Js),t(js),t(A),t(ws),t(P),t(bs),t(O),t(gs),t(D),t(fs),t(K),t(vs),t(Is),t(se),t(Ss),t(xs),t(ne),t(Bs),t(Es),t(ae),t(ks),t(Cs),t(ie),t(Gs),t(qs),t(pe),t(Rs),t(Vs),t(de),t($s),t(Fs),t(me),t(Ws),t(Zs),t(he),t(Hs),t(Ns),t(Te),t(Ys),t(Qs),t(Je),t(Ls),t(_s),t(we),t(zs),t(Xs),t(ge),t(As),t(Ps),t(ve),t(Os),t(Ds),t(Se),t(Ks),t(xe),t(et),t(g),t(st),t(h),t(ut),t(dt),t(Ee),t(ct),t(mt),t(Ce),t(Mt),t(ht),t(qe),t(yt),t(Tt),t(Ve),t(Ut),t(Jt),t(Fe),t(jt),t(_e)),t(w),M(v,e),M(E,e),M(C,e),M(q,e),M(V,e),M(F,e),M(Z,e),M(N,e),M(Q,e),M(X,e),M(ee,e),M(te,e),M(le,e),M(oe,e),M(re,e),M(ue,e),M(ce,e),M(Me,e),M(ye,e),M(Ue,e),M(je,e),M(be,e),M(fe,e),M(Ie,e),M(Be,e),M(ke,e),M(Ge,e),M(Re,e),M($e,e)}}}const Fn='{"title":"Modèles pré-entraînés pour la reconnaissance automatique de la parole","local":"modèles-pré-entraînés-pour-la-reconnaissance-automatique-de-la-parole","sections":[{"title":"Sonder les modèles CTC","local":"sonder-les-modèles-ctc","sections":[],"depth":2},{"title":"Passage à Seq2Seq","local":"passage-à-seq2seq","sections":[],"depth":2},{"title":"Longue transcription et horodatage","local":"longue-transcription-et-horodatage","sections":[],"depth":2},{"title":"Résumé","local":"résumé","sections":[],"depth":2}],"depth":1}';function Wn(Ct){return Gn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qn extends qn{constructor(w){super(),Rn(this,w,Wn,$n,kn,{})}}export{Qn as component};
