import{s as Ea,n as Sa,o as xa}from"../chunks/scheduler.f7e1785c.js";import{S as Ba,i as Qa,g as p,s as a,r as i,m as I,H as nt,A as Va,h as M,f as e,c as n,j as yt,u as U,x as J,n as b,E as pt,k as is,y as j,a as t,v as y,d as T,t as w,w as m}from"../chunks/index.9f8f0838.js";import{C as r}from"../chunks/CodeBlock.b3510e34.js";import{H as Us}from"../chunks/Heading.6643a2f7.js";function Ra(Tt){let c,ys,Ms,Ts,C,ws,f,wt=`В этом разделе мы рассмотрим, как с помощью <code>pipeline()</code> использовать предварительно обученные модели для распознавания речи.
В <a href="../chapter2/asr_pipeline">Разделе 2</a> мы представили <code>pipeline()</code> как простой способ выполнения задач распознавания речи с предварительной
и последующей обработкой “под капотом” и возможностью быстро экспериментировать с любой предварительно обученной контрольной точкой модели на Hugging Face Hub.
В этом разделе мы углубимся в изучение различных характеристик моделей распознавания речи и рассмотрим, как их можно использовать для решения различных задач.`,ms,E,mt="Как подробно описано в Разделе 3, модели распознавания речи в целом относятся к одной из двух категорий:",rs,S,rt="<li>Connectionist Temporal Classification (CTC) или Коннекционистская Временная Классификация: модели состящие только из энкодера, с головой линейного классификатора в вершине модели.</li> <li>Sequence-to-sequence (Seq2Seq) или последовательность-в-последовательность: модели включающие в себя как энкодер, так и декодер с механизмом перекрестного внимания между ними (cross-attention).</li>",hs,x,ht=`До 2022 года более популярной из двух архитектур была CTC, а такие модели, работающие только с энкодером, как Wav2Vec2, HuBERT и XLSR, совершили прорыв в парадигме
предварительного обучения/дообучения в задачах с речью. Крупные корпорации, такие как Meta и Microsoft, предварительно обучали энкодер на огромных объемах
неразмеченных аудиоданных в течение многих дней или недель. Затем пользователи могли взять предварительно обученную контрольную точку и дообучить ее с помощью
головы CTC всего на <strong>10 минутах</strong> размеченных речевых данных для достижения высоких результатов в последующей задаче распознавания речи.`,os,B,ot=`Однако модели CTC имеют свои недостатки. Присоединение простого линейного слоя к кодирующему устройству дает небольшую и быструю модель в целом, но она может
быть подвержена фонетическим ошибкам в написании. Ниже мы продемонстрируем это на примере модели Wav2Vec2.`,js,Q,cs,V,jt=`Загрузим небольшой фрагмент набора данных <a href="hf-internal-testing/librispeech_asr_dummy">LibriSpeech ASR</a> чтобы продемонстрировать возможности Wav2Vec2
по транскрибации речи:`,ds,R,us,k,ct="<strong>Output:</strong>",Is,g,bs,v,dt="Мы можем выбрать один из 73 аудиообразцов и просмотреть его, а также транскрипцию:",Cs,G,fs,$,ut="<strong>Output:</strong>",Es,F,Ss,H,It=`Хорошо! Рождество и запеченная в духовке говядина, звучит здорово! 🎄 Сформировав выборку данных, мы теперь загружаем
дообученную контрольную точку в <code>pipeline()</code>. Для этого мы будем использовать официальную контрольную точку <a href="facebook/wav2vec2-base-100h">Wav2Vec2 base</a>
дообученную на 100 часах данных LibriSpeech:`,xs,W,Bs,Z,bt=`Далее мы возьмем пример из набора данных и передадим его исходные данные в конвейер. Поскольку <code>pipeline</code> <em>поглощает</em> любой словарь, который мы ему
передаем (то есть его нельзя использовать повторно), мы будем передавать копию данных. Таким образом, мы можем безопасно повторно использовать один
и тот же аудиообразец в следующих примерах:`,Qs,N,Vs,_,Ct="<strong>Output:</strong>",Rs,Y,ks,A,ft=`Видно, что модель Wav2Vec2 неплохо справляется с транскрибацией данного образца - на первый взгляд, все выглядит в целом корректно.
Давайте поставим целевое значение (target) и прогноз/предсказание модели (prediction) рядом и выделим различия:`,gs,L,vs,z,Et="Сравнивая целевой текст с предсказанной транскрибацией, мы видим, что все слова <em>звучат</em> правильно, но некоторые написаны не совсем точно. Например:",Gs,X,St="<li><em>CHRISTMAUS</em> vs. <em>CHRISTMAS</em></li> <li><em>ROSE</em> vs. <em>ROAST</em></li> <li><em>SIMALYIS</em> vs. <em>SIMILES</em></li>",$s,q,xt=`Это подчеркивает недостаток модели CTC. Модель CTC - это, по сути, “только акустическая” модель: она состоит из энкодера, который формирует представления
скрытых состояний из аудиовходов, и линейного слоя, который отображает скрытые состояния в символы:`,Fs,D,Bt=`Это означает, что система практически полностью основывает свое предсказание на акустических данных (фонетических звуках аудиозаписи) и поэтому склонна
транскрибировать аудиозапись фонетическим способом (например, <em>CHRISTMAUS</em>). В нем меньше внимания уделяется языковому моделирующему контексту предыдущих
и последующих букв, поэтому он склонен к фонетическим ошибкам в написании. Более интеллектуальная модель определила бы, что <em>CHRISTMAUS</em> не является
правильным словом в английском словаре, и исправила бы его на <em>CHRISTMAS</em>, когда делала бы свои предсказания. Кроме того, в нашем прогнозировании отсутствуют
два важных признака - регистр и пунктуация, что ограничивает полезность транскрибации модели для реальных приложений.`,Hs,O,Ws,P,Qt=`Модели Seq2Seq! Как было описано в Разделе 3, модели Seq2Seq состоят из энкодера и декодера, связанных между собой механизмом перекрестного внимания.
Энкодер играет ту же роль, что и раньше, вычисляя представления скрытых состояний аудиовходов, а декодер - роль <strong>языковой модели</strong>. Декодер обрабатывает
всю последовательность представлений скрытых состояний, полученных от энкодера, и формирует соответствующие текстовые транскрипции. Имея глобальный контекст
входного аудиосигнала, декодер может использовать контекст языкового моделирования при составлении своих прогнозов, исправляя орфографические ошибки
“на лету” и тем самым обходя проблему фонетических прогнозов.`,Zs,K,Vt="У моделей Seq2Seq есть два недостатка:",Ns,ll,Rt="<li>Они изначально медленнее декодируют, поскольку процесс декодирования происходит по одному шагу за раз, а не все сразу</li> <li>Они более требовательны к данным, для достижения сходимости им требуется значительно больше обучающих данных</li>",_s,sl,kt=`В частности, узким местом в развитии архитектур Seq2Seq для задач с речью является потребность в больших объемах обучающих данных. Размеченные речевые данные
труднодоступны, самые большие аннотированные базы данных на тот момент составляли всего 10 000 часов. Все изменилось в 2022 году после выхода <strong>Whisper</strong>.
Whisper - это предварительно обученная модель для распознавания речи, опубликованная в <a href="https://openai.com/blog/whisper/" rel="nofollow">Сентябре 2022</a> авторами Alec Radford
и др. из компании OpenAI. В отличие от предшественников CTC, которые обучались исключительно на <strong>неразмеченных</strong> аудиоданных, Whisper предварительно обучен
на огромном количестве <strong>размеченных</strong> данных аудиотранскрипции, а именно на 680 000 часов.`,Ys,el,gt=`Это на порядок больше данных, чем неразмеченные аудиоданные, использованные для обучения Wav2Vec 2.0 (60 000 часов). Более того, 117 000 часов этих данных,
предназначенных для предварительного обучения, являются мультиязычными (или “не английскими”) данными. В результате контрольные точки могут быть применены
к более чем 96 языкам, многие из которых считаются <em>низкоресурсными</em>, т.е. не имеющими большого корпуса данных, пригодных для обучения.`,As,tl,vt=`При масштабировании на 680 000 часов аннотированных данных для предварительного обучения модели Whisper демонстрируют высокую способность к обобщению
на многие наборы данных и области. Предварительно обученные контрольные точки достигают результатов, конкурентоспособных с state-of-the-art pipe systems,
с коэффициентом ошибок в словах (WER) около 3% на подмножестве чистых тестов LibriSpeech и новым рекордом на TED-LIUM с WER 4,7%
(см. табл. 8 <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper paper</a>).`,Ls,al,Gt=`Особое значение имеет способность Whisper работать с длинными аудиообразцами, устойчивость к входным шумам и возможность предсказывать транскрипцию с
использованием падежей и пунктуации. Это делает его перспективным для использования в реальных системах распознавания речи.`,zs,nl,$t=`В оставшейся части этого раздела будет показано, как использовать предварительно обученные модели Whisper для распознавания речи с помощью 🤗 Transformers.
Во многих ситуациях предварительно обученные контрольные точки Whisper обладают высокой производительностью и дают отличные результаты, поэтому мы
рекомендуем вам попробовать использовать предварительно обученные контрольные точки в качестве первого шага к решению любой задачи распознавания речи.
Благодаря дообучению предварительно обученные контрольные точки могут быть адаптированы для конкретных наборов данных и языков с целью дальнейшего
улучшения результатов. Как это сделать, мы продемонстрируем в следующем подразделе, посвященном [дообучению] (fine-tuning).`,Xs,pl,Ft=`Контрольные точки модели Whisper доступны в пяти конфигурациях с различными размерами модели. Наименьшие по параметрам четыре модели обучаются либо
только на английском, либо на многоязычных данных. Самая большая по параметрам контрольная точка была обучена только на мультиязычных данных.
Все девять предварительно обученных контрольных точек доступны на <a href="https://huggingface.co/models?search=openai/whisper" rel="nofollow">Hugging Face Hub</a>. Контрольные
точки приведены в следующей таблице со ссылками на модели на Hugging Face Hub. “VRAM” обозначает объем памяти GPU, необходимый для работы модели с
минимальным размером пакета = 1. “Rel Speed” - относительная скорость контрольной точки по сравнению с самой большой моделью. На основе этой информации
можно выбрать контрольную точку, наиболее подходящую для вашего оборудования.`,qs,Ml,Ht='<thead><tr><th>Size</th> <th>Parameters</th> <th>VRAM / GB</th> <th>Rel Speed</th> <th>English-only</th> <th>Multilingual</th></tr></thead> <tbody><tr><td>tiny</td> <td>39 M</td> <td>1.4</td> <td>32</td> <td><a href="https://huggingface.co/openai/whisper-tiny.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-tiny" rel="nofollow">✓</a></td></tr> <tr><td>base</td> <td>74 M</td> <td>1.5</td> <td>16</td> <td><a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-base" rel="nofollow">✓</a></td></tr> <tr><td>small</td> <td>244 M</td> <td>2.3</td> <td>6</td> <td><a href="https://huggingface.co/openai/whisper-small.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-small" rel="nofollow">✓</a></td></tr> <tr><td>medium</td> <td>769 M</td> <td>4.2</td> <td>2</td> <td><a href="https://huggingface.co/openai/whisper-medium.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-medium" rel="nofollow">✓</a></td></tr> <tr><td>large</td> <td>1550 M</td> <td>7.5</td> <td>1</td> <td>x</td> <td><a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">✓</a></td></tr></tbody>',Ds,Jl,Wt=`Загрузим контрольную точку <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a>, которая по размеру сопоставима с контрольной точкой Wav2Vec2, которую
мы использовали ранее. Предваряя наш переход к многоязычному распознаванию речи, загрузим многоязычный вариант базовой контрольной точки. Мы также загрузим
модель на GPU, если он доступен, или на CPU в противном случае. В последствии <code>pipeline()</code> позаботится о перемещении всех входов/выходов с CPU на GPU по мере
необходимости:`,Os,il,Ps,Ul,Zt=`Отлично! Теперь давайте транскрибируем аудиозапись, как и раньше. Единственное изменение - это передача дополнительного аргумента <code>max_new_tokens</code>, который
указывает модели максимальное количество токенов, которые нужно генерировать при предсказании:`,Ks,yl,le,Tl,Nt="<strong>Output:</strong>",se,wl,ee,ml,_t=`Достаточно легко! Первое, на что вы обратите внимание, - это наличие как регистра, так и знаков препинания. Это сразу же делает транскрипцию более удобной для
чтения по сравнению с транскрипцией из Wav2Vec2, не содержащей ни регистра, ни пунктуации. Давайте поместим транскрипцию рядом с целевой меткой:`,te,rl,ae,hl,Yt=`Whisper проделал большую работу по исправлению фонетических ошибок, которые мы видели в Wav2Vec2 - и <em>Christmas</em>, и <em>roast</em> написаны правильно.
Мы видим, что модель все еще испытывает трудности с <em>SIMILES</em>, которое неправильно транскрибируется как <em>similarly</em>, но на этот раз предсказание
является правильным словом из английского словаря. Использование контрольной точки Whisper большего размера позволяет еще больше снизить количество
ошибок в транскрибированном тексте, но при этом требует больше вычислений и увеличивает время транскрибации.`,ne,ol,At=`Нам обещали модель, способную работать с 96 языками, так что оставим пока распознавание английской речи и пойдем по миру 🌎! Набор данных <a href="https://huggingface.co/datasets/facebook/multilingual_librispeech" rel="nofollow">Multilingual LibriSpeech</a>
(MLS) представляет собой многоязычный аналог набора данных LibriSpeech, содержащий размеченные аудиоданные на шести языках. Мы загрузим одну
образец из испанской части набора данных MLS, используя режим <em>streaming</em>, чтобы не загружать весь набор данных:`,pe,jl,Me,cl,Lt="Снова посмотрим текстовую транскрипцию и прослушаем аудиофрагмент:",Je,dl,ie,ul,zt="<strong>Output:</strong>",Ue,Il,ye,bl,Xt=`Это целевой текст, на который мы ориентируемся в нашей транскрипции Whisper. Хотя теперь мы знаем, что, вероятно, можем сделать это лучше,
поскольку наша модель будет предсказывать также пунктуацию и регистр, которые в выводе примера отсутствуют. Передадим образец звука в конвейер для
получения предсказания текста. Следует отметить, что конвейер <em>потребует</em> словарь аудиовходов, который мы вводим, то есть словарь не может
быть использован повторно. Чтобы обойти эту проблему, мы будем передавать <em>копию</em> аудиообразца, что позволит нам повторно использовать тот же самый
аудиообразец в последующих примерах кода:`,Te,Cl,we,fl,qt="<strong>Output:</strong>",me,El,re,Sl,Dt=`Отлично - это очень похоже на наш целевой текст (возможно, даже лучше, поскольку в нем есть пунктуация и регистр!). Обратите внимание, что мы передали
<code>&quot;task&quot;</code> в качестве аргумента <em>генерируемого ключевого слова</em> (generate kwarg). Передача ключу <code>&quot;task&quot;</code> значения <code>&quot;transcribe&quot;</code> заставляет Whisper
выполнять задачу <em>распознавания речи</em>, при которой аудиозапись транскрибируется на том же языке, на котором была произнесена речь. Whisper также
способен выполнять тесно связанную с задачу - <em>перевода речи</em>, когда аудиозапись на испанском языке может быть переведена в текст на английском.
Для этого мы передаем ключу <code>&quot;task&quot;</code> значение <code>&quot;translate&quot;</code>:`,he,xl,oe,Bl,Ot="<strong>Output:</strong>",je,Ql,ce,Vl,Pt=`Теперь, когда мы знаем, что можем переключаться между распознаванием речи и ее переводом, мы можем выбирать задачу в зависимости от наших потребностей.
Либо мы распознаем звук на языке X в текст на том же языке X (например, испанский звук в испанский текст), либо переводим с любого языка X в текст
на английском языке (например, испанский звук в английский текст).`,de,Rl,Kt=`Подробнее о том, как аргумент <code>&quot;task&quot;</code> используется для управления свойствами генерируемого текста, см. в <a href="https://huggingface.co/openai/whisper-base#usage" rel="nofollow">карточке модели</a>
для базовой модели Whisper.`,ue,kl,Ie,gl,la=`Пока мы были сосредоточены на транскрибации коротких аудиофрагментов длительностью менее 30 секунд. Мы уже упоминали, что одной из привлекательных
сторон Whisper является возможность работы с длинными аудиофрагментами. В этой части раздела мы рассмотрим эту задачу!`,be,vl,sa=`Создадим длинный аудиофайл путем конкатенации последовательных выборок из набора данных MLS. Поскольку набор данных MLS формируется путем разбиения
длинных записей аудиокниг на более короткие сегменты, конкатенация образцов является одним из способов реконструкции более длинных отрывков аудиокниг.
Следовательно, результирующий звук должен быть когерентным по всей выборке.`,Ce,Gl,ea="Мы установим целевую длительность звука в 5 минут и прекратим конкатенацию сэмплов, как только достигнем этого значения:",fe,$l,Ee,Fl,ta="<strong>Output:</strong>",Se,Hl,xe,Wl,aa=`Отлично! Осталось транскрибировать 5 минут 17 секунд аудиозаписи. При передаче такого длинного аудиофрагмента непосредственно в модель
возникают две проблемы:`,Be,Zl,na="<li>Whisper изначально рассчитан на работу с 30-секундными образцами: все, что короче 30 секунд, заполняется тишиной, все, что длиннее 30 секунд, усекается до 30 секунд путем вырезания лишнего звука, поэтому если мы передадим наш звук напрямую, то получим транскрипцию только первых 30 секунд</li> <li>Память в сети трансформера зависит от квадрата длины последовательности: удвоение длины входного сигнала увеличивает потребность в памяти в четыре раза, поэтому передача очень длинных аудиофайлов обязательно приведет к ошибке “вне памяти” (out-of-memory)</li>",Qe,Nl,pa=`Длинная транскрибация в 🤗 Transformers осуществляется путем <em>фрагментации</em> (от англ. chunking) входного аудио на более мелкие и управляемые фрагменты.
Каждый фрагмент имеет небольшое наложение с предыдущим. Это позволяет нам точно соединять фрагменты на границах,
так как мы можем найти наложение между фрагментами и соответствующим образом объединить транскрипции:`,Ve,d,Ma='<img src="https://huggingface.co/blog/assets/49_asr_chunking/Striding.png" alt="🤗 Transformers chunking algorithm. Source: https://huggingface.co/blog/asr-chunking."/>',Re,h,Mt,ke,Ia='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',ge,ve,ba='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Ge,ns,Ja="нестационарный",Jt,$e,Ca='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Fe,He,fa='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',We,ps,ia="пакетировать",it,u,Ua="посте из блога",Ut,Ze,_l,ya=`Для активации длинных транскрипций необходимо добавить один дополнительный аргумент при вызове конвейера. Этот аргумент, <code>chunk_length_s</code>,
определяет длину фрагментов в секундах. Для Whisper оптимальной является 30-секундная длина фрагментов, поскольку она соответствует длине
входного сигнала, ожидаемого Whisper.`,Ne,Yl,Ta=`Чтобы активизировать пакетную обработку, необходимо передать конвейеру аргумент <code>batch_size</code>. Если собрать все это воедино,
то транскрибация длинного аудиообразца с использованием чанкинга и батчинга может быть выполнена следующим образом:`,_e,Al,Ye,Ll,wa="<strong>Output:</strong>",Ae,zl,Le,Xl,ma=`Мы не будем приводить здесь весь результат, поскольку он довольно длинный (всего 312 слов)! На графическом процессоре V100
с памятью 16 Гбайт выполнение приведенной выше строки займет примерно 3,45 секунды, что весьма неплохо для 317-секундного аудиообразца.
На CPU ожидается около 30 секунд.`,ze,ql,ra=`Whisper также способен предсказывать <em>временные метки</em> на уровне фрагментов для аудиоданных. Эти временные метки указывают на время начала
и окончания короткого отрывка аудиозаписи и особенно полезны для выравнивания транскрипции с входным аудиосигналом. Предположим, мы хотим
создать субтитры для видео - нам нужны эти временные метки, чтобы знать, какая часть транскрипции соответствует определенному
сегменту видео, чтобы отобразить правильную транскрипцию для этого времени.`,Xe,Dl,ha=`Активировать предсказание временных меток очень просто, достаточно установить аргумент <code>return_timestamps=True</code>. Временные метки совместимы
с методами фрагментирования и пакетирования, которые мы использовали ранее, поэтому мы можем просто добавить аргумент timestamp к нашему
предыдущему вызову:`,qe,Ol,De,Pl,oa="<strong>Output:</strong>",Oe,Kl,Pe,ls,ja="И вуаля! У нас есть предсказанный текст и соответствующие временные метки.",Ke,ss,lt,es,ca=`Whisper - это сильная предварительно обученная модель для распознавания и перевода речи. По сравнению с Wav2Vec2, он обладает более
высокой точностью транскрибации, при этом выходные данные содержат знаки препинания и регистр. Он может использоваться для транскрибации
речи на английском и 96 других языках, как на коротких аудиофрагментах, так и на более длинных за счет <em>фрагментирования</em>. Эти качества делают
его подходящей моделью для многих задач распознавания речи и перевода без необходимости дообучения. Метод <code>pipeline()</code> обеспечивает простой
способ выполнения выводов в виде однострочных вызовов API с контролем над генерируемыми предсказаниями.`,st,ts,da=`В то время как модель Whisper демонстрирует отличные результаты на многих языках с большим количеством ресурсов, она имеет более низкую
точность транскрибации и перевода на языках с малым количеством ресурсов, т.е. на языках с меньшим количеством доступных обучающих данных.
Кроме того, существуют различия в результатах работы с разными акцентами и диалектами некоторых языков, включая более низкую точность для
носителей разных полов, рас, возрастов и других демографических критериев (например, <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper paper</a>).`,et,as,ua=`Для повышения производительности при работе с языками, акцентами или диалектами, не имеющими достаточного количества ресурсов, мы можем взять
предварительно обученную модель Whisper и обучить ее на небольшом корпусе данных, подобранных соответствующим образом, в процессе,
называемом <em>дообучением</em>. Мы покажем, что всего десять часов дополнительных данных позволяют повысить производительность модели Whisper более
чем на 100% на языке с низким уровнем ресурсов. В следующей секции мы рассмотрим процесс выбора набора данных для дообучения модели.`,tt,Js,at;return C=new Us({props:{title:"Предварительно обученные модели для распознавания речи",local:"предварительно-обученные-модели-для-распознавания-речи",headingTag:"h1"}}),Q=new Us({props:{title:"Анализ моделей CTC",local:"анализ-моделей-ctc",headingTag:"h2"}}),R=new r({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMEEpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(
    <span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>
)
dataset`,wrap:!1}}),g=new r({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidmaWxlJyUyQyUyMCdhdWRpbyclMkMlMjAndGV4dCclMkMlMjAnc3BlYWtlcl9pZCclMkMlMjAnY2hhcHRlcl9pZCclMkMlMjAnaWQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA3MyUwQSU3RCk=",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;speaker_id&#x27;</span>, <span class="hljs-string">&#x27;chapter_id&#x27;</span>, <span class="hljs-string">&#x27;id&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">73</span>
})`,wrap:!1}}),G=new r({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjIlNUQlMEElMEFwcmludChzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEKSUwQUF1ZGlvKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByYXRlJTNEc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sample = dataset[<span class="hljs-number">2</span>]

<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),F=new r({props:{code:"SEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5E",highlighted:'HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND',wrap:!1}}),W=new r({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS0xMDBoJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;facebook/wav2vec2-base-100h&quot;</span>)`,wrap:!1}}),N=new r({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCkp",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())',wrap:!1}}),Y=new r({props:{code:"JTdCJTIydGV4dCUyMiUzQSUyMCUyMkhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMENIUklTVE1BVVMlMjBBTkQlMjBST1NFJTIwQkVFRiUyMExPT01JTkclMjBCRUZPUkUlMjBVUyUyMFNJTUFMWUlTJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQlMjIlN0Q=",highlighted:'<span class="hljs-comment">{&quot;text&quot;: &quot;HE TELLS US THAT AT THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAUS AND ROSE BEEF LOOMING BEFORE US SIMALYIS DRAWN FROM EATING AND ITS RESULTS OCCUR MOST READILY TO THE MIND&quot;}</span>',wrap:!1}}),L=new r({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMCUyMEhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMCoqQ0hSSVNUTUFVUyoqJTIwQU5EJTIwKipST1NFKiolMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwKipTSU1BTFlJUyoqJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQ=",highlighted:`<span class="hljs-symbol">Target:</span>      HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span>  HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH **CHRISTMAUS** <span class="hljs-keyword">AND </span>**ROSE** <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US **SIMALYIS** DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND`,wrap:!1}}),O=new Us({props:{title:"Переход к Seq2Seq",local:"переход-к-seq2seq",headingTag:"h2"}}),il=new r({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`,wrap:!1}}),yl=new r({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>)',wrap:!1}}),wl=new r({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMENocmlzdG1hcyUyMGFuZCUyMHJvYXN0JTIwYmVlZiUyMGxvb21pbmclMjBiZWZvcmUlMjB1cyUyQyUyMHNpbWlsYXJseSUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQuJyU3RA==",highlighted:'{&#x27;<span class="hljs-built_in">text</span>&#x27;: &#x27; He tells us <span class="hljs-keyword">that</span> <span class="hljs-keyword">at</span> this festive season <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span>, <span class="hljs-keyword">with</span> Christmas <span class="hljs-keyword">and</span> roast beef looming <span class="hljs-keyword">before</span> us, similarly <span class="hljs-keyword">is</span> drawn <span class="hljs-keyword">from</span> eating <span class="hljs-keyword">and</span> <span class="hljs-keyword">its</span> results occur most readily <span class="hljs-keyword">to</span> <span class="hljs-keyword">the</span> mind.&#x27;}',wrap:!1}}),rl=new r({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMCoqQ2hyaXN0bWFzKiolMjBhbmQlMjAqKnJvYXN0KiolMjBiZWVmJTIwbG9vbWluZyUyMGJlZm9yZSUyMHVzJTJDJTIwKipzaW1pbGFybHkqKiUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQu",highlighted:`<span class="hljs-symbol">Target:</span>     HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span> He tells us that <span class="hljs-built_in">at</span> this festive season of the year, with **Christmas** <span class="hljs-keyword">and </span>**roast** <span class="hljs-keyword">beef </span>looming <span class="hljs-keyword">before </span>us, **similarly** is drawn from eating <span class="hljs-keyword">and </span>its results occur most readily to the mind.`,wrap:!1}}),jl=new r({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm11bHRpbGluZ3VhbF9saWJyaXNwZWVjaCUyMiUyQyUyMCUyMnNwYW5pc2glMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTBBKSUwQXNhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSk=",highlighted:`dataset = load_dataset(
    <span class="hljs-string">&quot;facebook/multilingual_librispeech&quot;</span>, <span class="hljs-string">&quot;spanish&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`,wrap:!1}}),dl=new r({props:{code:"cHJpbnQoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMEFBdWRpbyhzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmF0ZSUzRHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),Il=new r({props:{code:"ZW50b25jZXMlMjB0ZSUyMGRlbGVsaXRhciVDMyVBMXMlMjBlbiUyMGplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjAlQzMlQTElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwamFjb2IlMjB0dSUyMHBhZHJlJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBqZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRv",highlighted:'entonces <span class="hljs-keyword">te</span> delelitarás <span class="hljs-keyword">en</span> jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré á comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> jehová lo ha hablado',wrap:!1}}),Cl=new r({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiUyQyUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMnRhc2slMjIlM0ElMjAlMjJ0cmFuc2NyaWJlJTIyJTdEKQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy(), max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>})',wrap:!1}}),El=new r({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUyMGhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4nJTdE",highlighted:'{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> Jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado.&#x27;}',wrap:!1}}),xl=new r({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zbGF0ZSUyMiU3RCk=",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})',wrap:!1}}),Ql=new r({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMFNvJTIweW91JTIwd2lsbCUyMGNob29zZSUyMGluJTIwSmVob3ZhaCUyMGFuZCUyMEklMjB3aWxsJTIwcmFpc2UlMjB5b3UlMjBvbiUyMHRoZSUyMGhlaWdodHMlMjBvZiUyMHRoZSUyMGVhcnRoJTIwYW5kJTIwSSUyMHdpbGwlMjBnaXZlJTIweW91JTIwdGhlJTIwaG9ub3IlMjBvZiUyMEphY29iJTIwdG8lMjB5b3VyJTIwZmF0aGVyJTIwYmVjYXVzZSUyMHRoZSUyMHZvaWNlJTIwb2YlMjBKZWhvdmFoJTIwaGFzJTIwc3Bva2VuJTIwdG8lMjB5b3UuJyU3RA==",highlighted:'<span class="hljs-comment">{&#x27;text&#x27;: &#x27; So you will choose in Jehovah and I will raise you on the heights of the earth and I will give you the honor of Jacob to your father because the voice of Jehovah has spoken to you.&#x27;}</span>',wrap:!1}}),kl=new Us({props:{title:"Длинноформатная транскрипция и временные метки",local:"длинноформатная-транскрипция-и-временные-метки",headingTag:"h2"}}),$l=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_length_in_m = <span class="hljs-number">5</span>

<span class="hljs-comment"># преобразование из минут в секунды (* 60) в число выборок (* частота дискретизации)</span>
sampling_rate = pipe.feature_extractor.sampling_rate
target_length_in_samples = target_length_in_m * <span class="hljs-number">60</span> * sampling_rate

<span class="hljs-comment"># итерируемся по нашему потоковому набору данных, конкатенируя выборки до тех пор, пока мы не достигнем нашей цели</span>
long_audio = []
<span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> dataset:
    long_audio.extend(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(long_audio) &gt; target_length_in_samples:
        <span class="hljs-keyword">break</span>

long_audio = np.asarray(long_audio)

<span class="hljs-comment"># что у нас получилось?</span>
seconds = <span class="hljs-built_in">len</span>(long_audio) / <span class="hljs-number">16000</span>
minutes, seconds = <span class="hljs-built_in">divmod</span>(seconds, <span class="hljs-number">60</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Length of audio sample is <span class="hljs-subst">{minutes}</span> minutes <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)`,wrap:!1}}),Hl=new r({props:{code:"TGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwNS4wJTIwbWludXRlcyUyMDE3LjIyJTIwc2Vjb25kcw==",highlighted:'<span class="hljs-attribute">Length</span> of audio sample is <span class="hljs-number">5</span>.<span class="hljs-number">0</span> minutes <span class="hljs-number">17</span>.<span class="hljs-number">22</span> seconds',wrap:!1}}),Al=new r({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
)`,wrap:!1}}),zl=new r({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTJDJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMkMlMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUwQWhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyQyUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4lMjBub3NvdHJvcyUyMGN1cmFkb3MuJTIwVG9kb3MlMjBub3NvdHJvcyUyMG5vcyUyMGRlc2NhcnJpYW1vcyUwQWNvbW8lMjBiZWphcyUyQyUyMGNhZGElMjBjdWFsJTIwc2UlMjBhcGFydCVDMyVCMyUyMHBvciUyMHN1JTIwY2FtaW5vJTJDJTIwbWFzJTIwSmVob3YlQzMlQTElMjBjYXJnJUMzJUIzJTIwZW4lMjAlQzMlQTlsJTIwZWwlMjBwZWNhZG8lMjBkZSUyMHRvZG9zJTIwbm9zb3Ryb3MuLi4=",highlighted:`{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová, y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra, y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span>
heredad <span class="hljs-keyword">de</span> Jacob tu padre, porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos
como bejas, cada cual <span class="hljs-keyword">se</span> apartó por <span class="hljs-keyword">su</span> camino, mas Jehová cargó <span class="hljs-keyword">en</span> é<span class="hljs-keyword">l</span> el pecado <span class="hljs-keyword">de</span> todos nosotros...`,wrap:!1}}),Ol=new r({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSUyQyUwQSklNUIlMjJjaHVua3MlMjIlNUQ=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
    return_timestamps=<span class="hljs-literal">True</span>,
)[<span class="hljs-string">&quot;chunks&quot;</span>]`,wrap:!1}}),Kl=new r({props:{code:"JTVCJTdCJ3RpbWVzdGFtcCclM0ElMjAoMC4wJTJDJTIwMjYuNCklMkMlMEElMjAlMjAndGV4dCclM0ElMjAnJTIwRW50b25jZXMlMjB0ZSUyMGRlbGVpdGFyJUMzJUExcyUyMGVuJTIwSmVob3YlQzMlQTElMkMlMjB5JTIweW8lMjB0ZSUyMGhhciVDMyVBOSUyMHN1YmlyJTIwc29icmUlMjBsYXMlMjBhbHR1cmFzJTIwZGUlMjBsYSUyMHRpZXJyYSUyQyUyMHklMjB0ZSUyMGRhciVDMyVBOSUyMGElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwSmFjb2IlMjB0dSUyMHBhZHJlJTJDJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBKZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRvLiUyMG5vc290cm9zJTIwY3VyYWRvcy4lMjBUb2RvcyUyMG5vc290cm9zJTIwbm9zJTIwZGVzY2FycmlhbW9zJTIwY29tbyUyMGJlamFzJTJDJTIwY2FkYSUyMGN1YWwlMjBzZSUyMGFwYXJ0JUMzJUIzJTIwcG9yJTIwc3UlMjBjYW1pbm8lMkMnJTdEJTJDJTBBJTIwJTdCJ3RpbWVzdGFtcCclM0ElMjAoMjYuNCUyQyUyMDMyLjQ4KSUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCclMjBtYXMlMjBKZWhvdiVDMyVBMSUyMGNhcmclQzMlQjMlMjBlbiUyMCVDMyVBOWwlMjBlbCUyMHBlY2FkbyUyMGRlJTIwdG9kb3MlMjBub3NvdHJvcy4lMjBObyUyMGVzJTIwcXVlJTIwcGFydGFzJTIwdHUlMjBwYW4lMjBjb24lMjBlbCclN0QlMkMlMEElMjAlN0IndGltZXN0YW1wJyUzQSUyMCgzMi40OCUyQyUyMDM4LjQpJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyUyMGhhbWJyaWVudG8lMjB5JTIwYSUyMGxvcyUyMGhvbWJyZXMlMjBoZXJyYW50ZXMlMjBtZXRhcyUyMGVuJTIwY2FzYSUyQyUyMHF1ZSUyMGN1YW5kbyUyMHZpZXJlcyUyMGFsJTIwZGVzbnVkbyUyMGxvJTIwY3VicmFzJTIweSUyMG5vJyU3RCUyQyUwQSUyMC4uLg==",highlighted:`[{<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">0.0</span>, <span class="hljs-number">26.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; Entonces te deleitarás en Jehová, y yo te haré subir sobre las alturas de la tierra, y te daré a comer la heredad de Jacob tu padre, porque la boca de Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos como bejas, cada cual se apartó por su camino,&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">26.4</span>, <span class="hljs-number">32.48</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; mas Jehová cargó en él el pecado de todos nosotros. No es que partas tu pan con el&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">32.48</span>, <span class="hljs-number">38.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; hambriento y a los hombres herrantes metas en casa, que cuando vieres al desnudo lo cubras y no&#x27;},
 ...`,wrap:!1}}),ss=new Us({props:{title:"Итоги",local:"итоги",headingTag:"h2"}}),{c(){c=p("meta"),ys=a(),Ms=p("p"),Ts=a(),i(C.$$.fragment),ws=a(),f=p("p"),f.innerHTML=wt,ms=a(),E=p("p"),E.textContent=mt,rs=a(),S=p("ol"),S.innerHTML=rt,hs=a(),x=p("p"),x.innerHTML=ht,os=a(),B=p("p"),B.textContent=ot,js=a(),i(Q.$$.fragment),cs=a(),V=p("p"),V.innerHTML=jt,ds=a(),i(R.$$.fragment),us=a(),k=p("p"),k.innerHTML=ct,Is=a(),i(g.$$.fragment),bs=a(),v=p("p"),v.textContent=dt,Cs=a(),i(G.$$.fragment),fs=a(),$=p("p"),$.innerHTML=ut,Es=a(),i(F.$$.fragment),Ss=a(),H=p("p"),H.innerHTML=It,xs=a(),i(W.$$.fragment),Bs=a(),Z=p("p"),Z.innerHTML=bt,Qs=a(),i(N.$$.fragment),Vs=a(),_=p("p"),_.innerHTML=Ct,Rs=a(),i(Y.$$.fragment),ks=a(),A=p("p"),A.textContent=ft,gs=a(),i(L.$$.fragment),vs=a(),z=p("p"),z.innerHTML=Et,Gs=a(),X=p("ul"),X.innerHTML=St,$s=a(),q=p("p"),q.textContent=xt,Fs=a(),D=p("p"),D.innerHTML=Bt,Hs=a(),i(O.$$.fragment),Ws=a(),P=p("p"),P.innerHTML=Qt,Zs=a(),K=p("p"),K.textContent=Vt,Ns=a(),ll=p("ol"),ll.innerHTML=Rt,_s=a(),sl=p("p"),sl.innerHTML=kt,Ys=a(),el=p("p"),el.innerHTML=gt,As=a(),tl=p("p"),tl.innerHTML=vt,Ls=a(),al=p("p"),al.textContent=Gt,zs=a(),nl=p("p"),nl.textContent=$t,Xs=a(),pl=p("p"),pl.innerHTML=Ft,qs=a(),Ml=p("table"),Ml.innerHTML=Ht,Ds=a(),Jl=p("p"),Jl.innerHTML=Wt,Os=a(),i(il.$$.fragment),Ps=a(),Ul=p("p"),Ul.innerHTML=Zt,Ks=a(),i(yl.$$.fragment),le=a(),Tl=p("p"),Tl.innerHTML=Nt,se=a(),i(wl.$$.fragment),ee=a(),ml=p("p"),ml.textContent=_t,te=a(),i(rl.$$.fragment),ae=a(),hl=p("p"),hl.innerHTML=Yt,ne=a(),ol=p("p"),ol.innerHTML=At,pe=a(),i(jl.$$.fragment),Me=a(),cl=p("p"),cl.textContent=Lt,Je=a(),i(dl.$$.fragment),ie=a(),ul=p("p"),ul.innerHTML=zt,Ue=a(),i(Il.$$.fragment),ye=a(),bl=p("p"),bl.innerHTML=Xt,Te=a(),i(Cl.$$.fragment),we=a(),fl=p("p"),fl.innerHTML=qt,me=a(),i(El.$$.fragment),re=a(),Sl=p("p"),Sl.innerHTML=Dt,he=a(),i(xl.$$.fragment),oe=a(),Bl=p("p"),Bl.innerHTML=Ot,je=a(),i(Ql.$$.fragment),ce=a(),Vl=p("p"),Vl.textContent=Pt,de=a(),Rl=p("p"),Rl.innerHTML=Kt,ue=a(),i(kl.$$.fragment),Ie=a(),gl=p("p"),gl.textContent=la,be=a(),vl=p("p"),vl.textContent=sa,Ce=a(),Gl=p("p"),Gl.textContent=ea,fe=a(),i($l.$$.fragment),Ee=a(),Fl=p("p"),Fl.innerHTML=ta,Se=a(),i(Hl.$$.fragment),xe=a(),Wl=p("p"),Wl.textContent=aa,Be=a(),Zl=p("ol"),Zl.innerHTML=na,Qe=a(),Nl=p("p"),Nl.innerHTML=pa,Ve=a(),d=p("div"),d.innerHTML=Ma,Re=a(),h=p("p"),Mt=I("Преимущество фрагментирования аудиообразцов на части заключается в том, что нам не нужен результат транскрибации небольшого фрагмента аудиосигнала "),ke=new nt(!1),ge=I(`
для транскрибации последующего фрагмента `),ve=new nt(!1),Ge=I(`. Соединение выполняется после того, как мы
транскрибировали все фрагменты на границах фрагментов, поэтому не имеет значения, в каком порядке мы их транскрибируем. Алгоритм полностью `),ns=p("strong"),ns.textContent=Ja,Jt=I(`,
поэтому мы можем даже обрабатывать фрагмент `),$e=new nt(!1),Fe=I(" одновременно с фрагментом "),He=new nt(!1),We=I("! Это позволяет нам "),ps=p("em"),ps.textContent=ia,it=I(` (от англ. batch) фрагменты
и прогонять их через модель параллельно, обеспечивая значительное ускорение вычислений по сравнению с их последовательной транскрибацией. Более подробно
о фрагментированни в 🤗 Transformers можно прочитать в `),u=p("a"),u.textContent=Ua,Ut=I("."),Ze=a(),_l=p("p"),_l.innerHTML=ya,Ne=a(),Yl=p("p"),Yl.innerHTML=Ta,_e=a(),i(Al.$$.fragment),Ye=a(),Ll=p("p"),Ll.innerHTML=wa,Ae=a(),i(zl.$$.fragment),Le=a(),Xl=p("p"),Xl.textContent=ma,ze=a(),ql=p("p"),ql.innerHTML=ra,Xe=a(),Dl=p("p"),Dl.innerHTML=ha,qe=a(),i(Ol.$$.fragment),De=a(),Pl=p("p"),Pl.innerHTML=oa,Oe=a(),i(Kl.$$.fragment),Pe=a(),ls=p("p"),ls.textContent=ja,Ke=a(),i(ss.$$.fragment),lt=a(),es=p("p"),es.innerHTML=ca,st=a(),ts=p("p"),ts.innerHTML=da,et=a(),as=p("p"),as.innerHTML=ua,tt=a(),Js=p("p"),this.h()},l(l){const s=Va("svelte-u9bgzb",document.head);c=M(s,"META",{name:!0,content:!0}),s.forEach(e),ys=n(l),Ms=M(l,"P",{}),yt(Ms).forEach(e),Ts=n(l),U(C.$$.fragment,l),ws=n(l),f=M(l,"P",{"data-svelte-h":!0}),J(f)!=="svelte-1gtvm8h"&&(f.innerHTML=wt),ms=n(l),E=M(l,"P",{"data-svelte-h":!0}),J(E)!=="svelte-6jcjni"&&(E.textContent=mt),rs=n(l),S=M(l,"OL",{"data-svelte-h":!0}),J(S)!=="svelte-bjelpo"&&(S.innerHTML=rt),hs=n(l),x=M(l,"P",{"data-svelte-h":!0}),J(x)!=="svelte-1vky12r"&&(x.innerHTML=ht),os=n(l),B=M(l,"P",{"data-svelte-h":!0}),J(B)!=="svelte-1vi57w3"&&(B.textContent=ot),js=n(l),U(Q.$$.fragment,l),cs=n(l),V=M(l,"P",{"data-svelte-h":!0}),J(V)!=="svelte-5khewd"&&(V.innerHTML=jt),ds=n(l),U(R.$$.fragment,l),us=n(l),k=M(l,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1mvdyro"&&(k.innerHTML=ct),Is=n(l),U(g.$$.fragment,l),bs=n(l),v=M(l,"P",{"data-svelte-h":!0}),J(v)!=="svelte-1ibu3ww"&&(v.textContent=dt),Cs=n(l),U(G.$$.fragment,l),fs=n(l),$=M(l,"P",{"data-svelte-h":!0}),J($)!=="svelte-1mvdyro"&&($.innerHTML=ut),Es=n(l),U(F.$$.fragment,l),Ss=n(l),H=M(l,"P",{"data-svelte-h":!0}),J(H)!=="svelte-aibedu"&&(H.innerHTML=It),xs=n(l),U(W.$$.fragment,l),Bs=n(l),Z=M(l,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-i8aadp"&&(Z.innerHTML=bt),Qs=n(l),U(N.$$.fragment,l),Vs=n(l),_=M(l,"P",{"data-svelte-h":!0}),J(_)!=="svelte-1mvdyro"&&(_.innerHTML=Ct),Rs=n(l),U(Y.$$.fragment,l),ks=n(l),A=M(l,"P",{"data-svelte-h":!0}),J(A)!=="svelte-htuiqs"&&(A.textContent=ft),gs=n(l),U(L.$$.fragment,l),vs=n(l),z=M(l,"P",{"data-svelte-h":!0}),J(z)!=="svelte-10h19k1"&&(z.innerHTML=Et),Gs=n(l),X=M(l,"UL",{"data-svelte-h":!0}),J(X)!=="svelte-11mc7qy"&&(X.innerHTML=St),$s=n(l),q=M(l,"P",{"data-svelte-h":!0}),J(q)!=="svelte-qu6mk6"&&(q.textContent=xt),Fs=n(l),D=M(l,"P",{"data-svelte-h":!0}),J(D)!=="svelte-sq2gy5"&&(D.innerHTML=Bt),Hs=n(l),U(O.$$.fragment,l),Ws=n(l),P=M(l,"P",{"data-svelte-h":!0}),J(P)!=="svelte-1i2fk02"&&(P.innerHTML=Qt),Zs=n(l),K=M(l,"P",{"data-svelte-h":!0}),J(K)!=="svelte-1ifxb88"&&(K.textContent=Vt),Ns=n(l),ll=M(l,"OL",{"data-svelte-h":!0}),J(ll)!=="svelte-71blpy"&&(ll.innerHTML=Rt),_s=n(l),sl=M(l,"P",{"data-svelte-h":!0}),J(sl)!=="svelte-1qrj0ya"&&(sl.innerHTML=kt),Ys=n(l),el=M(l,"P",{"data-svelte-h":!0}),J(el)!=="svelte-15998yu"&&(el.innerHTML=gt),As=n(l),tl=M(l,"P",{"data-svelte-h":!0}),J(tl)!=="svelte-1qtehni"&&(tl.innerHTML=vt),Ls=n(l),al=M(l,"P",{"data-svelte-h":!0}),J(al)!=="svelte-el2qut"&&(al.textContent=Gt),zs=n(l),nl=M(l,"P",{"data-svelte-h":!0}),J(nl)!=="svelte-1j2fp4v"&&(nl.textContent=$t),Xs=n(l),pl=M(l,"P",{"data-svelte-h":!0}),J(pl)!=="svelte-1bqbmak"&&(pl.innerHTML=Ft),qs=n(l),Ml=M(l,"TABLE",{"data-svelte-h":!0}),J(Ml)!=="svelte-leifmh"&&(Ml.innerHTML=Ht),Ds=n(l),Jl=M(l,"P",{"data-svelte-h":!0}),J(Jl)!=="svelte-7zg689"&&(Jl.innerHTML=Wt),Os=n(l),U(il.$$.fragment,l),Ps=n(l),Ul=M(l,"P",{"data-svelte-h":!0}),J(Ul)!=="svelte-1ilagb0"&&(Ul.innerHTML=Zt),Ks=n(l),U(yl.$$.fragment,l),le=n(l),Tl=M(l,"P",{"data-svelte-h":!0}),J(Tl)!=="svelte-1mvdyro"&&(Tl.innerHTML=Nt),se=n(l),U(wl.$$.fragment,l),ee=n(l),ml=M(l,"P",{"data-svelte-h":!0}),J(ml)!=="svelte-cuywh6"&&(ml.textContent=_t),te=n(l),U(rl.$$.fragment,l),ae=n(l),hl=M(l,"P",{"data-svelte-h":!0}),J(hl)!=="svelte-18d7cq3"&&(hl.innerHTML=Yt),ne=n(l),ol=M(l,"P",{"data-svelte-h":!0}),J(ol)!=="svelte-1bh6i43"&&(ol.innerHTML=At),pe=n(l),U(jl.$$.fragment,l),Me=n(l),cl=M(l,"P",{"data-svelte-h":!0}),J(cl)!=="svelte-1q4wmmh"&&(cl.textContent=Lt),Je=n(l),U(dl.$$.fragment,l),ie=n(l),ul=M(l,"P",{"data-svelte-h":!0}),J(ul)!=="svelte-1mvdyro"&&(ul.innerHTML=zt),Ue=n(l),U(Il.$$.fragment,l),ye=n(l),bl=M(l,"P",{"data-svelte-h":!0}),J(bl)!=="svelte-14g7j7g"&&(bl.innerHTML=Xt),Te=n(l),U(Cl.$$.fragment,l),we=n(l),fl=M(l,"P",{"data-svelte-h":!0}),J(fl)!=="svelte-1mvdyro"&&(fl.innerHTML=qt),me=n(l),U(El.$$.fragment,l),re=n(l),Sl=M(l,"P",{"data-svelte-h":!0}),J(Sl)!=="svelte-j49oek"&&(Sl.innerHTML=Dt),he=n(l),U(xl.$$.fragment,l),oe=n(l),Bl=M(l,"P",{"data-svelte-h":!0}),J(Bl)!=="svelte-1mvdyro"&&(Bl.innerHTML=Ot),je=n(l),U(Ql.$$.fragment,l),ce=n(l),Vl=M(l,"P",{"data-svelte-h":!0}),J(Vl)!=="svelte-iwrqcj"&&(Vl.textContent=Pt),de=n(l),Rl=M(l,"P",{"data-svelte-h":!0}),J(Rl)!=="svelte-17xpsvz"&&(Rl.innerHTML=Kt),ue=n(l),U(kl.$$.fragment,l),Ie=n(l),gl=M(l,"P",{"data-svelte-h":!0}),J(gl)!=="svelte-z1wxhe"&&(gl.textContent=la),be=n(l),vl=M(l,"P",{"data-svelte-h":!0}),J(vl)!=="svelte-1dkwyap"&&(vl.textContent=sa),Ce=n(l),Gl=M(l,"P",{"data-svelte-h":!0}),J(Gl)!=="svelte-1tfnh52"&&(Gl.textContent=ea),fe=n(l),U($l.$$.fragment,l),Ee=n(l),Fl=M(l,"P",{"data-svelte-h":!0}),J(Fl)!=="svelte-1mvdyro"&&(Fl.innerHTML=ta),Se=n(l),U(Hl.$$.fragment,l),xe=n(l),Wl=M(l,"P",{"data-svelte-h":!0}),J(Wl)!=="svelte-wptioh"&&(Wl.textContent=aa),Be=n(l),Zl=M(l,"OL",{"data-svelte-h":!0}),J(Zl)!=="svelte-1too0g5"&&(Zl.innerHTML=na),Qe=n(l),Nl=M(l,"P",{"data-svelte-h":!0}),J(Nl)!=="svelte-zc3x59"&&(Nl.innerHTML=pa),Ve=n(l),d=M(l,"DIV",{class:!0,"data-svelte-h":!0}),J(d)!=="svelte-dbmn5s"&&(d.innerHTML=Ma),Re=n(l),h=M(l,"P",{});var o=yt(h);Mt=b(o,"Преимущество фрагментирования аудиообразцов на части заключается в том, что нам не нужен результат транскрибации небольшого фрагмента аудиосигнала "),ke=pt(o,!1),ge=b(o,`
для транскрибации последующего фрагмента `),ve=pt(o,!1),Ge=b(o,`. Соединение выполняется после того, как мы
транскрибировали все фрагменты на границах фрагментов, поэтому не имеет значения, в каком порядке мы их транскрибируем. Алгоритм полностью `),ns=M(o,"STRONG",{"data-svelte-h":!0}),J(ns)!=="svelte-1n450gz"&&(ns.textContent=Ja),Jt=b(o,`,
поэтому мы можем даже обрабатывать фрагмент `),$e=pt(o,!1),Fe=b(o," одновременно с фрагментом "),He=pt(o,!1),We=b(o,"! Это позволяет нам "),ps=M(o,"EM",{"data-svelte-h":!0}),J(ps)!=="svelte-x1261k"&&(ps.textContent=ia),it=b(o,` (от англ. batch) фрагменты
и прогонять их через модель параллельно, обеспечивая значительное ускорение вычислений по сравнению с их последовательной транскрибацией. Более подробно
о фрагментированни в 🤗 Transformers можно прочитать в `),u=M(o,"A",{href:!0,rel:!0,"data-svelte-h":!0}),J(u)!=="svelte-vrtp4c"&&(u.textContent=Ua),Ut=b(o,"."),o.forEach(e),Ze=n(l),_l=M(l,"P",{"data-svelte-h":!0}),J(_l)!=="svelte-rnzic7"&&(_l.innerHTML=ya),Ne=n(l),Yl=M(l,"P",{"data-svelte-h":!0}),J(Yl)!=="svelte-575eay"&&(Yl.innerHTML=Ta),_e=n(l),U(Al.$$.fragment,l),Ye=n(l),Ll=M(l,"P",{"data-svelte-h":!0}),J(Ll)!=="svelte-1mvdyro"&&(Ll.innerHTML=wa),Ae=n(l),U(zl.$$.fragment,l),Le=n(l),Xl=M(l,"P",{"data-svelte-h":!0}),J(Xl)!=="svelte-n1n71v"&&(Xl.textContent=ma),ze=n(l),ql=M(l,"P",{"data-svelte-h":!0}),J(ql)!=="svelte-1w5bf9x"&&(ql.innerHTML=ra),Xe=n(l),Dl=M(l,"P",{"data-svelte-h":!0}),J(Dl)!=="svelte-1gr2r2y"&&(Dl.innerHTML=ha),qe=n(l),U(Ol.$$.fragment,l),De=n(l),Pl=M(l,"P",{"data-svelte-h":!0}),J(Pl)!=="svelte-1mvdyro"&&(Pl.innerHTML=oa),Oe=n(l),U(Kl.$$.fragment,l),Pe=n(l),ls=M(l,"P",{"data-svelte-h":!0}),J(ls)!=="svelte-1glad5k"&&(ls.textContent=ja),Ke=n(l),U(ss.$$.fragment,l),lt=n(l),es=M(l,"P",{"data-svelte-h":!0}),J(es)!=="svelte-z1aoca"&&(es.innerHTML=ca),st=n(l),ts=M(l,"P",{"data-svelte-h":!0}),J(ts)!=="svelte-kz3n2j"&&(ts.innerHTML=da),et=n(l),as=M(l,"P",{"data-svelte-h":!0}),J(as)!=="svelte-1ciho6b"&&(as.innerHTML=ua),tt=n(l),Js=M(l,"P",{}),yt(Js).forEach(e),this.h()},h(){is(c,"name","hf:doc:metadata"),is(c,"content",ka),is(d,"class","flex justify-center"),ke.a=ge,ve.a=Ge,$e.a=Fe,He.a=We,is(u,"href","https://huggingface.co/blog/asr-chunking"),is(u,"rel","nofollow")},m(l,s){j(document.head,c),t(l,ys,s),t(l,Ms,s),t(l,Ts,s),y(C,l,s),t(l,ws,s),t(l,f,s),t(l,ms,s),t(l,E,s),t(l,rs,s),t(l,S,s),t(l,hs,s),t(l,x,s),t(l,os,s),t(l,B,s),t(l,js,s),y(Q,l,s),t(l,cs,s),t(l,V,s),t(l,ds,s),y(R,l,s),t(l,us,s),t(l,k,s),t(l,Is,s),y(g,l,s),t(l,bs,s),t(l,v,s),t(l,Cs,s),y(G,l,s),t(l,fs,s),t(l,$,s),t(l,Es,s),y(F,l,s),t(l,Ss,s),t(l,H,s),t(l,xs,s),y(W,l,s),t(l,Bs,s),t(l,Z,s),t(l,Qs,s),y(N,l,s),t(l,Vs,s),t(l,_,s),t(l,Rs,s),y(Y,l,s),t(l,ks,s),t(l,A,s),t(l,gs,s),y(L,l,s),t(l,vs,s),t(l,z,s),t(l,Gs,s),t(l,X,s),t(l,$s,s),t(l,q,s),t(l,Fs,s),t(l,D,s),t(l,Hs,s),y(O,l,s),t(l,Ws,s),t(l,P,s),t(l,Zs,s),t(l,K,s),t(l,Ns,s),t(l,ll,s),t(l,_s,s),t(l,sl,s),t(l,Ys,s),t(l,el,s),t(l,As,s),t(l,tl,s),t(l,Ls,s),t(l,al,s),t(l,zs,s),t(l,nl,s),t(l,Xs,s),t(l,pl,s),t(l,qs,s),t(l,Ml,s),t(l,Ds,s),t(l,Jl,s),t(l,Os,s),y(il,l,s),t(l,Ps,s),t(l,Ul,s),t(l,Ks,s),y(yl,l,s),t(l,le,s),t(l,Tl,s),t(l,se,s),y(wl,l,s),t(l,ee,s),t(l,ml,s),t(l,te,s),y(rl,l,s),t(l,ae,s),t(l,hl,s),t(l,ne,s),t(l,ol,s),t(l,pe,s),y(jl,l,s),t(l,Me,s),t(l,cl,s),t(l,Je,s),y(dl,l,s),t(l,ie,s),t(l,ul,s),t(l,Ue,s),y(Il,l,s),t(l,ye,s),t(l,bl,s),t(l,Te,s),y(Cl,l,s),t(l,we,s),t(l,fl,s),t(l,me,s),y(El,l,s),t(l,re,s),t(l,Sl,s),t(l,he,s),y(xl,l,s),t(l,oe,s),t(l,Bl,s),t(l,je,s),y(Ql,l,s),t(l,ce,s),t(l,Vl,s),t(l,de,s),t(l,Rl,s),t(l,ue,s),y(kl,l,s),t(l,Ie,s),t(l,gl,s),t(l,be,s),t(l,vl,s),t(l,Ce,s),t(l,Gl,s),t(l,fe,s),y($l,l,s),t(l,Ee,s),t(l,Fl,s),t(l,Se,s),y(Hl,l,s),t(l,xe,s),t(l,Wl,s),t(l,Be,s),t(l,Zl,s),t(l,Qe,s),t(l,Nl,s),t(l,Ve,s),t(l,d,s),t(l,Re,s),t(l,h,s),j(h,Mt),ke.m(Ia,h),j(h,ge),ve.m(ba,h),j(h,Ge),j(h,ns),j(h,Jt),$e.m(Ca,h),j(h,Fe),He.m(fa,h),j(h,We),j(h,ps),j(h,it),j(h,u),j(h,Ut),t(l,Ze,s),t(l,_l,s),t(l,Ne,s),t(l,Yl,s),t(l,_e,s),y(Al,l,s),t(l,Ye,s),t(l,Ll,s),t(l,Ae,s),y(zl,l,s),t(l,Le,s),t(l,Xl,s),t(l,ze,s),t(l,ql,s),t(l,Xe,s),t(l,Dl,s),t(l,qe,s),y(Ol,l,s),t(l,De,s),t(l,Pl,s),t(l,Oe,s),y(Kl,l,s),t(l,Pe,s),t(l,ls,s),t(l,Ke,s),y(ss,l,s),t(l,lt,s),t(l,es,s),t(l,st,s),t(l,ts,s),t(l,et,s),t(l,as,s),t(l,tt,s),t(l,Js,s),at=!0},p:Sa,i(l){at||(T(C.$$.fragment,l),T(Q.$$.fragment,l),T(R.$$.fragment,l),T(g.$$.fragment,l),T(G.$$.fragment,l),T(F.$$.fragment,l),T(W.$$.fragment,l),T(N.$$.fragment,l),T(Y.$$.fragment,l),T(L.$$.fragment,l),T(O.$$.fragment,l),T(il.$$.fragment,l),T(yl.$$.fragment,l),T(wl.$$.fragment,l),T(rl.$$.fragment,l),T(jl.$$.fragment,l),T(dl.$$.fragment,l),T(Il.$$.fragment,l),T(Cl.$$.fragment,l),T(El.$$.fragment,l),T(xl.$$.fragment,l),T(Ql.$$.fragment,l),T(kl.$$.fragment,l),T($l.$$.fragment,l),T(Hl.$$.fragment,l),T(Al.$$.fragment,l),T(zl.$$.fragment,l),T(Ol.$$.fragment,l),T(Kl.$$.fragment,l),T(ss.$$.fragment,l),at=!0)},o(l){w(C.$$.fragment,l),w(Q.$$.fragment,l),w(R.$$.fragment,l),w(g.$$.fragment,l),w(G.$$.fragment,l),w(F.$$.fragment,l),w(W.$$.fragment,l),w(N.$$.fragment,l),w(Y.$$.fragment,l),w(L.$$.fragment,l),w(O.$$.fragment,l),w(il.$$.fragment,l),w(yl.$$.fragment,l),w(wl.$$.fragment,l),w(rl.$$.fragment,l),w(jl.$$.fragment,l),w(dl.$$.fragment,l),w(Il.$$.fragment,l),w(Cl.$$.fragment,l),w(El.$$.fragment,l),w(xl.$$.fragment,l),w(Ql.$$.fragment,l),w(kl.$$.fragment,l),w($l.$$.fragment,l),w(Hl.$$.fragment,l),w(Al.$$.fragment,l),w(zl.$$.fragment,l),w(Ol.$$.fragment,l),w(Kl.$$.fragment,l),w(ss.$$.fragment,l),at=!1},d(l){l&&(e(ys),e(Ms),e(Ts),e(ws),e(f),e(ms),e(E),e(rs),e(S),e(hs),e(x),e(os),e(B),e(js),e(cs),e(V),e(ds),e(us),e(k),e(Is),e(bs),e(v),e(Cs),e(fs),e($),e(Es),e(Ss),e(H),e(xs),e(Bs),e(Z),e(Qs),e(Vs),e(_),e(Rs),e(ks),e(A),e(gs),e(vs),e(z),e(Gs),e(X),e($s),e(q),e(Fs),e(D),e(Hs),e(Ws),e(P),e(Zs),e(K),e(Ns),e(ll),e(_s),e(sl),e(Ys),e(el),e(As),e(tl),e(Ls),e(al),e(zs),e(nl),e(Xs),e(pl),e(qs),e(Ml),e(Ds),e(Jl),e(Os),e(Ps),e(Ul),e(Ks),e(le),e(Tl),e(se),e(ee),e(ml),e(te),e(ae),e(hl),e(ne),e(ol),e(pe),e(Me),e(cl),e(Je),e(ie),e(ul),e(Ue),e(ye),e(bl),e(Te),e(we),e(fl),e(me),e(re),e(Sl),e(he),e(oe),e(Bl),e(je),e(ce),e(Vl),e(de),e(Rl),e(ue),e(Ie),e(gl),e(be),e(vl),e(Ce),e(Gl),e(fe),e(Ee),e(Fl),e(Se),e(xe),e(Wl),e(Be),e(Zl),e(Qe),e(Nl),e(Ve),e(d),e(Re),e(h),e(Ze),e(_l),e(Ne),e(Yl),e(_e),e(Ye),e(Ll),e(Ae),e(Le),e(Xl),e(ze),e(ql),e(Xe),e(Dl),e(qe),e(De),e(Pl),e(Oe),e(Pe),e(ls),e(Ke),e(lt),e(es),e(st),e(ts),e(et),e(as),e(tt),e(Js)),e(c),m(C,l),m(Q,l),m(R,l),m(g,l),m(G,l),m(F,l),m(W,l),m(N,l),m(Y,l),m(L,l),m(O,l),m(il,l),m(yl,l),m(wl,l),m(rl,l),m(jl,l),m(dl,l),m(Il,l),m(Cl,l),m(El,l),m(xl,l),m(Ql,l),m(kl,l),m($l,l),m(Hl,l),m(Al,l),m(zl,l),m(Ol,l),m(Kl,l),m(ss,l)}}}const ka='{"title":"Предварительно обученные модели для распознавания речи","local":"предварительно-обученные-модели-для-распознавания-речи","sections":[{"title":"Анализ моделей CTC","local":"анализ-моделей-ctc","sections":[],"depth":2},{"title":"Переход к Seq2Seq","local":"переход-к-seq2seq","sections":[],"depth":2},{"title":"Длинноформатная транскрипция и временные метки","local":"длинноформатная-транскрипция-и-временные-метки","sections":[],"depth":2},{"title":"Итоги","local":"итоги","sections":[],"depth":2}],"depth":1}';function ga(Tt){return xa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ha extends Ba{constructor(c){super(),Qa(this,c,ga,Ra,Ea,{})}}export{Ha as component};
