import{s as ho,o as _o,n as dt}from"../chunks/scheduler.182ea377.js";import{S as bo,i as xo,g as s,s as n,r as h,A as Po,h as a,f as l,c as o,j as L,u as _,x as d,k as S,y as t,a as g,v as b,d as x,t as P,w as v}from"../chunks/index.abf12888.js";import{T as vo}from"../chunks/Tip.230e2334.js";import{D as $}from"../chunks/Docstring.93f6f462.js";import{C as Mt}from"../chunks/CodeBlock.57fe6e13.js";import{E as Tt}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Sn}from"../chunks/Heading.16916d63.js";function yo(j){let r,M='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){r=s("p"),r.innerHTML=M},l(u){r=a(u,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1wmc0l4"&&(r.innerHTML=M)},m(u,c){g(u,r,c)},p:dt,d(u){u&&l(r)}}}function wo(j){let r,M="Examples:",u,c,y;return c=new Mt({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEElMEElMEFkZWYlMjBkb3dubG9hZF9pbWFnZSh1cmwpJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFBJTC5JbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkaWZmdXNlcnMtaW1hZ2VzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRm1vdW50YWluLnBuZyUyMiUwQSUwQWltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UoaW1nX3VybCkucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIydGltYnJvb2tzJTJGaW5zdHJ1Y3QtcGl4MnBpeCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMm1ha2UlMjB0aGUlMjBtb3VudGFpbnMlMjBzbm93eSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
<span class="hljs-meta">... </span>    response = requests.get(url)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionInstructPix2PixPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;make the mountains snowy&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){r=s("p"),r.textContent=M,u=n(),h(c.$$.fragment)},l(i){r=a(i,"P",{"data-svelte-h":!0}),d(r)!=="svelte-kvfsh7"&&(r.textContent=M),u=o(i),_(c.$$.fragment,i)},m(i,T){g(i,r,T),g(i,u,T),b(c,i,T),y=!0},p:dt,i(i){y||(x(c.$$.fragment,i),y=!0)},o(i){P(c.$$.fragment,i),y=!1},d(i){i&&(l(r),l(u)),v(c,i)}}}function Io(j){let r,M="To load a textual inversion embedding vector in 🤗 Diffusers format:",u,c,y;return c=new Mt({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){r=s("p"),r.textContent=M,u=n(),h(c.$$.fragment)},l(i){r=a(i,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1y13ww6"&&(r.textContent=M),u=o(i),_(c.$$.fragment,i)},m(i,T){g(i,r,T),g(i,u,T),b(c,i,T),y=!0},p:dt,i(i){y||(x(c.$$.fragment,i),y=!0)},o(i){P(c.$$.fragment,i),y=!1},d(i){i&&(l(r),l(u)),v(c,i)}}}function To(j){let r,M="locally:",u,c,y;return c=new Mt({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){r=s("p"),r.textContent=M,u=n(),h(c.$$.fragment)},l(i){r=a(i,"P",{"data-svelte-h":!0}),d(r)!=="svelte-4c75kq"&&(r.textContent=M),u=o(i),_(c.$$.fragment,i)},m(i,T){g(i,r,T),g(i,u,T),b(c,i,T),y=!0},p:dt,i(i){y||(x(c.$$.fragment,i),y=!0)},o(i){P(c.$$.fragment,i),y=!1},d(i){i&&(l(r),l(u)),v(c,i)}}}function Mo(j){let r,M="Examples:",u,c,y;return c=new Mt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExJbnN0cnVjdFBpeDJQaXhQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcmVzb2x1dGlvbiUyMCUzRCUyMDc2OCUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmhmLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkaWZmdXNlcnMtaW1hZ2VzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRm1vdW50YWluLnBuZyUyMiUwQSkucmVzaXplKChyZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbikpJTBBZWRpdF9pbnN0cnVjdGlvbiUyMCUzRCUyMCUyMlR1cm4lMjBza3klMjBpbnRvJTIwYSUyMGNsb3VkeSUyMG9uZSUyMiUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEluc3RydWN0UGl4MlBpeFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMkZzZHhsLWluc3RydWN0cGl4MnBpeC03NjglMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBZWRpdGVkX2ltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0RlZGl0X2luc3RydWN0aW9uJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRHJlc29sdXRpb24lMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRHJlc29sdXRpb24lMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDMuMCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX2d1aWRhbmNlX3NjYWxlJTNEMS41JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBZWRpdGVkX2ltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLInstructPix2PixPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>resolution = <span class="hljs-number">768</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span>
<span class="hljs-meta">... </span>).resize((resolution, resolution))
<span class="hljs-meta">&gt;&gt;&gt; </span>edit_instruction = <span class="hljs-string">&quot;Turn sky into a cloudy one&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLInstructPix2PixPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;diffusers/sdxl-instructpix2pix-768&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>edited_image = pipe(
<span class="hljs-meta">... </span>    prompt=edit_instruction,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    height=resolution,
<span class="hljs-meta">... </span>    width=resolution,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">3.0</span>,
<span class="hljs-meta">... </span>    image_guidance_scale=<span class="hljs-number">1.5</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>edited_image`,wrap:!1}}),{c(){r=s("p"),r.textContent=M,u=n(),h(c.$$.fragment)},l(i){r=a(i,"P",{"data-svelte-h":!0}),d(r)!=="svelte-kvfsh7"&&(r.textContent=M),u=o(i),_(c.$$.fragment,i)},m(i,T){g(i,r,T),g(i,u,T),b(c,i,T),y=!0},p:dt,i(i){y||(x(c.$$.fragment,i),y=!0)},o(i){P(c.$$.fragment,i),y=!1},d(i){i&&(l(r),l(u)),v(c,i)}}}function Lo(j){let r,M,u,c,y,i,T,Dn='<a href="https://huggingface.co/papers/2211.09800" rel="nofollow">InstructPix2Pix: Learning to Follow Image Editing Instructions</a> is by Tim Brooks, Aleksander Holynski and Alexei A. Efros.',ct,te,kn="The abstract from the paper is:",pt,ne,$n="<em>We propose a method for editing images from human instructions: given an input image and a written instruction that tells the model what to do, our model follows these instructions to edit the image. To obtain training data for this problem, we combine the knowledge of two large pretrained models — a language model (GPT-3) and a text-to-image model (Stable Diffusion) — to generate a large dataset of image editing examples. Our conditional diffusion model, InstructPix2Pix, is trained on our generated data, and generalizes to real images and user-written instructions at inference time. Since it performs edits in the forward pass and does not require per example fine-tuning or inversion, our model edits images quickly, in a matter of seconds. We show compelling editing results for a diverse collection of input images and written instructions.</em>",ft,oe,Cn='You can find additional information about InstructPix2Pix on the <a href="https://www.timothybrooks.com/instruct-pix2pix" rel="nofollow">project page</a>, <a href="https://github.com/timothybrooks/instruct-pix2pix" rel="nofollow">original codebase</a>, and try it out in a <a href="https://huggingface.co/spaces/timbrooks/instruct-pix2pix" rel="nofollow">demo</a>.',ut,G,mt,ie,gt,w,se,Lt,we,Un="Pipeline for pixel-level image editing by following text instructions (based on Stable Diffusion).",St,Ie,jn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Dt,Te,Jn="The pipeline also inherits the following loading methods:",kt,Me,Xn='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.StableDiffusionDepth2ImgPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',$t,N,ae,Ct,Le,Nn="The call function to the pipeline for generation.",Ut,B,jt,D,re,Jt,Se,Wn=`Load textual inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Xt,De,Zn="Example:",Nt,E,Wt,ke,zn=`To load a textual inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,Zt,H,zt,k,le,Ft,$e,Fn=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,Gt,Ce,Gn="All kwargs are forwarded to <code>self.lora_state_dict</code>.",Bt,Ue,Bn='See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',Et,je,En=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,Ht,Je,Hn=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,Rt,R,de,qt,Xe,Rn="Save the LoRA parameters corresponding to the UNet and text encoder.",At,q,ce,Vt,Ne,qn="Disables the FreeU mechanism if enabled.",Yt,J,pe,Qt,We,An='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Ot,Ze,Vn="The suffixes after the scaling factors represent the stages where they are being applied.",Kt,ze,Yn=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,ht,fe,_t,f,ue,en,Fe,Qn="Pipeline for pixel-level image editing by following text instructions. Based on Stable Diffusion XL.",tn,Ge,On=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,nn,Be,Kn="In addition the pipeline inherits the following loading methods:",on,Ee,eo='<li><em>LoRA</em>: <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights()</a></li>',sn,He,to="as well as the following saving methods:",an,Re,no="<li><em>LoRA</em>: <code>loaders.StableDiffusionXLLoraLoaderMixin.save_lora_weights()</code></li>",rn,W,me,ln,qe,oo="Function invoked when calling the pipeline for generation.",dn,A,cn,V,ge,pn,Ae,io="Disables the FreeU mechanism if enabled.",fn,Y,he,un,Ve,so=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously invoked, this method will go back to
computing decoding in one step.`,mn,Q,_e,gn,Ye,ao=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously invoked, this method will go back to
computing decoding in one step.`,hn,X,be,_n,Qe,ro='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',bn,Oe,lo="The suffixes after the scaling factors represent the stages where they are being applied.",xn,Ke,co=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Pn,Z,xe,vn,et,po="Enable sliced VAE decoding.",yn,tt,fo=`When this option is enabled, the VAE will split the input tensor in slices to compute decoding in several
steps. This is useful to save some memory and allow larger batch sizes.`,wn,z,Pe,In,nt,uo="Enable tiled VAE decoding.",Tn,ot,mo=`When this option is enabled, the VAE will split the input tensor into tiles to compute decoding and encoding in
several steps. This is useful to save a large amount of memory and to allow the processing of larger images.`,Mn,O,ve,Ln,it,go="Encodes the prompt into text encoder hidden states.",bt,lt,xt;return y=new Sn({props:{title:"InstructPix2Pix",local:"instructpix2pix",headingTag:"h1"}}),G=new vo({props:{$$slots:{default:[yo]},$$scope:{ctx:j}}}),ie=new Sn({props:{title:"StableDiffusionInstructPix2PixPipeline",local:"diffusers.StableDiffusionInstructPix2PixPipeline",headingTag:"h2"}}),se=new $({props:{name:"class diffusers.StableDiffusionInstructPix2PixPipeline",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L61"}}),ae=new $({props:{name:"__call__",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 7.5"},{name:"image_guidance_scale",val:": float = 1.5"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> <code>np.ndarray</code>, <code>PIL.Image.Image</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be repainted according to <code>prompt</code>. Can also accept
image latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.image_guidance_scale",description:`<strong>image_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.5) &#x2014;
Push the generated image towards the inital <code>image</code>. Image guidance scale is enabled by setting
<code>image_guidance_scale &gt; 1</code>. Higher image guidance scale encourages generated images that are closely
linked to the source <code>image</code>, usually at the expense of lower image quality. This pipeline requires a
value of at least <code>1</code>.`,name:"image_guidance_scale"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L140",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),B=new Tt({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.example",$$slots:{default:[wo]},$$scope:{ctx:j}}}),re=new $({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, typing.List[str], typing.Dict[str, torch.Tensor], typing.List[typing.Dict[str, torch.Tensor]]]"},{name:"token",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[ForwardRef('PreTrainedTokenizer')] = None"},{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L270"}}),E=new Tt({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.example",$$slots:{default:[Io]},$$scope:{ctx:j}}}),H=new Tt({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.example-2",$$slots:{default:[To]},$$scope:{ctx:j}}}),le=new $({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L79"}}),de=new $({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"unet_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"text_encoder_lora_layers",val:": typing.Dict[str, torch.nn.modules.module.Module] = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L875"}}),ce=new $({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L779"}}),pe=new $({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L756"}}),fe=new Sn({props:{title:"StableDiffusionXLInstructPix2PixPipeline",local:"diffusers.StableDiffusionXLInstructPix2PixPipeline",headingTag:"h2"}}),ue=new $({props:{name:"class diffusers.StableDiffusionXLInstructPix2PixPipeline",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion XL uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code> CLIPTextModelWithProjection</code>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.requires_aesthetics_score",description:`<strong>requires_aesthetics_score</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;False&quot;</code>) &#x2014;
Whether the <code>unet</code> requires a aesthetic_score condition to be passed during inference. Also see the config
of <code>stabilityai/stable-diffusion-xl-refiner-1-0</code>.`,name:"requires_aesthetics_score"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings shall be forced to always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark library</a> to
watermark output images. If not defined, it will default to True if the package is installed, otherwise no
watermarker will be used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L105"}}),me=new $({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 100"},{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"image_guidance_scale",val:": float = 1.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Tuple[int, int] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Tuple[int, int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> or <code>PIL.Image.Image</code> or <code>np.ndarray</code> or <code>List[torch.FloatTensor]</code> or <code>List[PIL.Image.Image]</code> or <code>List[np.ndarray]</code>) &#x2014;
The image(s) to modify with the pipeline.`,name:"image"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.image_guidance_scale",description:`<strong>image_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.5) &#x2014;
Image guidance scale is to push the generated image towards the inital image <code>image</code>. Image guidance
scale is enabled by setting <code>image_guidance_scale &gt; 1</code>. Higher image guidance scale encourages to
generate images that are closely linked to the source image <code>image</code>, usually at the expense of lower
image quality. This pipeline requires a value of at least <code>1</code>.`,name:"image_guidance_scale"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L646",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),A=new Tt({props:{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.example",$$slots:{default:[Mo]},$$scope:{ctx:j}}}),ge=new $({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L642"}}),he=new $({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L202"}}),_e=new $({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L218"}}),be=new $({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L619"}}),xe=new $({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L193"}}),Pe=new $({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L209"}}),ve=new $({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": typing.Optional[str] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt_2",val:": typing.Optional[str] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L225"}}),{c(){r=s("meta"),M=n(),u=s("p"),c=n(),h(y.$$.fragment),i=n(),T=s("p"),T.innerHTML=Dn,ct=n(),te=s("p"),te.textContent=kn,pt=n(),ne=s("p"),ne.innerHTML=$n,ft=n(),oe=s("p"),oe.innerHTML=Cn,ut=n(),h(G.$$.fragment),mt=n(),h(ie.$$.fragment),gt=n(),w=s("div"),h(se.$$.fragment),Lt=n(),we=s("p"),we.textContent=Un,St=n(),Ie=s("p"),Ie.innerHTML=jn,Dt=n(),Te=s("p"),Te.textContent=Jn,kt=n(),Me=s("ul"),Me.innerHTML=Xn,$t=n(),N=s("div"),h(ae.$$.fragment),Ct=n(),Le=s("p"),Le.textContent=Nn,Ut=n(),h(B.$$.fragment),jt=n(),D=s("div"),h(re.$$.fragment),Jt=n(),Se=s("p"),Se.innerHTML=Wn,Xt=n(),De=s("p"),De.textContent=Zn,Nt=n(),h(E.$$.fragment),Wt=n(),ke=s("p"),ke.innerHTML=zn,Zt=n(),h(H.$$.fragment),zt=n(),k=s("div"),h(le.$$.fragment),Ft=n(),$e=s("p"),$e.innerHTML=Fn,Gt=n(),Ce=s("p"),Ce.innerHTML=Gn,Bt=n(),Ue=s("p"),Ue.innerHTML=Bn,Et=n(),je=s("p"),je.innerHTML=En,Ht=n(),Je=s("p"),Je.innerHTML=Hn,Rt=n(),R=s("div"),h(de.$$.fragment),qt=n(),Xe=s("p"),Xe.textContent=Rn,At=n(),q=s("div"),h(ce.$$.fragment),Vt=n(),Ne=s("p"),Ne.textContent=qn,Yt=n(),J=s("div"),h(pe.$$.fragment),Qt=n(),We=s("p"),We.innerHTML=An,Ot=n(),Ze=s("p"),Ze.textContent=Vn,Kt=n(),ze=s("p"),ze.innerHTML=Yn,ht=n(),h(fe.$$.fragment),_t=n(),f=s("div"),h(ue.$$.fragment),en=n(),Fe=s("p"),Fe.textContent=Qn,tn=n(),Ge=s("p"),Ge.innerHTML=On,nn=n(),Be=s("p"),Be.textContent=Kn,on=n(),Ee=s("ul"),Ee.innerHTML=eo,sn=n(),He=s("p"),He.textContent=to,an=n(),Re=s("ul"),Re.innerHTML=no,rn=n(),W=s("div"),h(me.$$.fragment),ln=n(),qe=s("p"),qe.textContent=oo,dn=n(),h(A.$$.fragment),cn=n(),V=s("div"),h(ge.$$.fragment),pn=n(),Ae=s("p"),Ae.textContent=io,fn=n(),Y=s("div"),h(he.$$.fragment),un=n(),Ve=s("p"),Ve.innerHTML=so,mn=n(),Q=s("div"),h(_e.$$.fragment),gn=n(),Ye=s("p"),Ye.innerHTML=ao,hn=n(),X=s("div"),h(be.$$.fragment),_n=n(),Qe=s("p"),Qe.innerHTML=ro,bn=n(),Oe=s("p"),Oe.textContent=lo,xn=n(),Ke=s("p"),Ke.innerHTML=co,Pn=n(),Z=s("div"),h(xe.$$.fragment),vn=n(),et=s("p"),et.textContent=po,yn=n(),tt=s("p"),tt.textContent=fo,wn=n(),z=s("div"),h(Pe.$$.fragment),In=n(),nt=s("p"),nt.textContent=uo,Tn=n(),ot=s("p"),ot.textContent=mo,Mn=n(),O=s("div"),h(ve.$$.fragment),Ln=n(),it=s("p"),it.textContent=go,bt=n(),lt=s("p"),this.h()},l(e){const p=Po("svelte-u9bgzb",document.head);r=a(p,"META",{name:!0,content:!0}),p.forEach(l),M=o(e),u=a(e,"P",{}),L(u).forEach(l),c=o(e),_(y.$$.fragment,e),i=o(e),T=a(e,"P",{"data-svelte-h":!0}),d(T)!=="svelte-1tl4gnd"&&(T.innerHTML=Dn),ct=o(e),te=a(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1cwsb16"&&(te.textContent=kn),pt=o(e),ne=a(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1gbgk0u"&&(ne.innerHTML=$n),ft=o(e),oe=a(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-18wh1q7"&&(oe.innerHTML=Cn),ut=o(e),_(G.$$.fragment,e),mt=o(e),_(ie.$$.fragment,e),gt=o(e),w=a(e,"DIV",{class:!0});var I=L(w);_(se.$$.fragment,I),Lt=o(I),we=a(I,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1gz00nq"&&(we.textContent=Un),St=o(I),Ie=a(I,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-496sm0"&&(Ie.innerHTML=jn),Dt=o(I),Te=a(I,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-14s6m4u"&&(Te.textContent=Jn),kt=o(I),Me=a(I,"UL",{"data-svelte-h":!0}),d(Me)!=="svelte-q3xzhg"&&(Me.innerHTML=Xn),$t=o(I),N=a(I,"DIV",{class:!0});var F=L(N);_(ae.$$.fragment,F),Ct=o(F),Le=a(F,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-50j04k"&&(Le.textContent=Nn),Ut=o(F),_(B.$$.fragment,F),F.forEach(l),jt=o(I),D=a(I,"DIV",{class:!0});var C=L(D);_(re.$$.fragment,C),Jt=o(C),Se=a(C,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-617c7s"&&(Se.innerHTML=Wn),Xt=o(C),De=a(C,"P",{"data-svelte-h":!0}),d(De)!=="svelte-11lpom8"&&(De.textContent=Zn),Nt=o(C),_(E.$$.fragment,C),Wt=o(C),ke=a(C,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-2gddoh"&&(ke.innerHTML=zn),Zt=o(C),_(H.$$.fragment,C),C.forEach(l),zt=o(I),k=a(I,"DIV",{class:!0});var U=L(k);_(le.$$.fragment,U),Ft=o(U),$e=a(U,"P",{"data-svelte-h":!0}),d($e)!=="svelte-vs7s0z"&&($e.innerHTML=Fn),Gt=o(U),Ce=a(U,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-15b960v"&&(Ce.innerHTML=Gn),Bt=o(U),Ue=a(U,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-qj05o3"&&(Ue.innerHTML=Bn),Et=o(U),je=a(U,"P",{"data-svelte-h":!0}),d(je)!=="svelte-ot29jq"&&(je.innerHTML=En),Ht=o(U),Je=a(U,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1ah097o"&&(Je.innerHTML=Hn),U.forEach(l),Rt=o(I),R=a(I,"DIV",{class:!0});var ye=L(R);_(de.$$.fragment,ye),qt=o(ye),Xe=a(ye,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-1ufq5ot"&&(Xe.textContent=Rn),ye.forEach(l),At=o(I),q=a(I,"DIV",{class:!0});var Pt=L(q);_(ce.$$.fragment,Pt),Vt=o(Pt),Ne=a(Pt,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-psupw6"&&(Ne.textContent=qn),Pt.forEach(l),Yt=o(I),J=a(I,"DIV",{class:!0});var K=L(J);_(pe.$$.fragment,K),Qt=o(K),We=a(K,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1f3tmq1"&&(We.innerHTML=An),Ot=o(K),Ze=a(K,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-xjijlp"&&(Ze.textContent=Vn),Kt=o(K),ze=a(K,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-hy0nzs"&&(ze.innerHTML=Yn),K.forEach(l),I.forEach(l),ht=o(e),_(fe.$$.fragment,e),_t=o(e),f=a(e,"DIV",{class:!0});var m=L(f);_(ue.$$.fragment,m),en=o(m),Fe=a(m,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1n3req3"&&(Fe.textContent=Qn),tn=o(m),Ge=a(m,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-wu1jmh"&&(Ge.innerHTML=On),nn=o(m),Be=a(m,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-984r3o"&&(Be.textContent=Kn),on=o(m),Ee=a(m,"UL",{"data-svelte-h":!0}),d(Ee)!=="svelte-wacfqw"&&(Ee.innerHTML=eo),sn=o(m),He=a(m,"P",{"data-svelte-h":!0}),d(He)!=="svelte-19qtqre"&&(He.textContent=to),an=o(m),Re=a(m,"UL",{"data-svelte-h":!0}),d(Re)!=="svelte-1lnbtw8"&&(Re.innerHTML=no),rn=o(m),W=a(m,"DIV",{class:!0});var st=L(W);_(me.$$.fragment,st),ln=o(st),qe=a(st,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-v78lg8"&&(qe.textContent=oo),dn=o(st),_(A.$$.fragment,st),st.forEach(l),cn=o(m),V=a(m,"DIV",{class:!0});var vt=L(V);_(ge.$$.fragment,vt),pn=o(vt),Ae=a(vt,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-psupw6"&&(Ae.textContent=io),vt.forEach(l),fn=o(m),Y=a(m,"DIV",{class:!0});var yt=L(Y);_(he.$$.fragment,yt),un=o(yt),Ve=a(yt,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-1lk12qh"&&(Ve.innerHTML=so),yt.forEach(l),mn=o(m),Q=a(m,"DIV",{class:!0});var wt=L(Q);_(_e.$$.fragment,wt),gn=o(wt),Ye=a(wt,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-elsxjh"&&(Ye.innerHTML=ao),wt.forEach(l),hn=o(m),X=a(m,"DIV",{class:!0});var ee=L(X);_(be.$$.fragment,ee),_n=o(ee),Qe=a(ee,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1f3tmq1"&&(Qe.innerHTML=ro),bn=o(ee),Oe=a(ee,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-xjijlp"&&(Oe.textContent=lo),xn=o(ee),Ke=a(ee,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-hy0nzs"&&(Ke.innerHTML=co),ee.forEach(l),Pn=o(m),Z=a(m,"DIV",{class:!0});var at=L(Z);_(xe.$$.fragment,at),vn=o(at),et=a(at,"P",{"data-svelte-h":!0}),d(et)!=="svelte-ssd5ny"&&(et.textContent=po),yn=o(at),tt=a(at,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-62zig4"&&(tt.textContent=fo),at.forEach(l),wn=o(m),z=a(m,"DIV",{class:!0});var rt=L(z);_(Pe.$$.fragment,rt),In=o(rt),nt=a(rt,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-4j2l7q"&&(nt.textContent=uo),Tn=o(rt),ot=a(rt,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-1biw85q"&&(ot.textContent=mo),rt.forEach(l),Mn=o(m),O=a(m,"DIV",{class:!0});var It=L(O);_(ve.$$.fragment,It),Ln=o(It),it=a(It,"P",{"data-svelte-h":!0}),d(it)!=="svelte-16q0ax1"&&(it.textContent=go),It.forEach(l),m.forEach(l),bt=o(e),lt=a(e,"P",{}),L(lt).forEach(l),this.h()},h(){S(r,"name","hf:doc:metadata"),S(r,"content",So),S(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){t(document.head,r),g(e,M,p),g(e,u,p),g(e,c,p),b(y,e,p),g(e,i,p),g(e,T,p),g(e,ct,p),g(e,te,p),g(e,pt,p),g(e,ne,p),g(e,ft,p),g(e,oe,p),g(e,ut,p),b(G,e,p),g(e,mt,p),b(ie,e,p),g(e,gt,p),g(e,w,p),b(se,w,null),t(w,Lt),t(w,we),t(w,St),t(w,Ie),t(w,Dt),t(w,Te),t(w,kt),t(w,Me),t(w,$t),t(w,N),b(ae,N,null),t(N,Ct),t(N,Le),t(N,Ut),b(B,N,null),t(w,jt),t(w,D),b(re,D,null),t(D,Jt),t(D,Se),t(D,Xt),t(D,De),t(D,Nt),b(E,D,null),t(D,Wt),t(D,ke),t(D,Zt),b(H,D,null),t(w,zt),t(w,k),b(le,k,null),t(k,Ft),t(k,$e),t(k,Gt),t(k,Ce),t(k,Bt),t(k,Ue),t(k,Et),t(k,je),t(k,Ht),t(k,Je),t(w,Rt),t(w,R),b(de,R,null),t(R,qt),t(R,Xe),t(w,At),t(w,q),b(ce,q,null),t(q,Vt),t(q,Ne),t(w,Yt),t(w,J),b(pe,J,null),t(J,Qt),t(J,We),t(J,Ot),t(J,Ze),t(J,Kt),t(J,ze),g(e,ht,p),b(fe,e,p),g(e,_t,p),g(e,f,p),b(ue,f,null),t(f,en),t(f,Fe),t(f,tn),t(f,Ge),t(f,nn),t(f,Be),t(f,on),t(f,Ee),t(f,sn),t(f,He),t(f,an),t(f,Re),t(f,rn),t(f,W),b(me,W,null),t(W,ln),t(W,qe),t(W,dn),b(A,W,null),t(f,cn),t(f,V),b(ge,V,null),t(V,pn),t(V,Ae),t(f,fn),t(f,Y),b(he,Y,null),t(Y,un),t(Y,Ve),t(f,mn),t(f,Q),b(_e,Q,null),t(Q,gn),t(Q,Ye),t(f,hn),t(f,X),b(be,X,null),t(X,_n),t(X,Qe),t(X,bn),t(X,Oe),t(X,xn),t(X,Ke),t(f,Pn),t(f,Z),b(xe,Z,null),t(Z,vn),t(Z,et),t(Z,yn),t(Z,tt),t(f,wn),t(f,z),b(Pe,z,null),t(z,In),t(z,nt),t(z,Tn),t(z,ot),t(f,Mn),t(f,O),b(ve,O,null),t(O,Ln),t(O,it),g(e,bt,p),g(e,lt,p),xt=!0},p(e,[p]){const I={};p&2&&(I.$$scope={dirty:p,ctx:e}),G.$set(I);const F={};p&2&&(F.$$scope={dirty:p,ctx:e}),B.$set(F);const C={};p&2&&(C.$$scope={dirty:p,ctx:e}),E.$set(C);const U={};p&2&&(U.$$scope={dirty:p,ctx:e}),H.$set(U);const ye={};p&2&&(ye.$$scope={dirty:p,ctx:e}),A.$set(ye)},i(e){xt||(x(y.$$.fragment,e),x(G.$$.fragment,e),x(ie.$$.fragment,e),x(se.$$.fragment,e),x(ae.$$.fragment,e),x(B.$$.fragment,e),x(re.$$.fragment,e),x(E.$$.fragment,e),x(H.$$.fragment,e),x(le.$$.fragment,e),x(de.$$.fragment,e),x(ce.$$.fragment,e),x(pe.$$.fragment,e),x(fe.$$.fragment,e),x(ue.$$.fragment,e),x(me.$$.fragment,e),x(A.$$.fragment,e),x(ge.$$.fragment,e),x(he.$$.fragment,e),x(_e.$$.fragment,e),x(be.$$.fragment,e),x(xe.$$.fragment,e),x(Pe.$$.fragment,e),x(ve.$$.fragment,e),xt=!0)},o(e){P(y.$$.fragment,e),P(G.$$.fragment,e),P(ie.$$.fragment,e),P(se.$$.fragment,e),P(ae.$$.fragment,e),P(B.$$.fragment,e),P(re.$$.fragment,e),P(E.$$.fragment,e),P(H.$$.fragment,e),P(le.$$.fragment,e),P(de.$$.fragment,e),P(ce.$$.fragment,e),P(pe.$$.fragment,e),P(fe.$$.fragment,e),P(ue.$$.fragment,e),P(me.$$.fragment,e),P(A.$$.fragment,e),P(ge.$$.fragment,e),P(he.$$.fragment,e),P(_e.$$.fragment,e),P(be.$$.fragment,e),P(xe.$$.fragment,e),P(Pe.$$.fragment,e),P(ve.$$.fragment,e),xt=!1},d(e){e&&(l(M),l(u),l(c),l(i),l(T),l(ct),l(te),l(pt),l(ne),l(ft),l(oe),l(ut),l(mt),l(gt),l(w),l(ht),l(_t),l(f),l(bt),l(lt)),l(r),v(y,e),v(G,e),v(ie,e),v(se),v(ae),v(B),v(re),v(E),v(H),v(le),v(de),v(ce),v(pe),v(fe,e),v(ue),v(me),v(A),v(ge),v(he),v(_e),v(be),v(xe),v(Pe),v(ve)}}}const So='{"title":"InstructPix2Pix","local":"instructpix2pix","sections":[{"title":"StableDiffusionInstructPix2PixPipeline","local":"diffusers.StableDiffusionInstructPix2PixPipeline","sections":[],"depth":2},{"title":"StableDiffusionXLInstructPix2PixPipeline","local":"diffusers.StableDiffusionXLInstructPix2PixPipeline","sections":[],"depth":2}],"depth":1}';function Do(j){return _o(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class No extends bo{constructor(r){super(),xo(this,r,Do,Lo,ho,{})}}export{No as component};
