import{s as Lr,n as Fr,o as zr}from"../chunks/scheduler.9039eef2.js";import{S as Sr,i as qr,g as r,s as n,r as l,A as Ir,h as o,f as i,c as a,j as u,u as d,x as h,k as f,y as t,a as _,v as c,d as p,t as m,w as g}from"../chunks/index.ded8f90d.js";import{D as v}from"../chunks/Docstring.a2ba2b54.js";import{H as k}from"../chunks/Heading.f027f30d.js";function Mr(Va){let z,Ut,At,Ht,re,Rt,oe,ja=`At TRL we support PPO (Proximal Policy Optimisation) with an implementation that largely follows  the structure introduced in the paper “Fine-Tuning Language Models from Human Preferences” by D. Ziegler et al. [<a href="https://arxiv.org/pdf/1909.08593.pdf" rel="nofollow">paper</a>, <a href="https://github.com/openai/lm-human-preferences" rel="nofollow">code</a>].
The Trainer and model classes are largely inspired from <code>transformers.Trainer</code> and <code>transformers.AutoModel</code> classes and adapted for RL.
We also support a <code>RewardTrainer</code> that can be used to train a reward model.`,Vt,ie,jt,S,se,qn,Ke,Wa="Configuration class for PPOTrainer",Wt,le,Bt,b,de,In,Ge,Ba=`The PPOTrainer uses Proximal Policy Optimization to optimise language models.
Note, this trainer is heavily inspired by the original OpenAI learning to summarize work here:
<a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">https://github.com/openai/summarize-from-feedback</a>`,Mn,A,ce,An,Ye,Ja="Calculate model outputs in multiple batches.",En,E,pe,Un,Ze,Ka="Compute per token rewards from scores and KL-penalty.",Hn,U,me,Rn,Qe,Ga="Creates and saves a model card for a TRL model.",Vn,H,ge,jn,Xe,Ya="Gather stats from all processes. Useful in the context of distributed training.",Wn,R,he,Bn,et,Za=`Generate response with the model given the query tensor.
call the <code>generate</code> method of the model.`,Jn,V,_e,Kn,tt,Qa="A function that logs all the training stats. Call it at the end of each epoch.",Gn,j,ue,Yn,nt,Xa="Calculate policy and value losses.",Zn,W,fe,Qn,at,er="Prepare the dataloader for training.",Xn,B,ve,ea,rt,tr="Record training step statistics.",ta,J,be,na,ot,nr="Run a PPO optimisation step given a list of queries, model responses, and rewards.",aa,K,Te,ra,it,ar="Train one PPO minibatch",Jt,ye,Kt,D,xe,oa,st,rr='RewardConfig collects all training arguments related to the <a href="/docs/trl/main/en/reward_trainer#trl.RewardTrainer">RewardTrainer</a> class.',ia,lt,or=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Gt,Pe,Yt,P,$e,sa,dt,ir=`The RewardTrainer can be used to train your custom Reward Model. It is a subclass of the
<code>transformers.Trainer</code> class and inherits all of its attributes and methods. It is recommended to use
an <code>AutoModelForSequenceClassification</code> as the reward model. The reward model should be trained on a dataset
of paired examples, where each example is a tuple of two sequences. The reward model should be trained to
predict which example in the pair is more relevant to the task at hand.`,la,ct,sr=`The reward trainer expects a very specific format for the dataset. The dataset should contain two 4 entries at least
if you don’t use the default <code>RewardDataCollatorWithPadding</code> data collator. The entries should be named`,da,pt,lr="<li><code>input_ids_chosen</code></li> <li><code>attention_mask_chosen</code></li> <li><code>input_ids_rejected</code></li> <li><code>attention_mask_rejected</code></li>",ca,mt,dr=`Optionally, you can also pass a <code>margin</code> entry to the dataset. This entry should contain the margin used to modulate the
loss of the reward model as outlined in <a href="https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/" rel="nofollow">https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/</a>.
If you don’t pass a margin, no margin will be used.`,Zt,Oe,Qt,q,De,pa,gt,cr=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,Xt,we,en,y,ke,ma,ht,pr="Initialize DPOTrainer.",ga,C,Ce,ha,_t,mr="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",_a,ut,gr="We do this to avoid doing two forward passes, because it’s faster for FSDP.",ua,G,Ne,fa,ft,hr="Concatenate the chosen and rejected inputs into a single tensor.",va,Y,Le,ba,vt,_r="Compute the DPO loss for a batch of policy and reference model log probabilities.",Ta,N,Fe,ya,bt,ur=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,xa,Tt,fr="Works both with or without labels.",Pa,Z,ze,$a,yt,vr="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",Oa,Q,Se,Da,xt,br="Generate samples from the model and reference model for the given batch of inputs.",wa,X,qe,ka,Pt,Tr="Log <code>logs</code> on the various objects watching training, including stored metrics.",tn,Ie,nn,I,Me,Ca,$t,yr="Configuration class for DDPOTrainer",an,Ae,rn,$,Ee,Na,Ot,xr=`The DDPOTrainer uses Deep Diffusion Policy Optimization to optimise diffusion models.
Note, this trainer is heavily inspired by the work here: <a href="https://github.com/kvablack/ddpo-pytorch" rel="nofollow">https://github.com/kvablack/ddpo-pytorch</a>
As of now only Stable Diffusion based pipelines are supported`,La,ee,Ue,Fa,Dt,Pr="Calculate the loss for a batch of an unpacked sample",za,O,He,Sa,wt,$r="Perform a single step of training.",qa,kt,Or="Side Effects:",Ia,Ct,Dr="<li>Model weights are updated</li> <li>Logs the statistics to the accelerator trackers.</li> <li>If <code>self.image_samples_callback</code> is not None, it will be called with the prompt_image_pairs, global_step, and the accelerator tracker.</li>",Ma,te,Re,Aa,Nt,wr="Train the model for a given number of epochs",on,Ve,sn,w,je,Ea,Lt,kr="The IterativeSFTTrainer can be used to finetune models with methods that requires some steps between optimization.",Ua,ne,We,Ha,Ft,Cr="Run an optimisation step given a list of input_ids, attention_mask, and labels or a list of text and text_labels.",ln,Be,dn,M,Je,Ra,zt,Nr="Helper function for reproducible behavior to set the seed in <code>random</code>, <code>numpy</code>, and <code>torch</code>.",cn,Et,pn;return re=new k({props:{title:"Trainer",local:"trainer",headingTag:"h1"}}),ie=new k({props:{title:"PPOConfig",local:"trl.PPOConfig",headingTag:"h2"}}),se=new v({props:{name:"class trl.PPOConfig",anchor:"trl.PPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"seed",val:": int = 0"},{name:"log_with",val:": typing.Union[typing.Literal['wandb', 'tensorboard'], NoneType] = None"},{name:"task_name",val:": typing.Optional[str] = None"},{name:"model_name",val:": typing.Optional[str] = None"},{name:"query_dataset",val:": typing.Optional[str] = None"},{name:"reward_model",val:": typing.Optional[str] = None"},{name:"remove_unused_columns",val:": bool = True"},{name:"tracker_kwargs",val:": typing_extensions.Annotated[typing.Optional[dict], _ArgConfiguration(name=None, metavar='JSON', help=None, aliases=None, prefix_name=None, constructor_factory=<function arg.<locals>.<lambda> at 0x7fa926c82280>)] = <factory>"},{name:"accelerator_kwargs",val:": typing_extensions.Annotated[typing.Optional[dict], _ArgConfiguration(name=None, metavar='JSON', help=None, aliases=None, prefix_name=None, constructor_factory=<function arg.<locals>.<lambda> at 0x7fa926c82280>)] = <factory>"},{name:"project_kwargs",val:": typing_extensions.Annotated[typing.Optional[dict], _ArgConfiguration(name=None, metavar='JSON', help=None, aliases=None, prefix_name=None, constructor_factory=<function arg.<locals>.<lambda> at 0x7fa926c82280>)] = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"push_to_hub_if_best_kwargs",val:": typing_extensions.Annotated[typing.Optional[dict], _ArgConfiguration(name=None, metavar='JSON', help=None, aliases=None, prefix_name=None, constructor_factory=<function arg.<locals>.<lambda> at 0x7fa926c82280>)] = <factory>"},{name:"steps",val:": int = 20000"},{name:"learning_rate",val:": float = 1e-05"},{name:"adap_kl_ctrl",val:": bool = True"},{name:"init_kl_coef",val:": typing.Optional[float] = 0.2"},{name:"kl_penalty",val:": typing.Literal['kl', 'abs', 'mse', 'full'] = 'kl'"},{name:"target",val:": typing.Optional[float] = 6"},{name:"horizon",val:": typing.Optional[float] = 10000"},{name:"gamma",val:": float = 1"},{name:"lam",val:": float = 0.95"},{name:"cliprange",val:": float = 0.2"},{name:"cliprange_value",val:": float = 0.2"},{name:"vf_coef",val:": float = 0.1"},{name:"batch_size",val:": int = 256"},{name:"forward_batch_size",val:": typing.Optional[int] = None"},{name:"mini_batch_size",val:": int = 1"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"world_size",val:": typing_extensions.Annotated[int, Suppress] = None"},{name:"ppo_epochs",val:": int = 4"},{name:"max_grad_norm",val:": typing.Optional[float] = None"},{name:"optimize_cuda_cache",val:": bool = False"},{name:"optimize_device_cache",val:": typing.Optional[bool] = False"},{name:"early_stopping",val:": bool = False"},{name:"target_kl",val:": float = 1"},{name:"compare_steps",val:": int = 1"},{name:"ratio_threshold",val:": float = 10.0"},{name:"use_score_scaling",val:": bool = False"},{name:"use_score_norm",val:": bool = False"},{name:"score_clip",val:": typing.Optional[float] = None"},{name:"whiten_rewards",val:": bool = False"},{name:"is_encoder_decoder",val:": typing.Union[typing_extensions.Annotated[bool, Suppress], NoneType] = None"},{name:"is_peft_model",val:": typing.Union[typing_extensions.Annotated[bool, Suppress], NoneType] = None"},{name:"backward_batch_size",val:": typing_extensions.Annotated[int, Suppress] = None"},{name:"global_backward_batch_size",val:": typing_extensions.Annotated[int, Suppress] = None"},{name:"global_batch_size",val:": typing_extensions.Annotated[int, Suppress] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_config.py#L35"}}),le=new k({props:{title:"PPOTrainer",local:"trl.PPOTrainer",headingTag:"h2"}}),de=new v({props:{name:"class trl.PPOTrainer",anchor:"trl.PPOTrainer",parameters:[{name:"config",val:": PPOConfig = None"},{name:"model",val:": PreTrainedModelWrapper = None"},{name:"ref_model",val:": typing.Optional[trl.models.modeling_base.PreTrainedModelWrapper] = None"},{name:"tokenizer",val:": PreTrainedTokenizerBase = None"},{name:"dataset",val:": typing.Union[torch.utils.data.dataset.Dataset, datasets.arrow_dataset.Dataset, NoneType] = None"},{name:"optimizer",val:": typing.Optional[torch.optim.optimizer.Optimizer] = None"},{name:"data_collator",val:": typing.Optional[typing.Callable] = None"},{name:"num_shared_layers",val:": typing.Optional[int] = None"},{name:"lr_scheduler",val:": typing.Optional[torch.optim.lr_scheduler._LRScheduler] = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>PPOConfig</code>) &#x2014; Configuration object for PPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.PPOTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModelWrapper</code>) &#x2014; Model to be optimized, Hugging Face transformer model with a value head. &#x2014;
Check the documentation of <code>PreTrainedModelWrapper</code> for more details.`,name:"*model**"},{anchor:"trl.PPOTrainer.*ref_model**",description:`*<strong>*ref_model**</strong> (<code>PreTrainedModelWrapper</code>, <em>optional</em>) &#x2014; Reference model to be used for KL penalty, Hugging Face &#x2014;
transformer model with a casual language modelling head. Check the documentation of <code>PreTrainedModelWrapper</code>
for more details. If no reference model is provided, the trainer will create a reference model with the same
architecture as the model to be optimized with shared layers.`,name:"*ref_model**"},{anchor:"trl.PPOTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.PPOTrainer.*dataset**",description:`*<strong>*dataset**</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>], <em>optional</em>) &#x2014; PyTorch dataset or Hugging &#x2014;
Face dataset. This is used to create a PyTorch dataloader. If no dataset is provided, the dataloader must be
created outside the trainer users needs to design their own dataloader and make sure the batch
size that is used is the same as the one specified in the configuration object.`,name:"*dataset**"},{anchor:"trl.PPOTrainer.*optimizer**",description:`*<strong>*optimizer**</strong> (<code>torch.optim.Optimizer</code>, <em>optional</em>) &#x2014; Optimizer to be used for training. If no optimizer is &#x2014;
provided, the trainer will create an Adam optimizer with the learning rate specified in the configuration
object.`,name:"*optimizer**"},{anchor:"trl.PPOTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (DataCollatorForLanguageModeling, <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader`,name:"*data_collator**"},{anchor:"trl.PPOTrainer.*num_shared_layers**",description:`*<strong>*num_shared_layers**</strong> (int, <em>optional</em>) &#x2014; Number of layers to be shared between the model and the reference &#x2014;
model, if no reference model is passed. If no number is provided, all the layers will be shared.`,name:"*num_shared_layers**"},{anchor:"trl.PPOTrainer.*lr_scheduler**",description:"*<strong>*lr_scheduler**</strong> (<code>torch.optim.lr_scheduler</code>, <em>optional</em>) &#x2014; Learning rate scheduler to be used for training. &#x2014;",name:"*lr_scheduler**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L108"}}),ce=new v({props:{name:"batched_forward_pass",anchor:"trl.PPOTrainer.batched_forward_pass",parameters:[{name:"model",val:": PreTrainedModelWrapper"},{name:"queries",val:": Tensor"},{name:"responses",val:": Tensor"},{name:"model_inputs",val:": dict"},{name:"return_logits",val:": bool = False"},{name:"response_masks",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.batched_forward_pass.queries",description:`<strong>queries</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries, shape (<code>batch_size</code>, <code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.batched_forward_pass.responses",description:`<strong>responses</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.batched_forward_pass.return_logits",description:`<strong>return_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return all_logits. Set to <code>False</code> if logits are not needed to reduce memory consumption.`,name:"return_logits"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L935",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>all_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_ref_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_values (<code>torch.FloatTensor</code>): Values of the responses, shape (<code>batch_size</code>, <code>response_length</code>)</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(tuple)</p>
`}}),pe=new v({props:{name:"compute_rewards",anchor:"trl.PPOTrainer.compute_rewards",parameters:[{name:"scores",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"ref_logprobs",val:": FloatTensor"},{name:"masks",val:": LongTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.compute_rewards.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code>) &#x2014;
Scores from the reward model, shape (<code>batch_size</code>)`,name:"scores"},{anchor:"trl.PPOTrainer.compute_rewards.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"},{anchor:"trl.PPOTrainer.compute_rewards.ref_logprobs",description:`<strong>ref_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the reference model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"ref_logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1072"}}),me=new v({props:{name:"create_model_card",anchor:"trl.PPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": typing.Optional[str] = 'TRL Model'"}],parametersDescription:[{anchor:"trl.PPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.PPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1381"}}),ge=new v({props:{name:"gather_stats",anchor:"trl.PPOTrainer.gather_stats",parameters:[{name:"stats",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.gather_stats.stats",description:"<strong>stats</strong> (dict[str, Any]) &#x2014;",name:"stats"},{anchor:"trl.PPOTrainer.gather_stats.a",description:"<strong>a</strong> dictionary of stats to be gathered. The stats should contain torch tensors. &#x2014;",name:"a"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L891",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary of stats with the tensors gathered.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),he=new v({props:{name:"generate",anchor:"trl.PPOTrainer.generate",parameters:[{name:"query_tensor",val:": typing.Union[torch.Tensor, typing.List[torch.Tensor]]"},{name:"length_sampler",val:": typing.Callable = None"},{name:"batch_size",val:": int = 4"},{name:"return_prompt",val:": bool = True"},{name:"generate_ref_response",val:": bool = False"},{name:"**generation_kwargs",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.generate.query_tensor",description:`<strong>query_tensor</strong> (<code>torch.LongTensor</code>) &#x2014;
A tensor of shape (<code>seq_len</code>) containing query tokens or a list of tensors of shape (<code>seq_len</code>).`,name:"query_tensor"},{anchor:"trl.PPOTrainer.generate.generation_kwargs",description:`<strong>generation_kwargs</strong> (dict[str, Any]) &#x2014;
Keyword arguments for generation.`,name:"generation_kwargs"},{anchor:"trl.PPOTrainer.generate.length_sampler",description:`<strong>length_sampler</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Callable that returns the number of newly generated tokens.`,name:"length_sampler"},{anchor:"trl.PPOTrainer.generate.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, *optional) &#x2014;
Batch size used for generation, defaults to <code>4</code>.`,name:"batch_size"},{anchor:"trl.PPOTrainer.generate.return_prompt",description:`<strong>return_prompt</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>False</code> the prompt is not returned but only the newly generated tokens, defaults to <code>True</code>.`,name:"return_prompt"},{anchor:"trl.PPOTrainer.generate.generate_ref_response",description:`<strong>generate_ref_response</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code> the reference response is also generated, defaults to <code>False</code>.`,name:"generate_ref_response"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L426",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (<code>batch_size</code>, <code>gen_len</code>) containing response tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code></p>
`}}),_e=new v({props:{name:"log_stats",anchor:"trl.PPOTrainer.log_stats",parameters:[{name:"stats",val:": dict"},{name:"batch",val:": dict"},{name:"rewards",val:": typing.List[torch.FloatTensor]"},{name:"columns_to_log",val:": typing.List[str] = ['query', 'response']"}],parametersDescription:[{anchor:"trl.PPOTrainer.log_stats.stats",description:`<strong>stats</strong> (dict[str, Any]) &#x2014;
A dictionary of training stats.`,name:"stats"},{anchor:"trl.PPOTrainer.log_stats.batch",description:`<strong>batch</strong> (dict[str, Any]) &#x2014;
A dictionary of batch data, this contains the queries and responses.`,name:"batch"},{anchor:"trl.PPOTrainer.log_stats.rewards",description:`<strong>rewards</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
A tensor of rewards.`,name:"rewards"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1300"}}),ue=new v({props:{name:"loss",anchor:"trl.PPOTrainer.loss",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.loss.old_logprobs",description:`<strong>old_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"old_logprobs"},{anchor:"trl.PPOTrainer.loss.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"values"},{anchor:"trl.PPOTrainer.loss.rewards",description:`<strong>rewards</strong> (<code>torch.FloatTensor</code>) &#x2014;
Rewards from the reward model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"rewards"},{anchor:"trl.PPOTrainer.loss.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
Logits of the model, shape (<code>batch_size</code>, <code>response_length</code>, <code>vocab_size</code>)`,name:"logits"},{anchor:"trl.PPOTrainer.loss.v_pred",description:`<strong>v_pred</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"v_pred"},{anchor:"trl.PPOTrainer.loss.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1148"}}),fe=new v({props:{name:"prepare_dataloader",anchor:"trl.PPOTrainer.prepare_dataloader",parameters:[{name:"dataset",val:": typing.Union[torch.utils.data.dataset.Dataset, datasets.arrow_dataset.Dataset]"},{name:"data_collator",val:" = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.prepare_dataloader.dataset",description:`<strong>dataset</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>]) &#x2014;
PyTorch dataset or Hugging Face dataset. If a Hugging Face dataset is passed, the dataset
will be preprocessed by removing the columns that are not used by the model.`,name:"dataset"},{anchor:"trl.PPOTrainer.prepare_dataloader.data_collator",description:`<strong>data_collator</strong> (Optional[function]) &#x2014;
Data collator function.`,name:"data_collator"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L371",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>PyTorch dataloader</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.utils.data.DataLoader</code></p>
`}}),ve=new v({props:{name:"record_step_stats",anchor:"trl.PPOTrainer.record_step_stats",parameters:[{name:"kl_coef",val:": float"},{name:"**data",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.record_step_stats.kl_coef",description:`<strong>kl_coef</strong> (<code>float</code>) &#x2014;
KL coefficient`,name:"kl_coef"},{anchor:"trl.PPOTrainer.record_step_stats.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary of training step data`,name:"data"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1237",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training step statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stats (<code>dict</code>)</p>
`}}),be=new v({props:{name:"step",anchor:"trl.PPOTrainer.step",parameters:[{name:"queries",val:": typing.List[torch.LongTensor]"},{name:"responses",val:": typing.List[torch.LongTensor]"},{name:"scores",val:": typing.List[torch.FloatTensor]"},{name:"response_masks",val:": typing.Optional[typing.List[torch.LongTensor]] = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.step.queries",description:`<strong>queries</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries of shape (<code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.step.responses",description:`<strong>responses</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses of shape (<code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.step.scores",description:`<strong>scores</strong> (List<code>torch.FloatTensor</code>) &#x2014;
List of tensors containing the scores.`,name:"scores"},{anchor:"trl.PPOTrainer.step.response_masks",description:`<strong>response_masks</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>)) &#x2014;
List of tensors containing masks of the response tokens.`,name:"response_masks"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L612",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Te=new v({props:{name:"train_minibatch",anchor:"trl.PPOTrainer.train_minibatch",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.train_minibatch.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape [batch_size, response_length]`,name:"logprobs"},{anchor:"trl.PPOTrainer.train_minibatch.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape [batch_size, response_length]`,name:"values"},{anchor:"trl.PPOTrainer.train_minibatch.query",description:`<strong>query</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded queries, shape [batch_size, query_length]`,name:"query"},{anchor:"trl.PPOTrainer.train_minibatch.response",description:`<strong>response</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded responses, shape [batch_size, response_length]`,name:"response"},{anchor:"trl.PPOTrainer.train_minibatch.model_input",description:`<strong>model_input</strong> (<code>torch.LongTensor</code>) &#x2014;
Concatenated queries and responses, shape [batch_size, query_length+response_length]`,name:"model_input"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1026",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>train_stats (dict[str, <code>torch.Tensor</code>])</p>
`}}),ye=new k({props:{title:"RewardConfig",local:"trl.RewardConfig",headingTag:"h2"}}),xe=new v({props:{name:"class trl.RewardConfig",anchor:"trl.RewardConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": typing.Optional[int] = None"},{name:"per_gpu_eval_batch_size",val:": typing.Optional[int] = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": typing.Optional[int] = None"},{name:"eval_delay",val:": typing.Optional[float] = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": typing.Union[transformers.trainer_utils.SchedulerType, str] = 'linear'"},{name:"lr_scheduler_kwargs",val:": typing.Optional[typing.Dict] = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": typing.Optional[str] = 'passive'"},{name:"log_level_replica",val:": typing.Optional[str] = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": typing.Optional[str] = None"},{name:"logging_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": typing.Optional[int] = None"},{name:"save_safetensors",val:": typing.Optional[bool] = True"},{name:"save_on_each_node",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": typing.Optional[int] = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": typing.Optional[bool] = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": typing.Optional[str] = None"},{name:"tpu_num_cores",val:": typing.Optional[int] = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": typing.Union[str, typing.List[transformers.debug_utils.DebugOption]] = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": typing.Optional[float] = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": typing.Optional[str] = None"},{name:"disable_tqdm",val:": typing.Optional[bool] = None"},{name:"remove_unused_columns",val:": typing.Optional[bool] = True"},{name:"label_names",val:": typing.Optional[typing.List[str]] = None"},{name:"load_best_model_at_end",val:": typing.Optional[bool] = False"},{name:"metric_for_best_model",val:": typing.Optional[str] = None"},{name:"greater_is_better",val:": typing.Optional[bool] = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": typing.Union[typing.List[transformers.trainer_utils.FSDPOption], str, NoneType] = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": typing.Optional[str] = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": typing.Optional[str] = None"},{name:"deepspeed",val:": typing.Optional[str] = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": typing.Union[transformers.training_args.OptimizerNames, str] = 'adamw_torch'"},{name:"optim_args",val:": typing.Optional[str] = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": typing.Optional[str] = 'length'"},{name:"report_to",val:": typing.Optional[typing.List[str]] = None"},{name:"ddp_find_unused_parameters",val:": typing.Optional[bool] = None"},{name:"ddp_bucket_cap_mb",val:": typing.Optional[int] = None"},{name:"ddp_broadcast_buffers",val:": typing.Optional[bool] = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": typing.Optional[str] = None"},{name:"hub_model_id",val:": typing.Optional[str] = None"},{name:"hub_strategy",val:": typing.Union[transformers.trainer_utils.HubStrategy, str] = 'every_save'"},{name:"hub_token",val:": typing.Optional[str] = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": typing.Optional[bool] = True"},{name:"gradient_checkpointing_kwargs",val:": typing.Optional[dict] = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": typing.Optional[str] = None"},{name:"push_to_hub_organization",val:": typing.Optional[str] = None"},{name:"push_to_hub_token",val:": typing.Optional[str] = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": typing.Optional[str] = None"},{name:"ray_scope",val:": typing.Optional[str] = 'last'"},{name:"ddp_timeout",val:": typing.Optional[int] = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": typing.Optional[str] = None"},{name:"torch_compile_mode",val:": typing.Optional[str] = None"},{name:"dispatch_batches",val:": typing.Optional[bool] = None"},{name:"split_batches",val:": typing.Optional[bool] = False"},{name:"include_tokens_per_second",val:": typing.Optional[bool] = False"},{name:"include_num_input_tokens_seen",val:": typing.Optional[bool] = False"},{name:"neftune_noise_alpha",val:": float = None"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"trl.RewardConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.RewardConfig.gradient_checkpointing",description:`<strong>gradient_checkpointing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, use gradient checkpointing to save memory at the expense of slower backward pass.`,name:"gradient_checkpointing"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/training_configs.py#L23"}}),Pe=new k({props:{title:"RewardTrainer",local:"trl.RewardTrainer",headingTag:"h2"}}),$e=new v({props:{name:"class trl.RewardTrainer",anchor:"trl.RewardTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module] = None"},{name:"args",val:": typing.Optional[trl.trainer.training_configs.RewardConfig] = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalPrediction], typing.Dict], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"peft_config",val:": typing.Optional[typing.Dict] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/reward_trainer.py#L36"}}),Oe=new k({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),De=new v({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalPrediction], typing.Dict], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"peft_config",val:": typing.Optional[ForwardRef('PeftConfig')] = None"},{name:"dataset_text_field",val:": typing.Optional[str] = None"},{name:"packing",val:": typing.Optional[bool] = False"},{name:"formatting_func",val:": typing.Optional[typing.Callable] = None"},{name:"max_seq_length",val:": typing.Optional[int] = None"},{name:"infinite",val:": typing.Optional[bool] = False"},{name:"num_of_sequences",val:": typing.Optional[int] = 1024"},{name:"chars_per_token",val:": typing.Optional[float] = 3.6"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"model_init_kwargs",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to <code>compute_accuracy</code>) &#x2014;
The metrics to use for evaluation. If no metrics are specified, the default metric (<code>compute_accuracy</code>) will be used.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automaticallty creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTTrainer.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instrcution
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"neftune_noise_alpha"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/sft_trainer.py#L50"}}),we=new k({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),ke=new v({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"ref_model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str, NoneType] = None"},{name:"beta",val:": float = 0.1"},{name:"loss_type",val:": typing.Literal['sigmoid', 'hinge'] = 'sigmoid'"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_prompt_length",val:": typing.Optional[int] = None"},{name:"max_target_length",val:": typing.Optional[int] = None"},{name:"peft_config",val:": typing.Optional[typing.Dict] = None"},{name:"is_encoder_decoder",val:": typing.Optional[bool] = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], typing.Dict], NoneType] = None"},{name:"model_init_kwargs",val:": typing.Optional[typing.Dict] = None"},{name:"ref_model_init_kwargs",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy.`,name:"beta"},{anchor:"trl.DPOTrainer.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss or <code>&quot;hinge&quot;</code> loss from SLiC paper.`,name:"loss_type"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>transformers.TrainingArguments</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOTrainer.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value. This argument is required if you want to use the default data collator.`,name:"padding_value"},{anchor:"trl.DPOTrainer.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOTrainer.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOTrainer.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOTrainer.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L55"}}),Ce=new v({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L493"}}),Ne=new v({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L377",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),Le=new v({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_free",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L416",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Fe=new v({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": typing.Optional[bool] = None"},{name:"ignore_keys",val:": typing.Optional[typing.List[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L684"}}),ze=new v({props:{name:"get_batch_metrics",anchor:"trl.DPOTrainer.get_batch_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"},{name:"train_eval",val:": typing.Literal['train', 'eval'] = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L531"}}),Se=new v({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, torch.LongTensor]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L604"}}),qe=new v({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": typing.Dict[str, float]"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L734"}}),Ie=new k({props:{title:"DDPOConfig",local:"trl.DDPOConfig",headingTag:"h2"}}),Me=new v({props:{name:"class trl.DDPOConfig",anchor:"trl.DDPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"run_name",val:": typing.Optional[str] = ''"},{name:"seed",val:": int = 0"},{name:"log_with",val:": typing.Union[typing.Literal['wandb', 'tensorboard'], NoneType] = None"},{name:"tracker_kwargs",val:": dict = <factory>"},{name:"accelerator_kwargs",val:": dict = <factory>"},{name:"project_kwargs",val:": dict = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"logdir",val:": str = 'logs'"},{name:"num_epochs",val:": int = 100"},{name:"save_freq",val:": int = 1"},{name:"num_checkpoint_limit",val:": int = 5"},{name:"mixed_precision",val:": str = 'fp16'"},{name:"allow_tf32",val:": bool = True"},{name:"resume_from",val:": typing.Optional[str] = ''"},{name:"sample_num_steps",val:": int = 50"},{name:"sample_eta",val:": float = 1.0"},{name:"sample_guidance_scale",val:": float = 5.0"},{name:"sample_batch_size",val:": int = 1"},{name:"sample_num_batches_per_epoch",val:": int = 2"},{name:"train_batch_size",val:": int = 1"},{name:"train_use_8bit_adam",val:": bool = False"},{name:"train_learning_rate",val:": float = 0.0003"},{name:"train_adam_beta1",val:": float = 0.9"},{name:"train_adam_beta2",val:": float = 0.999"},{name:"train_adam_weight_decay",val:": float = 0.0001"},{name:"train_adam_epsilon",val:": float = 1e-08"},{name:"train_gradient_accumulation_steps",val:": int = 1"},{name:"train_max_grad_norm",val:": float = 1.0"},{name:"train_num_inner_epochs",val:": int = 1"},{name:"train_cfg",val:": bool = True"},{name:"train_adv_clip_max",val:": float = 5"},{name:"train_clip_range",val:": float = 0.0001"},{name:"train_timestep_fraction",val:": float = 1.0"},{name:"per_prompt_stat_tracking",val:": bool = False"},{name:"per_prompt_stat_tracking_buffer_size",val:": int = 16"},{name:"per_prompt_stat_tracking_min_count",val:": int = 16"},{name:"async_reward_computation",val:": bool = False"},{name:"max_workers",val:": int = 2"},{name:"negative_prompts",val:": typing.Optional[str] = ''"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_config.py#L12"}}),Ae=new k({props:{title:"DDPOTrainer",local:"trl.DDPOTrainer",headingTag:"h2"}}),Ee=new v({props:{name:"class trl.DDPOTrainer",anchor:"trl.DDPOTrainer",parameters:[{name:"config",val:": DDPOConfig"},{name:"reward_function",val:": typing.Callable[[torch.Tensor, typing.Tuple[str], typing.Tuple[typing.Any]], torch.Tensor]"},{name:"prompt_function",val:": typing.Callable[[], typing.Tuple[str, typing.Any]]"},{name:"sd_pipeline",val:": DDPOStableDiffusionPipeline"},{name:"image_samples_hook",val:": typing.Union[typing.Callable[[typing.Any, typing.Any, typing.Any], typing.Any], NoneType] = None"}],parametersDescription:[{anchor:"trl.DDPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>DDPOConfig</code>) &#x2014; Configuration object for DDPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.DDPOTrainer.*reward_function**",description:"*<strong>*reward_function**</strong> (Callable[[torch.Tensor, Tuple[str], Tuple[Any]], torch.Tensor]) &#x2014; Reward function to be used &#x2014;",name:"*reward_function**"},{anchor:"trl.DDPOTrainer.*prompt_function**",description:"*<strong>*prompt_function**</strong> (Callable[[], Tuple[str, Any]]) &#x2014; Function to generate prompts to guide model &#x2014;",name:"*prompt_function**"},{anchor:"trl.DDPOTrainer.*sd_pipeline**",description:"*<strong>*sd_pipeline**</strong> (<code>DDPOStableDiffusionPipeline</code>) &#x2014; Stable Diffusion pipeline to be used for training. &#x2014;",name:"*sd_pipeline**"},{anchor:"trl.DDPOTrainer.*image_samples_hook**",description:"*<strong>*image_samples_hook**</strong> (Optional[Callable[[Any, Any, Any], Any]]) &#x2014; Hook to be called to log images &#x2014;",name:"*image_samples_hook**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L34"}}),Ue=new v({props:{name:"calculate_loss",anchor:"trl.DDPOTrainer.calculate_loss",parameters:[{name:"latents",val:""},{name:"timesteps",val:""},{name:"next_latents",val:""},{name:"log_probs",val:""},{name:"advantages",val:""},{name:"embeds",val:""}],parametersDescription:[{anchor:"trl.DDPOTrainer.calculate_loss.latents",description:`<strong>latents</strong> (torch.Tensor) &#x2014;
The latents sampled from the diffusion model, shape: [batch_size, num_steps, &#x2026;]`,name:"latents"},{anchor:"trl.DDPOTrainer.calculate_loss.timesteps",description:`<strong>timesteps</strong> (torch.Tensor) &#x2014;
The timesteps sampled from the diffusion model, shape: [batch_size]`,name:"timesteps"},{anchor:"trl.DDPOTrainer.calculate_loss.next_latents",description:`<strong>next_latents</strong> (torch.Tensor) &#x2014;
The next latents sampled from the diffusion model, shape: [batch_size, num_steps, &#x2026;]`,name:"next_latents"},{anchor:"trl.DDPOTrainer.calculate_loss.log_probs",description:`<strong>log_probs</strong> (torch.Tensor) &#x2014;
The log probabilities of the latents, shape: [batch_size]`,name:"log_probs"},{anchor:"trl.DDPOTrainer.calculate_loss.advantages",description:`<strong>advantages</strong> (torch.Tensor) &#x2014;
The advantages of the latents, shape: [batch_size]`,name:"advantages"},{anchor:"trl.DDPOTrainer.calculate_loss.embeds",description:`<strong>embeds</strong> (torch.Tensor) &#x2014;
The embeddings of the prompts, shape: [2*batch_size or batch_size, &#x2026;]
Note: the &#x201C;or&#x201D; is because if train_cfg is True, the expectation is that negative prompts are concatenated to the embeds`,name:"embeds"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L311",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>loss (torch.Tensor), approx_kl (torch.Tensor), clipfrac (torch.Tensor)
(all of these are of shape (1,))</p>
`}}),He=new v({props:{name:"step",anchor:"trl.DDPOTrainer.step",parameters:[{name:"epoch",val:": int"},{name:"global_step",val:": int"}],parametersDescription:[{anchor:"trl.DDPOTrainer.step.epoch",description:"<strong>epoch</strong> (int) &#x2014; The current epoch.",name:"epoch"},{anchor:"trl.DDPOTrainer.step.global_step",description:"<strong>global_step</strong> (int) &#x2014; The current global step.",name:"global_step"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L205",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The updated global step.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>global_step (int)</p>
`}}),Re=new v({props:{name:"train",anchor:"trl.DDPOTrainer.train",parameters:[{name:"epochs",val:": typing.Optional[int] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L565"}}),Ve=new k({props:{title:"IterativeSFTTrainer",local:"trl.IterativeSFTTrainer",headingTag:"h2"}}),je=new v({props:{name:"class trl.IterativeSFTTrainer",anchor:"trl.IterativeSFTTrainer",parameters:[{name:"model",val:": PreTrainedModel = None"},{name:"args",val:": TrainingArguments = None"},{name:"tokenizer",val:": PreTrainedTokenizerBase = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"truncation_mode",val:": typing.Optional[str] = 'keep_end'"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], typing.Dict], NoneType] = None"},{name:"optimize_device_cache",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModel</code>) &#x2014; Model to be optimized, either an &#x2018;AutoModelForCausalLM&#x2019; or an &#x2018;AutoModelForSeq2SeqLM&#x2019;. &#x2014;
Check the documentation of <code>PreTrainedModel</code> for more details.`,name:"*model**"},{anchor:"trl.IterativeSFTTrainer.*args**",description:"*<strong>*args**</strong> (<code>transformers.TrainingArguments</code>) &#x2014; &#x2014; The arguments to use for training.",name:"*args**"},{anchor:"trl.IterativeSFTTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.IterativeSFTTrainer.*optimizers**",description:"*<strong>*optimizers**</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014; &#x2014; The optimizer and scheduler to use for training.",name:"*optimizers**"},{anchor:"trl.IterativeSFTTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (Union[DataCollatorForLanguageModeling, DataCollatorForSeq2Seq], <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader.`,name:"*data_collator**"},{anchor:"trl.IterativeSFTTrainer.*eval_dataset**",description:"*<strong>*eval_dataset**</strong> (<code>datasets.Dataset</code>) &#x2014; The dataset to use for evaluation.",name:"*eval_dataset**"},{anchor:"trl.IterativeSFTTrainer.*max_length**",description:"*<strong>*max_length**</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014; &#x2014; The maximum length of the input.",name:"*max_length**"},{anchor:"trl.IterativeSFTTrainer.*truncation_mode**",description:"*<strong>*truncation_mode**</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014; &#x2014; The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>.",name:"*truncation_mode**"},{anchor:"trl.IterativeSFTTrainer.*preprocess_logits_for_metrics**",description:"*<strong>*preprocess_logits_for_metrics**</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014; &#x2014; The function to use to preprocess the logits before computing the metrics.",name:"*preprocess_logits_for_metrics**"},{anchor:"trl.IterativeSFTTrainer.*compute_metrics**",description:"*<strong>*compute_metrics**</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014; &#x2014; The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return a dictionary string to metric values.",name:"*compute_metrics**"},{anchor:"trl.IterativeSFTTrainer.*optimize_device_cache",description:"*<strong>*optimize_device_cache</strong> *<em> (<code>bool</code>, </em>optional*, defaults to <code>False</code>) &#x2014; Optimize CUDA cache for slightly more memory-efficient training. &#x2014;",name:"*optimize_device_cache"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/iterative_sft_trainer.py#L39"}}),We=new v({props:{name:"step",anchor:"trl.IterativeSFTTrainer.step",parameters:[{name:"input_ids",val:": typing.Optional[typing.List[torch.LongTensor]] = None"},{name:"attention_mask",val:": typing.Optional[typing.List[torch.LongTensor]] = None"},{name:"labels",val:": typing.Optional[typing.List[torch.LongTensor]] = None"},{name:"texts",val:": typing.Optional[typing.List[str]] = None"},{name:"texts_labels",val:": typing.Optional[typing.List[str]] = None"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.step.input_ids",description:`<strong>input_ids</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the input_ids (if not provided, text will be used)`,name:"input_ids"},{anchor:"trl.IterativeSFTTrainer.step.attention_mask",description:`<strong>attention_mask</strong> (List<code>torch.LongTensor</code>, , <em>optional</em>) &#x2014;
List of tensors containing the attention_mask`,name:"attention_mask"},{anchor:"trl.IterativeSFTTrainer.step.labels",description:`<strong>labels</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of tensors containing the labels (if set to None, will default to input_ids)`,name:"labels"},{anchor:"trl.IterativeSFTTrainer.step.texts",description:`<strong>texts</strong> (List<code>str</code>, <em>optional</em>) &#x2014;
List of strings containing the text input (if not provided, input_ids will directly be used)`,name:"texts"},{anchor:"trl.IterativeSFTTrainer.step.texts_labels",description:`<strong>texts_labels</strong> (List<code>str</code>, <em>optional</em>) &#x2014;
List of strings containing the text labels (if set to None, will default to text)`,name:"texts_labels"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/iterative_sft_trainer.py#L229",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Be=new k({props:{title:"set_seed",local:"trl.set_seed",headingTag:"h2"}}),Je=new v({props:{name:"trl.set_seed",anchor:"trl.set_seed",parameters:[{name:"seed",val:": int"}],parametersDescription:[{anchor:"trl.set_seed.seed",description:"<strong>seed</strong> (<code>int</code>) &#x2014; The seed to set.",name:"seed"}],source:"https://github.com/huggingface/trl/blob/main/trl/core.py#L236"}}),{c(){z=r("meta"),Ut=n(),At=r("p"),Ht=n(),l(re.$$.fragment),Rt=n(),oe=r("p"),oe.innerHTML=ja,Vt=n(),l(ie.$$.fragment),jt=n(),S=r("div"),l(se.$$.fragment),qn=n(),Ke=r("p"),Ke.textContent=Wa,Wt=n(),l(le.$$.fragment),Bt=n(),b=r("div"),l(de.$$.fragment),In=n(),Ge=r("p"),Ge.innerHTML=Ba,Mn=n(),A=r("div"),l(ce.$$.fragment),An=n(),Ye=r("p"),Ye.textContent=Ja,En=n(),E=r("div"),l(pe.$$.fragment),Un=n(),Ze=r("p"),Ze.textContent=Ka,Hn=n(),U=r("div"),l(me.$$.fragment),Rn=n(),Qe=r("p"),Qe.textContent=Ga,Vn=n(),H=r("div"),l(ge.$$.fragment),jn=n(),Xe=r("p"),Xe.textContent=Ya,Wn=n(),R=r("div"),l(he.$$.fragment),Bn=n(),et=r("p"),et.innerHTML=Za,Jn=n(),V=r("div"),l(_e.$$.fragment),Kn=n(),tt=r("p"),tt.textContent=Qa,Gn=n(),j=r("div"),l(ue.$$.fragment),Yn=n(),nt=r("p"),nt.textContent=Xa,Zn=n(),W=r("div"),l(fe.$$.fragment),Qn=n(),at=r("p"),at.textContent=er,Xn=n(),B=r("div"),l(ve.$$.fragment),ea=n(),rt=r("p"),rt.textContent=tr,ta=n(),J=r("div"),l(be.$$.fragment),na=n(),ot=r("p"),ot.textContent=nr,aa=n(),K=r("div"),l(Te.$$.fragment),ra=n(),it=r("p"),it.textContent=ar,Jt=n(),l(ye.$$.fragment),Kt=n(),D=r("div"),l(xe.$$.fragment),oa=n(),st=r("p"),st.innerHTML=rr,ia=n(),lt=r("p"),lt.innerHTML=or,Gt=n(),l(Pe.$$.fragment),Yt=n(),P=r("div"),l($e.$$.fragment),sa=n(),dt=r("p"),dt.innerHTML=ir,la=n(),ct=r("p"),ct.innerHTML=sr,da=n(),pt=r("ul"),pt.innerHTML=lr,ca=n(),mt=r("p"),mt.innerHTML=dr,Zt=n(),l(Oe.$$.fragment),Qt=n(),q=r("div"),l(De.$$.fragment),pa=n(),gt=r("p"),gt.innerHTML=cr,Xt=n(),l(we.$$.fragment),en=n(),y=r("div"),l(ke.$$.fragment),ma=n(),ht=r("p"),ht.textContent=pr,ga=n(),C=r("div"),l(Ce.$$.fragment),ha=n(),_t=r("p"),_t.textContent=mr,_a=n(),ut=r("p"),ut.textContent=gr,ua=n(),G=r("div"),l(Ne.$$.fragment),fa=n(),ft=r("p"),ft.textContent=hr,va=n(),Y=r("div"),l(Le.$$.fragment),ba=n(),vt=r("p"),vt.textContent=_r,Ta=n(),N=r("div"),l(Fe.$$.fragment),ya=n(),bt=r("p"),bt.innerHTML=ur,xa=n(),Tt=r("p"),Tt.textContent=fr,Pa=n(),Z=r("div"),l(ze.$$.fragment),$a=n(),yt=r("p"),yt.textContent=vr,Oa=n(),Q=r("div"),l(Se.$$.fragment),Da=n(),xt=r("p"),xt.textContent=br,wa=n(),X=r("div"),l(qe.$$.fragment),ka=n(),Pt=r("p"),Pt.innerHTML=Tr,tn=n(),l(Ie.$$.fragment),nn=n(),I=r("div"),l(Me.$$.fragment),Ca=n(),$t=r("p"),$t.textContent=yr,an=n(),l(Ae.$$.fragment),rn=n(),$=r("div"),l(Ee.$$.fragment),Na=n(),Ot=r("p"),Ot.innerHTML=xr,La=n(),ee=r("div"),l(Ue.$$.fragment),Fa=n(),Dt=r("p"),Dt.textContent=Pr,za=n(),O=r("div"),l(He.$$.fragment),Sa=n(),wt=r("p"),wt.textContent=$r,qa=n(),kt=r("p"),kt.textContent=Or,Ia=n(),Ct=r("ul"),Ct.innerHTML=Dr,Ma=n(),te=r("div"),l(Re.$$.fragment),Aa=n(),Nt=r("p"),Nt.textContent=wr,on=n(),l(Ve.$$.fragment),sn=n(),w=r("div"),l(je.$$.fragment),Ea=n(),Lt=r("p"),Lt.textContent=kr,Ua=n(),ne=r("div"),l(We.$$.fragment),Ha=n(),Ft=r("p"),Ft.textContent=Cr,ln=n(),l(Be.$$.fragment),dn=n(),M=r("div"),l(Je.$$.fragment),Ra=n(),zt=r("p"),zt.innerHTML=Nr,cn=n(),Et=r("p"),this.h()},l(e){const s=Ir("svelte-u9bgzb",document.head);z=o(s,"META",{name:!0,content:!0}),s.forEach(i),Ut=a(e),At=o(e,"P",{}),u(At).forEach(i),Ht=a(e),d(re.$$.fragment,e),Rt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),h(oe)!=="svelte-dxrcnp"&&(oe.innerHTML=ja),Vt=a(e),d(ie.$$.fragment,e),jt=a(e),S=o(e,"DIV",{class:!0});var mn=u(S);d(se.$$.fragment,mn),qn=a(mn),Ke=o(mn,"P",{"data-svelte-h":!0}),h(Ke)!=="svelte-aondqr"&&(Ke.textContent=Wa),mn.forEach(i),Wt=a(e),d(le.$$.fragment,e),Bt=a(e),b=o(e,"DIV",{class:!0});var T=u(b);d(de.$$.fragment,T),In=a(T),Ge=o(T,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-hys9rl"&&(Ge.innerHTML=Ba),Mn=a(T),A=o(T,"DIV",{class:!0});var gn=u(A);d(ce.$$.fragment,gn),An=a(gn),Ye=o(gn,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-185nst0"&&(Ye.textContent=Ja),gn.forEach(i),En=a(T),E=o(T,"DIV",{class:!0});var hn=u(E);d(pe.$$.fragment,hn),Un=a(hn),Ze=o(hn,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-3nt516"&&(Ze.textContent=Ka),hn.forEach(i),Hn=a(T),U=o(T,"DIV",{class:!0});var _n=u(U);d(me.$$.fragment,_n),Rn=a(_n),Qe=o(_n,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-3jfrz9"&&(Qe.textContent=Ga),_n.forEach(i),Vn=a(T),H=o(T,"DIV",{class:!0});var un=u(H);d(ge.$$.fragment,un),jn=a(un),Xe=o(un,"P",{"data-svelte-h":!0}),h(Xe)!=="svelte-lcc1u3"&&(Xe.textContent=Ya),un.forEach(i),Wn=a(T),R=o(T,"DIV",{class:!0});var fn=u(R);d(he.$$.fragment,fn),Bn=a(fn),et=o(fn,"P",{"data-svelte-h":!0}),h(et)!=="svelte-1gqqzmu"&&(et.innerHTML=Za),fn.forEach(i),Jn=a(T),V=o(T,"DIV",{class:!0});var vn=u(V);d(_e.$$.fragment,vn),Kn=a(vn),tt=o(vn,"P",{"data-svelte-h":!0}),h(tt)!=="svelte-ffqz5"&&(tt.textContent=Qa),vn.forEach(i),Gn=a(T),j=o(T,"DIV",{class:!0});var bn=u(j);d(ue.$$.fragment,bn),Yn=a(bn),nt=o(bn,"P",{"data-svelte-h":!0}),h(nt)!=="svelte-febvhf"&&(nt.textContent=Xa),bn.forEach(i),Zn=a(T),W=o(T,"DIV",{class:!0});var Tn=u(W);d(fe.$$.fragment,Tn),Qn=a(Tn),at=o(Tn,"P",{"data-svelte-h":!0}),h(at)!=="svelte-1hbodkw"&&(at.textContent=er),Tn.forEach(i),Xn=a(T),B=o(T,"DIV",{class:!0});var yn=u(B);d(ve.$$.fragment,yn),ea=a(yn),rt=o(yn,"P",{"data-svelte-h":!0}),h(rt)!=="svelte-1hfgx92"&&(rt.textContent=tr),yn.forEach(i),ta=a(T),J=o(T,"DIV",{class:!0});var xn=u(J);d(be.$$.fragment,xn),na=a(xn),ot=o(xn,"P",{"data-svelte-h":!0}),h(ot)!=="svelte-yrsdu6"&&(ot.textContent=nr),xn.forEach(i),aa=a(T),K=o(T,"DIV",{class:!0});var Pn=u(K);d(Te.$$.fragment,Pn),ra=a(Pn),it=o(Pn,"P",{"data-svelte-h":!0}),h(it)!=="svelte-3k7k5e"&&(it.textContent=ar),Pn.forEach(i),T.forEach(i),Jt=a(e),d(ye.$$.fragment,e),Kt=a(e),D=o(e,"DIV",{class:!0});var St=u(D);d(xe.$$.fragment,St),oa=a(St),st=o(St,"P",{"data-svelte-h":!0}),h(st)!=="svelte-1alpag9"&&(st.innerHTML=rr),ia=a(St),lt=o(St,"P",{"data-svelte-h":!0}),h(lt)!=="svelte-1xl7jqc"&&(lt.innerHTML=or),St.forEach(i),Gt=a(e),d(Pe.$$.fragment,e),Yt=a(e),P=o(e,"DIV",{class:!0});var L=u(P);d($e.$$.fragment,L),sa=a(L),dt=o(L,"P",{"data-svelte-h":!0}),h(dt)!=="svelte-qafafj"&&(dt.innerHTML=ir),la=a(L),ct=o(L,"P",{"data-svelte-h":!0}),h(ct)!=="svelte-bkmbwh"&&(ct.innerHTML=sr),da=a(L),pt=o(L,"UL",{"data-svelte-h":!0}),h(pt)!=="svelte-1ytuxgw"&&(pt.innerHTML=lr),ca=a(L),mt=o(L,"P",{"data-svelte-h":!0}),h(mt)!=="svelte-18tbp4c"&&(mt.innerHTML=dr),L.forEach(i),Zt=a(e),d(Oe.$$.fragment,e),Qt=a(e),q=o(e,"DIV",{class:!0});var $n=u(q);d(De.$$.fragment,$n),pa=a($n),gt=o($n,"P",{"data-svelte-h":!0}),h(gt)!=="svelte-14oyph8"&&(gt.innerHTML=cr),$n.forEach(i),Xt=a(e),d(we.$$.fragment,e),en=a(e),y=o(e,"DIV",{class:!0});var x=u(y);d(ke.$$.fragment,x),ma=a(x),ht=o(x,"P",{"data-svelte-h":!0}),h(ht)!=="svelte-n6cc8y"&&(ht.textContent=pr),ga=a(x),C=o(x,"DIV",{class:!0});var qt=u(C);d(Ce.$$.fragment,qt),ha=a(qt),_t=o(qt,"P",{"data-svelte-h":!0}),h(_t)!=="svelte-16i1nac"&&(_t.textContent=mr),_a=a(qt),ut=o(qt,"P",{"data-svelte-h":!0}),h(ut)!=="svelte-tgti68"&&(ut.textContent=gr),qt.forEach(i),ua=a(x),G=o(x,"DIV",{class:!0});var On=u(G);d(Ne.$$.fragment,On),fa=a(On),ft=o(On,"P",{"data-svelte-h":!0}),h(ft)!=="svelte-1cvsgkk"&&(ft.textContent=hr),On.forEach(i),va=a(x),Y=o(x,"DIV",{class:!0});var Dn=u(Y);d(Le.$$.fragment,Dn),ba=a(Dn),vt=o(Dn,"P",{"data-svelte-h":!0}),h(vt)!=="svelte-ymgxq7"&&(vt.textContent=_r),Dn.forEach(i),Ta=a(x),N=o(x,"DIV",{class:!0});var It=u(N);d(Fe.$$.fragment,It),ya=a(It),bt=o(It,"P",{"data-svelte-h":!0}),h(bt)!=="svelte-8qlty5"&&(bt.innerHTML=ur),xa=a(It),Tt=o(It,"P",{"data-svelte-h":!0}),h(Tt)!=="svelte-1tyo99t"&&(Tt.textContent=fr),It.forEach(i),Pa=a(x),Z=o(x,"DIV",{class:!0});var wn=u(Z);d(ze.$$.fragment,wn),$a=a(wn),yt=o(wn,"P",{"data-svelte-h":!0}),h(yt)!=="svelte-11q8u7l"&&(yt.textContent=vr),wn.forEach(i),Oa=a(x),Q=o(x,"DIV",{class:!0});var kn=u(Q);d(Se.$$.fragment,kn),Da=a(kn),xt=o(kn,"P",{"data-svelte-h":!0}),h(xt)!=="svelte-18uwvbi"&&(xt.textContent=br),kn.forEach(i),wa=a(x),X=o(x,"DIV",{class:!0});var Cn=u(X);d(qe.$$.fragment,Cn),ka=a(Cn),Pt=o(Cn,"P",{"data-svelte-h":!0}),h(Pt)!=="svelte-nqksfz"&&(Pt.innerHTML=Tr),Cn.forEach(i),x.forEach(i),tn=a(e),d(Ie.$$.fragment,e),nn=a(e),I=o(e,"DIV",{class:!0});var Nn=u(I);d(Me.$$.fragment,Nn),Ca=a(Nn),$t=o(Nn,"P",{"data-svelte-h":!0}),h($t)!=="svelte-2zpx1f"&&($t.textContent=yr),Nn.forEach(i),an=a(e),d(Ae.$$.fragment,e),rn=a(e),$=o(e,"DIV",{class:!0});var F=u($);d(Ee.$$.fragment,F),Na=a(F),Ot=o(F,"P",{"data-svelte-h":!0}),h(Ot)!=="svelte-8q861t"&&(Ot.innerHTML=xr),La=a(F),ee=o(F,"DIV",{class:!0});var Ln=u(ee);d(Ue.$$.fragment,Ln),Fa=a(Ln),Dt=o(Ln,"P",{"data-svelte-h":!0}),h(Dt)!=="svelte-1ag17u3"&&(Dt.textContent=Pr),Ln.forEach(i),za=a(F),O=o(F,"DIV",{class:!0});var ae=u(O);d(He.$$.fragment,ae),Sa=a(ae),wt=o(ae,"P",{"data-svelte-h":!0}),h(wt)!=="svelte-r6y15n"&&(wt.textContent=$r),qa=a(ae),kt=o(ae,"P",{"data-svelte-h":!0}),h(kt)!=="svelte-imqqfp"&&(kt.textContent=Or),Ia=a(ae),Ct=o(ae,"UL",{"data-svelte-h":!0}),h(Ct)!=="svelte-105j238"&&(Ct.innerHTML=Dr),ae.forEach(i),Ma=a(F),te=o(F,"DIV",{class:!0});var Fn=u(te);d(Re.$$.fragment,Fn),Aa=a(Fn),Nt=o(Fn,"P",{"data-svelte-h":!0}),h(Nt)!=="svelte-1an944l"&&(Nt.textContent=wr),Fn.forEach(i),F.forEach(i),on=a(e),d(Ve.$$.fragment,e),sn=a(e),w=o(e,"DIV",{class:!0});var Mt=u(w);d(je.$$.fragment,Mt),Ea=a(Mt),Lt=o(Mt,"P",{"data-svelte-h":!0}),h(Lt)!=="svelte-xqyw6w"&&(Lt.textContent=kr),Ua=a(Mt),ne=o(Mt,"DIV",{class:!0});var zn=u(ne);d(We.$$.fragment,zn),Ha=a(zn),Ft=o(zn,"P",{"data-svelte-h":!0}),h(Ft)!=="svelte-v7dhdf"&&(Ft.textContent=Cr),zn.forEach(i),Mt.forEach(i),ln=a(e),d(Be.$$.fragment,e),dn=a(e),M=o(e,"DIV",{class:!0});var Sn=u(M);d(Je.$$.fragment,Sn),Ra=a(Sn),zt=o(Sn,"P",{"data-svelte-h":!0}),h(zt)!=="svelte-1aeuhep"&&(zt.innerHTML=Nr),Sn.forEach(i),cn=a(e),Et=o(e,"P",{}),u(Et).forEach(i),this.h()},h(){f(z,"name","hf:doc:metadata"),f(z,"content",Ar),f(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),f(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){t(document.head,z),_(e,Ut,s),_(e,At,s),_(e,Ht,s),c(re,e,s),_(e,Rt,s),_(e,oe,s),_(e,Vt,s),c(ie,e,s),_(e,jt,s),_(e,S,s),c(se,S,null),t(S,qn),t(S,Ke),_(e,Wt,s),c(le,e,s),_(e,Bt,s),_(e,b,s),c(de,b,null),t(b,In),t(b,Ge),t(b,Mn),t(b,A),c(ce,A,null),t(A,An),t(A,Ye),t(b,En),t(b,E),c(pe,E,null),t(E,Un),t(E,Ze),t(b,Hn),t(b,U),c(me,U,null),t(U,Rn),t(U,Qe),t(b,Vn),t(b,H),c(ge,H,null),t(H,jn),t(H,Xe),t(b,Wn),t(b,R),c(he,R,null),t(R,Bn),t(R,et),t(b,Jn),t(b,V),c(_e,V,null),t(V,Kn),t(V,tt),t(b,Gn),t(b,j),c(ue,j,null),t(j,Yn),t(j,nt),t(b,Zn),t(b,W),c(fe,W,null),t(W,Qn),t(W,at),t(b,Xn),t(b,B),c(ve,B,null),t(B,ea),t(B,rt),t(b,ta),t(b,J),c(be,J,null),t(J,na),t(J,ot),t(b,aa),t(b,K),c(Te,K,null),t(K,ra),t(K,it),_(e,Jt,s),c(ye,e,s),_(e,Kt,s),_(e,D,s),c(xe,D,null),t(D,oa),t(D,st),t(D,ia),t(D,lt),_(e,Gt,s),c(Pe,e,s),_(e,Yt,s),_(e,P,s),c($e,P,null),t(P,sa),t(P,dt),t(P,la),t(P,ct),t(P,da),t(P,pt),t(P,ca),t(P,mt),_(e,Zt,s),c(Oe,e,s),_(e,Qt,s),_(e,q,s),c(De,q,null),t(q,pa),t(q,gt),_(e,Xt,s),c(we,e,s),_(e,en,s),_(e,y,s),c(ke,y,null),t(y,ma),t(y,ht),t(y,ga),t(y,C),c(Ce,C,null),t(C,ha),t(C,_t),t(C,_a),t(C,ut),t(y,ua),t(y,G),c(Ne,G,null),t(G,fa),t(G,ft),t(y,va),t(y,Y),c(Le,Y,null),t(Y,ba),t(Y,vt),t(y,Ta),t(y,N),c(Fe,N,null),t(N,ya),t(N,bt),t(N,xa),t(N,Tt),t(y,Pa),t(y,Z),c(ze,Z,null),t(Z,$a),t(Z,yt),t(y,Oa),t(y,Q),c(Se,Q,null),t(Q,Da),t(Q,xt),t(y,wa),t(y,X),c(qe,X,null),t(X,ka),t(X,Pt),_(e,tn,s),c(Ie,e,s),_(e,nn,s),_(e,I,s),c(Me,I,null),t(I,Ca),t(I,$t),_(e,an,s),c(Ae,e,s),_(e,rn,s),_(e,$,s),c(Ee,$,null),t($,Na),t($,Ot),t($,La),t($,ee),c(Ue,ee,null),t(ee,Fa),t(ee,Dt),t($,za),t($,O),c(He,O,null),t(O,Sa),t(O,wt),t(O,qa),t(O,kt),t(O,Ia),t(O,Ct),t($,Ma),t($,te),c(Re,te,null),t(te,Aa),t(te,Nt),_(e,on,s),c(Ve,e,s),_(e,sn,s),_(e,w,s),c(je,w,null),t(w,Ea),t(w,Lt),t(w,Ua),t(w,ne),c(We,ne,null),t(ne,Ha),t(ne,Ft),_(e,ln,s),c(Be,e,s),_(e,dn,s),_(e,M,s),c(Je,M,null),t(M,Ra),t(M,zt),_(e,cn,s),_(e,Et,s),pn=!0},p:Fr,i(e){pn||(p(re.$$.fragment,e),p(ie.$$.fragment,e),p(se.$$.fragment,e),p(le.$$.fragment,e),p(de.$$.fragment,e),p(ce.$$.fragment,e),p(pe.$$.fragment,e),p(me.$$.fragment,e),p(ge.$$.fragment,e),p(he.$$.fragment,e),p(_e.$$.fragment,e),p(ue.$$.fragment,e),p(fe.$$.fragment,e),p(ve.$$.fragment,e),p(be.$$.fragment,e),p(Te.$$.fragment,e),p(ye.$$.fragment,e),p(xe.$$.fragment,e),p(Pe.$$.fragment,e),p($e.$$.fragment,e),p(Oe.$$.fragment,e),p(De.$$.fragment,e),p(we.$$.fragment,e),p(ke.$$.fragment,e),p(Ce.$$.fragment,e),p(Ne.$$.fragment,e),p(Le.$$.fragment,e),p(Fe.$$.fragment,e),p(ze.$$.fragment,e),p(Se.$$.fragment,e),p(qe.$$.fragment,e),p(Ie.$$.fragment,e),p(Me.$$.fragment,e),p(Ae.$$.fragment,e),p(Ee.$$.fragment,e),p(Ue.$$.fragment,e),p(He.$$.fragment,e),p(Re.$$.fragment,e),p(Ve.$$.fragment,e),p(je.$$.fragment,e),p(We.$$.fragment,e),p(Be.$$.fragment,e),p(Je.$$.fragment,e),pn=!0)},o(e){m(re.$$.fragment,e),m(ie.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(de.$$.fragment,e),m(ce.$$.fragment,e),m(pe.$$.fragment,e),m(me.$$.fragment,e),m(ge.$$.fragment,e),m(he.$$.fragment,e),m(_e.$$.fragment,e),m(ue.$$.fragment,e),m(fe.$$.fragment,e),m(ve.$$.fragment,e),m(be.$$.fragment,e),m(Te.$$.fragment,e),m(ye.$$.fragment,e),m(xe.$$.fragment,e),m(Pe.$$.fragment,e),m($e.$$.fragment,e),m(Oe.$$.fragment,e),m(De.$$.fragment,e),m(we.$$.fragment,e),m(ke.$$.fragment,e),m(Ce.$$.fragment,e),m(Ne.$$.fragment,e),m(Le.$$.fragment,e),m(Fe.$$.fragment,e),m(ze.$$.fragment,e),m(Se.$$.fragment,e),m(qe.$$.fragment,e),m(Ie.$$.fragment,e),m(Me.$$.fragment,e),m(Ae.$$.fragment,e),m(Ee.$$.fragment,e),m(Ue.$$.fragment,e),m(He.$$.fragment,e),m(Re.$$.fragment,e),m(Ve.$$.fragment,e),m(je.$$.fragment,e),m(We.$$.fragment,e),m(Be.$$.fragment,e),m(Je.$$.fragment,e),pn=!1},d(e){e&&(i(Ut),i(At),i(Ht),i(Rt),i(oe),i(Vt),i(jt),i(S),i(Wt),i(Bt),i(b),i(Jt),i(Kt),i(D),i(Gt),i(Yt),i(P),i(Zt),i(Qt),i(q),i(Xt),i(en),i(y),i(tn),i(nn),i(I),i(an),i(rn),i($),i(on),i(sn),i(w),i(ln),i(dn),i(M),i(cn),i(Et)),i(z),g(re,e),g(ie,e),g(se),g(le,e),g(de),g(ce),g(pe),g(me),g(ge),g(he),g(_e),g(ue),g(fe),g(ve),g(be),g(Te),g(ye,e),g(xe),g(Pe,e),g($e),g(Oe,e),g(De),g(we,e),g(ke),g(Ce),g(Ne),g(Le),g(Fe),g(ze),g(Se),g(qe),g(Ie,e),g(Me),g(Ae,e),g(Ee),g(Ue),g(He),g(Re),g(Ve,e),g(je),g(We),g(Be,e),g(Je)}}}const Ar='{"title":"Trainer","local":"trainer","sections":[{"title":"PPOConfig","local":"trl.PPOConfig","sections":[],"depth":2},{"title":"PPOTrainer","local":"trl.PPOTrainer","sections":[],"depth":2},{"title":"RewardConfig","local":"trl.RewardConfig","sections":[],"depth":2},{"title":"RewardTrainer","local":"trl.RewardTrainer","sections":[],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"DDPOConfig","local":"trl.DDPOConfig","sections":[],"depth":2},{"title":"DDPOTrainer","local":"trl.DDPOTrainer","sections":[],"depth":2},{"title":"IterativeSFTTrainer","local":"trl.IterativeSFTTrainer","sections":[],"depth":2},{"title":"set_seed","local":"trl.set_seed","sections":[],"depth":2}],"depth":1}';function Er(Va){return zr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jr extends Sr{constructor(z){super(),qr(this,z,Er,Mr,Lr,{})}}export{jr as component};
