import{s as nt,o as ot,n as Ge}from"../chunks/scheduler.6062bdaf.js";import{S as st,i as lt,g as r,s as o,r as m,A as it,h as c,f as t,c as s,j as x,u as g,x as M,k as J,y as a,a as p,v as u,d as f,t as _,w as b}from"../chunks/index.4bca734e.js";import{T as tt}from"../chunks/Tip.b9ac1f03.js";import{D as k}from"../chunks/Docstring.ed07512f.js";import{C as Za}from"../chunks/CodeBlock.fa01571c.js";import{E as Wa}from"../chunks/ExampleCodeBlock.823fb173.js";import{H as Ne}from"../chunks/Heading.723dceba.js";function rt($){let n,y="Example:",d,h,v;return h=new Za({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-comment"># Inherit from ModelHubMixin</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCustomModel</span>(
<span class="hljs-meta">... </span>        ModelHubMixin,
<span class="hljs-meta">... </span>        library_name=<span class="hljs-string">&quot;my-library&quot;</span>,
<span class="hljs-meta">... </span>        tags=[<span class="hljs-string">&quot;x-custom-tag&quot;</span>],
<span class="hljs-meta">... </span>        repo_url=<span class="hljs-string">&quot;https://github.com/huggingface/my-cool-library&quot;</span>,
<span class="hljs-meta">... </span>        docs_url=<span class="hljs-string">&quot;https://huggingface.co/docs/my-cool-library&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># ^ optional metadata to generate model card</span>
<span class="hljs-meta">... </span>    ):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, size: <span class="hljs-built_in">int</span> = <span class="hljs-number">512</span>, device: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span></span>):
<span class="hljs-meta">... </span>        <span class="hljs-comment"># define how to initialize your model</span>
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        ...
...
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_pretrained</span>(<span class="hljs-params">self, save_directory: Path</span>) -&gt; <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># define how to serialize your model</span>
<span class="hljs-meta">... </span>        ...
...
<span class="hljs-meta">... </span>    @<span class="hljs-built_in">classmethod</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">from_pretrained</span>(<span class="hljs-params">
<span class="hljs-meta">... </span>        cls: <span class="hljs-type">Type</span>[T],
<span class="hljs-meta">... </span>        pretrained_model_name_or_path: <span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, Path],
<span class="hljs-meta">... </span>        *,
<span class="hljs-meta">... </span>        force_download: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        resume_download: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        proxies: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>] = <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>        token: <span class="hljs-type">Optional</span>[<span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>]] = <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>        cache_dir: <span class="hljs-type">Optional</span>[<span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, Path]] = <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>        local_files_only: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        revision: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>] = <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>        **model_kwargs,
<span class="hljs-meta">... </span>    </span>) -&gt; T:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># define how to deserialize your model</span>
<span class="hljs-meta">... </span>        ...

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyCustomModel(size=<span class="hljs-number">256</span>, device=<span class="hljs-string">&quot;gpu&quot;</span>)

<span class="hljs-comment"># Save model weights to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Download and initialize weights from the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>reloaded_model = MyCustomModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>reloaded_model.config
{<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">256</span>, <span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;gpu&quot;</span>}

<span class="hljs-comment"># Model card has been correctly populated</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard
<span class="hljs-meta">&gt;&gt;&gt; </span>card = ModelCard.load(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card.data.tags
[<span class="hljs-string">&quot;x-custom-tag&quot;</span>, <span class="hljs-string">&quot;pytorch_model_hub_mixin&quot;</span>, <span class="hljs-string">&quot;model_hub_mixin&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>card.data.library_name
<span class="hljs-string">&quot;my-library&quot;</span>`,wrap:!1}}),{c(){n=r("p"),n.textContent=y,d=o(),m(h.$$.fragment)},l(i){n=c(i,"P",{"data-svelte-h":!0}),M(n)!=="svelte-11lpom8"&&(n.textContent=y),d=s(i),g(h.$$.fragment,i)},m(i,T){p(i,n,T),p(i,d,T),u(h,i,T),v=!0},p:Ge,i(i){v||(f(h.$$.fragment,i),v=!0)},o(i){_(h.$$.fragment,i),v=!1},d(i){i&&(t(n),t(d)),b(h,i)}}}function ct($){let n,y="Example:",d,h,v;return h=new Za({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyME15TW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uTW9kdWxlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsaWJyYXJ5X25hbWUlM0QlMjJrZXJhcy1ubHAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmtlcmFzLXRlYW0lMkZrZXJhcy1ubHAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkb2NzX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGa2VyYXMuaW8lMkZrZXJhc19ubHAlMkYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAlNUUlMjBvcHRpb25hbCUyMG1ldGFkYXRhJTIwdG8lMjBnZW5lcmF0ZSUyMG1vZGVsJTIwY2FyZCUwQSUyMCUyMCUyMCUyMCklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwaGlkZGVuX3NpemUlM0ElMjBpbnQlMjAlM0QlMjA1MTIlMkMlMjB2b2NhYl9zaXplJTNBJTIwaW50JTIwJTNEJTIwMzAwMDAlMkMlMjBvdXRwdXRfc2l6ZSUzQSUyMGludCUyMCUzRCUyMDQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5wYXJhbSUyMCUzRCUyMG5uLlBhcmFtZXRlcih0b3JjaC5yYW5kKGhpZGRlbl9zaXplJTJDJTIwdm9jYWJfc2l6ZSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5saW5lYXIlMjAlM0QlMjBubi5MaW5lYXIob3V0cHV0X3NpemUlMkMlMjB2b2NhYl9zaXplKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5saW5lYXIoeCUyMCUyQiUyMHNlbGYucGFyYW0pJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsKGhpZGRlbl9zaXplJTNEMjU2KSUwQSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJteS1hd2Vzb21lLW1vZGVsJTIyKSUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ1c2VybmFtZSUyRm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBbW9kZWwuaGlkZGVuX3NpemU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(
<span class="hljs-meta">... </span>        nn.Module,
<span class="hljs-meta">... </span>        PyTorchModelHubMixin,
<span class="hljs-meta">... </span>        library_name=<span class="hljs-string">&quot;keras-nlp&quot;</span>,
<span class="hljs-meta">... </span>        repo_url=<span class="hljs-string">&quot;https://github.com/keras-team/keras-nlp&quot;</span>,
<span class="hljs-meta">... </span>        docs_url=<span class="hljs-string">&quot;https://keras.io/keras_nlp/&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># ^ optional metadata to generate model card</span>
<span class="hljs-meta">... </span>    ):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, hidden_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">512</span>, vocab_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">30000</span>, output_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">4</span></span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(hidden_size, vocab_size))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(output_size, vocab_size)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel(hidden_size=<span class="hljs-number">256</span>)

<span class="hljs-comment"># Save model weights to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Download and initialize weights from the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.hidden_size
<span class="hljs-number">256</span>`,wrap:!1}}),{c(){n=r("p"),n.textContent=y,d=o(),m(h.$$.fragment)},l(i){n=c(i,"P",{"data-svelte-h":!0}),M(n)!=="svelte-11lpom8"&&(n.textContent=y),d=s(i),g(h.$$.fragment,i)},m(i,T){p(i,n,T),p(i,d,T),u(h,i,T),v=!0},p:Ge,i(i){v||(f(h.$$.fragment,i),v=!0)},o(i){_(h.$$.fragment,i),v=!1},d(i){i&&(t(n),t(d)),b(h,i)}}}function dt($){let n,y;return n=new Za({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwS2VyYXNNb2RlbEh1Yk1peGluJTBBJTBBJTBBY2xhc3MlMjBNeU1vZGVsKHRmLmtlcmFzLk1vZGVsJTJDJTIwS2VyYXNNb2RlbEh1Yk1peGluKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmNvbmZpZyUyMCUzRCUyMGt3YXJncy5wb3AoJTIyY29uZmlnJTIyJTJDJTIwTm9uZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmR1bW15X2lucHV0cyUyMCUzRCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGF5ZXIlMjAlM0QlMjAuLi4lMEElMEElMjAlMjAlMjAlMjBkZWYlMjBjYWxsKHNlbGYlMkMlMjAqYXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAuLi4lMEElMEElMEElMjMlMjBJbml0aWFsaXplJTIwYW5kJTIwY29tcGlsZSUyMHRoZSUyMG1vZGVsJTIwYXMlMjB5b3UlMjBub3JtYWxseSUyMHdvdWxkJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsKCklMEFtb2RlbC5jb21waWxlKC4uLiklMEElMjMlMjBCdWlsZCUyMHRoZSUyMGdyYXBoJTIwYnklMjB0cmFpbmluZyUyMGl0JTIwb3IlMjBwYXNzaW5nJTIwZHVtbXklMjBpbnB1dHMlMEFfJTIwJTNEJTIwbW9kZWwobW9kZWwuZHVtbXlfaW5wdXRzKSUwQSUyMyUyMFNhdmUlMjBtb2RlbCUyMHdlaWdodHMlMjB0byUyMGxvY2FsJTIwZGlyZWN0b3J5JTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTIzJTIwUHVzaCUyMG1vZGVsJTIwd2VpZ2h0cyUyMHRvJTIwdGhlJTIwSHViJTBBbW9kZWwucHVzaF90b19odWIoJTIybXktYXdlc29tZS1tb2RlbCUyMiklMEElMjMlMjBEb3dubG9hZCUyMGFuZCUyMGluaXRpYWxpemUlMjB3ZWlnaHRzJTIwZnJvbSUyMHRoZSUyMEh1YiUwQW1vZGVsJTIwJTNEJTIwTXlNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydXNlcm5hbWUlMkZzdXBlci1jb29sLW1vZGVsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> KerasModelHubMixin


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(tf.keras.Model, KerasModelHubMixin):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, **kwargs</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        self.config = kwargs.pop(<span class="hljs-string">&quot;config&quot;</span>, <span class="hljs-literal">None</span>)
<span class="hljs-meta">... </span>        self.dummy_inputs = ...
<span class="hljs-meta">... </span>        self.layer = ...

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">call</span>(<span class="hljs-params">self, *args</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> ...


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize and compile the model as you normally would</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">compile</span>(...)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Build the graph by training it or passing dummy inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model(model.dummy_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save model weights to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download and initialize weights from the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/super-cool-model&quot;</span>)`,wrap:!1}}),{c(){m(n.$$.fragment)},l(d){g(n.$$.fragment,d)},m(d,h){u(n,d,h),y=!0},p:Ge,i(d){y||(f(n.$$.fragment,d),y=!0)},o(d){_(n.$$.fragment,d),y=!1},d(d){b(n,d)}}}function pt($){let n,y=`Passing <code>token=True</code> is required when you want to use a private
model.`;return{c(){n=r("p"),n.innerHTML=y},l(d){n=c(d,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1j5fb81"&&(n.innerHTML=y)},m(d,h){p(d,n,h)},p:Ge,d(d){d&&t(n)}}}function ht($){let n,y="Raises the following error:",d,h,v=`<li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><em>ValueError</em></a>
if the user is not log on to the Hugging Face Hub.</li>`;return{c(){n=r("p"),n.textContent=y,d=o(),h=r("ul"),h.innerHTML=v},l(i){n=c(i,"P",{"data-svelte-h":!0}),M(n)!=="svelte-1f6kjc7"&&(n.textContent=y),d=s(i),h=c(i,"UL",{"data-svelte-h":!0}),M(h)!=="svelte-qftit0"&&(h.innerHTML=v)},m(i,T){p(i,n,T),p(i,d,T),p(i,h,T)},p:Ge,d(i){i&&(t(n),t(d),t(h))}}}function mt($){let n,y,d,h,v,i,T,Fe,q,Ba=`The <code>huggingface_hub</code> library offers a range of mixins that can be used as a parent class for your objects, in order to
provide simple uploading and downloading functions. Check out our <a href="../guides/integrations">integration guide</a> to learn
how to integrate any ML framework with the Hub.`,Ve,Q,Se,w,D,sa,ue,Ea="A generic mixin to integrate ANY machine learning framework with the Hub.",la,fe,Na=`To integrate your framework, your model class must inherit from this class. Custom logic for saving/loading models
have to be overwritten in  <code>_from_pretrained</code> and <code>_save_pretrained</code>. <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.PyTorchModelHubMixin">PyTorchModelHubMixin</a> is a good example
of mixin integration with the Hub. Check out our <a href="../guides/integrations">integration guide</a> for more instructions.`,ia,G,ra,F,K,ca,_e,za=`Overwrite this method in subclass to define how to save your model.
Check out our <a href="../guides/integrations">integration guide</a> for instructions.`,da,I,O,pa,be,Ga="Overwrite this method in subclass to define how to load your model from pretrained.",ha,Me,Fa=`Use <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> to download files from the Hub before loading them. Most
args taken as input can be directly passed to those 2 methods. If needed, you can add more arguments to this
method using “model_kwargs”. For example <code>PyTorchModelHubMixin._from_pretrained()</code> takes as input a <code>map_location</code>
parameter to set on which device the model should be loaded.`,ma,we,Va='Check out our <a href="../guides/integrations">integration guide</a> for more instructions.',ga,V,ee,ua,ye,Sa="Download a model from the Huggingface Hub and instantiate it.",fa,B,ae,_a,je,Xa="Upload model checkpoint to the Hub.",ba,ve,Ya=`Use <code>allow_patterns</code> and <code>ignore_patterns</code> to precisely filter which files should be pushed to the hub. Use
<code>delete_patterns</code> to delete existing remote files in the same commit. See <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> reference for more
details.`,Ma,S,te,wa,Te,La="Save weights in local directory.",Xe,ne,Ye,H,oe,ya,xe,Ra=`Implementation of <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> to provide model Hub upload/download capabilities to PyTorch models. The model
is set in evaluation mode by default using <code>model.eval()</code> (dropout modules are deactivated). To train the model,
you should first set it back in training mode with <code>model.train()</code>.`,ja,X,Le,se,Re,C,le,va,Je,Pa=`Implementation of <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> to provide model Hub upload/download
capabilities to Keras models.`,Ta,Y,Pe,A,ie,xa,Ue,qa=`Instantiate a pretrained Keras model from a pre-trained model from the Hub.
The model is expected to be in <code>SavedModel</code> format.`,Ja,L,qe,W,re,Ua,ke,Qa="Upload model checkpoint to the Hub.",ka,$e,Da=`Use <code>allow_patterns</code> and <code>ignore_patterns</code> to precisely filter which files should be pushed to the hub. Use
<code>delete_patterns</code> to delete existing remote files in the same commit. See <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> reference for more
details.`,Qe,E,ce,$a,Ie,Ka=`Saves a Keras model to save_directory in SavedModel format. Use this if
you’re using the Functional or Sequential APIs.`,De,de,Ke,N,pe,Ia,He,Oa="Load pretrained fastai model from the Hub or from a local directory.",Oe,U,he,Ha,Ce,et="Upload learner checkpoint files to the Hub.",Ca,Ae,at=`Use <em>allow_patterns</em> and <em>ignore_patterns</em> to precisely filter which files should be pushed to the hub. Use
<em>delete_patterns</em> to delete existing remote files in the same commit. See [<em>upload_folder</em>] reference for more
details.`,Aa,R,ea,ze,aa;return v=new Ne({props:{title:"Mixins & serialization methods",local:"mixins--serialization-methods",headingTag:"h1"}}),T=new Ne({props:{title:"Mixins",local:"mixins",headingTag:"h2"}}),Q=new Ne({props:{title:"Generic",local:"huggingface_hub.ModelHubMixin",headingTag:"h3"}}),D=new k({props:{name:"class huggingface_hub.ModelHubMixin",anchor:"huggingface_hub.ModelHubMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L62"}}),G=new Wa({props:{anchor:"huggingface_hub.ModelHubMixin.example",$$slots:{default:[rt]},$$scope:{ctx:$}}}),K=new k({props:{name:"_save_pretrained",anchor:"huggingface_hub.ModelHubMixin._save_pretrained",parameters:[{name:"save_directory",val:": Path"}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin._save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to directory in which the model weights and configuration will be saved.`,name:"save_directory"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L277"}}),O=new k({props:{name:"_from_pretrained",anchor:"huggingface_hub.ModelHubMixin._from_pretrained",parameters:[{name:"model_id",val:": str"},{name:"revision",val:": Optional"},{name:"cache_dir",val:": Union"},{name:"force_download",val:": bool"},{name:"proxies",val:": Optional"},{name:"resume_download",val:": bool"},{name:"local_files_only",val:": bool"},{name:"token",val:": Union"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
ID of the model to load from the Huggingface Hub (e.g. <code>bigscience/bloom</code>).`,name:"model_id"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision of the model on the Hub. Can be a branch name, a git tag or any commit id. Defaults to the
latest commit on <code>main</code> branch.`,name:"revision"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to force (re-)downloading the model weights and configuration files from the Hub, overriding
the existing cache.`,name:"force_download"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to delete incompletely received files. Will attempt to resume the download if such a file exists.`,name:"resume_download"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint (e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>).`,name:"proxies"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. By default, it will use the token
cached when running <code>huggingface-cli login</code>.`,name:"token"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the local cached file if it exists.
model_kwargs &#x2014;
Additional keyword arguments passed along to the <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin._from_pretrained">_from_pretrained()</a> method.`,name:"local_files_only"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L410"}}),ee=new k({props:{name:"from_pretrained",anchor:"huggingface_hub.ModelHubMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"force_download",val:": bool = False"},{name:"resume_download",val:": bool = False"},{name:"proxies",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"cache_dir",val:": Union = None"},{name:"local_files_only",val:": bool = False"},{name:"revision",val:": Optional = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code>, <code>Path</code>) &#x2014;<ul>
<li>Either the <code>model_id</code> (string) of a model hosted on the Hub, e.g. <code>bigscience/bloom</code>.</li>
<li>Or a path to a <code>directory</code> containing model weights saved using
<a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained" rel="nofollow">save_pretrained</a>, e.g., <code>../path/to/my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision of the model on the Hub. Can be a branch name, a git tag or any commit id.
Defaults to the latest commit on <code>main</code> branch.`,name:"revision"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to force (re-)downloading the model weights and configuration files from the Hub, overriding
the existing cache.`,name:"force_download"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to delete incompletely received files. Will attempt to resume the download if such a file exists.`,name:"resume_download"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on every request.`,name:"proxies"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. By default, it will use the token
cached when running <code>huggingface-cli login</code>.`,name:"token"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the local cached file if it exists.`,name:"local_files_only"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.model_kwargs",description:`<strong>model_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional kwargs to pass to the model during initialization.`,name:"model_kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L288"}}),ae=new k({props:{name:"push_to_hub",anchor:"huggingface_hub.ModelHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"config",val:": Union = None"},{name:"commit_message",val:": str = 'Push model using huggingface_hub.'"},{name:"private",val:": bool = False"},{name:"token",val:": Optional = None"},{name:"branch",val:": Optional = None"},{name:"create_pr",val:": Optional = None"},{name:"allow_patterns",val:": Union = None"},{name:"ignore_patterns",val:": Union = None"},{name:"delete_patterns",val:": Union = None"},{name:"api_endpoint",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repository to push to (example: <code>&quot;username/my-model&quot;</code>).`,name:"repo_id"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.config",description:`<strong>config</strong> (<code>dict</code> or <code>DataclassInstance</code>, <em>optional</em>) &#x2014;
Model configuration specified as a key/value dictionary or a dataclass instance.`,name:"config"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing.`,name:"commit_message"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the repository created should be private.`,name:"private"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.api_endpoint",description:`<strong>api_endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API endpoint to use when pushing the model to the hub.`,name:"api_endpoint"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. By default, it will use the token
cached when running <code>huggingface-cli login</code>.`,name:"token"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git branch on which to push the model. This defaults to <code>&quot;main&quot;</code>.`,name:"branch"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request from <code>branch</code> with that commit. Defaults to <code>False</code>.`,name:"create_pr"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are pushed.`,name:"allow_patterns"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not pushed.`,name:"ignore_patterns"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.delete_patterns",description:`<strong>delete_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, remote files matching any of the patterns will be deleted from the repo.`,name:"delete_patterns"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L459",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The url of the commit of your model in the given repository.</p>
`}}),te=new k({props:{name:"save_pretrained",anchor:"huggingface_hub.ModelHubMixin.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"config",val:": Union = None"},{name:"repo_id",val:": Optional = None"},{name:"push_to_hub",val:": bool = False"},{name:"**push_to_hub_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to directory in which the model weights and configuration will be saved.`,name:"save_directory"},{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.config",description:`<strong>config</strong> (<code>dict</code> or <code>DataclassInstance</code>, <em>optional</em>) &#x2014;
Model configuration specified as a key/value dictionary or a dataclass instance.`,name:"config"},{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Huggingface Hub after saving it.`,name:"push_to_hub"},{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.repo_id",description:`<strong>repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of your repository on the Hub. Used only if <code>push_to_hub=True</code>. Will default to the folder name if
not provided.
kwargs &#x2014;
Additional key word arguments passed along to the <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"repo_id"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L220"}}),ne=new Ne({props:{title:"PyTorch",local:"huggingface_hub.PyTorchModelHubMixin",headingTag:"h3"}}),oe=new k({props:{name:"class huggingface_hub.PyTorchModelHubMixin",anchor:"huggingface_hub.PyTorchModelHubMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py#L543"}}),X=new Wa({props:{anchor:"huggingface_hub.PyTorchModelHubMixin.example",$$slots:{default:[ct]},$$scope:{ctx:$}}}),se=new Ne({props:{title:"Keras",local:"huggingface_hub.KerasModelHubMixin",headingTag:"h3"}}),le=new k({props:{name:"class huggingface_hub.KerasModelHubMixin",anchor:"huggingface_hub.KerasModelHubMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/keras_mixin.py#L397"}}),Y=new Wa({props:{anchor:"huggingface_hub.KerasModelHubMixin.example",$$slots:{default:[dt]},$$scope:{ctx:$}}}),ie=new k({props:{name:"huggingface_hub.from_pretrained_keras",anchor:"huggingface_hub.from_pretrained_keras",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.from_pretrained_keras.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:<ul>
<li>A string, the <code>model id</code> of a pretrained model hosted inside a
model repo on huggingface.co. Valid model ids can be located
at the root-level, like <code>bert-base-uncased</code>, or namespaced
under a user or organization name, like
<code>dbmdz/bert-base-german-cased</code>.</li>
<li>You can add <code>revision</code> by appending <code>@</code> at the end of model_id
simply like this: <code>dbmdz/bert-base-german-cased@main</code> Revision
is the specific model version to use. It can be a branch name,
a tag name, or a commit id, since we use a git-based system
for storing models and other artifacts on huggingface.co, so
<code>revision</code> can be any identifier allowed by git.</li>
<li>A path to a <code>directory</code> containing model weights saved using
<a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained" rel="nofollow">save_pretrained</a>, e.g.,
<code>./my_model_directory/</code>.</li>
<li><code>None</code> if you are both providing the configuration and state
dictionary (resp. with keyword arguments <code>config</code> and
<code>state_dict</code>).</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"huggingface_hub.from_pretrained_keras.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to force the (re-)download of the model weights and
configuration files, overriding the cached versions if they exist.`,name:"force_download"},{anchor:"huggingface_hub.from_pretrained_keras.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to delete incompletely received files. Will attempt to
resume the download if such a file exists.`,name:"resume_download"},{anchor:"huggingface_hub.from_pretrained_keras.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g.,
<code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The
proxies are used on each request.`,name:"proxies"},{anchor:"huggingface_hub.from_pretrained_keras.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If
<code>True</code>, will use the token generated when running <code>transformers-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"huggingface_hub.from_pretrained_keras.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model
configuration should be cached if the standard cache should not be
used.`,name:"cache_dir"},{anchor:"huggingface_hub.from_pretrained_keras.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only look at local files (i.e., do not try to download
the model).`,name:"local_files_only(bool,"},{anchor:"huggingface_hub.from_pretrained_keras.model_kwargs",description:`<strong>model_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
model_kwargs will be passed to the model during initialization`,name:"model_kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/keras_mixin.py#L216"}}),L=new tt({props:{$$slots:{default:[pt]},$$scope:{ctx:$}}}),re=new k({props:{name:"huggingface_hub.push_to_hub_keras",anchor:"huggingface_hub.push_to_hub_keras",parameters:[{name:"model",val:""},{name:"repo_id",val:": str"},{name:"config",val:": Optional = None"},{name:"commit_message",val:": str = 'Push Keras model using huggingface_hub.'"},{name:"private",val:": bool = False"},{name:"api_endpoint",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"branch",val:": Optional = None"},{name:"create_pr",val:": Optional = None"},{name:"allow_patterns",val:": Union = None"},{name:"ignore_patterns",val:": Union = None"},{name:"delete_patterns",val:": Union = None"},{name:"log_dir",val:": Optional = None"},{name:"include_optimizer",val:": bool = False"},{name:"tags",val:": Union = None"},{name:"plot_model",val:": bool = True"},{name:"**model_save_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.push_to_hub_keras.model",description:`<strong>model</strong> (<code>Keras.Model</code>) &#x2014;
The <a href="%60https://www.tensorflow.org/api_docs/python/tf/keras/Model%60">Keras model</a> you&#x2019;d like to push to the
Hub. The model must be compiled and built.`,name:"model"},{anchor:"huggingface_hub.push_to_hub_keras.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
ID of the repository to push to (example: <code>&quot;username/my-model&quot;</code>).`,name:"repo_id"},{anchor:"huggingface_hub.push_to_hub_keras.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;Add Keras model&#x201D;) &#x2014;
Message to commit while pushing.`,name:"commit_message"},{anchor:"huggingface_hub.push_to_hub_keras.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the repository created should be private.`,name:"private"},{anchor:"huggingface_hub.push_to_hub_keras.api_endpoint",description:`<strong>api_endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API endpoint to use when pushing the model to the hub.`,name:"api_endpoint"},{anchor:"huggingface_hub.push_to_hub_keras.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If
not set, will use the token set when logging in with
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"huggingface_hub.push_to_hub_keras.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git branch on which to push the model. This defaults to
the default branch as specified in your repository, which
defaults to <code>&quot;main&quot;</code>.`,name:"branch"},{anchor:"huggingface_hub.push_to_hub_keras.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request from <code>branch</code> with that commit.
Defaults to <code>False</code>.`,name:"create_pr"},{anchor:"huggingface_hub.push_to_hub_keras.config",description:`<strong>config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Configuration object to be saved alongside the model weights.`,name:"config"},{anchor:"huggingface_hub.push_to_hub_keras.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are pushed.`,name:"allow_patterns"},{anchor:"huggingface_hub.push_to_hub_keras.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not pushed.`,name:"ignore_patterns"},{anchor:"huggingface_hub.push_to_hub_keras.delete_patterns",description:`<strong>delete_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, remote files matching any of the patterns will be deleted from the repo.`,name:"delete_patterns"},{anchor:"huggingface_hub.push_to_hub_keras.log_dir",description:`<strong>log_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
TensorBoard logging directory to be pushed. The Hub automatically
hosts and displays a TensorBoard instance if log files are included
in the repository.`,name:"log_dir"},{anchor:"huggingface_hub.push_to_hub_keras.include_optimizer",description:`<strong>include_optimizer</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include optimizer during serialization.`,name:"include_optimizer"},{anchor:"huggingface_hub.push_to_hub_keras.tags",description:`<strong>tags</strong> (Union[<code>list</code>, <code>str</code>], <em>optional</em>) &#x2014;
List of tags that are related to model or string of a single tag. See example tags
<a href="https://github.com/huggingface/hub-docs/blob/main/modelcard.md?plain=1" rel="nofollow">here</a>.`,name:"tags"},{anchor:"huggingface_hub.push_to_hub_keras.plot_model",description:`<strong>plot_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Setting this to <code>True</code> will plot the model and put it in the model
card. Requires graphviz and pydot to be installed.`,name:"plot_model"},{anchor:"huggingface_hub.push_to_hub_keras.model_save_kwargs(dict,",description:`<strong>model_save_kwargs(<code>dict</code>,</strong> <em>optional</em>) &#x2014;
model_save_kwargs will be passed to
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/models/save_model" rel="nofollow"><code>tf.keras.models.save_model()</code></a>.`,name:"model_save_kwargs(dict,"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/keras_mixin.py#L275",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The url of the commit of your model in the given repository.</p>
`}}),ce=new k({props:{name:"huggingface_hub.save_pretrained_keras",anchor:"huggingface_hub.save_pretrained_keras",parameters:[{name:"model",val:""},{name:"save_directory",val:": Union"},{name:"config",val:": Optional = None"},{name:"include_optimizer",val:": bool = False"},{name:"plot_model",val:": bool = True"},{name:"tags",val:": Union = None"},{name:"**model_save_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.save_pretrained_keras.model",description:`<strong>model</strong> (<code>Keras.Model</code>) &#x2014;
The <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">Keras
model</a>
you&#x2019;d like to save. The model must be compiled and built.`,name:"model"},{anchor:"huggingface_hub.save_pretrained_keras.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Specify directory in which you want to save the Keras model.`,name:"save_directory"},{anchor:"huggingface_hub.save_pretrained_keras.config",description:`<strong>config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Configuration object to be saved alongside the model weights.`,name:"config"},{anchor:"huggingface_hub.save_pretrained_keras.include_optimizer(bool,",description:`<strong>include_optimizer(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include optimizer in serialization.`,name:"include_optimizer(bool,"},{anchor:"huggingface_hub.save_pretrained_keras.plot_model",description:`<strong>plot_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Setting this to <code>True</code> will plot the model and put it in the model
card. Requires graphviz and pydot to be installed.`,name:"plot_model"},{anchor:"huggingface_hub.save_pretrained_keras.tags",description:`<strong>tags</strong> (Union[<code>str</code>,<code>list</code>], <em>optional</em>) &#x2014;
List of tags that are related to model or string of a single tag. See example tags
<a href="https://github.com/huggingface/hub-docs/blob/main/modelcard.md?plain=1" rel="nofollow">here</a>.`,name:"tags"},{anchor:"huggingface_hub.save_pretrained_keras.model_save_kwargs(dict,",description:`<strong>model_save_kwargs(<code>dict</code>,</strong> <em>optional</em>) &#x2014;
model_save_kwargs will be passed to
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/models/save_model" rel="nofollow"><code>tf.keras.models.save_model()</code></a>.`,name:"model_save_kwargs(dict,"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/keras_mixin.py#L131"}}),de=new Ne({props:{title:"Fastai",local:"huggingface_hub.from_pretrained_fastai",headingTag:"h3"}}),pe=new k({props:{name:"huggingface_hub.from_pretrained_fastai",anchor:"huggingface_hub.from_pretrained_fastai",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.from_pretrained_fastai.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The location where the pickled fastai.Learner is. It can be either of the two:<ul>
<li>Hosted on the Hugging Face Hub. E.g.: &#x2018;espejelomar/fatai-pet-breeds-classification&#x2019; or &#x2018;distilgpt2&#x2019;.
You can add a <code>revision</code> by appending <code>@</code> at the end of <code>repo_id</code>. E.g.: <code>dbmdz/bert-base-german-cased@main</code>.
Revision is the specific model version to use. Since we use a git-based system for storing models and other
artifacts on the Hugging Face Hub, it can be a branch name, a tag name, or a commit id.</li>
<li>Hosted locally. <code>repo_id</code> would be a directory containing the pickle and a pyproject.toml
indicating the fastai and fastcore versions used to build the <code>fastai.Learner</code>. E.g.: <code>./my_model_directory/</code>.</li>
</ul>`,name:"repo_id"},{anchor:"huggingface_hub.from_pretrained_fastai.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision at which the repo&#x2019;s files are downloaded. See documentation of <code>snapshot_download</code>.`,name:"revision"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/fastai_utils.py#L298",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>fastai.Learner</code> model in the <code>repo_id</code> repo.</p>
`}}),he=new k({props:{name:"huggingface_hub.push_to_hub_fastai",anchor:"huggingface_hub.push_to_hub_fastai",parameters:[{name:"learner",val:""},{name:"repo_id",val:": str"},{name:"commit_message",val:": str = 'Push FastAI model using huggingface_hub.'"},{name:"private",val:": bool = False"},{name:"token",val:": Optional = None"},{name:"config",val:": Optional = None"},{name:"branch",val:": Optional = None"},{name:"create_pr",val:": Optional = None"},{name:"allow_patterns",val:": Union = None"},{name:"ignore_patterns",val:": Union = None"},{name:"delete_patterns",val:": Union = None"},{name:"api_endpoint",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.push_to_hub_fastai.learner",description:`<strong>learner</strong> (<em>Learner</em>) &#x2014;
The *fastai.Learner&#x2019; you&#x2019;d like to push to the Hub.`,name:"learner"},{anchor:"huggingface_hub.push_to_hub_fastai.repo_id",description:`<strong>repo_id</strong> (<em>str</em>) &#x2014;
The repository id for your model in Hub in the format of &#x201C;namespace/repo_name&#x201D;. The namespace can be your individual account or an organization to which you have write access (for example, &#x2018;stanfordnlp/stanza-de&#x2019;).`,name:"repo_id"},{anchor:"huggingface_hub.push_to_hub_fastai.commit_message",description:"<strong>commit_message</strong> (<em>str`, </em>optional*) &#x2014; Message to commit while pushing. Will default to <code>&quot;add model&quot;</code>.",name:"commit_message"},{anchor:"huggingface_hub.push_to_hub_fastai.private",description:`<strong>private</strong> (<em>bool</em>, <em>optional</em>, defaults to <em>False</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"huggingface_hub.push_to_hub_fastai.token",description:`<strong>token</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The Hugging Face account token to use as HTTP bearer authorization for remote files. If <code>None</code>, the token will be asked by a prompt.`,name:"token"},{anchor:"huggingface_hub.push_to_hub_fastai.config",description:`<strong>config</strong> (<em>dict</em>, <em>optional</em>) &#x2014;
Configuration object to be saved alongside the model weights.`,name:"config"},{anchor:"huggingface_hub.push_to_hub_fastai.branch",description:`<strong>branch</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The git branch on which to push the model. This defaults to
the default branch as specified in your repository, which
defaults to <em>&#x201C;main&#x201D;</em>.`,name:"branch"},{anchor:"huggingface_hub.push_to_hub_fastai.create_pr",description:`<strong>create_pr</strong> (<em>boolean</em>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request from <em>branch</em> with that commit.
Defaults to <em>False</em>.`,name:"create_pr"},{anchor:"huggingface_hub.push_to_hub_fastai.api_endpoint",description:`<strong>api_endpoint</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The API endpoint to use when pushing the model to the hub.`,name:"api_endpoint"},{anchor:"huggingface_hub.push_to_hub_fastai.allow_patterns",description:`<strong>allow_patterns</strong> (<em>List[str]</em> or <em>str</em>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are pushed.`,name:"allow_patterns"},{anchor:"huggingface_hub.push_to_hub_fastai.ignore_patterns",description:`<strong>ignore_patterns</strong> (<em>List[str]</em> or <em>str</em>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not pushed.`,name:"ignore_patterns"},{anchor:"huggingface_hub.push_to_hub_fastai.delete_patterns",description:`<strong>delete_patterns</strong> (<em>List[str]</em> or <em>str</em>, <em>optional</em>) &#x2014;
If provided, remote files matching any of the patterns will be deleted from the repo.`,name:"delete_patterns"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/fastai_utils.py#L343",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The url of the commit of your model in the given repository.</p>
`}}),R=new tt({props:{$$slots:{default:[ht]},$$scope:{ctx:$}}}),{c(){n=r("meta"),y=o(),d=r("p"),h=o(),m(v.$$.fragment),i=o(),m(T.$$.fragment),Fe=o(),q=r("p"),q.innerHTML=Ba,Ve=o(),m(Q.$$.fragment),Se=o(),w=r("div"),m(D.$$.fragment),sa=o(),ue=r("p"),ue.textContent=Ea,la=o(),fe=r("p"),fe.innerHTML=Na,ia=o(),m(G.$$.fragment),ra=o(),F=r("div"),m(K.$$.fragment),ca=o(),_e=r("p"),_e.innerHTML=za,da=o(),I=r("div"),m(O.$$.fragment),pa=o(),be=r("p"),be.textContent=Ga,ha=o(),Me=r("p"),Me.innerHTML=Fa,ma=o(),we=r("p"),we.innerHTML=Va,ga=o(),V=r("div"),m(ee.$$.fragment),ua=o(),ye=r("p"),ye.textContent=Sa,fa=o(),B=r("div"),m(ae.$$.fragment),_a=o(),je=r("p"),je.textContent=Xa,ba=o(),ve=r("p"),ve.innerHTML=Ya,Ma=o(),S=r("div"),m(te.$$.fragment),wa=o(),Te=r("p"),Te.textContent=La,Xe=o(),m(ne.$$.fragment),Ye=o(),H=r("div"),m(oe.$$.fragment),ya=o(),xe=r("p"),xe.innerHTML=Ra,ja=o(),m(X.$$.fragment),Le=o(),m(se.$$.fragment),Re=o(),C=r("div"),m(le.$$.fragment),va=o(),Je=r("p"),Je.innerHTML=Pa,Ta=o(),m(Y.$$.fragment),Pe=o(),A=r("div"),m(ie.$$.fragment),xa=o(),Ue=r("p"),Ue.innerHTML=qa,Ja=o(),m(L.$$.fragment),qe=o(),W=r("div"),m(re.$$.fragment),Ua=o(),ke=r("p"),ke.textContent=Qa,ka=o(),$e=r("p"),$e.innerHTML=Da,Qe=o(),E=r("div"),m(ce.$$.fragment),$a=o(),Ie=r("p"),Ie.textContent=Ka,De=o(),m(de.$$.fragment),Ke=o(),N=r("div"),m(pe.$$.fragment),Ia=o(),He=r("p"),He.textContent=Oa,Oe=o(),U=r("div"),m(he.$$.fragment),Ha=o(),Ce=r("p"),Ce.textContent=et,Ca=o(),Ae=r("p"),Ae.innerHTML=at,Aa=o(),m(R.$$.fragment),ea=o(),ze=r("p"),this.h()},l(e){const l=it("svelte-u9bgzb",document.head);n=c(l,"META",{name:!0,content:!0}),l.forEach(t),y=s(e),d=c(e,"P",{}),x(d).forEach(t),h=s(e),g(v.$$.fragment,e),i=s(e),g(T.$$.fragment,e),Fe=s(e),q=c(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-by7ppc"&&(q.innerHTML=Ba),Ve=s(e),g(Q.$$.fragment,e),Se=s(e),w=c(e,"DIV",{class:!0});var j=x(w);g(D.$$.fragment,j),sa=s(j),ue=c(j,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-1q74itk"&&(ue.textContent=Ea),la=s(j),fe=c(j,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-1g82wpt"&&(fe.innerHTML=Na),ia=s(j),g(G.$$.fragment,j),ra=s(j),F=c(j,"DIV",{class:!0});var me=x(F);g(K.$$.fragment,me),ca=s(me),_e=c(me,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-1fdydm0"&&(_e.innerHTML=za),me.forEach(t),da=s(j),I=c(j,"DIV",{class:!0});var Z=x(I);g(O.$$.fragment,Z),pa=s(Z),be=c(Z,"P",{"data-svelte-h":!0}),M(be)!=="svelte-1totzue"&&(be.textContent=Ga),ha=s(Z),Me=c(Z,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-90qthw"&&(Me.innerHTML=Fa),ma=s(Z),we=c(Z,"P",{"data-svelte-h":!0}),M(we)!=="svelte-1xccgfy"&&(we.innerHTML=Va),Z.forEach(t),ga=s(j),V=c(j,"DIV",{class:!0});var ge=x(V);g(ee.$$.fragment,ge),ua=s(ge),ye=c(ge,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-ydwjgk"&&(ye.textContent=Sa),ge.forEach(t),fa=s(j),B=c(j,"DIV",{class:!0});var z=x(B);g(ae.$$.fragment,z),_a=s(z),je=c(z,"P",{"data-svelte-h":!0}),M(je)!=="svelte-skcyeb"&&(je.textContent=Xa),ba=s(z),ve=c(z,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-mlktc5"&&(ve.innerHTML=Ya),z.forEach(t),Ma=s(j),S=c(j,"DIV",{class:!0});var ta=x(S);g(te.$$.fragment,ta),wa=s(ta),Te=c(ta,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-usyekl"&&(Te.textContent=La),ta.forEach(t),j.forEach(t),Xe=s(e),g(ne.$$.fragment,e),Ye=s(e),H=c(e,"DIV",{class:!0});var We=x(H);g(oe.$$.fragment,We),ya=s(We),xe=c(We,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-1gq77ie"&&(xe.innerHTML=Ra),ja=s(We),g(X.$$.fragment,We),We.forEach(t),Le=s(e),g(se.$$.fragment,e),Re=s(e),C=c(e,"DIV",{class:!0});var Ze=x(C);g(le.$$.fragment,Ze),va=s(Ze),Je=c(Ze,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-1ldd987"&&(Je.innerHTML=Pa),Ta=s(Ze),g(Y.$$.fragment,Ze),Ze.forEach(t),Pe=s(e),A=c(e,"DIV",{class:!0});var Be=x(A);g(ie.$$.fragment,Be),xa=s(Be),Ue=c(Be,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-13dzwpk"&&(Ue.innerHTML=qa),Ja=s(Be),g(L.$$.fragment,Be),Be.forEach(t),qe=s(e),W=c(e,"DIV",{class:!0});var Ee=x(W);g(re.$$.fragment,Ee),Ua=s(Ee),ke=c(Ee,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-skcyeb"&&(ke.textContent=Qa),ka=s(Ee),$e=c(Ee,"P",{"data-svelte-h":!0}),M($e)!=="svelte-mlktc5"&&($e.innerHTML=Da),Ee.forEach(t),Qe=s(e),E=c(e,"DIV",{class:!0});var na=x(E);g(ce.$$.fragment,na),$a=s(na),Ie=c(na,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-1y1rkkk"&&(Ie.textContent=Ka),na.forEach(t),De=s(e),g(de.$$.fragment,e),Ke=s(e),N=c(e,"DIV",{class:!0});var oa=x(N);g(pe.$$.fragment,oa),Ia=s(oa),He=c(oa,"P",{"data-svelte-h":!0}),M(He)!=="svelte-1fexh91"&&(He.textContent=Oa),oa.forEach(t),Oe=s(e),U=c(e,"DIV",{class:!0});var P=x(U);g(he.$$.fragment,P),Ha=s(P),Ce=c(P,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-18c83zg"&&(Ce.textContent=et),Ca=s(P),Ae=c(P,"P",{"data-svelte-h":!0}),M(Ae)!=="svelte-1jbgd9l"&&(Ae.innerHTML=at),Aa=s(P),g(R.$$.fragment,P),P.forEach(t),ea=s(e),ze=c(e,"P",{}),x(ze).forEach(t),this.h()},h(){J(n,"name","hf:doc:metadata"),J(n,"content",gt),J(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){a(document.head,n),p(e,y,l),p(e,d,l),p(e,h,l),u(v,e,l),p(e,i,l),u(T,e,l),p(e,Fe,l),p(e,q,l),p(e,Ve,l),u(Q,e,l),p(e,Se,l),p(e,w,l),u(D,w,null),a(w,sa),a(w,ue),a(w,la),a(w,fe),a(w,ia),u(G,w,null),a(w,ra),a(w,F),u(K,F,null),a(F,ca),a(F,_e),a(w,da),a(w,I),u(O,I,null),a(I,pa),a(I,be),a(I,ha),a(I,Me),a(I,ma),a(I,we),a(w,ga),a(w,V),u(ee,V,null),a(V,ua),a(V,ye),a(w,fa),a(w,B),u(ae,B,null),a(B,_a),a(B,je),a(B,ba),a(B,ve),a(w,Ma),a(w,S),u(te,S,null),a(S,wa),a(S,Te),p(e,Xe,l),u(ne,e,l),p(e,Ye,l),p(e,H,l),u(oe,H,null),a(H,ya),a(H,xe),a(H,ja),u(X,H,null),p(e,Le,l),u(se,e,l),p(e,Re,l),p(e,C,l),u(le,C,null),a(C,va),a(C,Je),a(C,Ta),u(Y,C,null),p(e,Pe,l),p(e,A,l),u(ie,A,null),a(A,xa),a(A,Ue),a(A,Ja),u(L,A,null),p(e,qe,l),p(e,W,l),u(re,W,null),a(W,Ua),a(W,ke),a(W,ka),a(W,$e),p(e,Qe,l),p(e,E,l),u(ce,E,null),a(E,$a),a(E,Ie),p(e,De,l),u(de,e,l),p(e,Ke,l),p(e,N,l),u(pe,N,null),a(N,Ia),a(N,He),p(e,Oe,l),p(e,U,l),u(he,U,null),a(U,Ha),a(U,Ce),a(U,Ca),a(U,Ae),a(U,Aa),u(R,U,null),p(e,ea,l),p(e,ze,l),aa=!0},p(e,[l]){const j={};l&2&&(j.$$scope={dirty:l,ctx:e}),G.$set(j);const me={};l&2&&(me.$$scope={dirty:l,ctx:e}),X.$set(me);const Z={};l&2&&(Z.$$scope={dirty:l,ctx:e}),Y.$set(Z);const ge={};l&2&&(ge.$$scope={dirty:l,ctx:e}),L.$set(ge);const z={};l&2&&(z.$$scope={dirty:l,ctx:e}),R.$set(z)},i(e){aa||(f(v.$$.fragment,e),f(T.$$.fragment,e),f(Q.$$.fragment,e),f(D.$$.fragment,e),f(G.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(ae.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(X.$$.fragment,e),f(se.$$.fragment,e),f(le.$$.fragment,e),f(Y.$$.fragment,e),f(ie.$$.fragment,e),f(L.$$.fragment,e),f(re.$$.fragment,e),f(ce.$$.fragment,e),f(de.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(R.$$.fragment,e),aa=!0)},o(e){_(v.$$.fragment,e),_(T.$$.fragment,e),_(Q.$$.fragment,e),_(D.$$.fragment,e),_(G.$$.fragment,e),_(K.$$.fragment,e),_(O.$$.fragment,e),_(ee.$$.fragment,e),_(ae.$$.fragment,e),_(te.$$.fragment,e),_(ne.$$.fragment,e),_(oe.$$.fragment,e),_(X.$$.fragment,e),_(se.$$.fragment,e),_(le.$$.fragment,e),_(Y.$$.fragment,e),_(ie.$$.fragment,e),_(L.$$.fragment,e),_(re.$$.fragment,e),_(ce.$$.fragment,e),_(de.$$.fragment,e),_(pe.$$.fragment,e),_(he.$$.fragment,e),_(R.$$.fragment,e),aa=!1},d(e){e&&(t(y),t(d),t(h),t(i),t(Fe),t(q),t(Ve),t(Se),t(w),t(Xe),t(Ye),t(H),t(Le),t(Re),t(C),t(Pe),t(A),t(qe),t(W),t(Qe),t(E),t(De),t(Ke),t(N),t(Oe),t(U),t(ea),t(ze)),t(n),b(v,e),b(T,e),b(Q,e),b(D),b(G),b(K),b(O),b(ee),b(ae),b(te),b(ne,e),b(oe),b(X),b(se,e),b(le),b(Y),b(ie),b(L),b(re),b(ce),b(de,e),b(pe),b(he),b(R)}}}const gt='{"title":"Mixins & serialization methods","local":"mixins--serialization-methods","sections":[{"title":"Mixins","local":"mixins","sections":[{"title":"Generic","local":"huggingface_hub.ModelHubMixin","sections":[],"depth":3},{"title":"PyTorch","local":"huggingface_hub.PyTorchModelHubMixin","sections":[],"depth":3},{"title":"Keras","local":"huggingface_hub.KerasModelHubMixin","sections":[],"depth":3},{"title":"Fastai","local":"huggingface_hub.from_pretrained_fastai","sections":[],"depth":3}],"depth":2}],"depth":1}';function ut($){return ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vt extends st{constructor(n){super(),lt(this,n,ut,mt,nt,{})}}export{vt as component};
