import{s as Je,n as je,o as Te}from"../chunks/scheduler.6062bdaf.js";import{S as be,i as Ue,g as a,s as o,r as m,A as ve,h as l,f as e,c as i,j as c,u as d,x as h,k as p,y as r,a as n,v as g,d as u,t as y,w as f}from"../chunks/index.4bca734e.js";import{I as Wt}from"../chunks/IconCopyLink.68a13644.js";import{C as nt}from"../chunks/CodeBlock.f213e6a5.js";function Ze(Lt){let M,ct,w,b,ot,I,Et,D,Qt="Interact with the Hub through the Filesystem API",ht,_,At='In addition to the <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>, the <code>huggingface_hub</code> library provides <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>, a pythonic <a href="https://filesystem-spec.readthedocs.io/en/latest/" rel="nofollow">fsspec-compatible</a> file interface to the Hugging Face Hub. The <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> builds of top of the <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> and offers typical filesystem style operations like <code>cp</code>, <code>mv</code>, <code>ls</code>, <code>du</code>, <code>glob</code>, <code>get_file</code>, and <code>put_file</code>.',mt,J,U,it,G,Ht,K,Pt="Usage",dt,R,gt,S,Dt="The optional <code>revision</code> argument can be passed to run an operation from a specific commit such as a branch, tag name, or a commit hash.",ut,X,Kt="Unlike Python’s built-in <code>open</code>, <code>fsspec</code>’s <code>open</code> defaults to binary mode, <code>&quot;rb&quot;</code>. This means you must explicitly set mode as <code>&quot;r&quot;</code> for reading and <code>&quot;w&quot;</code> for writing in text mode. Appending to a file (modes <code>&quot;a&quot;</code> and <code>&quot;ab&quot;</code>) is not supported yet.",yt,j,v,rt,B,Ct,O,Ot="Integrations",ft,$,te='The <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> can be used with any library that integrates <code>fsspec</code>, provided the URL follows the scheme:',Mt,x,wt,F,ee="The <code>repo_type_prefix</code> is <code>datasets/</code> for datasets, <code>spaces/</code> for spaces, and models don’t need a prefix in the URL.",Jt,W,se='Some interesting integrations where <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> simplifies interacting with the Hub are listed below:',jt,tt,E,et,ae='Reading/writing a <a href="https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html#reading-writing-remote-files" rel="nofollow">Pandas</a> DataFrame from/to a Hub repository:',Yt,H,Tt,C,le='The same workflow can also be used for <a href="https://docs.dask.org/en/stable/how-to/connect-to-remote-data.html" rel="nofollow">Dask</a> and <a href="https://pola-rs.github.io/polars/py-polars/html/reference/io.html" rel="nofollow">Polars</a> DataFrames.',bt,Z,Y,st,ne='Querying (remote) Hub files with <a href="https://duckdb.org/docs/guides/python/filesystems" rel="nofollow">DuckDB</a>:',Nt,N,qt,q,at,oe='Using the Hub as an array store with <a href="https://zarr.readthedocs.io/en/stable/tutorial.html#io-with-fsspec" rel="nofollow">Zarr</a>:',zt,z,Ut,T,k,pt,V,Vt,lt,ie="Authentication",vt,L,re='In many cases, you must be logged in with a Hugging Face account to interact with the Hub. Refer to the <a href="../quick-start#login">Login</a> section of the documentation to learn more about authentication methods on the Hub.',Zt,Q,pe='It is also possible to login programmatically by passing your <code>token</code> as an argument to <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>:',kt,A,It,P,ce="If you login this way, be careful not to accidentally leak the token when sharing your source code!",_t;return I=new Wt({}),G=new Wt({}),R=new nt({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEElMEElMjMlMjBMaXN0JTIwYWxsJTIwZmlsZXMlMjBpbiUyMGElMjBkaXJlY3RvcnklMEFmcy5scyglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyMiUyQyUyMGRldGFpbCUzREZhbHNlKSUwQSUwQSUyMyUyMExpc3QlMjBhbGwlMjAlMjIuY3N2JTIyJTIwZmlsZXMlMjBpbiUyMGElMjByZXBvJTBBZnMuZ2xvYiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGKiouY3N2JTIyKSUwQSUwQSUyMyUyMFJlYWQlMjBhJTIwcmVtb3RlJTIwZmlsZSUyMCUwQXdpdGglMjBmcy5vcGVuKCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhJTJGdHJhaW4uY3N2JTIyJTJDJTIwJTIyciUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhJTIwJTNEJTIwZi5yZWFkbGluZXMoKSUwQSUwQSUyMyUyMFJlYWQlMjB0aGUlMjBjb250ZW50JTIwb2YlMjBhJTIwcmVtb3RlJTIwZmlsZSUyMGFzJTIwYSUyMHN0cmluZyUwQXRyYWluX2RhdGElMjAlM0QlMjBmcy5yZWFkX3RleHQoJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ0cmFpbi5jc3YlMjIlMkMlMjByZXZpc2lvbiUzRCUyMmRldiUyMiklMEElMEElMjMlMjBXcml0ZSUyMGElMjByZW1vdGUlMjBmaWxlJTBBd2l0aCUyMGZzLm9wZW4oJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ2YWxpZGF0aW9uLmNzdiUyMiUyQyUyMCUyMnclMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwZi53cml0ZSglMjJ0ZXh0JTJDbGFiZWwlMjIpJTBBJTIwJTIwJTIwJTIwZi53cml0ZSglMjJGYW50YXN0aWMlMjBtb3ZpZSElMkNnb29kJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># List all files in a directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.ls(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data&quot;</span>, detail=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># List all &quot;.csv&quot; files in a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.glob(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/**.csv&quot;</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read a remote file </span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    train_data = f.readlines()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read the content of a remote file as a string</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_data = fs.read_text(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, revision=<span class="hljs-string">&quot;dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write a remote file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/validation.csv&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;text,label&quot;</span>)
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;Fantastic movie!,good&quot;</span>)`}}),B=new Wt({}),x=new nt({props:{code:"aGYlM0ElMkYlMkYlNUIlM0NyZXBvX3R5cGVfcHJlZml4JTNFJTVEJTNDcmVwb19pZCUzRSU1QiU0MCUzQ3JldmlzaW9uJTNFJTVEJTJGJTNDcGF0aCUyRmluJTJGcmVwbyUzRQ==",highlighted:'hf:<span class="hljs-regexp">//</span>[&lt;repo_type_prefix&gt;]&lt;repo_id&gt;[@&lt;revision&gt;]<span class="hljs-regexp">/&lt;path/i</span>n/repo&gt;'}}),H=new nt({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQSUyMyUyMFJlYWQlMjBhJTIwcmVtb3RlJTIwQ1NWJTIwZmlsZSUyMGludG8lMjBhJTIwZGF0YWZyYW1lJTBBZGYlMjAlM0QlMjBwZC5yZWFkX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0cmFpbi5jc3YlMjIpJTBBJTBBJTIzJTIwV3JpdGUlMjBhJTIwZGF0YWZyYW1lJTIwdG8lMjBhJTIwcmVtb3RlJTIwQ1NWJTIwZmlsZSUwQWRmLnRvX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0ZXN0LmNzdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read a remote CSV file into a dataframe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/train.csv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write a dataframe to a remote CSV file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df.to_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/test.csv&quot;</span>)`}}),N=new nt({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWltcG9ydCUyMGR1Y2tkYiUwQSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEFkdWNrZGIucmVnaXN0ZXJfZmlsZXN5c3RlbShmcyklMEElMjMlMjBRdWVyeSUyMGElMjByZW1vdGUlMjBmaWxlJTIwYW5kJTIwZ2V0JTIwdGhlJTIwcmVzdWx0JTIwYmFjayUyMGFzJTIwYSUyMGRhdGFmcmFtZSUwQWZzX3F1ZXJ5X2ZpbGUlMjAlM0QlMjAlMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhX2RpciUyRmRhdGEucGFycXVldCUyMiUwQWRmJTIwJTNEJTIwZHVja2RiLnF1ZXJ5KGYlMjJTRUxFQ1QlMjAqJTIwRlJPTSUyMCclN0Jmc19xdWVyeV9maWxlJTdEJyUyMExJTUlUJTIwMTAlMjIpLmRmKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> duckdb

<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()
<span class="hljs-meta">&gt;&gt;&gt; </span>duckdb.register_filesystem(fs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Query a remote file and get the result back as a dataframe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs_query_file = <span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/data_dir/data.parquet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = duckdb.query(<span class="hljs-string">f&quot;SELECT * FROM &#x27;<span class="hljs-subst">{fs_query_file}</span>&#x27; LIMIT 10&quot;</span>).df()`}}),z=new nt({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwemFyciUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjBucC5yYW5kb20ucmFuZG4oNTAwMDAlMkMlMjAxMDAwKS5hc3R5cGUoJTIyZmxvYXQzMiUyMiklMEElMEElMjMlMjBXcml0ZSUyMGFuJTIwYXJyYXklMjB0byUyMGElMjByZXBvJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnclMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZm9vJTIwJTNEJTIwcm9vdC5jcmVhdGVfZ3JvdXAoJTIyZW1iZWRkaW5ncyUyMiklMEElMjAlMjAlMjBmb29iYXIlMjAlM0QlMjBmb28uemVyb3MoJ2V4cGVyaW1lbnRfMCclMkMlMjBzaGFwZSUzRCg1MDAwMCUyQyUyMDEwMDApJTJDJTIwY2h1bmtzJTNEKDEwMDAwJTJDJTIwMTAwMCklMkMlMjBkdHlwZSUzRCdmNCcpJTBBJTIwJTIwJTIwZm9vYmFyJTVCJTNBJTVEJTIwJTNEJTIwZW1iZWRkaW5ncyUwQSUwQSUyMyUyMFJlYWQlMjBhbiUyMGFycmF5JTIwZnJvbSUyMGElMjByZXBvJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnIlMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZmlyc3Rfcm93JTIwJTNEJTIwcm9vdCU1QiUyMmVtYmVkZGluZ3MlMkZleHBlcmltZW50XzAlMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> zarr

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = np.random.randn(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>).astype(<span class="hljs-string">&quot;float32&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write an array to a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   foo = root.create_group(<span class="hljs-string">&quot;embeddings&quot;</span>)
<span class="hljs-meta">... </span>   foobar = foo.zeros(<span class="hljs-string">&#x27;experiment_0&#x27;</span>, shape=(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>), chunks=(<span class="hljs-number">10000</span>, <span class="hljs-number">1000</span>), dtype=<span class="hljs-string">&#x27;f4&#x27;</span>)
<span class="hljs-meta">... </span>   foobar[:] = embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read an array from a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   first_row = root[<span class="hljs-string">&quot;embeddings/experiment_0&quot;</span>][<span class="hljs-number">0</span>]`}}),V=new Wt({}),A=new nt({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKHRva2VuJTNEdG9rZW4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem(token=token)`}}),{c(){M=a("meta"),ct=o(),w=a("h1"),b=a("a"),ot=a("span"),m(I.$$.fragment),Et=o(),D=a("span"),D.textContent=Qt,ht=o(),_=a("p"),_.innerHTML=At,mt=o(),J=a("h2"),U=a("a"),it=a("span"),m(G.$$.fragment),Ht=o(),K=a("span"),K.textContent=Pt,dt=o(),m(R.$$.fragment),gt=o(),S=a("p"),S.innerHTML=Dt,ut=o(),X=a("p"),X.innerHTML=Kt,yt=o(),j=a("h2"),v=a("a"),rt=a("span"),m(B.$$.fragment),Ct=o(),O=a("span"),O.textContent=Ot,ft=o(),$=a("p"),$.innerHTML=te,Mt=o(),m(x.$$.fragment),wt=o(),F=a("p"),F.innerHTML=ee,Jt=o(),W=a("p"),W.innerHTML=se,jt=o(),tt=a("ul"),E=a("li"),et=a("p"),et.innerHTML=ae,Yt=o(),m(H.$$.fragment),Tt=o(),C=a("p"),C.innerHTML=le,bt=o(),Z=a("ul"),Y=a("li"),st=a("p"),st.innerHTML=ne,Nt=o(),m(N.$$.fragment),qt=o(),q=a("li"),at=a("p"),at.innerHTML=oe,zt=o(),m(z.$$.fragment),Ut=o(),T=a("h2"),k=a("a"),pt=a("span"),m(V.$$.fragment),Vt=o(),lt=a("span"),lt.textContent=ie,vt=o(),L=a("p"),L.innerHTML=re,Zt=o(),Q=a("p"),Q.innerHTML=pe,kt=o(),m(A.$$.fragment),It=o(),P=a("p"),P.textContent=ce,this.h()},l(t){const s=ve("svelte-1phssyn",document.head);M=l(s,"META",{name:!0,content:!0}),s.forEach(e),ct=i(t),w=l(t,"H1",{class:!0});var Gt=c(w);b=l(Gt,"A",{id:!0,class:!0,href:!0});var he=c(b);ot=l(he,"SPAN",{});var me=c(ot);d(I.$$.fragment,me),me.forEach(e),he.forEach(e),Et=i(Gt),D=l(Gt,"SPAN",{"data-svelte-h":!0}),h(D)!=="svelte-o8b6j0"&&(D.textContent=Qt),Gt.forEach(e),ht=i(t),_=l(t,"P",{"data-svelte-h":!0}),h(_)!=="svelte-182hfgc"&&(_.innerHTML=At),mt=i(t),J=l(t,"H2",{class:!0});var Rt=c(J);U=l(Rt,"A",{id:!0,class:!0,href:!0});var de=c(U);it=l(de,"SPAN",{});var ge=c(it);d(G.$$.fragment,ge),ge.forEach(e),de.forEach(e),Ht=i(Rt),K=l(Rt,"SPAN",{"data-svelte-h":!0}),h(K)!=="svelte-jwh4bg"&&(K.textContent=Pt),Rt.forEach(e),dt=i(t),d(R.$$.fragment,t),gt=i(t),S=l(t,"P",{"data-svelte-h":!0}),h(S)!=="svelte-fkc5g9"&&(S.innerHTML=Dt),ut=i(t),X=l(t,"P",{"data-svelte-h":!0}),h(X)!=="svelte-2xrojz"&&(X.innerHTML=Kt),yt=i(t),j=l(t,"H2",{class:!0});var St=c(j);v=l(St,"A",{id:!0,class:!0,href:!0});var ue=c(v);rt=l(ue,"SPAN",{});var ye=c(rt);d(B.$$.fragment,ye),ye.forEach(e),ue.forEach(e),Ct=i(St),O=l(St,"SPAN",{"data-svelte-h":!0}),h(O)!=="svelte-1ekmyfg"&&(O.textContent=Ot),St.forEach(e),ft=i(t),$=l(t,"P",{"data-svelte-h":!0}),h($)!=="svelte-1pmbx05"&&($.innerHTML=te),Mt=i(t),d(x.$$.fragment,t),wt=i(t),F=l(t,"P",{"data-svelte-h":!0}),h(F)!=="svelte-1x0g0bv"&&(F.innerHTML=ee),Jt=i(t),W=l(t,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1myfka1"&&(W.innerHTML=se),jt=i(t),tt=l(t,"UL",{});var fe=c(tt);E=l(fe,"LI",{});var Xt=c(E);et=l(Xt,"P",{"data-svelte-h":!0}),h(et)!=="svelte-8bmxp4"&&(et.innerHTML=ae),Yt=i(Xt),d(H.$$.fragment,Xt),Xt.forEach(e),fe.forEach(e),Tt=i(t),C=l(t,"P",{"data-svelte-h":!0}),h(C)!=="svelte-evo4u9"&&(C.innerHTML=le),bt=i(t),Z=l(t,"UL",{});var Bt=c(Z);Y=l(Bt,"LI",{});var $t=c(Y);st=l($t,"P",{"data-svelte-h":!0}),h(st)!=="svelte-14x5nlf"&&(st.innerHTML=ne),Nt=i($t),d(N.$$.fragment,$t),$t.forEach(e),qt=i(Bt),q=l(Bt,"LI",{});var xt=c(q);at=l(xt,"P",{"data-svelte-h":!0}),h(at)!=="svelte-1abwu1e"&&(at.innerHTML=oe),zt=i(xt),d(z.$$.fragment,xt),xt.forEach(e),Bt.forEach(e),Ut=i(t),T=l(t,"H2",{class:!0});var Ft=c(T);k=l(Ft,"A",{id:!0,class:!0,href:!0});var Me=c(k);pt=l(Me,"SPAN",{});var we=c(pt);d(V.$$.fragment,we),we.forEach(e),Me.forEach(e),Vt=i(Ft),lt=l(Ft,"SPAN",{"data-svelte-h":!0}),h(lt)!=="svelte-1hjmc5p"&&(lt.textContent=ie),Ft.forEach(e),vt=i(t),L=l(t,"P",{"data-svelte-h":!0}),h(L)!=="svelte-ztp1vg"&&(L.innerHTML=re),Zt=i(t),Q=l(t,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-8fjyy1"&&(Q.innerHTML=pe),kt=i(t),d(A.$$.fragment,t),It=i(t),P=l(t,"P",{"data-svelte-h":!0}),h(P)!=="svelte-y88ov3"&&(P.textContent=ce),this.h()},h(){p(M,"name","hf:doc:metadata"),p(M,"content",JSON.stringify(ke)),p(b,"id","interact-with-the-hub-through-the-filesystem-api"),p(b,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(b,"href","#interact-with-the-hub-through-the-filesystem-api"),p(w,"class","relative group"),p(U,"id","usage"),p(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(U,"href","#usage"),p(J,"class","relative group"),p(v,"id","integrations"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#integrations"),p(j,"class","relative group"),p(k,"id","authentication"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#authentication"),p(T,"class","relative group")},m(t,s){r(document.head,M),n(t,ct,s),n(t,w,s),r(w,b),r(b,ot),g(I,ot,null),r(w,Et),r(w,D),n(t,ht,s),n(t,_,s),n(t,mt,s),n(t,J,s),r(J,U),r(U,it),g(G,it,null),r(J,Ht),r(J,K),n(t,dt,s),g(R,t,s),n(t,gt,s),n(t,S,s),n(t,ut,s),n(t,X,s),n(t,yt,s),n(t,j,s),r(j,v),r(v,rt),g(B,rt,null),r(j,Ct),r(j,O),n(t,ft,s),n(t,$,s),n(t,Mt,s),g(x,t,s),n(t,wt,s),n(t,F,s),n(t,Jt,s),n(t,W,s),n(t,jt,s),n(t,tt,s),r(tt,E),r(E,et),r(E,Yt),g(H,E,null),n(t,Tt,s),n(t,C,s),n(t,bt,s),n(t,Z,s),r(Z,Y),r(Y,st),r(Y,Nt),g(N,Y,null),r(Z,qt),r(Z,q),r(q,at),r(q,zt),g(z,q,null),n(t,Ut,s),n(t,T,s),r(T,k),r(k,pt),g(V,pt,null),r(T,Vt),r(T,lt),n(t,vt,s),n(t,L,s),n(t,Zt,s),n(t,Q,s),n(t,kt,s),g(A,t,s),n(t,It,s),n(t,P,s),_t=!0},p:je,i(t){_t||(u(I.$$.fragment,t),u(G.$$.fragment,t),u(R.$$.fragment,t),u(B.$$.fragment,t),u(x.$$.fragment,t),u(H.$$.fragment,t),u(N.$$.fragment,t),u(z.$$.fragment,t),u(V.$$.fragment,t),u(A.$$.fragment,t),_t=!0)},o(t){y(I.$$.fragment,t),y(G.$$.fragment,t),y(R.$$.fragment,t),y(B.$$.fragment,t),y(x.$$.fragment,t),y(H.$$.fragment,t),y(N.$$.fragment,t),y(z.$$.fragment,t),y(V.$$.fragment,t),y(A.$$.fragment,t),_t=!1},d(t){t&&(e(ct),e(w),e(ht),e(_),e(mt),e(J),e(dt),e(gt),e(S),e(ut),e(X),e(yt),e(j),e(ft),e($),e(Mt),e(wt),e(F),e(Jt),e(W),e(jt),e(tt),e(Tt),e(C),e(bt),e(Z),e(Ut),e(T),e(vt),e(L),e(Zt),e(Q),e(kt),e(It),e(P)),e(M),f(I),f(G),f(R,t),f(B),f(x,t),f(H),f(N),f(z),f(V),f(A,t)}}}const ke={local:"interact-with-the-hub-through-the-filesystem-api",sections:[{local:"usage",title:"Usage"},{local:"integrations",title:"Integrations"},{local:"authentication",title:"Authentication"}],title:"Interact with the Hub through the Filesystem API"};function Ie(Lt){return Te(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xe extends be{constructor(M){super(),Ue(this,M,Ie,Ze,Je,{})}}export{Xe as component};
