import{s as ro,o as po,n as Vt}from"../chunks/scheduler.8c3d61f6.js";import{S as co,i as mo,g as i,s,r as c,A as ho,h as r,f as n,c as o,j as b,u as m,x as M,k as w,y as l,a,v as h,d as u,t as g,w as f}from"../chunks/index.da70eac4.js";import{T as io}from"../chunks/Tip.1d9b8c37.js";import{D as Z}from"../chunks/Docstring.932cdff3.js";import{C as N}from"../chunks/CodeBlock.a9c4becf.js";import{E as Ts}from"../chunks/ExampleCodeBlock.c0461b09.js";import{H as C,E as uo}from"../chunks/index.ef90fe87.js";function go(W){let d,U='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){d=i("p"),d.innerHTML=U},l(y){d=r(y,"P",{"data-svelte-h":!0}),M(d)!=="svelte-1qn15hi"&&(d.innerHTML=U)},m(y,T){a(y,d,T)},p:Vt,d(y){y&&n(d)}}}function fo(W){let d,U='The examples below show some recommended generation settings, but note that all features supported in the original <a href="https://github.com/Lightricks/LTX-Video" rel="nofollow">LTX Video repository</a> are not supported in <code>diffusers</code> yet (for example, Spatio-temporal Guidance and CRF compression for image inputs). This will gradually be supported in the future. For the best possible generation quality, we recommend using the code from the original repository.';return{c(){d=i("p"),d.innerHTML=U},l(y){d=r(y,"P",{"data-svelte-h":!0}),M(d)!=="svelte-xgacl"&&(d.innerHTML=U)},m(y,T){a(y,d,T)},p:Vt,d(y){y&&n(d)}}}function Mo(W){let d,U="Examples:",y,T,_;return T=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTFRYUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMExUWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJMaWdodHJpY2tzJTJGTFRYLVZpZGVvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMHdvbWFuJTIwd2l0aCUyMGxvbmclMjBicm93biUyMGhhaXIlMjBhbmQlMjBsaWdodCUyMHNraW4lMjBzbWlsZXMlMjBhdCUyMGFub3RoZXIlMjB3b21hbiUyMHdpdGglMjBsb25nJTIwYmxvbmRlJTIwaGFpci4lMjBUaGUlMjB3b21hbiUyMHdpdGglMjBicm93biUyMGhhaXIlMjB3ZWFycyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMGhhcyUyMGElMjBzbWFsbCUyQyUyMGJhcmVseSUyMG5vdGljZWFibGUlMjBtb2xlJTIwb24lMjBoZXIlMjByaWdodCUyMGNoZWVrLiUyMFRoZSUyMGNhbWVyYSUyMGFuZ2xlJTIwaXMlMjBhJTIwY2xvc2UtdXAlMkMlMjBmb2N1c2VkJTIwb24lMjB0aGUlMjB3b21hbiUyMHdpdGglMjBicm93biUyMGhhaXIncyUyMGZhY2UuJTIwVGhlJTIwbGlnaHRpbmclMjBpcyUyMHdhcm0lMjBhbmQlMjBuYXR1cmFsJTJDJTIwbGlrZWx5JTIwZnJvbSUyMHRoZSUyMHNldHRpbmclMjBzdW4lMkMlMjBjYXN0aW5nJTIwYSUyMHNvZnQlMjBnbG93JTIwb24lMjB0aGUlMjBzY2VuZS4lMjBUaGUlMjBzY2VuZSUyMGFwcGVhcnMlMjB0byUyMGJlJTIwcmVhbC1saWZlJTIwZm9vdGFnZSUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMndvcnN0JTIwcXVhbGl0eSUyQyUyMGluY29uc2lzdGVudCUyMG1vdGlvbiUyQyUyMGJsdXJyeSUyQyUyMGppdHRlcnklMkMlMjBkaXN0b3J0ZWQlMjIlMEElMEF2aWRlbyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3MDQlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q0ODAlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYxJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDI0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = LTXPipeline.from_pretrained(<span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A woman with long brown hair and light skin smiles at another woman with long blonde hair. The woman with brown hair wears a black jacket and has a small, barely noticeable mole on her right cheek. The camera angle is a close-up, focused on the woman with brown hair&#x27;s face. The lighting is warm and natural, likely from the setting sun, casting a soft glow on the scene. The scene appears to be real-life footage&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;worst quality, inconsistent motion, blurry, jittery, distorted&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">704</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">161</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=U,y=s(),c(T.$$.fragment)},l(p){d=r(p,"P",{"data-svelte-h":!0}),M(d)!=="svelte-kvfsh7"&&(d.textContent=U),y=o(p),m(T.$$.fragment,p)},m(p,J){a(p,d,J),a(p,y,J),h(T,p,J),_=!0},p:Vt,i(p){_||(u(T.$$.fragment,p),_=!0)},o(p){g(T.$$.fragment,p),_=!1},d(p){p&&(n(d),n(y)),f(T,p)}}}function yo(W){let d,U="Examples:",y,T,_;return T=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTFRYSW1hZ2VUb1ZpZGVvUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBMVFhJbWFnZVRvVmlkZW9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyTGlnaHRyaWNrcyUyRkxUWC1WaWRlbyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZhLXItci1vLXclMkZ0aW55LW1lbWUtZGF0YXNldC1jYXB0aW9uZWQlMkZyZXNvbHZlJTJGbWFpbiUyRmltYWdlcyUyRjgucG5nJTIyJTBBKSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjB5b3VuZyUyMGdpcmwlMjBzdGFuZHMlMjBjYWxtbHklMjBpbiUyMHRoZSUyMGZvcmVncm91bmQlMkMlMjBsb29raW5nJTIwZGlyZWN0bHklMjBhdCUyMHRoZSUyMGNhbWVyYSUyQyUyMGFzJTIwYSUyMGhvdXNlJTIwZmlyZSUyMHJhZ2VzJTIwaW4lMjB0aGUlMjBiYWNrZ3JvdW5kLiUyMEZsYW1lcyUyMGVuZ3VsZiUyMHRoZSUyMHN0cnVjdHVyZSUyQyUyMHdpdGglMjBzbW9rZSUyMGJpbGxvd2luZyUyMGludG8lMjB0aGUlMjBhaXIuJTIwRmlyZWZpZ2h0ZXJzJTIwaW4lMjBwcm90ZWN0aXZlJTIwZ2VhciUyMHJ1c2glMjB0byUyMHRoZSUyMHNjZW5lJTJDJTIwYSUyMGZpcmUlMjB0cnVjayUyMGxhYmVsZWQlMjAnMzgnJTIwdmlzaWJsZSUyMGJlaGluZCUyMHRoZW0uJTIwVGhlJTIwZ2lybCdzJTIwbmV1dHJhbCUyMGV4cHJlc3Npb24lMjBjb250cmFzdHMlMjBzaGFycGx5JTIwd2l0aCUyMHRoZSUyMGNoYW9zJTIwb2YlMjB0aGUlMjBmaXJlJTJDJTIwY3JlYXRpbmclMjBhJTIwcG9pZ25hbnQlMjBhbmQlMjBlbW90aW9uYWxseSUyMGNoYXJnZWQlMjBzY2VuZS4lMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJ3b3JzdCUyMHF1YWxpdHklMkMlMjBpbmNvbnNpc3RlbnQlMjBtb3Rpb24lMkMlMjBibHVycnklMkMlMjBqaXR0ZXJ5JTJDJTIwZGlzdG9ydGVkJTIyJTBBJTBBdmlkZW8lMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDcwNCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDQ4MCUyQyUwQSUyMCUyMCUyMCUyMG51bV9mcmFtZXMlM0QxNjElMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEEpLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fdmlkZW8odmlkZW8lMkMlMjAlMjJvdXRwdXQubXA0JTIyJTJDJTIwZnBzJTNEMjQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXImageToVideoPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = LTXImageToVideoPipeline.from_pretrained(<span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/a-r-r-o-w/tiny-meme-dataset-captioned/resolve/main/images/8.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A young girl stands calmly in the foreground, looking directly at the camera, as a house fire rages in the background. Flames engulf the structure, with smoke billowing into the air. Firefighters in protective gear rush to the scene, a fire truck labeled &#x27;38&#x27; visible behind them. The girl&#x27;s neutral expression contrasts sharply with the chaos of the fire, creating a poignant and emotionally charged scene.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;worst quality, inconsistent motion, blurry, jittery, distorted&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">704</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">161</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=U,y=s(),c(T.$$.fragment)},l(p){d=r(p,"P",{"data-svelte-h":!0}),M(d)!=="svelte-kvfsh7"&&(d.textContent=U),y=o(p),m(T.$$.fragment,p)},m(p,J){a(p,d,J),a(p,y,J),h(T,p,J),_=!0},p:Vt,i(p){_||(u(T.$$.fragment,p),_=!0)},o(p){g(T.$$.fragment,p),_=!1},d(p){p&&(n(d),n(y)),f(T,p)}}}function To(W){let d,U="Examples:",y,T,_;return T=new N({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.pipelines.ltx.pipeline_ltx_condition <span class="hljs-keyword">import</span> LTXConditionPipeline, LTXVideoCondition
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = LTXConditionPipeline.from_pretrained(<span class="hljs-string">&quot;Lightricks/LTX-Video-0.9.5&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load input image and video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video = load_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cosmos/cosmos-video2world-input-vid.mp4&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cosmos/cosmos-video2world-input.jpg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create conditioning objects</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>condition1 = LTXVideoCondition(
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    frame_index=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>condition2 = LTXVideoCondition(
<span class="hljs-meta">... </span>    video=video,
<span class="hljs-meta">... </span>    frame_index=<span class="hljs-number">80</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;The video depicts a long, straight highway stretching into the distance, flanked by metal guardrails. The road is divided into multiple lanes, with a few vehicles visible in the far distance. The surrounding landscape features dry, grassy fields on one side and rolling hills on the other. The sky is mostly clear with a few scattered clouds, suggesting a bright, sunny day. And then the camera switch to a winding mountain road covered in snow, with a single vehicle traveling along it. The road is flanked by steep, rocky cliffs and sparse vegetation. The landscape is characterized by rugged terrain and a river visible in the distance. The scene captures the solitude and beauty of a winter drive through a mountainous region.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;worst quality, inconsistent motion, blurry, jittery, distorted&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Text-only conditioning is also supported without the need to pass \`conditions\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    conditions=[condition1, condition2],
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">161</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">40</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=U,y=s(),c(T.$$.fragment)},l(p){d=r(p,"P",{"data-svelte-h":!0}),M(d)!=="svelte-kvfsh7"&&(d.textContent=U),y=o(p),m(T.$$.fragment,p)},m(p,J){a(p,d,J),a(p,y,J),h(T,p,J),_=!0},p:Vt,i(p){_||(u(T.$$.fragment,p),_=!0)},o(p){g(T.$$.fragment,p),_=!1},d(p){p&&(n(d),n(y)),f(T,p)}}}function _o(W){let d,U,y,T,_,p,J,_s='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/> <img alt="MPS" src="https://img.shields.io/badge/MPS-000000?style=flat&amp;logo=apple&amp;logoColor=white%22"/>',xt,oe,bs='<a href="https://huggingface.co/Lightricks/LTX-Video" rel="nofollow">LTX Video</a> is the first DiT-based video generation model capable of generating high-quality videos in real-time. It produces 24 FPS videos at a 768x512 resolution faster than they can be watched. Trained on a large-scale dataset of diverse videos, the model generates high-resolution videos with realistic and varied content. We provide a model for both text-to-video as well as image + text-to-video usecases.',Wt,H,Ct,ae,ws="Available models:",kt,le,Js='<thead><tr><th align="center">Model name</th> <th align="center">Recommended dtype</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/Lightricks/LTX-Video/blob/main/ltx-video-2b-v0.9.safetensors" rel="nofollow"><code>LTX Video 2B 0.9.0</code></a></td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Lightricks/LTX-Video/blob/main/ltx-video-2b-v0.9.1.safetensors" rel="nofollow"><code>LTX Video 2B 0.9.1</code></a></td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Lightricks/LTX-Video/blob/main/ltx-video-2b-v0.9.5.safetensors" rel="nofollow"><code>LTX Video 2B 0.9.5</code></a></td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Lightricks/LTX-Video/blob/main/ltxv-13b-0.9.7-dev.safetensors" rel="nofollow"><code>LTX Video 13B 0.9.7</code></a></td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Lightricks/LTX-Video/blob/main/ltxv-13b-0.9.7-distilled.safetensors" rel="nofollow"><code>LTX Video 13B 0.9.7 (distilled)</code></a></td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Lightricks/LTX-Video/blob/main/ltxv-spatial-upscaler-0.9.7.safetensors" rel="nofollow"><code>LTX Video Spatial Upscaler 0.9.7</code></a></td> <td align="center"><code>torch.bfloat16</code></td></tr></tbody>',Lt,ie,Us="Note: The recommended dtype is for the transformer component. The VAE and text encoders can be either <code>torch.float32</code>, <code>torch.bfloat16</code> or <code>torch.float16</code> but the recommended dtype is <code>torch.bfloat16</code> as used in the original repository.",Rt,re,Nt,de,vs='For the best results, it is recommended to follow the guidelines mentioned in the official LTX Video <a href="https://github.com/Lightricks/LTX-Video" rel="nofollow">repository</a>.',Ft,pe,js="<li>Some variants of LTX Video are guidance-distilled. For guidance-distilled models, <code>guidance_scale</code> must be set to <code>1.0</code>. For any other models, <code>guidance_scale</code> should be set higher (e.g., <code>5.0</code>) for good generation quality.</li> <li>For variants with a timestep-aware VAE (LTXV 0.9.1 and above), it is recommended to set <code>decode_timestep</code> to <code>0.05</code> and <code>image_cond_noise_scale</code> to <code>0.025</code>.</li> <li>For variants that support interpolation between multiple conditioning images and videos (LTXV 0.9.5 and above), it is recommended to use similar looking images/videos for the best results. High divergence between the conditionings may lead to abrupt transitions in the generated video.</li>",Yt,E,Ht,ce,Et,me,Zs="LTX Video 0.9.7 comes with a spatial latent upscaler and a 13B parameter transformer. The inference involves generating a low resolution video first, which is very fast, followed by upscaling and refining the generated video.",zt,he,Qt,ue,$t,ge,Gs="The same example as above can be used with the exception of the <code>guidance_scale</code> parameter. The model is both guidance and timestep distilled in order to speedup generation. It requires <code>guidance_scale</code> to be set to <code>1.0</code>. Additionally, to benefit from the timestep distillation, <code>num_inference_steps</code> can be set between <code>4</code> and <code>10</code> for good generation quality.",St,fe,Is="Additionally, custom timesteps can also be used for conditioning the generation. The authors recommend using the following timesteps for best results:",Pt,Me,Xs="<li>Base model inference to prepare for upscaling: <code>[1000, 993, 987, 981, 975, 909, 725, 0.03]</code></li> <li>Upscaling: <code>[1000, 909, 725, 421, 0]</code></li>",At,z,it,Bs="Full example",Cn,ye,Dt,Te,qt,_e,Vs="Loading the original LTX Video checkpoints is also possible with <code>~ModelMixin.from_single_file</code>. We recommend using <code>from_single_file</code> for the Lightricks series of models, as they plan to release multiple models in the future in the single file format.",Ot,be,Kt,we,xs="Alternatively, the pipeline can be used to load the weights with <code>~FromSingleFileMixin.from_single_file</code>.",en,Je,tn,Ue,Ws='Loading <a href="https://huggingface.co/city96/LTX-Video-gguf" rel="nofollow">LTX GGUF checkpoints</a> are also supported:',nn,ve,sn,je,Cs='Make sure to read the <a href="../../quantization/gguf">documentation on GGUF</a> to learn more about our GGUF support.',on,Ze,ks='Loading and running inference with <a href="https://huggingface.co/Lightricks/LTX-Video/blob/main/ltx-video-2b-v0.9.1.safetensors" rel="nofollow">LTX Video 0.9.1</a> weights.',an,Ge,ln,Ie,Ls='Refer to <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/cogvideox#memory-optimization" rel="nofollow">this section</a> to learn more about optimizing memory consumption.',rn,Xe,dn,Be,Rs="Quantization helps reduce the memory requirements of very large models by storing model weights in a lower precision data type. However, quantization may have varying impact on video quality depending on the video model.",pn,Ve,Ns='Refer to the <a href="../../quantization/overview">Quantization</a> overview to learn more about supported quantization backends and selecting a quantization backend that supports your use case. The example below demonstrates how to load a quantized <a href="/docs/diffusers/main/en/api/pipelines/ltx_video#diffusers.LTXPipeline">LTXPipeline</a> for inference with bitsandbytes.',cn,xe,mn,We,hn,G,Ce,kn,rt,Fs="Pipeline for text-to-video generation.",Ln,dt,Ys='Reference: <a href="https://github.com/Lightricks/LTX-Video" rel="nofollow">https://github.com/Lightricks/LTX-Video</a>',Rn,k,ke,Nn,pt,Hs="Function invoked when calling the pipeline for generation.",Fn,Q,Yn,$,Le,Hn,ct,Es="Encodes the prompt into text encoder hidden states.",un,Re,gn,I,Ne,En,mt,zs="Pipeline for image-to-video generation.",zn,ht,Qs='Reference: <a href="https://github.com/Lightricks/LTX-Video" rel="nofollow">https://github.com/Lightricks/LTX-Video</a>',Qn,L,Fe,$n,ut,$s="Function invoked when calling the pipeline for generation.",Sn,S,Pn,P,Ye,An,gt,Ss="Encodes the prompt into text encoder hidden states.",fn,He,Mn,v,Ee,Dn,ft,Ps="Pipeline for text/image/video-to-video generation.",qn,Mt,As='Reference: <a href="https://github.com/Lightricks/LTX-Video" rel="nofollow">https://github.com/Lightricks/LTX-Video</a>',On,R,ze,Kn,yt,Ds="Function invoked when calling the pipeline for generation.",es,A,ts,D,Qe,ns,Tt,qs=`Add timestep-dependent noise to the hard-conditioning latents. This helps with motion continuity, especially
when conditioned on a single frame.`,ss,q,$e,os,_t,Os="Encodes the prompt into text encoder hidden states.",as,O,Se,ls,bt,Ks="Trim a conditioning sequence to the allowed number of frames.",yn,Pe,Tn,j,Ae,is,wt,De,rs,K,qe,ds,Jt,eo=`Applies Adaptive Instance Normalization (AdaIN) to a latent tensor based on statistics from a reference latent
tensor.`,ps,ee,Oe,cs,Ut,to=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,ms,te,Ke,hs,vt,no=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,us,ne,et,gs,jt,so=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,fs,se,tt,Ms,Zt,oo=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,_n,nt,bn,F,st,ys,Gt,ao="Output class for LTX pipelines.",wn,ot,Jn,Bt,Un;return _=new C({props:{title:"LTX Video",local:"ltx-video",headingTag:"h1"}}),H=new io({props:{$$slots:{default:[go]},$$scope:{ctx:W}}}),re=new C({props:{title:"Recommended settings for generation",local:"recommended-settings-for-generation",headingTag:"h2"}}),E=new io({props:{warning:!0,$$slots:{default:[fo]},$$scope:{ctx:W}}}),ce=new C({props:{title:"Using LTX Video 13B 0.9.7",local:"using-ltx-video-13b-097",headingTag:"h2"}}),he=new N({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXConditionPipeline, LTXLatentUpsamplePipeline
<span class="hljs-keyword">from</span> diffusers.pipelines.ltx.pipeline_ltx_condition <span class="hljs-keyword">import</span> LTXVideoCondition
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video

pipe = LTXConditionPipeline.from_pretrained(<span class="hljs-string">&quot;Lightricks/LTX-Video-0.9.7-dev&quot;</span>, torch_dtype=torch.bfloat16)
pipe_upsample = LTXLatentUpsamplePipeline.from_pretrained(<span class="hljs-string">&quot;Lightricks/ltxv-spatial-upscaler-0.9.7&quot;</span>, vae=pipe.vae, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe_upsample.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.vae.enable_tiling()

<span class="hljs-keyword">def</span> <span class="hljs-title function_">round_to_nearest_resolution_acceptable_by_vae</span>(<span class="hljs-params">height, width</span>):
    height = height - (height % pipe.vae_temporal_compression_ratio)
    width = width - (width % pipe.vae_temporal_compression_ratio)
    <span class="hljs-keyword">return</span> height, width

video = load_video(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cosmos/cosmos-video2world-input-vid.mp4&quot;</span>
)[:<span class="hljs-number">21</span>]  <span class="hljs-comment"># Use only the first 21 frames as conditioning</span>
condition1 = LTXVideoCondition(video=video, frame_index=<span class="hljs-number">0</span>)

prompt = <span class="hljs-string">&quot;The video depicts a winding mountain road covered in snow, with a single vehicle traveling along it. The road is flanked by steep, rocky cliffs and sparse vegetation. The landscape is characterized by rugged terrain and a river visible in the distance. The scene captures the solitude and beauty of a winter drive through a mountainous region.&quot;</span>
negative_prompt = <span class="hljs-string">&quot;worst quality, inconsistent motion, blurry, jittery, distorted&quot;</span>
expected_height, expected_width = <span class="hljs-number">768</span>, <span class="hljs-number">1152</span>
downscale_factor = <span class="hljs-number">2</span> / <span class="hljs-number">3</span>
num_frames = <span class="hljs-number">161</span>

<span class="hljs-comment"># Part 1. Generate video at smaller resolution</span>
<span class="hljs-comment"># Text-only conditioning is also supported without the need to pass \`conditions\`</span>
downscaled_height, downscaled_width = <span class="hljs-built_in">int</span>(expected_height * downscale_factor), <span class="hljs-built_in">int</span>(expected_width * downscale_factor)
downscaled_height, downscaled_width = round_to_nearest_resolution_acceptable_by_vae(downscaled_height, downscaled_width)
latents = pipe(
    conditions=[condition1],
    prompt=prompt,
    negative_prompt=negative_prompt,
    width=downscaled_width,
    height=downscaled_height,
    num_frames=num_frames,
    num_inference_steps=<span class="hljs-number">30</span>,
    decode_timestep=<span class="hljs-number">0.05</span>,
    decode_noise_scale=<span class="hljs-number">0.025</span>,
    image_cond_noise_scale=<span class="hljs-number">0.0</span>,
    guidance_scale=<span class="hljs-number">5.0</span>,
    guidance_rescale=<span class="hljs-number">0.7</span>,
    generator=torch.Generator().manual_seed(<span class="hljs-number">0</span>),
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).frames

<span class="hljs-comment"># Part 2. Upscale generated video using latent upsampler with fewer inference steps</span>
<span class="hljs-comment"># The available latent upsampler upscales the height/width by 2x</span>
upscaled_height, upscaled_width = downscaled_height * <span class="hljs-number">2</span>, downscaled_width * <span class="hljs-number">2</span>
upscaled_latents = pipe_upsample(
    latents=latents,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>
).frames

<span class="hljs-comment"># Part 3. Denoise the upscaled video with few steps to improve texture (optional, but recommended)</span>
video = pipe(
    conditions=[condition1],
    prompt=prompt,
    negative_prompt=negative_prompt,
    width=upscaled_width,
    height=upscaled_height,
    num_frames=num_frames,
    denoise_strength=<span class="hljs-number">0.4</span>,  <span class="hljs-comment"># Effectively, 4 inference steps out of 10</span>
    num_inference_steps=<span class="hljs-number">10</span>,
    latents=upscaled_latents,
    decode_timestep=<span class="hljs-number">0.05</span>,
    decode_noise_scale=<span class="hljs-number">0.025</span>,
    image_cond_noise_scale=<span class="hljs-number">0.0</span>,
    guidance_scale=<span class="hljs-number">5.0</span>,
    guidance_rescale=<span class="hljs-number">0.7</span>,
    generator=torch.Generator().manual_seed(<span class="hljs-number">0</span>),
    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
).frames[<span class="hljs-number">0</span>]

<span class="hljs-comment"># Part 4. Downscale the video to the expected resolution</span>
video = [frame.resize((expected_width, expected_height)) <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video]

export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),ue=new C({props:{title:"Using LTX Video 0.9.7 (distilled)",local:"using-ltx-video-097-distilled",headingTag:"h2"}}),ye=new N({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXConditionPipeline, LTXLatentUpsamplePipeline
<span class="hljs-keyword">from</span> diffusers.pipelines.ltx.pipeline_ltx_condition <span class="hljs-keyword">import</span> LTXVideoCondition
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video

pipe = LTXConditionPipeline.from_pretrained(<span class="hljs-string">&quot;Lightricks/LTX-Video-0.9.7-distilled&quot;</span>, torch_dtype=torch.bfloat16)
pipe_upsample = LTXLatentUpsamplePipeline.from_pretrained(<span class="hljs-string">&quot;Lightricks/ltxv-spatial-upscaler-0.9.7&quot;</span>, vae=pipe.vae, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe_upsample.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.vae.enable_tiling()

<span class="hljs-keyword">def</span> <span class="hljs-title function_">round_to_nearest_resolution_acceptable_by_vae</span>(<span class="hljs-params">height, width</span>):
    height = height - (height % pipe.vae_temporal_compression_ratio)
    width = width - (width % pipe.vae_temporal_compression_ratio)
    <span class="hljs-keyword">return</span> height, width

prompt = <span class="hljs-string">&quot;artistic anatomical 3d render, utlra quality, human half full male body with transparent skin revealing structure instead of organs, muscular, intricate creative patterns, monochromatic with backlighting, lightning mesh, scientific concept art, blending biology with botany, surreal and ethereal quality, unreal engine 5, ray tracing, ultra realistic, 16K UHD, rich details. camera zooms out in a rotating fashion&quot;</span>
negative_prompt = <span class="hljs-string">&quot;worst quality, inconsistent motion, blurry, jittery, distorted&quot;</span>
expected_height, expected_width = <span class="hljs-number">768</span>, <span class="hljs-number">1152</span>
downscale_factor = <span class="hljs-number">2</span> / <span class="hljs-number">3</span>
num_frames = <span class="hljs-number">161</span>

<span class="hljs-comment"># Part 1. Generate video at smaller resolution</span>
downscaled_height, downscaled_width = <span class="hljs-built_in">int</span>(expected_height * downscale_factor), <span class="hljs-built_in">int</span>(expected_width * downscale_factor)
downscaled_height, downscaled_width = round_to_nearest_resolution_acceptable_by_vae(downscaled_height, downscaled_width)
latents = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    width=downscaled_width,
    height=downscaled_height,
    num_frames=num_frames,
    timesteps=[<span class="hljs-number">1000</span>, <span class="hljs-number">993</span>, <span class="hljs-number">987</span>, <span class="hljs-number">981</span>, <span class="hljs-number">975</span>, <span class="hljs-number">909</span>, <span class="hljs-number">725</span>, <span class="hljs-number">0.03</span>],
    decode_timestep=<span class="hljs-number">0.05</span>,
    decode_noise_scale=<span class="hljs-number">0.025</span>,
    image_cond_noise_scale=<span class="hljs-number">0.0</span>,
    guidance_scale=<span class="hljs-number">1.0</span>,
    guidance_rescale=<span class="hljs-number">0.7</span>,
    generator=torch.Generator().manual_seed(<span class="hljs-number">0</span>),
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).frames

<span class="hljs-comment"># Part 2. Upscale generated video using latent upsampler with fewer inference steps</span>
<span class="hljs-comment"># The available latent upsampler upscales the height/width by 2x</span>
upscaled_height, upscaled_width = downscaled_height * <span class="hljs-number">2</span>, downscaled_width * <span class="hljs-number">2</span>
upscaled_latents = pipe_upsample(
    latents=latents,
    adain_factor=<span class="hljs-number">1.0</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>
).frames

<span class="hljs-comment"># Part 3. Denoise the upscaled video with few steps to improve texture (optional, but recommended)</span>
video = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    width=upscaled_width,
    height=upscaled_height,
    num_frames=num_frames,
    denoise_strength=<span class="hljs-number">0.999</span>,  <span class="hljs-comment"># Effectively, 4 inference steps out of 5</span>
    timesteps=[<span class="hljs-number">1000</span>, <span class="hljs-number">909</span>, <span class="hljs-number">725</span>, <span class="hljs-number">421</span>, <span class="hljs-number">0</span>],
    latents=upscaled_latents,
    decode_timestep=<span class="hljs-number">0.05</span>,
    decode_noise_scale=<span class="hljs-number">0.025</span>,
    image_cond_noise_scale=<span class="hljs-number">0.0</span>,
    guidance_scale=<span class="hljs-number">1.0</span>,
    guidance_rescale=<span class="hljs-number">0.7</span>,
    generator=torch.Generator().manual_seed(<span class="hljs-number">0</span>),
    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
).frames[<span class="hljs-number">0</span>]

<span class="hljs-comment"># Part 4. Downscale the video to the expected resolution</span>
video = [frame.resize((expected_width, expected_height)) <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> video]

export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),Te=new C({props:{title:"Loading Single Files",local:"loading-single-files",headingTag:"h2"}}),be=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b2VuY29kZXJLTExUWFZpZGVvJTJDJTIwTFRYSW1hZ2VUb1ZpZGVvUGlwZWxpbmUlMkMlMjBMVFhWaWRlb1RyYW5zZm9ybWVyM0RNb2RlbCUwQSUwQSUyMyUyMCU2MHNpbmdsZV9maWxlX3VybCU2MCUyMGNvdWxkJTIwYWxzbyUyMGJlJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRkxpZ2h0cmlja3MlMkZMVFgtVmlkZW8lMkZsdHgtdmlkZW8tMmItdjAuOS4xLnNhZmV0ZW5zb3JzJTBBc2luZ2xlX2ZpbGVfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRkxpZ2h0cmlja3MlMkZMVFgtVmlkZW8lMkZsdHgtdmlkZW8tMmItdjAuOS5zYWZldGVuc29ycyUyMiUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwTFRYVmlkZW9UcmFuc2Zvcm1lcjNETW9kZWwuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjBzaW5nbGVfZmlsZV91cmwlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQXZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyS0xMVFhWaWRlby5mcm9tX3NpbmdsZV9maWxlKHNpbmdsZV9maWxlX3VybCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMExUWEltYWdlVG9WaWRlb1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJMaWdodHJpY2tzJTJGTFRYLVZpZGVvJTIyJTJDJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lciUyQyUyMHZhZSUzRHZhZSUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBJTBBJTIzJTIwLi4uJTIwaW5mZXJlbmNlJTIwY29kZSUyMC4uLg==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKLLTXVideo, LTXImageToVideoPipeline, LTXVideoTransformer3DModel

<span class="hljs-comment"># \`single_file_url\` could also be https://huggingface.co/Lightricks/LTX-Video/ltx-video-2b-v0.9.1.safetensors</span>
single_file_url = <span class="hljs-string">&quot;https://huggingface.co/Lightricks/LTX-Video/ltx-video-2b-v0.9.safetensors&quot;</span>
transformer = LTXVideoTransformer3DModel.from_single_file(
  single_file_url, torch_dtype=torch.bfloat16
)
vae = AutoencoderKLLTXVideo.from_single_file(single_file_url, torch_dtype=torch.bfloat16)
pipe = LTXImageToVideoPipeline.from_pretrained(
  <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, transformer=transformer, vae=vae, torch_dtype=torch.bfloat16
)

<span class="hljs-comment"># ... inference code ...</span>`,wrap:!1}}),Je=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTFRYSW1hZ2VUb1ZpZGVvUGlwZWxpbmUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMkMlMjBUNVRva2VuaXplciUwQSUwQXNpbmdsZV9maWxlX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZMaWdodHJpY2tzJTJGTFRYLVZpZGVvJTJGbHR4LXZpZGVvLTJiLXYwLjkuc2FmZXRlbnNvcnMlMjIlMEF0ZXh0X2VuY29kZXIlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIyTGlnaHRyaWNrcyUyRkxUWC1WaWRlbyUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBdG9rZW5pemVyJTIwJTNEJTIwVDVUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMkxpZ2h0cmlja3MlMkZMVFgtVmlkZW8lMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBMVFhJbWFnZVRvVmlkZW9QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMHNpbmdsZV9maWxlX3VybCUyQyUyMHRleHRfZW5jb2RlciUzRHRleHRfZW5jb2RlciUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXImageToVideoPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel, T5Tokenizer

single_file_url = <span class="hljs-string">&quot;https://huggingface.co/Lightricks/LTX-Video/ltx-video-2b-v0.9.safetensors&quot;</span>
text_encoder = T5EncoderModel.from_pretrained(
  <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, torch_dtype=torch.bfloat16
)
tokenizer = T5Tokenizer.from_pretrained(
  <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>, torch_dtype=torch.bfloat16
)
pipe = LTXImageToVideoPipeline.from_single_file(
  single_file_url, text_encoder=text_encoder, tokenizer=tokenizer, torch_dtype=torch.bfloat16
)`,wrap:!1}}),ve=new N({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXPipeline, LTXVideoTransformer3DModel, GGUFQuantizationConfig

ckpt_path = (
    <span class="hljs-string">&quot;https://huggingface.co/city96/LTX-Video-gguf/blob/main/ltx-video-2b-v0.9-Q3_K_S.gguf&quot;</span>
)
transformer = LTXVideoTransformer3DModel.from_single_file(
    ckpt_path,
    quantization_config=GGUFQuantizationConfig(compute_dtype=torch.bfloat16),
    torch_dtype=torch.bfloat16,
)
pipe = LTXPipeline.from_pretrained(
    <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>,
    transformer=transformer,
    torch_dtype=torch.bfloat16,
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A woman with long brown hair and light skin smiles at another woman with long blonde hair. The woman with brown hair wears a black jacket and has a small, barely noticeable mole on her right cheek. The camera angle is a close-up, focused on the woman with brown hair&#x27;s face. The lighting is warm and natural, likely from the setting sun, casting a soft glow on the scene. The scene appears to be real-life footage&quot;</span>
negative_prompt = <span class="hljs-string">&quot;worst quality, inconsistent motion, blurry, jittery, distorted&quot;</span>

video = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    width=<span class="hljs-number">704</span>,
    height=<span class="hljs-number">480</span>,
    num_frames=<span class="hljs-number">161</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;output_gguf_ltx.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),Ge=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTFRYUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMExUWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJhLXItci1vLXclMkZMVFgtVmlkZW8tMC45LjEtZGlmZnVzZXJzJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMHdvbWFuJTIwd2l0aCUyMGxvbmclMjBicm93biUyMGhhaXIlMjBhbmQlMjBsaWdodCUyMHNraW4lMjBzbWlsZXMlMjBhdCUyMGFub3RoZXIlMjB3b21hbiUyMHdpdGglMjBsb25nJTIwYmxvbmRlJTIwaGFpci4lMjBUaGUlMjB3b21hbiUyMHdpdGglMjBicm93biUyMGhhaXIlMjB3ZWFycyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMGhhcyUyMGElMjBzbWFsbCUyQyUyMGJhcmVseSUyMG5vdGljZWFibGUlMjBtb2xlJTIwb24lMjBoZXIlMjByaWdodCUyMGNoZWVrLiUyMFRoZSUyMGNhbWVyYSUyMGFuZ2xlJTIwaXMlMjBhJTIwY2xvc2UtdXAlMkMlMjBmb2N1c2VkJTIwb24lMjB0aGUlMjB3b21hbiUyMHdpdGglMjBicm93biUyMGhhaXIncyUyMGZhY2UuJTIwVGhlJTIwbGlnaHRpbmclMjBpcyUyMHdhcm0lMjBhbmQlMjBuYXR1cmFsJTJDJTIwbGlrZWx5JTIwZnJvbSUyMHRoZSUyMHNldHRpbmclMjBzdW4lMkMlMjBjYXN0aW5nJTIwYSUyMHNvZnQlMjBnbG93JTIwb24lMjB0aGUlMjBzY2VuZS4lMjBUaGUlMjBzY2VuZSUyMGFwcGVhcnMlMjB0byUyMGJlJTIwcmVhbC1saWZlJTIwZm9vdGFnZSUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMndvcnN0JTIwcXVhbGl0eSUyQyUyMGluY29uc2lzdGVudCUyMG1vdGlvbiUyQyUyMGJsdXJyeSUyQyUyMGppdHRlcnklMkMlMjBkaXN0b3J0ZWQlMjIlMEElMEF2aWRlbyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYxJTJDJTBBJTIwJTIwJTIwJTIwZGVjb2RlX3RpbWVzdGVwJTNEMC4wMyUyQyUwQSUyMCUyMCUyMCUyMGRlY29kZV9ub2lzZV9zY2FsZSUzRDAuMDI1JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDI0KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = LTXPipeline.from_pretrained(<span class="hljs-string">&quot;a-r-r-o-w/LTX-Video-0.9.1-diffusers&quot;</span>, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A woman with long brown hair and light skin smiles at another woman with long blonde hair. The woman with brown hair wears a black jacket and has a small, barely noticeable mole on her right cheek. The camera angle is a close-up, focused on the woman with brown hair&#x27;s face. The lighting is warm and natural, likely from the setting sun, casting a soft glow on the scene. The scene appears to be real-life footage&quot;</span>
negative_prompt = <span class="hljs-string">&quot;worst quality, inconsistent motion, blurry, jittery, distorted&quot;</span>

video = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    width=<span class="hljs-number">768</span>,
    height=<span class="hljs-number">512</span>,
    num_frames=<span class="hljs-number">161</span>,
    decode_timestep=<span class="hljs-number">0.03</span>,
    decode_noise_scale=<span class="hljs-number">0.025</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),Xe=new C({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),xe=new N({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig, LTXVideoTransformer3DModel, LTXPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> BitsAndBytesConfig, T5EncoderModel

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
text_encoder_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
transformer_8bit = LTXVideoTransformer3DModel.from_pretrained(
    <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

pipeline = LTXPipeline.from_pretrained(
    <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>,
    text_encoder=text_encoder_8bit,
    transformer=transformer_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
)

prompt = <span class="hljs-string">&quot;A detailed wooden toy ship with intricately carved masts and sails is seen gliding smoothly over a plush, blue carpet that mimics the waves of the sea. The ship&#x27;s hull is painted a rich brown, with tiny windows. The carpet, soft and textured, provides a perfect backdrop, resembling an oceanic expanse. Surrounding the ship are various other toys and children&#x27;s items, hinting at a playful environment. The scene captures the innocence and imagination of childhood, with the toy ship&#x27;s journey symbolizing endless adventures in a whimsical, indoor setting.&quot;</span>
video = pipeline(prompt=prompt, num_frames=<span class="hljs-number">161</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;ship.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),We=new C({props:{title:"LTXPipeline",local:"diffusers.LTXPipeline",headingTag:"h2"}}),Ce=new Z({props:{name:"class diffusers.LTXPipeline",anchor:"diffusers.LTXPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLLTXVideo"},{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": LTXVideoTransformer3DModel"}],parametersDescription:[{anchor:"diffusers.LTXPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/ltx_video_transformer3d#diffusers.LTXVideoTransformer3DModel">LTXVideoTransformer3DModel</a>) &#x2014;
Conditional Transformer architecture to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.LTXPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.LTXPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl_ltx_video#diffusers.AutoencoderKLLTXVideo">AutoencoderKLLTXVideo</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.LTXPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.LTXPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.LTXPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx.py#L170"}}),ke=new Z({props:{name:"__call__",anchor:"diffusers.LTXPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 704"},{name:"num_frames",val:": int = 161"},{name:"frame_rate",val:": int = 25"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"guidance_scale",val:": float = 3"},{name:"guidance_rescale",val:": float = 0.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decode_timestep",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"decode_noise_scale",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 128"}],parametersDescription:[{anchor:"diffusers.LTXPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.LTXPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>512</code>) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.LTXPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>704</code>) &#x2014;
The width in pixels of the generated image. This is set to 848 by default for the best results.`,name:"width"},{anchor:"diffusers.LTXPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>161</code>) &#x2014;
The number of video frames to generate`,name:"num_frames"},{anchor:"diffusers.LTXPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.LTXPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.LTXPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>3 </code>) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.LTXPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.LTXPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.LTXPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.LTXPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.LTXPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LTXPipeline.__call__.prompt_attention_mask",description:`<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for text embeddings.`,name:"prompt_attention_mask"},{anchor:"diffusers.LTXPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LTXPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.LTXPipeline.__call__.decode_timestep",description:`<strong>decode_timestep</strong> (<code>float</code>, defaults to <code>0.0</code>) &#x2014;
The timestep at which generated video is decoded.`,name:"decode_timestep"},{anchor:"diffusers.LTXPipeline.__call__.decode_noise_scale",description:`<strong>decode_noise_scale</strong> (<code>float</code>, defaults to <code>None</code>) &#x2014;
The interpolation factor between random noise and denoised latents at the decode timestep.`,name:"decode_noise_scale"},{anchor:"diffusers.LTXPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.LTXPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.ltx.LTXPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.LTXPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.LTXPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.LTXPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.LTXPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code> defaults to <code>128 </code>) &#x2014;
Maximum sequence length to use with the <code>prompt</code>.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx.py#L535",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.ltx.LTXPipelineOutput</code> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.ltx.LTXPipelineOutput</code> or <code>tuple</code></p>
`}}),Q=new Ts({props:{anchor:"diffusers.LTXPipeline.__call__.example",$$slots:{default:[Mo]},$$scope:{ctx:W}}}),Le=new Z({props:{name:"encode_prompt",anchor:"diffusers.LTXPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 128"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.LTXPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.LTXPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LTXPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.LTXPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.LTXPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LTXPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LTXPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.LTXPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx.py#L283"}}),Re=new C({props:{title:"LTXImageToVideoPipeline",local:"diffusers.LTXImageToVideoPipeline",headingTag:"h2"}}),Ne=new Z({props:{name:"class diffusers.LTXImageToVideoPipeline",anchor:"diffusers.LTXImageToVideoPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLLTXVideo"},{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": LTXVideoTransformer3DModel"}],parametersDescription:[{anchor:"diffusers.LTXImageToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/ltx_video_transformer3d#diffusers.LTXVideoTransformer3DModel">LTXVideoTransformer3DModel</a>) &#x2014;
Conditional Transformer architecture to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.LTXImageToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.LTXImageToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl_ltx_video#diffusers.AutoencoderKLLTXVideo">AutoencoderKLLTXVideo</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.LTXImageToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.LTXImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.LTXImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_image2video.py#L189"}}),Fe=new Z({props:{name:"__call__",anchor:"diffusers.LTXImageToVideoPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 704"},{name:"num_frames",val:": int = 161"},{name:"frame_rate",val:": int = 25"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"guidance_scale",val:": float = 3"},{name:"guidance_rescale",val:": float = 0.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decode_timestep",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"decode_noise_scale",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 128"}],parametersDescription:[{anchor:"diffusers.LTXImageToVideoPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>512</code>) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>704</code>) &#x2014;
The width in pixels of the generated image. This is set to 848 by default for the best results.`,name:"width"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>161</code>) &#x2014;
The number of video frames to generate`,name:"num_frames"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>3 </code>) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.prompt_attention_mask",description:`<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for text embeddings.`,name:"prompt_attention_mask"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.decode_timestep",description:`<strong>decode_timestep</strong> (<code>float</code>, defaults to <code>0.0</code>) &#x2014;
The timestep at which generated video is decoded.`,name:"decode_timestep"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.decode_noise_scale",description:`<strong>decode_noise_scale</strong> (<code>float</code>, defaults to <code>None</code>) &#x2014;
The interpolation factor between random noise and denoised latents at the decode timestep.`,name:"decode_noise_scale"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.ltx.LTXPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code> defaults to <code>128 </code>) &#x2014;
Maximum sequence length to use with the <code>prompt</code>.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_image2video.py#L596",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.ltx.LTXPipelineOutput</code> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.ltx.LTXPipelineOutput</code> or <code>tuple</code></p>
`}}),S=new Ts({props:{anchor:"diffusers.LTXImageToVideoPipeline.__call__.example",$$slots:{default:[yo]},$$scope:{ctx:W}}}),Ye=new Z({props:{name:"encode_prompt",anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 128"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_image2video.py#L306"}}),He=new C({props:{title:"LTXConditionPipeline",local:"diffusers.LTXConditionPipeline",headingTag:"h2"}}),Ee=new Z({props:{name:"class diffusers.LTXConditionPipeline",anchor:"diffusers.LTXConditionPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLLTXVideo"},{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": LTXVideoTransformer3DModel"}],parametersDescription:[{anchor:"diffusers.LTXConditionPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/ltx_video_transformer3d#diffusers.LTXVideoTransformer3DModel">LTXVideoTransformer3DModel</a>) &#x2014;
Conditional Transformer architecture to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.LTXConditionPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.LTXConditionPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl_ltx_video#diffusers.AutoencoderKLLTXVideo">AutoencoderKLLTXVideo</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.LTXConditionPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.LTXConditionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.LTXConditionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_condition.py#L252"}}),ze=new Z({props:{name:"__call__",anchor:"diffusers.LTXConditionPipeline.__call__",parameters:[{name:"conditions",val:": typing.Union[diffusers.pipelines.ltx.pipeline_ltx_condition.LTXVideoCondition, typing.List[diffusers.pipelines.ltx.pipeline_ltx_condition.LTXVideoCondition]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], typing.List[typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]]] = None"},{name:"video",val:": typing.List[typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]] = None"},{name:"frame_index",val:": typing.Union[int, typing.List[int]] = 0"},{name:"strength",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"denoise_strength",val:": float = 1.0"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 704"},{name:"num_frames",val:": int = 161"},{name:"frame_rate",val:": int = 25"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"guidance_scale",val:": float = 3"},{name:"guidance_rescale",val:": float = 0.0"},{name:"image_cond_noise_scale",val:": float = 0.15"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decode_timestep",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"decode_noise_scale",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 256"}],parametersDescription:[{anchor:"diffusers.LTXConditionPipeline.__call__.conditions",description:`<strong>conditions</strong> (<code>List[LTXVideoCondition], *optional*</code>) &#x2014;
The list of frame-conditioning items for the video generation.If not provided, conditions will be
created using <code>image</code>, <code>video</code>, <code>frame_index</code> and <code>strength</code>.`,name:"conditions"},{anchor:"diffusers.LTXConditionPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code> or <code>List[PipelineImageInput]</code>, <em>optional</em>) &#x2014;
The image or images to condition the video generation. If not provided, one has to pass <code>video</code> or
<code>conditions</code>.`,name:"image"},{anchor:"diffusers.LTXConditionPipeline.__call__.video",description:`<strong>video</strong> (<code>List[PipelineImageInput]</code>, <em>optional</em>) &#x2014;
The video to condition the video generation. If not provided, one has to pass <code>image</code> or <code>conditions</code>.`,name:"video"},{anchor:"diffusers.LTXConditionPipeline.__call__.frame_index",description:`<strong>frame_index</strong> (<code>int</code> or <code>List[int]</code>, <em>optional</em>) &#x2014;
The frame index or frame indices at which the image or video will conditionally effect the video
generation. If not provided, one has to pass <code>conditions</code>.`,name:"frame_index"},{anchor:"diffusers.LTXConditionPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>) &#x2014;
The strength or strengths of the conditioning effect. If not provided, one has to pass <code>conditions</code>.`,name:"strength"},{anchor:"diffusers.LTXConditionPipeline.__call__.denoise_strength",description:`<strong>denoise_strength</strong> (<code>float</code>, defaults to <code>1.0</code>) &#x2014;
The strength of the noise added to the latents for editing. Higher strength leads to more noise added
to the latents, therefore leading to more differences between original video and generated video. This
is useful for video-to-video editing.`,name:"denoise_strength"},{anchor:"diffusers.LTXConditionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.LTXConditionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>512</code>) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.LTXConditionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>704</code>) &#x2014;
The width in pixels of the generated image. This is set to 848 by default for the best results.`,name:"width"},{anchor:"diffusers.LTXConditionPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>161</code>) &#x2014;
The number of video frames to generate`,name:"num_frames"},{anchor:"diffusers.LTXConditionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.LTXConditionPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.LTXConditionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>3 </code>) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.LTXConditionPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.LTXConditionPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.LTXConditionPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.LTXConditionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.LTXConditionPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LTXConditionPipeline.__call__.prompt_attention_mask",description:`<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for text embeddings.`,name:"prompt_attention_mask"},{anchor:"diffusers.LTXConditionPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LTXConditionPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.LTXConditionPipeline.__call__.decode_timestep",description:`<strong>decode_timestep</strong> (<code>float</code>, defaults to <code>0.0</code>) &#x2014;
The timestep at which generated video is decoded.`,name:"decode_timestep"},{anchor:"diffusers.LTXConditionPipeline.__call__.decode_noise_scale",description:`<strong>decode_noise_scale</strong> (<code>float</code>, defaults to <code>None</code>) &#x2014;
The interpolation factor between random noise and denoised latents at the decode timestep.`,name:"decode_noise_scale"},{anchor:"diffusers.LTXConditionPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.LTXConditionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.ltx.LTXPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.LTXConditionPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.LTXConditionPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.LTXConditionPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.LTXConditionPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code> defaults to <code>128 </code>) &#x2014;
Maximum sequence length to use with the <code>prompt</code>.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_condition.py#L848",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.ltx.LTXPipelineOutput</code> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.ltx.LTXPipelineOutput</code> or <code>tuple</code></p>
`}}),A=new Ts({props:{anchor:"diffusers.LTXConditionPipeline.__call__.example",$$slots:{default:[To]},$$scope:{ctx:W}}}),Qe=new Z({props:{name:"add_noise_to_image_conditioning_latents",anchor:"diffusers.LTXConditionPipeline.add_noise_to_image_conditioning_latents",parameters:[{name:"t",val:": float"},{name:"init_latents",val:": Tensor"},{name:"latents",val:": Tensor"},{name:"noise_scale",val:": float"},{name:"conditioning_mask",val:": Tensor"},{name:"generator",val:""},{name:"eps",val:" = 1e-06"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_condition.py#L646"}}),$e=new Z({props:{name:"encode_prompt",anchor:"diffusers.LTXConditionPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 256"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.LTXConditionPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.LTXConditionPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LTXConditionPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.LTXConditionPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.LTXConditionPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LTXConditionPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LTXConditionPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.LTXConditionPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_condition.py#L369"}}),Se=new Z({props:{name:"trim_conditioning_sequence",anchor:"diffusers.LTXConditionPipeline.trim_conditioning_sequence",parameters:[{name:"start_frame",val:": int"},{name:"sequence_num_frames",val:": int"},{name:"target_num_frames",val:": int"}],parametersDescription:[{anchor:"diffusers.LTXConditionPipeline.trim_conditioning_sequence.start_frame",description:"<strong>start_frame</strong> (int) &#x2014; The target frame number of the first frame in the sequence.",name:"start_frame"},{anchor:"diffusers.LTXConditionPipeline.trim_conditioning_sequence.sequence_num_frames",description:"<strong>sequence_num_frames</strong> (int) &#x2014; The number of frames in the sequence.",name:"sequence_num_frames"},{anchor:"diffusers.LTXConditionPipeline.trim_conditioning_sequence.target_num_frames",description:"<strong>target_num_frames</strong> (int) &#x2014; The target number of frames in the generated video.",name:"target_num_frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_condition.py#L629",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>updated sequence length</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>int</p>
`}}),Pe=new C({props:{title:"LTXLatentUpsamplePipeline",local:"diffusers.LTXLatentUpsamplePipeline",headingTag:"h2"}}),Ae=new Z({props:{name:"class diffusers.LTXLatentUpsamplePipeline",anchor:"diffusers.LTXLatentUpsamplePipeline",parameters:[{name:"vae",val:": AutoencoderKLLTXVideo"},{name:"latent_upsampler",val:": LTXLatentUpsamplerModel"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_latent_upsample.py#L46"}}),De=new Z({props:{name:"__call__",anchor:"diffusers.LTXLatentUpsamplePipeline.__call__",parameters:[{name:"video",val:": typing.Optional[typing.List[typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]]] = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 704"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"decode_timestep",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"decode_noise_scale",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"adain_factor",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_latent_upsample.py#L182"}}),qe=new Z({props:{name:"adain_filter_latent",anchor:"diffusers.LTXLatentUpsamplePipeline.adain_filter_latent",parameters:[{name:"latents",val:": Tensor"},{name:"reference_latents",val:": Tensor"},{name:"factor",val:": float = 1.0"}],parametersDescription:[{anchor:"diffusers.LTXLatentUpsamplePipeline.adain_filter_latent.latent",description:`<strong>latent</strong> (<code>torch.Tensor</code>) &#x2014;
Input latents to normalize`,name:"latent"},{anchor:"diffusers.LTXLatentUpsamplePipeline.adain_filter_latent.reference_latents",description:`<strong>reference_latents</strong> (<code>torch.Tensor</code>) &#x2014;
The reference latents providing style statistics.`,name:"reference_latents"},{anchor:"diffusers.LTXLatentUpsamplePipeline.adain_filter_latent.factor",description:`<strong>factor</strong> (<code>float</code>) &#x2014;
Blending factor between original and transformed latent. Range: -10.0 to 10.0, Default: 1.0`,name:"factor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_latent_upsample.py#L94",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The transformed latent tensor</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>torch.Tensor</p>
`}}),Oe=new Z({props:{name:"disable_vae_slicing",anchor:"diffusers.LTXLatentUpsamplePipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_latent_upsample.py#L151"}}),Ke=new Z({props:{name:"disable_vae_tiling",anchor:"diffusers.LTXLatentUpsamplePipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_latent_upsample.py#L166"}}),et=new Z({props:{name:"enable_vae_slicing",anchor:"diffusers.LTXLatentUpsamplePipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_latent_upsample.py#L144"}}),tt=new Z({props:{name:"enable_vae_tiling",anchor:"diffusers.LTXLatentUpsamplePipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_latent_upsample.py#L158"}}),nt=new C({props:{title:"LTXPipelineOutput",local:"diffusers.pipelines.ltx.pipeline_output.LTXPipelineOutput",headingTag:"h2"}}),st=new Z({props:{name:"class diffusers.pipelines.ltx.pipeline_output.LTXPipelineOutput",anchor:"diffusers.pipelines.ltx.pipeline_output.LTXPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.ltx.pipeline_output.LTXPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_output.py#L8"}}),ot=new uo({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/ltx_video.md"}}),{c(){d=i("meta"),U=s(),y=i("p"),T=s(),c(_.$$.fragment),p=s(),J=i("div"),J.innerHTML=_s,xt=s(),oe=i("p"),oe.innerHTML=bs,Wt=s(),c(H.$$.fragment),Ct=s(),ae=i("p"),ae.textContent=ws,kt=s(),le=i("table"),le.innerHTML=Js,Lt=s(),ie=i("p"),ie.innerHTML=Us,Rt=s(),c(re.$$.fragment),Nt=s(),de=i("p"),de.innerHTML=vs,Ft=s(),pe=i("ul"),pe.innerHTML=js,Yt=s(),c(E.$$.fragment),Ht=s(),c(ce.$$.fragment),Et=s(),me=i("p"),me.textContent=Zs,zt=s(),c(he.$$.fragment),Qt=s(),c(ue.$$.fragment),$t=s(),ge=i("p"),ge.innerHTML=Gs,St=s(),fe=i("p"),fe.textContent=Is,Pt=s(),Me=i("ul"),Me.innerHTML=Xs,At=s(),z=i("details"),it=i("summary"),it.textContent=Bs,Cn=s(),c(ye.$$.fragment),Dt=s(),c(Te.$$.fragment),qt=s(),_e=i("p"),_e.innerHTML=Vs,Ot=s(),c(be.$$.fragment),Kt=s(),we=i("p"),we.innerHTML=xs,en=s(),c(Je.$$.fragment),tn=s(),Ue=i("p"),Ue.innerHTML=Ws,nn=s(),c(ve.$$.fragment),sn=s(),je=i("p"),je.innerHTML=Cs,on=s(),Ze=i("p"),Ze.innerHTML=ks,an=s(),c(Ge.$$.fragment),ln=s(),Ie=i("p"),Ie.innerHTML=Ls,rn=s(),c(Xe.$$.fragment),dn=s(),Be=i("p"),Be.textContent=Rs,pn=s(),Ve=i("p"),Ve.innerHTML=Ns,cn=s(),c(xe.$$.fragment),mn=s(),c(We.$$.fragment),hn=s(),G=i("div"),c(Ce.$$.fragment),kn=s(),rt=i("p"),rt.textContent=Fs,Ln=s(),dt=i("p"),dt.innerHTML=Ys,Rn=s(),k=i("div"),c(ke.$$.fragment),Nn=s(),pt=i("p"),pt.textContent=Hs,Fn=s(),c(Q.$$.fragment),Yn=s(),$=i("div"),c(Le.$$.fragment),Hn=s(),ct=i("p"),ct.textContent=Es,un=s(),c(Re.$$.fragment),gn=s(),I=i("div"),c(Ne.$$.fragment),En=s(),mt=i("p"),mt.textContent=zs,zn=s(),ht=i("p"),ht.innerHTML=Qs,Qn=s(),L=i("div"),c(Fe.$$.fragment),$n=s(),ut=i("p"),ut.textContent=$s,Sn=s(),c(S.$$.fragment),Pn=s(),P=i("div"),c(Ye.$$.fragment),An=s(),gt=i("p"),gt.textContent=Ss,fn=s(),c(He.$$.fragment),Mn=s(),v=i("div"),c(Ee.$$.fragment),Dn=s(),ft=i("p"),ft.textContent=Ps,qn=s(),Mt=i("p"),Mt.innerHTML=As,On=s(),R=i("div"),c(ze.$$.fragment),Kn=s(),yt=i("p"),yt.textContent=Ds,es=s(),c(A.$$.fragment),ts=s(),D=i("div"),c(Qe.$$.fragment),ns=s(),Tt=i("p"),Tt.textContent=qs,ss=s(),q=i("div"),c($e.$$.fragment),os=s(),_t=i("p"),_t.textContent=Os,as=s(),O=i("div"),c(Se.$$.fragment),ls=s(),bt=i("p"),bt.textContent=Ks,yn=s(),c(Pe.$$.fragment),Tn=s(),j=i("div"),c(Ae.$$.fragment),is=s(),wt=i("div"),c(De.$$.fragment),rs=s(),K=i("div"),c(qe.$$.fragment),ds=s(),Jt=i("p"),Jt.textContent=eo,ps=s(),ee=i("div"),c(Oe.$$.fragment),cs=s(),Ut=i("p"),Ut.innerHTML=to,ms=s(),te=i("div"),c(Ke.$$.fragment),hs=s(),vt=i("p"),vt.innerHTML=no,us=s(),ne=i("div"),c(et.$$.fragment),gs=s(),jt=i("p"),jt.textContent=so,fs=s(),se=i("div"),c(tt.$$.fragment),Ms=s(),Zt=i("p"),Zt.textContent=oo,_n=s(),c(nt.$$.fragment),bn=s(),F=i("div"),c(st.$$.fragment),ys=s(),Gt=i("p"),Gt.textContent=ao,wn=s(),c(ot.$$.fragment),Jn=s(),Bt=i("p"),this.h()},l(e){const t=ho("svelte-u9bgzb",document.head);d=r(t,"META",{name:!0,content:!0}),t.forEach(n),U=o(e),y=r(e,"P",{}),b(y).forEach(n),T=o(e),m(_.$$.fragment,e),p=o(e),J=r(e,"DIV",{class:!0,"data-svelte-h":!0}),M(J)!=="svelte-1elo7hh"&&(J.innerHTML=_s),xt=o(e),oe=r(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-1t4cyrb"&&(oe.innerHTML=bs),Wt=o(e),m(H.$$.fragment,e),Ct=o(e),ae=r(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-1bob28v"&&(ae.textContent=ws),kt=o(e),le=r(e,"TABLE",{"data-svelte-h":!0}),M(le)!=="svelte-1om9qen"&&(le.innerHTML=Js),Lt=o(e),ie=r(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-xu6cps"&&(ie.innerHTML=Us),Rt=o(e),m(re.$$.fragment,e),Nt=o(e),de=r(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-1giptmx"&&(de.innerHTML=vs),Ft=o(e),pe=r(e,"UL",{"data-svelte-h":!0}),M(pe)!=="svelte-e50cei"&&(pe.innerHTML=js),Yt=o(e),m(E.$$.fragment,e),Ht=o(e),m(ce.$$.fragment,e),Et=o(e),me=r(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-3t8vbu"&&(me.textContent=Zs),zt=o(e),m(he.$$.fragment,e),Qt=o(e),m(ue.$$.fragment,e),$t=o(e),ge=r(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-56x8zn"&&(ge.innerHTML=Gs),St=o(e),fe=r(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-eb6mxv"&&(fe.textContent=Is),Pt=o(e),Me=r(e,"UL",{"data-svelte-h":!0}),M(Me)!=="svelte-4s8fmo"&&(Me.innerHTML=Xs),At=o(e),z=r(e,"DETAILS",{});var at=b(z);it=r(at,"SUMMARY",{"data-svelte-h":!0}),M(it)!=="svelte-bsenvv"&&(it.textContent=Bs),Cn=o(at),m(ye.$$.fragment,at),at.forEach(n),Dt=o(e),m(Te.$$.fragment,e),qt=o(e),_e=r(e,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-lk4l6j"&&(_e.innerHTML=Vs),Ot=o(e),m(be.$$.fragment,e),Kt=o(e),we=r(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-rvy320"&&(we.innerHTML=xs),en=o(e),m(Je.$$.fragment,e),tn=o(e),Ue=r(e,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-1r1x4fd"&&(Ue.innerHTML=Ws),nn=o(e),m(ve.$$.fragment,e),sn=o(e),je=r(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-7vi8uq"&&(je.innerHTML=Cs),on=o(e),Ze=r(e,"P",{"data-svelte-h":!0}),M(Ze)!=="svelte-1d7qawf"&&(Ze.innerHTML=ks),an=o(e),m(Ge.$$.fragment,e),ln=o(e),Ie=r(e,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-obf3nv"&&(Ie.innerHTML=Ls),rn=o(e),m(Xe.$$.fragment,e),dn=o(e),Be=r(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-1ou2pxc"&&(Be.textContent=Rs),pn=o(e),Ve=r(e,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-1dokfz4"&&(Ve.innerHTML=Ns),cn=o(e),m(xe.$$.fragment,e),mn=o(e),m(We.$$.fragment,e),hn=o(e),G=r(e,"DIV",{class:!0});var V=b(G);m(Ce.$$.fragment,V),kn=o(V),rt=r(V,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-19ipoo4"&&(rt.textContent=Fs),Ln=o(V),dt=r(V,"P",{"data-svelte-h":!0}),M(dt)!=="svelte-1sr6eg8"&&(dt.innerHTML=Ys),Rn=o(V),k=r(V,"DIV",{class:!0});var Y=b(k);m(ke.$$.fragment,Y),Nn=o(Y),pt=r(Y,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-v78lg8"&&(pt.textContent=Hs),Fn=o(Y),m(Q.$$.fragment,Y),Y.forEach(n),Yn=o(V),$=r(V,"DIV",{class:!0});var lt=b($);m(Le.$$.fragment,lt),Hn=o(lt),ct=r(lt,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-16q0ax1"&&(ct.textContent=Es),lt.forEach(n),V.forEach(n),un=o(e),m(Re.$$.fragment,e),gn=o(e),I=r(e,"DIV",{class:!0});var x=b(I);m(Ne.$$.fragment,x),En=o(x),mt=r(x,"P",{"data-svelte-h":!0}),M(mt)!=="svelte-10tczlw"&&(mt.textContent=zs),zn=o(x),ht=r(x,"P",{"data-svelte-h":!0}),M(ht)!=="svelte-1sr6eg8"&&(ht.innerHTML=Qs),Qn=o(x),L=r(x,"DIV",{class:!0});var It=b(L);m(Fe.$$.fragment,It),$n=o(It),ut=r(It,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-v78lg8"&&(ut.textContent=$s),Sn=o(It),m(S.$$.fragment,It),It.forEach(n),Pn=o(x),P=r(x,"DIV",{class:!0});var vn=b(P);m(Ye.$$.fragment,vn),An=o(vn),gt=r(vn,"P",{"data-svelte-h":!0}),M(gt)!=="svelte-16q0ax1"&&(gt.textContent=Ss),vn.forEach(n),x.forEach(n),fn=o(e),m(He.$$.fragment,e),Mn=o(e),v=r(e,"DIV",{class:!0});var X=b(v);m(Ee.$$.fragment,X),Dn=o(X),ft=r(X,"P",{"data-svelte-h":!0}),M(ft)!=="svelte-4vzu4m"&&(ft.textContent=Ps),qn=o(X),Mt=r(X,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-1sr6eg8"&&(Mt.innerHTML=As),On=o(X),R=r(X,"DIV",{class:!0});var Xt=b(R);m(ze.$$.fragment,Xt),Kn=o(Xt),yt=r(Xt,"P",{"data-svelte-h":!0}),M(yt)!=="svelte-v78lg8"&&(yt.textContent=Ds),es=o(Xt),m(A.$$.fragment,Xt),Xt.forEach(n),ts=o(X),D=r(X,"DIV",{class:!0});var jn=b(D);m(Qe.$$.fragment,jn),ns=o(jn),Tt=r(jn,"P",{"data-svelte-h":!0}),M(Tt)!=="svelte-9ak1um"&&(Tt.textContent=qs),jn.forEach(n),ss=o(X),q=r(X,"DIV",{class:!0});var Zn=b(q);m($e.$$.fragment,Zn),os=o(Zn),_t=r(Zn,"P",{"data-svelte-h":!0}),M(_t)!=="svelte-16q0ax1"&&(_t.textContent=Os),Zn.forEach(n),as=o(X),O=r(X,"DIV",{class:!0});var Gn=b(O);m(Se.$$.fragment,Gn),ls=o(Gn),bt=r(Gn,"P",{"data-svelte-h":!0}),M(bt)!=="svelte-1eod455"&&(bt.textContent=Ks),Gn.forEach(n),X.forEach(n),yn=o(e),m(Pe.$$.fragment,e),Tn=o(e),j=r(e,"DIV",{class:!0});var B=b(j);m(Ae.$$.fragment,B),is=o(B),wt=r(B,"DIV",{class:!0});var lo=b(wt);m(De.$$.fragment,lo),lo.forEach(n),rs=o(B),K=r(B,"DIV",{class:!0});var In=b(K);m(qe.$$.fragment,In),ds=o(In),Jt=r(In,"P",{"data-svelte-h":!0}),M(Jt)!=="svelte-tr32vd"&&(Jt.textContent=eo),In.forEach(n),ps=o(B),ee=r(B,"DIV",{class:!0});var Xn=b(ee);m(Oe.$$.fragment,Xn),cs=o(Xn),Ut=r(Xn,"P",{"data-svelte-h":!0}),M(Ut)!=="svelte-1s3c06i"&&(Ut.innerHTML=to),Xn.forEach(n),ms=o(B),te=r(B,"DIV",{class:!0});var Bn=b(te);m(Ke.$$.fragment,Bn),hs=o(Bn),vt=r(Bn,"P",{"data-svelte-h":!0}),M(vt)!=="svelte-pkn4ui"&&(vt.innerHTML=no),Bn.forEach(n),us=o(B),ne=r(B,"DIV",{class:!0});var Vn=b(ne);m(et.$$.fragment,Vn),gs=o(Vn),jt=r(Vn,"P",{"data-svelte-h":!0}),M(jt)!=="svelte-14bnrb6"&&(jt.textContent=so),Vn.forEach(n),fs=o(B),se=r(B,"DIV",{class:!0});var xn=b(se);m(tt.$$.fragment,xn),Ms=o(xn),Zt=r(xn,"P",{"data-svelte-h":!0}),M(Zt)!=="svelte-1xwrf7t"&&(Zt.textContent=oo),xn.forEach(n),B.forEach(n),_n=o(e),m(nt.$$.fragment,e),bn=o(e),F=r(e,"DIV",{class:!0});var Wn=b(F);m(st.$$.fragment,Wn),ys=o(Wn),Gt=r(Wn,"P",{"data-svelte-h":!0}),M(Gt)!=="svelte-ia4jjd"&&(Gt.textContent=ao),Wn.forEach(n),wn=o(e),m(ot.$$.fragment,e),Jn=o(e),Bt=r(e,"P",{}),b(Bt).forEach(n),this.h()},h(){w(d,"name","hf:doc:metadata"),w(d,"content",bo),w(J,"class","flex flex-wrap space-x-1"),w(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,d),a(e,U,t),a(e,y,t),a(e,T,t),h(_,e,t),a(e,p,t),a(e,J,t),a(e,xt,t),a(e,oe,t),a(e,Wt,t),h(H,e,t),a(e,Ct,t),a(e,ae,t),a(e,kt,t),a(e,le,t),a(e,Lt,t),a(e,ie,t),a(e,Rt,t),h(re,e,t),a(e,Nt,t),a(e,de,t),a(e,Ft,t),a(e,pe,t),a(e,Yt,t),h(E,e,t),a(e,Ht,t),h(ce,e,t),a(e,Et,t),a(e,me,t),a(e,zt,t),h(he,e,t),a(e,Qt,t),h(ue,e,t),a(e,$t,t),a(e,ge,t),a(e,St,t),a(e,fe,t),a(e,Pt,t),a(e,Me,t),a(e,At,t),a(e,z,t),l(z,it),l(z,Cn),h(ye,z,null),a(e,Dt,t),h(Te,e,t),a(e,qt,t),a(e,_e,t),a(e,Ot,t),h(be,e,t),a(e,Kt,t),a(e,we,t),a(e,en,t),h(Je,e,t),a(e,tn,t),a(e,Ue,t),a(e,nn,t),h(ve,e,t),a(e,sn,t),a(e,je,t),a(e,on,t),a(e,Ze,t),a(e,an,t),h(Ge,e,t),a(e,ln,t),a(e,Ie,t),a(e,rn,t),h(Xe,e,t),a(e,dn,t),a(e,Be,t),a(e,pn,t),a(e,Ve,t),a(e,cn,t),h(xe,e,t),a(e,mn,t),h(We,e,t),a(e,hn,t),a(e,G,t),h(Ce,G,null),l(G,kn),l(G,rt),l(G,Ln),l(G,dt),l(G,Rn),l(G,k),h(ke,k,null),l(k,Nn),l(k,pt),l(k,Fn),h(Q,k,null),l(G,Yn),l(G,$),h(Le,$,null),l($,Hn),l($,ct),a(e,un,t),h(Re,e,t),a(e,gn,t),a(e,I,t),h(Ne,I,null),l(I,En),l(I,mt),l(I,zn),l(I,ht),l(I,Qn),l(I,L),h(Fe,L,null),l(L,$n),l(L,ut),l(L,Sn),h(S,L,null),l(I,Pn),l(I,P),h(Ye,P,null),l(P,An),l(P,gt),a(e,fn,t),h(He,e,t),a(e,Mn,t),a(e,v,t),h(Ee,v,null),l(v,Dn),l(v,ft),l(v,qn),l(v,Mt),l(v,On),l(v,R),h(ze,R,null),l(R,Kn),l(R,yt),l(R,es),h(A,R,null),l(v,ts),l(v,D),h(Qe,D,null),l(D,ns),l(D,Tt),l(v,ss),l(v,q),h($e,q,null),l(q,os),l(q,_t),l(v,as),l(v,O),h(Se,O,null),l(O,ls),l(O,bt),a(e,yn,t),h(Pe,e,t),a(e,Tn,t),a(e,j,t),h(Ae,j,null),l(j,is),l(j,wt),h(De,wt,null),l(j,rs),l(j,K),h(qe,K,null),l(K,ds),l(K,Jt),l(j,ps),l(j,ee),h(Oe,ee,null),l(ee,cs),l(ee,Ut),l(j,ms),l(j,te),h(Ke,te,null),l(te,hs),l(te,vt),l(j,us),l(j,ne),h(et,ne,null),l(ne,gs),l(ne,jt),l(j,fs),l(j,se),h(tt,se,null),l(se,Ms),l(se,Zt),a(e,_n,t),h(nt,e,t),a(e,bn,t),a(e,F,t),h(st,F,null),l(F,ys),l(F,Gt),a(e,wn,t),h(ot,e,t),a(e,Jn,t),a(e,Bt,t),Un=!0},p(e,[t]){const at={};t&2&&(at.$$scope={dirty:t,ctx:e}),H.$set(at);const V={};t&2&&(V.$$scope={dirty:t,ctx:e}),E.$set(V);const Y={};t&2&&(Y.$$scope={dirty:t,ctx:e}),Q.$set(Y);const lt={};t&2&&(lt.$$scope={dirty:t,ctx:e}),S.$set(lt);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),A.$set(x)},i(e){Un||(u(_.$$.fragment,e),u(H.$$.fragment,e),u(re.$$.fragment,e),u(E.$$.fragment,e),u(ce.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(ye.$$.fragment,e),u(Te.$$.fragment,e),u(be.$$.fragment,e),u(Je.$$.fragment,e),u(ve.$$.fragment,e),u(Ge.$$.fragment,e),u(Xe.$$.fragment,e),u(xe.$$.fragment,e),u(We.$$.fragment,e),u(Ce.$$.fragment,e),u(ke.$$.fragment,e),u(Q.$$.fragment,e),u(Le.$$.fragment,e),u(Re.$$.fragment,e),u(Ne.$$.fragment,e),u(Fe.$$.fragment,e),u(S.$$.fragment,e),u(Ye.$$.fragment,e),u(He.$$.fragment,e),u(Ee.$$.fragment,e),u(ze.$$.fragment,e),u(A.$$.fragment,e),u(Qe.$$.fragment,e),u($e.$$.fragment,e),u(Se.$$.fragment,e),u(Pe.$$.fragment,e),u(Ae.$$.fragment,e),u(De.$$.fragment,e),u(qe.$$.fragment,e),u(Oe.$$.fragment,e),u(Ke.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(nt.$$.fragment,e),u(st.$$.fragment,e),u(ot.$$.fragment,e),Un=!0)},o(e){g(_.$$.fragment,e),g(H.$$.fragment,e),g(re.$$.fragment,e),g(E.$$.fragment,e),g(ce.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(ye.$$.fragment,e),g(Te.$$.fragment,e),g(be.$$.fragment,e),g(Je.$$.fragment,e),g(ve.$$.fragment,e),g(Ge.$$.fragment,e),g(Xe.$$.fragment,e),g(xe.$$.fragment,e),g(We.$$.fragment,e),g(Ce.$$.fragment,e),g(ke.$$.fragment,e),g(Q.$$.fragment,e),g(Le.$$.fragment,e),g(Re.$$.fragment,e),g(Ne.$$.fragment,e),g(Fe.$$.fragment,e),g(S.$$.fragment,e),g(Ye.$$.fragment,e),g(He.$$.fragment,e),g(Ee.$$.fragment,e),g(ze.$$.fragment,e),g(A.$$.fragment,e),g(Qe.$$.fragment,e),g($e.$$.fragment,e),g(Se.$$.fragment,e),g(Pe.$$.fragment,e),g(Ae.$$.fragment,e),g(De.$$.fragment,e),g(qe.$$.fragment,e),g(Oe.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(tt.$$.fragment,e),g(nt.$$.fragment,e),g(st.$$.fragment,e),g(ot.$$.fragment,e),Un=!1},d(e){e&&(n(U),n(y),n(T),n(p),n(J),n(xt),n(oe),n(Wt),n(Ct),n(ae),n(kt),n(le),n(Lt),n(ie),n(Rt),n(Nt),n(de),n(Ft),n(pe),n(Yt),n(Ht),n(Et),n(me),n(zt),n(Qt),n($t),n(ge),n(St),n(fe),n(Pt),n(Me),n(At),n(z),n(Dt),n(qt),n(_e),n(Ot),n(Kt),n(we),n(en),n(tn),n(Ue),n(nn),n(sn),n(je),n(on),n(Ze),n(an),n(ln),n(Ie),n(rn),n(dn),n(Be),n(pn),n(Ve),n(cn),n(mn),n(hn),n(G),n(un),n(gn),n(I),n(fn),n(Mn),n(v),n(yn),n(Tn),n(j),n(_n),n(bn),n(F),n(wn),n(Jn),n(Bt)),n(d),f(_,e),f(H,e),f(re,e),f(E,e),f(ce,e),f(he,e),f(ue,e),f(ye),f(Te,e),f(be,e),f(Je,e),f(ve,e),f(Ge,e),f(Xe,e),f(xe,e),f(We,e),f(Ce),f(ke),f(Q),f(Le),f(Re,e),f(Ne),f(Fe),f(S),f(Ye),f(He,e),f(Ee),f(ze),f(A),f(Qe),f($e),f(Se),f(Pe,e),f(Ae),f(De),f(qe),f(Oe),f(Ke),f(et),f(tt),f(nt,e),f(st),f(ot,e)}}}const bo='{"title":"LTX Video","local":"ltx-video","sections":[{"title":"Recommended settings for generation","local":"recommended-settings-for-generation","sections":[],"depth":2},{"title":"Using LTX Video 13B 0.9.7","local":"using-ltx-video-13b-097","sections":[],"depth":2},{"title":"Using LTX Video 0.9.7 (distilled)","local":"using-ltx-video-097-distilled","sections":[],"depth":2},{"title":"Loading Single Files","local":"loading-single-files","sections":[],"depth":2},{"title":"Quantization","local":"quantization","sections":[],"depth":2},{"title":"LTXPipeline","local":"diffusers.LTXPipeline","sections":[],"depth":2},{"title":"LTXImageToVideoPipeline","local":"diffusers.LTXImageToVideoPipeline","sections":[],"depth":2},{"title":"LTXConditionPipeline","local":"diffusers.LTXConditionPipeline","sections":[],"depth":2},{"title":"LTXLatentUpsamplePipeline","local":"diffusers.LTXLatentUpsamplePipeline","sections":[],"depth":2},{"title":"LTXPipelineOutput","local":"diffusers.pipelines.ltx.pipeline_output.LTXPipelineOutput","sections":[],"depth":2}],"depth":1}';function wo(W){return po(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xo extends co{constructor(d){super(),mo(this,d,wo,_o,ro,{})}}export{Xo as component};
