import{s as Cl,n as xl,o as Vl}from"../chunks/scheduler.6062bdaf.js";import{S as Sl,i as Fl,g as d,s as n,r as i,A as El,h as M,f as t,c as a,j as kl,u as p,x as b,k as Ml,y as _l,a as s,v as m,d as o,t as r,w as u}from"../chunks/index.4bca734e.js";import{C as y}from"../chunks/CodeBlock.fa01571c.js";import{H as c}from"../chunks/Heading.723dceba.js";function Ql(bl){let f,ce,Me,ye,J,fe,g,cl=`Optimum is a utility package for building and running inference with accelerated runtime like ONNX Runtime.
Optimum can be used to load optimized models from the <a href="hf.co/models">Hugging Face Hub</a> and create pipelines
to run accelerated inference without rewriting your APIs.`,he,T,Je,w,yl=`The <code>optimum.onnxruntime.ORTModelForXXX</code> model classes are API compatible with Hugging Face Transformers models. This
means you can just replace your <code>AutoModelForXXX</code> class with the corresponding <code>ORTModelForXXX</code> class in <code>optimum.onnxruntime</code>.`,ge,U,fl="You do not need to adapt your code to get it to work with <code>ORTModelForXXX</code> classes:",Te,Z,we,j,Ue,W,hl=`Because the model you want to work with might not be already converted to ONNX,  <a href="/docs/optimum/v1.18.1/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>
includes a method to convert vanilla Transformers models to ONNX ones. Simply pass <code>export=True</code> to the
<a href="/docs/optimum/v1.18.1/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">from_pretrained()</a> method, and your model will be loaded and converted to ONNX on-the-fly:`,Ze,X,je,B,We,G,Jl=`It is also possible, just as with regular <a href="https://huggingface.co/docs/transformers/v4.39.3/en/main_classes/model#transformers.PreTrainedModel" rel="nofollow">PreTrainedModel</a>s, to push your <code>ORTModelForXXX</code> to the
<a href="https://hf.co/models" rel="nofollow">Hugging Face Model Hub</a>:`,Xe,R,Be,I,Ge,$,gl=`Sequence-to-sequence (Seq2Seq) models can also be used when running inference with ONNX Runtime. When Seq2Seq models
are exported to the ONNX format, they are decomposed into three parts that are later combined during inference:`,Re,N,Tl=`<li>The encoder part of the model</li> <li>The decoder part of the model + the language modeling head</li> <li>The same decoder part of the model + language modeling head but taking and using pre-computed key / values as inputs and
outputs. This makes inference faster.</li>`,Ie,v,wl="Here is an example of how you can load a T5 model to the ONNX format and run inference for a translation task:",$e,k,Ne,C,ve,x,Ul=`Stable Diffusion models can also be used when running inference with ONNX Runtime. When Stable Diffusion models
are exported to the ONNX format, they are split into four components that are later combined during inference:`,ke,V,Zl="<li>The text encoder</li> <li>The U-NET</li> <li>The VAE encoder</li> <li>The VAE decoder</li>",Ce,S,jl="Make sure you have 🤗 Diffusers installed.",xe,F,Wl="To install <code>diffusers</code>:",Ve,E,Se,_,Fe,Q,Xl="Here is an example of how you can load an ONNX Stable Diffusion model and run inference using ONNX Runtime:",Ee,H,_e,Y,Bl="To load your PyTorch model and convert it to ONNX on-the-fly, you can set <code>export=True</code>.",Qe,q,He,h,Gl='<img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/stable_diffusion_v1_5_ort_sail_boat.png"/>',Ye,z,qe,L,ze,O,Le,P,Oe,A,Pe,D,Rl="Before using <code>ORTStableDiffusionXLPipeline</code> make sure to have <code>diffusers</code> and <code>invisible_watermark</code> installed. You can install the libraries as follows:",Ae,K,De,ee,Ke,le,Il='Here is an example of how you can load a SDXL ONNX model from <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> and run inference using ONNX Runtime :',el,te,ll,se,tl,ne,$l="Here is an example of how you can load a PyTorch SDXL model, convert it to ONNX on-the-fly and run inference using ONNX Runtime for <em>image-to-image</em> :",sl,ae,nl,ie,al,pe,Nl='The image can be refined by making use of a model like <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-refiner-1.0</a>. In this case, you only have to output the latents from the base model.',il,me,pl,oe,ml,re,ol,ue,vl='Here is an example of how you can load a Latent Consistency Models (LCMs) from <a href="https://huggingface.co/SimianLuo/LCM_Dreamshaper_v7" rel="nofollow">SimianLuo/LCM_Dreamshaper_v7</a> and run inference using ONNX Runtime :',rl,de,ul,be,dl;return J=new c({props:{title:"Optimum Inference with ONNX Runtime",local:"optimum-inference-with-onnx-runtime",headingTag:"h1"}}),T=new c({props:{title:"Switching from Transformers to Optimum",local:"switching-from-transformers-to-optimum",headingTag:"h2"}}),Z=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQS1mcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMkJmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMEEtbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcHNldCUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTIwJTIzJTIwUHlUb3JjaCUyMGNoZWNrcG9pbnQlMEElMkJtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUyMCUyMyUyME9OTlglMjBjaGVja3BvaW50JTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcHNldCUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBJTBBb25ueF9xYSUyMCUzRCUyMHBpcGVsaW5lKCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQ21vZGVsJTNEbW9kZWwlMkN0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcXVlc3Rpb24lMjAlM0QlMjAlMjJXaGF0J3MlMjBteSUyMG5hbWUlM0YlMjIlMEFjb250ZXh0JTIwJTNEJTIwJTIyTXklMjBuYW1lJTIwaXMlMjBQaGlsaXBwJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyME51cmVtYmVyZy4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9xYShxdWVzdGlvbiUyQyUyMGNvbnRleHQp",highlighted:`from transformers import AutoTokenizer, pipeline
<span class="hljs-deletion">-from transformers import AutoModelForQuestionAnswering</span>
<span class="hljs-addition">+from optimum.onnxruntime import ORTModelForQuestionAnswering</span>

<span class="hljs-deletion">-model = AutoModelForQuestionAnswering.from_pretrained(&quot;deepset/roberta-base-squad2&quot;) # PyTorch checkpoint</span>
<span class="hljs-addition">+model = ORTModelForQuestionAnswering.from_pretrained(&quot;optimum/roberta-base-squad2&quot;) # ONNX checkpoint</span>
tokenizer = AutoTokenizer.from_pretrained(&quot;deepset/roberta-base-squad2&quot;)

onnx_qa = pipeline(&quot;question-answering&quot;,model=model,tokenizer=tokenizer)

question = &quot;What&#x27;s my name?&quot;
context = &quot;My name is Philipp and I live in Nuremberg.&quot;
pred = onnx_qa(question, context)`,wrap:!1}}),j=new c({props:{title:"Loading a vanilla Transformers model",local:"loading-a-vanilla-transformers-model",headingTag:"h3"}}),X=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwaHViJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyMHRoZSUyME9OTlglMjBmb3JtYXQlMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIlMkMlMjBleHBvcnQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the model from the hub and export it to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>, export=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),B=new c({props:{title:"Pushing ONNX models to the Hugging Face Hub",local:"pushing-onnx-models-to-the-hugging-face-hub",headingTag:"h3"}}),R=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwaHViJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyMHRoZSUyME9OTlglMjBmb3JtYXQlMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIlMkMlMjBleHBvcnQlM0RUcnVlJTBBKSUwQSUwQSUyMyUyMFNhdmUlMjB0aGUlMjBjb252ZXJ0ZWQlMjBtb2RlbCUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJhX2xvY2FsX3BhdGhfZm9yX2NvbnZlcnRfb25ueF9tb2RlbCUyMiklMEElMEFtb2RlbC5wdXNoX3RvX2h1YiglMEElMjAlMjAlMjJhX2xvY2FsX3BhdGhfZm9yX2NvbnZlcnRfb25ueF9tb2RlbCUyMiUyQyUyMHJlcG9zaXRvcnlfaWQlM0QlMjJteS1vbm54LXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the model from the hub and export it to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>, export=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save the converted model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;a_local_path_for_convert_onnx_model&quot;</span>)

<span class="hljs-comment"># Push the onnx model to HF Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;a_local_path_for_convert_onnx_model&quot;</span>, repository_id=<span class="hljs-string">&quot;my-onnx-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),I=new c({props:{title:"Sequence-to-sequence models",local:"sequence-to-sequence-models",headingTag:"h2"}}),k=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbF9uYW1lJTIwJTNEJTIwJTIydDUtc21hbGwlMjIlMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKSUwQSUwQW9ubnhfdHJhbnNsYXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJ0cmFuc2xhdGlvbl9lbl90b19mciUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBdGV4dCUyMCUzRCUyMCUyMkhlJTIwbmV2ZXIlMjB3ZW50JTIwb3V0JTIwd2l0aG91dCUyMGElMjBib29rJTIwdW5kZXIlMjBoaXMlMjBhcm0lMkMlMjBhbmQlMjBoZSUyMG9mdGVuJTIwY2FtZSUyMGJhY2slMjB3aXRoJTIwdHdvLiUyMiUwQXJlc3VsdCUyMCUzRCUyMG9ubnhfdHJhbnNsYXRpb24odGV4dCklMEElMjMlMjAlNUIlN0IndHJhbnNsYXRpb25fdGV4dCclM0ElMjAlMjJJbCUyMG4nZXN0JTIwamFtYWlzJTIwc29ydGklMjBzYW5zJTIwdW4lMjBsaXZyZSUyMHNvdXMlMjBzb24lMjBicmFzJTJDJTIwZXQlMjBpbCUyMGVzdCUyMHNvdXZlbnQlMjByZXZlbnUlMjBhdmVjJTIwZGV1eC4lMjIlN0QlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-comment"># Load the model from the hub and export it to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;t5-small&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(model_name, export=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_name)

<span class="hljs-comment"># Create a pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_translation = pipeline(<span class="hljs-string">&quot;translation_en_to_fr&quot;</span>, model=model, tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;He never went out without a book under his arm, and he often came back with two.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = onnx_translation(text)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [{&#x27;translation_text&#x27;: &quot;Il n&#x27;est jamais sorti sans un livre sous son bras, et il est souvent revenu avec deux.&quot;}]</span>`,wrap:!1}}),C=new c({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),E=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2Vycw==",highlighted:"pip install diffusers",wrap:!1}}),_=new c({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),H=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRTdGFibGVEaWZmdXNpb25QaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFwaXBlbGluZSUyMCUzRCUyME9SVFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHJldmlzaW9uJTNEJTIyb25ueCUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJzYWlsaW5nJTIwc2hpcCUyMGluJTIwc3Rvcm0lMjBieSUyMExlb25hcmRvJTIwZGElMjBWaW5jaSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = ORTStableDiffusionPipeline.from_pretrained(model_id, revision=<span class="hljs-string">&quot;onnx&quot;</span>)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Leonardo da Vinci&quot;</span>
image = pipeline(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),q=new y({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBPUlRTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQSUyMyUyMERvbid0JTIwZm9yZ2V0JTIwdG8lMjBzYXZlJTIwdGhlJTIwT05OWCUyMG1vZGVsJTBBc2F2ZV9kaXJlY3RvcnklMjAlM0QlMjAlMjJhX2xvY2FsX3BhdGglMjIlMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3Rvcnkp",highlighted:`pipeline = ORTStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Don&#x27;t forget to save the ONNX model</span>
save_directory = <span class="hljs-string">&quot;a_local_path&quot;</span>
pipeline.save_pretrained(save_directory)`,wrap:!1}}),z=new c({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),L=new y({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFwaXBlbGluZSUyMCUzRCUyME9SVFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjByZXZpc2lvbiUzRCUyMm9ubnglMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24lMkZtYWluJTJGYXNzZXRzJTJGc3RhYmxlLXNhbXBsZXMlMkZpbWcyaW1nJTJGc2tldGNoLW1vdW50YWlucy1pbnB1dC5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oQnl0ZXNJTyhyZXNwb25zZS5jb250ZW50KSkuY29udmVydCglMjJSR0IlMjIpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGluaXRfaW1hZ2UucmVzaXplKCg3NjglMkMlMjA1MTIpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTJDJTIwdHJlbmRpbmclMjBvbiUyMGFydHN0YXRpb24lMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC43NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy41KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJmYW50YXN5X2xhbmRzY2FwZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = ORTStableDiffusionImg2ImgPipeline.from_pretrained(model_id, revision=<span class="hljs-string">&quot;onnx&quot;</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),O=new c({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),P=new y({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLWlucGFpbnRpbmclMjIlMEFwaXBlbGluZSUyMCUzRCUyME9SVFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjByZXZpc2lvbiUzRCUyMm9ubnglMjIpJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBQSUwuSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW8ucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1b19tYXNrLnBuZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShpbWdfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBbWFza19pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKG1hc2tfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyRmFjZSUyMG9mJTIwYSUyMHllbGxvdyUyMGNhdCUyQyUyMGhpZ2glMjByZXNvbHV0aW9uJTJDJTIwc2l0dGluZyUyMG9uJTIwYSUyMHBhcmslMjBiZW5jaCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionInpaintPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>
pipeline = ORTStableDiffusionInpaintPipeline.from_pretrained(model_id, revision=<span class="hljs-string">&quot;onnx&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),A=new c({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),K=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2VycyUwQXBpcCUyMGluc3RhbGwlMjBpbnZpc2libGUtd2F0ZXJtYXJrJTNFJTNEMC4yLjA=",highlighted:`pip install diffusers
pip install invisible-watermark&gt;=0.2.0`,wrap:!1}}),ee=new c({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),te=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMEFiYXNlJTIwJTNEJTIwT1JUU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBcHJvbXB0JTIwJTNEJTIwJTIyc2FpbGluZyUyMHNoaXAlMjBpbiUyMHN0b3JtJTIwYnklMjBMZW9uYXJkbyUyMGRhJTIwVmluY2klMjIlMEFpbWFnZSUyMCUzRCUyMGJhc2UocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTBBJTIzJTIwRG9uJ3QlMjBmb3JnZXQlMjB0byUyMHNhdmUlMjB0aGUlMjBPTk5YJTIwbW9kZWwlMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMnNkX3hsX2Jhc2UlMjIlMEFiYXNlLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSk=",highlighted:`<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
base = ORTStableDiffusionXLPipeline.from_pretrained(model_id)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Leonardo da Vinci&quot;</span>
image = base(prompt).images[<span class="hljs-number">0</span>]

<span class="hljs-comment"># Don&#x27;t forget to save the ONNX model</span>
save_directory = <span class="hljs-string">&quot;sd_xl_base&quot;</span>
base.save_pretrained(save_directory)`,wrap:!1}}),se=new c({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),ae=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtcmVmaW5lci0xLjAlMjIlMEFwaXBlbGluZSUyMCUzRCUyME9SVFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGb3B0aW11bSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZpbnRlbCUyRm9wZW52aW5vJTJGc2RfeGwlMkZjYXN0bGVfZnJpZWRyaWNoLnBuZyUyMiUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMm1lZGlldmFsJTIwY2FzdGxlJTIwYnklMjBDYXNwYXIlMjBEYXZpZCUyMEZyaWVkcmljaCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0RpbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIybWVkaWV2YWxfY2FzdGxlLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>
pipeline = ORTStableDiffusionXLImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;medieval castle by Caspar David Friedrich&quot;</span>
image = pipeline(prompt, image=image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;medieval_castle.png&quot;</span>)`,wrap:!1}}),ie=new c({props:{title:"Refining the image output",local:"refining-the-image-output",headingTag:"h3"}}),me=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLXJlZmluZXItMS4wJTIyJTBBcmVmaW5lciUyMCUzRCUyME9SVFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKHByb21wdCUzRHByb21wdCUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2UlMjAlM0QlMjByZWZpbmVyKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW1hZ2UlNUJOb25lJTJDJTIwJTNBJTVEKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJzYWlsaW5nX3NoaXAucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionXLImg2ImgPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>
refiner = ORTStableDiffusionXLImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sailing_ship.png&quot;</span>)`,wrap:!1}}),oe=new c({props:{title:"Latent Consistency Models",local:"latent-consistency-models",headingTag:"h2"}}),re=new c({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),de=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRMYXRlbnRDb25zaXN0ZW5jeU1vZGVsUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMlNpbWlhbkx1byUyRkxDTV9EcmVhbXNoYXBlcl92NyUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwT1JUTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBcHJvbXB0JTIwJTNEJTIwJTIyc2FpbGluZyUyMHNoaXAlMjBpbiUyMHN0b3JtJTIwYnklMjBMZW9uYXJkbyUyMGRhJTIwVmluY2klMjIlMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTLatentConsistencyModelPipeline

model_id = <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>
pipeline = ORTLatentConsistencyModelPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Leonardo da Vinci&quot;</span>
images = pipeline(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),{c(){f=d("meta"),ce=n(),Me=d("p"),ye=n(),i(J.$$.fragment),fe=n(),g=d("p"),g.innerHTML=cl,he=n(),i(T.$$.fragment),Je=n(),w=d("p"),w.innerHTML=yl,ge=n(),U=d("p"),U.innerHTML=fl,Te=n(),i(Z.$$.fragment),we=n(),i(j.$$.fragment),Ue=n(),W=d("p"),W.innerHTML=hl,Ze=n(),i(X.$$.fragment),je=n(),i(B.$$.fragment),We=n(),G=d("p"),G.innerHTML=Jl,Xe=n(),i(R.$$.fragment),Be=n(),i(I.$$.fragment),Ge=n(),$=d("p"),$.textContent=gl,Re=n(),N=d("ul"),N.innerHTML=Tl,Ie=n(),v=d("p"),v.textContent=wl,$e=n(),i(k.$$.fragment),Ne=n(),i(C.$$.fragment),ve=n(),x=d("p"),x.textContent=Ul,ke=n(),V=d("ul"),V.innerHTML=Zl,Ce=n(),S=d("p"),S.textContent=jl,xe=n(),F=d("p"),F.innerHTML=Wl,Ve=n(),i(E.$$.fragment),Se=n(),i(_.$$.fragment),Fe=n(),Q=d("p"),Q.textContent=Xl,Ee=n(),i(H.$$.fragment),_e=n(),Y=d("p"),Y.innerHTML=Bl,Qe=n(),i(q.$$.fragment),He=n(),h=d("div"),h.innerHTML=Gl,Ye=n(),i(z.$$.fragment),qe=n(),i(L.$$.fragment),ze=n(),i(O.$$.fragment),Le=n(),i(P.$$.fragment),Oe=n(),i(A.$$.fragment),Pe=n(),D=d("p"),D.innerHTML=Rl,Ae=n(),i(K.$$.fragment),De=n(),i(ee.$$.fragment),Ke=n(),le=d("p"),le.innerHTML=Il,el=n(),i(te.$$.fragment),ll=n(),i(se.$$.fragment),tl=n(),ne=d("p"),ne.innerHTML=$l,sl=n(),i(ae.$$.fragment),nl=n(),i(ie.$$.fragment),al=n(),pe=d("p"),pe.innerHTML=Nl,il=n(),i(me.$$.fragment),pl=n(),i(oe.$$.fragment),ml=n(),i(re.$$.fragment),ol=n(),ue=d("p"),ue.innerHTML=vl,rl=n(),i(de.$$.fragment),ul=n(),be=d("p"),this.h()},l(e){const l=El("svelte-u9bgzb",document.head);f=M(l,"META",{name:!0,content:!0}),l.forEach(t),ce=a(e),Me=M(e,"P",{}),kl(Me).forEach(t),ye=a(e),p(J.$$.fragment,e),fe=a(e),g=M(e,"P",{"data-svelte-h":!0}),b(g)!=="svelte-4xrbw1"&&(g.innerHTML=cl),he=a(e),p(T.$$.fragment,e),Je=a(e),w=M(e,"P",{"data-svelte-h":!0}),b(w)!=="svelte-rq0os"&&(w.innerHTML=yl),ge=a(e),U=M(e,"P",{"data-svelte-h":!0}),b(U)!=="svelte-182to9s"&&(U.innerHTML=fl),Te=a(e),p(Z.$$.fragment,e),we=a(e),p(j.$$.fragment,e),Ue=a(e),W=M(e,"P",{"data-svelte-h":!0}),b(W)!=="svelte-1nrwpop"&&(W.innerHTML=hl),Ze=a(e),p(X.$$.fragment,e),je=a(e),p(B.$$.fragment,e),We=a(e),G=M(e,"P",{"data-svelte-h":!0}),b(G)!=="svelte-d2m5pi"&&(G.innerHTML=Jl),Xe=a(e),p(R.$$.fragment,e),Be=a(e),p(I.$$.fragment,e),Ge=a(e),$=M(e,"P",{"data-svelte-h":!0}),b($)!=="svelte-g9kxqu"&&($.textContent=gl),Re=a(e),N=M(e,"UL",{"data-svelte-h":!0}),b(N)!=="svelte-ugiogr"&&(N.innerHTML=Tl),Ie=a(e),v=M(e,"P",{"data-svelte-h":!0}),b(v)!=="svelte-jyc43"&&(v.textContent=wl),$e=a(e),p(k.$$.fragment,e),Ne=a(e),p(C.$$.fragment,e),ve=a(e),x=M(e,"P",{"data-svelte-h":!0}),b(x)!=="svelte-h8xsd7"&&(x.textContent=Ul),ke=a(e),V=M(e,"UL",{"data-svelte-h":!0}),b(V)!=="svelte-bu3ryq"&&(V.innerHTML=Zl),Ce=a(e),S=M(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-1itwfg8"&&(S.textContent=jl),xe=a(e),F=M(e,"P",{"data-svelte-h":!0}),b(F)!=="svelte-1nlmsjk"&&(F.innerHTML=Wl),Ve=a(e),p(E.$$.fragment,e),Se=a(e),p(_.$$.fragment,e),Fe=a(e),Q=M(e,"P",{"data-svelte-h":!0}),b(Q)!=="svelte-s2wxrw"&&(Q.textContent=Xl),Ee=a(e),p(H.$$.fragment,e),_e=a(e),Y=M(e,"P",{"data-svelte-h":!0}),b(Y)!=="svelte-vf0f3x"&&(Y.innerHTML=Bl),Qe=a(e),p(q.$$.fragment,e),He=a(e),h=M(e,"DIV",{class:!0,"data-svelte-h":!0}),b(h)!=="svelte-1pusq1s"&&(h.innerHTML=Gl),Ye=a(e),p(z.$$.fragment,e),qe=a(e),p(L.$$.fragment,e),ze=a(e),p(O.$$.fragment,e),Le=a(e),p(P.$$.fragment,e),Oe=a(e),p(A.$$.fragment,e),Pe=a(e),D=M(e,"P",{"data-svelte-h":!0}),b(D)!=="svelte-rwvcml"&&(D.innerHTML=Rl),Ae=a(e),p(K.$$.fragment,e),De=a(e),p(ee.$$.fragment,e),Ke=a(e),le=M(e,"P",{"data-svelte-h":!0}),b(le)!=="svelte-tg9ftm"&&(le.innerHTML=Il),el=a(e),p(te.$$.fragment,e),ll=a(e),p(se.$$.fragment,e),tl=a(e),ne=M(e,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-gtkw23"&&(ne.innerHTML=$l),sl=a(e),p(ae.$$.fragment,e),nl=a(e),p(ie.$$.fragment,e),al=a(e),pe=M(e,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-1lzmdpv"&&(pe.innerHTML=Nl),il=a(e),p(me.$$.fragment,e),pl=a(e),p(oe.$$.fragment,e),ml=a(e),p(re.$$.fragment,e),ol=a(e),ue=M(e,"P",{"data-svelte-h":!0}),b(ue)!=="svelte-18cakbd"&&(ue.innerHTML=vl),rl=a(e),p(de.$$.fragment,e),ul=a(e),be=M(e,"P",{}),kl(be).forEach(t),this.h()},h(){Ml(f,"name","hf:doc:metadata"),Ml(f,"content",Hl),Ml(h,"class","flex justify-center")},m(e,l){_l(document.head,f),s(e,ce,l),s(e,Me,l),s(e,ye,l),m(J,e,l),s(e,fe,l),s(e,g,l),s(e,he,l),m(T,e,l),s(e,Je,l),s(e,w,l),s(e,ge,l),s(e,U,l),s(e,Te,l),m(Z,e,l),s(e,we,l),m(j,e,l),s(e,Ue,l),s(e,W,l),s(e,Ze,l),m(X,e,l),s(e,je,l),m(B,e,l),s(e,We,l),s(e,G,l),s(e,Xe,l),m(R,e,l),s(e,Be,l),m(I,e,l),s(e,Ge,l),s(e,$,l),s(e,Re,l),s(e,N,l),s(e,Ie,l),s(e,v,l),s(e,$e,l),m(k,e,l),s(e,Ne,l),m(C,e,l),s(e,ve,l),s(e,x,l),s(e,ke,l),s(e,V,l),s(e,Ce,l),s(e,S,l),s(e,xe,l),s(e,F,l),s(e,Ve,l),m(E,e,l),s(e,Se,l),m(_,e,l),s(e,Fe,l),s(e,Q,l),s(e,Ee,l),m(H,e,l),s(e,_e,l),s(e,Y,l),s(e,Qe,l),m(q,e,l),s(e,He,l),s(e,h,l),s(e,Ye,l),m(z,e,l),s(e,qe,l),m(L,e,l),s(e,ze,l),m(O,e,l),s(e,Le,l),m(P,e,l),s(e,Oe,l),m(A,e,l),s(e,Pe,l),s(e,D,l),s(e,Ae,l),m(K,e,l),s(e,De,l),m(ee,e,l),s(e,Ke,l),s(e,le,l),s(e,el,l),m(te,e,l),s(e,ll,l),m(se,e,l),s(e,tl,l),s(e,ne,l),s(e,sl,l),m(ae,e,l),s(e,nl,l),m(ie,e,l),s(e,al,l),s(e,pe,l),s(e,il,l),m(me,e,l),s(e,pl,l),m(oe,e,l),s(e,ml,l),m(re,e,l),s(e,ol,l),s(e,ue,l),s(e,rl,l),m(de,e,l),s(e,ul,l),s(e,be,l),dl=!0},p:xl,i(e){dl||(o(J.$$.fragment,e),o(T.$$.fragment,e),o(Z.$$.fragment,e),o(j.$$.fragment,e),o(X.$$.fragment,e),o(B.$$.fragment,e),o(R.$$.fragment,e),o(I.$$.fragment,e),o(k.$$.fragment,e),o(C.$$.fragment,e),o(E.$$.fragment,e),o(_.$$.fragment,e),o(H.$$.fragment,e),o(q.$$.fragment,e),o(z.$$.fragment,e),o(L.$$.fragment,e),o(O.$$.fragment,e),o(P.$$.fragment,e),o(A.$$.fragment,e),o(K.$$.fragment,e),o(ee.$$.fragment,e),o(te.$$.fragment,e),o(se.$$.fragment,e),o(ae.$$.fragment,e),o(ie.$$.fragment,e),o(me.$$.fragment,e),o(oe.$$.fragment,e),o(re.$$.fragment,e),o(de.$$.fragment,e),dl=!0)},o(e){r(J.$$.fragment,e),r(T.$$.fragment,e),r(Z.$$.fragment,e),r(j.$$.fragment,e),r(X.$$.fragment,e),r(B.$$.fragment,e),r(R.$$.fragment,e),r(I.$$.fragment,e),r(k.$$.fragment,e),r(C.$$.fragment,e),r(E.$$.fragment,e),r(_.$$.fragment,e),r(H.$$.fragment,e),r(q.$$.fragment,e),r(z.$$.fragment,e),r(L.$$.fragment,e),r(O.$$.fragment,e),r(P.$$.fragment,e),r(A.$$.fragment,e),r(K.$$.fragment,e),r(ee.$$.fragment,e),r(te.$$.fragment,e),r(se.$$.fragment,e),r(ae.$$.fragment,e),r(ie.$$.fragment,e),r(me.$$.fragment,e),r(oe.$$.fragment,e),r(re.$$.fragment,e),r(de.$$.fragment,e),dl=!1},d(e){e&&(t(ce),t(Me),t(ye),t(fe),t(g),t(he),t(Je),t(w),t(ge),t(U),t(Te),t(we),t(Ue),t(W),t(Ze),t(je),t(We),t(G),t(Xe),t(Be),t(Ge),t($),t(Re),t(N),t(Ie),t(v),t($e),t(Ne),t(ve),t(x),t(ke),t(V),t(Ce),t(S),t(xe),t(F),t(Ve),t(Se),t(Fe),t(Q),t(Ee),t(_e),t(Y),t(Qe),t(He),t(h),t(Ye),t(qe),t(ze),t(Le),t(Oe),t(Pe),t(D),t(Ae),t(De),t(Ke),t(le),t(el),t(ll),t(tl),t(ne),t(sl),t(nl),t(al),t(pe),t(il),t(pl),t(ml),t(ol),t(ue),t(rl),t(ul),t(be)),t(f),u(J,e),u(T,e),u(Z,e),u(j,e),u(X,e),u(B,e),u(R,e),u(I,e),u(k,e),u(C,e),u(E,e),u(_,e),u(H,e),u(q,e),u(z,e),u(L,e),u(O,e),u(P,e),u(A,e),u(K,e),u(ee,e),u(te,e),u(se,e),u(ae,e),u(ie,e),u(me,e),u(oe,e),u(re,e),u(de,e)}}}const Hl='{"title":"Optimum Inference with ONNX Runtime","local":"optimum-inference-with-onnx-runtime","sections":[{"title":"Switching from Transformers to Optimum","local":"switching-from-transformers-to-optimum","sections":[{"title":"Loading a vanilla Transformers model","local":"loading-a-vanilla-transformers-model","sections":[],"depth":3},{"title":"Pushing ONNX models to the Hugging Face Hub","local":"pushing-onnx-models-to-the-hugging-face-hub","sections":[],"depth":3}],"depth":2},{"title":"Sequence-to-sequence models","local":"sequence-to-sequence-models","sections":[],"depth":2},{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Refining the image output","local":"refining-the-image-output","sections":[],"depth":3}],"depth":2},{"title":"Latent Consistency Models","local":"latent-consistency-models","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2}],"depth":1}';function Yl(bl){return Vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pl extends Sl{constructor(f){super(),Fl(this,f,Yl,Ql,Cl,{})}}export{Pl as component};
