import{s as Ai,n as gi,o as ji}from"../chunks/scheduler.d6170356.js";import{S as Di,i as Qi,g as a,s,r as M,A as bi,h as T,f as t,c as n,j as ki,u as p,x as o,k as mt,y as Ri,a as i,v as U,d as y,t as J,w}from"../chunks/index.fcd4cc08.js";import{C as h}from"../chunks/CodeBlock.7b16bdef.js";import{H as r}from"../chunks/Heading.8660bd0e.js";function vi(ut){let c,Sl,Ll,Zl,m,Wl,u,Ct="Pickle is a widely used serialization format in ML. Most notably, it is the default format for PyTorch model weights.",zl,C,It='There are dangerous arbitrary code execution attacks that can be perpetrated when you load a pickle file. We suggest loading models from users and organizations you trust, relying on signed commits, and/or loading models from TF or Jax formats with the <code>from_tf=True</code> auto-conversion mechanism. We also alleviate this issue by displaying/“vetting” the list of imports in any pickled file, directly on the Hub. Finally, we are experimenting with a new, simple serialization format for weights called <a href="https://github.com/huggingface/safetensors" rel="nofollow"><code>safetensors</code></a>.',Pl,I,Yl,d,dt='From the <a href="https://docs.python.org/3/library/pickle.html" rel="nofollow">official docs</a> :',Xl,O,Ot="<p>The <code>pickle</code> module implements binary protocols for serializing and de-serializing a Python object structure.</p>",ql,k,kt="What this means is that pickle is a serializing protocol, something you use to efficiently share data amongst parties.",Kl,A,At="We call a pickle the binary file that was generated while pickling.",le,g,gt="At its core, the pickle is basically a stack of instructions or opcodes. As you probably have guessed, it’s not human readable. The opcodes are generated when pickling and read sequentially at unpickling. Based on the opcode, a given action is executed.",ee,j,jt="Here’s a small example:",te,D,ie,Q,Dt="When you run this, it will create a pickle file and print the following instructions in your terminal:",se,b,ne,R,Qt='Don’t worry too much about the instructions for now, just know that the <a href="https://docs.python.org/3/library/pickletools.html" rel="nofollow">pickletools</a> module is very useful for analyzing pickles. It allows you to read the instructions in the file <strong><em>without</em></strong> executing any code.',ae,v,bt="Pickle is not simply a serialization protocol, it allows more flexibility by giving the ability to users to run python code at de-serialization time. Doesn’t sound good, does it?",Te,x,oe,N,Rt="As we’ve stated above, de-serializing pickle means that code can be executed. But this comes with certain limitations: you can only reference functions and classes from the top level module; you cannot embed them in the pickle file itself.",Me,F,vt="Back to the drawing board:",pe,$,Ue,V,xt="When we run this script we get the <code>payload.pkl</code> again. When we check the file’s contents:",ye,B,Je,_,Nt="We can see that there isn’t much in there, a few opcodes and the associated data. You might be thinking, so what’s the problem with pickle?",we,H,Ft="Let’s try something else:",re,E,ce,L,$t='Here we’re using the <a href="https://github.com/trailofbits/fickling" rel="nofollow">fickling</a> library for simplicity. It allows us to add pickle instructions to execute code contained in a string via the <code>exec</code> function. This is how you circumvent the fact that you cannot define functions or classes in your pickles: you run exec on python code saved as a string.',he,G,Vt="When you run this, it creates a <code>payload.pkl</code> and prints the following:",fe,S,me,Z,Bt="If we check the contents of the pickle file, we get:",ue,W,Ce,z,_t="Basically, this is what’s happening when you unpickle:",Ie,P,de,Y,Ht="The instructions that pose a threat are <code>STACK_GLOBAL</code>, <code>GLOBAL</code> and <code>REDUCE</code>.",Oe,X,Et="<code>REDUCE</code> is what tells the unpickler to execute the function with the provided arguments and <code>*GLOBAL</code> instructions are telling the unpickler to <code>import</code> stuff.",ke,q,Lt="To sum up, pickle is dangerous because:",Ae,K,Gt="<li>when importing a python module, arbitrary code can be executed</li> <li>you can import builtin functions like <code>eval</code> or <code>exec</code>, which can be used to execute arbitrary code</li> <li>when instantiating an object, the constructor may be called</li>",ge,ll,St="This is why it is stated in most docs using pickle, do not unpickle data from untrusted sources.",je,el,De,tl,Zt="<strong><em>Don’t use pickle</em></strong>",Qe,il,Wt="Sound advice Luc, but pickle is used profusely and isn’t going anywhere soon: finding a new format everyone is happy with and initiating the change will take some time.",be,sl,zt="So what can we do for now?",Re,nl,ve,al,Pt='On the Hub, you have the ability to <a href="./security-gpg">sign your commits with a GPG key</a>. This does <strong>not</strong> guarantee that your file is safe, but it does guarantee the origin of the file.',xe,Tl,Yt="If you know and trust user A and the commit that includes the file on the Hub is signed by user A’s GPG key, it’s pretty safe to assume that you can trust the file.",Ne,ol,Fe,Ml,Xt="TensorFlow and Flax checkpoints are not affected, and can be loaded within PyTorch architectures using the <code>from_tf</code> and <code>from_flax</code> kwargs for the <code>from_pretrained</code> method to circumvent this issue.",$e,pl,qt="E.g.:",Ve,Ul,Be,yl,_e,Jl,Kt='<li><a href="https://msgpack.org/index.html" rel="nofollow">MsgPack</a></li> <li><a href="https://developers.google.com/protocol-buffers" rel="nofollow">Protobuf</a></li> <li><a href="https://capnproto.org/" rel="nofollow">Cap’n’proto</a></li> <li><a href="https://avro.apache.org/" rel="nofollow">Avro</a></li> <li><a href="https://github.com/huggingface/safetensors" rel="nofollow">safetensors</a></li>',He,wl,li="This last format, <code>safetensors</code>, is a simple serialization format that we are working on and experimenting with currently! Please help or contribute if you can 🔥.",Ee,rl,Le,cl,ei='There’s an open discussion in progress at PyTorch on having a <a href="https://github.com/pytorch/pytorch/issues/52181" rel="nofollow">Safe way of loading only weights from *.pt file by default</a> – please chime in there!',Ge,hl,Se,fl,Ze,ml,ti="We have created a security scanner that scans every file pushed to the Hub and runs security checks. At the time of writing, it runs two types of scans:",We,ul,ii="<li>ClamAV scans</li> <li>Pickle Import scans</li>",ze,Cl,si='For ClamAV scans, files are run through the open-source antivirus <a href="https://www.clamav.net" rel="nofollow">ClamAV</a>. While this covers a good amount of dangerous files, it doesn’t cover pickle exploits.',Pe,Il,ni="We have implemented a Pickle Import scan, which extracts the list of imports referenced in a pickle file. Every time you upload a <code>pytorch_model.bin</code> or any other pickled file, this scan is run.",Ye,dl,ai="On the hub the list of imports will be displayed next to each file containing imports. If any import looks suspicious, it will be highlighted.",Xe,f,Ti='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/security-pickle-imports.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/security-pickle-imports-dark.png"/>',qe,Ol,oi='We get this data thanks to <a href="https://docs.python.org/3/library/pickletools.html#pickletools.genops" rel="nofollow"><code>pickletools.genops</code></a> which allows us to read the file without executing potentially dangerous code.',Ke,kl,Mi="Note that this is what allows to know if, when unpickling a file, it will <code>REDUCE</code> on a potentially dangerous function that was imported by <code>*GLOBAL</code>.",lt,Al,pi=`<strong><em>Disclaimer</em></strong>: this is not 100% foolproof. It is your responsibility as a user to check if something is safe or not. We are not actively auditing python packages for safety, the safe/unsafe imports lists we have are maintained in a best-effort manner.
Please contact us if you think something is not safe, and we flag it as such, by sending us an email to website at huggingface.co`,et,gl,tt,jl,Ui='One could think of creating a custom <a href="https://docs.python.org/3/library/pickle.html#pickle.Unpickler" rel="nofollow">Unpickler</a> in the likes of <a href="https://github.com/facebookresearch/CrypTen/blob/main/crypten/common/serial.py" rel="nofollow">this one</a>. But as we can see in this <a href="https://ctftime.org/writeup/16723" rel="nofollow">sophisticated exploit</a>, this won’t work.',it,Dl,yi="Thankfully, there is always a trace of the <code>eval</code> import, so reading the opcodes directly should allow to catch malicious usage.",st,Ql,Ji="The current solution I propose is creating a file resembling a <code>.gitignore</code> but for imports.",nt,bl,wi="This file would be a whitelist of imports that would make a <code>pytorch_model.bin</code> file flagged as dangerous if there are imports not included in the whitelist.",at,Rl,ri="One could imagine having a regex-ish format where you could allow all numpy submodules for instance via a simple line like: <code>numpy.*</code>.",Tt,vl,ot,xl,ci='<a href="https://docs.python.org/3/library/pickle.html#what-can-be-pickled-and-unpickled" rel="nofollow">pickle - Python object serialization - Python 3.10.6 documentation</a>',Mt,Nl,hi='<a href="https://intoli.com/blog/dangerous-pickles/" rel="nofollow">Dangerous Pickles - Malicious Python Serialization</a>',pt,Fl,fi='<a href="https://github.com/trailofbits/fickling" rel="nofollow">GitHub - trailofbits/fickling: A Python pickling decompiler and static analyzer</a>',Ut,$l,mi='<a href="https://davidhamann.de/2020/04/05/exploiting-python-pickle/" rel="nofollow">Exploiting Python pickles</a>',yt,Vl,ui='<a href="https://github.com/python/cpython/blob/3.10/Lib/pickletools.py" rel="nofollow">cpython/pickletools.py at 3.10 · python/cpython</a>',Jt,Bl,Ci='<a href="https://github.com/python/cpython/blob/3.10/Lib/pickle.py" rel="nofollow">cpython/pickle.py at 3.10 · python/cpython</a>',wt,_l,Ii='<a href="https://github.com/facebookresearch/CrypTen/blob/main/crypten/common/serial.py" rel="nofollow">CrypTen/serial.py at main · facebookresearch/CrypTen</a>',rt,Hl,di='<a href="https://ctftime.org/writeup/16723" rel="nofollow">CTFtime.org / Balsn CTF 2019 / pyshv1 / Writeup</a>',ct,El,Oi='<a href="https://github.com/moreati/pickle-fuzz" rel="nofollow">Rehabilitating Python’s pickle module</a>',ht,Gl,ft;return m=new r({props:{title:"Pickle Scanning",local:"pickle-scanning",headingTag:"h1"}}),I=new r({props:{title:"What is a pickle?",local:"what-is-a-pickle",headingTag:"h2"}}),D=new h({props:{code:"aW1wb3J0JTIwcGlja2xlJTBBaW1wb3J0JTIwcGlja2xldG9vbHMlMEElMEF2YXIlMjAlM0QlMjAlMjJkYXRhJTIwSSUyMHdhbnQlMjB0byUyMHNoYXJlJTIwd2l0aCUyMGElMjBmcmllbmQlMjIlMEElMEElMjMlMjBzdG9yZSUyMHRoZSUyMHBpY2tsZSUyMGRhdGElMjBpbiUyMGElMjBmaWxlJTIwbmFtZWQlMjAncGF5bG9hZC5wa2wnJTBBd2l0aCUyMG9wZW4oJ3BheWxvYWQucGtsJyUyQyUyMCd3YicpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwcGlja2xlLmR1bXAodmFyJTJDJTIwZiklMEElMEElMjMlMjBkaXNhc3NlbWJsZSUyMHRoZSUyMHBpY2tsZSUwQSUyMyUyMGFuZCUyMHByaW50JTIwdGhlJTIwaW5zdHJ1Y3Rpb25zJTIwdG8lMjB0aGUlMjBjb21tYW5kJTIwbGluZSUwQXdpdGglMjBvcGVuKCdwYXlsb2FkLnBrbCclMkMlMjAncmInKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMHBpY2tsZXRvb2xzLmRpcyhmKQ==",highlighted:`<span class="hljs-keyword">import</span> pickle
<span class="hljs-keyword">import</span> pickletools

var = <span class="hljs-string">&quot;data I want to share with a friend&quot;</span>

<span class="hljs-comment"># store the pickle data in a file named &#x27;payload.pkl&#x27;</span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;payload.pkl&#x27;</span>, <span class="hljs-string">&#x27;wb&#x27;</span>) <span class="hljs-keyword">as</span> f:
    pickle.dump(var, f)

<span class="hljs-comment"># disassemble the pickle</span>
<span class="hljs-comment"># and print the instructions to the command line</span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;payload.pkl&#x27;</span>, <span class="hljs-string">&#x27;rb&#x27;</span>) <span class="hljs-keyword">as</span> f:
    pickletools.dis(f)`,wrap:!1}}),b=new h({props:{code:"JTIwJTIwJTIwJTIwMCUzQSUyMCU1Q3g4MCUyMFBST1RPJTIwJTIwJTIwJTIwJTIwJTIwNCUwQSUyMCUyMCUyMCUyMDIlM0ElMjAlNUN4OTUlMjBGUkFNRSUyMCUyMCUyMCUyMCUyMCUyMDQ4JTBBJTIwJTIwJTIwMTElM0ElMjAlNUN4OGMlMjBTSE9SVF9CSU5VTklDT0RFJTIwJ2RhdGElMjBJJTIwd2FudCUyMHRvJTIwc2hhcmUlMjB3aXRoJTIwYSUyMGZyaWVuZCclMEElMjAlMjAlMjA1NyUzQSUyMCU1Q3g5NCUyME1FTU9JWkUlMjAlMjAlMjAlMjAoYXMlMjAwKSUwQSUyMCUyMCUyMDU4JTNBJTIwLiUyMCUyMCUyMCUyMFNUT1AlMEFoaWdoZXN0JTIwcHJvdG9jb2wlMjBhbW9uZyUyMG9wY29kZXMlMjAlM0QlMjA0",highlighted:`    <span class="hljs-number">0</span>: \\x80 PROTO      <span class="hljs-number">4</span>
    <span class="hljs-number">2</span>: \\x95 FRAME      <span class="hljs-number">48</span>
   <span class="hljs-number">11</span>: \\x8c SHORT_BINUNICODE <span class="hljs-string">&#x27;data I want to share with a friend&#x27;</span>
   <span class="hljs-number">57</span>: \\x94 MEMOIZE    (<span class="hljs-keyword">as</span> <span class="hljs-number">0</span>)
   <span class="hljs-number">58</span>: .    STOP
highest protocol among opcodes = <span class="hljs-number">4</span>`,wrap:!1}}),x=new r({props:{title:"Why is it dangerous?",local:"why-is-it-dangerous",headingTag:"h2"}}),$=new h({props:{code:"aW1wb3J0JTIwcGlja2xlJTBBaW1wb3J0JTIwcGlja2xldG9vbHMlMEElMEFjbGFzcyUyMERhdGElM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwaW1wb3J0YW50X3N0dWZmJTNBJTIwc3RyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaW1wb3J0YW50X3N0dWZmJTIwJTNEJTIwaW1wb3J0YW50X3N0dWZmJTBBJTBBZCUyMCUzRCUyMERhdGEoJTIyNDIlMjIpJTBBJTBBd2l0aCUyMG9wZW4oJ3BheWxvYWQucGtsJyUyQyUyMCd3YicpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwcGlja2xlLmR1bXAoZCUyQyUyMGYp",highlighted:`<span class="hljs-keyword">import</span> pickle
<span class="hljs-keyword">import</span> pickletools

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Data</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, important_stuff: <span class="hljs-built_in">str</span></span>):
        self.important_stuff = important_stuff

d = Data(<span class="hljs-string">&quot;42&quot;</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;payload.pkl&#x27;</span>, <span class="hljs-string">&#x27;wb&#x27;</span>) <span class="hljs-keyword">as</span> f:
    pickle.dump(d, f)`,wrap:!1}}),B=new h({props:{code:"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",highlighted:`
<span class="hljs-comment"># cat payload.pkl</span>
__main__Data)}important_stuff42sb.%

<span class="hljs-comment"># hexyl payload.pkl</span>
┌────────┬─────────────────────────┬─────────────────────────┬────────┬────────┐
│00000000│ 80 04 95 33 00 00 00 00 ┊ 00 00 00 8c 08 5f 5f 6d │×•×30000┊000×•__m│
│00000010│ 61 69 6e 5f 5f 94 8c 04 ┊ 44 61 74 61 94 93 94 29 │ain__××•┊Data×××)│
│00000020│ 81 94 7d 94 8c 0f 69 6d ┊ 70 6f 72 74 61 6e 74 5f │××}××•im┊portant_│
│00000030│ 73 74 75 66 66 94 8c 02 ┊ 34 32 94 73 62 2e       │stuff××•┊42×sb.  │
└────────┴─────────────────────────┴─────────────────────────┴────────┴────────┘`,wrap:!1}}),E=new h({props:{code:"ZnJvbSUyMGZpY2tsaW5nLnBpY2tsZSUyMGltcG9ydCUyMFBpY2tsZWQlMEFpbXBvcnQlMjBwaWNrbGUlMEElMEElMjMlMjBDcmVhdGUlMjBhJTIwbWFsaWNpb3VzJTIwcGlja2xlJTBBZGF0YSUyMCUzRCUyMCUyMm15JTIwZnJpZW5kJTIwbmVlZHMlMjB0byUyMGtub3clMjB0aGlzJTIyJTBBJTBBcGlja2xlX2JpbiUyMCUzRCUyMHBpY2tsZS5kdW1wcyhkYXRhKSUwQSUwQXAlMjAlM0QlMjBQaWNrbGVkLmxvYWQocGlja2xlX2JpbiklMEElMEFwLmluc2VydF9weXRob25fZXhlYygncHJpbnQoJTIyeW91JTVDJ3ZlJTIwYmVlbiUyMHB3bmVkJTIwISUyMiknKSUwQSUwQXdpdGglMjBvcGVuKCdwYXlsb2FkLnBrbCclMkMlMjAnd2InKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMHAuZHVtcChmKSUwQSUwQSUyMyUyMGlubm9jZW50bHklMjB1bnBpY2tsZSUyMGFuZCUyMGdldCUyMHlvdXIlMjBmcmllbmQncyUyMGRhdGElMEF3aXRoJTIwb3BlbigncGF5bG9hZC5wa2wnJTJDJTIwJ3JiJyklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBkYXRhJTIwJTNEJTIwcGlja2xlLmxvYWQoZiklMEElMjAlMjAlMjAlMjBwcmludChkYXRhKQ==",highlighted:`<span class="hljs-keyword">from</span> fickling.pickle <span class="hljs-keyword">import</span> Pickled
<span class="hljs-keyword">import</span> pickle

<span class="hljs-comment"># Create a malicious pickle</span>
data = <span class="hljs-string">&quot;my friend needs to know this&quot;</span>

pickle_bin = pickle.dumps(data)

p = Pickled.load(pickle_bin)

p.insert_python_exec(<span class="hljs-string">&#x27;print(&quot;you\\&#x27;ve been pwned !&quot;)&#x27;</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;payload.pkl&#x27;</span>, <span class="hljs-string">&#x27;wb&#x27;</span>) <span class="hljs-keyword">as</span> f:
    p.dump(f)

<span class="hljs-comment"># innocently unpickle and get your friend&#x27;s data</span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;payload.pkl&#x27;</span>, <span class="hljs-string">&#x27;rb&#x27;</span>) <span class="hljs-keyword">as</span> f:
    data = pickle.load(f)
    <span class="hljs-built_in">print</span>(data)`,wrap:!1}}),S=new h({props:{code:"eW91J3ZlJTIwYmVlbiUyMHB3bmVkJTIwISUwQW15JTIwZnJpZW5kJTIwbmVlZHMlMjB0byUyMGtub3clMjB0aGlz",highlighted:`you<span class="hljs-comment">&#x27;ve been pwned !</span>
my <span class="hljs-keyword">friend</span> needs <span class="hljs-keyword">to</span> know this`,wrap:!1}}),W=new h({props:{code:"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",highlighted:`<span class="hljs-comment"># cat payload.pkl</span>
c__builtin__
<span class="hljs-built_in">exec</span>
(Vprint(<span class="hljs-string">&quot;you&#x27;ve been pwned !&quot;</span>)
tR my friend needs to know this.%

<span class="hljs-comment"># hexyl payload.pkl</span>
┌────────┬─────────────────────────┬─────────────────────────┬────────┬────────┐
│00000000│ 63 5f 5f 62 75 69 6c 74 ┊ 69 6e 5f 5f 0a 65 78 65 │c__built┊in___exe│
│00000010│ 63 0a 28 56 70 72 69 6e ┊ 74 28 22 79 6f 75 27 76 │c_(Vprin┊t(<span class="hljs-string">&quot;you&#x27;v│
│00000020│ 65 20 62 65 65 6e 20 70 ┊ 77 6e 65 64 20 21 22 29 │e been p┊wned !&quot;</span>)│
│00000030│ 0a 74 52 80 04 95 20 00 ┊ 00 00 00 00 00 00 8c 1c │_tR×•× 0┊000000×•│
│00000040│ 6d 79 20 66 72 69 65 6e ┊ 64 20 6e 65 65 64 73 20 │my frien┊d needs │
│00000050│ 74 6f 20 6b 6e 6f 77 20 ┊ 74 68 69 73 94 2e       │to know ┊this×.  │
└────────┴─────────────────────────┴─────────────────────────┴────────┴────────┘`,wrap:!1}}),P=new h({props:{code:"JTIzJTIwLi4uJTBBb3Bjb2Rlc19zdGFjayUyMCUzRCUyMCU1QmV4ZWNfZnVuYyUyQyUyMCUyMm1hbGljaW91cyUyMGFyZ3VtZW50JTIyJTJDJTIwJTIyUkVEVUNFJTIyJTVEJTBBb3Bjb2RlJTIwJTNEJTIwc3RhY2sucG9wKCklMEFpZiUyMG9wY29kZSUyMCUzRCUzRCUyMCUyMlJFRFVDRSUyMiUzQSUwQSUyMCUyMCUyMCUyMGFyZyUyMCUzRCUyMG9wY29kZXNfc3RhY2sucG9wKCklMEElMjAlMjAlMjAlMjBjYWxsYWJsZSUyMCUzRCUyMG9wY29kZXNfc3RhY2sucG9wKCklMEElMjAlMjAlMjAlMjBvcGNvZGVzX3N0YWNrLmFwcGVuZChjYWxsYWJsZShhcmcpKSUwQSUyMyUyMC4uLg==",highlighted:`<span class="hljs-comment"># ...</span>
opcodes_stack = [exec_func, <span class="hljs-string">&quot;malicious argument&quot;</span>, <span class="hljs-string">&quot;REDUCE&quot;</span>]
opcode = stack.pop()
<span class="hljs-keyword">if</span> opcode == <span class="hljs-string">&quot;REDUCE&quot;</span>:
    arg = opcodes_stack.pop()
    <span class="hljs-built_in">callable</span> = opcodes_stack.pop()
    opcodes_stack.append(<span class="hljs-built_in">callable</span>(arg))
<span class="hljs-comment"># ...</span>`,wrap:!1}}),el=new r({props:{title:"Mitigation Strategies",local:"mitigation-strategies",headingTag:"h2"}}),nl=new r({props:{title:"Load files from users and organizations you trust",local:"load-files-from-users-and-organizations-you-trust",headingTag:"h3"}}),ol=new r({props:{title:"Load model weights from TF or Flax",local:"load-model-weights-from-tf-or-flax",headingTag:"h3"}}),Ul=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIlMkMlMjBmcm9tX2ZsYXglM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, from_flax=<span class="hljs-literal">True</span>)`,wrap:!1}}),yl=new r({props:{title:"Use your own serialization format",local:"use-your-own-serialization-format",headingTag:"h3"}}),rl=new r({props:{title:"Improve torch.load/save",local:"improve-torchloadsave",headingTag:"h3"}}),hl=new r({props:{title:"Hub’s Security Scanner",local:"hubs-security-scanner",headingTag:"h3"}}),fl=new r({props:{title:"What we have now",local:"what-we-have-now",headingTag:"h4"}}),gl=new r({props:{title:"Potential solutions",local:"potential-solutions",headingTag:"h4"}}),vl=new r({props:{title:"Further Reading",local:"further-reading",headingTag:"h2"}}),{c(){c=a("meta"),Sl=s(),Ll=a("p"),Zl=s(),M(m.$$.fragment),Wl=s(),u=a("p"),u.textContent=Ct,zl=s(),C=a("p"),C.innerHTML=It,Pl=s(),M(I.$$.fragment),Yl=s(),d=a("p"),d.innerHTML=dt,Xl=s(),O=a("blockquote"),O.innerHTML=Ot,ql=s(),k=a("p"),k.textContent=kt,Kl=s(),A=a("p"),A.textContent=At,le=s(),g=a("p"),g.textContent=gt,ee=s(),j=a("p"),j.textContent=jt,te=s(),M(D.$$.fragment),ie=s(),Q=a("p"),Q.textContent=Dt,se=s(),M(b.$$.fragment),ne=s(),R=a("p"),R.innerHTML=Qt,ae=s(),v=a("p"),v.textContent=bt,Te=s(),M(x.$$.fragment),oe=s(),N=a("p"),N.textContent=Rt,Me=s(),F=a("p"),F.textContent=vt,pe=s(),M($.$$.fragment),Ue=s(),V=a("p"),V.innerHTML=xt,ye=s(),M(B.$$.fragment),Je=s(),_=a("p"),_.textContent=Nt,we=s(),H=a("p"),H.textContent=Ft,re=s(),M(E.$$.fragment),ce=s(),L=a("p"),L.innerHTML=$t,he=s(),G=a("p"),G.innerHTML=Vt,fe=s(),M(S.$$.fragment),me=s(),Z=a("p"),Z.textContent=Bt,ue=s(),M(W.$$.fragment),Ce=s(),z=a("p"),z.textContent=_t,Ie=s(),M(P.$$.fragment),de=s(),Y=a("p"),Y.innerHTML=Ht,Oe=s(),X=a("p"),X.innerHTML=Et,ke=s(),q=a("p"),q.textContent=Lt,Ae=s(),K=a("ul"),K.innerHTML=Gt,ge=s(),ll=a("p"),ll.textContent=St,je=s(),M(el.$$.fragment),De=s(),tl=a("p"),tl.innerHTML=Zt,Qe=s(),il=a("p"),il.textContent=Wt,be=s(),sl=a("p"),sl.textContent=zt,Re=s(),M(nl.$$.fragment),ve=s(),al=a("p"),al.innerHTML=Pt,xe=s(),Tl=a("p"),Tl.textContent=Yt,Ne=s(),M(ol.$$.fragment),Fe=s(),Ml=a("p"),Ml.innerHTML=Xt,$e=s(),pl=a("p"),pl.textContent=qt,Ve=s(),M(Ul.$$.fragment),Be=s(),M(yl.$$.fragment),_e=s(),Jl=a("ul"),Jl.innerHTML=Kt,He=s(),wl=a("p"),wl.innerHTML=li,Ee=s(),M(rl.$$.fragment),Le=s(),cl=a("p"),cl.innerHTML=ei,Ge=s(),M(hl.$$.fragment),Se=s(),M(fl.$$.fragment),Ze=s(),ml=a("p"),ml.textContent=ti,We=s(),ul=a("ul"),ul.innerHTML=ii,ze=s(),Cl=a("p"),Cl.innerHTML=si,Pe=s(),Il=a("p"),Il.innerHTML=ni,Ye=s(),dl=a("p"),dl.textContent=ai,Xe=s(),f=a("div"),f.innerHTML=Ti,qe=s(),Ol=a("p"),Ol.innerHTML=oi,Ke=s(),kl=a("p"),kl.innerHTML=Mi,lt=s(),Al=a("p"),Al.innerHTML=pi,et=s(),M(gl.$$.fragment),tt=s(),jl=a("p"),jl.innerHTML=Ui,it=s(),Dl=a("p"),Dl.innerHTML=yi,st=s(),Ql=a("p"),Ql.innerHTML=Ji,nt=s(),bl=a("p"),bl.innerHTML=wi,at=s(),Rl=a("p"),Rl.innerHTML=ri,Tt=s(),M(vl.$$.fragment),ot=s(),xl=a("p"),xl.innerHTML=ci,Mt=s(),Nl=a("p"),Nl.innerHTML=hi,pt=s(),Fl=a("p"),Fl.innerHTML=fi,Ut=s(),$l=a("p"),$l.innerHTML=mi,yt=s(),Vl=a("p"),Vl.innerHTML=ui,Jt=s(),Bl=a("p"),Bl.innerHTML=Ci,wt=s(),_l=a("p"),_l.innerHTML=Ii,rt=s(),Hl=a("p"),Hl.innerHTML=di,ct=s(),El=a("p"),El.innerHTML=Oi,ht=s(),Gl=a("p"),this.h()},l(l){const e=bi("svelte-u9bgzb",document.head);c=T(e,"META",{name:!0,content:!0}),e.forEach(t),Sl=n(l),Ll=T(l,"P",{}),ki(Ll).forEach(t),Zl=n(l),p(m.$$.fragment,l),Wl=n(l),u=T(l,"P",{"data-svelte-h":!0}),o(u)!=="svelte-fqsq33"&&(u.textContent=Ct),zl=n(l),C=T(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-a29lns"&&(C.innerHTML=It),Pl=n(l),p(I.$$.fragment,l),Yl=n(l),d=T(l,"P",{"data-svelte-h":!0}),o(d)!=="svelte-t990cu"&&(d.innerHTML=dt),Xl=n(l),O=T(l,"BLOCKQUOTE",{"data-svelte-h":!0}),o(O)!=="svelte-mvgji8"&&(O.innerHTML=Ot),ql=n(l),k=T(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-xlsbn2"&&(k.textContent=kt),Kl=n(l),A=T(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-crw8fq"&&(A.textContent=At),le=n(l),g=T(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-903ikp"&&(g.textContent=gt),ee=n(l),j=T(l,"P",{"data-svelte-h":!0}),o(j)!=="svelte-ybkvbq"&&(j.textContent=jt),te=n(l),p(D.$$.fragment,l),ie=n(l),Q=T(l,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-dc6jzh"&&(Q.textContent=Dt),se=n(l),p(b.$$.fragment,l),ne=n(l),R=T(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-2o2p4t"&&(R.innerHTML=Qt),ae=n(l),v=T(l,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1lc08qc"&&(v.textContent=bt),Te=n(l),p(x.$$.fragment,l),oe=n(l),N=T(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-18mv2f5"&&(N.textContent=Rt),Me=n(l),F=T(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-qlmkz7"&&(F.textContent=vt),pe=n(l),p($.$$.fragment,l),Ue=n(l),V=T(l,"P",{"data-svelte-h":!0}),o(V)!=="svelte-45qs4"&&(V.innerHTML=xt),ye=n(l),p(B.$$.fragment,l),Je=n(l),_=T(l,"P",{"data-svelte-h":!0}),o(_)!=="svelte-162o2y5"&&(_.textContent=Nt),we=n(l),H=T(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1cipmup"&&(H.textContent=Ft),re=n(l),p(E.$$.fragment,l),ce=n(l),L=T(l,"P",{"data-svelte-h":!0}),o(L)!=="svelte-tiwo6o"&&(L.innerHTML=$t),he=n(l),G=T(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-exjbyy"&&(G.innerHTML=Vt),fe=n(l),p(S.$$.fragment,l),me=n(l),Z=T(l,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-f6hcto"&&(Z.textContent=Bt),ue=n(l),p(W.$$.fragment,l),Ce=n(l),z=T(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-17mv8nc"&&(z.textContent=_t),Ie=n(l),p(P.$$.fragment,l),de=n(l),Y=T(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1ywjbrq"&&(Y.innerHTML=Ht),Oe=n(l),X=T(l,"P",{"data-svelte-h":!0}),o(X)!=="svelte-2a921e"&&(X.innerHTML=Et),ke=n(l),q=T(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1anxjjv"&&(q.textContent=Lt),Ae=n(l),K=T(l,"UL",{"data-svelte-h":!0}),o(K)!=="svelte-tgdm9a"&&(K.innerHTML=Gt),ge=n(l),ll=T(l,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-nlb4po"&&(ll.textContent=St),je=n(l),p(el.$$.fragment,l),De=n(l),tl=T(l,"P",{"data-svelte-h":!0}),o(tl)!=="svelte-1gahowb"&&(tl.innerHTML=Zt),Qe=n(l),il=T(l,"P",{"data-svelte-h":!0}),o(il)!=="svelte-1i4ndwq"&&(il.textContent=Wt),be=n(l),sl=T(l,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-1akd8xr"&&(sl.textContent=zt),Re=n(l),p(nl.$$.fragment,l),ve=n(l),al=T(l,"P",{"data-svelte-h":!0}),o(al)!=="svelte-18verv9"&&(al.innerHTML=Pt),xe=n(l),Tl=T(l,"P",{"data-svelte-h":!0}),o(Tl)!=="svelte-xz3ko3"&&(Tl.textContent=Yt),Ne=n(l),p(ol.$$.fragment,l),Fe=n(l),Ml=T(l,"P",{"data-svelte-h":!0}),o(Ml)!=="svelte-gbqaor"&&(Ml.innerHTML=Xt),$e=n(l),pl=T(l,"P",{"data-svelte-h":!0}),o(pl)!=="svelte-oz78gk"&&(pl.textContent=qt),Ve=n(l),p(Ul.$$.fragment,l),Be=n(l),p(yl.$$.fragment,l),_e=n(l),Jl=T(l,"UL",{"data-svelte-h":!0}),o(Jl)!=="svelte-iyr210"&&(Jl.innerHTML=Kt),He=n(l),wl=T(l,"P",{"data-svelte-h":!0}),o(wl)!=="svelte-ztaxgy"&&(wl.innerHTML=li),Ee=n(l),p(rl.$$.fragment,l),Le=n(l),cl=T(l,"P",{"data-svelte-h":!0}),o(cl)!=="svelte-15ucwe"&&(cl.innerHTML=ei),Ge=n(l),p(hl.$$.fragment,l),Se=n(l),p(fl.$$.fragment,l),Ze=n(l),ml=T(l,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-65c4de"&&(ml.textContent=ti),We=n(l),ul=T(l,"UL",{"data-svelte-h":!0}),o(ul)!=="svelte-1zxf3f"&&(ul.innerHTML=ii),ze=n(l),Cl=T(l,"P",{"data-svelte-h":!0}),o(Cl)!=="svelte-g06wit"&&(Cl.innerHTML=si),Pe=n(l),Il=T(l,"P",{"data-svelte-h":!0}),o(Il)!=="svelte-1hmoht6"&&(Il.innerHTML=ni),Ye=n(l),dl=T(l,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-3ixeiy"&&(dl.textContent=ai),Xe=n(l),f=T(l,"DIV",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-1skhc0f"&&(f.innerHTML=Ti),qe=n(l),Ol=T(l,"P",{"data-svelte-h":!0}),o(Ol)!=="svelte-wdhs2f"&&(Ol.innerHTML=oi),Ke=n(l),kl=T(l,"P",{"data-svelte-h":!0}),o(kl)!=="svelte-1bjlcuv"&&(kl.innerHTML=Mi),lt=n(l),Al=T(l,"P",{"data-svelte-h":!0}),o(Al)!=="svelte-t5sie"&&(Al.innerHTML=pi),et=n(l),p(gl.$$.fragment,l),tt=n(l),jl=T(l,"P",{"data-svelte-h":!0}),o(jl)!=="svelte-17489ml"&&(jl.innerHTML=Ui),it=n(l),Dl=T(l,"P",{"data-svelte-h":!0}),o(Dl)!=="svelte-4971ge"&&(Dl.innerHTML=yi),st=n(l),Ql=T(l,"P",{"data-svelte-h":!0}),o(Ql)!=="svelte-bttwre"&&(Ql.innerHTML=Ji),nt=n(l),bl=T(l,"P",{"data-svelte-h":!0}),o(bl)!=="svelte-1her4zo"&&(bl.innerHTML=wi),at=n(l),Rl=T(l,"P",{"data-svelte-h":!0}),o(Rl)!=="svelte-19plnsx"&&(Rl.innerHTML=ri),Tt=n(l),p(vl.$$.fragment,l),ot=n(l),xl=T(l,"P",{"data-svelte-h":!0}),o(xl)!=="svelte-dshrcb"&&(xl.innerHTML=ci),Mt=n(l),Nl=T(l,"P",{"data-svelte-h":!0}),o(Nl)!=="svelte-1nbw5zj"&&(Nl.innerHTML=hi),pt=n(l),Fl=T(l,"P",{"data-svelte-h":!0}),o(Fl)!=="svelte-1pxtenc"&&(Fl.innerHTML=fi),Ut=n(l),$l=T(l,"P",{"data-svelte-h":!0}),o($l)!=="svelte-dgsssn"&&($l.innerHTML=mi),yt=n(l),Vl=T(l,"P",{"data-svelte-h":!0}),o(Vl)!=="svelte-9sknvp"&&(Vl.innerHTML=ui),Jt=n(l),Bl=T(l,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-yi9gp3"&&(Bl.innerHTML=Ci),wt=n(l),_l=T(l,"P",{"data-svelte-h":!0}),o(_l)!=="svelte-162i3ur"&&(_l.innerHTML=Ii),rt=n(l),Hl=T(l,"P",{"data-svelte-h":!0}),o(Hl)!=="svelte-1uviqpm"&&(Hl.innerHTML=di),ct=n(l),El=T(l,"P",{"data-svelte-h":!0}),o(El)!=="svelte-1bxqg0w"&&(El.innerHTML=Oi),ht=n(l),Gl=T(l,"P",{}),ki(Gl).forEach(t),this.h()},h(){mt(c,"name","hf:doc:metadata"),mt(c,"content",xi),mt(f,"class","flex justify-center")},m(l,e){Ri(document.head,c),i(l,Sl,e),i(l,Ll,e),i(l,Zl,e),U(m,l,e),i(l,Wl,e),i(l,u,e),i(l,zl,e),i(l,C,e),i(l,Pl,e),U(I,l,e),i(l,Yl,e),i(l,d,e),i(l,Xl,e),i(l,O,e),i(l,ql,e),i(l,k,e),i(l,Kl,e),i(l,A,e),i(l,le,e),i(l,g,e),i(l,ee,e),i(l,j,e),i(l,te,e),U(D,l,e),i(l,ie,e),i(l,Q,e),i(l,se,e),U(b,l,e),i(l,ne,e),i(l,R,e),i(l,ae,e),i(l,v,e),i(l,Te,e),U(x,l,e),i(l,oe,e),i(l,N,e),i(l,Me,e),i(l,F,e),i(l,pe,e),U($,l,e),i(l,Ue,e),i(l,V,e),i(l,ye,e),U(B,l,e),i(l,Je,e),i(l,_,e),i(l,we,e),i(l,H,e),i(l,re,e),U(E,l,e),i(l,ce,e),i(l,L,e),i(l,he,e),i(l,G,e),i(l,fe,e),U(S,l,e),i(l,me,e),i(l,Z,e),i(l,ue,e),U(W,l,e),i(l,Ce,e),i(l,z,e),i(l,Ie,e),U(P,l,e),i(l,de,e),i(l,Y,e),i(l,Oe,e),i(l,X,e),i(l,ke,e),i(l,q,e),i(l,Ae,e),i(l,K,e),i(l,ge,e),i(l,ll,e),i(l,je,e),U(el,l,e),i(l,De,e),i(l,tl,e),i(l,Qe,e),i(l,il,e),i(l,be,e),i(l,sl,e),i(l,Re,e),U(nl,l,e),i(l,ve,e),i(l,al,e),i(l,xe,e),i(l,Tl,e),i(l,Ne,e),U(ol,l,e),i(l,Fe,e),i(l,Ml,e),i(l,$e,e),i(l,pl,e),i(l,Ve,e),U(Ul,l,e),i(l,Be,e),U(yl,l,e),i(l,_e,e),i(l,Jl,e),i(l,He,e),i(l,wl,e),i(l,Ee,e),U(rl,l,e),i(l,Le,e),i(l,cl,e),i(l,Ge,e),U(hl,l,e),i(l,Se,e),U(fl,l,e),i(l,Ze,e),i(l,ml,e),i(l,We,e),i(l,ul,e),i(l,ze,e),i(l,Cl,e),i(l,Pe,e),i(l,Il,e),i(l,Ye,e),i(l,dl,e),i(l,Xe,e),i(l,f,e),i(l,qe,e),i(l,Ol,e),i(l,Ke,e),i(l,kl,e),i(l,lt,e),i(l,Al,e),i(l,et,e),U(gl,l,e),i(l,tt,e),i(l,jl,e),i(l,it,e),i(l,Dl,e),i(l,st,e),i(l,Ql,e),i(l,nt,e),i(l,bl,e),i(l,at,e),i(l,Rl,e),i(l,Tt,e),U(vl,l,e),i(l,ot,e),i(l,xl,e),i(l,Mt,e),i(l,Nl,e),i(l,pt,e),i(l,Fl,e),i(l,Ut,e),i(l,$l,e),i(l,yt,e),i(l,Vl,e),i(l,Jt,e),i(l,Bl,e),i(l,wt,e),i(l,_l,e),i(l,rt,e),i(l,Hl,e),i(l,ct,e),i(l,El,e),i(l,ht,e),i(l,Gl,e),ft=!0},p:gi,i(l){ft||(y(m.$$.fragment,l),y(I.$$.fragment,l),y(D.$$.fragment,l),y(b.$$.fragment,l),y(x.$$.fragment,l),y($.$$.fragment,l),y(B.$$.fragment,l),y(E.$$.fragment,l),y(S.$$.fragment,l),y(W.$$.fragment,l),y(P.$$.fragment,l),y(el.$$.fragment,l),y(nl.$$.fragment,l),y(ol.$$.fragment,l),y(Ul.$$.fragment,l),y(yl.$$.fragment,l),y(rl.$$.fragment,l),y(hl.$$.fragment,l),y(fl.$$.fragment,l),y(gl.$$.fragment,l),y(vl.$$.fragment,l),ft=!0)},o(l){J(m.$$.fragment,l),J(I.$$.fragment,l),J(D.$$.fragment,l),J(b.$$.fragment,l),J(x.$$.fragment,l),J($.$$.fragment,l),J(B.$$.fragment,l),J(E.$$.fragment,l),J(S.$$.fragment,l),J(W.$$.fragment,l),J(P.$$.fragment,l),J(el.$$.fragment,l),J(nl.$$.fragment,l),J(ol.$$.fragment,l),J(Ul.$$.fragment,l),J(yl.$$.fragment,l),J(rl.$$.fragment,l),J(hl.$$.fragment,l),J(fl.$$.fragment,l),J(gl.$$.fragment,l),J(vl.$$.fragment,l),ft=!1},d(l){l&&(t(Sl),t(Ll),t(Zl),t(Wl),t(u),t(zl),t(C),t(Pl),t(Yl),t(d),t(Xl),t(O),t(ql),t(k),t(Kl),t(A),t(le),t(g),t(ee),t(j),t(te),t(ie),t(Q),t(se),t(ne),t(R),t(ae),t(v),t(Te),t(oe),t(N),t(Me),t(F),t(pe),t(Ue),t(V),t(ye),t(Je),t(_),t(we),t(H),t(re),t(ce),t(L),t(he),t(G),t(fe),t(me),t(Z),t(ue),t(Ce),t(z),t(Ie),t(de),t(Y),t(Oe),t(X),t(ke),t(q),t(Ae),t(K),t(ge),t(ll),t(je),t(De),t(tl),t(Qe),t(il),t(be),t(sl),t(Re),t(ve),t(al),t(xe),t(Tl),t(Ne),t(Fe),t(Ml),t($e),t(pl),t(Ve),t(Be),t(_e),t(Jl),t(He),t(wl),t(Ee),t(Le),t(cl),t(Ge),t(Se),t(Ze),t(ml),t(We),t(ul),t(ze),t(Cl),t(Pe),t(Il),t(Ye),t(dl),t(Xe),t(f),t(qe),t(Ol),t(Ke),t(kl),t(lt),t(Al),t(et),t(tt),t(jl),t(it),t(Dl),t(st),t(Ql),t(nt),t(bl),t(at),t(Rl),t(Tt),t(ot),t(xl),t(Mt),t(Nl),t(pt),t(Fl),t(Ut),t($l),t(yt),t(Vl),t(Jt),t(Bl),t(wt),t(_l),t(rt),t(Hl),t(ct),t(El),t(ht),t(Gl)),t(c),w(m,l),w(I,l),w(D,l),w(b,l),w(x,l),w($,l),w(B,l),w(E,l),w(S,l),w(W,l),w(P,l),w(el,l),w(nl,l),w(ol,l),w(Ul,l),w(yl,l),w(rl,l),w(hl,l),w(fl,l),w(gl,l),w(vl,l)}}}const xi='{"title":"Pickle Scanning","local":"pickle-scanning","sections":[{"title":"What is a pickle?","local":"what-is-a-pickle","sections":[],"depth":2},{"title":"Why is it dangerous?","local":"why-is-it-dangerous","sections":[],"depth":2},{"title":"Mitigation Strategies","local":"mitigation-strategies","sections":[{"title":"Load files from users and organizations you trust","local":"load-files-from-users-and-organizations-you-trust","sections":[],"depth":3},{"title":"Load model weights from TF or Flax","local":"load-model-weights-from-tf-or-flax","sections":[],"depth":3},{"title":"Use your own serialization format","local":"use-your-own-serialization-format","sections":[],"depth":3},{"title":"Improve torch.load/save","local":"improve-torchloadsave","sections":[],"depth":3},{"title":"Hub’s Security Scanner","local":"hubs-security-scanner","sections":[{"title":"What we have now","local":"what-we-have-now","sections":[],"depth":4},{"title":"Potential solutions","local":"potential-solutions","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Further Reading","local":"further-reading","sections":[],"depth":2}],"depth":1}';function Ni(ut){return ji(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _i extends Di{constructor(c){super(),Qi(this,c,Ni,vi,Ai,{})}}export{_i as component};
