import{s as Gs,n as Zs,o as Ws}from"../chunks/scheduler.9680c161.js";import{S as Ss,i as vs,g as J,s as a,r as j,A as zs,h as T,f as M,c as n,j as Ts,u as I,x as o,k as Ns,y as js,a as t,v as y,d as e,t as w,w as p}from"../chunks/index.38d74ee1.js";import{C as c}from"../chunks/CodeBlock.1371964c.js";import{H as U,E as Vs}from"../chunks/EditOnGithub.1c840068.js";function ks(Is){let i,wl,yl,pl,A,ol,C,ys='Text Generation Inference (TGI) now supports <a href="#grammar-and-constraints">JSON and regex grammars</a> and <a href="#tools-and-functions">tools and functions</a> to help developers guide LLM responses to fit their needs.',Ul,r,es='These feature are available starting from version <code>1.4.3</code>. They are accessible via the <a href="https://pypi.org/project/text-generation/" rel="nofollow">text_generation</a> library.  The tool support is compatible with OpenAI’s client libraries. The following guide will walk you through the new features and how to use them!',il,h,ws="<p>The Grammar guidance support is currently only available in the TGI API due to lack of support in Open AI API.</p>",ul,m,cl,q,ps="Before we jump into the deep end, ensure your system is using TGI version <code>1.4.3</code> or later to access all the features we’re about to explore in this guide.",Al,d,os="If you’re not up to date, grab the latest version and let’s get started!",Cl,b,rl,B,hl,E,Us='<li><a href="#the-grammar-parameter">The Grammar Parameter</a>: Shape your AI’s responses with precision.</li> <li><a href="#constrain-with-pydantic">Constrain with Pydantic</a>: Define a grammar using Pydantic models.</li> <li><a href="#json-schema-integration">JSON Schema Integration</a>: Fine-grained control over your requests via JSON schema.</li> <li><a href="#using-the-client">Using the client</a>: Use TGI’s client libraries to shape the AI’s responses.</li>',ml,g,ql,Q,is='<li><a href="#the-tools-parameter">The Tools Parameter</a>: Enhance the AI’s capabilities with predefined functions.</li> <li><a href="#text-generation-inference-client">Via the client</a>: Use TGI’s client libraries to interact with the Messages API and Tool functions.</li> <li><a href="#openai-integration">OpenAI integration</a>: Use OpenAI’s client libraries to interact with TGI’s Messages API and Tool functions.</li>',dl,f,bl,N,Bl,G,us="In TGI <code>1.4.3</code>, we’ve introduced the grammar parameter, which allows you to specify the format of the response you want from the AI. This is a game-changer for those who need precise control over the AI’s output.",El,Z,cs='Using curl, you can make a request to TGI’s Messages API with the grammar parameter. This is the most primitive way to interact with the API and using <a href="#constrain-with-pydantic">Pydantic</a> is recommended for ease of use and readability.',gl,W,Ql,S,As="A grammar can be defined using Pydantic models, JSON schemas, or regular expressions. The AI will then generate a response that conforms to the specified grammar.",fl,v,Cs="<p>Note: A grammar must compile to an intermediate representation to constrain the output. Grammar compilation is a computationally expensive and may take a few seconds to complete on the first request. Subsequent requests will use the cached grammar and will be much faster.</p>",Nl,z,Gl,V,rs="Pydantic is a powerful library for data validation and settings management. It’s the perfect tool for crafting the a specific response format.",Zl,k,hs="Using Pydantic models we can define a similar grammar as the previous example in a shorter and more readable way.",Wl,R,Sl,X,vl,Y,ms="If Pydantic’s not your style, go raw with direct JSON Schema integration. It’s like having a conversation with the AI in its own language. This is simliar to the first example but with programmatic control.",zl,x,Vl,$,kl,H,qs="TGI provides a client library to that make it easy to send requests with all of the parameters we’ve discussed above. Here’s an example of how to use the client to send a request with a grammar parameter.",Rl,F,Xl,_,Yl,D,xl,P,ds="In addition to the grammar parameter, we’ve also introduced a set of tools and functions to help you get the most out of the Messages API.",$l,L,bs="Tools are a set of user defined functions that can be used in tandem with the chat functionality to enhance the AI’s capabilities. You can use these tools to perform a variety of tasks, such as data manipulation, formatting, and more.",Hl,O,Bs="Functions, similar to grammar are defined as JSON schema and can be passed as part of the parameters to the Messages API.",Fl,K,_l,u,Il,Es="Tools used in example below",Js,ll,Dl,sl,Pl,Ml,gs="TGI provides a client library to interact with the Messages API and Tool functions. The client library is available in both synchronous and asynchronous versions.",Ll,tl,Ol,al,Kl,nl,Qs="TGI exposes an OpenAI-compatible API, which means you can use OpenAI’s client libraries to interact with TGI’s Messages API and Tool functions.",ls,Jl,fs="However there are some minor differences in the API, for example <code>tool_choice=&quot;auto&quot;</code> will ALWAYS choose the tool for you. This is different from OpenAI’s API where <code>tool_choice=&quot;auto&quot;</code> will choose a tool if the model thinks it’s necessary.",ss,Tl,Ms,jl,ts,el,as;return A=new U({props:{title:"Guidance",local:"guidance",headingTag:"h1"}}),m=new U({props:{title:"Quick Start",local:"quick-start",headingTag:"h2"}}),b=new U({props:{title:"Table of Contents 📚",local:"table-of-contents-",headingTag:"h2"}}),B=new U({props:{title:"Grammar and Constraints",local:"grammar-and-constraints",headingTag:"h3"}}),g=new U({props:{title:"Tools and Functions",local:"tools-and-functions",headingTag:"h3"}}),f=new U({props:{title:"Grammar and Constraints 🛣️",local:"grammar-and-constraints-",headingTag:"h2"}}),N=new U({props:{title:"The Grammar Parameter",local:"the-grammar-parameter",headingTag:"h3"}}),W=new c({props:{code:"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",highlighted:`curl localhost<span class="hljs-punctuation">:</span><span class="hljs-number">3000</span>/generate \\
    -X POST \\
    -H &#x27;Content-Type<span class="hljs-punctuation">:</span> application/json&#x27; \\
    -d &#x27;<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;repetition_penalty&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1.3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;grammar&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;json&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;value&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                    <span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;activity&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;animals_seen&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;integer&quot;</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;minimum&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;maximum&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;animals&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;array&quot;</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;items&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span>
                        <span class="hljs-punctuation">}</span>
                    <span class="hljs-punctuation">}</span>
                <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;location&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;activity&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;animals_seen&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;animals&quot;</span><span class="hljs-punctuation">]</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>&#x27;
<span class="hljs-comment">// {&quot;generated_text&quot;:&quot;{ \\n\\n\\&quot;activity\\&quot;: \\&quot;biking\\&quot;,\\n\\&quot;animals\\&quot;: [\\&quot;puppy\\&quot;,\\&quot;cat\\&quot;,\\&quot;raccoon\\&quot;],\\n\\&quot;animals_seen\\&quot;: 3,\\n\\&quot;location\\&quot;: \\&quot;park\\&quot;\\n}&quot;}</span>
`,wrap:!1}}),z=new U({props:{title:"Constrain with Pydantic",local:"constrain-with-pydantic",headingTag:"h3"}}),R=new c({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwcHlkYW50aWMlMjBpbXBvcnQlMjBCYXNlTW9kZWwlMkMlMjBjb25pbnQlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwTGlzdCUwQSUwQWNsYXNzJTIwQW5pbWFscyhCYXNlTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0ElMjBzdHIlMEElMjAlMjAlMjAlMjBhY3Rpdml0eSUzQSUyMHN0ciUwQSUyMCUyMCUyMCUyMGFuaW1hbHNfc2VlbiUzQSUyMGNvbmludChnZSUzRDElMkMlMjBsZSUzRDUpJTIwJTIwJTIzJTIwQ29uc3RyYWluZWQlMjBpbnRlZ2VyJTIwdHlwZSUwQSUyMCUyMCUyMCUyMGFuaW1hbHMlM0ElMjBMaXN0JTVCc3RyJTVEJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyY29udmVydCUyMHRvJTIwSlNPTiUzQSUyMEklMjBzYXclMjBhJTIwcHVwcHklMjBhJTIwY2F0JTIwYW5kJTIwYSUyMHJhY2Nvb24lMjBkdXJpbmclMjBteSUyMGJpa2UlMjByaWRlJTIwaW4lMjB0aGUlMjBwYXJrJTIyJTBBJTBBZGF0YSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZXBldGl0aW9uX3BlbmFsdHklMjIlM0ElMjAxLjMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJncmFtbWFyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmpzb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2YWx1ZSUyMiUzQSUyMEFuaW1hbHMuc2NoZW1hKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0QlMEElMEFoZWFkZXJzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyQ29udGVudC1UeXBlJTIyJTNBJTIwJTIyYXBwbGljYXRpb24lMkZqc29uJTIyJTJDJTBBJTdEJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5wb3N0KCUwQSUyMCUyMCUyMCUyMCdodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBMzAwMCUyRmdlbmVyYXRlJyUyQyUwQSUyMCUyMCUyMCUyMGhlYWRlcnMlM0RoZWFkZXJzJTJDJTBBJTIwJTIwJTIwJTIwanNvbiUzRGRhdGElMEEpJTBBcHJpbnQocmVzcG9uc2UuanNvbigpKSUwQSUyMyUyMCU3QidnZW5lcmF0ZWRfdGV4dCclM0ElMjAnJTdCJTIwJTIyYWN0aXZpdHklMjIlM0ElMjAlMjJiaWtlJTIwcmlkaW5nJTIyJTJDJTIwJTIyYW5pbWFscyUyMiUzQSUyMCU1QiUyMnB1cHB5JTIyJTJDJTIyY2F0JTIyJTJDJTIycmFjY29vbiUyMiU1RCUyQyUyMmFuaW1hbHNfc2VlbiUyMiUzQSUyMDMlMkMlMjAlMjJsb2NhdGlvbiUyMiUzQSUyMnBhcmslMjIlMjAlN0QnJTdEJTBB",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> pydantic <span class="hljs-keyword">import</span> BaseModel, conint
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Animals</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    location: <span class="hljs-built_in">str</span>
    activity: <span class="hljs-built_in">str</span>
    animals_seen: conint(ge=<span class="hljs-number">1</span>, le=<span class="hljs-number">5</span>)  <span class="hljs-comment"># Constrained integer type</span>
    animals: <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]

prompt = <span class="hljs-string">&quot;convert to JSON: I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>

data = {
    <span class="hljs-string">&quot;inputs&quot;</span>: prompt,
    <span class="hljs-string">&quot;parameters&quot;</span>: {
        <span class="hljs-string">&quot;repetition_penalty&quot;</span>: <span class="hljs-number">1.3</span>,
        <span class="hljs-string">&quot;grammar&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
            <span class="hljs-string">&quot;value&quot;</span>: Animals.schema()
        }
    }
}

headers = {
    <span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
}

response = requests.post(
    <span class="hljs-string">&#x27;http://127.0.0.1:3000/generate&#x27;</span>,
    headers=headers,
    json=data
)
<span class="hljs-built_in">print</span>(response.json())
<span class="hljs-comment"># {&#x27;generated_text&#x27;: &#x27;{ &quot;activity&quot;: &quot;bike riding&quot;, &quot;animals&quot;: [&quot;puppy&quot;,&quot;cat&quot;,&quot;raccoon&quot;],&quot;animals_seen&quot;: 3, &quot;location&quot;:&quot;park&quot; }&#x27;}</span>
`,wrap:!1}}),X=new U({props:{title:"JSON Schema Integration",local:"json-schema-integration",headingTag:"h3"}}),x=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests

json_schema = {
    <span class="hljs-string">&quot;properties&quot;</span>: {
        <span class="hljs-string">&quot;location&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>
        },
        <span class="hljs-string">&quot;activity&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>
        },
        <span class="hljs-string">&quot;animals_seen&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
            <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>,
            <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>
        },
        <span class="hljs-string">&quot;animals&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>,
            <span class="hljs-string">&quot;items&quot;</span>: {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>
            }
        }
    },
    <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>]
}

data = {
    <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;convert to JSON: I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
    <span class="hljs-string">&quot;parameters&quot;</span>: {
        <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">200</span>,
        <span class="hljs-string">&quot;repetition_penalty&quot;</span>: <span class="hljs-number">1.3</span>,
        <span class="hljs-string">&quot;grammar&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
            <span class="hljs-string">&quot;value&quot;</span>: json_schema
        }
    }
}

headers = {
    <span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
}

response = requests.post(
    <span class="hljs-string">&#x27;http://127.0.0.1:3000/generate&#x27;</span>,
    headers=headers,
    json=data
)
<span class="hljs-built_in">print</span>(response.json())
<span class="hljs-comment"># {&#x27;generated_text&#x27;: &#x27;{\\n&quot;activity&quot;: &quot;biking&quot;,\\n&quot;animals&quot;: [&quot;puppy&quot;,&quot;cat&quot;,&quot;raccoon&quot;]\\n  , &quot;animals_seen&quot;: 3,\\n   &quot;location&quot;:&quot;park&quot;}&#x27;}</span>
`,wrap:!1}}),$=new U({props:{title:"Using the client",local:"using-the-client",headingTag:"h3"}}),F=new c({props:{code:"ZnJvbSUyMHRleHRfZ2VuZXJhdGlvbiUyMGltcG9ydCUyMEFzeW5jQ2xpZW50JTBBZnJvbSUyMHRleHRfZ2VuZXJhdGlvbi50eXBlcyUyMGltcG9ydCUyMEdyYW1tYXJUeXBlJTBBJTBBJTIzJTIwTk9URSUzQSUyMHRvb2xzJTIwZGVmaW5lZCUyMGFib3ZlJTIwYW5kJTIwcmVtb3ZlZCUyMGZvciUyMGJyZXZpdHklMEElMEElMjMlMjBEZWZpbmUlMjBhbiUyMGFzeW5jJTIwZnVuY3Rpb24lMjB0byUyMGVuY2Fwc3VsYXRlJTIwdGhlJTIwYXN5bmMlMjBvcGVyYXRpb24lMEFhc3luYyUyMGRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMGNsaWVudCUyMCUzRCUyMEFzeW5jQ2xpZW50KGJhc2VfdXJsJTNEJTIyaHR0cCUzQSUyRiUyRmxvY2FsaG9zdCUzQTMwMDAlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNlJTIwJ2F3YWl0JyUyMHRvJTIwd2FpdCUyMGZvciUyMHRoZSUyMGFzeW5jJTIwbWV0aG9kJTIwJ2NoYXQnJTIwdG8lMjBjb21wbGV0ZSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBHb29nbGVzJTIwRE5TJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlY29kZXJfaW5wdXRfZGV0YWlscyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWVkJTNEMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyYW1tYXIlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwR3JhbW1hclR5cGUuUmVnZXglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2YWx1ZSUyMiUzQSUyMCUyMigoMjUlNUIwLTUlNUQlN0MyJTVCMC00JTVEJTVDJTVDZCU3QyU1QjAxJTVEJTNGJTVDJTVDZCU1QyU1Q2QlM0YpJTVDJTVDLiklN0IzJTdEKDI1JTVCMC01JTVEJTdDMiU1QjAtNCU1RCU1QyU1Q2QlN0MlNUIwMSU1RCUzRiU1QyU1Q2QlNUMlNUNkJTNGKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBPbmNlJTIwdGhlJTIwcmVzcG9uc2UlMjBpcyUyMHJlY2VpdmVkJTJDJTIweW91JTIwY2FuJTIwcHJvY2VzcyUyMGl0JTBBJTIwJTIwJTIwJTIwcHJpbnQocmVzcG9uc2UuZ2VuZXJhdGVkX3RleHQpJTBBJTBBJTIzJTIwRW5zdXJlJTIwdGhlJTIwbWFpbiUyMGFzeW5jJTIwZnVuY3Rpb24lMjBpcyUyMHJ1biUyMGluJTIwdGhlJTIwZXZlbnQlMjBsb29wJTBBaWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTBBJTIwJTIwJTIwJTIwaW1wb3J0JTIwYXN5bmNpbyUwQSUyMCUyMCUyMCUyMGFzeW5jaW8ucnVuKG1haW4oKSklMEElMEElMjMlMjAxMTguOC4wLjg0JTBB",highlighted:`<span class="hljs-keyword">from</span> text_generation <span class="hljs-keyword">import</span> AsyncClient
<span class="hljs-keyword">from</span> text_generation.types <span class="hljs-keyword">import</span> GrammarType

<span class="hljs-comment"># <span class="hljs-doctag">NOTE:</span> tools defined above and removed for brevity</span>

<span class="hljs-comment"># Define an async function to encapsulate the async operation</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    client = AsyncClient(base_url=<span class="hljs-string">&quot;http://localhost:3000&quot;</span>)

    <span class="hljs-comment"># Use &#x27;await&#x27; to wait for the async method &#x27;chat&#x27; to complete</span>
    response = <span class="hljs-keyword">await</span> client.generate(
        <span class="hljs-string">&quot;Whats Googles DNS&quot;</span>,
        max_new_tokens=<span class="hljs-number">10</span>,
        decoder_input_details=<span class="hljs-literal">True</span>,
        seed=<span class="hljs-number">1</span>,
        grammar={
            <span class="hljs-string">&quot;type&quot;</span>: GrammarType.Regex,
            <span class="hljs-string">&quot;value&quot;</span>: <span class="hljs-string">&quot;((25[0-5]|2[0-4]\\\\d|[01]?\\\\d\\\\d?)\\\\.){3}(25[0-5]|2[0-4]\\\\d|[01]?\\\\d\\\\d?)&quot;</span>,
        },
    )

    <span class="hljs-comment"># Once the response is received, you can process it</span>
    <span class="hljs-built_in">print</span>(response.generated_text)

<span class="hljs-comment"># Ensure the main async function is run in the event loop</span>
<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    <span class="hljs-keyword">import</span> asyncio
    asyncio.run(main())

<span class="hljs-comment"># 118.8.0.84</span>
`,wrap:!1}}),_=new U({props:{title:"Tools and Functions 🛠️",local:"tools-and-functions-",headingTag:"h2"}}),D=new U({props:{title:"The Tools Parameter",local:"the-tools-parameter",headingTag:"h3"}}),K=new c({props:{code:"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",highlighted:`curl localhost<span class="hljs-punctuation">:</span><span class="hljs-number">3000</span>/v1/chat/completions \\
    -X POST \\
    -H &#x27;Content-Type<span class="hljs-punctuation">:</span> application/json&#x27; \\
    -d &#x27;<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;model&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;tgi&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is the weather like in New York?&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;tools&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_current_weather&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Get the current weather&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span>
                            <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>
                        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;format&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span>
                            <span class="hljs-attr">&quot;enum&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;celsius&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;fahrenheit&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
                            <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>
                        <span class="hljs-punctuation">}</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;location&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;format&quot;</span><span class="hljs-punctuation">]</span>
                <span class="hljs-punctuation">}</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;tool_choice&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_current_weather&quot;</span>
<span class="hljs-punctuation">}</span>&#x27;
<span class="hljs-comment">// {&quot;id&quot;:&quot;&quot;,&quot;object&quot;:&quot;text_completion&quot;,&quot;created&quot;:1709051640,&quot;model&quot;:&quot;HuggingFaceH4/zephyr-7b-beta&quot;,&quot;system_fingerprint&quot;:&quot;1.4.3-native&quot;,&quot;choices&quot;:[{&quot;index&quot;:0,&quot;message&quot;:{&quot;role&quot;:&quot;assistant&quot;,&quot;tool_calls&quot;:{&quot;id&quot;:0,&quot;type&quot;:&quot;function&quot;,&quot;function&quot;:{&quot;description&quot;:null,&quot;name&quot;:&quot;tools&quot;,&quot;parameters&quot;:{&quot;format&quot;:&quot;celsius&quot;,&quot;location&quot;:&quot;New York&quot;}}}},&quot;logprobs&quot;:null,&quot;finish_reason&quot;:&quot;eos_token&quot;}],&quot;usage&quot;:{&quot;prompt_tokens&quot;:157,&quot;completion_tokens&quot;:19,&quot;total_tokens&quot;:176}}</span>`,wrap:!1}}),ll=new c({props:{code:"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",highlighted:`  tools = [
      {
          <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
          <span class="hljs-string">&quot;function&quot;</span>: {
              <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
              <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
              <span class="hljs-string">&quot;parameters&quot;</span>: {
                  <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                  <span class="hljs-string">&quot;properties&quot;</span>: {
                      <span class="hljs-string">&quot;location&quot;</span>: {
                          <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                          <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
                      },
                      <span class="hljs-string">&quot;format&quot;</span>: {
                          <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                          <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
                          <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
                      },
                  },
                  <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
              },
          },
      },
      {
          <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
          <span class="hljs-string">&quot;function&quot;</span>: {
              <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
              <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
              <span class="hljs-string">&quot;parameters&quot;</span>: {
                  <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                  <span class="hljs-string">&quot;properties&quot;</span>: {
                      <span class="hljs-string">&quot;location&quot;</span>: {
                          <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                          <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
                      },
                      <span class="hljs-string">&quot;format&quot;</span>: {
                          <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                          <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
                          <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
                      },
                      <span class="hljs-string">&quot;num_days&quot;</span>: {
                          <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
                          <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
                      },
                  },
                  <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
              },
          },
      }
  ]`,wrap:!1}}),sl=new U({props:{title:"Text Generation Inference Client",local:"text-generation-inference-client",headingTag:"h3"}}),tl=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> text_generation <span class="hljs-keyword">import</span> AsyncClient

<span class="hljs-comment"># <span class="hljs-doctag">NOTE:</span> tools defined above and removed for brevity</span>

<span class="hljs-comment"># Define an async function to encapsulate the async operation</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    client = AsyncClient(base_url=<span class="hljs-string">&quot;http://localhost:3000&quot;</span>)

    <span class="hljs-comment"># Use &#x27;await&#x27; to wait for the async method &#x27;chat&#x27; to complete</span>
    response = <span class="hljs-keyword">await</span> client.chat(
        max_tokens=<span class="hljs-number">100</span>,
        seed=<span class="hljs-number">1</span>,
        tools=tools,
        presence_penalty=-<span class="hljs-number">1.1</span>,
        messages=[
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You&#x27;re a helpful assistant! Answer the users question best you can.&quot;</span>,
            },
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the weather like in Brooklyn, New York?&quot;</span>,
            },
        ],
    )

    <span class="hljs-comment"># Once the response is received, you can process it</span>
    <span class="hljs-built_in">print</span>(response.choices[<span class="hljs-number">0</span>].message.tool_calls)

<span class="hljs-comment"># Ensure the main async function is run in the event loop</span>
<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    <span class="hljs-keyword">import</span> asyncio
    asyncio.run(main())

<span class="hljs-comment"># {&quot;id&quot;:&quot;&quot;,&quot;object&quot;:&quot;text_completion&quot;,&quot;created&quot;:1709051942,&quot;model&quot;:&quot;HuggingFaceH4/zephyr-7b-beta&quot;,&quot;system_fingerprint&quot;:&quot;1.4.3-native&quot;,&quot;choices&quot;:[{&quot;index&quot;:0,&quot;message&quot;:{&quot;role&quot;:&quot;assistant&quot;,&quot;tool_calls&quot;:{&quot;id&quot;:0,&quot;type&quot;:&quot;function&quot;,&quot;function&quot;:{&quot;description&quot;:null,&quot;name&quot;:&quot;tools&quot;,&quot;parameters&quot;:{&quot;format&quot;:&quot;celsius&quot;,&quot;location&quot;:&quot;New York&quot;}}}},&quot;logprobs&quot;:null,&quot;finish_reason&quot;:&quot;eos_token&quot;}],&quot;usage&quot;:{&quot;prompt_tokens&quot;:157,&quot;completion_tokens&quot;:20,&quot;total_tokens&quot;:177}}</span>
`,wrap:!1}}),al=new U({props:{title:"OpenAI integration",local:"openai-integration",headingTag:"h3"}}),Tl=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># Initialize the client, pointing it to one of the available models</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;_&quot;</span>,
)

<span class="hljs-comment"># <span class="hljs-doctag">NOTE:</span> tools defined above and removed for brevity</span>

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
        },
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
        },
    ],
    tools=tools,
    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,  <span class="hljs-comment"># tool selected by model</span>
    max_tokens=<span class="hljs-number">500</span>,
)


called = chat_completion.choices[<span class="hljs-number">0</span>].message.tool_calls
<span class="hljs-built_in">print</span>(called)
<span class="hljs-comment"># {</span>
<span class="hljs-comment">#     &quot;id&quot;: 0,</span>
<span class="hljs-comment">#     &quot;type&quot;: &quot;function&quot;,</span>
<span class="hljs-comment">#     &quot;function&quot;: {</span>
<span class="hljs-comment">#         &quot;description&quot;: None,</span>
<span class="hljs-comment">#         &quot;name&quot;: &quot;tools&quot;,</span>
<span class="hljs-comment">#         &quot;parameters&quot;: {</span>
<span class="hljs-comment">#             &quot;format&quot;: &quot;celsius&quot;,</span>
<span class="hljs-comment">#             &quot;location&quot;: &quot;San Francisco, CA&quot;,</span>
<span class="hljs-comment">#             &quot;num_days&quot;: 3,</span>
<span class="hljs-comment">#         },</span>
<span class="hljs-comment">#     },</span>
<span class="hljs-comment"># }</span>`,wrap:!1}}),jl=new Vs({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/conceptual/guidance.md"}}),{c(){i=J("meta"),wl=a(),yl=J("p"),pl=a(),j(A.$$.fragment),ol=a(),C=J("p"),C.innerHTML=ys,Ul=a(),r=J("p"),r.innerHTML=es,il=a(),h=J("blockquote"),h.innerHTML=ws,ul=a(),j(m.$$.fragment),cl=a(),q=J("p"),q.innerHTML=ps,Al=a(),d=J("p"),d.textContent=os,Cl=a(),j(b.$$.fragment),rl=a(),j(B.$$.fragment),hl=a(),E=J("ul"),E.innerHTML=Us,ml=a(),j(g.$$.fragment),ql=a(),Q=J("ul"),Q.innerHTML=is,dl=a(),j(f.$$.fragment),bl=a(),j(N.$$.fragment),Bl=a(),G=J("p"),G.innerHTML=us,El=a(),Z=J("p"),Z.innerHTML=cs,gl=a(),j(W.$$.fragment),Ql=a(),S=J("p"),S.textContent=As,fl=a(),v=J("blockquote"),v.innerHTML=Cs,Nl=a(),j(z.$$.fragment),Gl=a(),V=J("p"),V.textContent=rs,Zl=a(),k=J("p"),k.textContent=hs,Wl=a(),j(R.$$.fragment),Sl=a(),j(X.$$.fragment),vl=a(),Y=J("p"),Y.textContent=ms,zl=a(),j(x.$$.fragment),Vl=a(),j($.$$.fragment),kl=a(),H=J("p"),H.textContent=qs,Rl=a(),j(F.$$.fragment),Xl=a(),j(_.$$.fragment),Yl=a(),j(D.$$.fragment),xl=a(),P=J("p"),P.textContent=ds,$l=a(),L=J("p"),L.textContent=bs,Hl=a(),O=J("p"),O.textContent=Bs,Fl=a(),j(K.$$.fragment),_l=a(),u=J("details"),Il=J("summary"),Il.textContent=Es,Js=a(),j(ll.$$.fragment),Dl=a(),j(sl.$$.fragment),Pl=a(),Ml=J("p"),Ml.textContent=gs,Ll=a(),j(tl.$$.fragment),Ol=a(),j(al.$$.fragment),Kl=a(),nl=J("p"),nl.textContent=Qs,ls=a(),Jl=J("p"),Jl.innerHTML=fs,ss=a(),j(Tl.$$.fragment),Ms=a(),j(jl.$$.fragment),ts=a(),el=J("p"),this.h()},l(l){const s=zs("svelte-u9bgzb",document.head);i=T(s,"META",{name:!0,content:!0}),s.forEach(M),wl=n(l),yl=T(l,"P",{}),Ts(yl).forEach(M),pl=n(l),I(A.$$.fragment,l),ol=n(l),C=T(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-kbjeep"&&(C.innerHTML=ys),Ul=n(l),r=T(l,"P",{"data-svelte-h":!0}),o(r)!=="svelte-7p3180"&&(r.innerHTML=es),il=n(l),h=T(l,"BLOCKQUOTE",{"data-svelte-h":!0}),o(h)!=="svelte-1tp3yxk"&&(h.innerHTML=ws),ul=n(l),I(m.$$.fragment,l),cl=n(l),q=T(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1yk2trj"&&(q.innerHTML=ps),Al=n(l),d=T(l,"P",{"data-svelte-h":!0}),o(d)!=="svelte-dzufb1"&&(d.textContent=os),Cl=n(l),I(b.$$.fragment,l),rl=n(l),I(B.$$.fragment,l),hl=n(l),E=T(l,"UL",{"data-svelte-h":!0}),o(E)!=="svelte-12576sd"&&(E.innerHTML=Us),ml=n(l),I(g.$$.fragment,l),ql=n(l),Q=T(l,"UL",{"data-svelte-h":!0}),o(Q)!=="svelte-18ofpvb"&&(Q.innerHTML=is),dl=n(l),I(f.$$.fragment,l),bl=n(l),I(N.$$.fragment,l),Bl=n(l),G=T(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1dpevtv"&&(G.innerHTML=us),El=n(l),Z=T(l,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1vsv0tm"&&(Z.innerHTML=cs),gl=n(l),I(W.$$.fragment,l),Ql=n(l),S=T(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1xvi374"&&(S.textContent=As),fl=n(l),v=T(l,"BLOCKQUOTE",{"data-svelte-h":!0}),o(v)!=="svelte-cm9i0i"&&(v.innerHTML=Cs),Nl=n(l),I(z.$$.fragment,l),Gl=n(l),V=T(l,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1gr119f"&&(V.textContent=rs),Zl=n(l),k=T(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-3pxjtu"&&(k.textContent=hs),Wl=n(l),I(R.$$.fragment,l),Sl=n(l),I(X.$$.fragment,l),vl=n(l),Y=T(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-ng8aow"&&(Y.textContent=ms),zl=n(l),I(x.$$.fragment,l),Vl=n(l),I($.$$.fragment,l),kl=n(l),H=T(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1u2gawg"&&(H.textContent=qs),Rl=n(l),I(F.$$.fragment,l),Xl=n(l),I(_.$$.fragment,l),Yl=n(l),I(D.$$.fragment,l),xl=n(l),P=T(l,"P",{"data-svelte-h":!0}),o(P)!=="svelte-lut42n"&&(P.textContent=ds),$l=n(l),L=T(l,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1qej1bm"&&(L.textContent=bs),Hl=n(l),O=T(l,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1yk642r"&&(O.textContent=Bs),Fl=n(l),I(K.$$.fragment,l),_l=n(l),u=T(l,"DETAILS",{});var ns=Ts(u);Il=T(ns,"SUMMARY",{"data-svelte-h":!0}),o(Il)!=="svelte-1bsygvs"&&(Il.textContent=Es),Js=n(ns),I(ll.$$.fragment,ns),ns.forEach(M),Dl=n(l),I(sl.$$.fragment,l),Pl=n(l),Ml=T(l,"P",{"data-svelte-h":!0}),o(Ml)!=="svelte-s8b45c"&&(Ml.textContent=gs),Ll=n(l),I(tl.$$.fragment,l),Ol=n(l),I(al.$$.fragment,l),Kl=n(l),nl=T(l,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-qj1me9"&&(nl.textContent=Qs),ls=n(l),Jl=T(l,"P",{"data-svelte-h":!0}),o(Jl)!=="svelte-7v54cr"&&(Jl.innerHTML=fs),ss=n(l),I(Tl.$$.fragment,l),Ms=n(l),I(jl.$$.fragment,l),ts=n(l),el=T(l,"P",{}),Ts(el).forEach(M),this.h()},h(){Ns(i,"name","hf:doc:metadata"),Ns(i,"content",Rs)},m(l,s){js(document.head,i),t(l,wl,s),t(l,yl,s),t(l,pl,s),y(A,l,s),t(l,ol,s),t(l,C,s),t(l,Ul,s),t(l,r,s),t(l,il,s),t(l,h,s),t(l,ul,s),y(m,l,s),t(l,cl,s),t(l,q,s),t(l,Al,s),t(l,d,s),t(l,Cl,s),y(b,l,s),t(l,rl,s),y(B,l,s),t(l,hl,s),t(l,E,s),t(l,ml,s),y(g,l,s),t(l,ql,s),t(l,Q,s),t(l,dl,s),y(f,l,s),t(l,bl,s),y(N,l,s),t(l,Bl,s),t(l,G,s),t(l,El,s),t(l,Z,s),t(l,gl,s),y(W,l,s),t(l,Ql,s),t(l,S,s),t(l,fl,s),t(l,v,s),t(l,Nl,s),y(z,l,s),t(l,Gl,s),t(l,V,s),t(l,Zl,s),t(l,k,s),t(l,Wl,s),y(R,l,s),t(l,Sl,s),y(X,l,s),t(l,vl,s),t(l,Y,s),t(l,zl,s),y(x,l,s),t(l,Vl,s),y($,l,s),t(l,kl,s),t(l,H,s),t(l,Rl,s),y(F,l,s),t(l,Xl,s),y(_,l,s),t(l,Yl,s),y(D,l,s),t(l,xl,s),t(l,P,s),t(l,$l,s),t(l,L,s),t(l,Hl,s),t(l,O,s),t(l,Fl,s),y(K,l,s),t(l,_l,s),t(l,u,s),js(u,Il),js(u,Js),y(ll,u,null),t(l,Dl,s),y(sl,l,s),t(l,Pl,s),t(l,Ml,s),t(l,Ll,s),y(tl,l,s),t(l,Ol,s),y(al,l,s),t(l,Kl,s),t(l,nl,s),t(l,ls,s),t(l,Jl,s),t(l,ss,s),y(Tl,l,s),t(l,Ms,s),y(jl,l,s),t(l,ts,s),t(l,el,s),as=!0},p:Zs,i(l){as||(e(A.$$.fragment,l),e(m.$$.fragment,l),e(b.$$.fragment,l),e(B.$$.fragment,l),e(g.$$.fragment,l),e(f.$$.fragment,l),e(N.$$.fragment,l),e(W.$$.fragment,l),e(z.$$.fragment,l),e(R.$$.fragment,l),e(X.$$.fragment,l),e(x.$$.fragment,l),e($.$$.fragment,l),e(F.$$.fragment,l),e(_.$$.fragment,l),e(D.$$.fragment,l),e(K.$$.fragment,l),e(ll.$$.fragment,l),e(sl.$$.fragment,l),e(tl.$$.fragment,l),e(al.$$.fragment,l),e(Tl.$$.fragment,l),e(jl.$$.fragment,l),as=!0)},o(l){w(A.$$.fragment,l),w(m.$$.fragment,l),w(b.$$.fragment,l),w(B.$$.fragment,l),w(g.$$.fragment,l),w(f.$$.fragment,l),w(N.$$.fragment,l),w(W.$$.fragment,l),w(z.$$.fragment,l),w(R.$$.fragment,l),w(X.$$.fragment,l),w(x.$$.fragment,l),w($.$$.fragment,l),w(F.$$.fragment,l),w(_.$$.fragment,l),w(D.$$.fragment,l),w(K.$$.fragment,l),w(ll.$$.fragment,l),w(sl.$$.fragment,l),w(tl.$$.fragment,l),w(al.$$.fragment,l),w(Tl.$$.fragment,l),w(jl.$$.fragment,l),as=!1},d(l){l&&(M(wl),M(yl),M(pl),M(ol),M(C),M(Ul),M(r),M(il),M(h),M(ul),M(cl),M(q),M(Al),M(d),M(Cl),M(rl),M(hl),M(E),M(ml),M(ql),M(Q),M(dl),M(bl),M(Bl),M(G),M(El),M(Z),M(gl),M(Ql),M(S),M(fl),M(v),M(Nl),M(Gl),M(V),M(Zl),M(k),M(Wl),M(Sl),M(vl),M(Y),M(zl),M(Vl),M(kl),M(H),M(Rl),M(Xl),M(Yl),M(xl),M(P),M($l),M(L),M(Hl),M(O),M(Fl),M(_l),M(u),M(Dl),M(Pl),M(Ml),M(Ll),M(Ol),M(Kl),M(nl),M(ls),M(Jl),M(ss),M(Ms),M(ts),M(el)),M(i),p(A,l),p(m,l),p(b,l),p(B,l),p(g,l),p(f,l),p(N,l),p(W,l),p(z,l),p(R,l),p(X,l),p(x,l),p($,l),p(F,l),p(_,l),p(D,l),p(K,l),p(ll),p(sl,l),p(tl,l),p(al,l),p(Tl,l),p(jl,l)}}}const Rs='{"title":"Guidance","local":"guidance","sections":[{"title":"Quick Start","local":"quick-start","sections":[],"depth":2},{"title":"Table of Contents 📚","local":"table-of-contents-","sections":[{"title":"Grammar and Constraints","local":"grammar-and-constraints","sections":[],"depth":3},{"title":"Tools and Functions","local":"tools-and-functions","sections":[],"depth":3}],"depth":2},{"title":"Grammar and Constraints 🛣️","local":"grammar-and-constraints-","sections":[{"title":"The Grammar Parameter","local":"the-grammar-parameter","sections":[],"depth":3},{"title":"Constrain with Pydantic","local":"constrain-with-pydantic","sections":[],"depth":3},{"title":"JSON Schema Integration","local":"json-schema-integration","sections":[],"depth":3},{"title":"Using the client","local":"using-the-client","sections":[],"depth":3}],"depth":2},{"title":"Tools and Functions 🛠️","local":"tools-and-functions-","sections":[{"title":"The Tools Parameter","local":"the-tools-parameter","sections":[],"depth":3},{"title":"Text Generation Inference Client","local":"text-generation-inference-client","sections":[],"depth":3},{"title":"OpenAI integration","local":"openai-integration","sections":[],"depth":3}],"depth":2}],"depth":1}';function Xs(Is){return Ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fs extends Ss{constructor(i){super(),vs(this,i,Xs,ks,Gs,{})}}export{Fs as component};
