import{s as Ji,n as Hi,o as Ii}from"../chunks/scheduler.b108d059.js";import{S as Fi,i as ki,g as l,s,r as p,A as ji,h as d,f as r,c as a,j as f,u as m,x as i,k as c,y as Li,a as o,v as n,d as u,t as h,w as _}from"../chunks/index.008de539.js";import{C as Gl}from"../chunks/CodeBlock.3968c746.js";import{H as g,E as zi}from"../chunks/EditOnGithub.d1c48e3d.js";function Ai(Nl){let x,$r,yr,wr,T,Mr,b,Er,y,Zl="Processors are used to prepare non-textual inputs (e.g., image or audio) for a model.",Cr,v,Ql="<strong>Example:</strong> Using a <code>WhisperProcessor</code> to prepare an audio input for a model.",Pr,$,Jr,w,Xl='<li><a href="#module_processors">processors</a><ul><li><em>static</em><ul><li><a href="#module_processors.FeatureExtractor">.FeatureExtractor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.FeatureExtractor_new"><code>new FeatureExtractor(config)</code></a></li></ul></li> <li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+rescale"><code>.rescale(pixelData)</code></a> ⇒ <code>void</code></li> <li><a href="#module_processors.ImageFeatureExtractor+get_resize_output_image_size"><code>.get_resize_output_image_size(image, size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+resize"><code>.resize(image)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li> <li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li> <li><a href="#module_processors.Processor">.Processor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.WhisperProcessor">.WhisperProcessor</a> ⇐ <code>Processor</code><ul><li><a href="#module_processors.WhisperProcessor+_call"><code>._call(audio)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.AutoProcessor">.AutoProcessor</a><ul><li><a href="#module_processors.AutoProcessor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_processors..center_to_corners_format"><code>~center_to_corners_format(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_processors..enforce_size_divisibility"><code>~enforce_size_divisibility(size, divisor)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors..HeightWidth"><code>~HeightWidth</code></a> : <code>*</code></li> <li><a href="#module_processors..ImageFeatureExtractorResult"><code>~ImageFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..PreprocessedImage"><code>~PreprocessedImage</code></a> : <code>object</code></li> <li><a href="#module_processors..DetrFeatureExtractorResult"><code>~DetrFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..SamImageProcessorResult"><code>~SamImageProcessorResult</code></a> : <code>object</code></li></ul></li></ul></li>',Hr,Ir,Fr,M,kr,E,jr,C,Vl="Base class for feature extractors.",Lr,P,Yl='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',zr,Ar,Rr,J,Dr,H,Ur,I,Sl="Constructs a new FeatureExtractor instance.",Br,F,Kl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td></tr></tbody>",Wr,Gr,Nr,k,Zr,j,Qr,L,ql="Feature extractor for image models.",Xr,z,Ol='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>FeatureExtractor</code>',Vr,A,ed='<li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+rescale"><code>.rescale(pixelData)</code></a> ⇒ <code>void</code></li> <li><a href="#module_processors.ImageFeatureExtractor+get_resize_output_image_size"><code>.get_resize_output_image_size(image, size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+resize"><code>.resize(image)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li>',Yr,Sr,Kr,R,qr,D,Or,U,td="Constructs a new ImageFeatureExtractor instance.",eo,B,rd=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td></td><td><p>The configuration for the feature extractor.</p></td> </tr><tr><td>config.image_mean</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The mean values for image normalization.</p></td> </tr><tr><td>config.image_std</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The standard deviation values for image normalization.</p></td> </tr><tr><td>config.do_rescale</td><td><code>boolean</code></td><td></td><td><p>Whether to rescale the image pixel values to the [0,1] range.</p></td> </tr><tr><td>config.rescale_factor</td><td><code>number</code></td><td></td><td><p>The factor to use for rescaling the image pixel values.</p></td> </tr><tr><td>config.do_normalize</td><td><code>boolean</code></td><td></td><td><p>Whether to normalize the image pixel values.</p></td> </tr><tr><td>config.do_resize</td><td><code>boolean</code></td><td></td><td><p>Whether to resize the image.</p></td> </tr><tr><td>config.resample</td><td><code>number</code></td><td></td><td><p>What method to use for resampling.</p></td> </tr><tr><td>config.size</td><td><code>number</code> | <code>Object</code></td><td></td><td><p>The size to resize the image to.</p></td> </tr><tr><td>[config.do_flip_channel_order]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to flip the color channels from RGB to BGR.
Can be overridden by the <code>do_flip_channel_order</code> parameter in the <code>preprocess</code> method.</p></td></tr></tbody>`,to,ro,oo,W,so,G,ao,N,od=`Resize the image to make a thumbnail. The image is resized so that no dimension is larger than any
corresponding dimension of the specified size.`,lo,Z,sd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',io,Q,ad="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be resized.</p></td> </tr><tr><td>size</td><td><code>Object</code></td><td></td><td><p>The size <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> to resize the image to.</p></td> </tr><tr><td>[resample]</td><td><code>string</code> | <code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code></td><td><code>2</code></td><td><p>The resampling filter to use.</p></td></tr></tbody>",co,po,mo,X,no,V,uo,Y,ld="Crops the margin of the image. Gray pixels are considered margin (i.e., pixels with a value below the threshold).",ho,S,dd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The cropped image.',_o,K,id="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be cropped.</p></td> </tr><tr><td>gray_threshold</td><td><code>number</code></td><td><code>200</code></td><td><p>Value below which pixels are considered to be gray.</p></td></tr></tbody>",fo,go,xo,q,To,O,bo,ee,cd="Pad the image by a certain amount.",yo,te,pd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The padded pixel data and image dimensions.',vo,re,md="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td></td><td><p>The pixel data to pad.</p></td> </tr><tr><td>imgDims</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The dimensions of the image (height, width, channels).</p></td> </tr><tr><td>padSize</td><td><code>*</code></td><td></td><td><p>The dimensions of the padded image.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for padding.</p></td> </tr><tr><td>[options.mode]</td><td><code>&#39;constant&#39;</code> | <code>&#39;symmetric&#39;</code></td><td><code>&#39;constant&#39;</code></td><td><p>The type of padding to add.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to center the image.</p></td> </tr><tr><td>[options.constant_values]</td><td><code>number</code></td><td><code>0</code></td><td><p>The constant value to use for padding.</p></td></tr></tbody>",$o,wo,Mo,oe,Eo,se,Co,ae,nd="Rescale the image’ pixel values by <code>this.rescale_factor</code>.",Po,le,ud='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a>',Jo,de,hd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td><p>The pixel data to rescale.</p></td></tr></tbody>",Ho,Io,Fo,ie,ko,ce,jo,pe,_d=`Find the target (width, height) dimension of the output image after
resizing given the input image and the desired size.`,Lo,me,fd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The target (width, height) dimension of the output image after resizing.',zo,ne,gd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to resize.</p></td> </tr><tr><td>size</td><td><code>any</code></td><td><p>The size to use for resizing the image.</p></td></tr></tbody>",Ao,Ro,Do,ue,Uo,he,Bo,_e,xd="Resizes the image.",Wo,fe,Td='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',Go,ge,bd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to resize.</p></td></tr></tbody>",No,Zo,Qo,xe,Xo,Te,Vo,be,yd="Preprocesses the given image.",Yo,ye,vd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;PreprocessedImage&gt;</code> - The preprocessed image.',So,ve,$d="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to preprocess.</p></td> </tr><tr><td>overrides</td><td><code>Object</code></td><td><p>The overrides for the preprocessing options.</p></td></tr></tbody>",Ko,qo,Oo,$e,es,we,ts,Me,wd=`Calls the feature extraction process on an array of images,
preprocesses each image, and concatenates the resulting
features into a single Tensor.`,rs,Ee,Md='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values (and other metadata) of the preprocessed images.',os,Ce,Ed="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",ss,as,ls,Pe,ds,Je,is,He,Cd="Detr Feature Extractor.",cs,Ie,Pd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>ImageFeatureExtractor</code>',ps,Fe,Jd='<li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li>',ms,ns,us,ke,hs,je,_s,Le,Hd=`Calls the feature extraction process on an array of images, preprocesses
each image, and concatenates the resulting features into a single Tensor.`,fs,ze,Id='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values of the preprocessed images.',gs,Ae,Fd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td></tr></tbody>",xs,Ts,bs,Re,ys,De,vs,Ue,kd='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',$s,ws,Ms,Be,Es,We,Cs,Ge,jd="Binarize the given masks using <code>object_mask_threshold</code>, it returns the associated values of <code>masks</code>, <code>scores</code> and <code>labels</code>.",Ps,Ne,Ld='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The binarized masks, the scores, and the labels.',Js,Ze,zd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>class_logits</td><td><code>Tensor</code></td><td><p>The class logits.</p></td> </tr><tr><td>mask_logits</td><td><code>Tensor</code></td><td><p>The mask logits.</p></td> </tr><tr><td>object_mask_threshold</td><td><code>number</code></td><td><p>A number between 0 and 1 used to binarize the masks.</p></td> </tr><tr><td>num_labels</td><td><code>number</code></td><td><p>The number of labels.</p></td></tr></tbody>",Hs,Is,Fs,Qe,ks,Xe,js,Ve,Ad="Checks whether the segment is valid or not.",Ls,Ye,Rd='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - Whether the segment is valid or not, and the indices of the valid labels.',zs,Se,Dd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_labels</td><td><code>Int32Array</code></td><td></td><td><p>Labels for each pixel in the mask.</p></td> </tr><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>Probabilities for each pixel in the masks.</p></td> </tr><tr><td>k</td><td><code>number</code></td><td></td><td><p>The class id of the segment.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold.</p></td></tr></tbody>",As,Rs,Ds,Ke,Us,qe,Bs,Oe,Ud="Computes the segments.",Ws,et,Bd='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The computed segments.',Gs,tt,Wd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>The mask probabilities.</p></td> </tr><tr><td>pred_scores</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted scores.</p></td> </tr><tr><td>pred_labels</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted labels.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td></td><td><p>The overlap mask area threshold.</p></td> </tr><tr><td>label_ids_to_fuse</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The label ids to fuse.</p></td> </tr><tr><td>target_size</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>The target size of the image.</p></td></tr></tbody>",Ns,Zs,Qs,rt,Xs,ot,Vs,st,Gd="Post-process the model output to generate the final panoptic segmentation.",Ys,at,Nd='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',Ss,lt,Zd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>outputs</td><td><code>*</code></td><td></td><td><p>The model output to post process</p></td> </tr><tr><td>[threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The probability score threshold to keep predicted instance masks.</p></td> </tr><tr><td>[mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold to merge or discard small disconnected parts within each binary instance mask.</p></td> </tr><tr><td>[label_ids_to_fuse]</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The labels in this state will have all their instances be fused together.</p></td> </tr><tr><td>[target_sizes]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>The target sizes to resize the masks to.</p></td></tr></tbody>",Ks,qs,Os,dt,ea,it,ta,ct,Qd="Represents a Processor that extracts features from an input.",ra,pt,Xd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',oa,mt,Vd='<li><a href="#module_processors.Processor">.Processor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',sa,aa,la,nt,da,ut,ia,ht,Yd="Creates a new Processor with the given feature extractor.",ca,_t,Sd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>feature_extractor</td><td><code>FeatureExtractor</code></td><td><p>The function used to extract features from the input.</p></td></tr></tbody>",pa,ma,na,ft,ua,gt,ha,xt,Kd="Calls the feature_extractor function with the given input.",_a,Tt,qd='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',fa,bt,Od="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>any</code></td><td><p>The input to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",ga,xa,Ta,yt,ba,vt,ya,$t,ei="Represents a WhisperProcessor that extracts features from an audio input.",va,wt,ti='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Processor</code>',$a,wa,Ma,Mt,Ea,Et,Ca,Ct,ri="Calls the feature_extractor function with the given audio input.",Pa,Pt,oi='<strong>Kind</strong>: instance method of <a href="#module_processors.WhisperProcessor"><code>WhisperProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',Ja,Jt,si="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td><p>The audio input to extract features from.</p></td></tr></tbody>",Ha,Ia,Fa,Ht,ka,It,ja,Ft,ai=`Helper class which is used to instantiate pretrained processors with the <code>from_pretrained</code> function.
The chosen processor class is determined by the type specified in the processor config.`,La,kt,li="<strong>Example:</strong> Load a processor using <code>from_pretrained</code>.",za,jt,Aa,Lt,di="<strong>Example:</strong> Run an image through a processor.",Ra,zt,Da,At,ii='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a>',Ua,Ba,Wa,Rt,Ga,Dt,Na,Ut,ci="Instantiate one of the processor classes of the library from a pretrained model.",Za,Bt,pi=`The processor class to instantiate is selected based on the <code>feature_extractor_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible)`,Qa,Wt,mi='<strong>Kind</strong>: static method of <a href="#module_processors.AutoProcessor"><code>AutoProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Processor&gt;</code> - A new instance of the Processor class.',Xa,Gt,ni=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pretrained_model_name_or_path</td><td><code>string</code></td><td><p>The name or path of the pretrained model. Can be either:</p> <ul><li>A string, the <em>model id</em> of a pretrained processor hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li> <li>A path to a <em>directory</em> containing processor files, e.g., <code>./my_model_directory/</code>.</li></ul></td> </tr><tr><td>options</td><td><code>*</code></td><td><p>Additional options for loading the processor.</p></td></tr></tbody>`,Va,Ya,Sa,Nt,Ka,Zt,qa,Qt,ui="Converts bounding boxes from center format to corners format.",Oa,Xt,hi='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The coodinates for the top-left and bottom-right corners of the box (top_left_x, top_left_y, bottom_right_x, bottom_right_y)',el,Vt,_i="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The coordinate for the center of the box and its width, height dimensions (center_x, center_y, width, height)</p></td></tr></tbody>",tl,rl,ol,Yt,sl,St,al,Kt,fi="Rounds the height and width down to the closest multiple of size_divisibility",ll,qt,gi='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>*</code> - The rounded size.',dl,Ot,xi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>*</code></td><td><p>The size of the image</p></td> </tr><tr><td>divisor</td><td><code>number</code></td><td><p>The divisor to use.</p></td></tr></tbody>",il,cl,pl,er,ml,tr,nl,rr,Ti=`Named tuple to indicate the order we are using is (height x width), even though
the Graphics’ industry standard is (width x height).`,ul,or,bi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a>',hl,_l,fl,sr,gl,ar,xl,lr,yi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Tl,dr,vi="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the batched preprocessed images.</p></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[480, 640]].</p></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[1000, 1330]].</p></td></tr></tbody>",bl,yl,vl,ir,$l,cr,wl,pr,$i='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Ml,mr,wi="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>original_size</td><td><code>HeightWidth</code></td><td><p>The original size of the image.</p></td> </tr><tr><td>reshaped_input_size</td><td><code>HeightWidth</code></td><td><p>The reshaped input size of the image.</p></td> </tr><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the preprocessed image.</p></td></tr></tbody>",El,Cl,Pl,nr,Jl,ur,Hl,hr,Mi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Il,_r,Ei="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_mask</td><td><code>Tensor</code></td></tr></tbody>",Fl,kl,jl,fr,Ll,gr,zl,xr,Ci='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Al,Tr,Pi="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>[input_points]</td><td><code>Tensor</code></td> </tr><tr><td>[input_labels]</td><td><code>Tensor</code></td></tr></tbody>",Rl,Dl,Ul,br,Bl,vr,Wl;return b=new g({props:{title:"processors",local:"processors",headingTag:"h1"}}),$=new Gl({props:{code:"aW1wb3J0JTIwJTdCJTIwQXV0b1Byb2Nlc3NvciUyQyUyMHJlYWRfYXVkaW8lMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFsZXQlMjBwcm9jZXNzb3IlMjAlM0QlMjBhd2FpdCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCdvcGVuYWklMkZ3aGlzcGVyLXRpbnkuZW4nKSUzQiUwQWxldCUyMGF1ZGlvJTIwJTNEJTIwYXdhaXQlMjByZWFkX2F1ZGlvKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJyUyQyUyMDE2MDAwKSUzQiUwQWxldCUyMCU3QiUyMGlucHV0X2ZlYXR1cmVzJTIwJTdEJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoYXVkaW8pJTNCJTBBJTJGJTJGJTIwVGVuc29yJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSgyNDAwMDApJTIwJTVCMC40NzUyOTg0NjQyOTgyNDgzJTJDJTIwMC41NTk3MjU4ODA2MjI4NjM4JTJDJTIwMC41NjQzNDE2NjQzMTQyNyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwODAlMkMlMjAzMDAwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwdHlwZSUzQSUyMCdmbG9hdDMyJyUyQyUwQSUyRiUyRiUyMCUyMCUyMHNpemUlM0ElMjAyNDAwMDAlMkMlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">AutoProcessor</span>, read_audio } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> audio = <span class="hljs-keyword">await</span> <span class="hljs-title function_">read_audio</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/v2.17.2/mlk.flac&#x27;</span>, <span class="hljs-number">16000</span>);
<span class="hljs-keyword">let</span> { input_features } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(audio);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   data: Float32Array(240000) [0.4752984642982483, 0.5597258806228638, 0.56434166431427, ...],</span>
<span class="hljs-comment">//   dims: [1, 80, 3000],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   size: 240000,</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),E=new g({props:{title:"processors.FeatureExtractor ⇐ <code> Callable </code>",local:"processorsfeatureextractor--code-callable-code",headingTag:"h2"}}),H=new g({props:{title:"new FeatureExtractor(config)",local:"new-featureextractorconfig",headingTag:"h3"}}),j=new g({props:{title:"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>",local:"processorsimagefeatureextractor--code-featureextractor-code",headingTag:"h2"}}),D=new g({props:{title:"new ImageFeatureExtractor(config)",local:"new-imagefeatureextractorconfig",headingTag:"h3"}}),G=new g({props:{title:"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code",headingTag:"h3"}}),V=new g({props:{title:"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code",headingTag:"h3"}}),O=new g({props:{title:"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>",local:"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code",headingTag:"h3"}}),se=new g({props:{title:"imageFeatureExtractor.rescale(pixelData) ⇒ <code> void </code>",local:"imagefeatureextractorrescalepixeldata--code-void-code",headingTag:"h3"}}),ce=new g({props:{title:"imageFeatureExtractor.get_resize_output_image_size(image, size) ⇒ <code> * </code>",local:"imagefeatureextractorgetresizeoutputimagesizeimage-size--code--code",headingTag:"h3"}}),he=new g({props:{title:"imageFeatureExtractor.resize(image) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorresizeimage--code-promise--rawimage--code",headingTag:"h3"}}),Te=new g({props:{title:"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>",local:"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code",headingTag:"h3"}}),we=new g({props:{title:"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>",local:"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code",headingTag:"h3"}}),Je=new g({props:{title:"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>",local:"processorsdetrfeatureextractor--code-imagefeatureextractor-code",headingTag:"h2"}}),je=new g({props:{title:"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>",local:"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code",headingTag:"h3"}}),De=new g({props:{title:"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>",local:"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code",headingTag:"h3"}}),We=new g({props:{title:"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>",local:"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code",headingTag:"h3"}}),Xe=new g({props:{title:"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>",local:"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code",headingTag:"h3"}}),qe=new g({props:{title:"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>",local:"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code",headingTag:"h3"}}),ot=new g({props:{title:"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>",local:"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code",headingTag:"h3"}}),it=new g({props:{title:"processors.Processor ⇐ <code> Callable </code>",local:"processorsprocessor--code-callable-code",headingTag:"h2"}}),ut=new g({props:{title:"new Processor(feature_extractor)",local:"new-processorfeatureextractor",headingTag:"h3"}}),gt=new g({props:{title:"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>",local:"processorcallinput-args--code-promise--any--code",headingTag:"h3"}}),vt=new g({props:{title:"processors.WhisperProcessor ⇐ <code> Processor </code>",local:"processorswhisperprocessor--code-processor-code",headingTag:"h2"}}),Et=new g({props:{title:"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>",local:"whisperprocessorcallaudio--code-promise--any--code",headingTag:"h3"}}),It=new g({props:{title:"processors.AutoProcessor",local:"processorsautoprocessor",headingTag:"h2"}}),jt=new Gl({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJyklM0I=",highlighted:'<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);',wrap:!1}}),zt=new Gl({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDE2JyklM0IlMEFsZXQlMjBpbWFnZSUyMCUzRCUyMGF3YWl0JTIwUmF3SW1hZ2UucmVhZCgnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmZvb3RiYWxsLW1hdGNoLmpwZycpJTNCJTBBbGV0JTIwaW1hZ2VfaW5wdXRzJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoaW1hZ2UpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIyZGltcyUyMiUzQSUyMCU1QiUyMDElMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZsb2F0MzIlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjJkYXRhJTIyJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTQ0MDg5MzE3MzIxNzc3MyUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMnNpemUlMjIlM0ElMjAxNTA1MjglMEElMkYlMkYlMjAlMjAlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJvcmlnaW5hbF9zaXplcyUyMiUzQSUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU1QiUyMDUzMyUyQyUyMDgwMCUyMCU1RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMnJlc2hhcGVkX2lucHV0X3NpemVzJTIyJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTVCJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTBBJTJGJTJGJTIwJTIwJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;Xenova/clip-vit-base-patch16&#x27;</span>);
<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/v2.17.2/football-match.jpg&#x27;</span>);
<span class="hljs-keyword">let</span> image_inputs = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(image);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;pixel_values&quot;: {</span>
<span class="hljs-comment">//     &quot;dims&quot;: [ 1, 3, 224, 224 ],</span>
<span class="hljs-comment">//     &quot;type&quot;: &quot;float32&quot;,</span>
<span class="hljs-comment">//     &quot;data&quot;: Float32Array [ -1.558687686920166, -1.558687686920166, -1.5440893173217773, ... ],</span>
<span class="hljs-comment">//     &quot;size&quot;: 150528</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   &quot;original_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 533, 800 ]</span>
<span class="hljs-comment">//   ],</span>
<span class="hljs-comment">//   &quot;reshaped_input_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 224, 224 ]</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Dt=new g({props:{title:"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>",local:"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code",headingTag:"h3"}}),Zt=new g({props:{title:"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>",local:"processorscentertocornersformatarr--code-array--number--code",headingTag:"h2"}}),St=new g({props:{title:"processors~enforce_size_divisibility(size, divisor) ⇒ <code> * </code>",local:"processorsenforcesizedivisibilitysize-divisor--code--code",headingTag:"h2"}}),tr=new g({props:{title:"processors~HeightWidth : <code> * </code>",local:"processorsheightwidth--code--code",headingTag:"h2"}}),ar=new g({props:{title:"processors~ImageFeatureExtractorResult : <code> object </code>",local:"processorsimagefeatureextractorresult--code-object-code",headingTag:"h2"}}),cr=new g({props:{title:"processors~PreprocessedImage : <code> object </code>",local:"processorspreprocessedimage--code-object-code",headingTag:"h2"}}),ur=new g({props:{title:"processors~DetrFeatureExtractorResult : <code> object </code>",local:"processorsdetrfeatureextractorresult--code-object-code",headingTag:"h2"}}),gr=new g({props:{title:"processors~SamImageProcessorResult : <code> object </code>",local:"processorssamimageprocessorresult--code-object-code",headingTag:"h2"}}),br=new zi({props:{source:"https://github.com/xenova/transformers.js/blob/v2.17.2/docs/source/api/processors.md"}}),{c(){x=l("meta"),$r=s(),yr=l("p"),wr=s(),T=l("a"),Mr=s(),p(b.$$.fragment),Er=s(),y=l("p"),y.textContent=Zl,Cr=s(),v=l("p"),v.innerHTML=Ql,Pr=s(),p($.$$.fragment),Jr=s(),w=l("ul"),w.innerHTML=Xl,Hr=s(),Ir=l("hr"),Fr=s(),M=l("a"),kr=s(),p(E.$$.fragment),jr=s(),C=l("p"),C.textContent=Vl,Lr=s(),P=l("p"),P.innerHTML=Yl,zr=s(),Ar=l("hr"),Rr=s(),J=l("a"),Dr=s(),p(H.$$.fragment),Ur=s(),I=l("p"),I.textContent=Sl,Br=s(),F=l("table"),F.innerHTML=Kl,Wr=s(),Gr=l("hr"),Nr=s(),k=l("a"),Zr=s(),p(j.$$.fragment),Qr=s(),L=l("p"),L.textContent=ql,Xr=s(),z=l("p"),z.innerHTML=Ol,Vr=s(),A=l("ul"),A.innerHTML=ed,Yr=s(),Sr=l("hr"),Kr=s(),R=l("a"),qr=s(),p(D.$$.fragment),Or=s(),U=l("p"),U.textContent=td,eo=s(),B=l("table"),B.innerHTML=rd,to=s(),ro=l("hr"),oo=s(),W=l("a"),so=s(),p(G.$$.fragment),ao=s(),N=l("p"),N.textContent=od,lo=s(),Z=l("p"),Z.innerHTML=sd,io=s(),Q=l("table"),Q.innerHTML=ad,co=s(),po=l("hr"),mo=s(),X=l("a"),no=s(),p(V.$$.fragment),uo=s(),Y=l("p"),Y.textContent=ld,ho=s(),S=l("p"),S.innerHTML=dd,_o=s(),K=l("table"),K.innerHTML=id,fo=s(),go=l("hr"),xo=s(),q=l("a"),To=s(),p(O.$$.fragment),bo=s(),ee=l("p"),ee.textContent=cd,yo=s(),te=l("p"),te.innerHTML=pd,vo=s(),re=l("table"),re.innerHTML=md,$o=s(),wo=l("hr"),Mo=s(),oe=l("a"),Eo=s(),p(se.$$.fragment),Co=s(),ae=l("p"),ae.innerHTML=nd,Po=s(),le=l("p"),le.innerHTML=ud,Jo=s(),de=l("table"),de.innerHTML=hd,Ho=s(),Io=l("hr"),Fo=s(),ie=l("a"),ko=s(),p(ce.$$.fragment),jo=s(),pe=l("p"),pe.textContent=_d,Lo=s(),me=l("p"),me.innerHTML=fd,zo=s(),ne=l("table"),ne.innerHTML=gd,Ao=s(),Ro=l("hr"),Do=s(),ue=l("a"),Uo=s(),p(he.$$.fragment),Bo=s(),_e=l("p"),_e.textContent=xd,Wo=s(),fe=l("p"),fe.innerHTML=Td,Go=s(),ge=l("table"),ge.innerHTML=bd,No=s(),Zo=l("hr"),Qo=s(),xe=l("a"),Xo=s(),p(Te.$$.fragment),Vo=s(),be=l("p"),be.textContent=yd,Yo=s(),ye=l("p"),ye.innerHTML=vd,So=s(),ve=l("table"),ve.innerHTML=$d,Ko=s(),qo=l("hr"),Oo=s(),$e=l("a"),es=s(),p(we.$$.fragment),ts=s(),Me=l("p"),Me.textContent=wd,rs=s(),Ee=l("p"),Ee.innerHTML=Md,os=s(),Ce=l("table"),Ce.innerHTML=Ed,ss=s(),as=l("hr"),ls=s(),Pe=l("a"),ds=s(),p(Je.$$.fragment),is=s(),He=l("p"),He.textContent=Cd,cs=s(),Ie=l("p"),Ie.innerHTML=Pd,ps=s(),Fe=l("ul"),Fe.innerHTML=Jd,ms=s(),ns=l("hr"),us=s(),ke=l("a"),hs=s(),p(je.$$.fragment),_s=s(),Le=l("p"),Le.textContent=Hd,fs=s(),ze=l("p"),ze.innerHTML=Id,gs=s(),Ae=l("table"),Ae.innerHTML=Fd,xs=s(),Ts=l("hr"),bs=s(),Re=l("a"),ys=s(),p(De.$$.fragment),vs=s(),Ue=l("p"),Ue.innerHTML=kd,$s=s(),ws=l("hr"),Ms=s(),Be=l("a"),Es=s(),p(We.$$.fragment),Cs=s(),Ge=l("p"),Ge.innerHTML=jd,Ps=s(),Ne=l("p"),Ne.innerHTML=Ld,Js=s(),Ze=l("table"),Ze.innerHTML=zd,Hs=s(),Is=l("hr"),Fs=s(),Qe=l("a"),ks=s(),p(Xe.$$.fragment),js=s(),Ve=l("p"),Ve.textContent=Ad,Ls=s(),Ye=l("p"),Ye.innerHTML=Rd,zs=s(),Se=l("table"),Se.innerHTML=Dd,As=s(),Rs=l("hr"),Ds=s(),Ke=l("a"),Us=s(),p(qe.$$.fragment),Bs=s(),Oe=l("p"),Oe.textContent=Ud,Ws=s(),et=l("p"),et.innerHTML=Bd,Gs=s(),tt=l("table"),tt.innerHTML=Wd,Ns=s(),Zs=l("hr"),Qs=s(),rt=l("a"),Xs=s(),p(ot.$$.fragment),Vs=s(),st=l("p"),st.textContent=Gd,Ys=s(),at=l("p"),at.innerHTML=Nd,Ss=s(),lt=l("table"),lt.innerHTML=Zd,Ks=s(),qs=l("hr"),Os=s(),dt=l("a"),ea=s(),p(it.$$.fragment),ta=s(),ct=l("p"),ct.textContent=Qd,ra=s(),pt=l("p"),pt.innerHTML=Xd,oa=s(),mt=l("ul"),mt.innerHTML=Vd,sa=s(),aa=l("hr"),la=s(),nt=l("a"),da=s(),p(ut.$$.fragment),ia=s(),ht=l("p"),ht.textContent=Yd,ca=s(),_t=l("table"),_t.innerHTML=Sd,pa=s(),ma=l("hr"),na=s(),ft=l("a"),ua=s(),p(gt.$$.fragment),ha=s(),xt=l("p"),xt.textContent=Kd,_a=s(),Tt=l("p"),Tt.innerHTML=qd,fa=s(),bt=l("table"),bt.innerHTML=Od,ga=s(),xa=l("hr"),Ta=s(),yt=l("a"),ba=s(),p(vt.$$.fragment),ya=s(),$t=l("p"),$t.textContent=ei,va=s(),wt=l("p"),wt.innerHTML=ti,$a=s(),wa=l("hr"),Ma=s(),Mt=l("a"),Ea=s(),p(Et.$$.fragment),Ca=s(),Ct=l("p"),Ct.textContent=ri,Pa=s(),Pt=l("p"),Pt.innerHTML=oi,Ja=s(),Jt=l("table"),Jt.innerHTML=si,Ha=s(),Ia=l("hr"),Fa=s(),Ht=l("a"),ka=s(),p(It.$$.fragment),ja=s(),Ft=l("p"),Ft.innerHTML=ai,La=s(),kt=l("p"),kt.innerHTML=li,za=s(),p(jt.$$.fragment),Aa=s(),Lt=l("p"),Lt.innerHTML=di,Ra=s(),p(zt.$$.fragment),Da=s(),At=l("p"),At.innerHTML=ii,Ua=s(),Ba=l("hr"),Wa=s(),Rt=l("a"),Ga=s(),p(Dt.$$.fragment),Na=s(),Ut=l("p"),Ut.textContent=ci,Za=s(),Bt=l("p"),Bt.innerHTML=pi,Qa=s(),Wt=l("p"),Wt.innerHTML=mi,Xa=s(),Gt=l("table"),Gt.innerHTML=ni,Va=s(),Ya=l("hr"),Sa=s(),Nt=l("a"),Ka=s(),p(Zt.$$.fragment),qa=s(),Qt=l("p"),Qt.textContent=ui,Oa=s(),Xt=l("p"),Xt.innerHTML=hi,el=s(),Vt=l("table"),Vt.innerHTML=_i,tl=s(),rl=l("hr"),ol=s(),Yt=l("a"),sl=s(),p(St.$$.fragment),al=s(),Kt=l("p"),Kt.textContent=fi,ll=s(),qt=l("p"),qt.innerHTML=gi,dl=s(),Ot=l("table"),Ot.innerHTML=xi,il=s(),cl=l("hr"),pl=s(),er=l("a"),ml=s(),p(tr.$$.fragment),nl=s(),rr=l("p"),rr.textContent=Ti,ul=s(),or=l("p"),or.innerHTML=bi,hl=s(),_l=l("hr"),fl=s(),sr=l("a"),gl=s(),p(ar.$$.fragment),xl=s(),lr=l("p"),lr.innerHTML=yi,Tl=s(),dr=l("table"),dr.innerHTML=vi,bl=s(),yl=l("hr"),vl=s(),ir=l("a"),$l=s(),p(cr.$$.fragment),wl=s(),pr=l("p"),pr.innerHTML=$i,Ml=s(),mr=l("table"),mr.innerHTML=wi,El=s(),Cl=l("hr"),Pl=s(),nr=l("a"),Jl=s(),p(ur.$$.fragment),Hl=s(),hr=l("p"),hr.innerHTML=Mi,Il=s(),_r=l("table"),_r.innerHTML=Ei,Fl=s(),kl=l("hr"),jl=s(),fr=l("a"),Ll=s(),p(gr.$$.fragment),zl=s(),xr=l("p"),xr.innerHTML=Ci,Al=s(),Tr=l("table"),Tr.innerHTML=Pi,Rl=s(),Dl=l("hr"),Ul=s(),p(br.$$.fragment),Bl=s(),vr=l("p"),this.h()},l(e){const t=ji("svelte-u9bgzb",document.head);x=d(t,"META",{name:!0,content:!0}),t.forEach(r),$r=a(e),yr=d(e,"P",{}),f(yr).forEach(r),wr=a(e),T=d(e,"A",{id:!0,class:!0}),f(T).forEach(r),Mr=a(e),m(b.$$.fragment,e),Er=a(e),y=d(e,"P",{"data-svelte-h":!0}),i(y)!=="svelte-w0rx8m"&&(y.textContent=Zl),Cr=a(e),v=d(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1olsie5"&&(v.innerHTML=Ql),Pr=a(e),m($.$$.fragment,e),Jr=a(e),w=d(e,"UL",{"data-svelte-h":!0}),i(w)!=="svelte-tl9vbq"&&(w.innerHTML=Xl),Hr=a(e),Ir=d(e,"HR",{}),Fr=a(e),M=d(e,"A",{id:!0,class:!0}),f(M).forEach(r),kr=a(e),m(E.$$.fragment,e),jr=a(e),C=d(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-14r3pvv"&&(C.textContent=Vl),Lr=a(e),P=d(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-fac4cj"&&(P.innerHTML=Yl),zr=a(e),Ar=d(e,"HR",{}),Rr=a(e),J=d(e,"A",{id:!0,class:!0}),f(J).forEach(r),Dr=a(e),m(H.$$.fragment,e),Ur=a(e),I=d(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-k3m2wg"&&(I.textContent=Sl),Br=a(e),F=d(e,"TABLE",{"data-svelte-h":!0}),i(F)!=="svelte-rd7ds7"&&(F.innerHTML=Kl),Wr=a(e),Gr=d(e,"HR",{}),Nr=a(e),k=d(e,"A",{id:!0,class:!0}),f(k).forEach(r),Zr=a(e),m(j.$$.fragment,e),Qr=a(e),L=d(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-8k8cys"&&(L.textContent=ql),Xr=a(e),z=d(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-18p52n5"&&(z.innerHTML=Ol),Vr=a(e),A=d(e,"UL",{"data-svelte-h":!0}),i(A)!=="svelte-1ne2ywl"&&(A.innerHTML=ed),Yr=a(e),Sr=d(e,"HR",{}),Kr=a(e),R=d(e,"A",{id:!0,class:!0}),f(R).forEach(r),qr=a(e),m(D.$$.fragment,e),Or=a(e),U=d(e,"P",{"data-svelte-h":!0}),i(U)!=="svelte-1mp2vol"&&(U.textContent=td),eo=a(e),B=d(e,"TABLE",{"data-svelte-h":!0}),i(B)!=="svelte-1131cyk"&&(B.innerHTML=rd),to=a(e),ro=d(e,"HR",{}),oo=a(e),W=d(e,"A",{id:!0,class:!0}),f(W).forEach(r),so=a(e),m(G.$$.fragment,e),ao=a(e),N=d(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1q6eyx4"&&(N.textContent=od),lo=a(e),Z=d(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-ar7q77"&&(Z.innerHTML=sd),io=a(e),Q=d(e,"TABLE",{"data-svelte-h":!0}),i(Q)!=="svelte-klyf4z"&&(Q.innerHTML=ad),co=a(e),po=d(e,"HR",{}),mo=a(e),X=d(e,"A",{id:!0,class:!0}),f(X).forEach(r),no=a(e),m(V.$$.fragment,e),uo=a(e),Y=d(e,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-7fx89a"&&(Y.textContent=ld),ho=a(e),S=d(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-65os4c"&&(S.innerHTML=dd),_o=a(e),K=d(e,"TABLE",{"data-svelte-h":!0}),i(K)!=="svelte-1dnvwno"&&(K.innerHTML=id),fo=a(e),go=d(e,"HR",{}),xo=a(e),q=d(e,"A",{id:!0,class:!0}),f(q).forEach(r),To=a(e),m(O.$$.fragment,e),bo=a(e),ee=d(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-1mmkb9p"&&(ee.textContent=cd),yo=a(e),te=d(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-110o3sn"&&(te.innerHTML=pd),vo=a(e),re=d(e,"TABLE",{"data-svelte-h":!0}),i(re)!=="svelte-mhh1xm"&&(re.innerHTML=md),$o=a(e),wo=d(e,"HR",{}),Mo=a(e),oe=d(e,"A",{id:!0,class:!0}),f(oe).forEach(r),Eo=a(e),m(se.$$.fragment,e),Co=a(e),ae=d(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-pyd72v"&&(ae.innerHTML=nd),Po=a(e),le=d(e,"P",{"data-svelte-h":!0}),i(le)!=="svelte-1isxmg1"&&(le.innerHTML=ud),Jo=a(e),de=d(e,"TABLE",{"data-svelte-h":!0}),i(de)!=="svelte-1e1ka8e"&&(de.innerHTML=hd),Ho=a(e),Io=d(e,"HR",{}),Fo=a(e),ie=d(e,"A",{id:!0,class:!0}),f(ie).forEach(r),ko=a(e),m(ce.$$.fragment,e),jo=a(e),pe=d(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-8leww2"&&(pe.textContent=_d),Lo=a(e),me=d(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-eqxqo6"&&(me.innerHTML=fd),zo=a(e),ne=d(e,"TABLE",{"data-svelte-h":!0}),i(ne)!=="svelte-1n361ub"&&(ne.innerHTML=gd),Ao=a(e),Ro=d(e,"HR",{}),Do=a(e),ue=d(e,"A",{id:!0,class:!0}),f(ue).forEach(r),Uo=a(e),m(he.$$.fragment,e),Bo=a(e),_e=d(e,"P",{"data-svelte-h":!0}),i(_e)!=="svelte-5iny39"&&(_e.textContent=xd),Wo=a(e),fe=d(e,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-ar7q77"&&(fe.innerHTML=Td),Go=a(e),ge=d(e,"TABLE",{"data-svelte-h":!0}),i(ge)!=="svelte-d8vk38"&&(ge.innerHTML=bd),No=a(e),Zo=d(e,"HR",{}),Qo=a(e),xe=d(e,"A",{id:!0,class:!0}),f(xe).forEach(r),Xo=a(e),m(Te.$$.fragment,e),Vo=a(e),be=d(e,"P",{"data-svelte-h":!0}),i(be)!=="svelte-10g8wi9"&&(be.textContent=yd),Yo=a(e),ye=d(e,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-cd20o3"&&(ye.innerHTML=vd),So=a(e),ve=d(e,"TABLE",{"data-svelte-h":!0}),i(ve)!=="svelte-1773mps"&&(ve.innerHTML=$d),Ko=a(e),qo=d(e,"HR",{}),Oo=a(e),$e=d(e,"A",{id:!0,class:!0}),f($e).forEach(r),es=a(e),m(we.$$.fragment,e),ts=a(e),Me=d(e,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-1uytqp8"&&(Me.textContent=wd),rs=a(e),Ee=d(e,"P",{"data-svelte-h":!0}),i(Ee)!=="svelte-1pa0uk8"&&(Ee.innerHTML=Md),os=a(e),Ce=d(e,"TABLE",{"data-svelte-h":!0}),i(Ce)!=="svelte-hch5rz"&&(Ce.innerHTML=Ed),ss=a(e),as=d(e,"HR",{}),ls=a(e),Pe=d(e,"A",{id:!0,class:!0}),f(Pe).forEach(r),ds=a(e),m(Je.$$.fragment,e),is=a(e),He=d(e,"P",{"data-svelte-h":!0}),i(He)!=="svelte-y1gxwn"&&(He.textContent=Cd),cs=a(e),Ie=d(e,"P",{"data-svelte-h":!0}),i(Ie)!=="svelte-1xz91ac"&&(Ie.innerHTML=Pd),ps=a(e),Fe=d(e,"UL",{"data-svelte-h":!0}),i(Fe)!=="svelte-1obx36y"&&(Fe.innerHTML=Jd),ms=a(e),ns=d(e,"HR",{}),us=a(e),ke=d(e,"A",{id:!0,class:!0}),f(ke).forEach(r),hs=a(e),m(je.$$.fragment,e),_s=a(e),Le=d(e,"P",{"data-svelte-h":!0}),i(Le)!=="svelte-1ec3vsm"&&(Le.textContent=Hd),fs=a(e),ze=d(e,"P",{"data-svelte-h":!0}),i(ze)!=="svelte-6tjpr7"&&(ze.innerHTML=Id),gs=a(e),Ae=d(e,"TABLE",{"data-svelte-h":!0}),i(Ae)!=="svelte-1px7bnv"&&(Ae.innerHTML=Fd),xs=a(e),Ts=d(e,"HR",{}),bs=a(e),Re=d(e,"A",{id:!0,class:!0}),f(Re).forEach(r),ys=a(e),m(De.$$.fragment,e),vs=a(e),Ue=d(e,"P",{"data-svelte-h":!0}),i(Ue)!=="svelte-j2v54d"&&(Ue.innerHTML=kd),$s=a(e),ws=d(e,"HR",{}),Ms=a(e),Be=d(e,"A",{id:!0,class:!0}),f(Be).forEach(r),Es=a(e),m(We.$$.fragment,e),Cs=a(e),Ge=d(e,"P",{"data-svelte-h":!0}),i(Ge)!=="svelte-75c7d5"&&(Ge.innerHTML=jd),Ps=a(e),Ne=d(e,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-o8p6wm"&&(Ne.innerHTML=Ld),Js=a(e),Ze=d(e,"TABLE",{"data-svelte-h":!0}),i(Ze)!=="svelte-yqya7v"&&(Ze.innerHTML=zd),Hs=a(e),Is=d(e,"HR",{}),Fs=a(e),Qe=d(e,"A",{id:!0,class:!0}),f(Qe).forEach(r),ks=a(e),m(Xe.$$.fragment,e),js=a(e),Ve=d(e,"P",{"data-svelte-h":!0}),i(Ve)!=="svelte-gl8gb6"&&(Ve.textContent=Ad),Ls=a(e),Ye=d(e,"P",{"data-svelte-h":!0}),i(Ye)!=="svelte-1qxvzd2"&&(Ye.innerHTML=Rd),zs=a(e),Se=d(e,"TABLE",{"data-svelte-h":!0}),i(Se)!=="svelte-1f7z42u"&&(Se.innerHTML=Dd),As=a(e),Rs=d(e,"HR",{}),Ds=a(e),Ke=d(e,"A",{id:!0,class:!0}),f(Ke).forEach(r),Us=a(e),m(qe.$$.fragment,e),Bs=a(e),Oe=d(e,"P",{"data-svelte-h":!0}),i(Oe)!=="svelte-7vs1p7"&&(Oe.textContent=Ud),Ws=a(e),et=d(e,"P",{"data-svelte-h":!0}),i(et)!=="svelte-15rcpil"&&(et.innerHTML=Bd),Gs=a(e),tt=d(e,"TABLE",{"data-svelte-h":!0}),i(tt)!=="svelte-3xdz32"&&(tt.innerHTML=Wd),Ns=a(e),Zs=d(e,"HR",{}),Qs=a(e),rt=d(e,"A",{id:!0,class:!0}),f(rt).forEach(r),Xs=a(e),m(ot.$$.fragment,e),Vs=a(e),st=d(e,"P",{"data-svelte-h":!0}),i(st)!=="svelte-frdp8m"&&(st.textContent=Gd),Ys=a(e),at=d(e,"P",{"data-svelte-h":!0}),i(at)!=="svelte-j2v54d"&&(at.innerHTML=Nd),Ss=a(e),lt=d(e,"TABLE",{"data-svelte-h":!0}),i(lt)!=="svelte-11rkhka"&&(lt.innerHTML=Zd),Ks=a(e),qs=d(e,"HR",{}),Os=a(e),dt=d(e,"A",{id:!0,class:!0}),f(dt).forEach(r),ea=a(e),m(it.$$.fragment,e),ta=a(e),ct=d(e,"P",{"data-svelte-h":!0}),i(ct)!=="svelte-o9f953"&&(ct.textContent=Qd),ra=a(e),pt=d(e,"P",{"data-svelte-h":!0}),i(pt)!=="svelte-fac4cj"&&(pt.innerHTML=Xd),oa=a(e),mt=d(e,"UL",{"data-svelte-h":!0}),i(mt)!=="svelte-1v579im"&&(mt.innerHTML=Vd),sa=a(e),aa=d(e,"HR",{}),la=a(e),nt=d(e,"A",{id:!0,class:!0}),f(nt).forEach(r),da=a(e),m(ut.$$.fragment,e),ia=a(e),ht=d(e,"P",{"data-svelte-h":!0}),i(ht)!=="svelte-1naom0u"&&(ht.textContent=Yd),ca=a(e),_t=d(e,"TABLE",{"data-svelte-h":!0}),i(_t)!=="svelte-ilxs6c"&&(_t.innerHTML=Sd),pa=a(e),ma=d(e,"HR",{}),na=a(e),ft=d(e,"A",{id:!0,class:!0}),f(ft).forEach(r),ua=a(e),m(gt.$$.fragment,e),ha=a(e),xt=d(e,"P",{"data-svelte-h":!0}),i(xt)!=="svelte-zbbm3j"&&(xt.textContent=Kd),_a=a(e),Tt=d(e,"P",{"data-svelte-h":!0}),i(Tt)!=="svelte-kflsb2"&&(Tt.innerHTML=qd),fa=a(e),bt=d(e,"TABLE",{"data-svelte-h":!0}),i(bt)!=="svelte-pm1u9z"&&(bt.innerHTML=Od),ga=a(e),xa=d(e,"HR",{}),Ta=a(e),yt=d(e,"A",{id:!0,class:!0}),f(yt).forEach(r),ba=a(e),m(vt.$$.fragment,e),ya=a(e),$t=d(e,"P",{"data-svelte-h":!0}),i($t)!=="svelte-17pib55"&&($t.textContent=ei),va=a(e),wt=d(e,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-1ljhyyr"&&(wt.innerHTML=ti),$a=a(e),wa=d(e,"HR",{}),Ma=a(e),Mt=d(e,"A",{id:!0,class:!0}),f(Mt).forEach(r),Ea=a(e),m(Et.$$.fragment,e),Ca=a(e),Ct=d(e,"P",{"data-svelte-h":!0}),i(Ct)!=="svelte-r5x3fh"&&(Ct.textContent=ri),Pa=a(e),Pt=d(e,"P",{"data-svelte-h":!0}),i(Pt)!=="svelte-1vpvonk"&&(Pt.innerHTML=oi),Ja=a(e),Jt=d(e,"TABLE",{"data-svelte-h":!0}),i(Jt)!=="svelte-nv3lon"&&(Jt.innerHTML=si),Ha=a(e),Ia=d(e,"HR",{}),Fa=a(e),Ht=d(e,"A",{id:!0,class:!0}),f(Ht).forEach(r),ka=a(e),m(It.$$.fragment,e),ja=a(e),Ft=d(e,"P",{"data-svelte-h":!0}),i(Ft)!=="svelte-62dsf9"&&(Ft.innerHTML=ai),La=a(e),kt=d(e,"P",{"data-svelte-h":!0}),i(kt)!=="svelte-11vd43e"&&(kt.innerHTML=li),za=a(e),m(jt.$$.fragment,e),Aa=a(e),Lt=d(e,"P",{"data-svelte-h":!0}),i(Lt)!=="svelte-c0cgha"&&(Lt.innerHTML=di),Ra=a(e),m(zt.$$.fragment,e),Da=a(e),At=d(e,"P",{"data-svelte-h":!0}),i(At)!=="svelte-wmyz1o"&&(At.innerHTML=ii),Ua=a(e),Ba=d(e,"HR",{}),Wa=a(e),Rt=d(e,"A",{id:!0,class:!0}),f(Rt).forEach(r),Ga=a(e),m(Dt.$$.fragment,e),Na=a(e),Ut=d(e,"P",{"data-svelte-h":!0}),i(Ut)!=="svelte-jwfdp9"&&(Ut.textContent=ci),Za=a(e),Bt=d(e,"P",{"data-svelte-h":!0}),i(Bt)!=="svelte-t85gxq"&&(Bt.innerHTML=pi),Qa=a(e),Wt=d(e,"P",{"data-svelte-h":!0}),i(Wt)!=="svelte-y7m8db"&&(Wt.innerHTML=mi),Xa=a(e),Gt=d(e,"TABLE",{"data-svelte-h":!0}),i(Gt)!=="svelte-1oj79mt"&&(Gt.innerHTML=ni),Va=a(e),Ya=d(e,"HR",{}),Sa=a(e),Nt=d(e,"A",{id:!0,class:!0}),f(Nt).forEach(r),Ka=a(e),m(Zt.$$.fragment,e),qa=a(e),Qt=d(e,"P",{"data-svelte-h":!0}),i(Qt)!=="svelte-kjzox5"&&(Qt.textContent=ui),Oa=a(e),Xt=d(e,"P",{"data-svelte-h":!0}),i(Xt)!=="svelte-19qboln"&&(Xt.innerHTML=hi),el=a(e),Vt=d(e,"TABLE",{"data-svelte-h":!0}),i(Vt)!=="svelte-1bv5sxq"&&(Vt.innerHTML=_i),tl=a(e),rl=d(e,"HR",{}),ol=a(e),Yt=d(e,"A",{id:!0,class:!0}),f(Yt).forEach(r),sl=a(e),m(St.$$.fragment,e),al=a(e),Kt=d(e,"P",{"data-svelte-h":!0}),i(Kt)!=="svelte-vlkbp"&&(Kt.textContent=fi),ll=a(e),qt=d(e,"P",{"data-svelte-h":!0}),i(qt)!=="svelte-vmdbik"&&(qt.innerHTML=gi),dl=a(e),Ot=d(e,"TABLE",{"data-svelte-h":!0}),i(Ot)!=="svelte-4ldb45"&&(Ot.innerHTML=xi),il=a(e),cl=d(e,"HR",{}),pl=a(e),er=d(e,"A",{id:!0,class:!0}),f(er).forEach(r),ml=a(e),m(tr.$$.fragment,e),nl=a(e),rr=d(e,"P",{"data-svelte-h":!0}),i(rr)!=="svelte-2u8xbp"&&(rr.textContent=Ti),ul=a(e),or=d(e,"P",{"data-svelte-h":!0}),i(or)!=="svelte-3xndnt"&&(or.innerHTML=bi),hl=a(e),_l=d(e,"HR",{}),fl=a(e),sr=d(e,"A",{id:!0,class:!0}),f(sr).forEach(r),gl=a(e),m(ar.$$.fragment,e),xl=a(e),lr=d(e,"P",{"data-svelte-h":!0}),i(lr)!=="svelte-cy5pwv"&&(lr.innerHTML=yi),Tl=a(e),dr=d(e,"TABLE",{"data-svelte-h":!0}),i(dr)!=="svelte-1dyar84"&&(dr.innerHTML=vi),bl=a(e),yl=d(e,"HR",{}),vl=a(e),ir=d(e,"A",{id:!0,class:!0}),f(ir).forEach(r),$l=a(e),m(cr.$$.fragment,e),wl=a(e),pr=d(e,"P",{"data-svelte-h":!0}),i(pr)!=="svelte-cy5pwv"&&(pr.innerHTML=$i),Ml=a(e),mr=d(e,"TABLE",{"data-svelte-h":!0}),i(mr)!=="svelte-1cnys15"&&(mr.innerHTML=wi),El=a(e),Cl=d(e,"HR",{}),Pl=a(e),nr=d(e,"A",{id:!0,class:!0}),f(nr).forEach(r),Jl=a(e),m(ur.$$.fragment,e),Hl=a(e),hr=d(e,"P",{"data-svelte-h":!0}),i(hr)!=="svelte-cy5pwv"&&(hr.innerHTML=Mi),Il=a(e),_r=d(e,"TABLE",{"data-svelte-h":!0}),i(_r)!=="svelte-179cln2"&&(_r.innerHTML=Ei),Fl=a(e),kl=d(e,"HR",{}),jl=a(e),fr=d(e,"A",{id:!0,class:!0}),f(fr).forEach(r),Ll=a(e),m(gr.$$.fragment,e),zl=a(e),xr=d(e,"P",{"data-svelte-h":!0}),i(xr)!=="svelte-cy5pwv"&&(xr.innerHTML=Ci),Al=a(e),Tr=d(e,"TABLE",{"data-svelte-h":!0}),i(Tr)!=="svelte-vnvxdo"&&(Tr.innerHTML=Pi),Rl=a(e),Dl=d(e,"HR",{}),Ul=a(e),m(br.$$.fragment,e),Bl=a(e),vr=d(e,"P",{}),f(vr).forEach(r),this.h()},h(){c(x,"name","hf:doc:metadata"),c(x,"content",Ri),c(T,"id","module_processors"),c(T,"class","group"),c(M,"id","module_processors.FeatureExtractor"),c(M,"class","group"),c(J,"id","new_module_processors.FeatureExtractor_new"),c(J,"class","group"),c(k,"id","module_processors.ImageFeatureExtractor"),c(k,"class","group"),c(R,"id","new_module_processors.ImageFeatureExtractor_new"),c(R,"class","group"),c(W,"id","module_processors.ImageFeatureExtractor+thumbnail"),c(W,"class","group"),c(X,"id","module_processors.ImageFeatureExtractor+crop_margin"),c(X,"class","group"),c(q,"id","module_processors.ImageFeatureExtractor+pad_image"),c(q,"class","group"),c(oe,"id","module_processors.ImageFeatureExtractor+rescale"),c(oe,"class","group"),c(ie,"id","module_processors.ImageFeatureExtractor+get_resize_output_image_size"),c(ie,"class","group"),c(ue,"id","module_processors.ImageFeatureExtractor+resize"),c(ue,"class","group"),c(xe,"id","module_processors.ImageFeatureExtractor+preprocess"),c(xe,"class","group"),c($e,"id","module_processors.ImageFeatureExtractor+_call"),c($e,"class","group"),c(Pe,"id","module_processors.DetrFeatureExtractor"),c(Pe,"class","group"),c(ke,"id","module_processors.DetrFeatureExtractor+_call"),c(ke,"class","group"),c(Re,"id","module_processors.DetrFeatureExtractor+post_process_object_detection"),c(Re,"class","group"),c(Be,"id","module_processors.DetrFeatureExtractor+remove_low_and_no_objects"),c(Be,"class","group"),c(Qe,"id","module_processors.DetrFeatureExtractor+check_segment_validity"),c(Qe,"class","group"),c(Ke,"id","module_processors.DetrFeatureExtractor+compute_segments"),c(Ke,"class","group"),c(rt,"id","module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"),c(rt,"class","group"),c(dt,"id","module_processors.Processor"),c(dt,"class","group"),c(nt,"id","new_module_processors.Processor_new"),c(nt,"class","group"),c(ft,"id","module_processors.Processor+_call"),c(ft,"class","group"),c(yt,"id","module_processors.WhisperProcessor"),c(yt,"class","group"),c(Mt,"id","module_processors.WhisperProcessor+_call"),c(Mt,"class","group"),c(Ht,"id","module_processors.AutoProcessor"),c(Ht,"class","group"),c(Rt,"id","module_processors.AutoProcessor.from_pretrained"),c(Rt,"class","group"),c(Nt,"id","module_processors..center_to_corners_format"),c(Nt,"class","group"),c(Yt,"id","module_processors..enforce_size_divisibility"),c(Yt,"class","group"),c(er,"id","module_processors..HeightWidth"),c(er,"class","group"),c(sr,"id","module_processors..ImageFeatureExtractorResult"),c(sr,"class","group"),c(ir,"id","module_processors..PreprocessedImage"),c(ir,"class","group"),c(nr,"id","module_processors..DetrFeatureExtractorResult"),c(nr,"class","group"),c(fr,"id","module_processors..SamImageProcessorResult"),c(fr,"class","group")},m(e,t){Li(document.head,x),o(e,$r,t),o(e,yr,t),o(e,wr,t),o(e,T,t),o(e,Mr,t),n(b,e,t),o(e,Er,t),o(e,y,t),o(e,Cr,t),o(e,v,t),o(e,Pr,t),n($,e,t),o(e,Jr,t),o(e,w,t),o(e,Hr,t),o(e,Ir,t),o(e,Fr,t),o(e,M,t),o(e,kr,t),n(E,e,t),o(e,jr,t),o(e,C,t),o(e,Lr,t),o(e,P,t),o(e,zr,t),o(e,Ar,t),o(e,Rr,t),o(e,J,t),o(e,Dr,t),n(H,e,t),o(e,Ur,t),o(e,I,t),o(e,Br,t),o(e,F,t),o(e,Wr,t),o(e,Gr,t),o(e,Nr,t),o(e,k,t),o(e,Zr,t),n(j,e,t),o(e,Qr,t),o(e,L,t),o(e,Xr,t),o(e,z,t),o(e,Vr,t),o(e,A,t),o(e,Yr,t),o(e,Sr,t),o(e,Kr,t),o(e,R,t),o(e,qr,t),n(D,e,t),o(e,Or,t),o(e,U,t),o(e,eo,t),o(e,B,t),o(e,to,t),o(e,ro,t),o(e,oo,t),o(e,W,t),o(e,so,t),n(G,e,t),o(e,ao,t),o(e,N,t),o(e,lo,t),o(e,Z,t),o(e,io,t),o(e,Q,t),o(e,co,t),o(e,po,t),o(e,mo,t),o(e,X,t),o(e,no,t),n(V,e,t),o(e,uo,t),o(e,Y,t),o(e,ho,t),o(e,S,t),o(e,_o,t),o(e,K,t),o(e,fo,t),o(e,go,t),o(e,xo,t),o(e,q,t),o(e,To,t),n(O,e,t),o(e,bo,t),o(e,ee,t),o(e,yo,t),o(e,te,t),o(e,vo,t),o(e,re,t),o(e,$o,t),o(e,wo,t),o(e,Mo,t),o(e,oe,t),o(e,Eo,t),n(se,e,t),o(e,Co,t),o(e,ae,t),o(e,Po,t),o(e,le,t),o(e,Jo,t),o(e,de,t),o(e,Ho,t),o(e,Io,t),o(e,Fo,t),o(e,ie,t),o(e,ko,t),n(ce,e,t),o(e,jo,t),o(e,pe,t),o(e,Lo,t),o(e,me,t),o(e,zo,t),o(e,ne,t),o(e,Ao,t),o(e,Ro,t),o(e,Do,t),o(e,ue,t),o(e,Uo,t),n(he,e,t),o(e,Bo,t),o(e,_e,t),o(e,Wo,t),o(e,fe,t),o(e,Go,t),o(e,ge,t),o(e,No,t),o(e,Zo,t),o(e,Qo,t),o(e,xe,t),o(e,Xo,t),n(Te,e,t),o(e,Vo,t),o(e,be,t),o(e,Yo,t),o(e,ye,t),o(e,So,t),o(e,ve,t),o(e,Ko,t),o(e,qo,t),o(e,Oo,t),o(e,$e,t),o(e,es,t),n(we,e,t),o(e,ts,t),o(e,Me,t),o(e,rs,t),o(e,Ee,t),o(e,os,t),o(e,Ce,t),o(e,ss,t),o(e,as,t),o(e,ls,t),o(e,Pe,t),o(e,ds,t),n(Je,e,t),o(e,is,t),o(e,He,t),o(e,cs,t),o(e,Ie,t),o(e,ps,t),o(e,Fe,t),o(e,ms,t),o(e,ns,t),o(e,us,t),o(e,ke,t),o(e,hs,t),n(je,e,t),o(e,_s,t),o(e,Le,t),o(e,fs,t),o(e,ze,t),o(e,gs,t),o(e,Ae,t),o(e,xs,t),o(e,Ts,t),o(e,bs,t),o(e,Re,t),o(e,ys,t),n(De,e,t),o(e,vs,t),o(e,Ue,t),o(e,$s,t),o(e,ws,t),o(e,Ms,t),o(e,Be,t),o(e,Es,t),n(We,e,t),o(e,Cs,t),o(e,Ge,t),o(e,Ps,t),o(e,Ne,t),o(e,Js,t),o(e,Ze,t),o(e,Hs,t),o(e,Is,t),o(e,Fs,t),o(e,Qe,t),o(e,ks,t),n(Xe,e,t),o(e,js,t),o(e,Ve,t),o(e,Ls,t),o(e,Ye,t),o(e,zs,t),o(e,Se,t),o(e,As,t),o(e,Rs,t),o(e,Ds,t),o(e,Ke,t),o(e,Us,t),n(qe,e,t),o(e,Bs,t),o(e,Oe,t),o(e,Ws,t),o(e,et,t),o(e,Gs,t),o(e,tt,t),o(e,Ns,t),o(e,Zs,t),o(e,Qs,t),o(e,rt,t),o(e,Xs,t),n(ot,e,t),o(e,Vs,t),o(e,st,t),o(e,Ys,t),o(e,at,t),o(e,Ss,t),o(e,lt,t),o(e,Ks,t),o(e,qs,t),o(e,Os,t),o(e,dt,t),o(e,ea,t),n(it,e,t),o(e,ta,t),o(e,ct,t),o(e,ra,t),o(e,pt,t),o(e,oa,t),o(e,mt,t),o(e,sa,t),o(e,aa,t),o(e,la,t),o(e,nt,t),o(e,da,t),n(ut,e,t),o(e,ia,t),o(e,ht,t),o(e,ca,t),o(e,_t,t),o(e,pa,t),o(e,ma,t),o(e,na,t),o(e,ft,t),o(e,ua,t),n(gt,e,t),o(e,ha,t),o(e,xt,t),o(e,_a,t),o(e,Tt,t),o(e,fa,t),o(e,bt,t),o(e,ga,t),o(e,xa,t),o(e,Ta,t),o(e,yt,t),o(e,ba,t),n(vt,e,t),o(e,ya,t),o(e,$t,t),o(e,va,t),o(e,wt,t),o(e,$a,t),o(e,wa,t),o(e,Ma,t),o(e,Mt,t),o(e,Ea,t),n(Et,e,t),o(e,Ca,t),o(e,Ct,t),o(e,Pa,t),o(e,Pt,t),o(e,Ja,t),o(e,Jt,t),o(e,Ha,t),o(e,Ia,t),o(e,Fa,t),o(e,Ht,t),o(e,ka,t),n(It,e,t),o(e,ja,t),o(e,Ft,t),o(e,La,t),o(e,kt,t),o(e,za,t),n(jt,e,t),o(e,Aa,t),o(e,Lt,t),o(e,Ra,t),n(zt,e,t),o(e,Da,t),o(e,At,t),o(e,Ua,t),o(e,Ba,t),o(e,Wa,t),o(e,Rt,t),o(e,Ga,t),n(Dt,e,t),o(e,Na,t),o(e,Ut,t),o(e,Za,t),o(e,Bt,t),o(e,Qa,t),o(e,Wt,t),o(e,Xa,t),o(e,Gt,t),o(e,Va,t),o(e,Ya,t),o(e,Sa,t),o(e,Nt,t),o(e,Ka,t),n(Zt,e,t),o(e,qa,t),o(e,Qt,t),o(e,Oa,t),o(e,Xt,t),o(e,el,t),o(e,Vt,t),o(e,tl,t),o(e,rl,t),o(e,ol,t),o(e,Yt,t),o(e,sl,t),n(St,e,t),o(e,al,t),o(e,Kt,t),o(e,ll,t),o(e,qt,t),o(e,dl,t),o(e,Ot,t),o(e,il,t),o(e,cl,t),o(e,pl,t),o(e,er,t),o(e,ml,t),n(tr,e,t),o(e,nl,t),o(e,rr,t),o(e,ul,t),o(e,or,t),o(e,hl,t),o(e,_l,t),o(e,fl,t),o(e,sr,t),o(e,gl,t),n(ar,e,t),o(e,xl,t),o(e,lr,t),o(e,Tl,t),o(e,dr,t),o(e,bl,t),o(e,yl,t),o(e,vl,t),o(e,ir,t),o(e,$l,t),n(cr,e,t),o(e,wl,t),o(e,pr,t),o(e,Ml,t),o(e,mr,t),o(e,El,t),o(e,Cl,t),o(e,Pl,t),o(e,nr,t),o(e,Jl,t),n(ur,e,t),o(e,Hl,t),o(e,hr,t),o(e,Il,t),o(e,_r,t),o(e,Fl,t),o(e,kl,t),o(e,jl,t),o(e,fr,t),o(e,Ll,t),n(gr,e,t),o(e,zl,t),o(e,xr,t),o(e,Al,t),o(e,Tr,t),o(e,Rl,t),o(e,Dl,t),o(e,Ul,t),n(br,e,t),o(e,Bl,t),o(e,vr,t),Wl=!0},p:Hi,i(e){Wl||(u(b.$$.fragment,e),u($.$$.fragment,e),u(E.$$.fragment,e),u(H.$$.fragment,e),u(j.$$.fragment,e),u(D.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(O.$$.fragment,e),u(se.$$.fragment,e),u(ce.$$.fragment,e),u(he.$$.fragment,e),u(Te.$$.fragment,e),u(we.$$.fragment,e),u(Je.$$.fragment,e),u(je.$$.fragment,e),u(De.$$.fragment,e),u(We.$$.fragment,e),u(Xe.$$.fragment,e),u(qe.$$.fragment,e),u(ot.$$.fragment,e),u(it.$$.fragment,e),u(ut.$$.fragment,e),u(gt.$$.fragment,e),u(vt.$$.fragment,e),u(Et.$$.fragment,e),u(It.$$.fragment,e),u(jt.$$.fragment,e),u(zt.$$.fragment,e),u(Dt.$$.fragment,e),u(Zt.$$.fragment,e),u(St.$$.fragment,e),u(tr.$$.fragment,e),u(ar.$$.fragment,e),u(cr.$$.fragment,e),u(ur.$$.fragment,e),u(gr.$$.fragment,e),u(br.$$.fragment,e),Wl=!0)},o(e){h(b.$$.fragment,e),h($.$$.fragment,e),h(E.$$.fragment,e),h(H.$$.fragment,e),h(j.$$.fragment,e),h(D.$$.fragment,e),h(G.$$.fragment,e),h(V.$$.fragment,e),h(O.$$.fragment,e),h(se.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),h(je.$$.fragment,e),h(De.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(qe.$$.fragment,e),h(ot.$$.fragment,e),h(it.$$.fragment,e),h(ut.$$.fragment,e),h(gt.$$.fragment,e),h(vt.$$.fragment,e),h(Et.$$.fragment,e),h(It.$$.fragment,e),h(jt.$$.fragment,e),h(zt.$$.fragment,e),h(Dt.$$.fragment,e),h(Zt.$$.fragment,e),h(St.$$.fragment,e),h(tr.$$.fragment,e),h(ar.$$.fragment,e),h(cr.$$.fragment,e),h(ur.$$.fragment,e),h(gr.$$.fragment,e),h(br.$$.fragment,e),Wl=!1},d(e){e&&(r($r),r(yr),r(wr),r(T),r(Mr),r(Er),r(y),r(Cr),r(v),r(Pr),r(Jr),r(w),r(Hr),r(Ir),r(Fr),r(M),r(kr),r(jr),r(C),r(Lr),r(P),r(zr),r(Ar),r(Rr),r(J),r(Dr),r(Ur),r(I),r(Br),r(F),r(Wr),r(Gr),r(Nr),r(k),r(Zr),r(Qr),r(L),r(Xr),r(z),r(Vr),r(A),r(Yr),r(Sr),r(Kr),r(R),r(qr),r(Or),r(U),r(eo),r(B),r(to),r(ro),r(oo),r(W),r(so),r(ao),r(N),r(lo),r(Z),r(io),r(Q),r(co),r(po),r(mo),r(X),r(no),r(uo),r(Y),r(ho),r(S),r(_o),r(K),r(fo),r(go),r(xo),r(q),r(To),r(bo),r(ee),r(yo),r(te),r(vo),r(re),r($o),r(wo),r(Mo),r(oe),r(Eo),r(Co),r(ae),r(Po),r(le),r(Jo),r(de),r(Ho),r(Io),r(Fo),r(ie),r(ko),r(jo),r(pe),r(Lo),r(me),r(zo),r(ne),r(Ao),r(Ro),r(Do),r(ue),r(Uo),r(Bo),r(_e),r(Wo),r(fe),r(Go),r(ge),r(No),r(Zo),r(Qo),r(xe),r(Xo),r(Vo),r(be),r(Yo),r(ye),r(So),r(ve),r(Ko),r(qo),r(Oo),r($e),r(es),r(ts),r(Me),r(rs),r(Ee),r(os),r(Ce),r(ss),r(as),r(ls),r(Pe),r(ds),r(is),r(He),r(cs),r(Ie),r(ps),r(Fe),r(ms),r(ns),r(us),r(ke),r(hs),r(_s),r(Le),r(fs),r(ze),r(gs),r(Ae),r(xs),r(Ts),r(bs),r(Re),r(ys),r(vs),r(Ue),r($s),r(ws),r(Ms),r(Be),r(Es),r(Cs),r(Ge),r(Ps),r(Ne),r(Js),r(Ze),r(Hs),r(Is),r(Fs),r(Qe),r(ks),r(js),r(Ve),r(Ls),r(Ye),r(zs),r(Se),r(As),r(Rs),r(Ds),r(Ke),r(Us),r(Bs),r(Oe),r(Ws),r(et),r(Gs),r(tt),r(Ns),r(Zs),r(Qs),r(rt),r(Xs),r(Vs),r(st),r(Ys),r(at),r(Ss),r(lt),r(Ks),r(qs),r(Os),r(dt),r(ea),r(ta),r(ct),r(ra),r(pt),r(oa),r(mt),r(sa),r(aa),r(la),r(nt),r(da),r(ia),r(ht),r(ca),r(_t),r(pa),r(ma),r(na),r(ft),r(ua),r(ha),r(xt),r(_a),r(Tt),r(fa),r(bt),r(ga),r(xa),r(Ta),r(yt),r(ba),r(ya),r($t),r(va),r(wt),r($a),r(wa),r(Ma),r(Mt),r(Ea),r(Ca),r(Ct),r(Pa),r(Pt),r(Ja),r(Jt),r(Ha),r(Ia),r(Fa),r(Ht),r(ka),r(ja),r(Ft),r(La),r(kt),r(za),r(Aa),r(Lt),r(Ra),r(Da),r(At),r(Ua),r(Ba),r(Wa),r(Rt),r(Ga),r(Na),r(Ut),r(Za),r(Bt),r(Qa),r(Wt),r(Xa),r(Gt),r(Va),r(Ya),r(Sa),r(Nt),r(Ka),r(qa),r(Qt),r(Oa),r(Xt),r(el),r(Vt),r(tl),r(rl),r(ol),r(Yt),r(sl),r(al),r(Kt),r(ll),r(qt),r(dl),r(Ot),r(il),r(cl),r(pl),r(er),r(ml),r(nl),r(rr),r(ul),r(or),r(hl),r(_l),r(fl),r(sr),r(gl),r(xl),r(lr),r(Tl),r(dr),r(bl),r(yl),r(vl),r(ir),r($l),r(wl),r(pr),r(Ml),r(mr),r(El),r(Cl),r(Pl),r(nr),r(Jl),r(Hl),r(hr),r(Il),r(_r),r(Fl),r(kl),r(jl),r(fr),r(Ll),r(zl),r(xr),r(Al),r(Tr),r(Rl),r(Dl),r(Ul),r(Bl),r(vr)),r(x),_(b,e),_($,e),_(E,e),_(H,e),_(j,e),_(D,e),_(G,e),_(V,e),_(O,e),_(se,e),_(ce,e),_(he,e),_(Te,e),_(we,e),_(Je,e),_(je,e),_(De,e),_(We,e),_(Xe,e),_(qe,e),_(ot,e),_(it,e),_(ut,e),_(gt,e),_(vt,e),_(Et,e),_(It,e),_(jt,e),_(zt,e),_(Dt,e),_(Zt,e),_(St,e),_(tr,e),_(ar,e),_(cr,e),_(ur,e),_(gr,e),_(br,e)}}}const Ri='{"title":"processors","local":"processors","sections":[{"title":"processors.FeatureExtractor ⇐ <code> Callable </code>","local":"processorsfeatureextractor--code-callable-code","sections":[{"title":"new FeatureExtractor(config)","local":"new-featureextractorconfig","sections":[],"depth":3}],"depth":2},{"title":"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>","local":"processorsimagefeatureextractor--code-featureextractor-code","sections":[{"title":"new ImageFeatureExtractor(config)","local":"new-imagefeatureextractorconfig","sections":[],"depth":3},{"title":"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>","local":"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.rescale(pixelData) ⇒ <code> void </code>","local":"imagefeatureextractorrescalepixeldata--code-void-code","sections":[],"depth":3},{"title":"imageFeatureExtractor.get_resize_output_image_size(image, size) ⇒ <code> * </code>","local":"imagefeatureextractorgetresizeoutputimagesizeimage-size--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.resize(image) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorresizeimage--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>","local":"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>","local":"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code","sections":[],"depth":3}],"depth":2},{"title":"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>","local":"processorsdetrfeatureextractor--code-imagefeatureextractor-code","sections":[{"title":"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>","local":"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>","local":"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code","sections":[],"depth":3},{"title":"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>","local":"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>","local":"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>","local":"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>","local":"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code","sections":[],"depth":3}],"depth":2},{"title":"processors.Processor ⇐ <code> Callable </code>","local":"processorsprocessor--code-callable-code","sections":[{"title":"new Processor(feature_extractor)","local":"new-processorfeatureextractor","sections":[],"depth":3},{"title":"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>","local":"processorcallinput-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.WhisperProcessor ⇐ <code> Processor </code>","local":"processorswhisperprocessor--code-processor-code","sections":[{"title":"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>","local":"whisperprocessorcallaudio--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.AutoProcessor","local":"processorsautoprocessor","sections":[{"title":"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>","local":"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code","sections":[],"depth":3}],"depth":2},{"title":"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>","local":"processorscentertocornersformatarr--code-array--number--code","sections":[],"depth":2},{"title":"processors~enforce_size_divisibility(size, divisor) ⇒ <code> * </code>","local":"processorsenforcesizedivisibilitysize-divisor--code--code","sections":[],"depth":2},{"title":"processors~HeightWidth : <code> * </code>","local":"processorsheightwidth--code--code","sections":[],"depth":2},{"title":"processors~ImageFeatureExtractorResult : <code> object </code>","local":"processorsimagefeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~PreprocessedImage : <code> object </code>","local":"processorspreprocessedimage--code-object-code","sections":[],"depth":2},{"title":"processors~DetrFeatureExtractorResult : <code> object </code>","local":"processorsdetrfeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~SamImageProcessorResult : <code> object </code>","local":"processorssamimageprocessorresult--code-object-code","sections":[],"depth":2}],"depth":1}';function Di(Nl){return Ii(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ni extends Fi{constructor(x){super(),ki(this,x,Di,Ai,Ji,{})}}export{Ni as component};
