import{s as Re,n as He,o as Ve}from"../chunks/scheduler.389d799c.js";import{S as Xe,i as ze,g as i,s as a,r as u,A as Ee,h as p,f as l,c as n,j as Ge,u as r,x as m,k as xe,y as Fe,a as s,v as d,d as c,t as f,w as h}from"../chunks/index.8f81d18f.js";import{C as Me}from"../chunks/CodeBlock.3845caa1.js";import{H as he,E as Se}from"../chunks/EditOnGithub.33306dfe.js";function Le(we){let o,F,z,S,M,L,w,ye='<a href="https://githubtocolab.com/dylanebert/ml-for-3d-course-notebooks/blob/main/multi_view_diffusion.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',P,y,ge="In our case, we’ll be using a pretrained pipeline:",Q,g,N,J,Je='The name of the model is <a href="https://huggingface.co/dylanebert/multi-view-diffusion" rel="nofollow">dylanebert/multi-view-diffusion</a>, a mirror of <a href="https://huggingface.co/ashawkey/mvdream-sd2.1-diffusers" rel="nofollow">ashawkey/mvdream-sd2.1-diffusers</a>. For any pretrained model, you can find the model card on the Hugging Face Hub at <code>https://huggingface.co/&lt;model-name&gt;</code>, which contains information about the model.',q,T,Te="In our case, we also need to load the custom pipeline (also at <code>dylanebert/multi-view-diffusion</code>) to use the model. This is because diffusers doesn’t officially support 3D. So, for the purposes of this course, I’ve wrapped the model in a custom pipeline that allows you to use it for 3D tasks.",A,b,Y,j,D,C,be='<img src="https://huggingface.co/datasets/dylanebert/3d-arena/resolve/main/inputs/images/a_cat_statue.jpg" alt="Cat Statue"/>',K,U,je='With this code, we load and display the famous <a href="https://huggingface.co/datasets/dylanebert/3d-arena/resolve/main/inputs/images/a_cat_statue.jpg" rel="nofollow">Cat Statue</a>, used for image-to-3D demos.',O,_,ee,W,te,v,Ce="Finally, we run the pipeline on the image.",le,I,Ue="The <code>create_image_grid</code> function isn’t part of the pipeline. It’s just a helper function to display the results in a grid.",se,Z,_e="To run the pipeline, we simply prepare the image by converting it to a normalized numpy array:",ae,$,We="<code>image = np.array(image, dtype=np.float32) / 255.0</code>",ne,k,ve="Then, we pass it to the pipeline:",ie,B,Ie="<code>images = multi_view_diffusion_pipeline(&quot;&quot;, image, guidance_scale=5, num_inference_steps=30, elevation=0)</code>",pe,G,Ze="Where parameters <code>guidance_scale</code>, <code>num_inference_steps</code>, and <code>elevation</code> are specific to the multi-view diffusion model.",me,x,$e='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/ml-for-3d-course/multi-view-cats.png" alt="Multi-view Cats"/>',oe,R,ue,H,ke="Congratulations! You’ve run a multi-view diffusion pipeline.",re,V,Be="Now what about hosting your own demo?",de,X,ce,E,fe;return M=new he({props:{title:"Pipeline",local:"pipeline",headingTag:"h1"}}),g=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFtdWx0aV92aWV3X2RpZmZ1c2lvbl9waXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJkeWxhbmViZXJ0JTJGbXVsdGktdmlldy1kaWZmdXNpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJkeWxhbmViZXJ0JTJGbXVsdGktdmlldy1kaWZmdXNpb24lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

multi_view_diffusion_pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;dylanebert/multi-view-diffusion&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;dylanebert/multi-view-diffusion&quot;</span>,
    torch_dtype=torch.float16,
    trust_remote_code=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),b=new he({props:{title:"Load an Image",local:"load-an-image",headingTag:"h2"}}),j=new Me({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBJTBBJTBBaW1hZ2VfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGZHlsYW5lYmVydCUyRjNkLWFyZW5hJTJGcmVzb2x2ZSUyRm1haW4lMkZpbnB1dHMlMkZpbWFnZXMlMkZhX2NhdF9zdGF0dWUuanBnJTIyJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQoaW1hZ2VfdXJsKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKSUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO


image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/dylanebert/3d-arena/resolve/main/inputs/images/a_cat_statue.jpg&quot;</span>
response = requests.get(image_url)
image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content))
image`,wrap:!1}}),_=new he({props:{title:"Run the Pipeline",local:"run-the-pipeline",headingTag:"h2"}}),W=new Me({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZGVmJTIwY3JlYXRlX2ltYWdlX2dyaWQoaW1hZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QkltYWdlLmZyb21hcnJheSgoaW1nJTIwKiUyMDI1NSkuYXN0eXBlKCUyMnVpbnQ4JTIyKSklMjBmb3IlMjBpbWclMjBpbiUyMGltYWdlcyU1RCUwQSUwQSUyMCUyMCUyMCUyMHdpZHRoJTJDJTIwaGVpZ2h0JTIwJTNEJTIwaW1hZ2VzJTVCMCU1RC5zaXplJTBBJTIwJTIwJTIwJTIwZ3JpZF9pbWclMjAlM0QlMjBJbWFnZS5uZXcoJTIyUkdCJTIyJTJDJTIwKDIlMjAqJTIwd2lkdGglMkMlMjAyJTIwKiUyMGhlaWdodCkpJTBBJTBBJTIwJTIwJTIwJTIwZ3JpZF9pbWcucGFzdGUoaW1hZ2VzJTVCMCU1RCUyQyUyMCgwJTJDJTIwMCkpJTBBJTIwJTIwJTIwJTIwZ3JpZF9pbWcucGFzdGUoaW1hZ2VzJTVCMSU1RCUyQyUyMCh3aWR0aCUyQyUyMDApKSUwQSUyMCUyMCUyMCUyMGdyaWRfaW1nLnBhc3RlKGltYWdlcyU1QjIlNUQlMkMlMjAoMCUyQyUyMGhlaWdodCkpJTBBJTIwJTIwJTIwJTIwZ3JpZF9pbWcucGFzdGUoaW1hZ2VzJTVCMyU1RCUyQyUyMCh3aWR0aCUyQyUyMGhlaWdodCkpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZ3JpZF9pbWclMEElMEFpbWFnZSUyMCUzRCUyMG5wLmFycmF5KGltYWdlJTJDJTIwZHR5cGUlM0RucC5mbG9hdDMyKSUyMCUyRiUyMDI1NS4wJTBBaW1hZ2VzJTIwJTNEJTIwbXVsdGlfdmlld19kaWZmdXNpb25fcGlwZWxpbmUoJTIyJTIyJTJDJTIwaW1hZ2UlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDUlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzAlMkMlMjBlbGV2YXRpb24lM0QwKSUwQSUwQWNyZWF0ZV9pbWFnZV9ncmlkKGltYWdlcyk=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_image_grid</span>(<span class="hljs-params">images</span>):
    images = [Image.fromarray((img * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>)) <span class="hljs-keyword">for</span> img <span class="hljs-keyword">in</span> images]

    width, height = images[<span class="hljs-number">0</span>].size
    grid_img = Image.new(<span class="hljs-string">&quot;RGB&quot;</span>, (<span class="hljs-number">2</span> * width, <span class="hljs-number">2</span> * height))

    grid_img.paste(images[<span class="hljs-number">0</span>], (<span class="hljs-number">0</span>, <span class="hljs-number">0</span>))
    grid_img.paste(images[<span class="hljs-number">1</span>], (width, <span class="hljs-number">0</span>))
    grid_img.paste(images[<span class="hljs-number">2</span>], (<span class="hljs-number">0</span>, height))
    grid_img.paste(images[<span class="hljs-number">3</span>], (width, height))

    <span class="hljs-keyword">return</span> grid_img

image = np.array(image, dtype=np.float32) / <span class="hljs-number">255.0</span>
images = multi_view_diffusion_pipeline(<span class="hljs-string">&quot;&quot;</span>, image, guidance_scale=<span class="hljs-number">5</span>, num_inference_steps=<span class="hljs-number">30</span>, elevation=<span class="hljs-number">0</span>)

create_image_grid(images)`,wrap:!1}}),R=new he({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),X=new Se({props:{source:"https://github.com/huggingface/ml-for-3d-course/blob/main/units/en/unit2/pipeline.mdx"}}),{c(){o=i("meta"),F=a(),z=i("p"),S=a(),u(M.$$.fragment),L=a(),w=i("p"),w.innerHTML=ye,P=a(),y=i("p"),y.textContent=ge,Q=a(),u(g.$$.fragment),N=a(),J=i("p"),J.innerHTML=Je,q=a(),T=i("p"),T.innerHTML=Te,A=a(),u(b.$$.fragment),Y=a(),u(j.$$.fragment),D=a(),C=i("p"),C.innerHTML=be,K=a(),U=i("p"),U.innerHTML=je,O=a(),u(_.$$.fragment),ee=a(),u(W.$$.fragment),te=a(),v=i("p"),v.textContent=Ce,le=a(),I=i("p"),I.innerHTML=Ue,se=a(),Z=i("p"),Z.textContent=_e,ae=a(),$=i("p"),$.innerHTML=We,ne=a(),k=i("p"),k.textContent=ve,ie=a(),B=i("p"),B.innerHTML=Ie,pe=a(),G=i("p"),G.innerHTML=Ze,me=a(),x=i("p"),x.innerHTML=$e,oe=a(),u(R.$$.fragment),ue=a(),H=i("p"),H.textContent=ke,re=a(),V=i("p"),V.textContent=Be,de=a(),u(X.$$.fragment),ce=a(),E=i("p"),this.h()},l(e){const t=Ee("svelte-u9bgzb",document.head);o=p(t,"META",{name:!0,content:!0}),t.forEach(l),F=n(e),z=p(e,"P",{}),Ge(z).forEach(l),S=n(e),r(M.$$.fragment,e),L=n(e),w=p(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-v6uc4p"&&(w.innerHTML=ye),P=n(e),y=p(e,"P",{"data-svelte-h":!0}),m(y)!=="svelte-fp5no8"&&(y.textContent=ge),Q=n(e),r(g.$$.fragment,e),N=n(e),J=p(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-yrjro4"&&(J.innerHTML=Je),q=n(e),T=p(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-7qd2a7"&&(T.innerHTML=Te),A=n(e),r(b.$$.fragment,e),Y=n(e),r(j.$$.fragment,e),D=n(e),C=p(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1us2jjv"&&(C.innerHTML=be),K=n(e),U=p(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1ln5xdz"&&(U.innerHTML=je),O=n(e),r(_.$$.fragment,e),ee=n(e),r(W.$$.fragment,e),te=n(e),v=p(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-15hr6oi"&&(v.textContent=Ce),le=n(e),I=p(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-18nhbvh"&&(I.innerHTML=Ue),se=n(e),Z=p(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-8f1ljq"&&(Z.textContent=_e),ae=n(e),$=p(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-u0glvv"&&($.innerHTML=We),ne=n(e),k=p(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1cjs0sd"&&(k.textContent=ve),ie=n(e),B=p(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-e1i5gf"&&(B.innerHTML=Ie),pe=n(e),G=p(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1e9jktk"&&(G.innerHTML=Ze),me=n(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-v2rinw"&&(x.innerHTML=$e),oe=n(e),r(R.$$.fragment,e),ue=n(e),H=p(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1g4v259"&&(H.textContent=ke),re=n(e),V=p(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-ik6l2o"&&(V.textContent=Be),de=n(e),r(X.$$.fragment,e),ce=n(e),E=p(e,"P",{}),Ge(E).forEach(l),this.h()},h(){xe(o,"name","hf:doc:metadata"),xe(o,"content",Pe)},m(e,t){Fe(document.head,o),s(e,F,t),s(e,z,t),s(e,S,t),d(M,e,t),s(e,L,t),s(e,w,t),s(e,P,t),s(e,y,t),s(e,Q,t),d(g,e,t),s(e,N,t),s(e,J,t),s(e,q,t),s(e,T,t),s(e,A,t),d(b,e,t),s(e,Y,t),d(j,e,t),s(e,D,t),s(e,C,t),s(e,K,t),s(e,U,t),s(e,O,t),d(_,e,t),s(e,ee,t),d(W,e,t),s(e,te,t),s(e,v,t),s(e,le,t),s(e,I,t),s(e,se,t),s(e,Z,t),s(e,ae,t),s(e,$,t),s(e,ne,t),s(e,k,t),s(e,ie,t),s(e,B,t),s(e,pe,t),s(e,G,t),s(e,me,t),s(e,x,t),s(e,oe,t),d(R,e,t),s(e,ue,t),s(e,H,t),s(e,re,t),s(e,V,t),s(e,de,t),d(X,e,t),s(e,ce,t),s(e,E,t),fe=!0},p:He,i(e){fe||(c(M.$$.fragment,e),c(g.$$.fragment,e),c(b.$$.fragment,e),c(j.$$.fragment,e),c(_.$$.fragment,e),c(W.$$.fragment,e),c(R.$$.fragment,e),c(X.$$.fragment,e),fe=!0)},o(e){f(M.$$.fragment,e),f(g.$$.fragment,e),f(b.$$.fragment,e),f(j.$$.fragment,e),f(_.$$.fragment,e),f(W.$$.fragment,e),f(R.$$.fragment,e),f(X.$$.fragment,e),fe=!1},d(e){e&&(l(F),l(z),l(S),l(L),l(w),l(P),l(y),l(Q),l(N),l(J),l(q),l(T),l(A),l(Y),l(D),l(C),l(K),l(U),l(O),l(ee),l(te),l(v),l(le),l(I),l(se),l(Z),l(ae),l($),l(ne),l(k),l(ie),l(B),l(pe),l(G),l(me),l(x),l(oe),l(ue),l(H),l(re),l(V),l(de),l(ce),l(E)),l(o),h(M,e),h(g,e),h(b,e),h(j,e),h(_,e),h(W,e),h(R,e),h(X,e)}}}const Pe='{"title":"Pipeline","local":"pipeline","sections":[{"title":"Load an Image","local":"load-an-image","sections":[],"depth":2},{"title":"Run the Pipeline","local":"run-the-pipeline","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Qe(we){return Ve(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class De extends Xe{constructor(o){super(),ze(this,o,Qe,Le,Re,{})}}export{De as component};
