import{s as Pe,o as qe,n as Le}from"../chunks/scheduler.182ea377.js";import{S as De,i as Ke,g as n,s,r,A as Oe,h as p,f as t,c as a,j as Ae,u,x as o,k as L,y as el,a as i,v as c,d as f,t as d,w as y}from"../chunks/index.abf12888.js";import{T as ll}from"../chunks/Tip.230e2334.js";import{C as Z}from"../chunks/CodeBlock.57fe6e13.js";import{H as Be}from"../chunks/Heading.16916d63.js";function tl(D){let m,w='Take a look at the <a href="../api/pipelines/auto_pipeline">AutoPipeline</a> reference to see which tasks are supported. Currently, it supports text-to-image, image-to-image, and inpainting.';return{c(){m=n("p"),m.innerHTML=w},l(h){m=p(h,"P",{"data-svelte-h":!0}),o(m)!=="svelte-14r7e5m"&&(m.innerHTML=w)},m(h,P){i(h,m,P)},p:Le,d(h){h&&t(m)}}}function il(D){let m,w,h,P,J,K,j,ve='🤗 Diffusers is able to complete many different tasks, and you can often reuse the same pretrained weights for multiple tasks such as text-to-image, image-to-image, and inpainting. If you’re new to the library and diffusion models though, it may be difficult to know which pipeline to use for a task. For example, if you’re using the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a> checkpoint for text-to-image, you might not know that you could also use it for image-to-image and inpainting by loading the checkpoint with the <a href="/docs/diffusers/v0.26.1/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a> and <a href="/docs/diffusers/v0.26.1/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline">StableDiffusionInpaintPipeline</a> classes respectively.',O,W,_e="The <code>AutoPipeline</code> class is designed to simplify the variety of pipelines in 🤗 Diffusers. It is a generic, <em>task-first</em> pipeline that lets you focus on the task. The <code>AutoPipeline</code> automatically detects the correct pipeline class to use, which makes it easier to load a checkpoint for a task without knowing the specific pipeline class name.",ee,M,le,T,ke="This tutorial shows you how to use an <code>AutoPipeline</code> to automatically infer the pipeline class to load for a specific task, given the pretrained weights.",te,G,ie,B,Ie='Start by picking a checkpoint. For example, if you’re interested in text-to-image with the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a> checkpoint, use <a href="/docs/diffusers/v0.26.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForText2Image">AutoPipelineForText2Image</a>:',se,v,ae,g,Ve='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-text2img.png" alt="generated image of peasant fighting dragon in wood cutting style"/>',ne,_,Re='Under the hood, <a href="/docs/diffusers/v0.26.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForText2Image">AutoPipelineForText2Image</a>:',pe,k,Xe='<li>automatically detects a <code>&quot;stable-diffusion&quot;</code> class from the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code></a> file</li> <li>loads the corresponding text-to-image <a href="/docs/diffusers/v0.26.1/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> based on the <code>&quot;stable-diffusion&quot;</code> class name</li>',oe,I,Fe='Likewise, for image-to-image, <a href="/docs/diffusers/v0.26.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image">AutoPipelineForImage2Image</a> detects a <code>&quot;stable-diffusion&quot;</code> checkpoint from the <code>model_index.json</code> file and it’ll load the corresponding <a href="/docs/diffusers/v0.26.1/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a> behind the scenes. You can also pass any additional arguments specific to the pipeline class such as <code>strength</code>, which determines the amount of noise or variation added to an input image:',me,V,re,b,Ce='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-img2img.png" alt="generated image of a vermeer portrait of a dog wearing a pearl earring"/>',ue,R,xe='And if you want to do inpainting, then <a href="/docs/diffusers/v0.26.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForInpainting">AutoPipelineForInpainting</a> loads the underlying <a href="/docs/diffusers/v0.26.1/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline">StableDiffusionInpaintPipeline</a> class in the same way:',ce,X,fe,U,$e='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-inpaint.png" alt="generated image of a tiger sitting on a bench"/>',de,F,Se="If you try to load an unsupported checkpoint, it’ll throw an error:",ye,C,he,x,Me,$,Ye='For some workflows or if you’re loading many pipelines, it is more memory-efficient to reuse the same components from a checkpoint instead of reloading them which would unnecessarily consume additional memory. For example, if you’re using a checkpoint for text-to-image and you want to use it again for image-to-image, use the <a href="/docs/diffusers/v0.26.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe">from_pipe()</a> method. This method creates a new pipeline from the components of a previously loaded pipeline at no additional memory cost.',ge,S,He='The <a href="/docs/diffusers/v0.26.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe">from_pipe()</a> method detects the original pipeline class and maps it to the new pipeline class corresponding to the task you want to do. For example, if you load a <code>&quot;stable-diffusion&quot;</code> class pipeline for text-to-image:',be,Y,Ue,H,Qe='Then <a href="/docs/diffusers/v0.26.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe">from_pipe()</a> maps the original <code>&quot;stable-diffusion&quot;</code> pipeline class to <a href="/docs/diffusers/v0.26.1/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a>:',Ze,Q,we,z,ze="If you passed an optional argument - like disabling the safety checker - to the original pipeline, this argument is also passed on to the new pipeline:",Je,E,je,N,Ee="You can overwrite any of the arguments and even configuration from the original pipeline if you want to change the behavior of the new pipeline. For example, to turn the safety checker back on and add the <code>strength</code> argument:",We,A,Te,q,Ge;return J=new Be({props:{title:"AutoPipeline",local:"autopipeline",headingTag:"h1"}}),M=new ll({props:{$$slots:{default:[tl]},$$scope:{ctx:D}}}),G=new Be({props:{title:"Choose an AutoPipeline for your task",local:"choose-an-autopipeline-for-your-task",headingTag:"h2"}}),v=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMnBlYXNhbnQlMjBhbmQlMjBkcmFnb24lMjBjb21iYXQlMkMlMjB3b29kJTIwY3V0dGluZyUyMHN0eWxlJTJDJTIwdmlraW5nJTIwZXJhJTJDJTIwYmV2ZWwlMjB3aXRoJTIwcnVuZSUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;peasant and dragon combat, wood cutting style, viking era, bevel with rune&quot;</span>

image = pipeline(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),V=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBvcnRyYWl0JTIwb2YlMjBhJTIwZG9nJTIwd2VhcmluZyUyMGElMjBwZWFybCUyMGVhcnJpbmclMjIlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGMCUyRjBmJTJGMTY2NV9HaXJsX3dpdGhfYV9QZWFybF9FYXJyaW5nLmpwZyUyRjgwMHB4LTE2NjVfR2lybF93aXRoX2FfUGVhcmxfRWFycmluZy5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWltYWdlLnRodW1ibmFpbCgoNzY4JTJDJTIwNzY4KSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwMCUyQyUyMHN0cmVuZ3RoJTNEMC43NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMTAuNSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;a portrait of a dog wearing a pearl earring&quot;</span>

url = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/0/0f/1665_Girl_with_a_Pearl_Earring.jpg/800px-1665_Girl_with_a_Pearl_Earring.jpg&quot;</span>

response = requests.get(url)
image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image.thumbnail((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))

image = pipeline(prompt, image, num_inference_steps=<span class="hljs-number">200</span>, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">10.5</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),X=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBbWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UobWFza191cmwpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBtYWplc3RpYyUyMHRpZ2VyJTIwc2l0dGluZyUyMG9uJTIwYSUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMHN0cmVuZ3RoJTNEMC44MCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

prompt = <span class="hljs-string">&quot;A majestic tiger sitting on a bench&quot;</span>
image = pipeline(prompt, image=init_image, mask_image=mask_image, num_inference_steps=<span class="hljs-number">50</span>, strength=<span class="hljs-number">0.80</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),C=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVuYWklMkZzaGFwLWUtaW1nMmltZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTIyVmFsdWVFcnJvciUzQSUyMEF1dG9QaXBlbGluZSUyMGNhbid0JTIwZmluZCUyMGElMjBwaXBlbGluZSUyMGxpbmtlZCUyMHRvJTIwU2hhcEVJbWcySW1nUGlwZWxpbmUlMjBmb3IlMjBOb25lJTIy",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;openai/shap-e-img2img&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-string">&quot;ValueError: AutoPipeline can&#x27;t find a pipeline linked to ShapEImg2ImgPipeline for None&quot;</span>`,wrap:!1}}),x=new Be({props:{title:"Use multiple pipelines",local:"use-multiple-pipelines",headingTag:"h2"}}),Y=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmVfdGV4dDJpbWclMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcHJpbnQodHlwZShwaXBlbGluZV90ZXh0MmltZykpJTBBJTIyJTNDY2xhc3MlMjAnZGlmZnVzZXJzLnBpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uLnBpcGVsaW5lX3N0YWJsZV9kaWZmdXNpb24uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUnJTNFJTIy",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2img = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">type</span>(pipeline_text2img))
<span class="hljs-string">&quot;&lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt;&quot;</span>`,wrap:!1}}),Q=new Z({props:{code:"cGlwZWxpbmVfaW1nMmltZyUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltZyklMEFwcmludCh0eXBlKHBpcGVsaW5lX2ltZzJpbWcpKSUwQSUyMiUzQ2NsYXNzJTIwJ2RpZmZ1c2Vycy5waXBlbGluZXMuc3RhYmxlX2RpZmZ1c2lvbi5waXBlbGluZV9zdGFibGVfZGlmZnVzaW9uX2ltZzJpbWcuU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJyUzRSUyMg==",highlighted:`pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">type</span>(pipeline_img2img))
<span class="hljs-string">&quot;&lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion_img2img.StableDiffusionImg2ImgPipeline&#x27;&gt;&quot;</span>`,wrap:!1}}),E=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmVfdGV4dDJpbWclMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXF1aXJlc19zYWZldHlfY2hlY2tlciUzREZhbHNlJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXBpcGVsaW5lX2ltZzJpbWclMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3BpcGUocGlwZWxpbmVfdGV4dDJpbWcpJTBBcHJpbnQocGlwZWxpbmVfaW1nMmltZy5jb25maWcucmVxdWlyZXNfc2FmZXR5X2NoZWNrZXIpJTBBJTIyRmFsc2UlMjI=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2img = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
    requires_safety_checker=<span class="hljs-literal">False</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img)
<span class="hljs-built_in">print</span>(pipeline_img2img.config.requires_safety_checker)
<span class="hljs-string">&quot;False&quot;</span>`,wrap:!1}}),A=new Z({props:{code:"cGlwZWxpbmVfaW1nMmltZyUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltZyUyQyUyMHJlcXVpcmVzX3NhZmV0eV9jaGVja2VyJTNEVHJ1ZSUyQyUyMHN0cmVuZ3RoJTNEMC4zKSUwQXByaW50KHBpcGVsaW5lX2ltZzJpbWcuY29uZmlnLnJlcXVpcmVzX3NhZmV0eV9jaGVja2VyKSUwQSUyMlRydWUlMjI=",highlighted:`pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img, requires_safety_checker=<span class="hljs-literal">True</span>, strength=<span class="hljs-number">0.3</span>)
<span class="hljs-built_in">print</span>(pipeline_img2img.config.requires_safety_checker)
<span class="hljs-string">&quot;True&quot;</span>`,wrap:!1}}),{c(){m=n("meta"),w=s(),h=n("p"),P=s(),r(J.$$.fragment),K=s(),j=n("p"),j.innerHTML=ve,O=s(),W=n("p"),W.innerHTML=_e,ee=s(),r(M.$$.fragment),le=s(),T=n("p"),T.innerHTML=ke,te=s(),r(G.$$.fragment),ie=s(),B=n("p"),B.innerHTML=Ie,se=s(),r(v.$$.fragment),ae=s(),g=n("div"),g.innerHTML=Ve,ne=s(),_=n("p"),_.innerHTML=Re,pe=s(),k=n("ol"),k.innerHTML=Xe,oe=s(),I=n("p"),I.innerHTML=Fe,me=s(),r(V.$$.fragment),re=s(),b=n("div"),b.innerHTML=Ce,ue=s(),R=n("p"),R.innerHTML=xe,ce=s(),r(X.$$.fragment),fe=s(),U=n("div"),U.innerHTML=$e,de=s(),F=n("p"),F.textContent=Se,ye=s(),r(C.$$.fragment),he=s(),r(x.$$.fragment),Me=s(),$=n("p"),$.innerHTML=Ye,ge=s(),S=n("p"),S.innerHTML=He,be=s(),r(Y.$$.fragment),Ue=s(),H=n("p"),H.innerHTML=Qe,Ze=s(),r(Q.$$.fragment),we=s(),z=n("p"),z.textContent=ze,Je=s(),r(E.$$.fragment),je=s(),N=n("p"),N.innerHTML=Ee,We=s(),r(A.$$.fragment),Te=s(),q=n("p"),this.h()},l(e){const l=Oe("svelte-u9bgzb",document.head);m=p(l,"META",{name:!0,content:!0}),l.forEach(t),w=a(e),h=p(e,"P",{}),Ae(h).forEach(t),P=a(e),u(J.$$.fragment,e),K=a(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-185gpjg"&&(j.innerHTML=ve),O=a(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1unhzn0"&&(W.innerHTML=_e),ee=a(e),u(M.$$.fragment,e),le=a(e),T=p(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-wmnxi6"&&(T.innerHTML=ke),te=a(e),u(G.$$.fragment,e),ie=a(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-13whwhh"&&(B.innerHTML=Ie),se=a(e),u(v.$$.fragment,e),ae=a(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-1yzwly4"&&(g.innerHTML=Ve),ne=a(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1rqpi5m"&&(_.innerHTML=Re),pe=a(e),k=p(e,"OL",{"data-svelte-h":!0}),o(k)!=="svelte-1ycyqhu"&&(k.innerHTML=Xe),oe=a(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-3qpbv6"&&(I.innerHTML=Fe),me=a(e),u(V.$$.fragment,e),re=a(e),b=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-9fi2fw"&&(b.innerHTML=Ce),ue=a(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1jyk25k"&&(R.innerHTML=xe),ce=a(e),u(X.$$.fragment,e),fe=a(e),U=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-1id5o5z"&&(U.innerHTML=$e),de=a(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-77swfd"&&(F.textContent=Se),ye=a(e),u(C.$$.fragment,e),he=a(e),u(x.$$.fragment,e),Me=a(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-lzbmdt"&&($.innerHTML=Ye),ge=a(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-dix47a"&&(S.innerHTML=He),be=a(e),u(Y.$$.fragment,e),Ue=a(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-lniecy"&&(H.innerHTML=Qe),Ze=a(e),u(Q.$$.fragment,e),we=a(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-kxf2pi"&&(z.textContent=ze),Je=a(e),u(E.$$.fragment,e),je=a(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-wave52"&&(N.innerHTML=Ee),We=a(e),u(A.$$.fragment,e),Te=a(e),q=p(e,"P",{}),Ae(q).forEach(t),this.h()},h(){L(m,"name","hf:doc:metadata"),L(m,"content",sl),L(g,"class","flex justify-center"),L(b,"class","flex justify-center"),L(U,"class","flex justify-center")},m(e,l){el(document.head,m),i(e,w,l),i(e,h,l),i(e,P,l),c(J,e,l),i(e,K,l),i(e,j,l),i(e,O,l),i(e,W,l),i(e,ee,l),c(M,e,l),i(e,le,l),i(e,T,l),i(e,te,l),c(G,e,l),i(e,ie,l),i(e,B,l),i(e,se,l),c(v,e,l),i(e,ae,l),i(e,g,l),i(e,ne,l),i(e,_,l),i(e,pe,l),i(e,k,l),i(e,oe,l),i(e,I,l),i(e,me,l),c(V,e,l),i(e,re,l),i(e,b,l),i(e,ue,l),i(e,R,l),i(e,ce,l),c(X,e,l),i(e,fe,l),i(e,U,l),i(e,de,l),i(e,F,l),i(e,ye,l),c(C,e,l),i(e,he,l),c(x,e,l),i(e,Me,l),i(e,$,l),i(e,ge,l),i(e,S,l),i(e,be,l),c(Y,e,l),i(e,Ue,l),i(e,H,l),i(e,Ze,l),c(Q,e,l),i(e,we,l),i(e,z,l),i(e,Je,l),c(E,e,l),i(e,je,l),i(e,N,l),i(e,We,l),c(A,e,l),i(e,Te,l),i(e,q,l),Ge=!0},p(e,[l]){const Ne={};l&2&&(Ne.$$scope={dirty:l,ctx:e}),M.$set(Ne)},i(e){Ge||(f(J.$$.fragment,e),f(M.$$.fragment,e),f(G.$$.fragment,e),f(v.$$.fragment,e),f(V.$$.fragment,e),f(X.$$.fragment,e),f(C.$$.fragment,e),f(x.$$.fragment,e),f(Y.$$.fragment,e),f(Q.$$.fragment,e),f(E.$$.fragment,e),f(A.$$.fragment,e),Ge=!0)},o(e){d(J.$$.fragment,e),d(M.$$.fragment,e),d(G.$$.fragment,e),d(v.$$.fragment,e),d(V.$$.fragment,e),d(X.$$.fragment,e),d(C.$$.fragment,e),d(x.$$.fragment,e),d(Y.$$.fragment,e),d(Q.$$.fragment,e),d(E.$$.fragment,e),d(A.$$.fragment,e),Ge=!1},d(e){e&&(t(w),t(h),t(P),t(K),t(j),t(O),t(W),t(ee),t(le),t(T),t(te),t(ie),t(B),t(se),t(ae),t(g),t(ne),t(_),t(pe),t(k),t(oe),t(I),t(me),t(re),t(b),t(ue),t(R),t(ce),t(fe),t(U),t(de),t(F),t(ye),t(he),t(Me),t($),t(ge),t(S),t(be),t(Ue),t(H),t(Ze),t(we),t(z),t(Je),t(je),t(N),t(We),t(Te),t(q)),t(m),y(J,e),y(M,e),y(G,e),y(v,e),y(V,e),y(X,e),y(C,e),y(x,e),y(Y,e),y(Q,e),y(E,e),y(A,e)}}}const sl='{"title":"AutoPipeline","local":"autopipeline","sections":[{"title":"Choose an AutoPipeline for your task","local":"choose-an-autopipeline-for-your-task","sections":[],"depth":2},{"title":"Use multiple pipelines","local":"use-multiple-pipelines","sections":[],"depth":2}],"depth":1}';function al(D){return qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ul extends De{constructor(m){super(),Ke(this,m,al,il,Pe,{})}}export{ul as component};
