import{s as Xs,n as Fs,o as Qs}from"../chunks/scheduler.39a43cde.js";import{S as zs,i as Ys,g as i,s as l,r,A as qs,h as o,f as n,c as a,j as xs,u as c,x as p,k as Hs,y as Ss,a as s,v as u,d,t as M,w as h}from"../chunks/index.23ec2204.js";import{D as Ls,C as m}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as f}from"../chunks/Heading.c42e7061.js";function Ps(Xn){let y,nt,et,st,w,lt,g,at,b,Fn='<em>Authored by: <a href="https://huggingface.co/davidberenstein1957" rel="nofollow">David Berenstein</a> and <a href="https://huggingface.co/sdiazlor" rel="nofollow">Sara Han Díaz</a></em>',it,T,Qn="In this tutorial, you will learn how to use the Notus model on  the HF Inference Endpoints to create a legal preference dataset based on Retrieval Augmented Generation instructions from the European AI Act. A full end-to-end example of how to use distilabel to leverage LLMs!",ot,J,zn='<a href="https://github.com/argilla-io/distilabel" rel="nofollow">distilabel</a> is an AI Feedback (AIF) framework that can generate and label datasets using LLMs and can be used for many different use cases. Implemented with robustness, efficiency, and scalability in mind, it allows anyone to build their synthetic datasets that can be used in many different scenarios.',pt,j,Yn='To generate the instruction dataset, we will use the <a href="https://huggingface.co/docs/inference-endpoints/en/index" rel="nofollow">HF Inference Endpoints</a> integrated with distilabel. These Inference Endpoints are provided by Hugging Face and allow to easily deploy and run transformers, diffusers or any available model from the Hub on a dedicated and autoscaling infrastructure. You can find more information on how to create your first endpoint <a href="https://huggingface.co/docs/inference-endpoints/guides/create_endpoint" rel="nofollow">here</a>.',rt,U,qn='The LLM model that we will fine-tune for this is <a href="https://argilla.io/blog/notus7b/" rel="nofollow">Notus 7B</a>, a fine-tuned version of Zephyr 7B that uses Direct Preference Optimization (DPO) and AIF techniques to outperform its foundation model in several benchmarks and is completely open-source.',ct,I,Sn="This tutorial includes the following steps:",ut,k,Ln="<li>Defining a custom generating task for a <code>distilabel</code> pipeline.</li> <li>Creating a RAG pipeline using Haystack for the EU AI Act.</li> <li>Generating an instruction dataset with <code>SelfInstructTask</code>.</li> <li>Generating a preference dataset using an <code>UltraFeedback</code> text quality task.</li>",dt,C,Mt,v,Pn="Let’s start by installing the required dependencies to run <strong>distilabel</strong> and the rest of the packages used in the tutorial; most notably, <strong>Haystack</strong>. Install also <strong>Argilla</strong> for a better visualization and curation of the results.",ht,$,mt,Z,ft,_,Dn='The main dependencies for this tutorial are distilabel for creating the synthetic datasets and Argilla for visualizing and annotating these datasets, and also for fine-tuning our model. The package <a href="https://haystack.deepset.ai/" rel="nofollow">Haystack</a> is used to create batches from the original PDF document we want to create our datasets from.',yt,G,wt,R,gt,V,On='We need to provide our HuggingFace access token, which can be retrieved from <a href="https://huggingface.co/settings/tokens" rel="nofollow">Settings</a>. In addition, we also need the OpenAI api key for the generation of the preference dataset through the UltraFeedback text quality task. You can find it <a href="https://platform.openai.com/api-keys" rel="nofollow">here</a>. Note that depending on the model used, a different fee will be charged, so make sure you check the OpenAI <a href="https://openai.com/pricing" rel="nofollow">pricing page</a>.',bt,E,Kn="To later instantiate an <code>InferenceEndpointsLLM</code> object, we need to pass as parameters the HF Inference Endpoint name and the HF namespace. One very convenient way to do so is also through environment variables.",Tt,N,Jt,W,jt,A,es='Inference endpoints are a solution, managed by Hugging Face, to easily deploy any Transformer-like model. They are built from models on the Hugging Face Hub. Inference endpoints are handy for making inference on LLMs without the hassle of trying to run the models locally. In this tutorial, we will use inference endpoints to generate text using our Notus model, as part of the <code>distilabel</code> workflow. The endpoint of choice has a <a href="https://ui.endpoints.huggingface.co/argilla/endpoints/aws-notus-7b-v1-4052" rel="nofollow">Notus 7B instance</a> running.',Ut,B,It,x,ts="To kickstart this tutorial, let’s see how to set up an endpoint for our Notus model. It’s not part of the end-to-end example we’ll see later, but an example of how to connect to a Hugging Face endpoint and a test of the <code>distilabel</code> pipeline.",kt,H,ns="Let’s dive into this quick example of how to use an inference endpoint. We have prepared an easy <code>TextGenerationTask</code> to ask questions to the model, in a very similar way as we talk with the LLMs using chatbots. First, we define a class for the question-answering task, with functions showing <code>distilabel</code> how the model should generate the prompts, parse the input and the output, etc.",Ct,X,vt,F,ss="<code>llm</code> is an object of the <code>InferenceEndpointsLLM</code> class, and by using it we can start generating answers to question using the <code>llm.generate()</code> method.",$t,Q,Zt,z,ls="With the <code>InferenceEndpointsLLM</code> object defined with the endpoint information and the Task, we can go ahead and start generating text. Let’s ask this LLM what’s, for example, the second most populated city in Denmark. The answer should be Aarhus.",_t,Y,Gt,q,as="The endpoint is working correctly! We have succesfully set up a custom generating task for a <code>distilabel</code> pipeline.",Rt,S,Vt,L,is="For this end-to-end example, we would like to create an expert model capable of answering question and filling up information about the new AI Act promoted by the European Union, which is the first regulation on artificial intelligence. As part of its digital strategy, the EU wants to regulate artificial AI to ensure better conditions for the development and use of this innovative technology. This act is a regulatory framework for AI, with different risk levels meaning more or less regulation. They are the world’s first rules on AI.",Et,P,os="This RAG pipeline that we want to create downloads the PDF file, converts it to plain text and preprocess it, creating batches that we can feed <code>distilabel</code> to start creating instructions from it. Let’s see this first part of the pipeline and get the input data. Note that this RAG part of the pipeline is not based on an active pipeline based queries or semantic properties, but a more brute-force approach in which we download the PDF and preprocess its contents.",Nt,D,Wt,O,ps="Firstly, we need to download the PDF document itself. We’ll place it in our working directory, if it’s not there already.",At,K,Bt,ee,rs="Once we have it in our working directory, we can use Haystack’s Converter and Pipeline features to extract the textual data, clean it and divide it in different batches. Afterwards, these batches will be used to start creating synthetic instructions.",xt,te,Ht,ne,cs="Let’s take a quick look at the batches we just generated.",Xt,se,Ft,le,us="The document has been correctly batched, from one big document to 355 strings, 150-character long at maximum. This list of strings can now be used as input to generate a instruction dataset using <code>distilabel</code>.",Qt,ae,zt,ie,ds="With our Inference Endpoint up and running, we should be able to generate instructions with distilabel. These instructions, made by the LLM through our endpoint, will form an instruction dataset, with instructions created from the data we just extracted.",Yt,oe,Ms="For this example, we are using a subset of 50 batches generated in the section above, to be gentle on performance.",qt,pe,St,re,hs='With the <code>SelfInstructTask</code> class we can generate a Self-Instruct specitification for building the prompts, as done in the <a href="https://arxiv.org/abs/2212.10560" rel="nofollow">Self-Instruct paper</a>. <code>distilabel</code> will start from human-made input, in this case, the batches we created from the AI Act pdf, and it will generate instructions based on it. These instructions can then be reviewed using Argilla to keep the best ones.',Lt,ce,ms="An application description can be passed as a parameter to specify the behaviour of the model; we want a model capable of answering our questions about the AI Act.",Pt,ue,Dt,de,fs="Let’s now define a generator, passing the <code>SelfInstructTask</code> object, and create a <code>Pipeline</code> object.",Ot,Me,Kt,he,ys="Our pipeline is ready to be used to generate instructions. Let’s do it!",en,me,tn,fe,ws="The pipeline has succesfully generated instructions given the topics and the behavior passed as input. Let’s gather all those instructions and see how they look.",nn,ye,sn,we,gs=`Number of generated instructions: 178
What are the reasons for and objectives of the proposal for a Regulation laying down harmonised rules on artificial intelligence?
How can artificial intelligence improve prediction, optimise operations and resource allocation, and personalise service delivery?
What benefits can artificial intelligence bring to the European economy and society as a whole?
How can the use of artificial intelligence support socially and environmentally beneficial outcomes?
What are the high-impact sectors that require AI action according to the AI Act by the European Union?
`,ln,ge,bs="These initial instructions create our instruction dataset. Following the human-in-the-loop approach, we should push the instructions to Argilla to visualize them and be able to rank them in terms of quality. Those annotations are essential to make quality data, ensuring a better performance of the final model. Nevertheless, this step is optional.",an,be,on,Te,Ts="Let’s take a quick look at the instructions generated by <code>SelfInstructTask</code>.",pn,Je,rn,je,Js="For each input, i.e., each batch of the AI Act pdf file, we have a generator prompt, with general guidelines on how to behave, as well as the application description parameter. 4 instructions per input have been generated.",cn,Ue,js="Now it’s the perfect time to upload the instruction dataset to Argilla, review it and manually annotate it.",un,Ie,dn,ke,Mn,Ce,Us="In the Argilla UI, each tuple input-instruction is visualized individually, and can be individually annotated.",hn,ve,Is='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/instrucion_dataset_notus_ui.png" alt="Instruction dataset"/>',mn,$e,fn,Ze,ks="Once we have our instruction dataset, we are going to create a preference dataset through the UltraFeedback text quality task. This is a type of task used in NLP used to evaluate the quality of text generated; our goal is to provide detailed feedback on the quality of the generated text, beyond a binary label.",yn,_e,Cs="Our <code>pipeline()</code> method allows us to create a <code>Pipeline</code> instance with the provided LLMs for a given task, which is useful whenever you want to use a pre-defined or custom <code>Pipeline</code> for a given task. We will specify our task and subtask, the generator we want to use (in this case, one based in a Text Generator Task) and our OpenAI API key.",wn,Ge,vs="<p>Note that not using a OpenAI model to retrieve this feedback is also possible. However, the performance will suffer and the quality of the feedback will be lower.</p>",gn,Re,bn,Ve,$s="We also need to retrieve our instruction dataset from Argilla, as it will be the input of this pipeline.",Tn,Ee,Jn,Ne,jn,We,Zs="Before generating the text based on our instructions, we need to rename some of the columns in our dataset. From the previous section, we still have our old input, the batches from the PDF. We have to change that to the instructions that we generated.",Un,Ae,In,Be,_s="Now, let’s build a dataset by using the pipeline we just created, and the topics from which our instructions were generated.",kn,xe,Cn,He,Gs="Let’s take a look at an instance of the preference dataset:",vn,Xe,$n,Fe,Zn,Qe,Rs='You can use the AI Feedback created by distilabel directly but we have seen that enhancing it with human feedback will improve the quality of your LLM. We provide a <code>to_argilla</code> method which creates a dataset for Argilla along with out-of-the-box tailored metadata filters and semantic search to allow you to provide human feedback as quickly and engaging as possible. You can check <a href="https://docs.argilla.io/en/latest/getting_started/quickstart_installation.html" rel="nofollow">the Argilla docs</a> to get it up and running.',_n,ze,Vs="If you are running Argilla using the Docker quickstart image or Hugging Face Spaces, you need to init the Argilla client with the URL and API_KEY:",Gn,Ye,Rn,qe,Es="Once our preference dataset has been correctly generated, the Argilla UI is the best tool at our disposal to visualize and annotate it. As for the instruction dataset, we just have to convert it to an Argilla Feedback Dataset, and push it to Argilla.",Vn,Se,En,Le,Ns="In the Argilla UI, we can see the input (an instruction), and the two generations that the LLM created out of it.",Nn,Pe,Ws='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/preference_dataset_notus_ui.png" alt="Preference dataset"/>',Wn,De,An,Oe,As="To conclude, we have gone through an end-to-end example of distilabel. We’ve set up an Inference Endpoint, defined a distilabel pipeline that extracts information from a PDF, and created and manually reviewed the instruction and preference dataset created from that input. The final preference dataset is perfect for fine-tuning, and you can easily do this using the ArgillaTrainer from Argilla. Have a look at these resources if you want to go further:",Bn,Ke,Bs='<li><a href="https://docs.argilla.io/en/latest/tutorials_and_integrations/tutorials/feedback/end2end_examples/train-model-006.html" rel="nofollow">Train a Model with ArgillaTrainer</a></li> <li><a href="https://docs.argilla.io/en/latest/tutorials_and_integrations/tutorials/feedback/training-llm-mistral-sft.html" rel="nofollow">Ⓜ️ Finetuning LLMs as chat assistants: Supervised Finetuning on Mistral 7B</a></li> <li><a href="https://docs.argilla.io/en/latest/tutorials_and_integrations/tutorials/feedback/fine-tuning-sentencesimilarity-rag.html" rel="nofollow">🌠 Improving RAG by Optimizing Retrieval and Reranking Models</a></li>',xn,tt,Hn;return w=new Ls({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/pipeline_notus_instructions_preferences_legal.ipynb"}]}}),g=new f({props:{title:"⚖️ Create a legal preference dataset",local:"-create-a-legal-preference-dataset",headingTag:"h1"}}),C=new f({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),$=new m({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMC1VJTIwZGlzdGlsYWJlbCUyMCUyMmZhcm0taGF5c3RhY2slNUJwcmVwcm9jZXNzaW5nJTVEJTIyJTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMC1VJTIwJTIyZGlzdGlsYWJlbCU1QmhmLWluZmVyZW5jZS1lbmRwb2ludHMlMkMlMjBhcmdpbGxhJTVEJTIy",highlighted:`!pip install -q -U distilabel <span class="hljs-string">&quot;farm-haystack[preprocessing]&quot;</span>
!pip install -q -U <span class="hljs-string">&quot;distilabel[hf-inference-endpoints, argilla]&quot;</span>`,wrap:!1}}),Z=new f({props:{title:"Import dependencies",local:"import-dependencies",headingTag:"h3"}}),G=new m({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwRGljdCUwQSUwQWZyb20lMjBkaXN0aWxhYmVsLmxsbSUyMGltcG9ydCUyMEluZmVyZW5jZUVuZHBvaW50c0xMTSUwQWZyb20lMjBkaXN0aWxhYmVsLnBpcGVsaW5lJTIwaW1wb3J0JTIwUGlwZWxpbmUlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBkaXN0aWxhYmVsLnRhc2tzJTIwaW1wb3J0JTIwVGV4dEdlbmVyYXRpb25UYXNrJTJDJTIwU2VsZkluc3RydWN0VGFzayUyQyUyMFByb21wdCUwQSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMERhdGFzZXQlMEFmcm9tJTIwaGF5c3RhY2subm9kZXMlMjBpbXBvcnQlMjBQREZUb1RleHRDb252ZXJ0ZXIlMkMlMjBQcmVQcm9jZXNzb3I=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>

<span class="hljs-keyword">from</span> distilabel.llm <span class="hljs-keyword">import</span> InferenceEndpointsLLM
<span class="hljs-keyword">from</span> distilabel.pipeline <span class="hljs-keyword">import</span> Pipeline, pipeline
<span class="hljs-keyword">from</span> distilabel.tasks <span class="hljs-keyword">import</span> TextGenerationTask, SelfInstructTask, Prompt

<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> haystack.nodes <span class="hljs-keyword">import</span> PDFToTextConverter, PreProcessor`,wrap:!1}}),R=new f({props:{title:"Environment variables",local:"environment-variables",headingTag:"h3"}}),N=new m({props:{code:"b3MuZW52aXJvbiU1QiUyMkhGX1RPS0VOJTIyJTVEJTIwJTNEJTIwJTIyJTIyJTBBb3MuZW52aXJvbiU1QiUyMkhGX0lORkVSRU5DRV9FTkRQT0lOVF9OQU1FJTIyJTVEJTIwJTNEJTIwJTIyYXdzLW5vdHVzLTdiLXYxLTMxODQlMjIlMEFvcy5lbnZpcm9uJTVCJTIySEZfTkFNRVNQQUNFJTIyJTVEJTIwJTNEJTIwJTIyYXJnaWxsYSUyMiUwQW9zLmVudmlyb24lNUIlMjJPUEVOQUlfQVBJX0tFWSUyMiU1RCUyMCUzRCUyMCUyMiUyMg==",highlighted:`os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;&quot;</span>
os.environ[<span class="hljs-string">&quot;HF_INFERENCE_ENDPOINT_NAME&quot;</span>] = <span class="hljs-string">&quot;aws-notus-7b-v1-3184&quot;</span>
os.environ[<span class="hljs-string">&quot;HF_NAMESPACE&quot;</span>] = <span class="hljs-string">&quot;argilla&quot;</span>
os.environ[<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>] = <span class="hljs-string">&quot;&quot;</span>`,wrap:!1}}),W=new f({props:{title:"Setting up an inference endpoint with Notus",local:"setting-up-an-inference-endpoint-with-notus",headingTag:"h2"}}),B=new f({props:{title:"Defining a custom generating task for a distilabel pipeline",local:"defining-a-custom-generating-task-for-a-distilabel-pipeline",headingTag:"h3"}}),X=new m({props:{code:"Y2xhc3MlMjBRdWVzdGlvbkFuc3dlcmluZ1Rhc2soVGV4dEdlbmVyYXRpb25UYXNrKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGdlbmVyYXRlX3Byb21wdChzZWxmJTJDJTIwcXVlc3Rpb24lM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFByb21wdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzeXN0ZW1fcHJvbXB0JTNEc2VsZi5zeXN0ZW1fcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9ybWF0dGVkX3Byb21wdCUzRHF1ZXN0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKS5mb3JtYXRfYXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGxhbWEyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyMCUyMCUyMyUyMHR5cGUlM0ElMjBpZ25vcmUlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBwYXJzZV9vdXRwdXQoc2VsZiUyQyUyMG91dHB1dCUzQSUyMHN0ciklMjAtJTNFJTIwRGljdCU1QnN0ciUyQyUyMHN0ciU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmFuc3dlciUyMiUzQSUyMG91dHB1dC5zdHJpcCgpJTdEJTBBJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjBpbnB1dF9hcmdzX25hbWVzKHNlbGYpJTIwLSUzRSUyMGxpc3QlNUJzdHIlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIlMjJxdWVzdGlvbiUyMiU1RCUwQSUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwb3V0cHV0X2FyZ3NfbmFtZXMoc2VsZiklMjAtJTNFJTIwbGlzdCU1QnN0ciU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU1QiUyMmFuc3dlciUyMiU1RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">QuestionAnsweringTask</span>(<span class="hljs-title class_ inherited__">TextGenerationTask</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_prompt</span>(<span class="hljs-params">self, question: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">return</span> Prompt(
            system_prompt=self.system_prompt,
            formatted_prompt=question,
        ).format_as(
            <span class="hljs-string">&quot;llama2&quot;</span>
        )  <span class="hljs-comment"># type: ignore</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">parse_output</span>(<span class="hljs-params">self, output: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;answer&quot;</span>: output.strip()}

<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">input_args_names</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;question&quot;</span>]

<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">output_args_names</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;answer&quot;</span>]`,wrap:!1}}),Q=new m({props:{code:"bGxtJTIwJTNEJTIwSW5mZXJlbmNlRW5kcG9pbnRzTExNKCUwQSUyMCUyMCUyMCUyMGVuZHBvaW50X25hbWVfb3JfbW9kZWxfaWQlM0Rvcy5nZXRlbnYoJTIySEZfSU5GRVJFTkNFX0VORFBPSU5UX05BTUUlMjIpJTJDJTIwJTIwJTIzJTIwdHlwZSUzQSUyMGlnbm9yZSUwQSUyMCUyMCUyMCUyMGVuZHBvaW50X25hbWVzcGFjZSUzRG9zLmdldGVudiglMjJIRl9OQU1FU1BBQ0UlMjIpJTJDJTIwJTIwJTIzJTIwdHlwZSUzQSUyMGlnbm9yZSUwQSUyMCUyMCUyMCUyMHRva2VuJTNEb3MuZ2V0ZW52KCUyMkhGX1RPS0VOJTIyKSUyMG9yJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0RRdWVzdGlvbkFuc3dlcmluZ1Rhc2soKSUyQyUwQSk=",highlighted:`llm = InferenceEndpointsLLM(
    endpoint_name_or_model_id=os.getenv(<span class="hljs-string">&quot;HF_INFERENCE_ENDPOINT_NAME&quot;</span>),  <span class="hljs-comment"># type: ignore</span>
    endpoint_namespace=os.getenv(<span class="hljs-string">&quot;HF_NAMESPACE&quot;</span>),  <span class="hljs-comment"># type: ignore</span>
    token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>) <span class="hljs-keyword">or</span> <span class="hljs-literal">None</span>,
    task=QuestionAnsweringTask(),
)`,wrap:!1}}),Y=new m({props:{code:"Z2VuZXJhdGlvbiUyMCUzRCUyMGxsbS5nZW5lcmF0ZSglNUIlN0IlMjJxdWVzdGlvbiUyMiUzQSUyMCUyMldoYXQncyUyMHRoZSUyMHNlY29uZCUyMG1vc3QlMjBwb3B1bGF0ZWQlMjBjaXR5JTIwaW4lMjBEZW5tYXJrJTNGJTIyJTdEJTVEKSUwQWdlbmVyYXRpb24lNUIwJTVEJTVCMCU1RCU1QiUyMnBhcnNlZF9vdXRwdXQlMjIlNUQlNUIlMjJhbnN3ZXIlMjIlNUQ=",highlighted:`generation = llm.generate([{<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the second most populated city in Denmark?&quot;</span>}])
generation[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;parsed_output&quot;</span>][<span class="hljs-string">&quot;answer&quot;</span>]`,wrap:!1}}),S=new f({props:{title:"Creating a RAG pipeline using Haystack for the European AI Act",local:"creating-a-rag-pipeline-using-haystack-for-the-european-ai-act",headingTag:"h2"}}),D=new f({props:{title:"Downloading the AI Act PDF",local:"downloading-the-ai-act-pdf",headingTag:"h3"}}),K=new m({props:{code:"JTI1JTI1YmFzaCUwQSUwQWlmJTIwJTVCJTIwISUyMC1mJTIwJTIyVGhlLUFJLUFjdC5wZGYlMjIlMjAlNUQlM0IlMjB0aGVuJTBBJTIwJTIwJTIwJTIwd2dldCUyMC1xJTIwaHR0cHMlM0ElMkYlMkZhcnRpZmljaWFsaW50ZWxsaWdlbmNlYWN0LmV1JTJGd3AtY29udGVudCUyRnVwbG9hZHMlMkYyMDIxJTJGMDglMkZUaGUtQUktQWN0LnBkZiUwQWZp",highlighted:`%%bash

<span class="hljs-keyword">if</span> [ ! -f <span class="hljs-string">&quot;The-AI-Act.pdf&quot;</span> ]; then
    wget -q https://artificialintelligenceact.eu/wp-content/uploads/<span class="hljs-number">2021</span>/08/The-AI-Act.pdf
fi`,wrap:!1}}),te=new m({props:{code:"JTIzJTIwVGhlJTIwY29udmVydGVyJTIwdHVybnMlMjB0aGUlMjBQREYlMjBpbnRvJTIwdGV4dCUyMHdlJTIwY2FuJTIwcHJvY2VzcyUyMGVhc2lseSUwQWNvbnZlcnRlciUyMCUzRCUyMFBERlRvVGV4dENvbnZlcnRlcihyZW1vdmVfbnVtZXJpY190YWJsZXMlM0RUcnVlJTJDJTIwdmFsaWRfbGFuZ3VhZ2VzJTNEJTVCJTIyZW4lMjIlNUQpJTBBJTBBJTIzJTIwUHJlcHJvY2Vzc2luZyUyMHBpcGVsaW5lcyUyMGNhbiUyMGhhdmUlMjBzZXZlcmFsJTIwc3RlcHMuJTBBJTIzJTIwT3VycyUyMGNsZWFuJTIwZW1wdHklMjBsaW5lcyUyQyUyMGhlYWRlciUyQyUyMGZvb3RlcnMlMjBhbmQlMjB3aGl0ZXNwYWNlcyUwQSUyMyUyMGFuZCUyMHNwbGl0JTIwdGhlJTIwdGV4dCUyMGludG8lMjAxNTAtY2hhciUyMGxvbmclMjBiYXRjaGVzJTJDJTIwcmVzcGVjdGluZyUwQSUyMyUyMHdoZXJlJTIwdGhlJTIwc2VudGVuY2VzJTIwbmF0dXJhbGx5JTIwZW5kJTIwYW5kJTIwYmVnaW4uJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwUHJlUHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMGNsZWFuX2VtcHR5X2xpbmVzJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGNsZWFuX3doaXRlc3BhY2UlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwY2xlYW5faGVhZGVyX2Zvb3RlciUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzcGxpdF9ieSUzRCUyMndvcmQlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGxpdF9sZW5ndGglM0QxNTAlMkMlMEElMjAlMjAlMjAlMjBzcGxpdF9yZXNwZWN0X3NlbnRlbmNlX2JvdW5kYXJ5JTNEVHJ1ZSUyQyUwQSklMEElMEFkb2MlMjAlM0QlMjBjb252ZXJ0ZXIuY29udmVydChmaWxlX3BhdGglM0QlMjJUaGUtQUktQWN0LnBkZiUyMiUyQyUyMG1ldGElM0ROb25lKSU1QjAlNUQlMEFkb2NzJTIwJTNEJTIwcHJlcHJvY2Vzc29yLnByb2Nlc3MoJTVCZG9jJTVEKSUwQXByaW50KGYlMjJEb2N1bWVudHMlM0ElMjAxJTVDbkJhdGNoZXMlM0ElMjAlN0JsZW4oZG9jcyklN0QlMjIp",highlighted:`<span class="hljs-comment"># The converter turns the PDF into text we can process easily</span>
converter = PDFToTextConverter(remove_numeric_tables=<span class="hljs-literal">True</span>, valid_languages=[<span class="hljs-string">&quot;en&quot;</span>])

<span class="hljs-comment"># Preprocessing pipelines can have several steps.</span>
<span class="hljs-comment"># Ours clean empty lines, header, footers and whitespaces</span>
<span class="hljs-comment"># and split the text into 150-char long batches, respecting</span>
<span class="hljs-comment"># where the sentences naturally end and begin.</span>
preprocessor = PreProcessor(
    clean_empty_lines=<span class="hljs-literal">True</span>,
    clean_whitespace=<span class="hljs-literal">True</span>,
    clean_header_footer=<span class="hljs-literal">True</span>,
    split_by=<span class="hljs-string">&quot;word&quot;</span>,
    split_length=<span class="hljs-number">150</span>,
    split_respect_sentence_boundary=<span class="hljs-literal">True</span>,
)

doc = converter.convert(file_path=<span class="hljs-string">&quot;The-AI-Act.pdf&quot;</span>, meta=<span class="hljs-literal">None</span>)[<span class="hljs-number">0</span>]
docs = preprocessor.process([doc])
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Documents: 1\\nBatches: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(docs)}</span>&quot;</span>)`,wrap:!1}}),se=new m({props:{code:"aW5wdXRzJTIwJTNEJTIwJTVCZG9jLmNvbnRlbnQlMjBmb3IlMjBkb2MlMjBpbiUyMGRvY3MlNUQlMEFpbnB1dHMlNUIwJTVEJTVCMCUzQTUwMCU1RA==",highlighted:`inputs = [doc.content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs]
inputs[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>:<span class="hljs-number">500</span>]`,wrap:!1}}),ae=new f({props:{title:"Generating instructions with SelfInstructTask",local:"generating-instructions-with-selfinstructtask",headingTag:"h2"}}),pe=new m({props:{code:"aW5zdHJ1Y3Rpb25zX2RhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJpbnB1dCUyMiUzQSUyMGlucHV0cyU1QjAlM0E1MCU1RCU3RCklMEElMEFpbnN0cnVjdGlvbnNfZGF0YXNldA==",highlighted:`instructions_dataset = Dataset.from_dict({<span class="hljs-string">&quot;input&quot;</span>: inputs[<span class="hljs-number">0</span>:<span class="hljs-number">50</span>]})

instructions_dataset`,wrap:!1}}),ue=new m({props:{code:"aW5zdHJ1Y3Rpb25zX3Rhc2slMjAlM0QlMjBTZWxmSW5zdHJ1Y3RUYXNrKCUwQSUyMCUyMCUyMCUyMGFwcGxpY2F0aW9uX2Rlc2NyaXB0aW9uJTNEJTIyQSUyMGFzc2lzdGFudCUyMHRoYXQlMjBjYW4lMjBhbnN3ZXIlMjBxdWVzdGlvbnMlMjBhYm91dCUyMHRoZSUyMEFJJTIwQWN0JTIwbWFkZSUyMGJ5JTIwdGhlJTIwRXVyb3BlYW4lMjBVbmlvbi4lMjIlMEEp",highlighted:`instructions_task = SelfInstructTask(
    application_description=<span class="hljs-string">&quot;A assistant that can answer questions about the AI Act made by the European Union.&quot;</span>
)`,wrap:!1}}),Me=new m({props:{code:"aW5zdHJ1Y3Rpb25zX2dlbmVyYXRvciUyMCUzRCUyMEluZmVyZW5jZUVuZHBvaW50c0xMTSglMEElMjAlMjAlMjAlMjBlbmRwb2ludF9uYW1lX29yX21vZGVsX2lkJTNEb3MuZ2V0ZW52KCUyMkhGX0lORkVSRU5DRV9FTkRQT0lOVF9OQU1FJTIyKSUyQyUyMCUyMCUyMyUyMHR5cGUlM0ElMjBpZ25vcmUlMEElMjAlMjAlMjAlMjBlbmRwb2ludF9uYW1lc3BhY2UlM0Rvcy5nZXRlbnYoJTIySEZfTkFNRVNQQUNFJTIyKSUyQyUyMCUyMCUyMyUyMHR5cGUlM0ElMjBpZ25vcmUlMEElMjAlMjAlMjAlMjB0b2tlbiUzRG9zLmdldGVudiglMjJIRl9UT0tFTiUyMiklMjBvciUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjB0YXNrJTNEaW5zdHJ1Y3Rpb25zX3Rhc2slMkMlMEEpJTBBJTBBaW5zdHJ1Y3Rpb25zX3BpcGVsaW5lJTIwJTNEJTIwUGlwZWxpbmUoZ2VuZXJhdG9yJTNEaW5zdHJ1Y3Rpb25zX2dlbmVyYXRvcik=",highlighted:`instructions_generator = InferenceEndpointsLLM(
    endpoint_name_or_model_id=os.getenv(<span class="hljs-string">&quot;HF_INFERENCE_ENDPOINT_NAME&quot;</span>),  <span class="hljs-comment"># type: ignore</span>
    endpoint_namespace=os.getenv(<span class="hljs-string">&quot;HF_NAMESPACE&quot;</span>),  <span class="hljs-comment"># type: ignore</span>
    token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>) <span class="hljs-keyword">or</span> <span class="hljs-literal">None</span>,
    task=instructions_task,
)

instructions_pipeline = Pipeline(generator=instructions_generator)`,wrap:!1}}),me=new m({props:{code:"Z2VuZXJhdGVkX2luc3RydWN0aW9ucyUyMCUzRCUyMGluc3RydWN0aW9uc19waXBlbGluZS5nZW5lcmF0ZShkYXRhc2V0JTNEaW5zdHJ1Y3Rpb25zX2RhdGFzZXQlMkMlMjBudW1fZ2VuZXJhdGlvbnMlM0QxJTJDJTIwYmF0Y2hfc2l6ZSUzRDgp",highlighted:'generated_instructions = instructions_pipeline.generate(dataset=instructions_dataset, num_generations=<span class="hljs-number">1</span>, batch_size=<span class="hljs-number">8</span>)',wrap:!1}}),ye=new m({props:{code:"aW5zdHJ1Y3Rpb25zJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwZ2VuZXJhdGlvbnMlMjBpbiUyMGdlbmVyYXRlZF9pbnN0cnVjdGlvbnMlNUIlMjJpbnN0cnVjdGlvbnMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBnZW5lcmF0aW9uJTIwaW4lMjBnZW5lcmF0aW9ucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluc3RydWN0aW9ucy5leHRlbmQoZ2VuZXJhdGlvbiklMEElMEFwcmludChmJTIyTnVtYmVyJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbnN0cnVjdGlvbnMlM0ElMjAlN0JsZW4oaW5zdHJ1Y3Rpb25zKSU3RCUyMiklMEElMEFmb3IlMjBpbnN0cnVjdGlvbiUyMGluJTIwaW5zdHJ1Y3Rpb25zJTVCJTNBNSU1RCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGluc3RydWN0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>instructions = []
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> generations <span class="hljs-keyword">in</span> generated_instructions[<span class="hljs-string">&quot;instructions&quot;</span>]:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> generation <span class="hljs-keyword">in</span> generations:
<span class="hljs-meta">... </span>        instructions.extend(generation)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Number of generated instructions: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(instructions)}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> instruction <span class="hljs-keyword">in</span> instructions[:<span class="hljs-number">5</span>]:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(instruction)`,wrap:!1}}),be=new f({props:{title:"Pushing the instruction dataset to Argilla to visualize and annotate.",local:"pushing-the-instruction-dataset-to-argilla-to-visualize-and-annotate",headingTag:"h3"}}),Je=new m({props:{code:"Z2VuZXJhdGVkX2luc3RydWN0aW9ucyU1QjAlNUQ=",highlighted:'generated_instructions[<span class="hljs-number">0</span>]',wrap:!1}}),Ie=new m({props:{code:"aW5zdHJ1Y3Rpb25zX3JnX2RhdGFzZXQlMjAlM0QlMjBnZW5lcmF0ZWRfaW5zdHJ1Y3Rpb25zLnRvX2FyZ2lsbGEoKSUwQWluc3RydWN0aW9uc19yZ19kYXRhc2V0JTVCMCU1RA==",highlighted:`instructions_rg_dataset = generated_instructions.to_argilla()
instructions_rg_dataset[<span class="hljs-number">0</span>]`,wrap:!1}}),ke=new m({props:{code:"aW5zdHJ1Y3Rpb25zX3JnX2RhdGFzZXQucHVzaF90b19hcmdpbGxhKG5hbWUlM0RmJTIybm90dXNfQUlfaW5zdHJ1Y3Rpb25zJTIyKQ==",highlighted:'instructions_rg_dataset.push_to_argilla(name=<span class="hljs-string">f&quot;notus_AI_instructions&quot;</span>)',wrap:!1}}),$e=new f({props:{title:"Generate a Preference Dataset using an Ultrafeedback text quality task.",local:"generate-a-preference-dataset-using-an-ultrafeedback-text-quality-task",headingTag:"h2"}}),Re=new m({props:{code:"cHJlZmVyZW5jZV9waXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnByZWZlcmVuY2UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnN0cnVjdGlvbi1mb2xsb3dpbmclMjIlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RJbmZlcmVuY2VFbmRwb2ludHNMTE0oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW5kcG9pbnRfbmFtZV9vcl9tb2RlbF9pZCUzRG9zLmdldGVudiglMjJIRl9JTkZFUkVOQ0VfRU5EUE9JTlRfTkFNRSUyMiklMkMlMjAlMjAlMjMlMjB0eXBlJTNBJTIwaWdub3JlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW5kcG9pbnRfbmFtZXNwYWNlJTNEb3MuZ2V0ZW52KCUyMkhGX05BTUVTUEFDRSUyMiUyQyUyME5vbmUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFzayUzRFRleHRHZW5lcmF0aW9uVGFzaygpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fdGhyZWFkcyUzRDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMyUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiUyQyUwQSUyMCUyMCUyMCUyMG51bV90aHJlYWRzJTNEMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyT1BFTkFJX0FQSV9LRVklMjIlMkMlMjBOb25lKSUyQyUwQSUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNEMC4wJTJDJTBBKQ==",highlighted:`preference_pipeline = pipeline(
    <span class="hljs-string">&quot;preference&quot;</span>,
    <span class="hljs-string">&quot;instruction-following&quot;</span>,
    generator=InferenceEndpointsLLM(
        endpoint_name_or_model_id=os.getenv(<span class="hljs-string">&quot;HF_INFERENCE_ENDPOINT_NAME&quot;</span>),  <span class="hljs-comment"># type: ignore</span>
        endpoint_namespace=os.getenv(<span class="hljs-string">&quot;HF_NAMESPACE&quot;</span>, <span class="hljs-literal">None</span>),
        task=TextGenerationTask(),
        max_new_tokens=<span class="hljs-number">256</span>,
        num_threads=<span class="hljs-number">2</span>,
        temperature=<span class="hljs-number">0.3</span>,
    ),
    max_new_tokens=<span class="hljs-number">256</span>,
    num_threads=<span class="hljs-number">2</span>,
    api_key=os.getenv(<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>, <span class="hljs-literal">None</span>),
    temperature=<span class="hljs-number">0.0</span>,
)`,wrap:!1}}),Ee=new m({props:{code:"cmVtb3RlX2RhdGFzZXQlMjAlM0QlMjByZy5GZWVkYmFja0RhdGFzZXQuZnJvbV9hcmdpbGxhKCUyMm5vdHVzX0FJX2luc3RydWN0aW9ucyUyMiUyQyUyMHdvcmtzcGFjZSUzRCUyMmFkbWluJTIyKSUwQWluc3RydWN0aW9uc19kYXRhc2V0JTIwJTNEJTIwcmVtb3RlX2RhdGFzZXQucHVsbChtYXhfcmVjb3JkcyUzRDEwMCklMjAlMjAlMjMlMjBnZXQlMjBmaXJzdCUyMDEwMCUyMHJlY29yZHMlMEElMEFpbnN0cnVjdGlvbnNfZGF0YXNldCUyMCUzRCUyMGluc3RydWN0aW9uc19kYXRhc2V0LmZvcm1hdF9hcyglMjJkYXRhc2V0cyUyMiklMEFpbnN0cnVjdGlvbnNfZGF0YXNldA==",highlighted:`remote_dataset = rg.FeedbackDataset.from_argilla(<span class="hljs-string">&quot;notus_AI_instructions&quot;</span>, workspace=<span class="hljs-string">&quot;admin&quot;</span>)
instructions_dataset = remote_dataset.pull(max_records=<span class="hljs-number">100</span>)  <span class="hljs-comment"># get first 100 records</span>

instructions_dataset = instructions_dataset.format_as(<span class="hljs-string">&quot;datasets&quot;</span>)
instructions_dataset`,wrap:!1}}),Ne=new m({props:{code:"aW5zdHJ1Y3Rpb25zX2RhdGFzZXQlNUIwJTVE",highlighted:'instructions_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),Ae=new m({props:{code:"aW5zdHJ1Y3Rpb25zX2RhdGFzZXQlMjAlM0QlMjBpbnN0cnVjdGlvbnNfZGF0YXNldC5yZW5hbWVfY29sdW1ucyglN0IlMjJpbnB1dCUyMiUzQSUyMCUyMmNvbnRleHQlMjIlMkMlMjAlMjJpbnN0cnVjdGlvbiUyMiUzQSUyMCUyMmlucHV0JTIyJTdEKQ==",highlighted:'instructions_dataset = instructions_dataset.rename_columns({<span class="hljs-string">&quot;input&quot;</span>: <span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;input&quot;</span>})',wrap:!1}}),xe=new m({props:{code:"cHJlZmVyZW5jZV9kYXRhc2V0JTIwJTNEJTIwcHJlZmVyZW5jZV9waXBlbGluZS5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBpbnN0cnVjdGlvbnNfZGF0YXNldCUyQyUyMCUyMCUyMyUyMHR5cGUlM0ElMjBpZ25vcmUlMEElMjAlMjAlMjAlMjBudW1fZ2VuZXJhdGlvbnMlM0QyJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMEElMjAlMjAlMjAlMjBkaXNwbGF5X3Byb2dyZXNzX2JhciUzRFRydWUlMkMlMEEp",highlighted:`preference_dataset = preference_pipeline.generate(
    instructions_dataset,  <span class="hljs-comment"># type: ignore</span>
    num_generations=<span class="hljs-number">2</span>,
    batch_size=<span class="hljs-number">8</span>,
    display_progress_bar=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),Xe=new m({props:{code:"cHJlZmVyZW5jZV9kYXRhc2V0JTVCMCU1RA==",highlighted:'preference_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),Fe=new f({props:{title:"Human Feedback with Argilla",local:"human-feedback-with-argilla",headingTag:"h2"}}),Ye=new m({props:{code:"aW1wb3J0JTIwYXJnaWxsYSUyMGFzJTIwcmclMEElMEElMjMlMjBSZXBsYWNlJTIwYXBpX3VybCUyMHdpdGglMjB0aGUlMjB1cmwlMjB0byUyMHlvdXIlMjBIRiUyMFNwYWNlcyUyMFVSTCUyMGlmJTIwdXNpbmclMjBTcGFjZXMlMEElMjMlMjBSZXBsYWNlJTIwYXBpX2tleSUyMGlmJTIweW91JTIwY29uZmlndXJlZCUyMGElMjBjdXN0b20lMjBBUEklMjBrZXklMEFyZy5pbml0KGFwaV91cmwlM0QlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBNjkwMCUyMiUyQyUyMGFwaV9rZXklM0QlMjJvd25lci5hcGlrZXklMjIlMkMlMjB3b3Jrc3BhY2UlM0QlMjJhZG1pbiUyMik=",highlighted:`<span class="hljs-keyword">import</span> argilla <span class="hljs-keyword">as</span> rg

<span class="hljs-comment"># Replace api_url with the url to your HF Spaces URL if using Spaces</span>
<span class="hljs-comment"># Replace api_key if you configured a custom API key</span>
rg.init(api_url=<span class="hljs-string">&quot;http://localhost:6900&quot;</span>, api_key=<span class="hljs-string">&quot;owner.apikey&quot;</span>, workspace=<span class="hljs-string">&quot;admin&quot;</span>)`,wrap:!1}}),Se=new m({props:{code:"JTIzJTIwVXBsb2FkaW5nJTIwdGhlJTIwUHJlZmVyZW5jZSUyMERhdGFzZXQlMEFwcmVmZXJlbmNlX3JnX2RhdGFzZXQlMjAlM0QlMjBwcmVmZXJlbmNlX2RhdGFzZXQudG9fYXJnaWxsYSgpJTBBJTBBJTIzJTIwQWRkaW5nJTIwdGhlJTIwY29udGV4dCUyMGFzJTIwYSUyMG1ldGFkYXRhJTIwcHJvcGVydHklMjBpbiUyMHRoZSUyMG5ldyUyMEZlZWRiYWNrJTIwZGF0YXNldCUyQyUyMGFzJTIwdGhpcyUwQSUyMyUyMGluZm9ybWF0aW9uJTIwd2lsbCUyMGJlJTIwdXNlZnVsJTIwbGF0ZXIuJTBBZm9yJTIwcmVjb3JkX2ZlZWRiYWNrJTJDJTIwcmVjb3JkX2h1Z2dpbmdmYWNlJTIwaW4lMjB6aXAocHJlZmVyZW5jZV9yZ19kYXRhc2V0JTJDJTIwcHJlZmVyZW5jZV9kYXRhc2V0KSUzQSUwQSUyMCUyMCUyMCUyMHJlY29yZF9mZWVkYmFjay5tZXRhZGF0YSU1QiUyMmNvbnRleHQlMjIlNUQlMjAlM0QlMjByZWNvcmRfaHVnZ2luZ2ZhY2UlNUIlMjJjb250ZXh0JTIyJTVEJTBBJTBBcHJlZmVyZW5jZV9yZ19kYXRhc2V0LnB1c2hfdG9fYXJnaWxsYShuYW1lJTNEZiUyMm5vdHVzX0FJX3ByZWZlcmVuY2UlMjIp",highlighted:`<span class="hljs-comment"># Uploading the Preference Dataset</span>
preference_rg_dataset = preference_dataset.to_argilla()

<span class="hljs-comment"># Adding the context as a metadata property in the new Feedback dataset, as this</span>
<span class="hljs-comment"># information will be useful later.</span>
<span class="hljs-keyword">for</span> record_feedback, record_huggingface <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(preference_rg_dataset, preference_dataset):
    record_feedback.metadata[<span class="hljs-string">&quot;context&quot;</span>] = record_huggingface[<span class="hljs-string">&quot;context&quot;</span>]

preference_rg_dataset.push_to_argilla(name=<span class="hljs-string">f&quot;notus_AI_preference&quot;</span>)`,wrap:!1}}),De=new f({props:{title:"Conclusions",local:"conclusions",headingTag:"h2"}}),{c(){y=i("meta"),nt=l(),et=i("p"),st=l(),r(w.$$.fragment),lt=l(),r(g.$$.fragment),at=l(),b=i("p"),b.innerHTML=Fn,it=l(),T=i("p"),T.textContent=Qn,ot=l(),J=i("p"),J.innerHTML=zn,pt=l(),j=i("p"),j.innerHTML=Yn,rt=l(),U=i("p"),U.innerHTML=qn,ct=l(),I=i("p"),I.textContent=Sn,ut=l(),k=i("ul"),k.innerHTML=Ln,dt=l(),r(C.$$.fragment),Mt=l(),v=i("p"),v.innerHTML=Pn,ht=l(),r($.$$.fragment),mt=l(),r(Z.$$.fragment),ft=l(),_=i("p"),_.innerHTML=Dn,yt=l(),r(G.$$.fragment),wt=l(),r(R.$$.fragment),gt=l(),V=i("p"),V.innerHTML=On,bt=l(),E=i("p"),E.innerHTML=Kn,Tt=l(),r(N.$$.fragment),Jt=l(),r(W.$$.fragment),jt=l(),A=i("p"),A.innerHTML=es,Ut=l(),r(B.$$.fragment),It=l(),x=i("p"),x.innerHTML=ts,kt=l(),H=i("p"),H.innerHTML=ns,Ct=l(),r(X.$$.fragment),vt=l(),F=i("p"),F.innerHTML=ss,$t=l(),r(Q.$$.fragment),Zt=l(),z=i("p"),z.innerHTML=ls,_t=l(),r(Y.$$.fragment),Gt=l(),q=i("p"),q.innerHTML=as,Rt=l(),r(S.$$.fragment),Vt=l(),L=i("p"),L.textContent=is,Et=l(),P=i("p"),P.innerHTML=os,Nt=l(),r(D.$$.fragment),Wt=l(),O=i("p"),O.textContent=ps,At=l(),r(K.$$.fragment),Bt=l(),ee=i("p"),ee.textContent=rs,xt=l(),r(te.$$.fragment),Ht=l(),ne=i("p"),ne.textContent=cs,Xt=l(),r(se.$$.fragment),Ft=l(),le=i("p"),le.innerHTML=us,Qt=l(),r(ae.$$.fragment),zt=l(),ie=i("p"),ie.textContent=ds,Yt=l(),oe=i("p"),oe.textContent=Ms,qt=l(),r(pe.$$.fragment),St=l(),re=i("p"),re.innerHTML=hs,Lt=l(),ce=i("p"),ce.textContent=ms,Pt=l(),r(ue.$$.fragment),Dt=l(),de=i("p"),de.innerHTML=fs,Ot=l(),r(Me.$$.fragment),Kt=l(),he=i("p"),he.textContent=ys,en=l(),r(me.$$.fragment),tn=l(),fe=i("p"),fe.textContent=ws,nn=l(),r(ye.$$.fragment),sn=l(),we=i("pre"),we.textContent=gs,ln=l(),ge=i("p"),ge.textContent=bs,an=l(),r(be.$$.fragment),on=l(),Te=i("p"),Te.innerHTML=Ts,pn=l(),r(Je.$$.fragment),rn=l(),je=i("p"),je.textContent=Js,cn=l(),Ue=i("p"),Ue.textContent=js,un=l(),r(Ie.$$.fragment),dn=l(),r(ke.$$.fragment),Mn=l(),Ce=i("p"),Ce.textContent=Us,hn=l(),ve=i("p"),ve.innerHTML=Is,mn=l(),r($e.$$.fragment),fn=l(),Ze=i("p"),Ze.textContent=ks,yn=l(),_e=i("p"),_e.innerHTML=Cs,wn=l(),Ge=i("blockquote"),Ge.innerHTML=vs,gn=l(),r(Re.$$.fragment),bn=l(),Ve=i("p"),Ve.textContent=$s,Tn=l(),r(Ee.$$.fragment),Jn=l(),r(Ne.$$.fragment),jn=l(),We=i("p"),We.textContent=Zs,Un=l(),r(Ae.$$.fragment),In=l(),Be=i("p"),Be.textContent=_s,kn=l(),r(xe.$$.fragment),Cn=l(),He=i("p"),He.textContent=Gs,vn=l(),r(Xe.$$.fragment),$n=l(),r(Fe.$$.fragment),Zn=l(),Qe=i("p"),Qe.innerHTML=Rs,_n=l(),ze=i("p"),ze.textContent=Vs,Gn=l(),r(Ye.$$.fragment),Rn=l(),qe=i("p"),qe.textContent=Es,Vn=l(),r(Se.$$.fragment),En=l(),Le=i("p"),Le.textContent=Ns,Nn=l(),Pe=i("p"),Pe.innerHTML=Ws,Wn=l(),r(De.$$.fragment),An=l(),Oe=i("p"),Oe.textContent=As,Bn=l(),Ke=i("ul"),Ke.innerHTML=Bs,xn=l(),tt=i("p"),this.h()},l(e){const t=qs("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(n),nt=a(e),et=o(e,"P",{}),xs(et).forEach(n),st=a(e),c(w.$$.fragment,e),lt=a(e),c(g.$$.fragment,e),at=a(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-gisfdz"&&(b.innerHTML=Fn),it=a(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-mqma1d"&&(T.textContent=Qn),ot=a(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-yea2ux"&&(J.innerHTML=zn),pt=a(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-17mb955"&&(j.innerHTML=Yn),rt=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-11aljr5"&&(U.innerHTML=qn),ct=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-19b4mku"&&(I.textContent=Sn),ut=a(e),k=o(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-13d75gm"&&(k.innerHTML=Ln),dt=a(e),c(C.$$.fragment,e),Mt=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1ryr4ij"&&(v.innerHTML=Pn),ht=a(e),c($.$$.fragment,e),mt=a(e),c(Z.$$.fragment,e),ft=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1erg8tk"&&(_.innerHTML=Dn),yt=a(e),c(G.$$.fragment,e),wt=a(e),c(R.$$.fragment,e),gt=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1a5bpoh"&&(V.innerHTML=On),bt=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1nivs9h"&&(E.innerHTML=Kn),Tt=a(e),c(N.$$.fragment,e),Jt=a(e),c(W.$$.fragment,e),jt=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1hffalf"&&(A.innerHTML=es),Ut=a(e),c(B.$$.fragment,e),It=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-rfp9xd"&&(x.innerHTML=ts),kt=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1765knx"&&(H.innerHTML=ns),Ct=a(e),c(X.$$.fragment,e),vt=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1ptkxnm"&&(F.innerHTML=ss),$t=a(e),c(Q.$$.fragment,e),Zt=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1hne08h"&&(z.innerHTML=ls),_t=a(e),c(Y.$$.fragment,e),Gt=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-tlkol7"&&(q.innerHTML=as),Rt=a(e),c(S.$$.fragment,e),Vt=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-gabva0"&&(L.textContent=is),Et=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1lw2gw2"&&(P.innerHTML=os),Nt=a(e),c(D.$$.fragment,e),Wt=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1mdkzao"&&(O.textContent=ps),At=a(e),c(K.$$.fragment,e),Bt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-8mbdvf"&&(ee.textContent=rs),xt=a(e),c(te.$$.fragment,e),Ht=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1dv9t7i"&&(ne.textContent=cs),Xt=a(e),c(se.$$.fragment,e),Ft=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1an99na"&&(le.innerHTML=us),Qt=a(e),c(ae.$$.fragment,e),zt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1lvdv6q"&&(ie.textContent=ds),Yt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1m9r1yp"&&(oe.textContent=Ms),qt=a(e),c(pe.$$.fragment,e),St=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-djnimz"&&(re.innerHTML=hs),Lt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-18v6qga"&&(ce.textContent=ms),Pt=a(e),c(ue.$$.fragment,e),Dt=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-5revu1"&&(de.innerHTML=fs),Ot=a(e),c(Me.$$.fragment,e),Kt=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1ifebmj"&&(he.textContent=ys),en=a(e),c(me.$$.fragment,e),tn=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-2126i5"&&(fe.textContent=ws),nn=a(e),c(ye.$$.fragment,e),sn=a(e),we=o(e,"PRE",{"data-svelte-h":!0}),p(we)!=="svelte-4uqjoq"&&(we.textContent=gs),ln=a(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-ia76xw"&&(ge.textContent=bs),an=a(e),c(be.$$.fragment,e),on=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-171069i"&&(Te.innerHTML=Ts),pn=a(e),c(Je.$$.fragment,e),rn=a(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1vrlcaw"&&(je.textContent=Js),cn=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1fcqwou"&&(Ue.textContent=js),un=a(e),c(Ie.$$.fragment,e),dn=a(e),c(ke.$$.fragment,e),Mn=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-103dp5e"&&(Ce.textContent=Us),hn=a(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-itxog8"&&(ve.innerHTML=Is),mn=a(e),c($e.$$.fragment,e),fn=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-lsw5va"&&(Ze.textContent=ks),yn=a(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-xgzptg"&&(_e.innerHTML=Cs),wn=a(e),Ge=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(Ge)!=="svelte-ifombh"&&(Ge.innerHTML=vs),gn=a(e),c(Re.$$.fragment,e),bn=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1ori6ky"&&(Ve.textContent=$s),Tn=a(e),c(Ee.$$.fragment,e),Jn=a(e),c(Ne.$$.fragment,e),jn=a(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1j5x0o"&&(We.textContent=Zs),Un=a(e),c(Ae.$$.fragment,e),In=a(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-15xtit4"&&(Be.textContent=_s),kn=a(e),c(xe.$$.fragment,e),Cn=a(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-1h1vx0c"&&(He.textContent=Gs),vn=a(e),c(Xe.$$.fragment,e),$n=a(e),c(Fe.$$.fragment,e),Zn=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-8dm5d1"&&(Qe.innerHTML=Rs),_n=a(e),ze=o(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-eb5mcf"&&(ze.textContent=Vs),Gn=a(e),c(Ye.$$.fragment,e),Rn=a(e),qe=o(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-56jh0q"&&(qe.textContent=Es),Vn=a(e),c(Se.$$.fragment,e),En=a(e),Le=o(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1qohgpc"&&(Le.textContent=Ns),Nn=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1isjfj4"&&(Pe.innerHTML=Ws),Wn=a(e),c(De.$$.fragment,e),An=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-aphsx"&&(Oe.textContent=As),Bn=a(e),Ke=o(e,"UL",{"data-svelte-h":!0}),p(Ke)!=="svelte-1db0aq6"&&(Ke.innerHTML=Bs),xn=a(e),tt=o(e,"P",{}),xs(tt).forEach(n),this.h()},h(){Hs(y,"name","hf:doc:metadata"),Hs(y,"content",Ds)},m(e,t){Ss(document.head,y),s(e,nt,t),s(e,et,t),s(e,st,t),u(w,e,t),s(e,lt,t),u(g,e,t),s(e,at,t),s(e,b,t),s(e,it,t),s(e,T,t),s(e,ot,t),s(e,J,t),s(e,pt,t),s(e,j,t),s(e,rt,t),s(e,U,t),s(e,ct,t),s(e,I,t),s(e,ut,t),s(e,k,t),s(e,dt,t),u(C,e,t),s(e,Mt,t),s(e,v,t),s(e,ht,t),u($,e,t),s(e,mt,t),u(Z,e,t),s(e,ft,t),s(e,_,t),s(e,yt,t),u(G,e,t),s(e,wt,t),u(R,e,t),s(e,gt,t),s(e,V,t),s(e,bt,t),s(e,E,t),s(e,Tt,t),u(N,e,t),s(e,Jt,t),u(W,e,t),s(e,jt,t),s(e,A,t),s(e,Ut,t),u(B,e,t),s(e,It,t),s(e,x,t),s(e,kt,t),s(e,H,t),s(e,Ct,t),u(X,e,t),s(e,vt,t),s(e,F,t),s(e,$t,t),u(Q,e,t),s(e,Zt,t),s(e,z,t),s(e,_t,t),u(Y,e,t),s(e,Gt,t),s(e,q,t),s(e,Rt,t),u(S,e,t),s(e,Vt,t),s(e,L,t),s(e,Et,t),s(e,P,t),s(e,Nt,t),u(D,e,t),s(e,Wt,t),s(e,O,t),s(e,At,t),u(K,e,t),s(e,Bt,t),s(e,ee,t),s(e,xt,t),u(te,e,t),s(e,Ht,t),s(e,ne,t),s(e,Xt,t),u(se,e,t),s(e,Ft,t),s(e,le,t),s(e,Qt,t),u(ae,e,t),s(e,zt,t),s(e,ie,t),s(e,Yt,t),s(e,oe,t),s(e,qt,t),u(pe,e,t),s(e,St,t),s(e,re,t),s(e,Lt,t),s(e,ce,t),s(e,Pt,t),u(ue,e,t),s(e,Dt,t),s(e,de,t),s(e,Ot,t),u(Me,e,t),s(e,Kt,t),s(e,he,t),s(e,en,t),u(me,e,t),s(e,tn,t),s(e,fe,t),s(e,nn,t),u(ye,e,t),s(e,sn,t),s(e,we,t),s(e,ln,t),s(e,ge,t),s(e,an,t),u(be,e,t),s(e,on,t),s(e,Te,t),s(e,pn,t),u(Je,e,t),s(e,rn,t),s(e,je,t),s(e,cn,t),s(e,Ue,t),s(e,un,t),u(Ie,e,t),s(e,dn,t),u(ke,e,t),s(e,Mn,t),s(e,Ce,t),s(e,hn,t),s(e,ve,t),s(e,mn,t),u($e,e,t),s(e,fn,t),s(e,Ze,t),s(e,yn,t),s(e,_e,t),s(e,wn,t),s(e,Ge,t),s(e,gn,t),u(Re,e,t),s(e,bn,t),s(e,Ve,t),s(e,Tn,t),u(Ee,e,t),s(e,Jn,t),u(Ne,e,t),s(e,jn,t),s(e,We,t),s(e,Un,t),u(Ae,e,t),s(e,In,t),s(e,Be,t),s(e,kn,t),u(xe,e,t),s(e,Cn,t),s(e,He,t),s(e,vn,t),u(Xe,e,t),s(e,$n,t),u(Fe,e,t),s(e,Zn,t),s(e,Qe,t),s(e,_n,t),s(e,ze,t),s(e,Gn,t),u(Ye,e,t),s(e,Rn,t),s(e,qe,t),s(e,Vn,t),u(Se,e,t),s(e,En,t),s(e,Le,t),s(e,Nn,t),s(e,Pe,t),s(e,Wn,t),u(De,e,t),s(e,An,t),s(e,Oe,t),s(e,Bn,t),s(e,Ke,t),s(e,xn,t),s(e,tt,t),Hn=!0},p:Fs,i(e){Hn||(d(w.$$.fragment,e),d(g.$$.fragment,e),d(C.$$.fragment,e),d($.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(R.$$.fragment,e),d(N.$$.fragment,e),d(W.$$.fragment,e),d(B.$$.fragment,e),d(X.$$.fragment,e),d(Q.$$.fragment,e),d(Y.$$.fragment,e),d(S.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(pe.$$.fragment,e),d(ue.$$.fragment,e),d(Me.$$.fragment,e),d(me.$$.fragment,e),d(ye.$$.fragment,e),d(be.$$.fragment,e),d(Je.$$.fragment,e),d(Ie.$$.fragment,e),d(ke.$$.fragment,e),d($e.$$.fragment,e),d(Re.$$.fragment,e),d(Ee.$$.fragment,e),d(Ne.$$.fragment,e),d(Ae.$$.fragment,e),d(xe.$$.fragment,e),d(Xe.$$.fragment,e),d(Fe.$$.fragment,e),d(Ye.$$.fragment,e),d(Se.$$.fragment,e),d(De.$$.fragment,e),Hn=!0)},o(e){M(w.$$.fragment,e),M(g.$$.fragment,e),M(C.$$.fragment,e),M($.$$.fragment,e),M(Z.$$.fragment,e),M(G.$$.fragment,e),M(R.$$.fragment,e),M(N.$$.fragment,e),M(W.$$.fragment,e),M(B.$$.fragment,e),M(X.$$.fragment,e),M(Q.$$.fragment,e),M(Y.$$.fragment,e),M(S.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(te.$$.fragment,e),M(se.$$.fragment,e),M(ae.$$.fragment,e),M(pe.$$.fragment,e),M(ue.$$.fragment,e),M(Me.$$.fragment,e),M(me.$$.fragment,e),M(ye.$$.fragment,e),M(be.$$.fragment,e),M(Je.$$.fragment,e),M(Ie.$$.fragment,e),M(ke.$$.fragment,e),M($e.$$.fragment,e),M(Re.$$.fragment,e),M(Ee.$$.fragment,e),M(Ne.$$.fragment,e),M(Ae.$$.fragment,e),M(xe.$$.fragment,e),M(Xe.$$.fragment,e),M(Fe.$$.fragment,e),M(Ye.$$.fragment,e),M(Se.$$.fragment,e),M(De.$$.fragment,e),Hn=!1},d(e){e&&(n(nt),n(et),n(st),n(lt),n(at),n(b),n(it),n(T),n(ot),n(J),n(pt),n(j),n(rt),n(U),n(ct),n(I),n(ut),n(k),n(dt),n(Mt),n(v),n(ht),n(mt),n(ft),n(_),n(yt),n(wt),n(gt),n(V),n(bt),n(E),n(Tt),n(Jt),n(jt),n(A),n(Ut),n(It),n(x),n(kt),n(H),n(Ct),n(vt),n(F),n($t),n(Zt),n(z),n(_t),n(Gt),n(q),n(Rt),n(Vt),n(L),n(Et),n(P),n(Nt),n(Wt),n(O),n(At),n(Bt),n(ee),n(xt),n(Ht),n(ne),n(Xt),n(Ft),n(le),n(Qt),n(zt),n(ie),n(Yt),n(oe),n(qt),n(St),n(re),n(Lt),n(ce),n(Pt),n(Dt),n(de),n(Ot),n(Kt),n(he),n(en),n(tn),n(fe),n(nn),n(sn),n(we),n(ln),n(ge),n(an),n(on),n(Te),n(pn),n(rn),n(je),n(cn),n(Ue),n(un),n(dn),n(Mn),n(Ce),n(hn),n(ve),n(mn),n(fn),n(Ze),n(yn),n(_e),n(wn),n(Ge),n(gn),n(bn),n(Ve),n(Tn),n(Jn),n(jn),n(We),n(Un),n(In),n(Be),n(kn),n(Cn),n(He),n(vn),n($n),n(Zn),n(Qe),n(_n),n(ze),n(Gn),n(Rn),n(qe),n(Vn),n(En),n(Le),n(Nn),n(Pe),n(Wn),n(An),n(Oe),n(Bn),n(Ke),n(xn),n(tt)),n(y),h(w,e),h(g,e),h(C,e),h($,e),h(Z,e),h(G,e),h(R,e),h(N,e),h(W,e),h(B,e),h(X,e),h(Q,e),h(Y,e),h(S,e),h(D,e),h(K,e),h(te,e),h(se,e),h(ae,e),h(pe,e),h(ue,e),h(Me,e),h(me,e),h(ye,e),h(be,e),h(Je,e),h(Ie,e),h(ke,e),h($e,e),h(Re,e),h(Ee,e),h(Ne,e),h(Ae,e),h(xe,e),h(Xe,e),h(Fe,e),h(Ye,e),h(Se,e),h(De,e)}}}const Ds='{"title":"⚖️ Create a legal preference dataset","local":"-create-a-legal-preference-dataset","sections":[{"title":"Introduction","local":"introduction","sections":[{"title":"Import dependencies","local":"import-dependencies","sections":[],"depth":3},{"title":"Environment variables","local":"environment-variables","sections":[],"depth":3}],"depth":2},{"title":"Setting up an inference endpoint with Notus","local":"setting-up-an-inference-endpoint-with-notus","sections":[{"title":"Defining a custom generating task for a distilabel pipeline","local":"defining-a-custom-generating-task-for-a-distilabel-pipeline","sections":[],"depth":3}],"depth":2},{"title":"Creating a RAG pipeline using Haystack for the European AI Act","local":"creating-a-rag-pipeline-using-haystack-for-the-european-ai-act","sections":[{"title":"Downloading the AI Act PDF","local":"downloading-the-ai-act-pdf","sections":[],"depth":3}],"depth":2},{"title":"Generating instructions with SelfInstructTask","local":"generating-instructions-with-selfinstructtask","sections":[{"title":"Pushing the instruction dataset to Argilla to visualize and annotate.","local":"pushing-the-instruction-dataset-to-argilla-to-visualize-and-annotate","sections":[],"depth":3}],"depth":2},{"title":"Generate a Preference Dataset using an Ultrafeedback text quality task.","local":"generate-a-preference-dataset-using-an-ultrafeedback-text-quality-task","sections":[],"depth":2},{"title":"Human Feedback with Argilla","local":"human-feedback-with-argilla","sections":[],"depth":2},{"title":"Conclusions","local":"conclusions","sections":[],"depth":2}],"depth":1}';function Os(Xn){return Qs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sl extends zs{constructor(y){super(),Ys(this,y,Os,Ps,Xs,{})}}export{sl as component};
