import{s as Cn,o as kn,n as ut}from"../chunks/scheduler.9bc65507.js";import{S as wn,i as Mn,g as c,s as r,r as p,A as Fn,h as l,f as o,c as s,j as S,u as f,x as b,k,y as i,a,v as h,d as u,t as g,w as _}from"../chunks/index.707bf1b6.js";import{D as Z}from"../chunks/Docstring.570ddb64.js";import{C as I}from"../chunks/CodeBlock.54a9f38d.js";import{E as ht}from"../chunks/ExampleCodeBlock.bc2be6bc.js";import{H as z,E as Sn}from"../chunks/EditOnGithub.922df6ba.js";function $n(U){let d,C="Example:",v,m,y;return m=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZhc3RTcGVlY2gyQ29uZm9ybWVyTW9kZWwlMkMlMjBGYXN0U3BlZWNoMkNvbmZvcm1lckNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBGYXN0U3BlZWNoMkNvbmZvcm1lciUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBGYXN0U3BlZWNoMkNvbmZvcm1lckNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMEZhc3RTcGVlY2gyQ29uZm9ybWVyJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBGYXN0U3BlZWNoMkNvbmZvcm1lck1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FastSpeech2ConformerModel, FastSpeech2ConformerConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a FastSpeech2Conformer style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = FastSpeech2ConformerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the FastSpeech2Conformer style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FastSpeech2ConformerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){d=c("p"),d.textContent=C,v=r(),p(m.$$.fragment)},l(n){d=l(n,"P",{"data-svelte-h":!0}),b(d)!=="svelte-11lpom8"&&(d.textContent=C),v=s(n),f(m.$$.fragment,n)},m(n,T){a(n,d,T),a(n,v,T),h(m,n,T),y=!0},p:ut,i(n){y||(u(m.$$.fragment,n),y=!0)},o(n){g(m.$$.fragment,n),y=!1},d(n){n&&(o(d),o(v)),_(m,n)}}}function xn(U){let d,C="Example:",v,m,y;return m=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZhc3RTcGVlY2gyQ29uZm9ybWVySGlmaUdhbiUyQyUyMEZhc3RTcGVlY2gyQ29uZm9ybWVySGlmaUdhbkNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBGYXN0U3BlZWNoMkNvbmZvcm1lckhpZmlHYW4lMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMEZhc3RTcGVlY2gyQ29uZm9ybWVySGlmaUdhbkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBGYXN0U3BlZWNoMkNvbmZvcm1lckhpZmlHYW4oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FastSpeech2ConformerHifiGan, FastSpeech2ConformerHifiGanConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a FastSpeech2ConformerHifiGan configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = FastSpeech2ConformerHifiGanConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FastSpeech2ConformerHifiGan(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){d=c("p"),d.textContent=C,v=r(),p(m.$$.fragment)},l(n){d=l(n,"P",{"data-svelte-h":!0}),b(d)!=="svelte-11lpom8"&&(d.textContent=C),v=s(n),f(m.$$.fragment,n)},m(n,T){a(n,d,T),a(n,v,T),h(m,n,T),y=!0},p:ut,i(n){y||(u(m.$$.fragment,n),y=!0)},o(n){g(m.$$.fragment,n),y=!1},d(n){n&&(o(d),o(v)),_(m,n)}}}function Zn(U){let d,C="Example:",v,m,y;return m=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBGYXN0U3BlZWNoMkNvbmZvcm1lckNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMEZhc3RTcGVlY2gyQ29uZm9ybWVySGlmaUdhbkNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMEZhc3RTcGVlY2gyQ29uZm9ybWVyV2l0aEhpZmlHYW5Db25maWclMkMlMEElMjAlMjAlMjAlMjBGYXN0U3BlZWNoMkNvbmZvcm1lcldpdGhIaWZpR2FuJTJDJTBBKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMEZhc3RTcGVlY2gyQ29uZm9ybWVyV2l0aEhpZmlHYW4lMjBzdWItbW9kdWxlcyUyMGNvbmZpZ3VyYXRpb25zLiUwQW1vZGVsX2NvbmZpZyUyMCUzRCUyMEZhc3RTcGVlY2gyQ29uZm9ybWVyQ29uZmlnKCklMEF2b2NvZGVyX2NvbmZpZyUyMCUzRCUyMEZhc3RTcGVlY2gyQ29uZm9ybWVySGlmaUdhbkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEZhc3RTcGVlY2gyQ29uZm9ybWVyV2l0aEhpZmlHYW4lMjBtb2R1bGUlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwRmFzdFNwZWVjaDJDb25mb3JtZXJXaXRoSGlmaUdhbkNvbmZpZyhtb2RlbF9jb25maWcudG9fZGljdCgpJTJDJTIwdm9jb2Rlcl9jb25maWcudG9fZGljdCgpKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMEFtb2RlbCUyMCUzRCUyMEZhc3RTcGVlY2gyQ29uZm9ybWVyV2l0aEhpZmlHYW4oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    FastSpeech2ConformerConfig,
<span class="hljs-meta">... </span>    FastSpeech2ConformerHifiGanConfig,
<span class="hljs-meta">... </span>    FastSpeech2ConformerWithHifiGanConfig,
<span class="hljs-meta">... </span>    FastSpeech2ConformerWithHifiGan,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing FastSpeech2ConformerWithHifiGan sub-modules configurations.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_config = FastSpeech2ConformerConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>vocoder_config = FastSpeech2ConformerHifiGanConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a FastSpeech2ConformerWithHifiGan module style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = FastSpeech2ConformerWithHifiGanConfig(model_config.to_dict(), vocoder_config.to_dict())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FastSpeech2ConformerWithHifiGan(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){d=c("p"),d.textContent=C,v=r(),p(m.$$.fragment)},l(n){d=l(n,"P",{"data-svelte-h":!0}),b(d)!=="svelte-11lpom8"&&(d.textContent=C),v=s(n),f(m.$$.fragment,n)},m(n,T){a(n,d,T),a(n,v,T),h(m,n,T),y=!0},p:ut,i(n){y||(u(m.$$.fragment,n),y=!0)},o(n){g(m.$$.fragment,n),y=!1},d(n){n&&(o(d),o(v)),_(m,n)}}}function zn(U){let d,C="Example:",v,m,y;return m=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBGYXN0U3BlZWNoMkNvbmZvcm1lclRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMEZhc3RTcGVlY2gyQ29uZm9ybWVyTW9kZWwlMkMlMEElMjAlMjAlMjAlMjBGYXN0U3BlZWNoMkNvbmZvcm1lckhpZmlHYW4lMkMlMEEpJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwRmFzdFNwZWVjaDJDb25mb3JtZXJUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmVzcG5ldCUyRmZhc3RzcGVlY2gyX2NvbmZvcm1lciUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyc29tZSUyMHRleHQlMjB0byUyMGNvbnZlcnQlMjB0byUyMHNwZWVjaCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfaWRzJTIwJTNEJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBbW9kZWwlMjAlM0QlMjBGYXN0U3BlZWNoMkNvbmZvcm1lck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJlc3BuZXQlMkZmYXN0c3BlZWNoMl9jb25mb3JtZXIlMjIpJTBBb3V0cHV0X2RpY3QlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlMkMlMjByZXR1cm5fZGljdCUzRFRydWUpJTBBc3BlY3Ryb2dyYW0lMjAlM0QlMjBvdXRwdXRfZGljdCU1QiUyMnNwZWN0cm9ncmFtJTIyJTVEJTBBJTBBdm9jb2RlciUyMCUzRCUyMEZhc3RTcGVlY2gyQ29uZm9ybWVySGlmaUdhbi5mcm9tX3ByZXRyYWluZWQoJTIyZXNwbmV0JTJGZmFzdHNwZWVjaDJfY29uZm9ybWVyX2hpZmlnYW4lMjIpJTBBd2F2ZWZvcm0lMjAlM0QlMjB2b2NvZGVyKHNwZWN0cm9ncmFtKSUwQXByaW50KHdhdmVmb3JtLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    FastSpeech2ConformerTokenizer,
<span class="hljs-meta">... </span>    FastSpeech2ConformerModel,
<span class="hljs-meta">... </span>    FastSpeech2ConformerHifiGan,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = FastSpeech2ConformerTokenizer.from_pretrained(<span class="hljs-string">&quot;espnet/fastspeech2_conformer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;some text to convert to speech&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>model = FastSpeech2ConformerModel.from_pretrained(<span class="hljs-string">&quot;espnet/fastspeech2_conformer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_dict = model(input_ids, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>spectrogram = output_dict[<span class="hljs-string">&quot;spectrogram&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>vocoder = FastSpeech2ConformerHifiGan.from_pretrained(<span class="hljs-string">&quot;espnet/fastspeech2_conformer_hifigan&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>waveform = vocoder(spectrogram)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(waveform.shape)
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">49664</span>])`,wrap:!1}}),{c(){d=c("p"),d.textContent=C,v=r(),p(m.$$.fragment)},l(n){d=l(n,"P",{"data-svelte-h":!0}),b(d)!=="svelte-11lpom8"&&(d.textContent=C),v=s(n),f(m.$$.fragment,n)},m(n,T){a(n,d,T),a(n,v,T),h(m,n,T),y=!0},p:ut,i(n){y||(u(m.$$.fragment,n),y=!0)},o(n){g(m.$$.fragment,n),y=!1},d(n){n&&(o(d),o(v)),_(m,n)}}}function Wn(U){let d,C="Example:",v,m,y;return m=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBGYXN0U3BlZWNoMkNvbmZvcm1lclRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMEZhc3RTcGVlY2gyQ29uZm9ybWVyV2l0aEhpZmlHYW4lMkMlMEEpJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwRmFzdFNwZWVjaDJDb25mb3JtZXJUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmVzcG5ldCUyRmZhc3RzcGVlY2gyX2NvbmZvcm1lciUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyc29tZSUyMHRleHQlMjB0byUyMGNvbnZlcnQlMjB0byUyMHNwZWVjaCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfaWRzJTIwJTNEJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBbW9kZWwlMjAlM0QlMjBGYXN0U3BlZWNoMkNvbmZvcm1lcldpdGhIaWZpR2FuLmZyb21fcHJldHJhaW5lZCglMjJlc3BuZXQlMkZmYXN0c3BlZWNoMl9jb25mb3JtZXJfd2l0aF9oaWZpZ2FuJTIyKSUwQW91dHB1dF9kaWN0JTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTJDJTIwcmV0dXJuX2RpY3QlM0RUcnVlKSUwQXdhdmVmb3JtJTIwJTNEJTIwb3V0cHV0X2RpY3QlNUIlMjJ3YXZlZm9ybSUyMiU1RCUwQXByaW50KHdhdmVmb3JtLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    FastSpeech2ConformerTokenizer,
<span class="hljs-meta">... </span>    FastSpeech2ConformerWithHifiGan,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = FastSpeech2ConformerTokenizer.from_pretrained(<span class="hljs-string">&quot;espnet/fastspeech2_conformer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;some text to convert to speech&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>model = FastSpeech2ConformerWithHifiGan.from_pretrained(<span class="hljs-string">&quot;espnet/fastspeech2_conformer_with_hifigan&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_dict = model(input_ids, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>waveform = output_dict[<span class="hljs-string">&quot;waveform&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(waveform.shape)
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">49664</span>])`,wrap:!1}}),{c(){d=c("p"),d.textContent=C,v=r(),p(m.$$.fragment)},l(n){d=l(n,"P",{"data-svelte-h":!0}),b(d)!=="svelte-11lpom8"&&(d.textContent=C),v=s(n),f(m.$$.fragment,n)},m(n,T){a(n,d,T),a(n,v,T),h(m,n,T),y=!0},p:ut,i(n){y||(u(m.$$.fragment,n),y=!0)},o(n){g(m.$$.fragment,n),y=!1},d(n){n&&(o(d),o(v)),_(m,n)}}}function jn(U){let d,C,v,m,y,n,T,gt,ne,Io='The FastSpeech2Conformer model was proposed with the paper <a href="https://arxiv.org/abs/2010.13956" rel="nofollow">Recent Developments On Espnet Toolkit Boosted By Conformer</a> by Pengcheng Guo, Florian Boyer, Xuankai Chang, Tomoki Hayashi, Yosuke Higuchi, Hirofumi Inaguma, Naoyuki Kamo, Chenda Li, Daniel Garcia-Romero, Jiatong Shi, Jing Shi, Shinji Watanabe, Kun Wei, Wangyou Zhang, and Yuekai Zhang.',_t,re,Vo="The abstract from the original FastSpeech2 paper is the following:",bt,se,qo='<em>Non-autoregressive text to speech (TTS) models such as FastSpeech (Ren et al., 2019) can synthesize speech significantly faster than previous autoregressive models with comparable quality. The training of FastSpeech model relies on an autoregressive teacher model for duration prediction (to provide more information as input) and knowledge distillation (to simplify the data distribution in output), which can ease the one-to-many mapping problem (i.e., multiple speech variations correspond to the same text) in TTS. However, FastSpeech has several disadvantages: 1) the teacher-student distillation pipeline is complicated and time-consuming, 2) the duration extracted from the teacher model is not accurate enough, and the target mel-spectrograms distilled from teacher model suffer from information loss due to data simplification, both of which limit the voice quality. In this paper, we propose FastSpeech 2, which addresses the issues in FastSpeech and better solves the one-to-many mapping problem in TTS by 1) directly training the model with ground-truth target instead of the simplified output from teacher, and 2) introducing more variation information of speech (e.g., pitch, energy and more accurate duration) as conditional inputs. Specifically, we extract duration, pitch and energy from speech waveform and directly take them as conditional inputs in training and use predicted values in inference. We further design FastSpeech 2s, which is the first attempt to directly generate speech waveform from text in parallel, enjoying the benefit of fully end-to-end inference. Experimental results show that 1) FastSpeech 2 achieves a 3x training speed-up over FastSpeech, and FastSpeech 2s enjoys even faster inference speed; 2) FastSpeech 2 and 2s outperform FastSpeech in voice quality, and FastSpeech 2 can even surpass autoregressive models. Audio samples are available at <a href="https://speechresearch.github.io/fastspeech2/" rel="nofollow">https://speechresearch.github.io/fastspeech2/</a>.</em>',yt,ae,Ro='This model was contributed by <a href="https://huggingface.co/connor-henderson" rel="nofollow">Connor Henderson</a>. The original code can be found <a href="https://github.com/espnet/espnet/blob/master/espnet2/tts/fastspeech2/fastspeech2.py" rel="nofollow">here</a>.',vt,ie,Tt,ce,Xo="FastSpeech2’s general structure with a Mel-spectrogram decoder was implemented, and the traditional transformer blocks were replaced with conformer blocks as done in the ESPnet library.",Ct,le,kt,de,Eo='<img src="https://www.microsoft.com/en-us/research/uploads/prod/2021/04/fastspeech2-1.png" alt="FastSpeech2 Model Architecture"/>',wt,me,Mt,pe,Lo='<img src="https://www.researchgate.net/profile/Hirofumi-Inaguma-2/publication/344911155/figure/fig2/AS:951455406108673@1603856054097/An-overview-of-Conformer-block.png" alt="Conformer Blocks"/>',Ft,fe,St,he,Yo='<img src="https://d3i71xaburhd42.cloudfront.net/8809d0732f6147d4ad9218c8f9b20227c837a746/2-Figure1-1.png" alt="Convolution Module"/>',$t,ue,xt,ge,Qo="You can run FastSpeech2Conformer locally with the 🤗 Transformers library.",Zt,_e,Po='<li>First install the 🤗 <a href="https://github.com/huggingface/transformers" rel="nofollow">Transformers library</a>, g2p-en:</li>',zt,be,Wt,V,Do="<li>Run inference via the Transformers modelling code with the model and hifigan separately</li>",jt,ye,Jt,q,Ao="<li>Run inference via the Transformers modelling code with the model and hifigan combined</li>",Gt,ve,Ut,R,Oo="<li>Run inference with a pipeline and specify which vocoder to use</li>",Nt,Te,Ht,Ce,Bt,W,ke,ao,Ee,Ko=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerModel">FastSpeech2ConformerModel</a>. It is used to
instantiate a FastSpeech2Conformer model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the
FastSpeech2Conformer <a href="https://huggingface.co/espnet/fastspeech2_conformer" rel="nofollow">espnet/fastspeech2_conformer</a>
architecture.`,io,Le,en=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,co,X,It,we,Vt,j,Me,lo,Ye,tn=`This is the configuration class to store the configuration of a <code>FastSpeech2ConformerHifiGanModel</code>. It is used to
instantiate a FastSpeech2Conformer HiFi-GAN vocoder model according to the specified arguments, defining the model
architecture. Instantiating a configuration with the defaults will yield a similar configuration to that of the
FastSpeech2Conformer
<a href="https://huggingface.co/espnet/fastspeech2_conformer_hifigan" rel="nofollow">espnet/fastspeech2_conformer_hifigan</a> architecture.`,mo,Qe,on=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,po,E,qt,Fe,Rt,w,Se,fo,Pe,nn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerWithHifiGan">FastSpeech2ConformerWithHifiGan</a>. It is used to
instantiate a <code>FastSpeech2ConformerWithHifiGanModel</code> model according to the specified sub-models configurations,
defining the model architecture.`,ho,De,rn=`Instantiating a configuration with the defaults will yield a similar configuration to that of the
FastSpeech2ConformerModel <a href="https://huggingface.co/espnet/fastspeech2_conformer" rel="nofollow">espnet/fastspeech2_conformer</a> and
FastSpeech2ConformerHifiGan
<a href="https://huggingface.co/espnet/fastspeech2_conformer_hifigan" rel="nofollow">espnet/fastspeech2_conformer_hifigan</a> architectures.`,uo,Ae,sn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,go,Oe,an=`model_config (<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerConfig">FastSpeech2ConformerConfig</a>, <em>optional</em>):
Configuration of the text-to-speech model.
vocoder_config (<code>FastSpeech2ConformerHiFiGanConfig</code>, <em>optional</em>):
Configuration of the vocoder model.`,_o,L,Xt,$e,Et,M,xe,bo,Ke,cn="Construct a FastSpeech2Conformer tokenizer.",yo,Y,Ze,vo,et,ln=`Main method to tokenize and prepare for the model one or several sequence(s) or one or several pair(s) of
sequences.`,To,Q,ze,Co,tt,dn="Save the vocabulary and special tokens file to a directory.",ko,ot,We,wo,P,je,Mo,nt,mn="Convert a list of lists of token ids into a list of strings by calling decode.",Lt,Je,Yt,F,Ge,Fo,rt,pn=`FastSpeech2Conformer Model.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,So,st,fn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,$o,at,hn="FastSpeech 2 module.",xo,it,un=`This is a module of FastSpeech 2 described in ‘FastSpeech 2: Fast and High-Quality End-to-End Text to Speech’
<a href="https://arxiv.org/abs/2006.04558" rel="nofollow">https://arxiv.org/abs/2006.04558</a>. Instead of quantized pitch and energy, we use token-averaged value introduced in
FastPitch: Parallel Text-to-speech with Pitch Prediction. The encoder and decoder are Conformers instead of regular
Transformers.`,Zo,D,Ue,zo,A,Qt,Ne,Pt,J,He,Wo,ct,gn=`HiFi-GAN vocoder.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,jo,lt,_n=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Jo,O,Be,Go,dt,bn=`Converts a log-mel spectrogram into a speech waveform. Passing a batch of log-mel spectrograms returns a batch
of speech waveforms. Passing a single, un-batched log-mel spectrogram returns a single, un-batched speech
waveform.`,Dt,Ie,At,G,Ve,Uo,mt,yn=`The FastSpeech2ConformerModel with a FastSpeech2ConformerHifiGan vocoder head that performs text-to-speech (waveform).
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,No,pt,vn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ho,K,qe,Bo,ee,Ot,Re,Kt,ft,eo;return y=new z({props:{title:"FastSpeech2Conformer",local:"fastspeech2conformer",headingTag:"h1"}}),T=new z({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ie=new z({props:{title:"🤗 Model Architecture",local:"-model-architecture",headingTag:"h2"}}),le=new z({props:{title:"FastSpeech2 Model Architecture",local:"fastspeech2-model-architecture",headingTag:"h4"}}),me=new z({props:{title:"Conformer Blocks",local:"conformer-blocks",headingTag:"h4"}}),fe=new z({props:{title:"Convolution Module",local:"convolution-module",headingTag:"h4"}}),ue=new z({props:{title:"🤗 Transformers Usage",local:"-transformers-usage",headingTag:"h2"}}),be=new I({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHBpcCUwQXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjB0cmFuc2Zvcm1lcnMlMjBnMnAtZW4=",highlighted:`pip install --upgrade pip
pip install --upgrade transformers g2p-en`,wrap:!1}}),ye=new I({props:{code:"JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZhc3RTcGVlY2gyQ29uZm9ybWVyVG9rZW5pemVyJTJDJTIwRmFzdFNwZWVjaDJDb25mb3JtZXJNb2RlbCUyQyUyMEZhc3RTcGVlY2gyQ29uZm9ybWVySGlmaUdhbiUwQWltcG9ydCUyMHNvdW5kZmlsZSUyMGFzJTIwc2YlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBGYXN0U3BlZWNoMkNvbmZvcm1lclRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZXNwbmV0JTJGZmFzdHNwZWVjaDJfY29uZm9ybWVyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfaWRzJTIwJTNEJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBbW9kZWwlMjAlM0QlMjBGYXN0U3BlZWNoMkNvbmZvcm1lck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJlc3BuZXQlMkZmYXN0c3BlZWNoMl9jb25mb3JtZXIlMjIpJTBBb3V0cHV0X2RpY3QlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlMkMlMjByZXR1cm5fZGljdCUzRFRydWUpJTBBc3BlY3Ryb2dyYW0lMjAlM0QlMjBvdXRwdXRfZGljdCU1QiUyMnNwZWN0cm9ncmFtJTIyJTVEJTBBJTBBaGlmaWdhbiUyMCUzRCUyMEZhc3RTcGVlY2gyQ29uZm9ybWVySGlmaUdhbi5mcm9tX3ByZXRyYWluZWQoJTIyZXNwbmV0JTJGZmFzdHNwZWVjaDJfY29uZm9ybWVyX2hpZmlnYW4lMjIpJTBBd2F2ZWZvcm0lMjAlM0QlMjBoaWZpZ2FuKHNwZWN0cm9ncmFtKSUwQSUwQXNmLndyaXRlKCUyMnNwZWVjaC53YXYlMjIlMkMlMjB3YXZlZm9ybS5zcXVlZXplKCkuZGV0YWNoKCkubnVtcHkoKSUyQyUyMHNhbXBsZXJhdGUlM0QyMjA1MCk=",highlighted:`
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FastSpeech2ConformerTokenizer, FastSpeech2ConformerModel, FastSpeech2ConformerHifiGan
<span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

tokenizer = FastSpeech2ConformerTokenizer.from_pretrained(<span class="hljs-string">&quot;espnet/fastspeech2_conformer&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
input_ids = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>]

model = FastSpeech2ConformerModel.from_pretrained(<span class="hljs-string">&quot;espnet/fastspeech2_conformer&quot;</span>)
output_dict = model(input_ids, return_dict=<span class="hljs-literal">True</span>)
spectrogram = output_dict[<span class="hljs-string">&quot;spectrogram&quot;</span>]

hifigan = FastSpeech2ConformerHifiGan.from_pretrained(<span class="hljs-string">&quot;espnet/fastspeech2_conformer_hifigan&quot;</span>)
waveform = hifigan(spectrogram)

sf.write(<span class="hljs-string">&quot;speech.wav&quot;</span>, waveform.squeeze().detach().numpy(), samplerate=<span class="hljs-number">22050</span>)`,wrap:!1}}),ve=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZhc3RTcGVlY2gyQ29uZm9ybWVyVG9rZW5pemVyJTJDJTIwRmFzdFNwZWVjaDJDb25mb3JtZXJXaXRoSGlmaUdhbiUwQWltcG9ydCUyMHNvdW5kZmlsZSUyMGFzJTIwc2YlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBGYXN0U3BlZWNoMkNvbmZvcm1lclRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZXNwbmV0JTJGZmFzdHNwZWVjaDJfY29uZm9ybWVyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfaWRzJTIwJTNEJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBbW9kZWwlMjAlM0QlMjBGYXN0U3BlZWNoMkNvbmZvcm1lcldpdGhIaWZpR2FuLmZyb21fcHJldHJhaW5lZCglMjJlc3BuZXQlMkZmYXN0c3BlZWNoMl9jb25mb3JtZXJfd2l0aF9oaWZpZ2FuJTIyKSUwQW91dHB1dF9kaWN0JTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTJDJTIwcmV0dXJuX2RpY3QlM0RUcnVlKSUwQXdhdmVmb3JtJTIwJTNEJTIwb3V0cHV0X2RpY3QlNUIlMjJ3YXZlZm9ybSUyMiU1RCUwQSUwQXNmLndyaXRlKCUyMnNwZWVjaC53YXYlMjIlMkMlMjB3YXZlZm9ybS5zcXVlZXplKCkuZGV0YWNoKCkubnVtcHkoKSUyQyUyMHNhbXBsZXJhdGUlM0QyMjA1MCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FastSpeech2ConformerTokenizer, FastSpeech2ConformerWithHifiGan
<span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

tokenizer = FastSpeech2ConformerTokenizer.from_pretrained(<span class="hljs-string">&quot;espnet/fastspeech2_conformer&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
input_ids = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>]

model = FastSpeech2ConformerWithHifiGan.from_pretrained(<span class="hljs-string">&quot;espnet/fastspeech2_conformer_with_hifigan&quot;</span>)
output_dict = model(input_ids, return_dict=<span class="hljs-literal">True</span>)
waveform = output_dict[<span class="hljs-string">&quot;waveform&quot;</span>]

sf.write(<span class="hljs-string">&quot;speech.wav&quot;</span>, waveform.squeeze().detach().numpy(), samplerate=<span class="hljs-number">22050</span>)`,wrap:!1}}),Te=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTJDJTIwRmFzdFNwZWVjaDJDb25mb3JtZXJIaWZpR2FuJTBBaW1wb3J0JTIwc291bmRmaWxlJTIwYXMlMjBzZiUwQSUwQXZvY29kZXIlMjAlM0QlMjBGYXN0U3BlZWNoMkNvbmZvcm1lckhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMmVzcG5ldCUyRmZhc3RzcGVlY2gyX2NvbmZvcm1lcl9oaWZpZ2FuJTIyKSUwQXN5bnRoZXNpc2VyJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJlc3BuZXQlMkZmYXN0c3BlZWNoMl9jb25mb3JtZXIlMjIlMkMlMjB2b2NvZGVyJTNEdm9jb2RlciklMEElMEFzcGVlY2glMjAlM0QlMjBzeW50aGVzaXNlciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjb29sZXIlMjB0aGFuJTIweW91ISUyMiklMEElMEFzZi53cml0ZSglMjJzcGVlY2gud2F2JTIyJTJDJTIwc3BlZWNoJTVCJTIyYXVkaW8lMjIlNUQuc3F1ZWV6ZSgpJTJDJTIwc2FtcGxlcmF0ZSUzRHNwZWVjaCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline, FastSpeech2ConformerHifiGan
<span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

vocoder = FastSpeech2ConformerHifiGan.from_pretrained(<span class="hljs-string">&quot;espnet/fastspeech2_conformer_hifigan&quot;</span>)
synthesiser = pipeline(model=<span class="hljs-string">&quot;espnet/fastspeech2_conformer&quot;</span>, vocoder=vocoder)

speech = synthesiser(<span class="hljs-string">&quot;Hello, my dog is cooler than you!&quot;</span>)

sf.write(<span class="hljs-string">&quot;speech.wav&quot;</span>, speech[<span class="hljs-string">&quot;audio&quot;</span>].squeeze(), samplerate=speech[<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),Ce=new z({props:{title:"FastSpeech2ConformerConfig",local:"transformers.FastSpeech2ConformerConfig",headingTag:"h2"}}),ke=new Z({props:{name:"class transformers.FastSpeech2ConformerConfig",anchor:"transformers.FastSpeech2ConformerConfig",parameters:[{name:"hidden_size",val:" = 384"},{name:"vocab_size",val:" = 78"},{name:"num_mel_bins",val:" = 80"},{name:"encoder_num_attention_heads",val:" = 2"},{name:"encoder_layers",val:" = 4"},{name:"encoder_linear_units",val:" = 1536"},{name:"decoder_layers",val:" = 4"},{name:"decoder_num_attention_heads",val:" = 2"},{name:"decoder_linear_units",val:" = 1536"},{name:"speech_decoder_postnet_layers",val:" = 5"},{name:"speech_decoder_postnet_units",val:" = 256"},{name:"speech_decoder_postnet_kernel",val:" = 5"},{name:"positionwise_conv_kernel_size",val:" = 3"},{name:"encoder_normalize_before",val:" = False"},{name:"decoder_normalize_before",val:" = False"},{name:"encoder_concat_after",val:" = False"},{name:"decoder_concat_after",val:" = False"},{name:"reduction_factor",val:" = 1"},{name:"speaking_speed",val:" = 1.0"},{name:"use_macaron_style_in_conformer",val:" = True"},{name:"use_cnn_in_conformer",val:" = True"},{name:"encoder_kernel_size",val:" = 7"},{name:"decoder_kernel_size",val:" = 31"},{name:"duration_predictor_layers",val:" = 2"},{name:"duration_predictor_channels",val:" = 256"},{name:"duration_predictor_kernel_size",val:" = 3"},{name:"energy_predictor_layers",val:" = 2"},{name:"energy_predictor_channels",val:" = 256"},{name:"energy_predictor_kernel_size",val:" = 3"},{name:"energy_predictor_dropout",val:" = 0.5"},{name:"energy_embed_kernel_size",val:" = 1"},{name:"energy_embed_dropout",val:" = 0.0"},{name:"stop_gradient_from_energy_predictor",val:" = False"},{name:"pitch_predictor_layers",val:" = 5"},{name:"pitch_predictor_channels",val:" = 256"},{name:"pitch_predictor_kernel_size",val:" = 5"},{name:"pitch_predictor_dropout",val:" = 0.5"},{name:"pitch_embed_kernel_size",val:" = 1"},{name:"pitch_embed_dropout",val:" = 0.0"},{name:"stop_gradient_from_pitch_predictor",val:" = True"},{name:"encoder_dropout_rate",val:" = 0.2"},{name:"encoder_positional_dropout_rate",val:" = 0.2"},{name:"encoder_attention_dropout_rate",val:" = 0.2"},{name:"decoder_dropout_rate",val:" = 0.2"},{name:"decoder_positional_dropout_rate",val:" = 0.2"},{name:"decoder_attention_dropout_rate",val:" = 0.2"},{name:"duration_predictor_dropout_rate",val:" = 0.2"},{name:"speech_decoder_postnet_dropout",val:" = 0.5"},{name:"max_source_positions",val:" = 5000"},{name:"use_masking",val:" = True"},{name:"use_weighted_masking",val:" = False"},{name:"num_speakers",val:" = None"},{name:"num_languages",val:" = None"},{name:"speaker_embed_dim",val:" = None"},{name:"is_encoder_decoder",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FastSpeech2ConformerConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The dimensionality of the hidden layers.`,name:"hidden_size"},{anchor:"transformers.FastSpeech2ConformerConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 78) &#x2014;
The size of the vocabulary.`,name:"vocab_size"},{anchor:"transformers.FastSpeech2ConformerConfig.num_mel_bins",description:`<strong>num_mel_bins</strong> (<code>int</code>, <em>optional</em>, defaults to 80) &#x2014;
The number of mel filters used in the filter bank.`,name:"num_mel_bins"},{anchor:"transformers.FastSpeech2ConformerConfig.encoder_num_attention_heads",description:`<strong>encoder_num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The number of attention heads in the encoder.`,name:"encoder_num_attention_heads"},{anchor:"transformers.FastSpeech2ConformerConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of layers in the encoder.`,name:"encoder_layers"},{anchor:"transformers.FastSpeech2ConformerConfig.encoder_linear_units",description:`<strong>encoder_linear_units</strong> (<code>int</code>, <em>optional</em>, defaults to 1536) &#x2014;
The number of units in the linear layer of the encoder.`,name:"encoder_linear_units"},{anchor:"transformers.FastSpeech2ConformerConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of layers in the decoder.`,name:"decoder_layers"},{anchor:"transformers.FastSpeech2ConformerConfig.decoder_num_attention_heads",description:`<strong>decoder_num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The number of attention heads in the decoder.`,name:"decoder_num_attention_heads"},{anchor:"transformers.FastSpeech2ConformerConfig.decoder_linear_units",description:`<strong>decoder_linear_units</strong> (<code>int</code>, <em>optional</em>, defaults to 1536) &#x2014;
The number of units in the linear layer of the decoder.`,name:"decoder_linear_units"},{anchor:"transformers.FastSpeech2ConformerConfig.speech_decoder_postnet_layers",description:`<strong>speech_decoder_postnet_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
The number of layers in the post-net of the speech decoder.`,name:"speech_decoder_postnet_layers"},{anchor:"transformers.FastSpeech2ConformerConfig.speech_decoder_postnet_units",description:`<strong>speech_decoder_postnet_units</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of units in the post-net layers of the speech decoder.`,name:"speech_decoder_postnet_units"},{anchor:"transformers.FastSpeech2ConformerConfig.speech_decoder_postnet_kernel",description:`<strong>speech_decoder_postnet_kernel</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
The kernel size in the post-net of the speech decoder.`,name:"speech_decoder_postnet_kernel"},{anchor:"transformers.FastSpeech2ConformerConfig.positionwise_conv_kernel_size",description:`<strong>positionwise_conv_kernel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The size of the convolution kernel used in the position-wise layer.`,name:"positionwise_conv_kernel_size"},{anchor:"transformers.FastSpeech2ConformerConfig.encoder_normalize_before",description:`<strong>encoder_normalize_before</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Specifies whether to normalize before encoder layers.`,name:"encoder_normalize_before"},{anchor:"transformers.FastSpeech2ConformerConfig.decoder_normalize_before",description:`<strong>decoder_normalize_before</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Specifies whether to normalize before decoder layers.`,name:"decoder_normalize_before"},{anchor:"transformers.FastSpeech2ConformerConfig.encoder_concat_after",description:`<strong>encoder_concat_after</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Specifies whether to concatenate after encoder layers.`,name:"encoder_concat_after"},{anchor:"transformers.FastSpeech2ConformerConfig.decoder_concat_after",description:`<strong>decoder_concat_after</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Specifies whether to concatenate after decoder layers.`,name:"decoder_concat_after"},{anchor:"transformers.FastSpeech2ConformerConfig.reduction_factor",description:`<strong>reduction_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The factor by which the speech frame rate is reduced.`,name:"reduction_factor"},{anchor:"transformers.FastSpeech2ConformerConfig.speaking_speed",description:`<strong>speaking_speed</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The speed of the speech produced.`,name:"speaking_speed"},{anchor:"transformers.FastSpeech2ConformerConfig.use_macaron_style_in_conformer",description:`<strong>use_macaron_style_in_conformer</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Specifies whether to use macaron style in the conformer.`,name:"use_macaron_style_in_conformer"},{anchor:"transformers.FastSpeech2ConformerConfig.use_cnn_in_conformer",description:`<strong>use_cnn_in_conformer</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Specifies whether to use convolutional neural networks in the conformer.`,name:"use_cnn_in_conformer"},{anchor:"transformers.FastSpeech2ConformerConfig.encoder_kernel_size",description:`<strong>encoder_kernel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 7) &#x2014;
The kernel size used in the encoder.`,name:"encoder_kernel_size"},{anchor:"transformers.FastSpeech2ConformerConfig.decoder_kernel_size",description:`<strong>decoder_kernel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 31) &#x2014;
The kernel size used in the decoder.`,name:"decoder_kernel_size"},{anchor:"transformers.FastSpeech2ConformerConfig.duration_predictor_layers",description:`<strong>duration_predictor_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The number of layers in the duration predictor.`,name:"duration_predictor_layers"},{anchor:"transformers.FastSpeech2ConformerConfig.duration_predictor_channels",description:`<strong>duration_predictor_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of channels in the duration predictor.`,name:"duration_predictor_channels"},{anchor:"transformers.FastSpeech2ConformerConfig.duration_predictor_kernel_size",description:`<strong>duration_predictor_kernel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The kernel size used in the duration predictor.`,name:"duration_predictor_kernel_size"},{anchor:"transformers.FastSpeech2ConformerConfig.energy_predictor_layers",description:`<strong>energy_predictor_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The number of layers in the energy predictor.`,name:"energy_predictor_layers"},{anchor:"transformers.FastSpeech2ConformerConfig.energy_predictor_channels",description:`<strong>energy_predictor_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of channels in the energy predictor.`,name:"energy_predictor_channels"},{anchor:"transformers.FastSpeech2ConformerConfig.energy_predictor_kernel_size",description:`<strong>energy_predictor_kernel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The kernel size used in the energy predictor.`,name:"energy_predictor_kernel_size"},{anchor:"transformers.FastSpeech2ConformerConfig.energy_predictor_dropout",description:`<strong>energy_predictor_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The dropout rate in the energy predictor.`,name:"energy_predictor_dropout"},{anchor:"transformers.FastSpeech2ConformerConfig.energy_embed_kernel_size",description:`<strong>energy_embed_kernel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The kernel size used in the energy embed layer.`,name:"energy_embed_kernel_size"},{anchor:"transformers.FastSpeech2ConformerConfig.energy_embed_dropout",description:`<strong>energy_embed_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout rate in the energy embed layer.`,name:"energy_embed_dropout"},{anchor:"transformers.FastSpeech2ConformerConfig.stop_gradient_from_energy_predictor",description:`<strong>stop_gradient_from_energy_predictor</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Specifies whether to stop gradients from the energy predictor.`,name:"stop_gradient_from_energy_predictor"},{anchor:"transformers.FastSpeech2ConformerConfig.pitch_predictor_layers",description:`<strong>pitch_predictor_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
The number of layers in the pitch predictor.`,name:"pitch_predictor_layers"},{anchor:"transformers.FastSpeech2ConformerConfig.pitch_predictor_channels",description:`<strong>pitch_predictor_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of channels in the pitch predictor.`,name:"pitch_predictor_channels"},{anchor:"transformers.FastSpeech2ConformerConfig.pitch_predictor_kernel_size",description:`<strong>pitch_predictor_kernel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
The kernel size used in the pitch predictor.`,name:"pitch_predictor_kernel_size"},{anchor:"transformers.FastSpeech2ConformerConfig.pitch_predictor_dropout",description:`<strong>pitch_predictor_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The dropout rate in the pitch predictor.`,name:"pitch_predictor_dropout"},{anchor:"transformers.FastSpeech2ConformerConfig.pitch_embed_kernel_size",description:`<strong>pitch_embed_kernel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The kernel size used in the pitch embed layer.`,name:"pitch_embed_kernel_size"},{anchor:"transformers.FastSpeech2ConformerConfig.pitch_embed_dropout",description:`<strong>pitch_embed_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout rate in the pitch embed layer.`,name:"pitch_embed_dropout"},{anchor:"transformers.FastSpeech2ConformerConfig.stop_gradient_from_pitch_predictor",description:`<strong>stop_gradient_from_pitch_predictor</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Specifies whether to stop gradients from the pitch predictor.`,name:"stop_gradient_from_pitch_predictor"},{anchor:"transformers.FastSpeech2ConformerConfig.encoder_dropout_rate",description:`<strong>encoder_dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.2) &#x2014;
The dropout rate in the encoder.`,name:"encoder_dropout_rate"},{anchor:"transformers.FastSpeech2ConformerConfig.encoder_positional_dropout_rate",description:`<strong>encoder_positional_dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.2) &#x2014;
The positional dropout rate in the encoder.`,name:"encoder_positional_dropout_rate"},{anchor:"transformers.FastSpeech2ConformerConfig.encoder_attention_dropout_rate",description:`<strong>encoder_attention_dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.2) &#x2014;
The attention dropout rate in the encoder.`,name:"encoder_attention_dropout_rate"},{anchor:"transformers.FastSpeech2ConformerConfig.decoder_dropout_rate",description:`<strong>decoder_dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.2) &#x2014;
The dropout rate in the decoder.`,name:"decoder_dropout_rate"},{anchor:"transformers.FastSpeech2ConformerConfig.decoder_positional_dropout_rate",description:`<strong>decoder_positional_dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.2) &#x2014;
The positional dropout rate in the decoder.`,name:"decoder_positional_dropout_rate"},{anchor:"transformers.FastSpeech2ConformerConfig.decoder_attention_dropout_rate",description:`<strong>decoder_attention_dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.2) &#x2014;
The attention dropout rate in the decoder.`,name:"decoder_attention_dropout_rate"},{anchor:"transformers.FastSpeech2ConformerConfig.duration_predictor_dropout_rate",description:`<strong>duration_predictor_dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.2) &#x2014;
The dropout rate in the duration predictor.`,name:"duration_predictor_dropout_rate"},{anchor:"transformers.FastSpeech2ConformerConfig.speech_decoder_postnet_dropout",description:`<strong>speech_decoder_postnet_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The dropout rate in the speech decoder postnet.`,name:"speech_decoder_postnet_dropout"},{anchor:"transformers.FastSpeech2ConformerConfig.max_source_positions",description:`<strong>max_source_positions</strong> (<code>int</code>, <em>optional</em>, defaults to 5000) &#x2014;
if <code>&quot;relative&quot;</code> position embeddings are used, defines the maximum source input positions.`,name:"max_source_positions"},{anchor:"transformers.FastSpeech2ConformerConfig.use_masking",description:`<strong>use_masking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Specifies whether to use masking in the model.`,name:"use_masking"},{anchor:"transformers.FastSpeech2ConformerConfig.use_weighted_masking",description:`<strong>use_weighted_masking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Specifies whether to use weighted masking in the model.`,name:"use_weighted_masking"},{anchor:"transformers.FastSpeech2ConformerConfig.num_speakers",description:`<strong>num_speakers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of speakers. If set to &gt; 1, assume that the speaker ids will be provided as the input and use
speaker id embedding layer.`,name:"num_speakers"},{anchor:"transformers.FastSpeech2ConformerConfig.num_languages",description:`<strong>num_languages</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of languages. If set to &gt; 1, assume that the language ids will be provided as the input and use the
languge id embedding layer.`,name:"num_languages"},{anchor:"transformers.FastSpeech2ConformerConfig.speaker_embed_dim",description:`<strong>speaker_embed_dim</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Speaker embedding dimension. If set to &gt; 0, assume that speaker_embedding will be provided as the input.`,name:"speaker_embed_dim"},{anchor:"transformers.FastSpeech2ConformerConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Specifies whether the model is an encoder-decoder.`,name:"is_encoder_decoder"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fastspeech2_conformer/configuration_fastspeech2_conformer.py#L33"}}),X=new ht({props:{anchor:"transformers.FastSpeech2ConformerConfig.example",$$slots:{default:[$n]},$$scope:{ctx:U}}}),we=new z({props:{title:"FastSpeech2ConformerHifiGanConfig",local:"transformers.FastSpeech2ConformerHifiGanConfig",headingTag:"h2"}}),Me=new Z({props:{name:"class transformers.FastSpeech2ConformerHifiGanConfig",anchor:"transformers.FastSpeech2ConformerHifiGanConfig",parameters:[{name:"model_in_dim",val:" = 80"},{name:"upsample_initial_channel",val:" = 512"},{name:"upsample_rates",val:" = [8, 8, 2, 2]"},{name:"upsample_kernel_sizes",val:" = [16, 16, 4, 4]"},{name:"resblock_kernel_sizes",val:" = [3, 7, 11]"},{name:"resblock_dilation_sizes",val:" = [[1, 3, 5], [1, 3, 5], [1, 3, 5]]"},{name:"initializer_range",val:" = 0.01"},{name:"leaky_relu_slope",val:" = 0.1"},{name:"normalize_before",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FastSpeech2ConformerHifiGanConfig.model_in_dim",description:`<strong>model_in_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 80) &#x2014;
The number of frequency bins in the input log-mel spectrogram.`,name:"model_in_dim"},{anchor:"transformers.FastSpeech2ConformerHifiGanConfig.upsample_initial_channel",description:`<strong>upsample_initial_channel</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The number of input channels into the upsampling network.`,name:"upsample_initial_channel"},{anchor:"transformers.FastSpeech2ConformerHifiGanConfig.upsample_rates",description:`<strong>upsample_rates</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>[8, 8, 2, 2]</code>) &#x2014;
A tuple of integers defining the stride of each 1D convolutional layer in the upsampling network. The
length of <em>upsample_rates</em> defines the number of convolutional layers and has to match the length of
<em>upsample_kernel_sizes</em>.`,name:"upsample_rates"},{anchor:"transformers.FastSpeech2ConformerHifiGanConfig.upsample_kernel_sizes",description:`<strong>upsample_kernel_sizes</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>[16, 16, 4, 4]</code>) &#x2014;
A tuple of integers defining the kernel size of each 1D convolutional layer in the upsampling network. The
length of <em>upsample_kernel_sizes</em> defines the number of convolutional layers and has to match the length of
<em>upsample_rates</em>.`,name:"upsample_kernel_sizes"},{anchor:"transformers.FastSpeech2ConformerHifiGanConfig.resblock_kernel_sizes",description:`<strong>resblock_kernel_sizes</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 7, 11]</code>) &#x2014;
A tuple of integers defining the kernel sizes of the 1D convolutional layers in the multi-receptive field
fusion (MRF) module.`,name:"resblock_kernel_sizes"},{anchor:"transformers.FastSpeech2ConformerHifiGanConfig.resblock_dilation_sizes",description:`<strong>resblock_dilation_sizes</strong> (<code>Tuple[Tuple[int]]</code> or <code>List[List[int]]</code>, <em>optional</em>, defaults to <code>[[1, 3, 5], [1, 3, 5], [1, 3, 5]]</code>) &#x2014;
A nested tuple of integers defining the dilation rates of the dilated 1D convolutional layers in the
multi-receptive field fusion (MRF) module.`,name:"resblock_dilation_sizes"},{anchor:"transformers.FastSpeech2ConformerHifiGanConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.01) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.FastSpeech2ConformerHifiGanConfig.leaky_relu_slope",description:`<strong>leaky_relu_slope</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The angle of the negative slope used by the leaky ReLU activation.`,name:"leaky_relu_slope"},{anchor:"transformers.FastSpeech2ConformerHifiGanConfig.normalize_before",description:`<strong>normalize_before</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the spectrogram before vocoding using the vocoder&#x2019;s learned mean and variance.`,name:"normalize_before"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fastspeech2_conformer/configuration_fastspeech2_conformer.py#L334"}}),E=new ht({props:{anchor:"transformers.FastSpeech2ConformerHifiGanConfig.example",$$slots:{default:[xn]},$$scope:{ctx:U}}}),Fe=new z({props:{title:"FastSpeech2ConformerWithHifiGanConfig",local:"transformers.FastSpeech2ConformerWithHifiGanConfig",headingTag:"h2"}}),Se=new Z({props:{name:"class transformers.FastSpeech2ConformerWithHifiGanConfig",anchor:"transformers.FastSpeech2ConformerWithHifiGanConfig",parameters:[{name:"model_config",val:": Dict = None"},{name:"vocoder_config",val:": Dict = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FastSpeech2ConformerWithHifiGanConfig.model_config",description:`<strong>model_config</strong> (<code>typing.Dict</code>, <em>optional</em>) &#x2014;
Configuration of the text-to-speech model.`,name:"model_config"},{anchor:"transformers.FastSpeech2ConformerWithHifiGanConfig.vocoder_config",description:`<strong>vocoder_config</strong> (<code>typing.Dict</code>, <em>optional</em>) &#x2014;
Configuration of the vocoder model.`,name:"vocoder_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fastspeech2_conformer/configuration_fastspeech2_conformer.py#L413"}}),L=new ht({props:{anchor:"transformers.FastSpeech2ConformerWithHifiGanConfig.example",$$slots:{default:[Zn]},$$scope:{ctx:U}}}),$e=new z({props:{title:"FastSpeech2ConformerTokenizer",local:"transformers.FastSpeech2ConformerTokenizer",headingTag:"h2"}}),xe=new Z({props:{name:"class transformers.FastSpeech2ConformerTokenizer",anchor:"transformers.FastSpeech2ConformerTokenizer",parameters:[{name:"vocab_file",val:""},{name:"bos_token",val:" = '<sos/eos>'"},{name:"eos_token",val:" = '<sos/eos>'"},{name:"pad_token",val:" = '<blank>'"},{name:"unk_token",val:" = '<unk>'"},{name:"should_strip_spaces",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FastSpeech2ConformerTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.FastSpeech2ConformerTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;sos/eos&gt;&quot;</code>) &#x2014;
The begin of sequence token. Note that for FastSpeech2, it is the same as the <code>eos_token</code>.`,name:"bos_token"},{anchor:"transformers.FastSpeech2ConformerTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;sos/eos&gt;&quot;</code>) &#x2014;
The end of sequence token. Note that for FastSpeech2, it is the same as the <code>bos_token</code>.`,name:"eos_token"},{anchor:"transformers.FastSpeech2ConformerTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;blank&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.FastSpeech2ConformerTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.FastSpeech2ConformerTokenizer.should_strip_spaces",description:`<strong>should_strip_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to strip the spaces from the list of tokens.`,name:"should_strip_spaces"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fastspeech2_conformer/tokenization_fastspeech2_conformer.py#L31"}}),Ze=new Z({props:{name:"__call__",anchor:"transformers.FastSpeech2ConformerTokenizer.__call__",parameters:[{name:"text",val:": Union = None"},{name:"text_pair",val:": Union = None"},{name:"text_target",val:": Union = None"},{name:"text_pair_target",val:": Union = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": Union = False"},{name:"truncation",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"stride",val:": int = 0"},{name:"is_split_into_words",val:": bool = False"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"return_token_type_ids",val:": Optional = None"},{name:"return_attention_mask",val:": Optional = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.text_pair",description:`<strong>text_pair</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.text_target",description:`<strong>text_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_target"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.text_pair_target",description:`<strong>text_pair_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair_target"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add special tokens when encoding the sequences. This will use the underlying
<code>PretrainedTokenizerBase.build_inputs_with_special_tokens</code> function, which defines which tokens are
automatically added to the input ids. This is usefull if you want to add <code>bos</code> or <code>eos</code> tokens
automatically.`,name:"add_special_tokens"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. Requires <code>padding</code> to be activated.
This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.return_token_type_ids",description:`<strong>return_token_type_ids</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return token type IDs. If left to the default, will return the token type IDs according to
the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"return_token_type_ids"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return the attention mask. If left to the default, will return the attention mask according
to the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"return_attention_mask"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.return_overflowing_tokens",description:`<strong>return_overflowing_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return overflowing token sequences. If a pair of sequences of input ids (or a batch
of pairs) is provided with <code>truncation_strategy = longest_first</code> or <code>True</code>, an error is raised instead
of returning overflowing tokens.`,name:"return_overflowing_tokens"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.return_special_tokens_mask",description:`<strong>return_special_tokens_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return special tokens mask information.`,name:"return_special_tokens_mask"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.return_offsets_mapping",description:`<strong>return_offsets_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return <code>(char_start, char_end)</code> for each token.</p>
<p>This is only available on fast tokenizers inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a>, if using
Python&#x2019;s tokenizer, this method will raise <code>NotImplementedError</code>.`,name:"return_offsets_mapping"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.return_length",description:`<strong>return_length</strong>  (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the lengths of the encoded inputs.`,name:"return_length"},{anchor:"transformers.FastSpeech2ConformerTokenizer.__call__.verbose",description:`<strong>verbose</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to print more information and warnings.
**kwargs &#x2014; passed to the <code>self.tokenize()</code> method`,name:"verbose"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L2785",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a> with the following fields:</p>
<ul>
<li>
<p><strong>input_ids</strong> — List of token ids to be fed to a model.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
</li>
<li>
<p><strong>token_type_ids</strong> — List of token type ids to be fed to a model (when <code>return_token_type_ids=True</code> or
if <em>“token_type_ids”</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a></p>
</li>
<li>
<p><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
</li>
<li>
<p><strong>overflowing_tokens</strong> — List of overflowing tokens sequences (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>num_truncated_tokens</strong> — Number of tokens truncated (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>special_tokens_mask</strong> — List of 0s and 1s, with 1 specifying added special tokens and 0 specifying
regular sequence tokens (when <code>add_special_tokens=True</code> and <code>return_special_tokens_mask=True</code>).</p>
</li>
<li>
<p><strong>length</strong> — The length of the inputs (when <code>return_length=True</code>)</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a></p>
`}}),ze=new Z({props:{name:"save_vocabulary",anchor:"transformers.FastSpeech2ConformerTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FastSpeech2ConformerTokenizer.save_vocabulary.save_directory",description:`<strong>save_directory</strong> (<code>str</code>) &#x2014;
The directory in which to save the vocabulary.`,name:"save_directory"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fastspeech2_conformer/tokenization_fastspeech2_conformer.py#L145",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Paths to the files saved.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple(str)</code></p>
`}}),We=new Z({props:{name:"decode",anchor:"transformers.FastSpeech2ConformerTokenizer.decode",parameters:[{name:"token_ids",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fastspeech2_conformer/tokenization_fastspeech2_conformer.py#L132"}}),je=new Z({props:{name:"batch_decode",anchor:"transformers.FastSpeech2ConformerTokenizer.batch_decode",parameters:[{name:"sequences",val:": Union"},{name:"skip_special_tokens",val:": bool = False"},{name:"clean_up_tokenization_spaces",val:": bool = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FastSpeech2ConformerTokenizer.batch_decode.sequences",description:`<strong>sequences</strong> (<code>Union[List[int], List[List[int]], np.ndarray, torch.Tensor, tf.Tensor]</code>) &#x2014;
List of tokenized input ids. Can be obtained using the <code>__call__</code> method.`,name:"sequences"},{anchor:"transformers.FastSpeech2ConformerTokenizer.batch_decode.skip_special_tokens",description:`<strong>skip_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to remove special tokens in the decoding.`,name:"skip_special_tokens"},{anchor:"transformers.FastSpeech2ConformerTokenizer.batch_decode.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to clean up the tokenization spaces. If <code>None</code>, will default to
<code>self.clean_up_tokenization_spaces</code>.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.FastSpeech2ConformerTokenizer.batch_decode.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Will be passed to the underlying model specific decode method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L3748",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The list of decoded sentences.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Je=new z({props:{title:"FastSpeech2ConformerModel",local:"transformers.FastSpeech2ConformerModel",headingTag:"h2"}}),Ge=new Z({props:{name:"class transformers.FastSpeech2ConformerModel",anchor:"transformers.FastSpeech2ConformerModel",parameters:[{name:"config",val:": FastSpeech2ConformerConfig"}],parametersDescription:[{anchor:"transformers.FastSpeech2ConformerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerConfig">FastSpeech2ConformerConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fastspeech2_conformer/modeling_fastspeech2_conformer.py#L1098"}}),Ue=new Z({props:{name:"forward",anchor:"transformers.FastSpeech2ConformerModel.forward",parameters:[{name:"input_ids",val:": LongTensor"},{name:"attention_mask",val:": Optional = None"},{name:"spectrogram_labels",val:": Optional = None"},{name:"duration_labels",val:": Optional = None"},{name:"pitch_labels",val:": Optional = None"},{name:"energy_labels",val:": Optional = None"},{name:"speaker_ids",val:": Optional = None"},{name:"lang_ids",val:": Optional = None"},{name:"speaker_embedding",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FastSpeech2ConformerModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Input sequence of text vectors.`,name:"input_ids"},{anchor:"transformers.FastSpeech2ConformerModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in
<code>[0, 1]</code>: 0 for tokens that are <strong>masked</strong>, 1 for tokens that are <strong>not masked</strong>.`,name:"attention_mask"},{anchor:"transformers.FastSpeech2ConformerModel.forward.spectrogram_labels",description:`<strong>spectrogram_labels</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, max_spectrogram_length, num_mel_bins)</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Batch of padded target features.`,name:"spectrogram_labels"},{anchor:"transformers.FastSpeech2ConformerModel.forward.duration_labels",description:`<strong>duration_labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length + 1)</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Batch of padded durations.`,name:"duration_labels"},{anchor:"transformers.FastSpeech2ConformerModel.forward.pitch_labels",description:`<strong>pitch_labels</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length + 1, 1)</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Batch of padded token-averaged pitch.`,name:"pitch_labels"},{anchor:"transformers.FastSpeech2ConformerModel.forward.energy_labels",description:`<strong>energy_labels</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length + 1, 1)</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Batch of padded token-averaged energy.`,name:"energy_labels"},{anchor:"transformers.FastSpeech2ConformerModel.forward.speaker_ids",description:`<strong>speaker_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 1)</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Speaker ids used to condition features of speech output by the model.`,name:"speaker_ids"},{anchor:"transformers.FastSpeech2ConformerModel.forward.lang_ids",description:`<strong>lang_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 1)</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Language ids used to condition features of speech output by the model.`,name:"lang_ids"},{anchor:"transformers.FastSpeech2ConformerModel.forward.speaker_embedding",description:`<strong>speaker_embedding</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, embedding_dim)</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Embedding containing conditioning signals for the features of the speech.`,name:"speaker_embedding"},{anchor:"transformers.FastSpeech2ConformerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether or not to return a <code>FastSpeech2ConformerModelOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.FastSpeech2ConformerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FastSpeech2ConformerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fastspeech2_conformer/modeling_fastspeech2_conformer.py#L1179",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.fastspeech2_conformer.modeling_fastspeech2_conformer.FastSpeech2ConformerModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerConfig"
>FastSpeech2ConformerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Spectrogram generation loss.</p>
</li>
<li>
<p><strong>spectrogram</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, num_bins)</code>) — The predicted spectrogram.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>duration_outputs</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, max_text_length + 1)</code>, <em>optional</em>) — Outputs of the duration predictor.</p>
</li>
<li>
<p><strong>pitch_outputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, max_text_length + 1, 1)</code>, <em>optional</em>) — Outputs of the pitch predictor.</p>
</li>
<li>
<p><strong>energy_outputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, max_text_length + 1, 1)</code>, <em>optional</em>) — Outputs of the energy predictor.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.fastspeech2_conformer.modeling_fastspeech2_conformer.FastSpeech2ConformerModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new ht({props:{anchor:"transformers.FastSpeech2ConformerModel.forward.example",$$slots:{default:[zn]},$$scope:{ctx:U}}}),Ne=new z({props:{title:"FastSpeech2ConformerHifiGan",local:"transformers.FastSpeech2ConformerHifiGan",headingTag:"h2"}}),He=new Z({props:{name:"class transformers.FastSpeech2ConformerHifiGan",anchor:"transformers.FastSpeech2ConformerHifiGan",parameters:[{name:"config",val:": FastSpeech2ConformerHifiGanConfig"}],parametersDescription:[{anchor:"transformers.FastSpeech2ConformerHifiGan.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerConfig">FastSpeech2ConformerConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fastspeech2_conformer/modeling_fastspeech2_conformer.py#L1444"}}),Be=new Z({props:{name:"forward",anchor:"transformers.FastSpeech2ConformerHifiGan.forward",parameters:[{name:"spectrogram",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.FastSpeech2ConformerHifiGan.forward.spectrogram",description:`<strong>spectrogram</strong> (<code>torch.FloatTensor</code>) &#x2014;
Tensor containing the log-mel spectrograms. Can be batched and of shape <code>(batch_size, sequence_length, config.model_in_dim)</code>, or un-batched and of shape <code>(sequence_length, config.model_in_dim)</code>.`,name:"spectrogram"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fastspeech2_conformer/modeling_fastspeech2_conformer.py#L1514",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Tensor containing the speech waveform. If the input spectrogram is batched, will be of
shape <code>(batch_size, num_frames,)</code>. If un-batched, will be of shape <code>(num_frames,)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),Ie=new z({props:{title:"FastSpeech2ConformerWithHifiGan",local:"transformers.FastSpeech2ConformerWithHifiGan",headingTag:"h2"}}),Ve=new Z({props:{name:"class transformers.FastSpeech2ConformerWithHifiGan",anchor:"transformers.FastSpeech2ConformerWithHifiGan",parameters:[{name:"config",val:": FastSpeech2ConformerWithHifiGanConfig"}],parametersDescription:[{anchor:"transformers.FastSpeech2ConformerWithHifiGan.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerWithHifiGanConfig">FastSpeech2ConformerWithHifiGanConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fastspeech2_conformer/modeling_fastspeech2_conformer.py#L1562"}}),qe=new Z({props:{name:"forward",anchor:"transformers.FastSpeech2ConformerWithHifiGan.forward",parameters:[{name:"input_ids",val:": LongTensor"},{name:"attention_mask",val:": Optional = None"},{name:"spectrogram_labels",val:": Optional = None"},{name:"duration_labels",val:": Optional = None"},{name:"pitch_labels",val:": Optional = None"},{name:"energy_labels",val:": Optional = None"},{name:"speaker_ids",val:": Optional = None"},{name:"lang_ids",val:": Optional = None"},{name:"speaker_embedding",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FastSpeech2ConformerWithHifiGan.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Input sequence of text vectors.`,name:"input_ids"},{anchor:"transformers.FastSpeech2ConformerWithHifiGan.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing convolution and attention on padding token indices. Mask values selected in
<code>[0, 1]</code>: 0 for tokens that are <strong>masked</strong>, 1 for tokens that are <strong>not masked</strong>.`,name:"attention_mask"},{anchor:"transformers.FastSpeech2ConformerWithHifiGan.forward.spectrogram_labels",description:`<strong>spectrogram_labels</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, max_spectrogram_length, num_mel_bins)</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Batch of padded target features.`,name:"spectrogram_labels"},{anchor:"transformers.FastSpeech2ConformerWithHifiGan.forward.duration_labels",description:`<strong>duration_labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length + 1)</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Batch of padded durations.`,name:"duration_labels"},{anchor:"transformers.FastSpeech2ConformerWithHifiGan.forward.pitch_labels",description:`<strong>pitch_labels</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length + 1, 1)</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Batch of padded token-averaged pitch.`,name:"pitch_labels"},{anchor:"transformers.FastSpeech2ConformerWithHifiGan.forward.energy_labels",description:`<strong>energy_labels</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length + 1, 1)</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Batch of padded token-averaged energy.`,name:"energy_labels"},{anchor:"transformers.FastSpeech2ConformerWithHifiGan.forward.speaker_ids",description:`<strong>speaker_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 1)</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Speaker ids used to condition features of speech output by the model.`,name:"speaker_ids"},{anchor:"transformers.FastSpeech2ConformerWithHifiGan.forward.lang_ids",description:`<strong>lang_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 1)</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Language ids used to condition features of speech output by the model.`,name:"lang_ids"},{anchor:"transformers.FastSpeech2ConformerWithHifiGan.forward.speaker_embedding",description:`<strong>speaker_embedding</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, embedding_dim)</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Embedding containing conditioning signals for the features of the speech.`,name:"speaker_embedding"},{anchor:"transformers.FastSpeech2ConformerWithHifiGan.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether or not to return a <code>FastSpeech2ConformerModelOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.FastSpeech2ConformerWithHifiGan.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FastSpeech2ConformerWithHifiGan.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fastspeech2_conformer/modeling_fastspeech2_conformer.py#L1577",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.fastspeech2_conformer.modeling_fastspeech2_conformer.FastSpeech2ConformerWithHifiGanOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.fastspeech2_conformer.configuration_fastspeech2_conformer.FastSpeech2ConformerWithHifiGanConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>waveform</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, audio_length)</code>) — Speech output as a result of passing the predicted mel spectrogram through the vocoder.</p>
</li>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Spectrogram generation loss.</p>
</li>
<li>
<p><strong>spectrogram</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, num_bins)</code>) — The predicted spectrogram.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>duration_outputs</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, max_text_length + 1)</code>, <em>optional</em>) — Outputs of the duration predictor.</p>
</li>
<li>
<p><strong>pitch_outputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, max_text_length + 1, 1)</code>, <em>optional</em>) — Outputs of the pitch predictor.</p>
</li>
<li>
<p><strong>energy_outputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, max_text_length + 1, 1)</code>, <em>optional</em>) — Outputs of the energy predictor.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.fastspeech2_conformer.modeling_fastspeech2_conformer.FastSpeech2ConformerWithHifiGanOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ee=new ht({props:{anchor:"transformers.FastSpeech2ConformerWithHifiGan.forward.example",$$slots:{default:[Wn]},$$scope:{ctx:U}}}),Re=new Sn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/fastspeech2_conformer.md"}}),{c(){d=c("meta"),C=r(),v=c("p"),m=r(),p(y.$$.fragment),n=r(),p(T.$$.fragment),gt=r(),ne=c("p"),ne.innerHTML=Io,_t=r(),re=c("p"),re.textContent=Vo,bt=r(),se=c("p"),se.innerHTML=qo,yt=r(),ae=c("p"),ae.innerHTML=Ro,vt=r(),p(ie.$$.fragment),Tt=r(),ce=c("p"),ce.textContent=Xo,Ct=r(),p(le.$$.fragment),kt=r(),de=c("p"),de.innerHTML=Eo,wt=r(),p(me.$$.fragment),Mt=r(),pe=c("p"),pe.innerHTML=Lo,Ft=r(),p(fe.$$.fragment),St=r(),he=c("p"),he.innerHTML=Yo,$t=r(),p(ue.$$.fragment),xt=r(),ge=c("p"),ge.textContent=Qo,Zt=r(),_e=c("ol"),_e.innerHTML=Po,zt=r(),p(be.$$.fragment),Wt=r(),V=c("ol"),V.innerHTML=Do,jt=r(),p(ye.$$.fragment),Jt=r(),q=c("ol"),q.innerHTML=Ao,Gt=r(),p(ve.$$.fragment),Ut=r(),R=c("ol"),R.innerHTML=Oo,Nt=r(),p(Te.$$.fragment),Ht=r(),p(Ce.$$.fragment),Bt=r(),W=c("div"),p(ke.$$.fragment),ao=r(),Ee=c("p"),Ee.innerHTML=Ko,io=r(),Le=c("p"),Le.innerHTML=en,co=r(),p(X.$$.fragment),It=r(),p(we.$$.fragment),Vt=r(),j=c("div"),p(Me.$$.fragment),lo=r(),Ye=c("p"),Ye.innerHTML=tn,mo=r(),Qe=c("p"),Qe.innerHTML=on,po=r(),p(E.$$.fragment),qt=r(),p(Fe.$$.fragment),Rt=r(),w=c("div"),p(Se.$$.fragment),fo=r(),Pe=c("p"),Pe.innerHTML=nn,ho=r(),De=c("p"),De.innerHTML=rn,uo=r(),Ae=c("p"),Ae.innerHTML=sn,go=r(),Oe=c("p"),Oe.innerHTML=an,_o=r(),p(L.$$.fragment),Xt=r(),p($e.$$.fragment),Et=r(),M=c("div"),p(xe.$$.fragment),bo=r(),Ke=c("p"),Ke.textContent=cn,yo=r(),Y=c("div"),p(Ze.$$.fragment),vo=r(),et=c("p"),et.textContent=ln,To=r(),Q=c("div"),p(ze.$$.fragment),Co=r(),tt=c("p"),tt.textContent=dn,ko=r(),ot=c("div"),p(We.$$.fragment),wo=r(),P=c("div"),p(je.$$.fragment),Mo=r(),nt=c("p"),nt.textContent=mn,Lt=r(),p(Je.$$.fragment),Yt=r(),F=c("div"),p(Ge.$$.fragment),Fo=r(),rt=c("p"),rt.innerHTML=pn,So=r(),st=c("p"),st.innerHTML=fn,$o=r(),at=c("p"),at.textContent=hn,xo=r(),it=c("p"),it.innerHTML=un,Zo=r(),D=c("div"),p(Ue.$$.fragment),zo=r(),p(A.$$.fragment),Qt=r(),p(Ne.$$.fragment),Pt=r(),J=c("div"),p(He.$$.fragment),Wo=r(),ct=c("p"),ct.innerHTML=gn,jo=r(),lt=c("p"),lt.innerHTML=_n,Jo=r(),O=c("div"),p(Be.$$.fragment),Go=r(),dt=c("p"),dt.textContent=bn,Dt=r(),p(Ie.$$.fragment),At=r(),G=c("div"),p(Ve.$$.fragment),Uo=r(),mt=c("p"),mt.innerHTML=yn,No=r(),pt=c("p"),pt.innerHTML=vn,Ho=r(),K=c("div"),p(qe.$$.fragment),Bo=r(),p(ee.$$.fragment),Ot=r(),p(Re.$$.fragment),Kt=r(),ft=c("p"),this.h()},l(e){const t=Fn("svelte-u9bgzb",document.head);d=l(t,"META",{name:!0,content:!0}),t.forEach(o),C=s(e),v=l(e,"P",{}),S(v).forEach(o),m=s(e),f(y.$$.fragment,e),n=s(e),f(T.$$.fragment,e),gt=s(e),ne=l(e,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-11lj5xf"&&(ne.innerHTML=Io),_t=s(e),re=l(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-i2f859"&&(re.textContent=Vo),bt=s(e),se=l(e,"P",{"data-svelte-h":!0}),b(se)!=="svelte-1h2qnit"&&(se.innerHTML=qo),yt=s(e),ae=l(e,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-s65fns"&&(ae.innerHTML=Ro),vt=s(e),f(ie.$$.fragment,e),Tt=s(e),ce=l(e,"P",{"data-svelte-h":!0}),b(ce)!=="svelte-1uewxg9"&&(ce.textContent=Xo),Ct=s(e),f(le.$$.fragment,e),kt=s(e),de=l(e,"P",{"data-svelte-h":!0}),b(de)!=="svelte-dil2g4"&&(de.innerHTML=Eo),wt=s(e),f(me.$$.fragment,e),Mt=s(e),pe=l(e,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-1y8wo0z"&&(pe.innerHTML=Lo),Ft=s(e),f(fe.$$.fragment,e),St=s(e),he=l(e,"P",{"data-svelte-h":!0}),b(he)!=="svelte-13qfhfp"&&(he.innerHTML=Yo),$t=s(e),f(ue.$$.fragment,e),xt=s(e),ge=l(e,"P",{"data-svelte-h":!0}),b(ge)!=="svelte-19omgwa"&&(ge.textContent=Qo),Zt=s(e),_e=l(e,"OL",{"data-svelte-h":!0}),b(_e)!=="svelte-thbc7u"&&(_e.innerHTML=Po),zt=s(e),f(be.$$.fragment,e),Wt=s(e),V=l(e,"OL",{start:!0,"data-svelte-h":!0}),b(V)!=="svelte-loqyp8"&&(V.innerHTML=Do),jt=s(e),f(ye.$$.fragment,e),Jt=s(e),q=l(e,"OL",{start:!0,"data-svelte-h":!0}),b(q)!=="svelte-fhcfuy"&&(q.innerHTML=Ao),Gt=s(e),f(ve.$$.fragment,e),Ut=s(e),R=l(e,"OL",{start:!0,"data-svelte-h":!0}),b(R)!=="svelte-80t8iw"&&(R.innerHTML=Oo),Nt=s(e),f(Te.$$.fragment,e),Ht=s(e),f(Ce.$$.fragment,e),Bt=s(e),W=l(e,"DIV",{class:!0});var H=S(W);f(ke.$$.fragment,H),ao=s(H),Ee=l(H,"P",{"data-svelte-h":!0}),b(Ee)!=="svelte-tf1t85"&&(Ee.innerHTML=Ko),io=s(H),Le=l(H,"P",{"data-svelte-h":!0}),b(Le)!=="svelte-o55m63"&&(Le.innerHTML=en),co=s(H),f(X.$$.fragment,H),H.forEach(o),It=s(e),f(we.$$.fragment,e),Vt=s(e),j=l(e,"DIV",{class:!0});var B=S(j);f(Me.$$.fragment,B),lo=s(B),Ye=l(B,"P",{"data-svelte-h":!0}),b(Ye)!=="svelte-1o2ujgq"&&(Ye.innerHTML=tn),mo=s(B),Qe=l(B,"P",{"data-svelte-h":!0}),b(Qe)!=="svelte-o55m63"&&(Qe.innerHTML=on),po=s(B),f(E.$$.fragment,B),B.forEach(o),qt=s(e),f(Fe.$$.fragment,e),Rt=s(e),w=l(e,"DIV",{class:!0});var $=S(w);f(Se.$$.fragment,$),fo=s($),Pe=l($,"P",{"data-svelte-h":!0}),b(Pe)!=="svelte-17f9qgu"&&(Pe.innerHTML=nn),ho=s($),De=l($,"P",{"data-svelte-h":!0}),b(De)!=="svelte-1qqmy8s"&&(De.innerHTML=rn),uo=s($),Ae=l($,"P",{"data-svelte-h":!0}),b(Ae)!=="svelte-o55m63"&&(Ae.innerHTML=sn),go=s($),Oe=l($,"P",{"data-svelte-h":!0}),b(Oe)!=="svelte-sr3enk"&&(Oe.innerHTML=an),_o=s($),f(L.$$.fragment,$),$.forEach(o),Xt=s(e),f($e.$$.fragment,e),Et=s(e),M=l(e,"DIV",{class:!0});var x=S(M);f(xe.$$.fragment,x),bo=s(x),Ke=l(x,"P",{"data-svelte-h":!0}),b(Ke)!=="svelte-7gt8fu"&&(Ke.textContent=cn),yo=s(x),Y=l(x,"DIV",{class:!0});var Xe=S(Y);f(Ze.$$.fragment,Xe),vo=s(Xe),et=l(Xe,"P",{"data-svelte-h":!0}),b(et)!=="svelte-kpxj0c"&&(et.textContent=ln),Xe.forEach(o),To=s(x),Q=l(x,"DIV",{class:!0});var to=S(Q);f(ze.$$.fragment,to),Co=s(to),tt=l(to,"P",{"data-svelte-h":!0}),b(tt)!=="svelte-1slb66l"&&(tt.textContent=dn),to.forEach(o),ko=s(x),ot=l(x,"DIV",{class:!0});var Tn=S(ot);f(We.$$.fragment,Tn),Tn.forEach(o),wo=s(x),P=l(x,"DIV",{class:!0});var oo=S(P);f(je.$$.fragment,oo),Mo=s(oo),nt=l(oo,"P",{"data-svelte-h":!0}),b(nt)!=="svelte-1deng2j"&&(nt.textContent=mn),oo.forEach(o),x.forEach(o),Lt=s(e),f(Je.$$.fragment,e),Yt=s(e),F=l(e,"DIV",{class:!0});var N=S(F);f(Ge.$$.fragment,N),Fo=s(N),rt=l(N,"P",{"data-svelte-h":!0}),b(rt)!=="svelte-1gnx6du"&&(rt.innerHTML=pn),So=s(N),st=l(N,"P",{"data-svelte-h":!0}),b(st)!=="svelte-hswkmf"&&(st.innerHTML=fn),$o=s(N),at=l(N,"P",{"data-svelte-h":!0}),b(at)!=="svelte-b8dnq0"&&(at.textContent=hn),xo=s(N),it=l(N,"P",{"data-svelte-h":!0}),b(it)!=="svelte-wilylt"&&(it.innerHTML=un),Zo=s(N),D=l(N,"DIV",{class:!0});var no=S(D);f(Ue.$$.fragment,no),zo=s(no),f(A.$$.fragment,no),no.forEach(o),N.forEach(o),Qt=s(e),f(Ne.$$.fragment,e),Pt=s(e),J=l(e,"DIV",{class:!0});var te=S(J);f(He.$$.fragment,te),Wo=s(te),ct=l(te,"P",{"data-svelte-h":!0}),b(ct)!=="svelte-185meuv"&&(ct.innerHTML=gn),jo=s(te),lt=l(te,"P",{"data-svelte-h":!0}),b(lt)!=="svelte-hswkmf"&&(lt.innerHTML=_n),Jo=s(te),O=l(te,"DIV",{class:!0});var ro=S(O);f(Be.$$.fragment,ro),Go=s(ro),dt=l(ro,"P",{"data-svelte-h":!0}),b(dt)!=="svelte-qef8w5"&&(dt.textContent=bn),ro.forEach(o),te.forEach(o),Dt=s(e),f(Ie.$$.fragment,e),At=s(e),G=l(e,"DIV",{class:!0});var oe=S(G);f(Ve.$$.fragment,oe),Uo=s(oe),mt=l(oe,"P",{"data-svelte-h":!0}),b(mt)!=="svelte-hltul0"&&(mt.innerHTML=yn),No=s(oe),pt=l(oe,"P",{"data-svelte-h":!0}),b(pt)!=="svelte-hswkmf"&&(pt.innerHTML=vn),Ho=s(oe),K=l(oe,"DIV",{class:!0});var so=S(K);f(qe.$$.fragment,so),Bo=s(so),f(ee.$$.fragment,so),so.forEach(o),oe.forEach(o),Ot=s(e),f(Re.$$.fragment,e),Kt=s(e),ft=l(e,"P",{}),S(ft).forEach(o),this.h()},h(){k(d,"name","hf:doc:metadata"),k(d,"content",Jn),k(V,"start","2"),k(q,"start","3"),k(R,"start","4"),k(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,d),a(e,C,t),a(e,v,t),a(e,m,t),h(y,e,t),a(e,n,t),h(T,e,t),a(e,gt,t),a(e,ne,t),a(e,_t,t),a(e,re,t),a(e,bt,t),a(e,se,t),a(e,yt,t),a(e,ae,t),a(e,vt,t),h(ie,e,t),a(e,Tt,t),a(e,ce,t),a(e,Ct,t),h(le,e,t),a(e,kt,t),a(e,de,t),a(e,wt,t),h(me,e,t),a(e,Mt,t),a(e,pe,t),a(e,Ft,t),h(fe,e,t),a(e,St,t),a(e,he,t),a(e,$t,t),h(ue,e,t),a(e,xt,t),a(e,ge,t),a(e,Zt,t),a(e,_e,t),a(e,zt,t),h(be,e,t),a(e,Wt,t),a(e,V,t),a(e,jt,t),h(ye,e,t),a(e,Jt,t),a(e,q,t),a(e,Gt,t),h(ve,e,t),a(e,Ut,t),a(e,R,t),a(e,Nt,t),h(Te,e,t),a(e,Ht,t),h(Ce,e,t),a(e,Bt,t),a(e,W,t),h(ke,W,null),i(W,ao),i(W,Ee),i(W,io),i(W,Le),i(W,co),h(X,W,null),a(e,It,t),h(we,e,t),a(e,Vt,t),a(e,j,t),h(Me,j,null),i(j,lo),i(j,Ye),i(j,mo),i(j,Qe),i(j,po),h(E,j,null),a(e,qt,t),h(Fe,e,t),a(e,Rt,t),a(e,w,t),h(Se,w,null),i(w,fo),i(w,Pe),i(w,ho),i(w,De),i(w,uo),i(w,Ae),i(w,go),i(w,Oe),i(w,_o),h(L,w,null),a(e,Xt,t),h($e,e,t),a(e,Et,t),a(e,M,t),h(xe,M,null),i(M,bo),i(M,Ke),i(M,yo),i(M,Y),h(Ze,Y,null),i(Y,vo),i(Y,et),i(M,To),i(M,Q),h(ze,Q,null),i(Q,Co),i(Q,tt),i(M,ko),i(M,ot),h(We,ot,null),i(M,wo),i(M,P),h(je,P,null),i(P,Mo),i(P,nt),a(e,Lt,t),h(Je,e,t),a(e,Yt,t),a(e,F,t),h(Ge,F,null),i(F,Fo),i(F,rt),i(F,So),i(F,st),i(F,$o),i(F,at),i(F,xo),i(F,it),i(F,Zo),i(F,D),h(Ue,D,null),i(D,zo),h(A,D,null),a(e,Qt,t),h(Ne,e,t),a(e,Pt,t),a(e,J,t),h(He,J,null),i(J,Wo),i(J,ct),i(J,jo),i(J,lt),i(J,Jo),i(J,O),h(Be,O,null),i(O,Go),i(O,dt),a(e,Dt,t),h(Ie,e,t),a(e,At,t),a(e,G,t),h(Ve,G,null),i(G,Uo),i(G,mt),i(G,No),i(G,pt),i(G,Ho),i(G,K),h(qe,K,null),i(K,Bo),h(ee,K,null),a(e,Ot,t),h(Re,e,t),a(e,Kt,t),a(e,ft,t),eo=!0},p(e,[t]){const H={};t&2&&(H.$$scope={dirty:t,ctx:e}),X.$set(H);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),E.$set(B);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),L.$set($);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),A.$set(x);const Xe={};t&2&&(Xe.$$scope={dirty:t,ctx:e}),ee.$set(Xe)},i(e){eo||(u(y.$$.fragment,e),u(T.$$.fragment,e),u(ie.$$.fragment,e),u(le.$$.fragment,e),u(me.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(ve.$$.fragment,e),u(Te.$$.fragment,e),u(Ce.$$.fragment,e),u(ke.$$.fragment,e),u(X.$$.fragment,e),u(we.$$.fragment,e),u(Me.$$.fragment,e),u(E.$$.fragment,e),u(Fe.$$.fragment,e),u(Se.$$.fragment,e),u(L.$$.fragment,e),u($e.$$.fragment,e),u(xe.$$.fragment,e),u(Ze.$$.fragment,e),u(ze.$$.fragment,e),u(We.$$.fragment,e),u(je.$$.fragment,e),u(Je.$$.fragment,e),u(Ge.$$.fragment,e),u(Ue.$$.fragment,e),u(A.$$.fragment,e),u(Ne.$$.fragment,e),u(He.$$.fragment,e),u(Be.$$.fragment,e),u(Ie.$$.fragment,e),u(Ve.$$.fragment,e),u(qe.$$.fragment,e),u(ee.$$.fragment,e),u(Re.$$.fragment,e),eo=!0)},o(e){g(y.$$.fragment,e),g(T.$$.fragment,e),g(ie.$$.fragment,e),g(le.$$.fragment,e),g(me.$$.fragment,e),g(fe.$$.fragment,e),g(ue.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(ve.$$.fragment,e),g(Te.$$.fragment,e),g(Ce.$$.fragment,e),g(ke.$$.fragment,e),g(X.$$.fragment,e),g(we.$$.fragment,e),g(Me.$$.fragment,e),g(E.$$.fragment,e),g(Fe.$$.fragment,e),g(Se.$$.fragment,e),g(L.$$.fragment,e),g($e.$$.fragment,e),g(xe.$$.fragment,e),g(Ze.$$.fragment,e),g(ze.$$.fragment,e),g(We.$$.fragment,e),g(je.$$.fragment,e),g(Je.$$.fragment,e),g(Ge.$$.fragment,e),g(Ue.$$.fragment,e),g(A.$$.fragment,e),g(Ne.$$.fragment,e),g(He.$$.fragment,e),g(Be.$$.fragment,e),g(Ie.$$.fragment,e),g(Ve.$$.fragment,e),g(qe.$$.fragment,e),g(ee.$$.fragment,e),g(Re.$$.fragment,e),eo=!1},d(e){e&&(o(C),o(v),o(m),o(n),o(gt),o(ne),o(_t),o(re),o(bt),o(se),o(yt),o(ae),o(vt),o(Tt),o(ce),o(Ct),o(kt),o(de),o(wt),o(Mt),o(pe),o(Ft),o(St),o(he),o($t),o(xt),o(ge),o(Zt),o(_e),o(zt),o(Wt),o(V),o(jt),o(Jt),o(q),o(Gt),o(Ut),o(R),o(Nt),o(Ht),o(Bt),o(W),o(It),o(Vt),o(j),o(qt),o(Rt),o(w),o(Xt),o(Et),o(M),o(Lt),o(Yt),o(F),o(Qt),o(Pt),o(J),o(Dt),o(At),o(G),o(Ot),o(Kt),o(ft)),o(d),_(y,e),_(T,e),_(ie,e),_(le,e),_(me,e),_(fe,e),_(ue,e),_(be,e),_(ye,e),_(ve,e),_(Te,e),_(Ce,e),_(ke),_(X),_(we,e),_(Me),_(E),_(Fe,e),_(Se),_(L),_($e,e),_(xe),_(Ze),_(ze),_(We),_(je),_(Je,e),_(Ge),_(Ue),_(A),_(Ne,e),_(He),_(Be),_(Ie,e),_(Ve),_(qe),_(ee),_(Re,e)}}}const Jn='{"title":"FastSpeech2Conformer","local":"fastspeech2conformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"🤗 Model Architecture","local":"-model-architecture","sections":[{"title":"FastSpeech2 Model Architecture","local":"fastspeech2-model-architecture","sections":[],"depth":4},{"title":"Conformer Blocks","local":"conformer-blocks","sections":[],"depth":4},{"title":"Convolution Module","local":"convolution-module","sections":[],"depth":4}],"depth":2},{"title":"🤗 Transformers Usage","local":"-transformers-usage","sections":[],"depth":2},{"title":"FastSpeech2ConformerConfig","local":"transformers.FastSpeech2ConformerConfig","sections":[],"depth":2},{"title":"FastSpeech2ConformerHifiGanConfig","local":"transformers.FastSpeech2ConformerHifiGanConfig","sections":[],"depth":2},{"title":"FastSpeech2ConformerWithHifiGanConfig","local":"transformers.FastSpeech2ConformerWithHifiGanConfig","sections":[],"depth":2},{"title":"FastSpeech2ConformerTokenizer","local":"transformers.FastSpeech2ConformerTokenizer","sections":[],"depth":2},{"title":"FastSpeech2ConformerModel","local":"transformers.FastSpeech2ConformerModel","sections":[],"depth":2},{"title":"FastSpeech2ConformerHifiGan","local":"transformers.FastSpeech2ConformerHifiGan","sections":[],"depth":2},{"title":"FastSpeech2ConformerWithHifiGan","local":"transformers.FastSpeech2ConformerWithHifiGan","sections":[],"depth":2}],"depth":1}';function Gn(U){return kn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qn extends wn{constructor(d){super(),Mn(this,d,Gn,jn,Cn,{})}}export{qn as component};
