import{s as Ia,o as ga,n as Ca}from"../chunks/scheduler.9bc65507.js";import{S as va,i as Za,g as p,s as t,r as M,A as Ga,h as i,f as e,c as n,j as ba,u as m,x as o,k as Ze,y as Wa,a,v as c,d as y,t as r,w as h}from"../chunks/index.707bf1b6.js";import{T as Ba}from"../chunks/Tip.c2ecdbf4.js";import{C as d}from"../chunks/CodeBlock.54a9f38d.js";import{D as _a}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as Ls,E as Aa}from"../chunks/EditOnGithub.922df6ba.js";function ka(Ks){let w,u='To see all architectures and checkpoints compatible with this task, we recommend checking the <a href="https://huggingface.co/tasks/video-classification" rel="nofollow">task-page</a>.';return{c(){w=p("p"),w.innerHTML=u},l(J){w=i(J,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1cybrxm"&&(w.innerHTML=u)},m(J,qs){a(J,w,qs)},p:Ca,d(J){J&&e(w)}}}function Va(Ks){let w,u,J,qs,f,Ps,b,Os,I,Ge="Video classification is the task of assigning a label or class to an entire video. Videos are expected to have only one class for each video. Video classification models take a video as input and return a prediction about which class the video belongs to. These models can be used to categorize what a video is all about. A real-world application of video classification is action / activity recognition, which is useful for fitness applications. It is also helpful for vision-impaired individuals, especially when they are commuting.",sl,g,We="This guide will show you how to:",ll,C,Be='<li>Fine-tune <a href="https://huggingface.co/docs/transformers/main/en/model_doc/videomae" rel="nofollow">VideoMAE</a> on a subset of the <a href="https://www.crcv.ucf.edu/data/UCF101.php" rel="nofollow">UCF101</a> dataset.</li> <li>Use your fine-tuned model for inference.</li>',el,j,al,v,_e="Before you begin, make sure you have all the necessary libraries installed:",tl,Z,nl,G,Ae='You will use <a href="https://pytorchvideo.org/" rel="nofollow">PyTorchVideo</a> (dubbed <code>pytorchvideo</code>) to process and prepare the videos.',pl,W,ke="We encourage you to log in to your Hugging Face account so you can upload and share your model with the community. When prompted, enter your token to log in:",il,B,ol,_,Ml,A,Ve='Start by loading a subset of the <a href="https://www.crcv.ucf.edu/data/UCF101.php" rel="nofollow">UCF-101 dataset</a>. This will give you a chance to experiment and make sure everything works before spending more time training on the full dataset.',ml,k,cl,V,Re="After the subset has been downloaded, you need to extract the compressed archive:",yl,R,rl,x,xe="At a high level, the dataset is organized like so:",hl,$,dl,X,$e="The (<code>sorted</code>) video paths appear like so:",wl,F,Jl,z,Xe="You will notice that there are video clips belonging to the same group / scene where group is denoted by <code>g</code> in the video file paths. <code>v_ApplyEyeMakeup_g07_c04.avi</code> and <code>v_ApplyEyeMakeup_g07_c06.avi</code>, for example.",jl,Y,Fe='For the validation and evaluation splits, you wouldn’t want to have video clips from the same group / scene to prevent <a href="https://www.kaggle.com/code/alexisbcook/data-leakage" rel="nofollow">data leakage</a>. The subset that you are using in this tutorial takes this information into account.',Tl,S,ze="Next up, you will derive the set of labels present in the dataset. Also, create two dictionaries that’ll be helpful when initializing the model:",Ul,E,Ye="<li><code>label2id</code>: maps the class names to integers.</li> <li><code>id2label</code>: maps the integers to class names.</li>",ul,Q,fl,N,Se="There are 10 unique classes. For each class, there are 30 videos in the training set.",bl,H,Il,L,Ee="Instantiate a video classification model from a pretrained checkpoint and its associated image processor. The model’s encoder comes with pre-trained parameters, and the classification head is randomly initialized. The image processor will come in handy when writing the preprocessing pipeline for our dataset.",gl,q,Cl,D,Qe="While the model is loading, you might notice the following warning:",vl,K,Zl,P,Ne="The warning is telling us we are throwing away some weights (e.g. the weights and bias of the <code>classifier</code> layer) and randomly initializing some others (the weights and bias of a new <code>classifier</code> layer). This is expected in this case, because we are adding a new head for which we don’t have pretrained weights, so the library warns us we should fine-tune this model before using it for inference, which is exactly what we are going to do.",Gl,O,He='<strong>Note</strong> that <a href="https://huggingface.co/MCG-NJU/videomae-base-finetuned-kinetics" rel="nofollow">this checkpoint</a> leads to better performance on this task as the checkpoint was obtained fine-tuning on a similar downstream task having considerable domain overlap. You can check out <a href="https://huggingface.co/sayakpaul/videomae-base-finetuned-kinetics-finetuned-ucf101-subset" rel="nofollow">this checkpoint</a> which was obtained by fine-tuning <code>MCG-NJU/videomae-base-finetuned-kinetics</code>.',Wl,ss,Bl,ls,Le='For preprocessing the videos, you will leverage the <a href="https://pytorchvideo.org/" rel="nofollow">PyTorchVideo library</a>. Start by importing the dependencies we need.',_l,es,Al,as,qe='For the training dataset transformations, use a combination of uniform temporal subsampling, pixel normalization, random cropping, and random horizontal flipping. For the validation and evaluation dataset transformations, keep the same transformation chain except for random cropping and horizontal flipping. To learn more about the details of these transformations check out the <a href="https://pytorchvideo.org" rel="nofollow">official documentation of PyTorchVideo</a>.',kl,ts,De="Use the <code>image_processor</code> associated with the pre-trained model to obtain the following information:",Vl,ns,Ke="<li>Image mean and standard deviation with which the video frame pixels will be normalized.</li> <li>Spatial resolution to which the video frames will be resized.</li>",Rl,ps,Pe="Start by defining some constants.",xl,is,$l,os,Oe="Now, define the dataset-specific transformations and the datasets respectively. Starting with the training set:",Xl,Ms,Fl,ms,sa="The same sequence of workflow can be applied to the validation and evaluation sets:",zl,cs,Yl,ys,la='<strong>Note</strong>: The above dataset pipelines are taken from the <a href="https://pytorchvideo.org/docs/tutorial_classification#dataset" rel="nofollow">official PyTorchVideo example</a>. We’re using the <a href="https://pytorchvideo.readthedocs.io/en/latest/api/data/data.html#pytorchvideo.data.Ucf101" rel="nofollow"><code>pytorchvideo.data.Ucf101()</code></a> function because it’s tailored for the UCF-101 dataset. Under the hood, it returns a <a href="https://pytorchvideo.readthedocs.io/en/latest/api/data/data.html#pytorchvideo.data.LabeledVideoDataset" rel="nofollow"><code>pytorchvideo.data.labeled_video_dataset.LabeledVideoDataset</code></a> object. <code>LabeledVideoDataset</code> class is the base class for all things video in the PyTorchVideo dataset. So, if you want to use a custom dataset not supported off-the-shelf by PyTorchVideo, you can extend the <code>LabeledVideoDataset</code> class accordingly. Refer to the <code>data</code> API <a href="https://pytorchvideo.readthedocs.io/en/latest/api/data/data.html" rel="nofollow">documentation to</a> learn more. Also, if your dataset follows a similar structure (as shown above), then using the <code>pytorchvideo.data.Ucf101()</code> should work just fine.',Sl,rs,ea="You can access the <code>num_videos</code> argument to know the number of videos in the dataset.",El,hs,Ql,ds,Nl,ws,Hl,T,aa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/sample_gif.gif" alt="Person playing basketball"/>',Ll,Js,ql,js,ta='Leverage <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow"><code>Trainer</code></a> from  🤗 Transformers for training the model. To instantiate a <code>Trainer</code>, you need to define the training configuration and an evaluation metric. The most important is the <a href="https://huggingface.co/transformers/main_classes/trainer.html#transformers.TrainingArguments" rel="nofollow"><code>TrainingArguments</code></a>, which is a class that contains all the attributes to configure the training. It requires an output folder name, which will be used to save the checkpoints of the model. It also helps sync all the information in the model repository on 🤗 Hub.',Dl,Ts,na="Most of the training arguments are self-explanatory, but one that is quite important here is <code>remove_unused_columns=False</code>. This one will drop any features not used by the model’s call function. By default it’s <code>True</code> because usually it’s ideal to drop unused feature columns, making it easier to unpack inputs into the model’s call function. But, in this case, you need the unused features (‘video’ in particular) in order to create <code>pixel_values</code> (which is a mandatory key our model expects in its inputs).",Kl,Us,Pl,us,pa="The dataset returned by <code>pytorchvideo.data.Ucf101()</code> doesn’t implement the <code>__len__</code> method. As such, we must define <code>max_steps</code> when instantiating <code>TrainingArguments</code>.",Ol,fs,ia="Next, you need to define a function to compute the metrics from the predictions, which will use the <code>metric</code> you’ll load now. The only preprocessing you have to do is to take the argmax of our predicted logits:",se,bs,le,Is,oa="<strong>A note on evaluation</strong>:",ee,gs,Ma='In the <a href="https://arxiv.org/abs/2203.12602" rel="nofollow">VideoMAE paper</a>, the authors use the following evaluation strategy. They evaluate the model on several clips from test videos and apply different crops to those clips and report the aggregate score. However, in the interest of simplicity and brevity, we don’t consider that in this tutorial.',ae,Cs,ma="Also, define a <code>collate_fn</code>, which will be used to batch examples together. Each batch consists of 2 keys, namely <code>pixel_values</code> and <code>labels</code>.",te,vs,ne,Zs,ca="Then you just pass all of this along with the datasets to <code>Trainer</code>:",pe,Gs,ie,Ws,ya="You might wonder why you passed along the <code>image_processor</code> as a tokenizer when you preprocessed the data already. This is only to make sure the image processor configuration file (stored as JSON) will also be uploaded to the repo on the Hub.",oe,Bs,ra="Now fine-tune our model by calling the <code>train</code> method:",Me,_s,me,As,ha='Once training is completed, share your model to the Hub with the <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> method so everyone can use your model:',ce,ks,ye,Vs,re,Rs,da="Great, now that you have fine-tuned a model, you can use it for inference!",he,xs,wa="Load a video for inference:",de,$s,we,U,Ja='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/sample_gif_two.gif" alt="Teams playing basketball"/>',Je,Xs,ja='The simplest way to try out your fine-tuned model for inference is to use it in a <a href="https://huggingface.co/docs/transformers/main/en/main_classes/pipelines#transformers.VideoClassificationPipeline" rel="nofollow"><code>pipeline</code></a>. Instantiate a <code>pipeline</code> for video classification with your model, and pass your video to it:',je,Fs,Te,zs,Ta="You can also manually replicate the results of the <code>pipeline</code> if you’d like.",Ue,Ys,ue,Ss,Ua="Now, pass your input to the model and return the <code>logits</code>:",fe,Es,be,Qs,ua="Decoding the <code>logits</code>, we get:",Ie,Ns,ge,Hs,Ce,Ds,ve;return f=new Ls({props:{title:"Video classification",local:"video-classification",headingTag:"h1"}}),b=new _a({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/video_classification.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/video_classification.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/video_classification.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/video_classification.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/video_classification.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/video_classification.ipynb"}]}}),j=new Ba({props:{$$slots:{default:[ka]},$$scope:{ctx:Ks}}}),Z=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwcHl0b3JjaHZpZGVvJTIwdHJhbnNmb3JtZXJzJTIwZXZhbHVhdGU=",highlighted:"pip install -q pytorchvideo transformers evaluate",wrap:!1}}),B=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),_=new Ls({props:{title:"Load UCF101 dataset",local:"load-ucf101-dataset",headingTag:"h2"}}),k=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQWhmX2RhdGFzZXRfaWRlbnRpZmllciUyMCUzRCUyMCUyMnNheWFrcGF1bCUyRnVjZjEwMS1zdWJzZXQlMjIlMEFmaWxlbmFtZSUyMCUzRCUyMCUyMlVDRjEwMV9zdWJzZXQudGFyLmd6JTIyJTBBZmlsZV9wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0RoZl9kYXRhc2V0X2lkZW50aWZpZXIlMkMlMjBmaWxlbmFtZSUzRGZpbGVuYW1lJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>hf_dataset_identifier = <span class="hljs-string">&quot;sayakpaul/ucf101-subset&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>filename = <span class="hljs-string">&quot;UCF101_subset.tar.gz&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(repo_id=hf_dataset_identifier, filename=filename, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)`,wrap:!1}}),R=new d({props:{code:"aW1wb3J0JTIwdGFyZmlsZSUwQSUwQXdpdGglMjB0YXJmaWxlLm9wZW4oZmlsZV9wYXRoKSUyMGFzJTIwdCUzQSUwQSUyMCUyMCUyMCUyMCUyMHQuZXh0cmFjdGFsbCglMjIuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tarfile

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> tarfile.<span class="hljs-built_in">open</span>(file_path) <span class="hljs-keyword">as</span> t:
<span class="hljs-meta">... </span>     t.extractall(<span class="hljs-string">&quot;.&quot;</span>)`,wrap:!1}}),$=new d({props:{code:"VUNGMTAxX3N1YnNldCUyRiUwQSUyMCUyMCUyMCUyMHRyYWluJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQmFuZE1hcmNoaW5nJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmlkZW9fMS5tcDQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18yLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEFyY2hlcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18xLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZpZGVvXzIubXA0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwdmFsJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQmFuZE1hcmNoaW5nJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmlkZW9fMS5tcDQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18yLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEFyY2hlcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18xLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZpZGVvXzIubXA0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwdGVzdCUyRiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEJhbmRNYXJjaGluZyUyRiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZpZGVvXzEubXA0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmlkZW9fMi5tcDQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBcmNoZXJ5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmlkZW9fMS5tcDQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18yLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLg==",highlighted:`UCF101_subset/
    train/
        BandMarching/
            video_1.mp4
            video_2.mp4
            ...
        Archery
            video_1.mp4
            video_2.mp4
            ...
        ...
    val/
        BandMarching/
            video_1.mp4
            video_2.mp4
            ...
        Archery
            video_1.mp4
            video_2.mp4
            ...
        ...
    <span class="hljs-built_in">test</span>/
        BandMarching/
            video_1.mp4
            video_2.mp4
            ...
        Archery
            video_1.mp4
            video_2.mp4
            ...
        ...`,wrap:!1}}),F=new d({props:{code:"",highlighted:`...
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g07_c04.avi&#x27;</span>,
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g07_c06.avi&#x27;</span>,
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g08_c01.avi&#x27;</span>,
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g09_c02.avi&#x27;</span>,
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g09_c06.avi&#x27;</span>
...`,wrap:!1}}),Q=new d({props:{code:"Y2xhc3NfbGFiZWxzJTIwJTNEJTIwc29ydGVkKCU3QnN0cihwYXRoKS5zcGxpdCglMjIlMkYlMjIpJTVCMiU1RCUyMGZvciUyMHBhdGglMjBpbiUyMGFsbF92aWRlb19maWxlX3BhdGhzJTdEKSUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCbGFiZWwlM0ElMjBpJTIwZm9yJTIwaSUyQyUyMGxhYmVsJTIwaW4lMjBlbnVtZXJhdGUoY2xhc3NfbGFiZWxzKSU3RCUwQWlkMmxhYmVsJTIwJTNEJTIwJTdCaSUzQSUyMGxhYmVsJTIwZm9yJTIwbGFiZWwlMkMlMjBpJTIwaW4lMjBsYWJlbDJpZC5pdGVtcygpJTdEJTBBJTBBcHJpbnQoZiUyMlVuaXF1ZSUyMGNsYXNzZXMlM0ElMjAlN0JsaXN0KGxhYmVsMmlkLmtleXMoKSklN0QuJTIyKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>class_labels = <span class="hljs-built_in">sorted</span>({<span class="hljs-built_in">str</span>(path).split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">2</span>] <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> all_video_file_paths})
<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {label: i <span class="hljs-keyword">for</span> i, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(class_labels)}
<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {i: label <span class="hljs-keyword">for</span> label, i <span class="hljs-keyword">in</span> label2id.items()}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Unique classes: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(label2id.keys())}</span>.&quot;</span>)

<span class="hljs-comment"># Unique classes: [&#x27;ApplyEyeMakeup&#x27;, &#x27;ApplyLipstick&#x27;, &#x27;Archery&#x27;, &#x27;BabyCrawling&#x27;, &#x27;BalanceBeam&#x27;, &#x27;BandMarching&#x27;, &#x27;BaseballPitch&#x27;, &#x27;Basketball&#x27;, &#x27;BasketballDunk&#x27;, &#x27;BenchPress&#x27;].</span>`,wrap:!1}}),H=new Ls({props:{title:"Load a model to fine-tune",local:"load-a-model-to-fine-tune",headingTag:"h2"}}),q=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTUFFSW1hZ2VQcm9jZXNzb3IlMkMlMjBWaWRlb01BRUZvclZpZGVvQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbF9ja3B0JTIwJTNEJTIwJTIyTUNHLU5KVSUyRnZpZGVvbWFlLWJhc2UlMjIlMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBWaWRlb01BRUltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9ja3B0KSUwQW1vZGVsJTIwJTNEJTIwVmlkZW9NQUVGb3JWaWRlb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9ja3B0JTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMjAlMjAlMjMlMjBwcm92aWRlJTIwdGhpcyUyMGluJTIwY2FzZSUyMHlvdSdyZSUyMHBsYW5uaW5nJTIwdG8lMjBmaW5lLXR1bmUlMjBhbiUyMGFscmVhZHklMjBmaW5lLXR1bmVkJTIwY2hlY2twb2ludCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoMAEImageProcessor, VideoMAEForVideoClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model_ckpt = <span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = VideoMAEImageProcessor.from_pretrained(model_ckpt)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoMAEForVideoClassification.from_pretrained(
<span class="hljs-meta">... </span>    model_ckpt,
<span class="hljs-meta">... </span>    label2id=label2id,
<span class="hljs-meta">... </span>    id2label=id2label,
<span class="hljs-meta">... </span>    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># provide this in case you&#x27;re planning to fine-tune an already fine-tuned checkpoint</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),K=new d({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwTUNHLU5KVSUyRnZpZGVvbWFlLWJhc2UlMjB3ZXJlJTIwbm90JTIwdXNlZCUyMHdoZW4lMjBpbml0aWFsaXppbmclMjBWaWRlb01BRUZvclZpZGVvQ2xhc3NpZmljYXRpb24lM0ElMjAlNUIuLi4lMkMlMjAnZGVjb2Rlci5kZWNvZGVyX2xheWVycy4xLmF0dGVudGlvbi5vdXRwdXQuZGVuc2UuYmlhcyclMkMlMjAnZGVjb2Rlci5kZWNvZGVyX2xheWVycy4yLmF0dGVudGlvbi5hdHRlbnRpb24ua2V5LndlaWdodCclNUQlMEEtJTIwVGhpcyUyMElTJTIwZXhwZWN0ZWQlMjBpZiUyMHlvdSUyMGFyZSUyMGluaXRpYWxpemluZyUyMFZpZGVvTUFFRm9yVmlkZW9DbGFzc2lmaWNhdGlvbiUyMGZyb20lMjB0aGUlMjBjaGVja3BvaW50JTIwb2YlMjBhJTIwbW9kZWwlMjB0cmFpbmVkJTIwb24lMjBhbm90aGVyJTIwdGFzayUyMG9yJTIwd2l0aCUyMGFub3RoZXIlMjBhcmNoaXRlY3R1cmUlMjAoZS5nLiUyMGluaXRpYWxpemluZyUyMGElMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyMG1vZGVsJTIwZnJvbSUyMGElMjBCZXJ0Rm9yUHJlVHJhaW5pbmclMjBtb2RlbCkuJTBBLSUyMFRoaXMlMjBJUyUyME5PVCUyMGV4cGVjdGVkJTIwaWYlMjB5b3UlMjBhcmUlMjBpbml0aWFsaXppbmclMjBWaWRlb01BRUZvclZpZGVvQ2xhc3NpZmljYXRpb24lMjBmcm9tJTIwdGhlJTIwY2hlY2twb2ludCUyMG9mJTIwYSUyMG1vZGVsJTIwdGhhdCUyMHlvdSUyMGV4cGVjdCUyMHRvJTIwYmUlMjBleGFjdGx5JTIwaWRlbnRpY2FsJTIwKGluaXRpYWxpemluZyUyMGElMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyMG1vZGVsJTIwZnJvbSUyMGElMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyMG1vZGVsKS4lMEFTb21lJTIwd2VpZ2h0cyUyMG9mJTIwVmlkZW9NQUVGb3JWaWRlb0NsYXNzaWZpY2F0aW9uJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwTUNHLU5KVSUyRnZpZGVvbWFlLWJhc2UlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTNBJTIwJTVCJ2NsYXNzaWZpZXIuYmlhcyclMkMlMjAnY2xhc3NpZmllci53ZWlnaHQnJTVEJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`Some weights of the model checkpoint at MCG-NJU/videomae-base were not used when initializing VideoMAEForVideoClassification: [..., <span class="hljs-string">&#x27;decoder.decoder_layers.1.attention.output.dense.bias&#x27;</span>, <span class="hljs-string">&#x27;decoder.decoder_layers.2.attention.attention.key.weight&#x27;</span>]
- This IS expected <span class="hljs-keyword">if</span> you are initializing VideoMAEForVideoClassification from the checkpoint of a model trained on another task or with another architecture (e.g. initializing a BertForSequenceClassification model from a BertForPreTraining model).
- This IS NOT expected <span class="hljs-keyword">if</span> you are initializing VideoMAEForVideoClassification from the checkpoint of a model that you expect to be exactly identical (initializing a BertForSequenceClassification model from a BertForSequenceClassification model).
Some weights of VideoMAEForVideoClassification were not initialized from the model checkpoint at MCG-NJU/videomae-base and are newly initialized: [<span class="hljs-string">&#x27;classifier.bias&#x27;</span>, <span class="hljs-string">&#x27;classifier.weight&#x27;</span>]
You should probably TRAIN this model on a down-stream task to be able to use it <span class="hljs-keyword">for</span> predictions and inference.`,wrap:!1}}),ss=new Ls({props:{title:"Prepare the datasets for training",local:"prepare-the-datasets-for-training",headingTag:"h2"}}),es=new d({props:{code:"aW1wb3J0JTIwcHl0b3JjaHZpZGVvLmRhdGElMEElMEFmcm9tJTIwcHl0b3JjaHZpZGVvLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQXBwbHlUcmFuc2Zvcm1Ub0tleSUyQyUwQSUyMCUyMCUyMCUyME5vcm1hbGl6ZSUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbVNob3J0U2lkZVNjYWxlJTJDJTBBJTIwJTIwJTIwJTIwUmVtb3ZlS2V5JTJDJTBBJTIwJTIwJTIwJTIwU2hvcnRTaWRlU2NhbGUlMkMlMEElMjAlMjAlMjAlMjBVbmlmb3JtVGVtcG9yYWxTdWJzYW1wbGUlMkMlMEEpJTBBJTBBZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ29tcG9zZSUyQyUwQSUyMCUyMCUyMCUyMExhbWJkYSUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbUNyb3AlMkMlMEElMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcCUyQyUwQSUyMCUyMCUyMCUyMFJlc2l6ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pytorchvideo.data

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pytorchvideo.transforms <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    ApplyTransformToKey,
<span class="hljs-meta">... </span>    Normalize,
<span class="hljs-meta">... </span>    RandomShortSideScale,
<span class="hljs-meta">... </span>    RemoveKey,
<span class="hljs-meta">... </span>    ShortSideScale,
<span class="hljs-meta">... </span>    UniformTemporalSubsample,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    Compose,
<span class="hljs-meta">... </span>    Lambda,
<span class="hljs-meta">... </span>    RandomCrop,
<span class="hljs-meta">... </span>    RandomHorizontalFlip,
<span class="hljs-meta">... </span>    Resize,
<span class="hljs-meta">... </span>)`,wrap:!1}}),is=new d({props:{code:"bWVhbiUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5pbWFnZV9tZWFuJTBBc3RkJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLmltYWdlX3N0ZCUwQWlmJTIwJTIyc2hvcnRlc3RfZWRnZSUyMiUyMGluJTIwaW1hZ2VfcHJvY2Vzc29yLnNpemUlM0ElMEElMjAlMjAlMjAlMjBoZWlnaHQlMjAlM0QlMjB3aWR0aCUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5zaXplJTVCJTIyc2hvcnRlc3RfZWRnZSUyMiU1RCUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBoZWlnaHQlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3Iuc2l6ZSU1QiUyMmhlaWdodCUyMiU1RCUwQSUyMCUyMCUyMCUyMHdpZHRoJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnNpemUlNUIlMjJ3aWR0aCUyMiU1RCUwQXJlc2l6ZV90byUyMCUzRCUyMChoZWlnaHQlMkMlMjB3aWR0aCklMEElMEFudW1fZnJhbWVzX3RvX3NhbXBsZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5udW1fZnJhbWVzJTBBc2FtcGxlX3JhdGUlMjAlM0QlMjA0JTBBZnBzJTIwJTNEJTIwMzAlMEFjbGlwX2R1cmF0aW9uJTIwJTNEJTIwbnVtX2ZyYW1lc190b19zYW1wbGUlMjAqJTIwc2FtcGxlX3JhdGUlMjAlMkYlMjBmcHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>mean = image_processor.image_mean
<span class="hljs-meta">&gt;&gt;&gt; </span>std = image_processor.image_std
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> <span class="hljs-string">&quot;shortest_edge&quot;</span> <span class="hljs-keyword">in</span> image_processor.size:
<span class="hljs-meta">... </span>    height = width = image_processor.size[<span class="hljs-string">&quot;shortest_edge&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    height = image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]
<span class="hljs-meta">... </span>    width = image_processor.size[<span class="hljs-string">&quot;width&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>resize_to = (height, width)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_frames_to_sample = model.config.num_frames
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_rate = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fps = <span class="hljs-number">30</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>clip_duration = num_frames_to_sample * sample_rate / fps`,wrap:!1}}),Ms=new d({props:{code:"dHJhaW5fdHJhbnNmb3JtJTIwJTNEJTIwQ29tcG9zZSglMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBcHBseVRyYW5zZm9ybVRvS2V5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGtleSUzRCUyMnZpZGVvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3JtJTNEQ29tcG9zZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBVbmlmb3JtVGVtcG9yYWxTdWJzYW1wbGUobnVtX2ZyYW1lc190b19zYW1wbGUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTGFtYmRhKGxhbWJkYSUyMHglM0ElMjB4JTIwJTJGJTIwMjU1LjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTm9ybWFsaXplKG1lYW4lMkMlMjBzdGQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tU2hvcnRTaWRlU2NhbGUobWluX3NpemUlM0QyNTYlMkMlMjBtYXhfc2l6ZSUzRDMyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSYW5kb21Dcm9wKHJlc2l6ZV90byklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcChwJTNEMC41KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQSUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBweXRvcmNodmlkZW8uZGF0YS5VY2YxMDEoJTBBJTIwJTIwJTIwJTIwZGF0YV9wYXRoJTNEb3MucGF0aC5qb2luKGRhdGFzZXRfcm9vdF9wYXRoJTJDJTIwJTIydHJhaW4lMjIpJTJDJTBBJTIwJTIwJTIwJTIwY2xpcF9zYW1wbGVyJTNEcHl0b3JjaHZpZGVvLmRhdGEubWFrZV9jbGlwX3NhbXBsZXIoJTIycmFuZG9tJTIyJTJDJTIwY2xpcF9kdXJhdGlvbiklMkMlMEElMjAlMjAlMjAlMjBkZWNvZGVfYXVkaW8lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybSUzRHRyYWluX3RyYW5zZm9ybSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_transform = Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        ApplyTransformToKey(
<span class="hljs-meta">... </span>            key=<span class="hljs-string">&quot;video&quot;</span>,
<span class="hljs-meta">... </span>            transform=Compose(
<span class="hljs-meta">... </span>                [
<span class="hljs-meta">... </span>                    UniformTemporalSubsample(num_frames_to_sample),
<span class="hljs-meta">... </span>                    Lambda(<span class="hljs-keyword">lambda</span> x: x / <span class="hljs-number">255.0</span>),
<span class="hljs-meta">... </span>                    Normalize(mean, std),
<span class="hljs-meta">... </span>                    RandomShortSideScale(min_size=<span class="hljs-number">256</span>, max_size=<span class="hljs-number">320</span>),
<span class="hljs-meta">... </span>                    RandomCrop(resize_to),
<span class="hljs-meta">... </span>                    RandomHorizontalFlip(p=<span class="hljs-number">0.5</span>),
<span class="hljs-meta">... </span>                ]
<span class="hljs-meta">... </span>            ),
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = pytorchvideo.data.Ucf101(
<span class="hljs-meta">... </span>    data_path=os.path.join(dataset_root_path, <span class="hljs-string">&quot;train&quot;</span>),
<span class="hljs-meta">... </span>    clip_sampler=pytorchvideo.data.make_clip_sampler(<span class="hljs-string">&quot;random&quot;</span>, clip_duration),
<span class="hljs-meta">... </span>    decode_audio=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    transform=train_transform,
<span class="hljs-meta">... </span>)`,wrap:!1}}),cs=new d({props:{code:"dmFsX3RyYW5zZm9ybSUyMCUzRCUyMENvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQXBwbHlUcmFuc2Zvcm1Ub0tleSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBrZXklM0QlMjJ2aWRlbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybSUzRENvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVW5pZm9ybVRlbXBvcmFsU3Vic2FtcGxlKG51bV9mcmFtZXNfdG9fc2FtcGxlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMExhbWJkYShsYW1iZGElMjB4JTNBJTIweCUyMCUyRiUyMDI1NS4wKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME5vcm1hbGl6ZShtZWFuJTJDJTIwc3RkKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJlc2l6ZShyZXNpemVfdG8pJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBdmFsX2RhdGFzZXQlMjAlM0QlMjBweXRvcmNodmlkZW8uZGF0YS5VY2YxMDEoJTBBJTIwJTIwJTIwJTIwZGF0YV9wYXRoJTNEb3MucGF0aC5qb2luKGRhdGFzZXRfcm9vdF9wYXRoJTJDJTIwJTIydmFsJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfc2FtcGxlciUzRHB5dG9yY2h2aWRlby5kYXRhLm1ha2VfY2xpcF9zYW1wbGVyKCUyMnVuaWZvcm0lMjIlMkMlMjBjbGlwX2R1cmF0aW9uKSUyQyUwQSUyMCUyMCUyMCUyMGRlY29kZV9hdWRpbyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtJTNEdmFsX3RyYW5zZm9ybSUyQyUwQSklMEElMEF0ZXN0X2RhdGFzZXQlMjAlM0QlMjBweXRvcmNodmlkZW8uZGF0YS5VY2YxMDEoJTBBJTIwJTIwJTIwJTIwZGF0YV9wYXRoJTNEb3MucGF0aC5qb2luKGRhdGFzZXRfcm9vdF9wYXRoJTJDJTIwJTIydGVzdCUyMiklMkMlMEElMjAlMjAlMjAlMjBjbGlwX3NhbXBsZXIlM0RweXRvcmNodmlkZW8uZGF0YS5tYWtlX2NsaXBfc2FtcGxlciglMjJ1bmlmb3JtJTIyJTJDJTIwY2xpcF9kdXJhdGlvbiklMkMlMEElMjAlMjAlMjAlMjBkZWNvZGVfYXVkaW8lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybSUzRHZhbF90cmFuc2Zvcm0lMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>val_transform = Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        ApplyTransformToKey(
<span class="hljs-meta">... </span>            key=<span class="hljs-string">&quot;video&quot;</span>,
<span class="hljs-meta">... </span>            transform=Compose(
<span class="hljs-meta">... </span>                [
<span class="hljs-meta">... </span>                    UniformTemporalSubsample(num_frames_to_sample),
<span class="hljs-meta">... </span>                    Lambda(<span class="hljs-keyword">lambda</span> x: x / <span class="hljs-number">255.0</span>),
<span class="hljs-meta">... </span>                    Normalize(mean, std),
<span class="hljs-meta">... </span>                    Resize(resize_to),
<span class="hljs-meta">... </span>                ]
<span class="hljs-meta">... </span>            ),
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>val_dataset = pytorchvideo.data.Ucf101(
<span class="hljs-meta">... </span>    data_path=os.path.join(dataset_root_path, <span class="hljs-string">&quot;val&quot;</span>),
<span class="hljs-meta">... </span>    clip_sampler=pytorchvideo.data.make_clip_sampler(<span class="hljs-string">&quot;uniform&quot;</span>, clip_duration),
<span class="hljs-meta">... </span>    decode_audio=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    transform=val_transform,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>test_dataset = pytorchvideo.data.Ucf101(
<span class="hljs-meta">... </span>    data_path=os.path.join(dataset_root_path, <span class="hljs-string">&quot;test&quot;</span>),
<span class="hljs-meta">... </span>    clip_sampler=pytorchvideo.data.make_clip_sampler(<span class="hljs-string">&quot;uniform&quot;</span>, clip_duration),
<span class="hljs-meta">... </span>    decode_audio=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    transform=val_transform,
<span class="hljs-meta">... </span>)`,wrap:!1}}),hs=new d({props:{code:"cHJpbnQodHJhaW5fZGF0YXNldC5udW1fdmlkZW9zJTJDJTIwdmFsX2RhdGFzZXQubnVtX3ZpZGVvcyUyQyUyMHRlc3RfZGF0YXNldC5udW1fdmlkZW9zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(train_dataset.num_videos, val_dataset.num_videos, test_dataset.num_videos)
<span class="hljs-comment"># (300, 30, 75)</span>`,wrap:!1}}),ds=new Ls({props:{title:"Visualize the preprocessed video for better debugging",local:"visualize-the-preprocessed-video-for-better-debugging",headingTag:"h2"}}),ws=new d({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> imageio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">unnormalize_img</span>(<span class="hljs-params">img</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Un-normalizes the image pixels.&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    img = (img * std) + mean
<span class="hljs-meta">... </span>    img = (img * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> img.clip(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_gif</span>(<span class="hljs-params">video_tensor, filename=<span class="hljs-string">&quot;sample.gif&quot;</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Prepares a GIF from a video tensor.
<span class="hljs-meta">... </span>    
<span class="hljs-meta">... </span>    The video tensor is expected to have the following shape:
<span class="hljs-meta">... </span>    (num_frames, num_channels, height, width).
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> video_frame <span class="hljs-keyword">in</span> video_tensor:
<span class="hljs-meta">... </span>        frame_unnormalized = unnormalize_img(video_frame.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>).numpy())
<span class="hljs-meta">... </span>        frames.append(frame_unnormalized)
<span class="hljs-meta">... </span>    kargs = {<span class="hljs-string">&quot;duration&quot;</span>: <span class="hljs-number">0.25</span>}
<span class="hljs-meta">... </span>    imageio.mimsave(filename, frames, <span class="hljs-string">&quot;GIF&quot;</span>, **kargs)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> filename

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">display_gif</span>(<span class="hljs-params">video_tensor, gif_name=<span class="hljs-string">&quot;sample.gif&quot;</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Prepares and displays a GIF from a video tensor.&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    video_tensor = video_tensor.permute(<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>)
<span class="hljs-meta">... </span>    gif_filename = create_gif(video_tensor, gif_name)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> Image(filename=gif_filename)

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_video = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(train_dataset))
<span class="hljs-meta">&gt;&gt;&gt; </span>video_tensor = sample_video[<span class="hljs-string">&quot;video&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>display_gif(video_tensor)`,wrap:!1}}),Js=new Ls({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),Us=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjBtb2RlbF9ja3B0LnNwbGl0KCUyMiUyRiUyMiklNUItMSU1RCUwQW5ld19tb2RlbF9uYW1lJTIwJTNEJTIwZiUyMiU3Qm1vZGVsX25hbWUlN0QtZmluZXR1bmVkLXVjZjEwMS1zdWJzZXQlMjIlMEFudW1fZXBvY2hzJTIwJTNEJTIwNCUwQSUwQWFyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBuZXdfbW9kZWxfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV9zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDVlLTUlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3JhdGlvJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9iZXN0X21vZGVsX2F0X2VuZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBtZXRyaWNfZm9yX2Jlc3RfbW9kZWwlM0QlMjJhY2N1cmFjeSUyMiUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRCh0cmFpbl9kYXRhc2V0Lm51bV92aWRlb3MlMjAlMkYlMkYlMjBiYXRjaF9zaXplKSUyMColMjBudW1fZXBvY2hzJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = model_ckpt.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>new_model_name = <span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>-finetuned-ucf101-subset&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_epochs = <span class="hljs-number">4</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>args = TrainingArguments(
<span class="hljs-meta">... </span>    new_model_name,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
<span class="hljs-meta">... </span>    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">5e-5</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=batch_size,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=batch_size,
<span class="hljs-meta">... </span>    warmup_ratio=<span class="hljs-number">0.1</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    metric_for_best_model=<span class="hljs-string">&quot;accuracy&quot;</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    max_steps=(train_dataset.num_videos // batch_size) * num_epochs,
<span class="hljs-meta">... </span>)`,wrap:!1}}),bs=new d({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmFjY3VyYWN5JTIyKSUwQSUwQSUwQWRlZiUyMGNvbXB1dGVfbWV0cmljcyhldmFsX3ByZWQpJTNBJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgoZXZhbF9wcmVkLnByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RldmFsX3ByZWQubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions = np.argmax(eval_pred.predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=eval_pred.label_ids)`,wrap:!1}}),vs=new d({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBwZXJtdXRlJTIwdG8lMjAobnVtX2ZyYW1lcyUyQyUyMG51bV9jaGFubmVscyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoKSUwQSUyMCUyMCUyMCUyMHBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnN0YWNrKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmV4YW1wbGUlNUIlMjJ2aWRlbyUyMiU1RC5wZXJtdXRlKDElMkMlMjAwJTJDJTIwMiUyQyUyMDMpJTIwZm9yJTIwZXhhbXBsZSUyMGluJTIwZXhhbXBsZXMlNUQlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QmV4YW1wbGUlNUIlMjJsYWJlbCUyMiU1RCUyMGZvciUyMGV4YW1wbGUlMjBpbiUyMGV4YW1wbGVzJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnBpeGVsX3ZhbHVlcyUyMiUzQSUyMHBpeGVsX3ZhbHVlcyUyQyUyMCUyMmxhYmVscyUyMiUzQSUyMGxhYmVscyU3RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># permute to (num_frames, num_channels, height, width)</span>
<span class="hljs-meta">... </span>    pixel_values = torch.stack(
<span class="hljs-meta">... </span>        [example[<span class="hljs-string">&quot;video&quot;</span>].permute(<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>) <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    labels = torch.tensor([example[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: labels}`,wrap:!1}}),Gs=new d({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRGltYWdlX3Byb2Nlc3NvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRlX2ZuJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model,
<span class="hljs-meta">... </span>    args,
<span class="hljs-meta">... </span>    train_dataset=train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=val_dataset,
<span class="hljs-meta">... </span>    tokenizer=image_processor,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>    data_collator=collate_fn,
<span class="hljs-meta">... </span>)`,wrap:!1}}),_s=new d({props:{code:"dHJhaW5fcmVzdWx0cyUyMCUzRCUyMHRyYWluZXIudHJhaW4oKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>train_results = trainer.train()',wrap:!1}}),ks=new d({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),Vs=new Ls({props:{title:"Inference",local:"inference",headingTag:"h2"}}),$s=new d({props:{code:"c2FtcGxlX3Rlc3RfdmlkZW8lMjAlM0QlMjBuZXh0KGl0ZXIodGVzdF9kYXRhc2V0KSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>sample_test_video = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(test_dataset))',wrap:!1}}),Fs=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlkZW9fY2xzJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJteV9hd2Vzb21lX3ZpZGVvX2Nsc19tb2RlbCUyMiklMEF2aWRlb19jbHMoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGc2F5YWtwYXVsJTJGdWNmMTAxLXN1YnNldCUyRnJlc29sdmUlMkZtYWluJTJGdl9CYXNrZXRiYWxsRHVua19nMTRfYzA2LmF2aSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>video_cls = pipeline(model=<span class="hljs-string">&quot;my_awesome_video_cls_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video_cls(<span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/ucf101-subset/resolve/main/v_BasketballDunk_g14_c06.avi&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9272987842559814</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BasketballDunk&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.017777055501937866</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BabyCrawling&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.01663011871278286</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BalanceBeam&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.009560945443809032</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BandMarching&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0068979403004050255</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BaseballPitch&#x27;</span>}]`,wrap:!1}}),Ys=new d({props:{code:"ZGVmJTIwcnVuX2luZmVyZW5jZShtb2RlbCUyQyUyMHZpZGVvKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMChudW1fZnJhbWVzJTJDJTIwbnVtX2NoYW5uZWxzJTJDJTIwaGVpZ2h0JTJDJTIwd2lkdGgpJTBBJTIwJTIwJTIwJTIwcGVydW11dGVkX3NhbXBsZV90ZXN0X3ZpZGVvJTIwJTNEJTIwdmlkZW8ucGVybXV0ZSgxJTJDJTIwMCUyQyUyMDIlMkMlMjAzKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpeGVsX3ZhbHVlcyUyMiUzQSUyMHBlcnVtdXRlZF9zYW1wbGVfdGVzdF92aWRlby51bnNxdWVlemUoMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYWJlbHMlMjIlM0ElMjB0b3JjaC50ZW5zb3IoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCc2FtcGxlX3Rlc3RfdmlkZW8lNUIlMjJsYWJlbCUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMjAlMjAlMjMlMjB0aGlzJTIwY2FuJTIwYmUlMjBza2lwcGVkJTIwaWYlMjB5b3UlMjBkb24ndCUyMGhhdmUlMjBsYWJlbHMlMjBhdmFpbGFibGUuJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG1vZGVsLnRvKGRldmljZSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBmb3J3YXJkJTIwcGFzcyUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">run_inference</span>(<span class="hljs-params">model, video</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># (num_frames, num_channels, height, width)</span>
<span class="hljs-meta">... </span>    perumuted_sample_test_video = video.permute(<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>)
<span class="hljs-meta">... </span>    inputs = {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;pixel_values&quot;</span>: perumuted_sample_test_video.unsqueeze(<span class="hljs-number">0</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;labels&quot;</span>: torch.tensor(
<span class="hljs-meta">... </span>            [sample_test_video[<span class="hljs-string">&quot;label&quot;</span>]]
<span class="hljs-meta">... </span>        ),  <span class="hljs-comment"># this can be skipped if you don&#x27;t have labels available.</span>
<span class="hljs-meta">... </span>    }

<span class="hljs-meta">... </span>    device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">... </span>    inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
<span class="hljs-meta">... </span>    model = model.to(device)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        outputs = model(**inputs)
<span class="hljs-meta">... </span>        logits = outputs.logits

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> logits`,wrap:!1}}),Es=new d({props:{code:"bG9naXRzJTIwJTNEJTIwcnVuX2luZmVyZW5jZSh0cmFpbmVkX21vZGVsJTJDJTIwc2FtcGxlX3Rlc3RfdmlkZW8lNUIlMjJ2aWRlbyUyMiU1RCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>logits = run_inference(trained_model, sample_test_video[<span class="hljs-string">&quot;video&quot;</span>])',wrap:!1}}),Ns=new d({props:{code:"cHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
<span class="hljs-comment"># Predicted class: BasketballDunk</span>`,wrap:!1}}),Hs=new Aa({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/video_classification.md"}}),{c(){w=p("meta"),u=t(),J=p("p"),qs=t(),M(f.$$.fragment),Ps=t(),M(b.$$.fragment),Os=t(),I=p("p"),I.textContent=Ge,sl=t(),g=p("p"),g.textContent=We,ll=t(),C=p("ol"),C.innerHTML=Be,el=t(),M(j.$$.fragment),al=t(),v=p("p"),v.textContent=_e,tl=t(),M(Z.$$.fragment),nl=t(),G=p("p"),G.innerHTML=Ae,pl=t(),W=p("p"),W.textContent=ke,il=t(),M(B.$$.fragment),ol=t(),M(_.$$.fragment),Ml=t(),A=p("p"),A.innerHTML=Ve,ml=t(),M(k.$$.fragment),cl=t(),V=p("p"),V.textContent=Re,yl=t(),M(R.$$.fragment),rl=t(),x=p("p"),x.textContent=xe,hl=t(),M($.$$.fragment),dl=t(),X=p("p"),X.innerHTML=$e,wl=t(),M(F.$$.fragment),Jl=t(),z=p("p"),z.innerHTML=Xe,jl=t(),Y=p("p"),Y.innerHTML=Fe,Tl=t(),S=p("p"),S.textContent=ze,Ul=t(),E=p("ul"),E.innerHTML=Ye,ul=t(),M(Q.$$.fragment),fl=t(),N=p("p"),N.textContent=Se,bl=t(),M(H.$$.fragment),Il=t(),L=p("p"),L.textContent=Ee,gl=t(),M(q.$$.fragment),Cl=t(),D=p("p"),D.textContent=Qe,vl=t(),M(K.$$.fragment),Zl=t(),P=p("p"),P.innerHTML=Ne,Gl=t(),O=p("p"),O.innerHTML=He,Wl=t(),M(ss.$$.fragment),Bl=t(),ls=p("p"),ls.innerHTML=Le,_l=t(),M(es.$$.fragment),Al=t(),as=p("p"),as.innerHTML=qe,kl=t(),ts=p("p"),ts.innerHTML=De,Vl=t(),ns=p("ul"),ns.innerHTML=Ke,Rl=t(),ps=p("p"),ps.textContent=Pe,xl=t(),M(is.$$.fragment),$l=t(),os=p("p"),os.textContent=Oe,Xl=t(),M(Ms.$$.fragment),Fl=t(),ms=p("p"),ms.textContent=sa,zl=t(),M(cs.$$.fragment),Yl=t(),ys=p("p"),ys.innerHTML=la,Sl=t(),rs=p("p"),rs.innerHTML=ea,El=t(),M(hs.$$.fragment),Ql=t(),M(ds.$$.fragment),Nl=t(),M(ws.$$.fragment),Hl=t(),T=p("div"),T.innerHTML=aa,Ll=t(),M(Js.$$.fragment),ql=t(),js=p("p"),js.innerHTML=ta,Dl=t(),Ts=p("p"),Ts.innerHTML=na,Kl=t(),M(Us.$$.fragment),Pl=t(),us=p("p"),us.innerHTML=pa,Ol=t(),fs=p("p"),fs.innerHTML=ia,se=t(),M(bs.$$.fragment),le=t(),Is=p("p"),Is.innerHTML=oa,ee=t(),gs=p("p"),gs.innerHTML=Ma,ae=t(),Cs=p("p"),Cs.innerHTML=ma,te=t(),M(vs.$$.fragment),ne=t(),Zs=p("p"),Zs.innerHTML=ca,pe=t(),M(Gs.$$.fragment),ie=t(),Ws=p("p"),Ws.innerHTML=ya,oe=t(),Bs=p("p"),Bs.innerHTML=ra,Me=t(),M(_s.$$.fragment),me=t(),As=p("p"),As.innerHTML=ha,ce=t(),M(ks.$$.fragment),ye=t(),M(Vs.$$.fragment),re=t(),Rs=p("p"),Rs.textContent=da,he=t(),xs=p("p"),xs.textContent=wa,de=t(),M($s.$$.fragment),we=t(),U=p("div"),U.innerHTML=Ja,Je=t(),Xs=p("p"),Xs.innerHTML=ja,je=t(),M(Fs.$$.fragment),Te=t(),zs=p("p"),zs.innerHTML=Ta,Ue=t(),M(Ys.$$.fragment),ue=t(),Ss=p("p"),Ss.innerHTML=Ua,fe=t(),M(Es.$$.fragment),be=t(),Qs=p("p"),Qs.innerHTML=ua,Ie=t(),M(Ns.$$.fragment),ge=t(),M(Hs.$$.fragment),Ce=t(),Ds=p("p"),this.h()},l(s){const l=Ga("svelte-u9bgzb",document.head);w=i(l,"META",{name:!0,content:!0}),l.forEach(e),u=n(s),J=i(s,"P",{}),ba(J).forEach(e),qs=n(s),m(f.$$.fragment,s),Ps=n(s),m(b.$$.fragment,s),Os=n(s),I=i(s,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1uw5n59"&&(I.textContent=Ge),sl=n(s),g=i(s,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1aff4p7"&&(g.textContent=We),ll=n(s),C=i(s,"OL",{"data-svelte-h":!0}),o(C)!=="svelte-1qfvs25"&&(C.innerHTML=Be),el=n(s),m(j.$$.fragment,s),al=n(s),v=i(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1c9nexd"&&(v.textContent=_e),tl=n(s),m(Z.$$.fragment,s),nl=n(s),G=i(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-cnicg0"&&(G.innerHTML=Ae),pl=n(s),W=i(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-27hn0u"&&(W.textContent=ke),il=n(s),m(B.$$.fragment,s),ol=n(s),m(_.$$.fragment,s),Ml=n(s),A=i(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-zo4tpc"&&(A.innerHTML=Ve),ml=n(s),m(k.$$.fragment,s),cl=n(s),V=i(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-yyrc6l"&&(V.textContent=Re),yl=n(s),m(R.$$.fragment,s),rl=n(s),x=i(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-vxwx6z"&&(x.textContent=xe),hl=n(s),m($.$$.fragment,s),dl=n(s),X=i(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-xl39ap"&&(X.innerHTML=$e),wl=n(s),m(F.$$.fragment,s),Jl=n(s),z=i(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1t7u230"&&(z.innerHTML=Xe),jl=n(s),Y=i(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-igo46q"&&(Y.innerHTML=Fe),Tl=n(s),S=i(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-4ll1ff"&&(S.textContent=ze),Ul=n(s),E=i(s,"UL",{"data-svelte-h":!0}),o(E)!=="svelte-1y0n38a"&&(E.innerHTML=Ye),ul=n(s),m(Q.$$.fragment,s),fl=n(s),N=i(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1z0r2k5"&&(N.textContent=Se),bl=n(s),m(H.$$.fragment,s),Il=n(s),L=i(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-14088fx"&&(L.textContent=Ee),gl=n(s),m(q.$$.fragment,s),Cl=n(s),D=i(s,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1rauzal"&&(D.textContent=Qe),vl=n(s),m(K.$$.fragment,s),Zl=n(s),P=i(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-19dkvgp"&&(P.innerHTML=Ne),Gl=n(s),O=i(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-nk737h"&&(O.innerHTML=He),Wl=n(s),m(ss.$$.fragment,s),Bl=n(s),ls=i(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-islfqt"&&(ls.innerHTML=Le),_l=n(s),m(es.$$.fragment,s),Al=n(s),as=i(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-5m4gle"&&(as.innerHTML=qe),kl=n(s),ts=i(s,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-8w7a7w"&&(ts.innerHTML=De),Vl=n(s),ns=i(s,"UL",{"data-svelte-h":!0}),o(ns)!=="svelte-u2neln"&&(ns.innerHTML=Ke),Rl=n(s),ps=i(s,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-llv4fi"&&(ps.textContent=Pe),xl=n(s),m(is.$$.fragment,s),$l=n(s),os=i(s,"P",{"data-svelte-h":!0}),o(os)!=="svelte-1lr33l4"&&(os.textContent=Oe),Xl=n(s),m(Ms.$$.fragment,s),Fl=n(s),ms=i(s,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-92qkhv"&&(ms.textContent=sa),zl=n(s),m(cs.$$.fragment,s),Yl=n(s),ys=i(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-lyltai"&&(ys.innerHTML=la),Sl=n(s),rs=i(s,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-1vli4t8"&&(rs.innerHTML=ea),El=n(s),m(hs.$$.fragment,s),Ql=n(s),m(ds.$$.fragment,s),Nl=n(s),m(ws.$$.fragment,s),Hl=n(s),T=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-1mxsghh"&&(T.innerHTML=aa),Ll=n(s),m(Js.$$.fragment,s),ql=n(s),js=i(s,"P",{"data-svelte-h":!0}),o(js)!=="svelte-rirkpj"&&(js.innerHTML=ta),Dl=n(s),Ts=i(s,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-ixq0kp"&&(Ts.innerHTML=na),Kl=n(s),m(Us.$$.fragment,s),Pl=n(s),us=i(s,"P",{"data-svelte-h":!0}),o(us)!=="svelte-1v50sum"&&(us.innerHTML=pa),Ol=n(s),fs=i(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-1kbaooa"&&(fs.innerHTML=ia),se=n(s),m(bs.$$.fragment,s),le=n(s),Is=i(s,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-1yc7v5f"&&(Is.innerHTML=oa),ee=n(s),gs=i(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-9bk5j6"&&(gs.innerHTML=Ma),ae=n(s),Cs=i(s,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-1csqroh"&&(Cs.innerHTML=ma),te=n(s),m(vs.$$.fragment,s),ne=n(s),Zs=i(s,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-16wl6hd"&&(Zs.innerHTML=ca),pe=n(s),m(Gs.$$.fragment,s),ie=n(s),Ws=i(s,"P",{"data-svelte-h":!0}),o(Ws)!=="svelte-g6wg27"&&(Ws.innerHTML=ya),oe=n(s),Bs=i(s,"P",{"data-svelte-h":!0}),o(Bs)!=="svelte-umxz0w"&&(Bs.innerHTML=ra),Me=n(s),m(_s.$$.fragment,s),me=n(s),As=i(s,"P",{"data-svelte-h":!0}),o(As)!=="svelte-1v13hlo"&&(As.innerHTML=ha),ce=n(s),m(ks.$$.fragment,s),ye=n(s),m(Vs.$$.fragment,s),re=n(s),Rs=i(s,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-riodtu"&&(Rs.textContent=da),he=n(s),xs=i(s,"P",{"data-svelte-h":!0}),o(xs)!=="svelte-w1spga"&&(xs.textContent=wa),de=n(s),m($s.$$.fragment,s),we=n(s),U=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-556htt"&&(U.innerHTML=Ja),Je=n(s),Xs=i(s,"P",{"data-svelte-h":!0}),o(Xs)!=="svelte-e8z0ag"&&(Xs.innerHTML=ja),je=n(s),m(Fs.$$.fragment,s),Te=n(s),zs=i(s,"P",{"data-svelte-h":!0}),o(zs)!=="svelte-1j33lbi"&&(zs.innerHTML=Ta),Ue=n(s),m(Ys.$$.fragment,s),ue=n(s),Ss=i(s,"P",{"data-svelte-h":!0}),o(Ss)!=="svelte-12olihs"&&(Ss.innerHTML=Ua),fe=n(s),m(Es.$$.fragment,s),be=n(s),Qs=i(s,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-1v8qszj"&&(Qs.innerHTML=ua),Ie=n(s),m(Ns.$$.fragment,s),ge=n(s),m(Hs.$$.fragment,s),Ce=n(s),Ds=i(s,"P",{}),ba(Ds).forEach(e),this.h()},h(){Ze(w,"name","hf:doc:metadata"),Ze(w,"content",Ra),Ze(T,"class","flex justify-center"),Ze(U,"class","flex justify-center")},m(s,l){Wa(document.head,w),a(s,u,l),a(s,J,l),a(s,qs,l),c(f,s,l),a(s,Ps,l),c(b,s,l),a(s,Os,l),a(s,I,l),a(s,sl,l),a(s,g,l),a(s,ll,l),a(s,C,l),a(s,el,l),c(j,s,l),a(s,al,l),a(s,v,l),a(s,tl,l),c(Z,s,l),a(s,nl,l),a(s,G,l),a(s,pl,l),a(s,W,l),a(s,il,l),c(B,s,l),a(s,ol,l),c(_,s,l),a(s,Ml,l),a(s,A,l),a(s,ml,l),c(k,s,l),a(s,cl,l),a(s,V,l),a(s,yl,l),c(R,s,l),a(s,rl,l),a(s,x,l),a(s,hl,l),c($,s,l),a(s,dl,l),a(s,X,l),a(s,wl,l),c(F,s,l),a(s,Jl,l),a(s,z,l),a(s,jl,l),a(s,Y,l),a(s,Tl,l),a(s,S,l),a(s,Ul,l),a(s,E,l),a(s,ul,l),c(Q,s,l),a(s,fl,l),a(s,N,l),a(s,bl,l),c(H,s,l),a(s,Il,l),a(s,L,l),a(s,gl,l),c(q,s,l),a(s,Cl,l),a(s,D,l),a(s,vl,l),c(K,s,l),a(s,Zl,l),a(s,P,l),a(s,Gl,l),a(s,O,l),a(s,Wl,l),c(ss,s,l),a(s,Bl,l),a(s,ls,l),a(s,_l,l),c(es,s,l),a(s,Al,l),a(s,as,l),a(s,kl,l),a(s,ts,l),a(s,Vl,l),a(s,ns,l),a(s,Rl,l),a(s,ps,l),a(s,xl,l),c(is,s,l),a(s,$l,l),a(s,os,l),a(s,Xl,l),c(Ms,s,l),a(s,Fl,l),a(s,ms,l),a(s,zl,l),c(cs,s,l),a(s,Yl,l),a(s,ys,l),a(s,Sl,l),a(s,rs,l),a(s,El,l),c(hs,s,l),a(s,Ql,l),c(ds,s,l),a(s,Nl,l),c(ws,s,l),a(s,Hl,l),a(s,T,l),a(s,Ll,l),c(Js,s,l),a(s,ql,l),a(s,js,l),a(s,Dl,l),a(s,Ts,l),a(s,Kl,l),c(Us,s,l),a(s,Pl,l),a(s,us,l),a(s,Ol,l),a(s,fs,l),a(s,se,l),c(bs,s,l),a(s,le,l),a(s,Is,l),a(s,ee,l),a(s,gs,l),a(s,ae,l),a(s,Cs,l),a(s,te,l),c(vs,s,l),a(s,ne,l),a(s,Zs,l),a(s,pe,l),c(Gs,s,l),a(s,ie,l),a(s,Ws,l),a(s,oe,l),a(s,Bs,l),a(s,Me,l),c(_s,s,l),a(s,me,l),a(s,As,l),a(s,ce,l),c(ks,s,l),a(s,ye,l),c(Vs,s,l),a(s,re,l),a(s,Rs,l),a(s,he,l),a(s,xs,l),a(s,de,l),c($s,s,l),a(s,we,l),a(s,U,l),a(s,Je,l),a(s,Xs,l),a(s,je,l),c(Fs,s,l),a(s,Te,l),a(s,zs,l),a(s,Ue,l),c(Ys,s,l),a(s,ue,l),a(s,Ss,l),a(s,fe,l),c(Es,s,l),a(s,be,l),a(s,Qs,l),a(s,Ie,l),c(Ns,s,l),a(s,ge,l),c(Hs,s,l),a(s,Ce,l),a(s,Ds,l),ve=!0},p(s,[l]){const fa={};l&2&&(fa.$$scope={dirty:l,ctx:s}),j.$set(fa)},i(s){ve||(y(f.$$.fragment,s),y(b.$$.fragment,s),y(j.$$.fragment,s),y(Z.$$.fragment,s),y(B.$$.fragment,s),y(_.$$.fragment,s),y(k.$$.fragment,s),y(R.$$.fragment,s),y($.$$.fragment,s),y(F.$$.fragment,s),y(Q.$$.fragment,s),y(H.$$.fragment,s),y(q.$$.fragment,s),y(K.$$.fragment,s),y(ss.$$.fragment,s),y(es.$$.fragment,s),y(is.$$.fragment,s),y(Ms.$$.fragment,s),y(cs.$$.fragment,s),y(hs.$$.fragment,s),y(ds.$$.fragment,s),y(ws.$$.fragment,s),y(Js.$$.fragment,s),y(Us.$$.fragment,s),y(bs.$$.fragment,s),y(vs.$$.fragment,s),y(Gs.$$.fragment,s),y(_s.$$.fragment,s),y(ks.$$.fragment,s),y(Vs.$$.fragment,s),y($s.$$.fragment,s),y(Fs.$$.fragment,s),y(Ys.$$.fragment,s),y(Es.$$.fragment,s),y(Ns.$$.fragment,s),y(Hs.$$.fragment,s),ve=!0)},o(s){r(f.$$.fragment,s),r(b.$$.fragment,s),r(j.$$.fragment,s),r(Z.$$.fragment,s),r(B.$$.fragment,s),r(_.$$.fragment,s),r(k.$$.fragment,s),r(R.$$.fragment,s),r($.$$.fragment,s),r(F.$$.fragment,s),r(Q.$$.fragment,s),r(H.$$.fragment,s),r(q.$$.fragment,s),r(K.$$.fragment,s),r(ss.$$.fragment,s),r(es.$$.fragment,s),r(is.$$.fragment,s),r(Ms.$$.fragment,s),r(cs.$$.fragment,s),r(hs.$$.fragment,s),r(ds.$$.fragment,s),r(ws.$$.fragment,s),r(Js.$$.fragment,s),r(Us.$$.fragment,s),r(bs.$$.fragment,s),r(vs.$$.fragment,s),r(Gs.$$.fragment,s),r(_s.$$.fragment,s),r(ks.$$.fragment,s),r(Vs.$$.fragment,s),r($s.$$.fragment,s),r(Fs.$$.fragment,s),r(Ys.$$.fragment,s),r(Es.$$.fragment,s),r(Ns.$$.fragment,s),r(Hs.$$.fragment,s),ve=!1},d(s){s&&(e(u),e(J),e(qs),e(Ps),e(Os),e(I),e(sl),e(g),e(ll),e(C),e(el),e(al),e(v),e(tl),e(nl),e(G),e(pl),e(W),e(il),e(ol),e(Ml),e(A),e(ml),e(cl),e(V),e(yl),e(rl),e(x),e(hl),e(dl),e(X),e(wl),e(Jl),e(z),e(jl),e(Y),e(Tl),e(S),e(Ul),e(E),e(ul),e(fl),e(N),e(bl),e(Il),e(L),e(gl),e(Cl),e(D),e(vl),e(Zl),e(P),e(Gl),e(O),e(Wl),e(Bl),e(ls),e(_l),e(Al),e(as),e(kl),e(ts),e(Vl),e(ns),e(Rl),e(ps),e(xl),e($l),e(os),e(Xl),e(Fl),e(ms),e(zl),e(Yl),e(ys),e(Sl),e(rs),e(El),e(Ql),e(Nl),e(Hl),e(T),e(Ll),e(ql),e(js),e(Dl),e(Ts),e(Kl),e(Pl),e(us),e(Ol),e(fs),e(se),e(le),e(Is),e(ee),e(gs),e(ae),e(Cs),e(te),e(ne),e(Zs),e(pe),e(ie),e(Ws),e(oe),e(Bs),e(Me),e(me),e(As),e(ce),e(ye),e(re),e(Rs),e(he),e(xs),e(de),e(we),e(U),e(Je),e(Xs),e(je),e(Te),e(zs),e(Ue),e(ue),e(Ss),e(fe),e(be),e(Qs),e(Ie),e(ge),e(Ce),e(Ds)),e(w),h(f,s),h(b,s),h(j,s),h(Z,s),h(B,s),h(_,s),h(k,s),h(R,s),h($,s),h(F,s),h(Q,s),h(H,s),h(q,s),h(K,s),h(ss,s),h(es,s),h(is,s),h(Ms,s),h(cs,s),h(hs,s),h(ds,s),h(ws,s),h(Js,s),h(Us,s),h(bs,s),h(vs,s),h(Gs,s),h(_s,s),h(ks,s),h(Vs,s),h($s,s),h(Fs,s),h(Ys,s),h(Es,s),h(Ns,s),h(Hs,s)}}}const Ra='{"title":"Video classification","local":"video-classification","sections":[{"title":"Load UCF101 dataset","local":"load-ucf101-dataset","sections":[],"depth":2},{"title":"Load a model to fine-tune","local":"load-a-model-to-fine-tune","sections":[],"depth":2},{"title":"Prepare the datasets for training","local":"prepare-the-datasets-for-training","sections":[],"depth":2},{"title":"Visualize the preprocessed video for better debugging","local":"visualize-the-preprocessed-video-for-better-debugging","sections":[],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function xa(Ks){return ga(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ea extends va{constructor(w){super(),Za(this,w,xa,Va,Ia,{})}}export{Ea as component};
