import{s as ma,n as ja,o as ha}from"../chunks/scheduler.9bc65507.js";import{S as ya,i as Ma,g as p,s as n,r,A as oa,h as i,f as t,c as e,j as Fs,u as m,x as c,k as ra,y as U,a,v as j,d as h,t as y,w as M}from"../chunks/index.707bf1b6.js";import{C as g}from"../chunks/CodeBlock.54a9f38d.js";import{H as o}from"../chunks/Heading.342b1fa6.js";function ga(Ut){let u,_s,Xs,Ss,x,As,T,xt="🤗 Transformersは、自然言語処理（NLP）、コンピュータビジョン、音声処理などの最新の事前学習済みモデルのライブラリです。このライブラリには、Transformerモデルだけでなく、コンピュータビジョンタスク向けのモダンな畳み込みニューラルネットワークなど、Transformer以外のモデルも含まれています。現代のスマートフォン、アプリ、テレビなど、最も人気のある消費者製品の多くには、深層学習技術が使用されています。スマートフォンで撮影した写真から背景オブジェクトを削除したいですか？これはパノプティック・セグメンテーション（まだ何を意味するかわからなくても心配しないでください、以下のセクションで説明します！）のタスクの一例です。",Ls,b,Tt="このページでは、🤗 Transformersライブラリを使用して、たった3行のコードで解決できるさまざまな音声および音声、コンピュータビジョン、NLPタスクの概要を提供します！",Ps,d,Ks,w,bt="音声と音声処理のタスクは、他のモダリティとは少し異なります。なぜなら、入力としての生の音声波形は連続的な信号であるからです。テキストとは異なり、生の音声波形は文章を単語に分割できるようにきれいに分割できません。これを解決するために、通常、生の音声信号は定期的な間隔でサンプリングされます。間隔内でより多くのサンプルを取ると、サンプリングレートが高くなり、音声はより元の音声ソースに近づきます。",Ds,f,dt="以前のアプローチでは、音声を前処理してそれから有用な特徴を抽出しました。しかし、現在では、生の音声波形を特徴エンコーダに直接フィードし、音声表現を抽出することから始めることが一般的です。これにより、前処理ステップが簡素化され、モデルは最も重要な特徴を学習できます。",Os,C,sl,Z,wt="音声分類は、事前に定義されたクラスのセットから音声データにラベルを付けるタスクです。これは多くの具体的なアプリケーションを含む広範なカテゴリであり、いくつかの例は次のとおりです：",ll,I,ft="<li>音響シーン分類：音声にシーンラベルを付ける（「オフィス」、「ビーチ」、「スタジアム」）</li> <li>音響イベント検出：音声に音声イベントラベルを付ける（「車のクラクション」、「クジラの呼び声」、「ガラスの破裂」）</li> <li>タギング：複数の音を含む音声にラベルを付ける（鳥の鳴き声、会議でのスピーカー識別）</li> <li>音楽分類：音楽にジャンルラベルを付ける（「メタル」、「ヒップホップ」、「カントリー」）</li>",tl,B,al,$,nl,W,Ct="自動音声認識（ASR）は音声をテキストに変換します。これは、人間のコミュニケーションの自然な形式である音声の一部として、部分的にそのような一般的なオーディオタスクの一つです。今日、ASRシステムはスピーカー、スマートフォン、自動車などの「スマート」テクノロジープロダクトに組み込まれています。私たちは仮想アシスタントに音楽を再生してもらったり、リマインダーを設定してもらったり、天気を教えてもらったりできます。",el,G,Zt="しかし、Transformerアーキテクチャが助けた主要な課題の一つは、低リソース言語におけるものです。大量の音声データで事前トレーニングし、低リソース言語でラベル付き音声データをわずか1時間だけでファインチューニングすることでも、以前のASRシステムと比較して高品質な結果を得ることができます。以前のASRシステムは100倍以上のラベル付きデータでトレーニングされていましたが、Transformerアーキテクチャはこの問題に貢献しました。",pl,k,il,H,cl,q,It='最初で初めて成功したコンピュータビジョンのタスクの一つは、<a href="glossary#convolution">畳み込みニューラルネットワーク（CNN）</a>を使用して郵便番号の画像を認識することでした。画像はピクセルから構成され、各ピクセルには数値があります。これにより、画像をピクセル値の行列として簡単に表現できます。特定のピクセル値の組み合わせは、画像の色を記述します。',rl,v,Bt="コンピュータビジョンのタスクを解決する一般的な方法は次の2つです：",ml,V,$t="<li>畳み込みを使用して、低レベルの特徴から高レベルの抽象的な情報まで、画像の階層的な特徴を学習する。</li> <li>画像をパッチに分割し、各画像パッチが画像全体とどのように関連しているかを徐々に学習するためにTransformerを使用する。CNNが好むボトムアップアプローチとは異なり、これはぼんやりとした画像から始めて徐々に焦点を合わせるようなものです。</li>",jl,N,hl,R,Wt="画像分類は、事前に定義されたクラスのセットから画像全体にラベルを付けます。多くの分類タスクと同様に、画像分類には多くの実用的な用途があり、その一部は次のとおりです：",yl,z,Gt="<li>医療：疾患の検出や患者の健康の監視に使用するために医療画像にラベルを付ける</li> <li>環境：森林伐採の監視、野生地の管理情報、または山火事の検出に使用するために衛星画像にラベルを付ける</li> <li>農業：作物の健康を監視するための作物の画像や、土地利用の監視のための衛星画像にラベルを付ける</li> <li>生態学：野生動物の個体数を監視したり、絶滅危惧種を追跡するために動植物の種の画像にラベルを付ける</li>",Ml,Q,ol,Y,gl,X,kt="画像分類とは異なり、オブジェクト検出は画像内の複数のオブジェクトを識別し、オブジェクトの位置を画像内で定義する境界ボックスによって特定します。オブジェクト検出の例には次のような用途があります：",ul,E,Ht="<li>自動運転車：他の車両、歩行者、信号機などの日常の交通オブジェクトを検出</li> <li>リモートセンシング：災害モニタリング、都市計画、天候予測</li> <li>欠陥検出：建物のクラックや構造上の損傷、製造上の欠陥を検出</li>",Jl,F,Ul,_,xl,S,qt="画像セグメンテーションは、画像内のすべてのピクセルをクラスに割り当てるピクセルレベルのタスクです。これはオブジェクト検出とは異なり、オブジェクトをラベル付けし、予測するために境界ボックスを使用する代わりに、セグメンテーションはより詳細になります。セグメンテーションはピクセルレベルでオブジェクトを検出できます。画像セグメンテーションにはいくつかのタイプがあります：",Tl,A,vt="<li>インスタンスセグメンテーション：オブジェクトのクラスをラベル付けするだけでなく、オブジェクトの個別のインスタンス（“犬-1”、“犬-2”）もラベル付けします。</li> <li>パノプティックセグメンテーション：セマンティックセグメンテーションとインスタンスセグメンテーションの組み合わせ。セマンティッククラスごとに各ピクセルにラベルを付け、オブジェクトの個別のインスタンスもラベル付けします。</li>",bl,L,Vt="セグメンテーションタスクは、自動運転車にとって、周囲の世界のピクセルレベルのマップを作成し、歩行者や他の車両を安全に回避できるようにするのに役立ちます。また、医療画像では、タスクの細かい粒度が異常な細胞や臓器の特徴を識別するのに役立ちます。画像セグメンテーションは、eコマースで衣類を仮想的に試着したり、カメラを通じて実世界にオブジェクトを重ねて拡張現実の体験を作成したりするためにも使用できます。",dl,P,wl,K,fl,D,Nt="深度推定は、画像内の各ピクセルがカメラからの距離を予測します。このコンピュータビジョンタスクは、特にシーンの理解と再構築に重要です。たとえば、自動運転車では、歩行者、交通標識、他の車などの物体がどれだけ遠いかを理解し、障害物や衝突を回避するために必要です。深度情報はまた、2D画像から3D表現を構築し、生物学的構造や建物の高品質な3D表現を作成するのに役立ちます。",Cl,O,Rt="深度推定には次の2つのアプローチがあります：",Zl,ss,zt="<li>ステレオ：深度は、わずかに異なる角度からの同じ画像の2つの画像を比較して推定されます。</li> <li>モノキュラー：深度は単一の画像から推定されます。</li>",Il,ls,Bl,ts,$l,as,Qt="NLPタスクは、テキストが私たちにとって自然なコミュニケーション手段であるため、最も一般的なタスクの一つです。モデルが認識するための形式にテキストを変換するには、トークン化が必要です。これは、テキストのシーケンスを単語やサブワード（トークン）に分割し、それらのトークンを数字に変換することを意味します。その結果、テキストのシーケンスを数字のシーケンスとして表現し、一度数字のシーケンスがあれば、さまざまなNLPタスクを解決するためにモデルに入力できます！",Wl,ns,Gl,es,Yt="どんなモダリティの分類タスクと同様に、テキスト分類は事前に定義されたクラスのセットからテキストのシーケンス（文レベル、段落、またはドキュメントであることがあります）にラベルを付けます。テキスト分類には多くの実用的な用途があり、その一部は次のとおりです：",kl,ps,Xt="<li>感情分析：<code>positive</code>や<code>negative</code>のような極性に従ってテキストにラベルを付け、政治、金融、マーケティングなどの分野での意思決定をサポートします。</li> <li>コンテンツ分類：テキストをトピックに従ってラベル付けし、ニュースやソーシャルメディアのフィード内の情報を整理し、フィルタリングするのに役立ちます（<code>天気</code>、<code>スポーツ</code>、<code>金融</code>など）。</li>",Hl,is,ql,cs,vl,rs,Et='どんなNLPタスクでも、テキストはテキストのシーケンスを個々の単語やサブワードに分割して前処理されます。これらは<a href="/glossary#token">トークン</a>として知られています。トークン分類は、事前に定義されたクラスのセットから各トークンにラベルを割り当てます。',Vl,ms,Ft="トークン分類の一般的なタイプは次の2つです：",Nl,js,_t="<li>固有表現認識（NER）：組織、人物、場所、日付などのエンティティのカテゴリに従ってトークンにラベルを付けます。NERは特にバイオメディカル環境で人気であり、遺伝子、タンパク質、薬物名などをラベル付けできます。</li> <li>品詞タグ付け（POS）：名詞、動詞、形容詞などの品詞に従ってトークンにラベルを付けます。POSは、翻訳システムが同じ単語が文法的にどのように異なるかを理解するのに役立ちます（名詞としての「銀行」と動詞としての「銀行」など）。</li>",Rl,hs,zl,ys,Ql,Ms,St="質問応答は、コンテキスト（オープンドメイン）を含む場合と含まない場合（クローズドドメイン）がある場合もある、別のトークンレベルのタスクで、質問に対する回答を返します。このタスクは、仮想アシスタントにレストランが営業しているかどうかのような質問をするときに発生します。また、顧客や技術サポートを提供し、検索エンジンがあなたが求めている関連情報を取得するのにも役立ちます。",Yl,os,At="質問応答の一般的なタイプは次の2つです：",Xl,gs,Lt='<li>抽出型：質問と一部のコンテキストが与えられた場合、モデルがコンテキストから抽出する必要のあるテキストのスパンが回答となります。</li> <li>抽象的：質問と一部のコンテキストが与えられた場合、回答はコンテキストから生成されます。このアプローチは、<a href="/docs/transformers/main/ja/main_classes/pipelines#transformers.QuestionAnsweringPipeline">QuestionAnsweringPipeline</a>ではなく<a href="/docs/transformers/main/ja/main_classes/pipelines#transformers.Text2TextGenerationPipeline">Text2TextGenerationPipeline</a>で処理されます。</li>',El,us,Fl,Js,_l,Us,Pt="要約は、長いテキストから短いバージョンを作成し、元の文書の意味の大部分を保ちながら試みるタスクです。要約はシーケンスからシーケンスへのタスクであり、入力よりも短いテキストシーケンスを出力します。要約を行うことで、読者が主要なポイントを迅速に理解できるようにするのに役立つ長文書がたくさんあります。法案、法的および財務文書、特許、科学論文など、読者の時間を節約し読書の支援となる文書の例があります。",Sl,xs,Kt="質問応答と同様に、要約には2つのタイプがあります：",Al,Ts,Dt='<li>抽出的要約：元のテキストから最も重要な文を識別して抽出します。</li> <li>抽象的要約：元のテキストからターゲットの要約（入力文書に含まれていない新しい単語を含むことがあります）を生成します。<a href="/docs/transformers/main/ja/main_classes/pipelines#transformers.SummarizationPipeline">SummarizationPipeline</a>は抽象的なアプローチを使用しています。</li>',Ll,bs,Pl,ds,Kl,ws,Ot="翻訳は、ある言語のテキストシーケンスを別の言語に変換する作業です。これは異なるバックグラウンドを持つ人々がコミュニケーションをとるのに役立ち、広範な観客にコンテンツを翻訳して伝えるのに役立ち、新しい言語を学ぶのを支援する学習ツールにもなります。要約と共に、翻訳はシーケンス間のタスクであり、モデルは入力シーケンスを受け取り、ターゲットの出力シーケンスを返します。",Dl,fs,sa="初期の翻訳モデルは主に単一言語でしたが、最近では多言語モデルに対する関心が高まり、多くの言語対で翻訳できるような多言語モデルに注目が集まっています。",Ol,Cs,st,Zs,lt,Is,la="言語モデリングは、テキストのシーケンス内の単語を予測するタスクです。事前学習された言語モデルは、多くの他のダウンストリームタスクに対してファインチューニングできるため、非常に人気のあるNLPタスクとなっています。最近では、ゼロショットまたはフューショット学習を実証する大規模な言語モデル（LLM）に大きな関心が寄せられています。これは、モデルが明示的にトレーニングされていないタスクを解決できることを意味します！言語モデルは、流暢で説得力のあるテキストを生成するために使用できますが、テキストが常に正確であるわけではないため、注意が必要です。",tt,Bs,ta="言語モデリングには2つのタイプがあります：",at,J,$s,Qs,aa="因果的：モデルの目標は、シーケンス内の次のトークンを予測することであり、将来のトークンはマスクされます。",gt,Ws,ut,Gs,Ys,na="マスクされた：モデルの目的は、シーケンス内のトークン全体にアクセスしながら、シーケンス内のマスクされたトークンを予測することです。",Jt,ks,nt,Hs,et,qs,ea="マルチモーダルタスクは、特定の問題を解決するために複数のデータモダリティ（テキスト、画像、音声、ビデオ）を処理するためにモデルを必要とします。画像キャプショニングは、モデルが入力として画像を受け取り、画像を説明するテキストのシーケンスまたは画像のいくつかの特性を出力するマルチモーダルタスクの例です。",pt,vs,pa="マルチモーダルモデルは異なるデータタイプまたはモダリティで作業しますが、内部的には前処理ステップがモデルにすべてのデータタイプを埋め込み（データに関する意味のある情報を保持するベクトルまたは数字のリスト）に変換するのを支援します。画像キャプショニングのようなタスクでは、モデルは画像の埋め込みとテキストの埋め込みの間の関係を学習します。",it,Vs,ct,Ns,ia="ドキュメント質問応答は、ドキュメントからの自然言語の質問に答えるタスクです。テキストを入力とするトークンレベルの質問応答タスクとは異なり、ドキュメント質問応答はドキュメントの画像とそのドキュメントに関する質問を受け取り、答えを返します。ドキュメント質問応答は構造化されたドキュメントを解析し、それから重要な情報を抽出するために使用できます。以下の例では、レシートから合計金額とお釣りを抽出することができます。",rt,Rs,mt,zs,ca='このページが各モダリティのタスクの種類とそれぞれの重要性についての追加の背景情報を提供できたことを願っています。次の <a href="tasks_explained">セクション</a> では、🤗 トランスフォーマーがこれらのタスクを解決するために <strong>どのように</strong> 動作するかを学びます。',jt,Es,ht;return x=new o({props:{title:"What 🤗 Transformers can do",local:"what--transformers-can-do",headingTag:"h1"}}),d=new o({props:{title:"Audio",local:"audio",headingTag:"h2"}}),C=new o({props:{title:"Audio classification",local:"audio-classification",headingTag:"h3"}}),B=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyc3VwZXJiJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWVyJTIyKSUwQXByZWRzJTIwJTNEJTIwY2xhc3NpZmllciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKSUwQXByZWRzJTIwJTNEJTIwJTVCJTdCJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwcHJlZCU1QiUyMmxhYmVsJTIyJTVEJTdEJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlNUQlMEFwcmVkcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;superb/hubert-base-superb-er&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4532</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;hap&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.3622</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sad&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0943</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;neu&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0903</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;ang&#x27;</span>}]`,wrap:!1}}),$=new o({props:{title:"Automatic speech recognition",local:"automatic-speech-recognition",headingTag:"h3"}}),k=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMiklMEF0cmFuc2NyaWJlciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>}`,wrap:!1}}),H=new o({props:{title:"Computer vision",local:"computer-vision",headingTag:"h2"}}),N=new o({props:{title:"Image classification",local:"image-classification",headingTag:"h3"}}),Q=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMGNsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByaW50KCpwcmVkcyUyQyUyMHNlcCUzRCUyMiU1Q24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}`,wrap:!1}}),Y=new o({props:{title:"Object detection",local:"object-detection",headingTag:"h3"}}),F=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGV0ZWN0b3IlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyb2JqZWN0LWRldGVjdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMGRldGVjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBpcGVsaW5lLWNhdC1jaG9uay5qcGVnJTIyJTBBKSUwQXByZWRzJTIwJTNEJTIwJTVCJTdCJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwcHJlZCU1QiUyMmxhYmVsJTIyJTVEJTJDJTIwJTIyYm94JTIyJTNBJTIwcHJlZCU1QiUyMmJveCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(task=<span class="hljs-string">&quot;object-detection&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = detector(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>], <span class="hljs-string">&quot;box&quot;</span>: pred[<span class="hljs-string">&quot;box&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9865</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">178</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">154</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">882</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">598</span>}}]`,wrap:!1}}),_=new o({props:{title:"Image segmentation",local:"image-segmentation",headingTag:"h3"}}),P=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLXNlZ21lbnRhdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMHNlZ21lbnRlciglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXBlbGluZS1jYXQtY2hvbmsuanBlZyUyMiUwQSklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJpbnQoKnByZWRzJTJDJTIwc2VwJTNEJTIyJTVDbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>segmenter = pipeline(task=<span class="hljs-string">&quot;image-segmentation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = segmenter(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9879</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;LABEL_184&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9973</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9972</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>}`,wrap:!1}}),K=new o({props:{title:"Depth estimation",local:"depth-estimation",headingTag:"h3"}}),ls=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmRlcHRoLWVzdGltYXRpb24lMjIpJTBBcHJlZHMlMjAlM0QlMjBkZXB0aF9lc3RpbWF0b3IoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>depth_estimator = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = depth_estimator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ts=new o({props:{title:"Natural language processing",local:"natural-language-processing",headingTag:"h2"}}),ns=new o({props:{title:"Text classification",local:"text-classification",headingTag:"h3"}}),is=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJzZW50aW1lbnQtYW5hbHlzaXMlMjIpJTBBcHJlZHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjB0aGUlMjBiZXN0JTIwdGhpbmclMjBzaW5jZSUyMHNsaWNlZCUyMGJyZWFkISUyMiklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;sentiment-analysis&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;Hugging Face is the best thing since sliced bread!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9991</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;POSITIVE&#x27;</span>}]`,wrap:!1}}),cs=new o({props:{title:"Token classification",local:"token-classification",headingTag:"h3"}}),hs=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJuZXIlMjIpJTBBcHJlZHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwRnJlbmNoJTIwY29tcGFueSUyMGJhc2VkJTIwaW4lMjBOZXclMjBZb3JrJTIwQ2l0eS4lMjIpJTBBcHJlZHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnRpdHklMjIlM0ElMjBwcmVkJTVCJTIyZW50aXR5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmluZGV4JTIyJTNBJTIwcHJlZCU1QiUyMmluZGV4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd29yZCUyMiUzQSUyMHByZWQlNUIlMjJ3b3JkJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhcnQlMjIlM0ElMjBwcmVkJTVCJTIyc3RhcnQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmQlMjIlM0ElMjBwcmVkJTVCJTIyZW5kJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlMEElNUQlMEFwcmludCgqcHJlZHMlMkMlMjBzZXAlM0QlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;ner&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;Hugging Face is a French company based in New York City.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;entity&quot;</span>: pred[<span class="hljs-string">&quot;entity&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;index&quot;</span>: pred[<span class="hljs-string">&quot;index&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;word&quot;</span>: pred[<span class="hljs-string">&quot;word&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;start&quot;</span>: pred[<span class="hljs-string">&quot;start&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;end&quot;</span>: pred[<span class="hljs-string">&quot;end&quot;</span>],
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9968</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;Hu&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">2</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9293</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;##gging&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">7</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9763</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;Face&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">8</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">12</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-MISC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9983</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">6</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;French&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">18</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">24</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;New&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">42</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">45</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9987</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;York&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">46</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">50</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9992</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">12</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;City&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">51</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">55</span>}`,wrap:!1}}),ys=new o({props:{title:"Question answering",local:"question-answering",headingTag:"h3"}}),us=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcXVlc3Rpb25fYW5zd2VyZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyKSUwQXByZWRzJTIwJTNEJTIwcXVlc3Rpb25fYW5zd2VyZXIoJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjByZXBvc2l0b3J5JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzRCUyMlRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMHJlcG9zaXRvcnklMjBpcyUyMGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJTIyJTJDJTBBKSUwQXByaW50KCUwQSUyMCUyMCUyMCUyMGYlMjJzY29yZSUzQSUyMCU3QnJvdW5kKHByZWRzJTVCJ3Njb3JlJyU1RCUyQyUyMDQpJTdEJTJDJTIwc3RhcnQlM0ElMjAlN0JwcmVkcyU1QidzdGFydCclNUQlN0QlMkMlMjBlbmQlM0ElMjAlN0JwcmVkcyU1QidlbmQnJTVEJTdEJTJDJTIwYW5zd2VyJTNBJTIwJTdCcHJlZHMlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>question_answerer = pipeline(task=<span class="hljs-string">&quot;question-answering&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = question_answerer(
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the name of the repository?&quot;</span>,
<span class="hljs-meta">... </span>    context=<span class="hljs-string">&quot;The name of the repository is huggingface/transformers&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;score: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(preds[<span class="hljs-string">&#x27;score&#x27;</span>], <span class="hljs-number">4</span>)}</span>, start: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;start&#x27;</span>]}</span>, end: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;end&#x27;</span>]}</span>, answer: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
<span class="hljs-meta">... </span>)
score: <span class="hljs-number">0.9327</span>, start: <span class="hljs-number">30</span>, end: <span class="hljs-number">54</span>, answer: huggingface/transformers`,wrap:!1}}),Js=new o({props:{title:"Summarization",local:"summarization",headingTag:"h3"}}),bs=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc3VtbWFyaXplciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJzdW1tYXJpemF0aW9uJTIyKSUwQXN1bW1hcml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIySW4lMjB0aGlzJTIwd29yayUyQyUyMHdlJTIwcHJlc2VudGVkJTIwdGhlJTIwVHJhbnNmb3JtZXIlMkMlMjB0aGUlMjBmaXJzdCUyMHNlcXVlbmNlJTIwdHJhbnNkdWN0aW9uJTIwbW9kZWwlMjBiYXNlZCUyMGVudGlyZWx5JTIwb24lMjBhdHRlbnRpb24lMkMlMjByZXBsYWNpbmclMjB0aGUlMjByZWN1cnJlbnQlMjBsYXllcnMlMjBtb3N0JTIwY29tbW9ubHklMjB1c2VkJTIwaW4lMjBlbmNvZGVyLWRlY29kZXIlMjBhcmNoaXRlY3R1cmVzJTIwd2l0aCUyMG11bHRpLWhlYWRlZCUyMHNlbGYtYXR0ZW50aW9uLiUyMEZvciUyMHRyYW5zbGF0aW9uJTIwdGFza3MlMkMlMjB0aGUlMjBUcmFuc2Zvcm1lciUyMGNhbiUyMGJlJTIwdHJhaW5lZCUyMHNpZ25pZmljYW50bHklMjBmYXN0ZXIlMjB0aGFuJTIwYXJjaGl0ZWN0dXJlcyUyMGJhc2VkJTIwb24lMjByZWN1cnJlbnQlMjBvciUyMGNvbnZvbHV0aW9uYWwlMjBsYXllcnMuJTIwT24lMjBib3RoJTIwV01UJTIwMjAxNCUyMEVuZ2xpc2gtdG8tR2VybWFuJTIwYW5kJTIwV01UJTIwMjAxNCUyMEVuZ2xpc2gtdG8tRnJlbmNoJTIwdHJhbnNsYXRpb24lMjB0YXNrcyUyQyUyMHdlJTIwYWNoaWV2ZSUyMGElMjBuZXclMjBzdGF0ZSUyMG9mJTIwdGhlJTIwYXJ0LiUyMEluJTIwdGhlJTIwZm9ybWVyJTIwdGFzayUyMG91ciUyMGJlc3QlMjBtb2RlbCUyMG91dHBlcmZvcm1zJTIwZXZlbiUyMGFsbCUyMHByZXZpb3VzbHklMjByZXBvcnRlZCUyMGVuc2VtYmxlcy4lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>summarizer = pipeline(task=<span class="hljs-string">&quot;summarization&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summarizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;In this work, we presented the Transformer, the first sequence transduction model based entirely on attention, replacing the recurrent layers most commonly used in encoder-decoder architectures with multi-headed self-attention. For translation tasks, the Transformer can be trained significantly faster than architectures based on recurrent or convolutional layers. On both WMT 2014 English-to-German and WMT 2014 English-to-French translation tasks, we achieve a new state of the art. In the former task our best model outperforms even all previously reported ensembles.&quot;</span>
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;summary_text&#x27;</span>: <span class="hljs-string">&#x27; The Transformer is the first sequence transduction model based entirely on attention . It replaces the recurrent layers most commonly used in encoder-decoder architectures with multi-headed self-attention . For translation tasks, the Transformer can be trained significantly faster than architectures based on recurrent or convolutional layers .&#x27;</span>}]`,wrap:!1}}),ds=new o({props:{title:"Translation",local:"translation",headingTag:"h3"}}),Cs=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdGV4dCUyMCUzRCUyMCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMEZyZW5jaCUzQSUyMEh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tbXVuaXR5LWJhc2VkJTIwb3Blbi1zb3VyY2UlMjBwbGF0Zm9ybSUyMGZvciUyMG1hY2hpbmUlMjBsZWFybmluZy4lMjIlMEF0cmFuc2xhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRyYW5zbGF0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJnb29nbGUtdDUlMkZ0NS1zbWFsbCUyMiklMEF0cmFuc2xhdG9yKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;translate English to French: Hugging Face is a community-based open-source platform for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>translator = pipeline(task=<span class="hljs-string">&quot;translation&quot;</span>, model=<span class="hljs-string">&quot;google-t5/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>translator(text)
[{<span class="hljs-string">&#x27;translation_text&#x27;</span>: <span class="hljs-string">&quot;Hugging Face est une tribune communautaire de l&#x27;apprentissage des machines.&quot;</span>}]`,wrap:!1}}),Zs=new o({props:{title:"言語モデリング",local:"言語モデリング",headingTag:"h3"}}),Ws=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySHVnZ2luZyUyMEZhY2UlMjBpcyUyMGElMjBjb21tdW5pdHktYmFzZWQlMjBvcGVuLXNvdXJjZSUyMHBsYXRmb3JtJTIwZm9yJTIwbWFjaGluZSUyMGxlYXJuaW5nLiUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIpJTBBZ2VuZXJhdG9yKHByb21wdCklMjAlMjAlMjMlMjBkb2N0ZXN0JTNBJTIwJTJCU0tJUA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hugging Face is a community-based open-source platform for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(prompt)  <span class="hljs-comment"># doctest: +SKIP</span>`,wrap:!1}}),ks=new g({props:{code:"dGV4dCUyMCUzRCUyMCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tbXVuaXR5LWJhc2VkJTIwb3Blbi1zb3VyY2UlMjAlM0NtYXNrJTNFJTIwZm9yJTIwbWFjaGluZSUyMGxlYXJuaW5nLiUyMiUwQWZpbGxfbWFzayUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJmaWxsLW1hc2slMjIpJTBBcHJlZHMlMjAlM0QlMjBmaWxsX21hc2sodGV4dCUyQyUyMHRvcF9rJTNEMSklMEFwcmVkcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b2tlbiUyMiUzQSUyMHByZWQlNUIlMjJ0b2tlbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRva2VuX3N0ciUyMiUzQSUyMHByZWQlNUIlMjJ0b2tlbl9zdHIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzZXF1ZW5jZSUyMiUzQSUyMHByZWQlNUIlMjJzZXF1ZW5jZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTBBJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hugging Face is a community-based open-source &lt;mask&gt; for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_mask = pipeline(task=<span class="hljs-string">&quot;fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = fill_mask(text, top_k=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;token&quot;</span>: pred[<span class="hljs-string">&quot;token&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;token_str&quot;</span>: pred[<span class="hljs-string">&quot;token_str&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;sequence&quot;</span>: pred[<span class="hljs-string">&quot;sequence&quot;</span>],
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.2236</span>,
  <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">1761</span>,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27; platform&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hugging Face is a community-based open-source platform for machine learning.&#x27;</span>}]`,wrap:!1}}),Hs=new o({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),Vs=new o({props:{title:"Document question answering",local:"document-question-answering",headingTag:"h3"}}),Rs=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZXhhbXBsZS1kb2N1bWVudHMlMkZyZXNvbHZlJTJGbWFpbiUyRmpwZWdfaW1hZ2VzJTJGMi5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFkb2NfcXVlc3Rpb25fYW5zd2VyZXIlMjAlM0QlMjBwaXBlbGluZSglMjJkb2N1bWVudC1xdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMjBtb2RlbCUzRCUyMm1hZ29yc2h1bm92JTJGbGF5b3V0bG0taW52b2ljZXMlMjIpJTBBcHJlZHMlMjAlM0QlMjBkb2NfcXVlc3Rpb25fYW5zd2VyZXIoJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjB0b3RhbCUyMGFtb3VudCUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEEpJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/example-documents/resolve/main/jpeg_images/2.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>doc_question_answerer = pipeline(<span class="hljs-string">&quot;document-question-answering&quot;</span>, model=<span class="hljs-string">&quot;magorshunov/layoutlm-invoices&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = doc_question_answerer(
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the total amount?&quot;</span>,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.8531</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;17,000&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">4</span>}]`,wrap:!1}}),{c(){u=p("meta"),_s=n(),Xs=p("p"),Ss=n(),r(x.$$.fragment),As=n(),T=p("p"),T.textContent=xt,Ls=n(),b=p("p"),b.textContent=Tt,Ps=n(),r(d.$$.fragment),Ks=n(),w=p("p"),w.textContent=bt,Ds=n(),f=p("p"),f.textContent=dt,Os=n(),r(C.$$.fragment),sl=n(),Z=p("p"),Z.textContent=wt,ll=n(),I=p("ul"),I.innerHTML=ft,tl=n(),r(B.$$.fragment),al=n(),r($.$$.fragment),nl=n(),W=p("p"),W.textContent=Ct,el=n(),G=p("p"),G.textContent=Zt,pl=n(),r(k.$$.fragment),il=n(),r(H.$$.fragment),cl=n(),q=p("p"),q.innerHTML=It,rl=n(),v=p("p"),v.textContent=Bt,ml=n(),V=p("ol"),V.innerHTML=$t,jl=n(),r(N.$$.fragment),hl=n(),R=p("p"),R.textContent=Wt,yl=n(),z=p("ul"),z.innerHTML=Gt,Ml=n(),r(Q.$$.fragment),ol=n(),r(Y.$$.fragment),gl=n(),X=p("p"),X.textContent=kt,ul=n(),E=p("ul"),E.innerHTML=Ht,Jl=n(),r(F.$$.fragment),Ul=n(),r(_.$$.fragment),xl=n(),S=p("p"),S.textContent=qt,Tl=n(),A=p("ul"),A.innerHTML=vt,bl=n(),L=p("p"),L.textContent=Vt,dl=n(),r(P.$$.fragment),wl=n(),r(K.$$.fragment),fl=n(),D=p("p"),D.textContent=Nt,Cl=n(),O=p("p"),O.textContent=Rt,Zl=n(),ss=p("ul"),ss.innerHTML=zt,Il=n(),r(ls.$$.fragment),Bl=n(),r(ts.$$.fragment),$l=n(),as=p("p"),as.textContent=Qt,Wl=n(),r(ns.$$.fragment),Gl=n(),es=p("p"),es.textContent=Yt,kl=n(),ps=p("ul"),ps.innerHTML=Xt,Hl=n(),r(is.$$.fragment),ql=n(),r(cs.$$.fragment),vl=n(),rs=p("p"),rs.innerHTML=Et,Vl=n(),ms=p("p"),ms.textContent=Ft,Nl=n(),js=p("ul"),js.innerHTML=_t,Rl=n(),r(hs.$$.fragment),zl=n(),r(ys.$$.fragment),Ql=n(),Ms=p("p"),Ms.textContent=St,Yl=n(),os=p("p"),os.textContent=At,Xl=n(),gs=p("ul"),gs.innerHTML=Lt,El=n(),r(us.$$.fragment),Fl=n(),r(Js.$$.fragment),_l=n(),Us=p("p"),Us.textContent=Pt,Sl=n(),xs=p("p"),xs.textContent=Kt,Al=n(),Ts=p("ul"),Ts.innerHTML=Dt,Ll=n(),r(bs.$$.fragment),Pl=n(),r(ds.$$.fragment),Kl=n(),ws=p("p"),ws.textContent=Ot,Dl=n(),fs=p("p"),fs.textContent=sa,Ol=n(),r(Cs.$$.fragment),st=n(),r(Zs.$$.fragment),lt=n(),Is=p("p"),Is.textContent=la,tt=n(),Bs=p("p"),Bs.textContent=ta,at=n(),J=p("ul"),$s=p("li"),Qs=p("p"),Qs.textContent=aa,gt=n(),r(Ws.$$.fragment),ut=n(),Gs=p("li"),Ys=p("p"),Ys.textContent=na,Jt=n(),r(ks.$$.fragment),nt=n(),r(Hs.$$.fragment),et=n(),qs=p("p"),qs.textContent=ea,pt=n(),vs=p("p"),vs.textContent=pa,it=n(),r(Vs.$$.fragment),ct=n(),Ns=p("p"),Ns.textContent=ia,rt=n(),r(Rs.$$.fragment),mt=n(),zs=p("p"),zs.innerHTML=ca,jt=n(),Es=p("p"),this.h()},l(s){const l=oa("svelte-u9bgzb",document.head);u=i(l,"META",{name:!0,content:!0}),l.forEach(t),_s=e(s),Xs=i(s,"P",{}),Fs(Xs).forEach(t),Ss=e(s),m(x.$$.fragment,s),As=e(s),T=i(s,"P",{"data-svelte-h":!0}),c(T)!=="svelte-ek4mfb"&&(T.textContent=xt),Ls=e(s),b=i(s,"P",{"data-svelte-h":!0}),c(b)!=="svelte-1rw5e2u"&&(b.textContent=Tt),Ps=e(s),m(d.$$.fragment,s),Ks=e(s),w=i(s,"P",{"data-svelte-h":!0}),c(w)!=="svelte-15dyqe4"&&(w.textContent=bt),Ds=e(s),f=i(s,"P",{"data-svelte-h":!0}),c(f)!=="svelte-lal6en"&&(f.textContent=dt),Os=e(s),m(C.$$.fragment,s),sl=e(s),Z=i(s,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1k2664o"&&(Z.textContent=wt),ll=e(s),I=i(s,"UL",{"data-svelte-h":!0}),c(I)!=="svelte-1qvj2e6"&&(I.innerHTML=ft),tl=e(s),m(B.$$.fragment,s),al=e(s),m($.$$.fragment,s),nl=e(s),W=i(s,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1m26psw"&&(W.textContent=Ct),el=e(s),G=i(s,"P",{"data-svelte-h":!0}),c(G)!=="svelte-r87y6j"&&(G.textContent=Zt),pl=e(s),m(k.$$.fragment,s),il=e(s),m(H.$$.fragment,s),cl=e(s),q=i(s,"P",{"data-svelte-h":!0}),c(q)!=="svelte-18036m9"&&(q.innerHTML=It),rl=e(s),v=i(s,"P",{"data-svelte-h":!0}),c(v)!=="svelte-ymmeyz"&&(v.textContent=Bt),ml=e(s),V=i(s,"OL",{"data-svelte-h":!0}),c(V)!=="svelte-v4gh81"&&(V.innerHTML=$t),jl=e(s),m(N.$$.fragment,s),hl=e(s),R=i(s,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1mp36i8"&&(R.textContent=Wt),yl=e(s),z=i(s,"UL",{"data-svelte-h":!0}),c(z)!=="svelte-j3igwn"&&(z.innerHTML=Gt),Ml=e(s),m(Q.$$.fragment,s),ol=e(s),m(Y.$$.fragment,s),gl=e(s),X=i(s,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1xlgwtm"&&(X.textContent=kt),ul=e(s),E=i(s,"UL",{"data-svelte-h":!0}),c(E)!=="svelte-vyf034"&&(E.innerHTML=Ht),Jl=e(s),m(F.$$.fragment,s),Ul=e(s),m(_.$$.fragment,s),xl=e(s),S=i(s,"P",{"data-svelte-h":!0}),c(S)!=="svelte-ryfffz"&&(S.textContent=qt),Tl=e(s),A=i(s,"UL",{"data-svelte-h":!0}),c(A)!=="svelte-1rz6dd1"&&(A.innerHTML=vt),bl=e(s),L=i(s,"P",{"data-svelte-h":!0}),c(L)!=="svelte-rbr5j5"&&(L.textContent=Vt),dl=e(s),m(P.$$.fragment,s),wl=e(s),m(K.$$.fragment,s),fl=e(s),D=i(s,"P",{"data-svelte-h":!0}),c(D)!=="svelte-qofxu2"&&(D.textContent=Nt),Cl=e(s),O=i(s,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1npln10"&&(O.textContent=Rt),Zl=e(s),ss=i(s,"UL",{"data-svelte-h":!0}),c(ss)!=="svelte-1i4tid3"&&(ss.innerHTML=zt),Il=e(s),m(ls.$$.fragment,s),Bl=e(s),m(ts.$$.fragment,s),$l=e(s),as=i(s,"P",{"data-svelte-h":!0}),c(as)!=="svelte-1m59zxk"&&(as.textContent=Qt),Wl=e(s),m(ns.$$.fragment,s),Gl=e(s),es=i(s,"P",{"data-svelte-h":!0}),c(es)!=="svelte-1a39rcj"&&(es.textContent=Yt),kl=e(s),ps=i(s,"UL",{"data-svelte-h":!0}),c(ps)!=="svelte-1wx0y2z"&&(ps.innerHTML=Xt),Hl=e(s),m(is.$$.fragment,s),ql=e(s),m(cs.$$.fragment,s),vl=e(s),rs=i(s,"P",{"data-svelte-h":!0}),c(rs)!=="svelte-mrs7ie"&&(rs.innerHTML=Et),Vl=e(s),ms=i(s,"P",{"data-svelte-h":!0}),c(ms)!=="svelte-l02yas"&&(ms.textContent=Ft),Nl=e(s),js=i(s,"UL",{"data-svelte-h":!0}),c(js)!=="svelte-109mihx"&&(js.innerHTML=_t),Rl=e(s),m(hs.$$.fragment,s),zl=e(s),m(ys.$$.fragment,s),Ql=e(s),Ms=i(s,"P",{"data-svelte-h":!0}),c(Ms)!=="svelte-edc05x"&&(Ms.textContent=St),Yl=e(s),os=i(s,"P",{"data-svelte-h":!0}),c(os)!=="svelte-1vhjwqv"&&(os.textContent=At),Xl=e(s),gs=i(s,"UL",{"data-svelte-h":!0}),c(gs)!=="svelte-10yichi"&&(gs.innerHTML=Lt),El=e(s),m(us.$$.fragment,s),Fl=e(s),m(Js.$$.fragment,s),_l=e(s),Us=i(s,"P",{"data-svelte-h":!0}),c(Us)!=="svelte-oh104g"&&(Us.textContent=Pt),Sl=e(s),xs=i(s,"P",{"data-svelte-h":!0}),c(xs)!=="svelte-1i939bz"&&(xs.textContent=Kt),Al=e(s),Ts=i(s,"UL",{"data-svelte-h":!0}),c(Ts)!=="svelte-txq2y6"&&(Ts.innerHTML=Dt),Ll=e(s),m(bs.$$.fragment,s),Pl=e(s),m(ds.$$.fragment,s),Kl=e(s),ws=i(s,"P",{"data-svelte-h":!0}),c(ws)!=="svelte-1eoa6ft"&&(ws.textContent=Ot),Dl=e(s),fs=i(s,"P",{"data-svelte-h":!0}),c(fs)!=="svelte-fyu2t"&&(fs.textContent=sa),Ol=e(s),m(Cs.$$.fragment,s),st=e(s),m(Zs.$$.fragment,s),lt=e(s),Is=i(s,"P",{"data-svelte-h":!0}),c(Is)!=="svelte-ts71z3"&&(Is.textContent=la),tt=e(s),Bs=i(s,"P",{"data-svelte-h":!0}),c(Bs)!=="svelte-ph2wi1"&&(Bs.textContent=ta),at=e(s),J=i(s,"UL",{});var yt=Fs(J);$s=i(yt,"LI",{});var Mt=Fs($s);Qs=i(Mt,"P",{"data-svelte-h":!0}),c(Qs)!=="svelte-e09crk"&&(Qs.textContent=aa),gt=e(Mt),m(Ws.$$.fragment,Mt),Mt.forEach(t),ut=e(yt),Gs=i(yt,"LI",{});var ot=Fs(Gs);Ys=i(ot,"P",{"data-svelte-h":!0}),c(Ys)!=="svelte-1vyw9g3"&&(Ys.textContent=na),Jt=e(ot),m(ks.$$.fragment,ot),ot.forEach(t),yt.forEach(t),nt=e(s),m(Hs.$$.fragment,s),et=e(s),qs=i(s,"P",{"data-svelte-h":!0}),c(qs)!=="svelte-9np98f"&&(qs.textContent=ea),pt=e(s),vs=i(s,"P",{"data-svelte-h":!0}),c(vs)!=="svelte-miuti3"&&(vs.textContent=pa),it=e(s),m(Vs.$$.fragment,s),ct=e(s),Ns=i(s,"P",{"data-svelte-h":!0}),c(Ns)!=="svelte-1q7jq3c"&&(Ns.textContent=ia),rt=e(s),m(Rs.$$.fragment,s),mt=e(s),zs=i(s,"P",{"data-svelte-h":!0}),c(zs)!=="svelte-1ik2fe4"&&(zs.innerHTML=ca),jt=e(s),Es=i(s,"P",{}),Fs(Es).forEach(t),this.h()},h(){ra(u,"name","hf:doc:metadata"),ra(u,"content",ua)},m(s,l){U(document.head,u),a(s,_s,l),a(s,Xs,l),a(s,Ss,l),j(x,s,l),a(s,As,l),a(s,T,l),a(s,Ls,l),a(s,b,l),a(s,Ps,l),j(d,s,l),a(s,Ks,l),a(s,w,l),a(s,Ds,l),a(s,f,l),a(s,Os,l),j(C,s,l),a(s,sl,l),a(s,Z,l),a(s,ll,l),a(s,I,l),a(s,tl,l),j(B,s,l),a(s,al,l),j($,s,l),a(s,nl,l),a(s,W,l),a(s,el,l),a(s,G,l),a(s,pl,l),j(k,s,l),a(s,il,l),j(H,s,l),a(s,cl,l),a(s,q,l),a(s,rl,l),a(s,v,l),a(s,ml,l),a(s,V,l),a(s,jl,l),j(N,s,l),a(s,hl,l),a(s,R,l),a(s,yl,l),a(s,z,l),a(s,Ml,l),j(Q,s,l),a(s,ol,l),j(Y,s,l),a(s,gl,l),a(s,X,l),a(s,ul,l),a(s,E,l),a(s,Jl,l),j(F,s,l),a(s,Ul,l),j(_,s,l),a(s,xl,l),a(s,S,l),a(s,Tl,l),a(s,A,l),a(s,bl,l),a(s,L,l),a(s,dl,l),j(P,s,l),a(s,wl,l),j(K,s,l),a(s,fl,l),a(s,D,l),a(s,Cl,l),a(s,O,l),a(s,Zl,l),a(s,ss,l),a(s,Il,l),j(ls,s,l),a(s,Bl,l),j(ts,s,l),a(s,$l,l),a(s,as,l),a(s,Wl,l),j(ns,s,l),a(s,Gl,l),a(s,es,l),a(s,kl,l),a(s,ps,l),a(s,Hl,l),j(is,s,l),a(s,ql,l),j(cs,s,l),a(s,vl,l),a(s,rs,l),a(s,Vl,l),a(s,ms,l),a(s,Nl,l),a(s,js,l),a(s,Rl,l),j(hs,s,l),a(s,zl,l),j(ys,s,l),a(s,Ql,l),a(s,Ms,l),a(s,Yl,l),a(s,os,l),a(s,Xl,l),a(s,gs,l),a(s,El,l),j(us,s,l),a(s,Fl,l),j(Js,s,l),a(s,_l,l),a(s,Us,l),a(s,Sl,l),a(s,xs,l),a(s,Al,l),a(s,Ts,l),a(s,Ll,l),j(bs,s,l),a(s,Pl,l),j(ds,s,l),a(s,Kl,l),a(s,ws,l),a(s,Dl,l),a(s,fs,l),a(s,Ol,l),j(Cs,s,l),a(s,st,l),j(Zs,s,l),a(s,lt,l),a(s,Is,l),a(s,tt,l),a(s,Bs,l),a(s,at,l),a(s,J,l),U(J,$s),U($s,Qs),U($s,gt),j(Ws,$s,null),U(J,ut),U(J,Gs),U(Gs,Ys),U(Gs,Jt),j(ks,Gs,null),a(s,nt,l),j(Hs,s,l),a(s,et,l),a(s,qs,l),a(s,pt,l),a(s,vs,l),a(s,it,l),j(Vs,s,l),a(s,ct,l),a(s,Ns,l),a(s,rt,l),j(Rs,s,l),a(s,mt,l),a(s,zs,l),a(s,jt,l),a(s,Es,l),ht=!0},p:ja,i(s){ht||(h(x.$$.fragment,s),h(d.$$.fragment,s),h(C.$$.fragment,s),h(B.$$.fragment,s),h($.$$.fragment,s),h(k.$$.fragment,s),h(H.$$.fragment,s),h(N.$$.fragment,s),h(Q.$$.fragment,s),h(Y.$$.fragment,s),h(F.$$.fragment,s),h(_.$$.fragment,s),h(P.$$.fragment,s),h(K.$$.fragment,s),h(ls.$$.fragment,s),h(ts.$$.fragment,s),h(ns.$$.fragment,s),h(is.$$.fragment,s),h(cs.$$.fragment,s),h(hs.$$.fragment,s),h(ys.$$.fragment,s),h(us.$$.fragment,s),h(Js.$$.fragment,s),h(bs.$$.fragment,s),h(ds.$$.fragment,s),h(Cs.$$.fragment,s),h(Zs.$$.fragment,s),h(Ws.$$.fragment,s),h(ks.$$.fragment,s),h(Hs.$$.fragment,s),h(Vs.$$.fragment,s),h(Rs.$$.fragment,s),ht=!0)},o(s){y(x.$$.fragment,s),y(d.$$.fragment,s),y(C.$$.fragment,s),y(B.$$.fragment,s),y($.$$.fragment,s),y(k.$$.fragment,s),y(H.$$.fragment,s),y(N.$$.fragment,s),y(Q.$$.fragment,s),y(Y.$$.fragment,s),y(F.$$.fragment,s),y(_.$$.fragment,s),y(P.$$.fragment,s),y(K.$$.fragment,s),y(ls.$$.fragment,s),y(ts.$$.fragment,s),y(ns.$$.fragment,s),y(is.$$.fragment,s),y(cs.$$.fragment,s),y(hs.$$.fragment,s),y(ys.$$.fragment,s),y(us.$$.fragment,s),y(Js.$$.fragment,s),y(bs.$$.fragment,s),y(ds.$$.fragment,s),y(Cs.$$.fragment,s),y(Zs.$$.fragment,s),y(Ws.$$.fragment,s),y(ks.$$.fragment,s),y(Hs.$$.fragment,s),y(Vs.$$.fragment,s),y(Rs.$$.fragment,s),ht=!1},d(s){s&&(t(_s),t(Xs),t(Ss),t(As),t(T),t(Ls),t(b),t(Ps),t(Ks),t(w),t(Ds),t(f),t(Os),t(sl),t(Z),t(ll),t(I),t(tl),t(al),t(nl),t(W),t(el),t(G),t(pl),t(il),t(cl),t(q),t(rl),t(v),t(ml),t(V),t(jl),t(hl),t(R),t(yl),t(z),t(Ml),t(ol),t(gl),t(X),t(ul),t(E),t(Jl),t(Ul),t(xl),t(S),t(Tl),t(A),t(bl),t(L),t(dl),t(wl),t(fl),t(D),t(Cl),t(O),t(Zl),t(ss),t(Il),t(Bl),t($l),t(as),t(Wl),t(Gl),t(es),t(kl),t(ps),t(Hl),t(ql),t(vl),t(rs),t(Vl),t(ms),t(Nl),t(js),t(Rl),t(zl),t(Ql),t(Ms),t(Yl),t(os),t(Xl),t(gs),t(El),t(Fl),t(_l),t(Us),t(Sl),t(xs),t(Al),t(Ts),t(Ll),t(Pl),t(Kl),t(ws),t(Dl),t(fs),t(Ol),t(st),t(lt),t(Is),t(tt),t(Bs),t(at),t(J),t(nt),t(et),t(qs),t(pt),t(vs),t(it),t(ct),t(Ns),t(rt),t(mt),t(zs),t(jt),t(Es)),t(u),M(x,s),M(d,s),M(C,s),M(B,s),M($,s),M(k,s),M(H,s),M(N,s),M(Q,s),M(Y,s),M(F,s),M(_,s),M(P,s),M(K,s),M(ls,s),M(ts,s),M(ns,s),M(is,s),M(cs,s),M(hs,s),M(ys,s),M(us,s),M(Js,s),M(bs,s),M(ds,s),M(Cs,s),M(Zs,s),M(Ws),M(ks),M(Hs,s),M(Vs,s),M(Rs,s)}}}const ua='{"title":"What 🤗 Transformers can do","local":"what--transformers-can-do","sections":[{"title":"Audio","local":"audio","sections":[{"title":"Audio classification","local":"audio-classification","sections":[],"depth":3},{"title":"Automatic speech recognition","local":"automatic-speech-recognition","sections":[],"depth":3}],"depth":2},{"title":"Computer vision","local":"computer-vision","sections":[{"title":"Image classification","local":"image-classification","sections":[],"depth":3},{"title":"Object detection","local":"object-detection","sections":[],"depth":3},{"title":"Image segmentation","local":"image-segmentation","sections":[],"depth":3},{"title":"Depth estimation","local":"depth-estimation","sections":[],"depth":3}],"depth":2},{"title":"Natural language processing","local":"natural-language-processing","sections":[{"title":"Text classification","local":"text-classification","sections":[],"depth":3},{"title":"Token classification","local":"token-classification","sections":[],"depth":3},{"title":"Question answering","local":"question-answering","sections":[],"depth":3},{"title":"Summarization","local":"summarization","sections":[],"depth":3},{"title":"Translation","local":"translation","sections":[],"depth":3},{"title":"言語モデリング","local":"言語モデリング","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"Document question answering","local":"document-question-answering","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ja(Ut){return ha(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class da extends ya{constructor(u){super(),Ma(this,u,Ja,ga,ma,{})}}export{da as component};
