import{s as hl,o as Ul,n as fl}from"../chunks/scheduler.8c3d61f6.js";import{S as Il,i as kl,g as p,s as n,r as w,A as Bl,h as o,f as t,c as a,j as yl,u as m,x as i,k as Jl,y as _l,a as s,v as d,d as T,t as j,w as y}from"../chunks/index.da70eac4.js";import{T as bl}from"../chunks/Tip.1d9b8c37.js";import{C as h}from"../chunks/CodeBlock.a9c4becf.js";import{H as Cl,E as vl}from"../chunks/getInferenceSnippets.a8672208.js";function Gl(ae){let c,b="🧪 <strong>Experimental Feature</strong>: Modular Diffusers is an experimental feature we are actively developing. The API may be subject to breaking changes.";return{c(){c=p("p"),c.innerHTML=b},l(M){c=o(M,"P",{"data-svelte-h":!0}),i(c)!=="svelte-11qh5l3"&&(c.innerHTML=b)},m(M,r){s(M,c,r)},p:fl,d(M){M&&t(c)}}}function xl(ae){let c,b='Other types of multi-blocks include <a href="./sequential_pipeline_blocks.md">SequentialPipelineBlocks</a> (for linear workflows) and <a href="./auto_pipeline_blocks.md">AutoPipelineBlocks</a> (for conditional block selection). For information on creating individual blocks, see the <a href="./pipeline_block.md">PipelineBlock guide</a>.',M,r,f='Additionally, like all <code>ModularPipelineBlocks</code>, <code>LoopSequentialPipelineBlocks</code> are definitions/specifications, not runnable pipelines. You need to convert them into a <code>ModularPipeline</code> to actually execute them. For information on creating and running pipelines, see the <a href="modular_pipeline.md">Modular Pipeline guide</a>.';return{c(){c=p("p"),c.innerHTML=b,M=n(),r=p("p"),r.innerHTML=f},l(u){c=o(u,"P",{"data-svelte-h":!0}),i(c)!=="svelte-z7v1cx"&&(c.innerHTML=b),M=a(u),r=o(u,"P",{"data-svelte-h":!0}),i(r)!=="svelte-1hzjjr4"&&(r.innerHTML=f)},m(u,J){s(u,c,J),s(u,M,J),s(u,r,J)},p:fl,d(u){u&&(t(c),t(M),t(r))}}}function $l(ae){let c,b,M,r,f,u,J,oe,I,We="<code>LoopSequentialPipelineBlocks</code> is a subclass of <code>ModularPipelineBlocks</code>. It is a multi-block that composes other blocks together in a loop, creating iterative workflows where blocks run multiple times with evolving state. It’s particularly useful for denoising loops requiring repeated execution of the same blocks.",ie,U,ce,k,Pe="You could create a loop using <code>PipelineBlock</code> like this:",Me,B,re,_,Ve="But in this tutorial, we will focus on how to use <code>LoopSequentialPipelineBlocks</code> to create a “composable” denoising loop where you can add or remove blocks within the loop or reuse the same loop structure with different block combinations.",ue,C,qe="It involves two parts: a <strong>loop wrapper</strong> and <strong>loop blocks</strong>",we,v,Qe="<li><p>The <strong>loop wrapper</strong> (<code>LoopSequentialPipelineBlocks</code>) defines the loop structure, e.g. it defines the iteration variables, and loop configurations such as progress bar.</p></li> <li><p>The <strong>loop blocks</strong> are basically standard pipeline blocks you add to the loop wrapper.</p> <ul><li>they run sequentially for each iteration of the loop</li> <li>they receive the current iteration index as an additional parameter</li> <li>they share the same block_state throughout the entire loop</li></ul></li>",me,G,Fe="Unlike regular <code>SequentialPipelineBlocks</code> where each block gets its own state, loop blocks share a single state that persists and evolves across iterations.",de,x,De="We will build a simple loop block to demonstrate these concepts. Creating a loop block involves three steps:",Te,$,Ke="<li>defining the loop wrapper class</li> <li>creating the loop blocks</li> <li>adding the loop blocks to the loop wrapper class to create the loop wrapper instance</li>",je,A,Oe="<strong>Step 1: Define the Loop Wrapper</strong>",ye,g,el="To create a <code>LoopSequentialPipelineBlocks</code> class, you need to define:",Je,L,ll="<li><code>loop_inputs</code>: User input variables (equivalent to <code>PipelineBlock.inputs</code>)</li> <li><code>loop_intermediate_inputs</code>: Intermediate variables needed from the mutable pipeline state (equivalent to <code>PipelineBlock.intermediates_inputs</code>)</li> <li><code>loop_intermediate_outputs</code>: New intermediate variables this block will add to the mutable pipeline state (equivalent to <code>PipelineBlock.intermediates_outputs</code>)</li> <li><code>__call__</code> method: Defines the loop structure and iteration logic</li>",be,Z,tl="Here is an example of a loop wrapper:",fe,H,he,X,sl="<strong>Step 2: Create Loop Blocks</strong>",Ue,S,nl="Loop blocks are standard <code>PipelineBlock</code>s, but their <code>__call__</code> method works differently:",Ie,Y,al="<li>It receives the iteration variable (e.g., <code>i</code>) passed by the loop wrapper</li> <li>It works directly with <code>block_state</code> instead of pipeline state</li> <li>No need to call <code>self.get_block_state()</code> or <code>self.set_block_state()</code></li>",ke,z,Be,R,pl="<strong>Step 3: Combine Everything</strong>",_e,N,ol="Finally, assemble your loop by adding the block(s) to the wrapper:",Ce,E,ve,W,il="Now you’ve created a loop with one step:",Ge,P,xe,V,cl="It has two inputs: <code>x</code> (used at each step within the loop) and <code>num_steps</code> used to define the loop.",$e,q,Ae,Q,Ml="<strong>Running the Loop:</strong>",ge,F,Le,D,rl="<strong>Adding Multiple Blocks:</strong>",Ze,K,ul="We can add multiple blocks to run within each iteration. Let’s run the loop block twice within each iteration:",He,O,Xe,ee,wl="<strong>Key Differences from SequentialPipelineBlocks:</strong>",Se,le,ml="The main difference is that loop blocks share the same <code>block_state</code> across all iterations, allowing values to accumulate and evolve throughout the loop. Loop blocks could receive additional arguments (like the current iteration index) depending on the loop wrapper’s implementation, since the wrapper defines how loop blocks are called. You can easily add, remove, or reorder blocks within the loop without changing the loop logic itself.",Ye,te,dl="The officially supported denoising loops in Modular Diffusers are implemented using <code>LoopSequentialPipelineBlocks</code>. You can explore the actual implementation to see how these concepts work in practice:",ze,se,Re,ne,Ne,pe,Ee;return f=new Cl({props:{title:"LoopSequentialPipelineBlocks",local:"loopsequentialpipelineblocks",headingTag:"h1"}}),J=new bl({props:{warning:!0,$$slots:{default:[Gl]},$$scope:{ctx:ae}}}),U=new bl({props:{$$slots:{default:[xl]},$$scope:{ctx:ae}}}),B=new h({props:{code:"Y2xhc3MlMjBEZW5vaXNlTG9vcChQaXBlbGluZUJsb2NrKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYlMkMlMjBjb21wb25lbnRzJTJDJTIwc3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfc3RhdGUlMjAlM0QlMjBzZWxmLmdldF9ibG9ja19zdGF0ZShzdGF0ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjB0JTIwaW4lMjByYW5nZShibG9ja19zdGF0ZS5udW1faW5mZXJlbmNlX3N0ZXBzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMC4uLiUyMGxvb3AlMjBsb2dpYyUyMGhlcmUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXNzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5zZXRfYmxvY2tfc3RhdGUoc3RhdGUlMkMlMjBibG9ja19zdGF0ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBjb21wb25lbnRzJTJDJTIwc3RhdGU=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">DenoiseLoop</span>(<span class="hljs-title class_ inherited__">PipelineBlock</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
        block_state = self.get_block_state(state)
        <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(block_state.num_inference_steps):
            <span class="hljs-comment"># ... loop logic here</span>
            <span class="hljs-keyword">pass</span>
        self.set_block_state(state, block_state)
        <span class="hljs-keyword">return</span> components, state`,wrap:!1}}),H=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzJTIwaW1wb3J0JTIwTG9vcFNlcXVlbnRpYWxQaXBlbGluZUJsb2NrcyUyQyUyMFBpcGVsaW5lQmxvY2slMkMlMjBJbnB1dFBhcmFtJTJDJTIwT3V0cHV0UGFyYW0lMEElMEFjbGFzcyUyMExvb3BXcmFwcGVyKExvb3BTZXF1ZW50aWFsUGlwZWxpbmVCbG9ja3MpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnRlc3QlMjIlMEElMjAlMjAlMjAlMjAlNDBwcm9wZXJ0eSUwQSUyMCUyMCUyMCUyMGRlZiUyMGRlc2NyaXB0aW9uKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIySSdtJTIwYSUyMGxvb3AhISUyMiUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwbG9vcF9pbnB1dHMoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlNUJJbnB1dFBhcmFtKG5hbWUlM0QlMjJudW1fc3RlcHMlMjIpJTVEJTBBJTIwJTIwJTIwJTIwJTQwdG9yY2gubm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMGNvbXBvbmVudHMlMkMlMjBzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19zdGF0ZSUyMCUzRCUyMHNlbGYuZ2V0X2Jsb2NrX3N0YXRlKHN0YXRlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMExvb3AlMjBzdHJ1Y3R1cmUlMjAtJTIwY2FuJTIwYmUlMjBjdXN0b21pemVkJTIwdG8lMjB5b3VyJTIwbmVlZHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShibG9ja19zdGF0ZS5udW1fc3RlcHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbG9vcF9zdGVwJTIwZXhlY3V0ZXMlMjBhbGwlMjByZWdpc3RlcmVkJTIwYmxvY2tzJTIwaW4lMjBzZXF1ZW5jZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbXBvbmVudHMlMkMlMjBibG9ja19zdGF0ZSUyMCUzRCUyMHNlbGYubG9vcF9zdGVwKGNvbXBvbmVudHMlMkMlMjBibG9ja19zdGF0ZSUyQyUyMGklM0RpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuc2V0X2Jsb2NrX3N0YXRlKHN0YXRlJTJDJTIwYmxvY2tfc3RhdGUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwY29tcG9uZW50cyUyQyUyMHN0YXRl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> LoopSequentialPipelineBlocks, PipelineBlock, InputParam, OutputParam

<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopWrapper</span>(<span class="hljs-title class_ inherited__">LoopSequentialPipelineBlocks</span>):
    model_name = <span class="hljs-string">&quot;test&quot;</span>
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">description</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;I&#x27;m a loop!!&quot;</span>
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">loop_inputs</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> [InputParam(name=<span class="hljs-string">&quot;num_steps&quot;</span>)]
<span class="hljs-meta">    @torch.no_grad()</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
        block_state = self.get_block_state(state)
        <span class="hljs-comment"># Loop structure - can be customized to your needs</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(block_state.num_steps):
            <span class="hljs-comment"># loop_step executes all registered blocks in sequence</span>
            components, block_state = self.loop_step(components, block_state, i=i)
        self.set_block_state(state, block_state)
        <span class="hljs-keyword">return</span> components, state`,wrap:!1}}),z=new h({props:{code:"Y2xhc3MlMjBMb29wQmxvY2soUGlwZWxpbmVCbG9jayklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjB0aGlzJTIwaXMlMjB1c2VkJTIwdG8lMjBpZGVudGlmeSUyMHRoZSUyMG1vZGVsJTIwZmFtaWx5JTJDJTIwd2UlMjB3b24ndCUyMHdvcnJ5JTIwYWJvdXQlMjBpdCUyMGluJTIwdGhpcyUyMGV4YW1wbGUlMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTIwJTNEJTIwJTIydGVzdCUyMiUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwaW5wdXRzKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCSW5wdXRQYXJhbShuYW1lJTNEJTIyeCUyMiklNUQlMEElMjAlMjAlMjAlMjAlNDBwcm9wZXJ0eSUwQSUyMCUyMCUyMCUyMGRlZiUyMGludGVybWVkaWF0ZV9vdXRwdXRzKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwb3V0cHV0cyUyMHByb2R1Y2VkJTIwYnklMjB0aGlzJTIwYmxvY2slMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlNUJPdXRwdXRQYXJhbShuYW1lJTNEJTIyeCUyMiklNUQlMEElMjAlMjAlMjAlMjAlNDBwcm9wZXJ0eSUwQSUyMCUyMCUyMCUyMGRlZiUyMGRlc2NyaXB0aW9uKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIySSdtJTIwYSUyMGJsb2NrJTIwdXNlZCUyMGluc2lkZSUyMHRoZSUyMCU2MExvb3BXcmFwcGVyJTYwJTIwY2xhc3MlMjIlMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwY29tcG9uZW50cyUyQyUyMGJsb2NrX3N0YXRlJTJDJTIwaSUzQSUyMGludCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19zdGF0ZS54JTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGNvbXBvbmVudHMlMkMlMjBibG9ja19zdGF0ZQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopBlock</span>(<span class="hljs-title class_ inherited__">PipelineBlock</span>):
    <span class="hljs-comment"># this is used to identify the model family, we won&#x27;t worry about it in this example</span>
    model_name = <span class="hljs-string">&quot;test&quot;</span>
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">inputs</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> [InputParam(name=<span class="hljs-string">&quot;x&quot;</span>)]
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">intermediate_outputs</span>(<span class="hljs-params">self</span>):
        <span class="hljs-comment"># outputs produced by this block</span>
        <span class="hljs-keyword">return</span> [OutputParam(name=<span class="hljs-string">&quot;x&quot;</span>)]
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">description</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;I&#x27;m a block used inside the \`LoopWrapper\` class&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, block_state, i: <span class="hljs-built_in">int</span></span>):
        block_state.x += <span class="hljs-number">1</span>
        <span class="hljs-keyword">return</span> components, block_state`,wrap:!1}}),E=new h({props:{code:"bG9vcCUyMCUzRCUyMExvb3BXcmFwcGVyLmZyb21fYmxvY2tzX2RpY3QoJTdCJTIyYmxvY2sxJTIyJTNBJTIwTG9vcEJsb2NrJTdEKQ==",highlighted:'loop = LoopWrapper.from_blocks_dict({<span class="hljs-string">&quot;block1&quot;</span>: LoopBlock})',wrap:!1}}),P=new h({props:{code:"bG9vcCUwQSUwQSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>loop
LoopWrapper(
  Class: LoopSequentialPipelineBlocks

  Description: I<span class="hljs-string">&#x27;m a loop!!

  Sub-Blocks:
    [0] block1 (LoopBlock)
       Description: I&#x27;</span>m a block used inside the \`LoopWrapper\` <span class="hljs-keyword">class</span>

)`,wrap:!1}}),q=new h({props:{code:"cHJpbnQobG9vcC5kb2MpJTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(loop.doc)
<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopWrapper</span>

  I<span class="hljs-string">&#x27;m a loop!!

  Inputs:

      x (\`None\`, *optional*):

      num_steps (\`None\`, *optional*):

  Outputs:

      x (\`None\`):</span>`,wrap:!1}}),F=new h({props:{code:"JTIzJTIwcnVuJTIwdGhlJTIwbG9vcCUwQWxvb3BfcGlwZWxpbmUlMjAlM0QlMjBsb29wLmluaXRfcGlwZWxpbmUoKSUwQXglMjAlM0QlMjBsb29wX3BpcGVsaW5lKG51bV9zdGVwcyUzRDEwJTJDJTIweCUzRDAlMkMlMjBvdXRwdXQlM0QlMjJ4JTIyKSUwQWFzc2VydCUyMHglMjAlM0QlM0QlMjAxMA==",highlighted:`<span class="hljs-comment"># run the loop</span>
loop_pipeline = loop.init_pipeline()
x = loop_pipeline(num_steps=<span class="hljs-number">10</span>, x=<span class="hljs-number">0</span>, output=<span class="hljs-string">&quot;x&quot;</span>)
<span class="hljs-keyword">assert</span> x == <span class="hljs-number">10</span>`,wrap:!1}}),O=new h({props:{code:"bG9vcCUyMCUzRCUyMExvb3BXcmFwcGVyLmZyb21fYmxvY2tzX2RpY3QoJTdCJTIyYmxvY2sxJTIyJTNBJTIwTG9vcEJsb2NrKCklMkMlMjAlMjJibG9jazIlMjIlM0ElMjBMb29wQmxvY2slN0QpJTBBbG9vcF9waXBlbGluZSUyMCUzRCUyMGxvb3AuaW5pdF9waXBlbGluZSgpJTBBeCUyMCUzRCUyMGxvb3BfcGlwZWxpbmUobnVtX3N0ZXBzJTNEMTAlMkMlMjB4JTNEMCUyQyUyMG91dHB1dCUzRCUyMnglMjIpJTBBYXNzZXJ0JTIweCUyMCUzRCUzRCUyMDIwJTIwJTIwJTIzJTIwRWFjaCUyMGl0ZXJhdGlvbiUyMHJ1bnMlMjAyJTIwYmxvY2tzJTJDJTIwc28lMjAxMCUyMGl0ZXJhdGlvbnMlMjAqJTIwMiUyMCUzRCUyMDIw",highlighted:`loop = LoopWrapper.from_blocks_dict({<span class="hljs-string">&quot;block1&quot;</span>: LoopBlock(), <span class="hljs-string">&quot;block2&quot;</span>: LoopBlock})
loop_pipeline = loop.init_pipeline()
x = loop_pipeline(num_steps=<span class="hljs-number">10</span>, x=<span class="hljs-number">0</span>, output=<span class="hljs-string">&quot;x&quot;</span>)
<span class="hljs-keyword">assert</span> x == <span class="hljs-number">20</span>  <span class="hljs-comment"># Each iteration runs 2 blocks, so 10 iterations * 2 = 20</span>`,wrap:!1}}),se=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsLmRlbm9pc2UlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25YTERlbm9pc2VTdGVwJTBBU3RhYmxlRGlmZnVzaW9uWExEZW5vaXNlU3RlcCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl.denoise <span class="hljs-keyword">import</span> StableDiffusionXLDenoiseStep
StableDiffusionXLDenoiseStep()`,wrap:!1}}),ne=new vl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/modular_diffusers/loop_sequential_pipeline_blocks.md"}}),{c(){c=p("meta"),b=n(),M=p("p"),r=n(),w(f.$$.fragment),u=n(),w(J.$$.fragment),oe=n(),I=p("p"),I.innerHTML=We,ie=n(),w(U.$$.fragment),ce=n(),k=p("p"),k.innerHTML=Pe,Me=n(),w(B.$$.fragment),re=n(),_=p("p"),_.innerHTML=Ve,ue=n(),C=p("p"),C.innerHTML=qe,we=n(),v=p("ul"),v.innerHTML=Qe,me=n(),G=p("p"),G.innerHTML=Fe,de=n(),x=p("p"),x.textContent=De,Te=n(),$=p("ol"),$.innerHTML=Ke,je=n(),A=p("p"),A.innerHTML=Oe,ye=n(),g=p("p"),g.innerHTML=el,Je=n(),L=p("ul"),L.innerHTML=ll,be=n(),Z=p("p"),Z.textContent=tl,fe=n(),w(H.$$.fragment),he=n(),X=p("p"),X.innerHTML=sl,Ue=n(),S=p("p"),S.innerHTML=nl,Ie=n(),Y=p("ul"),Y.innerHTML=al,ke=n(),w(z.$$.fragment),Be=n(),R=p("p"),R.innerHTML=pl,_e=n(),N=p("p"),N.textContent=ol,Ce=n(),w(E.$$.fragment),ve=n(),W=p("p"),W.textContent=il,Ge=n(),w(P.$$.fragment),xe=n(),V=p("p"),V.innerHTML=cl,$e=n(),w(q.$$.fragment),Ae=n(),Q=p("p"),Q.innerHTML=Ml,ge=n(),w(F.$$.fragment),Le=n(),D=p("p"),D.innerHTML=rl,Ze=n(),K=p("p"),K.textContent=ul,He=n(),w(O.$$.fragment),Xe=n(),ee=p("p"),ee.innerHTML=wl,Se=n(),le=p("p"),le.innerHTML=ml,Ye=n(),te=p("p"),te.innerHTML=dl,ze=n(),w(se.$$.fragment),Re=n(),w(ne.$$.fragment),Ne=n(),pe=p("p"),this.h()},l(e){const l=Bl("svelte-u9bgzb",document.head);c=o(l,"META",{name:!0,content:!0}),l.forEach(t),b=a(e),M=o(e,"P",{}),yl(M).forEach(t),r=a(e),m(f.$$.fragment,e),u=a(e),m(J.$$.fragment,e),oe=a(e),I=o(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-xl9zk8"&&(I.innerHTML=We),ie=a(e),m(U.$$.fragment,e),ce=a(e),k=o(e,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1vaq9ea"&&(k.innerHTML=Pe),Me=a(e),m(B.$$.fragment,e),re=a(e),_=o(e,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1rdiz9k"&&(_.innerHTML=Ve),ue=a(e),C=o(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-6557vk"&&(C.innerHTML=qe),we=a(e),v=o(e,"UL",{"data-svelte-h":!0}),i(v)!=="svelte-17nq7um"&&(v.innerHTML=Qe),me=a(e),G=o(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-rtau3w"&&(G.innerHTML=Fe),de=a(e),x=o(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1qv8b"&&(x.textContent=De),Te=a(e),$=o(e,"OL",{"data-svelte-h":!0}),i($)!=="svelte-1dhss6s"&&($.innerHTML=Ke),je=a(e),A=o(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-ulnx8p"&&(A.innerHTML=Oe),ye=a(e),g=o(e,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1en1jzl"&&(g.innerHTML=el),Je=a(e),L=o(e,"UL",{"data-svelte-h":!0}),i(L)!=="svelte-16l6cn8"&&(L.innerHTML=ll),be=a(e),Z=o(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1xspfpu"&&(Z.textContent=tl),fe=a(e),m(H.$$.fragment,e),he=a(e),X=o(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-15g49vj"&&(X.innerHTML=sl),Ue=a(e),S=o(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-e0yaqv"&&(S.innerHTML=nl),Ie=a(e),Y=o(e,"UL",{"data-svelte-h":!0}),i(Y)!=="svelte-y66e4"&&(Y.innerHTML=al),ke=a(e),m(z.$$.fragment,e),Be=a(e),R=o(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1c5cx58"&&(R.innerHTML=pl),_e=a(e),N=o(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-qvme9r"&&(N.textContent=ol),Ce=a(e),m(E.$$.fragment,e),ve=a(e),W=o(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-gx44pi"&&(W.textContent=il),Ge=a(e),m(P.$$.fragment,e),xe=a(e),V=o(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-bwerrz"&&(V.innerHTML=cl),$e=a(e),m(q.$$.fragment,e),Ae=a(e),Q=o(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1ickhlt"&&(Q.innerHTML=Ml),ge=a(e),m(F.$$.fragment,e),Le=a(e),D=o(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-c9iaqy"&&(D.innerHTML=rl),Ze=a(e),K=o(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-y0dhln"&&(K.textContent=ul),He=a(e),m(O.$$.fragment,e),Xe=a(e),ee=o(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-10vcc97"&&(ee.innerHTML=wl),Se=a(e),le=o(e,"P",{"data-svelte-h":!0}),i(le)!=="svelte-1wopqg"&&(le.innerHTML=ml),Ye=a(e),te=o(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-1f0i3fw"&&(te.innerHTML=dl),ze=a(e),m(se.$$.fragment,e),Re=a(e),m(ne.$$.fragment,e),Ne=a(e),pe=o(e,"P",{}),yl(pe).forEach(t),this.h()},h(){Jl(c,"name","hf:doc:metadata"),Jl(c,"content",Al)},m(e,l){_l(document.head,c),s(e,b,l),s(e,M,l),s(e,r,l),d(f,e,l),s(e,u,l),d(J,e,l),s(e,oe,l),s(e,I,l),s(e,ie,l),d(U,e,l),s(e,ce,l),s(e,k,l),s(e,Me,l),d(B,e,l),s(e,re,l),s(e,_,l),s(e,ue,l),s(e,C,l),s(e,we,l),s(e,v,l),s(e,me,l),s(e,G,l),s(e,de,l),s(e,x,l),s(e,Te,l),s(e,$,l),s(e,je,l),s(e,A,l),s(e,ye,l),s(e,g,l),s(e,Je,l),s(e,L,l),s(e,be,l),s(e,Z,l),s(e,fe,l),d(H,e,l),s(e,he,l),s(e,X,l),s(e,Ue,l),s(e,S,l),s(e,Ie,l),s(e,Y,l),s(e,ke,l),d(z,e,l),s(e,Be,l),s(e,R,l),s(e,_e,l),s(e,N,l),s(e,Ce,l),d(E,e,l),s(e,ve,l),s(e,W,l),s(e,Ge,l),d(P,e,l),s(e,xe,l),s(e,V,l),s(e,$e,l),d(q,e,l),s(e,Ae,l),s(e,Q,l),s(e,ge,l),d(F,e,l),s(e,Le,l),s(e,D,l),s(e,Ze,l),s(e,K,l),s(e,He,l),d(O,e,l),s(e,Xe,l),s(e,ee,l),s(e,Se,l),s(e,le,l),s(e,Ye,l),s(e,te,l),s(e,ze,l),d(se,e,l),s(e,Re,l),d(ne,e,l),s(e,Ne,l),s(e,pe,l),Ee=!0},p(e,[l]){const Tl={};l&2&&(Tl.$$scope={dirty:l,ctx:e}),J.$set(Tl);const jl={};l&2&&(jl.$$scope={dirty:l,ctx:e}),U.$set(jl)},i(e){Ee||(T(f.$$.fragment,e),T(J.$$.fragment,e),T(U.$$.fragment,e),T(B.$$.fragment,e),T(H.$$.fragment,e),T(z.$$.fragment,e),T(E.$$.fragment,e),T(P.$$.fragment,e),T(q.$$.fragment,e),T(F.$$.fragment,e),T(O.$$.fragment,e),T(se.$$.fragment,e),T(ne.$$.fragment,e),Ee=!0)},o(e){j(f.$$.fragment,e),j(J.$$.fragment,e),j(U.$$.fragment,e),j(B.$$.fragment,e),j(H.$$.fragment,e),j(z.$$.fragment,e),j(E.$$.fragment,e),j(P.$$.fragment,e),j(q.$$.fragment,e),j(F.$$.fragment,e),j(O.$$.fragment,e),j(se.$$.fragment,e),j(ne.$$.fragment,e),Ee=!1},d(e){e&&(t(b),t(M),t(r),t(u),t(oe),t(I),t(ie),t(ce),t(k),t(Me),t(re),t(_),t(ue),t(C),t(we),t(v),t(me),t(G),t(de),t(x),t(Te),t($),t(je),t(A),t(ye),t(g),t(Je),t(L),t(be),t(Z),t(fe),t(he),t(X),t(Ue),t(S),t(Ie),t(Y),t(ke),t(Be),t(R),t(_e),t(N),t(Ce),t(ve),t(W),t(Ge),t(xe),t(V),t($e),t(Ae),t(Q),t(ge),t(Le),t(D),t(Ze),t(K),t(He),t(Xe),t(ee),t(Se),t(le),t(Ye),t(te),t(ze),t(Re),t(Ne),t(pe)),t(c),y(f,e),y(J,e),y(U,e),y(B,e),y(H,e),y(z,e),y(E,e),y(P,e),y(q,e),y(F,e),y(O,e),y(se,e),y(ne,e)}}}const Al='{"title":"LoopSequentialPipelineBlocks","local":"loopsequentialpipelineblocks","sections":[],"depth":1}';function gl(ae){return Ul(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yl extends Il{constructor(c){super(),kl(this,c,gl,$l,hl,{})}}export{Yl as component};
