import{s as Ui,o as $i,n as un}from"../chunks/scheduler.182ea377.js";import{S as Zi,i as Wi,g as n,s,p as f,A as zi,h as o,f as a,c as i,j as m,q as g,m as r,k as d,v as e,a as v,r as u,d as h,t as _,u as b}from"../chunks/index.008d68e4.js";import{T as Xi}from"../chunks/Tip.4f096367.js";import{D as M}from"../chunks/Docstring.7aec8b85.js";import{C as Ts}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as gn}from"../chunks/IconCopyLink.96bbb92b.js";import{E as Ms}from"../chunks/ExampleCodeBlock.23e54afe.js";function Bi(P){let p,S='🧪 Many of the SDXL ControlNet checkpoints are experimental, and there is a lot of room for improvement. Feel free to open an <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">Issue</a> and leave us feedback on how we can improve!';return{c(){p=n("p"),p.innerHTML=S},l(w){p=o(w,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1q1xjpk"&&(p.innerHTML=S)},m(w,y){v(w,p,y)},p:un,d(w){w&&a(p)}}}function Gi(P){let p,S='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){p=n("p"),p.innerHTML=S},l(w){p=o(w,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1wmc0l4"&&(p.innerHTML=S)},m(w,y){v(w,p,y)},p:un,d(w){w&&a(p)}}}function Ei(P){let p,S="Examples:",w,y,j;return y=new Ts({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install opencv-python transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel, AutoencoderKL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> cv2
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;low quality, bad quality, sketches&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download an image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># initialize the models and pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet_conditioning_scale = <span class="hljs-number">0.5</span>  <span class="hljs-comment"># recommended for good generalization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLControlNetPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnet, vae=vae, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get canny image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.array(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>canny_image = Image.fromarray(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt, controlnet_conditioning_scale=controlnet_conditioning_scale, image=canny_image
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`}}),{c(){p=n("p"),p.textContent=S,w=s(),f(y.$$.fragment)},l(l){p=o(l,"P",{"data-svelte-h":!0}),r(p)!=="svelte-kvfsh7"&&(p.textContent=S),w=i(l),g(y.$$.fragment,l)},m(l,D){v(l,p,D),v(l,w,D),u(y,l,D),j=!0},p:un,i(l){j||(h(y.$$.fragment,l),j=!0)},o(l){_(y.$$.fragment,l),j=!1},d(l){l&&(a(p),a(w)),b(y,l)}}}function Fi(P){let p,S="Examples:",w,y,j;return y=new Ts({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># pip install accelerate transformers safetensors diffusers</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DPTFeatureExtractor, DPTForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel, StableDiffusionXLControlNetImg2ImgPipeline, AutoencoderKL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image


<span class="hljs-meta">&gt;&gt;&gt; </span>depth_estimator = DPTForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-hybrid-midas&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = DPTFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-hybrid-midas&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;diffusers/controlnet-depth-sdxl-1.0-small&quot;</span>,
<span class="hljs-meta">... </span>    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLControlNetImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
<span class="hljs-meta">... </span>    controlnet=controlnet,
<span class="hljs-meta">... </span>    vae=vae,
<span class="hljs-meta">... </span>    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_depth_map</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    image = feature_extractor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad(), torch.autocast(<span class="hljs-string">&quot;cuda&quot;</span>):
<span class="hljs-meta">... </span>        depth_map = depth_estimator(image).predicted_depth

<span class="hljs-meta">... </span>    depth_map = torch.nn.functional.interpolate(
<span class="hljs-meta">... </span>        depth_map.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>        size=(<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>),
<span class="hljs-meta">... </span>        mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>        align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    depth_min = torch.amin(depth_map, dim=[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>], keepdim=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    depth_max = torch.amax(depth_map, dim=[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>], keepdim=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    depth_map = (depth_map - depth_min) / (depth_max - depth_min)
<span class="hljs-meta">... </span>    image = torch.cat([depth_map] * <span class="hljs-number">3</span>, dim=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    image = image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>).cpu().numpy()[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    image = Image.fromarray((image * <span class="hljs-number">255.0</span>).clip(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>).astype(np.uint8))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image


<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A robot, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet_conditioning_scale = <span class="hljs-number">0.5</span>  <span class="hljs-comment"># recommended for good generalization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth_image = get_depth_map(image)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    control_image=depth_image,
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.99</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    controlnet_conditioning_scale=controlnet_conditioning_scale,
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">f&quot;robot_cat.png&quot;</span>)`}}),{c(){p=n("p"),p.textContent=S,w=s(),f(y.$$.fragment)},l(l){p=o(l,"P",{"data-svelte-h":!0}),r(p)!=="svelte-kvfsh7"&&(p.textContent=S),w=i(l),g(y.$$.fragment,l)},m(l,D){v(l,p,D),v(l,w,D),u(y,l,D),j=!0},p:un,i(l){j||(h(y.$$.fragment,l),j=!0)},o(l){_(y.$$.fragment,l),j=!1},d(l){l&&(a(p),a(w)),b(y,l)}}}function Ai(P){let p,S="Examples:",w,y,j;return y=new Ts({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetInpaintPipeline, ControlNetModel, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/test-arrays/resolve/main/stable_diffusion_inpaint/boy.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/test-arrays/resolve/main/stable_diffusion_inpaint/boy_mask.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = mask_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">make_canny_condition</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    image = np.array(image)
<span class="hljs-meta">... </span>    image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">... </span>    image = image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">... </span>    image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    image = Image.fromarray(image)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image


<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = make_canny_condition(init_image)

<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLControlNetInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;a handsome man with ray-ban sunglasses&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    eta=<span class="hljs-number">1.0</span>,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    mask_image=mask_image,
<span class="hljs-meta">... </span>    control_image=control_image,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`}}),{c(){p=n("p"),p.textContent=S,w=s(),f(y.$$.fragment)},l(l){p=o(l,"P",{"data-svelte-h":!0}),r(p)!=="svelte-kvfsh7"&&(p.textContent=S),w=i(l),g(y.$$.fragment,l)},m(l,D){v(l,p,D),v(l,w,D),u(y,l,D),j=!0},p:un,i(l){j||(h(y.$$.fragment,l),j=!0)},o(l){_(y.$$.fragment,l),j=!1},d(l){l&&(a(p),a(w)),b(y,l)}}}function Ri(P){let p,S,w,y,j,l,D,lt,Ls="ControlNet with Stable Diffusion XL",hn,ye,Ns='ControlNet was introduced in <a href="https://huggingface.co/papers/2302.05543" rel="nofollow">Adding Conditional Control to Text-to-Image Diffusion Models</a> by Lvmin Zhang, Anyi Rao, and Maneesh Agrawala.',_n,xe,js="With a ControlNet model, you can provide an additional control image to condition and control Stable Diffusion generation. For example, if you provide a depth map, the ControlNet model generates an image that’ll preserve the spatial information from the depth map. It is a more flexible and accurate way to control the image generation process.",bn,Ce,Ss="The abstract from the paper is:",vn,Ie,Ds="<em>We present ControlNet, a neural network architecture to add spatial conditioning controls to large, pretrained text-to-image diffusion models. ControlNet locks the production-ready large diffusion models, and reuses their deep and robust encoding layers pretrained with billions of images as a strong backbone to learn a diverse set of conditional controls. The neural architecture is connected with “zero convolutions” (zero-initialized convolution layers) that progressively grow the parameters from zero and ensure that no harmful noise could affect the finetuning. We test various conditioning controls, eg, edges, depth, segmentation, human pose, etc, with Stable Diffusion, using single or multiple conditions, with or without prompts. We show that the training of ControlNets is robust with small (&lt;50k) and large (&gt;1m) datasets. Extensive results show that ControlNet may facilitate wider applications to control image diffusion models.</em>",wn,Me,Ps='You can find additional smaller Stable Diffusion XL (SDXL) ControlNet checkpoints from the 🤗 <a href="https://huggingface.co/diffusers" rel="nofollow">Diffusers</a> Hub organization, and browse <a href="https://huggingface.co/models?other=stable-diffusion-xl&amp;other=controlnet" rel="nofollow">community-trained</a> checkpoints on the Hub.',yn,F,xn,Te,ks='If you don’t see a checkpoint you’re interested in, you can train your own SDXL ControlNet with our <a href="../../../../../examples/controlnet/README_sdxl">training script</a>.',Cn,A,In,W,R,rn,Le,no,dt,Js="StableDiffusionXLControlNetPipeline",Mn,x,Ne,oo,pt,Xs="Pipeline for text-to-image generation using Stable Diffusion XL with ControlNet guidance.",so,ct,Us=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,io,mt,$s="The pipeline also inherits the following loading methods:",ao,ft,Zs='<li><a href="/docs/diffusers/v0.25.0/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><code>save_lora_weights()</code> for saving LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',ro,U,je,lo,gt,Ws="The call function to the pipeline for generation.",po,V,co,Y,Se,mo,ut,zs="Disables the FreeU mechanism if enabled.",fo,Q,De,go,ht,Bs=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,uo,H,Pe,ho,_t,Gs=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,_o,k,ke,bo,bt,Es='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',vo,vt,Fs="The suffixes after the scaling factors represent the stages where they are being applied.",wo,wt,As=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,yo,O,Je,xo,yt,Rs=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Co,q,Xe,Io,xt,Vs=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Mo,K,Ue,To,Ct,Ys="Encodes the prompt into text encoder hidden states.",Lo,ee,$e,No,It,Qs='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Tn,z,te,ln,Ze,jo,Mt,Hs="StableDiffusionXLControlNetImg2ImgPipeline",Ln,C,We,So,Tt,Os="Pipeline for image-to-image generation using Stable Diffusion XL with ControlNet guidance.",Do,Lt,qs=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Po,Nt,Ks="The pipeline also inherits the following loading methods:",ko,jt,ei='<li><a href="/docs/diffusers/v0.25.0/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><code>save_lora_weights()</code> for saving LoRA weights</li>',Jo,$,ze,Xo,St,ti="Function invoked when calling the pipeline for generation.",Uo,ne,$o,oe,Be,Zo,Dt,ni="Disables the FreeU mechanism if enabled.",Wo,se,Ge,zo,Pt,oi=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Bo,ie,Ee,Go,kt,si=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Eo,J,Fe,Fo,Jt,ii='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Ao,Xt,ai="The suffixes after the scaling factors represent the stages where they are being applied.",Ro,Ut,ri=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Vo,ae,Ae,Yo,$t,li=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Qo,re,Re,Ho,Zt,di=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Oo,le,Ve,qo,Wt,pi="Encodes the prompt into text encoder hidden states.",Nn,B,de,dn,Ye,Ko,zt,ci="StableDiffusionXLControlNetInpaintPipeline",jn,I,Qe,es,Bt,mi="Pipeline for text-to-image generation using Stable Diffusion XL.",ts,Gt,fi=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,ns,Et,gi="The pipeline also inherits the following loading methods:",os,Ft,ui='<li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><code>save_lora_weights()</code> for saving LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li>',ss,Z,He,is,At,hi="Function invoked when calling the pipeline for generation.",as,pe,rs,ce,Oe,ls,Rt,_i="Disables the FreeU mechanism if enabled.",ds,me,qe,ps,Vt,bi=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,cs,fe,Ke,ms,Yt,vi=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,fs,X,et,gs,Qt,wi='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',us,Ht,yi="The suffixes after the scaling factors represent the stages where they are being applied.",hs,Ot,xi=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,_s,ge,tt,bs,qt,Ci=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,vs,ue,nt,ws,Kt,Ii=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,ys,he,ot,xs,en,Mi="Encodes the prompt into text encoder hidden states.",Sn,G,_e,pn,st,Cs,tn,Ti="StableDiffusionPipelineOutput",Dn,E,it,Is,nn,Li="Output class for Stable Diffusion pipelines.",Pn;return l=new gn({}),F=new Xi({props:{warning:!0,$$slots:{default:[Bi]},$$scope:{ctx:P}}}),A=new Xi({props:{$$slots:{default:[Gi]},$$scope:{ctx:P}}}),Le=new gn({}),Ne=new M({props:{name:"class diffusers.StableDiffusionXLControlNetPipeline",anchor:"diffusers.StableDiffusionXLControlNetPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": Union"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": Optional = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIPTextModelWithProjection</a>) &#x2014;
Second frozen text-encoder
(<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>).`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.25.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings should always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark</a> library to
watermark output images. If not defined, it defaults to <code>True</code> if the package is installed; otherwise no
watermarker is used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl.py#L117"}}),je=new M({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"prompt_2",val:": Union = None"},{name:"image",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"controlnet_conditioning_scale",val:": Union = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": Union = 0.0"},{name:"control_guidance_end",val:": Union = 1.0"},{name:"original_size",val:": Tuple = None"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"target_size",val:": Tuple = None"},{name:"negative_original_size",val:": Optional = None"},{name:"negative_crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"negative_target_size",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders.`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.FloatTensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be
accepted as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height
and/or width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in
<code>init</code>, images must be passed as a list such that each element of the list can be correctly batched for
input to a single ControlNet.`,name:"image"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image. Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"height"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image. Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"width"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. This is sent to <code>tokenizer_2</code>
and <code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, pooled text embeddings are generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs (prompt
weighting). If not provided, pooled <code>negative_prompt_embeds</code> are generated from <code>negative_prompt</code> input
argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeine class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl.py#L914",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned containing the output images.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),V=new Ms({props:{anchor:"diffusers.StableDiffusionXLControlNetPipeline.__call__.example",$$slots:{default:[Ei]},$$scope:{ctx:P}}}),Se=new M({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionXLControlNetPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl.py#L858"}}),De=new M({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionXLControlNetPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl.py#L234"}}),Pe=new M({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionXLControlNetPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl.py#L251"}}),ke=new M({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionXLControlNetPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl.py#L835"}}),Je=new M({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionXLControlNetPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl.py#L226"}}),Xe=new M({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionXLControlNetPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl.py#L242"}}),Ue=new M({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": Optional = None"},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Optional = None"},{name:"negative_prompt_2",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl.py#L259"}}),$e=new M({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionXLControlNetPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:""},{name:"embedding_dim",val:" = 512"},{name:"dtype",val:" = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetPipeline.get_guidance_scale_embedding.timesteps",description:`<strong>timesteps</strong> (<code>torch.Tensor</code>) &#x2014;
generate embedding vectors at these timesteps`,name:"timesteps"},{anchor:"diffusers.StableDiffusionXLControlNetPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
dimension of the embeddings to generate
dtype &#x2014;
data type of the generated embeddings`,name:"embedding_dim"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl.py#L863",returnDescription:`
<p>Embedding vectors with shape <code>(len(timesteps), embedding_dim)</code></p>
`,returnType:`
<p><code>torch.FloatTensor</code></p>
`}}),Ze=new gn({}),We=new M({props:{name:"class diffusers.StableDiffusionXLControlNetImg2ImgPipeline",anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": Union"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code> CLIPTextModelWithProjection</code>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the unet during the denoising process. If you set multiple ControlNets
as a list, the outputs from each ControlNet are added together to create one combined additional
conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.25.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.requires_aesthetics_score",description:`<strong>requires_aesthetics_score</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;False&quot;</code>) &#x2014;
Whether the <code>unet</code> requires an <code>aesthetic_score</code> condition to be passed during inference. Also see the
config of <code>stabilityai/stable-diffusion-xl-refiner-1-0</code>.`,name:"requires_aesthetics_score"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings shall be forced to always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark library</a> to
watermark output images. If not defined, it will default to True if the package is installed, otherwise no
watermarker will be used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl_img2img.py#L149"}}),ze=new M({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"prompt_2",val:": Union = None"},{name:"image",val:": Union = None"},{name:"control_image",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"controlnet_conditioning_scale",val:": Union = 0.8"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": Union = 0.0"},{name:"control_guidance_end",val:": Union = 1.0"},{name:"original_size",val:": Tuple = None"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"target_size",val:": Tuple = None"},{name:"negative_original_size",val:": Optional = None"},{name:"negative_crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"negative_target_size",val:": Optional = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The initial image will be used as the starting point for the image generation process. Can also accept
image latents as <code>image</code>, if passing latents directly, it will not be encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition. ControlNet uses this input condition to generate guidance to Unet. If
the type is specified as <code>Torch.FloatTensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can
also be accepted as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If
height and/or width are passed, <code>image</code> is resized according to them. If multiple ControlNets are
specified in init, images must be passed as a list such that each element of the list can be correctly
batched for input to a single controlnet.`,name:"control_image"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to the size of control_image) &#x2014;
The height in pixels of the generated image. Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"height"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to the size of control_image) &#x2014;
The width in pixels of the generated image. Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"width"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>.`,name:"strength"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the controlnet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original unet. If multiple ControlNets are specified in init, you can set the
corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
In this mode, the ControlNet encoder will try best to recognize the content of the input image even if
you remove all prompts. The <code>guidance_scale</code> between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the controlnet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the controlnet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeine class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl_img2img.py#L991",returnDescription:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> if <code>return_dict</code> is True, otherwise a <code>tuple</code>
containing the output images.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),ne=new Ms({props:{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.__call__.example",$$slots:{default:[Fi]},$$scope:{ctx:P}}}),Be=new M({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl_img2img.py#L964"}}),Ge=new M({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl_img2img.py#L259"}}),Ee=new M({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl_img2img.py#L276"}}),Fe=new M({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl_img2img.py#L941"}}),Ae=new M({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl_img2img.py#L251"}}),Re=new M({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl_img2img.py#L267"}}),Ve=new M({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": Optional = None"},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Optional = None"},{name:"negative_prompt_2",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_sd_xl_img2img.py#L284"}}),Ye=new gn({}),Qe=new M({props:{name:"class diffusers.StableDiffusionXLControlNetInpaintPipeline",anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": ControlNetModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion XL uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code> CLIPTextModelWithProjection</code>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.25.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint_sd_xl.py#L142"}}),He=new M({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"prompt_2",val:": Union = None"},{name:"image",val:": Union = None"},{name:"mask_image",val:": Union = None"},{name:"control_image",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"strength",val:": float = 0.9999"},{name:"num_inference_steps",val:": int = 50"},{name:"denoising_start",val:": Optional = None"},{name:"denoising_end",val:": Optional = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"controlnet_conditioning_scale",val:": Union = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": Union = 0.0"},{name:"control_guidance_end",val:": Union = 1.0"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": Tuple = None"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"target_size",val:": Tuple = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be inpainted, <em>i.e.</em> parts of the image will
be masked out with <code>mask_image</code> and repainted according to <code>prompt</code>.`,name:"image"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be
repainted, while black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted
to a single channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L)
instead of 3, so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9999) &#x2014;
Conceptually, indicates how much to transform the masked portion of the reference <code>image</code>. Must be
between 0 and 1. <code>image</code> will be used as a starting point, adding more noise to it the larger the
<code>strength</code>. The number of denoising steps depends on the amount of noise initially added. When
<code>strength</code> is 1, added noise will be maximum and the denoising process will run for the full number of
iterations specified in <code>num_inference_steps</code>. A value of 1, therefore, essentially ignores the masked
portion of the reference <code>image</code>. Note that in the case of <code>denoising_start</code> being declared as an
integer, the value of <code>strength</code> will be ignored.`,name:"strength"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.denoising_start",description:`<strong>denoising_start</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, indicates the fraction (between 0.0 and 1.0) of the total denoising process to be
bypassed before it is initiated. Consequently, the initial part of the denoising process is skipped and
it is assumed that the passed <code>image</code> is a partly denoised image. Note that when this is specified,
strength will be ignored. The <code>denoising_start</code> parameter is particularly beneficial when this pipeline
is integrated into a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as detailed in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>.`,name:"denoising_start"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise (ca. final 20% of timesteps still needed) and should be
denoised by a successor pipeline that has <code>denoising_start</code> set to 0.8 so that it only denoises the
final 20% of the scheduler. The denoising_end parameter should ideally be utilized when this pipeline
forms a part of a &#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>.`,name:"denoising_end"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(width, height)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(width, height)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeine class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint_sd_xl.py#L1055",returnDescription:`
<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple. </code>tuple. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`
<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),pe=new Ms({props:{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.__call__.example",$$slots:{default:[Ai]},$$scope:{ctx:P}}}),Oe=new M({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint_sd_xl.py#L1028"}}),qe=new M({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint_sd_xl.py#L241"}}),Ke=new M({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint_sd_xl.py#L258"}}),et=new M({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint_sd_xl.py#L1005"}}),tt=new M({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint_sd_xl.py#L233"}}),nt=new M({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint_sd_xl.py#L249"}}),ot=new M({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": Optional = None"},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Optional = None"},{name:"negative_prompt_2",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionXLControlNetInpaintPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint_sd_xl.py#L266"}}),st=new gn({}),it=new M({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),{c(){p=n("meta"),S=s(),w=n("h1"),y=n("a"),j=n("span"),f(l.$$.fragment),D=s(),lt=n("span"),lt.textContent=Ls,hn=s(),ye=n("p"),ye.innerHTML=Ns,_n=s(),xe=n("p"),xe.textContent=js,bn=s(),Ce=n("p"),Ce.textContent=Ss,vn=s(),Ie=n("p"),Ie.innerHTML=Ds,wn=s(),Me=n("p"),Me.innerHTML=Ps,yn=s(),f(F.$$.fragment),xn=s(),Te=n("p"),Te.innerHTML=ks,Cn=s(),f(A.$$.fragment),In=s(),W=n("h2"),R=n("a"),rn=n("span"),f(Le.$$.fragment),no=s(),dt=n("span"),dt.textContent=Js,Mn=s(),x=n("div"),f(Ne.$$.fragment),oo=s(),pt=n("p"),pt.textContent=Xs,so=s(),ct=n("p"),ct.innerHTML=Us,io=s(),mt=n("p"),mt.textContent=$s,ao=s(),ft=n("ul"),ft.innerHTML=Zs,ro=s(),U=n("div"),f(je.$$.fragment),lo=s(),gt=n("p"),gt.textContent=Ws,po=s(),f(V.$$.fragment),co=s(),Y=n("div"),f(Se.$$.fragment),mo=s(),ut=n("p"),ut.textContent=zs,fo=s(),Q=n("div"),f(De.$$.fragment),go=s(),ht=n("p"),ht.innerHTML=Bs,uo=s(),H=n("div"),f(Pe.$$.fragment),ho=s(),_t=n("p"),_t.innerHTML=Gs,_o=s(),k=n("div"),f(ke.$$.fragment),bo=s(),bt=n("p"),bt.innerHTML=Es,vo=s(),vt=n("p"),vt.textContent=Fs,wo=s(),wt=n("p"),wt.innerHTML=As,yo=s(),O=n("div"),f(Je.$$.fragment),xo=s(),yt=n("p"),yt.textContent=Rs,Co=s(),q=n("div"),f(Xe.$$.fragment),Io=s(),xt=n("p"),xt.textContent=Vs,Mo=s(),K=n("div"),f(Ue.$$.fragment),To=s(),Ct=n("p"),Ct.textContent=Ys,Lo=s(),ee=n("div"),f($e.$$.fragment),No=s(),It=n("p"),It.innerHTML=Qs,Tn=s(),z=n("h2"),te=n("a"),ln=n("span"),f(Ze.$$.fragment),jo=s(),Mt=n("span"),Mt.textContent=Hs,Ln=s(),C=n("div"),f(We.$$.fragment),So=s(),Tt=n("p"),Tt.textContent=Os,Do=s(),Lt=n("p"),Lt.innerHTML=qs,Po=s(),Nt=n("p"),Nt.textContent=Ks,ko=s(),jt=n("ul"),jt.innerHTML=ei,Jo=s(),$=n("div"),f(ze.$$.fragment),Xo=s(),St=n("p"),St.textContent=ti,Uo=s(),f(ne.$$.fragment),$o=s(),oe=n("div"),f(Be.$$.fragment),Zo=s(),Dt=n("p"),Dt.textContent=ni,Wo=s(),se=n("div"),f(Ge.$$.fragment),zo=s(),Pt=n("p"),Pt.innerHTML=oi,Bo=s(),ie=n("div"),f(Ee.$$.fragment),Go=s(),kt=n("p"),kt.innerHTML=si,Eo=s(),J=n("div"),f(Fe.$$.fragment),Fo=s(),Jt=n("p"),Jt.innerHTML=ii,Ao=s(),Xt=n("p"),Xt.textContent=ai,Ro=s(),Ut=n("p"),Ut.innerHTML=ri,Vo=s(),ae=n("div"),f(Ae.$$.fragment),Yo=s(),$t=n("p"),$t.textContent=li,Qo=s(),re=n("div"),f(Re.$$.fragment),Ho=s(),Zt=n("p"),Zt.textContent=di,Oo=s(),le=n("div"),f(Ve.$$.fragment),qo=s(),Wt=n("p"),Wt.textContent=pi,Nn=s(),B=n("h2"),de=n("a"),dn=n("span"),f(Ye.$$.fragment),Ko=s(),zt=n("span"),zt.textContent=ci,jn=s(),I=n("div"),f(Qe.$$.fragment),es=s(),Bt=n("p"),Bt.textContent=mi,ts=s(),Gt=n("p"),Gt.innerHTML=fi,ns=s(),Et=n("p"),Et.textContent=gi,os=s(),Ft=n("ul"),Ft.innerHTML=ui,ss=s(),Z=n("div"),f(He.$$.fragment),is=s(),At=n("p"),At.textContent=hi,as=s(),f(pe.$$.fragment),rs=s(),ce=n("div"),f(Oe.$$.fragment),ls=s(),Rt=n("p"),Rt.textContent=_i,ds=s(),me=n("div"),f(qe.$$.fragment),ps=s(),Vt=n("p"),Vt.innerHTML=bi,cs=s(),fe=n("div"),f(Ke.$$.fragment),ms=s(),Yt=n("p"),Yt.innerHTML=vi,fs=s(),X=n("div"),f(et.$$.fragment),gs=s(),Qt=n("p"),Qt.innerHTML=wi,us=s(),Ht=n("p"),Ht.textContent=yi,hs=s(),Ot=n("p"),Ot.innerHTML=xi,_s=s(),ge=n("div"),f(tt.$$.fragment),bs=s(),qt=n("p"),qt.textContent=Ci,vs=s(),ue=n("div"),f(nt.$$.fragment),ws=s(),Kt=n("p"),Kt.textContent=Ii,ys=s(),he=n("div"),f(ot.$$.fragment),xs=s(),en=n("p"),en.textContent=Mi,Sn=s(),G=n("h2"),_e=n("a"),pn=n("span"),f(st.$$.fragment),Cs=s(),tn=n("span"),tn.textContent=Ti,Dn=s(),E=n("div"),f(it.$$.fragment),Is=s(),nn=n("p"),nn.textContent=Li,this.h()},l(t){const c=zi("svelte-1phssyn",document.head);p=o(c,"META",{name:!0,content:!0}),c.forEach(a),S=i(t),w=o(t,"H1",{class:!0});var at=m(w);y=o(at,"A",{id:!0,class:!0,href:!0});var cn=m(y);j=o(cn,"SPAN",{});var mn=m(j);g(l.$$.fragment,mn),mn.forEach(a),cn.forEach(a),D=i(at),lt=o(at,"SPAN",{"data-svelte-h":!0}),r(lt)!=="svelte-14isvjv"&&(lt.textContent=Ls),at.forEach(a),hn=i(t),ye=o(t,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1v2xz23"&&(ye.innerHTML=Ns),_n=i(t),xe=o(t,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1dn0wji"&&(xe.textContent=js),bn=i(t),Ce=o(t,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1cwsb16"&&(Ce.textContent=Ss),vn=i(t),Ie=o(t,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-fbiw6t"&&(Ie.innerHTML=Ds),wn=i(t),Me=o(t,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-qc26k5"&&(Me.innerHTML=Ps),yn=i(t),g(F.$$.fragment,t),xn=i(t),Te=o(t,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1gi3meg"&&(Te.innerHTML=ks),Cn=i(t),g(A.$$.fragment,t),In=i(t),W=o(t,"H2",{class:!0});var rt=m(W);R=o(rt,"A",{id:!0,class:!0,href:!0});var fn=m(R);rn=o(fn,"SPAN",{});var Ni=m(rn);g(Le.$$.fragment,Ni),Ni.forEach(a),fn.forEach(a),no=i(rt),dt=o(rt,"SPAN",{"data-svelte-h":!0}),r(dt)!=="svelte-1lgityb"&&(dt.textContent=Js),rt.forEach(a),Mn=i(t),x=o(t,"DIV",{class:!0});var T=m(x);g(Ne.$$.fragment,T),oo=i(T),pt=o(T,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-ehlo5w"&&(pt.textContent=Xs),so=i(T),ct=o(T,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-s6xyvg"&&(ct.innerHTML=Us),io=i(T),mt=o(T,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-14s6m4u"&&(mt.textContent=$s),ao=i(T),ft=o(T,"UL",{"data-svelte-h":!0}),r(ft)!=="svelte-1wxgd8i"&&(ft.innerHTML=Zs),ro=i(T),U=o(T,"DIV",{class:!0});var on=m(U);g(je.$$.fragment,on),lo=i(on),gt=o(on,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-50j04k"&&(gt.textContent=Ws),po=i(on),g(V.$$.fragment,on),on.forEach(a),co=i(T),Y=o(T,"DIV",{class:!0});var kn=m(Y);g(Se.$$.fragment,kn),mo=i(kn),ut=o(kn,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-psupw6"&&(ut.textContent=zs),kn.forEach(a),fo=i(T),Q=o(T,"DIV",{class:!0});var Jn=m(Q);g(De.$$.fragment,Jn),go=i(Jn),ht=o(Jn,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1s3c06i"&&(ht.innerHTML=Bs),Jn.forEach(a),uo=i(T),H=o(T,"DIV",{class:!0});var Xn=m(H);g(Pe.$$.fragment,Xn),ho=i(Xn),_t=o(Xn,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-pkn4ui"&&(_t.innerHTML=Gs),Xn.forEach(a),_o=i(T),k=o(T,"DIV",{class:!0});var be=m(k);g(ke.$$.fragment,be),bo=i(be),bt=o(be,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-1f3tmq1"&&(bt.innerHTML=Es),vo=i(be),vt=o(be,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-xjijlp"&&(vt.textContent=Fs),wo=i(be),wt=o(be,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-hy0nzs"&&(wt.innerHTML=As),be.forEach(a),yo=i(T),O=o(T,"DIV",{class:!0});var Un=m(O);g(Je.$$.fragment,Un),xo=i(Un),yt=o(Un,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-14bnrb6"&&(yt.textContent=Rs),Un.forEach(a),Co=i(T),q=o(T,"DIV",{class:!0});var $n=m(q);g(Xe.$$.fragment,$n),Io=i($n),xt=o($n,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-1xwrf7t"&&(xt.textContent=Vs),$n.forEach(a),Mo=i(T),K=o(T,"DIV",{class:!0});var Zn=m(K);g(Ue.$$.fragment,Zn),To=i(Zn),Ct=o(Zn,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-16q0ax1"&&(Ct.textContent=Ys),Zn.forEach(a),Lo=i(T),ee=o(T,"DIV",{class:!0});var Wn=m(ee);g($e.$$.fragment,Wn),No=i(Wn),It=o(Wn,"P",{"data-svelte-h":!0}),r(It)!=="svelte-vo59ec"&&(It.innerHTML=Qs),Wn.forEach(a),T.forEach(a),Tn=i(t),z=o(t,"H2",{class:!0});var zn=m(z);te=o(zn,"A",{id:!0,class:!0,href:!0});var ji=m(te);ln=o(ji,"SPAN",{});var Si=m(ln);g(Ze.$$.fragment,Si),Si.forEach(a),ji.forEach(a),jo=i(zn),Mt=o(zn,"SPAN",{"data-svelte-h":!0}),r(Mt)!=="svelte-iv8b0z"&&(Mt.textContent=Hs),zn.forEach(a),Ln=i(t),C=o(t,"DIV",{class:!0});var L=m(C);g(We.$$.fragment,L),So=i(L),Tt=o(L,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-1q9vn04"&&(Tt.textContent=Os),Do=i(L),Lt=o(L,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-1bjwwin"&&(Lt.innerHTML=qs),Po=i(L),Nt=o(L,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-14s6m4u"&&(Nt.textContent=Ks),ko=i(L),jt=o(L,"UL",{"data-svelte-h":!0}),r(jt)!=="svelte-14967ut"&&(jt.innerHTML=ei),Jo=i(L),$=o(L,"DIV",{class:!0});var sn=m($);g(ze.$$.fragment,sn),Xo=i(sn),St=o(sn,"P",{"data-svelte-h":!0}),r(St)!=="svelte-v78lg8"&&(St.textContent=ti),Uo=i(sn),g(ne.$$.fragment,sn),sn.forEach(a),$o=i(L),oe=o(L,"DIV",{class:!0});var Bn=m(oe);g(Be.$$.fragment,Bn),Zo=i(Bn),Dt=o(Bn,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-psupw6"&&(Dt.textContent=ni),Bn.forEach(a),Wo=i(L),se=o(L,"DIV",{class:!0});var Gn=m(se);g(Ge.$$.fragment,Gn),zo=i(Gn),Pt=o(Gn,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-1s3c06i"&&(Pt.innerHTML=oi),Gn.forEach(a),Bo=i(L),ie=o(L,"DIV",{class:!0});var En=m(ie);g(Ee.$$.fragment,En),Go=i(En),kt=o(En,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-pkn4ui"&&(kt.innerHTML=si),En.forEach(a),Eo=i(L),J=o(L,"DIV",{class:!0});var ve=m(J);g(Fe.$$.fragment,ve),Fo=i(ve),Jt=o(ve,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1f3tmq1"&&(Jt.innerHTML=ii),Ao=i(ve),Xt=o(ve,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-xjijlp"&&(Xt.textContent=ai),Ro=i(ve),Ut=o(ve,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-hy0nzs"&&(Ut.innerHTML=ri),ve.forEach(a),Vo=i(L),ae=o(L,"DIV",{class:!0});var Fn=m(ae);g(Ae.$$.fragment,Fn),Yo=i(Fn),$t=o(Fn,"P",{"data-svelte-h":!0}),r($t)!=="svelte-14bnrb6"&&($t.textContent=li),Fn.forEach(a),Qo=i(L),re=o(L,"DIV",{class:!0});var An=m(re);g(Re.$$.fragment,An),Ho=i(An),Zt=o(An,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-1xwrf7t"&&(Zt.textContent=di),An.forEach(a),Oo=i(L),le=o(L,"DIV",{class:!0});var Rn=m(le);g(Ve.$$.fragment,Rn),qo=i(Rn),Wt=o(Rn,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-16q0ax1"&&(Wt.textContent=pi),Rn.forEach(a),L.forEach(a),Nn=i(t),B=o(t,"H2",{class:!0});var Vn=m(B);de=o(Vn,"A",{id:!0,class:!0,href:!0});var Di=m(de);dn=o(Di,"SPAN",{});var Pi=m(dn);g(Ye.$$.fragment,Pi),Pi.forEach(a),Di.forEach(a),Ko=i(Vn),zt=o(Vn,"SPAN",{"data-svelte-h":!0}),r(zt)!=="svelte-chodh2"&&(zt.textContent=ci),Vn.forEach(a),jn=i(t),I=o(t,"DIV",{class:!0});var N=m(I);g(Qe.$$.fragment,N),es=i(N),Bt=o(N,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-1q4yve"&&(Bt.textContent=mi),ts=i(N),Gt=o(N,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-1bjwwin"&&(Gt.innerHTML=fi),ns=i(N),Et=o(N,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-14s6m4u"&&(Et.textContent=gi),os=i(N),Ft=o(N,"UL",{"data-svelte-h":!0}),r(Ft)!=="svelte-17tyiv0"&&(Ft.innerHTML=ui),ss=i(N),Z=o(N,"DIV",{class:!0});var an=m(Z);g(He.$$.fragment,an),is=i(an),At=o(an,"P",{"data-svelte-h":!0}),r(At)!=="svelte-v78lg8"&&(At.textContent=hi),as=i(an),g(pe.$$.fragment,an),an.forEach(a),rs=i(N),ce=o(N,"DIV",{class:!0});var Yn=m(ce);g(Oe.$$.fragment,Yn),ls=i(Yn),Rt=o(Yn,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-psupw6"&&(Rt.textContent=_i),Yn.forEach(a),ds=i(N),me=o(N,"DIV",{class:!0});var Qn=m(me);g(qe.$$.fragment,Qn),ps=i(Qn),Vt=o(Qn,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-1s3c06i"&&(Vt.innerHTML=bi),Qn.forEach(a),cs=i(N),fe=o(N,"DIV",{class:!0});var Hn=m(fe);g(Ke.$$.fragment,Hn),ms=i(Hn),Yt=o(Hn,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-pkn4ui"&&(Yt.innerHTML=vi),Hn.forEach(a),fs=i(N),X=o(N,"DIV",{class:!0});var we=m(X);g(et.$$.fragment,we),gs=i(we),Qt=o(we,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-1f3tmq1"&&(Qt.innerHTML=wi),us=i(we),Ht=o(we,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-xjijlp"&&(Ht.textContent=yi),hs=i(we),Ot=o(we,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-hy0nzs"&&(Ot.innerHTML=xi),we.forEach(a),_s=i(N),ge=o(N,"DIV",{class:!0});var On=m(ge);g(tt.$$.fragment,On),bs=i(On),qt=o(On,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-14bnrb6"&&(qt.textContent=Ci),On.forEach(a),vs=i(N),ue=o(N,"DIV",{class:!0});var qn=m(ue);g(nt.$$.fragment,qn),ws=i(qn),Kt=o(qn,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-1xwrf7t"&&(Kt.textContent=Ii),qn.forEach(a),ys=i(N),he=o(N,"DIV",{class:!0});var Kn=m(he);g(ot.$$.fragment,Kn),xs=i(Kn),en=o(Kn,"P",{"data-svelte-h":!0}),r(en)!=="svelte-16q0ax1"&&(en.textContent=Mi),Kn.forEach(a),N.forEach(a),Sn=i(t),G=o(t,"H2",{class:!0});var eo=m(G);_e=o(eo,"A",{id:!0,class:!0,href:!0});var ki=m(_e);pn=o(ki,"SPAN",{});var Ji=m(pn);g(st.$$.fragment,Ji),Ji.forEach(a),ki.forEach(a),Cs=i(eo),tn=o(eo,"SPAN",{"data-svelte-h":!0}),r(tn)!=="svelte-1ocdz42"&&(tn.textContent=Ti),eo.forEach(a),Dn=i(t),E=o(t,"DIV",{class:!0});var to=m(E);g(it.$$.fragment,to),Is=i(to),nn=o(to,"P",{"data-svelte-h":!0}),r(nn)!=="svelte-1qpjiuf"&&(nn.textContent=Li),to.forEach(a),this.h()},h(){d(p,"name","hf:doc:metadata"),d(p,"content",JSON.stringify(Vi)),d(y,"id","controlnet-with-stable-diffusion-xl"),d(y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(y,"href","#controlnet-with-stable-diffusion-xl"),d(w,"class","relative group"),d(R,"id","diffusers.StableDiffusionXLControlNetPipeline"),d(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(R,"href","#diffusers.StableDiffusionXLControlNetPipeline"),d(W,"class","relative group"),d(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(te,"id","diffusers.StableDiffusionXLControlNetImg2ImgPipeline"),d(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(te,"href","#diffusers.StableDiffusionXLControlNetImg2ImgPipeline"),d(z,"class","relative group"),d($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(de,"id","diffusers.StableDiffusionXLControlNetInpaintPipeline"),d(de,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(de,"href","#diffusers.StableDiffusionXLControlNetInpaintPipeline"),d(B,"class","relative group"),d(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(_e,"id","diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"),d(_e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(_e,"href","#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"),d(G,"class","relative group"),d(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,c){e(document.head,p),v(t,S,c),v(t,w,c),e(w,y),e(y,j),u(l,j,null),e(w,D),e(w,lt),v(t,hn,c),v(t,ye,c),v(t,_n,c),v(t,xe,c),v(t,bn,c),v(t,Ce,c),v(t,vn,c),v(t,Ie,c),v(t,wn,c),v(t,Me,c),v(t,yn,c),u(F,t,c),v(t,xn,c),v(t,Te,c),v(t,Cn,c),u(A,t,c),v(t,In,c),v(t,W,c),e(W,R),e(R,rn),u(Le,rn,null),e(W,no),e(W,dt),v(t,Mn,c),v(t,x,c),u(Ne,x,null),e(x,oo),e(x,pt),e(x,so),e(x,ct),e(x,io),e(x,mt),e(x,ao),e(x,ft),e(x,ro),e(x,U),u(je,U,null),e(U,lo),e(U,gt),e(U,po),u(V,U,null),e(x,co),e(x,Y),u(Se,Y,null),e(Y,mo),e(Y,ut),e(x,fo),e(x,Q),u(De,Q,null),e(Q,go),e(Q,ht),e(x,uo),e(x,H),u(Pe,H,null),e(H,ho),e(H,_t),e(x,_o),e(x,k),u(ke,k,null),e(k,bo),e(k,bt),e(k,vo),e(k,vt),e(k,wo),e(k,wt),e(x,yo),e(x,O),u(Je,O,null),e(O,xo),e(O,yt),e(x,Co),e(x,q),u(Xe,q,null),e(q,Io),e(q,xt),e(x,Mo),e(x,K),u(Ue,K,null),e(K,To),e(K,Ct),e(x,Lo),e(x,ee),u($e,ee,null),e(ee,No),e(ee,It),v(t,Tn,c),v(t,z,c),e(z,te),e(te,ln),u(Ze,ln,null),e(z,jo),e(z,Mt),v(t,Ln,c),v(t,C,c),u(We,C,null),e(C,So),e(C,Tt),e(C,Do),e(C,Lt),e(C,Po),e(C,Nt),e(C,ko),e(C,jt),e(C,Jo),e(C,$),u(ze,$,null),e($,Xo),e($,St),e($,Uo),u(ne,$,null),e(C,$o),e(C,oe),u(Be,oe,null),e(oe,Zo),e(oe,Dt),e(C,Wo),e(C,se),u(Ge,se,null),e(se,zo),e(se,Pt),e(C,Bo),e(C,ie),u(Ee,ie,null),e(ie,Go),e(ie,kt),e(C,Eo),e(C,J),u(Fe,J,null),e(J,Fo),e(J,Jt),e(J,Ao),e(J,Xt),e(J,Ro),e(J,Ut),e(C,Vo),e(C,ae),u(Ae,ae,null),e(ae,Yo),e(ae,$t),e(C,Qo),e(C,re),u(Re,re,null),e(re,Ho),e(re,Zt),e(C,Oo),e(C,le),u(Ve,le,null),e(le,qo),e(le,Wt),v(t,Nn,c),v(t,B,c),e(B,de),e(de,dn),u(Ye,dn,null),e(B,Ko),e(B,zt),v(t,jn,c),v(t,I,c),u(Qe,I,null),e(I,es),e(I,Bt),e(I,ts),e(I,Gt),e(I,ns),e(I,Et),e(I,os),e(I,Ft),e(I,ss),e(I,Z),u(He,Z,null),e(Z,is),e(Z,At),e(Z,as),u(pe,Z,null),e(I,rs),e(I,ce),u(Oe,ce,null),e(ce,ls),e(ce,Rt),e(I,ds),e(I,me),u(qe,me,null),e(me,ps),e(me,Vt),e(I,cs),e(I,fe),u(Ke,fe,null),e(fe,ms),e(fe,Yt),e(I,fs),e(I,X),u(et,X,null),e(X,gs),e(X,Qt),e(X,us),e(X,Ht),e(X,hs),e(X,Ot),e(I,_s),e(I,ge),u(tt,ge,null),e(ge,bs),e(ge,qt),e(I,vs),e(I,ue),u(nt,ue,null),e(ue,ws),e(ue,Kt),e(I,ys),e(I,he),u(ot,he,null),e(he,xs),e(he,en),v(t,Sn,c),v(t,G,c),e(G,_e),e(_e,pn),u(st,pn,null),e(G,Cs),e(G,tn),v(t,Dn,c),v(t,E,c),u(it,E,null),e(E,Is),e(E,nn),Pn=!0},p(t,[c]){const at={};c&2&&(at.$$scope={dirty:c,ctx:t}),F.$set(at);const cn={};c&2&&(cn.$$scope={dirty:c,ctx:t}),A.$set(cn);const mn={};c&2&&(mn.$$scope={dirty:c,ctx:t}),V.$set(mn);const rt={};c&2&&(rt.$$scope={dirty:c,ctx:t}),ne.$set(rt);const fn={};c&2&&(fn.$$scope={dirty:c,ctx:t}),pe.$set(fn)},i(t){Pn||(h(l.$$.fragment,t),h(F.$$.fragment,t),h(A.$$.fragment,t),h(Le.$$.fragment,t),h(Ne.$$.fragment,t),h(je.$$.fragment,t),h(V.$$.fragment,t),h(Se.$$.fragment,t),h(De.$$.fragment,t),h(Pe.$$.fragment,t),h(ke.$$.fragment,t),h(Je.$$.fragment,t),h(Xe.$$.fragment,t),h(Ue.$$.fragment,t),h($e.$$.fragment,t),h(Ze.$$.fragment,t),h(We.$$.fragment,t),h(ze.$$.fragment,t),h(ne.$$.fragment,t),h(Be.$$.fragment,t),h(Ge.$$.fragment,t),h(Ee.$$.fragment,t),h(Fe.$$.fragment,t),h(Ae.$$.fragment,t),h(Re.$$.fragment,t),h(Ve.$$.fragment,t),h(Ye.$$.fragment,t),h(Qe.$$.fragment,t),h(He.$$.fragment,t),h(pe.$$.fragment,t),h(Oe.$$.fragment,t),h(qe.$$.fragment,t),h(Ke.$$.fragment,t),h(et.$$.fragment,t),h(tt.$$.fragment,t),h(nt.$$.fragment,t),h(ot.$$.fragment,t),h(st.$$.fragment,t),h(it.$$.fragment,t),Pn=!0)},o(t){_(l.$$.fragment,t),_(F.$$.fragment,t),_(A.$$.fragment,t),_(Le.$$.fragment,t),_(Ne.$$.fragment,t),_(je.$$.fragment,t),_(V.$$.fragment,t),_(Se.$$.fragment,t),_(De.$$.fragment,t),_(Pe.$$.fragment,t),_(ke.$$.fragment,t),_(Je.$$.fragment,t),_(Xe.$$.fragment,t),_(Ue.$$.fragment,t),_($e.$$.fragment,t),_(Ze.$$.fragment,t),_(We.$$.fragment,t),_(ze.$$.fragment,t),_(ne.$$.fragment,t),_(Be.$$.fragment,t),_(Ge.$$.fragment,t),_(Ee.$$.fragment,t),_(Fe.$$.fragment,t),_(Ae.$$.fragment,t),_(Re.$$.fragment,t),_(Ve.$$.fragment,t),_(Ye.$$.fragment,t),_(Qe.$$.fragment,t),_(He.$$.fragment,t),_(pe.$$.fragment,t),_(Oe.$$.fragment,t),_(qe.$$.fragment,t),_(Ke.$$.fragment,t),_(et.$$.fragment,t),_(tt.$$.fragment,t),_(nt.$$.fragment,t),_(ot.$$.fragment,t),_(st.$$.fragment,t),_(it.$$.fragment,t),Pn=!1},d(t){t&&(a(S),a(w),a(hn),a(ye),a(_n),a(xe),a(bn),a(Ce),a(vn),a(Ie),a(wn),a(Me),a(yn),a(xn),a(Te),a(Cn),a(In),a(W),a(Mn),a(x),a(Tn),a(z),a(Ln),a(C),a(Nn),a(B),a(jn),a(I),a(Sn),a(G),a(Dn),a(E)),a(p),b(l),b(F,t),b(A,t),b(Le),b(Ne),b(je),b(V),b(Se),b(De),b(Pe),b(ke),b(Je),b(Xe),b(Ue),b($e),b(Ze),b(We),b(ze),b(ne),b(Be),b(Ge),b(Ee),b(Fe),b(Ae),b(Re),b(Ve),b(Ye),b(Qe),b(He),b(pe),b(Oe),b(qe),b(Ke),b(et),b(tt),b(nt),b(ot),b(st),b(it)}}}const Vi={local:"controlnet-with-stable-diffusion-xl",sections:[{local:"diffusers.StableDiffusionXLControlNetPipeline",title:"StableDiffusionXLControlNetPipeline"},{local:"diffusers.StableDiffusionXLControlNetImg2ImgPipeline",title:"StableDiffusionXLControlNetImg2ImgPipeline"},{local:"diffusers.StableDiffusionXLControlNetInpaintPipeline",title:"StableDiffusionXLControlNetInpaintPipeline"},{local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",title:"StableDiffusionPipelineOutput"}],title:"ControlNet with Stable Diffusion XL"};function Yi(P){return $i(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class na extends Zi{constructor(p){super(),Wi(this,p,Yi,Ri,Ui,{})}}export{na as component};
