import{s as tt,n as et,o as st}from"../chunks/scheduler.f7e1785c.js";import{S as at,i as nt,g as M,s as a,r as p,A as Mt,h as i,f as e,c as n,j as lt,u,x as o,k as xl,y as it,a as s,v as y,d,t as c,w as j}from"../chunks/index.9f8f0838.js";import{C as r}from"../chunks/CodeBlock.b3510e34.js";import{H as ot}from"../chunks/Heading.6643a2f7.js";function pt(Zl){let m,P,V,O,U,K,w,ql=`In this course we will use the 🤗 Datasets library to work with audio datasets. 🤗 Datasets is an open-source library for
downloading and preparing datasets from all modalities including audio. The library offers easy access to an unparalleled
selection of machine learning datasets publicly available on Hugging Face Hub. Moreover, 🤗 Datasets includes multiple
features tailored to audio datasets that simplify working with such datasets for both researchers and practitioners.`,ll,J,Wl="To begin working with audio datasets, make sure you have the 🤗 Datasets library installed:",tl,T,el,f,Bl=`One of the key defining features of 🤗 Datasets is the ability to download and prepare a dataset in just one line of
Python code using the <code>load_dataset()</code> function.`,sl,b,El=`Let’s load and explore and audio dataset called <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>, which contains
recordings of people asking an e-banking system questions in several languages and dialects.`,al,A,Ql=`To load the MINDS-14 dataset, we need to copy the dataset’s identifier on the Hub (<code>PolyAI/minds14</code>) and pass it
to the <code>load_dataset</code> function. We’ll also specify that we’re only interested in the Australian subset (<code>en-AU</code>) of
the data, and limit it to the training split:`,nl,C,Ml,I,_l="<strong>Output:</strong>",il,g,ol,k,Rl=`The dataset contains 654 audio files, each of which is accompanied by a transcription, an English translation, and a label
indicating the intent behind the person’s query. The audio column contains the raw audio data. Let’s take a closer look
at one of the examples:`,pl,v,ul,G,Fl="<strong>Output:</strong>",yl,$,dl,x,Yl="You may notice that the audio column contains several features. Here’s what they are:",cl,Z,Hl="<li><code>path</code>: the path to the audio file (<code>*.wav</code> in this case).</li> <li><code>array</code>: The decoded audio data, represented as a 1-dimensional NumPy array.</li> <li><code>sampling_rate</code>. The sampling rate of the audio file (8,000 Hz in this example).</li>",jl,q,zl=`The <code>intent_class</code> is a classification category of the audio recording. To convert this number into a meaningful string,
we can use the <code>int2str()</code> method:`,rl,W,ml,B,Nl="<strong>Output:</strong>",hl,E,Ul,Q,Sl=`If you look at the transcription feature, you can see that the audio file indeed has recorded a person asking a question
about paying a bill.`,wl,_,Xl=`If you plan to train an audio classifier on this subset of data, you may not necessarily need all of the features. For example,
the <code>lang_id</code> is going to have the same value for all examples, and won’t be useful. The <code>english_transcription</code> will likely
duplicate the <code>transcription</code> in this subset, so we can safely remove them.`,Jl,R,Ll="You can easily remove irrelevant features using 🤗 Datasets’ <code>remove_columns</code> method:",Tl,F,fl,Y,Vl="<strong>Output:</strong>",bl,H,Al,z,Dl=`Now that we’ve loaded and inspected the raw contents of the dataset, let’s listen to a few examples! We’ll use the <code>Blocks</code>
and <code>Audio</code> features from <code>Gradio</code> to decode a few random samples from the dataset:`,Cl,N,Il,S,Pl="If you’d like to, you can also visualize some of the examples. Let’s plot the waveform for the first example.",gl,X,kl,h,Ol='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot"/>',vl,L,Kl=`Try it out! Download another dialect or language of the MINDS-14 dataset, listen and visualize some examples to get a sense
of the variation in the whole dataset. You can find the full list of available languages <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">here</a>.`,Gl,D,$l;return U=new ot({props:{title:"Load and explore an audio dataset",local:"load-and-explore-an-audio-dataset",headingTag:"h1"}}),T=new r({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]",wrap:!1}}),C=new r({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`,wrap:!1}}),g=new r({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),v=new r({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`,wrap:!1}}),$=new r({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`,wrap:!1}}),W=new r({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`,wrap:!1}}),E=new r({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>',wrap:!1}}),F=new r({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`,wrap:!1}}),H=new r({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>',wrap:!1}}),N=new r({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),X=new r({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),{c(){m=M("meta"),P=a(),V=M("p"),O=a(),p(U.$$.fragment),K=a(),w=M("p"),w.textContent=ql,ll=a(),J=M("p"),J.textContent=Wl,tl=a(),p(T.$$.fragment),el=a(),f=M("p"),f.innerHTML=Bl,sl=a(),b=M("p"),b.innerHTML=El,al=a(),A=M("p"),A.innerHTML=Ql,nl=a(),p(C.$$.fragment),Ml=a(),I=M("p"),I.innerHTML=_l,il=a(),p(g.$$.fragment),ol=a(),k=M("p"),k.textContent=Rl,pl=a(),p(v.$$.fragment),ul=a(),G=M("p"),G.innerHTML=Fl,yl=a(),p($.$$.fragment),dl=a(),x=M("p"),x.textContent=Yl,cl=a(),Z=M("ul"),Z.innerHTML=Hl,jl=a(),q=M("p"),q.innerHTML=zl,rl=a(),p(W.$$.fragment),ml=a(),B=M("p"),B.innerHTML=Nl,hl=a(),p(E.$$.fragment),Ul=a(),Q=M("p"),Q.textContent=Sl,wl=a(),_=M("p"),_.innerHTML=Xl,Jl=a(),R=M("p"),R.innerHTML=Ll,Tl=a(),p(F.$$.fragment),fl=a(),Y=M("p"),Y.innerHTML=Vl,bl=a(),p(H.$$.fragment),Al=a(),z=M("p"),z.innerHTML=Dl,Cl=a(),p(N.$$.fragment),Il=a(),S=M("p"),S.textContent=Pl,gl=a(),p(X.$$.fragment),kl=a(),h=M("div"),h.innerHTML=Ol,vl=a(),L=M("p"),L.innerHTML=Kl,Gl=a(),D=M("p"),this.h()},l(l){const t=Mt("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(e),P=n(l),V=i(l,"P",{}),lt(V).forEach(e),O=n(l),u(U.$$.fragment,l),K=n(l),w=i(l,"P",{"data-svelte-h":!0}),o(w)!=="svelte-14tdruz"&&(w.textContent=ql),ll=n(l),J=i(l,"P",{"data-svelte-h":!0}),o(J)!=="svelte-16weaia"&&(J.textContent=Wl),tl=n(l),u(T.$$.fragment,l),el=n(l),f=i(l,"P",{"data-svelte-h":!0}),o(f)!=="svelte-vy8pv5"&&(f.innerHTML=Bl),sl=n(l),b=i(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1ibmxou"&&(b.innerHTML=El),al=n(l),A=i(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-11xjat8"&&(A.innerHTML=Ql),nl=n(l),u(C.$$.fragment,l),Ml=n(l),I=i(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1mvdyro"&&(I.innerHTML=_l),il=n(l),u(g.$$.fragment,l),ol=n(l),k=i(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-7t6f49"&&(k.textContent=Rl),pl=n(l),u(v.$$.fragment,l),ul=n(l),G=i(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1mvdyro"&&(G.innerHTML=Fl),yl=n(l),u($.$$.fragment,l),dl=n(l),x=i(l,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1xpct0w"&&(x.textContent=Yl),cl=n(l),Z=i(l,"UL",{"data-svelte-h":!0}),o(Z)!=="svelte-n6enht"&&(Z.innerHTML=Hl),jl=n(l),q=i(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1wz2ihr"&&(q.innerHTML=zl),rl=n(l),u(W.$$.fragment,l),ml=n(l),B=i(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1mvdyro"&&(B.innerHTML=Nl),hl=n(l),u(E.$$.fragment,l),Ul=n(l),Q=i(l,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1a1ybip"&&(Q.textContent=Sl),wl=n(l),_=i(l,"P",{"data-svelte-h":!0}),o(_)!=="svelte-11cpnca"&&(_.innerHTML=Xl),Jl=n(l),R=i(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-gmqz2q"&&(R.innerHTML=Ll),Tl=n(l),u(F.$$.fragment,l),fl=n(l),Y=i(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1mvdyro"&&(Y.innerHTML=Vl),bl=n(l),u(H.$$.fragment,l),Al=n(l),z=i(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1iz3f0u"&&(z.innerHTML=Dl),Cl=n(l),u(N.$$.fragment,l),Il=n(l),S=i(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-14zloga"&&(S.textContent=Pl),gl=n(l),u(X.$$.fragment,l),kl=n(l),h=i(l,"DIV",{class:!0,"data-svelte-h":!0}),o(h)!=="svelte-1ym6zda"&&(h.innerHTML=Ol),vl=n(l),L=i(l,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1frcml4"&&(L.innerHTML=Kl),Gl=n(l),D=i(l,"P",{}),lt(D).forEach(e),this.h()},h(){xl(m,"name","hf:doc:metadata"),xl(m,"content",ut),xl(h,"class","flex justify-center")},m(l,t){it(document.head,m),s(l,P,t),s(l,V,t),s(l,O,t),y(U,l,t),s(l,K,t),s(l,w,t),s(l,ll,t),s(l,J,t),s(l,tl,t),y(T,l,t),s(l,el,t),s(l,f,t),s(l,sl,t),s(l,b,t),s(l,al,t),s(l,A,t),s(l,nl,t),y(C,l,t),s(l,Ml,t),s(l,I,t),s(l,il,t),y(g,l,t),s(l,ol,t),s(l,k,t),s(l,pl,t),y(v,l,t),s(l,ul,t),s(l,G,t),s(l,yl,t),y($,l,t),s(l,dl,t),s(l,x,t),s(l,cl,t),s(l,Z,t),s(l,jl,t),s(l,q,t),s(l,rl,t),y(W,l,t),s(l,ml,t),s(l,B,t),s(l,hl,t),y(E,l,t),s(l,Ul,t),s(l,Q,t),s(l,wl,t),s(l,_,t),s(l,Jl,t),s(l,R,t),s(l,Tl,t),y(F,l,t),s(l,fl,t),s(l,Y,t),s(l,bl,t),y(H,l,t),s(l,Al,t),s(l,z,t),s(l,Cl,t),y(N,l,t),s(l,Il,t),s(l,S,t),s(l,gl,t),y(X,l,t),s(l,kl,t),s(l,h,t),s(l,vl,t),s(l,L,t),s(l,Gl,t),s(l,D,t),$l=!0},p:et,i(l){$l||(d(U.$$.fragment,l),d(T.$$.fragment,l),d(C.$$.fragment,l),d(g.$$.fragment,l),d(v.$$.fragment,l),d($.$$.fragment,l),d(W.$$.fragment,l),d(E.$$.fragment,l),d(F.$$.fragment,l),d(H.$$.fragment,l),d(N.$$.fragment,l),d(X.$$.fragment,l),$l=!0)},o(l){c(U.$$.fragment,l),c(T.$$.fragment,l),c(C.$$.fragment,l),c(g.$$.fragment,l),c(v.$$.fragment,l),c($.$$.fragment,l),c(W.$$.fragment,l),c(E.$$.fragment,l),c(F.$$.fragment,l),c(H.$$.fragment,l),c(N.$$.fragment,l),c(X.$$.fragment,l),$l=!1},d(l){l&&(e(P),e(V),e(O),e(K),e(w),e(ll),e(J),e(tl),e(el),e(f),e(sl),e(b),e(al),e(A),e(nl),e(Ml),e(I),e(il),e(ol),e(k),e(pl),e(ul),e(G),e(yl),e(dl),e(x),e(cl),e(Z),e(jl),e(q),e(rl),e(ml),e(B),e(hl),e(Ul),e(Q),e(wl),e(_),e(Jl),e(R),e(Tl),e(fl),e(Y),e(bl),e(Al),e(z),e(Cl),e(Il),e(S),e(gl),e(kl),e(h),e(vl),e(L),e(Gl),e(D)),e(m),j(U,l),j(T,l),j(C,l),j(g,l),j(v,l),j($,l),j(W,l),j(E,l),j(F,l),j(H,l),j(N,l),j(X,l)}}}const ut='{"title":"Load and explore an audio dataset","local":"load-and-explore-an-audio-dataset","sections":[],"depth":1}';function yt(Zl){return st(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mt extends at{constructor(m){super(),nt(this,m,yt,pt,tt,{})}}export{mt as component};
