import{s as ns,o as os,n as ts}from"../chunks/scheduler.6062bdaf.js";import{S as rs,i as as,g as r,s as n,r as p,A as ss,h as a,f as s,c as o,j as _,u as d,x as c,k as b,y as t,a as v,v as h,d as u,t as m,w as f}from"../chunks/index.4bca734e.js";import{T as is}from"../chunks/Tip.b9ac1f03.js";import{D as y}from"../chunks/Docstring.ed07512f.js";import{C as ls}from"../chunks/CodeBlock.fa01571c.js";import{E as cs}from"../chunks/ExampleCodeBlock.823fb173.js";import{H as bo}from"../chunks/Heading.723dceba.js";function gs(ut){let x,j="Raises the following error:",T,w,k=`<li><p><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if an organization token (starts with “api_org”) is passed. Use must use
your own personal access token (see <a href="https://hf.co/settings/tokens" rel="nofollow">https://hf.co/settings/tokens</a>).</p></li> <li><p><a href="https://docs.python.org/3/library/exceptions.html#EnvironmentError" rel="nofollow"><code>EnvironmentError</code></a>
if you are trying to clone the repository in a non-empty folder, or if the
<code>git</code> operations raise errors.</p></li>`;return{c(){x=r("p"),x.textContent=j,T=n(),w=r("ul"),w.innerHTML=k},l($){x=a($,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1f6kjc7"&&(x.textContent=j),T=o($),w=a($,"UL",{"data-svelte-h":!0}),c(w)!=="svelte-dnmxmk"&&(w.innerHTML=k)},m($,R){v($,x,R),v($,T,R),v($,w,R)},p:ts,d($){$&&(s(x),s(T),s(w))}}}function ps(ut){let x,j="Examples:",T,w,k;return w=new ls({props:{code:"d2l0aCUyMFJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIydGV4dC1maWxlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsb25lX2Zyb20lM0QlMjIlM0N1c2VyJTNFJTJGdGV4dC1maWxlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEVHJ1ZSUyQyUwQSkuY29tbWl0KCUyMk15JTIwZmlyc3QlMjBmaWxlJTIwJTNBKSUyMiklM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwb3BlbiglMjJmaWxlLnR4dCUyMiUyQyUyMCUyMnclMkIlMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShqc29uLmR1bXBzKCU3QiUyMmhleSUyMiUzQSUyMDglN0QpKSUwQSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjB0b3JjaC5ubi5UcmFuc2Zvcm1lcigpJTBBd2l0aCUyMFJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIydG9yY2gtbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjbG9uZV9mcm9tJTNEJTIyJTNDdXNlciUzRSUyRnRvcmNoLW1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW4lM0RUcnVlJTJDJTBBKS5jb21taXQoJTIyTXklMjBjb29sJTIwbW9kZWwlMjAlM0EpJTIyKSUzQSUwQSUyMCUyMCUyMCUyMHRvcmNoLnNhdmUobW9kZWwuc3RhdGVfZGljdCgpJTJDJTIwJTIybW9kZWwucHQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Repository(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;text-files&quot;</span>,
<span class="hljs-meta">... </span>    clone_from=<span class="hljs-string">&quot;&lt;user&gt;/text-files&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">&gt;&gt;&gt; </span>).commit(<span class="hljs-string">&quot;My first file :)&quot;</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;file.txt&quot;</span>, <span class="hljs-string">&quot;w+&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(json.dumps({<span class="hljs-string">&quot;hey&quot;</span>: <span class="hljs-number">8</span>}))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = torch.nn.Transformer()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Repository(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;torch-model&quot;</span>,
<span class="hljs-meta">... </span>    clone_from=<span class="hljs-string">&quot;&lt;user&gt;/torch-model&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">&gt;&gt;&gt; </span>).commit(<span class="hljs-string">&quot;My cool model :)&quot;</span>):
<span class="hljs-meta">... </span>    torch.save(model.state_dict(), <span class="hljs-string">&quot;model.pt&quot;</span>)`,wrap:!1}}),{c(){x=r("p"),x.textContent=j,T=n(),p(w.$$.fragment)},l($){x=a($,"P",{"data-svelte-h":!0}),c(x)!=="svelte-kvfsh7"&&(x.textContent=j),T=o($),d(w.$$.fragment,$)},m($,R){v($,x,R),v($,T,R),h(w,$,R),k=!0},p:ts,i($){k||(u(w.$$.fragment,$),k=!0)},o($){m(w.$$.fragment,$),k=!1},d($){$&&(s(x),s(T)),f(w,$)}}}function ds(ut){let x,j,T,w,k,$,R,Xr=`The <code>Repository</code> class is a helper class that wraps <code>git</code> and <code>git-lfs</code> commands. It provides tooling adapted
for managing repositories which can be very large.`,xn,ye,Kr=`It is the recommended tool as soon as any <code>git</code> operation is involved, or when collaboration will be a point
of focus with the repository itself.`,wn,$e,Cn,i,xe,vo,mt,Yr="Helper class to wrap the git and git-lfs commands.",yo,ft,ea=`The aim is to facilitate interacting with huggingface.co hosted model or
dataset repos, though not a lot here (if any) is actually specific to
huggingface.co.`,$o,I,we,xo,_t,ta="Instantiate a local clone of a git repo.",wo,bt,na=`If <code>clone_from</code> is set, the repo will be cloned from an existing remote repository.
If the remote repo does not exist, a <code>EnvironmentError</code> exception will be thrown.
Please create the remote repo first using <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`,Co,vt,oa=`<code>Repository</code> uses the local git credentials by default. If explicitly set, the <code>token</code>
or the <code>git_user</code>/<code>git_email</code> pair will be used instead.`,To,z,Ce,ko,yt,ra="Returns the current checked out branch.",Ro,D,Te,Io,$t,aa="Add a tag at the current head and push it",Do,xt,sa="If remote is None, will just be updated locally",Mo,wt,ia=`If no message is provided, the tag will be lightweight. if a message is
provided, the tag will be annotated.`,Lo,Q,ke,Po,Ct,la="Automatically track binary files with git-lfs.",Eo,G,Re,jo,Tt,ca=`Automatically track large files (files that weigh more than 10MBs) with
git-lfs.`,Uo,Z,Ie,Ho,kt,ga="Checks that <code>git</code> and <code>git-lfs</code> can be run.",Jo,M,De,No,Rt,pa=`Clone from a remote. If the folder already exists, will try to clone the
repository within it.`,Vo,It,da=`If this folder is a git repository with linked history, will try to
update the repository.`,Fo,X,qo,U,Me,Wo,Dt,ha=`Context manager utility to handle committing to a repository. This
automatically tracks large files (&gt;10Mb) with git-lfs. Set the
<code>track_large_files</code> argument to <code>False</code> if you wish to ignore that
behavior.`,Bo,K,So,Y,Le,Ao,Mt,ua="Delete a tag, both local and remote, if it exists",Oo,H,Pe,zo,Lt,ma="git add",Qo,Pt,fa=`Setting the <code>auto_lfs_track</code> parameter to <code>True</code> will automatically
track files that are larger than 10MB with <code>git-lfs</code>.`,Go,J,Ee,Zo,Et,_a="git checkout a given revision",Xo,jt,ba=`Specifying <code>create_branch_ok</code> to <code>True</code> will create the branch to the
given revision if that revision doesn’t exist.`,Ko,ee,je,Yo,Ut,va="git commit",er,te,Ue,tr,Ht,ya="Sets git username and email (only in the current repo).",nr,ne,He,or,Jt,$a="Sets the git credential helper to <code>store</code>",rr,oe,Je,ar,Nt,xa=`Get URL to last commit on HEAD. We assume it’s been pushed, and the url
scheme is the same one as for GitHub or HuggingFace.`,sr,re,Ne,ir,Vt,wa="Get commit sha on top of HEAD.",lr,ae,Ve,cr,Ft,Ca="git pull",gr,N,Fe,pr,qt,Ta="git push",dr,Wt,ka=`If used without setting <code>blocking</code>, will return url to commit on remote
repo. If used with <code>blocking=True</code>, will return a tuple containing the
url to commit and the command object to follow for information about the
process.`,hr,se,qe,ur,Bt,Ra="Get URL to origin remote.",mr,ie,We,fr,St,Ia="Return whether or not the git status is clean or not",_r,le,Be,br,At,Da="HF-specific. This enables upload support of files >5GB.",vr,ce,Se,yr,Ot,Ma="git lfs prune",$r,V,Ae,xr,zt,La="Tell git-lfs to track files according to a pattern.",wr,Qt,Pa=`Setting the <code>filename</code> argument to <code>True</code> will treat the arguments as
literal filenames, not as patterns. Any special glob characters in the
filename will be escaped when writing to the <code>.gitattributes</code> file.`,Cr,ge,Oe,Tr,Gt,Ea="Tell git-lfs to untrack those files.",kr,pe,ze,Rr,Zt,ja=`Returns a list of the files that are deleted in the working directory or
index.`,Ir,de,Qe,Dr,Xt,Ua=`Helper to add, commit, and push files to remote repository on the
HuggingFace Hub. Will automatically track large files (>10MB).`,Mr,he,Ge,Lr,Kt,Ha="Check if a tag exists or not.",Pr,ue,Ze,Er,Yt,Ja=`Blocking method: blocks all subsequent execution until all commands have
been processed.`,Tn,Xe,kn,F,Ke,jr,en,Na="Check if the folder is the root or part of a git repository",Rn,q,Ye,Ur,tn,Va="Check if the folder is a local clone of the remote_url",In,W,et,Hr,nn,Fa="Check if the file passed is tracked with git-lfs.",Dn,B,tt,Jr,on,qa="Check if file is git-ignored. Supports nested .gitignore files.",Mn,S,nt,Nr,rn,Wa="Returns a list of filenames that are to be staged.",Ln,A,ot,Vr,an,Ba="Check if the current checked-out branch is tracked upstream.",Pn,P,rt,Fr,sn,Sa="Check the number of commits that would be pushed upstream",qr,ln,Aa=`The name of the upstream repository with which the comparison should be
made.`,En,at,jn,st,Oa="The <code>Repository</code> utility offers several methods which can be launched asynchronously:",Un,it,za="<li><code>git_push</code></li> <li><code>git_pull</code></li> <li><code>push_to_hub</code></li> <li>The <code>commit</code> context manager</li>",Hn,lt,Qa="See below for utilities to manage such asynchronous methods.",Jn,C,ct,Wr,cn,Ga="Helper class to wrap the git and git-lfs commands.",Br,gn,Za=`The aim is to facilitate interacting with huggingface.co hosted model or
dataset repos, though not a lot here (if any) is actually specific to
huggingface.co.`,Sr,me,gt,Ar,pn,Xa="Returns the asynchronous commands that failed.",Or,fe,pt,zr,dn,Ka="Returns the asynchronous commands that are currently in progress.",Qr,_e,dt,Gr,hn,Ya=`Blocking method: blocks all subsequent execution until all commands have
been processed.`,Nn,O,ht,Zr,un,es="Utility to follow commands launched asynchronously.",Vn,$n,Fn;return k=new bo({props:{title:"Managing local and online repositories",local:"managing-local-and-online-repositories",headingTag:"h1"}}),$e=new bo({props:{title:"The Repository class",local:"huggingface_hub.Repository",headingTag:"h2"}}),xe=new y({props:{name:"class huggingface_hub.Repository",anchor:"huggingface_hub.Repository",parameters:[{name:"local_dir",val:": typing.Union[str, pathlib.Path]"},{name:"clone_from",val:": typing.Optional[str] = None"},{name:"repo_type",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Union[bool, str] = True"},{name:"git_user",val:": typing.Optional[str] = None"},{name:"git_email",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"skip_lfs_files",val:": bool = False"},{name:"client",val:": typing.Optional[huggingface_hub.hf_api.HfApi] = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L424"}}),we=new y({props:{name:"__init__",anchor:"huggingface_hub.Repository.__init__",parameters:[{name:"local_dir",val:": typing.Union[str, pathlib.Path]"},{name:"clone_from",val:": typing.Optional[str] = None"},{name:"repo_type",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Union[bool, str] = True"},{name:"git_user",val:": typing.Optional[str] = None"},{name:"git_email",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"skip_lfs_files",val:": bool = False"},{name:"client",val:": typing.Optional[huggingface_hub.hf_api.HfApi] = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.__init__.local_dir",description:`<strong>local_dir</strong> (<code>str</code> or <code>Path</code>) &#x2014;
path (e.g. <code>&apos;my_trained_model/&apos;</code>) to the local directory, where
the <code>Repository</code> will be initialized.`,name:"local_dir"},{anchor:"huggingface_hub.Repository.__init__.clone_from",description:`<strong>clone_from</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Either a repository url or <code>repo_id</code>.
Example:<ul>
<li><code>&quot;https://huggingface.co/philschmid/playground-tests&quot;</code></li>
<li><code>&quot;philschmid/playground-tests&quot;</code></li>
</ul>`,name:"clone_from"},{anchor:"huggingface_hub.Repository.__init__.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
To set when cloning a repo from a repo_id. Default is model.`,name:"repo_type"},{anchor:"huggingface_hub.Repository.__init__.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
A valid authentication token (see <a href="https://huggingface.co/settings/token" rel="nofollow">https://huggingface.co/settings/token</a>).
If <code>None</code> or <code>True</code> and machine is logged in (through <code>huggingface-cli login</code>
or <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/login#huggingface_hub.login">login()</a>), token will be retrieved from the cache.
If <code>False</code>, token is not sent in the request header.`,name:"token"},{anchor:"huggingface_hub.Repository.__init__.git_user",description:`<strong>git_user</strong> (<code>str</code>, <em>optional</em>) &#x2014;
will override the <code>git config user.name</code> for committing and
pushing files to the hub.`,name:"git_user"},{anchor:"huggingface_hub.Repository.__init__.git_email",description:`<strong>git_email</strong> (<code>str</code>, <em>optional</em>) &#x2014;
will override the <code>git config user.email</code> for committing and
pushing files to the hub.`,name:"git_email"},{anchor:"huggingface_hub.Repository.__init__.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision to checkout after initializing the repository. If the
revision doesn&#x2019;t exist, a branch will be created with that
revision name from the default branch&#x2019;s current HEAD.`,name:"revision"},{anchor:"huggingface_hub.Repository.__init__.skip_lfs_files",description:`<strong>skip_lfs_files</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
whether to skip git-LFS files or not.`,name:"skip_lfs_files"},{anchor:"huggingface_hub.Repository.__init__.client",description:`<strong>client</strong> (<code>HfApi</code>, <em>optional</em>) &#x2014;
Instance of <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> to use when calling the HF Hub API. A new
instance will be created if this is left to <code>None</code>.`,name:"client"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L435",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><ul>
<li>— <a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a>
if the remote repository set in <code>clone_from</code> does not exist.</li>
</ul></li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li></li>
</ul>
`}}),Ce=new y({props:{name:"current_branch",anchor:"huggingface_hub.Repository.current_branch",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L544",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Current checked out branch.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Te=new y({props:{name:"add_tag",anchor:"huggingface_hub.Repository.add_tag",parameters:[{name:"tag_name",val:": str"},{name:"message",val:": typing.Optional[str] = None"},{name:"remote",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.add_tag.tag_name",description:`<strong>tag_name</strong> (<code>str</code>) &#x2014;
The name of the tag to be added.`,name:"tag_name"},{anchor:"huggingface_hub.Repository.add_tag.message",description:`<strong>message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The message that accompanies the tag. The tag will turn into an
annotated tag if a message is passed.`,name:"message"},{anchor:"huggingface_hub.Repository.add_tag.remote",description:`<strong>remote</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The remote on which to add the tag.`,name:"remote"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L1228"}}),ke=new y({props:{name:"auto_track_binary_files",anchor:"huggingface_hub.Repository.auto_track_binary_files",parameters:[{name:"pattern",val:": str = '.'"}],parametersDescription:[{anchor:"huggingface_hub.Repository.auto_track_binary_files.pattern",description:`<strong>pattern</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201D;.&#x201C;) &#x2014;
The pattern with which to track files that are binary.`,name:"pattern"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L870",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of filenames that are now tracked due to being
binary files</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Re=new y({props:{name:"auto_track_large_files",anchor:"huggingface_hub.Repository.auto_track_large_files",parameters:[{name:"pattern",val:": str = '.'"}],parametersDescription:[{anchor:"huggingface_hub.Repository.auto_track_large_files.pattern",description:`<strong>pattern</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201D;.&#x201C;) &#x2014;
The pattern with which to track files that are above 10MBs.`,name:"pattern"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L913",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of filenames that are now tracked due to their
size.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Ie=new y({props:{name:"check_git_versions",anchor:"huggingface_hub.Repository.check_git_versions",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L559",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><ul>
<li>— <a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a>
if <code>git</code> or <code>git-lfs</code> are not installed.</li>
</ul></li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li></li>
</ul>
`}}),De=new y({props:{name:"clone_from",anchor:"huggingface_hub.Repository.clone_from",parameters:[{name:"repo_url",val:": str"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.clone_from.repo_url",description:`<strong>repo_url</strong> (<code>str</code>) &#x2014;
The URL from which to clone the repository`,name:"repo_url"},{anchor:"huggingface_hub.Repository.clone_from.token",description:`<strong>token</strong> (<code>Union[str, bool]</code>, <em>optional</em>) &#x2014;
Whether to use the authentication token. It can be:<ul>
<li>a string which is the token itself</li>
<li><code>False</code>, which would not use the authentication token</li>
<li><code>True</code>, which would fetch the authentication token from the
local folder and use it (you should be logged in for this to
work).</li>
<li><code>None</code>, which would retrieve the value of
<code>self.huggingface_token</code>.</li>
</ul>`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L582"}}),X=new is({props:{$$slots:{default:[gs]},$$scope:{ctx:ut}}}),Me=new y({props:{name:"commit",anchor:"huggingface_hub.Repository.commit",parameters:[{name:"commit_message",val:": str"},{name:"branch",val:": typing.Optional[str] = None"},{name:"track_large_files",val:": bool = True"},{name:"blocking",val:": bool = True"},{name:"auto_lfs_prune",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.commit.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
Message to use for the commit.`,name:"commit_message"},{anchor:"huggingface_hub.Repository.commit.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The branch on which the commit will appear. This branch will be
checked-out before any operation.`,name:"branch"},{anchor:"huggingface_hub.Repository.commit.track_large_files",description:`<strong>track_large_files</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to automatically track large files or not. Will do so by
default.`,name:"track_large_files"},{anchor:"huggingface_hub.Repository.commit.blocking",description:`<strong>blocking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the function should return only when the <code>git push</code> has
finished.`,name:"blocking"},{anchor:"huggingface_hub.Repository.commit.auto_lfs_prune",description:`<strong>auto_lfs_prune</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to automatically prune files once they have been pushed
to the remote.`,name:"auto_lfs_prune"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L1312"}}),K=new cs({props:{anchor:"huggingface_hub.Repository.commit.example",$$slots:{default:[ps]},$$scope:{ctx:ut}}}),Le=new y({props:{name:"delete_tag",anchor:"huggingface_hub.Repository.delete_tag",parameters:[{name:"tag_name",val:": str"},{name:"remote",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.delete_tag.tag_name",description:`<strong>tag_name</strong> (<code>str</code>) &#x2014;
The tag name to delete.`,name:"tag_name"},{anchor:"huggingface_hub.Repository.delete_tag.remote",description:`<strong>remote</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The remote on which to delete the tag.`,name:"remote"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L1191",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if deleted, <code>False</code> if the tag didn’t exist.
If remote is not passed, will just be updated locally</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Pe=new y({props:{name:"git_add",anchor:"huggingface_hub.Repository.git_add",parameters:[{name:"pattern",val:": str = '.'"},{name:"auto_lfs_track",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_add.pattern",description:`<strong>pattern</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201D;.&#x201C;) &#x2014;
The pattern with which to add files to staging.`,name:"pattern"},{anchor:"huggingface_hub.Repository.git_add.auto_lfs_track",description:`<strong>auto_lfs_track</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to automatically track large and binary files with
git-lfs. Any file over 10MB in size, or in binary format, will
be automatically tracked.`,name:"auto_lfs_track"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L988"}}),Ee=new y({props:{name:"git_checkout",anchor:"huggingface_hub.Repository.git_checkout",parameters:[{name:"revision",val:": str"},{name:"create_branch_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_checkout.revision",description:`<strong>revision</strong> (<code>str</code>) &#x2014;
The revision to checkout.`,name:"revision"},{anchor:"huggingface_hub.Repository.git_checkout.create_branch_ok",description:`<strong>create_branch_ok</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether creating a branch named with the <code>revision</code> passed at
the current checked-out reference if <code>revision</code> isn&#x2019;t an
existing revision is allowed.`,name:"create_branch_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L1129"}}),je=new y({props:{name:"git_commit",anchor:"huggingface_hub.Repository.git_commit",parameters:[{name:"commit_message",val:": str = 'commit files to HF hub'"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_commit.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;commit files to HF hub&#x201D;) &#x2014;
The message attributed to the commit.`,name:"commit_message"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L1022"}}),Ue=new y({props:{name:"git_config_username_and_email",anchor:"huggingface_hub.Repository.git_config_username_and_email",parameters:[{name:"git_user",val:": typing.Optional[str] = None"},{name:"git_email",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_config_username_and_email.git_user",description:`<strong>git_user</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The username to register through <code>git</code>.`,name:"git_user"},{anchor:"huggingface_hub.Repository.git_config_username_and_email.git_email",description:`<strong>git_email</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The email to register through <code>git</code>.`,name:"git_email"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L710"}}),He=new y({props:{name:"git_credential_helper_store",anchor:"huggingface_hub.Repository.git_credential_helper_store",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L729"}}),Je=new y({props:{name:"git_head_commit_url",anchor:"huggingface_hub.Repository.git_head_commit_url",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L766",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The URL to the current checked-out commit.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Ne=new y({props:{name:"git_head_hash",anchor:"huggingface_hub.Repository.git_head_hash",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L738",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The current checked out commit SHA.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Ve=new y({props:{name:"git_pull",anchor:"huggingface_hub.Repository.git_pull",parameters:[{name:"rebase",val:": bool = False"},{name:"lfs",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_pull.rebase",description:`<strong>rebase</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to rebase the current branch on top of the upstream
branch after fetching.`,name:"rebase"},{anchor:"huggingface_hub.Repository.git_pull.lfs",description:`<strong>lfs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fetch the LFS files too. This option only changes the
behavior when a repository was cloned without fetching the LFS
files; calling <code>repo.git_pull(lfs=True)</code> will then fetch the LFS
file from the remote repository.`,name:"lfs"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L964"}}),Fe=new y({props:{name:"git_push",anchor:"huggingface_hub.Repository.git_push",parameters:[{name:"upstream",val:": typing.Optional[str] = None"},{name:"blocking",val:": bool = True"},{name:"auto_lfs_prune",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_push.upstream",description:`<strong>upstream</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Upstream to which this should push. If not specified, will push
to the lastly defined upstream or to the default one (<code>origin main</code>).`,name:"upstream"},{anchor:"huggingface_hub.Repository.git_push.blocking",description:`<strong>blocking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the function should return only when the push has
finished. Setting this to <code>False</code> will return an
<code>CommandInProgress</code> object which has an <code>is_done</code> property. This
property will be set to <code>True</code> when the push is finished.`,name:"blocking"},{anchor:"huggingface_hub.Repository.git_push.auto_lfs_prune",description:`<strong>auto_lfs_prune</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to automatically prune files once they have been pushed
to the remote.`,name:"auto_lfs_prune"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L1039"}}),qe=new y({props:{name:"git_remote_url",anchor:"huggingface_hub.Repository.git_remote_url",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L751",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The URL of the <code>origin</code> remote.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),We=new y({props:{name:"is_repo_clean",anchor:"huggingface_hub.Repository.is_repo_clean",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L1262",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the git status is clean, <code>False</code> otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Be=new y({props:{name:"lfs_enable_largefiles",anchor:"huggingface_hub.Repository.lfs_enable_largefiles",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L856"}}),Se=new y({props:{name:"lfs_prune",anchor:"huggingface_hub.Repository.lfs_prune",parameters:[{name:"recent",val:" = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.lfs_prune.recent",description:`<strong>recent</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to prune files even if they were referenced by recent
commits. See the following
<a href="https://github.com/git-lfs/git-lfs/blob/f3d43f0428a84fc4f1e5405b76b5a73ec2437e65/docs/man/git-lfs-prune.1.ronn#recent-files" rel="nofollow">link</a>
for more information.`,name:"recent"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L946"}}),Ae=new y({props:{name:"lfs_track",anchor:"huggingface_hub.Repository.lfs_track",parameters:[{name:"patterns",val:": typing.Union[str, typing.List[str]]"},{name:"filename",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.lfs_track.patterns",description:`<strong>patterns</strong> (<code>Union[str, List[str]]</code>) &#x2014;
The pattern, or list of patterns, to track with git-lfs.`,name:"patterns"},{anchor:"huggingface_hub.Repository.lfs_track.filename",description:`<strong>filename</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use the patterns as literal filenames.`,name:"filename"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L815"}}),Oe=new y({props:{name:"lfs_untrack",anchor:"huggingface_hub.Repository.lfs_untrack",parameters:[{name:"patterns",val:": typing.Union[str, typing.List[str]]"}],parametersDescription:[{anchor:"huggingface_hub.Repository.lfs_untrack.patterns",description:`<strong>patterns</strong> (<code>Union[str, List[str]]</code>) &#x2014;
The pattern, or list of patterns, to untrack with git-lfs.`,name:"patterns"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L840"}}),ze=new y({props:{name:"list_deleted_files",anchor:"huggingface_hub.Repository.list_deleted_files",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L780",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of files that have been deleted in the working
directory or index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Qe=new y({props:{name:"push_to_hub",anchor:"huggingface_hub.Repository.push_to_hub",parameters:[{name:"commit_message",val:": str = 'commit files to HF hub'"},{name:"blocking",val:": bool = True"},{name:"clean_ok",val:": bool = True"},{name:"auto_lfs_prune",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
Message to use for the commit.`,name:"commit_message"},{anchor:"huggingface_hub.Repository.push_to_hub.blocking",description:`<strong>blocking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the function should return only when the <code>git push</code> has
finished.`,name:"blocking"},{anchor:"huggingface_hub.Repository.push_to_hub.clean_ok",description:`<strong>clean_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, this function will return None if the repo is
untouched. Default behavior is to fail because the git command
fails.`,name:"clean_ok"},{anchor:"huggingface_hub.Repository.push_to_hub.auto_lfs_prune",description:`<strong>auto_lfs_prune</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to automatically prune files once they have been pushed
to the remote.`,name:"auto_lfs_prune"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L1276"}}),Ge=new y({props:{name:"tag_exists",anchor:"huggingface_hub.Repository.tag_exists",parameters:[{name:"tag_name",val:": str"},{name:"remote",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.tag_exists.tag_name",description:`<strong>tag_name</strong> (<code>str</code>) &#x2014;
The name of the tag to check.`,name:"tag_name"},{anchor:"huggingface_hub.Repository.tag_exists.remote",description:`<strong>remote</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Whether to check if the tag exists on a remote. This parameter
should be the identifier of the remote.`,name:"remote"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L1161",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether the tag exists.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Ze=new y({props:{name:"wait_for_commands",anchor:"huggingface_hub.Repository.wait_for_commands",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L1442"}}),Xe=new bo({props:{title:"Helper methods",local:"huggingface_hub.repository.is_git_repo",headingTag:"h2"}}),Ke=new y({props:{name:"huggingface_hub.repository.is_git_repo",anchor:"huggingface_hub.repository.is_git_repo",parameters:[{name:"folder",val:": typing.Union[str, pathlib.Path]"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_git_repo.folder",description:`<strong>folder</strong> (<code>str</code>) &#x2014;
The folder in which to run the command.`,name:"folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L113",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the repository is part of a repository, <code>False</code>
otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Ye=new y({props:{name:"huggingface_hub.repository.is_local_clone",anchor:"huggingface_hub.repository.is_local_clone",parameters:[{name:"folder",val:": typing.Union[str, pathlib.Path]"},{name:"remote_url",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_local_clone.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"},{anchor:"huggingface_hub.repository.is_local_clone.remote_url",description:`<strong>remote_url</strong> (<code>str</code>) &#x2014;
The url of a git repository.`,name:"remote_url"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L130",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the repository is a local clone of the remote
repository specified, <code>False</code> otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),et=new y({props:{name:"huggingface_hub.repository.is_tracked_with_lfs",anchor:"huggingface_hub.repository.is_tracked_with_lfs",parameters:[{name:"filename",val:": typing.Union[str, pathlib.Path]"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_tracked_with_lfs.filename",description:`<strong>filename</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The filename to check.`,name:"filename"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L155",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the file passed is tracked with git-lfs, <code>False</code>
otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),tt=new y({props:{name:"huggingface_hub.repository.is_git_ignored",anchor:"huggingface_hub.repository.is_git_ignored",parameters:[{name:"filename",val:": typing.Union[str, pathlib.Path]"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_git_ignored.filename",description:`<strong>filename</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The filename to check.`,name:"filename"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L192",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the file passed is ignored by <code>git</code>, <code>False</code>
otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),nt=new y({props:{name:"huggingface_hub.repository.files_to_be_staged",anchor:"huggingface_hub.repository.files_to_be_staged",parameters:[{name:"pattern",val:": str = '.'"},{name:"folder",val:": typing.Union[str, pathlib.Path, NoneType] = None"}],parametersDescription:[{anchor:"huggingface_hub.repository.files_to_be_staged.pattern",description:`<strong>pattern</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The pattern of filenames to check. Put <code>.</code> to get all files.`,name:"pattern"},{anchor:"huggingface_hub.repository.files_to_be_staged.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L240",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of files that are to be staged.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),ot=new y({props:{name:"huggingface_hub.repository.is_tracked_upstream",anchor:"huggingface_hub.repository.is_tracked_upstream",parameters:[{name:"folder",val:": typing.Union[str, pathlib.Path]"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_tracked_upstream.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L265",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the current checked-out branch is tracked upstream,
<code>False</code> otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),rt=new y({props:{name:"huggingface_hub.repository.commits_to_push",anchor:"huggingface_hub.repository.commits_to_push",parameters:[{name:"folder",val:": typing.Union[str, pathlib.Path]"},{name:"upstream",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.repository.commits_to_push.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"},{anchor:"huggingface_hub.repository.commits_to_push.upstream",description:"<strong>upstream</strong> (<code>str</code>, <em>optional</em>) &#x2014;",name:"upstream"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L287",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Number of commits that would be pushed upstream were a <code>git push</code> to proceed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>int</code></p>
`}}),at=new bo({props:{title:"Following asynchronous commands",local:"huggingface_hub.Repository",headingTag:"h2"}}),ct=new y({props:{name:"class huggingface_hub.Repository",anchor:"huggingface_hub.Repository",parameters:[{name:"local_dir",val:": typing.Union[str, pathlib.Path]"},{name:"clone_from",val:": typing.Optional[str] = None"},{name:"repo_type",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Union[bool, str] = True"},{name:"git_user",val:": typing.Optional[str] = None"},{name:"git_email",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"skip_lfs_files",val:": bool = False"},{name:"client",val:": typing.Optional[huggingface_hub.hf_api.HfApi] = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L424"}}),gt=new y({props:{name:"commands_failed",anchor:"huggingface_hub.Repository.commands_failed",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L1428"}}),pt=new y({props:{name:"commands_in_progress",anchor:"huggingface_hub.Repository.commands_in_progress",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L1435"}}),dt=new y({props:{name:"wait_for_commands",anchor:"huggingface_hub.Repository.wait_for_commands",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L1442"}}),ht=new y({props:{name:"class huggingface_hub.repository.CommandInProgress",anchor:"huggingface_hub.repository.CommandInProgress",parameters:[{name:"title",val:": str"},{name:"is_done_method",val:": typing.Callable"},{name:"status_method",val:": typing.Callable"},{name:"process",val:": Popen"},{name:"post_method",val:": typing.Optional[typing.Callable] = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.18.0.rc0/src/huggingface_hub/repository.py#L30"}}),{c(){x=r("meta"),j=n(),T=r("p"),w=n(),p(k.$$.fragment),$=n(),R=r("p"),R.innerHTML=Xr,xn=n(),ye=r("p"),ye.innerHTML=Kr,wn=n(),p($e.$$.fragment),Cn=n(),i=r("div"),p(xe.$$.fragment),vo=n(),mt=r("p"),mt.textContent=Yr,yo=n(),ft=r("p"),ft.textContent=ea,$o=n(),I=r("div"),p(we.$$.fragment),xo=n(),_t=r("p"),_t.textContent=ta,wo=n(),bt=r("p"),bt.innerHTML=na,Co=n(),vt=r("p"),vt.innerHTML=oa,To=n(),z=r("div"),p(Ce.$$.fragment),ko=n(),yt=r("p"),yt.textContent=ra,Ro=n(),D=r("div"),p(Te.$$.fragment),Io=n(),$t=r("p"),$t.textContent=aa,Do=n(),xt=r("p"),xt.textContent=sa,Mo=n(),wt=r("p"),wt.textContent=ia,Lo=n(),Q=r("div"),p(ke.$$.fragment),Po=n(),Ct=r("p"),Ct.textContent=la,Eo=n(),G=r("div"),p(Re.$$.fragment),jo=n(),Tt=r("p"),Tt.textContent=ca,Uo=n(),Z=r("div"),p(Ie.$$.fragment),Ho=n(),kt=r("p"),kt.innerHTML=ga,Jo=n(),M=r("div"),p(De.$$.fragment),No=n(),Rt=r("p"),Rt.textContent=pa,Vo=n(),It=r("p"),It.textContent=da,Fo=n(),p(X.$$.fragment),qo=n(),U=r("div"),p(Me.$$.fragment),Wo=n(),Dt=r("p"),Dt.innerHTML=ha,Bo=n(),p(K.$$.fragment),So=n(),Y=r("div"),p(Le.$$.fragment),Ao=n(),Mt=r("p"),Mt.textContent=ua,Oo=n(),H=r("div"),p(Pe.$$.fragment),zo=n(),Lt=r("p"),Lt.textContent=ma,Qo=n(),Pt=r("p"),Pt.innerHTML=fa,Go=n(),J=r("div"),p(Ee.$$.fragment),Zo=n(),Et=r("p"),Et.textContent=_a,Xo=n(),jt=r("p"),jt.innerHTML=ba,Ko=n(),ee=r("div"),p(je.$$.fragment),Yo=n(),Ut=r("p"),Ut.textContent=va,er=n(),te=r("div"),p(Ue.$$.fragment),tr=n(),Ht=r("p"),Ht.textContent=ya,nr=n(),ne=r("div"),p(He.$$.fragment),or=n(),Jt=r("p"),Jt.innerHTML=$a,rr=n(),oe=r("div"),p(Je.$$.fragment),ar=n(),Nt=r("p"),Nt.textContent=xa,sr=n(),re=r("div"),p(Ne.$$.fragment),ir=n(),Vt=r("p"),Vt.textContent=wa,lr=n(),ae=r("div"),p(Ve.$$.fragment),cr=n(),Ft=r("p"),Ft.textContent=Ca,gr=n(),N=r("div"),p(Fe.$$.fragment),pr=n(),qt=r("p"),qt.textContent=Ta,dr=n(),Wt=r("p"),Wt.innerHTML=ka,hr=n(),se=r("div"),p(qe.$$.fragment),ur=n(),Bt=r("p"),Bt.textContent=Ra,mr=n(),ie=r("div"),p(We.$$.fragment),fr=n(),St=r("p"),St.textContent=Ia,_r=n(),le=r("div"),p(Be.$$.fragment),br=n(),At=r("p"),At.textContent=Da,vr=n(),ce=r("div"),p(Se.$$.fragment),yr=n(),Ot=r("p"),Ot.textContent=Ma,$r=n(),V=r("div"),p(Ae.$$.fragment),xr=n(),zt=r("p"),zt.textContent=La,wr=n(),Qt=r("p"),Qt.innerHTML=Pa,Cr=n(),ge=r("div"),p(Oe.$$.fragment),Tr=n(),Gt=r("p"),Gt.textContent=Ea,kr=n(),pe=r("div"),p(ze.$$.fragment),Rr=n(),Zt=r("p"),Zt.textContent=ja,Ir=n(),de=r("div"),p(Qe.$$.fragment),Dr=n(),Xt=r("p"),Xt.textContent=Ua,Mr=n(),he=r("div"),p(Ge.$$.fragment),Lr=n(),Kt=r("p"),Kt.textContent=Ha,Pr=n(),ue=r("div"),p(Ze.$$.fragment),Er=n(),Yt=r("p"),Yt.textContent=Ja,Tn=n(),p(Xe.$$.fragment),kn=n(),F=r("div"),p(Ke.$$.fragment),jr=n(),en=r("p"),en.textContent=Na,Rn=n(),q=r("div"),p(Ye.$$.fragment),Ur=n(),tn=r("p"),tn.textContent=Va,In=n(),W=r("div"),p(et.$$.fragment),Hr=n(),nn=r("p"),nn.textContent=Fa,Dn=n(),B=r("div"),p(tt.$$.fragment),Jr=n(),on=r("p"),on.textContent=qa,Mn=n(),S=r("div"),p(nt.$$.fragment),Nr=n(),rn=r("p"),rn.textContent=Wa,Ln=n(),A=r("div"),p(ot.$$.fragment),Vr=n(),an=r("p"),an.textContent=Ba,Pn=n(),P=r("div"),p(rt.$$.fragment),Fr=n(),sn=r("p"),sn.textContent=Sa,qr=n(),ln=r("p"),ln.textContent=Aa,En=n(),p(at.$$.fragment),jn=n(),st=r("p"),st.innerHTML=Oa,Un=n(),it=r("ul"),it.innerHTML=za,Hn=n(),lt=r("p"),lt.textContent=Qa,Jn=n(),C=r("div"),p(ct.$$.fragment),Wr=n(),cn=r("p"),cn.textContent=Ga,Br=n(),gn=r("p"),gn.textContent=Za,Sr=n(),me=r("div"),p(gt.$$.fragment),Ar=n(),pn=r("p"),pn.textContent=Xa,Or=n(),fe=r("div"),p(pt.$$.fragment),zr=n(),dn=r("p"),dn.textContent=Ka,Qr=n(),_e=r("div"),p(dt.$$.fragment),Gr=n(),hn=r("p"),hn.textContent=Ya,Nn=n(),O=r("div"),p(ht.$$.fragment),Zr=n(),un=r("p"),un.textContent=es,Vn=n(),$n=r("p"),this.h()},l(e){const g=ss("svelte-u9bgzb",document.head);x=a(g,"META",{name:!0,content:!0}),g.forEach(s),j=o(e),T=a(e,"P",{}),_(T).forEach(s),w=o(e),d(k.$$.fragment,e),$=o(e),R=a(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-fqtivw"&&(R.innerHTML=Xr),xn=o(e),ye=a(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-1mkssuw"&&(ye.innerHTML=Kr),wn=o(e),d($e.$$.fragment,e),Cn=o(e),i=a(e,"DIV",{class:!0});var l=_(i);d(xe.$$.fragment,l),vo=o(l),mt=a(l,"P",{"data-svelte-h":!0}),c(mt)!=="svelte-sfljep"&&(mt.textContent=Yr),yo=o(l),ft=a(l,"P",{"data-svelte-h":!0}),c(ft)!=="svelte-130r937"&&(ft.textContent=ea),$o=o(l),I=a(l,"DIV",{class:!0});var E=_(I);d(we.$$.fragment,E),xo=o(E),_t=a(E,"P",{"data-svelte-h":!0}),c(_t)!=="svelte-u91m2x"&&(_t.textContent=ta),wo=o(E),bt=a(E,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-1rmahq6"&&(bt.innerHTML=na),Co=o(E),vt=a(E,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-1rccgws"&&(vt.innerHTML=oa),E.forEach(s),To=o(l),z=a(l,"DIV",{class:!0});var qn=_(z);d(Ce.$$.fragment,qn),ko=o(qn),yt=a(qn,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-1931o36"&&(yt.textContent=ra),qn.forEach(s),Ro=o(l),D=a(l,"DIV",{class:!0});var be=_(D);d(Te.$$.fragment,be),Io=o(be),$t=a(be,"P",{"data-svelte-h":!0}),c($t)!=="svelte-63n9b3"&&($t.textContent=aa),Do=o(be),xt=a(be,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-1mgqvlx"&&(xt.textContent=sa),Mo=o(be),wt=a(be,"P",{"data-svelte-h":!0}),c(wt)!=="svelte-10sq8kk"&&(wt.textContent=ia),be.forEach(s),Lo=o(l),Q=a(l,"DIV",{class:!0});var Wn=_(Q);d(ke.$$.fragment,Wn),Po=o(Wn),Ct=a(Wn,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-1xz8ip4"&&(Ct.textContent=la),Wn.forEach(s),Eo=o(l),G=a(l,"DIV",{class:!0});var Bn=_(G);d(Re.$$.fragment,Bn),jo=o(Bn),Tt=a(Bn,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-gpfomi"&&(Tt.textContent=ca),Bn.forEach(s),Uo=o(l),Z=a(l,"DIV",{class:!0});var Sn=_(Z);d(Ie.$$.fragment,Sn),Ho=o(Sn),kt=a(Sn,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-i6ef2h"&&(kt.innerHTML=ga),Sn.forEach(s),Jo=o(l),M=a(l,"DIV",{class:!0});var ve=_(M);d(De.$$.fragment,ve),No=o(ve),Rt=a(ve,"P",{"data-svelte-h":!0}),c(Rt)!=="svelte-yrpdu4"&&(Rt.textContent=pa),Vo=o(ve),It=a(ve,"P",{"data-svelte-h":!0}),c(It)!=="svelte-kcbb31"&&(It.textContent=da),Fo=o(ve),d(X.$$.fragment,ve),ve.forEach(s),qo=o(l),U=a(l,"DIV",{class:!0});var mn=_(U);d(Me.$$.fragment,mn),Wo=o(mn),Dt=a(mn,"P",{"data-svelte-h":!0}),c(Dt)!=="svelte-srmdei"&&(Dt.innerHTML=ha),Bo=o(mn),d(K.$$.fragment,mn),mn.forEach(s),So=o(l),Y=a(l,"DIV",{class:!0});var An=_(Y);d(Le.$$.fragment,An),Ao=o(An),Mt=a(An,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-x8sm21"&&(Mt.textContent=ua),An.forEach(s),Oo=o(l),H=a(l,"DIV",{class:!0});var fn=_(H);d(Pe.$$.fragment,fn),zo=o(fn),Lt=a(fn,"P",{"data-svelte-h":!0}),c(Lt)!=="svelte-1eaw53"&&(Lt.textContent=ma),Qo=o(fn),Pt=a(fn,"P",{"data-svelte-h":!0}),c(Pt)!=="svelte-1gwi68h"&&(Pt.innerHTML=fa),fn.forEach(s),Go=o(l),J=a(l,"DIV",{class:!0});var _n=_(J);d(Ee.$$.fragment,_n),Zo=o(_n),Et=a(_n,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-fr7o3n"&&(Et.textContent=_a),Xo=o(_n),jt=a(_n,"P",{"data-svelte-h":!0}),c(jt)!=="svelte-1f8uww9"&&(jt.innerHTML=ba),_n.forEach(s),Ko=o(l),ee=a(l,"DIV",{class:!0});var On=_(ee);d(je.$$.fragment,On),Yo=o(On),Ut=a(On,"P",{"data-svelte-h":!0}),c(Ut)!=="svelte-10kdqwr"&&(Ut.textContent=va),On.forEach(s),er=o(l),te=a(l,"DIV",{class:!0});var zn=_(te);d(Ue.$$.fragment,zn),tr=o(zn),Ht=a(zn,"P",{"data-svelte-h":!0}),c(Ht)!=="svelte-1jc3bks"&&(Ht.textContent=ya),zn.forEach(s),nr=o(l),ne=a(l,"DIV",{class:!0});var Qn=_(ne);d(He.$$.fragment,Qn),or=o(Qn),Jt=a(Qn,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-1pc1msi"&&(Jt.innerHTML=$a),Qn.forEach(s),rr=o(l),oe=a(l,"DIV",{class:!0});var Gn=_(oe);d(Je.$$.fragment,Gn),ar=o(Gn),Nt=a(Gn,"P",{"data-svelte-h":!0}),c(Nt)!=="svelte-1v7pd4y"&&(Nt.textContent=xa),Gn.forEach(s),sr=o(l),re=a(l,"DIV",{class:!0});var Zn=_(re);d(Ne.$$.fragment,Zn),ir=o(Zn),Vt=a(Zn,"P",{"data-svelte-h":!0}),c(Vt)!=="svelte-vce47s"&&(Vt.textContent=wa),Zn.forEach(s),lr=o(l),ae=a(l,"DIV",{class:!0});var Xn=_(ae);d(Ve.$$.fragment,Xn),cr=o(Xn),Ft=a(Xn,"P",{"data-svelte-h":!0}),c(Ft)!=="svelte-14r2tu1"&&(Ft.textContent=Ca),Xn.forEach(s),gr=o(l),N=a(l,"DIV",{class:!0});var bn=_(N);d(Fe.$$.fragment,bn),pr=o(bn),qt=a(bn,"P",{"data-svelte-h":!0}),c(qt)!=="svelte-7q6b1s"&&(qt.textContent=Ta),dr=o(bn),Wt=a(bn,"P",{"data-svelte-h":!0}),c(Wt)!=="svelte-13r9fow"&&(Wt.innerHTML=ka),bn.forEach(s),hr=o(l),se=a(l,"DIV",{class:!0});var Kn=_(se);d(qe.$$.fragment,Kn),ur=o(Kn),Bt=a(Kn,"P",{"data-svelte-h":!0}),c(Bt)!=="svelte-1gemtfc"&&(Bt.textContent=Ra),Kn.forEach(s),mr=o(l),ie=a(l,"DIV",{class:!0});var Yn=_(ie);d(We.$$.fragment,Yn),fr=o(Yn),St=a(Yn,"P",{"data-svelte-h":!0}),c(St)!=="svelte-1szkij9"&&(St.textContent=Ia),Yn.forEach(s),_r=o(l),le=a(l,"DIV",{class:!0});var eo=_(le);d(Be.$$.fragment,eo),br=o(eo),At=a(eo,"P",{"data-svelte-h":!0}),c(At)!=="svelte-ywq4p5"&&(At.textContent=Da),eo.forEach(s),vr=o(l),ce=a(l,"DIV",{class:!0});var to=_(ce);d(Se.$$.fragment,to),yr=o(to),Ot=a(to,"P",{"data-svelte-h":!0}),c(Ot)!=="svelte-o0hw73"&&(Ot.textContent=Ma),to.forEach(s),$r=o(l),V=a(l,"DIV",{class:!0});var vn=_(V);d(Ae.$$.fragment,vn),xr=o(vn),zt=a(vn,"P",{"data-svelte-h":!0}),c(zt)!=="svelte-rew8wo"&&(zt.textContent=La),wr=o(vn),Qt=a(vn,"P",{"data-svelte-h":!0}),c(Qt)!=="svelte-9edfgw"&&(Qt.innerHTML=Pa),vn.forEach(s),Cr=o(l),ge=a(l,"DIV",{class:!0});var no=_(ge);d(Oe.$$.fragment,no),Tr=o(no),Gt=a(no,"P",{"data-svelte-h":!0}),c(Gt)!=="svelte-un1lv4"&&(Gt.textContent=Ea),no.forEach(s),kr=o(l),pe=a(l,"DIV",{class:!0});var oo=_(pe);d(ze.$$.fragment,oo),Rr=o(oo),Zt=a(oo,"P",{"data-svelte-h":!0}),c(Zt)!=="svelte-1i0xpsk"&&(Zt.textContent=ja),oo.forEach(s),Ir=o(l),de=a(l,"DIV",{class:!0});var ro=_(de);d(Qe.$$.fragment,ro),Dr=o(ro),Xt=a(ro,"P",{"data-svelte-h":!0}),c(Xt)!=="svelte-jqquke"&&(Xt.textContent=Ua),ro.forEach(s),Mr=o(l),he=a(l,"DIV",{class:!0});var ao=_(he);d(Ge.$$.fragment,ao),Lr=o(ao),Kt=a(ao,"P",{"data-svelte-h":!0}),c(Kt)!=="svelte-j7abay"&&(Kt.textContent=Ha),ao.forEach(s),Pr=o(l),ue=a(l,"DIV",{class:!0});var so=_(ue);d(Ze.$$.fragment,so),Er=o(so),Yt=a(so,"P",{"data-svelte-h":!0}),c(Yt)!=="svelte-11wx7zp"&&(Yt.textContent=Ja),so.forEach(s),l.forEach(s),Tn=o(e),d(Xe.$$.fragment,e),kn=o(e),F=a(e,"DIV",{class:!0});var io=_(F);d(Ke.$$.fragment,io),jr=o(io),en=a(io,"P",{"data-svelte-h":!0}),c(en)!=="svelte-5hpmfd"&&(en.textContent=Na),io.forEach(s),Rn=o(e),q=a(e,"DIV",{class:!0});var lo=_(q);d(Ye.$$.fragment,lo),Ur=o(lo),tn=a(lo,"P",{"data-svelte-h":!0}),c(tn)!=="svelte-1d1mfv5"&&(tn.textContent=Va),lo.forEach(s),In=o(e),W=a(e,"DIV",{class:!0});var co=_(W);d(et.$$.fragment,co),Hr=o(co),nn=a(co,"P",{"data-svelte-h":!0}),c(nn)!=="svelte-oqtt44"&&(nn.textContent=Fa),co.forEach(s),Dn=o(e),B=a(e,"DIV",{class:!0});var go=_(B);d(tt.$$.fragment,go),Jr=o(go),on=a(go,"P",{"data-svelte-h":!0}),c(on)!=="svelte-1jg2eg8"&&(on.textContent=qa),go.forEach(s),Mn=o(e),S=a(e,"DIV",{class:!0});var po=_(S);d(nt.$$.fragment,po),Nr=o(po),rn=a(po,"P",{"data-svelte-h":!0}),c(rn)!=="svelte-97mwvc"&&(rn.textContent=Wa),po.forEach(s),Ln=o(e),A=a(e,"DIV",{class:!0});var ho=_(A);d(ot.$$.fragment,ho),Vr=o(ho),an=a(ho,"P",{"data-svelte-h":!0}),c(an)!=="svelte-vpsey2"&&(an.textContent=Ba),ho.forEach(s),Pn=o(e),P=a(e,"DIV",{class:!0});var yn=_(P);d(rt.$$.fragment,yn),Fr=o(yn),sn=a(yn,"P",{"data-svelte-h":!0}),c(sn)!=="svelte-18uhass"&&(sn.textContent=Sa),qr=o(yn),ln=a(yn,"P",{"data-svelte-h":!0}),c(ln)!=="svelte-zq2g9v"&&(ln.textContent=Aa),yn.forEach(s),En=o(e),d(at.$$.fragment,e),jn=o(e),st=a(e,"P",{"data-svelte-h":!0}),c(st)!=="svelte-1w5vmm6"&&(st.innerHTML=Oa),Un=o(e),it=a(e,"UL",{"data-svelte-h":!0}),c(it)!=="svelte-1dzo48z"&&(it.innerHTML=za),Hn=o(e),lt=a(e,"P",{"data-svelte-h":!0}),c(lt)!=="svelte-1k7k7po"&&(lt.textContent=Qa),Jn=o(e),C=a(e,"DIV",{class:!0});var L=_(C);d(ct.$$.fragment,L),Wr=o(L),cn=a(L,"P",{"data-svelte-h":!0}),c(cn)!=="svelte-sfljep"&&(cn.textContent=Ga),Br=o(L),gn=a(L,"P",{"data-svelte-h":!0}),c(gn)!=="svelte-130r937"&&(gn.textContent=Za),Sr=o(L),me=a(L,"DIV",{class:!0});var uo=_(me);d(gt.$$.fragment,uo),Ar=o(uo),pn=a(uo,"P",{"data-svelte-h":!0}),c(pn)!=="svelte-1qshjwq"&&(pn.textContent=Xa),uo.forEach(s),Or=o(L),fe=a(L,"DIV",{class:!0});var mo=_(fe);d(pt.$$.fragment,mo),zr=o(mo),dn=a(mo,"P",{"data-svelte-h":!0}),c(dn)!=="svelte-54rv4h"&&(dn.textContent=Ka),mo.forEach(s),Qr=o(L),_e=a(L,"DIV",{class:!0});var fo=_(_e);d(dt.$$.fragment,fo),Gr=o(fo),hn=a(fo,"P",{"data-svelte-h":!0}),c(hn)!=="svelte-11wx7zp"&&(hn.textContent=Ya),fo.forEach(s),L.forEach(s),Nn=o(e),O=a(e,"DIV",{class:!0});var _o=_(O);d(ht.$$.fragment,_o),Zr=o(_o),un=a(_o,"P",{"data-svelte-h":!0}),c(un)!=="svelte-1na97wh"&&(un.textContent=es),_o.forEach(s),Vn=o(e),$n=a(e,"P",{}),_($n).forEach(s),this.h()},h(){b(x,"name","hf:doc:metadata"),b(x,"content",hs),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(i,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,g){t(document.head,x),v(e,j,g),v(e,T,g),v(e,w,g),h(k,e,g),v(e,$,g),v(e,R,g),v(e,xn,g),v(e,ye,g),v(e,wn,g),h($e,e,g),v(e,Cn,g),v(e,i,g),h(xe,i,null),t(i,vo),t(i,mt),t(i,yo),t(i,ft),t(i,$o),t(i,I),h(we,I,null),t(I,xo),t(I,_t),t(I,wo),t(I,bt),t(I,Co),t(I,vt),t(i,To),t(i,z),h(Ce,z,null),t(z,ko),t(z,yt),t(i,Ro),t(i,D),h(Te,D,null),t(D,Io),t(D,$t),t(D,Do),t(D,xt),t(D,Mo),t(D,wt),t(i,Lo),t(i,Q),h(ke,Q,null),t(Q,Po),t(Q,Ct),t(i,Eo),t(i,G),h(Re,G,null),t(G,jo),t(G,Tt),t(i,Uo),t(i,Z),h(Ie,Z,null),t(Z,Ho),t(Z,kt),t(i,Jo),t(i,M),h(De,M,null),t(M,No),t(M,Rt),t(M,Vo),t(M,It),t(M,Fo),h(X,M,null),t(i,qo),t(i,U),h(Me,U,null),t(U,Wo),t(U,Dt),t(U,Bo),h(K,U,null),t(i,So),t(i,Y),h(Le,Y,null),t(Y,Ao),t(Y,Mt),t(i,Oo),t(i,H),h(Pe,H,null),t(H,zo),t(H,Lt),t(H,Qo),t(H,Pt),t(i,Go),t(i,J),h(Ee,J,null),t(J,Zo),t(J,Et),t(J,Xo),t(J,jt),t(i,Ko),t(i,ee),h(je,ee,null),t(ee,Yo),t(ee,Ut),t(i,er),t(i,te),h(Ue,te,null),t(te,tr),t(te,Ht),t(i,nr),t(i,ne),h(He,ne,null),t(ne,or),t(ne,Jt),t(i,rr),t(i,oe),h(Je,oe,null),t(oe,ar),t(oe,Nt),t(i,sr),t(i,re),h(Ne,re,null),t(re,ir),t(re,Vt),t(i,lr),t(i,ae),h(Ve,ae,null),t(ae,cr),t(ae,Ft),t(i,gr),t(i,N),h(Fe,N,null),t(N,pr),t(N,qt),t(N,dr),t(N,Wt),t(i,hr),t(i,se),h(qe,se,null),t(se,ur),t(se,Bt),t(i,mr),t(i,ie),h(We,ie,null),t(ie,fr),t(ie,St),t(i,_r),t(i,le),h(Be,le,null),t(le,br),t(le,At),t(i,vr),t(i,ce),h(Se,ce,null),t(ce,yr),t(ce,Ot),t(i,$r),t(i,V),h(Ae,V,null),t(V,xr),t(V,zt),t(V,wr),t(V,Qt),t(i,Cr),t(i,ge),h(Oe,ge,null),t(ge,Tr),t(ge,Gt),t(i,kr),t(i,pe),h(ze,pe,null),t(pe,Rr),t(pe,Zt),t(i,Ir),t(i,de),h(Qe,de,null),t(de,Dr),t(de,Xt),t(i,Mr),t(i,he),h(Ge,he,null),t(he,Lr),t(he,Kt),t(i,Pr),t(i,ue),h(Ze,ue,null),t(ue,Er),t(ue,Yt),v(e,Tn,g),h(Xe,e,g),v(e,kn,g),v(e,F,g),h(Ke,F,null),t(F,jr),t(F,en),v(e,Rn,g),v(e,q,g),h(Ye,q,null),t(q,Ur),t(q,tn),v(e,In,g),v(e,W,g),h(et,W,null),t(W,Hr),t(W,nn),v(e,Dn,g),v(e,B,g),h(tt,B,null),t(B,Jr),t(B,on),v(e,Mn,g),v(e,S,g),h(nt,S,null),t(S,Nr),t(S,rn),v(e,Ln,g),v(e,A,g),h(ot,A,null),t(A,Vr),t(A,an),v(e,Pn,g),v(e,P,g),h(rt,P,null),t(P,Fr),t(P,sn),t(P,qr),t(P,ln),v(e,En,g),h(at,e,g),v(e,jn,g),v(e,st,g),v(e,Un,g),v(e,it,g),v(e,Hn,g),v(e,lt,g),v(e,Jn,g),v(e,C,g),h(ct,C,null),t(C,Wr),t(C,cn),t(C,Br),t(C,gn),t(C,Sr),t(C,me),h(gt,me,null),t(me,Ar),t(me,pn),t(C,Or),t(C,fe),h(pt,fe,null),t(fe,zr),t(fe,dn),t(C,Qr),t(C,_e),h(dt,_e,null),t(_e,Gr),t(_e,hn),v(e,Nn,g),v(e,O,g),h(ht,O,null),t(O,Zr),t(O,un),v(e,Vn,g),v(e,$n,g),Fn=!0},p(e,[g]){const l={};g&2&&(l.$$scope={dirty:g,ctx:e}),X.$set(l);const E={};g&2&&(E.$$scope={dirty:g,ctx:e}),K.$set(E)},i(e){Fn||(u(k.$$.fragment,e),u($e.$$.fragment,e),u(xe.$$.fragment,e),u(we.$$.fragment,e),u(Ce.$$.fragment,e),u(Te.$$.fragment,e),u(ke.$$.fragment,e),u(Re.$$.fragment,e),u(Ie.$$.fragment,e),u(De.$$.fragment,e),u(X.$$.fragment,e),u(Me.$$.fragment,e),u(K.$$.fragment,e),u(Le.$$.fragment,e),u(Pe.$$.fragment,e),u(Ee.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),u(He.$$.fragment,e),u(Je.$$.fragment,e),u(Ne.$$.fragment,e),u(Ve.$$.fragment,e),u(Fe.$$.fragment,e),u(qe.$$.fragment,e),u(We.$$.fragment,e),u(Be.$$.fragment,e),u(Se.$$.fragment,e),u(Ae.$$.fragment,e),u(Oe.$$.fragment,e),u(ze.$$.fragment,e),u(Qe.$$.fragment,e),u(Ge.$$.fragment,e),u(Ze.$$.fragment,e),u(Xe.$$.fragment,e),u(Ke.$$.fragment,e),u(Ye.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(nt.$$.fragment,e),u(ot.$$.fragment,e),u(rt.$$.fragment,e),u(at.$$.fragment,e),u(ct.$$.fragment,e),u(gt.$$.fragment,e),u(pt.$$.fragment,e),u(dt.$$.fragment,e),u(ht.$$.fragment,e),Fn=!0)},o(e){m(k.$$.fragment,e),m($e.$$.fragment,e),m(xe.$$.fragment,e),m(we.$$.fragment,e),m(Ce.$$.fragment,e),m(Te.$$.fragment,e),m(ke.$$.fragment,e),m(Re.$$.fragment,e),m(Ie.$$.fragment,e),m(De.$$.fragment,e),m(X.$$.fragment,e),m(Me.$$.fragment,e),m(K.$$.fragment,e),m(Le.$$.fragment,e),m(Pe.$$.fragment,e),m(Ee.$$.fragment,e),m(je.$$.fragment,e),m(Ue.$$.fragment,e),m(He.$$.fragment,e),m(Je.$$.fragment,e),m(Ne.$$.fragment,e),m(Ve.$$.fragment,e),m(Fe.$$.fragment,e),m(qe.$$.fragment,e),m(We.$$.fragment,e),m(Be.$$.fragment,e),m(Se.$$.fragment,e),m(Ae.$$.fragment,e),m(Oe.$$.fragment,e),m(ze.$$.fragment,e),m(Qe.$$.fragment,e),m(Ge.$$.fragment,e),m(Ze.$$.fragment,e),m(Xe.$$.fragment,e),m(Ke.$$.fragment,e),m(Ye.$$.fragment,e),m(et.$$.fragment,e),m(tt.$$.fragment,e),m(nt.$$.fragment,e),m(ot.$$.fragment,e),m(rt.$$.fragment,e),m(at.$$.fragment,e),m(ct.$$.fragment,e),m(gt.$$.fragment,e),m(pt.$$.fragment,e),m(dt.$$.fragment,e),m(ht.$$.fragment,e),Fn=!1},d(e){e&&(s(j),s(T),s(w),s($),s(R),s(xn),s(ye),s(wn),s(Cn),s(i),s(Tn),s(kn),s(F),s(Rn),s(q),s(In),s(W),s(Dn),s(B),s(Mn),s(S),s(Ln),s(A),s(Pn),s(P),s(En),s(jn),s(st),s(Un),s(it),s(Hn),s(lt),s(Jn),s(C),s(Nn),s(O),s(Vn),s($n)),s(x),f(k,e),f($e,e),f(xe),f(we),f(Ce),f(Te),f(ke),f(Re),f(Ie),f(De),f(X),f(Me),f(K),f(Le),f(Pe),f(Ee),f(je),f(Ue),f(He),f(Je),f(Ne),f(Ve),f(Fe),f(qe),f(We),f(Be),f(Se),f(Ae),f(Oe),f(ze),f(Qe),f(Ge),f(Ze),f(Xe,e),f(Ke),f(Ye),f(et),f(tt),f(nt),f(ot),f(rt),f(at,e),f(ct),f(gt),f(pt),f(dt),f(ht)}}}const hs='{"title":"Managing local and online repositories","local":"managing-local-and-online-repositories","sections":[{"title":"The Repository class","local":"huggingface_hub.Repository","sections":[],"depth":2},{"title":"Helper methods","local":"huggingface_hub.repository.is_git_repo","sections":[],"depth":2},{"title":"Following asynchronous commands","local":"huggingface_hub.Repository","sections":[],"depth":2}],"depth":1}';function us(ut){return os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xs extends rs{constructor(x){super(),as(this,x,us,ds,ns,{})}}export{xs as component};
