import{s as pl,o as fl,n as hl}from"../chunks/scheduler.6062bdaf.js";import{S as ul,i as gl,g as o,s as n,r,A as ml,h as i,f as l,c as s,j as dl,u as c,x as d,k as rl,y as wl,a,v as h,d as p,t as f,w as u}from"../chunks/index.4bca734e.js";import{T as cl}from"../chunks/Tip.b9ac1f03.js";import{C as w}from"../chunks/CodeBlock.fa01571c.js";import{H as y}from"../chunks/Heading.723dceba.js";function bl(Te){let g,b=`The returned filepath is a pointer to the HF local cache. Therefore, it is important to not modify the file to avoid
having a corrupted cache. If you are interested in getting to know more about how files are cached, please refer to our
<a href="./manage-cache">caching guide</a>.`;return{c(){g=o("p"),g.innerHTML=b},l(m){g=i(m,"P",{"data-svelte-h":!0}),d(g)!=="svelte-1jtqj65"&&(g.innerHTML=b)},m(m,_){a(m,g,_)},p:hl,d(m){m&&l(g)}}}function yl(Te){let g,b='<code>hf_transfer</code> is a power user tool! It is tested and production-ready, but it lacks user-friendly features like progress bars or advanced error handling. For more details, please take a look at this <a href="https://huggingface.co/docs/huggingface_hub/hf_transfer" rel="nofollow">section</a>.';return{c(){g=o("p"),g.innerHTML=b},l(m){g=i(m,"P",{"data-svelte-h":!0}),d(g)!=="svelte-b5ezec"&&(g.innerHTML=b)},m(m,_){a(m,g,_)},p:hl,d(m){m&&l(g)}}}function _l(Te){let g,b,m,_,M,ke,T,xt=`The <code>huggingface_hub</code> library provides functions to download files from the repositories
stored on the Hub. You can use these functions independently or integrate them into your
own library, making it more convenient for your users to interact with the Hub. This
guide will show you how to:`,He,j,Yt="<li>Download and cache a single file.</li> <li>Download and cache an entire repository.</li> <li>Download files to a local folder.</li>",Je,k,Ze,H,qt=`The <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> function is the main function for downloading files from the Hub.
It downloads the remote file, caches it on disk (in a version-aware way), and returns its local file path.`,xe,$,Ye,J,qe,Z,Lt=`Select the file to download using the <code>repo_id</code>, <code>repo_type</code> and <code>filename</code> parameters. By default, the file will
be considered as being part of a <code>model</code> repo.`,Le,x,Ue,Y,Ce,q,Ut=`By default, the latest version from the <code>main</code> branch is downloaded. However, in some cases you want to download a file
at a particular version (e.g. from a specific branch, a PR, a tag or a commit hash).
To do so, use the <code>revision</code> parameter:`,Ie,L,Ge,U,Ct="<strong>Note:</strong> When using the commit hash, it must be the full-length hash instead of a 7-character commit hash.",Xe,C,Re,I,It=`In case you want to construct the URL used to download a file from a repo, you can use <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/file_download#huggingface_hub.hf_hub_url">hf_hub_url()</a> which returns a URL.
Note that it is used internally by <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a>.`,We,G,Be,X,Gt=`<a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> downloads an entire repository at a given revision. It uses internally <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> which
means all downloaded files are also cached on your local disk. Downloads are made concurrently to speed-up the process.`,Qe,R,Xt="To download a whole repository, just pass the <code>repo_id</code> and <code>repo_type</code>:",ze,W,Ne,B,Rt=`<a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> downloads the latest revision by default. If you want a specific repository revision, use the
<code>revision</code> parameter:`,Fe,Q,Pe,z,De,N,Wt=`<a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> provides an easy way to download a repository. However, you don’t always want to download the
entire content of a repository. For example, you might want to prevent downloading all <code>.bin</code> files if you know you’ll
only use the <code>.safetensors</code> weights. You can do that using <code>allow_patterns</code> and <code>ignore_patterns</code> parameters.`,Se,F,Bt=`These parameters accept either a single pattern or a list of patterns. Patterns are Standard Wildcards (globbing
patterns) as documented <a href="https://tldp.org/LDP/GNU-Linux-Tools-Summary/html/x11655.htm" rel="nofollow">here</a>. The pattern matching is
based on <a href="https://docs.python.org/3/library/fnmatch.html" rel="nofollow"><code>fnmatch</code></a>.`,Ve,P,Qt="For example, you can use <code>allow_patterns</code> to only download JSON configuration files:",Ae,D,Ee,S,zt=`On the other hand, <code>ignore_patterns</code> can exclude certain files from being downloaded. The
following example ignores the <code>.msgpack</code> and <code>.h5</code> file extensions:`,Ke,V,Oe,A,Nt=`Finally, you can combine both to precisely filter your download. Here is an example to download all json and markdown
files except <code>vocab.json</code>.`,et,E,tt,K,lt,O,Ft=`The recommended (and default) way to download files from the Hub is to use the <a href="./manage-cache">cache-system</a>.
You can define your cache location by setting <code>cache_dir</code> parameter (both in <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> and <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a>).`,at,ee,Pt=`However, in some cases you want to download files and move them to a specific folder. This is useful to get a workflow
closer to what <code>git</code> commands offer. You can do that using the <code>local_dir</code> and <code>local_dir_use_symlinks</code> parameters:`,nt,te,Dt=`<li><code>local_dir</code> must be a path to a folder on your system. The downloaded files will keep the same file structure as in the
repo. For example if <code>filename=&quot;data/train.csv&quot;</code> and <code>local_dir=&quot;path/to/folder&quot;</code>, then the returned filepath will be
<code>&quot;path/to/folder/data/train.csv&quot;</code>.</li> <li><code>local_dir_use_symlinks</code> defines how the file must be saved in your local folder.<ul><li>The default behavior (<code>&quot;auto&quot;</code>) is to duplicate small files (&lt;5MB) and use symlinks for bigger files. Symlinks allow
to optimize both bandwidth and disk usage. However manually editing a symlinked file might corrupt the cache, hence
the duplication for small files. The 5MB threshold can be configured with the <code>HF_HUB_LOCAL_DIR_AUTO_SYMLINK_THRESHOLD</code>
environment variable.</li> <li>If <code>local_dir_use_symlinks=True</code> is set, all files are symlinked for an optimal disk space optimization. This is
for example useful when downloading a huge dataset with thousands of small files.</li> <li>Finally, if you don’t want symlinks at all you can disable them (<code>local_dir_use_symlinks=False</code>). The cache directory
will still be used to check wether the file is already cached or not. If already cached, the file is <strong>duplicated</strong>
from the cache (i.e. saves bandwidth but increases disk usage). If the file is not already cached, it will be
downloaded and moved directly to the local dir. This means that if you need to reuse it somewhere else later, it
will be <strong>re-downloaded</strong>.</li></ul></li>`,st,le,St="Here is a table that summarizes the different options to help you choose the parameters that best suit your use case.",ot,ae,Vt='<thead><tr><th>Parameters</th> <th align="center">File already cached</th> <th align="center">Returned path</th> <th align="center">Can read path?</th> <th align="center">Can save to path?</th> <th align="center">Optimized bandwidth</th> <th align="center">Optimized disk usage</th></tr></thead> <tbody><tr><td><code>local_dir=None</code></td> <td align="center"></td> <td align="center">symlink in cache</td> <td align="center">✅</td> <td align="center">❌<br/><em>(save would corrupt the cache)</em></td> <td align="center">✅</td> <td align="center">✅</td></tr> <tr><td><code>local_dir=&quot;path/to/folder&quot;</code><br/><code>local_dir_use_symlinks=&quot;auto&quot;</code></td> <td align="center"></td> <td align="center">file or symlink in folder</td> <td align="center">✅</td> <td align="center">✅ <em>(for small files)</em> <br/> ⚠️ <em>(for big files do not resolve path before saving)</em></td> <td align="center">✅</td> <td align="center">✅</td></tr> <tr><td><code>local_dir=&quot;path/to/folder&quot;</code><br/><code>local_dir_use_symlinks=True</code></td> <td align="center"></td> <td align="center">symlink in folder</td> <td align="center">✅</td> <td align="center">⚠️<br/><em>(do not resolve path before saving)</em></td> <td align="center">✅</td> <td align="center">✅</td></tr> <tr><td><code>local_dir=&quot;path/to/folder&quot;</code><br/><code>local_dir_use_symlinks=False</code></td> <td align="center">No</td> <td align="center">file in folder</td> <td align="center">✅</td> <td align="center">✅</td> <td align="center">❌<br/><em>(if re-run, file is re-downloaded)</em></td> <td align="center">⚠️<br/>(multiple copies if ran in multiple folders)</td></tr> <tr><td><code>local_dir=&quot;path/to/folder&quot;</code><br/><code>local_dir_use_symlinks=False</code></td> <td align="center">Yes</td> <td align="center">file in folder</td> <td align="center">✅</td> <td align="center">✅</td> <td align="center">⚠️<br/><em>(file has to be cached first)</em></td> <td align="center">❌<br/><em>(file is duplicated)</em></td></tr></tbody>',it,ne,At=`<strong>Note:</strong> if you are on a Windows machine, you need to enable developer mode or run <code>huggingface_hub</code> as admin to enable
symlinks. Check out the <a href="../guides/manage-cache#limitations">cache limitations</a> section for more details.`,dt,se,rt,oe,Et=`You can use the <code>huggingface-cli download</code> command from the terminal to directly download files from the Hub.
Internally, it uses the same <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> and <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> helpers described above and prints the
returned path to the terminal:`,ct,ie,ht,de,Kt=`By default, the token saved locally (using <code>huggingface-cli login</code>) will be used. If you want to authenticate explicitly,
use the <code>--token</code> option:`,pt,re,ft,ce,Ot=`You can download multiple files at once which displays a progress bar and returns the snapshot path in which the files
are located:`,ut,he,gt,pe,el=`If you want to silence the progress bars and potential warnings, use the <code>--quiet</code> option. This can prove useful if you
want to pass the output to another command in a script.`,mt,fe,wt,ue,tl=`By default, files are downloaded to the cache directory defined by <code>HF_HOME</code> environment variable (or <code>~/.cache/huggingface/hub</code> if not specified). You
can override this by using the <code>--cache-dir</code> option:`,bt,ge,yt,me,ll=`If you want to download files to a local folder, without the cache directory structure, you can use <code>--local-dir</code>.
Downloading to a local folder comes with its limitations which are listed in this <a href="https://huggingface.co/docs/huggingface_hub/guides/download#download-files-to-local-folder" rel="nofollow">table</a>.`,_t,we,$t,be,al=`There are more arguments you can specify to download from different repo types or revisions and to include/exclude files to download using
glob patterns:`,vt,ye,Mt,_e,nl="For a full list of the arguments, you can run:",Tt,$e,jt,ve,kt,Me,sl='If you are running on a machine with high bandwidth, you can increase your download speed with <a href="https://github.com/huggingface/hf_transfer" rel="nofollow"><code>hf_transfer</code></a>, a Rust-based library developed to speed up file transfers with the Hub. To enable it, install the package (<code>pip install hf_transfer</code>) and set <code>HF_HUB_ENABLE_HF_TRANSFER=1</code> as an environment variable.',Ht,v,Jt,je,Zt;return M=new y({props:{title:"Download files from the Hub",local:"download-files-from-the-hub",headingTag:"h1"}}),k=new y({props:{title:"Download a single file",local:"download-a-single-file",headingTag:"h2"}}),$=new cl({props:{$$slots:{default:[bl]},$$scope:{ctx:Te}}}),J=new y({props:{title:"From latest version",local:"from-latest-version",headingTag:"h3"}}),x=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIyZ29vZ2xlJTJGZmxldXJzJTIyJTJDJTIwZmlsZW5hbWUlM0QlMjJmbGV1cnMucHklMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-string">&#x27;/root/.cache/huggingface/hub/models--lysandre--arxiv-nlp/snapshots/894a9adde21d9a3e3843e6d5aeaaf01875c7fade/config.json&#x27;</span>

<span class="hljs-comment"># Download from a dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;google/fleurs&quot;</span>, filename=<span class="hljs-string">&quot;fleurs.py&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;/root/.cache/huggingface/hub/datasets--google--fleurs/snapshots/199e4ae37915137c555b1765c01477c216287d34/fleurs.py&#x27;</span>`,wrap:!1}}),Y=new y({props:{title:"From specific version",local:"from-specific-version",headingTag:"h3"}}),L=new w({props:{code:"aGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRmFyeGl2LW5scCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyY29uZmlnLmpzb24lMjIlMkMlMjByZXZpc2lvbiUzRCUyMnYxLjAlMjIpJTBBJTBBaGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRmFyeGl2LW5scCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyY29uZmlnLmpzb24lMjIlMkMlMjByZXZpc2lvbiUzRCUyMnRlc3QtYnJhbmNoJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjJyZWZzJTJGcHIlMkYzJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjI4NzdiODRhOGY5M2YyZDYxOWZhYTJhNmU1MTRhMzJiZWVmODhhYjBhJTIyKQ==",highlighted:`<span class="hljs-comment"># Download from the \`v1.0\` tag</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;v1.0&quot;</span>)

<span class="hljs-comment"># Download from the \`test-branch\` branch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;test-branch&quot;</span>)

<span class="hljs-comment"># Download from Pull Request #3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;refs/pr/3&quot;</span>)

<span class="hljs-comment"># Download from a specific commit hash</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;877b84a8f93f2d619faa2a6e514a32beef88ab0a&quot;</span>)`,wrap:!1}}),C=new y({props:{title:"Construct a download URL",local:"construct-a-download-url",headingTag:"h3"}}),G=new y({props:{title:"Download an entire repository",local:"download-an-entire-repository",headingTag:"h2"}}),W=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyKSUwQSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlM0QlMjJnb29nbGUlMkZmbGV1cnMlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>)
<span class="hljs-string">&#x27;/home/lysandre/.cache/huggingface/hub/models--lysandre--arxiv-nlp/snapshots/894a9adde21d9a3e3843e6d5aeaaf01875c7fade&#x27;</span>

<span class="hljs-comment"># Or from a dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;google/fleurs&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;/home/lysandre/.cache/huggingface/hub/datasets--google--fleurs/snapshots/199e4ae37915137c555b1765c01477c216287d34&#x27;</span>`,wrap:!1}}),Q=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwcmV2aXNpb24lM0QlMjJyZWZzJTJGcHIlMkYxJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, revision=<span class="hljs-string">&quot;refs/pr/1&quot;</span>)`,wrap:!1}}),z=new y({props:{title:"Filter files to download",local:"filter-files-to-download",headingTag:"h3"}}),D=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwYWxsb3dfcGF0dGVybnMlM0QlMjIqLmpzb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, allow_patterns=<span class="hljs-string">&quot;*.json&quot;</span>)`,wrap:!1}}),V=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwaWdub3JlX3BhdHRlcm5zJTNEJTVCJTIyKi5tc2dwYWNrJTIyJTJDJTIwJTIyKi5oNSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, ignore_patterns=[<span class="hljs-string">&quot;*.msgpack&quot;</span>, <span class="hljs-string">&quot;*.h5&quot;</span>])`,wrap:!1}}),E=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmdwdDIlMjIlMkMlMjBhbGxvd19wYXR0ZXJucyUzRCU1QiUyMioubWQlMjIlMkMlMjAlMjIqLmpzb24lMjIlNUQlMkMlMjBpZ25vcmVfcGF0dGVybnMlM0QlMjJ2b2NhYi5qc29uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;gpt2&quot;</span>, allow_patterns=[<span class="hljs-string">&quot;*.md&quot;</span>, <span class="hljs-string">&quot;*.json&quot;</span>], ignore_patterns=<span class="hljs-string">&quot;vocab.json&quot;</span>)`,wrap:!1}}),K=new y({props:{title:"Download file(s) to local folder",local:"download-files-to-local-folder",headingTag:"h2"}}),se=new y({props:{title:"Download from the CLI",local:"download-from-the-cli",headingTag:"h2"}}),ie=new w({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24=",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`,wrap:!1}}),re=new w({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24lMjAtLXRva2VuJTNEaGZfKioqKg==",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json --token=hf_****
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`,wrap:!1}}),he=new w({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24lMjBtb2RlbC5zYWZldGVuc29ycw==",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json model.safetensors
Fetching 2 files: 100%|████████████████████████████████████████████| 2/2 [00:00&lt;00:00, 23831.27it/s]
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10`,wrap:!1}}),fe=new w({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24lMjBtb2RlbC5zYWZldGVuc29ycw==",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json model.safetensors
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10`,wrap:!1}}),ge=new w({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24lMjAtLWNhY2hlLWRpciUzRC4lMkZjYWNoZQ==",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json --cache-dir=./cache
./cache/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`,wrap:!1}}),we=new w({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24lMjAtLWxvY2FsLWRpciUzRC4lMkZtb2RlbHMlMkZncHQy",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json --local-dir=./models/gpt2
./models/gpt2/config.json`,wrap:!1}}),ye=new w({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBiaWdjb2RlJTJGdGhlLXN0YWNrJTIwLS1yZXBvLXR5cGUlM0RkYXRhc2V0JTIwLS1yZXZpc2lvbiUzRHYxLjIlMjAtLWluY2x1ZGUlM0QlMjJkYXRhJTJGcHl0aG9uJTJGKiUyMiUyMC0tZXhjbHU=",highlighted:`&gt;&gt;&gt; huggingface-cli download bigcode/the-stack --repo-type=dataset --revision=v1.2 --include=<span class="hljs-string">&quot;data/python/*&quot;</span> --exclu
de=<span class="hljs-string">&quot;*.json&quot;</span> --exclude=<span class="hljs-string">&quot;*.zip&quot;</span>
Fetching 206 files:   100%|████████████████████████████████████████████| 206/206 [02:31&lt;2:31, ?it/s]
/home/wauplin/.cache/huggingface/hub/datasets--bigcode--the-stack/snapshots/9ca8fa6acdbc8ce920a0cb58adcdafc495818ae7`,wrap:!1}}),$e=new w({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjAtLWhlbHA=",highlighted:'huggingface-cli download --<span class="hljs-built_in">help</span>',wrap:!1}}),ve=new y({props:{title:"Faster downloads",local:"faster-downloads",headingTag:"h2"}}),v=new cl({props:{warning:!0,$$slots:{default:[yl]},$$scope:{ctx:Te}}}),{c(){g=o("meta"),b=n(),m=o("p"),_=n(),r(M.$$.fragment),ke=n(),T=o("p"),T.innerHTML=xt,He=n(),j=o("ul"),j.innerHTML=Yt,Je=n(),r(k.$$.fragment),Ze=n(),H=o("p"),H.innerHTML=qt,xe=n(),r($.$$.fragment),Ye=n(),r(J.$$.fragment),qe=n(),Z=o("p"),Z.innerHTML=Lt,Le=n(),r(x.$$.fragment),Ue=n(),r(Y.$$.fragment),Ce=n(),q=o("p"),q.innerHTML=Ut,Ie=n(),r(L.$$.fragment),Ge=n(),U=o("p"),U.innerHTML=Ct,Xe=n(),r(C.$$.fragment),Re=n(),I=o("p"),I.innerHTML=It,We=n(),r(G.$$.fragment),Be=n(),X=o("p"),X.innerHTML=Gt,Qe=n(),R=o("p"),R.innerHTML=Xt,ze=n(),r(W.$$.fragment),Ne=n(),B=o("p"),B.innerHTML=Rt,Fe=n(),r(Q.$$.fragment),Pe=n(),r(z.$$.fragment),De=n(),N=o("p"),N.innerHTML=Wt,Se=n(),F=o("p"),F.innerHTML=Bt,Ve=n(),P=o("p"),P.innerHTML=Qt,Ae=n(),r(D.$$.fragment),Ee=n(),S=o("p"),S.innerHTML=zt,Ke=n(),r(V.$$.fragment),Oe=n(),A=o("p"),A.innerHTML=Nt,et=n(),r(E.$$.fragment),tt=n(),r(K.$$.fragment),lt=n(),O=o("p"),O.innerHTML=Ft,at=n(),ee=o("p"),ee.innerHTML=Pt,nt=n(),te=o("ul"),te.innerHTML=Dt,st=n(),le=o("p"),le.textContent=St,ot=n(),ae=o("table"),ae.innerHTML=Vt,it=n(),ne=o("p"),ne.innerHTML=At,dt=n(),r(se.$$.fragment),rt=n(),oe=o("p"),oe.innerHTML=Et,ct=n(),r(ie.$$.fragment),ht=n(),de=o("p"),de.innerHTML=Kt,pt=n(),r(re.$$.fragment),ft=n(),ce=o("p"),ce.textContent=Ot,ut=n(),r(he.$$.fragment),gt=n(),pe=o("p"),pe.innerHTML=el,mt=n(),r(fe.$$.fragment),wt=n(),ue=o("p"),ue.innerHTML=tl,bt=n(),r(ge.$$.fragment),yt=n(),me=o("p"),me.innerHTML=ll,_t=n(),r(we.$$.fragment),$t=n(),be=o("p"),be.textContent=al,vt=n(),r(ye.$$.fragment),Mt=n(),_e=o("p"),_e.textContent=nl,Tt=n(),r($e.$$.fragment),jt=n(),r(ve.$$.fragment),kt=n(),Me=o("p"),Me.innerHTML=sl,Ht=n(),r(v.$$.fragment),Jt=n(),je=o("p"),this.h()},l(e){const t=ml("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(l),b=s(e),m=i(e,"P",{}),dl(m).forEach(l),_=s(e),c(M.$$.fragment,e),ke=s(e),T=i(e,"P",{"data-svelte-h":!0}),d(T)!=="svelte-10amgpw"&&(T.innerHTML=xt),He=s(e),j=i(e,"UL",{"data-svelte-h":!0}),d(j)!=="svelte-39f2bi"&&(j.innerHTML=Yt),Je=s(e),c(k.$$.fragment,e),Ze=s(e),H=i(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-1tacu8f"&&(H.innerHTML=qt),xe=s(e),c($.$$.fragment,e),Ye=s(e),c(J.$$.fragment,e),qe=s(e),Z=i(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-18kdxej"&&(Z.innerHTML=Lt),Le=s(e),c(x.$$.fragment,e),Ue=s(e),c(Y.$$.fragment,e),Ce=s(e),q=i(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-16duplw"&&(q.innerHTML=Ut),Ie=s(e),c(L.$$.fragment,e),Ge=s(e),U=i(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1inqh8h"&&(U.innerHTML=Ct),Xe=s(e),c(C.$$.fragment,e),Re=s(e),I=i(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-31nze2"&&(I.innerHTML=It),We=s(e),c(G.$$.fragment,e),Be=s(e),X=i(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-b1eucj"&&(X.innerHTML=Gt),Qe=s(e),R=i(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-18b676r"&&(R.innerHTML=Xt),ze=s(e),c(W.$$.fragment,e),Ne=s(e),B=i(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-8l8f39"&&(B.innerHTML=Rt),Fe=s(e),c(Q.$$.fragment,e),Pe=s(e),c(z.$$.fragment,e),De=s(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-sboivb"&&(N.innerHTML=Wt),Se=s(e),F=i(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-u3vbhu"&&(F.innerHTML=Bt),Ve=s(e),P=i(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-1dn885x"&&(P.innerHTML=Qt),Ae=s(e),c(D.$$.fragment,e),Ee=s(e),S=i(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-uzetax"&&(S.innerHTML=zt),Ke=s(e),c(V.$$.fragment,e),Oe=s(e),A=i(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-ndvph"&&(A.innerHTML=Nt),et=s(e),c(E.$$.fragment,e),tt=s(e),c(K.$$.fragment,e),lt=s(e),O=i(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-hvnxjk"&&(O.innerHTML=Ft),at=s(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-ph8yhc"&&(ee.innerHTML=Pt),nt=s(e),te=i(e,"UL",{"data-svelte-h":!0}),d(te)!=="svelte-8wrzrg"&&(te.innerHTML=Dt),st=s(e),le=i(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-bmnyq5"&&(le.textContent=St),ot=s(e),ae=i(e,"TABLE",{"data-svelte-h":!0}),d(ae)!=="svelte-1qvhd9t"&&(ae.innerHTML=Vt),it=s(e),ne=i(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1slb1nq"&&(ne.innerHTML=At),dt=s(e),c(se.$$.fragment,e),rt=s(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1kwpg1b"&&(oe.innerHTML=Et),ct=s(e),c(ie.$$.fragment,e),ht=s(e),de=i(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-1ivwxb5"&&(de.innerHTML=Kt),pt=s(e),c(re.$$.fragment,e),ft=s(e),ce=i(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-c19wqr"&&(ce.textContent=Ot),ut=s(e),c(he.$$.fragment,e),gt=s(e),pe=i(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1b2g1yi"&&(pe.innerHTML=el),mt=s(e),c(fe.$$.fragment,e),wt=s(e),ue=i(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-q75tw1"&&(ue.innerHTML=tl),bt=s(e),c(ge.$$.fragment,e),yt=s(e),me=i(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1qj6x7w"&&(me.innerHTML=ll),_t=s(e),c(we.$$.fragment,e),$t=s(e),be=i(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-dgjt9v"&&(be.textContent=al),vt=s(e),c(ye.$$.fragment,e),Mt=s(e),_e=i(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-1e8vszn"&&(_e.textContent=nl),Tt=s(e),c($e.$$.fragment,e),jt=s(e),c(ve.$$.fragment,e),kt=s(e),Me=i(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-1e9pmj4"&&(Me.innerHTML=sl),Ht=s(e),c(v.$$.fragment,e),Jt=s(e),je=i(e,"P",{}),dl(je).forEach(l),this.h()},h(){rl(g,"name","hf:doc:metadata"),rl(g,"content",$l)},m(e,t){wl(document.head,g),a(e,b,t),a(e,m,t),a(e,_,t),h(M,e,t),a(e,ke,t),a(e,T,t),a(e,He,t),a(e,j,t),a(e,Je,t),h(k,e,t),a(e,Ze,t),a(e,H,t),a(e,xe,t),h($,e,t),a(e,Ye,t),h(J,e,t),a(e,qe,t),a(e,Z,t),a(e,Le,t),h(x,e,t),a(e,Ue,t),h(Y,e,t),a(e,Ce,t),a(e,q,t),a(e,Ie,t),h(L,e,t),a(e,Ge,t),a(e,U,t),a(e,Xe,t),h(C,e,t),a(e,Re,t),a(e,I,t),a(e,We,t),h(G,e,t),a(e,Be,t),a(e,X,t),a(e,Qe,t),a(e,R,t),a(e,ze,t),h(W,e,t),a(e,Ne,t),a(e,B,t),a(e,Fe,t),h(Q,e,t),a(e,Pe,t),h(z,e,t),a(e,De,t),a(e,N,t),a(e,Se,t),a(e,F,t),a(e,Ve,t),a(e,P,t),a(e,Ae,t),h(D,e,t),a(e,Ee,t),a(e,S,t),a(e,Ke,t),h(V,e,t),a(e,Oe,t),a(e,A,t),a(e,et,t),h(E,e,t),a(e,tt,t),h(K,e,t),a(e,lt,t),a(e,O,t),a(e,at,t),a(e,ee,t),a(e,nt,t),a(e,te,t),a(e,st,t),a(e,le,t),a(e,ot,t),a(e,ae,t),a(e,it,t),a(e,ne,t),a(e,dt,t),h(se,e,t),a(e,rt,t),a(e,oe,t),a(e,ct,t),h(ie,e,t),a(e,ht,t),a(e,de,t),a(e,pt,t),h(re,e,t),a(e,ft,t),a(e,ce,t),a(e,ut,t),h(he,e,t),a(e,gt,t),a(e,pe,t),a(e,mt,t),h(fe,e,t),a(e,wt,t),a(e,ue,t),a(e,bt,t),h(ge,e,t),a(e,yt,t),a(e,me,t),a(e,_t,t),h(we,e,t),a(e,$t,t),a(e,be,t),a(e,vt,t),h(ye,e,t),a(e,Mt,t),a(e,_e,t),a(e,Tt,t),h($e,e,t),a(e,jt,t),h(ve,e,t),a(e,kt,t),a(e,Me,t),a(e,Ht,t),h(v,e,t),a(e,Jt,t),a(e,je,t),Zt=!0},p(e,[t]){const ol={};t&2&&(ol.$$scope={dirty:t,ctx:e}),$.$set(ol);const il={};t&2&&(il.$$scope={dirty:t,ctx:e}),v.$set(il)},i(e){Zt||(p(M.$$.fragment,e),p(k.$$.fragment,e),p($.$$.fragment,e),p(J.$$.fragment,e),p(x.$$.fragment,e),p(Y.$$.fragment,e),p(L.$$.fragment,e),p(C.$$.fragment,e),p(G.$$.fragment,e),p(W.$$.fragment,e),p(Q.$$.fragment,e),p(z.$$.fragment,e),p(D.$$.fragment,e),p(V.$$.fragment,e),p(E.$$.fragment,e),p(K.$$.fragment,e),p(se.$$.fragment,e),p(ie.$$.fragment,e),p(re.$$.fragment,e),p(he.$$.fragment,e),p(fe.$$.fragment,e),p(ge.$$.fragment,e),p(we.$$.fragment,e),p(ye.$$.fragment,e),p($e.$$.fragment,e),p(ve.$$.fragment,e),p(v.$$.fragment,e),Zt=!0)},o(e){f(M.$$.fragment,e),f(k.$$.fragment,e),f($.$$.fragment,e),f(J.$$.fragment,e),f(x.$$.fragment,e),f(Y.$$.fragment,e),f(L.$$.fragment,e),f(C.$$.fragment,e),f(G.$$.fragment,e),f(W.$$.fragment,e),f(Q.$$.fragment,e),f(z.$$.fragment,e),f(D.$$.fragment,e),f(V.$$.fragment,e),f(E.$$.fragment,e),f(K.$$.fragment,e),f(se.$$.fragment,e),f(ie.$$.fragment,e),f(re.$$.fragment,e),f(he.$$.fragment,e),f(fe.$$.fragment,e),f(ge.$$.fragment,e),f(we.$$.fragment,e),f(ye.$$.fragment,e),f($e.$$.fragment,e),f(ve.$$.fragment,e),f(v.$$.fragment,e),Zt=!1},d(e){e&&(l(b),l(m),l(_),l(ke),l(T),l(He),l(j),l(Je),l(Ze),l(H),l(xe),l(Ye),l(qe),l(Z),l(Le),l(Ue),l(Ce),l(q),l(Ie),l(Ge),l(U),l(Xe),l(Re),l(I),l(We),l(Be),l(X),l(Qe),l(R),l(ze),l(Ne),l(B),l(Fe),l(Pe),l(De),l(N),l(Se),l(F),l(Ve),l(P),l(Ae),l(Ee),l(S),l(Ke),l(Oe),l(A),l(et),l(tt),l(lt),l(O),l(at),l(ee),l(nt),l(te),l(st),l(le),l(ot),l(ae),l(it),l(ne),l(dt),l(rt),l(oe),l(ct),l(ht),l(de),l(pt),l(ft),l(ce),l(ut),l(gt),l(pe),l(mt),l(wt),l(ue),l(bt),l(yt),l(me),l(_t),l($t),l(be),l(vt),l(Mt),l(_e),l(Tt),l(jt),l(kt),l(Me),l(Ht),l(Jt),l(je)),l(g),u(M,e),u(k,e),u($,e),u(J,e),u(x,e),u(Y,e),u(L,e),u(C,e),u(G,e),u(W,e),u(Q,e),u(z,e),u(D,e),u(V,e),u(E,e),u(K,e),u(se,e),u(ie,e),u(re,e),u(he,e),u(fe,e),u(ge,e),u(we,e),u(ye,e),u($e,e),u(ve,e),u(v,e)}}}const $l='{"title":"Download files from the Hub","local":"download-files-from-the-hub","sections":[{"title":"Download a single file","local":"download-a-single-file","sections":[{"title":"From latest version","local":"from-latest-version","sections":[],"depth":3},{"title":"From specific version","local":"from-specific-version","sections":[],"depth":3},{"title":"Construct a download URL","local":"construct-a-download-url","sections":[],"depth":3}],"depth":2},{"title":"Download an entire repository","local":"download-an-entire-repository","sections":[{"title":"Filter files to download","local":"filter-files-to-download","sections":[],"depth":3}],"depth":2},{"title":"Download file(s) to local folder","local":"download-files-to-local-folder","sections":[],"depth":2},{"title":"Download from the CLI","local":"download-from-the-cli","sections":[],"depth":2},{"title":"Faster downloads","local":"faster-downloads","sections":[],"depth":2}],"depth":1}';function vl(Te){return fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jl extends ul{constructor(g){super(),gl(this,g,vl,_l,pl,{})}}export{Jl as component};
