import{s as La,o as Pa,n as kn}from"../chunks/scheduler.182ea377.js";import{S as Za,i as Ga,g as o,s as l,r as u,A as Ra,h as a,f as i,c as n,j as Mi,u as p,x as r,k as $i,y as $,a as s,v as f,d,t as h,w as m}from"../chunks/index.abf12888.js";import{T as Aa}from"../chunks/Tip.230e2334.js";import{C as b}from"../chunks/CodeBlock.57fe6e13.js";import{H as w,E as Wa}from"../chunks/EditOnGithub.9b8e78e4.js";import{H as Ba,a as ja}from"../chunks/HfOption.fc88c804.js";function qa(x){let c,T='Read the <a href="../using-diffusers/custom_pipeline_overview#community-pipelines">Community pipelines</a> guide to learn more about the difference between a GitHub and Hugging Face Hub community pipeline. If you’re interested in why we have community pipelines, take a look at GitHub Issue <a href="https://github.com/huggingface/diffusers/issues/841" rel="nofollow">#841</a> (basically, we can’t maintain all the possible ways diffusion models can be used for inference but we also don’t want to prevent the community from building them).';return{c(){c=o("p"),c.innerHTML=T},l(g){c=a(g,"P",{"data-svelte-h":!0}),r(c)!=="svelte-h37xsq"&&(c.innerHTML=T)},m(g,v){s(g,c,v)},p:kn,d(g){g&&i(c)}}}function Va(x){let c,T='Share your GitHub pipeline by opening a pull request on the Diffusers <a href="https://github.com/huggingface/diffusers" rel="nofollow">repository</a> and add the one_step_unet.py file to the <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">examples/community</a> subfolder.';return{c(){c=o("p"),c.innerHTML=T},l(g){c=a(g,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1o65hru"&&(c.innerHTML=T)},m(g,v){s(g,c,v)},p:kn,d(g){g&&i(c)}}}function Xa(x){let c,T="Share your Hub pipeline by creating a model repository on the Hub and uploading the one_step_unet.py file to it.";return{c(){c=o("p"),c.textContent=T},l(g){c=a(g,"P",{"data-svelte-h":!0}),r(c)!=="svelte-b63tr0"&&(c.textContent=T)},m(g,v){s(g,c,v)},p:kn,d(g){g&&i(c)}}}function Na(x){let c,T,g,v;return c=new ja({props:{id:"pipeline type",option:"GitHub pipeline",$$slots:{default:[Va]},$$scope:{ctx:x}}}),g=new ja({props:{id:"pipeline type",option:"Hub pipeline",$$slots:{default:[Xa]},$$scope:{ctx:x}}}),{c(){u(c.$$.fragment),T=l(),u(g.$$.fragment)},l(y){p(c.$$.fragment,y),T=n(y),p(g.$$.fragment,y)},m(y,M){f(c,y,M),s(y,T,M),f(g,y,M),v=!0},p(y,M){const I={};M&2&&(I.$$scope={dirty:M,ctx:y}),c.$set(I);const ki={};M&2&&(ki.$$scope={dirty:M,ctx:y}),g.$set(ki)},i(y){v||(d(c.$$.fragment,y),d(g.$$.fragment,y),v=!0)},o(y){h(c.$$.fragment,y),h(g.$$.fragment,y),v=!1},d(y){y&&i(T),m(c,y),m(g,y)}}}function Da(x){let c,T,g,v,y,M,I,ki="We ❤️ contributions from the open-source community! Everyone is welcome, and all types of participation –not just code– are valued and appreciated. Answering questions, helping others, reaching out, and improving the documentation are all immensely valuable to the community, so don’t be afraid and get involved if you’re up for it!",_i,P,Hn='Everyone is encouraged to start by saying 👋 in our public Discord channel. We discuss the latest trends in diffusion models, ask questions, show off personal projects, help each other with contributions, or just hang out ☕. <a href="https://Discord.gg/G7tWnz98XR"><img alt="Join us on Discord" src="https://img.shields.io/discord/823813159592001537?color=5865F2&amp;logo=discord&amp;logoColor=white"/></a>',Ui,Z,_n='Whichever way you choose to contribute, we strive to be part of an open, welcoming, and kind community. Please, read our <a href="https://github.com/huggingface/diffusers/blob/main/CODE_OF_CONDUCT.md" rel="nofollow">code of conduct</a> and be mindful to respect it during your interactions. We also recommend you become familiar with the <a href="https://huggingface.co/docs/diffusers/conceptual/ethical_guidelines" rel="nofollow">ethical guidelines</a> that guide our project and ask you to adhere to the same principles of transparency and responsibility.',ji,G,Un="We enormously value feedback from the community, so please do not be afraid to speak up if you believe you have valuable feedback that can help improve the library - every message, comment, issue, and pull request (PR) is read and considered.",Li,R,Pi,A,jn=`You can contribute in many ways ranging from answering questions on issues to adding new diffusion models to
the core library.`,Zi,W,Ln="In the following, we give an overview of different ways to contribute, ranked by difficulty in ascending order. All of them are valuable to the community.",Gi,B,Pn='<li><ol><li>Asking and answering questions on <a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers" rel="nofollow">the Diffusers discussion forum</a> or on <a href="https://discord.gg/G7tWnz98XR" rel="nofollow">Discord</a>.</li></ol></li> <li><ol start="2"><li>Opening new issues on <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">the GitHub Issues tab</a>.</li></ol></li> <li><ol start="3"><li>Answering issues on <a href="https://github.com/huggingface/diffusers/issues" rel="nofollow">the GitHub Issues tab</a>.</li></ol></li> <li><ol start="4"><li>Fix a simple issue, marked by the “Good first issue” label, see <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22" rel="nofollow">here</a>.</li></ol></li> <li><ol start="5"><li>Contribute to the <a href="https://github.com/huggingface/diffusers/tree/main/docs/source" rel="nofollow">documentation</a>.</li></ol></li> <li><ol start="6"><li>Contribute a <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3Acommunity-examples" rel="nofollow">Community Pipeline</a>.</li></ol></li> <li><ol start="7"><li>Contribute to the <a href="https://github.com/huggingface/diffusers/tree/main/examples" rel="nofollow">examples</a>.</li></ol></li> <li><ol start="8"><li>Fix a more difficult issue, marked by the “Good second issue” label, see <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22Good+second+issue%22" rel="nofollow">here</a>.</li></ol></li> <li><ol start="9"><li>Add a new pipeline, model, or scheduler, see <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+pipeline%2Fmodel%22" rel="nofollow">“New Pipeline/Model”</a> and <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+scheduler%22" rel="nofollow">“New scheduler”</a> issues. For this contribution, please have a look at <a href="https://github.com/huggingface/diffusers/blob/main/PHILOSOPHY.md" rel="nofollow">Design Philosophy</a>.</li></ol></li>',Ri,q,Zn=`As said before, <strong>all contributions are valuable to the community</strong>.
In the following, we will explain each contribution a bit more in detail.`,Ai,V,Gn='For all contributions 4 - 9, you will need to open a PR. It is explained in detail how to do so in <a href="#how-to-open-a-pr">Opening a pull request</a>.',Wi,X,Bi,N,Rn='Any question or comment related to the Diffusers library can be asked on the <a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers/" rel="nofollow">discussion forum</a> or on <a href="https://discord.gg/G7tWnz98XR" rel="nofollow">Discord</a>. Such questions and comments include (but are not limited to):',qi,D,An="<li>Reports of training or inference experiments in an attempt to share knowledge</li> <li>Presentation of personal projects</li> <li>Questions to non-official training examples</li> <li>Project proposals</li> <li>General feedback</li> <li>Paper summaries</li> <li>Asking for help on personal projects that build on top of the Diffusers library</li> <li>General questions</li> <li>Ethical questions regarding diffusion models</li> <li>…</li>",Vi,S,Wn=`Every question that is asked on the forum or on Discord actively encourages the community to publicly
share knowledge and might very well help a beginner in the future who has the same question you’re
having. Please do pose any questions you might have.
In the same spirit, you are of immense help to the community by answering such questions because this way you are publicly documenting knowledge for everybody to learn from.`,Xi,F,Bn=`<strong>Please</strong> keep in mind that the more effort you put into asking or answering a question, the higher
the quality of the publicly documented knowledge. In the same way, well-posed and well-answered questions create a high-quality knowledge database accessible to everybody, while badly posed questions or answers reduce the overall quality of the public knowledge database.
In short, a high quality question or answer is <em>precise</em>, <em>concise</em>, <em>relevant</em>, <em>easy-to-understand</em>, <em>accessible</em>, and <em>well-formated/well-posed</em>. For more information, please have a look through the <a href="#how-to-write-a-good-issue">How to write a good issue</a> section.`,Ni,Y,qn=`<strong>NOTE about channels</strong>:
<a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers/63" rel="nofollow"><em>The forum</em></a> is much better indexed by search engines, such as Google. Posts are ranked by popularity rather than chronologically. Hence, it’s easier to look up questions and answers that we posted some time ago.
In addition, questions and answers posted in the forum can easily be linked to.
In contrast, <em>Discord</em> has a chat-like format that invites fast back-and-forth communication.
While it will most likely take less time for you to get an answer to your question on Discord, your
question won’t be visible anymore over time. Also, it’s much harder to find information that was posted a while back on Discord. We therefore strongly recommend using the forum for high-quality questions and answers in an attempt to create long-lasting knowledge for the community. If discussions on Discord lead to very interesting answers and conclusions, we recommend posting the results on the forum to make the information more available for future readers.`,Di,z,Si,E,Vn=`The 🧨 Diffusers library is robust and reliable thanks to the users who notify us of
the problems they encounter. So thank you for reporting an issue.`,Fi,Q,Xn="Remember, GitHub issues are reserved for technical questions directly related to the Diffusers library, bug reports, feature requests, or feedback on the library design.",Yi,O,Nn='In a nutshell, this means that everything that is <strong>not</strong> related to the <strong>code of the Diffusers library</strong> (including the documentation) should <strong>not</strong> be asked on GitHub, but rather on either the <a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers/63" rel="nofollow">forum</a> or <a href="https://discord.gg/G7tWnz98XR" rel="nofollow">Discord</a>.',zi,K,Dn="<strong>Please consider the following guidelines when opening a new issue</strong>:",Ei,ee,Sn=`<li>Make sure you have searched whether your issue has already been asked before (use the search bar on GitHub under Issues).</li> <li>Please never report a new issue on another (related) issue. If another issue is highly related, please
open a new issue nevertheless and link to the related issue.</li> <li>Make sure your issue is written in English. Please use one of the great, free online translation services, such as <a href="https://www.deepl.com/translator" rel="nofollow">DeepL</a> to translate from your native language to English if you are not comfortable in English.</li> <li>Check whether your issue might be solved by updating to the newest Diffusers version. Before posting your issue, please make sure that <code>python -c &quot;import diffusers; print(diffusers.__version__)&quot;</code> is higher or matches the latest Diffusers version.</li> <li>Remember that the more effort you put into opening a new issue, the higher the quality of your answer will be and the better the overall quality of the Diffusers issues.</li>`,Qi,te,Fn="New issues usually include the following.",Oi,ie,Ki,se,Yn=`A bug report should always have a reproducible code snippet and be as minimal and concise as possible.
This means in more detail:`,es,le,zn='<li>Narrow the bug down as much as you can, <strong>do not just dump your whole code file</strong>.</li> <li>Format your code.</li> <li>Do not include any external libraries except for Diffusers depending on them.</li> <li><strong>Always</strong> provide all necessary information about your environment; for this, you can run: <code>diffusers-cli env</code> in your shell and copy-paste the displayed information to the issue.</li> <li>Explain the issue. If the reader doesn’t know what the issue is and why it is an issue, she cannot solve it.</li> <li><strong>Always</strong> make sure the reader can reproduce your issue with as little effort as possible. If your code snippet cannot be run because of missing libraries or undefined variables, the reader cannot help you. Make sure your reproducible code snippet is as minimal as possible and can be copy-pasted into a simple Python shell.</li> <li>If in order to reproduce your issue a model and/or dataset is required, make sure the reader has access to that model or dataset. You can always upload your model or dataset to the <a href="https://huggingface.co" rel="nofollow">Hub</a> to make it easily downloadable. Try to keep your model and dataset as small as possible, to make the reproduction of your issue as effortless as possible.</li>',ts,ne,En='For more information, please have a look through the <a href="#how-to-write-a-good-issue">How to write a good issue</a> section.',is,oe,Qn='You can open a bug report <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=bug&amp;projects=&amp;template=bug-report.yml" rel="nofollow">here</a>.',ss,ae,ls,re,On="A world-class feature request addresses the following points:",ns,ue,Kn="<li>Motivation first:</li>",os,pe,eo=`<li>Is it related to a problem/frustration with the library? If so, please explain
why. Providing a code snippet that demonstrates the problem is best.</li> <li>Is it related to something you would need for a project? We’d love to hear
about it!</li> <li>Is it something you worked on and think could benefit the community?
Awesome! Tell us what problem it solved for you.</li>`,as,k,to="<li>Write a <em>full paragraph</em> describing the feature;</li> <li>Provide a <strong>code snippet</strong> that demonstrates its future use;</li> <li>In case this is related to a paper, please attach a link;</li> <li>Attach any additional information (drawings, screenshots, etc.) you think may help.</li>",rs,fe,io='You can open a feature request <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=&amp;template=feature_request.md&amp;title=" rel="nofollow">here</a>.',us,de,ps,he,so=`Feedback about the library design and why it is good or not good helps the core maintainers immensely to build a user-friendly library. To understand the philosophy behind the current design philosophy, please have a look <a href="https://huggingface.co/docs/diffusers/conceptual/philosophy" rel="nofollow">here</a>. If you feel like a certain design choice does not fit with the current design philosophy, please explain why and how it should be changed. If a certain design choice follows the design philosophy too much, hence restricting use cases, explain why and how it should be changed.
If a certain design choice is very useful for you, please also leave a note as this is great feedback for future design decisions.`,fs,me,lo='You can open an issue about feedback <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=&amp;template=feedback.md&amp;title=" rel="nofollow">here</a>.',ds,ce,hs,ge,no=`Technical questions are mainly about why certain code of the library was written in a certain way, or what a certain part of the code does. Please make sure to link to the code in question and please provide details on
why this part of the code is difficult to understand.`,ms,ye,oo='You can open an issue about a technical question <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=bug&amp;template=bug-report.yml" rel="nofollow">here</a>.',cs,we,gs,be,ao="If the diffusion model community released a new model, pipeline, or scheduler that you would like to see in the Diffusers library, please provide the following information:",ys,Te,ro="<li>Short description of the diffusion pipeline, model, or scheduler and link to the paper or public release.</li> <li>Link to any of its open-source implementation(s).</li> <li>Link to the model weights if they are available.</li>",ws,ve,uo=`If you are willing to contribute to the model yourself, let us know so we can best guide you. Also, don’t forget
to tag the original author of the component (model, scheduler, pipeline, etc.) by GitHub handle if you can find it.`,bs,Me,po='You can open a request for a model/pipeline/scheduler <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=New+model%2Fpipeline%2Fscheduler&amp;template=new-model-addition.yml" rel="nofollow">here</a>.',Ts,$e,vs,xe,fo=`Answering issues on GitHub might require some technical knowledge of Diffusers, but we encourage everybody to give it a try even if you are not 100% certain that your answer is correct.
Some tips to give a high-quality answer to an issue:`,Ms,Ie,ho="<li>Be as concise and minimal as possible.</li> <li>Stay on topic. An answer to the issue should concern the issue and only the issue.</li> <li>Provide links to code, papers, or other sources that prove or encourage your point.</li> <li>Answer in code. If a simple code snippet is the answer to the issue or shows how the issue can be solved, please provide a fully reproducible code snippet.</li>",$s,Je,mo=`Also, many issues tend to be simply off-topic, duplicates of other issues, or irrelevant. It is of great
help to the maintainers if you can answer such issues, encouraging the author of the issue to be
more precise, provide the link to a duplicated issue or redirect them to <a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers/63" rel="nofollow">the forum</a> or <a href="https://discord.gg/G7tWnz98XR" rel="nofollow">Discord</a>.`,xs,Ce,co=`If you have verified that the issued bug report is correct and requires a correction in the source code,
please have a look at the next sections.`,Is,ke,go='For all of the following contributions, you will need to open a PR. It is explained in detail how to do so in the <a href="#how-to-open-a-pr">Opening a pull request</a> section.',Js,He,Cs,_e,yo=`<em>Good first issues</em> are marked by the <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22" rel="nofollow">Good first issue</a> label. Usually, the issue already
explains how a potential solution should look so that it is easier to fix.
If the issue hasn’t been closed and you would like to try to fix this issue, you can just leave a message “I would like to try this issue.”. There are usually three scenarios:`,ks,Ue,wo="<li>a.) The issue description already proposes a fix. In this case and if the solution makes sense to you, you can open a PR or draft PR to fix it.</li> <li>b.) The issue description does not propose a fix. In this case, you can ask what a proposed fix could look like and someone from the Diffusers team should answer shortly. If you have a good idea of how to fix it, feel free to directly open a PR.</li> <li>c.) There is already an open PR to fix the issue, but the issue hasn’t been closed yet. If the PR has gone stale, you can simply open a new PR and link to the stale PR. PRs often go stale if the original contributor who wanted to fix the issue suddenly cannot find the time anymore to proceed. This often happens in open-source and is very normal. In this case, the community will be very happy if you give it a new try and leverage the knowledge of the existing PR. If there is already a PR and it is active, you can help the author by giving suggestions, reviewing the PR or even asking whether you can contribute to the PR.</li>",Hs,je,_s,Le,bo=`A good library <strong>always</strong> has good documentation! The official documentation is often one of the first points of contact for new users of the library, and therefore contributing to the documentation is a <strong>highly
valuable contribution</strong>.`,Us,Pe,To="Contributing to the library can have many forms:",js,Ze,vo="<li>Correcting spelling or grammatical errors.</li> <li>Correct incorrect formatting of the docstring. If you see that the official documentation is weirdly displayed or a link is broken, we would be very happy if you take some time to correct it.</li> <li>Correct the shape or dimensions of a docstring input or output tensor.</li> <li>Clarify documentation that is hard to understand or incorrect.</li> <li>Update outdated code examples.</li> <li>Translating the documentation to another language.</li>",Ls,Ge,Mo='Anything displayed on <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">the official Diffusers doc page</a> is part of the official documentation and can be corrected, adjusted in the respective <a href="https://github.com/huggingface/diffusers/tree/main/docs/source" rel="nofollow">documentation source</a>.',Ps,Re,$o='Please have a look at <a href="https://github.com/huggingface/diffusers/tree/main/docs" rel="nofollow">this page</a> on how to verify changes made to the documentation locally.',Zs,Ae,Gs,H,Rs,We,xo='Contributing a community pipeline is a great way to share your creativity and work with the community. It lets you build on top of the <a href="/docs/diffusers/v0.28.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> so that anyone can load and use it by setting the <code>custom_pipeline</code> parameter. This section will walk you through how to create a simple pipeline where the UNet only does a single forward pass and calls the scheduler once (a “one-step” pipeline).',As,Be,Io='<li><p>Create a one_step_unet.py file for your community pipeline. This file can contain whatever package you want to use as long as it’s installed by the user. Make sure you only have one pipeline class that inherits from <a href="/docs/diffusers/v0.28.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to load model weights and the scheduler configuration from the Hub. Add a UNet and scheduler to the <code>__init__</code> function.</p> <p>You should also add the <code>register_modules</code> function to ensure your pipeline and its components can be saved with <a href="/docs/diffusers/v0.28.0/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>.</p></li>',Ws,qe,Bs,Ve,Jo="<li>In the forward pass (which we recommend defining as <code>__call__</code>), you can add any feature you’d like. For the “one-step” pipeline, create a random image and call the UNet and scheduler once by setting <code>timestep=1</code>.</li>",qs,Xe,Vs,Ne,Co="Now you can run the pipeline by passing a UNet and scheduler to it or load pretrained weights if the pipeline structure is identical.",Xs,De,Ns,Se,ko="You can either share your pipeline as a GitHub community pipeline or Hub community pipeline.",Ds,_,Ss,Fe,Fs,Ye,Ho='Diffusers examples are a collection of training scripts that reside in <a href="https://github.com/huggingface/diffusers/tree/main/examples" rel="nofollow">examples</a>.',Ys,ze,_o="We support two types of training examples:",zs,Ee,Uo="<li>Official training examples</li> <li>Research training examples</li>",Es,Qe,jo=`Research training examples are located in <a href="https://github.com/huggingface/diffusers/tree/main/examples/research_projects" rel="nofollow">examples/research_projects</a> whereas official training examples include all folders under <a href="https://github.com/huggingface/diffusers/tree/main/examples" rel="nofollow">examples</a> except the <code>research_projects</code> and <code>community</code> folders.
The official training examples are maintained by the Diffusers’ core maintainers whereas the research training examples are maintained by the community.
This is because of the same reasons put forward in <a href="#6-contribute-a-community-pipeline">6. Contribute a community pipeline</a> for official pipelines vs. community pipelines: It is not feasible for the core maintainers to maintain all possible training methods for diffusion models.
If the Diffusers core maintainers and the community consider a certain training paradigm to be too experimental or not popular enough, the corresponding training code should be put in the <code>research_projects</code> folder and maintained by the author.`,Qs,Oe,Lo=`Both official training and research examples consist of a directory that contains one or more training scripts, a requirements.txt file, and a README.md file. In order for the user to make use of the
training examples, it is required to clone the repository:`,Os,Ke,Ks,et,Po="as well as to install all additional dependencies required for training:",el,tt,tl,it,Zo='Therefore when adding an example, the <code>requirements.txt</code> file shall define all pip dependencies required for your training example so that once all those are installed, the user can run the example’s training script. See, for example, the <a href="https://github.com/huggingface/diffusers/blob/main/examples/dreambooth/requirements.txt" rel="nofollow">DreamBooth <code>requirements.txt</code> file</a>.',il,st,Go="Training examples of the Diffusers library should adhere to the following philosophy:",sl,lt,Ro="<li>All the code necessary to run the examples should be found in a single Python file.</li> <li>One should be able to run the example from the command line with <code>python &lt;your-example&gt;.py --args</code>.</li> <li>Examples should be kept simple and serve as <strong>an example</strong> on how to use Diffusers for training. The purpose of example scripts is <strong>not</strong> to create state-of-the-art diffusion models, but rather to reproduce known training schemes without adding too much custom logic. As a byproduct of this point, our examples also strive to serve as good educational materials.</li>",ll,nt,Ao=`To contribute an example, it is highly recommended to look at already existing examples such as <a href="https://github.com/huggingface/diffusers/blob/main/examples/dreambooth/train_dreambooth.py" rel="nofollow">dreambooth</a> to get an idea of how they should look like.
We strongly advise contributors to make use of the <a href="https://github.com/huggingface/accelerate" rel="nofollow">Accelerate library</a> as it’s tightly integrated
with Diffusers.
Once an example script works, please make sure to add a comprehensive <code>README.md</code> that states how to use the example exactly. This README should include:`,nl,ot,Wo='<li>An example command on how to run the example script as shown <a href="https://github.com/huggingface/diffusers/tree/main/examples/dreambooth#running-locally-with-pytorch" rel="nofollow">here</a>.</li> <li>A link to some training results (logs, models, etc.) that show what the user can expect as shown <a href="https://api.wandb.ai/report/patrickvonplaten/xm6cd5q5" rel="nofollow">here</a>.</li> <li>If you are adding a non-official/research training example, <strong>please don’t forget</strong> to add a sentence that you are maintaining this training example which includes your git handle as shown <a href="https://github.com/huggingface/diffusers/tree/main/examples/research_projects/intel_opts#diffusers-examples-with-intel-optimizations" rel="nofollow">here</a>.</li>',ol,at,Bo='If you are contributing to the official training examples, please also make sure to add a test to <a href="https://github.com/huggingface/diffusers/blob/main/examples/test_examples.py" rel="nofollow">examples/test_examples.py</a>. This is not necessary for non-official training examples.',al,rt,rl,ut,qo=`<em>Good second issues</em> are marked by the <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22Good+second+issue%22" rel="nofollow">Good second issue</a> label. Good second issues are
usually more complicated to solve than <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22" rel="nofollow">Good first issues</a>.
The issue description usually gives less guidance on how to fix the issue and requires
a decent understanding of the library by the interested contributor.
If you are interested in tackling a good second issue, feel free to open a PR to fix it and link the PR to the issue. If you see that a PR has already been opened for this issue but did not get merged, have a look to understand why it wasn’t merged and try to open an improved PR.
Good second issues are usually more difficult to get merged compared to good first issues, so don’t hesitate to ask for help from the core maintainers. If your PR is almost finished the core maintainers can also jump into your PR and commit to it in order to get it merged.`,ul,pt,pl,ft,Vo=`Pipelines, models, and schedulers are the most important pieces of the Diffusers library.
They provide easy access to state-of-the-art diffusion technologies and thus allow the community to
build powerful generative AI applications.`,fl,dt,Xo="By adding a new model, pipeline, or scheduler you might enable a new powerful use case for any of the user interfaces relying on Diffusers which can be of immense value for the whole generative AI ecosystem.",dl,ht,No=`Diffusers has a couple of open feature requests for all three components - feel free to gloss over them
if you don’t know yet what specific component you would like to add:`,hl,mt,Do='<li><a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+pipeline%2Fmodel%22" rel="nofollow">Model or pipeline</a></li> <li><a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+scheduler%22" rel="nofollow">Scheduler</a></li>',ml,ct,So=`Before adding any of the three components, it is strongly recommended that you give the <a href="philosophy">Philosophy guide</a> a read to better understand the design of any of the three components. Please be aware that we cannot merge model, scheduler, or pipeline additions that strongly diverge from our design philosophy
as it will lead to API inconsistencies. If you fundamentally disagree with a design choice, please open a <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=&amp;template=feedback.md&amp;title=" rel="nofollow">Feedback issue</a> instead so that it can be discussed whether a certain design pattern/design choice shall be changed everywhere in the library and whether we shall update our design philosophy. Consistency across the library is very important for us.`,cl,gt,Fo="Please make sure to add links to the original codebase/paper to the PR and ideally also ping the original author directly on the PR so that they can follow the progress and potentially help with questions.",gl,yt,Yo="If you are unsure or stuck in the PR, don’t hesitate to leave a message to ask for a first review or help.",yl,wt,wl,bt,zo="A unique and important feature to understand when adding any pipeline, model or scheduler code is the <code># Copied from</code> mechanism. You’ll see this all over the Diffusers codebase, and the reason we use it is to keep the codebase easy to understand and maintain. Marking code with the <code># Copied from</code> mechanism forces the marked code to be identical to the code it was copied from. This makes it easy to update and propagate changes across many files whenever you run <code>make fix-copies</code>.",bl,Tt,Eo='For example, in the code example below, <a href="/docs/diffusers/v0.28.0/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> is the original code and <code>AltDiffusionPipelineOutput</code> uses the <code># Copied from</code> mechanism to copy it. The only difference is changing the class prefix from <code>Stable</code> to <code>Alt</code>.',Tl,vt,vl,Mt,Qo='To learn more, read this section of the <a href="https://huggingface.co/blog/transformers-design-philosophy#4-machine-learning-models-are-static" rel="nofollow">~Don’t~ Repeat Yourself*</a> blog post.',Ml,$t,$l,xt,Oo="<strong>The better your issue is written, the higher the chances that it will be quickly resolved.</strong>",xl,It,Ko='<li>Make sure that you’ve used the correct template for your issue. You can pick between <em>Bug Report</em>, <em>Feature Request</em>, <em>Feedback about API Design</em>, <em>New model/pipeline/scheduler addition</em>, <em>Forum</em>, or a blank issue. Make sure to pick the correct one when opening <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">a new issue</a>.</li> <li><strong>Be precise</strong>: Give your issue a fitting title. Try to formulate your issue description as simple as possible. The more precise you are when submitting an issue, the less time it takes to understand the issue and potentially solve it. Make sure to open an issue for one issue only and not for multiple issues. If you found multiple issues, simply open multiple issues. If your issue is a bug, try to be as precise as possible about what bug it is - you should not just write “Error in diffusers”.</li> <li><strong>Reproducibility</strong>: No reproducible code snippet == no solution. If you encounter a bug, maintainers <strong>have to be able to reproduce</strong> it. Make sure that you include a code snippet that can be copy-pasted into a Python interpreter to reproduce the issue. Make sure that your code snippet works, <em>i.e.</em> that there are no missing imports or missing links to images, … Your issue should contain an error message <strong>and</strong> a code snippet that can be copy-pasted without any changes to reproduce the exact same error message. If your issue is using local model weights or local data that cannot be accessed by the reader, the issue cannot be solved. If you cannot share your data or model, try to make a dummy model or dummy data.</li> <li><strong>Minimalistic</strong>: Try to help the reader as much as you can to understand the issue as quickly as possible by staying as concise as possible. Remove all code / all information that is irrelevant to the issue. If you have found a bug, try to create the easiest code example you can to demonstrate your issue, do not just dump your whole workflow into the issue as soon as you have found a bug. E.g., if you train a model and get an error at some point during the training, you should first try to understand what part of the training code is responsible for the error and try to reproduce it with a couple of lines. Try to use dummy data instead of full datasets.</li> <li>Add links. If you are referring to a certain naming, method, or model make sure to provide a link so that the reader can better understand what you mean. If you are referring to a specific PR or issue, make sure to link it to your issue. Do not assume that the reader knows what you are talking about. The more links you add to your issue the better.</li> <li>Formatting. Make sure to nicely format your issue by formatting code into Python code syntax, and error messages into normal code syntax. See the <a href="https://docs.github.com/en/get-started/writing-on-github/getting-started-with-writing-and-formatting-on-github/basic-writing-and-formatting-syntax" rel="nofollow">official GitHub formatting docs</a> for more information.</li> <li>Think of your issue not as a ticket to be solved, but rather as a beautiful entry to a well-written encyclopedia. Every added issue is a contribution to publicly available knowledge. By adding a nicely written issue you not only make it easier for maintainers to solve your issue, but you are helping the whole community to better understand a certain aspect of the library.</li>',Il,Jt,Jl,Ct,ea=`<li>Be a chameleon. Understand existing design patterns and syntax and make sure your code additions flow seamlessly into the existing code base. Pull requests that significantly diverge from existing design patterns or user interfaces will not be merged.</li> <li>Be laser focused. A pull request should solve one problem and one problem only. Make sure to not fall into the trap of “also fixing another problem while we’re adding it”. It is much more difficult to review pull requests that solve multiple, unrelated problems at once.</li> <li>If helpful, try to add a code snippet that displays an example of how your addition can be used.</li> <li>The title of your pull request should be a summary of its contribution.</li> <li>If your pull request addresses an issue, please mention the issue number in
the pull request description to make sure they are linked (and people
consulting the issue know you are working on it);</li> <li>To indicate a work in progress please prefix the title with <code>[WIP]</code>. These
are useful to avoid duplicated work, and to differentiate it from PRs ready
to be merged;</li> <li>Try to formulate and format your text as explained in <a href="#how-to-write-a-good-issue">How to write a good issue</a>.</li> <li>Make sure existing tests pass;</li> <li>Add high-coverage tests. No quality testing = no merge.</li>`,Cl,kt,ta=`<li>If you are adding new <code>@slow</code> tests, make sure they pass using
<code>RUN_SLOW=1 python -m pytest tests/test_my_new_model.py</code>.
CircleCI does not run the slow tests, but GitHub Actions does every night!</li>`,kl,U,ia=`<li>All public methods must have informative docstrings that work nicely with markdown. See <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/latent_diffusion/pipeline_latent_diffusion.py" rel="nofollow"><code>pipeline_latent_diffusion.py</code></a> for an example.</li> <li>Due to the rapidly growing repository, it is important to make sure that no files that would significantly weigh down the repository are added. This includes images, videos, and other non-text files. We prefer to leverage a hf.co hosted <code>dataset</code> like
<a href="https://huggingface.co/hf-internal-testing" rel="nofollow"><code>hf-internal-testing</code></a> or <a href="https://huggingface.co/datasets/huggingface/documentation-images" rel="nofollow">huggingface/documentation-images</a> to place these files.
If an external contribution, feel free to add the images to your PR and ask a Hugging Face member to migrate your images
to this dataset.</li>`,Hl,Ht,_l,_t,sa=`Before writing code, we strongly advise you to search through the existing PRs or
issues to make sure that nobody is already working on the same thing. If you are
unsure, it is always a good idea to open an issue to get some feedback.`,Ul,Ut,la=`You will need basic <code>git</code> proficiency to be able to contribute to
🧨 Diffusers. <code>git</code> is not the easiest tool to use but it has the greatest
manual. Type <code>git --help</code> in a shell and enjoy. If you prefer books, <a href="https://git-scm.com/book/en/v2" rel="nofollow">Pro
Git</a> is a very good reference.`,jl,jt,na='Follow these steps to start contributing (<a href="https://github.com/huggingface/diffusers/blob/main/setup.py#L244" rel="nofollow">supported Python versions</a>):',Ll,J,xi,oa=`<p>Fork the <a href="https://github.com/huggingface/diffusers" rel="nofollow">repository</a> by
clicking on the ‘Fork’ button on the repository’s page. This creates a copy of the code
under your GitHub user account.</p>`,$n,Lt,Ii,aa="Clone your fork to your local disk, and add the base repository as a remote:",xn,Pt,In,Zt,Ji,ra="Create a new branch to hold your development changes:",Jn,Gt,Pl,Rt,ua="<strong>Do not</strong> work on the <code>main</code> branch.",Zl,At,Wt,Ci,pa="Set up a development environment by running the following command in a virtual environment:",Cn,Bt,Gl,qt,fa=`If you have already cloned the repo, you might need to <code>git pull</code> to get the most recent changes in the
library.`,Rl,j,da="<li>Develop the features on your branch.</li>",Al,Vt,ha=`As you work on the features, you should make sure that the test suite
passes. You should run the tests impacted by your changes like this:`,Wl,Xt,Bl,Nt,ma=`Before you run the tests, please make sure you install the dependencies required for testing. You can do so
with this command:`,ql,Dt,Vl,St,ca=`You can also run the full test suite with the following command, but it takes
a beefy machine to produce a result in a decent amount of time now that
Diffusers has grown a lot. Here is the command for it:`,Xl,Ft,Nl,Yt,ga=`🧨 Diffusers relies on <code>black</code> and <code>isort</code> to format its source code
consistently. After you make changes, apply automatic style corrections and code verifications
that can’t be automated in one go with:`,Dl,zt,Sl,Et,ya=`🧨 Diffusers also uses <code>ruff</code> and a few custom scripts to check for coding mistakes. Quality
control runs in CI, however, you can also run the same checks with:`,Fl,Qt,Yl,Ot,wa=`Once you’re happy with your changes, add changed files using <code>git add</code> and
make a commit with <code>git commit</code> to record your changes locally:`,zl,Kt,El,ei,ba=`It is a good idea to sync your copy of the code with the original
repository regularly. This way you can quickly account for changes:`,Ql,ti,Ol,ii,Ta="Push the changes to your account using:",Kl,si,en,L,va=`<li><p>Once you are satisfied, go to the
webpage of your fork on GitHub. Click on ‘Pull request’ to send your changes
to the project maintainers for review.</p></li> <li><p>It’s OK if maintainers ask you for changes. It happens to core contributors
too! So everyone can see the changes in the Pull request, work in your local
branch and push the changes to your fork. They will automatically appear in
the pull request.</p></li>`,tn,li,sn,ni,Ma=`An extensive test suite is included to test the library behavior and several examples. Library tests can be found in
the <a href="https://github.com/huggingface/diffusers/tree/main/tests" rel="nofollow">tests folder</a>.`,ln,oi,$a=`We like <code>pytest</code> and <code>pytest-xdist</code> because it’s faster. From the root of the
repository, here’s how to run tests with <code>pytest</code> for the library:`,nn,ai,on,ri,xa="In fact, that’s how <code>make test</code> is implemented!",an,ui,Ia=`You can specify a smaller set of tests in order to test only the feature
you’re working on.`,rn,pi,Ja=`By default, slow tests are skipped. Set the <code>RUN_SLOW</code> environment variable to
<code>yes</code> to run them. This will download many gigabytes of models — make sure you
have enough disk space and a good Internet connection, or a lot of patience!`,un,fi,pn,di,Ca="<code>unittest</code> is fully supported, here’s how to run tests with it:",fn,hi,dn,mi,hn,ci,ka=`To avoid pinging the upstream repository which adds reference notes to each upstream PR and sends unnecessary notifications to the developers involved in these PRs,
when syncing the main branch of a forked repository, please, follow these steps:`,mn,gi,Ha="<li>When possible, avoid syncing with the upstream using a branch and PR on the forked repository. Instead, merge directly into the forked main.</li> <li>If a PR is absolutely necessary, use the following steps after checking out your branch:</li>",cn,yi,gn,wi,yn,bi,_a='For documentation strings, 🧨 Diffusers follows the <a href="https://google.github.io/styleguide/pyguide.html" rel="nofollow">Google style</a>.',wn,Ti,bn,Hi,Tn;return y=new w({props:{title:"How to contribute to Diffusers 🧨",local:"how-to-contribute-to-diffusers-",headingTag:"h1"}}),R=new w({props:{title:"Overview",local:"overview",headingTag:"h2"}}),X=new w({props:{title:"1. Asking and answering questions on the Diffusers discussion forum or on the Diffusers Discord",local:"1-asking-and-answering-questions-on-the-diffusers-discussion-forum-or-on-the-diffusers-discord",headingTag:"h3"}}),z=new w({props:{title:"2. Opening new issues on the GitHub issues tab",local:"2-opening-new-issues-on-the-github-issues-tab",headingTag:"h3"}}),ie=new w({props:{title:"2.1. Reproducible, minimal bug reports",local:"21-reproducible-minimal-bug-reports",headingTag:"h4"}}),ae=new w({props:{title:"2.2. Feature requests",local:"22-feature-requests",headingTag:"h4"}}),de=new w({props:{title:"2.3 Feedback",local:"23-feedback",headingTag:"h4"}}),ce=new w({props:{title:"2.4 Technical questions",local:"24-technical-questions",headingTag:"h4"}}),we=new w({props:{title:"2.5 Proposal to add a new model, scheduler, or pipeline",local:"25-proposal-to-add-a-new-model-scheduler-or-pipeline",headingTag:"h4"}}),$e=new w({props:{title:"3. Answering issues on the GitHub issues tab",local:"3-answering-issues-on-the-github-issues-tab",headingTag:"h3"}}),He=new w({props:{title:"4. Fixing a “Good first issue”",local:"4-fixing-a-good-first-issue",headingTag:"h3"}}),je=new w({props:{title:"5. Contribute to the documentation",local:"5-contribute-to-the-documentation",headingTag:"h3"}}),Ae=new w({props:{title:"6. Contribute a community pipeline",local:"6-contribute-a-community-pipeline",headingTag:"h3"}}),H=new Aa({props:{warning:!1,$$slots:{default:[qa]},$$scope:{ctx:x}}}),qe=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjbGFzcyUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUoRGlmZnVzaW9uUGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVuZXQlMkMlMjBzY2hlZHVsZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZWdpc3Rlcl9tb2R1bGVzKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">class</span> <span class="hljs-title class_">UnetSchedulerOneForwardPipeline</span>(<span class="hljs-title class_ inherited__">DiffusionPipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, unet, scheduler</span>):
        <span class="hljs-built_in">super</span>().__init__()

        self.register_modules(unet=unet, scheduler=scheduler)`,wrap:!1}}),Xe=new b({props:{code:"JTIwJTIwZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMEElMjAlMjBjbGFzcyUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUoRGlmZnVzaW9uUGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVuZXQlMkMlMjBzY2hlZHVsZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZWdpc3Rlcl9tb2R1bGVzKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB0b3JjaC5yYW5kbiglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoMSUyQyUyMHNlbGYudW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBzZWxmLnVuZXQuY29uZmlnLnNhbXBsZV9zaXplJTJDJTIwc2VsZi51bmV0LmNvbmZpZy5zYW1wbGVfc2l6ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGltZXN0ZXAlMjAlM0QlMjAxJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfb3V0cHV0JTIwJTNEJTIwc2VsZi51bmV0KGltYWdlJTJDJTIwdGltZXN0ZXApLnNhbXBsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjaGVkdWxlcl9vdXRwdXQlMjAlM0QlMjBzZWxmLnNjaGVkdWxlci5zdGVwKG1vZGVsX291dHB1dCUyQyUyMHRpbWVzdGVwJTJDJTIwaW1hZ2UpLnByZXZfc2FtcGxlJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2NoZWR1bGVyX291dHB1dA==",highlighted:`  <span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
  <span class="hljs-keyword">import</span> torch

  <span class="hljs-keyword">class</span> <span class="hljs-title class_">UnetSchedulerOneForwardPipeline</span>(<span class="hljs-title class_ inherited__">DiffusionPipeline</span>):
      <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, unet, scheduler</span>):
          <span class="hljs-built_in">super</span>().__init__()

          self.register_modules(unet=unet, scheduler=scheduler)

      <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self</span>):
          image = torch.randn(
              (<span class="hljs-number">1</span>, self.unet.config.in_channels, self.unet.config.sample_size, self.unet.config.sample_size),
          )
          timestep = <span class="hljs-number">1</span>

          model_output = self.unet(image, timestep).sample
          scheduler_output = self.scheduler.step(model_output, timestep, image).prev_sample

          <span class="hljs-keyword">return</span> scheduler_output`,wrap:!1}}),De=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMkMlMjBVTmV0MkRNb2RlbCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIoKSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRNb2RlbCgpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBVbmV0U2NoZWR1bGVyT25lRm9yd2FyZFBpcGVsaW5lKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKSUwQW91dHB1dCUyMCUzRCUyMHBpcGVsaW5lKCklMEElMjMlMjBsb2FkJTIwcHJldHJhaW5lZCUyMHdlaWdodHMlMEFwaXBlbGluZSUyMCUzRCUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmRkcG0tY2lmYXIxMC0zMiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZWxpbmUoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler, UNet2DModel

scheduler = DDPMScheduler()
unet = UNet2DModel()

pipeline = UnetSchedulerOneForwardPipeline(unet=unet, scheduler=scheduler)
output = pipeline()
<span class="hljs-comment"># load pretrained weights</span>
pipeline = UnetSchedulerOneForwardPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
output = pipeline()`,wrap:!1}}),_=new Ba({props:{id:"pipeline type",options:["GitHub pipeline","Hub pipeline"],$$slots:{default:[Na]},$$scope:{ctx:x}}}),Fe=new w({props:{title:"7. Contribute to training examples",local:"7-contribute-to-training-examples",headingTag:"h3"}}),Ke=new b({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2Vycw==",highlighted:'git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers',wrap:!1}}),tt=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1yJTIwJTJGZXhhbXBsZXMlMkYlM0N5b3VyLWV4YW1wbGUtZm9sZGVyJTNFJTJGcmVxdWlyZW1lbnRzLnR4dA==",highlighted:"pip install -r /examples/&lt;your-example-folder&gt;/requirements.txt",wrap:!1}}),rt=new w({props:{title:"8. Fixing a “Good second issue”",local:"8-fixing-a-good-second-issue",headingTag:"h3"}}),pt=new w({props:{title:"9. Adding pipelines, models, schedulers",local:"9-adding-pipelines-models-schedulers",headingTag:"h3"}}),wt=new w({props:{title:"Copied from mechanism",local:"copied-from-mechanism",headingTag:"h4"}}),vt=new b({props:{code:"JTIzJTIwQ29waWVkJTIwZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMuc3RhYmxlX2RpZmZ1c2lvbi5waXBlbGluZV9vdXRwdXQuU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmVPdXRwdXQlMjB3aXRoJTIwU3RhYmxlLSUzRUFsdCUwQWNsYXNzJTIwQWx0RGlmZnVzaW9uUGlwZWxpbmVPdXRwdXQoQmFzZU91dHB1dCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBPdXRwdXQlMjBjbGFzcyUyMGZvciUyMEFsdCUyMERpZmZ1c2lvbiUyMHBpcGVsaW5lcy4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2VzJTIwKCU2MExpc3QlNUJQSUwuSW1hZ2UuSW1hZ2UlNUQlNjAlMjBvciUyMCU2MG5wLm5kYXJyYXklNjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTGlzdCUyMG9mJTIwZGVub2lzZWQlMjBQSUwlMjBpbWFnZXMlMjBvZiUyMGxlbmd0aCUyMCU2MGJhdGNoX3NpemUlNjAlMjBvciUyME51bVB5JTIwYXJyYXklMjBvZiUyMHNoYXBlJTIwJTYwKGJhdGNoX3NpemUlMkMlMjBoZWlnaHQlMkMlMjB3aWR0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9jaGFubmVscyklNjAuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnNmd19jb250ZW50X2RldGVjdGVkJTIwKCU2MExpc3QlNUJib29sJTVEJTYwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMExpc3QlMjBpbmRpY2F0aW5nJTIwd2hldGhlciUyMHRoZSUyMGNvcnJlc3BvbmRpbmclMjBnZW5lcmF0ZWQlMjBpbWFnZSUyMGNvbnRhaW5zJTIwJTIybm90LXNhZmUtZm9yLXdvcmslMjIlMjAobnNmdyklMjBjb250ZW50JTIwb3IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNjBOb25lJTYwJTIwaWYlMjBzYWZldHklMjBjaGVja2luZyUyMGNvdWxkJTIwbm90JTIwYmUlMjBwZXJmb3JtZWQuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIy",highlighted:'<span class="hljs-comment"># Copied from diffusers.pipelines.stable_diffusion.pipeline_output.StableDiffusionPipelineOutput with Stable-&gt;Alt</span>\n<span class="hljs-keyword">class</span> <span class="hljs-title class_">AltDiffusionPipelineOutput</span>(<span class="hljs-title class_ inherited__">BaseOutput</span>):\n    <span class="hljs-string">&quot;&quot;&quot;\n    Output class for Alt Diffusion pipelines.\n\n    Args:\n        images (`List[PIL.Image.Image]` or `np.ndarray`)\n            List of denoised PIL images of length `batch_size` or NumPy array of shape `(batch_size, height, width,\n            num_channels)`.\n        nsfw_content_detected (`List[bool]`)\n            List indicating whether the corresponding generated image contains &quot;not-safe-for-work&quot; (nsfw) content or\n            `None` if safety checking could not be performed.\n    &quot;&quot;&quot;</span>',wrap:!1}}),$t=new w({props:{title:"How to write a good issue",local:"how-to-write-a-good-issue",headingTag:"h2"}}),Jt=new w({props:{title:"How to write a good PR",local:"how-to-write-a-good-pr",headingTag:"h2"}}),Ht=new w({props:{title:"How to open a PR",local:"how-to-open-a-pr",headingTag:"h2"}}),Pt=new b({props:{code:"JTI0JTIwZ2l0JTIwY2xvbmUlMjBnaXQlNDBnaXRodWIuY29tJTNBJTNDeW91ciUyMEdpdEh1YiUyMGhhbmRsZSUzRSUyRmRpZmZ1c2Vycy5naXQlMEElMjQlMjBjZCUyMGRpZmZ1c2VycyUwQSUyNCUyMGdpdCUyMHJlbW90ZSUyMGFkZCUyMHVwc3RyZWFtJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkaWZmdXNlcnMuZ2l0",highlighted:`$ git <span class="hljs-built_in">clone</span> git@github.com:&lt;your GitHub handle&gt;/diffusers.git
$ <span class="hljs-built_in">cd</span> diffusers
$ git remote add upstream https://github.com/huggingface/diffusers.git`,wrap:!1}}),Gt=new b({props:{code:"JTI0JTIwZ2l0JTIwY2hlY2tvdXQlMjAtYiUyMGEtZGVzY3JpcHRpdmUtbmFtZS1mb3ItbXktY2hhbmdlcw==",highlighted:"$ git checkout -b a-descriptive-name-for-my-changes",wrap:!1}}),Bt=new b({props:{code:"JTI0JTIwcGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QmRldiU1RCUyMg==",highlighted:'$ pip install -e <span class="hljs-string">&quot;.[dev]&quot;</span>',wrap:!1}}),Xt=new b({props:{code:"JTI0JTIwcHl0ZXN0JTIwdGVzdHMlMkYlM0NURVNUX1RPX1JVTiUzRS5weQ==",highlighted:"$ pytest tests/&lt;TEST_TO_RUN&gt;.py",wrap:!1}}),Dt=new b({props:{code:"JTI0JTIwcGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QnRlc3QlNUQlMjI=",highlighted:'$ pip install -e <span class="hljs-string">&quot;.[test]&quot;</span>',wrap:!1}}),Ft=new b({props:{code:"JTI0JTIwbWFrZSUyMHRlc3Q=",highlighted:'$ make <span class="hljs-built_in">test</span>',wrap:!1}}),zt=new b({props:{code:"JTI0JTIwbWFrZSUyMHN0eWxl",highlighted:"$ make style",wrap:!1}}),Qt=new b({props:{code:"JTI0JTIwbWFrZSUyMHF1YWxpdHk=",highlighted:"$ make quality",wrap:!1}}),Kt=new b({props:{code:"JTI0JTIwZ2l0JTIwYWRkJTIwbW9kaWZpZWRfZmlsZS5weSUwQSUyNCUyMGdpdCUyMGNvbW1pdCUyMC1tJTIwJTIyQSUyMGRlc2NyaXB0aXZlJTIwbWVzc2FnZSUyMGFib3V0JTIweW91ciUyMGNoYW5nZXMuJTIy",highlighted:`$ git add modified_file.py
$ git commit -m <span class="hljs-string">&quot;A descriptive message about your changes.&quot;</span>`,wrap:!1}}),ti=new b({props:{code:"JTI0JTIwZ2l0JTIwcHVsbCUyMHVwc3RyZWFtJTIwbWFpbg==",highlighted:"$ git pull upstream main",wrap:!1}}),si=new b({props:{code:"JTI0JTIwZ2l0JTIwcHVzaCUyMC11JTIwb3JpZ2luJTIwYS1kZXNjcmlwdGl2ZS1uYW1lLWZvci1teS1jaGFuZ2Vz",highlighted:"$ git push -u origin a-descriptive-name-for-my-changes",wrap:!1}}),li=new w({props:{title:"Tests",local:"tests",headingTag:"h3"}}),ai=new b({props:{code:"JTI0JTIwcHl0aG9uJTIwLW0lMjBweXRlc3QlMjAtbiUyMGF1dG8lMjAtLWRpc3QlM0Rsb2FkZmlsZSUyMC1zJTIwLXYlMjAuJTJGdGVzdHMlMkY=",highlighted:"$ python -m pytest -n auto --dist=loadfile -s -v ./tests/",wrap:!1}}),fi=new b({props:{code:"JTI0JTIwUlVOX1NMT1clM0R5ZXMlMjBweXRob24lMjAtbSUyMHB5dGVzdCUyMC1uJTIwYXV0byUyMC0tZGlzdCUzRGxvYWRmaWxlJTIwLXMlMjAtdiUyMC4lMkZ0ZXN0cyUyRg==",highlighted:'$ RUN_SLOW=<span class="hljs-built_in">yes</span> python -m pytest -n auto --dist=loadfile -s -v ./tests/',wrap:!1}}),hi=new b({props:{code:"JTI0JTIwcHl0aG9uJTIwLW0lMjB1bml0dGVzdCUyMGRpc2NvdmVyJTIwLXMlMjB0ZXN0cyUyMC10JTIwLiUyMC12JTBBJTI0JTIwcHl0aG9uJTIwLW0lMjB1bml0dGVzdCUyMGRpc2NvdmVyJTIwLXMlMjBleGFtcGxlcyUyMC10JTIwZXhhbXBsZXMlMjAtdg==",highlighted:`$ python -m unittest discover -s tests -t . -v
$ python -m unittest discover -s examples -t examples -v`,wrap:!1}}),mi=new w({props:{title:"Syncing forked main with upstream (HuggingFace) main",local:"syncing-forked-main-with-upstream-huggingface-main",headingTag:"h3"}}),yi=new b({props:{code:"JTI0JTIwZ2l0JTIwY2hlY2tvdXQlMjAtYiUyMHlvdXItYnJhbmNoLWZvci1zeW5jaW5nJTBBJTI0JTIwZ2l0JTIwcHVsbCUyMC0tc3F1YXNoJTIwLS1uby1jb21taXQlMjB1cHN0cmVhbSUyMG1haW4lMEElMjQlMjBnaXQlMjBjb21taXQlMjAtbSUyMCclM0N5b3VyJTIwbWVzc2FnZSUyMHdpdGhvdXQlMjBHaXRIdWIlMjByZWZlcmVuY2VzJTNFJyUwQSUyNCUyMGdpdCUyMHB1c2glMjAtLXNldC11cHN0cmVhbSUyMG9yaWdpbiUyMHlvdXItYnJhbmNoLWZvci1zeW5jaW5n",highlighted:`$ git checkout -b your-branch-for-syncing
$ git pull --squash --no-commit upstream main
$ git commit -m <span class="hljs-string">&#x27;&lt;your message without GitHub references&gt;&#x27;</span>
$ git push --set-upstream origin your-branch-for-syncing`,wrap:!1}}),wi=new w({props:{title:"Style guide",local:"style-guide",headingTag:"h3"}}),Ti=new Wa({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/conceptual/contribution.md"}}),{c(){c=o("meta"),T=l(),g=o("p"),v=l(),u(y.$$.fragment),M=l(),I=o("p"),I.textContent=ki,_i=l(),P=o("p"),P.innerHTML=Hn,Ui=l(),Z=o("p"),Z.innerHTML=_n,ji=l(),G=o("p"),G.textContent=Un,Li=l(),u(R.$$.fragment),Pi=l(),A=o("p"),A.textContent=jn,Zi=l(),W=o("p"),W.textContent=Ln,Gi=l(),B=o("ul"),B.innerHTML=Pn,Ri=l(),q=o("p"),q.innerHTML=Zn,Ai=l(),V=o("p"),V.innerHTML=Gn,Wi=l(),u(X.$$.fragment),Bi=l(),N=o("p"),N.innerHTML=Rn,qi=l(),D=o("ul"),D.innerHTML=An,Vi=l(),S=o("p"),S.textContent=Wn,Xi=l(),F=o("p"),F.innerHTML=Bn,Ni=l(),Y=o("p"),Y.innerHTML=qn,Di=l(),u(z.$$.fragment),Si=l(),E=o("p"),E.textContent=Vn,Fi=l(),Q=o("p"),Q.textContent=Xn,Yi=l(),O=o("p"),O.innerHTML=Nn,zi=l(),K=o("p"),K.innerHTML=Dn,Ei=l(),ee=o("ul"),ee.innerHTML=Sn,Qi=l(),te=o("p"),te.textContent=Fn,Oi=l(),u(ie.$$.fragment),Ki=l(),se=o("p"),se.textContent=Yn,es=l(),le=o("ul"),le.innerHTML=zn,ts=l(),ne=o("p"),ne.innerHTML=En,is=l(),oe=o("p"),oe.innerHTML=Qn,ss=l(),u(ae.$$.fragment),ls=l(),re=o("p"),re.textContent=On,ns=l(),ue=o("ol"),ue.innerHTML=Kn,os=l(),pe=o("ul"),pe.innerHTML=eo,as=l(),k=o("ol"),k.innerHTML=to,rs=l(),fe=o("p"),fe.innerHTML=io,us=l(),u(de.$$.fragment),ps=l(),he=o("p"),he.innerHTML=so,fs=l(),me=o("p"),me.innerHTML=lo,ds=l(),u(ce.$$.fragment),hs=l(),ge=o("p"),ge.textContent=no,ms=l(),ye=o("p"),ye.innerHTML=oo,cs=l(),u(we.$$.fragment),gs=l(),be=o("p"),be.textContent=ao,ys=l(),Te=o("ul"),Te.innerHTML=ro,ws=l(),ve=o("p"),ve.textContent=uo,bs=l(),Me=o("p"),Me.innerHTML=po,Ts=l(),u($e.$$.fragment),vs=l(),xe=o("p"),xe.textContent=fo,Ms=l(),Ie=o("ul"),Ie.innerHTML=ho,$s=l(),Je=o("p"),Je.innerHTML=mo,xs=l(),Ce=o("p"),Ce.textContent=co,Is=l(),ke=o("p"),ke.innerHTML=go,Js=l(),u(He.$$.fragment),Cs=l(),_e=o("p"),_e.innerHTML=yo,ks=l(),Ue=o("ul"),Ue.innerHTML=wo,Hs=l(),u(je.$$.fragment),_s=l(),Le=o("p"),Le.innerHTML=bo,Us=l(),Pe=o("p"),Pe.textContent=To,js=l(),Ze=o("ul"),Ze.innerHTML=vo,Ls=l(),Ge=o("p"),Ge.innerHTML=Mo,Ps=l(),Re=o("p"),Re.innerHTML=$o,Zs=l(),u(Ae.$$.fragment),Gs=l(),u(H.$$.fragment),Rs=l(),We=o("p"),We.innerHTML=xo,As=l(),Be=o("ol"),Be.innerHTML=Io,Ws=l(),u(qe.$$.fragment),Bs=l(),Ve=o("ol"),Ve.innerHTML=Jo,qs=l(),u(Xe.$$.fragment),Vs=l(),Ne=o("p"),Ne.textContent=Co,Xs=l(),u(De.$$.fragment),Ns=l(),Se=o("p"),Se.textContent=ko,Ds=l(),u(_.$$.fragment),Ss=l(),u(Fe.$$.fragment),Fs=l(),Ye=o("p"),Ye.innerHTML=Ho,Ys=l(),ze=o("p"),ze.textContent=_o,zs=l(),Ee=o("ul"),Ee.innerHTML=Uo,Es=l(),Qe=o("p"),Qe.innerHTML=jo,Qs=l(),Oe=o("p"),Oe.textContent=Lo,Os=l(),u(Ke.$$.fragment),Ks=l(),et=o("p"),et.textContent=Po,el=l(),u(tt.$$.fragment),tl=l(),it=o("p"),it.innerHTML=Zo,il=l(),st=o("p"),st.textContent=Go,sl=l(),lt=o("ul"),lt.innerHTML=Ro,ll=l(),nt=o("p"),nt.innerHTML=Ao,nl=l(),ot=o("ul"),ot.innerHTML=Wo,ol=l(),at=o("p"),at.innerHTML=Bo,al=l(),u(rt.$$.fragment),rl=l(),ut=o("p"),ut.innerHTML=qo,ul=l(),u(pt.$$.fragment),pl=l(),ft=o("p"),ft.textContent=Vo,fl=l(),dt=o("p"),dt.textContent=Xo,dl=l(),ht=o("p"),ht.textContent=No,hl=l(),mt=o("ul"),mt.innerHTML=Do,ml=l(),ct=o("p"),ct.innerHTML=So,cl=l(),gt=o("p"),gt.textContent=Fo,gl=l(),yt=o("p"),yt.textContent=Yo,yl=l(),u(wt.$$.fragment),wl=l(),bt=o("p"),bt.innerHTML=zo,bl=l(),Tt=o("p"),Tt.innerHTML=Eo,Tl=l(),u(vt.$$.fragment),vl=l(),Mt=o("p"),Mt.innerHTML=Qo,Ml=l(),u($t.$$.fragment),$l=l(),xt=o("p"),xt.innerHTML=Oo,xl=l(),It=o("ol"),It.innerHTML=Ko,Il=l(),u(Jt.$$.fragment),Jl=l(),Ct=o("ol"),Ct.innerHTML=ea,Cl=l(),kt=o("ul"),kt.innerHTML=ta,kl=l(),U=o("ol"),U.innerHTML=ia,Hl=l(),u(Ht.$$.fragment),_l=l(),_t=o("p"),_t.textContent=sa,Ul=l(),Ut=o("p"),Ut.innerHTML=la,jl=l(),jt=o("p"),jt.innerHTML=na,Ll=l(),J=o("ol"),xi=o("li"),xi.innerHTML=oa,$n=l(),Lt=o("li"),Ii=o("p"),Ii.textContent=aa,xn=l(),u(Pt.$$.fragment),In=l(),Zt=o("li"),Ji=o("p"),Ji.textContent=ra,Jn=l(),u(Gt.$$.fragment),Pl=l(),Rt=o("p"),Rt.innerHTML=ua,Zl=l(),At=o("ol"),Wt=o("li"),Ci=o("p"),Ci.textContent=pa,Cn=l(),u(Bt.$$.fragment),Gl=l(),qt=o("p"),qt.innerHTML=fa,Rl=l(),j=o("ol"),j.innerHTML=da,Al=l(),Vt=o("p"),Vt.textContent=ha,Wl=l(),u(Xt.$$.fragment),Bl=l(),Nt=o("p"),Nt.textContent=ma,ql=l(),u(Dt.$$.fragment),Vl=l(),St=o("p"),St.textContent=ca,Xl=l(),u(Ft.$$.fragment),Nl=l(),Yt=o("p"),Yt.innerHTML=ga,Dl=l(),u(zt.$$.fragment),Sl=l(),Et=o("p"),Et.innerHTML=ya,Fl=l(),u(Qt.$$.fragment),Yl=l(),Ot=o("p"),Ot.innerHTML=wa,zl=l(),u(Kt.$$.fragment),El=l(),ei=o("p"),ei.textContent=ba,Ql=l(),u(ti.$$.fragment),Ol=l(),ii=o("p"),ii.textContent=Ta,Kl=l(),u(si.$$.fragment),en=l(),L=o("ol"),L.innerHTML=va,tn=l(),u(li.$$.fragment),sn=l(),ni=o("p"),ni.innerHTML=Ma,ln=l(),oi=o("p"),oi.innerHTML=$a,nn=l(),u(ai.$$.fragment),on=l(),ri=o("p"),ri.innerHTML=xa,an=l(),ui=o("p"),ui.textContent=Ia,rn=l(),pi=o("p"),pi.innerHTML=Ja,un=l(),u(fi.$$.fragment),pn=l(),di=o("p"),di.innerHTML=Ca,fn=l(),u(hi.$$.fragment),dn=l(),u(mi.$$.fragment),hn=l(),ci=o("p"),ci.textContent=ka,mn=l(),gi=o("ol"),gi.innerHTML=Ha,cn=l(),u(yi.$$.fragment),gn=l(),u(wi.$$.fragment),yn=l(),bi=o("p"),bi.innerHTML=_a,wn=l(),u(Ti.$$.fragment),bn=l(),Hi=o("p"),this.h()},l(e){const t=Ra("svelte-u9bgzb",document.head);c=a(t,"META",{name:!0,content:!0}),t.forEach(i),T=n(e),g=a(e,"P",{}),Mi(g).forEach(i),v=n(e),p(y.$$.fragment,e),M=n(e),I=a(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-5law2j"&&(I.textContent=ki),_i=n(e),P=a(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-rf5fv0"&&(P.innerHTML=Hn),Ui=n(e),Z=a(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-7yk1qu"&&(Z.innerHTML=_n),ji=n(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-19e4jq9"&&(G.textContent=Un),Li=n(e),p(R.$$.fragment,e),Pi=n(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-qchdhx"&&(A.textContent=jn),Zi=n(e),W=a(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-vste1h"&&(W.textContent=Ln),Gi=n(e),B=a(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-1kftoyd"&&(B.innerHTML=Pn),Ri=n(e),q=a(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1a17ouk"&&(q.innerHTML=Zn),Ai=n(e),V=a(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1carl1x"&&(V.innerHTML=Gn),Wi=n(e),p(X.$$.fragment,e),Bi=n(e),N=a(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-eooydc"&&(N.innerHTML=Rn),qi=n(e),D=a(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-1pzwmv0"&&(D.innerHTML=An),Vi=n(e),S=a(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1gi90ut"&&(S.textContent=Wn),Xi=n(e),F=a(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1wkkt7q"&&(F.innerHTML=Bn),Ni=n(e),Y=a(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-14aelba"&&(Y.innerHTML=qn),Di=n(e),p(z.$$.fragment,e),Si=n(e),E=a(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1xkk71m"&&(E.textContent=Vn),Fi=n(e),Q=a(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1kqqlyc"&&(Q.textContent=Xn),Yi=n(e),O=a(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-180qij7"&&(O.innerHTML=Nn),zi=n(e),K=a(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1fjofc5"&&(K.innerHTML=Dn),Ei=n(e),ee=a(e,"UL",{"data-svelte-h":!0}),r(ee)!=="svelte-pzymlv"&&(ee.innerHTML=Sn),Qi=n(e),te=a(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1gfbuxb"&&(te.textContent=Fn),Oi=n(e),p(ie.$$.fragment,e),Ki=n(e),se=a(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1ipsy1e"&&(se.textContent=Yn),es=n(e),le=a(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-1mrun3g"&&(le.innerHTML=zn),ts=n(e),ne=a(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-b221ai"&&(ne.innerHTML=En),is=n(e),oe=a(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1vpz9iu"&&(oe.innerHTML=Qn),ss=n(e),p(ae.$$.fragment,e),ls=n(e),re=a(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1s92zhu"&&(re.textContent=On),ns=n(e),ue=a(e,"OL",{"data-svelte-h":!0}),r(ue)!=="svelte-1meaa0h"&&(ue.innerHTML=Kn),os=n(e),pe=a(e,"UL",{"data-svelte-h":!0}),r(pe)!=="svelte-1m6et35"&&(pe.innerHTML=eo),as=n(e),k=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(k)!=="svelte-1353nnk"&&(k.innerHTML=to),rs=n(e),fe=a(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1fbsnox"&&(fe.innerHTML=io),us=n(e),p(de.$$.fragment,e),ps=n(e),he=a(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-14r8j00"&&(he.innerHTML=so),fs=n(e),me=a(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-19nmi90"&&(me.innerHTML=lo),ds=n(e),p(ce.$$.fragment,e),hs=n(e),ge=a(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-w10b99"&&(ge.textContent=no),ms=n(e),ye=a(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-117d5cx"&&(ye.innerHTML=oo),cs=n(e),p(we.$$.fragment,e),gs=n(e),be=a(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-10axoet"&&(be.textContent=ao),ys=n(e),Te=a(e,"UL",{"data-svelte-h":!0}),r(Te)!=="svelte-djw2fh"&&(Te.innerHTML=ro),ws=n(e),ve=a(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1g4ps0b"&&(ve.textContent=uo),bs=n(e),Me=a(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-sc0vav"&&(Me.innerHTML=po),Ts=n(e),p($e.$$.fragment,e),vs=n(e),xe=a(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-15u5nyq"&&(xe.textContent=fo),Ms=n(e),Ie=a(e,"UL",{"data-svelte-h":!0}),r(Ie)!=="svelte-1utx7xe"&&(Ie.innerHTML=ho),$s=n(e),Je=a(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1h98g7p"&&(Je.innerHTML=mo),xs=n(e),Ce=a(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1n38hfq"&&(Ce.textContent=co),Is=n(e),ke=a(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1aq6j4g"&&(ke.innerHTML=go),Js=n(e),p(He.$$.fragment,e),Cs=n(e),_e=a(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-17d5j91"&&(_e.innerHTML=yo),ks=n(e),Ue=a(e,"UL",{"data-svelte-h":!0}),r(Ue)!=="svelte-csw3jn"&&(Ue.innerHTML=wo),Hs=n(e),p(je.$$.fragment,e),_s=n(e),Le=a(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-p135hl"&&(Le.innerHTML=bo),Us=n(e),Pe=a(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-dmhl9b"&&(Pe.textContent=To),js=n(e),Ze=a(e,"UL",{"data-svelte-h":!0}),r(Ze)!=="svelte-1vfa69p"&&(Ze.innerHTML=vo),Ls=n(e),Ge=a(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1fszx"&&(Ge.innerHTML=Mo),Ps=n(e),Re=a(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-6of141"&&(Re.innerHTML=$o),Zs=n(e),p(Ae.$$.fragment,e),Gs=n(e),p(H.$$.fragment,e),Rs=n(e),We=a(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-zrdocq"&&(We.innerHTML=xo),As=n(e),Be=a(e,"OL",{"data-svelte-h":!0}),r(Be)!=="svelte-gz1uwp"&&(Be.innerHTML=Io),Ws=n(e),p(qe.$$.fragment,e),Bs=n(e),Ve=a(e,"OL",{"data-svelte-h":!0}),r(Ve)!=="svelte-16wphgq"&&(Ve.innerHTML=Jo),qs=n(e),p(Xe.$$.fragment,e),Vs=n(e),Ne=a(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-kiwzsg"&&(Ne.textContent=Co),Xs=n(e),p(De.$$.fragment,e),Ns=n(e),Se=a(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-17fzb10"&&(Se.textContent=ko),Ds=n(e),p(_.$$.fragment,e),Ss=n(e),p(Fe.$$.fragment,e),Fs=n(e),Ye=a(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1695xih"&&(Ye.innerHTML=Ho),Ys=n(e),ze=a(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-dlx7ai"&&(ze.textContent=_o),zs=n(e),Ee=a(e,"UL",{"data-svelte-h":!0}),r(Ee)!=="svelte-15twepo"&&(Ee.innerHTML=Uo),Es=n(e),Qe=a(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1ao1iff"&&(Qe.innerHTML=jo),Qs=n(e),Oe=a(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-vgkeor"&&(Oe.textContent=Lo),Os=n(e),p(Ke.$$.fragment,e),Ks=n(e),et=a(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-idor3x"&&(et.textContent=Po),el=n(e),p(tt.$$.fragment,e),tl=n(e),it=a(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1951zcj"&&(it.innerHTML=Zo),il=n(e),st=a(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1m6im41"&&(st.textContent=Go),sl=n(e),lt=a(e,"UL",{"data-svelte-h":!0}),r(lt)!=="svelte-1xy9lh5"&&(lt.innerHTML=Ro),ll=n(e),nt=a(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-68kw4k"&&(nt.innerHTML=Ao),nl=n(e),ot=a(e,"UL",{"data-svelte-h":!0}),r(ot)!=="svelte-df85hq"&&(ot.innerHTML=Wo),ol=n(e),at=a(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-paax9d"&&(at.innerHTML=Bo),al=n(e),p(rt.$$.fragment,e),rl=n(e),ut=a(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-hbgtxz"&&(ut.innerHTML=qo),ul=n(e),p(pt.$$.fragment,e),pl=n(e),ft=a(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-if0791"&&(ft.textContent=Vo),fl=n(e),dt=a(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-9zs46y"&&(dt.textContent=Xo),dl=n(e),ht=a(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-ktahrm"&&(ht.textContent=No),hl=n(e),mt=a(e,"UL",{"data-svelte-h":!0}),r(mt)!=="svelte-1frr5y8"&&(mt.innerHTML=Do),ml=n(e),ct=a(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1nju92b"&&(ct.innerHTML=So),cl=n(e),gt=a(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1575xev"&&(gt.textContent=Fo),gl=n(e),yt=a(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-15y7ezq"&&(yt.textContent=Yo),yl=n(e),p(wt.$$.fragment,e),wl=n(e),bt=a(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-j9yg25"&&(bt.innerHTML=zo),bl=n(e),Tt=a(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-1jeilvb"&&(Tt.innerHTML=Eo),Tl=n(e),p(vt.$$.fragment,e),vl=n(e),Mt=a(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-bmf593"&&(Mt.innerHTML=Qo),Ml=n(e),p($t.$$.fragment,e),$l=n(e),xt=a(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-160saia"&&(xt.innerHTML=Oo),xl=n(e),It=a(e,"OL",{"data-svelte-h":!0}),r(It)!=="svelte-147evhz"&&(It.innerHTML=Ko),Il=n(e),p(Jt.$$.fragment,e),Jl=n(e),Ct=a(e,"OL",{"data-svelte-h":!0}),r(Ct)!=="svelte-1dyfapb"&&(Ct.innerHTML=ea),Cl=n(e),kt=a(e,"UL",{"data-svelte-h":!0}),r(kt)!=="svelte-bfdf0l"&&(kt.innerHTML=ta),kl=n(e),U=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(U)!=="svelte-9teity"&&(U.innerHTML=ia),Hl=n(e),p(Ht.$$.fragment,e),_l=n(e),_t=a(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-18wldn4"&&(_t.textContent=sa),Ul=n(e),Ut=a(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-ha1e2a"&&(Ut.innerHTML=la),jl=n(e),jt=a(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-hj53bb"&&(jt.innerHTML=na),Ll=n(e),J=a(e,"OL",{});var C=Mi(J);xi=a(C,"LI",{"data-svelte-h":!0}),r(xi)!=="svelte-1051ijo"&&(xi.innerHTML=oa),$n=n(C),Lt=a(C,"LI",{});var vi=Mi(Lt);Ii=a(vi,"P",{"data-svelte-h":!0}),r(Ii)!=="svelte-clge5v"&&(Ii.textContent=aa),xn=n(vi),p(Pt.$$.fragment,vi),vi.forEach(i),In=n(C),Zt=a(C,"LI",{});var vn=Mi(Zt);Ji=a(vn,"P",{"data-svelte-h":!0}),r(Ji)!=="svelte-imt6wq"&&(Ji.textContent=ra),Jn=n(vn),p(Gt.$$.fragment,vn),vn.forEach(i),C.forEach(i),Pl=n(e),Rt=a(e,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-12bf6z0"&&(Rt.innerHTML=ua),Zl=n(e),At=a(e,"OL",{start:!0});var Ua=Mi(At);Wt=a(Ua,"LI",{});var Mn=Mi(Wt);Ci=a(Mn,"P",{"data-svelte-h":!0}),r(Ci)!=="svelte-1sxg1ux"&&(Ci.textContent=pa),Cn=n(Mn),p(Bt.$$.fragment,Mn),Mn.forEach(i),Ua.forEach(i),Gl=n(e),qt=a(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-baqsq9"&&(qt.innerHTML=fa),Rl=n(e),j=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(j)!=="svelte-1ug4u82"&&(j.innerHTML=da),Al=n(e),Vt=a(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-6e1eyz"&&(Vt.textContent=ha),Wl=n(e),p(Xt.$$.fragment,e),Bl=n(e),Nt=a(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-zb2pxr"&&(Nt.textContent=ma),ql=n(e),p(Dt.$$.fragment,e),Vl=n(e),St=a(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-1xnez06"&&(St.textContent=ca),Xl=n(e),p(Ft.$$.fragment,e),Nl=n(e),Yt=a(e,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-1ee1sp3"&&(Yt.innerHTML=ga),Dl=n(e),p(zt.$$.fragment,e),Sl=n(e),Et=a(e,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-1fsb6ew"&&(Et.innerHTML=ya),Fl=n(e),p(Qt.$$.fragment,e),Yl=n(e),Ot=a(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-1h0d1ob"&&(Ot.innerHTML=wa),zl=n(e),p(Kt.$$.fragment,e),El=n(e),ei=a(e,"P",{"data-svelte-h":!0}),r(ei)!=="svelte-b5s72j"&&(ei.textContent=ba),Ql=n(e),p(ti.$$.fragment,e),Ol=n(e),ii=a(e,"P",{"data-svelte-h":!0}),r(ii)!=="svelte-1adm7yl"&&(ii.textContent=Ta),Kl=n(e),p(si.$$.fragment,e),en=n(e),L=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(L)!=="svelte-vcjscl"&&(L.innerHTML=va),tn=n(e),p(li.$$.fragment,e),sn=n(e),ni=a(e,"P",{"data-svelte-h":!0}),r(ni)!=="svelte-109saxj"&&(ni.innerHTML=Ma),ln=n(e),oi=a(e,"P",{"data-svelte-h":!0}),r(oi)!=="svelte-1w3mw7o"&&(oi.innerHTML=$a),nn=n(e),p(ai.$$.fragment,e),on=n(e),ri=a(e,"P",{"data-svelte-h":!0}),r(ri)!=="svelte-1df4miy"&&(ri.innerHTML=xa),an=n(e),ui=a(e,"P",{"data-svelte-h":!0}),r(ui)!=="svelte-12n8jzj"&&(ui.textContent=Ia),rn=n(e),pi=a(e,"P",{"data-svelte-h":!0}),r(pi)!=="svelte-kna9l3"&&(pi.innerHTML=Ja),un=n(e),p(fi.$$.fragment,e),pn=n(e),di=a(e,"P",{"data-svelte-h":!0}),r(di)!=="svelte-6tihfz"&&(di.innerHTML=Ca),fn=n(e),p(hi.$$.fragment,e),dn=n(e),p(mi.$$.fragment,e),hn=n(e),ci=a(e,"P",{"data-svelte-h":!0}),r(ci)!=="svelte-ciarbw"&&(ci.textContent=ka),mn=n(e),gi=a(e,"OL",{"data-svelte-h":!0}),r(gi)!=="svelte-ff502d"&&(gi.innerHTML=Ha),cn=n(e),p(yi.$$.fragment,e),gn=n(e),p(wi.$$.fragment,e),yn=n(e),bi=a(e,"P",{"data-svelte-h":!0}),r(bi)!=="svelte-1w7izlk"&&(bi.innerHTML=_a),wn=n(e),p(Ti.$$.fragment,e),bn=n(e),Hi=a(e,"P",{}),Mi(Hi).forEach(i),this.h()},h(){$i(c,"name","hf:doc:metadata"),$i(c,"content",Sa),$i(k,"start","2"),$i(U,"start","10"),$i(At,"start","4"),$i(j,"start","5"),$i(L,"start","6")},m(e,t){$(document.head,c),s(e,T,t),s(e,g,t),s(e,v,t),f(y,e,t),s(e,M,t),s(e,I,t),s(e,_i,t),s(e,P,t),s(e,Ui,t),s(e,Z,t),s(e,ji,t),s(e,G,t),s(e,Li,t),f(R,e,t),s(e,Pi,t),s(e,A,t),s(e,Zi,t),s(e,W,t),s(e,Gi,t),s(e,B,t),s(e,Ri,t),s(e,q,t),s(e,Ai,t),s(e,V,t),s(e,Wi,t),f(X,e,t),s(e,Bi,t),s(e,N,t),s(e,qi,t),s(e,D,t),s(e,Vi,t),s(e,S,t),s(e,Xi,t),s(e,F,t),s(e,Ni,t),s(e,Y,t),s(e,Di,t),f(z,e,t),s(e,Si,t),s(e,E,t),s(e,Fi,t),s(e,Q,t),s(e,Yi,t),s(e,O,t),s(e,zi,t),s(e,K,t),s(e,Ei,t),s(e,ee,t),s(e,Qi,t),s(e,te,t),s(e,Oi,t),f(ie,e,t),s(e,Ki,t),s(e,se,t),s(e,es,t),s(e,le,t),s(e,ts,t),s(e,ne,t),s(e,is,t),s(e,oe,t),s(e,ss,t),f(ae,e,t),s(e,ls,t),s(e,re,t),s(e,ns,t),s(e,ue,t),s(e,os,t),s(e,pe,t),s(e,as,t),s(e,k,t),s(e,rs,t),s(e,fe,t),s(e,us,t),f(de,e,t),s(e,ps,t),s(e,he,t),s(e,fs,t),s(e,me,t),s(e,ds,t),f(ce,e,t),s(e,hs,t),s(e,ge,t),s(e,ms,t),s(e,ye,t),s(e,cs,t),f(we,e,t),s(e,gs,t),s(e,be,t),s(e,ys,t),s(e,Te,t),s(e,ws,t),s(e,ve,t),s(e,bs,t),s(e,Me,t),s(e,Ts,t),f($e,e,t),s(e,vs,t),s(e,xe,t),s(e,Ms,t),s(e,Ie,t),s(e,$s,t),s(e,Je,t),s(e,xs,t),s(e,Ce,t),s(e,Is,t),s(e,ke,t),s(e,Js,t),f(He,e,t),s(e,Cs,t),s(e,_e,t),s(e,ks,t),s(e,Ue,t),s(e,Hs,t),f(je,e,t),s(e,_s,t),s(e,Le,t),s(e,Us,t),s(e,Pe,t),s(e,js,t),s(e,Ze,t),s(e,Ls,t),s(e,Ge,t),s(e,Ps,t),s(e,Re,t),s(e,Zs,t),f(Ae,e,t),s(e,Gs,t),f(H,e,t),s(e,Rs,t),s(e,We,t),s(e,As,t),s(e,Be,t),s(e,Ws,t),f(qe,e,t),s(e,Bs,t),s(e,Ve,t),s(e,qs,t),f(Xe,e,t),s(e,Vs,t),s(e,Ne,t),s(e,Xs,t),f(De,e,t),s(e,Ns,t),s(e,Se,t),s(e,Ds,t),f(_,e,t),s(e,Ss,t),f(Fe,e,t),s(e,Fs,t),s(e,Ye,t),s(e,Ys,t),s(e,ze,t),s(e,zs,t),s(e,Ee,t),s(e,Es,t),s(e,Qe,t),s(e,Qs,t),s(e,Oe,t),s(e,Os,t),f(Ke,e,t),s(e,Ks,t),s(e,et,t),s(e,el,t),f(tt,e,t),s(e,tl,t),s(e,it,t),s(e,il,t),s(e,st,t),s(e,sl,t),s(e,lt,t),s(e,ll,t),s(e,nt,t),s(e,nl,t),s(e,ot,t),s(e,ol,t),s(e,at,t),s(e,al,t),f(rt,e,t),s(e,rl,t),s(e,ut,t),s(e,ul,t),f(pt,e,t),s(e,pl,t),s(e,ft,t),s(e,fl,t),s(e,dt,t),s(e,dl,t),s(e,ht,t),s(e,hl,t),s(e,mt,t),s(e,ml,t),s(e,ct,t),s(e,cl,t),s(e,gt,t),s(e,gl,t),s(e,yt,t),s(e,yl,t),f(wt,e,t),s(e,wl,t),s(e,bt,t),s(e,bl,t),s(e,Tt,t),s(e,Tl,t),f(vt,e,t),s(e,vl,t),s(e,Mt,t),s(e,Ml,t),f($t,e,t),s(e,$l,t),s(e,xt,t),s(e,xl,t),s(e,It,t),s(e,Il,t),f(Jt,e,t),s(e,Jl,t),s(e,Ct,t),s(e,Cl,t),s(e,kt,t),s(e,kl,t),s(e,U,t),s(e,Hl,t),f(Ht,e,t),s(e,_l,t),s(e,_t,t),s(e,Ul,t),s(e,Ut,t),s(e,jl,t),s(e,jt,t),s(e,Ll,t),s(e,J,t),$(J,xi),$(J,$n),$(J,Lt),$(Lt,Ii),$(Lt,xn),f(Pt,Lt,null),$(J,In),$(J,Zt),$(Zt,Ji),$(Zt,Jn),f(Gt,Zt,null),s(e,Pl,t),s(e,Rt,t),s(e,Zl,t),s(e,At,t),$(At,Wt),$(Wt,Ci),$(Wt,Cn),f(Bt,Wt,null),s(e,Gl,t),s(e,qt,t),s(e,Rl,t),s(e,j,t),s(e,Al,t),s(e,Vt,t),s(e,Wl,t),f(Xt,e,t),s(e,Bl,t),s(e,Nt,t),s(e,ql,t),f(Dt,e,t),s(e,Vl,t),s(e,St,t),s(e,Xl,t),f(Ft,e,t),s(e,Nl,t),s(e,Yt,t),s(e,Dl,t),f(zt,e,t),s(e,Sl,t),s(e,Et,t),s(e,Fl,t),f(Qt,e,t),s(e,Yl,t),s(e,Ot,t),s(e,zl,t),f(Kt,e,t),s(e,El,t),s(e,ei,t),s(e,Ql,t),f(ti,e,t),s(e,Ol,t),s(e,ii,t),s(e,Kl,t),f(si,e,t),s(e,en,t),s(e,L,t),s(e,tn,t),f(li,e,t),s(e,sn,t),s(e,ni,t),s(e,ln,t),s(e,oi,t),s(e,nn,t),f(ai,e,t),s(e,on,t),s(e,ri,t),s(e,an,t),s(e,ui,t),s(e,rn,t),s(e,pi,t),s(e,un,t),f(fi,e,t),s(e,pn,t),s(e,di,t),s(e,fn,t),f(hi,e,t),s(e,dn,t),f(mi,e,t),s(e,hn,t),s(e,ci,t),s(e,mn,t),s(e,gi,t),s(e,cn,t),f(yi,e,t),s(e,gn,t),f(wi,e,t),s(e,yn,t),s(e,bi,t),s(e,wn,t),f(Ti,e,t),s(e,bn,t),s(e,Hi,t),Tn=!0},p(e,[t]){const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),H.$set(C);const vi={};t&2&&(vi.$$scope={dirty:t,ctx:e}),_.$set(vi)},i(e){Tn||(d(y.$$.fragment,e),d(R.$$.fragment,e),d(X.$$.fragment,e),d(z.$$.fragment,e),d(ie.$$.fragment,e),d(ae.$$.fragment,e),d(de.$$.fragment,e),d(ce.$$.fragment,e),d(we.$$.fragment,e),d($e.$$.fragment,e),d(He.$$.fragment,e),d(je.$$.fragment,e),d(Ae.$$.fragment,e),d(H.$$.fragment,e),d(qe.$$.fragment,e),d(Xe.$$.fragment,e),d(De.$$.fragment,e),d(_.$$.fragment,e),d(Fe.$$.fragment,e),d(Ke.$$.fragment,e),d(tt.$$.fragment,e),d(rt.$$.fragment,e),d(pt.$$.fragment,e),d(wt.$$.fragment,e),d(vt.$$.fragment,e),d($t.$$.fragment,e),d(Jt.$$.fragment,e),d(Ht.$$.fragment,e),d(Pt.$$.fragment,e),d(Gt.$$.fragment,e),d(Bt.$$.fragment,e),d(Xt.$$.fragment,e),d(Dt.$$.fragment,e),d(Ft.$$.fragment,e),d(zt.$$.fragment,e),d(Qt.$$.fragment,e),d(Kt.$$.fragment,e),d(ti.$$.fragment,e),d(si.$$.fragment,e),d(li.$$.fragment,e),d(ai.$$.fragment,e),d(fi.$$.fragment,e),d(hi.$$.fragment,e),d(mi.$$.fragment,e),d(yi.$$.fragment,e),d(wi.$$.fragment,e),d(Ti.$$.fragment,e),Tn=!0)},o(e){h(y.$$.fragment,e),h(R.$$.fragment,e),h(X.$$.fragment,e),h(z.$$.fragment,e),h(ie.$$.fragment,e),h(ae.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(we.$$.fragment,e),h($e.$$.fragment,e),h(He.$$.fragment,e),h(je.$$.fragment,e),h(Ae.$$.fragment,e),h(H.$$.fragment,e),h(qe.$$.fragment,e),h(Xe.$$.fragment,e),h(De.$$.fragment,e),h(_.$$.fragment,e),h(Fe.$$.fragment,e),h(Ke.$$.fragment,e),h(tt.$$.fragment,e),h(rt.$$.fragment,e),h(pt.$$.fragment,e),h(wt.$$.fragment,e),h(vt.$$.fragment,e),h($t.$$.fragment,e),h(Jt.$$.fragment,e),h(Ht.$$.fragment,e),h(Pt.$$.fragment,e),h(Gt.$$.fragment,e),h(Bt.$$.fragment,e),h(Xt.$$.fragment,e),h(Dt.$$.fragment,e),h(Ft.$$.fragment,e),h(zt.$$.fragment,e),h(Qt.$$.fragment,e),h(Kt.$$.fragment,e),h(ti.$$.fragment,e),h(si.$$.fragment,e),h(li.$$.fragment,e),h(ai.$$.fragment,e),h(fi.$$.fragment,e),h(hi.$$.fragment,e),h(mi.$$.fragment,e),h(yi.$$.fragment,e),h(wi.$$.fragment,e),h(Ti.$$.fragment,e),Tn=!1},d(e){e&&(i(T),i(g),i(v),i(M),i(I),i(_i),i(P),i(Ui),i(Z),i(ji),i(G),i(Li),i(Pi),i(A),i(Zi),i(W),i(Gi),i(B),i(Ri),i(q),i(Ai),i(V),i(Wi),i(Bi),i(N),i(qi),i(D),i(Vi),i(S),i(Xi),i(F),i(Ni),i(Y),i(Di),i(Si),i(E),i(Fi),i(Q),i(Yi),i(O),i(zi),i(K),i(Ei),i(ee),i(Qi),i(te),i(Oi),i(Ki),i(se),i(es),i(le),i(ts),i(ne),i(is),i(oe),i(ss),i(ls),i(re),i(ns),i(ue),i(os),i(pe),i(as),i(k),i(rs),i(fe),i(us),i(ps),i(he),i(fs),i(me),i(ds),i(hs),i(ge),i(ms),i(ye),i(cs),i(gs),i(be),i(ys),i(Te),i(ws),i(ve),i(bs),i(Me),i(Ts),i(vs),i(xe),i(Ms),i(Ie),i($s),i(Je),i(xs),i(Ce),i(Is),i(ke),i(Js),i(Cs),i(_e),i(ks),i(Ue),i(Hs),i(_s),i(Le),i(Us),i(Pe),i(js),i(Ze),i(Ls),i(Ge),i(Ps),i(Re),i(Zs),i(Gs),i(Rs),i(We),i(As),i(Be),i(Ws),i(Bs),i(Ve),i(qs),i(Vs),i(Ne),i(Xs),i(Ns),i(Se),i(Ds),i(Ss),i(Fs),i(Ye),i(Ys),i(ze),i(zs),i(Ee),i(Es),i(Qe),i(Qs),i(Oe),i(Os),i(Ks),i(et),i(el),i(tl),i(it),i(il),i(st),i(sl),i(lt),i(ll),i(nt),i(nl),i(ot),i(ol),i(at),i(al),i(rl),i(ut),i(ul),i(pl),i(ft),i(fl),i(dt),i(dl),i(ht),i(hl),i(mt),i(ml),i(ct),i(cl),i(gt),i(gl),i(yt),i(yl),i(wl),i(bt),i(bl),i(Tt),i(Tl),i(vl),i(Mt),i(Ml),i($l),i(xt),i(xl),i(It),i(Il),i(Jl),i(Ct),i(Cl),i(kt),i(kl),i(U),i(Hl),i(_l),i(_t),i(Ul),i(Ut),i(jl),i(jt),i(Ll),i(J),i(Pl),i(Rt),i(Zl),i(At),i(Gl),i(qt),i(Rl),i(j),i(Al),i(Vt),i(Wl),i(Bl),i(Nt),i(ql),i(Vl),i(St),i(Xl),i(Nl),i(Yt),i(Dl),i(Sl),i(Et),i(Fl),i(Yl),i(Ot),i(zl),i(El),i(ei),i(Ql),i(Ol),i(ii),i(Kl),i(en),i(L),i(tn),i(sn),i(ni),i(ln),i(oi),i(nn),i(on),i(ri),i(an),i(ui),i(rn),i(pi),i(un),i(pn),i(di),i(fn),i(dn),i(hn),i(ci),i(mn),i(gi),i(cn),i(gn),i(yn),i(bi),i(wn),i(bn),i(Hi)),i(c),m(y,e),m(R,e),m(X,e),m(z,e),m(ie,e),m(ae,e),m(de,e),m(ce,e),m(we,e),m($e,e),m(He,e),m(je,e),m(Ae,e),m(H,e),m(qe,e),m(Xe,e),m(De,e),m(_,e),m(Fe,e),m(Ke,e),m(tt,e),m(rt,e),m(pt,e),m(wt,e),m(vt,e),m($t,e),m(Jt,e),m(Ht,e),m(Pt),m(Gt),m(Bt),m(Xt,e),m(Dt,e),m(Ft,e),m(zt,e),m(Qt,e),m(Kt,e),m(ti,e),m(si,e),m(li,e),m(ai,e),m(fi,e),m(hi,e),m(mi,e),m(yi,e),m(wi,e),m(Ti,e)}}}const Sa='{"title":"How to contribute to Diffusers 🧨","local":"how-to-contribute-to-diffusers-","sections":[{"title":"Overview","local":"overview","sections":[{"title":"1. Asking and answering questions on the Diffusers discussion forum or on the Diffusers Discord","local":"1-asking-and-answering-questions-on-the-diffusers-discussion-forum-or-on-the-diffusers-discord","sections":[],"depth":3},{"title":"2. Opening new issues on the GitHub issues tab","local":"2-opening-new-issues-on-the-github-issues-tab","sections":[{"title":"2.1. Reproducible, minimal bug reports","local":"21-reproducible-minimal-bug-reports","sections":[],"depth":4},{"title":"2.2. Feature requests","local":"22-feature-requests","sections":[],"depth":4},{"title":"2.3 Feedback","local":"23-feedback","sections":[],"depth":4},{"title":"2.4 Technical questions","local":"24-technical-questions","sections":[],"depth":4},{"title":"2.5 Proposal to add a new model, scheduler, or pipeline","local":"25-proposal-to-add-a-new-model-scheduler-or-pipeline","sections":[],"depth":4}],"depth":3},{"title":"3. Answering issues on the GitHub issues tab","local":"3-answering-issues-on-the-github-issues-tab","sections":[],"depth":3},{"title":"4. Fixing a “Good first issue”","local":"4-fixing-a-good-first-issue","sections":[],"depth":3},{"title":"5. Contribute to the documentation","local":"5-contribute-to-the-documentation","sections":[],"depth":3},{"title":"6. Contribute a community pipeline","local":"6-contribute-a-community-pipeline","sections":[],"depth":3},{"title":"7. Contribute to training examples","local":"7-contribute-to-training-examples","sections":[],"depth":3},{"title":"8. Fixing a “Good second issue”","local":"8-fixing-a-good-second-issue","sections":[],"depth":3},{"title":"9. Adding pipelines, models, schedulers","local":"9-adding-pipelines-models-schedulers","sections":[{"title":"Copied from mechanism","local":"copied-from-mechanism","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"How to write a good issue","local":"how-to-write-a-good-issue","sections":[],"depth":2},{"title":"How to write a good PR","local":"how-to-write-a-good-pr","sections":[],"depth":2},{"title":"How to open a PR","local":"how-to-open-a-pr","sections":[{"title":"Tests","local":"tests","sections":[],"depth":3},{"title":"Syncing forked main with upstream (HuggingFace) main","local":"syncing-forked-main-with-upstream-huggingface-main","sections":[],"depth":3},{"title":"Style guide","local":"style-guide","sections":[],"depth":3}],"depth":2}],"depth":1}';function Fa(x){return Pa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class er extends Za{constructor(c){super(),Ga(this,c,Fa,Da,La,{})}}export{er as component};
