import{s as Cs,n as ws,o as gs}from"../chunks/scheduler.b108d059.js";import{S as Js,i as bs,g as a,s,r,A as vs,h as o,f as l,c as i,j as dn,u as p,x as u,k as fs,y as Mn,a as n,v as c,d,t as M,w as h}from"../chunks/index.008de539.js";import{C as m}from"../chunks/CodeBlock.7b00c886.js";import{H as y,E as js}from"../chunks/getInferenceSnippets.c71cadbd.js";function Is(hn){let T,ht,dt,mt,f,yt,C,mn='Deploying Text Embeddings Inference (TEI) on Google Cloud Platform (GCP) allows to benefit from the underlying <a href="https://kubernetes.io/" rel="nofollow">Kubernetes</a> technology which ensures that TEI can scale automatically up or down based on demand.',Tt,w,yn="On Google Cloud, there are 3 main options for deploying TEI (or any other Docker container):",Ut,g,Tn="<li>Cloud Run</li> <li>Vertex AI endpoints</li> <li>GKE (Google Kubernetes Engine).</li>",ft,J,Un="This guide explains how to deploy TEI on Cloud Run, a fully managed service by Google. Cloud Run is a so-called serverless offering. This means that the server infrastructure is handled by Google, you only need to provide a Docker container. The benefit of this is that you only pay for compute when there is demand for your application. Cloud Run will automatically spin up servers when there’s demand, and scale down to zero when there is no demand.",Ct,b,fn="We will showcase how to deploy any text embedding model with or without a GPU.",wt,v,Cn=`<p>[!NOTE]
At the time of writing, GPU support on Cloud Run is generally available in 4 regions. If you’re interested in using it, <a href="https://cloud.google.com/run/quotas#increase" rel="nofollow">request a quota increase</a> for <code>Total Nvidia L4 GPU allocation, per project per region</code>. So far, NVIDIA L4 GPUs (24GiB VRAM) are the only available GPUs on Cloud Run; enabling automatic scaling up to 7 instances by default (more available via quota), as well as scaling down to zero instances when there are no requests.</p>`,gt,j,Jt,I,wn='This guide already assumes you have set up a Google Cloud project and have enabled billing. This can be done at <a href="https://console.cloud.google.com/" rel="nofollow">https://console.cloud.google.com/</a>.',bt,$,gn='First, you need to install the <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">gcloud CLI</a> on your local machine. This allows to programmatically interact with your Google Cloud project.',vt,A,Jn="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",jt,V,It,E,bn="Some clarifications:",$t,R,vn='<li>We provide the latest official Docker image URI based on the <a href="https://github.com/huggingface/Google-Cloud-Containers/blob/main/containers/tei/README.md" rel="nofollow">README</a>.</li> <li>We choose to deploy the <a href="https://huggingface.co/ibm-granite/granite-embedding-278m-multilingual" rel="nofollow">IBM granite</a> embedding model given its strong multilingual capabilities. One can of course choose any other embedding model from the hub. It’s recommended to look for models tagged with either <code>feature-extraction</code>, <code>sentence-similarity</code> or <code>text-ranking</code>.</li>',At,N,jn="Then you need to login into your Google Cloud account and set the project ID you want to use to deploy Cloud Run.",Vt,Z,Et,S,In="Once you are logged in, you need to enable the Cloud Run API, which is required for the Hugging Face DLC for TEI deployment on Cloud Run.",Rt,x,Nt,L,Zt,k,$n="Once you are all set, you can call the <code>gcloud run deploy</code> command to deploy the Docker image.",St,G,An="The command needs you to specify the following parameters:",xt,W,Vn='<li><code>--image</code>: The container image URI to deploy.</li> <li><code>--args</code>: The arguments to pass to the container entrypoint, being <code>text-embeddings-inference</code> for the Hugging Face DLC for TEI. Read more about the supported arguments <a href="https://huggingface.co/docs/text-embeddings-inference/cli_arguments" rel="nofollow">here</a>.<ul><li><code>--model-id</code>: The model ID to use, in this case, <a href="https://huggingface.co/ibm-granite/granite-embedding-278m-multilingual" rel="nofollow"><code>ibm-granite/granite-embedding-278m-multilingual</code></a>.</li> <li><code>--quantize</code>: The quantization method to use. If not specified, it will be retrieved from the <code>quantization_config-&gt;quant_method</code> in the <code>config.json</code> file.</li> <li><code>--max-concurrent-requests</code>: The maximum amount of concurrent requests for this particular deployment. Having a low limit will refuse clients requests instead of having them wait for too long and is usually good to handle back pressure correctly. Set to 64, but default is 128.</li></ul></li> <li><code>--port</code>: The port the container listens to.</li> <li><code>--cpu</code> and <code>--memory</code>: The number of CPUs and amount of memory to allocate to the container. Needs to be set to 4 and 16Gi (16 GiB), respectively; as that’s the minimum requirement for using the GPU.</li> <li><code>--no-cpu-throttling</code>: Disables CPU throttling, which is required for using the GPU.</li> <li><code>--gpu</code> and <code>--gpu-type</code>: The number of GPUs and the GPU type to use. Needs to be set to 1 and <code>nvidia-l4</code>, respectively; as at the time of writing this tutorial, those are the only available options as Cloud Run on GPUs.</li> <li><code>--max-instances</code>: The maximum number of instances to run, set to 3, but default maximum value is 7. Alternatively, one could set it to 1 too, but that could eventually lead to downtime during infrastructure migrations, so anything above 1 is recommended.</li> <li><code>--concurrency</code>: the maximum number of concurrent requests per instance, set to 64. Note that this value is also aligned with the <a href="https://huggingface.co/docs/text-embeddings-inference/cli_arguments" rel="nofollow"><code>--max-concurrent-requests</code></a> argument in TEI.</li> <li><code>--region</code>: The region to deploy the Cloud Run service.</li> <li><code>--no-allow-unauthenticated</code>: Disables unauthenticated access to the service, which is a good practice as adds an authentication layer managed by Google Cloud IAM.</li>',Lt,U,ct,En=`[!NOTE]
Optionally, you can include the arguments <code>--vpc-egress=all-traffic</code> and <code>--subnet=default</code>, as there is external traffic being sent to the public internet, so in order to speed the network, you need to route all traffic through the VPC network by setting those flags. Note that besides setting the flags, you need to set up Google Cloud NAT to reach the public internet, which is a paid product. Find more information in <a href="https://cloud.google.com/run/docs/configuring/networking-best-practices" rel="nofollow">Cloud Run Documentation - Networking best practices</a>.`,cn,_,kt,Q,Rn="Finally, you can run the <code>gcloud run deploy</code> command to deploy TEI on Cloud Run as:",Gt,B,Wt,X,Nn="If you want to deploy with a GPU, run the following command:",_t,F,Qt,q,Zn="Or as it follows if you created the Cloud NAT:",Bt,H,Xt,O,Sn=`<p>[!NOTE]
The first time you deploy a new container on Cloud Run it will take around 5 minutes to deploy as it needs to import it from the Google Cloud Artifact Registry, but on the follow up deployments it will take less time as the image has been already imported before.</p>`,Ft,P,qt,Y,xn='Once deployed, you can send requests to the service via any of the supported TEI endpoints, check TEI’s <a href="https://huggingface.github.io/text-embeddings-inference/" rel="nofollow">OpenAPI Specification</a> to see all the available endpoints and their respective parameters.',Ht,D,Ln="All Cloud Run services are deployed privately by default, which means that they can’t be accessed without providing authentication credentials in the request headers. These services are secured by IAM and are only callable by Project Owners, Project Editors, and Cloud Run Admins and Cloud Run Invokers.",Ot,z,kn="In this case, a couple of alternatives to enable developer access will be showcased; while the other use cases are out of the scope of this example, as those are either not secure due to the authentication being disabled (for public access scenarios), or require additional setup for production-ready scenarios (service-to-service authentication, end-user access).",Pt,K,Gn=`<p>[!NOTE]
The alternatives mentioned below are for development scenarios, and should not be used in production-ready scenarios as is. The approach below is following the guide defined in <a href="https://cloud.google.com/run/docs/authenticating/developers" rel="nofollow">Cloud Run Documentation - Authenticate Developers</a>; but you can find every other guide as mentioned above in <a href="https://cloud.google.com/run/docs/authenticating/overview" rel="nofollow">Cloud Run Documentation - Authentication overview</a>.</p>`,Yt,ee,Dt,te,Wn="Cloud Run Proxy runs a server on localhost that proxies requests to the specified Cloud Run Service with credentials attached; which is useful for testing and experimentation.",zt,le,Kt,ne,_n="Then you can send requests to the deployed service on Cloud Run, using the http://localhost:8080 URL, with no authentication, exposed by the proxy as shown in the examples below. You can check the API docs at http://localhost:8080/docs in your browser.",el,se,tl,ie,Qn="To send a POST request to the TEI service using cURL, you can run the following command:",ll,ae,nl,oe,Bn="Alternatively, one can also send requests to the OpenAI-compatible endpoint:",sl,ue,il,re,al,pe,Xn='To run inference using Python, you can either use the <a href="https://huggingface.co/docs/huggingface_hub/en/index" rel="nofollow">huggingface_hub</a> Python SDK (recommended) or the openai Python SDK.',ol,ce,ul,de,Fn="You can install it via pip as <code>pip install --upgrade --quiet huggingface_hub</code>, and then run:",rl,Me,pl,he,cl,me,qn="You can install it via pip as <code>pip install --upgrade openai</code>, and then run:",dl,ye,Ml,Te,hl,Ue,Hn="Cloud Run Service has an unique URL assigned that can be used to send requests from anywhere, using the Google Cloud Credentials with Cloud Run Invoke access to the service; which is the recommended approach as it’s more secure and consistent than using the Cloud Run Proxy.",ml,fe,On="The URL of the Cloud Run service can be obtained via the following command (assigned to the SERVICE_URL variable for convenience):",yl,Ce,Tl,we,Pn="Then you can send requests to the deployed service on Cloud Run, using the <code>SERVICE_URL</code> and any Google Cloud Credentials with Cloud Run Invoke access. For setting up the credentials there are multiple approaches, some of those are listed below:",Ul,ge,Yn="Using the default identity token from the Google Cloud SDK:",fl,Je,Dn="<li>Via gcloud as:</li>",Cl,be,wl,ve,zn="<li>Via Python as:</li>",gl,je,Jl,Ie,Kn="<li>Using a Service Account with Cloud Run Invoke access, which can either be done with any of the following approaches:</li>",bl,$e,es="<strong>Create a Service Account before the Cloud Run Service was created, and then set the service-account flag to the Service Account email when creating the Cloud Run Service. And use an Access Token for that Service Account only using <code>gcloud auth print-access-token --impersonate-service-account=SERVICE_ACCOUNT_EMAIL</code>.</strong> Create a Service Account after the Cloud Run Service was created, and then update the Cloud Run Service to use the Service Account. And use an Access Token for that Service Account only using <code>gcloud auth print-access-token --impersonate-service-account=SERVICE_ACCOUNT_EMAIL</code>.",vl,Ae,ts="The recommended approach is to use a Service Account (SA), as the access can be controlled better and the permissions are more granular; as the Cloud Run Service was not created using a SA, which is another nice option, you need to now create the SA, gran it the necessary permissions, update the Cloud Run Service to use the SA, and then generate an access token to set as the authentication token within the requests, that can be revoked later once you are done using it.",jl,Ve,ls="<li>Set the SERVICE_ACCOUNT_NAME environment variable for convenience:</li>",Il,Ee,$l,Re,ns="<li>Create the Service Account:</li>",Al,Ne,Vl,Ze,ss="<li>Grant the Service Account the Cloud Run Invoker role:</li>",El,Se,Rl,xe,is="Generate the Access Token for the Service Account:",Nl,Le,Zl,ke,as="<p>The access token is short-lived and will expire, by default after 1 hour. If you want to extend the token lifetime beyond the default, you must create and organization policy and use the —lifetime argument when creating the token. Refer to Access token lifetime to learn more. Otherwise, you can also generate a new token by running the same command again.</p>",Sl,Ge,os="Now you can already dive into the different alternatives for sending the requests to the deployed Cloud Run Service using the <code>SERVICE_URL</code> AND <code>ACCESS_TOKEN</code> as described above.",xl,We,Ll,_e,us="To send a POST request to the TEI service using cURL, you can run the following command:",kl,Qe,Gl,Be,Wl,Xe,rs='To run inference using Python, you can either use the <a href="https://huggingface.co/docs/huggingface_hub/en/index" rel="nofollow">huggingface_hub</a> Python SDK (recommended) or the openai Python SDK.',_l,Fe,Ql,qe,ps="You can install it via pip as <code>pip install --upgrade --quiet huggingface_hub</code>, and then run:",Bl,He,Xl,Oe,Fl,Pe,cs="You can install it via pip as <code>pip install --upgrade openai</code>, and then run:",ql,Ye,Hl,De,Ol,ze,ds="Finally, once you are done using TEI on the Cloud Run Service, you can safely delete it to avoid incurring in unnecessary costs e.g. if the Cloud Run services are inadvertently invoked more times than your monthly Cloud Run invoke allocation in the free tier.",Pl,Ke,Ms='To delete the Cloud Run Service you can either go to the Google Cloud Console at <a href="https://console.cloud.google.com/run" rel="nofollow">https://console.cloud.google.com/run</a> and delete it manually; or use the Google Cloud SDK via gcloud as follows:',Yl,et,Dl,tt,hs="Additionally, if you followed the steps in via Cloud Run Service URL and generated a Service Account and an access token, you can either remove the Service Account, or just revoke the access token if it is still valid.",zl,lt,ms="<li>(recommended) Revoke the Access Token as:</li>",Kl,nt,en,st,ys="<li>(optional) Delete the Service Account as:</li>",tn,it,ln,at,Ts="Finally, if you decided to enable the VPC network via Cloud NAT, you can also remove the Cloud NAT (which is a paid product) as:",nn,ot,sn,ut,an,rt,Us='<li><a href="https://cloud.google.com/run/docs" rel="nofollow">Cloud Run documentation - Overview</a></li> <li><a href="https://cloud.google.com/run/docs/configuring/services/gpu" rel="nofollow">Cloud Run documentation - GPU services</a></li> <li><a href="https://cloud.google.com/blog/products/application-development/run-your-ai-inference-applications-on-cloud-run-with-nvidia-gpus" rel="nofollow">Google Cloud blog - Run your AI inference applications on Cloud Run with NVIDIA GPUs</a></li>',on,pt,un,Mt,rn;return f=new y({props:{title:"Deploying TEI on Google Cloud Run",local:"deploying-tei-on-google-cloud-run",headingTag:"h1"}}),j=new y({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),V=new m({props:{code:"ZXhwb3J0JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQWV4cG9ydCUyMExPQ0FUSU9OJTNEZXVyb3BlLXdlc3QxJTIwJTIwJTIzJTIwb3IlMjBhbnklMjBsb2NhdGlvbiUyMHlvdSUyMHByZWZlciUzQSUyMGh0dHBzJTNBJTJGJTJGY2xvdWQuZ29vZ2xlLmNvbSUyRnJ1biUyRmRvY3MlMkZsb2NhdGlvbnMlMEFleHBvcnQlMjBDT05UQUlORVJfVVJJJTNEJTIyZ2NyLmlvJTJGZGVlcGxlYXJuaW5nLXBsYXRmb3JtLXJlbGVhc2UlMkZodWdnaW5nZmFjZS10ZXh0LWVtYmVkZGluZ3MtaW5mZXJlbmNlLWNwdS4xLTYlMjIlMEFleHBvcnQlMjBTRVJWSUNFX05BTUUlM0QlMjJ0ZXh0LWVtYmVkZGluZy1zZXJ2ZXIlMjIlMjAlMjMlMjBjaG9vc2UlMjBhJTIwbmFtZSUyMGZvciUyMHlvdXIlMjBzZXJ2aWNlJTBBZXhwb3J0JTIwTU9ERUxfSUQlM0QlMjJpYm0tZ3Jhbml0ZSUyRmdyYW5pdGUtZW1iZWRkaW5nLTI3OG0tbXVsdGlsaW5ndWFsJTIyJTIwJTIzJTIwY2hvb3NlJTIwYW55JTIwZW1iZWRkaW5nJTIwbW9kZWw=",highlighted:`<span class="hljs-built_in">export</span> PROJECT_ID=your-project-id
<span class="hljs-built_in">export</span> LOCATION=europe-west1  <span class="hljs-comment"># or any location you prefer: https://cloud.google.com/run/docs/locations</span>
<span class="hljs-built_in">export</span> CONTAINER_URI=<span class="hljs-string">&quot;gcr.io/deeplearning-platform-release/huggingface-text-embeddings-inference-cpu.1-6&quot;</span>
<span class="hljs-built_in">export</span> SERVICE_NAME=<span class="hljs-string">&quot;text-embedding-server&quot;</span> <span class="hljs-comment"># choose a name for your service</span>
<span class="hljs-built_in">export</span> MODEL_ID=<span class="hljs-string">&quot;ibm-granite/granite-embedding-278m-multilingual&quot;</span> <span class="hljs-comment"># choose any embedding model</span>`,wrap:!1}}),Z=new m({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMGxvZ2luJTBBZ2Nsb3VkJTIwYXV0aCUyMGFwcGxpY2F0aW9uLWRlZmF1bHQlMjBsb2dpbiUyMCUyMCUyMyUyMEZvciUyMGxvY2FsJTIwZGV2ZWxvcG1lbnQlMEFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`gcloud auth login
gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
gcloud config <span class="hljs-built_in">set</span> project <span class="hljs-variable">$PROJECT_ID</span>`,wrap:!1}}),x=new m({props:{code:"Z2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBydW4uZ29vZ2xlYXBpcy5jb20=",highlighted:'gcloud services <span class="hljs-built_in">enable</span> run.googleapis.com',wrap:!1}}),L=new y({props:{title:"Deploy TEI on Cloud Run",local:"deploy-tei-on-cloud-run",headingTag:"h2"}}),_=new m({props:{code:"Z2Nsb3VkJTIwY29tcHV0ZSUyMHJvdXRlcnMlMjBjcmVhdGUlMjBuYXQtcm91dGVyJTIwLS1uZXR3b3JrJTNEZGVmYXVsdCUyMC0tcmVnaW9uJTNEJTI0TE9DQVRJT04lMEFnY2xvdWQlMjBjb21wdXRlJTIwcm91dGVycyUyMG5hdHMlMjBjcmVhdGUlMjB2bS1uYXQlMjAtLXJvdXRlciUzRG5hdC1yb3V0ZXIlMjAtLXJlZ2lvbiUzRCUyNExPQ0FUSU9OJTIwLS1hdXRvLWFsbG9jYXRlLW5hdC1leHRlcm5hbC1pcHMlMjAtLW5hdC1hbGwtc3VibmV0LWlwLXJhbmdlcw==",highlighted:`gcloud compute routers create nat-router --network=default --region=<span class="hljs-variable">$LOCATION</span>
gcloud compute routers nats create vm-nat --router=nat-router --region=<span class="hljs-variable">$LOCATION</span> --auto-allocate-nat-external-ips --nat-all-subnet-ip-ranges`,wrap:!1}}),B=new m({props:{code:"Z2Nsb3VkJTIwcnVuJTIwZGVwbG95JTIwJTI0U0VSVklDRV9OQU1FJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1pbWFnZSUzRCUyNENPTlRBSU5FUl9VUkklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWFyZ3MlM0QlMjItLW1vZGVsLWlkJTNEJTI0TU9ERUxfSUQlMkMtLW1heC1jb25jdXJyZW50LXJlcXVlc3RzJTNENjQlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNldC1lbnYtdmFycyUzREhGX0hVQl9FTkFCTEVfSEZfVFJBTlNGRVIlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wb3J0JTNEODA4MCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY3B1JTNEOCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWVtb3J5JTNEMzJHaSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVnaW9uJTNEJTI0TE9DQVRJT04lMjAlNUMlMEElMjAlMjAlMjAlMjAtLW5vLWFsbG93LXVuYXV0aGVudGljYXRlZA==",highlighted:`gcloud run deploy <span class="hljs-variable">$SERVICE_NAME</span> \\
    --image=<span class="hljs-variable">$CONTAINER_URI</span> \\
    --args=<span class="hljs-string">&quot;--model-id=<span class="hljs-variable">$MODEL_ID</span>,--max-concurrent-requests=64&quot;</span> \\
    --set-env-vars=HF_HUB_ENABLE_HF_TRANSFER=1 \\
    --port=8080 \\
    --cpu=8 \\
    --memory=32Gi \\
    --region=<span class="hljs-variable">$LOCATION</span> \\
    --no-allow-unauthenticated`,wrap:!1}}),F=new m({props:{code:"Z2Nsb3VkJTIwcnVuJTIwZGVwbG95JTIwJTI0U0VSVklDRV9OQU1FJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1pbWFnZSUzRCUyNENPTlRBSU5FUl9VUkklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWFyZ3MlM0QlMjItLW1vZGVsLWlkJTNEJTI0TU9ERUxfSUQlMkMtLW1heC1jb25jdXJyZW50LXJlcXVlc3RzJTNENjQlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNldC1lbnYtdmFycyUzREhGX0hVQl9FTkFCTEVfSEZfVFJBTlNGRVIlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wb3J0JTNEODA4MCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY3B1JTNEOCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWVtb3J5JTNEMzJHaSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbm8tY3B1LXRocm90dGxpbmclMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdwdSUzRDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdwdS10eXBlJTNEbnZpZGlhLWw0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXgtaW5zdGFuY2VzJTNEMyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY29uY3VycmVuY3klM0Q2NCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVnaW9uJTNEJTI0TE9DQVRJT04lMjAlNUMlMEElMjAlMjAlMjAlMjAtLW5vLWFsbG93LXVuYXV0aGVudGljYXRlZA==",highlighted:`gcloud run deploy <span class="hljs-variable">$SERVICE_NAME</span> \\
    --image=<span class="hljs-variable">$CONTAINER_URI</span> \\
    --args=<span class="hljs-string">&quot;--model-id=<span class="hljs-variable">$MODEL_ID</span>,--max-concurrent-requests=64&quot;</span> \\
    --set-env-vars=HF_HUB_ENABLE_HF_TRANSFER=1 \\
    --port=8080 \\
    --cpu=8 \\
    --memory=32Gi \\
    --no-cpu-throttling \\
    --gpu=1 \\
    --gpu-type=nvidia-l4 \\
    --max-instances=3 \\
    --concurrency=64 \\
    --region=<span class="hljs-variable">$LOCATION</span> \\
    --no-allow-unauthenticated`,wrap:!1}}),H=new m({props:{code:"Z2Nsb3VkJTIwYmV0YSUyMHJ1biUyMGRlcGxveSUyMCUyNFNFUlZJQ0VfTkFNRSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0taW1hZ2UlM0QlMjRDT05UQUlORVJfVVJJJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1hcmdzJTNEJTIyLS1tb2RlbC1pZCUzRCUyNE1PREVMX0lEJTJDLS1tYXgtY29uY3VycmVudC1yZXF1ZXN0cyUzRDY0JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zZXQtZW52LXZhcnMlM0RIRl9IVUJfRU5BQkxFX0hGX1RSQU5TRkVSJTNEMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcG9ydCUzRDgwODAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWNwdSUzRDglMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1lbW9yeSUzRDMyR2klMjAlNUMlMEElMjAlMjAlMjAlMjAtLW5vLWNwdS10aHJvdHRsaW5nJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ncHUlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ncHUtdHlwZSUzRG52aWRpYS1sNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4LWluc3RhbmNlcyUzRDMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWNvbmN1cnJlbmN5JTNENjQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlZ2lvbiUzRCUyNExPQ0FUSU9OJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1uby1hbGxvdy11bmF1dGhlbnRpY2F0ZWQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXZwYy1lZ3Jlc3MlM0RhbGwtdHJhZmZpYyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc3VibmV0JTNEZGVmYXVsdA==",highlighted:`gcloud beta run deploy <span class="hljs-variable">$SERVICE_NAME</span> \\
    --image=<span class="hljs-variable">$CONTAINER_URI</span> \\
    --args=<span class="hljs-string">&quot;--model-id=<span class="hljs-variable">$MODEL_ID</span>,--max-concurrent-requests=64&quot;</span> \\
    --set-env-vars=HF_HUB_ENABLE_HF_TRANSFER=1 \\
    --port=8080 \\
    --cpu=8 \\
    --memory=32Gi \\
    --no-cpu-throttling \\
    --gpu=1 \\
    --gpu-type=nvidia-l4 \\
    --max-instances=3 \\
    --concurrency=64 \\
    --region=<span class="hljs-variable">$LOCATION</span> \\
    --no-allow-unauthenticated \\
    --vpc-egress=all-traffic \\
    --subnet=default`,wrap:!1}}),P=new y({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ee=new y({props:{title:"Via Cloud Run Proxy",local:"via-cloud-run-proxy",headingTag:"h3"}}),le=new m({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBwcm94eSUyMCUyNFNFUlZJQ0VfTkFNRSUyMC0tcmVnaW9uJTIwJTI0TE9DQVRJT04=",highlighted:'gcloud run services proxy <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span>',wrap:!1}}),se=new y({props:{title:"cURL",local:"curl",headingTag:"h4"}}),ae=new m({props:{code:"Y3VybCUyMGh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGZW1iZWQlMjAlNUMlMEElMjAlMjAlMjAlMjAtWCUyMFBPU1QlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCdDb250ZW50LVR5cGUlM0ElMjBhcHBsaWNhdGlvbiUyRmpzb24nJTIwJTVDJTBBJTIwJTIwJTIwJTIwLWQlMjAnJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybW9kZWwlMjIlM0ElMjAlMjJ0ZWklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwZGVlcCUyMGxlYXJuaW5nJTNGJTIyJTBBJTIwJTIwJTIwJTIwJTdEJw==",highlighted:`curl http://localhost:8080/embed \\
    -X POST \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
        &quot;model&quot;: &quot;tei&quot;,
        &quot;text&quot;: &quot;What is deep learning?&quot;
    }&#x27;</span>`,wrap:!1}}),ue=new m({props:{code:"Y3VybCUyMGh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGdjElMkZlbWJlZGRpbmdzJTIwJTVDJTBBJTIwJTIwJTIwJTIwLVglMjBQT1NUJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1vZGVsJTIyJTNBJTIwJTIydGVpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUwQSUyMCUyMCUyMCUyMCU3RCc=",highlighted:`curl http://localhost:8080/v1/embeddings \\
    -X POST \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
        &quot;model&quot;: &quot;tei&quot;,
        &quot;text&quot;: &quot;What is deep learning?&quot;
    }&#x27;</span>`,wrap:!1}}),re=new y({props:{title:"Python",local:"python",headingTag:"h4"}}),ce=new y({props:{title:"huggingface_hub",local:"huggingfacehub",headingTag:"h5"}}),Me=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBZW1iZWRkaW5nJTIwJTNEJTIwY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJXaGF0JTIwaXMlMjBkZWVwJTIwbGVhcm5pbmclM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGZW1iZWQlMjIpJTBBcHJpbnQobGVuKGVtYmVkZGluZyU1QjAlNUQpKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient()
embedding = client.feature_extraction(<span class="hljs-string">&quot;What is deep learning?&quot;</span>,
                                      model=<span class="hljs-string">&quot;http://localhost:8080/embed&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(embedding[<span class="hljs-number">0</span>]))`,wrap:!1}}),he=new y({props:{title:"OpenAI",local:"openai",headingTag:"h4"}}),ye=new m({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQWNsaWVudCUyMCUzRCUyME9wZW5BSShiYXNlX3VybCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGdjElMkZlbWJlZGRpbmdzJTIyJTJDJTIwYXBpX2tleSUzRCUyMiUyMiklMEElMEFyZXNwb25zZSUyMCUzRCUyMGNsaWVudC5lbWJlZGRpbmdzLmNyZWF0ZSglMEElMjAlMjBtb2RlbCUzRCUyMnRlaSUyMiUyQyUwQSUyMCUyMGlucHV0JTNEJTIyV2hhdCUyMGlzJTIwZGVlcCUyMGxlYXJuaW5nJTNGJTIyJTBBKSUwQSUwQXByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

client = OpenAI(base_url=<span class="hljs-string">&quot;http://localhost:8080/v1/embeddings&quot;</span>, api_key=<span class="hljs-string">&quot;&quot;</span>)

response = client.embeddings.create(
  model=<span class="hljs-string">&quot;tei&quot;</span>,
  <span class="hljs-built_in">input</span>=<span class="hljs-string">&quot;What is deep learning?&quot;</span>
)

<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),Te=new y({props:{title:"(recommended) Via Cloud Run Service URL",local:"recommended-via-cloud-run-service-url",headingTag:"h3"}}),Ce=new m({props:{code:"U0VSVklDRV9VUkwlM0QlMjQoZ2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBkZXNjcmliZSUyMCUyNFNFUlZJQ0VfTkFNRSUyMC0tcmVnaW9uJTIwJTI0TE9DQVRJT04lMjAtLWZvcm1hdCUyMCd2YWx1ZShzdGF0dXMudXJsKScp",highlighted:'SERVICE_URL=$(gcloud run services describe <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span> --format <span class="hljs-string">&#x27;value(status.url)&#x27;</span>)',wrap:!1}}),be=new m({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMHByaW50LWlkZW50aXR5LXRva2Vu",highlighted:"gcloud auth print-identity-token",wrap:!1}}),je=new m({props:{code:"aW1wb3J0JTIwZ29vZ2xlLmF1dGglMEFmcm9tJTIwZ29vZ2xlLmF1dGgudHJhbnNwb3J0LnJlcXVlc3RzJTIwaW1wb3J0JTIwUmVxdWVzdCUyMGFzJTIwR29vZ2xlQXV0aFJlcXVlc3QlMEElMEFhdXRoX3JlcSUyMCUzRCUyMEdvb2dsZUF1dGhSZXF1ZXN0KCklMEFjcmVkcyUyQyUyMF8lMjAlM0QlMjBnb29nbGUuYXV0aC5kZWZhdWx0KCklMEFjcmVkcy5yZWZyZXNoKGF1dGhfcmVxKSUwQSUwQWlkX3Rva2VuJTIwJTNEJTIwY3JlZHMuaWRfdG9rZW4=",highlighted:`import google.auth
from google.auth.transport.requests import Request as GoogleAuthRequest

auth_req = GoogleAuthRequest()
creds, _ = google.auth.default()
creds.refresh(auth_req)

id_token = creds.id_token`,wrap:!1}}),Ee=new m({props:{code:"ZXhwb3J0JTIwU0VSVklDRV9BQ0NPVU5UX05BTUUlM0R0ZWktaW52b2tlcg==",highlighted:'<span class="hljs-built_in">export</span> SERVICE_ACCOUNT_NAME=tei-invoker',wrap:!1}}),Ne=new m({props:{code:"Z2Nsb3VkJTIwaWFtJTIwc2VydmljZS1hY2NvdW50cyUyMGNyZWF0ZSUyMCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1F",highlighted:'gcloud iam service-accounts create <span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>',wrap:!1}}),Se=new m({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBhZGQtaWFtLXBvbGljeS1iaW5kaW5nJTIwJTI0U0VSVklDRV9OQU1FJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tZW1iZXIlM0QlMjJzZXJ2aWNlQWNjb3VudCUzQSUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcm9sZSUzRCUyMnJvbGVzJTJGcnVuLmludm9rZXIlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlZ2lvbiUzRCUyNExPQ0FUSU9O",highlighted:`gcloud run services add-iam-policy-binding <span class="hljs-variable">$SERVICE_NAME</span> \\
    --member=<span class="hljs-string">&quot;serviceAccount:<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com&quot;</span> \\
    --role=<span class="hljs-string">&quot;roles/run.invoker&quot;</span> \\
    --region=<span class="hljs-variable">$LOCATION</span>`,wrap:!1}}),Le=new m({props:{code:"ZXhwb3J0JTIwQUNDRVNTX1RPS0VOJTNEJTI0KGdjbG91ZCUyMGF1dGglMjBwcmludC1hY2Nlc3MtdG9rZW4lMjAtLWltcGVyc29uYXRlLXNlcnZpY2UtYWNjb3VudCUzRCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbSk=",highlighted:'<span class="hljs-built_in">export</span> ACCESS_TOKEN=$(gcloud auth print-access-token --impersonate-service-account=<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com)',wrap:!1}}),We=new y({props:{title:"cURL",local:"curl",headingTag:"h4"}}),Qe=new m({props:{code:"Y3VybCUyMCUyNFNFUlZJQ0VfVVJMJTJGdjElMkZlbWJlZGRpZ3MlMjAlNUMlMEElMjAlMjAlMjAlMjAtWCUyMFBPU1QlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCUyMkF1dGhvcml6YXRpb24lM0ElMjBCZWFyZXIlMjAlMjRBQ0NFU1NfVE9LRU4lMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCdDb250ZW50LVR5cGUlM0ElMjBhcHBsaWNhdGlvbiUyRmpzb24nJTIwJTVDJTBBJTIwJTIwJTIwJTIwLWQlMjAnJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybW9kZWwlMjIlM0ElMjAlMjJ0ZWklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwZGVlcCUyMGxlYXJuaW5nJTNGJTIyJTBBJTIwJTIwJTIwJTIwJTdEJw==",highlighted:`curl <span class="hljs-variable">$SERVICE_URL</span>/v1/embeddigs \\
    -X POST \\
    -H <span class="hljs-string">&quot;Authorization: Bearer <span class="hljs-variable">$ACCESS_TOKEN</span>&quot;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
        &quot;model&quot;: &quot;tei&quot;,
        &quot;text&quot;: &quot;What is deep learning?&quot;
    }&#x27;</span>`,wrap:!1}}),Be=new y({props:{title:"Python",local:"python",headingTag:"h4"}}),Fe=new y({props:{title:"huggingface_hub",local:"huggingfacehub",headingTag:"h5"}}),He=new m({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNEb3MuZ2V0ZW52KCUyMlNFUlZJQ0VfVVJMJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyQUNDRVNTX1RPS0VOJTIyKSUyQyUwQSklMEElMEFlbWJlZGRpbmclMjAlM0QlMjBjbGllbnQuZmVhdHVyZV9leHRyYWN0aW9uKCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyaHR0cCUzQSUyRiUyRmxvY2FsaG9zdCUzQTgwODAlMkZlbWJlZCUyMiklMEFwcmludChsZW4oZW1iZWRkaW5nJTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(
    base_url=os.getenv(<span class="hljs-string">&quot;SERVICE_URL&quot;</span>),
    api_key=os.getenv(<span class="hljs-string">&quot;ACCESS_TOKEN&quot;</span>),
)

embedding = client.feature_extraction(<span class="hljs-string">&quot;What is deep learning?&quot;</span>,
                                      model=<span class="hljs-string">&quot;http://localhost:8080/embed&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(embedding[<span class="hljs-number">0</span>]))`,wrap:!1}}),Oe=new y({props:{title:"OpenAI",local:"openai",headingTag:"h4"}}),Ye=new m({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJJTBBJTBBY2xpZW50JTIwJTNEJTIwT3BlbkFJKCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNEb3MuZ2V0ZW52KCUyMlNFUlZJQ0VfVVJMJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyQUNDRVNTX1RPS0VOJTIyKSUyQyUwQSklMEElMEFyZXNwb25zZSUyMCUzRCUyMGNsaWVudC5lbWJlZGRpbmdzLmNyZWF0ZSglMEElMjAlMjBtb2RlbCUzRCUyMnRlaSUyMiUyQyUwQSUyMCUyMGlucHV0JTNEJTIyV2hhdCUyMGlzJTIwZGVlcCUyMGxlYXJuaW5nJTNGJTIyJTBBKSUwQSUwQXByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

client = OpenAI(
    base_url=os.getenv(<span class="hljs-string">&quot;SERVICE_URL&quot;</span>),
    api_key=os.getenv(<span class="hljs-string">&quot;ACCESS_TOKEN&quot;</span>),
)

response = client.embeddings.create(
  model=<span class="hljs-string">&quot;tei&quot;</span>,
  <span class="hljs-built_in">input</span>=<span class="hljs-string">&quot;What is deep learning?&quot;</span>
)

<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),De=new y({props:{title:"Resource clean up",local:"resource-clean-up",headingTag:"h2"}}),et=new m({props:{code:"Z2Nsb3VkJTIwcnVuJTIwc2VydmljZXMlMjBkZWxldGUlMjAlMjRTRVJWSUNFX05BTUUlMjAtLXJlZ2lvbiUyMCUyNExPQ0FUSU9O",highlighted:'gcloud run services delete <span class="hljs-variable">$SERVICE_NAME</span> --region <span class="hljs-variable">$LOCATION</span>',wrap:!1}}),nt=new m({props:{code:"Z2Nsb3VkJTIwYXV0aCUyMHJldm9rZSUyMC0taW1wZXJzb25hdGUtc2VydmljZS1hY2NvdW50JTNEJTI0U0VSVklDRV9BQ0NPVU5UX05BTUUlNDAlMjRQUk9KRUNUX0lELmlhbS5nc2VydmljZWFjY291bnQuY29t",highlighted:'gcloud auth revoke --impersonate-service-account=<span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com',wrap:!1}}),it=new m({props:{code:"Z2Nsb3VkJTIwaWFtJTIwc2VydmljZS1hY2NvdW50cyUyMGRlbGV0ZSUyMCUyNFNFUlZJQ0VfQUNDT1VOVF9OQU1FJTQwJTI0UFJPSkVDVF9JRC5pYW0uZ3NlcnZpY2VhY2NvdW50LmNvbQ==",highlighted:'gcloud iam service-accounts delete <span class="hljs-variable">$SERVICE_ACCOUNT_NAME</span>@<span class="hljs-variable">$PROJECT_ID</span>.iam.gserviceaccount.com',wrap:!1}}),ot=new m({props:{code:"Z2Nsb3VkJTIwY29tcHV0ZSUyMHJvdXRlcnMlMjBuYXRzJTIwZGVsZXRlJTIwdm0tbmF0JTIwLS1yb3V0ZXIlM0RuYXQtcm91dGVyJTIwLS1yZWdpb24lM0QlMjRMT0NBVElPTiUwQWdjbG91ZCUyMGNvbXB1dGUlMjByb3V0ZXJzJTIwZGVsZXRlJTIwbmF0LXJvdXRlciUyMC0tcmVnaW9uJTNEJTI0TE9DQVRJT04=",highlighted:`gcloud compute routers nats delete vm-nat --router=nat-router --region=<span class="hljs-variable">$LOCATION</span>
gcloud compute routers delete nat-router --region=<span class="hljs-variable">$LOCATION</span>`,wrap:!1}}),ut=new y({props:{title:"References",local:"references",headingTag:"h2"}}),pt=new js({props:{source:"https://github.com/huggingface/text-embeddings-inference/blob/main/docs/source/en/tei_cloud_run.md"}}),{c(){T=a("meta"),ht=s(),dt=a("p"),mt=s(),r(f.$$.fragment),yt=s(),C=a("p"),C.innerHTML=mn,Tt=s(),w=a("p"),w.textContent=yn,Ut=s(),g=a("ul"),g.innerHTML=Tn,ft=s(),J=a("p"),J.textContent=Un,Ct=s(),b=a("p"),b.textContent=fn,wt=s(),v=a("blockquote"),v.innerHTML=Cn,gt=s(),r(j.$$.fragment),Jt=s(),I=a("p"),I.innerHTML=wn,bt=s(),$=a("p"),$.innerHTML=gn,vt=s(),A=a("p"),A.textContent=Jn,jt=s(),r(V.$$.fragment),It=s(),E=a("p"),E.textContent=bn,$t=s(),R=a("ul"),R.innerHTML=vn,At=s(),N=a("p"),N.textContent=jn,Vt=s(),r(Z.$$.fragment),Et=s(),S=a("p"),S.textContent=In,Rt=s(),r(x.$$.fragment),Nt=s(),r(L.$$.fragment),Zt=s(),k=a("p"),k.innerHTML=$n,St=s(),G=a("p"),G.textContent=An,xt=s(),W=a("ul"),W.innerHTML=Vn,Lt=s(),U=a("blockquote"),ct=a("p"),ct.innerHTML=En,cn=s(),r(_.$$.fragment),kt=s(),Q=a("p"),Q.innerHTML=Rn,Gt=s(),r(B.$$.fragment),Wt=s(),X=a("p"),X.textContent=Nn,_t=s(),r(F.$$.fragment),Qt=s(),q=a("p"),q.textContent=Zn,Bt=s(),r(H.$$.fragment),Xt=s(),O=a("blockquote"),O.innerHTML=Sn,Ft=s(),r(P.$$.fragment),qt=s(),Y=a("p"),Y.innerHTML=xn,Ht=s(),D=a("p"),D.textContent=Ln,Ot=s(),z=a("p"),z.textContent=kn,Pt=s(),K=a("blockquote"),K.innerHTML=Gn,Yt=s(),r(ee.$$.fragment),Dt=s(),te=a("p"),te.textContent=Wn,zt=s(),r(le.$$.fragment),Kt=s(),ne=a("p"),ne.textContent=_n,el=s(),r(se.$$.fragment),tl=s(),ie=a("p"),ie.textContent=Qn,ll=s(),r(ae.$$.fragment),nl=s(),oe=a("p"),oe.textContent=Bn,sl=s(),r(ue.$$.fragment),il=s(),r(re.$$.fragment),al=s(),pe=a("p"),pe.innerHTML=Xn,ol=s(),r(ce.$$.fragment),ul=s(),de=a("p"),de.innerHTML=Fn,rl=s(),r(Me.$$.fragment),pl=s(),r(he.$$.fragment),cl=s(),me=a("p"),me.innerHTML=qn,dl=s(),r(ye.$$.fragment),Ml=s(),r(Te.$$.fragment),hl=s(),Ue=a("p"),Ue.textContent=Hn,ml=s(),fe=a("p"),fe.textContent=On,yl=s(),r(Ce.$$.fragment),Tl=s(),we=a("p"),we.innerHTML=Pn,Ul=s(),ge=a("p"),ge.textContent=Yn,fl=s(),Je=a("ul"),Je.innerHTML=Dn,Cl=s(),r(be.$$.fragment),wl=s(),ve=a("ul"),ve.innerHTML=zn,gl=s(),r(je.$$.fragment),Jl=s(),Ie=a("ul"),Ie.innerHTML=Kn,bl=s(),$e=a("p"),$e.innerHTML=es,vl=s(),Ae=a("p"),Ae.textContent=ts,jl=s(),Ve=a("ul"),Ve.innerHTML=ls,Il=s(),r(Ee.$$.fragment),$l=s(),Re=a("ul"),Re.innerHTML=ns,Al=s(),r(Ne.$$.fragment),Vl=s(),Ze=a("ul"),Ze.innerHTML=ss,El=s(),r(Se.$$.fragment),Rl=s(),xe=a("p"),xe.textContent=is,Nl=s(),r(Le.$$.fragment),Zl=s(),ke=a("blockquote"),ke.innerHTML=as,Sl=s(),Ge=a("p"),Ge.innerHTML=os,xl=s(),r(We.$$.fragment),Ll=s(),_e=a("p"),_e.textContent=us,kl=s(),r(Qe.$$.fragment),Gl=s(),r(Be.$$.fragment),Wl=s(),Xe=a("p"),Xe.innerHTML=rs,_l=s(),r(Fe.$$.fragment),Ql=s(),qe=a("p"),qe.innerHTML=ps,Bl=s(),r(He.$$.fragment),Xl=s(),r(Oe.$$.fragment),Fl=s(),Pe=a("p"),Pe.innerHTML=cs,ql=s(),r(Ye.$$.fragment),Hl=s(),r(De.$$.fragment),Ol=s(),ze=a("p"),ze.textContent=ds,Pl=s(),Ke=a("p"),Ke.innerHTML=Ms,Yl=s(),r(et.$$.fragment),Dl=s(),tt=a("p"),tt.textContent=hs,zl=s(),lt=a("ul"),lt.innerHTML=ms,Kl=s(),r(nt.$$.fragment),en=s(),st=a("ul"),st.innerHTML=ys,tn=s(),r(it.$$.fragment),ln=s(),at=a("p"),at.textContent=Ts,nn=s(),r(ot.$$.fragment),sn=s(),r(ut.$$.fragment),an=s(),rt=a("ul"),rt.innerHTML=Us,on=s(),r(pt.$$.fragment),un=s(),Mt=a("p"),this.h()},l(e){const t=vs("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(l),ht=i(e),dt=o(e,"P",{}),dn(dt).forEach(l),mt=i(e),p(f.$$.fragment,e),yt=i(e),C=o(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-1jywelx"&&(C.innerHTML=mn),Tt=i(e),w=o(e,"P",{"data-svelte-h":!0}),u(w)!=="svelte-kstn30"&&(w.textContent=yn),Ut=i(e),g=o(e,"UL",{"data-svelte-h":!0}),u(g)!=="svelte-1ri0d6u"&&(g.innerHTML=Tn),ft=i(e),J=o(e,"P",{"data-svelte-h":!0}),u(J)!=="svelte-jq2f1f"&&(J.textContent=Un),Ct=i(e),b=o(e,"P",{"data-svelte-h":!0}),u(b)!=="svelte-1kwnf1q"&&(b.textContent=fn),wt=i(e),v=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),u(v)!=="svelte-1y1fe0j"&&(v.innerHTML=Cn),gt=i(e),p(j.$$.fragment,e),Jt=i(e),I=o(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-9iv4wv"&&(I.innerHTML=wn),bt=i(e),$=o(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-p3n1a9"&&($.innerHTML=gn),vt=i(e),A=o(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-1i8n6rq"&&(A.textContent=Jn),jt=i(e),p(V.$$.fragment,e),It=i(e),E=o(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-12btpyf"&&(E.textContent=bn),$t=i(e),R=o(e,"UL",{"data-svelte-h":!0}),u(R)!=="svelte-1pcxftj"&&(R.innerHTML=vn),At=i(e),N=o(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-pfbeqd"&&(N.textContent=jn),Vt=i(e),p(Z.$$.fragment,e),Et=i(e),S=o(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-13jr0pj"&&(S.textContent=In),Rt=i(e),p(x.$$.fragment,e),Nt=i(e),p(L.$$.fragment,e),Zt=i(e),k=o(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-1aiwb7r"&&(k.innerHTML=$n),St=i(e),G=o(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-1f5ji1s"&&(G.textContent=An),xt=i(e),W=o(e,"UL",{"data-svelte-h":!0}),u(W)!=="svelte-1loprp1"&&(W.innerHTML=Vn),Lt=i(e),U=o(e,"BLOCKQUOTE",{});var pn=dn(U);ct=o(pn,"P",{"data-svelte-h":!0}),u(ct)!=="svelte-1qocff3"&&(ct.innerHTML=En),cn=i(pn),p(_.$$.fragment,pn),pn.forEach(l),kt=i(e),Q=o(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-wzi9ad"&&(Q.innerHTML=Rn),Gt=i(e),p(B.$$.fragment,e),Wt=i(e),X=o(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-cltr6v"&&(X.textContent=Nn),_t=i(e),p(F.$$.fragment,e),Qt=i(e),q=o(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-vtd23h"&&(q.textContent=Zn),Bt=i(e),p(H.$$.fragment,e),Xt=i(e),O=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),u(O)!=="svelte-408vnr"&&(O.innerHTML=Sn),Ft=i(e),p(P.$$.fragment,e),qt=i(e),Y=o(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-12bs2xr"&&(Y.innerHTML=xn),Ht=i(e),D=o(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-1gzo66i"&&(D.textContent=Ln),Ot=i(e),z=o(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-8buc6k"&&(z.textContent=kn),Pt=i(e),K=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),u(K)!=="svelte-yp5di9"&&(K.innerHTML=Gn),Yt=i(e),p(ee.$$.fragment,e),Dt=i(e),te=o(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-1n42sxg"&&(te.textContent=Wn),zt=i(e),p(le.$$.fragment,e),Kt=i(e),ne=o(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-1wqv6zg"&&(ne.textContent=_n),el=i(e),p(se.$$.fragment,e),tl=i(e),ie=o(e,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-1je3wgp"&&(ie.textContent=Qn),ll=i(e),p(ae.$$.fragment,e),nl=i(e),oe=o(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-7nrnml"&&(oe.textContent=Bn),sl=i(e),p(ue.$$.fragment,e),il=i(e),p(re.$$.fragment,e),al=i(e),pe=o(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-h8hgtx"&&(pe.innerHTML=Xn),ol=i(e),p(ce.$$.fragment,e),ul=i(e),de=o(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-1pmfr0a"&&(de.innerHTML=Fn),rl=i(e),p(Me.$$.fragment,e),pl=i(e),p(he.$$.fragment,e),cl=i(e),me=o(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-17lqblq"&&(me.innerHTML=qn),dl=i(e),p(ye.$$.fragment,e),Ml=i(e),p(Te.$$.fragment,e),hl=i(e),Ue=o(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-1o5h253"&&(Ue.textContent=Hn),ml=i(e),fe=o(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-govem3"&&(fe.textContent=On),yl=i(e),p(Ce.$$.fragment,e),Tl=i(e),we=o(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-niuemd"&&(we.innerHTML=Pn),Ul=i(e),ge=o(e,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-4rg0sg"&&(ge.textContent=Yn),fl=i(e),Je=o(e,"UL",{"data-svelte-h":!0}),u(Je)!=="svelte-h09l2v"&&(Je.innerHTML=Dn),Cl=i(e),p(be.$$.fragment,e),wl=i(e),ve=o(e,"UL",{"data-svelte-h":!0}),u(ve)!=="svelte-b6nbfv"&&(ve.innerHTML=zn),gl=i(e),p(je.$$.fragment,e),Jl=i(e),Ie=o(e,"UL",{"data-svelte-h":!0}),u(Ie)!=="svelte-93kat8"&&(Ie.innerHTML=Kn),bl=i(e),$e=o(e,"P",{"data-svelte-h":!0}),u($e)!=="svelte-1hrh7sd"&&($e.innerHTML=es),vl=i(e),Ae=o(e,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-18iwnqm"&&(Ae.textContent=ts),jl=i(e),Ve=o(e,"UL",{"data-svelte-h":!0}),u(Ve)!=="svelte-1v8yusc"&&(Ve.innerHTML=ls),Il=i(e),p(Ee.$$.fragment,e),$l=i(e),Re=o(e,"UL",{"data-svelte-h":!0}),u(Re)!=="svelte-1e2np3q"&&(Re.innerHTML=ns),Al=i(e),p(Ne.$$.fragment,e),Vl=i(e),Ze=o(e,"UL",{"data-svelte-h":!0}),u(Ze)!=="svelte-m7ycff"&&(Ze.innerHTML=ss),El=i(e),p(Se.$$.fragment,e),Rl=i(e),xe=o(e,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-v6tnr5"&&(xe.textContent=is),Nl=i(e),p(Le.$$.fragment,e),Zl=i(e),ke=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),u(ke)!=="svelte-dmerw2"&&(ke.innerHTML=as),Sl=i(e),Ge=o(e,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-ur1pan"&&(Ge.innerHTML=os),xl=i(e),p(We.$$.fragment,e),Ll=i(e),_e=o(e,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-1je3wgp"&&(_e.textContent=us),kl=i(e),p(Qe.$$.fragment,e),Gl=i(e),p(Be.$$.fragment,e),Wl=i(e),Xe=o(e,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-h8hgtx"&&(Xe.innerHTML=rs),_l=i(e),p(Fe.$$.fragment,e),Ql=i(e),qe=o(e,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-1pmfr0a"&&(qe.innerHTML=ps),Bl=i(e),p(He.$$.fragment,e),Xl=i(e),p(Oe.$$.fragment,e),Fl=i(e),Pe=o(e,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-17lqblq"&&(Pe.innerHTML=cs),ql=i(e),p(Ye.$$.fragment,e),Hl=i(e),p(De.$$.fragment,e),Ol=i(e),ze=o(e,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-8fqmhw"&&(ze.textContent=ds),Pl=i(e),Ke=o(e,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-1stcxhv"&&(Ke.innerHTML=Ms),Yl=i(e),p(et.$$.fragment,e),Dl=i(e),tt=o(e,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-1umuozh"&&(tt.textContent=hs),zl=i(e),lt=o(e,"UL",{"data-svelte-h":!0}),u(lt)!=="svelte-uuoqil"&&(lt.innerHTML=ms),Kl=i(e),p(nt.$$.fragment,e),en=i(e),st=o(e,"UL",{"data-svelte-h":!0}),u(st)!=="svelte-1toh59e"&&(st.innerHTML=ys),tn=i(e),p(it.$$.fragment,e),ln=i(e),at=o(e,"P",{"data-svelte-h":!0}),u(at)!=="svelte-1xv6mwy"&&(at.textContent=Ts),nn=i(e),p(ot.$$.fragment,e),sn=i(e),p(ut.$$.fragment,e),an=i(e),rt=o(e,"UL",{"data-svelte-h":!0}),u(rt)!=="svelte-1i59rl0"&&(rt.innerHTML=Us),on=i(e),p(pt.$$.fragment,e),un=i(e),Mt=o(e,"P",{}),dn(Mt).forEach(l),this.h()},h(){fs(T,"name","hf:doc:metadata"),fs(T,"content",$s)},m(e,t){Mn(document.head,T),n(e,ht,t),n(e,dt,t),n(e,mt,t),c(f,e,t),n(e,yt,t),n(e,C,t),n(e,Tt,t),n(e,w,t),n(e,Ut,t),n(e,g,t),n(e,ft,t),n(e,J,t),n(e,Ct,t),n(e,b,t),n(e,wt,t),n(e,v,t),n(e,gt,t),c(j,e,t),n(e,Jt,t),n(e,I,t),n(e,bt,t),n(e,$,t),n(e,vt,t),n(e,A,t),n(e,jt,t),c(V,e,t),n(e,It,t),n(e,E,t),n(e,$t,t),n(e,R,t),n(e,At,t),n(e,N,t),n(e,Vt,t),c(Z,e,t),n(e,Et,t),n(e,S,t),n(e,Rt,t),c(x,e,t),n(e,Nt,t),c(L,e,t),n(e,Zt,t),n(e,k,t),n(e,St,t),n(e,G,t),n(e,xt,t),n(e,W,t),n(e,Lt,t),n(e,U,t),Mn(U,ct),Mn(U,cn),c(_,U,null),n(e,kt,t),n(e,Q,t),n(e,Gt,t),c(B,e,t),n(e,Wt,t),n(e,X,t),n(e,_t,t),c(F,e,t),n(e,Qt,t),n(e,q,t),n(e,Bt,t),c(H,e,t),n(e,Xt,t),n(e,O,t),n(e,Ft,t),c(P,e,t),n(e,qt,t),n(e,Y,t),n(e,Ht,t),n(e,D,t),n(e,Ot,t),n(e,z,t),n(e,Pt,t),n(e,K,t),n(e,Yt,t),c(ee,e,t),n(e,Dt,t),n(e,te,t),n(e,zt,t),c(le,e,t),n(e,Kt,t),n(e,ne,t),n(e,el,t),c(se,e,t),n(e,tl,t),n(e,ie,t),n(e,ll,t),c(ae,e,t),n(e,nl,t),n(e,oe,t),n(e,sl,t),c(ue,e,t),n(e,il,t),c(re,e,t),n(e,al,t),n(e,pe,t),n(e,ol,t),c(ce,e,t),n(e,ul,t),n(e,de,t),n(e,rl,t),c(Me,e,t),n(e,pl,t),c(he,e,t),n(e,cl,t),n(e,me,t),n(e,dl,t),c(ye,e,t),n(e,Ml,t),c(Te,e,t),n(e,hl,t),n(e,Ue,t),n(e,ml,t),n(e,fe,t),n(e,yl,t),c(Ce,e,t),n(e,Tl,t),n(e,we,t),n(e,Ul,t),n(e,ge,t),n(e,fl,t),n(e,Je,t),n(e,Cl,t),c(be,e,t),n(e,wl,t),n(e,ve,t),n(e,gl,t),c(je,e,t),n(e,Jl,t),n(e,Ie,t),n(e,bl,t),n(e,$e,t),n(e,vl,t),n(e,Ae,t),n(e,jl,t),n(e,Ve,t),n(e,Il,t),c(Ee,e,t),n(e,$l,t),n(e,Re,t),n(e,Al,t),c(Ne,e,t),n(e,Vl,t),n(e,Ze,t),n(e,El,t),c(Se,e,t),n(e,Rl,t),n(e,xe,t),n(e,Nl,t),c(Le,e,t),n(e,Zl,t),n(e,ke,t),n(e,Sl,t),n(e,Ge,t),n(e,xl,t),c(We,e,t),n(e,Ll,t),n(e,_e,t),n(e,kl,t),c(Qe,e,t),n(e,Gl,t),c(Be,e,t),n(e,Wl,t),n(e,Xe,t),n(e,_l,t),c(Fe,e,t),n(e,Ql,t),n(e,qe,t),n(e,Bl,t),c(He,e,t),n(e,Xl,t),c(Oe,e,t),n(e,Fl,t),n(e,Pe,t),n(e,ql,t),c(Ye,e,t),n(e,Hl,t),c(De,e,t),n(e,Ol,t),n(e,ze,t),n(e,Pl,t),n(e,Ke,t),n(e,Yl,t),c(et,e,t),n(e,Dl,t),n(e,tt,t),n(e,zl,t),n(e,lt,t),n(e,Kl,t),c(nt,e,t),n(e,en,t),n(e,st,t),n(e,tn,t),c(it,e,t),n(e,ln,t),n(e,at,t),n(e,nn,t),c(ot,e,t),n(e,sn,t),c(ut,e,t),n(e,an,t),n(e,rt,t),n(e,on,t),c(pt,e,t),n(e,un,t),n(e,Mt,t),rn=!0},p:ws,i(e){rn||(d(f.$$.fragment,e),d(j.$$.fragment,e),d(V.$$.fragment,e),d(Z.$$.fragment,e),d(x.$$.fragment,e),d(L.$$.fragment,e),d(_.$$.fragment,e),d(B.$$.fragment,e),d(F.$$.fragment,e),d(H.$$.fragment,e),d(P.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(ue.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(Me.$$.fragment,e),d(he.$$.fragment,e),d(ye.$$.fragment,e),d(Te.$$.fragment,e),d(Ce.$$.fragment,e),d(be.$$.fragment,e),d(je.$$.fragment,e),d(Ee.$$.fragment,e),d(Ne.$$.fragment,e),d(Se.$$.fragment,e),d(Le.$$.fragment,e),d(We.$$.fragment,e),d(Qe.$$.fragment,e),d(Be.$$.fragment,e),d(Fe.$$.fragment,e),d(He.$$.fragment,e),d(Oe.$$.fragment,e),d(Ye.$$.fragment,e),d(De.$$.fragment,e),d(et.$$.fragment,e),d(nt.$$.fragment,e),d(it.$$.fragment,e),d(ot.$$.fragment,e),d(ut.$$.fragment,e),d(pt.$$.fragment,e),rn=!0)},o(e){M(f.$$.fragment,e),M(j.$$.fragment,e),M(V.$$.fragment,e),M(Z.$$.fragment,e),M(x.$$.fragment,e),M(L.$$.fragment,e),M(_.$$.fragment,e),M(B.$$.fragment,e),M(F.$$.fragment,e),M(H.$$.fragment,e),M(P.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(se.$$.fragment,e),M(ae.$$.fragment,e),M(ue.$$.fragment,e),M(re.$$.fragment,e),M(ce.$$.fragment,e),M(Me.$$.fragment,e),M(he.$$.fragment,e),M(ye.$$.fragment,e),M(Te.$$.fragment,e),M(Ce.$$.fragment,e),M(be.$$.fragment,e),M(je.$$.fragment,e),M(Ee.$$.fragment,e),M(Ne.$$.fragment,e),M(Se.$$.fragment,e),M(Le.$$.fragment,e),M(We.$$.fragment,e),M(Qe.$$.fragment,e),M(Be.$$.fragment,e),M(Fe.$$.fragment,e),M(He.$$.fragment,e),M(Oe.$$.fragment,e),M(Ye.$$.fragment,e),M(De.$$.fragment,e),M(et.$$.fragment,e),M(nt.$$.fragment,e),M(it.$$.fragment,e),M(ot.$$.fragment,e),M(ut.$$.fragment,e),M(pt.$$.fragment,e),rn=!1},d(e){e&&(l(ht),l(dt),l(mt),l(yt),l(C),l(Tt),l(w),l(Ut),l(g),l(ft),l(J),l(Ct),l(b),l(wt),l(v),l(gt),l(Jt),l(I),l(bt),l($),l(vt),l(A),l(jt),l(It),l(E),l($t),l(R),l(At),l(N),l(Vt),l(Et),l(S),l(Rt),l(Nt),l(Zt),l(k),l(St),l(G),l(xt),l(W),l(Lt),l(U),l(kt),l(Q),l(Gt),l(Wt),l(X),l(_t),l(Qt),l(q),l(Bt),l(Xt),l(O),l(Ft),l(qt),l(Y),l(Ht),l(D),l(Ot),l(z),l(Pt),l(K),l(Yt),l(Dt),l(te),l(zt),l(Kt),l(ne),l(el),l(tl),l(ie),l(ll),l(nl),l(oe),l(sl),l(il),l(al),l(pe),l(ol),l(ul),l(de),l(rl),l(pl),l(cl),l(me),l(dl),l(Ml),l(hl),l(Ue),l(ml),l(fe),l(yl),l(Tl),l(we),l(Ul),l(ge),l(fl),l(Je),l(Cl),l(wl),l(ve),l(gl),l(Jl),l(Ie),l(bl),l($e),l(vl),l(Ae),l(jl),l(Ve),l(Il),l($l),l(Re),l(Al),l(Vl),l(Ze),l(El),l(Rl),l(xe),l(Nl),l(Zl),l(ke),l(Sl),l(Ge),l(xl),l(Ll),l(_e),l(kl),l(Gl),l(Wl),l(Xe),l(_l),l(Ql),l(qe),l(Bl),l(Xl),l(Fl),l(Pe),l(ql),l(Hl),l(Ol),l(ze),l(Pl),l(Ke),l(Yl),l(Dl),l(tt),l(zl),l(lt),l(Kl),l(en),l(st),l(tn),l(ln),l(at),l(nn),l(sn),l(an),l(rt),l(on),l(un),l(Mt)),l(T),h(f,e),h(j,e),h(V,e),h(Z,e),h(x,e),h(L,e),h(_),h(B,e),h(F,e),h(H,e),h(P,e),h(ee,e),h(le,e),h(se,e),h(ae,e),h(ue,e),h(re,e),h(ce,e),h(Me,e),h(he,e),h(ye,e),h(Te,e),h(Ce,e),h(be,e),h(je,e),h(Ee,e),h(Ne,e),h(Se,e),h(Le,e),h(We,e),h(Qe,e),h(Be,e),h(Fe,e),h(He,e),h(Oe,e),h(Ye,e),h(De,e),h(et,e),h(nt,e),h(it,e),h(ot,e),h(ut,e),h(pt,e)}}}const $s='{"title":"Deploying TEI on Google Cloud Run","local":"deploying-tei-on-google-cloud-run","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[],"depth":2},{"title":"Deploy TEI on Cloud Run","local":"deploy-tei-on-cloud-run","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[{"title":"Via Cloud Run Proxy","local":"via-cloud-run-proxy","sections":[{"title":"cURL","local":"curl","sections":[],"depth":4},{"title":"Python","local":"python","sections":[{"title":"huggingface_hub","local":"huggingfacehub","sections":[],"depth":5}],"depth":4},{"title":"OpenAI","local":"openai","sections":[],"depth":4}],"depth":3},{"title":"(recommended) Via Cloud Run Service URL","local":"recommended-via-cloud-run-service-url","sections":[{"title":"cURL","local":"curl","sections":[],"depth":4},{"title":"Python","local":"python","sections":[{"title":"huggingface_hub","local":"huggingfacehub","sections":[],"depth":5}],"depth":4},{"title":"OpenAI","local":"openai","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Resource clean up","local":"resource-clean-up","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function As(hn){return gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zs extends Js{constructor(T){super(),bs(this,T,As,Is,Cs,{})}}export{Zs as component};
