import{s as Dt,o as Xt,n as oe}from"../chunks/scheduler.9bc65507.js";import{S as Qt,i as Yt,g as c,s as r,r as M,A as Kt,h as p,f as s,c as i,j as K,u as y,x as h,k as V,y as d,a as l,v as w,d as k,t as v,w as $}from"../chunks/index.707bf1b6.js";import{T as wt}from"../chunks/Tip.c2ecdbf4.js";import{D as ce}from"../chunks/Docstring.17db21ae.js";import{C as kt}from"../chunks/CodeBlock.54a9f38d.js";import{F as en,M as Et}from"../chunks/Markdown.fef84341.js";import{E as Ht}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{P as Vt}from"../chunks/PipelineTag.44585822.js";import{H as Ee}from"../chunks/Heading.342b1fa6.js";function tn(G){let e,g="Examples:",n,a,T;return a=new kt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME9wZW5BSUdQVENvbmZpZyUyQyUyME9wZW5BSUdQVE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEdQVCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwT3BlbkFJR1BUQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyME9wZW5BSUdQVE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OpenAIGPTConfig, OpenAIGPTModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a GPT configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = OpenAIGPTConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OpenAIGPTModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),M(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-kvfsh7"&&(e.textContent=g),n=i(o),y(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),w(a,o,_),T=!0},p:oe,i(o){T||(k(a.$$.fragment,o),T=!0)},o(o){v(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),$(a,o)}}}function nn(G){let e,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=g},l(n){e=p(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=g)},m(n,a){l(n,e,a)},p:oe,d(n){n&&s(e)}}}function on(G){let e,g="Example:",n,a,T;return a=new kt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBPcGVuQUlHUFRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWdwdCUyMiklMEFtb2RlbCUyMCUzRCUyME9wZW5BSUdQVE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktZ3B0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, OpenAIGPTModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OpenAIGPTModel.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),M(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=g),n=i(o),y(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),w(a,o,_),T=!0},p:oe,i(o){T||(k(a.$$.fragment,o),T=!0)},o(o){v(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),$(a,o)}}}function sn(G){let e,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=g},l(n){e=p(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=g)},m(n,a){l(n,e,a)},p:oe,d(n){n&&s(e)}}}function an(G){let e,g="Example:",n,a,T;return a=new kt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME9wZW5BSUdQVExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWdwdCUyMiklMEFtb2RlbCUyMCUzRCUyME9wZW5BSUdQVExNSGVhZE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktZ3B0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, OpenAIGPTLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OpenAIGPTLMHeadModel.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),M(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=g),n=i(o),y(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),w(a,o,_),T=!0},p:oe,i(o){T||(k(a.$$.fragment,o),T=!0)},o(o){v(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),$(a,o)}}}function rn(G){let e,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=g},l(n){e=p(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=g)},m(n,a){l(n,e,a)},p:oe,d(n){n&&s(e)}}}function ln(G){let e,g="Examples:",n,a,T;return a=new kt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBPcGVuQUlHUFREb3VibGVIZWFkc01vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktZ3B0JTIyKSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJR1BURG91YmxlSGVhZHNNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWdwdCUyMiklMEF0b2tlbml6ZXIuYWRkX3NwZWNpYWxfdG9rZW5zKCUwQSUyMCUyMCUyMCUyMCU3QiUyMmNsc190b2tlbiUyMiUzQSUyMCUyMiU1QkNMUyU1RCUyMiU3RCUwQSklMjAlMjAlMjMlMjBBZGQlMjBhJTIwJTVCQ0xTJTVEJTIwdG8lMjB0aGUlMjB2b2NhYnVsYXJ5JTIwKHdlJTIwc2hvdWxkJTIwdHJhaW4lMjBpdCUyMGFsc28hKSUwQW1vZGVsLnJlc2l6ZV90b2tlbl9lbWJlZGRpbmdzKGxlbih0b2tlbml6ZXIpKSUwQSUwQWNob2ljZXMlMjAlM0QlMjAlNUIlMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIwJTVCQ0xTJTVEJTIyJTJDJTIwJTIySGVsbG8lMkMlMjBteSUyMGNhdCUyMGlzJTIwY3V0ZSUyMCU1QkNMUyU1RCUyMiU1RCUwQWlucHV0X2lkcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJ0b2tlbml6ZXIuZW5jb2RlKHMpJTIwZm9yJTIwcyUyMGluJTIwY2hvaWNlcyU1RCkudW5zcXVlZXplKDApJTIwJTIwJTIzJTIwQmF0Y2glMjBzaXplJTIwMSUyQyUyMDIlMjBjaG9pY2VzJTBBbWNfdG9rZW5faWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QmlucHV0X2lkcy5zaXplKC0xKSUyMC0lMjAxJTJDJTIwaW5wdXRfaWRzLnNpemUoLTEpJTIwLSUyMDElNUQpLnVuc3F1ZWV6ZSgwKSUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTJDJTIwbWNfdG9rZW5faWRzJTNEbWNfdG9rZW5faWRzKSUwQWxtX2xvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBbWNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5tY19sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, OpenAIGPTDoubleHeadsModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OpenAIGPTDoubleHeadsModel.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.add_special_tokens(
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;cls_token&quot;</span>: <span class="hljs-string">&quot;[CLS]&quot;</span>}
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># Add a [CLS] to the vocabulary (we should train it also!)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.resize_token_embeddings(<span class="hljs-built_in">len</span>(tokenizer))

<span class="hljs-meta">&gt;&gt;&gt; </span>choices = [<span class="hljs-string">&quot;Hello, my dog is cute [CLS]&quot;</span>, <span class="hljs-string">&quot;Hello, my cat is cute [CLS]&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(s) <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> choices]).unsqueeze(<span class="hljs-number">0</span>)  <span class="hljs-comment"># Batch size 1, 2 choices</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mc_token_ids = torch.tensor([input_ids.size(-<span class="hljs-number">1</span>) - <span class="hljs-number">1</span>, input_ids.size(-<span class="hljs-number">1</span>) - <span class="hljs-number">1</span>]).unsqueeze(<span class="hljs-number">0</span>)  <span class="hljs-comment"># Batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, mc_token_ids=mc_token_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>lm_logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>mc_logits = outputs.mc_logits`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),M(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-kvfsh7"&&(e.textContent=g),n=i(o),y(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),w(a,o,_),T=!0},p:oe,i(o){T||(k(a.$$.fragment,o),T=!0)},o(o){v(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),$(a,o)}}}function dn(G){let e,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=g},l(n){e=p(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=g)},m(n,a){l(n,e,a)},p:oe,d(n){n&&s(e)}}}function cn(G){let e,g="Example of single-label classification:",n,a,T;return a=new kt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME9wZW5BSUdQVEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktZ3B0JTIyKSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJR1BURm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWdwdCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWQlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KCkuaXRlbSgpJTBBJTBBJTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJR1BURm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWdwdCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, OpenAIGPTForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OpenAIGPTForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OpenAIGPTForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),M(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-ykxpe4"&&(e.textContent=g),n=i(o),y(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),w(a,o,_),T=!0},p:oe,i(o){T||(k(a.$$.fragment,o),T=!0)},o(o){v(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),$(a,o)}}}function pn(G){let e,g="Example of multi-label classification:",n,a,T;return a=new kt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME9wZW5BSUdQVEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktZ3B0JTIyKSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJR1BURm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWdwdCUyMiUyQyUyMHByb2JsZW1fdHlwZSUzRCUyMm11bHRpX2xhYmVsX2NsYXNzaWZpY2F0aW9uJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZHMlMjAlM0QlMjB0b3JjaC5hcmFuZ2UoMCUyQyUyMGxvZ2l0cy5zaGFwZSU1Qi0xJTVEKSU1QnRvcmNoLnNpZ21vaWQobG9naXRzKS5zcXVlZXplKGRpbSUzRDApJTIwJTNFJTIwMC41JTVEJTBBJTBBJTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJR1BURm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb3BlbmFpLWdwdCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, OpenAIGPTForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OpenAIGPTForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OpenAIGPTForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;openai-gpt&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),M(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-1l8e32d"&&(e.textContent=g),n=i(o),y(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),w(a,o,_),T=!0},p:oe,i(o){T||(k(a.$$.fragment,o),T=!0)},o(o){v(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),$(a,o)}}}function mn(G){let e,g,n,a,T,o,_="The bare OpenAI GPT transformer model outputting raw hidden-states without any specific head on top.",se,j,C=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,R,A,O=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,E,m,P,pe,ae,Ft='The <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTModel">OpenAIGPTModel</a> forward method, overrides the <code>__call__</code> special method.',De,Me,Jt,re,Le,ye,st,H,Ue,F,He,vt=`OpenAI GPT Model transformer with a language modeling head on top (linear layer with weights tied to the input
embeddings).`,Pe,gt,$t=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,xe,_t,It=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ce,he,we,Xe,Qe,ee='The <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTLMHeadModel">OpenAIGPTLMHeadModel</a> forward method, overrides the <code>__call__</code> special method.',Be,ge,pt,Ze,Se,me,Ve,L,Je,ke,Re,W=`OpenAI GPT Model transformer with a language modeling and a multiple-choice classification head on top e.g. for
RocStories/SWAG tasks. The two heads are two linear layers. The language modeling head has its weights tied to the
input embeddings, the classification head takes as input the input of a specified classification token index in the
input sequence).`,at,Ye,Fe=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Gt,Ae,Tt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Pt,D,ve,_e,Oe,Ke='The <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a> forward method, overrides the <code>__call__</code> special method.',rt,X,et,$e,it,lt,qe,q,Ie,We,B,je=`The Original OpenAI GPT Model transformer with a sequence classification head on top (linear layer).
<a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTForSequenceClassification">OpenAIGPTForSequenceClassification</a> uses the last token in order to do the classification, as other causal
models (e.g. GPT-2) do. Since it does classification on the last token, it requires to know the position of the
last token. If a <code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding
token in each row. If no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since
it cannot guess the padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take
the last value in each row of the batch).`,bt,z,mt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,xt,Te,qt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ct,N,ut,At,be,ft='The <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTForSequenceClassification">OpenAIGPTForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Mt,te,Ot,S,ze,tt,nt;return e=new Ee({props:{title:"OpenAIGPTModel",local:"transformers.OpenAIGPTModel",headingTag:"h2"}}),a=new ce({props:{name:"class transformers.OpenAIGPTModel",anchor:"transformers.OpenAIGPTModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.OpenAIGPTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_openai.py#L398"}}),P=new ce({props:{name:"forward",anchor:"transformers.OpenAIGPTModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OpenAIGPTModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.OpenAIGPTModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.OpenAIGPTModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.OpenAIGPTModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.OpenAIGPTModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.OpenAIGPTModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.OpenAIGPTModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.OpenAIGPTModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OpenAIGPTModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_openai.py#L428",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig"
>OpenAIGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Me=new wt({props:{$$slots:{default:[nn]},$$scope:{ctx:G}}}),re=new Ht({props:{anchor:"transformers.OpenAIGPTModel.forward.example",$$slots:{default:[on]},$$scope:{ctx:G}}}),ye=new Ee({props:{title:"OpenAIGPTLMHeadModel",local:"transformers.OpenAIGPTLMHeadModel",headingTag:"h2"}}),Ue=new ce({props:{name:"class transformers.OpenAIGPTLMHeadModel",anchor:"transformers.OpenAIGPTLMHeadModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.OpenAIGPTLMHeadModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_openai.py#L526"}}),we=new ce({props:{name:"forward",anchor:"transformers.OpenAIGPTLMHeadModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OpenAIGPTLMHeadModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.OpenAIGPTLMHeadModel.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_openai.py#L550",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig"
>OpenAIGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ge=new wt({props:{$$slots:{default:[sn]},$$scope:{ctx:G}}}),Ze=new Ht({props:{anchor:"transformers.OpenAIGPTLMHeadModel.forward.example",$$slots:{default:[an]},$$scope:{ctx:G}}}),me=new Ee({props:{title:"OpenAIGPTDoubleHeadsModel",local:"transformers.OpenAIGPTDoubleHeadsModel",headingTag:"h2"}}),Je=new ce({props:{name:"class transformers.OpenAIGPTDoubleHeadsModel",anchor:"transformers.OpenAIGPTDoubleHeadsModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.OpenAIGPTDoubleHeadsModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_openai.py#L615"}}),ve=new ce({props:{name:"forward",anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"mc_token_ids",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"mc_labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.mc_token_ids",description:`<strong>mc_token_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices)</code>, <em>optional</em>, default to index of the last token of the input) &#x2014;
Index of the classification token in each input sequence. Selected in the range <code>[0, input_ids.size(-1) - 1]</code>.`,name:"mc_token_ids"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-1, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code> are
ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.mc_labels",description:`<strong>mc_labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>, <em>optional</em>) &#x2014;
Labels for computing the multiple choice classification loss. Indices should be in <code>[0, ..., num_choices]</code>
where <em>num_choices</em> is the size of the second dimension of the input tensors. (see <em>input_ids</em> above)`,name:"mc_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_openai.py#L644",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput"
>transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig"
>OpenAIGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>mc_loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>mc_labels</code> is provided) — Multiple choice classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>mc_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices)</code>) — Prediction scores of the multiple choice classification head (scores for each choice before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput"
>transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new wt({props:{$$slots:{default:[rn]},$$scope:{ctx:G}}}),$e=new Ht({props:{anchor:"transformers.OpenAIGPTDoubleHeadsModel.forward.example",$$slots:{default:[ln]},$$scope:{ctx:G}}}),lt=new Ee({props:{title:"OpenAIGPTForSequenceClassification",local:"transformers.OpenAIGPTForSequenceClassification",headingTag:"h2"}}),Ie=new ce({props:{name:"class transformers.OpenAIGPTForSequenceClassification",anchor:"transformers.OpenAIGPTForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.OpenAIGPTForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_openai.py#L740"}}),ut=new ce({props:{name:"forward",anchor:"transformers.OpenAIGPTForSequenceClassification.forward",parameters:[{name:"input_ids",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_openai.py#L762",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig"
>OpenAIGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),te=new wt({props:{$$slots:{default:[dn]},$$scope:{ctx:G}}}),S=new Ht({props:{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.example",$$slots:{default:[cn]},$$scope:{ctx:G}}}),tt=new Ht({props:{anchor:"transformers.OpenAIGPTForSequenceClassification.forward.example-2",$$slots:{default:[pn]},$$scope:{ctx:G}}}),{c(){M(e.$$.fragment),g=r(),n=c("div"),M(a.$$.fragment),T=r(),o=c("p"),o.textContent=_,se=r(),j=c("p"),j.innerHTML=C,R=r(),A=c("p"),A.innerHTML=O,E=r(),m=c("div"),M(P.$$.fragment),pe=r(),ae=c("p"),ae.innerHTML=Ft,De=r(),M(Me.$$.fragment),Jt=r(),M(re.$$.fragment),Le=r(),M(ye.$$.fragment),st=r(),H=c("div"),M(Ue.$$.fragment),F=r(),He=c("p"),He.textContent=vt,Pe=r(),gt=c("p"),gt.innerHTML=$t,xe=r(),_t=c("p"),_t.innerHTML=It,Ce=r(),he=c("div"),M(we.$$.fragment),Xe=r(),Qe=c("p"),Qe.innerHTML=ee,Be=r(),M(ge.$$.fragment),pt=r(),M(Ze.$$.fragment),Se=r(),M(me.$$.fragment),Ve=r(),L=c("div"),M(Je.$$.fragment),ke=r(),Re=c("p"),Re.textContent=W,at=r(),Ye=c("p"),Ye.innerHTML=Fe,Gt=r(),Ae=c("p"),Ae.innerHTML=Tt,Pt=r(),D=c("div"),M(ve.$$.fragment),_e=r(),Oe=c("p"),Oe.innerHTML=Ke,rt=r(),M(X.$$.fragment),et=r(),M($e.$$.fragment),it=r(),M(lt.$$.fragment),qe=r(),q=c("div"),M(Ie.$$.fragment),We=r(),B=c("p"),B.innerHTML=je,bt=r(),z=c("p"),z.innerHTML=mt,xt=r(),Te=c("p"),Te.innerHTML=qt,Ct=r(),N=c("div"),M(ut.$$.fragment),At=r(),be=c("p"),be.innerHTML=ft,Mt=r(),M(te.$$.fragment),Ot=r(),M(S.$$.fragment),ze=r(),M(tt.$$.fragment),this.h()},l(f){y(e.$$.fragment,f),g=i(f),n=p(f,"DIV",{class:!0});var x=K(n);y(a.$$.fragment,x),T=i(x),o=p(x,"P",{"data-svelte-h":!0}),h(o)!=="svelte-147bz4w"&&(o.textContent=_),se=i(x),j=p(x,"P",{"data-svelte-h":!0}),h(j)!=="svelte-6pahdo"&&(j.innerHTML=C),R=i(x),A=p(x,"P",{"data-svelte-h":!0}),h(A)!=="svelte-hswkmf"&&(A.innerHTML=O),E=i(x),m=p(x,"DIV",{class:!0});var U=K(m);y(P.$$.fragment,U),pe=i(U),ae=p(U,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-jrv8td"&&(ae.innerHTML=Ft),De=i(U),y(Me.$$.fragment,U),Jt=i(U),y(re.$$.fragment,U),U.forEach(s),x.forEach(s),Le=i(f),y(ye.$$.fragment,f),st=i(f),H=p(f,"DIV",{class:!0});var Q=K(H);y(Ue.$$.fragment,Q),F=i(Q),He=p(Q,"P",{"data-svelte-h":!0}),h(He)!=="svelte-w06qmh"&&(He.textContent=vt),Pe=i(Q),gt=p(Q,"P",{"data-svelte-h":!0}),h(gt)!=="svelte-6pahdo"&&(gt.innerHTML=$t),xe=i(Q),_t=p(Q,"P",{"data-svelte-h":!0}),h(_t)!=="svelte-hswkmf"&&(_t.innerHTML=It),Ce=i(Q),he=p(Q,"DIV",{class:!0});var Ge=K(he);y(we.$$.fragment,Ge),Xe=i(Ge),Qe=p(Ge,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-51z97r"&&(Qe.innerHTML=ee),Be=i(Ge),y(ge.$$.fragment,Ge),pt=i(Ge),y(Ze.$$.fragment,Ge),Ge.forEach(s),Q.forEach(s),Se=i(f),y(me.$$.fragment,f),Ve=i(f),L=p(f,"DIV",{class:!0});var Z=K(L);y(Je.$$.fragment,Z),ke=i(Z),Re=p(Z,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-1iaobcj"&&(Re.textContent=W),at=i(Z),Ye=p(Z,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-6pahdo"&&(Ye.innerHTML=Fe),Gt=i(Z),Ae=p(Z,"P",{"data-svelte-h":!0}),h(Ae)!=="svelte-hswkmf"&&(Ae.innerHTML=Tt),Pt=i(Z),D=p(Z,"DIV",{class:!0});var Ne=K(D);y(ve.$$.fragment,Ne),_e=i(Ne),Oe=p(Ne,"P",{"data-svelte-h":!0}),h(Oe)!=="svelte-1n22rdl"&&(Oe.innerHTML=Ke),rt=i(Ne),y(X.$$.fragment,Ne),et=i(Ne),y($e.$$.fragment,Ne),Ne.forEach(s),Z.forEach(s),it=i(f),y(lt.$$.fragment,f),qe=i(f),q=p(f,"DIV",{class:!0});var ie=K(q);y(Ie.$$.fragment,ie),We=i(ie),B=p(ie,"P",{"data-svelte-h":!0}),h(B)!=="svelte-15004d8"&&(B.innerHTML=je),bt=i(ie),z=p(ie,"P",{"data-svelte-h":!0}),h(z)!=="svelte-6pahdo"&&(z.innerHTML=mt),xt=i(ie),Te=p(ie,"P",{"data-svelte-h":!0}),h(Te)!=="svelte-hswkmf"&&(Te.innerHTML=qt),Ct=i(ie),N=p(ie,"DIV",{class:!0});var J=K(N);y(ut.$$.fragment,J),At=i(J),be=p(J,"P",{"data-svelte-h":!0}),h(be)!=="svelte-19za2a3"&&(be.innerHTML=ft),Mt=i(J),y(te.$$.fragment,J),Ot=i(J),y(S.$$.fragment,J),ze=i(J),y(tt.$$.fragment,J),J.forEach(s),ie.forEach(s),this.h()},h(){V(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(f,x){w(e,f,x),l(f,g,x),l(f,n,x),w(a,n,null),d(n,T),d(n,o),d(n,se),d(n,j),d(n,R),d(n,A),d(n,E),d(n,m),w(P,m,null),d(m,pe),d(m,ae),d(m,De),w(Me,m,null),d(m,Jt),w(re,m,null),l(f,Le,x),w(ye,f,x),l(f,st,x),l(f,H,x),w(Ue,H,null),d(H,F),d(H,He),d(H,Pe),d(H,gt),d(H,xe),d(H,_t),d(H,Ce),d(H,he),w(we,he,null),d(he,Xe),d(he,Qe),d(he,Be),w(ge,he,null),d(he,pt),w(Ze,he,null),l(f,Se,x),w(me,f,x),l(f,Ve,x),l(f,L,x),w(Je,L,null),d(L,ke),d(L,Re),d(L,at),d(L,Ye),d(L,Gt),d(L,Ae),d(L,Pt),d(L,D),w(ve,D,null),d(D,_e),d(D,Oe),d(D,rt),w(X,D,null),d(D,et),w($e,D,null),l(f,it,x),w(lt,f,x),l(f,qe,x),l(f,q,x),w(Ie,q,null),d(q,We),d(q,B),d(q,bt),d(q,z),d(q,xt),d(q,Te),d(q,Ct),d(q,N),w(ut,N,null),d(N,At),d(N,be),d(N,Mt),w(te,N,null),d(N,Ot),w(S,N,null),d(N,ze),w(tt,N,null),nt=!0},p(f,x){const U={};x&2&&(U.$$scope={dirty:x,ctx:f}),Me.$set(U);const Q={};x&2&&(Q.$$scope={dirty:x,ctx:f}),re.$set(Q);const Ge={};x&2&&(Ge.$$scope={dirty:x,ctx:f}),ge.$set(Ge);const Z={};x&2&&(Z.$$scope={dirty:x,ctx:f}),Ze.$set(Z);const Ne={};x&2&&(Ne.$$scope={dirty:x,ctx:f}),X.$set(Ne);const ie={};x&2&&(ie.$$scope={dirty:x,ctx:f}),$e.$set(ie);const J={};x&2&&(J.$$scope={dirty:x,ctx:f}),te.$set(J);const jt={};x&2&&(jt.$$scope={dirty:x,ctx:f}),S.$set(jt);const ue={};x&2&&(ue.$$scope={dirty:x,ctx:f}),tt.$set(ue)},i(f){nt||(k(e.$$.fragment,f),k(a.$$.fragment,f),k(P.$$.fragment,f),k(Me.$$.fragment,f),k(re.$$.fragment,f),k(ye.$$.fragment,f),k(Ue.$$.fragment,f),k(we.$$.fragment,f),k(ge.$$.fragment,f),k(Ze.$$.fragment,f),k(me.$$.fragment,f),k(Je.$$.fragment,f),k(ve.$$.fragment,f),k(X.$$.fragment,f),k($e.$$.fragment,f),k(lt.$$.fragment,f),k(Ie.$$.fragment,f),k(ut.$$.fragment,f),k(te.$$.fragment,f),k(S.$$.fragment,f),k(tt.$$.fragment,f),nt=!0)},o(f){v(e.$$.fragment,f),v(a.$$.fragment,f),v(P.$$.fragment,f),v(Me.$$.fragment,f),v(re.$$.fragment,f),v(ye.$$.fragment,f),v(Ue.$$.fragment,f),v(we.$$.fragment,f),v(ge.$$.fragment,f),v(Ze.$$.fragment,f),v(me.$$.fragment,f),v(Je.$$.fragment,f),v(ve.$$.fragment,f),v(X.$$.fragment,f),v($e.$$.fragment,f),v(lt.$$.fragment,f),v(Ie.$$.fragment,f),v(ut.$$.fragment,f),v(te.$$.fragment,f),v(S.$$.fragment,f),v(tt.$$.fragment,f),nt=!1},d(f){f&&(s(g),s(n),s(Le),s(st),s(H),s(Se),s(Ve),s(L),s(it),s(qe),s(q)),$(e,f),$(a),$(P),$(Me),$(re),$(ye,f),$(Ue),$(we),$(ge),$(Ze),$(me,f),$(Je),$(ve),$(X),$($e),$(lt,f),$(Ie),$(ut),$(te),$(S),$(tt)}}}function un(G){let e,g;return e=new Et({props:{$$slots:{default:[mn]},$$scope:{ctx:G}}}),{c(){M(e.$$.fragment)},l(n){y(e.$$.fragment,n)},m(n,a){w(e,n,a),g=!0},p(n,a){const T={};a&2&&(T.$$scope={dirty:a,ctx:n}),e.$set(T)},i(n){g||(k(e.$$.fragment,n),g=!0)},o(n){v(e.$$.fragment,n),g=!1},d(n){$(e,n)}}}function fn(G){let e,g="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,a,T="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,_,se=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,j,C,R=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,A,O,E=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=c("p"),e.innerHTML=g,n=r(),a=c("ul"),a.innerHTML=T,o=r(),_=c("p"),_.innerHTML=se,j=r(),C=c("ul"),C.innerHTML=R,A=r(),O=c("p"),O.innerHTML=E},l(m){e=p(m,"P",{"data-svelte-h":!0}),h(e)!=="svelte-1ajbfxg"&&(e.innerHTML=g),n=i(m),a=p(m,"UL",{"data-svelte-h":!0}),h(a)!=="svelte-qm1t26"&&(a.innerHTML=T),o=i(m),_=p(m,"P",{"data-svelte-h":!0}),h(_)!=="svelte-1v9qsc5"&&(_.innerHTML=se),j=i(m),C=p(m,"UL",{"data-svelte-h":!0}),h(C)!=="svelte-15scerc"&&(C.innerHTML=R),A=i(m),O=p(m,"P",{"data-svelte-h":!0}),h(O)!=="svelte-1an3odd"&&(O.innerHTML=E)},m(m,P){l(m,e,P),l(m,n,P),l(m,a,P),l(m,o,P),l(m,_,P),l(m,j,P),l(m,C,P),l(m,A,P),l(m,O,P)},p:oe,d(m){m&&(s(e),s(n),s(a),s(o),s(_),s(j),s(C),s(A),s(O))}}}function hn(G){let e,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=g},l(n){e=p(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=g)},m(n,a){l(n,e,a)},p:oe,d(n){n&&s(e)}}}function gn(G){let e,g="Example:",n,a,T;return a=new kt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURk9wZW5BSUdQVE1vZGVsJTBBaW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktZ3B0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZPcGVuQUlHUFRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWdwdCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFOpenAIGPTModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFOpenAIGPTModel.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),M(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=g),n=i(o),y(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),w(a,o,_),T=!0},p:oe,i(o){T||(k(a.$$.fragment,o),T=!0)},o(o){v(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),$(a,o)}}}function _n(G){let e,g="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,a,T="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,_,se=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,j,C,R=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,A,O,E=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=c("p"),e.innerHTML=g,n=r(),a=c("ul"),a.innerHTML=T,o=r(),_=c("p"),_.innerHTML=se,j=r(),C=c("ul"),C.innerHTML=R,A=r(),O=c("p"),O.innerHTML=E},l(m){e=p(m,"P",{"data-svelte-h":!0}),h(e)!=="svelte-1ajbfxg"&&(e.innerHTML=g),n=i(m),a=p(m,"UL",{"data-svelte-h":!0}),h(a)!=="svelte-qm1t26"&&(a.innerHTML=T),o=i(m),_=p(m,"P",{"data-svelte-h":!0}),h(_)!=="svelte-1v9qsc5"&&(_.innerHTML=se),j=i(m),C=p(m,"UL",{"data-svelte-h":!0}),h(C)!=="svelte-15scerc"&&(C.innerHTML=R),A=i(m),O=p(m,"P",{"data-svelte-h":!0}),h(O)!=="svelte-1an3odd"&&(O.innerHTML=E)},m(m,P){l(m,e,P),l(m,n,P),l(m,a,P),l(m,o,P),l(m,_,P),l(m,j,P),l(m,C,P),l(m,A,P),l(m,O,P)},p:oe,d(m){m&&(s(e),s(n),s(a),s(o),s(_),s(j),s(C),s(A),s(O))}}}function Tn(G){let e,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=g},l(n){e=p(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=g)},m(n,a){l(n,e,a)},p:oe,d(n){n&&s(e)}}}function bn(G){let e,g="Example:",n,a,T;return a=new kt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURk9wZW5BSUdQVExNSGVhZE1vZGVsJTBBaW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktZ3B0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZPcGVuQUlHUFRMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWdwdCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFOpenAIGPTLMHeadModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFOpenAIGPTLMHeadModel.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),M(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=g),n=i(o),y(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),w(a,o,_),T=!0},p:oe,i(o){T||(k(a.$$.fragment,o),T=!0)},o(o){v(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),$(a,o)}}}function Mn(G){let e,g="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,a,T="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,_,se=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,j,C,R=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,A,O,E=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=c("p"),e.innerHTML=g,n=r(),a=c("ul"),a.innerHTML=T,o=r(),_=c("p"),_.innerHTML=se,j=r(),C=c("ul"),C.innerHTML=R,A=r(),O=c("p"),O.innerHTML=E},l(m){e=p(m,"P",{"data-svelte-h":!0}),h(e)!=="svelte-1ajbfxg"&&(e.innerHTML=g),n=i(m),a=p(m,"UL",{"data-svelte-h":!0}),h(a)!=="svelte-qm1t26"&&(a.innerHTML=T),o=i(m),_=p(m,"P",{"data-svelte-h":!0}),h(_)!=="svelte-1v9qsc5"&&(_.innerHTML=se),j=i(m),C=p(m,"UL",{"data-svelte-h":!0}),h(C)!=="svelte-15scerc"&&(C.innerHTML=R),A=i(m),O=p(m,"P",{"data-svelte-h":!0}),h(O)!=="svelte-1an3odd"&&(O.innerHTML=E)},m(m,P){l(m,e,P),l(m,n,P),l(m,a,P),l(m,o,P),l(m,_,P),l(m,j,P),l(m,C,P),l(m,A,P),l(m,O,P)},p:oe,d(m){m&&(s(e),s(n),s(a),s(o),s(_),s(j),s(C),s(A),s(O))}}}function yn(G){let e,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=g},l(n){e=p(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=g)},m(n,a){l(n,e,a)},p:oe,d(n){n&&s(e)}}}function wn(G){let e,g="Examples:",n,a,T;return a=new kt({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGT3BlbkFJR1BURG91YmxlSGVhZHNNb2RlbCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1ncHQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURk9wZW5BSUdQVERvdWJsZUhlYWRzTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1ncHQlMjIpJTBBJTBBJTIzJTIwQWRkJTIwYSUyMCU1QkNMUyU1RCUyMHRvJTIwdGhlJTIwdm9jYWJ1bGFyeSUyMCh3ZSUyMHNob3VsZCUyMHRyYWluJTIwaXQlMjBhbHNvISklMEF0b2tlbml6ZXIuYWRkX3NwZWNpYWxfdG9rZW5zKCU3QiUyMmNsc190b2tlbiUyMiUzQSUyMCUyMiU1QkNMUyU1RCUyMiU3RCklMEFtb2RlbC5yZXNpemVfdG9rZW5fZW1iZWRkaW5ncyhsZW4odG9rZW5pemVyKSklMjAlMjAlMjMlMjBVcGRhdGUlMjB0aGUlMjBtb2RlbCUyMGVtYmVkZGluZ3MlMjB3aXRoJTIwdGhlJTIwbmV3JTIwdm9jYWJ1bGFyeSUyMHNpemUlMEFwcmludCh0b2tlbml6ZXIuY2xzX3Rva2VuX2lkJTJDJTIwbGVuKHRva2VuaXplcikpJTIwJTIwJTIzJTIwVGhlJTIwbmV3bHklMjB0b2tlbiUyMHRoZSUyMGxhc3QlMjB0b2tlbiUyMG9mJTIwdGhlJTIwdm9jYWJ1bGFyeSUwQSUwQWNob2ljZXMlMjAlM0QlMjAlNUIlMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIwJTVCQ0xTJTVEJTIyJTJDJTIwJTIySGVsbG8lMkMlMjBteSUyMGNhdCUyMGlzJTIwY3V0ZSUyMCU1QkNMUyU1RCUyMiU1RCUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyKGNob2ljZXMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQWlucHV0cyUyMCUzRCUyMCU3QmslM0ElMjB0Zi5leHBhbmRfZGltcyh2JTJDJTIwMCklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwZW5jb2RpbmcuaXRlbXMoKSU3RCUwQWlucHV0cyU1QiUyMm1jX3Rva2VuX2lkcyUyMiU1RCUyMCUzRCUyMHRmLmNvbnN0YW50KCUwQSUyMCUyMCUyMCUyMCU1QmlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RC5zaGFwZSU1Qi0xJTVEJTIwLSUyMDElMkMlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQuc2hhcGUlNUItMSU1RCUyMC0lMjAxJTVEJTBBKSU1QiUwQSUyMCUyMCUyMCUyME5vbmUlMkMlMjAlM0ElMEElNUQlMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEFsbV9wcmVkaWN0aW9uX3Njb3JlcyUyQyUyMG1jX3ByZWRpY3Rpb25fc2NvcmVzJTIwJTNEJTIwb3V0cHV0cyU1QiUzQTIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFOpenAIGPTDoubleHeadsModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFOpenAIGPTDoubleHeadsModel.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Add a [CLS] to the vocabulary (we should train it also!)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.add_special_tokens({<span class="hljs-string">&quot;cls_token&quot;</span>: <span class="hljs-string">&quot;[CLS]&quot;</span>})
<span class="hljs-meta">&gt;&gt;&gt; </span>model.resize_token_embeddings(<span class="hljs-built_in">len</span>(tokenizer))  <span class="hljs-comment"># Update the model embeddings with the new vocabulary size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.cls_token_id, <span class="hljs-built_in">len</span>(tokenizer))  <span class="hljs-comment"># The newly token the last token of the vocabulary</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>choices = [<span class="hljs-string">&quot;Hello, my dog is cute [CLS]&quot;</span>, <span class="hljs-string">&quot;Hello, my cat is cute [CLS]&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(choices, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = {k: tf.expand_dims(v, <span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items()}
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;mc_token_ids&quot;</span>] = tf.constant(
<span class="hljs-meta">... </span>    [inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>] - <span class="hljs-number">1</span>, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>] - <span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>)[
<span class="hljs-meta">... </span>    <span class="hljs-literal">None</span>, :
<span class="hljs-meta">... </span>]  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>lm_prediction_scores, mc_prediction_scores = outputs[:<span class="hljs-number">2</span>]`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),M(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-kvfsh7"&&(e.textContent=g),n=i(o),y(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),w(a,o,_),T=!0},p:oe,i(o){T||(k(a.$$.fragment,o),T=!0)},o(o){v(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),$(a,o)}}}function kn(G){let e,g="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,a,T="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,_,se=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,j,C,R=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,A,O,E=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){e=c("p"),e.innerHTML=g,n=r(),a=c("ul"),a.innerHTML=T,o=r(),_=c("p"),_.innerHTML=se,j=r(),C=c("ul"),C.innerHTML=R,A=r(),O=c("p"),O.innerHTML=E},l(m){e=p(m,"P",{"data-svelte-h":!0}),h(e)!=="svelte-1ajbfxg"&&(e.innerHTML=g),n=i(m),a=p(m,"UL",{"data-svelte-h":!0}),h(a)!=="svelte-qm1t26"&&(a.innerHTML=T),o=i(m),_=p(m,"P",{"data-svelte-h":!0}),h(_)!=="svelte-1v9qsc5"&&(_.innerHTML=se),j=i(m),C=p(m,"UL",{"data-svelte-h":!0}),h(C)!=="svelte-15scerc"&&(C.innerHTML=R),A=i(m),O=p(m,"P",{"data-svelte-h":!0}),h(O)!=="svelte-1an3odd"&&(O.innerHTML=E)},m(m,P){l(m,e,P),l(m,n,P),l(m,a,P),l(m,o,P),l(m,_,P),l(m,j,P),l(m,C,P),l(m,A,P),l(m,O,P)},p:oe,d(m){m&&(s(e),s(n),s(a),s(o),s(_),s(j),s(C),s(A),s(O))}}}function vn(G){let e,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=c("p"),e.innerHTML=g},l(n){e=p(n,"P",{"data-svelte-h":!0}),h(e)!=="svelte-fincs2"&&(e.innerHTML=g)},m(n,a){l(n,e,a)},p:oe,d(n){n&&s(e)}}}function $n(G){let e,g="Example:",n,a,T;return a=new kt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURk9wZW5BSUdQVEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1ncHQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURk9wZW5BSUdQVEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1ncHQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQSUwQWxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWQlMjAlM0QlMjBpbnQodGYubWF0aC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFOpenAIGPTForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFOpenAIGPTForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>])`,wrap:!1}}),{c(){e=c("p"),e.textContent=g,n=r(),M(a.$$.fragment)},l(o){e=p(o,"P",{"data-svelte-h":!0}),h(e)!=="svelte-11lpom8"&&(e.textContent=g),n=i(o),y(a.$$.fragment,o)},m(o,_){l(o,e,_),l(o,n,_),w(a,o,_),T=!0},p:oe,i(o){T||(k(a.$$.fragment,o),T=!0)},o(o){v(a.$$.fragment,o),T=!1},d(o){o&&(s(e),s(n)),$(a,o)}}}function In(G){let e,g;return e=new kt({props:{code:"JTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwVEZPcGVuQUlHUFRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktZ3B0JTIyJTJDJTIwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdGYuY29uc3RhbnQoMSklMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3M=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on `num_labels` classes, you can pass `num_labels=num_labels` to `.from_pretrained(...)`</span>\n<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)\n<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFOpenAIGPTForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;openai-gpt&quot;</span>, num_labels=num_labels)\n\n<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tf.constant(<span class="hljs-number">1</span>)\n<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss',wrap:!1}}),{c(){M(e.$$.fragment)},l(n){y(e.$$.fragment,n)},m(n,a){w(e,n,a),g=!0},p:oe,i(n){g||(k(e.$$.fragment,n),g=!0)},o(n){v(e.$$.fragment,n),g=!1},d(n){$(e,n)}}}function Gn(G){let e,g,n,a,T,o,_="The bare OpenAI GPT transformer model outputting raw hidden-states without any specific head on top.",se,j,C=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,R,A,O=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,E,m,P,pe,ae,Ft,De,Me='The <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.TFOpenAIGPTModel">TFOpenAIGPTModel</a> forward method, overrides the <code>__call__</code> special method.',Jt,re,Le,ye,st,H,Ue,F,He,vt,Pe,gt=`OpenAI GPT Model transformer with a language modeling head on top (linear layer with weights tied to the input
embeddings).`,$t,xe,_t=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,It,Ce,he=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,we,Xe,Qe,ee,Be,ge,pt,Ze='The <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.TFOpenAIGPTLMHeadModel">TFOpenAIGPTLMHeadModel</a> forward method, overrides the <code>__call__</code> special method.',Se,me,Ve,L,Je,ke,Re,W,at,Ye,Fe,Gt=`OpenAI GPT Model transformer with a language modeling and a multiple-choice classification head on top e.g. for
RocStories/SWAG tasks. The two heads are two linear layers. The language modeling head has its weights tied to the
input embeddings, the classification head takes as input the input of a specified classification token index in the
input sequence).`,Ae,Tt,Pt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,D,ve,_e=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,Oe,Ke,rt,X,et,$e,it,lt='The <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.TFOpenAIGPTDoubleHeadsModel">TFOpenAIGPTDoubleHeadsModel</a> forward method, overrides the <code>__call__</code> special method.',qe,q,Ie,We,B,je,bt,z,mt,xt,Te,qt="The OpenAI GPT Model transformer with a sequence classification head on top (linear layer).",Ct,N,ut=`<a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.TFOpenAIGPTForSequenceClassification">TFOpenAIGPTForSequenceClassification</a> uses the last token in order to do the classification, as other causal
models (e.g. GPT-2) do.`,At,be,ft=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,Mt,te,Ot=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,S,ze,tt=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,nt,f,x,U,Q,Ge,Z,Ne='The <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.TFOpenAIGPTForSequenceClassification">TFOpenAIGPTForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',ie,J,jt,ue,zt,yt,Ut;return e=new Ee({props:{title:"TFOpenAIGPTModel",local:"transformers.TFOpenAIGPTModel",headingTag:"h2"}}),a=new ce({props:{name:"class transformers.TFOpenAIGPTModel",anchor:"transformers.TFOpenAIGPTModel",parameters:[{name:"config",val:""},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFOpenAIGPTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_tf_openai.py#L540"}}),m=new wt({props:{$$slots:{default:[fn]},$$scope:{ctx:G}}}),ae=new ce({props:{name:"call",anchor:"transformers.TFOpenAIGPTModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFOpenAIGPTModel.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFOpenAIGPTModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFOpenAIGPTModel.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFOpenAIGPTModel.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFOpenAIGPTModel.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFOpenAIGPTModel.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFOpenAIGPTModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFOpenAIGPTModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFOpenAIGPTModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFOpenAIGPTModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_tf_openai.py#L549",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutput"
>transformers.modeling_tf_outputs.TFBaseModelOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig"
>OpenAIGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutput"
>transformers.modeling_tf_outputs.TFBaseModelOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),re=new wt({props:{$$slots:{default:[hn]},$$scope:{ctx:G}}}),ye=new Ht({props:{anchor:"transformers.TFOpenAIGPTModel.call.example",$$slots:{default:[gn]},$$scope:{ctx:G}}}),H=new Ee({props:{title:"TFOpenAIGPTLMHeadModel",local:"transformers.TFOpenAIGPTLMHeadModel",headingTag:"h2"}}),He=new ce({props:{name:"class transformers.TFOpenAIGPTLMHeadModel",anchor:"transformers.TFOpenAIGPTLMHeadModel",parameters:[{name:"config",val:""},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFOpenAIGPTLMHeadModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_tf_openai.py#L592"}}),Xe=new wt({props:{$$slots:{default:[_n]},$$scope:{ctx:G}}}),Be=new ce({props:{name:"call",anchor:"transformers.TFOpenAIGPTLMHeadModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the cross entropy classification loss. Indices should be in <code>[0, ..., config.vocab_size - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_tf_openai.py#L612",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutput"
>transformers.modeling_tf_outputs.TFCausalLMOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig"
>OpenAIGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutput"
>transformers.modeling_tf_outputs.TFCausalLMOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),me=new wt({props:{$$slots:{default:[Tn]},$$scope:{ctx:G}}}),L=new Ht({props:{anchor:"transformers.TFOpenAIGPTLMHeadModel.call.example",$$slots:{default:[bn]},$$scope:{ctx:G}}}),ke=new Ee({props:{title:"TFOpenAIGPTDoubleHeadsModel",local:"transformers.TFOpenAIGPTDoubleHeadsModel",headingTag:"h2"}}),at=new ce({props:{name:"class transformers.TFOpenAIGPTDoubleHeadsModel",anchor:"transformers.TFOpenAIGPTDoubleHeadsModel",parameters:[{name:"config",val:""},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_tf_openai.py#L685"}}),Ke=new wt({props:{$$slots:{default:[Mn]},$$scope:{ctx:G}}}),et=new ce({props:{name:"call",anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"mc_token_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.mc_token_ids",description:`<strong>mc_token_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, num_choices)</code>, <em>optional</em>, default to index of the last token of the input) &#x2014;
Index of the classification token in each input sequence. Selected in the range <code>[0, input_ids.size(-1) - 1]</code>.`,name:"mc_token_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_tf_openai.py#L703",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput"
>transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig"
>OpenAIGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>mc_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_choices)</code>) — Prediction scores of the multiple choice classification head (scores for each choice before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput"
>transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),q=new wt({props:{$$slots:{default:[yn]},$$scope:{ctx:G}}}),We=new Ht({props:{anchor:"transformers.TFOpenAIGPTDoubleHeadsModel.call.example",$$slots:{default:[wn]},$$scope:{ctx:G}}}),je=new Ee({props:{title:"TFOpenAIGPTForSequenceClassification",local:"transformers.TFOpenAIGPTForSequenceClassification",headingTag:"h2"}}),mt=new ce({props:{name:"class transformers.TFOpenAIGPTForSequenceClassification",anchor:"transformers.TFOpenAIGPTForSequenceClassification",parameters:[{name:"config",val:""},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFOpenAIGPTForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig">OpenAIGPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_tf_openai.py#L817"}}),f=new wt({props:{$$slots:{default:[kn]},$$scope:{ctx:G}}}),Q=new ce({props:{name:"call",anchor:"transformers.TFOpenAIGPTForSequenceClassification.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the cross entropy classification loss. Indices should be in <code>[0, ..., config.vocab_size - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_tf_openai.py#L845",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTConfig"
>OpenAIGPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),J=new wt({props:{$$slots:{default:[vn]},$$scope:{ctx:G}}}),ue=new Ht({props:{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.example",$$slots:{default:[$n]},$$scope:{ctx:G}}}),yt=new Ht({props:{anchor:"transformers.TFOpenAIGPTForSequenceClassification.call.example-2",$$slots:{default:[In]},$$scope:{ctx:G}}}),{c(){M(e.$$.fragment),g=r(),n=c("div"),M(a.$$.fragment),T=r(),o=c("p"),o.textContent=_,se=r(),j=c("p"),j.innerHTML=C,R=r(),A=c("p"),A.innerHTML=O,E=r(),M(m.$$.fragment),P=r(),pe=c("div"),M(ae.$$.fragment),Ft=r(),De=c("p"),De.innerHTML=Me,Jt=r(),M(re.$$.fragment),Le=r(),M(ye.$$.fragment),st=r(),M(H.$$.fragment),Ue=r(),F=c("div"),M(He.$$.fragment),vt=r(),Pe=c("p"),Pe.textContent=gt,$t=r(),xe=c("p"),xe.innerHTML=_t,It=r(),Ce=c("p"),Ce.innerHTML=he,we=r(),M(Xe.$$.fragment),Qe=r(),ee=c("div"),M(Be.$$.fragment),ge=r(),pt=c("p"),pt.innerHTML=Ze,Se=r(),M(me.$$.fragment),Ve=r(),M(L.$$.fragment),Je=r(),M(ke.$$.fragment),Re=r(),W=c("div"),M(at.$$.fragment),Ye=r(),Fe=c("p"),Fe.textContent=Gt,Ae=r(),Tt=c("p"),Tt.innerHTML=Pt,D=r(),ve=c("p"),ve.innerHTML=_e,Oe=r(),M(Ke.$$.fragment),rt=r(),X=c("div"),M(et.$$.fragment),$e=r(),it=c("p"),it.innerHTML=lt,qe=r(),M(q.$$.fragment),Ie=r(),M(We.$$.fragment),B=r(),M(je.$$.fragment),bt=r(),z=c("div"),M(mt.$$.fragment),xt=r(),Te=c("p"),Te.textContent=qt,Ct=r(),N=c("p"),N.innerHTML=ut,At=r(),be=c("p"),be.innerHTML=ft,Mt=r(),te=c("p"),te.innerHTML=Ot,S=r(),ze=c("p"),ze.innerHTML=tt,nt=r(),M(f.$$.fragment),x=r(),U=c("div"),M(Q.$$.fragment),Ge=r(),Z=c("p"),Z.innerHTML=Ne,ie=r(),M(J.$$.fragment),jt=r(),M(ue.$$.fragment),zt=r(),M(yt.$$.fragment),this.h()},l(u){y(e.$$.fragment,u),g=i(u),n=p(u,"DIV",{class:!0});var I=K(n);y(a.$$.fragment,I),T=i(I),o=p(I,"P",{"data-svelte-h":!0}),h(o)!=="svelte-147bz4w"&&(o.textContent=_),se=i(I),j=p(I,"P",{"data-svelte-h":!0}),h(j)!=="svelte-1qaxm70"&&(j.innerHTML=C),R=i(I),A=p(I,"P",{"data-svelte-h":!0}),h(A)!=="svelte-1ivrf8m"&&(A.innerHTML=O),E=i(I),y(m.$$.fragment,I),P=i(I),pe=p(I,"DIV",{class:!0});var fe=K(pe);y(ae.$$.fragment,fe),Ft=i(fe),De=p(fe,"P",{"data-svelte-h":!0}),h(De)!=="svelte-1uautgh"&&(De.innerHTML=Me),Jt=i(fe),y(re.$$.fragment,fe),Le=i(fe),y(ye.$$.fragment,fe),fe.forEach(s),I.forEach(s),st=i(u),y(H.$$.fragment,u),Ue=i(u),F=p(u,"DIV",{class:!0});var ne=K(F);y(He.$$.fragment,ne),vt=i(ne),Pe=p(ne,"P",{"data-svelte-h":!0}),h(Pe)!=="svelte-w06qmh"&&(Pe.textContent=gt),$t=i(ne),xe=p(ne,"P",{"data-svelte-h":!0}),h(xe)!=="svelte-1qaxm70"&&(xe.innerHTML=_t),It=i(ne),Ce=p(ne,"P",{"data-svelte-h":!0}),h(Ce)!=="svelte-1ivrf8m"&&(Ce.innerHTML=he),we=i(ne),y(Xe.$$.fragment,ne),Qe=i(ne),ee=p(ne,"DIV",{class:!0});var ot=K(ee);y(Be.$$.fragment,ot),ge=i(ot),pt=p(ot,"P",{"data-svelte-h":!0}),h(pt)!=="svelte-xqodf7"&&(pt.innerHTML=Ze),Se=i(ot),y(me.$$.fragment,ot),Ve=i(ot),y(L.$$.fragment,ot),ot.forEach(s),ne.forEach(s),Je=i(u),y(ke.$$.fragment,u),Re=i(u),W=p(u,"DIV",{class:!0});var le=K(W);y(at.$$.fragment,le),Ye=i(le),Fe=p(le,"P",{"data-svelte-h":!0}),h(Fe)!=="svelte-1iaobcj"&&(Fe.textContent=Gt),Ae=i(le),Tt=p(le,"P",{"data-svelte-h":!0}),h(Tt)!=="svelte-1qaxm70"&&(Tt.innerHTML=Pt),D=i(le),ve=p(le,"P",{"data-svelte-h":!0}),h(ve)!=="svelte-1ivrf8m"&&(ve.innerHTML=_e),Oe=i(le),y(Ke.$$.fragment,le),rt=i(le),X=p(le,"DIV",{class:!0});var dt=K(X);y(et.$$.fragment,dt),$e=i(dt),it=p(dt,"P",{"data-svelte-h":!0}),h(it)!=="svelte-76049"&&(it.innerHTML=lt),qe=i(dt),y(q.$$.fragment,dt),Ie=i(dt),y(We.$$.fragment,dt),dt.forEach(s),le.forEach(s),B=i(u),y(je.$$.fragment,u),bt=i(u),z=p(u,"DIV",{class:!0});var Y=K(z);y(mt.$$.fragment,Y),xt=i(Y),Te=p(Y,"P",{"data-svelte-h":!0}),h(Te)!=="svelte-1t263g7"&&(Te.textContent=qt),Ct=i(Y),N=p(Y,"P",{"data-svelte-h":!0}),h(N)!=="svelte-1hw2w86"&&(N.innerHTML=ut),At=i(Y),be=p(Y,"P",{"data-svelte-h":!0}),h(be)!=="svelte-10ugs3m"&&(be.innerHTML=ft),Mt=i(Y),te=p(Y,"P",{"data-svelte-h":!0}),h(te)!=="svelte-1qaxm70"&&(te.innerHTML=Ot),S=i(Y),ze=p(Y,"P",{"data-svelte-h":!0}),h(ze)!=="svelte-1ivrf8m"&&(ze.innerHTML=tt),nt=i(Y),y(f.$$.fragment,Y),x=i(Y),U=p(Y,"DIV",{class:!0});var de=K(U);y(Q.$$.fragment,de),Ge=i(de),Z=p(de,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-11j7fmf"&&(Z.innerHTML=Ne),ie=i(de),y(J.$$.fragment,de),jt=i(de),y(ue.$$.fragment,de),zt=i(de),y(yt.$$.fragment,de),de.forEach(s),Y.forEach(s),this.h()},h(){V(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(u,I){w(e,u,I),l(u,g,I),l(u,n,I),w(a,n,null),d(n,T),d(n,o),d(n,se),d(n,j),d(n,R),d(n,A),d(n,E),w(m,n,null),d(n,P),d(n,pe),w(ae,pe,null),d(pe,Ft),d(pe,De),d(pe,Jt),w(re,pe,null),d(pe,Le),w(ye,pe,null),l(u,st,I),w(H,u,I),l(u,Ue,I),l(u,F,I),w(He,F,null),d(F,vt),d(F,Pe),d(F,$t),d(F,xe),d(F,It),d(F,Ce),d(F,we),w(Xe,F,null),d(F,Qe),d(F,ee),w(Be,ee,null),d(ee,ge),d(ee,pt),d(ee,Se),w(me,ee,null),d(ee,Ve),w(L,ee,null),l(u,Je,I),w(ke,u,I),l(u,Re,I),l(u,W,I),w(at,W,null),d(W,Ye),d(W,Fe),d(W,Ae),d(W,Tt),d(W,D),d(W,ve),d(W,Oe),w(Ke,W,null),d(W,rt),d(W,X),w(et,X,null),d(X,$e),d(X,it),d(X,qe),w(q,X,null),d(X,Ie),w(We,X,null),l(u,B,I),w(je,u,I),l(u,bt,I),l(u,z,I),w(mt,z,null),d(z,xt),d(z,Te),d(z,Ct),d(z,N),d(z,At),d(z,be),d(z,Mt),d(z,te),d(z,S),d(z,ze),d(z,nt),w(f,z,null),d(z,x),d(z,U),w(Q,U,null),d(U,Ge),d(U,Z),d(U,ie),w(J,U,null),d(U,jt),w(ue,U,null),d(U,zt),w(yt,U,null),Ut=!0},p(u,I){const fe={};I&2&&(fe.$$scope={dirty:I,ctx:u}),m.$set(fe);const ne={};I&2&&(ne.$$scope={dirty:I,ctx:u}),re.$set(ne);const ot={};I&2&&(ot.$$scope={dirty:I,ctx:u}),ye.$set(ot);const le={};I&2&&(le.$$scope={dirty:I,ctx:u}),Xe.$set(le);const dt={};I&2&&(dt.$$scope={dirty:I,ctx:u}),me.$set(dt);const Y={};I&2&&(Y.$$scope={dirty:I,ctx:u}),L.$set(Y);const de={};I&2&&(de.$$scope={dirty:I,ctx:u}),Ke.$set(de);const Lt={};I&2&&(Lt.$$scope={dirty:I,ctx:u}),q.$set(Lt);const Wt={};I&2&&(Wt.$$scope={dirty:I,ctx:u}),We.$set(Wt);const Bt={};I&2&&(Bt.$$scope={dirty:I,ctx:u}),f.$set(Bt);const t={};I&2&&(t.$$scope={dirty:I,ctx:u}),J.$set(t);const b={};I&2&&(b.$$scope={dirty:I,ctx:u}),ue.$set(b);const ct={};I&2&&(ct.$$scope={dirty:I,ctx:u}),yt.$set(ct)},i(u){Ut||(k(e.$$.fragment,u),k(a.$$.fragment,u),k(m.$$.fragment,u),k(ae.$$.fragment,u),k(re.$$.fragment,u),k(ye.$$.fragment,u),k(H.$$.fragment,u),k(He.$$.fragment,u),k(Xe.$$.fragment,u),k(Be.$$.fragment,u),k(me.$$.fragment,u),k(L.$$.fragment,u),k(ke.$$.fragment,u),k(at.$$.fragment,u),k(Ke.$$.fragment,u),k(et.$$.fragment,u),k(q.$$.fragment,u),k(We.$$.fragment,u),k(je.$$.fragment,u),k(mt.$$.fragment,u),k(f.$$.fragment,u),k(Q.$$.fragment,u),k(J.$$.fragment,u),k(ue.$$.fragment,u),k(yt.$$.fragment,u),Ut=!0)},o(u){v(e.$$.fragment,u),v(a.$$.fragment,u),v(m.$$.fragment,u),v(ae.$$.fragment,u),v(re.$$.fragment,u),v(ye.$$.fragment,u),v(H.$$.fragment,u),v(He.$$.fragment,u),v(Xe.$$.fragment,u),v(Be.$$.fragment,u),v(me.$$.fragment,u),v(L.$$.fragment,u),v(ke.$$.fragment,u),v(at.$$.fragment,u),v(Ke.$$.fragment,u),v(et.$$.fragment,u),v(q.$$.fragment,u),v(We.$$.fragment,u),v(je.$$.fragment,u),v(mt.$$.fragment,u),v(f.$$.fragment,u),v(Q.$$.fragment,u),v(J.$$.fragment,u),v(ue.$$.fragment,u),v(yt.$$.fragment,u),Ut=!1},d(u){u&&(s(g),s(n),s(st),s(Ue),s(F),s(Je),s(Re),s(W),s(B),s(bt),s(z)),$(e,u),$(a),$(m),$(ae),$(re),$(ye),$(H,u),$(He),$(Xe),$(Be),$(me),$(L),$(ke,u),$(at),$(Ke),$(et),$(q),$(We),$(je,u),$(mt),$(f),$(Q),$(J),$(ue),$(yt)}}}function Pn(G){let e,g;return e=new Et({props:{$$slots:{default:[Gn]},$$scope:{ctx:G}}}),{c(){M(e.$$.fragment)},l(n){y(e.$$.fragment,n)},m(n,a){w(e,n,a),g=!0},p(n,a){const T={};a&2&&(T.$$scope={dirty:a,ctx:n}),e.$set(T)},i(n){g||(k(e.$$.fragment,n),g=!0)},o(n){v(e.$$.fragment,n),g=!1},d(n){$(e,n)}}}function xn(G){let e,g,n,a,T,o,_,se='<a href="https://huggingface.co/models?filter=openai-gpt"><img alt="Models" src="https://img.shields.io/badge/All_model_pages-openai--gpt-blueviolet"/></a> <a href="https://huggingface.co/spaces/docs-demos/openai-gpt"><img alt="Spaces" src="https://img.shields.io/badge/%F0%9F%A4%97%20Hugging%20Face-Spaces-blue"/></a>',j,C,R,A,O=`OpenAI GPT model was proposed in <a href="https://s3-us-west-2.amazonaws.com/openai-assets/research-covers/language-unsupervised/language_understanding_paper.pdf" rel="nofollow">Improving Language Understanding by Generative Pre-Training</a>
by Alec Radford, Karthik Narasimhan, Tim Salimans and Ilya Sutskever. It’s a causal (unidirectional) transformer
pre-trained using language modeling on a large corpus will long range dependencies, the Toronto Book Corpus.`,E,m,P="The abstract from the paper is the following:",pe,ae,Ft=`<em>Natural language understanding comprises a wide range of diverse tasks such as textual entailment, question answering,
semantic similarity assessment, and document classification. Although large unlabeled text corpora are abundant,
labeled data for learning these specific tasks is scarce, making it challenging for discriminatively trained models to
perform adequately. We demonstrate that large gains on these tasks can be realized by generative pretraining of a
language model on a diverse corpus of unlabeled text, followed by discriminative fine-tuning on each specific task. In
contrast to previous approaches, we make use of task-aware input transformations during fine-tuning to achieve
effective transfer while requiring minimal changes to the model architecture. We demonstrate the effectiveness of our
approach on a wide range of benchmarks for natural language understanding. Our general task-agnostic model outperforms
discriminatively trained models that use architectures specifically crafted for each task, significantly improving upon
the state of the art in 9 out of the 12 tasks studied.</em>`,De,Me,Jt=`<a href="https://transformer.huggingface.co/doc/gpt" rel="nofollow">Write With Transformer</a> is a webapp created and hosted by Hugging Face
showcasing the generative capabilities of several models. GPT is one of them.`,re,Le,ye='This model was contributed by <a href="https://huggingface.co/thomwolf" rel="nofollow">thomwolf</a>. The original code can be found <a href="https://github.com/openai/finetune-transformer-lm" rel="nofollow">here</a>.',st,H,Ue,F,He=`<li>GPT is a model with absolute position embeddings so it’s usually advised to pad the inputs on the right rather than
the left.</li> <li>GPT was trained with a causal language modeling (CLM) objective and is therefore powerful at predicting the next
token in a sequence. Leveraging this feature allows GPT-2 to generate syntactically coherent text as it can be
observed in the <em>run_generation.py</em> example script.</li>`,vt,Pe,gt="Note:",$t,xe,_t=`If you want to reproduce the original tokenization process of the <em>OpenAI GPT</em> paper, you will need to install <code>ftfy</code>
and <code>SpaCy</code>:`,It,Ce,he,we,Xe=`If you don’t install <code>ftfy</code> and <code>SpaCy</code>, the <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTTokenizer">OpenAIGPTTokenizer</a> will default to tokenize
using BERT’s <code>BasicTokenizer</code> followed by Byte-Pair Encoding (which should be fine for most usage, don’t worry).`,Qe,ee,Be,ge,pt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with OpenAI GPT. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Ze,Se,me,Ve,L='<li>A blog post on <a href="https://www.philschmid.de/getting-started-setfit" rel="nofollow">outperforming OpenAI GPT-3 with SetFit for text-classification</a>.</li> <li>See also: <a href="../tasks/sequence_classification">Text classification task guide</a></li>',Je,ke,Re,W,at='<li>A blog on how to <a href="https://www.philschmid.de/fine-tune-a-non-english-gpt-2-model-with-huggingface" rel="nofollow">Finetune a non-English GPT-2 Model with Hugging Face</a>.</li> <li>A blog on <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">How to generate text: using different decoding methods for language generation with Transformers</a> with GPT-2.</li> <li>A blog on <a href="https://huggingface.co/blog/codeparrot" rel="nofollow">Training CodeParrot 🦜 from Scratch</a>, a large GPT-2 model.</li> <li>A blog on <a href="https://huggingface.co/blog/tf-xla-generate" rel="nofollow">Faster Text Generation with TensorFlow and XLA</a> with GPT-2.</li> <li>A blog on <a href="https://huggingface.co/blog/megatron-training" rel="nofollow">How to train a Language Model with Megatron-LM</a> with a GPT-2 model.</li> <li>A notebook on how to <a href="https://colab.research.google.com/github/AlekseyKorshuk/huggingartists/blob/master/huggingartists-demo.ipynb" rel="nofollow">finetune GPT2 to generate lyrics in the style of your favorite artist</a>. 🌎</li> <li>A notebook on how to <a href="https://colab.research.google.com/github/borisdayma/huggingtweets/blob/master/huggingtweets-demo.ipynb" rel="nofollow">finetune GPT2 to generate tweets in the style of your favorite Twitter user</a>. 🌎</li> <li><a href="https://huggingface.co/course/en/chapter7/6?fw=pt#training-a-causal-language-model-from-scratch" rel="nofollow">Causal language modeling</a> chapter of the 🤗 Hugging Face Course.</li> <li><a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTLMHeadModel">OpenAIGPTLMHeadModel</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/language-modeling#gpt-2gpt-and-causal-language-modeling" rel="nofollow">causal language modeling example script</a>, <a href="https://github.com/huggingface/transformers/blob/main/examples/pytorch/text-generation/run_generation.py" rel="nofollow">text generation example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/language_modeling.ipynb" rel="nofollow">notebook</a>.</li> <li><a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.TFOpenAIGPTLMHeadModel">TFOpenAIGPTLMHeadModel</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/tensorflow/language-modeling#run_clmpy" rel="nofollow">causal language modeling example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/language_modeling-tf.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/language_modeling">Causal language modeling task guide</a></li>',Ye,Fe,Gt,Ae,Tt='<li>A course material on <a href="https://huggingface.co/course/en/chapter6/5" rel="nofollow">Byte-Pair Encoding tokenization</a>.</li>',Pt,D,ve,_e,Oe,Ke,rt,X=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTModel">OpenAIGPTModel</a> or a <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.TFOpenAIGPTModel">TFOpenAIGPTModel</a>. It is
used to instantiate a GPT model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the GPT
<a href="https://huggingface.co/openai-gpt" rel="nofollow">openai-gpt</a> architecture from OpenAI.`,et,$e,it=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,lt,qe,q,Ie,We,B,je,bt,z,mt="Construct a GPT Tokenizer. Based on Byte-Pair-Encoding with the following peculiarities:",xt,Te,qt=`<li>lowercases all inputs,</li> <li>uses <code>SpaCy</code> tokenizer and <code>ftfy</code> for pre-BPE tokenization if they are installed, fallback to BERT’s
<code>BasicTokenizer</code> if not.</li>`,Ct,N,ut=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,At,be,ft,Mt,te,Ot,S,ze,tt,nt,f=`Construct a “fast” GPT Tokenizer (backed by HuggingFace’s <em>tokenizers</em> library). Based on Byte-Pair-Encoding with
the following peculiarities:`,x,U,Q="<li>lower case all inputs</li> <li>uses BERT’s BasicTokenizer for pre-BPE tokenization</li>",Ge,Z,Ne=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,ie,J,jt,ue,zt,yt,Ut,u="Base class for outputs of models predicting if two sentences are consecutive or not.",I,fe,ne,ot,le,dt="Base class for outputs of models predicting if two sentences are consecutive or not.",Y,de,Lt,Wt,Bt;return T=new Ee({props:{title:"OpenAI GPT",local:"openai-gpt",headingTag:"h1"}}),C=new Ee({props:{title:"Overview",local:"overview",headingTag:"h2"}}),H=new Ee({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),Ce=new kt({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNwYWN5JTIwZnRmeSUzRCUzRDQuNC4zJTBBcHl0aG9uJTIwLW0lMjBzcGFjeSUyMGRvd25sb2FkJTIwZW4=",highlighted:`pip install spacy ftfy==4.4.3
python -m spacy download en`,wrap:!1}}),ee=new Ee({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Se=new Vt({props:{pipeline:"text-classification"}}),ke=new Vt({props:{pipeline:"text-generation"}}),Fe=new Vt({props:{pipeline:"token-classification"}}),D=new Ee({props:{title:"OpenAIGPTConfig",local:"transformers.OpenAIGPTConfig",headingTag:"h2"}}),Oe=new ce({props:{name:"class transformers.OpenAIGPTConfig",anchor:"transformers.OpenAIGPTConfig",parameters:[{name:"vocab_size",val:" = 40478"},{name:"n_positions",val:" = 512"},{name:"n_embd",val:" = 768"},{name:"n_layer",val:" = 12"},{name:"n_head",val:" = 12"},{name:"afn",val:" = 'gelu'"},{name:"resid_pdrop",val:" = 0.1"},{name:"embd_pdrop",val:" = 0.1"},{name:"attn_pdrop",val:" = 0.1"},{name:"layer_norm_epsilon",val:" = 1e-05"},{name:"initializer_range",val:" = 0.02"},{name:"summary_type",val:" = 'cls_index'"},{name:"summary_use_proj",val:" = True"},{name:"summary_activation",val:" = None"},{name:"summary_proj_to_labels",val:" = True"},{name:"summary_first_dropout",val:" = 0.1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OpenAIGPTConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 40478) &#x2014;
Vocabulary size of the GPT-2 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTModel">OpenAIGPTModel</a> or <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.TFOpenAIGPTModel">TFOpenAIGPTModel</a>.`,name:"vocab_size"},{anchor:"transformers.OpenAIGPTConfig.n_positions",description:`<strong>n_positions</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"n_positions"},{anchor:"transformers.OpenAIGPTConfig.n_embd",description:`<strong>n_embd</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the embeddings and hidden states.`,name:"n_embd"},{anchor:"transformers.OpenAIGPTConfig.n_layer",description:`<strong>n_layer</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"n_layer"},{anchor:"transformers.OpenAIGPTConfig.n_head",description:`<strong>n_head</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"n_head"},{anchor:"transformers.OpenAIGPTConfig.afn",description:`<strong>afn</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"afn"},{anchor:"transformers.OpenAIGPTConfig.resid_pdrop",description:`<strong>resid_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"resid_pdrop"},{anchor:"transformers.OpenAIGPTConfig.embd_pdrop",description:`<strong>embd_pdrop</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the embeddings.`,name:"embd_pdrop"},{anchor:"transformers.OpenAIGPTConfig.attn_pdrop",description:`<strong>attn_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention.`,name:"attn_pdrop"},{anchor:"transformers.OpenAIGPTConfig.layer_norm_epsilon",description:`<strong>layer_norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon to use in the layer normalization layers`,name:"layer_norm_epsilon"},{anchor:"transformers.OpenAIGPTConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.OpenAIGPTConfig.summary_type",description:`<strong>summary_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cls_index&quot;</code>) &#x2014;
Argument used when doing sequence summary, used in the models <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a> and
<a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a>.</p>
<p>Has to be one of the following options:</p>
<ul>
<li><code>&quot;last&quot;</code>: Take the last token hidden state (like XLNet).</li>
<li><code>&quot;first&quot;</code>: Take the first token hidden state (like BERT).</li>
<li><code>&quot;mean&quot;</code>: Take the mean of all tokens hidden states.</li>
<li><code>&quot;cls_index&quot;</code>: Supply a Tensor of classification token position (like GPT/GPT-2).</li>
<li><code>&quot;attn&quot;</code>: Not implemented now, use multi-head attention.</li>
</ul>`,name:"summary_type"},{anchor:"transformers.OpenAIGPTConfig.summary_use_proj",description:`<strong>summary_use_proj</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Argument used when doing sequence summary, used in the models <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a> and
<a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a>.</p>
<p>Whether or not to add a projection after the vector extraction.`,name:"summary_use_proj"},{anchor:"transformers.OpenAIGPTConfig.summary_activation",description:`<strong>summary_activation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Argument used when doing sequence summary, used in the models <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a> and
<a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a>.</p>
<p>Pass <code>&quot;tanh&quot;</code> for a tanh activation to the output, any other value will result in no activation.`,name:"summary_activation"},{anchor:"transformers.OpenAIGPTConfig.summary_proj_to_labels",description:`<strong>summary_proj_to_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Argument used when doing sequence summary, used in the models <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a> and
<a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a>.</p>
<p>Whether the projection outputs should have <code>config.num_labels</code> or <code>config.hidden_size</code> classes.`,name:"summary_proj_to_labels"},{anchor:"transformers.OpenAIGPTConfig.summary_first_dropout",description:`<strong>summary_first_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Argument used when doing sequence summary, used in the models <a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a> and
<a href="/docs/transformers/main/en/model_doc/openai-gpt#transformers.OpenAIGPTDoubleHeadsModel">OpenAIGPTDoubleHeadsModel</a>.</p>
<p>The dropout ratio to be used after the projection and activation.`,name:"summary_first_dropout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/configuration_openai.py#L27"}}),qe=new Ht({props:{anchor:"transformers.OpenAIGPTConfig.example",$$slots:{default:[tn]},$$scope:{ctx:G}}}),Ie=new Ee({props:{title:"OpenAIGPTTokenizer",local:"transformers.OpenAIGPTTokenizer",headingTag:"h2"}}),je=new ce({props:{name:"class transformers.OpenAIGPTTokenizer",anchor:"transformers.OpenAIGPTTokenizer",parameters:[{name:"vocab_file",val:""},{name:"merges_file",val:""},{name:"unk_token",val:" = '<unk>'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OpenAIGPTTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.OpenAIGPTTokenizer.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.OpenAIGPTTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/tokenization_openai.py#L245"}}),ft=new ce({props:{name:"save_vocabulary",anchor:"transformers.OpenAIGPTTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/tokenization_openai.py#L378"}}),te=new Ee({props:{title:"OpenAIGPTTokenizerFast",local:"transformers.OpenAIGPTTokenizerFast",headingTag:"h2"}}),ze=new ce({props:{name:"class transformers.OpenAIGPTTokenizerFast",anchor:"transformers.OpenAIGPTTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"merges_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"unk_token",val:" = '<unk>'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OpenAIGPTTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.OpenAIGPTTokenizerFast.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.OpenAIGPTTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/tokenization_openai_fast.py#L40"}}),J=new Ee({props:{title:"OpenAI specific outputs",local:"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput",headingTag:"h2"}}),zt=new ce({props:{name:"class transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput",anchor:"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"mc_loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"mc_logits",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss.`,name:"loss"},{anchor:"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput.mc_loss",description:`<strong>mc_loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>mc_labels</code> is provided) &#x2014;
Multiple choice classification loss.`,name:"mc_loss"},{anchor:"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput.mc_logits",description:`<strong>mc_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices)</code>) &#x2014;
Prediction scores of the multiple choice classification head (scores for each choice before SoftMax).`,name:"mc_logits"},{anchor:"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_openai.py#L297"}}),ne=new ce({props:{name:"class transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput",anchor:"transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput",parameters:[{name:"logits",val:": tf.Tensor = None"},{name:"mc_logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput.mc_logits",description:`<strong>mc_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_choices)</code>) &#x2014;
Prediction scores of the multiple choice classification head (scores for each choice before SoftMax).`,name:"mc_logits"},{anchor:"transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.openai.modeling_tf_openai.TFOpenAIGPTDoubleHeadsModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/openai/modeling_tf_openai.py#L413"}}),de=new en({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[Pn],pytorch:[un]},$$scope:{ctx:G}}}),{c(){e=c("meta"),g=r(),n=c("p"),a=r(),M(T.$$.fragment),o=r(),_=c("div"),_.innerHTML=se,j=r(),M(C.$$.fragment),R=r(),A=c("p"),A.innerHTML=O,E=r(),m=c("p"),m.textContent=P,pe=r(),ae=c("p"),ae.innerHTML=Ft,De=r(),Me=c("p"),Me.innerHTML=Jt,re=r(),Le=c("p"),Le.innerHTML=ye,st=r(),M(H.$$.fragment),Ue=r(),F=c("ul"),F.innerHTML=He,vt=r(),Pe=c("p"),Pe.textContent=gt,$t=r(),xe=c("p"),xe.innerHTML=_t,It=r(),M(Ce.$$.fragment),he=r(),we=c("p"),we.innerHTML=Xe,Qe=r(),M(ee.$$.fragment),Be=r(),ge=c("p"),ge.textContent=pt,Ze=r(),M(Se.$$.fragment),me=r(),Ve=c("ul"),Ve.innerHTML=L,Je=r(),M(ke.$$.fragment),Re=r(),W=c("ul"),W.innerHTML=at,Ye=r(),M(Fe.$$.fragment),Gt=r(),Ae=c("ul"),Ae.innerHTML=Tt,Pt=r(),M(D.$$.fragment),ve=r(),_e=c("div"),M(Oe.$$.fragment),Ke=r(),rt=c("p"),rt.innerHTML=X,et=r(),$e=c("p"),$e.innerHTML=it,lt=r(),M(qe.$$.fragment),q=r(),M(Ie.$$.fragment),We=r(),B=c("div"),M(je.$$.fragment),bt=r(),z=c("p"),z.textContent=mt,xt=r(),Te=c("ul"),Te.innerHTML=qt,Ct=r(),N=c("p"),N.innerHTML=ut,At=r(),be=c("div"),M(ft.$$.fragment),Mt=r(),M(te.$$.fragment),Ot=r(),S=c("div"),M(ze.$$.fragment),tt=r(),nt=c("p"),nt.innerHTML=f,x=r(),U=c("ul"),U.innerHTML=Q,Ge=r(),Z=c("p"),Z.innerHTML=Ne,ie=r(),M(J.$$.fragment),jt=r(),ue=c("div"),M(zt.$$.fragment),yt=r(),Ut=c("p"),Ut.textContent=u,I=r(),fe=c("div"),M(ne.$$.fragment),ot=r(),le=c("p"),le.textContent=dt,Y=r(),M(de.$$.fragment),Lt=r(),Wt=c("p"),this.h()},l(t){const b=Kt("svelte-u9bgzb",document.head);e=p(b,"META",{name:!0,content:!0}),b.forEach(s),g=i(t),n=p(t,"P",{}),K(n).forEach(s),a=i(t),y(T.$$.fragment,t),o=i(t),_=p(t,"DIV",{class:!0,"data-svelte-h":!0}),h(_)!=="svelte-ol7n4e"&&(_.innerHTML=se),j=i(t),y(C.$$.fragment,t),R=i(t),A=p(t,"P",{"data-svelte-h":!0}),h(A)!=="svelte-lzxyn"&&(A.innerHTML=O),E=i(t),m=p(t,"P",{"data-svelte-h":!0}),h(m)!=="svelte-vfdo9a"&&(m.textContent=P),pe=i(t),ae=p(t,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-1r8x2z3"&&(ae.innerHTML=Ft),De=i(t),Me=p(t,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-zq7bpd"&&(Me.innerHTML=Jt),re=i(t),Le=p(t,"P",{"data-svelte-h":!0}),h(Le)!=="svelte-wafrd3"&&(Le.innerHTML=ye),st=i(t),y(H.$$.fragment,t),Ue=i(t),F=p(t,"UL",{"data-svelte-h":!0}),h(F)!=="svelte-e2gzft"&&(F.innerHTML=He),vt=i(t),Pe=p(t,"P",{"data-svelte-h":!0}),h(Pe)!=="svelte-fovr4a"&&(Pe.textContent=gt),$t=i(t),xe=p(t,"P",{"data-svelte-h":!0}),h(xe)!=="svelte-9fkltf"&&(xe.innerHTML=_t),It=i(t),y(Ce.$$.fragment,t),he=i(t),we=p(t,"P",{"data-svelte-h":!0}),h(we)!=="svelte-47t9ni"&&(we.innerHTML=Xe),Qe=i(t),y(ee.$$.fragment,t),Be=i(t),ge=p(t,"P",{"data-svelte-h":!0}),h(ge)!=="svelte-z786dm"&&(ge.textContent=pt),Ze=i(t),y(Se.$$.fragment,t),me=i(t),Ve=p(t,"UL",{"data-svelte-h":!0}),h(Ve)!=="svelte-re9l8x"&&(Ve.innerHTML=L),Je=i(t),y(ke.$$.fragment,t),Re=i(t),W=p(t,"UL",{"data-svelte-h":!0}),h(W)!=="svelte-h8u0gz"&&(W.innerHTML=at),Ye=i(t),y(Fe.$$.fragment,t),Gt=i(t),Ae=p(t,"UL",{"data-svelte-h":!0}),h(Ae)!=="svelte-1goz972"&&(Ae.innerHTML=Tt),Pt=i(t),y(D.$$.fragment,t),ve=i(t),_e=p(t,"DIV",{class:!0});var ct=K(_e);y(Oe.$$.fragment,ct),Ke=i(ct),rt=p(ct,"P",{"data-svelte-h":!0}),h(rt)!=="svelte-lp0ry2"&&(rt.innerHTML=X),et=i(ct),$e=p(ct,"P",{"data-svelte-h":!0}),h($e)!=="svelte-o55m63"&&($e.innerHTML=it),lt=i(ct),y(qe.$$.fragment,ct),ct.forEach(s),q=i(t),y(Ie.$$.fragment,t),We=i(t),B=p(t,"DIV",{class:!0});var ht=K(B);y(je.$$.fragment,ht),bt=i(ht),z=p(ht,"P",{"data-svelte-h":!0}),h(z)!=="svelte-1mapzk"&&(z.textContent=mt),xt=i(ht),Te=p(ht,"UL",{"data-svelte-h":!0}),h(Te)!=="svelte-1ob4ey9"&&(Te.innerHTML=qt),Ct=i(ht),N=p(ht,"P",{"data-svelte-h":!0}),h(N)!=="svelte-1c3t5ty"&&(N.innerHTML=ut),At=i(ht),be=p(ht,"DIV",{class:!0});var Rt=K(be);y(ft.$$.fragment,Rt),Rt.forEach(s),ht.forEach(s),Mt=i(t),y(te.$$.fragment,t),Ot=i(t),S=p(t,"DIV",{class:!0});var Nt=K(S);y(ze.$$.fragment,Nt),tt=i(Nt),nt=p(Nt,"P",{"data-svelte-h":!0}),h(nt)!=="svelte-1ktb3mv"&&(nt.innerHTML=f),x=i(Nt),U=p(Nt,"UL",{"data-svelte-h":!0}),h(U)!=="svelte-ls1v46"&&(U.innerHTML=Q),Ge=i(Nt),Z=p(Nt,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-fh0aq"&&(Z.innerHTML=Ne),Nt.forEach(s),ie=i(t),y(J.$$.fragment,t),jt=i(t),ue=p(t,"DIV",{class:!0});var Zt=K(ue);y(zt.$$.fragment,Zt),yt=i(Zt),Ut=p(Zt,"P",{"data-svelte-h":!0}),h(Ut)!=="svelte-1bm2i0r"&&(Ut.textContent=u),Zt.forEach(s),I=i(t),fe=p(t,"DIV",{class:!0});var St=K(fe);y(ne.$$.fragment,St),ot=i(St),le=p(St,"P",{"data-svelte-h":!0}),h(le)!=="svelte-1bm2i0r"&&(le.textContent=dt),St.forEach(s),Y=i(t),y(de.$$.fragment,t),Lt=i(t),Wt=p(t,"P",{}),K(Wt).forEach(s),this.h()},h(){V(e,"name","hf:doc:metadata"),V(e,"content",Cn),V(_,"class","flex flex-wrap space-x-1"),V(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,b){d(document.head,e),l(t,g,b),l(t,n,b),l(t,a,b),w(T,t,b),l(t,o,b),l(t,_,b),l(t,j,b),w(C,t,b),l(t,R,b),l(t,A,b),l(t,E,b),l(t,m,b),l(t,pe,b),l(t,ae,b),l(t,De,b),l(t,Me,b),l(t,re,b),l(t,Le,b),l(t,st,b),w(H,t,b),l(t,Ue,b),l(t,F,b),l(t,vt,b),l(t,Pe,b),l(t,$t,b),l(t,xe,b),l(t,It,b),w(Ce,t,b),l(t,he,b),l(t,we,b),l(t,Qe,b),w(ee,t,b),l(t,Be,b),l(t,ge,b),l(t,Ze,b),w(Se,t,b),l(t,me,b),l(t,Ve,b),l(t,Je,b),w(ke,t,b),l(t,Re,b),l(t,W,b),l(t,Ye,b),w(Fe,t,b),l(t,Gt,b),l(t,Ae,b),l(t,Pt,b),w(D,t,b),l(t,ve,b),l(t,_e,b),w(Oe,_e,null),d(_e,Ke),d(_e,rt),d(_e,et),d(_e,$e),d(_e,lt),w(qe,_e,null),l(t,q,b),w(Ie,t,b),l(t,We,b),l(t,B,b),w(je,B,null),d(B,bt),d(B,z),d(B,xt),d(B,Te),d(B,Ct),d(B,N),d(B,At),d(B,be),w(ft,be,null),l(t,Mt,b),w(te,t,b),l(t,Ot,b),l(t,S,b),w(ze,S,null),d(S,tt),d(S,nt),d(S,x),d(S,U),d(S,Ge),d(S,Z),l(t,ie,b),w(J,t,b),l(t,jt,b),l(t,ue,b),w(zt,ue,null),d(ue,yt),d(ue,Ut),l(t,I,b),l(t,fe,b),w(ne,fe,null),d(fe,ot),d(fe,le),l(t,Y,b),w(de,t,b),l(t,Lt,b),l(t,Wt,b),Bt=!0},p(t,[b]){const ct={};b&2&&(ct.$$scope={dirty:b,ctx:t}),qe.$set(ct);const ht={};b&2&&(ht.$$scope={dirty:b,ctx:t}),de.$set(ht)},i(t){Bt||(k(T.$$.fragment,t),k(C.$$.fragment,t),k(H.$$.fragment,t),k(Ce.$$.fragment,t),k(ee.$$.fragment,t),k(Se.$$.fragment,t),k(ke.$$.fragment,t),k(Fe.$$.fragment,t),k(D.$$.fragment,t),k(Oe.$$.fragment,t),k(qe.$$.fragment,t),k(Ie.$$.fragment,t),k(je.$$.fragment,t),k(ft.$$.fragment,t),k(te.$$.fragment,t),k(ze.$$.fragment,t),k(J.$$.fragment,t),k(zt.$$.fragment,t),k(ne.$$.fragment,t),k(de.$$.fragment,t),Bt=!0)},o(t){v(T.$$.fragment,t),v(C.$$.fragment,t),v(H.$$.fragment,t),v(Ce.$$.fragment,t),v(ee.$$.fragment,t),v(Se.$$.fragment,t),v(ke.$$.fragment,t),v(Fe.$$.fragment,t),v(D.$$.fragment,t),v(Oe.$$.fragment,t),v(qe.$$.fragment,t),v(Ie.$$.fragment,t),v(je.$$.fragment,t),v(ft.$$.fragment,t),v(te.$$.fragment,t),v(ze.$$.fragment,t),v(J.$$.fragment,t),v(zt.$$.fragment,t),v(ne.$$.fragment,t),v(de.$$.fragment,t),Bt=!1},d(t){t&&(s(g),s(n),s(a),s(o),s(_),s(j),s(R),s(A),s(E),s(m),s(pe),s(ae),s(De),s(Me),s(re),s(Le),s(st),s(Ue),s(F),s(vt),s(Pe),s($t),s(xe),s(It),s(he),s(we),s(Qe),s(Be),s(ge),s(Ze),s(me),s(Ve),s(Je),s(Re),s(W),s(Ye),s(Gt),s(Ae),s(Pt),s(ve),s(_e),s(q),s(We),s(B),s(Mt),s(Ot),s(S),s(ie),s(jt),s(ue),s(I),s(fe),s(Y),s(Lt),s(Wt)),s(e),$(T,t),$(C,t),$(H,t),$(Ce,t),$(ee,t),$(Se,t),$(ke,t),$(Fe,t),$(D,t),$(Oe),$(qe),$(Ie,t),$(je),$(ft),$(te,t),$(ze),$(J,t),$(zt),$(ne),$(de,t)}}}const Cn='{"title":"OpenAI GPT","local":"openai-gpt","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"OpenAIGPTConfig","local":"transformers.OpenAIGPTConfig","sections":[],"depth":2},{"title":"OpenAIGPTTokenizer","local":"transformers.OpenAIGPTTokenizer","sections":[],"depth":2},{"title":"OpenAIGPTTokenizerFast","local":"transformers.OpenAIGPTTokenizerFast","sections":[],"depth":2},{"title":"OpenAI specific outputs","local":"transformers.models.openai.modeling_openai.OpenAIGPTDoubleHeadsModelOutput","sections":[],"depth":2},{"title":"OpenAIGPTModel","local":"transformers.OpenAIGPTModel","sections":[],"depth":2},{"title":"OpenAIGPTLMHeadModel","local":"transformers.OpenAIGPTLMHeadModel","sections":[],"depth":2},{"title":"OpenAIGPTDoubleHeadsModel","local":"transformers.OpenAIGPTDoubleHeadsModel","sections":[],"depth":2},{"title":"OpenAIGPTForSequenceClassification","local":"transformers.OpenAIGPTForSequenceClassification","sections":[],"depth":2},{"title":"TFOpenAIGPTModel","local":"transformers.TFOpenAIGPTModel","sections":[],"depth":2},{"title":"TFOpenAIGPTLMHeadModel","local":"transformers.TFOpenAIGPTLMHeadModel","sections":[],"depth":2},{"title":"TFOpenAIGPTDoubleHeadsModel","local":"transformers.TFOpenAIGPTDoubleHeadsModel","sections":[],"depth":2},{"title":"TFOpenAIGPTForSequenceClassification","local":"transformers.TFOpenAIGPTForSequenceClassification","sections":[],"depth":2}],"depth":1}';function An(G){return Xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nn extends Qt{constructor(e){super(),Yt(this,e,An,xn,Dt,{})}}export{Nn as component};
