import{s as mo,o as fo,n as Oe}from"../chunks/scheduler.9bc65507.js";import{S as po,i as ho,g as a,s as o,r as u,A as uo,h as s,f as c,c as n,j as C,x as m,u as g,k,y as t,a as w,v as _,d as b,t as y,w as v}from"../chunks/index.707bf1b6.js";import{T as io}from"../chunks/Tip.c2ecdbf4.js";import{D as P}from"../chunks/Docstring.17db21ae.js";import{C as lo}from"../chunks/CodeBlock.54a9f38d.js";import{E as co}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as go}from"../chunks/Heading.342b1fa6.js";function _o(j){let d,$=`A configuration file can be loaded and saved to disk. Loading the configuration file and using this file to
initialize a model does <strong>not</strong> load the model weights. It only affects the model’s configuration.`;return{c(){d=a("p"),d.innerHTML=$},l(f){d=s(f,"P",{"data-svelte-h":!0}),m(d)!=="svelte-s3sff7"&&(d.innerHTML=$)},m(f,h){w(f,d,h)},p:Oe,d(f){f&&c(d)}}}function bo(j){let d,$="Examples:",f,h,x;return h=new lo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMEElMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMGNvbmZpZyUyMHRvJTIweW91ciUyMG5hbWVzcGFjZSUyMHdpdGglMjB0aGUlMjBuYW1lJTIwJTIybXktZmluZXR1bmVkLWJlcnQlMjIuJTBBY29uZmlnLnB1c2hfdG9faHViKCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyKSUwQSUwQSUyMyUyMFB1c2glMjB0aGUlMjBjb25maWclMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFjb25maWcucHVzaF90b19odWIoJTIyaHVnZ2luZ2ZhY2UlMkZteS1maW5ldHVuZWQtYmVydCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig

config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the config to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
config.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the config to an organization with the name &quot;my-finetuned-bert&quot;.</span>
config.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){d=a("p"),d.textContent=$,f=o(),u(h.$$.fragment)},l(l){d=s(l,"P",{"data-svelte-h":!0}),m(d)!=="svelte-kvfsh7"&&(d.textContent=$),f=n(l),g(h.$$.fragment,l)},m(l,T){w(l,d,T),w(l,f,T),_(h,l,T),x=!0},p:Oe,i(l){x||(b(h.$$.fragment,l),x=!0)},o(l){y(h.$$.fragment,l),x=!1},d(l){l&&(c(d),c(f)),v(h,l)}}}function yo(j){let d,$="Examples:",f,h,x;return h=new lo({props:{code:"JTIzJTIwV2UlMjBjYW4ndCUyMGluc3RhbnRpYXRlJTIwZGlyZWN0bHklMjB0aGUlMjBiYXNlJTIwY2xhc3MlMjAqUHJldHJhaW5lZENvbmZpZyolMjBzbyUyMGxldCdzJTIwc2hvdyUyMHRoZSUyMGV4YW1wbGVzJTIwb24lMjBhJTBBJTIzJTIwZGVyaXZlZCUyMGNsYXNzJTNBJTIwQmVydENvbmZpZyUwQWNvbmZpZyUyMCUzRCUyMEJlcnRDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTBBKSUyMCUyMCUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEJlcnRDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIlMEEpJTIwJTIwJTIzJTIwRS5nLiUyMGNvbmZpZyUyMChvciUyMG1vZGVsKSUyMHdhcyUyMHNhdmVkJTIwdXNpbmclMjAqc2F2ZV9wcmV0cmFpbmVkKCcuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJykqJTBBY29uZmlnJTIwJTNEJTIwQmVydENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRm15X2NvbmZpZ3VyYXRpb24uanNvbiUyMiklMEFjb25maWclMjAlM0QlMjBCZXJ0Q29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSUyQyUyMGZvbyUzREZhbHNlKSUwQWFzc2VydCUyMGNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUyMCUzRCUzRCUyMFRydWUlMEFjb25maWclMkMlMjB1bnVzZWRfa3dhcmdzJTIwJTNEJTIwQmVydENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMkMlMjBvdXRwdXRfYXR0ZW50aW9ucyUzRFRydWUlMkMlMjBmb28lM0RGYWxzZSUyQyUyMHJldHVybl91bnVzZWRfa3dhcmdzJTNEVHJ1ZSUwQSklMEFhc3NlcnQlMjBjb25maWcub3V0cHV0X2F0dGVudGlvbnMlMjAlM0QlM0QlMjBUcnVlJTBBYXNzZXJ0JTIwdW51c2VkX2t3YXJncyUyMCUzRCUzRCUyMCU3QiUyMmZvbyUyMiUzQSUyMEZhbHNlJTdE",highlighted:`<span class="hljs-comment"># We can&#x27;t instantiate directly the base class *PretrainedConfig* so let&#x27;s show the examples on a</span>
<span class="hljs-comment"># derived class: BertConfig</span>
config = BertConfig.from_pretrained(
    <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
)  <span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
config = BertConfig.from_pretrained(
    <span class="hljs-string">&quot;./test/saved_model/&quot;</span>
)  <span class="hljs-comment"># E.g. config (or model) was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*</span>
config = BertConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/my_configuration.json&quot;</span>)
config = BertConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>, foo=<span class="hljs-literal">False</span>)
<span class="hljs-keyword">assert</span> config.output_attentions == <span class="hljs-literal">True</span>
config, unused_kwargs = BertConfig.from_pretrained(
    <span class="hljs-string">&quot;bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>, foo=<span class="hljs-literal">False</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
)
<span class="hljs-keyword">assert</span> config.output_attentions == <span class="hljs-literal">True</span>
<span class="hljs-keyword">assert</span> unused_kwargs == {<span class="hljs-string">&quot;foo&quot;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),{c(){d=a("p"),d.textContent=$,f=o(),u(h.$$.fragment)},l(l){d=s(l,"P",{"data-svelte-h":!0}),m(d)!=="svelte-kvfsh7"&&(d.textContent=$),f=n(l),g(h.$$.fragment,l)},m(l,T){w(l,d,T),w(l,f,T),_(h,l,T),x=!0},p:Oe,i(l){x||(b(h.$$.fragment,l),x=!0)},o(l){y(h.$$.fragment,l),x=!1},d(l){l&&(c(d),c(f)),v(h,l)}}}function vo(j){let d,$="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){d=a("p"),d.textContent=$},l(f){d=s(f,"P",{"data-svelte-h":!0}),m(d)!=="svelte-15rpg4"&&(d.textContent=$)},m(f,h){w(f,d,h)},p:Oe,d(f){f&&c(d)}}}function wo(j){let d,$,f,h,x,l="＃ 構成",T,X,Ft=`基本クラス <a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> は、設定をロード/保存するための一般的なメソッドを実装します。
ローカル ファイルまたはディレクトリから、またはライブラリ (ダウンロードされた) によって提供される事前トレーニング済みモデル構成から
HuggingFace の AWS S3 リポジトリから)。`,De,Y,Dt=`各派生構成クラスはモデル固有の属性を実装します。すべての構成クラスに存在する共通の属性は次のとおりです。
<code>hidden_​​size</code>、<code>num_attention_heads</code>、および <code>num_hidden_​​layers</code>。テキスト モデルはさらに以下を実装します。
<code>vocab_size</code>。`,He,Q,Ve,r,O,Ke,ue,Ht=`Base class for all configuration classes. Handles a few parameters common to all models’ configurations as well as
methods for loading/downloading/saving configurations.`,et,W,tt,ge,Vt="Class attributes (overridden by derived classes):",ot,_e,Nt=`<li><strong>model_type</strong> (<code>str</code>) — An identifier for the model type, serialized into the JSON file, and used to recreate
the correct object in <a href="/docs/transformers/main/ja/model_doc/auto#transformers.AutoConfig">AutoConfig</a>.</li> <li><strong>is_composition</strong> (<code>bool</code>) — Whether the config class is composed of multiple sub-configs. In this case the
config has to be initialized from two or more configs of type <a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> like:
<code>EncoderDecoderConfig</code> or <code>~RagConfig</code>.</li> <li><strong>keys_to_ignore_at_inference</strong> (<code>List[str]</code>) — A list of keys to ignore by default when looking at dictionary
outputs of the model during inference.</li> <li><strong>attribute_map</strong> (<code>Dict[str, str]</code>) — A dict that maps model specific attribute names to the standardized
naming of attributes.</li>`,nt,be,Bt="Common attributes (present in all subclasses):",rt,ye,St=`<li><strong>vocab_size</strong> (<code>int</code>) — The number of tokens in the vocabulary, which is also the first dimension of the
embeddings matrix (this attribute may be missing for models that don’t have a text modality like ViT).</li> <li><strong>hidden_size</strong> (<code>int</code>) — The hidden size of the model.</li> <li><strong>num_attention_heads</strong> (<code>int</code>) — The number of attention heads used in the multi-head attention layers of the
model.</li> <li><strong>num_hidden_layers</strong> (<code>int</code>) — The number of blocks in the model.</li>`,at,U,K,st,ve,Et="Upload the configuration file to the 🤗 Model Hub.",it,q,dt,L,ee,ct,we,Rt=`Checks whether the passed dictionary and its nested dicts have a <em>torch_dtype</em> key and if it’s not None,
converts torch.dtype to a string of just the type. For example, <code>torch.float32</code> get converted into <em>“float32”</em>
string, which can then be stored in the json format.`,lt,I,te,mt,xe,At='Instantiates a <a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> from a Python dictionary of parameters.',ft,F,oe,pt,Ce,Gt='Instantiates a <a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> from the path to a JSON file of parameters.',ht,z,ne,ut,ke,Xt='Instantiate a <a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> (or a derived class) from a pretrained model configuration.',gt,D,_t,H,re,bt,$e,Yt=`From a <code>pretrained_model_name_or_path</code>, resolve to a dictionary of parameters, to be used for instantiating a
<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> using <code>from_dict</code>.`,yt,J,ae,vt,Pe,Qt=`Register this class with a given auto class. This should only be used for custom configurations as the ones in
the library are already mapped with <code>AutoConfig</code>.`,wt,V,xt,N,se,Ct,Te,Ot=`Save a configuration object to the directory <code>save_directory</code>, so that it can be re-loaded using the
<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a> class method.`,kt,B,ie,$t,Me,Kt="Serializes this instance to a Python dictionary.",Pt,S,de,Tt,je,eo=`Removes all attributes from config which correspond to the default config attributes for better readability and
serializes to a Python dictionary.`,Mt,E,ce,jt,Ue,to="Save this instance to a JSON file.",Ut,R,le,zt,ze,oo="Serializes this instance to a JSON string.",Jt,A,me,Zt,Je,no="Updates attributes of this class with attributes from <code>config_dict</code>.",Wt,M,fe,qt,Ze,ro="Updates attributes of this class with attributes from <code>update_str</code>.",Lt,We,ao=`The expected format is ints, floats and strings as is, and for booleans use <code>true</code> or <code>false</code>. For example:
“n_embd=10,resid_pdrop=0.2,scale_attn_weights=false,summary_type=cls_index”`,It,qe,so="The keys to change have to already exist in the config object.",Ne,Fe,Be;return Q=new go({props:{title:"PretrainedConfig",local:"transformers.PretrainedConfig",headingTag:"h2"}}),O=new P({props:{name:"class transformers.PretrainedConfig",anchor:"transformers.PretrainedConfig",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.name_or_path",description:`<strong>name_or_path</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
Store the string that was passed to <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.from_pretrained">PreTrainedModel.from_pretrained()</a> or
<a href="/docs/transformers/main/ja/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">TFPreTrainedModel.from_pretrained()</a> as <code>pretrained_model_name_or_path</code> if the configuration was created
with such a method.`,name:"name_or_path"},{anchor:"transformers.PretrainedConfig.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model should return all hidden-states.`,name:"output_hidden_states"},{anchor:"transformers.PretrainedConfig.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model should returns all attentions.`,name:"output_attentions"},{anchor:"transformers.PretrainedConfig.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return a <a href="/docs/transformers/main/ja/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PretrainedConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model is used as an encoder/decoder or not.`,name:"is_encoder_decoder"},{anchor:"transformers.PretrainedConfig.is_decoder",description:`<strong>is_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model is used as decoder or not (in which case it&#x2019;s used as an encoder).`,name:"is_decoder"},{anchor:"transformers.PretrainedConfig.cross_attention_hidden_size**",description:`<strong>cross_attention_hidden_size**</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
The hidden size of the cross-attention layer in case the model is used as a decoder in an encoder-decoder
setting and the cross-attention hidden dimension differs from <code>self.config.hidden_size</code>.`,name:"cross_attention_hidden_size**"},{anchor:"transformers.PretrainedConfig.add_cross_attention",description:`<strong>add_cross_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether cross-attention layers should be added to the model. Note, this option is only relevant for models
that can be used as decoder models within the <code>EncoderDecoderModel</code> class, which consists of all models
in <code>AUTO_MODELS_FOR_CAUSAL_LM</code>.`,name:"add_cross_attention"},{anchor:"transformers.PretrainedConfig.tie_encoder_decoder",description:`<strong>tie_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether all encoder weights should be tied to their equivalent decoder weights. This requires the encoder
and decoder model to have the exact same parameter names.`,name:"tie_encoder_decoder"},{anchor:"transformers.PretrainedConfig.prune_heads",description:`<strong>prune_heads</strong> (<code>Dict[int, List[int]]</code>, <em>optional</em>, defaults to <code>{}</code>) &#x2014;
Pruned heads of the model. The keys are the selected layer indices and the associated values, the list of
heads to prune in said layer.</p>
<p>For instance <code>{1: [0, 2], 2: [2, 3]}</code> will prune heads 0 and 2 on layer 1 and heads 2 and 3 on layer 2.`,name:"prune_heads"},{anchor:"transformers.PretrainedConfig.chunk_size_feed_forward",description:`<strong>chunk_size_feed_forward</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
The chunk size of all feed forward layers in the residual attention blocks. A chunk size of <code>0</code> means that
the feed forward layer is not chunked. A chunk size of n means that the feed forward layer processes <code>n</code> &lt;
sequence_length embeddings at a time. For more information on feed forward chunking, see <a href="../glossary.html#feed-forward-chunking">How does Feed
Forward Chunking work?</a>.`,name:"chunk_size_feed_forward"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L49",parameterGroups:[{title:"Parameters for sequence generation",parametersDescription:[{anchor:"transformers.PretrainedConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
Maximum length that will be used by default in the <code>generate</code> method of the model.`,name:"max_length"},{anchor:"transformers.PretrainedConfig.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Minimum length that will be used by default in the <code>generate</code> method of the model.`,name:"min_length"},{anchor:"transformers.PretrainedConfig.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag that will be used by default in the <code>generate</code> method of the model. Whether or not to use sampling ;
use greedy decoding otherwise.`,name:"do_sample"},{anchor:"transformers.PretrainedConfig.early_stopping",description:`<strong>early_stopping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag that will be used by default in the <code>generate</code> method of the model. Whether to stop the beam search
when at least <code>num_beams</code> sentences are finished per batch or not.`,name:"early_stopping"},{anchor:"transformers.PretrainedConfig.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of beams for beam search that will be used by default in the <code>generate</code> method of the model. 1 means
no beam search.`,name:"num_beams"},{anchor:"transformers.PretrainedConfig.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams
that will be used by default in the <code>generate</code> method of the model. 1 means no group beam search.`,name:"num_beam_groups"},{anchor:"transformers.PretrainedConfig.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Value to control diversity for group beam search. that will be used by default in the <code>generate</code> method of
the model. 0 means no diversity penalty. The higher the penalty, the more diverse are the outputs.`,name:"diversity_penalty"},{anchor:"transformers.PretrainedConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value used to module the next token probabilities that will be used by default in the <code>generate</code> method
of the model. Must be strictly positive.`,name:"temperature"},{anchor:"transformers.PretrainedConfig.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
Number of highest probability vocabulary tokens to keep for top-k-filtering that will be used by default in
the <code>generate</code> method of the model.`,name:"top_k"},{anchor:"transformers.PretrainedConfig.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Value that will be used by default in the <code>generate</code> method of the model for <code>top_p</code>. If set to float &lt; 1,
only the most probable tokens with probabilities that add up to <code>top_p</code> or higher are kept for generation.`,name:"top_p"},{anchor:"transformers.PretrainedConfig.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is to
the expected conditional probability of predicting a random token next, given the partial text already
generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with probabilities that
add up to <code>typical_p</code> or higher are kept for generation. See <a href="https://arxiv.org/pdf/2202.00666.pdf" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"transformers.PretrainedConfig.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Parameter for repetition penalty that will be used by default in the <code>generate</code> method of the model. 1.0
means no penalty.`,name:"repetition_penalty"},{anchor:"transformers.PretrainedConfig.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.PretrainedConfig.no_repeat_ngram_size",description:`<strong>no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014; Value that will be used by default in the &#x2014;
<code>generate</code> method of the model for <code>no_repeat_ngram_size</code>. If set to int &gt; 0, all ngrams of that size can
only occur once.`,name:"no_repeat_ngram_size"},{anchor:"transformers.PretrainedConfig.encoder_no_repeat_ngram_size",description:`<strong>encoder_no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014; Value that will be used by &#x2014;
default in the <code>generate</code> method of the model for <code>encoder_no_repeat_ngram_size</code>. If set to int &gt; 0, all
ngrams of that size that occur in the <code>encoder_input_ids</code> cannot occur in the <code>decoder_input_ids</code>.`,name:"encoder_no_repeat_ngram_size"},{anchor:"transformers.PretrainedConfig.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List of token ids that are not allowed to be generated that will be used by default in the <code>generate</code>
method of the model. In order to get the tokens of the words that should not appear in the generated text,
use <code>tokenizer.encode(bad_word, add_prefix_space=True)</code>.`,name:"bad_words_ids"},{anchor:"transformers.PretrainedConfig.num_return_sequences",description:`<strong>num_return_sequences</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of independently computed returned sequences for each element in the batch that will be used by
default in the <code>generate</code> method of the model.`,name:"num_return_sequences"},{anchor:"transformers.PretrainedConfig.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model should return the logits when used for generation.`,name:"output_scores"},{anchor:"transformers.PretrainedConfig.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model should return a <a href="/docs/transformers/main/ja/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a <code>torch.LongTensor</code>.`,name:"return_dict_in_generate"},{anchor:"transformers.PretrainedConfig.forced_bos_token_id",description:`<strong>forced_bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful for
multilingual models like <a href="../model_doc/mbart">mBART</a> where the first generated token needs to be the target
language token.`,name:"forced_bos_token_id"},{anchor:"transformers.PretrainedConfig.forced_eos_token_id",description:`<strong>forced_eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"forced_eos_token_id"},{anchor:"transformers.PretrainedConfig.remove_invalid_values",description:`<strong>remove_invalid_values</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to remove possible <em>nan</em> and <em>inf</em> outputs of the model to prevent the generation method to crash.
Note that using <code>remove_invalid_values</code> can slow down generation.`,name:"remove_invalid_values"}]},{title:"Parameters for fine-tuning tasks",parametersDescription:[{anchor:"transformers.PretrainedConfig.architectures",description:`<strong>architectures</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Model architectures that can be used with the model pretrained weights.`,name:"architectures"},{anchor:"transformers.PretrainedConfig.finetuning_task",description:`<strong>finetuning_task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the task used to fine-tune the model. This can be used when converting from an original (TensorFlow
or PyTorch) checkpoint.`,name:"finetuning_task"},{anchor:"transformers.PretrainedConfig.id2label",description:`<strong>id2label</strong> (<code>Dict[int, str]</code>, <em>optional</em>) &#x2014;
A map from index (for instance prediction index, or target index) to label.`,name:"id2label"},{anchor:"transformers.PretrainedConfig.label2id",description:"<strong>label2id</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014; A map from label to index for the model.",name:"label2id"},{anchor:"transformers.PretrainedConfig.num_labels",description:`<strong>num_labels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of labels to use in the last layer added to the model, typically for a classification task.`,name:"num_labels"},{anchor:"transformers.PretrainedConfig.task_specific_params",description:`<strong>task_specific_params</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to store for the current task.`,name:"task_specific_params"},{anchor:"transformers.PretrainedConfig.problem_type",description:`<strong>problem_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Problem type for <code>XxxForSequenceClassification</code> models. Can be one of <code>&quot;regression&quot;</code>,
<code>&quot;single_label_classification&quot;</code> or <code>&quot;multi_label_classification&quot;</code>.`,name:"problem_type"}]},{title:"Parameters linked to the tokenizer",parametersDescription:[{anchor:"transformers.PretrainedConfig.tokenizer_class",description:`<strong>tokenizer_class</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the associated tokenizer class to use (if none is set, will use the tokenizer associated to the
model by default).`,name:"tokenizer_class"},{anchor:"transformers.PretrainedConfig.prefix",description:`<strong>prefix</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A specific prompt that should be added at the beginning of each text before calling the model.`,name:"prefix"},{anchor:"transformers.PretrainedConfig.bos_token_id",description:"<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014; The id of the <em>beginning-of-stream</em> token.",name:"bos_token_id"},{anchor:"transformers.PretrainedConfig.pad_token_id",description:"<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014; The id of the <em>padding</em> token.",name:"pad_token_id"},{anchor:"transformers.PretrainedConfig.eos_token_id",description:"<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014; The id of the <em>end-of-stream</em> token.",name:"eos_token_id"},{anchor:"transformers.PretrainedConfig.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token.`,name:"decoder_start_token_id"},{anchor:"transformers.PretrainedConfig.sep_token_id",description:"<strong>sep_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014; The id of the <em>separation</em> token.",name:"sep_token_id"}]},{title:"PyTorch specific parameters",parametersDescription:[{anchor:"transformers.PretrainedConfig.torchscript",description:`<strong>torchscript</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model should be used with Torchscript.`,name:"torchscript"},{anchor:"transformers.PretrainedConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied. Note that this is only relevant if the
model has a output word embedding layer.`,name:"tie_word_embeddings"},{anchor:"transformers.PretrainedConfig.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The <code>dtype</code> of the weights. This attribute can be used to initialize the model to a non-default <code>dtype</code>
(which is normally <code>float32</code>) and thus allow for optimal storage allocation. For example, if the saved
model is <code>float16</code>, ideally we want to load it back using the minimal amount of memory needed to load
<code>float16</code> weights. Since the config object is stored in plain text, this attribute contains just the
floating type string without the <code>torch.</code> prefix. For example, for <code>torch.float16</code> \`<code>torch_dtype</code> is the
<code>&quot;float16&quot;</code> string.</p>
<p>This attribute is currently not being used during model loading time, but this may change in the future
versions. But we can already start preparing for the future by saving the dtype with save_pretrained.`,name:"torch_dtype"},{anchor:"transformers.PretrainedConfig.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model. Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (attention using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>torch.nn.functional.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (attention using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}]},{title:"TensorFlow specific parameters",parametersDescription:[{anchor:"transformers.PretrainedConfig.use_bfloat16",description:`<strong>use_bfloat16</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model should use BFloat16 scalars (only used by some TensorFlow models).`,name:"use_bfloat16"},{anchor:"transformers.PretrainedConfig.tf_legacy_loss",description:`<strong>tf_legacy_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model should use legacy TensorFlow losses. Legacy losses have variable output shapes and may
not be XLA-compatible. This option is here for backward compatibility and will be removed in Transformers
v5.`,name:"tf_legacy_loss"}]}]}}),W=new io({props:{$$slots:{default:[_o]},$$scope:{ctx:j}}}),K=new P({props:{name:"push_to_hub",anchor:"transformers.PretrainedConfig.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": Optional = None"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"revision",val:": str = None"},{name:"commit_description",val:": str = None"},{name:"tags",val:": Optional = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your config to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.PretrainedConfig.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.PretrainedConfig.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload config&quot;</code>.`,name:"commit_message"},{anchor:"transformers.PretrainedConfig.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.PretrainedConfig.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.PretrainedConfig.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;5GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>). We default it to <code>&quot;5GB&quot;</code> so that users can easily load models on free-tier
Google Colab instances without any CPU OOM issues.`,name:"max_shard_size"},{anchor:"transformers.PretrainedConfig.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.PretrainedConfig.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.PretrainedConfig.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"},{anchor:"transformers.PretrainedConfig.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"transformers.PretrainedConfig.push_to_hub.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to push on the Hub.`,name:"tags"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/hub.py#L755"}}),q=new co({props:{anchor:"transformers.PretrainedConfig.push_to_hub.example",$$slots:{default:[bo]},$$scope:{ctx:j}}}),ee=new P({props:{name:"dict_torch_dtype_to_str",anchor:"transformers.PretrainedConfig.dict_torch_dtype_to_str",parameters:[{name:"d",val:": Dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L1005"}}),te=new P({props:{name:"from_dict",anchor:"transformers.PretrainedConfig.from_dict",parameters:[{name:"config_dict",val:": Dict"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.from_dict.config_dict",description:`<strong>config_dict</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary that will be used to instantiate the configuration object. Such a dictionary can be
retrieved from a pretrained checkpoint by leveraging the <a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.get_config_dict">get_config_dict()</a> method.`,name:"config_dict"},{anchor:"transformers.PretrainedConfig.from_dict.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Additional parameters from which to initialize the configuration object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L737",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from those parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig"
>PretrainedConfig</a></p>
`}}),oe=new P({props:{name:"from_json_file",anchor:"transformers.PretrainedConfig.from_json_file",parameters:[{name:"json_file",val:": Union"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.from_json_file.json_file",description:`<strong>json_file</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file containing the parameters.`,name:"json_file"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L798",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from that JSON file.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig"
>PretrainedConfig</a></p>
`}}),ne=new P({props:{name:"from_pretrained",anchor:"transformers.PretrainedConfig.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved configuration JSON <em>file</em>, e.g., <code>./my_model_directory/configuration.json</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.PretrainedConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.PretrainedConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the configuration files and override the cached versions if
they exist.`,name:"force_download"},{anchor:"transformers.PretrainedConfig.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.PretrainedConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.PretrainedConfig.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, or not specified, will use
the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.PretrainedConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass \`revision=&#x201C;refs/pr/<pr_number>&#x201C;.</pr_number></p>

					</div>`,name:"revision"},{anchor:"transformers.PretrainedConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.PretrainedConfig.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"transformers.PretrainedConfig.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L511",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from this pretrained model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig"
>PretrainedConfig</a></p>
`}}),D=new co({props:{anchor:"transformers.PretrainedConfig.from_pretrained.example",$$slots:{default:[yo]},$$scope:{ctx:j}}}),re=new P({props:{name:"get_config_dict",anchor:"transformers.PretrainedConfig.get_config_dict",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.get_config_dict.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The identifier of the pre-trained checkpoint from which we want the dictionary of parameters.`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L614",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary(ies) that will be used to instantiate the configuration object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[Dict, Dict]</code></p>
`}}),ae=new P({props:{name:"register_for_auto_class",anchor:"transformers.PretrainedConfig.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoConfig'"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoConfig&quot;</code>) &#x2014;
The auto class to register this new configuration with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L1017"}}),V=new io({props:{warning:!0,$$slots:{default:[vo]},$$scope:{ctx:j}}}),se=new P({props:{name:"save_pretrained",anchor:"transformers.PretrainedConfig.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the configuration JSON file will be saved (will be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.PretrainedConfig.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.PretrainedConfig.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L424"}}),ie=new P({props:{name:"to_dict",anchor:"transformers.PretrainedConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L883",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this configuration instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),de=new P({props:{name:"to_diff_dict",anchor:"transformers.PretrainedConfig.to_diff_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L826",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this configuration instance,</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),ce=new P({props:{name:"to_json_file",anchor:"transformers.PretrainedConfig.to_json_file",parameters:[{name:"json_file_path",val:": Union"},{name:"use_diff",val:": bool = True"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.to_json_file.json_file_path",description:`<strong>json_file_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file in which this configuration instance&#x2019;s parameters will be saved.`,name:"json_file_path"},{anchor:"transformers.PretrainedConfig.to_json_file.use_diff",description:`<strong>use_diff</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, only the difference between the config instance and the default <code>PretrainedConfig()</code>
is serialized to JSON file.`,name:"use_diff"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L943"}}),le=new P({props:{name:"to_json_string",anchor:"transformers.PretrainedConfig.to_json_string",parameters:[{name:"use_diff",val:": bool = True"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.to_json_string.use_diff",description:`<strong>use_diff</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, only the difference between the config instance and the default <code>PretrainedConfig()</code>
is serialized to JSON string.`,name:"use_diff"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L925",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>String containing all the attributes that make up this configuration instance in JSON format.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),me=new P({props:{name:"update",anchor:"transformers.PretrainedConfig.update",parameters:[{name:"config_dict",val:": Dict"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.update.config_dict",description:"<strong>config_dict</strong> (<code>Dict[str, Any]</code>) &#x2014; Dictionary of attributes that should be updated for this class.",name:"config_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L957"}}),fe=new P({props:{name:"update_from_string",anchor:"transformers.PretrainedConfig.update_from_string",parameters:[{name:"update_str",val:": str"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.update_from_string.update_str",description:"<strong>update_str</strong> (<code>str</code>) &#x2014; String with attributes that should be updated for this class.",name:"update_str"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/configuration_utils.py#L967"}}),{c(){d=a("meta"),$=o(),f=a("p"),h=o(),x=a("p"),x.textContent=l,T=o(),X=a("p"),X.innerHTML=Ft,De=o(),Y=a("p"),Y.innerHTML=Dt,He=o(),u(Q.$$.fragment),Ve=o(),r=a("div"),u(O.$$.fragment),Ke=o(),ue=a("p"),ue.textContent=Ht,et=o(),u(W.$$.fragment),tt=o(),ge=a("p"),ge.textContent=Vt,ot=o(),_e=a("ul"),_e.innerHTML=Nt,nt=o(),be=a("p"),be.textContent=Bt,rt=o(),ye=a("ul"),ye.innerHTML=St,at=o(),U=a("div"),u(K.$$.fragment),st=o(),ve=a("p"),ve.textContent=Et,it=o(),u(q.$$.fragment),dt=o(),L=a("div"),u(ee.$$.fragment),ct=o(),we=a("p"),we.innerHTML=Rt,lt=o(),I=a("div"),u(te.$$.fragment),mt=o(),xe=a("p"),xe.innerHTML=At,ft=o(),F=a("div"),u(oe.$$.fragment),pt=o(),Ce=a("p"),Ce.innerHTML=Gt,ht=o(),z=a("div"),u(ne.$$.fragment),ut=o(),ke=a("p"),ke.innerHTML=Xt,gt=o(),u(D.$$.fragment),_t=o(),H=a("div"),u(re.$$.fragment),bt=o(),$e=a("p"),$e.innerHTML=Yt,yt=o(),J=a("div"),u(ae.$$.fragment),vt=o(),Pe=a("p"),Pe.innerHTML=Qt,wt=o(),u(V.$$.fragment),xt=o(),N=a("div"),u(se.$$.fragment),Ct=o(),Te=a("p"),Te.innerHTML=Ot,kt=o(),B=a("div"),u(ie.$$.fragment),$t=o(),Me=a("p"),Me.textContent=Kt,Pt=o(),S=a("div"),u(de.$$.fragment),Tt=o(),je=a("p"),je.textContent=eo,Mt=o(),E=a("div"),u(ce.$$.fragment),jt=o(),Ue=a("p"),Ue.textContent=to,Ut=o(),R=a("div"),u(le.$$.fragment),zt=o(),ze=a("p"),ze.textContent=oo,Jt=o(),A=a("div"),u(me.$$.fragment),Zt=o(),Je=a("p"),Je.innerHTML=no,Wt=o(),M=a("div"),u(fe.$$.fragment),qt=o(),Ze=a("p"),Ze.innerHTML=ro,Lt=o(),We=a("p"),We.innerHTML=ao,It=o(),qe=a("p"),qe.textContent=so,Ne=o(),Fe=a("p"),this.h()},l(e){const p=uo("svelte-u9bgzb",document.head);d=s(p,"META",{name:!0,content:!0}),p.forEach(c),$=n(e),f=s(e,"P",{}),C(f).forEach(c),h=n(e),x=s(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-h0g430"&&(x.textContent=l),T=n(e),X=s(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-rm8u6d"&&(X.innerHTML=Ft),De=n(e),Y=s(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-lq0qfk"&&(Y.innerHTML=Dt),He=n(e),g(Q.$$.fragment,e),Ve=n(e),r=s(e,"DIV",{class:!0});var i=C(r);g(O.$$.fragment,i),Ke=n(i),ue=s(i,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-1p9qi0i"&&(ue.textContent=Ht),et=n(i),g(W.$$.fragment,i),tt=n(i),ge=s(i,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-1qxxkvo"&&(ge.textContent=Vt),ot=n(i),_e=s(i,"UL",{"data-svelte-h":!0}),m(_e)!=="svelte-1fp1b61"&&(_e.innerHTML=Nt),nt=n(i),be=s(i,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1yi3c0w"&&(be.textContent=Bt),rt=n(i),ye=s(i,"UL",{"data-svelte-h":!0}),m(ye)!=="svelte-1cjcwii"&&(ye.innerHTML=St),at=n(i),U=s(i,"DIV",{class:!0});var Z=C(U);g(K.$$.fragment,Z),st=n(Z),ve=s(Z,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-j50kqf"&&(ve.textContent=Et),it=n(Z),g(q.$$.fragment,Z),Z.forEach(c),dt=n(i),L=s(i,"DIV",{class:!0});var pe=C(L);g(ee.$$.fragment,pe),ct=n(pe),we=s(pe,"P",{"data-svelte-h":!0}),m(we)!=="svelte-m61tyl"&&(we.innerHTML=Rt),pe.forEach(c),lt=n(i),I=s(i,"DIV",{class:!0});var he=C(I);g(te.$$.fragment,he),mt=n(he),xe=s(he,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-1dta6qf"&&(xe.innerHTML=At),he.forEach(c),ft=n(i),F=s(i,"DIV",{class:!0});var Se=C(F);g(oe.$$.fragment,Se),pt=n(Se),Ce=s(Se,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-1pi307m"&&(Ce.innerHTML=Gt),Se.forEach(c),ht=n(i),z=s(i,"DIV",{class:!0});var Le=C(z);g(ne.$$.fragment,Le),ut=n(Le),ke=s(Le,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-1dpq3wy"&&(ke.innerHTML=Xt),gt=n(Le),g(D.$$.fragment,Le),Le.forEach(c),_t=n(i),H=s(i,"DIV",{class:!0});var Ee=C(H);g(re.$$.fragment,Ee),bt=n(Ee),$e=s(Ee,"P",{"data-svelte-h":!0}),m($e)!=="svelte-1yjmjpy"&&($e.innerHTML=Yt),Ee.forEach(c),yt=n(i),J=s(i,"DIV",{class:!0});var Ie=C(J);g(ae.$$.fragment,Ie),vt=n(Ie),Pe=s(Ie,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-30y31e"&&(Pe.innerHTML=Qt),wt=n(Ie),g(V.$$.fragment,Ie),Ie.forEach(c),xt=n(i),N=s(i,"DIV",{class:!0});var Re=C(N);g(se.$$.fragment,Re),Ct=n(Re),Te=s(Re,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-1dqtlcs"&&(Te.innerHTML=Ot),Re.forEach(c),kt=n(i),B=s(i,"DIV",{class:!0});var Ae=C(B);g(ie.$$.fragment,Ae),$t=n(Ae),Me=s(Ae,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1ww3wqq"&&(Me.textContent=Kt),Ae.forEach(c),Pt=n(i),S=s(i,"DIV",{class:!0});var Ge=C(S);g(de.$$.fragment,Ge),Tt=n(Ge),je=s(Ge,"P",{"data-svelte-h":!0}),m(je)!=="svelte-1p6bdas"&&(je.textContent=eo),Ge.forEach(c),Mt=n(i),E=s(i,"DIV",{class:!0});var Xe=C(E);g(ce.$$.fragment,Xe),jt=n(Xe),Ue=s(Xe,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-1g70y32"&&(Ue.textContent=to),Xe.forEach(c),Ut=n(i),R=s(i,"DIV",{class:!0});var Ye=C(R);g(le.$$.fragment,Ye),zt=n(Ye),ze=s(Ye,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-5ayq1f"&&(ze.textContent=oo),Ye.forEach(c),Jt=n(i),A=s(i,"DIV",{class:!0});var Qe=C(A);g(me.$$.fragment,Qe),Zt=n(Qe),Je=s(Qe,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-1hh5fg7"&&(Je.innerHTML=no),Qe.forEach(c),Wt=n(i),M=s(i,"DIV",{class:!0});var G=C(M);g(fe.$$.fragment,G),qt=n(G),Ze=s(G,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-a2aodj"&&(Ze.innerHTML=ro),Lt=n(G),We=s(G,"P",{"data-svelte-h":!0}),m(We)!=="svelte-179z5e8"&&(We.innerHTML=ao),It=n(G),qe=s(G,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-5bouux"&&(qe.textContent=so),G.forEach(c),i.forEach(c),Ne=n(e),Fe=s(e,"P",{}),C(Fe).forEach(c),this.h()},h(){k(d,"name","hf:doc:metadata"),k(d,"content",xo),k(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(r,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){t(document.head,d),w(e,$,p),w(e,f,p),w(e,h,p),w(e,x,p),w(e,T,p),w(e,X,p),w(e,De,p),w(e,Y,p),w(e,He,p),_(Q,e,p),w(e,Ve,p),w(e,r,p),_(O,r,null),t(r,Ke),t(r,ue),t(r,et),_(W,r,null),t(r,tt),t(r,ge),t(r,ot),t(r,_e),t(r,nt),t(r,be),t(r,rt),t(r,ye),t(r,at),t(r,U),_(K,U,null),t(U,st),t(U,ve),t(U,it),_(q,U,null),t(r,dt),t(r,L),_(ee,L,null),t(L,ct),t(L,we),t(r,lt),t(r,I),_(te,I,null),t(I,mt),t(I,xe),t(r,ft),t(r,F),_(oe,F,null),t(F,pt),t(F,Ce),t(r,ht),t(r,z),_(ne,z,null),t(z,ut),t(z,ke),t(z,gt),_(D,z,null),t(r,_t),t(r,H),_(re,H,null),t(H,bt),t(H,$e),t(r,yt),t(r,J),_(ae,J,null),t(J,vt),t(J,Pe),t(J,wt),_(V,J,null),t(r,xt),t(r,N),_(se,N,null),t(N,Ct),t(N,Te),t(r,kt),t(r,B),_(ie,B,null),t(B,$t),t(B,Me),t(r,Pt),t(r,S),_(de,S,null),t(S,Tt),t(S,je),t(r,Mt),t(r,E),_(ce,E,null),t(E,jt),t(E,Ue),t(r,Ut),t(r,R),_(le,R,null),t(R,zt),t(R,ze),t(r,Jt),t(r,A),_(me,A,null),t(A,Zt),t(A,Je),t(r,Wt),t(r,M),_(fe,M,null),t(M,qt),t(M,Ze),t(M,Lt),t(M,We),t(M,It),t(M,qe),w(e,Ne,p),w(e,Fe,p),Be=!0},p(e,[p]){const i={};p&2&&(i.$$scope={dirty:p,ctx:e}),W.$set(i);const Z={};p&2&&(Z.$$scope={dirty:p,ctx:e}),q.$set(Z);const pe={};p&2&&(pe.$$scope={dirty:p,ctx:e}),D.$set(pe);const he={};p&2&&(he.$$scope={dirty:p,ctx:e}),V.$set(he)},i(e){Be||(b(Q.$$.fragment,e),b(O.$$.fragment,e),b(W.$$.fragment,e),b(K.$$.fragment,e),b(q.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(oe.$$.fragment,e),b(ne.$$.fragment,e),b(D.$$.fragment,e),b(re.$$.fragment,e),b(ae.$$.fragment,e),b(V.$$.fragment,e),b(se.$$.fragment,e),b(ie.$$.fragment,e),b(de.$$.fragment,e),b(ce.$$.fragment,e),b(le.$$.fragment,e),b(me.$$.fragment,e),b(fe.$$.fragment,e),Be=!0)},o(e){y(Q.$$.fragment,e),y(O.$$.fragment,e),y(W.$$.fragment,e),y(K.$$.fragment,e),y(q.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(oe.$$.fragment,e),y(ne.$$.fragment,e),y(D.$$.fragment,e),y(re.$$.fragment,e),y(ae.$$.fragment,e),y(V.$$.fragment,e),y(se.$$.fragment,e),y(ie.$$.fragment,e),y(de.$$.fragment,e),y(ce.$$.fragment,e),y(le.$$.fragment,e),y(me.$$.fragment,e),y(fe.$$.fragment,e),Be=!1},d(e){e&&(c($),c(f),c(h),c(x),c(T),c(X),c(De),c(Y),c(He),c(Ve),c(r),c(Ne),c(Fe)),c(d),v(Q,e),v(O),v(W),v(K),v(q),v(ee),v(te),v(oe),v(ne),v(D),v(re),v(ae),v(V),v(se),v(ie),v(de),v(ce),v(le),v(me),v(fe)}}}const xo='{"title":"PretrainedConfig","local":"transformers.PretrainedConfig","sections":[],"depth":2}';function Co(j){return fo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zo extends po{constructor(d){super(),ho(this,d,Co,wo,mo,{})}}export{zo as component};
