import{s as qt,o as Dt,n as Je}from"../chunks/scheduler.182ea377.js";import{S as Kt,i as Ot,g as o,s as a,r as u,A as el,h as m,f as l,c as i,j as Lt,u as f,x as r,k as Pt,y as tl,a as s,v as d,d as y,t as h,w}from"../chunks/index.abf12888.js";import{T as we}from"../chunks/Tip.230e2334.js";import{C as I}from"../chunks/CodeBlock.57fe6e13.js";import{H as v,E as ll}from"../chunks/EditOnGithub.9b8e78e4.js";function sl(U){let n,J='In many cases, optimizing for memory or speed leads to improved performance in the other, so you should try to optimize for both whenever you can. This guide focuses on minimizing memory usage, but you can also learn more about how to <a href="fp16">Speed up inference</a>.';return{c(){n=o("p"),n.innerHTML=J},l(p){n=m(p,"P",{"data-svelte-h":!0}),r(n)!=="svelte-15lbm2y"&&(n.innerHTML=J)},m(p,c){s(p,n,c)},p:Je,d(p){p&&l(n)}}}function nl(U){let n,J='Consider using <a href="#model-offloading">model offloading</a> if you want to optimize for speed because it is much faster. The tradeoff is your memory savings won’t be as large.';return{c(){n=o("p"),n.innerHTML=J},l(p){n=m(p,"P",{"data-svelte-h":!0}),r(n)!=="svelte-1yyrc0t"&&(n.innerHTML=J)},m(p,c){s(p,n,c)},p:Je,d(p){p&&l(n)}}}function al(U){let n,J='When using <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, don’t move the pipeline to CUDA beforehand or else the gain in memory consumption will only be minimal (see this <a href="https://github.com/huggingface/diffusers/issues/1934" rel="nofollow">issue</a> for more information).',p,c,j='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> is a stateful operation that installs hooks on the models.';return{c(){n=o("p"),n.innerHTML=J,p=a(),c=o("p"),c.innerHTML=j},l(M){n=m(M,"P",{"data-svelte-h":!0}),r(n)!=="svelte-pysjic"&&(n.innerHTML=J),p=i(M),c=m(M,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1zrt6x"&&(c.innerHTML=j)},m(M,T){s(M,n,T),s(M,p,T),s(M,c,T)},p:Je,d(M){M&&(l(n),l(p),l(c))}}}function il(U){let n,J="Model offloading requires 🤗 Accelerate version 0.17.0 or higher.";return{c(){n=o("p"),n.textContent=J},l(p){n=m(p,"P",{"data-svelte-h":!0}),r(n)!=="svelte-1guxtqy"&&(n.textContent=J)},m(p,c){s(p,n,c)},p:Je,d(p){p&&l(n)}}}function pl(U){let n,J='In order to properly offload models after they’re called, it is required to run the entire pipeline and models are called in the pipeline’s expected order. Exercise caution if models are reused outside the context of the pipeline after hooks have been installed. See <a href="https://huggingface.co/docs/accelerate/en/package_reference/big_modeling#accelerate.hooks.remove_hook_from_module" rel="nofollow">Removing Hooks</a> for more information.',p,c,j='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> is a stateful operation that installs hooks on the models and state on the pipeline.';return{c(){n=o("p"),n.innerHTML=J,p=a(),c=o("p"),c.innerHTML=j},l(M){n=m(M,"P",{"data-svelte-h":!0}),r(n)!=="svelte-bljvwk"&&(n.innerHTML=J),p=i(M),c=m(M,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1rrcfel"&&(c.innerHTML=j)},m(M,T){s(M,n,T),s(M,p,T),s(M,c,T)},p:Je,d(M){M&&(l(n),l(p),l(c))}}}function ol(U){let n,J="If you have PyTorch &gt;= 2.0 installed, you should not expect a speed-up for inference when enabling <code>xformers</code>.";return{c(){n=o("p"),n.innerHTML=J},l(p){n=m(p,"P",{"data-svelte-h":!0}),r(n)!=="svelte-17vr965"&&(n.innerHTML=J)},m(p,c){s(p,n,c)},p:Je,d(p){p&&l(n)}}}function ml(U){let n,J,p,c,j,M,T,yt="A barrier to using diffusion models is the large amount of memory required. To overcome this challenge, there are several memory-reducing techniques you can use to run even some of the largest models on free-tier or consumer GPUs. Some of these techniques can even be combined to further reduce memory usage.",Ue,b,je,W,ht="The results below are obtained from generating a single 512x512 image from the prompt a photo of an astronaut riding a horse on mars with 50 DDIM steps on a Nvidia Titan RTX, demonstrating the speed-up you can expect as a result of reduced memory consumption.",be,$,wt="<thead><tr><th></th> <th>latency</th> <th>speed-up</th></tr></thead> <tbody><tr><td>original</td> <td>9.50s</td> <td>x1</td></tr> <tr><td>fp16</td> <td>3.61s</td> <td>x2.63</td></tr> <tr><td>channels last</td> <td>3.30s</td> <td>x2.88</td></tr> <tr><td>traced UNet</td> <td>3.21s</td> <td>x2.96</td></tr> <tr><td>memory-efficient attention</td> <td>2.63s</td> <td>x3.61</td></tr></tbody>",Ze,G,Ce,V,Jt='Sliced VAE enables decoding large batches of images with limited VRAM or batches with 32 images or more by decoding the batches of latents one image at a time. You’ll likely want to couple this with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',_e,X,Tt='To use sliced VAE, call <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline.enable_vae_slicing">enable_vae_slicing()</a> on your pipeline before inference:',ge,R,Be,k,Ut="You may see a small performance boost in VAE decoding on multi-image batches, and there should be no performance impact on single-image batches.",Ie,E,ve,x,jt='Tiled VAE processing also enables working with large images on limited VRAM (for example, generating 4k images on 8GB of VRAM) by splitting the image into overlapping tiles, decoding the tiles, and then blending the outputs together to compose the final image. You should also used tiled VAE with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',We,S,bt='To use tiled VAE processing, call <a href="/docs/diffusers/main/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline.enable_vae_tiling">enable_vae_tiling()</a> on your pipeline before inference:',$e,A,Ge,Q,Zt="The output image has some tile-to-tile tone variation because the tiles are decoded separately, but you shouldn’t see any sharp and obvious seams between the tiles. Tiling is turned off for images that are 512x512 or smaller.",Ve,N,Xe,H,Ct="Offloading the weights to the CPU and only loading them on the GPU when performing the forward pass can also save memory. Often, this technique can reduce memory consumption to less than 3GB.",Re,Y,_t='To perform CPU offloading, call <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>:',ke,z,Ee,F,gt="CPU offloading works on submodules rather than whole models. This is the best way to minimize memory consumption, but inference is much slower due to the iterative nature of the diffusion process. The UNet component of the pipeline runs several times (as many as <code>num_inference_steps</code>); each time, the different UNet submodules are sequentially onloaded and offloaded as needed, resulting in a large number of memory transfers.",xe,Z,Se,C,Ae,L,Qe,_,Ne,P,Bt='<a href="#cpu-offloading">Sequential CPU offloading</a> preserves a lot of memory but it makes inference slower because submodules are moved to GPU as needed, and they’re immediately returned to the CPU when a new module runs.',He,q,It="Full-model offloading is an alternative that moves whole models to the GPU, instead of handling each model’s constituent <em>submodules</em>. There is a negligible impact on inference time (compared with moving the pipeline to <code>cuda</code>), and it still provides some memory savings.",Ye,D,vt=`During model offloading, only one of the main components of the pipeline (typically the text encoder, UNet and VAE)
is placed on the GPU while the others wait on the CPU. Components like the UNet that run for multiple iterations stay on the GPU until they’re no longer needed.`,ze,K,Wt='Enable model offloading by calling <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> on the pipeline:',Fe,O,Le,g,Pe,ee,qe,te,$t="The channels-last memory format is an alternative way of ordering NCHW tensors in memory to preserve dimension ordering. Channels-last tensors are ordered in such a way that the channels become the densest dimension (storing images pixel-per-pixel). Since not all operators currently support the channels-last format, it may result in worst performance but you should still try and see if it works for your model.",De,le,Gt="For example, to set the pipeline’s UNet to use the channels-last format:",Ke,se,Oe,ne,et,ae,Vt="Tracing runs an example input tensor through the model and captures the operations that are performed on it as that input makes its way through the model’s layers. The executable or <code>ScriptFunction</code> that is returned is optimized with just-in-time compilation.",tt,ie,Xt="To trace a UNet:",lt,pe,st,oe,Rt="Replace the <code>unet</code> attribute of the pipeline with the traced model:",nt,me,at,re,it,ce,kt='Recent work on optimizing bandwidth in the attention block has generated huge speed-ups and reductions in GPU memory usage. The most recent type of memory-efficient attention is <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">Flash Attention</a> (you can check out the original code at <a href="https://github.com/HazyResearch/flash-attention" rel="nofollow">HazyResearch/flash-attention</a>).',pt,B,ot,Me,Et="To use Flash Attention, install the following:",mt,ue,xt='<li>PyTorch &gt; 1.12</li> <li>CUDA available</li> <li><a href="xformers">xFormers</a></li>',rt,fe,St='Then call <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on the pipeline:',ct,de,Mt,ye,At='The iteration speed when using <code>xformers</code> should match the iteration speed of PyTorch 2.0 as described <a href="torch2.0">here</a>.',ut,he,ft,Te,dt;return j=new v({props:{title:"Reduce memory usage",local:"reduce-memory-usage",headingTag:"h1"}}),b=new we({props:{$$slots:{default:[sl]},$$scope:{ctx:U}}}),G=new v({props:{title:"Sliced VAE",local:"sliced-vae",headingTag:"h2"}}),R=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBJTIzcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTVCcHJvbXB0JTVEJTIwKiUyMDMyKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_vae_slicing()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>
images = pipe([prompt] * <span class="hljs-number">32</span>).images`,wrap:!1}}),E=new v({props:{title:"Tiled VAE",local:"tiled-vae",headingTag:"h2"}}),A=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJlYXV0aWZ1bCUyMGxhbmRzY2FwZSUyMHBob3RvZ3JhcGglMjIlMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEElMjNwaXBlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCU1QnByb21wdCU1RCUyQyUyMHdpZHRoJTNEMzg0MCUyQyUyMGhlaWdodCUzRDIyMjQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, UniPCMultistepScheduler

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;a beautiful landscape photograph&quot;</span>
pipe.enable_vae_tiling()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>

image = pipe([prompt], width=<span class="hljs-number">3840</span>, height=<span class="hljs-number">2224</span>, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),N=new v({props:{title:"CPU offloading",local:"cpu-offloading",headingTag:"h2"}}),z=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfc2VxdWVudGlhbF9jcHVfb2ZmbG9hZCgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_sequential_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Z=new we({props:{$$slots:{default:[nl]},$$scope:{ctx:U}}}),C=new we({props:{warning:!0,$$slots:{default:[al]},$$scope:{ctx:U}}}),L=new v({props:{title:"Model offloading",local:"model-offloading",headingTag:"h2"}}),_=new we({props:{$$slots:{default:[il]},$$scope:{ctx:U}}}),O=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_model_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),g=new we({props:{warning:!0,$$slots:{default:[pl]},$$scope:{ctx:U}}}),ee=new v({props:{title:"Channels-last memory format",local:"channels-last-memory-format",headingTag:"h2"}}),se=new I({props:{code:"cHJpbnQocGlwZS51bmV0LmNvbnZfb3V0LnN0YXRlX2RpY3QoKSU1QiUyMndlaWdodCUyMiU1RC5zdHJpZGUoKSklMjAlMjAlMjMlMjAoMjg4MCUyQyUyMDklMkMlMjAzJTJDJTIwMSklMEFwaXBlLnVuZXQudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTIwJTIwJTIzJTIwaW4tcGxhY2UlMjBvcGVyYXRpb24lMEFwcmludCglMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQuY29udl9vdXQuc3RhdGVfZGljdCgpJTVCJTIyd2VpZ2h0JTIyJTVELnN0cmlkZSgpJTBBKSUyMCUyMCUyMyUyMCgyODgwJTJDJTIwMSUyQyUyMDk2MCUyQyUyMDMyMCklMjBoYXZpbmclMjBhJTIwc3RyaWRlJTIwb2YlMjAxJTIwZm9yJTIwdGhlJTIwMm5kJTIwZGltZW5zaW9uJTIwcHJvdmVzJTIwdGhhdCUyMGl0JTIwd29ya3M=",highlighted:`<span class="hljs-built_in">print</span>(pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride())  <span class="hljs-comment"># (2880, 9, 3, 1)</span>
pipe.unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># in-place operation</span>
<span class="hljs-built_in">print</span>(
    pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride()
)  <span class="hljs-comment"># (2880, 1, 960, 320) having a stride of 1 for the 2nd dimension proves that it works</span>`,wrap:!1}}),ne=new v({props:{title:"Tracing",local:"tracing",headingTag:"h2"}}),pe=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> functools

<span class="hljs-comment"># torch disable grad</span>
torch.set_grad_enabled(<span class="hljs-literal">False</span>)

<span class="hljs-comment"># set variables</span>
n_experiments = <span class="hljs-number">2</span>
unet_runs_per_experiment = <span class="hljs-number">50</span>


<span class="hljs-comment"># load inputs</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_inputs</span>():
    sample = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    timestep = torch.rand(<span class="hljs-number">1</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16) * <span class="hljs-number">999</span>
    encoder_hidden_states = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">77</span>, <span class="hljs-number">768</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    <span class="hljs-keyword">return</span> sample, timestep, encoder_hidden_states


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
unet = pipe.unet
unet.<span class="hljs-built_in">eval</span>()
unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># use channels_last memory format</span>
unet.forward = functools.partial(unet.forward, return_dict=<span class="hljs-literal">False</span>)  <span class="hljs-comment"># set return_dict=False as default</span>

<span class="hljs-comment"># warmup</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet(*inputs)

<span class="hljs-comment"># trace</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;tracing..&quot;</span>)
unet_traced = torch.jit.trace(unet, inputs)
unet_traced.<span class="hljs-built_in">eval</span>()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;done tracing&quot;</span>)


<span class="hljs-comment"># warmup and optimize graph</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet_traced(*inputs)


<span class="hljs-comment"># benchmarking</span>
<span class="hljs-keyword">with</span> torch.inference_mode():
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet_traced(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet traced inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)

<span class="hljs-comment"># save the model</span>
unet_traced.save(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)`,wrap:!1}}),me=new I({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjBkYXRhY2xhc3MlMEElMEElMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMFVOZXQyRENvbmRpdGlvbk91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUzQSUyMHRvcmNoLkZsb2F0VGVuc29yJTBBJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwdXNlJTIwaml0dGVkJTIwdW5ldCUwQXVuZXRfdHJhY2VkJTIwJTNEJTIwdG9yY2guaml0LmxvYWQoJTIydW5ldF90cmFjZWQucHQlMjIpJTBBJTBBJTBBJTIzJTIwZGVsJTIwcGlwZS51bmV0JTBBY2xhc3MlMjBUcmFjZWRVTmV0KHRvcmNoLm5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaW5fY2hhbm5lbHMlMjAlM0QlMjBwaXBlLnVuZXQuY29uZmlnLmluX2NoYW5uZWxzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5kZXZpY2UlMjAlM0QlMjBwaXBlLnVuZXQuZGV2aWNlJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwbGF0ZW50X21vZGVsX2lucHV0JTJDJTIwdCUyQyUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGUlMjAlM0QlMjB1bmV0X3RyYWNlZChsYXRlbnRfbW9kZWxfaW5wdXQlMkMlMjB0JTJDJTIwZW5jb2Rlcl9oaWRkZW5fc3RhdGVzKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBVTmV0MkRDb25kaXRpb25PdXRwdXQoc2FtcGxlJTNEc2FtcGxlKSUwQSUwQSUwQXBpcGUudW5ldCUyMCUzRCUyMFRyYWNlZFVOZXQoKSUwQSUwQXdpdGglMjB0b3JjaC5pbmZlcmVuY2VfbW9kZSgpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBwaXBlKCU1QnByb21wdCU1RCUyMColMjAxJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">UNet2DConditionOutput</span>:
    sample: torch.FloatTensor


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># use jitted unet</span>
unet_traced = torch.jit.load(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)


<span class="hljs-comment"># del pipe.unet</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TracedUNet</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.in_channels = pipe.unet.config.in_channels
        self.device = pipe.unet.device

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, latent_model_input, t, encoder_hidden_states</span>):
        sample = unet_traced(latent_model_input, t, encoder_hidden_states)[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">return</span> UNet2DConditionOutput(sample=sample)


pipe.unet = TracedUNet()

<span class="hljs-keyword">with</span> torch.inference_mode():
    image = pipe([prompt] * <span class="hljs-number">1</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),re=new v({props:{title:"Memory-efficient attention",local:"memory-efficient-attention",headingTag:"h2"}}),B=new we({props:{$$slots:{default:[ol]},$$scope:{ctx:U}}}),de=new I({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBzYW1wbGUlMjAlM0QlMjBwaXBlKCUyMmElMjBzbWFsbCUyMGNhdCUyMiklMEElMEElMjMlMjBvcHRpb25hbCUzQSUyMFlvdSUyMGNhbiUyMGRpc2FibGUlMjBpdCUyMHZpYSUwQSUyMyUyMHBpcGUuZGlzYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.enable_xformers_memory_efficient_attention()

<span class="hljs-keyword">with</span> torch.inference_mode():
    sample = pipe(<span class="hljs-string">&quot;a small cat&quot;</span>)

<span class="hljs-comment"># optional: You can disable it via</span>
<span class="hljs-comment"># pipe.disable_xformers_memory_efficient_attention()</span>`,wrap:!1}}),he=new ll({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/memory.md"}}),{c(){n=o("meta"),J=a(),p=o("p"),c=a(),u(j.$$.fragment),M=a(),T=o("p"),T.textContent=yt,Ue=a(),u(b.$$.fragment),je=a(),W=o("p"),W.textContent=ht,be=a(),$=o("table"),$.innerHTML=wt,Ze=a(),u(G.$$.fragment),Ce=a(),V=o("p"),V.innerHTML=Jt,_e=a(),X=o("p"),X.innerHTML=Tt,ge=a(),u(R.$$.fragment),Be=a(),k=o("p"),k.textContent=Ut,Ie=a(),u(E.$$.fragment),ve=a(),x=o("p"),x.innerHTML=jt,We=a(),S=o("p"),S.innerHTML=bt,$e=a(),u(A.$$.fragment),Ge=a(),Q=o("p"),Q.textContent=Zt,Ve=a(),u(N.$$.fragment),Xe=a(),H=o("p"),H.textContent=Ct,Re=a(),Y=o("p"),Y.innerHTML=_t,ke=a(),u(z.$$.fragment),Ee=a(),F=o("p"),F.innerHTML=gt,xe=a(),u(Z.$$.fragment),Se=a(),u(C.$$.fragment),Ae=a(),u(L.$$.fragment),Qe=a(),u(_.$$.fragment),Ne=a(),P=o("p"),P.innerHTML=Bt,He=a(),q=o("p"),q.innerHTML=It,Ye=a(),D=o("p"),D.textContent=vt,ze=a(),K=o("p"),K.innerHTML=Wt,Fe=a(),u(O.$$.fragment),Le=a(),u(g.$$.fragment),Pe=a(),u(ee.$$.fragment),qe=a(),te=o("p"),te.textContent=$t,De=a(),le=o("p"),le.textContent=Gt,Ke=a(),u(se.$$.fragment),Oe=a(),u(ne.$$.fragment),et=a(),ae=o("p"),ae.innerHTML=Vt,tt=a(),ie=o("p"),ie.textContent=Xt,lt=a(),u(pe.$$.fragment),st=a(),oe=o("p"),oe.innerHTML=Rt,nt=a(),u(me.$$.fragment),at=a(),u(re.$$.fragment),it=a(),ce=o("p"),ce.innerHTML=kt,pt=a(),u(B.$$.fragment),ot=a(),Me=o("p"),Me.textContent=Et,mt=a(),ue=o("ul"),ue.innerHTML=xt,rt=a(),fe=o("p"),fe.innerHTML=St,ct=a(),u(de.$$.fragment),Mt=a(),ye=o("p"),ye.innerHTML=At,ut=a(),u(he.$$.fragment),ft=a(),Te=o("p"),this.h()},l(e){const t=el("svelte-u9bgzb",document.head);n=m(t,"META",{name:!0,content:!0}),t.forEach(l),J=i(e),p=m(e,"P",{}),Lt(p).forEach(l),c=i(e),f(j.$$.fragment,e),M=i(e),T=m(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-18ag1qn"&&(T.textContent=yt),Ue=i(e),f(b.$$.fragment,e),je=i(e),W=m(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1nfsyhf"&&(W.textContent=ht),be=i(e),$=m(e,"TABLE",{"data-svelte-h":!0}),r($)!=="svelte-qiiy0g"&&($.innerHTML=wt),Ze=i(e),f(G.$$.fragment,e),Ce=i(e),V=m(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-g37v30"&&(V.innerHTML=Jt),_e=i(e),X=m(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1t1foqu"&&(X.innerHTML=Tt),ge=i(e),f(R.$$.fragment,e),Be=i(e),k=m(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-fte8mn"&&(k.textContent=Ut),Ie=i(e),f(E.$$.fragment,e),ve=i(e),x=m(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1g0rx31"&&(x.innerHTML=jt),We=i(e),S=m(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1yciusa"&&(S.innerHTML=bt),$e=i(e),f(A.$$.fragment,e),Ge=i(e),Q=m(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-nyzaca"&&(Q.textContent=Zt),Ve=i(e),f(N.$$.fragment,e),Xe=i(e),H=m(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-435lli"&&(H.textContent=Ct),Re=i(e),Y=m(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-z49dor"&&(Y.innerHTML=_t),ke=i(e),f(z.$$.fragment,e),Ee=i(e),F=m(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-153k8wf"&&(F.innerHTML=gt),xe=i(e),f(Z.$$.fragment,e),Se=i(e),f(C.$$.fragment,e),Ae=i(e),f(L.$$.fragment,e),Qe=i(e),f(_.$$.fragment,e),Ne=i(e),P=m(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1w0xgx8"&&(P.innerHTML=Bt),He=i(e),q=m(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-nislc4"&&(q.innerHTML=It),Ye=i(e),D=m(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-11gjm3"&&(D.textContent=vt),ze=i(e),K=m(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-op610o"&&(K.innerHTML=Wt),Fe=i(e),f(O.$$.fragment,e),Le=i(e),f(g.$$.fragment,e),Pe=i(e),f(ee.$$.fragment,e),qe=i(e),te=m(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-sky5la"&&(te.textContent=$t),De=i(e),le=m(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-mhdc10"&&(le.textContent=Gt),Ke=i(e),f(se.$$.fragment,e),Oe=i(e),f(ne.$$.fragment,e),et=i(e),ae=m(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1hj6sqj"&&(ae.innerHTML=Vt),tt=i(e),ie=m(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ca1ko1"&&(ie.textContent=Xt),lt=i(e),f(pe.$$.fragment,e),st=i(e),oe=m(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-mpebhd"&&(oe.innerHTML=Rt),nt=i(e),f(me.$$.fragment,e),at=i(e),f(re.$$.fragment,e),it=i(e),ce=m(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1tu2ji2"&&(ce.innerHTML=kt),pt=i(e),f(B.$$.fragment,e),ot=i(e),Me=m(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-rpfoyf"&&(Me.textContent=Et),mt=i(e),ue=m(e,"UL",{"data-svelte-h":!0}),r(ue)!=="svelte-1q6gndt"&&(ue.innerHTML=xt),rt=i(e),fe=m(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-141yc6t"&&(fe.innerHTML=St),ct=i(e),f(de.$$.fragment,e),Mt=i(e),ye=m(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1nf2kxh"&&(ye.innerHTML=At),ut=i(e),f(he.$$.fragment,e),ft=i(e),Te=m(e,"P",{}),Lt(Te).forEach(l),this.h()},h(){Pt(n,"name","hf:doc:metadata"),Pt(n,"content",rl)},m(e,t){tl(document.head,n),s(e,J,t),s(e,p,t),s(e,c,t),d(j,e,t),s(e,M,t),s(e,T,t),s(e,Ue,t),d(b,e,t),s(e,je,t),s(e,W,t),s(e,be,t),s(e,$,t),s(e,Ze,t),d(G,e,t),s(e,Ce,t),s(e,V,t),s(e,_e,t),s(e,X,t),s(e,ge,t),d(R,e,t),s(e,Be,t),s(e,k,t),s(e,Ie,t),d(E,e,t),s(e,ve,t),s(e,x,t),s(e,We,t),s(e,S,t),s(e,$e,t),d(A,e,t),s(e,Ge,t),s(e,Q,t),s(e,Ve,t),d(N,e,t),s(e,Xe,t),s(e,H,t),s(e,Re,t),s(e,Y,t),s(e,ke,t),d(z,e,t),s(e,Ee,t),s(e,F,t),s(e,xe,t),d(Z,e,t),s(e,Se,t),d(C,e,t),s(e,Ae,t),d(L,e,t),s(e,Qe,t),d(_,e,t),s(e,Ne,t),s(e,P,t),s(e,He,t),s(e,q,t),s(e,Ye,t),s(e,D,t),s(e,ze,t),s(e,K,t),s(e,Fe,t),d(O,e,t),s(e,Le,t),d(g,e,t),s(e,Pe,t),d(ee,e,t),s(e,qe,t),s(e,te,t),s(e,De,t),s(e,le,t),s(e,Ke,t),d(se,e,t),s(e,Oe,t),d(ne,e,t),s(e,et,t),s(e,ae,t),s(e,tt,t),s(e,ie,t),s(e,lt,t),d(pe,e,t),s(e,st,t),s(e,oe,t),s(e,nt,t),d(me,e,t),s(e,at,t),d(re,e,t),s(e,it,t),s(e,ce,t),s(e,pt,t),d(B,e,t),s(e,ot,t),s(e,Me,t),s(e,mt,t),s(e,ue,t),s(e,rt,t),s(e,fe,t),s(e,ct,t),d(de,e,t),s(e,Mt,t),s(e,ye,t),s(e,ut,t),d(he,e,t),s(e,ft,t),s(e,Te,t),dt=!0},p(e,[t]){const Qt={};t&2&&(Qt.$$scope={dirty:t,ctx:e}),b.$set(Qt);const Nt={};t&2&&(Nt.$$scope={dirty:t,ctx:e}),Z.$set(Nt);const Ht={};t&2&&(Ht.$$scope={dirty:t,ctx:e}),C.$set(Ht);const Yt={};t&2&&(Yt.$$scope={dirty:t,ctx:e}),_.$set(Yt);const zt={};t&2&&(zt.$$scope={dirty:t,ctx:e}),g.$set(zt);const Ft={};t&2&&(Ft.$$scope={dirty:t,ctx:e}),B.$set(Ft)},i(e){dt||(y(j.$$.fragment,e),y(b.$$.fragment,e),y(G.$$.fragment,e),y(R.$$.fragment,e),y(E.$$.fragment,e),y(A.$$.fragment,e),y(N.$$.fragment,e),y(z.$$.fragment,e),y(Z.$$.fragment,e),y(C.$$.fragment,e),y(L.$$.fragment,e),y(_.$$.fragment,e),y(O.$$.fragment,e),y(g.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(pe.$$.fragment,e),y(me.$$.fragment,e),y(re.$$.fragment,e),y(B.$$.fragment,e),y(de.$$.fragment,e),y(he.$$.fragment,e),dt=!0)},o(e){h(j.$$.fragment,e),h(b.$$.fragment,e),h(G.$$.fragment,e),h(R.$$.fragment,e),h(E.$$.fragment,e),h(A.$$.fragment,e),h(N.$$.fragment,e),h(z.$$.fragment,e),h(Z.$$.fragment,e),h(C.$$.fragment,e),h(L.$$.fragment,e),h(_.$$.fragment,e),h(O.$$.fragment,e),h(g.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(re.$$.fragment,e),h(B.$$.fragment,e),h(de.$$.fragment,e),h(he.$$.fragment,e),dt=!1},d(e){e&&(l(J),l(p),l(c),l(M),l(T),l(Ue),l(je),l(W),l(be),l($),l(Ze),l(Ce),l(V),l(_e),l(X),l(ge),l(Be),l(k),l(Ie),l(ve),l(x),l(We),l(S),l($e),l(Ge),l(Q),l(Ve),l(Xe),l(H),l(Re),l(Y),l(ke),l(Ee),l(F),l(xe),l(Se),l(Ae),l(Qe),l(Ne),l(P),l(He),l(q),l(Ye),l(D),l(ze),l(K),l(Fe),l(Le),l(Pe),l(qe),l(te),l(De),l(le),l(Ke),l(Oe),l(et),l(ae),l(tt),l(ie),l(lt),l(st),l(oe),l(nt),l(at),l(it),l(ce),l(pt),l(ot),l(Me),l(mt),l(ue),l(rt),l(fe),l(ct),l(Mt),l(ye),l(ut),l(ft),l(Te)),l(n),w(j,e),w(b,e),w(G,e),w(R,e),w(E,e),w(A,e),w(N,e),w(z,e),w(Z,e),w(C,e),w(L,e),w(_,e),w(O,e),w(g,e),w(ee,e),w(se,e),w(ne,e),w(pe,e),w(me,e),w(re,e),w(B,e),w(de,e),w(he,e)}}}const rl='{"title":"Reduce memory usage","local":"reduce-memory-usage","sections":[{"title":"Sliced VAE","local":"sliced-vae","sections":[],"depth":2},{"title":"Tiled VAE","local":"tiled-vae","sections":[],"depth":2},{"title":"CPU offloading","local":"cpu-offloading","sections":[],"depth":2},{"title":"Model offloading","local":"model-offloading","sections":[],"depth":2},{"title":"Channels-last memory format","local":"channels-last-memory-format","sections":[],"depth":2},{"title":"Tracing","local":"tracing","sections":[],"depth":2},{"title":"Memory-efficient attention","local":"memory-efficient-attention","sections":[],"depth":2}],"depth":1}';function cl(U){return Dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hl extends Kt{constructor(n){super(),Ot(this,n,cl,ml,qt,{})}}export{hl as component};
