import{s as al,o as ol,n as pl}from"../chunks/scheduler.182ea377.js";import{S as rl,i as dl,g as a,s,r as c,A as cl,h as o,f as t,c as n,j as il,u as m,x as r,k as sl,y as ml,a as i,v as u,d as f,t as w,w as y}from"../chunks/index.abf12888.js";import{T as nl}from"../chunks/Tip.230e2334.js";import{C as T}from"../chunks/CodeBlock.57fe6e13.js";import{H as te,E as ul}from"../chunks/EditOnGithub.9b8e78e4.js";function fl(ee){let p,M='💡 Take a look at GitHub Issue <a href="https://github.com/huggingface/diffusers/issues/841" rel="nofollow">#841</a> for more context about why we’re adding community pipelines to help everyone easily share their work without being slowed down.';return{c(){p=a("p"),p.innerHTML=M},l(d){p=o(d,"P",{"data-svelte-h":!0}),r(p)!=="svelte-19wo1pm"&&(p.innerHTML=M)},m(d,J){i(d,p,J)},p:pl,d(d){d&&t(p)}}}function wl(ee){let p,M="💡 You can use whatever package you want in your community pipeline file - as long as the user has it installed, everything will work fine. Make sure you have one and only one pipeline class that inherits from <code>DiffusionPipeline</code> because this is automatically detected.";return{c(){p=a("p"),p.innerHTML=M},l(d){p=o(d,"P",{"data-svelte-h":!0}),r(p)!=="svelte-143wzg5"&&(p.innerHTML=M)},m(d,J){i(d,p,J)},p:pl,d(d){d&&t(p)}}}function yl(ee){let p,M,d,J,U,ie,h,se,I,Re='Community pipelines allow you to add any additional features you’d like on top of the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. The main benefit of building on top of the <code>DiffusionPipeline</code> is anyone can load and use your pipeline by only adding one more argument, making it super easy for the community to access.',ne,Z,Ne="This guide will show you how to create a community pipeline and explain how they work. To keep things simple, you’ll create a “one-step” pipeline where the <code>UNet</code> does a single forward pass and calls the scheduler once.",pe,_,ae,j,Ee='You should start by creating a <code>one_step_unet.py</code> file for your community pipeline. In this file, create a pipeline class that inherits from the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to be able to load model weights and the scheduler configuration from the Hub. The one-step pipeline needs a <code>UNet</code> and a scheduler, so you’ll need to add these as arguments to the <code>__init__</code> function:',oe,G,re,V,xe='To ensure your pipeline and its components (<code>unet</code> and <code>scheduler</code>) can be saved with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>, add them to the <code>register_modules</code> function:',de,$,ce,B,Qe="Cool, the <code>__init__</code> step is done and you can move to the forward pass now! 🔥",me,g,ue,C,Se="In the forward pass, which we recommend defining as <code>__call__</code>, you have complete creative freedom to add whatever feature you’d like. For our amazing one-step pipeline, create a random image and only call the <code>unet</code> and <code>scheduler</code> once by setting <code>timestep=1</code>:",fe,v,we,W,ze="That’s it! 🚀 You can now run this pipeline by passing a <code>unet</code> and <code>scheduler</code> to it:",ye,X,Me,k,Pe='But what’s even better is you can load pre-existing weights into the pipeline if the pipeline structure is identical. For example, you can load the <a href="https://huggingface.co/google/ddpm-cifar10-32" rel="nofollow"><code>google/ddpm-cifar10-32</code></a> weights into the one-step pipeline:',Te,H,Je,R,he,N,Le='Open a Pull Request on the 🧨 Diffusers <a href="https://github.com/huggingface/diffusers" rel="nofollow">repository</a> to add your awesome pipeline in <code>one_step_unet.py</code> to the <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">examples/community</a> subfolder.',be,E,Ae="Once it is merged, anyone with <code>diffusers &gt;= 0.4.0</code> installed can use this pipeline magically 🪄 by specifying it in the <code>custom_pipeline</code> argument:",Ue,x,Ie,Q,Fe='Another way to share your community pipeline is to upload the <code>one_step_unet.py</code> file directly to your preferred <a href="https://huggingface.co/docs/hub/models-uploading" rel="nofollow">model repository</a> on the Hub. Instead of specifying the <code>one_step_unet.py</code> file, pass the model repository id to the <code>custom_pipeline</code> argument:',Ze,S,_e,z,Ye="Take a look at the following table to compare the two sharing workflows to help you decide the best option for you:",je,P,De="<thead><tr><th></th> <th>GitHub community pipeline</th> <th>HF Hub community pipeline</th></tr></thead> <tbody><tr><td>usage</td> <td>same</td> <td>same</td></tr> <tr><td>review process</td> <td>open a Pull Request on GitHub and undergo a review process from the Diffusers team before merging; may be slower</td> <td>upload directly to a Hub repository without any review; this is the fastest workflow</td></tr> <tr><td>visibility</td> <td>included in the official Diffusers repository and documentation</td> <td>included on your HF Hub profile and relies on your own usage/promotion to gain visibility</td></tr></tbody>",Ge,b,Ve,L,$e,A,qe='A community pipeline is a class that inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> which means:',Be,F,Ke="<li>It can be loaded with the <code>custom_pipeline</code> argument.</li> <li>The model weights and scheduler configuration are loaded from <code>pretrained_model_name_or_path</code>.</li> <li>The code that implements a feature in the community pipeline is defined in a <code>pipeline.py</code> file.</li>",ge,Y,Oe="Sometimes you can’t load all the pipeline components weights from an official repository. In this case, the other components should be passed directly to the pipeline:",Ce,D,ve,q,el="The magic behind community pipelines is contained in the following code. It allows the community pipeline to be loaded from GitHub or the Hub, and it’ll be available to all 🧨 Diffusers packages.",We,K,Xe,O,ke,le,He;return U=new te({props:{title:"Contribute a community pipeline",local:"contribute-a-community-pipeline",headingTag:"h1"}}),h=new nl({props:{$$slots:{default:[fl]},$$scope:{ctx:ee}}}),_=new te({props:{title:"Initialize the pipeline",local:"initialize-the-pipeline",headingTag:"h2"}}),G=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjbGFzcyUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUoRGlmZnVzaW9uUGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVuZXQlMkMlMjBzY2hlZHVsZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">class</span> <span class="hljs-title class_">UnetSchedulerOneForwardPipeline</span>(<span class="hljs-title class_ inherited__">DiffusionPipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, unet, scheduler</span>):
        <span class="hljs-built_in">super</span>().__init__()`,wrap:!1}}),$=new T({props:{code:"JTIwJTIwZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMEElMjAlMjBjbGFzcyUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUoRGlmZnVzaW9uUGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVuZXQlMkMlMjBzY2hlZHVsZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZWdpc3Rlcl9tb2R1bGVzKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKQ==",highlighted:`  from diffusers import DiffusionPipeline
  import torch

  class UnetSchedulerOneForwardPipeline(DiffusionPipeline):
      def __init__(self, unet, scheduler):
          super().__init__()

<span class="hljs-addition">+         self.register_modules(unet=unet, scheduler=scheduler)</span>`,wrap:!1}}),g=new te({props:{title:"Define the forward pass",local:"define-the-forward-pass",headingTag:"h2"}}),v=new T({props:{code:"JTIwJTIwZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMEElMjAlMjBjbGFzcyUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUoRGlmZnVzaW9uUGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVuZXQlMkMlMjBzY2hlZHVsZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZWdpc3Rlcl9tb2R1bGVzKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKSUwQSUwQSUyQiUyMCUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYpJTNBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB0b3JjaC5yYW5kbiglMEElMkIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoMSUyQyUyMHNlbGYudW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBzZWxmLnVuZXQuY29uZmlnLnNhbXBsZV9zaXplJTJDJTIwc2VsZi51bmV0LmNvbmZpZy5zYW1wbGVfc2l6ZSklMkMlMEElMkIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGltZXN0ZXAlMjAlM0QlMjAxJTBBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfb3V0cHV0JTIwJTNEJTIwc2VsZi51bmV0KGltYWdlJTJDJTIwdGltZXN0ZXApLnNhbXBsZSUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjaGVkdWxlcl9vdXRwdXQlMjAlM0QlMjBzZWxmLnNjaGVkdWxlci5zdGVwKG1vZGVsX291dHB1dCUyQyUyMHRpbWVzdGVwJTJDJTIwaW1hZ2UpLnByZXZfc2FtcGxlJTBBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2NoZWR1bGVyX291dHB1dA==",highlighted:`  from diffusers import DiffusionPipeline
  import torch

  class UnetSchedulerOneForwardPipeline(DiffusionPipeline):
      def __init__(self, unet, scheduler):
          super().__init__()

          self.register_modules(unet=unet, scheduler=scheduler)

<span class="hljs-addition">+     def __call__(self):</span>
<span class="hljs-addition">+         image = torch.randn(</span>
<span class="hljs-addition">+             (1, self.unet.config.in_channels, self.unet.config.sample_size, self.unet.config.sample_size),</span>
<span class="hljs-addition">+         )</span>
<span class="hljs-addition">+         timestep = 1</span>

<span class="hljs-addition">+         model_output = self.unet(image, timestep).sample</span>
<span class="hljs-addition">+         scheduler_output = self.scheduler.step(model_output, timestep, image).prev_sample</span>

<span class="hljs-addition">+         return scheduler_output</span>`,wrap:!1}}),X=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMkMlMjBVTmV0MkRNb2RlbCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIoKSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRNb2RlbCgpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBVbmV0U2NoZWR1bGVyT25lRm9yd2FyZFBpcGVsaW5lKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKSUwQSUwQW91dHB1dCUyMCUzRCUyMHBpcGVsaW5lKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler, UNet2DModel

scheduler = DDPMScheduler()
unet = UNet2DModel()

pipeline = UnetSchedulerOneForwardPipeline(unet=unet, scheduler=scheduler)

output = pipeline()`,wrap:!1}}),H=new T({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBVbmV0U2NoZWR1bGVyT25lRm9yd2FyZFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQSUwQW91dHB1dCUyMCUzRCUyMHBpcGVsaW5lKCk=",highlighted:`pipeline = UnetSchedulerOneForwardPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)

output = pipeline()`,wrap:!1}}),R=new te({props:{title:"Share your pipeline",local:"share-your-pipeline",headingTag:"h2"}}),x=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMkMlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJvbmVfc3RlcF91bmV0JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;one_step_unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipe()`,wrap:!1}}),S=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyc3RldmhsaXUlMkZvbmVfc3RlcF91bmV0JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;stevhliu/one_step_unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),b=new nl({props:{$$slots:{default:[wl]},$$scope:{ctx:ee}}}),L=new te({props:{title:"How do community pipelines work?",local:"how-do-community-pipelines-work",headingTag:"h2"}}),D=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBJbWFnZVByb2Nlc3NvciUyQyUyMENMSVBNb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQWNsaXBfbW9kZWxfaWQlMjAlM0QlMjAlMjJsYWlvbiUyRkNMSVAtVmlULUItMzItbGFpb24yQi1zMzRCLWI3OUslMjIlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMENMSVBJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2xpcF9tb2RlbF9pZCklMEFjbGlwX21vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZChjbGlwX21vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyY2xpcF9ndWlkZWRfc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPImageProcessor, CLIPModel

model_id = <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
clip_model_id = <span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>

feature_extractor = CLIPImageProcessor.from_pretrained(clip_model_id)
clip_model = CLIPModel.from_pretrained(clip_model_id, torch_dtype=torch.float16)

pipeline = DiffusionPipeline.from_pretrained(
    model_id,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    scheduler=scheduler,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),K=new T({props:{code:"JTIzJTIwMi4lMjBMb2FkJTIwdGhlJTIwcGlwZWxpbmUlMjBjbGFzcyUyQyUyMGlmJTIwdXNpbmclMjBjdXN0b20lMjBtb2R1bGUlMjB0aGVuJTIwbG9hZCUyMGl0JTIwZnJvbSUyMHRoZSUyMEh1YiUwQSUyMyUyMGlmJTIwd2UlMjBsb2FkJTIwZnJvbSUyMGV4cGxpY2l0JTIwY2xhc3MlMkMlMjBsZXQncyUyMHVzZSUyMGl0JTBBaWYlMjBjdXN0b21fcGlwZWxpbmUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUyMCUzRCUyMGdldF9jbGFzc19mcm9tX2R5bmFtaWNfbW9kdWxlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGN1c3RvbV9waXBlbGluZSUyQyUyMG1vZHVsZV9maWxlJTNEQ1VTVE9NX1BJUEVMSU5FX0ZJTEVfTkFNRSUyQyUyMGNhY2hlX2RpciUzRGN1c3RvbV9waXBlbGluZSUwQSUyMCUyMCUyMCUyMCklMEFlbGlmJTIwY2xzJTIwISUzRCUyMERpZmZ1c2lvblBpcGVsaW5lJTNBJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlMjAlM0QlMjBjbHMlMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzX21vZHVsZSUyMCUzRCUyMGltcG9ydGxpYi5pbXBvcnRfbW9kdWxlKGNscy5fX21vZHVsZV9fLnNwbGl0KCUyMi4lMjIpJTVCMCU1RCklMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUyMCUzRCUyMGdldGF0dHIoZGlmZnVzZXJzX21vZHVsZSUyQyUyMGNvbmZpZ19kaWN0JTVCJTIyX2NsYXNzX25hbWUlMjIlNUQp",highlighted:`<span class="hljs-comment"># 2. Load the pipeline class, if using custom module then load it from the Hub</span>
<span class="hljs-comment"># if we load from explicit class, let&#x27;s use it</span>
<span class="hljs-keyword">if</span> custom_pipeline <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    pipeline_class = get_class_from_dynamic_module(
        custom_pipeline, module_file=CUSTOM_PIPELINE_FILE_NAME, cache_dir=custom_pipeline
    )
<span class="hljs-keyword">elif</span> cls != DiffusionPipeline:
    pipeline_class = cls
<span class="hljs-keyword">else</span>:
    diffusers_module = importlib.import_module(cls.__module__.split(<span class="hljs-string">&quot;.&quot;</span>)[<span class="hljs-number">0</span>])
    pipeline_class = <span class="hljs-built_in">getattr</span>(diffusers_module, config_dict[<span class="hljs-string">&quot;_class_name&quot;</span>])`,wrap:!1}}),O=new ul({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/contribute_pipeline.md"}}),{c(){p=a("meta"),M=s(),d=a("p"),J=s(),c(U.$$.fragment),ie=s(),c(h.$$.fragment),se=s(),I=a("p"),I.innerHTML=Re,ne=s(),Z=a("p"),Z.innerHTML=Ne,pe=s(),c(_.$$.fragment),ae=s(),j=a("p"),j.innerHTML=Ee,oe=s(),c(G.$$.fragment),re=s(),V=a("p"),V.innerHTML=xe,de=s(),c($.$$.fragment),ce=s(),B=a("p"),B.innerHTML=Qe,me=s(),c(g.$$.fragment),ue=s(),C=a("p"),C.innerHTML=Se,fe=s(),c(v.$$.fragment),we=s(),W=a("p"),W.innerHTML=ze,ye=s(),c(X.$$.fragment),Me=s(),k=a("p"),k.innerHTML=Pe,Te=s(),c(H.$$.fragment),Je=s(),c(R.$$.fragment),he=s(),N=a("p"),N.innerHTML=Le,be=s(),E=a("p"),E.innerHTML=Ae,Ue=s(),c(x.$$.fragment),Ie=s(),Q=a("p"),Q.innerHTML=Fe,Ze=s(),c(S.$$.fragment),_e=s(),z=a("p"),z.textContent=Ye,je=s(),P=a("table"),P.innerHTML=De,Ge=s(),c(b.$$.fragment),Ve=s(),c(L.$$.fragment),$e=s(),A=a("p"),A.innerHTML=qe,Be=s(),F=a("ul"),F.innerHTML=Ke,ge=s(),Y=a("p"),Y.textContent=Oe,Ce=s(),c(D.$$.fragment),ve=s(),q=a("p"),q.textContent=el,We=s(),c(K.$$.fragment),Xe=s(),c(O.$$.fragment),ke=s(),le=a("p"),this.h()},l(e){const l=cl("svelte-u9bgzb",document.head);p=o(l,"META",{name:!0,content:!0}),l.forEach(t),M=n(e),d=o(e,"P",{}),il(d).forEach(t),J=n(e),m(U.$$.fragment,e),ie=n(e),m(h.$$.fragment,e),se=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-18q8p0l"&&(I.innerHTML=Re),ne=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-uyw7g0"&&(Z.innerHTML=Ne),pe=n(e),m(_.$$.fragment,e),ae=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1ofdu1u"&&(j.innerHTML=Ee),oe=n(e),m(G.$$.fragment,e),re=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1efu2er"&&(V.innerHTML=xe),de=n(e),m($.$$.fragment,e),ce=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-jmgs1z"&&(B.innerHTML=Qe),me=n(e),m(g.$$.fragment,e),ue=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1l1aime"&&(C.innerHTML=Se),fe=n(e),m(v.$$.fragment,e),we=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1wqngql"&&(W.innerHTML=ze),ye=n(e),m(X.$$.fragment,e),Me=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-13itfz9"&&(k.innerHTML=Pe),Te=n(e),m(H.$$.fragment,e),Je=n(e),m(R.$$.fragment,e),he=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1okqb75"&&(N.innerHTML=Le),be=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-mmjniw"&&(E.innerHTML=Ae),Ue=n(e),m(x.$$.fragment,e),Ie=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-hpyorm"&&(Q.innerHTML=Fe),Ze=n(e),m(S.$$.fragment,e),_e=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1wdgje4"&&(z.textContent=Ye),je=n(e),P=o(e,"TABLE",{"data-svelte-h":!0}),r(P)!=="svelte-1tu2a4k"&&(P.innerHTML=De),Ge=n(e),m(b.$$.fragment,e),Ve=n(e),m(L.$$.fragment,e),$e=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1jkfcz7"&&(A.innerHTML=qe),Be=n(e),F=o(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-185ii9u"&&(F.innerHTML=Ke),ge=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-84chr9"&&(Y.textContent=Oe),Ce=n(e),m(D.$$.fragment,e),ve=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-pfjr1e"&&(q.textContent=el),We=n(e),m(K.$$.fragment,e),Xe=n(e),m(O.$$.fragment,e),ke=n(e),le=o(e,"P",{}),il(le).forEach(t),this.h()},h(){sl(p,"name","hf:doc:metadata"),sl(p,"content",Ml)},m(e,l){ml(document.head,p),i(e,M,l),i(e,d,l),i(e,J,l),u(U,e,l),i(e,ie,l),u(h,e,l),i(e,se,l),i(e,I,l),i(e,ne,l),i(e,Z,l),i(e,pe,l),u(_,e,l),i(e,ae,l),i(e,j,l),i(e,oe,l),u(G,e,l),i(e,re,l),i(e,V,l),i(e,de,l),u($,e,l),i(e,ce,l),i(e,B,l),i(e,me,l),u(g,e,l),i(e,ue,l),i(e,C,l),i(e,fe,l),u(v,e,l),i(e,we,l),i(e,W,l),i(e,ye,l),u(X,e,l),i(e,Me,l),i(e,k,l),i(e,Te,l),u(H,e,l),i(e,Je,l),u(R,e,l),i(e,he,l),i(e,N,l),i(e,be,l),i(e,E,l),i(e,Ue,l),u(x,e,l),i(e,Ie,l),i(e,Q,l),i(e,Ze,l),u(S,e,l),i(e,_e,l),i(e,z,l),i(e,je,l),i(e,P,l),i(e,Ge,l),u(b,e,l),i(e,Ve,l),u(L,e,l),i(e,$e,l),i(e,A,l),i(e,Be,l),i(e,F,l),i(e,ge,l),i(e,Y,l),i(e,Ce,l),u(D,e,l),i(e,ve,l),i(e,q,l),i(e,We,l),u(K,e,l),i(e,Xe,l),u(O,e,l),i(e,ke,l),i(e,le,l),He=!0},p(e,[l]){const ll={};l&2&&(ll.$$scope={dirty:l,ctx:e}),h.$set(ll);const tl={};l&2&&(tl.$$scope={dirty:l,ctx:e}),b.$set(tl)},i(e){He||(f(U.$$.fragment,e),f(h.$$.fragment,e),f(_.$$.fragment,e),f(G.$$.fragment,e),f($.$$.fragment,e),f(g.$$.fragment,e),f(v.$$.fragment,e),f(X.$$.fragment,e),f(H.$$.fragment,e),f(R.$$.fragment,e),f(x.$$.fragment,e),f(S.$$.fragment,e),f(b.$$.fragment,e),f(L.$$.fragment,e),f(D.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),He=!0)},o(e){w(U.$$.fragment,e),w(h.$$.fragment,e),w(_.$$.fragment,e),w(G.$$.fragment,e),w($.$$.fragment,e),w(g.$$.fragment,e),w(v.$$.fragment,e),w(X.$$.fragment,e),w(H.$$.fragment,e),w(R.$$.fragment,e),w(x.$$.fragment,e),w(S.$$.fragment,e),w(b.$$.fragment,e),w(L.$$.fragment,e),w(D.$$.fragment,e),w(K.$$.fragment,e),w(O.$$.fragment,e),He=!1},d(e){e&&(t(M),t(d),t(J),t(ie),t(se),t(I),t(ne),t(Z),t(pe),t(ae),t(j),t(oe),t(re),t(V),t(de),t(ce),t(B),t(me),t(ue),t(C),t(fe),t(we),t(W),t(ye),t(Me),t(k),t(Te),t(Je),t(he),t(N),t(be),t(E),t(Ue),t(Ie),t(Q),t(Ze),t(_e),t(z),t(je),t(P),t(Ge),t(Ve),t($e),t(A),t(Be),t(F),t(ge),t(Y),t(Ce),t(ve),t(q),t(We),t(Xe),t(ke),t(le)),t(p),y(U,e),y(h,e),y(_,e),y(G,e),y($,e),y(g,e),y(v,e),y(X,e),y(H,e),y(R,e),y(x,e),y(S,e),y(b,e),y(L,e),y(D,e),y(K,e),y(O,e)}}}const Ml='{"title":"Contribute a community pipeline","local":"contribute-a-community-pipeline","sections":[{"title":"Initialize the pipeline","local":"initialize-the-pipeline","sections":[],"depth":2},{"title":"Define the forward pass","local":"define-the-forward-pass","sections":[],"depth":2},{"title":"Share your pipeline","local":"share-your-pipeline","sections":[],"depth":2},{"title":"How do community pipelines work?","local":"how-do-community-pipelines-work","sections":[],"depth":2}],"depth":1}';function Tl(ee){return ol(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zl extends rl{constructor(p){super(),dl(this,p,Tl,yl,al,{})}}export{Zl as component};
