import{s as Nt,o as zt,n as Ue}from"../chunks/scheduler.182ea377.js";import{S as Yt,i as Ft,g as u,s as p,r as y,A as St,h as d,f as l,c as r,j as mt,u as M,x as U,k as Je,y as x,a as s,v as h,d as w,t as b,w as J}from"../chunks/index.abf12888.js";import{T as yt}from"../chunks/Tip.230e2334.js";import{C as $}from"../chunks/CodeBlock.57fe6e13.js";import{D as Lt}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as Te,E as Dt}from"../chunks/EditOnGithub.9b8e78e4.js";import{H as Qt,a as ct}from"../chunks/HfOption.fc88c804.js";function qt(g){let i,c="By loading a community pipeline from the Hugging Face Hub, you are trusting that the code you are loading is safe. Make sure to inspect the code online before loading and running it automatically!";return{c(){i=u("p"),i.textContent=c},l(a){i=d(a,"P",{"data-svelte-h":!0}),U(i)!=="svelte-1d3q3fm"&&(i.textContent=c)},m(a,m){s(a,i,m)},p:Ue,d(a){a&&l(i)}}}function Pt(g){let i,c='To load a Hugging Face Hub community pipeline, pass the repository id of the community pipeline to the <code>custom_pipeline</code> argument and the model repository where you’d like to load the pipeline weights and components from. For example, the example below loads a dummy pipeline from <a href="https://huggingface.co/hf-internal-testing/diffusers-dummy-pipeline/blob/main/pipeline.py" rel="nofollow">hf-internal-testing/diffusers-dummy-pipeline</a> and the pipeline weights and components from <a href="https://huggingface.co/google/ddpm-cifar10-32" rel="nofollow">google/ddpm-cifar10-32</a>:',a,m,o,n,T;return m=new yt({props:{warning:!0,$$slots:{default:[qt]},$$scope:{ctx:g}}}),n=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1kdW1teS1waXBlbGluZSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;hf-internal-testing/diffusers-dummy-pipeline&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),{c(){i=u("p"),i.innerHTML=c,a=p(),y(m.$$.fragment),o=p(),y(n.$$.fragment)},l(f){i=d(f,"P",{"data-svelte-h":!0}),U(i)!=="svelte-he2t9o"&&(i.innerHTML=c),a=r(f),M(m.$$.fragment,f),o=r(f),M(n.$$.fragment,f)},m(f,Z){s(f,i,Z),s(f,a,Z),h(m,f,Z),s(f,o,Z),h(n,f,Z),T=!0},p(f,Z){const R={};Z&2&&(R.$$scope={dirty:Z,ctx:f}),m.$set(R)},i(f){T||(w(m.$$.fragment,f),w(n.$$.fragment,f),T=!0)},o(f){b(m.$$.fragment,f),b(n.$$.fragment,f),T=!1},d(f){f&&(l(i),l(a),l(o)),J(m,f),J(n,f)}}}function At(g){let i,c='To load a GitHub community pipeline, pass the repository id of the community pipeline to the <code>custom_pipeline</code> argument and the model repository where you you’d like to load the pipeline weights and components from. You can also load model components directly. The example below loads the community <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#clip-guided-stable-diffusion" rel="nofollow">CLIP Guided Stable Diffusion</a> pipeline and the CLIP model components.',a,m,o;return m=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBJbWFnZVByb2Nlc3NvciUyQyUyMENMSVBNb2RlbCUwQSUwQWNsaXBfbW9kZWxfaWQlMjAlM0QlMjAlMjJsYWlvbiUyRkNMSVAtVmlULUItMzItbGFpb24yQi1zMzRCLWI3OUslMjIlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMENMSVBJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2xpcF9tb2RlbF9pZCklMEFjbGlwX21vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZChjbGlwX21vZGVsX2lkKSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyY2xpcF9ndWlkZWRfc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPImageProcessor, CLIPModel

clip_model_id = <span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>

feature_extractor = CLIPImageProcessor.from_pretrained(clip_model_id)
clip_model = CLIPModel.from_pretrained(clip_model_id)

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){i=u("p"),i.innerHTML=c,a=p(),y(m.$$.fragment)},l(n){i=d(n,"P",{"data-svelte-h":!0}),U(i)!=="svelte-wu4rdv"&&(i.innerHTML=c),a=r(n),M(m.$$.fragment,n)},m(n,T){s(n,i,T),s(n,a,T),h(m,n,T),o=!0},p:Ue,i(n){o||(w(m.$$.fragment,n),o=!0)},o(n){b(m.$$.fragment,n),o=!1},d(n){n&&(l(i),l(a)),J(m,n)}}}function Kt(g){let i,c,a,m;return i=new ct({props:{id:"community",option:"Hub pipelines",$$slots:{default:[Pt]},$$scope:{ctx:g}}}),a=new ct({props:{id:"community",option:"GitHub pipelines",$$slots:{default:[At]},$$scope:{ctx:g}}}),{c(){y(i.$$.fragment),c=p(),y(a.$$.fragment)},l(o){M(i.$$.fragment,o),c=r(o),M(a.$$.fragment,o)},m(o,n){h(i,o,n),s(o,c,n),h(a,o,n),m=!0},p(o,n){const T={};n&2&&(T.$$scope={dirty:n,ctx:o}),i.$set(T);const f={};n&2&&(f.$$scope={dirty:n,ctx:o}),a.$set(f)},i(o){m||(w(i.$$.fragment,o),w(a.$$.fragment,o),m=!0)},o(o){b(i.$$.fragment,o),b(a.$$.fragment,o),m=!1},d(o){o&&l(c),J(i,o),J(a,o)}}}function Ot(g){let i,c="For example, to load from the main branch:",a,m,o;return m=new $({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJjbGlwX2d1aWRlZF9zdGFibGVfZGlmZnVzaW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JldmlzaW9uJTNEJTIybWFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    custom_revision=<span class="hljs-string">&quot;main&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){i=u("p"),i.textContent=c,a=p(),y(m.$$.fragment)},l(n){i=d(n,"P",{"data-svelte-h":!0}),U(i)!=="svelte-s49pqe"&&(i.textContent=c),a=r(n),M(m.$$.fragment,n)},m(n,T){s(n,i,T),s(n,a,T),h(m,n,T),o=!0},p:Ue,i(n){o||(w(m.$$.fragment,n),o=!0)},o(n){b(m.$$.fragment,n),o=!1},d(n){n&&(l(i),l(a)),J(m,n)}}}function el(g){let i,c="For example, to load from a previous version of Diffusers like v0.25.0:",a,m,o;return m=new $({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJjbGlwX2d1aWRlZF9zdGFibGVfZGlmZnVzaW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JldmlzaW9uJTNEJTIydjAuMjUuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    custom_revision=<span class="hljs-string">&quot;v0.25.0&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){i=u("p"),i.textContent=c,a=p(),y(m.$$.fragment)},l(n){i=d(n,"P",{"data-svelte-h":!0}),U(i)!=="svelte-1npkm46"&&(i.textContent=c),a=r(n),M(m.$$.fragment,n)},m(n,T){s(n,i,T),s(n,a,T),h(m,n,T),o=!0},p:Ue,i(n){o||(w(m.$$.fragment,n),o=!0)},o(n){b(m.$$.fragment,n),o=!1},d(n){n&&(l(i),l(a)),J(m,n)}}}function tl(g){let i,c,a,m;return i=new ct({props:{id:"version",option:"main",$$slots:{default:[Ot]},$$scope:{ctx:g}}}),a=new ct({props:{id:"version",option:"older version",$$slots:{default:[el]},$$scope:{ctx:g}}}),{c(){y(i.$$.fragment),c=p(),y(a.$$.fragment)},l(o){M(i.$$.fragment,o),c=r(o),M(a.$$.fragment,o)},m(o,n){h(i,o,n),s(o,c,n),h(a,o,n),m=!0},p(o,n){const T={};n&2&&(T.$$scope={dirty:n,ctx:o}),i.$set(T);const f={};n&2&&(f.$$scope={dirty:n,ctx:o}),a.$set(f)},i(o){m||(w(i.$$.fragment,o),w(a.$$.fragment,o),m=!0)},o(o){b(i.$$.fragment,o),b(a.$$.fragment,o),m=!1},d(o){o&&l(c),J(i,o),J(a,o)}}}function ll(g){let i,c='In steps 4 and 5, the custom <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">UNet</a> and <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">pipeline</a> implementation must match the format shown in their files for this example to work.';return{c(){i=u("p"),i.innerHTML=c},l(a){i=d(a,"P",{"data-svelte-h":!0}),U(i)!=="svelte-ptu9pr"&&(i.innerHTML=c)},m(a,m){s(a,i,m)},p:Ue,d(a){a&&l(i)}}}function il(g){let i,c='As an additional precaution with <code>trust_remote_code=True</code>, we strongly encourage you to pass a commit hash to the <code>revision</code> parameter in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to make sure the code hasn’t been updated with some malicious new lines of code (unless you fully trust the model owners).';return{c(){i=u("p"),i.innerHTML=c},l(a){i=d(a,"P",{"data-svelte-h":!0}),U(i)!=="svelte-1c30fnc"&&(i.innerHTML=c)},m(a,m){s(a,i,m)},p:Ue,d(a){a&&l(i)}}}function sl(g){let i,c,a,m,o,n,T,f,Z,R,H,Mt='Community pipelines are any <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class that are different from the original paper implementation (for example, the <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> corresponds to the <a href="https://arxiv.org/abs/2302.05543" rel="nofollow">Text-to-Image Generation with ControlNet Conditioning</a> paper). They provide additional functionality or extend the original implementation of a pipeline.',Ze,X,ht='There are many cool community pipelines like <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#marigold-depth-estimation" rel="nofollow">Marigold Depth Estimation</a> or <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#instantid-pipeline" rel="nofollow">InstantID</a>, and you can find all the official community pipelines <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">here</a>.',$e,E,wt='There are two types of community pipelines, those stored on the Hugging Face Hub and those stored on Diffusers GitHub repository. Hub pipelines are completely customizable (scheduler, models, pipeline code, etc.) while Diffusers GitHub pipelines are only limited to custom pipeline code. Refer to this <a href="./contribute_pipeline#share-your-pipeline">table</a> for a more detailed comparison of Hub vs GitHub community pipelines.',_e,I,Ge,Q,je,N,bt="Community pipelines can also be loaded from a local file if you pass a file path instead. The path to the passed directory must contain a pipeline.py file that contains the pipeline class.",Ie,z,Ve,Y,ve,F,Jt="By default, community pipelines are loaded from the latest stable version of Diffusers. To load a community pipeline from another version, use the <code>custom_revision</code> parameter.",We,V,Ce,S,Be,L,Tt='Community pipelines can also be loaded with the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> method which allows you to load and reuse multiple pipelines without any additional memory overhead (learn more in the <a href="./loading#reuse-a-pipeline">Reuse a pipeline</a> guide). The memory requirement is determined by the largest single pipeline loaded.',ke,D,Ut='For example, let’s load a community pipeline that supports <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#long-prompt-weighting-stable-diffusion" rel="nofollow">long prompts with weighting</a> from a Stable Diffusion pipeline.',xe,q,Re,v,gt='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/from_pipe_lpw.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Stable Diffusion with long prompt weighting</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/from_pipe_non_lpw.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Stable Diffusion</figcaption></div>',He,P,Xe,A,Zt="Community components allow users to build pipelines that may have customized components that are not a part of Diffusers. If your pipeline has custom components that Diffusers doesn’t already support, you need to provide their implementations as Python modules. These customized components could be a VAE, UNet, and scheduler. In most cases, the text encoder is imported from the Transformers library. The pipeline code itself can also be customized.",Ee,K,$t="This section shows how users should use community components to build a community pipeline.",Qe,O,_t='You’ll use the <a href="https://huggingface.co/showlab/show-1-base" rel="nofollow">showlab/show-1-base</a> pipeline checkpoint as an example.',Ne,ee,Gt="<li>Import and load the text encoder from Transformers:</li>",ze,te,Ye,W,jt="<li>Load a scheduler:</li>",Fe,le,Se,C,It="<li>Load an image processor:</li>",Le,ie,De,B,qe,_,G,he,Vt='Now you’ll load a <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">custom UNet</a>, which in this example, has already been implemented in <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">showone_unet_3d_condition.py</a> for your convenience. You’ll notice the <a href="/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> class name is changed to <code>ShowOneUNet3DConditionModel</code> because <a href="/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> already exists in Diffusers. Any components needed for the <code>ShowOneUNet3DConditionModel</code> class should be placed in showone_unet_3d_condition.py.',ut,we,vt="Once this is done, you can initialize the UNet:",dt,se,ft,be,Wt='<p>Finally, you’ll load the custom pipeline code. For this example, it has already been created for you in <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/pipeline_t2v_base_pixel.py" rel="nofollow">pipeline_t2v_base_pixel.py</a>. This script contains a custom <code>TextToVideoIFPipeline</code> class for generating videos from text. Just like the custom UNet, any code needed for the custom pipeline to work should go in pipeline_t2v_base_pixel.py.</p>',Pe,ne,Ct="Once everything is in place, you can initialize the <code>TextToVideoIFPipeline</code> with the <code>ShowOneUNet3DConditionModel</code>:",Ae,oe,Ke,ae,Bt="Push the pipeline to the Hub to share with the community!",Oe,pe,et,re,kt="After the pipeline is successfully pushed, you need to make a few changes:",tt,me,xt='<li>Change the <code>_class_name</code> attribute in <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/model_index.json#L2" rel="nofollow">model_index.json</a> to <code>&quot;pipeline_t2v_base_pixel&quot;</code> and <code>&quot;TextToVideoIFPipeline&quot;</code>.</li> <li>Upload <code>showone_unet_3d_condition.py</code> to the <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">unet</a> subfolder.</li> <li>Upload <code>pipeline_t2v_base_pixel.py</code> to the pipeline <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/tree/main" rel="nofollow">repository</a>.</li>',lt,ce,Rt="To run inference, add the <code>trust_remote_code</code> argument while initializing the pipeline to handle all the “magic” behind the scenes.",it,k,st,ue,nt,de,Ht='As an additional reference, take a look at the repository structure of <a href="https://huggingface.co/stabilityai/japanese-stable-diffusion-xl/" rel="nofollow">stabilityai/japanese-stable-diffusion-xl</a> which also uses the <code>trust_remote_code</code> feature.',ot,fe,at,ye,pt,ge,rt;return o=new Te({props:{title:"Load community pipelines and components",local:"load-community-pipelines-and-components",headingTag:"h1"}}),T=new Lt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"}]}}),Z=new Te({props:{title:"Community pipelines",local:"community-pipelines",headingTag:"h2"}}),I=new Qt({props:{id:"community",options:["Hub pipelines","GitHub pipelines"],$$slots:{default:[Kt]},$$scope:{ctx:g}}}),Q=new Te({props:{title:"Load from a local file",local:"load-from-a-local-file",headingTag:"h3"}}),z=new $({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjIuJTJGcGF0aCUyRnRvJTJGcGlwZWxpbmVfZGlyZWN0b3J5JTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwY2xpcF9tb2RlbCUzRGNsaXBfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBmZWF0dXJlX2V4dHJhY3RvciUzRGZlYXR1cmVfZXh0cmFjdG9yJTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSk=",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;./path/to/pipeline_directory/&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),Y=new Te({props:{title:"Load from a specific version",local:"load-from-a-specific-version",headingTag:"h3"}}),V=new Qt({props:{id:"version",options:["main","older version"],$$slots:{default:[tl]},$$scope:{ctx:g}}}),S=new Te({props:{title:"Load with from_pipe",local:"load-with-frompipe",headingTag:"h3"}}),q=new $({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe_sd = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/CyberRealistic_V3&quot;</span>, torch_dtype=torch.float16)
pipe_sd.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-comment"># load long prompt weighting pipeline</span>
pipe_lpw = DiffusionPipeline.from_pipe(
    pipe_sd,
    custom_pipeline=<span class="hljs-string">&quot;lpw_stable_diffusion&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;cat, hiding in the leaves, ((rain)), zazie rainyday, beautiful eyes, macro shot, colorful details, natural lighting, amazing composition, subsurface scattering, amazing textures, filmic, soft light, ultra-detailed eyes, intricate details, detailed texture, light source contrast, dramatic shadows, cinematic light, depth of field, film grain, noise, dark background, hyperrealistic dslr film still, dim volumetric cinematic lighting&quot;</span>
neg_prompt = <span class="hljs-string">&quot;(deformed iris, deformed pupils, semi-realistic, cgi, 3d, render, sketch, cartoon, drawing, anime, mutated hands and fingers:1.4), (deformed, distorted, disfigured:1.3), poorly drawn, bad anatomy, wrong anatomy, extra limb, missing limb, floating limbs, disconnected limbs, mutation, mutated, ugly, disgusting, amputation&quot;</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">20</span>)
out_lpw = pipe_lpw(
    prompt, 
    negative_prompt=neg_prompt, 
    width=<span class="hljs-number">512</span>,
    height=<span class="hljs-number">512</span>,
    max_embeddings_multiples=<span class="hljs-number">3</span>, 
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
    ).images[<span class="hljs-number">0</span>]
out_lpw`,wrap:!1}}),P=new Te({props:{title:"Community components",local:"community-components",headingTag:"h2"}}),te=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1VG9rZW5pemVyJTJDJTIwVDVFbmNvZGVyTW9kZWwlMEElMEFwaXBlX2lkJTIwJTNEJTIwJTIyc2hvd2xhYiUyRnNob3ctMS1iYXNlJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwVDVUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIpJTBBdGV4dF9lbmNvZGVyJTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5Tokenizer, T5EncoderModel

pipe_id = <span class="hljs-string">&quot;showlab/show-1-base&quot;</span>
tokenizer = T5Tokenizer.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)
text_encoder = T5EncoderModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>)`,wrap:!1}}),le=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

scheduler = DPMSolverMultistepScheduler.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)`,wrap:!1}}),ie=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBDTElQRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMmZlYXR1cmVfZXh0cmFjdG9yJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPFeatureExtractor

feature_extractor = CLIPFeatureExtractor.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;feature_extractor&quot;</span>)`,wrap:!1}}),B=new yt({props:{warning:!0,$$slots:{default:[ll]},$$scope:{ctx:g}}}),se=new $({props:{code:"ZnJvbSUyMHNob3dvbmVfdW5ldF8zZF9jb25kaXRpb24lMjBpbXBvcnQlMjBTaG93T25lVU5ldDNEQ29uZGl0aW9uTW9kZWwlMEElMEF1bmV0JTIwJTNEJTIwU2hvd09uZVVOZXQzRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZChwaXBlX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMik=",highlighted:`<span class="hljs-keyword">from</span> showone_unet_3d_condition <span class="hljs-keyword">import</span> ShowOneUNet3DConditionModel

unet = ShowOneUNet3DConditionModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),oe=new $({props:{code:"ZnJvbSUyMHBpcGVsaW5lX3Qydl9iYXNlX3BpeGVsJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9JRlBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMFRleHRUb1ZpZGVvSUZQaXBlbGluZSglMEElMjAlMjAlMjAlMjB1bmV0JTNEdW5ldCUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRHRleHRfZW5jb2RlciUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEZmVhdHVyZV9leHRyYWN0b3IlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byhkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQXBpcGVsaW5lLnRvcmNoX2R0eXBlJTIwJTNEJTIwdG9yY2guZmxvYXQxNg==",highlighted:`<span class="hljs-keyword">from</span> pipeline_t2v_base_pixel <span class="hljs-keyword">import</span> TextToVideoIFPipeline
<span class="hljs-keyword">import</span> torch

pipeline = TextToVideoIFPipeline(
    unet=unet,
    text_encoder=text_encoder,
    tokenizer=tokenizer,
    scheduler=scheduler,
    feature_extractor=feature_extractor
)
pipeline = pipeline.to(device=<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.torch_dtype = torch.float16`,wrap:!1}}),pe=new $({props:{code:"cGlwZWxpbmUucHVzaF90b19odWIoJTIyY3VzdG9tLXQydi1waXBlbGluZSUyMik=",highlighted:'pipeline.push_to_hub(<span class="hljs-string">&quot;custom-t2v-pipeline&quot;</span>)',wrap:!1}}),k=new yt({props:{warning:!0,$$slots:{default:[il]},$$scope:{ctx:g}}}),ue=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIlM0NjaGFuZ2UtdXNlcm5hbWUlM0UlMkYlM0NjaGFuZ2UtaWQlM0UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyaGVsbG8lMjIlMEElMEElMjMlMjBUZXh0JTIwZW1iZWRzJTBBcHJvbXB0X2VtYmVkcyUyQyUyMG5lZ2F0aXZlX2VtYmVkcyUyMCUzRCUyMHBpcGVsaW5lLmVuY29kZV9wcm9tcHQocHJvbXB0KSUwQSUwQSUyMyUyMEtleWZyYW1lcyUyMGdlbmVyYXRpb24lMjAoOHg2NHg0MCUyQyUyMDJmcHMpJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEbmVnYXRpdmVfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDglMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENjQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOS4wJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJwdCUyMiUwQSkuZnJhbWVz",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;&lt;change-username&gt;/&lt;change-id&gt;&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;hello&quot;</span>

<span class="hljs-comment"># Text embeds</span>
prompt_embeds, negative_embeds = pipeline.encode_prompt(prompt)

<span class="hljs-comment"># Keyframes generation (8x64x40, 2fps)</span>
video_frames = pipeline(
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=negative_embeds,
    num_frames=<span class="hljs-number">8</span>,
    height=<span class="hljs-number">40</span>,
    width=<span class="hljs-number">64</span>,
    num_inference_steps=<span class="hljs-number">2</span>,
    guidance_scale=<span class="hljs-number">9.0</span>,
    output_type=<span class="hljs-string">&quot;pt&quot;</span>
).frames`,wrap:!1}}),fe=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRmphcGFuZXNlLXN0YWJsZS1kaWZmdXNpb24teGwlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEpJTBBcGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/japanese-stable-diffusion-xl&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>
)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),ye=new Dt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/custom_pipeline_overview.md"}}),{c(){i=u("meta"),c=p(),a=u("p"),m=p(),y(o.$$.fragment),n=p(),y(T.$$.fragment),f=p(),y(Z.$$.fragment),R=p(),H=u("p"),H.innerHTML=Mt,Ze=p(),X=u("p"),X.innerHTML=ht,$e=p(),E=u("p"),E.innerHTML=wt,_e=p(),y(I.$$.fragment),Ge=p(),y(Q.$$.fragment),je=p(),N=u("p"),N.textContent=bt,Ie=p(),y(z.$$.fragment),Ve=p(),y(Y.$$.fragment),ve=p(),F=u("p"),F.innerHTML=Jt,We=p(),y(V.$$.fragment),Ce=p(),y(S.$$.fragment),Be=p(),L=u("p"),L.innerHTML=Tt,ke=p(),D=u("p"),D.innerHTML=Ut,xe=p(),y(q.$$.fragment),Re=p(),v=u("div"),v.innerHTML=gt,He=p(),y(P.$$.fragment),Xe=p(),A=u("p"),A.textContent=Zt,Ee=p(),K=u("p"),K.textContent=$t,Qe=p(),O=u("p"),O.innerHTML=_t,Ne=p(),ee=u("ol"),ee.innerHTML=Gt,ze=p(),y(te.$$.fragment),Ye=p(),W=u("ol"),W.innerHTML=jt,Fe=p(),y(le.$$.fragment),Se=p(),C=u("ol"),C.innerHTML=It,Le=p(),y(ie.$$.fragment),De=p(),y(B.$$.fragment),qe=p(),_=u("ol"),G=u("li"),he=u("p"),he.innerHTML=Vt,ut=p(),we=u("p"),we.textContent=vt,dt=p(),y(se.$$.fragment),ft=p(),be=u("li"),be.innerHTML=Wt,Pe=p(),ne=u("p"),ne.innerHTML=Ct,Ae=p(),y(oe.$$.fragment),Ke=p(),ae=u("p"),ae.textContent=Bt,Oe=p(),y(pe.$$.fragment),et=p(),re=u("p"),re.textContent=kt,tt=p(),me=u("ol"),me.innerHTML=xt,lt=p(),ce=u("p"),ce.innerHTML=Rt,it=p(),y(k.$$.fragment),st=p(),y(ue.$$.fragment),nt=p(),de=u("p"),de.innerHTML=Ht,ot=p(),y(fe.$$.fragment),at=p(),y(ye.$$.fragment),pt=p(),ge=u("p"),this.h()},l(e){const t=St("svelte-u9bgzb",document.head);i=d(t,"META",{name:!0,content:!0}),t.forEach(l),c=r(e),a=d(e,"P",{}),mt(a).forEach(l),m=r(e),M(o.$$.fragment,e),n=r(e),M(T.$$.fragment,e),f=r(e),M(Z.$$.fragment,e),R=r(e),H=d(e,"P",{"data-svelte-h":!0}),U(H)!=="svelte-rtgoii"&&(H.innerHTML=Mt),Ze=r(e),X=d(e,"P",{"data-svelte-h":!0}),U(X)!=="svelte-1um0op1"&&(X.innerHTML=ht),$e=r(e),E=d(e,"P",{"data-svelte-h":!0}),U(E)!=="svelte-1bcjewd"&&(E.innerHTML=wt),_e=r(e),M(I.$$.fragment,e),Ge=r(e),M(Q.$$.fragment,e),je=r(e),N=d(e,"P",{"data-svelte-h":!0}),U(N)!=="svelte-1ydiyl5"&&(N.textContent=bt),Ie=r(e),M(z.$$.fragment,e),Ve=r(e),M(Y.$$.fragment,e),ve=r(e),F=d(e,"P",{"data-svelte-h":!0}),U(F)!=="svelte-17rlizh"&&(F.innerHTML=Jt),We=r(e),M(V.$$.fragment,e),Ce=r(e),M(S.$$.fragment,e),Be=r(e),L=d(e,"P",{"data-svelte-h":!0}),U(L)!=="svelte-19exod8"&&(L.innerHTML=Tt),ke=r(e),D=d(e,"P",{"data-svelte-h":!0}),U(D)!=="svelte-p2flxu"&&(D.innerHTML=Ut),xe=r(e),M(q.$$.fragment,e),Re=r(e),v=d(e,"DIV",{class:!0,"data-svelte-h":!0}),U(v)!=="svelte-108dts5"&&(v.innerHTML=gt),He=r(e),M(P.$$.fragment,e),Xe=r(e),A=d(e,"P",{"data-svelte-h":!0}),U(A)!=="svelte-1vh7uou"&&(A.textContent=Zt),Ee=r(e),K=d(e,"P",{"data-svelte-h":!0}),U(K)!=="svelte-phpvnj"&&(K.textContent=$t),Qe=r(e),O=d(e,"P",{"data-svelte-h":!0}),U(O)!=="svelte-10zn7oi"&&(O.innerHTML=_t),Ne=r(e),ee=d(e,"OL",{"data-svelte-h":!0}),U(ee)!=="svelte-8ccbl9"&&(ee.innerHTML=Gt),ze=r(e),M(te.$$.fragment,e),Ye=r(e),W=d(e,"OL",{start:!0,"data-svelte-h":!0}),U(W)!=="svelte-1rtkhjg"&&(W.innerHTML=jt),Fe=r(e),M(le.$$.fragment,e),Se=r(e),C=d(e,"OL",{start:!0,"data-svelte-h":!0}),U(C)!=="svelte-o9t4x9"&&(C.innerHTML=It),Le=r(e),M(ie.$$.fragment,e),De=r(e),M(B.$$.fragment,e),qe=r(e),_=d(e,"OL",{start:!0});var Me=mt(_);G=d(Me,"LI",{});var j=mt(G);he=d(j,"P",{"data-svelte-h":!0}),U(he)!=="svelte-d8m38a"&&(he.innerHTML=Vt),ut=r(j),we=d(j,"P",{"data-svelte-h":!0}),U(we)!=="svelte-4yol19"&&(we.textContent=vt),dt=r(j),M(se.$$.fragment,j),j.forEach(l),ft=r(Me),be=d(Me,"LI",{"data-svelte-h":!0}),U(be)!=="svelte-u0mc44"&&(be.innerHTML=Wt),Me.forEach(l),Pe=r(e),ne=d(e,"P",{"data-svelte-h":!0}),U(ne)!=="svelte-1jpprmd"&&(ne.innerHTML=Ct),Ae=r(e),M(oe.$$.fragment,e),Ke=r(e),ae=d(e,"P",{"data-svelte-h":!0}),U(ae)!=="svelte-14lz5yb"&&(ae.textContent=Bt),Oe=r(e),M(pe.$$.fragment,e),et=r(e),re=d(e,"P",{"data-svelte-h":!0}),U(re)!=="svelte-1gts2xf"&&(re.textContent=kt),tt=r(e),me=d(e,"OL",{"data-svelte-h":!0}),U(me)!=="svelte-1ymo6a8"&&(me.innerHTML=xt),lt=r(e),ce=d(e,"P",{"data-svelte-h":!0}),U(ce)!=="svelte-3cd5s4"&&(ce.innerHTML=Rt),it=r(e),M(k.$$.fragment,e),st=r(e),M(ue.$$.fragment,e),nt=r(e),de=d(e,"P",{"data-svelte-h":!0}),U(de)!=="svelte-78djp3"&&(de.innerHTML=Ht),ot=r(e),M(fe.$$.fragment,e),at=r(e),M(ye.$$.fragment,e),pt=r(e),ge=d(e,"P",{}),mt(ge).forEach(l),this.h()},h(){Je(i,"name","hf:doc:metadata"),Je(i,"content",nl),Je(v,"class","flex gap-4"),Je(W,"start","2"),Je(C,"start","3"),Je(_,"start","4")},m(e,t){x(document.head,i),s(e,c,t),s(e,a,t),s(e,m,t),h(o,e,t),s(e,n,t),h(T,e,t),s(e,f,t),h(Z,e,t),s(e,R,t),s(e,H,t),s(e,Ze,t),s(e,X,t),s(e,$e,t),s(e,E,t),s(e,_e,t),h(I,e,t),s(e,Ge,t),h(Q,e,t),s(e,je,t),s(e,N,t),s(e,Ie,t),h(z,e,t),s(e,Ve,t),h(Y,e,t),s(e,ve,t),s(e,F,t),s(e,We,t),h(V,e,t),s(e,Ce,t),h(S,e,t),s(e,Be,t),s(e,L,t),s(e,ke,t),s(e,D,t),s(e,xe,t),h(q,e,t),s(e,Re,t),s(e,v,t),s(e,He,t),h(P,e,t),s(e,Xe,t),s(e,A,t),s(e,Ee,t),s(e,K,t),s(e,Qe,t),s(e,O,t),s(e,Ne,t),s(e,ee,t),s(e,ze,t),h(te,e,t),s(e,Ye,t),s(e,W,t),s(e,Fe,t),h(le,e,t),s(e,Se,t),s(e,C,t),s(e,Le,t),h(ie,e,t),s(e,De,t),h(B,e,t),s(e,qe,t),s(e,_,t),x(_,G),x(G,he),x(G,ut),x(G,we),x(G,dt),h(se,G,null),x(_,ft),x(_,be),s(e,Pe,t),s(e,ne,t),s(e,Ae,t),h(oe,e,t),s(e,Ke,t),s(e,ae,t),s(e,Oe,t),h(pe,e,t),s(e,et,t),s(e,re,t),s(e,tt,t),s(e,me,t),s(e,lt,t),s(e,ce,t),s(e,it,t),h(k,e,t),s(e,st,t),h(ue,e,t),s(e,nt,t),s(e,de,t),s(e,ot,t),h(fe,e,t),s(e,at,t),h(ye,e,t),s(e,pt,t),s(e,ge,t),rt=!0},p(e,[t]){const Me={};t&2&&(Me.$$scope={dirty:t,ctx:e}),I.$set(Me);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),V.$set(j);const Xt={};t&2&&(Xt.$$scope={dirty:t,ctx:e}),B.$set(Xt);const Et={};t&2&&(Et.$$scope={dirty:t,ctx:e}),k.$set(Et)},i(e){rt||(w(o.$$.fragment,e),w(T.$$.fragment,e),w(Z.$$.fragment,e),w(I.$$.fragment,e),w(Q.$$.fragment,e),w(z.$$.fragment,e),w(Y.$$.fragment,e),w(V.$$.fragment,e),w(S.$$.fragment,e),w(q.$$.fragment,e),w(P.$$.fragment,e),w(te.$$.fragment,e),w(le.$$.fragment,e),w(ie.$$.fragment,e),w(B.$$.fragment,e),w(se.$$.fragment,e),w(oe.$$.fragment,e),w(pe.$$.fragment,e),w(k.$$.fragment,e),w(ue.$$.fragment,e),w(fe.$$.fragment,e),w(ye.$$.fragment,e),rt=!0)},o(e){b(o.$$.fragment,e),b(T.$$.fragment,e),b(Z.$$.fragment,e),b(I.$$.fragment,e),b(Q.$$.fragment,e),b(z.$$.fragment,e),b(Y.$$.fragment,e),b(V.$$.fragment,e),b(S.$$.fragment,e),b(q.$$.fragment,e),b(P.$$.fragment,e),b(te.$$.fragment,e),b(le.$$.fragment,e),b(ie.$$.fragment,e),b(B.$$.fragment,e),b(se.$$.fragment,e),b(oe.$$.fragment,e),b(pe.$$.fragment,e),b(k.$$.fragment,e),b(ue.$$.fragment,e),b(fe.$$.fragment,e),b(ye.$$.fragment,e),rt=!1},d(e){e&&(l(c),l(a),l(m),l(n),l(f),l(R),l(H),l(Ze),l(X),l($e),l(E),l(_e),l(Ge),l(je),l(N),l(Ie),l(Ve),l(ve),l(F),l(We),l(Ce),l(Be),l(L),l(ke),l(D),l(xe),l(Re),l(v),l(He),l(Xe),l(A),l(Ee),l(K),l(Qe),l(O),l(Ne),l(ee),l(ze),l(Ye),l(W),l(Fe),l(Se),l(C),l(Le),l(De),l(qe),l(_),l(Pe),l(ne),l(Ae),l(Ke),l(ae),l(Oe),l(et),l(re),l(tt),l(me),l(lt),l(ce),l(it),l(st),l(nt),l(de),l(ot),l(at),l(pt),l(ge)),l(i),J(o,e),J(T,e),J(Z,e),J(I,e),J(Q,e),J(z,e),J(Y,e),J(V,e),J(S,e),J(q,e),J(P,e),J(te,e),J(le,e),J(ie,e),J(B,e),J(se),J(oe,e),J(pe,e),J(k,e),J(ue,e),J(fe,e),J(ye,e)}}}const nl='{"title":"Load community pipelines and components","local":"load-community-pipelines-and-components","sections":[{"title":"Community pipelines","local":"community-pipelines","sections":[{"title":"Load from a local file","local":"load-from-a-local-file","sections":[],"depth":3},{"title":"Load from a specific version","local":"load-from-a-specific-version","sections":[],"depth":3},{"title":"Load with from_pipe","local":"load-with-frompipe","sections":[],"depth":3}],"depth":2},{"title":"Community components","local":"community-components","sections":[],"depth":2}],"depth":1}';function ol(g){return zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fl extends Yt{constructor(i){super(),Ft(this,i,ol,sl,Nt,{})}}export{fl as component};
