import{s as Ha,o as Qa,n as B}from"../chunks/scheduler.182ea377.js";import{S as Aa,i as Sa,g as o,s as n,r as y,A as za,h as r,f as l,c as i,j as Na,u as f,x as d,k as V,y as Ea,a,v as g,d as h,t as J,w as U}from"../chunks/index.abf12888.js";import{T as dt}from"../chunks/Tip.230e2334.js";import{C as v}from"../chunks/CodeBlock.57fe6e13.js";import{H as x,E as qa}from"../chunks/EditOnGithub.9b8e78e4.js";import{H as La,a as Hl}from"../chunks/HfOption.fc88c804.js";function Pa(C){let p,w='Learn how to load an IP-Adapter in the <a href="../using-diffusers/loading_adapters#ip-adapter">Load adapters</a> guide, and make sure you check out the <a href="../using-diffusers/loading_adapters#ip-adapter-plus">IP-Adapter Plus</a> section which requires manually loading the image encoder.';return{c(){p=o("p"),p.innerHTML=w},l(m){p=r(m,"P",{"data-svelte-h":!0}),d(p)!=="svelte-1lc7m22"&&(p.innerHTML=w)},m(m,M){a(m,p,M)},p:B,d(m){m&&l(p)}}}function Da(C){let p,w='In the examples below, try adding <code>low_cpu_mem_usage=True</code> to the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method to speed up the loading time.';return{c(){p=o("p"),p.innerHTML=w},l(m){p=r(m,"P",{"data-svelte-h":!0}),d(p)!=="svelte-19gi0uq"&&(p.innerHTML=w)},m(m,M){a(m,p,M)},p:B,d(m){m&&l(p)}}}function Ka(C){let p,w="Crafting the precise text prompt to generate the image you want can be difficult because it may not always capture what you’d like to express. Adding an image alongside the text prompt helps the model better understand what it should generate and can lead to more accurate results.",m,M,G='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',_,Z,I,c,j="Create a text prompt and load an image prompt before passing them to the pipeline to generate an image.",X,T,k,W,R='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner_2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',u;return Z=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyaXAtYWRhcHRlcl9zZHhsLmJpbiUyMiklMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),T=new v({props:{code:"aW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfZGluZXIucG5nJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMHBvbGFyJTIwYmVhciUyMHNpdHRpbmclMjBpbiUyMGElMjBjaGFpciUyMGRyaW5raW5nJTIwYSUyMG1pbGtzaGFrZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmRlZm9ybWVkJTJDJTIwdWdseSUyQyUyMHdyb25nJTIwcHJvcG9ydGlvbiUyQyUyMGxvdyUyMHJlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){p=o("p"),p.textContent=w,m=n(),M=o("p"),M.innerHTML=G,_=n(),y(Z.$$.fragment),I=n(),c=o("p"),c.textContent=j,X=n(),y(T.$$.fragment),k=n(),W=o("div"),W.innerHTML=R,this.h()},l(s){p=r(s,"P",{"data-svelte-h":!0}),d(p)!=="svelte-1kuilfu"&&(p.textContent=w),m=i(s),M=r(s,"P",{"data-svelte-h":!0}),d(M)!=="svelte-10sdaqe"&&(M.innerHTML=G),_=i(s),f(Z.$$.fragment,s),I=i(s),c=r(s,"P",{"data-svelte-h":!0}),d(c)!=="svelte-yvbljp"&&(c.textContent=j),X=i(s),f(T.$$.fragment,s),k=i(s),W=r(s,"DIV",{class:!0,"data-svelte-h":!0}),d(W)!=="svelte-4jgjc0"&&(W.innerHTML=R),this.h()},h(){V(W,"class","flex flex-row gap-4")},m(s,b){a(s,p,b),a(s,m,b),a(s,M,b),a(s,_,b),g(Z,s,b),a(s,I,b),a(s,c,b),a(s,X,b),g(T,s,b),a(s,k,b),a(s,W,b),u=!0},p:B,i(s){u||(h(Z.$$.fragment,s),h(T.$$.fragment,s),u=!0)},o(s){J(Z.$$.fragment,s),J(T.$$.fragment,s),u=!1},d(s){s&&(l(p),l(m),l(M),l(_),l(I),l(c),l(X),l(k),l(W)),U(Z,s),U(T,s)}}}function Oa(C){let p,w="IP-Adapter can also help with image-to-image by guiding the model to generate an image that resembles the original image and the image prompt.",m,M,G='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',_,Z,I,c,j="Pass the original image and the IP-Adapter image prompt to the pipeline to generate an image. Providing a text prompt to the pipeline is optional, but in this example, a text prompt is used to increase image quality.",X,T,k,W,R='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_3.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',u;return Z=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),T=new v({props:{code:"aW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfYmVhcl8xLnBuZyUyMiklMEFpcF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9iZWFyXzIucG5nJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDQpJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaXBfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBzdHJlbmd0aCUzRDAuNiUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png&quot;</span>)
ip_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_2.png&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">4</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;best quality, high quality&quot;</span>,
    image=image,
    ip_adapter_image=ip_image,
    generator=generator,
    strength=<span class="hljs-number">0.6</span>,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){p=o("p"),p.textContent=w,m=n(),M=o("p"),M.innerHTML=G,_=n(),y(Z.$$.fragment),I=n(),c=o("p"),c.textContent=j,X=n(),y(T.$$.fragment),k=n(),W=o("div"),W.innerHTML=R,this.h()},l(s){p=r(s,"P",{"data-svelte-h":!0}),d(p)!=="svelte-avn1rr"&&(p.textContent=w),m=i(s),M=r(s,"P",{"data-svelte-h":!0}),d(M)!=="svelte-10sdaqe"&&(M.innerHTML=G),_=i(s),f(Z.$$.fragment,s),I=i(s),c=r(s,"P",{"data-svelte-h":!0}),d(c)!=="svelte-10sbd9g"&&(c.textContent=j),X=i(s),f(T.$$.fragment,s),k=i(s),W=r(s,"DIV",{class:!0,"data-svelte-h":!0}),d(W)!=="svelte-8bse9r"&&(W.innerHTML=R),this.h()},h(){V(W,"class","flex gap-4")},m(s,b){a(s,p,b),a(s,m,b),a(s,M,b),a(s,_,b),g(Z,s,b),a(s,I,b),a(s,c,b),a(s,X,b),g(T,s,b),a(s,k,b),a(s,W,b),u=!0},p:B,i(s){u||(h(Z.$$.fragment,s),h(T.$$.fragment,s),u=!0)},o(s){J(Z.$$.fragment,s),J(T.$$.fragment,s),u=!1},d(s){s&&(l(p),l(m),l(M),l(_),l(I),l(c),l(X),l(k),l(W)),U(Z,s),U(T,s)}}}function es(C){let p,w="IP-Adapter is also useful for inpainting because the image prompt allows you to be much more specific about what you’d like to generate.",m,M,G='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',_,Z,I,c,j="Pass a prompt, the original image, mask image, and the IP-Adapter image prompt to the pipeline to generate an image.",X,T,k,W,R='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',u;return Z=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMjJkaWZmdXNlcnMlMkZzdGFibGUtZGlmZnVzaW9uLXhsLTEuMC1pbnBhaW50aW5nLTAuMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForInpainting.from_pretrained(<span class="hljs-string">&quot;diffusers/stable-diffusion-xl-1.0-inpainting-0.1&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),T=new v({props:{code:"bWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9tYXNrLnBuZyUyMiklMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9iZWFyXzEucG5nJTIyKSUwQWlwX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9hZGFwdGVyX2d1bW15LnBuZyUyMiklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCg0KSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBjdXRlJTIwZ3VtbXklMjBiZWFyJTIwd2F2aW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_mask.png&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png&quot;</span>)
ip_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">4</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a cute gummy bear waving&quot;</span>,
    image=image,
    mask_image=mask_image,
    ip_adapter_image=ip_image,
    generator=generator,
    num_inference_steps=<span class="hljs-number">100</span>,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){p=o("p"),p.textContent=w,m=n(),M=o("p"),M.innerHTML=G,_=n(),y(Z.$$.fragment),I=n(),c=o("p"),c.textContent=j,X=n(),y(T.$$.fragment),k=n(),W=o("div"),W.innerHTML=R,this.h()},l(s){p=r(s,"P",{"data-svelte-h":!0}),d(p)!=="svelte-11wjoqr"&&(p.textContent=w),m=i(s),M=r(s,"P",{"data-svelte-h":!0}),d(M)!=="svelte-10sdaqe"&&(M.innerHTML=G),_=i(s),f(Z.$$.fragment,s),I=i(s),c=r(s,"P",{"data-svelte-h":!0}),d(c)!=="svelte-1wfeic0"&&(c.textContent=j),X=i(s),f(T.$$.fragment,s),k=i(s),W=r(s,"DIV",{class:!0,"data-svelte-h":!0}),d(W)!=="svelte-5iola2"&&(W.innerHTML=R),this.h()},h(){V(W,"class","flex gap-4")},m(s,b){a(s,p,b),a(s,m,b),a(s,M,b),a(s,_,b),g(Z,s,b),a(s,I,b),a(s,c,b),a(s,X,b),g(T,s,b),a(s,k,b),a(s,W,b),u=!0},p:B,i(s){u||(h(Z.$$.fragment,s),h(T.$$.fragment,s),u=!0)},o(s){J(Z.$$.fragment,s),J(T.$$.fragment,s),u=!1},d(s){s&&(l(p),l(m),l(M),l(_),l(I),l(c),l(X),l(k),l(W)),U(Z,s),U(T,s)}}}function ts(C){let p,w='If you’re planning on offloading the model to the CPU, make sure you run it after you’ve loaded the IP-Adapter. When you call <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> before loading the IP-Adapter, it offloads the image encoder module to the CPU and it’ll return an error when you try to run the pipeline.';return{c(){p=o("p"),p.innerHTML=w},l(m){p=r(m,"P",{"data-svelte-h":!0}),d(p)!=="svelte-pndhhh"&&(p.innerHTML=w)},m(m,M){a(m,p,M)},p:B,d(m){m&&l(p)}}}function ls(C){let p,w='IP-Adapter can also help you generate videos that are more aligned with your text prompt. For example, let’s load <a href="../api/pipelines/animatediff">AnimateDiff</a> with its motion adapter and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method.',m,M,G,_,Z,I,c="Pass a prompt and an image prompt to the pipeline to generate a short video.",j,X,T,k,W='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gummy_bear.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated video</figcaption></div>',R;return M=new dt({props:{warning:!0,$$slots:{default:[ts]},$$scope:{ctx:C}}}),_=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZQaXBlbGluZSUyQyUyMERESU1TY2hlZHVsZXIlMkMlMjBNb3Rpb25BZGFwdGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tYWRhcHRlci12MS01LTIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFzY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfc2FtcGxlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjB0aW1lc3RlcF9zcGFjaW5nJTNEJTIybGluc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBiZXRhX3NjaGVkdWxlJTNEJTIybGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3RlcHNfb2Zmc2V0JTNEMSUyQyUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBzY2hlZHVsZXIlMEFwaXBlbGluZS5lbmFibGVfdmFlX3NsaWNpbmcoKSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
pipeline = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>, motion_adapter=adapter, torch_dtype=torch.float16)
scheduler = DDIMScheduler.from_pretrained(
    <span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipeline.scheduler = scheduler
pipeline.enable_vae_slicing()

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),X=new v({props:{code:"aXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9pbnBhaW50LnBuZyUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJBJTIwY3V0ZSUyMGd1bW15JTIwYmVhciUyMHdhdmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmJhZCUyMHF1YWxpdHklMkMlMjB3b3JzZSUyMHF1YWxpdHklMkMlMjBsb3clMjByZXNvbHV0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2FkYXB0ZXJfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuNSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTJDJTBBKSUwQWZyYW1lcyUyMCUzRCUyMG91dHB1dC5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX2dpZihmcmFtZXMlMkMlMjAlMjJndW1teV9iZWFyLmdpZiUyMik=",highlighted:`ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png&quot;</span>)

output = pipeline(
    prompt=<span class="hljs-string">&quot;A cute gummy bear waving&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality, low resolution&quot;</span>,
    ip_adapter_image=ip_adapter_image,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;gummy_bear.gif&quot;</span>)`,wrap:!1}}),{c(){p=o("p"),p.innerHTML=w,m=n(),y(M.$$.fragment),G=n(),y(_.$$.fragment),Z=n(),I=o("p"),I.textContent=c,j=n(),y(X.$$.fragment),T=n(),k=o("div"),k.innerHTML=W,this.h()},l(u){p=r(u,"P",{"data-svelte-h":!0}),d(p)!=="svelte-10zqvoq"&&(p.innerHTML=w),m=i(u),f(M.$$.fragment,u),G=i(u),f(_.$$.fragment,u),Z=i(u),I=r(u,"P",{"data-svelte-h":!0}),d(I)!=="svelte-a6opnh"&&(I.textContent=c),j=i(u),f(X.$$.fragment,u),T=i(u),k=r(u,"DIV",{class:!0,"data-svelte-h":!0}),d(k)!=="svelte-ihoum9"&&(k.innerHTML=W),this.h()},h(){V(k,"class","flex flex-row gap-4")},m(u,s){a(u,p,s),a(u,m,s),g(M,u,s),a(u,G,s),g(_,u,s),a(u,Z,s),a(u,I,s),a(u,j,s),g(X,u,s),a(u,T,s),a(u,k,s),R=!0},p(u,s){const b={};s&2&&(b.$$scope={dirty:s,ctx:u}),M.$set(b)},i(u){R||(h(M.$$.fragment,u),h(_.$$.fragment,u),h(X.$$.fragment,u),R=!0)},o(u){J(M.$$.fragment,u),J(_.$$.fragment,u),J(X.$$.fragment,u),R=!1},d(u){u&&(l(p),l(m),l(G),l(Z),l(I),l(j),l(T),l(k)),U(M,u),U(_,u),U(X,u)}}}function as(C){let p,w,m,M,G,_,Z,I;return p=new Hl({props:{id:"tasks",option:"Text-to-image",$$slots:{default:[Ka]},$$scope:{ctx:C}}}),m=new Hl({props:{id:"tasks",option:"Image-to-image",$$slots:{default:[Oa]},$$scope:{ctx:C}}}),G=new Hl({props:{id:"tasks",option:"Inpainting",$$slots:{default:[es]},$$scope:{ctx:C}}}),Z=new Hl({props:{id:"tasks",option:"Video",$$slots:{default:[ls]},$$scope:{ctx:C}}}),{c(){y(p.$$.fragment),w=n(),y(m.$$.fragment),M=n(),y(G.$$.fragment),_=n(),y(Z.$$.fragment)},l(c){f(p.$$.fragment,c),w=i(c),f(m.$$.fragment,c),M=i(c),f(G.$$.fragment,c),_=i(c),f(Z.$$.fragment,c)},m(c,j){g(p,c,j),a(c,w,j),g(m,c,j),a(c,M,j),g(G,c,j),a(c,_,j),g(Z,c,j),I=!0},p(c,j){const X={};j&2&&(X.$$scope={dirty:j,ctx:c}),p.$set(X);const T={};j&2&&(T.$$scope={dirty:j,ctx:c}),m.$set(T);const k={};j&2&&(k.$$scope={dirty:j,ctx:c}),G.$set(k);const W={};j&2&&(W.$$scope={dirty:j,ctx:c}),Z.$set(W)},i(c){I||(h(p.$$.fragment,c),h(m.$$.fragment,c),h(G.$$.fragment,c),h(Z.$$.fragment,c),I=!0)},o(c){J(p.$$.fragment,c),J(m.$$.fragment,c),J(G.$$.fragment,c),J(Z.$$.fragment,c),I=!1},d(c){c&&(l(w),l(M),l(_)),U(p,c),U(m,c),U(G,c),U(Z,c)}}}function ss(C){let p,w="This parameter also gives you the flexibility to load embeddings from other sources. For example, ComfyUI image embeddings for IP-Adapters are compatible with Diffusers and should work ouf-of-the-box!";return{c(){p=o("p"),p.textContent=w},l(m){p=r(m,"P",{"data-svelte-h":!0}),d(p)!=="svelte-1rk1t7q"&&(p.textContent=w)},m(m,M){a(m,p,M)},p:B,d(m){m&&l(p)}}}function ns(C){let p,w="If you’re using IP-Adapter with <code>ip_adapter_image_embedding</code> instead of <code>ip_adapter_image</code>’, you can set <code>load_ip_adapter(image_encoder_folder=None,...)</code> because you don’t need to load an encoder to generate the image embeddings.";return{c(){p=o("p"),p.innerHTML=w},l(m){p=r(m,"P",{"data-svelte-h":!0}),d(p)!=="svelte-h0lw9v"&&(p.innerHTML=w)},m(m,M){a(m,p,M)},p:B,d(m){m&&l(p)}}}function is(C){let p,w='Read the <a href="../using-diffusers/loading_adapters#ip-adapter-plus">IP-Adapter Plus</a> section to learn why you need to manually load the image encoder.';return{c(){p=o("p"),p.innerHTML=w},l(m){p=r(m,"P",{"data-svelte-h":!0}),d(p)!=="svelte-apa7ha"&&(p.innerHTML=w)},m(m,M){a(m,p,M)},p:B,d(m){m&&l(p)}}}function ps(C){let p,w,m,M,G,_,Z,I='<a href="https://hf.co/papers/2308.06721" rel="nofollow">IP-Adapter</a> is an image prompt adapter that can be plugged into diffusion models to enable image prompting without any changes to the underlying model. Furthermore, this adapter can be reused with other models finetuned from the same base model and it can be combined with other adapters like <a href="../using-diffusers/controlnet">ControlNet</a>. The key idea behind IP-Adapter is the <em>decoupled cross-attention</em> mechanism which adds a separate cross-attention layer just for image features instead of using the same cross-attention layer for both text and image features. This allows the model to learn more image-specific features.',c,j,X,T,k="This guide will walk you through using IP-Adapter for various tasks and use cases.",W,R,u,s,b='Let’s take a look at how to use IP-Adapter’s image prompting capabilities with the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> for tasks like text-to-image, image-to-image, and inpainting. We also encourage you to try out other pipelines such as Stable Diffusion, LCM-LoRA, ControlNet, T2I-Adapter, or AnimateDiff!',ut,ee,Ql='In all the following examples, you’ll see the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.set_ip_adapter_scale">set_ip_adapter_scale()</a> method. This method controls the amount of text or image conditioning to apply to the model. A value of <code>1.0</code> means the model is only conditioned on the image prompt. Lowering this value encourages the model to produce more diverse images, but they may not be as aligned with the image prompt. Typically, a value of <code>0.5</code> achieves a good balance between the two prompt types and produces good results.',Mt,Y,yt,$,ft,te,gt,le,Al="There are a couple of IP-Adapter parameters that are useful to know about and can help you with your image generation tasks. These parameters can make your workflow more efficient or give you more control over image generation.",ht,ae,Jt,se,Sl='IP-Adapter enabled pipelines provide the <code>ip_adapter_image_embeds</code> parameter to accept precomputed image embeddings. This is particularly useful in scenarios where you need to run the IP-Adapter pipeline multiple times because you have more than one image. For example, <a href="#multi-ip-adapter">multi IP-Adapter</a> is a specific use case where you provide multiple styling images to generate a specific image in a specific style. Loading and encoding multiple images each time you use the pipeline would be inefficient. Instead, you can precompute and save the image embeddings to disk (which can save a lot of space if you’re using high-quality images) and load them when you need them.',Ut,F,Zt,ne,zl="Call the <code>prepare_ip_adapter_image_embeds()</code> method to encode and generate the image embeddings. Then you can save them to disk with <code>torch.save</code>.",bt,N,wt,ie,jt,pe,El="Now load the image embeddings by passing them to the <code>ip_adapter_image_embeds</code> parameter.",Tt,oe,Wt,re,_t,me,ql="Binary masks specify which portion of the output image should be assigned to an IP-Adapter. This is useful for composing more than one IP-Adapter image. For each input IP-Adapter image, you must provide a binary mask an an IP-Adapter.",Gt,de,Ll="To start, preprocess the input IP-Adapter images with the <code>~image_processor.IPAdapterMaskProcessor.preprocess()</code> to generate their masks. For optimal results, provide the output height and width to <code>~image_processor.IPAdapterMaskProcessor.preprocess()</code>. This ensures masks with different aspect ratios are appropriately stretched. If the input masks already match the aspect ratio of the generated image, you don’t have to set the <code>height</code> and <code>width</code>.",It,ce,Xt,H,Pl='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask one</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask two</figcaption></div>',kt,ue,Dl="When there is more than one input IP-Adapter image, load them as a list to ensure each image is assigned to a different IP-Adapter. Each of the input IP-Adapter images here correspond to the masks generated above.",vt,Me,Ct,Q,Kl='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image one</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image two</figcaption></div>',Rt,ye,Ol="Now pass the preprocessed masks to <code>cross_attention_kwargs</code> in the pipeline call.",Vt,fe,xt,A,ea='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_attention_mask_result_seed_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter masking applied</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_no_attention_mask_result_seed_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">no IP-Adapter masking applied</figcaption></div>',Bt,ge,Yt,he,ta="IP-Adapter’s image prompting and compatibility with other adapters and models makes it a versatile tool for a variety of use cases. This section covers some of the more popular applications of IP-Adapter, and we can’t wait to see what you come up with!",$t,Je,Ft,Ue,la='Generating accurate faces is challenging because they are complex and nuanced. Diffusers supports two IP-Adapter checkpoints specifically trained to generate faces from the <a href="https://huggingface.co/h94/IP-Adapter" rel="nofollow">h94/IP-Adapter</a> repository:',Nt,Ze,aa='<li><a href="https://huggingface.co/h94/IP-Adapter/blob/main/models/ip-adapter-full-face_sd15.safetensors" rel="nofollow">ip-adapter-full-face_sd15.safetensors</a> is conditioned with images of cropped faces and removed backgrounds</li> <li><a href="https://huggingface.co/h94/IP-Adapter/blob/main/models/ip-adapter-plus-face_sd15.safetensors" rel="nofollow">ip-adapter-plus-face_sd15.safetensors</a> uses patch embeddings and is conditioned with images of cropped faces</li>',Ht,be,sa='Additionally, Diffusers supports all IP-Adapter checkpoints trained with face embeddings extracted by <code>insightface</code> face models. Supported models are from the <a href="https://huggingface.co/h94/IP-Adapter-FaceID" rel="nofollow">h94/IP-Adapter-FaceID</a> repository.',Qt,we,na='For face models, use the <a href="https://huggingface.co/h94/IP-Adapter" rel="nofollow">h94/IP-Adapter</a> checkpoint. It is also recommended to use <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> or <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> for face models.',At,je,St,S,ia='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein_base.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',zt,Te,pa="To use IP-Adapter FaceID models, first extract face embeddings with <code>insightface</code>. Then pass the list of tensors to the pipeline as <code>ip_adapter_image_embeds</code>.",Et,We,qt,_e,oa="Both IP-Adapter FaceID Plus and Plus v2 models require CLIP image embeddings. You can prepare face embeddings as shown previously, then you can extract and pass CLIP embeddings to the hidden image projection layers.",Lt,Ge,Pt,Ie,Dt,Xe,ra="More than one IP-Adapter can be used at the same time to generate specific images in more diverse styles. For example, you can use IP-Adapter-Face to generate consistent faces and characters, and IP-Adapter Plus to generate those faces in a specific style.",Kt,z,Ot,ke,ma='Load the image encoder with <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModelWithProjection" rel="nofollow">CLIPVisionModelWithProjection</a>.',el,ve,tl,Ce,da="Next, you’ll load a base model, scheduler, and the IP-Adapters. The IP-Adapters to use are passed as a list to the <code>weight_name</code> parameter:",ll,Re,ca='<li><a href="https://huggingface.co/h94/IP-Adapter#ip-adapter-for-sdxl-10" rel="nofollow">ip-adapter-plus_sdxl_vit-h</a> uses patch embeddings and a ViT-H image encoder</li> <li><a href="https://huggingface.co/h94/IP-Adapter#ip-adapter-for-sdxl-10" rel="nofollow">ip-adapter-plus-face_sdxl_vit-h</a> has the same architecture but it is conditioned with images of cropped faces</li>',al,Ve,sl,xe,ua="Load an image prompt and a folder containing images of a certain style you want to use.",nl,Be,il,E,Ma='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/women_input.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image of face</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_style_grid.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter style images</figcaption></div>',pl,Ye,ya="Pass the image prompt and style images as a list to the <code>ip_adapter_image</code> parameter, and run the pipeline!",ol,$e,rl,q,fa='    <img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_multi_out.png"/>',ml,Fe,dl,Ne,ga='<a href="../using-diffusers/inference_with_lcm_lora">Latent Consistency Models (LCM)</a> are diffusion models that can generate images in as little as 4 steps compared to other diffusion models like SDXL that typically require way more steps. This is why image generation with an LCM feels “instantaneous”. IP-Adapters can be plugged into an LCM-LoRA model to instantly generate images with an image prompt.',cl,He,ha='The IP-Adapter weights need to be loaded first, then you can use <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> to load the LoRA style and weight you want to apply to your image.',ul,Qe,Ml,Ae,Ja='Try using with a lower IP-Adapter scale to condition image generation more on the <a href="https://huggingface.co/sd-dreambooth-library/herge-style" rel="nofollow">herge_style</a> checkpoint, and remember to use the special token <code>herge_style</code> in your prompt to trigger and apply the style.',yl,Se,fl,L,Ua='    <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_herge.png"/>',gl,ze,hl,Ee,Za='To control image generation to an even greater degree, you can combine IP-Adapter with a model like <a href="../using-diffusers/controlnet">ControlNet</a>. A ControlNet is also an adapter that can be inserted into a diffusion model to allow for conditioning on an additional control image. The control image can be depth maps, edge maps, pose estimations, and more.',Jl,qe,ba='Load a <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> checkpoint conditioned on depth maps, insert it into a diffusion model, and load the IP-Adapter.',Ul,Le,Zl,Pe,wa="Now load the IP-Adapter image and depth map.",bl,De,wl,P,ja='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/statue.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/depth.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">depth map</figcaption></div>',jl,Ke,Ta="Pass the depth map and IP-Adapter image to the pipeline to generate an image.",Tl,Oe,Wl,D,Wa='    <img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ipa-controlnet-out.png"/>',_l,et,Gl,tt,_a='<a href="https://arxiv.org/abs/2404.02733" rel="nofollow">InstantStyle</a> is a plug-and-play method on top of IP-Adapter, which disentangles style and layout from image prompt to control image generation. This is achieved by only inserting IP-Adapters to some specific part of the model.',Il,lt,Ga='By default IP-Adapters are inserted to all layers of the model. Use the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.set_ip_adapter_scale">set_ip_adapter_scale()</a> method with a dictionary to assign scales to IP-Adapter at different layers.',Xl,at,kl,st,Ia="This will activate IP-Adapter at the second layer in the model’s down-part block 2 and up-part block 0. The former is the layer where IP-Adapter injects layout information and the latter injects style. Inserting IP-Adapter to these two layers you can generate images following the style and layout of image prompt, but with contents more aligned to text prompt.",vl,nt,Cl,K,Xa='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/0052a70beed5bf71b92610a43a52df6d286cd5f3/diffusers/rabbit.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/0052a70beed5bf71b92610a43a52df6d286cd5f3/diffusers/rabbit_style_layout_cat.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Rl,it,ka="In contrast, inserting IP-Adapter to all layers will often generate images that overly focus on image prompt and diminish diversity.",Vl,pt,va="Activate IP-Adapter only in the style layer and then call the pipeline again.",xl,ot,Bl,O,Ca='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/0052a70beed5bf71b92610a43a52df6d286cd5f3/diffusers/rabbit_style_cat.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter only in style layer</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/30518dfe089e6bf50008875077b44cb98fb2065c/diffusers/default_out.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter in all layers</figcaption></div>',Yl,rt,Ra="Note that you don’t have to specify all layers in the dictionary. Those not included in the dictionary will be set to scale 0 which means disable IP-Adapter by default.",$l,mt,Fl,ct,Nl;return G=new x({props:{title:"IP-Adapter",local:"ip-adapter",headingTag:"h1"}}),j=new dt({props:{warning:!1,$$slots:{default:[Pa]},$$scope:{ctx:C}}}),R=new x({props:{title:"General tasks",local:"general-tasks",headingTag:"h2"}}),Y=new dt({props:{warning:!1,$$slots:{default:[Da]},$$scope:{ctx:C}}}),$=new La({props:{id:"tasks",options:["Text-to-image","Image-to-image","Inpainting","Video"],$$slots:{default:[as]},$$scope:{ctx:C}}}),te=new x({props:{title:"Configure parameters",local:"configure-parameters",headingTag:"h2"}}),ae=new x({props:{title:"Image embeddings",local:"image-embeddings",headingTag:"h3"}}),F=new dt({props:{warning:!1,$$slots:{default:[ss]},$$scope:{ctx:C}}}),N=new dt({props:{warning:!1,$$slots:{default:[ns]},$$scope:{ctx:C}}}),ie=new v({props:{code:"aW1hZ2VfZW1iZWRzJTIwJTNEJTIwcGlwZWxpbmUucHJlcGFyZV9pcF9hZGFwdGVyX2ltYWdlX2VtYmVkcyglMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlX2VtYmVkcyUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMSUyQyUwQSUyMCUyMCUyMCUyMGRvX2NsYXNzaWZpZXJfZnJlZV9ndWlkYW5jZSUzRFRydWUlMkMlMEEpJTBBJTBBdG9yY2guc2F2ZShpbWFnZV9lbWJlZHMlMkMlMjAlMjJpbWFnZV9lbWJlZHMuaXBhZHB0JTIyKQ==",highlighted:`image_embeds = pipeline.prepare_ip_adapter_image_embeds(
    ip_adapter_image=image,
    ip_adapter_image_embeds=<span class="hljs-literal">None</span>,
    device=<span class="hljs-string">&quot;cuda&quot;</span>,
    num_images_per_prompt=<span class="hljs-number">1</span>,
    do_classifier_free_guidance=<span class="hljs-literal">True</span>,
)

torch.save(image_embeds, <span class="hljs-string">&quot;image_embeds.ipadpt&quot;</span>)`,wrap:!1}}),oe=new v({props:{code:"aW1hZ2VfZW1iZWRzJTIwJTNEJTIwdG9yY2gubG9hZCglMjJpbWFnZV9lbWJlZHMuaXBhZHB0JTIyKSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwb2xhciUyMGJlYXIlMjBzaXR0aW5nJTIwaW4lMjBhJTIwY2hhaXIlMjBkcmlua2luZyUyMGElMjBtaWxrc2hha2UlMjIlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlX2VtYmVkcyUzRGltYWdlX2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmRlZm9ybWVkJTJDJTIwdWdseSUyQyUyMHdyb25nJTIwcHJvcG9ydGlvbiUyQyUyMGxvdyUyMHJlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2Vz",highlighted:`image_embeds = torch.load(<span class="hljs-string">&quot;image_embeds.ipadpt&quot;</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image_embeds=image_embeds,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images`,wrap:!1}}),re=new x({props:{title:"IP-Adapter masking",local:"ip-adapter-masking",headingTag:"h3"}}),ce=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5pbWFnZV9wcm9jZXNzb3IlMjBpbXBvcnQlMjBJUEFkYXB0ZXJNYXNrUHJvY2Vzc29yJTBBJTBBbWFzazElMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX21hc2tfbWFzazEucG5nJTIyKSUwQW1hc2syJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9tYXNrX21hc2syLnBuZyUyMiklMEElMEFvdXRwdXRfaGVpZ2h0JTIwJTNEJTIwMTAyNCUwQW91dHB1dF93aWR0aCUyMCUzRCUyMDEwMjQlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBJUEFkYXB0ZXJNYXNrUHJvY2Vzc29yKCklMEFtYXNrcyUyMCUzRCUyMHByb2Nlc3Nvci5wcmVwcm9jZXNzKCU1Qm1hc2sxJTJDJTIwbWFzazIlNUQlMkMlMjBoZWlnaHQlM0RvdXRwdXRfaGVpZ2h0JTJDJTIwd2lkdGglM0RvdXRwdXRfd2lkdGgp",highlighted:`<span class="hljs-keyword">from</span> diffusers.image_processor <span class="hljs-keyword">import</span> IPAdapterMaskProcessor

mask1 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_mask1.png&quot;</span>)
mask2 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_mask2.png&quot;</span>)

output_height = <span class="hljs-number">1024</span>
output_width = <span class="hljs-number">1024</span>

processor = IPAdapterMaskProcessor()
masks = processor.preprocess([mask1, mask2], height=output_height, width=output_width)`,wrap:!1}}),Me=new v({props:{code:"ZmFjZV9pbWFnZTElMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX21hc2tfZ2lybDEucG5nJTIyKSUwQWZhY2VfaW1hZ2UyJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9tYXNrX2dpcmwyLnBuZyUyMiklMEElMEFpcF9pbWFnZXMlMjAlM0QlMjAlNUIlNUJmYWNlX2ltYWdlMSU1RCUyQyUyMCU1QmZhY2VfaW1hZ2UyJTVEJTVE",highlighted:`face_image1 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_girl1.png&quot;</span>)
face_image2 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_girl2.png&quot;</span>)

ip_images = [[face_image1], [face_image2]]`,wrap:!1}}),fe=new v({props:{code:"cGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTVCJTIyaXAtYWRhcHRlci1wbHVzLWZhY2Vfc2R4bF92aXQtaC5zYWZldGVuc29ycyUyMiU1RCUyMColMjAyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKCU1QjAuNyU1RCUyMColMjAyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBbnVtX2ltYWdlcyUyMCUzRCUyMDElMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMjIlMjBnaXJscyUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpcF9pbWFnZXMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0RudW1faW1hZ2VzJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwY3Jvc3NfYXR0ZW50aW9uX2t3YXJncyUzRCU3QiUyMmlwX2FkYXB0ZXJfbWFza3MlMjIlM0ElMjBtYXNrcyU3RCUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=[<span class="hljs-string">&quot;ip-adapter-plus-face_sdxl_vit-h.safetensors&quot;</span>] * <span class="hljs-number">2</span>)
pipeline.set_ip_adapter_scale([<span class="hljs-number">0.7</span>] * <span class="hljs-number">2</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
num_images = <span class="hljs-number">1</span>

image = pipeline(
    prompt=<span class="hljs-string">&quot;2 girls&quot;</span>,
    ip_adapter_image=ip_images,
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">20</span>,
    num_images_per_prompt=num_images,
    generator=generator,
    cross_attention_kwargs={<span class="hljs-string">&quot;ip_adapter_masks&quot;</span>: masks}
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ge=new x({props:{title:"Specific use cases",local:"specific-use-cases",headingTag:"h2"}}),Je=new x({props:{title:"Face model",local:"face-model",headingTag:"h3"}}),je=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJtb2RlbHMlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMmlwLWFkYXB0ZXItZnVsbC1mYWNlX3NkMTUuYmluJTIyKSUwQSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNSklMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9laW5zdGVpbl9iYXNlLnBuZyUyMiklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgyNiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkElMjBwaG90byUyMG9mJTIwRWluc3RlaW4lMjBhcyUyMGElMjBjaGVmJTJDJTIwd2VhcmluZyUyMGFuJTIwYXByb24lMkMlMjBjb29raW5nJTIwaW4lMjBhJTIwRnJlbmNoJTIwcmVzdGF1cmFudCUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmxvd3JlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter-full-face_sd15.bin&quot;</span>)

pipeline.set_ip_adapter_scale(<span class="hljs-number">0.5</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein_base.png&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">26</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;A photo of Einstein as a chef, wearing an apron, cooking in a French restaurant&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),We=new v({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> insightface.app <span class="hljs-keyword">import</span> FaceAnalysis

pipeline = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter-FaceID&quot;</span>, subfolder=<span class="hljs-literal">None</span>, weight_name=<span class="hljs-string">&quot;ip-adapter-faceid_sd15.bin&quot;</span>, image_encoder_folder=<span class="hljs-literal">None</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_girl1.png&quot;</span>)

ref_images_embeds = []
app = FaceAnalysis(name=<span class="hljs-string">&quot;buffalo_l&quot;</span>, providers=[<span class="hljs-string">&#x27;CUDAExecutionProvider&#x27;</span>, <span class="hljs-string">&#x27;CPUExecutionProvider&#x27;</span>])
app.prepare(ctx_id=<span class="hljs-number">0</span>, det_size=(<span class="hljs-number">640</span>, <span class="hljs-number">640</span>))
image = cv2.cvtColor(np.asarray(image), cv2.COLOR_BGR2RGB)
faces = app.get(image)
image = torch.from_numpy(faces[<span class="hljs-number">0</span>].normed_embedding)
ref_images_embeds.append(image.unsqueeze(<span class="hljs-number">0</span>))
ref_images_embeds = torch.stack(ref_images_embeds, dim=<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)
neg_ref_images_embeds = torch.zeros_like(ref_images_embeds)
id_embeds = torch.cat([neg_ref_images_embeds, ref_images_embeds]).to(dtype=torch.float16, device=<span class="hljs-string">&quot;cuda&quot;</span>))

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>)

images = pipeline(
    prompt=<span class="hljs-string">&quot;A photo of a girl&quot;</span>,
    ip_adapter_image_embeds=[id_embeds], 
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>, 
    num_inference_steps=<span class="hljs-number">20</span>, num_images_per_prompt=<span class="hljs-number">1</span>,
    generator=generator
).images`,wrap:!1}}),Ge=new v({props:{code:"Y2xpcF9lbWJlZHMlMjAlM0QlMjBwaXBlbGluZS5wcmVwYXJlX2lwX2FkYXB0ZXJfaW1hZ2VfZW1iZWRzKCU1QmlwX2FkYXB0ZXJfaW1hZ2VzJTVEJTJDJTIwTm9uZSUyQyUyMHRvcmNoLmRldmljZSglMjJjdWRhJTIyKSUyQyUyMG51bV9pbWFnZXMlMkMlMjBUcnVlKSU1QjAlNUQlMEElMEFwaXBlbGluZS51bmV0LmVuY29kZXJfaGlkX3Byb2ouaW1hZ2VfcHJvamVjdGlvbl9sYXllcnMlNUIwJTVELmNsaXBfZW1iZWRzJTIwJTNEJTIwY2xpcF9lbWJlZHMudG8oZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lLnVuZXQuZW5jb2Rlcl9oaWRfcHJvai5pbWFnZV9wcm9qZWN0aW9uX2xheWVycyU1QjAlNUQuc2hvcnRjdXQlMjAlM0QlMjBGYWxzZSUyMCUyMyUyMFRydWUlMjBpZiUyMFBsdXMlMjB2Mg==",highlighted:`clip_embeds = pipeline.prepare_ip_adapter_image_embeds([ip_adapter_images], <span class="hljs-literal">None</span>, torch.device(<span class="hljs-string">&quot;cuda&quot;</span>), num_images, <span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]

pipeline.unet.encoder_hid_proj.image_projection_layers[<span class="hljs-number">0</span>].clip_embeds = clip_embeds.to(dtype=torch.float16)
pipeline.unet.encoder_hid_proj.image_projection_layers[<span class="hljs-number">0</span>].shortcut = <span class="hljs-literal">False</span> <span class="hljs-comment"># True if Plus v2</span>`,wrap:!1}}),Ie=new x({props:{title:"Multi IP-Adapter",local:"multi-ip-adapter",headingTag:"h3"}}),z=new dt({props:{warning:!1,$$slots:{default:[is]},$$scope:{ctx:C}}}),ve=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUyQyUyMERESU1TY2hlZHVsZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFZpc2lvbk1vZGVsV2l0aFByb2plY3Rpb24lMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltYWdlX2VuY29kZXIlMjAlM0QlMjBDTElQVmlzaW9uTW9kZWxXaXRoUHJvamVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMm1vZGVscyUyRmltYWdlX2VuY29kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, DDIMScheduler
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPVisionModelWithProjection
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

image_encoder = CLIPVisionModelWithProjection.from_pretrained(
    <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
    subfolder=<span class="hljs-string">&quot;models/image_encoder&quot;</span>,
    torch_dtype=torch.float16,
)`,wrap:!1}}),Ve=new v({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9lbmNvZGVyJTNEaW1hZ2VfZW5jb2RlciUyQyUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUwQSUyMCUyMCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMEElMjAlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUwQSUyMCUyMHdlaWdodF9uYW1lJTNEJTVCJTIyaXAtYWRhcHRlci1wbHVzX3NkeGxfdml0LWguc2FmZXRlbnNvcnMlMjIlMkMlMjAlMjJpcC1hZGFwdGVyLXBsdXMtZmFjZV9zZHhsX3ZpdC1oLnNhZmV0ZW5zb3JzJTIyJTVEJTBBKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKCU1QjAuNyUyQyUyMDAuMyU1RCklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    image_encoder=image_encoder,
)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>,
  weight_name=[<span class="hljs-string">&quot;ip-adapter-plus_sdxl_vit-h.safetensors&quot;</span>, <span class="hljs-string">&quot;ip-adapter-plus-face_sdxl_vit-h.safetensors&quot;</span>]
)
pipeline.set_ip_adapter_scale([<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>])
pipeline.enable_model_cpu_offload()`,wrap:!1}}),Be=new v({props:{code:"ZmFjZV9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRndvbWVuX2lucHV0LnBuZyUyMiklMEFzdHlsZV9mb2xkZXIlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc3R5bGVfemlnZ3klMjIlMEFzdHlsZV9pbWFnZXMlMjAlM0QlMjAlNUJsb2FkX2ltYWdlKGYlMjIlN0JzdHlsZV9mb2xkZXIlN0QlMkZpbWclN0JpJTdELnBuZyUyMiklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCklNUQ=",highlighted:`face_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/women_input.png&quot;</span>)
style_folder = <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/style_ziggy&quot;</span>
style_images = [load_image(<span class="hljs-string">f&quot;<span class="hljs-subst">{style_folder}</span>/img<span class="hljs-subst">{i}</span>.png&quot;</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>)]`,wrap:!1}}),$e=new v({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMndvbmRlcndvbWFuJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRCU1QnN0eWxlX2ltYWdlcyUyQyUyMGZhY2VfaW1hZ2UlNUQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;wonderwoman&quot;</span>,
    ip_adapter_image=[style_images, face_image],
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">50</span>, num_images_per_prompt=<span class="hljs-number">1</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Fe=new x({props:{title:"Instant generation",local:"instant-generation",headingTag:"h3"}}),Qe=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwTENNU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc2QtZHJlYW1ib290aC1saWJyYXJ5JTJGaGVyZ2Utc3R5bGUlMjIlMEFsY21fbG9yYV9pZCUyMCUzRCUyMCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkdjEtNSUyMiUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVsaW5lLmxvYWRfbG9yYV93ZWlnaHRzKGxjbV9sb3JhX2lkKSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, LCMScheduler
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

model_id = <span class="hljs-string">&quot;sd-dreambooth-library/herge-style&quot;</span>
lcm_lora_id = <span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>

pipeline = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16)

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipeline.load_lora_weights(lcm_lora_id)
pipeline.scheduler = LCMScheduler.from_config(pipeline.scheduler.config)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),Se=new v({props:{code:"cGlwZWxpbmUuc2V0X2lwX2FkYXB0ZXJfc2NhbGUoMC40KSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmhlcmdlX3N0eWxlJTIwd29tYW4lMjBpbiUyMGFybW9yJTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBJTBBaXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZ1c2VyLWltYWdlcy5naXRodWJ1c2VyY29udGVudC5jb20lMkYyNDczNDE0MiUyRjI2NjQ5Mjg3NS0yZDUwZDIyMy04NDc1LTQ0ZjAtYTdjNi0wOGI1MWNiNTM1NzIucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2FkYXB0ZXJfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMSUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`pipeline.set_ip_adapter_scale(<span class="hljs-number">0.4</span>)

prompt = <span class="hljs-string">&quot;herge_style woman in armor, best quality, high quality&quot;</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

ip_adapter_image = load_image(<span class="hljs-string">&quot;https://user-images.githubusercontent.com/24734142/266492875-2d50d223-8475-44f0-a7c6-08b51cb53572.png&quot;</span>)
image = pipeline(
    prompt=prompt,
    ip_adapter_image=ip_adapter_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1</span>,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ze=new x({props:{title:"Structural control",local:"structural-control",headingTag:"h3"}}),Le=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFjb250cm9sbmV0X21vZGVsX3BhdGglMjAlM0QlMjAlMjJsbGx5YXN2aWVsJTJGY29udHJvbF92MTFmMXBfc2QxNV9kZXB0aCUyMiUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNvbnRyb2xuZXRfbW9kZWxfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

controlnet_model_path = <span class="hljs-string">&quot;lllyasviel/control_v11f1p_sd15_depth&quot;</span>
controlnet = ControlNetModel.from_pretrained(controlnet_model_path, torch_dtype=torch.float16)

pipeline = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)`,wrap:!1}}),De=new v({props:{code:"aXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnN0YXR1ZS5wbmclMjIpJTBBZGVwdGhfbWFwJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGVwdGgucG5nJTIyKQ==",highlighted:`ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/statue.png&quot;</span>)
depth_map = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/depth.png&quot;</span>)`,wrap:!1}}),Oe=new v({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMzMpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJiZXN0JTIwcXVhbGl0eSUyQyUyMGhpZ2glMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RkZXB0aF9tYXAlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaXBfYWRhcHRlcl9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMm1vbm9jaHJvbWUlMkMlMjBsb3dyZXMlMkMlMjBiYWQlMjBhbmF0b215JTJDJTIwd29yc3QlMjBxdWFsaXR5JTJDJTIwbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
image = pipeline(
    prompt=<span class="hljs-string">&quot;best quality, high quality&quot;</span>,
    image=depth_map,
    ip_adapter_image=ip_adapter_image,
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),et=new x({props:{title:"Style & layout control",local:"style--layout-control",headingTag:"h3"}}),at=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQSUwQXNjYWxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZG93biUyMiUzQSUyMCU3QiUyMmJsb2NrXzIlMjIlM0ElMjAlNUIwLjAlMkMlMjAxLjAlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ1cCUyMiUzQSUyMCU3QiUyMmJsb2NrXzAlMjIlM0ElMjAlNUIwLjAlMkMlMjAxLjAlMkMlMjAwLjAlNUQlN0QlMkMlMEElN0QlMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZShzY2FsZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)

scale = {
    <span class="hljs-string">&quot;down&quot;</span>: {<span class="hljs-string">&quot;block_2&quot;</span>: [<span class="hljs-number">0.0</span>, <span class="hljs-number">1.0</span>]},
    <span class="hljs-string">&quot;up&quot;</span>: {<span class="hljs-string">&quot;block_0&quot;</span>: [<span class="hljs-number">0.0</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">0.0</span>]},
}
pipeline.set_ip_adapter_scale(scale)`,wrap:!1}}),nt=new v({props:{code:"c3R5bGVfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGMDA1MmE3MGJlZWQ1YmY3MWI5MjYxMGE0M2E1MmRmNmQyODZjZDVmMyUyRmRpZmZ1c2VycyUyRnJhYmJpdC5qcGclMjIpJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoNDIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJhJTIwY2F0JTJDJTIwbWFzdGVycGllY2UlMkMlMjBiZXN0JTIwcXVhbGl0eSUyQyUyMGhpZ2glMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RzdHlsZV9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMnRleHQlMkMlMjB3YXRlcm1hcmslMkMlMjBsb3dyZXMlMkMlMjBsb3clMjBxdWFsaXR5JTJDJTIwd29yc3QlMjBxdWFsaXR5JTJDJTIwZGVmb3JtZWQlMkMlMjBnbGl0Y2glMkMlMjBsb3clMjBjb250cmFzdCUyQyUyMG5vaXN5JTJDJTIwc2F0dXJhdGlvbiUyQyUyMGJsdXJyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNENSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`style_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/0052a70beed5bf71b92610a43a52df6d286cd5f3/diffusers/rabbit.jpg&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>)
image = pipeline(
    prompt=<span class="hljs-string">&quot;a cat, masterpiece, best quality, high quality&quot;</span>,
    image=style_image,
    negative_prompt=<span class="hljs-string">&quot;text, watermark, lowres, low quality, worst quality, deformed, glitch, low contrast, noisy, saturation, blurry&quot;</span>,
    guidance_scale=<span class="hljs-number">5</span>,
    num_inference_steps=<span class="hljs-number">30</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ot=new v({props:{code:"c2NhbGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJ1cCUyMiUzQSUyMCU3QiUyMmJsb2NrXzAlMjIlM0ElMjAlNUIwLjAlMkMlMjAxLjAlMkMlMjAwLjAlNUQlN0QlMkMlMEElN0QlMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZShzY2FsZSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCg0MiklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBjYXQlMkMlMjBtYXN0ZXJwaWVjZSUyQyUyMGJlc3QlMjBxdWFsaXR5JTJDJTIwaGlnaCUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRHN0eWxlX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIydGV4dCUyQyUyMHdhdGVybWFyayUyQyUyMGxvd3JlcyUyQyUyMGxvdyUyMHF1YWxpdHklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBkZWZvcm1lZCUyQyUyMGdsaXRjaCUyQyUyMGxvdyUyMGNvbnRyYXN0JTJDJTIwbm9pc3klMkMlMjBzYXR1cmF0aW9uJTJDJTIwYmx1cnJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`scale = {
    <span class="hljs-string">&quot;up&quot;</span>: {<span class="hljs-string">&quot;block_0&quot;</span>: [<span class="hljs-number">0.0</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">0.0</span>]},
}
pipeline.set_ip_adapter_scale(scale)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>)
image = pipeline(
    prompt=<span class="hljs-string">&quot;a cat, masterpiece, best quality, high quality&quot;</span>,
    image=style_image,
    negative_prompt=<span class="hljs-string">&quot;text, watermark, lowres, low quality, worst quality, deformed, glitch, low contrast, noisy, saturation, blurry&quot;</span>,
    guidance_scale=<span class="hljs-number">5</span>,
    num_inference_steps=<span class="hljs-number">30</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),mt=new qa({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/ip_adapter.md"}}),{c(){p=o("meta"),w=n(),m=o("p"),M=n(),y(G.$$.fragment),_=n(),Z=o("p"),Z.innerHTML=I,c=n(),y(j.$$.fragment),X=n(),T=o("p"),T.textContent=k,W=n(),y(R.$$.fragment),u=n(),s=o("p"),s.innerHTML=b,ut=n(),ee=o("p"),ee.innerHTML=Ql,Mt=n(),y(Y.$$.fragment),yt=n(),y($.$$.fragment),ft=n(),y(te.$$.fragment),gt=n(),le=o("p"),le.textContent=Al,ht=n(),y(ae.$$.fragment),Jt=n(),se=o("p"),se.innerHTML=Sl,Ut=n(),y(F.$$.fragment),Zt=n(),ne=o("p"),ne.innerHTML=zl,bt=n(),y(N.$$.fragment),wt=n(),y(ie.$$.fragment),jt=n(),pe=o("p"),pe.innerHTML=El,Tt=n(),y(oe.$$.fragment),Wt=n(),y(re.$$.fragment),_t=n(),me=o("p"),me.textContent=ql,Gt=n(),de=o("p"),de.innerHTML=Ll,It=n(),y(ce.$$.fragment),Xt=n(),H=o("div"),H.innerHTML=Pl,kt=n(),ue=o("p"),ue.textContent=Dl,vt=n(),y(Me.$$.fragment),Ct=n(),Q=o("div"),Q.innerHTML=Kl,Rt=n(),ye=o("p"),ye.innerHTML=Ol,Vt=n(),y(fe.$$.fragment),xt=n(),A=o("div"),A.innerHTML=ea,Bt=n(),y(ge.$$.fragment),Yt=n(),he=o("p"),he.textContent=ta,$t=n(),y(Je.$$.fragment),Ft=n(),Ue=o("p"),Ue.innerHTML=la,Nt=n(),Ze=o("ul"),Ze.innerHTML=aa,Ht=n(),be=o("p"),be.innerHTML=sa,Qt=n(),we=o("p"),we.innerHTML=na,At=n(),y(je.$$.fragment),St=n(),S=o("div"),S.innerHTML=ia,zt=n(),Te=o("p"),Te.innerHTML=pa,Et=n(),y(We.$$.fragment),qt=n(),_e=o("p"),_e.textContent=oa,Lt=n(),y(Ge.$$.fragment),Pt=n(),y(Ie.$$.fragment),Dt=n(),Xe=o("p"),Xe.textContent=ra,Kt=n(),y(z.$$.fragment),Ot=n(),ke=o("p"),ke.innerHTML=ma,el=n(),y(ve.$$.fragment),tl=n(),Ce=o("p"),Ce.innerHTML=da,ll=n(),Re=o("ul"),Re.innerHTML=ca,al=n(),y(Ve.$$.fragment),sl=n(),xe=o("p"),xe.textContent=ua,nl=n(),y(Be.$$.fragment),il=n(),E=o("div"),E.innerHTML=Ma,pl=n(),Ye=o("p"),Ye.innerHTML=ya,ol=n(),y($e.$$.fragment),rl=n(),q=o("div"),q.innerHTML=fa,ml=n(),y(Fe.$$.fragment),dl=n(),Ne=o("p"),Ne.innerHTML=ga,cl=n(),He=o("p"),He.innerHTML=ha,ul=n(),y(Qe.$$.fragment),Ml=n(),Ae=o("p"),Ae.innerHTML=Ja,yl=n(),y(Se.$$.fragment),fl=n(),L=o("div"),L.innerHTML=Ua,gl=n(),y(ze.$$.fragment),hl=n(),Ee=o("p"),Ee.innerHTML=Za,Jl=n(),qe=o("p"),qe.innerHTML=ba,Ul=n(),y(Le.$$.fragment),Zl=n(),Pe=o("p"),Pe.textContent=wa,bl=n(),y(De.$$.fragment),wl=n(),P=o("div"),P.innerHTML=ja,jl=n(),Ke=o("p"),Ke.textContent=Ta,Tl=n(),y(Oe.$$.fragment),Wl=n(),D=o("div"),D.innerHTML=Wa,_l=n(),y(et.$$.fragment),Gl=n(),tt=o("p"),tt.innerHTML=_a,Il=n(),lt=o("p"),lt.innerHTML=Ga,Xl=n(),y(at.$$.fragment),kl=n(),st=o("p"),st.textContent=Ia,vl=n(),y(nt.$$.fragment),Cl=n(),K=o("div"),K.innerHTML=Xa,Rl=n(),it=o("p"),it.textContent=ka,Vl=n(),pt=o("p"),pt.textContent=va,xl=n(),y(ot.$$.fragment),Bl=n(),O=o("div"),O.innerHTML=Ca,Yl=n(),rt=o("p"),rt.textContent=Ra,$l=n(),y(mt.$$.fragment),Fl=n(),ct=o("p"),this.h()},l(e){const t=za("svelte-u9bgzb",document.head);p=r(t,"META",{name:!0,content:!0}),t.forEach(l),w=i(e),m=r(e,"P",{}),Na(m).forEach(l),M=i(e),f(G.$$.fragment,e),_=i(e),Z=r(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-rd9njz"&&(Z.innerHTML=I),c=i(e),f(j.$$.fragment,e),X=i(e),T=r(e,"P",{"data-svelte-h":!0}),d(T)!=="svelte-1211s0v"&&(T.textContent=k),W=i(e),f(R.$$.fragment,e),u=i(e),s=r(e,"P",{"data-svelte-h":!0}),d(s)!=="svelte-49swfq"&&(s.innerHTML=b),ut=i(e),ee=r(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1pmqs0j"&&(ee.innerHTML=Ql),Mt=i(e),f(Y.$$.fragment,e),yt=i(e),f($.$$.fragment,e),ft=i(e),f(te.$$.fragment,e),gt=i(e),le=r(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1ytpuar"&&(le.textContent=Al),ht=i(e),f(ae.$$.fragment,e),Jt=i(e),se=r(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-csxost"&&(se.innerHTML=Sl),Ut=i(e),f(F.$$.fragment,e),Zt=i(e),ne=r(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1h2tzec"&&(ne.innerHTML=zl),bt=i(e),f(N.$$.fragment,e),wt=i(e),f(ie.$$.fragment,e),jt=i(e),pe=r(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1nluq5y"&&(pe.innerHTML=El),Tt=i(e),f(oe.$$.fragment,e),Wt=i(e),f(re.$$.fragment,e),_t=i(e),me=r(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-18t8qca"&&(me.textContent=ql),Gt=i(e),de=r(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-ci17qi"&&(de.innerHTML=Ll),It=i(e),f(ce.$$.fragment,e),Xt=i(e),H=r(e,"DIV",{class:!0,"data-svelte-h":!0}),d(H)!=="svelte-eifaa"&&(H.innerHTML=Pl),kt=i(e),ue=r(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-uxfn1w"&&(ue.textContent=Dl),vt=i(e),f(Me.$$.fragment,e),Ct=i(e),Q=r(e,"DIV",{class:!0,"data-svelte-h":!0}),d(Q)!=="svelte-m35a5e"&&(Q.innerHTML=Kl),Rt=i(e),ye=r(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1oy5psd"&&(ye.innerHTML=Ol),Vt=i(e),f(fe.$$.fragment,e),xt=i(e),A=r(e,"DIV",{class:!0,"data-svelte-h":!0}),d(A)!=="svelte-1rjzzk0"&&(A.innerHTML=ea),Bt=i(e),f(ge.$$.fragment,e),Yt=i(e),he=r(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-3uurtn"&&(he.textContent=ta),$t=i(e),f(Je.$$.fragment,e),Ft=i(e),Ue=r(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-1hojnjd"&&(Ue.innerHTML=la),Nt=i(e),Ze=r(e,"UL",{"data-svelte-h":!0}),d(Ze)!=="svelte-1a56pqx"&&(Ze.innerHTML=aa),Ht=i(e),be=r(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-1ylc0is"&&(be.innerHTML=sa),Qt=i(e),we=r(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1dtaqqk"&&(we.innerHTML=na),At=i(e),f(je.$$.fragment,e),St=i(e),S=r(e,"DIV",{class:!0,"data-svelte-h":!0}),d(S)!=="svelte-lbwedl"&&(S.innerHTML=ia),zt=i(e),Te=r(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-10x245s"&&(Te.innerHTML=pa),Et=i(e),f(We.$$.fragment,e),qt=i(e),_e=r(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-1mw36co"&&(_e.textContent=oa),Lt=i(e),f(Ge.$$.fragment,e),Pt=i(e),f(Ie.$$.fragment,e),Dt=i(e),Xe=r(e,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-1tk2m7v"&&(Xe.textContent=ra),Kt=i(e),f(z.$$.fragment,e),Ot=i(e),ke=r(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-qgg0iy"&&(ke.innerHTML=ma),el=i(e),f(ve.$$.fragment,e),tl=i(e),Ce=r(e,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-1vw2kqb"&&(Ce.innerHTML=da),ll=i(e),Re=r(e,"UL",{"data-svelte-h":!0}),d(Re)!=="svelte-tpz2u9"&&(Re.innerHTML=ca),al=i(e),f(Ve.$$.fragment,e),sl=i(e),xe=r(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-1p6lwr0"&&(xe.textContent=ua),nl=i(e),f(Be.$$.fragment,e),il=i(e),E=r(e,"DIV",{class:!0,"data-svelte-h":!0}),d(E)!=="svelte-im3du6"&&(E.innerHTML=Ma),pl=i(e),Ye=r(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1kkzavx"&&(Ye.innerHTML=ya),ol=i(e),f($e.$$.fragment,e),rl=i(e),q=r(e,"DIV",{class:!0,"data-svelte-h":!0}),d(q)!=="svelte-1t1eqqe"&&(q.innerHTML=fa),ml=i(e),f(Fe.$$.fragment,e),dl=i(e),Ne=r(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-1am74qu"&&(Ne.innerHTML=ga),cl=i(e),He=r(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-ntp5s3"&&(He.innerHTML=ha),ul=i(e),f(Qe.$$.fragment,e),Ml=i(e),Ae=r(e,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-13u2z8i"&&(Ae.innerHTML=Ja),yl=i(e),f(Se.$$.fragment,e),fl=i(e),L=r(e,"DIV",{class:!0,"data-svelte-h":!0}),d(L)!=="svelte-1cw2b12"&&(L.innerHTML=Ua),gl=i(e),f(ze.$$.fragment,e),hl=i(e),Ee=r(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-sz8jif"&&(Ee.innerHTML=Za),Jl=i(e),qe=r(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-837b2y"&&(qe.innerHTML=ba),Ul=i(e),f(Le.$$.fragment,e),Zl=i(e),Pe=r(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-77tfin"&&(Pe.textContent=wa),bl=i(e),f(De.$$.fragment,e),wl=i(e),P=r(e,"DIV",{class:!0,"data-svelte-h":!0}),d(P)!=="svelte-mjuwpp"&&(P.innerHTML=ja),jl=i(e),Ke=r(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-12fzw16"&&(Ke.textContent=Ta),Tl=i(e),f(Oe.$$.fragment,e),Wl=i(e),D=r(e,"DIV",{class:!0,"data-svelte-h":!0}),d(D)!=="svelte-kc4794"&&(D.innerHTML=Wa),_l=i(e),f(et.$$.fragment,e),Gl=i(e),tt=r(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-b9vgt0"&&(tt.innerHTML=_a),Il=i(e),lt=r(e,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-23zu3l"&&(lt.innerHTML=Ga),Xl=i(e),f(at.$$.fragment,e),kl=i(e),st=r(e,"P",{"data-svelte-h":!0}),d(st)!=="svelte-owxbq9"&&(st.textContent=Ia),vl=i(e),f(nt.$$.fragment,e),Cl=i(e),K=r(e,"DIV",{class:!0,"data-svelte-h":!0}),d(K)!=="svelte-93qxsx"&&(K.innerHTML=Xa),Rl=i(e),it=r(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-12ccihh"&&(it.textContent=ka),Vl=i(e),pt=r(e,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-18cri0h"&&(pt.textContent=va),xl=i(e),f(ot.$$.fragment,e),Bl=i(e),O=r(e,"DIV",{class:!0,"data-svelte-h":!0}),d(O)!=="svelte-1dkgnzt"&&(O.innerHTML=Ca),Yl=i(e),rt=r(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-bmv4p"&&(rt.textContent=Ra),$l=i(e),f(mt.$$.fragment,e),Fl=i(e),ct=r(e,"P",{}),Na(ct).forEach(l),this.h()},h(){V(p,"name","hf:doc:metadata"),V(p,"content",os),V(H,"class","flex flex-row gap-4"),V(Q,"class","flex flex-row gap-4"),V(A,"class","flex flex-row gap-4"),V(S,"class","flex flex-row gap-4"),V(E,"class","flex flex-row gap-4"),V(q,"class","flex justify-center"),V(L,"class","flex justify-center"),V(P,"class","flex flex-row gap-4"),V(D,"class","flex justify-center"),V(K,"class","flex flex-row gap-4"),V(O,"class","flex flex-row gap-4")},m(e,t){Ea(document.head,p),a(e,w,t),a(e,m,t),a(e,M,t),g(G,e,t),a(e,_,t),a(e,Z,t),a(e,c,t),g(j,e,t),a(e,X,t),a(e,T,t),a(e,W,t),g(R,e,t),a(e,u,t),a(e,s,t),a(e,ut,t),a(e,ee,t),a(e,Mt,t),g(Y,e,t),a(e,yt,t),g($,e,t),a(e,ft,t),g(te,e,t),a(e,gt,t),a(e,le,t),a(e,ht,t),g(ae,e,t),a(e,Jt,t),a(e,se,t),a(e,Ut,t),g(F,e,t),a(e,Zt,t),a(e,ne,t),a(e,bt,t),g(N,e,t),a(e,wt,t),g(ie,e,t),a(e,jt,t),a(e,pe,t),a(e,Tt,t),g(oe,e,t),a(e,Wt,t),g(re,e,t),a(e,_t,t),a(e,me,t),a(e,Gt,t),a(e,de,t),a(e,It,t),g(ce,e,t),a(e,Xt,t),a(e,H,t),a(e,kt,t),a(e,ue,t),a(e,vt,t),g(Me,e,t),a(e,Ct,t),a(e,Q,t),a(e,Rt,t),a(e,ye,t),a(e,Vt,t),g(fe,e,t),a(e,xt,t),a(e,A,t),a(e,Bt,t),g(ge,e,t),a(e,Yt,t),a(e,he,t),a(e,$t,t),g(Je,e,t),a(e,Ft,t),a(e,Ue,t),a(e,Nt,t),a(e,Ze,t),a(e,Ht,t),a(e,be,t),a(e,Qt,t),a(e,we,t),a(e,At,t),g(je,e,t),a(e,St,t),a(e,S,t),a(e,zt,t),a(e,Te,t),a(e,Et,t),g(We,e,t),a(e,qt,t),a(e,_e,t),a(e,Lt,t),g(Ge,e,t),a(e,Pt,t),g(Ie,e,t),a(e,Dt,t),a(e,Xe,t),a(e,Kt,t),g(z,e,t),a(e,Ot,t),a(e,ke,t),a(e,el,t),g(ve,e,t),a(e,tl,t),a(e,Ce,t),a(e,ll,t),a(e,Re,t),a(e,al,t),g(Ve,e,t),a(e,sl,t),a(e,xe,t),a(e,nl,t),g(Be,e,t),a(e,il,t),a(e,E,t),a(e,pl,t),a(e,Ye,t),a(e,ol,t),g($e,e,t),a(e,rl,t),a(e,q,t),a(e,ml,t),g(Fe,e,t),a(e,dl,t),a(e,Ne,t),a(e,cl,t),a(e,He,t),a(e,ul,t),g(Qe,e,t),a(e,Ml,t),a(e,Ae,t),a(e,yl,t),g(Se,e,t),a(e,fl,t),a(e,L,t),a(e,gl,t),g(ze,e,t),a(e,hl,t),a(e,Ee,t),a(e,Jl,t),a(e,qe,t),a(e,Ul,t),g(Le,e,t),a(e,Zl,t),a(e,Pe,t),a(e,bl,t),g(De,e,t),a(e,wl,t),a(e,P,t),a(e,jl,t),a(e,Ke,t),a(e,Tl,t),g(Oe,e,t),a(e,Wl,t),a(e,D,t),a(e,_l,t),g(et,e,t),a(e,Gl,t),a(e,tt,t),a(e,Il,t),a(e,lt,t),a(e,Xl,t),g(at,e,t),a(e,kl,t),a(e,st,t),a(e,vl,t),g(nt,e,t),a(e,Cl,t),a(e,K,t),a(e,Rl,t),a(e,it,t),a(e,Vl,t),a(e,pt,t),a(e,xl,t),g(ot,e,t),a(e,Bl,t),a(e,O,t),a(e,Yl,t),a(e,rt,t),a(e,$l,t),g(mt,e,t),a(e,Fl,t),a(e,ct,t),Nl=!0},p(e,[t]){const Va={};t&2&&(Va.$$scope={dirty:t,ctx:e}),j.$set(Va);const xa={};t&2&&(xa.$$scope={dirty:t,ctx:e}),Y.$set(xa);const Ba={};t&2&&(Ba.$$scope={dirty:t,ctx:e}),$.$set(Ba);const Ya={};t&2&&(Ya.$$scope={dirty:t,ctx:e}),F.$set(Ya);const $a={};t&2&&($a.$$scope={dirty:t,ctx:e}),N.$set($a);const Fa={};t&2&&(Fa.$$scope={dirty:t,ctx:e}),z.$set(Fa)},i(e){Nl||(h(G.$$.fragment,e),h(j.$$.fragment,e),h(R.$$.fragment,e),h(Y.$$.fragment,e),h($.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(F.$$.fragment,e),h(N.$$.fragment,e),h(ie.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(Me.$$.fragment,e),h(fe.$$.fragment,e),h(ge.$$.fragment,e),h(Je.$$.fragment,e),h(je.$$.fragment,e),h(We.$$.fragment,e),h(Ge.$$.fragment,e),h(Ie.$$.fragment,e),h(z.$$.fragment,e),h(ve.$$.fragment,e),h(Ve.$$.fragment,e),h(Be.$$.fragment,e),h($e.$$.fragment,e),h(Fe.$$.fragment,e),h(Qe.$$.fragment,e),h(Se.$$.fragment,e),h(ze.$$.fragment,e),h(Le.$$.fragment,e),h(De.$$.fragment,e),h(Oe.$$.fragment,e),h(et.$$.fragment,e),h(at.$$.fragment,e),h(nt.$$.fragment,e),h(ot.$$.fragment,e),h(mt.$$.fragment,e),Nl=!0)},o(e){J(G.$$.fragment,e),J(j.$$.fragment,e),J(R.$$.fragment,e),J(Y.$$.fragment,e),J($.$$.fragment,e),J(te.$$.fragment,e),J(ae.$$.fragment,e),J(F.$$.fragment,e),J(N.$$.fragment,e),J(ie.$$.fragment,e),J(oe.$$.fragment,e),J(re.$$.fragment,e),J(ce.$$.fragment,e),J(Me.$$.fragment,e),J(fe.$$.fragment,e),J(ge.$$.fragment,e),J(Je.$$.fragment,e),J(je.$$.fragment,e),J(We.$$.fragment,e),J(Ge.$$.fragment,e),J(Ie.$$.fragment,e),J(z.$$.fragment,e),J(ve.$$.fragment,e),J(Ve.$$.fragment,e),J(Be.$$.fragment,e),J($e.$$.fragment,e),J(Fe.$$.fragment,e),J(Qe.$$.fragment,e),J(Se.$$.fragment,e),J(ze.$$.fragment,e),J(Le.$$.fragment,e),J(De.$$.fragment,e),J(Oe.$$.fragment,e),J(et.$$.fragment,e),J(at.$$.fragment,e),J(nt.$$.fragment,e),J(ot.$$.fragment,e),J(mt.$$.fragment,e),Nl=!1},d(e){e&&(l(w),l(m),l(M),l(_),l(Z),l(c),l(X),l(T),l(W),l(u),l(s),l(ut),l(ee),l(Mt),l(yt),l(ft),l(gt),l(le),l(ht),l(Jt),l(se),l(Ut),l(Zt),l(ne),l(bt),l(wt),l(jt),l(pe),l(Tt),l(Wt),l(_t),l(me),l(Gt),l(de),l(It),l(Xt),l(H),l(kt),l(ue),l(vt),l(Ct),l(Q),l(Rt),l(ye),l(Vt),l(xt),l(A),l(Bt),l(Yt),l(he),l($t),l(Ft),l(Ue),l(Nt),l(Ze),l(Ht),l(be),l(Qt),l(we),l(At),l(St),l(S),l(zt),l(Te),l(Et),l(qt),l(_e),l(Lt),l(Pt),l(Dt),l(Xe),l(Kt),l(Ot),l(ke),l(el),l(tl),l(Ce),l(ll),l(Re),l(al),l(sl),l(xe),l(nl),l(il),l(E),l(pl),l(Ye),l(ol),l(rl),l(q),l(ml),l(dl),l(Ne),l(cl),l(He),l(ul),l(Ml),l(Ae),l(yl),l(fl),l(L),l(gl),l(hl),l(Ee),l(Jl),l(qe),l(Ul),l(Zl),l(Pe),l(bl),l(wl),l(P),l(jl),l(Ke),l(Tl),l(Wl),l(D),l(_l),l(Gl),l(tt),l(Il),l(lt),l(Xl),l(kl),l(st),l(vl),l(Cl),l(K),l(Rl),l(it),l(Vl),l(pt),l(xl),l(Bl),l(O),l(Yl),l(rt),l($l),l(Fl),l(ct)),l(p),U(G,e),U(j,e),U(R,e),U(Y,e),U($,e),U(te,e),U(ae,e),U(F,e),U(N,e),U(ie,e),U(oe,e),U(re,e),U(ce,e),U(Me,e),U(fe,e),U(ge,e),U(Je,e),U(je,e),U(We,e),U(Ge,e),U(Ie,e),U(z,e),U(ve,e),U(Ve,e),U(Be,e),U($e,e),U(Fe,e),U(Qe,e),U(Se,e),U(ze,e),U(Le,e),U(De,e),U(Oe,e),U(et,e),U(at,e),U(nt,e),U(ot,e),U(mt,e)}}}const os='{"title":"IP-Adapter","local":"ip-adapter","sections":[{"title":"General tasks","local":"general-tasks","sections":[],"depth":2},{"title":"Configure parameters","local":"configure-parameters","sections":[{"title":"Image embeddings","local":"image-embeddings","sections":[],"depth":3},{"title":"IP-Adapter masking","local":"ip-adapter-masking","sections":[],"depth":3}],"depth":2},{"title":"Specific use cases","local":"specific-use-cases","sections":[{"title":"Face model","local":"face-model","sections":[],"depth":3},{"title":"Multi IP-Adapter","local":"multi-ip-adapter","sections":[],"depth":3},{"title":"Instant generation","local":"instant-generation","sections":[],"depth":3},{"title":"Structural control","local":"structural-control","sections":[],"depth":3},{"title":"Style & layout control","local":"style--layout-control","sections":[],"depth":3}],"depth":2}],"depth":1}';function rs(C){return Qa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fs extends Aa{constructor(p){super(),Sa(this,p,rs,ps,Ha,{})}}export{fs as component};
