import{s as mt,o as dt,n as Pe}from"../chunks/scheduler.182ea377.js";import{S as ht,i as yt,g as o,s as n,r as m,A as bt,h as p,f as s,c as a,j as ut,u as d,x as r,k as ct,y as ft,a as l,v as h,d as y,t as b,w as f}from"../chunks/index.abf12888.js";import{T as xe}from"../chunks/Tip.230e2334.js";import{C as se}from"../chunks/CodeBlock.57fe6e13.js";import{D as Mt}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as ne,E as wt}from"../chunks/EditOnGithub.9b8e78e4.js";function jt(T){let i,w='💡 We strongly recommend reading PyTorch’s <a href="https://pytorch.org/docs/stable/notes/randomness.html" rel="nofollow">statement about reproducibility</a>:',u,c,J="<p>Completely reproducible results are not guaranteed across PyTorch releases, individual commits, or different platforms. Furthermore, results may not be reproducible between CPU and GPU executions, even when using identical seeds.</p>";return{c(){i=o("p"),i.innerHTML=w,u=n(),c=o("blockquote"),c.innerHTML=J},l(M){i=p(M,"P",{"data-svelte-h":!0}),r(i)!=="svelte-mk56g"&&(i.innerHTML=w),u=a(M),c=p(M,"BLOCKQUOTE",{"data-svelte-h":!0}),r(c)!=="svelte-16ppwuq"&&(c.innerHTML=J)},m(M,j){l(M,i,j),l(M,u,j),l(M,c,j)},p:Pe,d(M){M&&(s(i),s(u),s(c))}}}function Jt(T){let i,w=`💡 It might be a bit unintuitive at first to pass <code>Generator</code> objects to the pipeline instead of
just integer values representing the seed, but this is the recommended design when dealing with
probabilistic models in PyTorch, as <code>Generator</code>s are <em>random states</em> that can be
passed to multiple pipelines in a sequence.`;return{c(){i=o("p"),i.innerHTML=w},l(u){i=p(u,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1whzuej"&&(i.innerHTML=w)},m(u,c){l(u,i,c)},p:Pe,d(u){u&&s(i)}}}function Tt(T){let i,w=`💡 If reproducibility is important, we recommend always passing a CPU generator.
The performance loss is often neglectable, and you’ll generate much more similar
values than if the pipeline had been run on a GPU.`;return{c(){i=o("p"),i.textContent=w},l(u){i=p(u,"P",{"data-svelte-h":!0}),r(i)!=="svelte-6qqsvj"&&(i.textContent=w)},m(u,c){l(u,i,c)},p:Pe,d(u){u&&s(i)}}}function gt(T){let i,w,u,c,J,M,j,ae,W,Qe='Reproducibility is important for testing, replicating results, and can even be used to <a href="reusing_seeds">improve image quality</a>. However, the randomness in diffusion models is a desired property because it allows the pipeline to generate different images every time it is run. While you can’t expect to get the exact same results across platforms, you can expect results to be reproducible across releases and platforms within a certain tolerance range. Even then, tolerance varies depending on the diffusion pipeline and checkpoint.',ie,B,ze="This is why it’s important to understand how to control sources of randomness in diffusion models or use deterministic algorithms.",oe,g,pe,$,re,G,Se=`During inference, pipelines rely heavily on random sampling operations which include creating the
Gaussian noise tensors to denoise and adding noise to the scheduling step.`,ue,I,Fe='Take a look at the tensor values in the <a href="/docs/diffusers/main/en/api/pipelines/ddim#diffusers.DDIMPipeline">DDIMPipeline</a> after two inference steps:',ce,v,me,C,Ne="Running the code above prints one value, but if you run it again you get a different value. What is going on here?",de,_,qe='Every time the pipeline is run, <a href="https://pytorch.org/docs/stable/generated/torch.randn.html" rel="nofollow"><code>torch.randn</code></a> uses a different random seed to create Gaussian noise which is denoised stepwise. This leads to a different result each time it is run, which is great for diffusion pipelines since it generates a different random image each time.',he,k,Ye="But if you need to reliably generate the same image, that’ll depend on whether you’re running the pipeline on a CPU or GPU.",ye,V,be,R,Le='To generate reproducible results on a CPU, you’ll need to use a PyTorch <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>Generator</code></a> and set a seed:',fe,X,Me,E,De="Now when you run the code above, it always prints a value of <code>1491.1711</code> no matter what because the <code>Generator</code> object with the seed is passed to all the random functions of the pipeline.",we,H,Ae="If you run this code example on your specific hardware and PyTorch version, you should get a similar, if not the same, result.",je,U,Je,x,Te,P,Ke="Writing a reproducible pipeline on a GPU is a bit trickier, and full reproducibility across different hardware is not guaranteed because matrix multiplication - which diffusion pipelines require a lot of - is less deterministic on a GPU than a CPU. For example, if you run the same code example above on a GPU:",ge,Q,Ue,z,Oe="The result is not the same even though you’re using an identical seed because the GPU uses a different random number generator than the CPU.",Ze,S,et="To circumvent this problem, 🧨 Diffusers has a <code>randn_tensor()</code> function for creating random noise on the CPU, and then moving the tensor to a GPU if necessary. The <code>randn_tensor</code> function is used everywhere inside the pipeline, allowing the user to <strong>always</strong> pass a CPU <code>Generator</code> even if the pipeline is run on a GPU.",We,F,tt="You’ll see the results are much closer now!",Be,N,$e,Z,Ge,q,st=`Finally, for more complex pipelines such as <a href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.UnCLIPPipeline">UnCLIPPipeline</a>, these are often extremely
susceptible to precision error propagation. Don’t expect similar results across
different GPU hardware or PyTorch versions. In this case, you’ll need to run
exactly the same hardware and PyTorch version for full reproducibility.`,Ie,Y,ve,L,lt="You can also configure PyTorch to use deterministic algorithms to create a reproducible pipeline. However, you should be aware that deterministic algorithms may be slower than nondeterministic ones and you may observe a decrease in performance. But if reproducibility is important to you, then this is the way to go!",Ce,D,nt='Nondeterministic behavior occurs when operations are launched in more than one CUDA stream. To avoid this, set the environment variable <a href="https://docs.nvidia.com/cuda/cublas/index.html#results-reproducibility" rel="nofollow"><code>CUBLAS_WORKSPACE_CONFIG</code></a> to <code>:16:8</code> to only use one buffer size during runtime.',_e,A,at='PyTorch typically benchmarks multiple algorithms to select the fastest one, but if you want reproducibility, you should disable this feature because the benchmark may select different algorithms each time. Lastly, pass <code>True</code> to <a href="https://pytorch.org/docs/stable/generated/torch.use_deterministic_algorithms.html" rel="nofollow"><code>torch.use_deterministic_algorithms</code></a> to enable deterministic algorithms.',ke,K,Ve,O,it="Now when you run the same pipeline twice, you’ll get identical results.",Re,ee,Xe,te,Ee,le,He;return J=new ne({props:{title:"Create reproducible pipelines",local:"create-reproducible-pipelines",headingTag:"h1"}}),j=new Mt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/reproducibility.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/reproducibility.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/reproducibility.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/reproducibility.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/reproducibility.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/reproducibility.ipynb"}]}}),g=new xe({props:{$$slots:{default:[jt]},$$scope:{ctx:T}}}),$=new ne({props:{title:"Control randomness",local:"control-randomness",headingTag:"h2"}}),v=new se({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERESU1QaXBlbGluZSUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTBBJTBBJTIzJTIwbG9hZCUyMG1vZGVsJTIwYW5kJTIwc2NoZWR1bGVyJTBBZGRpbSUyMCUzRCUyMERESU1QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQSUwQSUyMyUyMHJ1biUyMHBpcGVsaW5lJTIwZm9yJTIwanVzdCUyMHR3byUyMHN0ZXBzJTIwYW5kJTIwcmV0dXJuJTIwbnVtcHklMjB0ZW5zb3IlMEFpbWFnZSUyMCUzRCUyMGRkaW0obnVtX2luZmVyZW5jZV9zdGVwcyUzRDIlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMm5wJTIyKS5pbWFnZXMlMEFwcmludChucC5hYnMoaW1hZ2UpLnN1bSgpKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>

<span class="hljs-comment"># load model and scheduler</span>
ddim = DDIMPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># run pipeline for just two steps and return numpy tensor</span>
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`,wrap:!1}}),V=new ne({props:{title:"CPU",local:"cpu",headingTag:"h3"}}),X=new se({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVBpcGVsaW5lJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMEElMEElMjMlMjBsb2FkJTIwbW9kZWwlMjBhbmQlMjBzY2hlZHVsZXIlMEFkZGltJTIwJTNEJTIwRERJTVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBJTBBJTIzJTIwY3JlYXRlJTIwYSUyMGdlbmVyYXRvciUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBJTBBJTIzJTIwcnVuJTIwcGlwZWxpbmUlMjBmb3IlMjBqdXN0JTIwdHdvJTIwc3RlcHMlMjBhbmQlMjByZXR1cm4lMjBudW1weSUyMHRlbnNvciUwQWltYWdlJTIwJTNEJTIwZGRpbShudW1faW5mZXJlbmNlX3N0ZXBzJTNEMiUyQyUyMG91dHB1dF90eXBlJTNEJTIybnAlMjIlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyUwQXByaW50KG5wLmFicyhpbWFnZSkuc3VtKCkp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>

<span class="hljs-comment"># load model and scheduler</span>
ddim = DDIMPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># create a generator for reproducibility</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-comment"># run pipeline for just two steps and return numpy tensor</span>
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>, generator=generator).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`,wrap:!1}}),U=new xe({props:{$$slots:{default:[Jt]},$$scope:{ctx:T}}}),x=new ne({props:{title:"GPU",local:"gpu",headingTag:"h3"}}),Q=new se({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVBpcGVsaW5lJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMEElMEElMjMlMjBsb2FkJTIwbW9kZWwlMjBhbmQlMjBzY2hlZHVsZXIlMEFkZGltJTIwJTNEJTIwRERJTVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBZGRpbS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGNyZWF0ZSUyMGElMjBnZW5lcmF0b3IlMjBmb3IlMjByZXByb2R1Y2liaWxpdHklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCklMEElMEElMjMlMjBydW4lMjBwaXBlbGluZSUyMGZvciUyMGp1c3QlMjB0d28lMjBzdGVwcyUyMGFuZCUyMHJldHVybiUyMG51bXB5JTIwdGVuc29yJTBBaW1hZ2UlMjAlM0QlMjBkZGltKG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMiUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuaW1hZ2VzJTBBcHJpbnQobnAuYWJzKGltYWdlKS5zdW0oKSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>

<span class="hljs-comment"># load model and scheduler</span>
ddim = DDIMPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)
ddim.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># create a generator for reproducibility</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-comment"># run pipeline for just two steps and return numpy tensor</span>
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>, generator=generator).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`,wrap:!1}}),N=new se({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVBpcGVsaW5lJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMEElMEElMjMlMjBsb2FkJTIwbW9kZWwlMjBhbmQlMjBzY2hlZHVsZXIlMEFkZGltJTIwJTNEJTIwRERJTVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBZGRpbS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGNyZWF0ZSUyMGElMjBnZW5lcmF0b3IlMjBmb3IlMjByZXByb2R1Y2liaWxpdHklM0IlMjBub3RpY2UlMjB5b3UlMjBkb24ndCUyMHBsYWNlJTIwaXQlMjBvbiUyMHRoZSUyMEdQVSElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUwQSUwQSUyMyUyMHJ1biUyMHBpcGVsaW5lJTIwZm9yJTIwanVzdCUyMHR3byUyMHN0ZXBzJTIwYW5kJTIwcmV0dXJuJTIwbnVtcHklMjB0ZW5zb3IlMEFpbWFnZSUyMCUzRCUyMGRkaW0obnVtX2luZmVyZW5jZV9zdGVwcyUzRDIlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMm5wJTIyJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlMEFwcmludChucC5hYnMoaW1hZ2UpLnN1bSgpKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>

<span class="hljs-comment"># load model and scheduler</span>
ddim = DDIMPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)
ddim.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># create a generator for reproducibility; notice you don&#x27;t place it on the GPU!</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-comment"># run pipeline for just two steps and return numpy tensor</span>
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>, generator=generator).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`,wrap:!1}}),Z=new xe({props:{$$slots:{default:[Tt]},$$scope:{ctx:T}}}),Y=new ne({props:{title:"Deterministic algorithms",local:"deterministic-algorithms",headingTag:"h2"}}),K=new se({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQW9zLmVudmlyb24lNUIlMjJDVUJMQVNfV09SS1NQQUNFX0NPTkZJRyUyMiU1RCUyMCUzRCUyMCUyMiUzQTE2JTNBOCUyMiUwQSUwQXRvcmNoLmJhY2tlbmRzLmN1ZG5uLmJlbmNobWFyayUyMCUzRCUyMEZhbHNlJTBBdG9yY2gudXNlX2RldGVybWluaXN0aWNfYWxnb3JpdGhtcyhUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch

os.environ[<span class="hljs-string">&quot;CUBLAS_WORKSPACE_CONFIG&quot;</span>] = <span class="hljs-string">&quot;:16:8&quot;</span>

torch.backends.cudnn.benchmark = <span class="hljs-literal">False</span>
torch.use_deterministic_algorithms(<span class="hljs-literal">True</span>)`,wrap:!1}}),ee=new se({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVNjaGVkdWxlciUyQyUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBZyUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBiZWFyJTIwaXMlMjBwbGF5aW5nJTIwYSUyMGd1aXRhciUyMG9uJTIwVGltZXMlMjBTcXVhcmUlMjIlMEElMEFnLm1hbnVhbF9zZWVkKDApJTBBcmVzdWx0MSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwZ2VuZXJhdG9yJTNEZyUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlMEElMEFnLm1hbnVhbF9zZWVkKDApJTBBcmVzdWx0MiUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwZ2VuZXJhdG9yJTNEZyUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlMEElMEFwcmludCglMjJMX2luZiUyMGRpc3QlMjAlM0QlMjIlMkMlMjBhYnMocmVzdWx0MSUyMC0lMjByZXN1bHQyKS5tYXgoKSklMEElMjJMX2luZiUyMGRpc3QlMjAlM0QlMjB0ZW5zb3IoMC4lMkMlMjBkZXZpY2UlM0QnY3VkYSUzQTAnKSUyMg==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler, StableDiffusionPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
g = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A bear is playing a guitar on Times Square&quot;</span>

g.manual_seed(<span class="hljs-number">0</span>)
result1 = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">50</span>, generator=g, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images

g.manual_seed(<span class="hljs-number">0</span>)
result2 = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">50</span>, generator=g, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;L_inf dist =&quot;</span>, <span class="hljs-built_in">abs</span>(result1 - result2).<span class="hljs-built_in">max</span>())
<span class="hljs-string">&quot;L_inf dist = tensor(0., device=&#x27;cuda:0&#x27;)&quot;</span>`,wrap:!1}}),te=new wt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/reproducibility.md"}}),{c(){i=o("meta"),w=n(),u=o("p"),c=n(),m(J.$$.fragment),M=n(),m(j.$$.fragment),ae=n(),W=o("p"),W.innerHTML=Qe,ie=n(),B=o("p"),B.textContent=ze,oe=n(),m(g.$$.fragment),pe=n(),m($.$$.fragment),re=n(),G=o("p"),G.textContent=Se,ue=n(),I=o("p"),I.innerHTML=Fe,ce=n(),m(v.$$.fragment),me=n(),C=o("p"),C.textContent=Ne,de=n(),_=o("p"),_.innerHTML=qe,he=n(),k=o("p"),k.textContent=Ye,ye=n(),m(V.$$.fragment),be=n(),R=o("p"),R.innerHTML=Le,fe=n(),m(X.$$.fragment),Me=n(),E=o("p"),E.innerHTML=De,we=n(),H=o("p"),H.textContent=Ae,je=n(),m(U.$$.fragment),Je=n(),m(x.$$.fragment),Te=n(),P=o("p"),P.textContent=Ke,ge=n(),m(Q.$$.fragment),Ue=n(),z=o("p"),z.textContent=Oe,Ze=n(),S=o("p"),S.innerHTML=et,We=n(),F=o("p"),F.textContent=tt,Be=n(),m(N.$$.fragment),$e=n(),m(Z.$$.fragment),Ge=n(),q=o("p"),q.innerHTML=st,Ie=n(),m(Y.$$.fragment),ve=n(),L=o("p"),L.textContent=lt,Ce=n(),D=o("p"),D.innerHTML=nt,_e=n(),A=o("p"),A.innerHTML=at,ke=n(),m(K.$$.fragment),Ve=n(),O=o("p"),O.textContent=it,Re=n(),m(ee.$$.fragment),Xe=n(),m(te.$$.fragment),Ee=n(),le=o("p"),this.h()},l(e){const t=bt("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(s),w=a(e),u=p(e,"P",{}),ut(u).forEach(s),c=a(e),d(J.$$.fragment,e),M=a(e),d(j.$$.fragment,e),ae=a(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1sdj1n4"&&(W.innerHTML=Qe),ie=a(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-spyond"&&(B.textContent=ze),oe=a(e),d(g.$$.fragment,e),pe=a(e),d($.$$.fragment,e),re=a(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1tn5oba"&&(G.textContent=Se),ue=a(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-uupr25"&&(I.innerHTML=Fe),ce=a(e),d(v.$$.fragment,e),me=a(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-6e7pfa"&&(C.textContent=Ne),de=a(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-mhfmil"&&(_.innerHTML=qe),he=a(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-opovkl"&&(k.textContent=Ye),ye=a(e),d(V.$$.fragment,e),be=a(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1kryd8j"&&(R.innerHTML=Le),fe=a(e),d(X.$$.fragment,e),Me=a(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-jf8pj"&&(E.innerHTML=De),we=a(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1mz2u42"&&(H.textContent=Ae),je=a(e),d(U.$$.fragment,e),Je=a(e),d(x.$$.fragment,e),Te=a(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-vhxkpf"&&(P.textContent=Ke),ge=a(e),d(Q.$$.fragment,e),Ue=a(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1tpavxr"&&(z.textContent=Oe),Ze=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-oj1ygm"&&(S.innerHTML=et),We=a(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-v5oouu"&&(F.textContent=tt),Be=a(e),d(N.$$.fragment,e),$e=a(e),d(Z.$$.fragment,e),Ge=a(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-zwtlbi"&&(q.innerHTML=st),Ie=a(e),d(Y.$$.fragment,e),ve=a(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-j2780s"&&(L.textContent=lt),Ce=a(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-10j1qq1"&&(D.innerHTML=nt),_e=a(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1ncc9dd"&&(A.innerHTML=at),ke=a(e),d(K.$$.fragment,e),Ve=a(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-b9yuf0"&&(O.textContent=it),Re=a(e),d(ee.$$.fragment,e),Xe=a(e),d(te.$$.fragment,e),Ee=a(e),le=p(e,"P",{}),ut(le).forEach(s),this.h()},h(){ct(i,"name","hf:doc:metadata"),ct(i,"content",Ut)},m(e,t){ft(document.head,i),l(e,w,t),l(e,u,t),l(e,c,t),h(J,e,t),l(e,M,t),h(j,e,t),l(e,ae,t),l(e,W,t),l(e,ie,t),l(e,B,t),l(e,oe,t),h(g,e,t),l(e,pe,t),h($,e,t),l(e,re,t),l(e,G,t),l(e,ue,t),l(e,I,t),l(e,ce,t),h(v,e,t),l(e,me,t),l(e,C,t),l(e,de,t),l(e,_,t),l(e,he,t),l(e,k,t),l(e,ye,t),h(V,e,t),l(e,be,t),l(e,R,t),l(e,fe,t),h(X,e,t),l(e,Me,t),l(e,E,t),l(e,we,t),l(e,H,t),l(e,je,t),h(U,e,t),l(e,Je,t),h(x,e,t),l(e,Te,t),l(e,P,t),l(e,ge,t),h(Q,e,t),l(e,Ue,t),l(e,z,t),l(e,Ze,t),l(e,S,t),l(e,We,t),l(e,F,t),l(e,Be,t),h(N,e,t),l(e,$e,t),h(Z,e,t),l(e,Ge,t),l(e,q,t),l(e,Ie,t),h(Y,e,t),l(e,ve,t),l(e,L,t),l(e,Ce,t),l(e,D,t),l(e,_e,t),l(e,A,t),l(e,ke,t),h(K,e,t),l(e,Ve,t),l(e,O,t),l(e,Re,t),h(ee,e,t),l(e,Xe,t),h(te,e,t),l(e,Ee,t),l(e,le,t),He=!0},p(e,[t]){const ot={};t&2&&(ot.$$scope={dirty:t,ctx:e}),g.$set(ot);const pt={};t&2&&(pt.$$scope={dirty:t,ctx:e}),U.$set(pt);const rt={};t&2&&(rt.$$scope={dirty:t,ctx:e}),Z.$set(rt)},i(e){He||(y(J.$$.fragment,e),y(j.$$.fragment,e),y(g.$$.fragment,e),y($.$$.fragment,e),y(v.$$.fragment,e),y(V.$$.fragment,e),y(X.$$.fragment,e),y(U.$$.fragment,e),y(x.$$.fragment,e),y(Q.$$.fragment,e),y(N.$$.fragment,e),y(Z.$$.fragment,e),y(Y.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),He=!0)},o(e){b(J.$$.fragment,e),b(j.$$.fragment,e),b(g.$$.fragment,e),b($.$$.fragment,e),b(v.$$.fragment,e),b(V.$$.fragment,e),b(X.$$.fragment,e),b(U.$$.fragment,e),b(x.$$.fragment,e),b(Q.$$.fragment,e),b(N.$$.fragment,e),b(Z.$$.fragment,e),b(Y.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),He=!1},d(e){e&&(s(w),s(u),s(c),s(M),s(ae),s(W),s(ie),s(B),s(oe),s(pe),s(re),s(G),s(ue),s(I),s(ce),s(me),s(C),s(de),s(_),s(he),s(k),s(ye),s(be),s(R),s(fe),s(Me),s(E),s(we),s(H),s(je),s(Je),s(Te),s(P),s(ge),s(Ue),s(z),s(Ze),s(S),s(We),s(F),s(Be),s($e),s(Ge),s(q),s(Ie),s(ve),s(L),s(Ce),s(D),s(_e),s(A),s(ke),s(Ve),s(O),s(Re),s(Xe),s(Ee),s(le)),s(i),f(J,e),f(j,e),f(g,e),f($,e),f(v,e),f(V,e),f(X,e),f(U,e),f(x,e),f(Q,e),f(N,e),f(Z,e),f(Y,e),f(K,e),f(ee,e),f(te,e)}}}const Ut='{"title":"Create reproducible pipelines","local":"create-reproducible-pipelines","sections":[{"title":"Control randomness","local":"control-randomness","sections":[{"title":"CPU","local":"cpu","sections":[],"depth":3},{"title":"GPU","local":"gpu","sections":[],"depth":3}],"depth":2},{"title":"Deterministic algorithms","local":"deterministic-algorithms","sections":[],"depth":2}],"depth":1}';function Zt(T){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ct extends ht{constructor(i){super(),yt(this,i,Zt,gt,mt,{})}}export{Ct as component};
