import{s as Ni,n as Ui,o as Gi}from"../chunks/scheduler.0219f8bd.js";import{S as Ji,i as Qi,g as r,s as l,r as c,A as Xi,h as a,f as d,c as i,j as s,u as m,x as n,k as u,y as Yi,a as o,v as p,d as f,t as h,w as _}from"../chunks/index.f61edf3b.js";import{H as b,E as Zi}from"../chunks/getInferenceSnippets.afc48652.js";function er(Pl){let w,Mt,xt,Ct,g,qt,v,Pt,T,Rl="Helper module for audio processing.",Rt,y,zl=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,zt,$,kl='<li><a href="#module_utils/audio">utils/audio</a><ul><li><em>static</em><ul><li><a href="#module_utils/audio.RawAudio">.RawAudio</a><ul><li><a href="#new_module_utils/audio.RawAudio_new"><code>new RawAudio(audio, sampling_rate)</code></a></li> <li><a href="#module_utils/audio.RawAudio+toWav"><code>.toWav()</code></a> ⇒ <code>ArrayBuffer</code></li> <li><a href="#module_utils/audio.RawAudio+toBlob"><code>.toBlob()</code></a> ⇒ <code>Blob</code></li> <li><a href="#module_utils/audio.RawAudio+save"><code>.save(path)</code></a></li></ul></li> <li><a href="#module_utils/audio.read_audio"><code>.read_audio(url, sampling_rate)</code></a> ⇒ <code>Promise.&lt;Float32Array&gt;</code><ul><li><a href="#module_utils/audio.read_audio..audio"><code>~audio</code></a> : <code>Float32Array</code></li></ul></li> <li><a href="#module_utils/audio.hanning"><code>.hanning(M)</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/audio.hamming"><code>.hamming(M)</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/audio.mel_filter_bank"><code>.mel_filter_bank(num_frequency_bins, num_mel_filters, min_frequency, max_frequency, sampling_rate, [norm], [mel_scale], [triangularize_in_mel_space])</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/audio.spectrogram"><code>.spectrogram(waveform, window, frame_length, hop_length, options)</code></a> ⇒ <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a></li> <li><a href="#module_utils/audio.window_function"><code>.window_function(window_length, name, options)</code></a> ⇒ <code>Float64Array</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/audio..generalized_cosine_window"><code>~generalized_cosine_window(M, a_0)</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/audio..hertz_to_mel"><code>~hertz_to_mel(freq, [mel_scale])</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio..mel_to_hertz"><code>~mel_to_hertz(mels, [mel_scale])</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio.._create_triangular_filter_bank"><code>~_create_triangular_filter_bank(fft_freqs, filter_freqs)</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/audio..linspace"><code>~linspace(start, end, num)</code></a> ⇒</li> <li><a href="#module_utils/audio..padReflect"><code>~padReflect(array, left, right)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio.._db_conversion_helper"><code>~_db_conversion_helper(spectrogram, factor, reference, min_value, db_range)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio..amplitude_to_db"><code>~amplitude_to_db(spectrogram, [reference], [min_value], [db_range])</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio..power_to_db"><code>~power_to_db(spectrogram, [reference], [min_value], [db_range])</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/audio..encodeWAV"><code>~encodeWAV(samples, rate)</code></a> ⇒ <code>ArrayBuffer</code></li></ul></li></ul></li>',kt,Ft,Bt,A,Et,H,Wt,x,Fl='<strong>Kind</strong>: static class of <a href="#module_utils/audio"><code>utils/audio</code></a>',Dt,L,Bl='<li><a href="#module_utils/audio.RawAudio">.RawAudio</a><ul><li><a href="#new_module_utils/audio.RawAudio_new"><code>new RawAudio(audio, sampling_rate)</code></a></li> <li><a href="#module_utils/audio.RawAudio+toWav"><code>.toWav()</code></a> ⇒ <code>ArrayBuffer</code></li> <li><a href="#module_utils/audio.RawAudio+toBlob"><code>.toBlob()</code></a> ⇒ <code>Blob</code></li> <li><a href="#module_utils/audio.RawAudio+save"><code>.save(path)</code></a></li></ul></li>',Kt,St,jt,M,It,C,Vt,q,El="Create a new <code>RawAudio</code> object.",Ot,P,Wl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>Float32Array</code></td><td><p>Audio data</p></td> </tr><tr><td>sampling_rate</td><td><code>number</code></td><td><p>Sampling rate of the audio data</p></td></tr></tbody>",Nt,Ut,Gt,R,Jt,z,Qt,k,Dl="Convert the audio to a wav file buffer.",Xt,F,Kl='<strong>Kind</strong>: instance method of <a href="#module_utils/audio.RawAudio"><code>RawAudio</code></a><br/> <strong>Returns</strong>: <code>ArrayBuffer</code> - The WAV file.',Yt,Zt,ed,B,td,E,dd,W,Sl="Convert the audio to a blob.",od,D,jl='<strong>Kind</strong>: instance method of <a href="#module_utils/audio.RawAudio"><code>RawAudio</code></a>',ld,id,rd,K,ad,S,nd,j,Il="Save the audio to a wav file.",ud,I,Vl='<strong>Kind</strong>: instance method of <a href="#module_utils/audio.RawAudio"><code>RawAudio</code></a>',sd,V,Ol="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td></tr></tbody>",cd,md,pd,O,fd,N,hd,U,Nl="Helper function to read audio from a path/URL.",_d,G,Ul='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Float32Array&gt;</code> - The decoded audio as a <code>Float32Array</code>.',bd,J,Gl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>url</td><td><code>string</code> | <code>URL</code></td><td><p>The path/URL to load the audio from.</p></td> </tr><tr><td>sampling_rate</td><td><code>number</code></td><td><p>The sampling rate to use when decoding the audio.</p></td></tr></tbody>",wd,gd,vd,Q,Td,X,yd,Y,Jl='<strong>Kind</strong>: inner property of <a href="#module_utils/audio.read_audio"><code>read_audio</code></a>',$d,Ad,Hd,Z,xd,ee,Ld,te,Ql=`Generates a Hanning window of length M.
See <a href="https://numpy.org/doc/stable/reference/generated/numpy.hanning.html" rel="nofollow">https://numpy.org/doc/stable/reference/generated/numpy.hanning.html</a> for more information.`,Md,de,Xl='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The generated Hanning window.',Cd,oe,Yl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>M</td><td><code>number</code></td><td><p>The length of the Hanning window to generate.</p></td></tr></tbody>",qd,Pd,Rd,le,zd,ie,kd,re,Zl=`Generates a Hamming window of length M.
See <a href="https://numpy.org/doc/stable/reference/generated/numpy.hamming.html" rel="nofollow">https://numpy.org/doc/stable/reference/generated/numpy.hamming.html</a> for more information.`,Fd,ae,ei='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The generated Hamming window.',Bd,ne,ti="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>M</td><td><code>number</code></td><td><p>The length of the Hamming window to generate.</p></td></tr></tbody>",Ed,Wd,Dd,ue,Kd,se,Sd,ce,di=`Creates a frequency bin conversion matrix used to obtain a mel spectrogram. This is called a <em>mel filter bank</em>, and
various implementation exist, which differ in the number of filters, the shape of the filters, the way the filters
are spaced, the bandwidth of the filters, and the manner in which the spectrum is warped. The goal of these
features is to approximate the non-linear human perception of the variation in pitch with respect to the frequency.`,jd,me,oi=`<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Array&lt;number&gt;&gt;</code> - Triangular filter bank matrix, which is a 2D array of shape (<code>num_frequency_bins</code>, <code>num_mel_filters</code>).
This is a projection matrix to go from a spectrogram to a mel spectrogram.`,Id,pe,li=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>num_frequency_bins</td><td><code>number</code></td><td><p>Number of frequency bins (should be the same as <code>n_fft // 2 + 1</code>
where <code>n_fft</code> is the size of the Fourier Transform used to compute the spectrogram).</p></td> </tr><tr><td>num_mel_filters</td><td><code>number</code></td><td><p>Number of mel filters to generate.</p></td> </tr><tr><td>min_frequency</td><td><code>number</code></td><td><p>Lowest frequency of interest in Hz.</p></td> </tr><tr><td>max_frequency</td><td><code>number</code></td><td><p>Highest frequency of interest in Hz. This should not exceed <code>sampling_rate / 2</code>.</p></td> </tr><tr><td>sampling_rate</td><td><code>number</code></td><td><p>Sample rate of the audio waveform.</p></td> </tr><tr><td>[norm]</td><td><code>string</code></td><td><p>If <code>&quot;slaney&quot;</code>, divide the triangular mel weights by the width of the mel band (area normalization).</p></td> </tr><tr><td>[mel_scale]</td><td><code>string</code></td><td><p>The mel frequency scale to use, <code>&quot;htk&quot;</code> or <code>&quot;slaney&quot;</code>.</p></td> </tr><tr><td>[triangularize_in_mel_space]</td><td><code>boolean</code></td><td><p>If this option is enabled, the triangular filter is applied in mel space rather than frequency space.
This should be set to <code>true</code> in order to get the same results as <code>torchaudio</code> when computing mel filters.</p></td></tr></tbody>`,Vd,Od,Nd,fe,Ud,he,Gd,_e,ii="Calculates a spectrogram over one waveform using the Short-Time Fourier Transform.",Jd,be,ri="This function can create the following kinds of spectrograms:",Qd,we,ai="<li>amplitude spectrogram (<code>power = 1.0</code>)</li> <li>power spectrogram (<code>power = 2.0</code>)</li> <li>complex-valued spectrogram (<code>power = None</code>)</li> <li>log spectrogram (use <code>log_mel</code> argument)</li> <li>mel spectrogram (provide <code>mel_filters</code>)</li> <li>log-mel spectrogram (provide <code>mel_filters</code> and <code>log_mel</code>)</li>",Xd,ge,ni=`In this implementation, the window is assumed to be zero-padded to have the same size as the analysis frame.
A padded window can be obtained from <code>window_function()</code>. The FFT input buffer may be larger than the analysis frame,
typically the next power of two.`,Yd,ve,ui='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <a href="#Tensor"><code>Promise.&lt;Tensor&gt;</code></a> - Spectrogram of shape <code>(num_frequency_bins, length)</code> (regular spectrogram) or shape <code>(num_mel_filters, length)</code> (mel spectrogram).',Zd,Te,si=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>waveform</td><td><code>Float32Array</code> | <code>Float64Array</code></td><td></td><td><p>The input waveform of shape <code>(length,)</code>. This must be a single real-valued, mono waveform.</p></td> </tr><tr><td>window</td><td><code>Float32Array</code> | <code>Float64Array</code></td><td></td><td><p>The windowing function to apply of shape <code>(frame_length,)</code>, including zero-padding if necessary. The actual window length may be
shorter than <code>frame_length</code>, but we&#39;re assuming the array has already been zero-padded.</p></td> </tr><tr><td>frame_length</td><td><code>number</code></td><td></td><td><p>The length of the analysis frames in samples (a.k.a., <code>fft_length</code>).</p></td> </tr><tr><td>hop_length</td><td><code>number</code></td><td></td><td><p>The stride between successive analysis frames in samples.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td></td> </tr><tr><td>[options.fft_length]</td><td><code>number</code></td><td><code></code></td><td><p>The size of the FFT buffer in samples. This determines how many frequency bins the spectrogram will have.
For optimal speed, this should be a power of two. If <code>null</code>, uses <code>frame_length</code>.</p></td> </tr><tr><td>[options.power]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>If 1.0, returns the amplitude spectrogram. If 2.0, returns the power spectrogram. If <code>null</code>, returns complex numbers.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to pad the waveform so that frame <code>t</code> is centered around time <code>t * hop_length</code>. If <code>false</code>, frame
<code>t</code> will start at time <code>t * hop_length</code>.</p></td> </tr><tr><td>[options.pad_mode]</td><td><code>string</code></td><td><code>&quot;&quot;reflect&quot;&quot;</code></td><td><p>Padding mode used when <code>center</code> is <code>true</code>. Possible values are: <code>&quot;constant&quot;</code> (pad with zeros),
<code>&quot;edge&quot;</code> (pad with edge values), <code>&quot;reflect&quot;</code> (pads with mirrored values).</p></td> </tr><tr><td>[options.onesided]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>If <code>true</code>, only computes the positive frequencies and returns a spectrogram containing <code>fft_length // 2 + 1</code>
frequency bins. If <code>false</code>, also computes the negative frequencies and returns <code>fft_length</code> frequency bins.</p></td> </tr><tr><td>[options.preemphasis]</td><td><code>number</code></td><td><code></code></td><td><p>Coefficient for a low-pass filter that applies pre-emphasis before the DFT.</p></td> </tr><tr><td>[options.preemphasis_htk_flavor]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to apply the pre-emphasis filter in the HTK flavor.</p></td> </tr><tr><td>[options.mel_filters]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>The mel filter bank of shape <code>(num_freq_bins, num_mel_filters)</code>.
If supplied, applies this filter bank to create a mel spectrogram.</p></td> </tr><tr><td>[options.mel_floor]</td><td><code>number</code></td><td><code>1e-10</code></td><td><p>Minimum value of mel frequency banks.</p></td> </tr><tr><td>[options.log_mel]</td><td><code>string</code></td><td><code>null</code></td><td><p>How to convert the spectrogram to log scale. Possible options are:
<code>null</code> (don&#39;t convert), <code>&quot;log&quot;</code> (take the natural logarithm) <code>&quot;log10&quot;</code> (take the base-10 logarithm), <code>&quot;dB&quot;</code> (convert to decibels).
Can only be used when <code>power</code> is not <code>null</code>.</p></td> </tr><tr><td>[options.reference]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Sets the input spectrogram value that corresponds to 0 dB. For example, use <code>max(spectrogram)[0]</code> to set
the loudest part to 0 dB. Must be greater than zero.</p></td> </tr><tr><td>[options.min_value]</td><td><code>number</code></td><td><code>1e-10</code></td><td><p>The spectrogram will be clipped to this minimum value before conversion to decibels, to avoid taking <code>log(0)</code>.
For a power spectrogram, the default of <code>1e-10</code> corresponds to a minimum of -100 dB. For an amplitude spectrogram, the value <code>1e-5</code> corresponds to -100 dB.
Must be greater than zero.</p></td> </tr><tr><td>[options.db_range]</td><td><code>number</code></td><td><code></code></td><td><p>Sets the maximum dynamic range in decibels. For example, if <code>db_range = 80</code>, the difference between the
peak value and the smallest value will never be more than 80 dB. Must be greater than zero.</p></td> </tr><tr><td>[options.remove_dc_offset]</td><td><code>boolean</code></td><td><code></code></td><td><p>Subtract mean from waveform on each frame, applied before pre-emphasis. This should be set to <code>true</code> in
order to get the same results as <code>torchaudio.compliance.kaldi.fbank</code> when computing mel filters.</p></td> </tr><tr><td>[options.max_num_frames]</td><td><code>number</code></td><td><code></code></td><td><p>If provided, limits the number of frames to compute to this value.</p></td> </tr><tr><td>[options.min_num_frames]</td><td><code>number</code></td><td><code></code></td><td><p>If provided, ensures the number of frames to compute is at least this value.</p></td> </tr><tr><td>[options.do_pad]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>If <code>true</code>, pads the output spectrogram to have <code>max_num_frames</code> frames.</p></td> </tr><tr><td>[options.transpose]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>If <code>true</code>, the returned spectrogram will have shape <code>(num_frames, num_frequency_bins/num_mel_filters)</code>. If <code>false</code>, the returned spectrogram will have shape <code>(num_frequency_bins/num_mel_filters, num_frames)</code>.</p></td></tr></tbody>`,eo,to,oo,ye,lo,$e,io,Ae,ci="Returns an array containing the specified window.",ro,He,mi='<strong>Kind</strong>: static method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The window of shape <code>(window_length,)</code> or <code>(frame_length,)</code>.',ao,xe,pi=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>window_length</td><td><code>number</code></td><td></td><td><p>The length of the window in samples.</p></td> </tr><tr><td>name</td><td><code>string</code></td><td></td><td><p>The name of the window function.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Additional options.</p></td> </tr><tr><td>[options.periodic]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether the window is periodic or symmetric.</p></td> </tr><tr><td>[options.frame_length]</td><td><code>number</code></td><td><code></code></td><td><p>The length of the analysis frames in samples.
Provide a value for <code>frame_length</code> if the window is smaller than the frame length, so that it will be zero-padded.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to center the window inside the FFT buffer. Only used when <code>frame_length</code> is provided.</p></td></tr></tbody>`,no,uo,so,Le,co,Me,mo,Ce,fi=`Helper function to generate windows that are special cases of the generalized cosine window.
See <a href="https://www.mathworks.com/help/signal/ug/generalized-cosine-windows.html" rel="nofollow">https://www.mathworks.com/help/signal/ug/generalized-cosine-windows.html</a> for more information.`,po,qe,hi='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The generated window.',fo,Pe,_i="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>M</td><td><code>number</code></td><td><p>Number of points in the output window. If zero or less, an empty array is returned.</p></td> </tr><tr><td>a_0</td><td><code>number</code></td><td><p>Offset for the generalized cosine window.</p></td></tr></tbody>",ho,_o,bo,Re,wo,ze,go,ke,bi='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a>',vo,Fe,wi="<thead><tr><th>Param</th><th>Type</th><th>Default</th></tr></thead> <tbody><tr><td>freq</td><td><code>T</code></td><td></td> </tr><tr><td>[mel_scale]</td><td><code>string</code></td><td><code>&quot;htk&quot;</code></td></tr></tbody>",To,yo,$o,Be,Ao,Ee,Ho,We,gi='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a>',xo,De,vi="<thead><tr><th>Param</th><th>Type</th><th>Default</th></tr></thead> <tbody><tr><td>mels</td><td><code>T</code></td><td></td> </tr><tr><td>[mel_scale]</td><td><code>string</code></td><td><code>&quot;htk&quot;</code></td></tr></tbody>",Lo,Mo,Co,Ke,qo,Se,Po,je,Ti="Creates a triangular filter bank.",Ro,Ie,yi="Adapted from torchaudio and librosa.",zo,Ve,$i='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Array&lt;number&gt;&gt;</code> - of shape <code>(num_frequency_bins, num_mel_filters)</code>.',ko,Oe,Ai="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>fft_freqs</td><td><code>Float64Array</code></td><td><p>Discrete frequencies of the FFT bins in Hz, of shape <code>(num_frequency_bins,)</code>.</p></td> </tr><tr><td>filter_freqs</td><td><code>Float64Array</code></td><td><p>Center frequencies of the triangular filters to create, in Hz, of shape <code>(num_mel_filters,)</code>.</p></td></tr></tbody>",Fo,Bo,Eo,Ne,Wo,Ue,Do,Ge,Hi="Return evenly spaced numbers over a specified interval.",Ko,Je,xi='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>num</code> evenly spaced samples, calculated over the interval <code>[start, stop]</code>.',So,Qe,Li="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>start</td><td><code>number</code></td><td><p>The starting value of the sequence.</p></td> </tr><tr><td>end</td><td><code>number</code></td><td><p>The end value of the sequence.</p></td> </tr><tr><td>num</td><td><code>number</code></td><td><p>Number of samples to generate.</p></td></tr></tbody>",jo,Io,Vo,Xe,Oo,Ye,No,Ze,Mi='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>T</code> - The padded array.',Uo,et,Ci="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>array</td><td><code>T</code></td><td><p>The array to pad.</p></td> </tr><tr><td>left</td><td><code>number</code></td><td><p>The amount of padding to add to the left.</p></td> </tr><tr><td>right</td><td><code>number</code></td><td><p>The amount of padding to add to the right.</p></td></tr></tbody>",Go,Jo,Qo,tt,Xo,dt,Yo,ot,qi="Helper function to compute <code>amplitude_to_db</code> and <code>power_to_db</code>.",Zo,lt,Pi='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a>',el,it,Ri="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>spectrogram</td><td><code>T</code></td> </tr><tr><td>factor</td><td><code>number</code></td> </tr><tr><td>reference</td><td><code>number</code></td> </tr><tr><td>min_value</td><td><code>number</code></td> </tr><tr><td>db_range</td><td><code>number</code></td></tr></tbody>",tl,dl,ol,rt,ll,at,il,nt,zi=`Converts an amplitude spectrogram to the decibel scale. This computes <code>20 * log10(spectrogram / reference)</code>,
using basic logarithm properties for numerical stability. NOTE: Operates in-place.`,rl,ut,ki=`The motivation behind applying the log function on the (mel) spectrogram is that humans do not hear loudness on a
linear scale. Generally to double the perceived volume of a sound we need to put 8 times as much energy into it.
This means that large variations in energy may not sound all that different if the sound is loud to begin with.
This compression operation makes the (mel) spectrogram features match more closely what humans actually hear.`,al,st,Fi='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>T</code> - The modified spectrogram in decibels.',nl,ct,Bi=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>spectrogram</td><td><code>T</code></td><td></td><td><p>The input amplitude (mel) spectrogram.</p></td> </tr><tr><td>[reference]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Sets the input spectrogram value that corresponds to 0 dB.
For example, use <code>np.max(spectrogram)</code> to set the loudest part to 0 dB. Must be greater than zero.</p></td> </tr><tr><td>[min_value]</td><td><code>number</code></td><td><code>1e-5</code></td><td><p>The spectrogram will be clipped to this minimum value before conversion to decibels,
to avoid taking <code>log(0)</code>. The default of <code>1e-5</code> corresponds to a minimum of -100 dB. Must be greater than zero.</p></td> </tr><tr><td>[db_range]</td><td><code>number</code></td><td><code></code></td><td><p>Sets the maximum dynamic range in decibels. For example, if <code>db_range = 80</code>, the
difference between the peak value and the smallest value will never be more than 80 dB. Must be greater than zero.</p></td></tr></tbody>`,ul,sl,cl,mt,ml,pt,pl,ft,Ei=`Converts a power spectrogram to the decibel scale. This computes <code>10 * log10(spectrogram / reference)</code>,
using basic logarithm properties for numerical stability. NOTE: Operates in-place.`,fl,ht,Wi=`The motivation behind applying the log function on the (mel) spectrogram is that humans do not hear loudness on a
linear scale. Generally to double the perceived volume of a sound we need to put 8 times as much energy into it.
This means that large variations in energy may not sound all that different if the sound is loud to begin with.
This compression operation makes the (mel) spectrogram features match more closely what humans actually hear.`,hl,_t,Di="Based on the implementation of <code>librosa.power_to_db</code>.",_l,bt,Ki='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>T</code> - The modified spectrogram in decibels.',bl,wt,Si=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>spectrogram</td><td><code>T</code></td><td></td><td><p>The input power (mel) spectrogram. Note that a power spectrogram has the amplitudes squared!</p></td> </tr><tr><td>[reference]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Sets the input spectrogram value that corresponds to 0 dB.
For example, use <code>np.max(spectrogram)</code> to set the loudest part to 0 dB. Must be greater than zero.</p></td> </tr><tr><td>[min_value]</td><td><code>number</code></td><td><code>1e-10</code></td><td><p>The spectrogram will be clipped to this minimum value before conversion to decibels,
to avoid taking <code>log(0)</code>. The default of <code>1e-10</code> corresponds to a minimum of -100 dB. Must be greater than zero.</p></td> </tr><tr><td>[db_range]</td><td><code>number</code></td><td><code></code></td><td><p>Sets the maximum dynamic range in decibels. For example, if <code>db_range = 80</code>, the
difference between the peak value and the smallest value will never be more than 80 dB. Must be greater than zero.</p></td></tr></tbody>`,wl,gl,vl,gt,Tl,vt,yl,Tt,ji=`Encode audio data to a WAV file.
WAV file specs : <a href="https://en.wikipedia.org/wiki/WAV#WAV_File_header" rel="nofollow">https://en.wikipedia.org/wiki/WAV#WAV_File_header</a>`,$l,yt,Ii='Adapted from <a href="https://www.npmjs.com/package/audiobuffer-to-wav" rel="nofollow">https://www.npmjs.com/package/audiobuffer-to-wav</a>',Al,$t,Vi='<strong>Kind</strong>: inner method of <a href="#module_utils/audio"><code>utils/audio</code></a><br/> <strong>Returns</strong>: <code>ArrayBuffer</code> - The WAV audio buffer.',Hl,At,Oi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>samples</td><td><code>Float32Array</code></td><td><p>The audio samples.</p></td> </tr><tr><td>rate</td><td><code>number</code></td><td><p>The sample rate.</p></td></tr></tbody>",xl,Ll,Ml,Ht,Cl,Lt,ql;return v=new b({props:{title:"utils/audio",local:"utilsaudio",headingTag:"h1"}}),H=new b({props:{title:"utils/audio.RawAudio",local:"utilsaudiorawaudio",headingTag:"h2"}}),C=new b({props:{title:"new RawAudio(audio, sampling_rate)",local:"new-rawaudioaudio-samplingrate",headingTag:"h3"}}),z=new b({props:{title:"rawAudio.toWav() ⇒ <code> ArrayBuffer </code>",local:"rawaudiotowav--code-arraybuffer-code",headingTag:"h3"}}),E=new b({props:{title:"rawAudio.toBlob() ⇒ <code> Blob </code>",local:"rawaudiotoblob--code-blob-code",headingTag:"h3"}}),S=new b({props:{title:"rawAudio.save(path)",local:"rawaudiosavepath",headingTag:"h3"}}),N=new b({props:{title:"utils/audio.read_audio(url, sampling_rate) ⇒ <code> Promise. < Float32Array > </code>",local:"utilsaudioreadaudiourl-samplingrate--code-promise--float32array--code",headingTag:"h2"}}),X=new b({props:{title:"read_audio~audio : <code> Float32Array </code>",local:"readaudioaudio--code-float32array-code",headingTag:"h3"}}),ee=new b({props:{title:"utils/audio.hanning(M) ⇒ <code> Float64Array </code>",local:"utilsaudiohanningm--code-float64array-code",headingTag:"h2"}}),ie=new b({props:{title:"utils/audio.hamming(M) ⇒ <code> Float64Array </code>",local:"utilsaudiohammingm--code-float64array-code",headingTag:"h2"}}),se=new b({props:{title:"utils/audio.mel_filter_bank(num_frequency_bins, num_mel_filters, min_frequency, max_frequency, sampling_rate, [norm], [mel_scale], [triangularize_in_mel_space]) ⇒ <code> Array. < Array < number > > </code>",local:"utilsaudiomelfilterbanknumfrequencybins-nummelfilters-minfrequency-maxfrequency-samplingrate-norm-melscale-triangularizeinmelspace--code-array--array--number---code",headingTag:"h2"}}),he=new b({props:{title:"utils/audio.spectrogram(waveform, window, frame_length, hop_length, options) ⇒ <code> Promise. < Tensor > </code>",local:"utilsaudiospectrogramwaveform-window-framelength-hoplength-options--code-promise--tensor--code",headingTag:"h2"}}),$e=new b({props:{title:"utils/audio.window_function(window_length, name, options) ⇒ <code> Float64Array </code>",local:"utilsaudiowindowfunctionwindowlength-name-options--code-float64array-code",headingTag:"h2"}}),Me=new b({props:{title:"utils/audio~generalized_cosine_window(M, a_0) ⇒ <code> Float64Array </code>",local:"utilsaudiogeneralizedcosinewindowm-a0--code-float64array-code",headingTag:"h2"}}),ze=new b({props:{title:"utils/audio~hertz_to_mel(freq, [mel_scale]) ⇒ <code> T </code>",local:"utilsaudiohertztomelfreq-melscale--code-t-code",headingTag:"h2"}}),Ee=new b({props:{title:"utils/audio~mel_to_hertz(mels, [mel_scale]) ⇒ <code> T </code>",local:"utilsaudiomeltohertzmels-melscale--code-t-code",headingTag:"h2"}}),Se=new b({props:{title:"utils/audio~_create_triangular_filter_bank(fft_freqs, filter_freqs) ⇒ <code> Array. < Array < number > > </code>",local:"utilsaudiocreatetriangularfilterbankfftfreqs-filterfreqs--code-array--array--number---code",headingTag:"h2"}}),Ue=new b({props:{title:"utils/audio~linspace(start, end, num) ⇒",local:"utilsaudiolinspacestart-end-num-",headingTag:"h2"}}),Ye=new b({props:{title:"utils/audio~padReflect(array, left, right) ⇒ <code> T </code>",local:"utilsaudiopadreflectarray-left-right--code-t-code",headingTag:"h2"}}),dt=new b({props:{title:"utils/audio~_db_conversion_helper(spectrogram, factor, reference, min_value, db_range) ⇒ <code> T </code>",local:"utilsaudiodbconversionhelperspectrogram-factor-reference-minvalue-dbrange--code-t-code",headingTag:"h2"}}),at=new b({props:{title:"utils/audio~amplitude_to_db(spectrogram, [reference], [min_value], [db_range]) ⇒ <code> T </code>",local:"utilsaudioamplitudetodbspectrogram-reference-minvalue-dbrange--code-t-code",headingTag:"h2"}}),pt=new b({props:{title:"utils/audio~power_to_db(spectrogram, [reference], [min_value], [db_range]) ⇒ <code> T </code>",local:"utilsaudiopowertodbspectrogram-reference-minvalue-dbrange--code-t-code",headingTag:"h2"}}),vt=new b({props:{title:"utils/audio~encodeWAV(samples, rate) ⇒ <code> ArrayBuffer </code>",local:"utilsaudioencodewavsamples-rate--code-arraybuffer-code",headingTag:"h2"}}),Ht=new Zi({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/audio.md"}}),{c(){w=r("meta"),Mt=l(),xt=r("p"),Ct=l(),g=r("a"),qt=l(),c(v.$$.fragment),Pt=l(),T=r("p"),T.textContent=Rl,Rt=l(),y=r("p"),y.textContent=zl,zt=l(),$=r("ul"),$.innerHTML=kl,kt=l(),Ft=r("hr"),Bt=l(),A=r("a"),Et=l(),c(H.$$.fragment),Wt=l(),x=r("p"),x.innerHTML=Fl,Dt=l(),L=r("ul"),L.innerHTML=Bl,Kt=l(),St=r("hr"),jt=l(),M=r("a"),It=l(),c(C.$$.fragment),Vt=l(),q=r("p"),q.innerHTML=El,Ot=l(),P=r("table"),P.innerHTML=Wl,Nt=l(),Ut=r("hr"),Gt=l(),R=r("a"),Jt=l(),c(z.$$.fragment),Qt=l(),k=r("p"),k.textContent=Dl,Xt=l(),F=r("p"),F.innerHTML=Kl,Yt=l(),Zt=r("hr"),ed=l(),B=r("a"),td=l(),c(E.$$.fragment),dd=l(),W=r("p"),W.textContent=Sl,od=l(),D=r("p"),D.innerHTML=jl,ld=l(),id=r("hr"),rd=l(),K=r("a"),ad=l(),c(S.$$.fragment),nd=l(),j=r("p"),j.textContent=Il,ud=l(),I=r("p"),I.innerHTML=Vl,sd=l(),V=r("table"),V.innerHTML=Ol,cd=l(),md=r("hr"),pd=l(),O=r("a"),fd=l(),c(N.$$.fragment),hd=l(),U=r("p"),U.textContent=Nl,_d=l(),G=r("p"),G.innerHTML=Ul,bd=l(),J=r("table"),J.innerHTML=Gl,wd=l(),gd=r("hr"),vd=l(),Q=r("a"),Td=l(),c(X.$$.fragment),yd=l(),Y=r("p"),Y.innerHTML=Jl,$d=l(),Ad=r("hr"),Hd=l(),Z=r("a"),xd=l(),c(ee.$$.fragment),Ld=l(),te=r("p"),te.innerHTML=Ql,Md=l(),de=r("p"),de.innerHTML=Xl,Cd=l(),oe=r("table"),oe.innerHTML=Yl,qd=l(),Pd=r("hr"),Rd=l(),le=r("a"),zd=l(),c(ie.$$.fragment),kd=l(),re=r("p"),re.innerHTML=Zl,Fd=l(),ae=r("p"),ae.innerHTML=ei,Bd=l(),ne=r("table"),ne.innerHTML=ti,Ed=l(),Wd=r("hr"),Dd=l(),ue=r("a"),Kd=l(),c(se.$$.fragment),Sd=l(),ce=r("p"),ce.innerHTML=di,jd=l(),me=r("p"),me.innerHTML=oi,Id=l(),pe=r("table"),pe.innerHTML=li,Vd=l(),Od=r("hr"),Nd=l(),fe=r("a"),Ud=l(),c(he.$$.fragment),Gd=l(),_e=r("p"),_e.textContent=ii,Jd=l(),be=r("p"),be.textContent=ri,Qd=l(),we=r("ul"),we.innerHTML=ai,Xd=l(),ge=r("p"),ge.innerHTML=ni,Yd=l(),ve=r("p"),ve.innerHTML=ui,Zd=l(),Te=r("table"),Te.innerHTML=si,eo=l(),to=r("hr"),oo=l(),ye=r("a"),lo=l(),c($e.$$.fragment),io=l(),Ae=r("p"),Ae.textContent=ci,ro=l(),He=r("p"),He.innerHTML=mi,ao=l(),xe=r("table"),xe.innerHTML=pi,no=l(),uo=r("hr"),so=l(),Le=r("a"),co=l(),c(Me.$$.fragment),mo=l(),Ce=r("p"),Ce.innerHTML=fi,po=l(),qe=r("p"),qe.innerHTML=hi,fo=l(),Pe=r("table"),Pe.innerHTML=_i,ho=l(),_o=r("hr"),bo=l(),Re=r("a"),wo=l(),c(ze.$$.fragment),go=l(),ke=r("p"),ke.innerHTML=bi,vo=l(),Fe=r("table"),Fe.innerHTML=wi,To=l(),yo=r("hr"),$o=l(),Be=r("a"),Ao=l(),c(Ee.$$.fragment),Ho=l(),We=r("p"),We.innerHTML=gi,xo=l(),De=r("table"),De.innerHTML=vi,Lo=l(),Mo=r("hr"),Co=l(),Ke=r("a"),qo=l(),c(Se.$$.fragment),Po=l(),je=r("p"),je.textContent=Ti,Ro=l(),Ie=r("p"),Ie.textContent=yi,zo=l(),Ve=r("p"),Ve.innerHTML=$i,ko=l(),Oe=r("table"),Oe.innerHTML=Ai,Fo=l(),Bo=r("hr"),Eo=l(),Ne=r("a"),Wo=l(),c(Ue.$$.fragment),Do=l(),Ge=r("p"),Ge.textContent=Hi,Ko=l(),Je=r("p"),Je.innerHTML=xi,So=l(),Qe=r("table"),Qe.innerHTML=Li,jo=l(),Io=r("hr"),Vo=l(),Xe=r("a"),Oo=l(),c(Ye.$$.fragment),No=l(),Ze=r("p"),Ze.innerHTML=Mi,Uo=l(),et=r("table"),et.innerHTML=Ci,Go=l(),Jo=r("hr"),Qo=l(),tt=r("a"),Xo=l(),c(dt.$$.fragment),Yo=l(),ot=r("p"),ot.innerHTML=qi,Zo=l(),lt=r("p"),lt.innerHTML=Pi,el=l(),it=r("table"),it.innerHTML=Ri,tl=l(),dl=r("hr"),ol=l(),rt=r("a"),ll=l(),c(at.$$.fragment),il=l(),nt=r("p"),nt.innerHTML=zi,rl=l(),ut=r("p"),ut.textContent=ki,al=l(),st=r("p"),st.innerHTML=Fi,nl=l(),ct=r("table"),ct.innerHTML=Bi,ul=l(),sl=r("hr"),cl=l(),mt=r("a"),ml=l(),c(pt.$$.fragment),pl=l(),ft=r("p"),ft.innerHTML=Ei,fl=l(),ht=r("p"),ht.textContent=Wi,hl=l(),_t=r("p"),_t.innerHTML=Di,_l=l(),bt=r("p"),bt.innerHTML=Ki,bl=l(),wt=r("table"),wt.innerHTML=Si,wl=l(),gl=r("hr"),vl=l(),gt=r("a"),Tl=l(),c(vt.$$.fragment),yl=l(),Tt=r("p"),Tt.innerHTML=ji,$l=l(),yt=r("p"),yt.innerHTML=Ii,Al=l(),$t=r("p"),$t.innerHTML=Vi,Hl=l(),At=r("table"),At.innerHTML=Oi,xl=l(),Ll=r("hr"),Ml=l(),c(Ht.$$.fragment),Cl=l(),Lt=r("p"),this.h()},l(e){const t=Xi("svelte-u9bgzb",document.head);w=a(t,"META",{name:!0,content:!0}),t.forEach(d),Mt=i(e),xt=a(e,"P",{}),s(xt).forEach(d),Ct=i(e),g=a(e,"A",{id:!0,class:!0}),s(g).forEach(d),qt=i(e),m(v.$$.fragment,e),Pt=i(e),T=a(e,"P",{"data-svelte-h":!0}),n(T)!=="svelte-12buzkq"&&(T.textContent=Rl),Rt=i(e),y=a(e,"P",{"data-svelte-h":!0}),n(y)!=="svelte-il3kl8"&&(y.textContent=zl),zt=i(e),$=a(e,"UL",{"data-svelte-h":!0}),n($)!=="svelte-u4g96s"&&($.innerHTML=kl),kt=i(e),Ft=a(e,"HR",{}),Bt=i(e),A=a(e,"A",{id:!0,class:!0}),s(A).forEach(d),Et=i(e),m(H.$$.fragment,e),Wt=i(e),x=a(e,"P",{"data-svelte-h":!0}),n(x)!=="svelte-1s2dpoa"&&(x.innerHTML=Fl),Dt=i(e),L=a(e,"UL",{"data-svelte-h":!0}),n(L)!=="svelte-wntzjv"&&(L.innerHTML=Bl),Kt=i(e),St=a(e,"HR",{}),jt=i(e),M=a(e,"A",{id:!0,class:!0}),s(M).forEach(d),It=i(e),m(C.$$.fragment,e),Vt=i(e),q=a(e,"P",{"data-svelte-h":!0}),n(q)!=="svelte-1a89sw5"&&(q.innerHTML=El),Ot=i(e),P=a(e,"TABLE",{"data-svelte-h":!0}),n(P)!=="svelte-e3w4n7"&&(P.innerHTML=Wl),Nt=i(e),Ut=a(e,"HR",{}),Gt=i(e),R=a(e,"A",{id:!0,class:!0}),s(R).forEach(d),Jt=i(e),m(z.$$.fragment,e),Qt=i(e),k=a(e,"P",{"data-svelte-h":!0}),n(k)!=="svelte-1r014ys"&&(k.textContent=Dl),Xt=i(e),F=a(e,"P",{"data-svelte-h":!0}),n(F)!=="svelte-r0dq8e"&&(F.innerHTML=Kl),Yt=i(e),Zt=a(e,"HR",{}),ed=i(e),B=a(e,"A",{id:!0,class:!0}),s(B).forEach(d),td=i(e),m(E.$$.fragment,e),dd=i(e),W=a(e,"P",{"data-svelte-h":!0}),n(W)!=="svelte-m879bd"&&(W.textContent=Sl),od=i(e),D=a(e,"P",{"data-svelte-h":!0}),n(D)!=="svelte-ugrjp2"&&(D.innerHTML=jl),ld=i(e),id=a(e,"HR",{}),rd=i(e),K=a(e,"A",{id:!0,class:!0}),s(K).forEach(d),ad=i(e),m(S.$$.fragment,e),nd=i(e),j=a(e,"P",{"data-svelte-h":!0}),n(j)!=="svelte-10oc88s"&&(j.textContent=Il),ud=i(e),I=a(e,"P",{"data-svelte-h":!0}),n(I)!=="svelte-ugrjp2"&&(I.innerHTML=Vl),sd=i(e),V=a(e,"TABLE",{"data-svelte-h":!0}),n(V)!=="svelte-f03x1m"&&(V.innerHTML=Ol),cd=i(e),md=a(e,"HR",{}),pd=i(e),O=a(e,"A",{id:!0,class:!0}),s(O).forEach(d),fd=i(e),m(N.$$.fragment,e),hd=i(e),U=a(e,"P",{"data-svelte-h":!0}),n(U)!=="svelte-wq5n0b"&&(U.textContent=Nl),_d=i(e),G=a(e,"P",{"data-svelte-h":!0}),n(G)!=="svelte-wzwr9x"&&(G.innerHTML=Ul),bd=i(e),J=a(e,"TABLE",{"data-svelte-h":!0}),n(J)!=="svelte-1u23bjg"&&(J.innerHTML=Gl),wd=i(e),gd=a(e,"HR",{}),vd=i(e),Q=a(e,"A",{id:!0,class:!0}),s(Q).forEach(d),Td=i(e),m(X.$$.fragment,e),yd=i(e),Y=a(e,"P",{"data-svelte-h":!0}),n(Y)!=="svelte-kcz1h5"&&(Y.innerHTML=Jl),$d=i(e),Ad=a(e,"HR",{}),Hd=i(e),Z=a(e,"A",{id:!0,class:!0}),s(Z).forEach(d),xd=i(e),m(ee.$$.fragment,e),Ld=i(e),te=a(e,"P",{"data-svelte-h":!0}),n(te)!=="svelte-13ns2vg"&&(te.innerHTML=Ql),Md=i(e),de=a(e,"P",{"data-svelte-h":!0}),n(de)!=="svelte-187ugov"&&(de.innerHTML=Xl),Cd=i(e),oe=a(e,"TABLE",{"data-svelte-h":!0}),n(oe)!=="svelte-1x4zay3"&&(oe.innerHTML=Yl),qd=i(e),Pd=a(e,"HR",{}),Rd=i(e),le=a(e,"A",{id:!0,class:!0}),s(le).forEach(d),zd=i(e),m(ie.$$.fragment,e),kd=i(e),re=a(e,"P",{"data-svelte-h":!0}),n(re)!=="svelte-8gymva"&&(re.innerHTML=Zl),Fd=i(e),ae=a(e,"P",{"data-svelte-h":!0}),n(ae)!=="svelte-1dyre01"&&(ae.innerHTML=ei),Bd=i(e),ne=a(e,"TABLE",{"data-svelte-h":!0}),n(ne)!=="svelte-io80jx"&&(ne.innerHTML=ti),Ed=i(e),Wd=a(e,"HR",{}),Dd=i(e),ue=a(e,"A",{id:!0,class:!0}),s(ue).forEach(d),Kd=i(e),m(se.$$.fragment,e),Sd=i(e),ce=a(e,"P",{"data-svelte-h":!0}),n(ce)!=="svelte-ke4v6b"&&(ce.innerHTML=di),jd=i(e),me=a(e,"P",{"data-svelte-h":!0}),n(me)!=="svelte-rtofow"&&(me.innerHTML=oi),Id=i(e),pe=a(e,"TABLE",{"data-svelte-h":!0}),n(pe)!=="svelte-3aon15"&&(pe.innerHTML=li),Vd=i(e),Od=a(e,"HR",{}),Nd=i(e),fe=a(e,"A",{id:!0,class:!0}),s(fe).forEach(d),Ud=i(e),m(he.$$.fragment,e),Gd=i(e),_e=a(e,"P",{"data-svelte-h":!0}),n(_e)!=="svelte-10mwufd"&&(_e.textContent=ii),Jd=i(e),be=a(e,"P",{"data-svelte-h":!0}),n(be)!=="svelte-zfp2ya"&&(be.textContent=ri),Qd=i(e),we=a(e,"UL",{"data-svelte-h":!0}),n(we)!=="svelte-14mziv8"&&(we.innerHTML=ai),Xd=i(e),ge=a(e,"P",{"data-svelte-h":!0}),n(ge)!=="svelte-iwx6w9"&&(ge.innerHTML=ni),Yd=i(e),ve=a(e,"P",{"data-svelte-h":!0}),n(ve)!=="svelte-1shoq4k"&&(ve.innerHTML=ui),Zd=i(e),Te=a(e,"TABLE",{"data-svelte-h":!0}),n(Te)!=="svelte-1nw4rg7"&&(Te.innerHTML=si),eo=i(e),to=a(e,"HR",{}),oo=i(e),ye=a(e,"A",{id:!0,class:!0}),s(ye).forEach(d),lo=i(e),m($e.$$.fragment,e),io=i(e),Ae=a(e,"P",{"data-svelte-h":!0}),n(Ae)!=="svelte-13l1rbm"&&(Ae.textContent=ci),ro=i(e),He=a(e,"P",{"data-svelte-h":!0}),n(He)!=="svelte-9ixqdv"&&(He.innerHTML=mi),ao=i(e),xe=a(e,"TABLE",{"data-svelte-h":!0}),n(xe)!=="svelte-h693em"&&(xe.innerHTML=pi),no=i(e),uo=a(e,"HR",{}),so=i(e),Le=a(e,"A",{id:!0,class:!0}),s(Le).forEach(d),co=i(e),m(Me.$$.fragment,e),mo=i(e),Ce=a(e,"P",{"data-svelte-h":!0}),n(Ce)!=="svelte-1lyeqxj"&&(Ce.innerHTML=fi),po=i(e),qe=a(e,"P",{"data-svelte-h":!0}),n(qe)!=="svelte-xu9700"&&(qe.innerHTML=hi),fo=i(e),Pe=a(e,"TABLE",{"data-svelte-h":!0}),n(Pe)!=="svelte-11w0boh"&&(Pe.innerHTML=_i),ho=i(e),_o=a(e,"HR",{}),bo=i(e),Re=a(e,"A",{id:!0,class:!0}),s(Re).forEach(d),wo=i(e),m(ze.$$.fragment,e),go=i(e),ke=a(e,"P",{"data-svelte-h":!0}),n(ke)!=="svelte-5cebk5"&&(ke.innerHTML=bi),vo=i(e),Fe=a(e,"TABLE",{"data-svelte-h":!0}),n(Fe)!=="svelte-1w6ehfm"&&(Fe.innerHTML=wi),To=i(e),yo=a(e,"HR",{}),$o=i(e),Be=a(e,"A",{id:!0,class:!0}),s(Be).forEach(d),Ao=i(e),m(Ee.$$.fragment,e),Ho=i(e),We=a(e,"P",{"data-svelte-h":!0}),n(We)!=="svelte-5cebk5"&&(We.innerHTML=gi),xo=i(e),De=a(e,"TABLE",{"data-svelte-h":!0}),n(De)!=="svelte-io7ocd"&&(De.innerHTML=vi),Lo=i(e),Mo=a(e,"HR",{}),Co=i(e),Ke=a(e,"A",{id:!0,class:!0}),s(Ke).forEach(d),qo=i(e),m(Se.$$.fragment,e),Po=i(e),je=a(e,"P",{"data-svelte-h":!0}),n(je)!=="svelte-uj0il7"&&(je.textContent=Ti),Ro=i(e),Ie=a(e,"P",{"data-svelte-h":!0}),n(Ie)!=="svelte-srmfwi"&&(Ie.textContent=yi),zo=i(e),Ve=a(e,"P",{"data-svelte-h":!0}),n(Ve)!=="svelte-aln42z"&&(Ve.innerHTML=$i),ko=i(e),Oe=a(e,"TABLE",{"data-svelte-h":!0}),n(Oe)!=="svelte-2x9dyx"&&(Oe.innerHTML=Ai),Fo=i(e),Bo=a(e,"HR",{}),Eo=i(e),Ne=a(e,"A",{id:!0,class:!0}),s(Ne).forEach(d),Wo=i(e),m(Ue.$$.fragment,e),Do=i(e),Ge=a(e,"P",{"data-svelte-h":!0}),n(Ge)!=="svelte-osjtvn"&&(Ge.textContent=Hi),Ko=i(e),Je=a(e,"P",{"data-svelte-h":!0}),n(Je)!=="svelte-bfmjcl"&&(Je.innerHTML=xi),So=i(e),Qe=a(e,"TABLE",{"data-svelte-h":!0}),n(Qe)!=="svelte-c7ztlp"&&(Qe.innerHTML=Li),jo=i(e),Io=a(e,"HR",{}),Vo=i(e),Xe=a(e,"A",{id:!0,class:!0}),s(Xe).forEach(d),Oo=i(e),m(Ye.$$.fragment,e),No=i(e),Ze=a(e,"P",{"data-svelte-h":!0}),n(Ze)!=="svelte-115nnpl"&&(Ze.innerHTML=Mi),Uo=i(e),et=a(e,"TABLE",{"data-svelte-h":!0}),n(et)!=="svelte-6p81mk"&&(et.innerHTML=Ci),Go=i(e),Jo=a(e,"HR",{}),Qo=i(e),tt=a(e,"A",{id:!0,class:!0}),s(tt).forEach(d),Xo=i(e),m(dt.$$.fragment,e),Yo=i(e),ot=a(e,"P",{"data-svelte-h":!0}),n(ot)!=="svelte-9t3wul"&&(ot.innerHTML=qi),Zo=i(e),lt=a(e,"P",{"data-svelte-h":!0}),n(lt)!=="svelte-5cebk5"&&(lt.innerHTML=Pi),el=i(e),it=a(e,"TABLE",{"data-svelte-h":!0}),n(it)!=="svelte-heeupf"&&(it.innerHTML=Ri),tl=i(e),dl=a(e,"HR",{}),ol=i(e),rt=a(e,"A",{id:!0,class:!0}),s(rt).forEach(d),ll=i(e),m(at.$$.fragment,e),il=i(e),nt=a(e,"P",{"data-svelte-h":!0}),n(nt)!=="svelte-93lmwr"&&(nt.innerHTML=zi),rl=i(e),ut=a(e,"P",{"data-svelte-h":!0}),n(ut)!=="svelte-12zo44d"&&(ut.textContent=ki),al=i(e),st=a(e,"P",{"data-svelte-h":!0}),n(st)!=="svelte-1d363v6"&&(st.innerHTML=Fi),nl=i(e),ct=a(e,"TABLE",{"data-svelte-h":!0}),n(ct)!=="svelte-1wpe278"&&(ct.innerHTML=Bi),ul=i(e),sl=a(e,"HR",{}),cl=i(e),mt=a(e,"A",{id:!0,class:!0}),s(mt).forEach(d),ml=i(e),m(pt.$$.fragment,e),pl=i(e),ft=a(e,"P",{"data-svelte-h":!0}),n(ft)!=="svelte-1dxatci"&&(ft.innerHTML=Ei),fl=i(e),ht=a(e,"P",{"data-svelte-h":!0}),n(ht)!=="svelte-12zo44d"&&(ht.textContent=Wi),hl=i(e),_t=a(e,"P",{"data-svelte-h":!0}),n(_t)!=="svelte-1bxqqp"&&(_t.innerHTML=Di),_l=i(e),bt=a(e,"P",{"data-svelte-h":!0}),n(bt)!=="svelte-1d363v6"&&(bt.innerHTML=Ki),bl=i(e),wt=a(e,"TABLE",{"data-svelte-h":!0}),n(wt)!=="svelte-h9b3kb"&&(wt.innerHTML=Si),wl=i(e),gl=a(e,"HR",{}),vl=i(e),gt=a(e,"A",{id:!0,class:!0}),s(gt).forEach(d),Tl=i(e),m(vt.$$.fragment,e),yl=i(e),Tt=a(e,"P",{"data-svelte-h":!0}),n(Tt)!=="svelte-1o808r9"&&(Tt.innerHTML=ji),$l=i(e),yt=a(e,"P",{"data-svelte-h":!0}),n(yt)!=="svelte-1dznmtc"&&(yt.innerHTML=Ii),Al=i(e),$t=a(e,"P",{"data-svelte-h":!0}),n($t)!=="svelte-1138la7"&&($t.innerHTML=Vi),Hl=i(e),At=a(e,"TABLE",{"data-svelte-h":!0}),n(At)!=="svelte-eymvyw"&&(At.innerHTML=Oi),xl=i(e),Ll=a(e,"HR",{}),Ml=i(e),m(Ht.$$.fragment,e),Cl=i(e),Lt=a(e,"P",{}),s(Lt).forEach(d),this.h()},h(){u(w,"name","hf:doc:metadata"),u(w,"content",tr),u(g,"id","module_utils/audio"),u(g,"class","group"),u(A,"id","module_utils/audio.RawAudio"),u(A,"class","group"),u(M,"id","new_module_utils/audio.RawAudio_new"),u(M,"class","group"),u(R,"id","module_utils/audio.RawAudio+toWav"),u(R,"class","group"),u(B,"id","module_utils/audio.RawAudio+toBlob"),u(B,"class","group"),u(K,"id","module_utils/audio.RawAudio+save"),u(K,"class","group"),u(O,"id","module_utils/audio.read_audio"),u(O,"class","group"),u(Q,"id","module_utils/audio.read_audio..audio"),u(Q,"class","group"),u(Z,"id","module_utils/audio.hanning"),u(Z,"class","group"),u(le,"id","module_utils/audio.hamming"),u(le,"class","group"),u(ue,"id","module_utils/audio.mel_filter_bank"),u(ue,"class","group"),u(fe,"id","module_utils/audio.spectrogram"),u(fe,"class","group"),u(ye,"id","module_utils/audio.window_function"),u(ye,"class","group"),u(Le,"id","module_utils/audio..generalized_cosine_window"),u(Le,"class","group"),u(Re,"id","module_utils/audio..hertz_to_mel"),u(Re,"class","group"),u(Be,"id","module_utils/audio..mel_to_hertz"),u(Be,"class","group"),u(Ke,"id","module_utils/audio.._create_triangular_filter_bank"),u(Ke,"class","group"),u(Ne,"id","module_utils/audio..linspace"),u(Ne,"class","group"),u(Xe,"id","module_utils/audio..padReflect"),u(Xe,"class","group"),u(tt,"id","module_utils/audio.._db_conversion_helper"),u(tt,"class","group"),u(rt,"id","module_utils/audio..amplitude_to_db"),u(rt,"class","group"),u(mt,"id","module_utils/audio..power_to_db"),u(mt,"class","group"),u(gt,"id","module_utils/audio..encodeWAV"),u(gt,"class","group")},m(e,t){Yi(document.head,w),o(e,Mt,t),o(e,xt,t),o(e,Ct,t),o(e,g,t),o(e,qt,t),p(v,e,t),o(e,Pt,t),o(e,T,t),o(e,Rt,t),o(e,y,t),o(e,zt,t),o(e,$,t),o(e,kt,t),o(e,Ft,t),o(e,Bt,t),o(e,A,t),o(e,Et,t),p(H,e,t),o(e,Wt,t),o(e,x,t),o(e,Dt,t),o(e,L,t),o(e,Kt,t),o(e,St,t),o(e,jt,t),o(e,M,t),o(e,It,t),p(C,e,t),o(e,Vt,t),o(e,q,t),o(e,Ot,t),o(e,P,t),o(e,Nt,t),o(e,Ut,t),o(e,Gt,t),o(e,R,t),o(e,Jt,t),p(z,e,t),o(e,Qt,t),o(e,k,t),o(e,Xt,t),o(e,F,t),o(e,Yt,t),o(e,Zt,t),o(e,ed,t),o(e,B,t),o(e,td,t),p(E,e,t),o(e,dd,t),o(e,W,t),o(e,od,t),o(e,D,t),o(e,ld,t),o(e,id,t),o(e,rd,t),o(e,K,t),o(e,ad,t),p(S,e,t),o(e,nd,t),o(e,j,t),o(e,ud,t),o(e,I,t),o(e,sd,t),o(e,V,t),o(e,cd,t),o(e,md,t),o(e,pd,t),o(e,O,t),o(e,fd,t),p(N,e,t),o(e,hd,t),o(e,U,t),o(e,_d,t),o(e,G,t),o(e,bd,t),o(e,J,t),o(e,wd,t),o(e,gd,t),o(e,vd,t),o(e,Q,t),o(e,Td,t),p(X,e,t),o(e,yd,t),o(e,Y,t),o(e,$d,t),o(e,Ad,t),o(e,Hd,t),o(e,Z,t),o(e,xd,t),p(ee,e,t),o(e,Ld,t),o(e,te,t),o(e,Md,t),o(e,de,t),o(e,Cd,t),o(e,oe,t),o(e,qd,t),o(e,Pd,t),o(e,Rd,t),o(e,le,t),o(e,zd,t),p(ie,e,t),o(e,kd,t),o(e,re,t),o(e,Fd,t),o(e,ae,t),o(e,Bd,t),o(e,ne,t),o(e,Ed,t),o(e,Wd,t),o(e,Dd,t),o(e,ue,t),o(e,Kd,t),p(se,e,t),o(e,Sd,t),o(e,ce,t),o(e,jd,t),o(e,me,t),o(e,Id,t),o(e,pe,t),o(e,Vd,t),o(e,Od,t),o(e,Nd,t),o(e,fe,t),o(e,Ud,t),p(he,e,t),o(e,Gd,t),o(e,_e,t),o(e,Jd,t),o(e,be,t),o(e,Qd,t),o(e,we,t),o(e,Xd,t),o(e,ge,t),o(e,Yd,t),o(e,ve,t),o(e,Zd,t),o(e,Te,t),o(e,eo,t),o(e,to,t),o(e,oo,t),o(e,ye,t),o(e,lo,t),p($e,e,t),o(e,io,t),o(e,Ae,t),o(e,ro,t),o(e,He,t),o(e,ao,t),o(e,xe,t),o(e,no,t),o(e,uo,t),o(e,so,t),o(e,Le,t),o(e,co,t),p(Me,e,t),o(e,mo,t),o(e,Ce,t),o(e,po,t),o(e,qe,t),o(e,fo,t),o(e,Pe,t),o(e,ho,t),o(e,_o,t),o(e,bo,t),o(e,Re,t),o(e,wo,t),p(ze,e,t),o(e,go,t),o(e,ke,t),o(e,vo,t),o(e,Fe,t),o(e,To,t),o(e,yo,t),o(e,$o,t),o(e,Be,t),o(e,Ao,t),p(Ee,e,t),o(e,Ho,t),o(e,We,t),o(e,xo,t),o(e,De,t),o(e,Lo,t),o(e,Mo,t),o(e,Co,t),o(e,Ke,t),o(e,qo,t),p(Se,e,t),o(e,Po,t),o(e,je,t),o(e,Ro,t),o(e,Ie,t),o(e,zo,t),o(e,Ve,t),o(e,ko,t),o(e,Oe,t),o(e,Fo,t),o(e,Bo,t),o(e,Eo,t),o(e,Ne,t),o(e,Wo,t),p(Ue,e,t),o(e,Do,t),o(e,Ge,t),o(e,Ko,t),o(e,Je,t),o(e,So,t),o(e,Qe,t),o(e,jo,t),o(e,Io,t),o(e,Vo,t),o(e,Xe,t),o(e,Oo,t),p(Ye,e,t),o(e,No,t),o(e,Ze,t),o(e,Uo,t),o(e,et,t),o(e,Go,t),o(e,Jo,t),o(e,Qo,t),o(e,tt,t),o(e,Xo,t),p(dt,e,t),o(e,Yo,t),o(e,ot,t),o(e,Zo,t),o(e,lt,t),o(e,el,t),o(e,it,t),o(e,tl,t),o(e,dl,t),o(e,ol,t),o(e,rt,t),o(e,ll,t),p(at,e,t),o(e,il,t),o(e,nt,t),o(e,rl,t),o(e,ut,t),o(e,al,t),o(e,st,t),o(e,nl,t),o(e,ct,t),o(e,ul,t),o(e,sl,t),o(e,cl,t),o(e,mt,t),o(e,ml,t),p(pt,e,t),o(e,pl,t),o(e,ft,t),o(e,fl,t),o(e,ht,t),o(e,hl,t),o(e,_t,t),o(e,_l,t),o(e,bt,t),o(e,bl,t),o(e,wt,t),o(e,wl,t),o(e,gl,t),o(e,vl,t),o(e,gt,t),o(e,Tl,t),p(vt,e,t),o(e,yl,t),o(e,Tt,t),o(e,$l,t),o(e,yt,t),o(e,Al,t),o(e,$t,t),o(e,Hl,t),o(e,At,t),o(e,xl,t),o(e,Ll,t),o(e,Ml,t),p(Ht,e,t),o(e,Cl,t),o(e,Lt,t),ql=!0},p:Ui,i(e){ql||(f(v.$$.fragment,e),f(H.$$.fragment,e),f(C.$$.fragment,e),f(z.$$.fragment,e),f(E.$$.fragment,e),f(S.$$.fragment,e),f(N.$$.fragment,e),f(X.$$.fragment,e),f(ee.$$.fragment,e),f(ie.$$.fragment,e),f(se.$$.fragment,e),f(he.$$.fragment,e),f($e.$$.fragment,e),f(Me.$$.fragment,e),f(ze.$$.fragment,e),f(Ee.$$.fragment,e),f(Se.$$.fragment,e),f(Ue.$$.fragment,e),f(Ye.$$.fragment,e),f(dt.$$.fragment,e),f(at.$$.fragment,e),f(pt.$$.fragment,e),f(vt.$$.fragment,e),f(Ht.$$.fragment,e),ql=!0)},o(e){h(v.$$.fragment,e),h(H.$$.fragment,e),h(C.$$.fragment,e),h(z.$$.fragment,e),h(E.$$.fragment,e),h(S.$$.fragment,e),h(N.$$.fragment,e),h(X.$$.fragment,e),h(ee.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),h(he.$$.fragment,e),h($e.$$.fragment,e),h(Me.$$.fragment,e),h(ze.$$.fragment,e),h(Ee.$$.fragment,e),h(Se.$$.fragment,e),h(Ue.$$.fragment,e),h(Ye.$$.fragment,e),h(dt.$$.fragment,e),h(at.$$.fragment,e),h(pt.$$.fragment,e),h(vt.$$.fragment,e),h(Ht.$$.fragment,e),ql=!1},d(e){e&&(d(Mt),d(xt),d(Ct),d(g),d(qt),d(Pt),d(T),d(Rt),d(y),d(zt),d($),d(kt),d(Ft),d(Bt),d(A),d(Et),d(Wt),d(x),d(Dt),d(L),d(Kt),d(St),d(jt),d(M),d(It),d(Vt),d(q),d(Ot),d(P),d(Nt),d(Ut),d(Gt),d(R),d(Jt),d(Qt),d(k),d(Xt),d(F),d(Yt),d(Zt),d(ed),d(B),d(td),d(dd),d(W),d(od),d(D),d(ld),d(id),d(rd),d(K),d(ad),d(nd),d(j),d(ud),d(I),d(sd),d(V),d(cd),d(md),d(pd),d(O),d(fd),d(hd),d(U),d(_d),d(G),d(bd),d(J),d(wd),d(gd),d(vd),d(Q),d(Td),d(yd),d(Y),d($d),d(Ad),d(Hd),d(Z),d(xd),d(Ld),d(te),d(Md),d(de),d(Cd),d(oe),d(qd),d(Pd),d(Rd),d(le),d(zd),d(kd),d(re),d(Fd),d(ae),d(Bd),d(ne),d(Ed),d(Wd),d(Dd),d(ue),d(Kd),d(Sd),d(ce),d(jd),d(me),d(Id),d(pe),d(Vd),d(Od),d(Nd),d(fe),d(Ud),d(Gd),d(_e),d(Jd),d(be),d(Qd),d(we),d(Xd),d(ge),d(Yd),d(ve),d(Zd),d(Te),d(eo),d(to),d(oo),d(ye),d(lo),d(io),d(Ae),d(ro),d(He),d(ao),d(xe),d(no),d(uo),d(so),d(Le),d(co),d(mo),d(Ce),d(po),d(qe),d(fo),d(Pe),d(ho),d(_o),d(bo),d(Re),d(wo),d(go),d(ke),d(vo),d(Fe),d(To),d(yo),d($o),d(Be),d(Ao),d(Ho),d(We),d(xo),d(De),d(Lo),d(Mo),d(Co),d(Ke),d(qo),d(Po),d(je),d(Ro),d(Ie),d(zo),d(Ve),d(ko),d(Oe),d(Fo),d(Bo),d(Eo),d(Ne),d(Wo),d(Do),d(Ge),d(Ko),d(Je),d(So),d(Qe),d(jo),d(Io),d(Vo),d(Xe),d(Oo),d(No),d(Ze),d(Uo),d(et),d(Go),d(Jo),d(Qo),d(tt),d(Xo),d(Yo),d(ot),d(Zo),d(lt),d(el),d(it),d(tl),d(dl),d(ol),d(rt),d(ll),d(il),d(nt),d(rl),d(ut),d(al),d(st),d(nl),d(ct),d(ul),d(sl),d(cl),d(mt),d(ml),d(pl),d(ft),d(fl),d(ht),d(hl),d(_t),d(_l),d(bt),d(bl),d(wt),d(wl),d(gl),d(vl),d(gt),d(Tl),d(yl),d(Tt),d($l),d(yt),d(Al),d($t),d(Hl),d(At),d(xl),d(Ll),d(Ml),d(Cl),d(Lt)),d(w),_(v,e),_(H,e),_(C,e),_(z,e),_(E,e),_(S,e),_(N,e),_(X,e),_(ee,e),_(ie,e),_(se,e),_(he,e),_($e,e),_(Me,e),_(ze,e),_(Ee,e),_(Se,e),_(Ue,e),_(Ye,e),_(dt,e),_(at,e),_(pt,e),_(vt,e),_(Ht,e)}}}const tr='{"title":"utils/audio","local":"utilsaudio","sections":[{"title":"utils/audio.RawAudio","local":"utilsaudiorawaudio","sections":[{"title":"new RawAudio(audio, sampling_rate)","local":"new-rawaudioaudio-samplingrate","sections":[],"depth":3},{"title":"rawAudio.toWav() ⇒ <code> ArrayBuffer </code>","local":"rawaudiotowav--code-arraybuffer-code","sections":[],"depth":3},{"title":"rawAudio.toBlob() ⇒ <code> Blob </code>","local":"rawaudiotoblob--code-blob-code","sections":[],"depth":3},{"title":"rawAudio.save(path)","local":"rawaudiosavepath","sections":[],"depth":3}],"depth":2},{"title":"utils/audio.read_audio(url, sampling_rate) ⇒ <code> Promise. < Float32Array > </code>","local":"utilsaudioreadaudiourl-samplingrate--code-promise--float32array--code","sections":[{"title":"read_audio~audio : <code> Float32Array </code>","local":"readaudioaudio--code-float32array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/audio.hanning(M) ⇒ <code> Float64Array </code>","local":"utilsaudiohanningm--code-float64array-code","sections":[],"depth":2},{"title":"utils/audio.hamming(M) ⇒ <code> Float64Array </code>","local":"utilsaudiohammingm--code-float64array-code","sections":[],"depth":2},{"title":"utils/audio.mel_filter_bank(num_frequency_bins, num_mel_filters, min_frequency, max_frequency, sampling_rate, [norm], [mel_scale], [triangularize_in_mel_space]) ⇒ <code> Array. < Array < number > > </code>","local":"utilsaudiomelfilterbanknumfrequencybins-nummelfilters-minfrequency-maxfrequency-samplingrate-norm-melscale-triangularizeinmelspace--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/audio.spectrogram(waveform, window, frame_length, hop_length, options) ⇒ <code> Promise. < Tensor > </code>","local":"utilsaudiospectrogramwaveform-window-framelength-hoplength-options--code-promise--tensor--code","sections":[],"depth":2},{"title":"utils/audio.window_function(window_length, name, options) ⇒ <code> Float64Array </code>","local":"utilsaudiowindowfunctionwindowlength-name-options--code-float64array-code","sections":[],"depth":2},{"title":"utils/audio~generalized_cosine_window(M, a_0) ⇒ <code> Float64Array </code>","local":"utilsaudiogeneralizedcosinewindowm-a0--code-float64array-code","sections":[],"depth":2},{"title":"utils/audio~hertz_to_mel(freq, [mel_scale]) ⇒ <code> T </code>","local":"utilsaudiohertztomelfreq-melscale--code-t-code","sections":[],"depth":2},{"title":"utils/audio~mel_to_hertz(mels, [mel_scale]) ⇒ <code> T </code>","local":"utilsaudiomeltohertzmels-melscale--code-t-code","sections":[],"depth":2},{"title":"utils/audio~_create_triangular_filter_bank(fft_freqs, filter_freqs) ⇒ <code> Array. < Array < number > > </code>","local":"utilsaudiocreatetriangularfilterbankfftfreqs-filterfreqs--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/audio~linspace(start, end, num) ⇒","local":"utilsaudiolinspacestart-end-num-","sections":[],"depth":2},{"title":"utils/audio~padReflect(array, left, right) ⇒ <code> T </code>","local":"utilsaudiopadreflectarray-left-right--code-t-code","sections":[],"depth":2},{"title":"utils/audio~_db_conversion_helper(spectrogram, factor, reference, min_value, db_range) ⇒ <code> T </code>","local":"utilsaudiodbconversionhelperspectrogram-factor-reference-minvalue-dbrange--code-t-code","sections":[],"depth":2},{"title":"utils/audio~amplitude_to_db(spectrogram, [reference], [min_value], [db_range]) ⇒ <code> T </code>","local":"utilsaudioamplitudetodbspectrogram-reference-minvalue-dbrange--code-t-code","sections":[],"depth":2},{"title":"utils/audio~power_to_db(spectrogram, [reference], [min_value], [db_range]) ⇒ <code> T </code>","local":"utilsaudiopowertodbspectrogram-reference-minvalue-dbrange--code-t-code","sections":[],"depth":2},{"title":"utils/audio~encodeWAV(samples, rate) ⇒ <code> ArrayBuffer </code>","local":"utilsaudioencodewavsamples-rate--code-arraybuffer-code","sections":[],"depth":2}],"depth":1}';function dr(Pl){return Gi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rr extends Ji{constructor(w){super(),Qi(this,w,dr,er,Ni,{})}}export{rr as component};
