import{s as gl,n as Tl,o as Jl}from"../chunks/scheduler.39a43cde.js";import{S as vl,i as jl,g as i,s,r,A as $l,h as o,f as l,c as a,j as Ml,u as m,x as p,k as wl,y as xl,a as n,v as d,d as u,t as h,w as c}from"../chunks/index.23ec2204.js";import{D as Bl,C as b}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as Je}from"../chunks/Heading.c42e7061.js";function Gl(It){let f,$e,ve,xe,y,Be,M,Ge,w,_t='This notebook demonstrates how you can quickly build a RAG (Retrieval Augmented Generation) for a project’s GitHub issues using <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a> model, and LangChain.',Ce,g,Nt="<strong>What is RAG?</strong>",ke,T,Wt="RAG is a popular approach to address the issue of a powerful LLM not being aware of specific content due to said content not being in its training data, or hallucinating even when it has seen it before. Such specific content may be proprietary, sensitive, or, as in this example, recent and updated often.",Ue,J,Ht="If your data is static and doesn’t change regularly, you may consider fine-tuning a large model. In many cases, however, fine-tuning can be costly, and, when done repeatedly (e.g. to address data drift), leads to “model shift”. This is when the model’s behavior changes in ways that are not desirable.",Ze,v,Xt="<strong>RAG (Retrieval Augmented Generation)</strong> does not require model fine-tuning. Instead, RAG works by providing an LLM with additional context that is retrieved from relevant data so that it can generate a better-informed response.",Ie,j,Vt="Here’s a quick illustration:",_e,$,Rt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/rag-diagram.png" alt="RAG diagram"/>',Ne,x,Ft="<li><p>The external data is converted into embedding vectors with a separate embeddings model, and the vectors are kept in a database. Embeddings models are typically small, so updating the embedding vectors on a regular basis is faster, cheaper, and easier than fine-tuning a model.</p></li> <li><p>At the same time, the fact that fine-tuning is not required gives you the freedom to swap your LLM for a more powerful one when it becomes available, or switch to a smaller distilled version, should you need faster inference.</p></li>",We,B,Et="Let’s illustrate building a RAG using an open-source LLM, embeddings model, and LandChain.",He,G,Lt="First, install the required dependencies:",Xe,C,Ve,k,Re,U,Fe,Z,Ee,I,qt='In this example, we’ll load all of the issues (both open and closed) from <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT library’s repo</a>.',Le,_,zt='First, you need to acquire a <a href="https://github.com/settings/tokens?type=beta" rel="nofollow">GitHub personal access token</a> to access the GitHub API.',qe,N,ze,W,St='Next, we’ll load all of the issues in the <a href="https://github.com/huggingface/peft" rel="nofollow">huggingface/peft</a> repo:',Se,H,At="<li>By default, pull requests are considered issues as well, here we chose to exclude them from data with by setting <code>include_prs=False</code></li> <li>Setting <code>state = &quot;all&quot;</code> means we will load both open and closed issues.</li>",Ae,X,Qe,V,Qt="The content of individual GitHub issues may be longer than what an embedding model can take as input. If we want to embed all of the available content, we need to chunk the documents into appropriately sized pieces.",Ye,R,Yt="The most common and straightforward approach to chunking is to define a fixed size of chunks and whether there should be any overlap between them. Keeping some overlap between chunks allows us to preserve some semantic context between the chunks.",Pe,F,Pt="Other approaches are typically more involved and take into account the documents’ structure and context. For example, one may want to split a document based on sentences or paragraphs, or create chunks based on the",De,E,Dt="The fixed-size chunking, however, works well for most common cases, so that is what we’ll do here.",Ke,L,Oe,q,et,z,Kt="Now that the docs are all of the appropriate size, we can create a database with their embeddings.",tt,S,Ot='To create document chunk embeddings we’ll use the <code>HuggingFaceEmbeddings</code> and the <a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow"><code>BAAI/bge-base-en-v1.5</code></a> embeddings model. There are many other embeddings models available on the Hub, and you can keep an eye on the best performing ones by checking the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">Massive Text Embedding Benchmark (MTEB) Leaderboard</a>.',lt,A,el="To create the vector database, we’ll use <code>FAISS</code>, a library developed by Facebook AI. This library offers efficient similarity search and clustering of dense vectors, which is what we need here. FAISS is currently one of the most used libraries for NN search in massive datasets.",nt,Q,tl="We’ll access both the embeddings model and FAISS via LangChain API.",st,Y,at,P,ll="We need a way to return(retrieve) the documents given an unstructured query. For that, we’ll use the <code>as_retriever</code> method using the <code>db</code> as a backbone:",it,D,nl="<li><code>search_type=&quot;similarity&quot;</code> means we want to perform similarity search between the query and documents</li> <li><code>search_kwargs={&#39;k&#39;: 4}</code> instructs the retriever to return top 4 results.</li>",ot,K,pt,O,sl="The vector database and retriever are now set up, next we need to set up the next piece of the chain - the model.",rt,ee,mt,te,al='For this example, we chose <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a>, a small but powerful model.',dt,le,il='With many models being released every week, you may want to substitute this model to the latest and greatest. The best way to keep track of open source LLMs is to check the <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open-source LLM leaderboard</a>.',ut,ne,ol="To make inference faster, we will load the quantized version of the model:",ht,se,ct,ae,bt,ie,pl="Finally, we have all the pieces we need to set up the LLM chain.",ft,oe,rl="First, create a text_generation pipeline using the loaded model and its tokenizer.",yt,pe,ml="Next, create a prompt template - this should follow the format of the model, so if you substitute the model checkpoint, make sure to use the appropriate formatting.",Mt,re,wt,me,dl="Note: <em>You can also use <code>tokenizer.apply_chat_template</code> to convert a list of messages (as dicts: <code>{&#39;role&#39;: &#39;user&#39;, &#39;content&#39;: &#39;(...)&#39;}</code>) into a string with the appropriate chat format.</em>",gt,de,ul="Finally, we need to combine the <code>llm_chain</code> with the retriever to create the RAG:",Tt,ue,Jt,he,vt,ce,hl="Let’s see the difference RAG makes in generating answers to the library-specific questions.",jt,be,$t,fe,cl="First, let’s see what kind of answer we can get with just the model itself, no context added:",xt,ye,Bt,Me,bl=`As you can see, the model interpreted the question as one about physical computer adapters, while in the context of PEFT, “adapters” refer to LoRA adapters.
Let’s see if adding context from GitHub issues helps the model give a more relevant answer:`,Gt,we,Ct,ge,fl="As we can see, the added context, really helps the exact same model, provide a much more relevant and informed answer to the library-specific question.",kt,Te,yl="Notably, combining multiple adapters for inference has been added to the library, and one can find this information in the documentation, so for the next iteration of this RAG it may be worth including documentation embeddings.",Ut,je,Zt;return y=new Bl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/RAG_zephyr_langchain.ipynb"}]}}),M=new Je({props:{title:"Simple RAG for GitHub issues using Hugging Face Zephyr and LangChain",local:"simple-rag-for-github-issues-using-hugging-face-zephyr-and-langchain",headingTag:"h1"}}),C=new b({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMHRyYW5zZm9ybWVycyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWdwdQ==",highlighted:"!pip install -q torch transformers accelerate bitsandbytes transformers sentence-transformers faiss-gpu",wrap:!1}}),k=new b({props:{code:"JTIzJTIwSWYlMjBydW5uaW5nJTIwaW4lMjBHb29nbGUlMjBDb2xhYiUyQyUyMHlvdSUyMG1heSUyMG5lZWQlMjB0byUyMHJ1biUyMHRoaXMlMjBjZWxsJTIwdG8lMjBtYWtlJTIwc3VyZSUyMHlvdSdyZSUyMHVzaW5nJTIwVVRGLTglMjBsb2NhbGUlMjB0byUyMGluc3RhbGwlMjBMYW5nQ2hhaW4lMEFpbXBvcnQlMjBsb2NhbGUlMEElMEFsb2NhbGUuZ2V0cHJlZmVycmVkZW5jb2RpbmclMjAlM0QlMjBsYW1iZGElM0ElMjAlMjJVVEYtOCUyMg==",highlighted:`<span class="hljs-comment"># If running in Google Colab, you may need to run this cell to make sure you&#x27;re using UTF-8 locale to install LangChain</span>
<span class="hljs-keyword">import</span> locale

locale.getpreferredencoding = <span class="hljs-keyword">lambda</span>: <span class="hljs-string">&quot;UTF-8&quot;</span>`,wrap:!1}}),U=new b({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGxhbmdjaGFpbg==",highlighted:"!pip install -q langchain",wrap:!1}}),Z=new Je({props:{title:"Prepare the data",local:"prepare-the-data",headingTag:"h2"}}),N=new b({props:{code:"ZnJvbSUyMGdldHBhc3MlMjBpbXBvcnQlMjBnZXRwYXNzJTBBJTBBQUNDRVNTX1RPS0VOJTIwJTNEJTIwZ2V0cGFzcyglMjJZT1VSX0dJVEhVQl9QRVJTT05BTF9UT0tFTiUyMik=",highlighted:`<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass

ACCESS_TOKEN = getpass(<span class="hljs-string">&quot;YOUR_GITHUB_PERSONAL_TOKEN&quot;</span>)`,wrap:!1}}),X=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2N1bWVudF9sb2FkZXJzJTIwaW1wb3J0JTIwR2l0SHViSXNzdWVzTG9hZGVyJTBBJTBBbG9hZGVyJTIwJTNEJTIwR2l0SHViSXNzdWVzTG9hZGVyKHJlcG8lM0QlMjJodWdnaW5nZmFjZSUyRnBlZnQlMjIlMkMlMjBhY2Nlc3NfdG9rZW4lM0RBQ0NFU1NfVE9LRU4lMkMlMjBpbmNsdWRlX3BycyUzREZhbHNlJTJDJTIwc3RhdGUlM0QlMjJhbGwlMjIpJTBBJTBBZG9jcyUyMCUzRCUyMGxvYWRlci5sb2FkKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.document_loaders <span class="hljs-keyword">import</span> GitHubIssuesLoader

loader = GitHubIssuesLoader(repo=<span class="hljs-string">&quot;huggingface/peft&quot;</span>, access_token=ACCESS_TOKEN, include_prs=<span class="hljs-literal">False</span>, state=<span class="hljs-string">&quot;all&quot;</span>)

docs = loader.load()`,wrap:!1}}),L=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBJTBBc3BsaXR0ZXIlMjAlM0QlMjBDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUxMiUyQyUyMGNodW5rX292ZXJsYXAlM0QzMCklMEElMEFjaHVua2VkX2RvY3MlMjAlM0QlMjBzcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoZG9jcyk=",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> CharacterTextSplitter

splitter = CharacterTextSplitter(chunk_size=<span class="hljs-number">512</span>, chunk_overlap=<span class="hljs-number">30</span>)

chunked_docs = splitter.split_documents(docs)`,wrap:!1}}),q=new Je({props:{title:"Create the embeddings + retriever",local:"create-the-embeddings--retriever",headingTag:"h2"}}),Y=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW4uZW1iZWRkaW5ncyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5ncyUwQSUwQWRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoY2h1bmtlZF9kb2NzJTJDJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLWJhc2UtZW4tdjEuNSUyMikp",highlighted:`<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

db = FAISS.from_documents(chunked_docs, HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;BAAI/bge-base-en-v1.5&quot;</span>))`,wrap:!1}}),K=new b({props:{code:"cmV0cmlldmVyJTIwJTNEJTIwZGIuYXNfcmV0cmlldmVyKHNlYXJjaF90eXBlJTNEJTIyc2ltaWxhcml0eSUyMiUyQyUyMHNlYXJjaF9rd2FyZ3MlM0QlN0IlMjJrJTIyJTNBJTIwNCU3RCk=",highlighted:'retriever = db.as_retriever(search_type=<span class="hljs-string">&quot;similarity&quot;</span>, search_kwargs={<span class="hljs-string">&quot;k&quot;</span>: <span class="hljs-number">4</span>})',wrap:!1}}),ee=new Je({props:{title:"Load quantized model",local:"load-quantized-model",headingTag:"h2"}}),se=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiUwQSUwQWJuYl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9jb25maWcpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>, bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>, bnb_4bit_compute_dtype=torch.bfloat16
)

model = AutoModelForCausalLM.from_pretrained(model_name, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(model_name)`,wrap:!1}}),ae=new Je({props:{title:"Setup the LLM chain",local:"setup-the-llm-chain",headingTag:"h2"}}),re=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5sbG1zJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VQaXBlbGluZSUwQWZyb20lMjBsYW5nY2hhaW4ucHJvbXB0cyUyMGltcG9ydCUyMFByb21wdFRlbXBsYXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMGxhbmdjaGFpbi5jaGFpbnMlMjBpbXBvcnQlMjBMTE1DaGFpbiUwQSUwQXRleHRfZ2VuZXJhdGlvbl9waXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjB0YXNrJTNEJTIydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjIlMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjElMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENDAwJTJDJTBBKSUwQSUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlUGlwZWxpbmUocGlwZWxpbmUlM0R0ZXh0X2dlbmVyYXRpb25fcGlwZWxpbmUpJTBBJTBBcHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIyJTIyJTBBJTNDJTdDc3lzdGVtJTdDJTNFJTBBQW5zd2VyJTIwdGhlJTIwcXVlc3Rpb24lMjBiYXNlZCUyMG9uJTIweW91ciUyMGtub3dsZWRnZS4lMjBVc2UlMjB0aGUlMjBmb2xsb3dpbmclMjBjb250ZXh0JTIwdG8lMjBoZWxwJTNBJTBBJTBBJTdCY29udGV4dCU3RCUwQSUwQSUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBJTdCcXVlc3Rpb24lN0QlMEElM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBJTBBJTIwJTIyJTIyJTIyJTBBJTBBcHJvbXB0JTIwJTNEJTIwUHJvbXB0VGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwaW5wdXRfdmFyaWFibGVzJTNEJTVCJTIyY29udGV4dCUyMiUyQyUyMCUyMnF1ZXN0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGxhdGUlM0Rwcm9tcHRfdGVtcGxhdGUlMkMlMEEpJTBBJTBBbGxtX2NoYWluJTIwJTNEJTIwTExNQ2hhaW4obGxtJTNEbGxtJTJDJTIwcHJvbXB0JTNEcHJvbXB0KQ==",highlighted:`<span class="hljs-keyword">from</span> langchain.llms <span class="hljs-keyword">import</span> HuggingFacePipeline
<span class="hljs-keyword">from</span> langchain.prompts <span class="hljs-keyword">import</span> PromptTemplate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> langchain.chains <span class="hljs-keyword">import</span> LLMChain

text_generation_pipeline = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    temperature=<span class="hljs-number">0.2</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">True</span>,
    max_new_tokens=<span class="hljs-number">400</span>,
)

llm = HuggingFacePipeline(pipeline=text_generation_pipeline)

prompt_template = <span class="hljs-string">&quot;&quot;&quot;
&lt;|system|&gt;
Answer the question based on your knowledge. Use the following context to help:

{context}

&lt;/s&gt;
&lt;|user|&gt;
{question}
&lt;/s&gt;
&lt;|assistant|&gt;

 &quot;&quot;&quot;</span>

prompt = PromptTemplate(
    input_variables=[<span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>],
    template=prompt_template,
)

llm_chain = LLMChain(llm=llm, prompt=prompt)`,wrap:!1}}),ue=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5zY2hlbWEucnVubmFibGUlMjBpbXBvcnQlMjBSdW5uYWJsZVBhc3N0aHJvdWdoJTBBJTBBcmV0cmlldmVyJTIwJTNEJTIwZGIuYXNfcmV0cmlldmVyKCklMEElMEFyYWdfY2hhaW4lMjAlM0QlMjAlN0IlMjJjb250ZXh0JTIyJTNBJTIwcmV0cmlldmVyJTJDJTIwJTIycXVlc3Rpb24lMjIlM0ElMjBSdW5uYWJsZVBhc3N0aHJvdWdoKCklN0QlMjAlN0MlMjBsbG1fY2hhaW4=",highlighted:`<span class="hljs-keyword">from</span> langchain.schema.runnable <span class="hljs-keyword">import</span> RunnablePassthrough

retriever = db.as_retriever()

rag_chain = {<span class="hljs-string">&quot;context&quot;</span>: retriever, <span class="hljs-string">&quot;question&quot;</span>: RunnablePassthrough()} | llm_chain`,wrap:!1}}),he=new Je({props:{title:"Compare the results",local:"compare-the-results",headingTag:"h2"}}),be=new b({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJIb3clMjBkbyUyMHlvdSUyMGNvbWJpbmUlMjBtdWx0aXBsZSUyMGFkYXB0ZXJzJTNGJTIy",highlighted:'question = <span class="hljs-string">&quot;How do you combine multiple adapters?&quot;</span>',wrap:!1}}),ye=new b({props:{code:"bGxtX2NoYWluLmludm9rZSglN0IlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTIwJTIycXVlc3Rpb24lMjIlM0ElMjBxdWVzdGlvbiU3RCklNUIlMjJ0ZXh0JTIyJTVE",highlighted:'llm_chain.invoke({<span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>: question})[<span class="hljs-string">&quot;text&quot;</span>]',wrap:!1}}),we=new b({props:{code:"cmFnX2NoYWluLmludm9rZShxdWVzdGlvbiklNUIlMjJ0ZXh0JTIyJTVE",highlighted:'rag_chain.invoke(question)[<span class="hljs-string">&quot;text&quot;</span>]',wrap:!1}}),{c(){f=i("meta"),$e=s(),ve=i("p"),xe=s(),r(y.$$.fragment),Be=s(),r(M.$$.fragment),Ge=s(),w=i("p"),w.innerHTML=_t,Ce=s(),g=i("p"),g.innerHTML=Nt,ke=s(),T=i("p"),T.textContent=Wt,Ue=s(),J=i("p"),J.textContent=Ht,Ze=s(),v=i("p"),v.innerHTML=Xt,Ie=s(),j=i("p"),j.textContent=Vt,_e=s(),$=i("p"),$.innerHTML=Rt,Ne=s(),x=i("ul"),x.innerHTML=Ft,We=s(),B=i("p"),B.textContent=Et,He=s(),G=i("p"),G.textContent=Lt,Xe=s(),r(C.$$.fragment),Ve=s(),r(k.$$.fragment),Re=s(),r(U.$$.fragment),Fe=s(),r(Z.$$.fragment),Ee=s(),I=i("p"),I.innerHTML=qt,Le=s(),_=i("p"),_.innerHTML=zt,qe=s(),r(N.$$.fragment),ze=s(),W=i("p"),W.innerHTML=St,Se=s(),H=i("ul"),H.innerHTML=At,Ae=s(),r(X.$$.fragment),Qe=s(),V=i("p"),V.textContent=Qt,Ye=s(),R=i("p"),R.textContent=Yt,Pe=s(),F=i("p"),F.textContent=Pt,De=s(),E=i("p"),E.textContent=Dt,Ke=s(),r(L.$$.fragment),Oe=s(),r(q.$$.fragment),et=s(),z=i("p"),z.textContent=Kt,tt=s(),S=i("p"),S.innerHTML=Ot,lt=s(),A=i("p"),A.innerHTML=el,nt=s(),Q=i("p"),Q.textContent=tl,st=s(),r(Y.$$.fragment),at=s(),P=i("p"),P.innerHTML=ll,it=s(),D=i("ul"),D.innerHTML=nl,ot=s(),r(K.$$.fragment),pt=s(),O=i("p"),O.textContent=sl,rt=s(),r(ee.$$.fragment),mt=s(),te=i("p"),te.innerHTML=al,dt=s(),le=i("p"),le.innerHTML=il,ut=s(),ne=i("p"),ne.textContent=ol,ht=s(),r(se.$$.fragment),ct=s(),r(ae.$$.fragment),bt=s(),ie=i("p"),ie.textContent=pl,ft=s(),oe=i("p"),oe.textContent=rl,yt=s(),pe=i("p"),pe.textContent=ml,Mt=s(),r(re.$$.fragment),wt=s(),me=i("p"),me.innerHTML=dl,gt=s(),de=i("p"),de.innerHTML=ul,Tt=s(),r(ue.$$.fragment),Jt=s(),r(he.$$.fragment),vt=s(),ce=i("p"),ce.textContent=hl,jt=s(),r(be.$$.fragment),$t=s(),fe=i("p"),fe.textContent=cl,xt=s(),r(ye.$$.fragment),Bt=s(),Me=i("p"),Me.textContent=bl,Gt=s(),r(we.$$.fragment),Ct=s(),ge=i("p"),ge.textContent=fl,kt=s(),Te=i("p"),Te.textContent=yl,Ut=s(),je=i("p"),this.h()},l(e){const t=$l("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(l),$e=a(e),ve=o(e,"P",{}),Ml(ve).forEach(l),xe=a(e),m(y.$$.fragment,e),Be=a(e),m(M.$$.fragment,e),Ge=a(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1ef5fle"&&(w.innerHTML=_t),Ce=a(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1ty8bu"&&(g.innerHTML=Nt),ke=a(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-7wteio"&&(T.textContent=Wt),Ue=a(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1x9vu2c"&&(J.textContent=Ht),Ze=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-14i5lt5"&&(v.innerHTML=Xt),Ie=a(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-5qqm02"&&(j.textContent=Vt),_e=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1c1z86r"&&($.innerHTML=Rt),Ne=a(e),x=o(e,"UL",{"data-svelte-h":!0}),p(x)!=="svelte-8anxeq"&&(x.innerHTML=Ft),We=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-gf6us3"&&(B.textContent=Et),He=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1f3oki6"&&(G.textContent=Lt),Xe=a(e),m(C.$$.fragment,e),Ve=a(e),m(k.$$.fragment,e),Re=a(e),m(U.$$.fragment,e),Fe=a(e),m(Z.$$.fragment,e),Ee=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1htvfcb"&&(I.innerHTML=qt),Le=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1y7zwpt"&&(_.innerHTML=zt),qe=a(e),m(N.$$.fragment,e),ze=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1sitgme"&&(W.innerHTML=St),Se=a(e),H=o(e,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-ktvuvk"&&(H.innerHTML=At),Ae=a(e),m(X.$$.fragment,e),Qe=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-oungvg"&&(V.textContent=Qt),Ye=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1c4l20y"&&(R.textContent=Yt),Pe=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-r5k8di"&&(F.textContent=Pt),De=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1u7b0nv"&&(E.textContent=Dt),Ke=a(e),m(L.$$.fragment,e),Oe=a(e),m(q.$$.fragment,e),et=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1ng4z3s"&&(z.textContent=Kt),tt=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-z63x34"&&(S.innerHTML=Ot),lt=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1hq28ne"&&(A.innerHTML=el),nt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1n2sms8"&&(Q.textContent=tl),st=a(e),m(Y.$$.fragment,e),at=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-140j4it"&&(P.innerHTML=ll),it=a(e),D=o(e,"UL",{"data-svelte-h":!0}),p(D)!=="svelte-hejw60"&&(D.innerHTML=nl),ot=a(e),m(K.$$.fragment,e),pt=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-4c9ypi"&&(O.textContent=sl),rt=a(e),m(ee.$$.fragment,e),mt=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1fynfov"&&(te.innerHTML=al),dt=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-gklra8"&&(le.innerHTML=il),ut=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1bs26eu"&&(ne.textContent=ol),ht=a(e),m(se.$$.fragment,e),ct=a(e),m(ae.$$.fragment,e),bt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-dvcewb"&&(ie.textContent=pl),ft=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-8iwm5k"&&(oe.textContent=rl),yt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-qz9rvk"&&(pe.textContent=ml),Mt=a(e),m(re.$$.fragment,e),wt=a(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-15zr00j"&&(me.innerHTML=dl),gt=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1tmcmgh"&&(de.innerHTML=ul),Tt=a(e),m(ue.$$.fragment,e),Jt=a(e),m(he.$$.fragment,e),vt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1m90it0"&&(ce.textContent=hl),jt=a(e),m(be.$$.fragment,e),$t=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1m8rs90"&&(fe.textContent=cl),xt=a(e),m(ye.$$.fragment,e),Bt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-10i2mx0"&&(Me.textContent=bl),Gt=a(e),m(we.$$.fragment,e),Ct=a(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1gvzgod"&&(ge.textContent=fl),kt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-rlk7jz"&&(Te.textContent=yl),Ut=a(e),je=o(e,"P",{}),Ml(je).forEach(l),this.h()},h(){wl(f,"name","hf:doc:metadata"),wl(f,"content",Cl)},m(e,t){xl(document.head,f),n(e,$e,t),n(e,ve,t),n(e,xe,t),d(y,e,t),n(e,Be,t),d(M,e,t),n(e,Ge,t),n(e,w,t),n(e,Ce,t),n(e,g,t),n(e,ke,t),n(e,T,t),n(e,Ue,t),n(e,J,t),n(e,Ze,t),n(e,v,t),n(e,Ie,t),n(e,j,t),n(e,_e,t),n(e,$,t),n(e,Ne,t),n(e,x,t),n(e,We,t),n(e,B,t),n(e,He,t),n(e,G,t),n(e,Xe,t),d(C,e,t),n(e,Ve,t),d(k,e,t),n(e,Re,t),d(U,e,t),n(e,Fe,t),d(Z,e,t),n(e,Ee,t),n(e,I,t),n(e,Le,t),n(e,_,t),n(e,qe,t),d(N,e,t),n(e,ze,t),n(e,W,t),n(e,Se,t),n(e,H,t),n(e,Ae,t),d(X,e,t),n(e,Qe,t),n(e,V,t),n(e,Ye,t),n(e,R,t),n(e,Pe,t),n(e,F,t),n(e,De,t),n(e,E,t),n(e,Ke,t),d(L,e,t),n(e,Oe,t),d(q,e,t),n(e,et,t),n(e,z,t),n(e,tt,t),n(e,S,t),n(e,lt,t),n(e,A,t),n(e,nt,t),n(e,Q,t),n(e,st,t),d(Y,e,t),n(e,at,t),n(e,P,t),n(e,it,t),n(e,D,t),n(e,ot,t),d(K,e,t),n(e,pt,t),n(e,O,t),n(e,rt,t),d(ee,e,t),n(e,mt,t),n(e,te,t),n(e,dt,t),n(e,le,t),n(e,ut,t),n(e,ne,t),n(e,ht,t),d(se,e,t),n(e,ct,t),d(ae,e,t),n(e,bt,t),n(e,ie,t),n(e,ft,t),n(e,oe,t),n(e,yt,t),n(e,pe,t),n(e,Mt,t),d(re,e,t),n(e,wt,t),n(e,me,t),n(e,gt,t),n(e,de,t),n(e,Tt,t),d(ue,e,t),n(e,Jt,t),d(he,e,t),n(e,vt,t),n(e,ce,t),n(e,jt,t),d(be,e,t),n(e,$t,t),n(e,fe,t),n(e,xt,t),d(ye,e,t),n(e,Bt,t),n(e,Me,t),n(e,Gt,t),d(we,e,t),n(e,Ct,t),n(e,ge,t),n(e,kt,t),n(e,Te,t),n(e,Ut,t),n(e,je,t),Zt=!0},p:Tl,i(e){Zt||(u(y.$$.fragment,e),u(M.$$.fragment,e),u(C.$$.fragment,e),u(k.$$.fragment,e),u(U.$$.fragment,e),u(Z.$$.fragment,e),u(N.$$.fragment,e),u(X.$$.fragment,e),u(L.$$.fragment,e),u(q.$$.fragment,e),u(Y.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(we.$$.fragment,e),Zt=!0)},o(e){h(y.$$.fragment,e),h(M.$$.fragment,e),h(C.$$.fragment,e),h(k.$$.fragment,e),h(U.$$.fragment,e),h(Z.$$.fragment,e),h(N.$$.fragment,e),h(X.$$.fragment,e),h(L.$$.fragment,e),h(q.$$.fragment,e),h(Y.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(be.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),Zt=!1},d(e){e&&(l($e),l(ve),l(xe),l(Be),l(Ge),l(w),l(Ce),l(g),l(ke),l(T),l(Ue),l(J),l(Ze),l(v),l(Ie),l(j),l(_e),l($),l(Ne),l(x),l(We),l(B),l(He),l(G),l(Xe),l(Ve),l(Re),l(Fe),l(Ee),l(I),l(Le),l(_),l(qe),l(ze),l(W),l(Se),l(H),l(Ae),l(Qe),l(V),l(Ye),l(R),l(Pe),l(F),l(De),l(E),l(Ke),l(Oe),l(et),l(z),l(tt),l(S),l(lt),l(A),l(nt),l(Q),l(st),l(at),l(P),l(it),l(D),l(ot),l(pt),l(O),l(rt),l(mt),l(te),l(dt),l(le),l(ut),l(ne),l(ht),l(ct),l(bt),l(ie),l(ft),l(oe),l(yt),l(pe),l(Mt),l(wt),l(me),l(gt),l(de),l(Tt),l(Jt),l(vt),l(ce),l(jt),l($t),l(fe),l(xt),l(Bt),l(Me),l(Gt),l(Ct),l(ge),l(kt),l(Te),l(Ut),l(je)),l(f),c(y,e),c(M,e),c(C,e),c(k,e),c(U,e),c(Z,e),c(N,e),c(X,e),c(L,e),c(q,e),c(Y,e),c(K,e),c(ee,e),c(se,e),c(ae,e),c(re,e),c(ue,e),c(he,e),c(be,e),c(ye,e),c(we,e)}}}const Cl='{"title":"Simple RAG for GitHub issues using Hugging Face Zephyr and LangChain","local":"simple-rag-for-github-issues-using-hugging-face-zephyr-and-langchain","sections":[{"title":"Prepare the data","local":"prepare-the-data","sections":[],"depth":2},{"title":"Create the embeddings + retriever","local":"create-the-embeddings--retriever","sections":[],"depth":2},{"title":"Load quantized model","local":"load-quantized-model","sections":[],"depth":2},{"title":"Setup the LLM chain","local":"setup-the-llm-chain","sections":[],"depth":2},{"title":"Compare the results","local":"compare-the-results","sections":[],"depth":2}],"depth":1}';function kl(It){return Jl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nl extends vl{constructor(f){super(),jl(this,f,kl,Gl,gl,{})}}export{Nl as component};
