import{s as Pe,n as Ae,o as Oe}from"../chunks/scheduler.9680c161.js";import{S as Ke,i as et,g as i,s as l,r as p,A as tt,h as r,f as s,c as a,j as De,u as c,x as o,k as D,y as st,a as n,v as h,d as m,t as d,w as y}from"../chunks/index.38d74ee1.js";import{C as P}from"../chunks/CodeBlock.1371964c.js";import{H as L}from"../chunks/Heading.74c51a96.js";function nt(Re){let M,A,F,O,J,K,f,ee,g,Ze="Token streaming is the mode in which the server returns the tokens one by one as the model generates them. This enables showing progressive generations to the user rather than waiting for the whole generation. Streaming is an essential aspect of the end-user experience as it reduces latency, one of the most critical aspects of a smooth experience.",te,u,Ce='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tgi/streaming-generation-visual_360.gif"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tgi/streaming-generation-visual-dark_360.gif"/>',se,U,Ge="With token streaming, the server can start returning the tokens one by one before having to generate the whole response. Users can have a sense of the generation’s quality earlier than the end of the generation. This has different positive effects:",ne,j,$e="<li>Users can get results orders of magnitude earlier for extremely long queries.</li> <li>Seeing something in progress allows users to stop the generation if it’s not going in the direction they expect.</li> <li>Perceived latency is lower when results are shown in the early stages.</li> <li>When used in conversational UIs, the experience feels more natural.</li>",le,b,Se="For example, a system can generate 100 tokens per second. If the system generates 1000 tokens, with the non-streaming setup, users need to wait 10 seconds to get results. On the other hand, with the streaming setup, users get initial results immediately, and although end-to-end latency will be the same, they can see half of the generation after five seconds. Below you can see an interactive demo that shows non-streaming vs streaming side-by-side. Click <strong>generate</strong> below.",ae,T,Ve='<iframe src="https://osanseviero-streaming-vs-non-streaming.hf.space?__theme=light" width="850" height="350"></iframe>',ie,w,He='<iframe src="https://osanseviero-streaming-vs-non-streaming.hf.space?__theme=dark" width="850" height="350"></iframe>',re,v,oe,k,pe,I,Ee="To stream tokens with <code>InferenceClient</code>, simply pass <code>stream=True</code> and iterate over the response.",ce,x,he,B,We="If you want additional details, you can add <code>details=True</code>. In this case, you get a <code>TextGenerationStreamResponse</code> which contains additional information such as the probabilities and the tokens. For the final response in the stream, it also returns the full generated text.",me,R,de,Z,Ne="The <code>huggingface_hub</code> library also comes with an <code>AsyncInferenceClient</code> in case you need to handle the requests concurrently.",ye,C,Me,G,ue,$,_e="To use the <code>generate_stream</code> endpoint with curl, you can add the <code>-N</code> flag, which disables curl default buffering and shows data as it arrives from the server",Te,S,we,V,Je,H,ze=`First, we need to install the <code>@huggingface/inference</code> library.
<code>npm install @huggingface/inference</code>`,fe,E,Qe="If you’re using the free Inference API, you can use <code>HfInference</code>. If you’re using inference endpoints, you can use <code>HfInferenceEndpoint</code>. Let’s",ge,W,Ye="We can create a <code>HfInferenceEndpoint</code> providing our endpoint URL and credential.",Ue,N,je,_,be,z,Xe="Under the hood, TGI uses Server-Sent Events (SSE). In an SSE Setup, a client sends a request with the data, opening an HTTP connection and subscribing to updates. Afterward, the server sends data to the client. There is no need for further requests; the server will keep sending the data. SSEs are unidirectional, meaning the client does not send other requests to the server. SSE sends data over HTTP, making it easy to use.",ve,Q,Le="SSEs are different than:",ke,Y,Fe="<li>Polling: where the client keeps calling the server to get data. This means that the server might return empty responses and cause overhead.</li> <li>Webhooks: where there is a bi-directional connection. The server can send information to the client, but the client can also send data to the server after the first request. Webhooks are more complex to operate as they don’t only use HTTP.</li>",Ie,X,qe="If there are too many requests at the same time, TGI returns an HTTP Error with an <code>overloaded</code> error type (<code>huggingface_hub</code> returns <code>OverloadedError</code>). This allows the client to manage the overloaded server (e.g., it could display a busy error to the user or retry with a new request). To configure the maximum number of concurrent requests, you can specify <code>--max_concurrent_requests</code>, allowing clients to handle backpressure.",xe,q,Be;return J=new L({props:{title:"Streaming",local:"streaming",headingTag:"h1"}}),f=new L({props:{title:"What is Streaming?",local:"what-is-streaming",headingTag:"h2"}}),v=new L({props:{title:"How to use Streaming?",local:"how-to-use-streaming",headingTag:"h2"}}),k=new L({props:{title:"Streaming with Python",local:"streaming-with-python",headingTag:"h3"}}),x=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODA4MCUyMiklMEFmb3IlMjB0b2tlbiUyMGluJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJIb3clMjBkbyUyMHlvdSUyMG1ha2UlMjBjaGVlc2UlM0YlMjIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbiklMEElMEElMjMlMjBUbyUwQSUyMyUyMG1ha2UlMEElMjMlMjBjaGVlc2UlMEElMjMlMkMlMEElMjMlMjB5b3UlMEElMjMlMjBuZWVkJTBBJTIzJTIwdG8lMEElMjMlMjBzdGFydCUwQSUyMyUyMHdpdGglMEElMjMlMjBtaWxrJTBBJTIzLg==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(<span class="hljs-string">&quot;http://127.0.0.1:8080&quot;</span>)
<span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;How do you make cheese?&quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
    <span class="hljs-built_in">print</span>(token)

<span class="hljs-comment"># To</span>
<span class="hljs-comment"># make</span>
<span class="hljs-comment"># cheese</span>
<span class="hljs-comment">#,</span>
<span class="hljs-comment"># you</span>
<span class="hljs-comment"># need</span>
<span class="hljs-comment"># to</span>
<span class="hljs-comment"># start</span>
<span class="hljs-comment"># with</span>
<span class="hljs-comment"># milk</span>
<span class="hljs-comment">#.</span>`,wrap:!1}}),R=new P({props:{code:"Zm9yJTIwZGV0YWlscyUyMGluJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJIb3clMjBkbyUyMHlvdSUyMG1ha2UlMjBjaGVlc2UlM0YlMjIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyJTJDJTIwZGV0YWlscyUzRFRydWUlMkMlMjBzdHJlYW0lM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGRldGFpbHMpJTBBJTBBJTIzVGV4dEdlbmVyYXRpb25TdHJlYW1SZXNwb25zZSh0b2tlbiUzRFRva2VuKGlkJTNEMTkzJTJDJTIwdGV4dCUzRCclNUNuJyUyQyUyMGxvZ3Byb2IlM0QtMC4wMDczNTg1NTElMkMlMjBzcGVjaWFsJTNERmFsc2UpJTJDJTIwZ2VuZXJhdGVkX3RleHQlM0ROb25lJTJDJTIwZGV0YWlscyUzRE5vbmUpJTBBJTIzVGV4dEdlbmVyYXRpb25TdHJlYW1SZXNwb25zZSh0b2tlbiUzRFRva2VuKGlkJTNEMjA0NCUyQyUyMHRleHQlM0QnVG8nJTJDJTIwbG9ncHJvYiUzRC0xLjEzNTc0MjIlMkMlMjBzcGVjaWFsJTNERmFsc2UpJTJDJTIwZ2VuZXJhdGVkX3RleHQlM0ROb25lJTJDJTIwZGV0YWlscyUzRE5vbmUpJTBBJTIzVGV4dEdlbmVyYXRpb25TdHJlYW1SZXNwb25zZSh0b2tlbiUzRFRva2VuKGlkJTNENzE3JTJDJTIwdGV4dCUzRCclMjBtYWtlJyUyQyUyMGxvZ3Byb2IlM0QtMC4wMDk4NDE5MTklMkMlMjBzcGVjaWFsJTNERmFsc2UpJTJDJTIwZ2VuZXJhdGVkX3RleHQlM0ROb25lJTJDJTIwZGV0YWlscyUzRE5vbmUpJTBBJTIzLi4uJTBBJTIzVGV4dEdlbmVyYXRpb25TdHJlYW1SZXNwb25zZSh0b2tlbiUzRFRva2VuKGlkJTNEMjUlMkMlMjB0ZXh0JTNEJy4nJTJDJTIwbG9ncHJvYiUzRC0xLjM0MDgyMDMlMkMlMjBzcGVjaWFsJTNERmFsc2UpJTJDJTIwZ2VuZXJhdGVkX3RleHQlM0QnJTVDblRvJTIwbWFrZSUyMGNoZWVzZSUyQyUyMHlvdSUyMG5lZWQlMjB0byUyMHN0YXJ0JTIwd2l0aCUyMG1pbGsuJyUyQyUyMGRldGFpbHMlM0RTdHJlYW1EZXRhaWxzKGZpbmlzaF9yZWFzb24lM0QlM0NGaW5pc2hSZWFzb24uTGVuZ3RoJTNBJTIwJ2xlbmd0aCclM0UlMkMlMjBnZW5lcmF0ZWRfdG9rZW5zJTNEMTIlMkMlMjBzZWVkJTNETm9uZSkp",highlighted:`<span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;How do you make cheese?&quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
    <span class="hljs-built_in">print</span>(details)

<span class="hljs-comment">#TextGenerationStreamResponse(token=Token(id=193, text=&#x27;\\n&#x27;, logprob=-0.007358551, special=False), generated_text=None, details=None)</span>
<span class="hljs-comment">#TextGenerationStreamResponse(token=Token(id=2044, text=&#x27;To&#x27;, logprob=-1.1357422, special=False), generated_text=None, details=None)</span>
<span class="hljs-comment">#TextGenerationStreamResponse(token=Token(id=717, text=&#x27; make&#x27;, logprob=-0.009841919, special=False), generated_text=None, details=None)</span>
<span class="hljs-comment">#...</span>
<span class="hljs-comment">#TextGenerationStreamResponse(token=Token(id=25, text=&#x27;.&#x27;, logprob=-1.3408203, special=False), generated_text=&#x27;\\nTo make cheese, you need to start with milk.&#x27;, details=StreamDetails(finish_reason=&lt;FinishReason.Length: &#x27;length&#x27;&gt;, generated_tokens=12, seed=None))</span>`,wrap:!1}}),C=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBJTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIyaHR0cCUzQSUyRiUyRjEyNy4wLjAuMSUzQTgwODAlMjIpJTBBYXN5bmMlMjBmb3IlMjB0b2tlbiUyMGluJTIwYXdhaXQlMjBjbGllbnQudGV4dF9nZW5lcmF0aW9uKCUyMkhvdyUyMGRvJTIweW91JTIwbWFrZSUyMGNoZWVzZSUzRiUyMiUyQyUyMHN0cmVhbSUzRFRydWUpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW4pJTBBJTBBJTIzJTIwVG8lMEElMjMlMjBtYWtlJTBBJTIzJTIwY2hlZXNlJTBBJTIzJTJDJTBBJTIzJTIweW91JTBBJTIzJTIwbmVlZCUwQSUyMyUyMHRvJTBBJTIzJTIwc3RhcnQlMEElMjMlMjB3aXRoJTBBJTIzJTIwbWlsayUwQSUyMy4=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient

client = AsyncInferenceClient(<span class="hljs-string">&quot;http://127.0.0.1:8080&quot;</span>)
<span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;How do you make cheese?&quot;</span>, stream=<span class="hljs-literal">True</span>):
    <span class="hljs-built_in">print</span>(token)

<span class="hljs-comment"># To</span>
<span class="hljs-comment"># make</span>
<span class="hljs-comment"># cheese</span>
<span class="hljs-comment">#,</span>
<span class="hljs-comment"># you</span>
<span class="hljs-comment"># need</span>
<span class="hljs-comment"># to</span>
<span class="hljs-comment"># start</span>
<span class="hljs-comment"># with</span>
<span class="hljs-comment"># milk</span>
<span class="hljs-comment">#.</span>`,wrap:!1}}),G=new L({props:{title:"Streaming with cURL",local:"streaming-with-curl",headingTag:"h3"}}),S=new P({props:{code:"Y3VybCUyMC1OJTIwMTI3LjAuMC4xJTNBODA4MCUyRmdlbmVyYXRlX3N0cmVhbSUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUyMmlucHV0cyUyMiUzQSUyMldoYXQlMjBpcyUyMERlZXAlMjBMZWFybmluZyUzRiUyMiUyQyUyMnBhcmFtZXRlcnMlMjIlM0ElN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQTIwJTdEJTdEJyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1IJTIwJ0NvbnRlbnQtVHlwZSUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbic=",highlighted:`curl -N <span class="hljs-number">127.0</span>.<span class="hljs-number">0.1</span>:<span class="hljs-number">8080</span>/generate_stream \\
    -X POST \\
    -d &#x27;{<span class="hljs-string">&quot;inputs&quot;</span>:<span class="hljs-string">&quot;What is Deep Learning?&quot;</span>,<span class="hljs-string">&quot;parameters&quot;</span>:{<span class="hljs-string">&quot;max_new_tokens&quot;</span>:<span class="hljs-number">20</span>}}&#x27; \\
    -H <span class="hljs-symbol">&#x27;Content</span>-<span class="hljs-keyword">Type</span>: application/json&#x27;`,wrap:!1}}),V=new L({props:{title:"Streaming with JavaScript",local:"streaming-with-javascript",headingTag:"h3"}}),N=new P({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2VFbmRwb2ludCUyMCU3RCUyMGZyb20lMjAnJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UnJTBBJTBBY29uc3QlMjBoZiUyMCUzRCUyMG5ldyUyMEhmSW5mZXJlbmNlRW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGWU9VUl9FTkRQT0lOVC5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQnJTJDJTIwJ2hmX1lPVVJfVE9LRU4nKSUwQSUwQSUyRiUyRiUyMHByb21wdCUwQWNvbnN0JTIwcHJvbXB0JTIwJTNEJTIwJ1doYXQlMjBjYW4lMjB5b3UlMjBkbyUyMGluJTIwTnVyZW1iZXJnJTJDJTIwR2VybWFueSUzRiUyMEdpdmUlMjBtZSUyMDMlMjBUaXBzJyUwQSUwQWNvbnN0JTIwc3RyZWFtJTIwJTNEJTIwaGYudGV4dEdlbmVyYXRpb25TdHJlYW0oJTdCJTIwaW5wdXRzJTNBJTIwcHJvbXB0JTIwJTdEKSUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwciUyMG9mJTIwc3RyZWFtKSUyMCU3QiUyMCUwQSUyMCUyMCUyRiUyRiUyMHlpZWxkJTIwdGhlJTIwZ2VuZXJhdGVkJTIwdG9rZW4lMEElMjAlMjBwcm9jZXNzLnN0ZG91dC53cml0ZShyLnRva2VuLnRleHQpJTBBJTdE",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInferenceEndpoint</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/inference&#x27;</span>

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInferenceEndpoint</span>(<span class="hljs-string">&#x27;https://YOUR_ENDPOINT.endpoints.huggingface.cloud&#x27;</span>, <span class="hljs-string">&#x27;hf_YOUR_TOKEN&#x27;</span>)

<span class="hljs-comment">// prompt</span>
<span class="hljs-keyword">const</span> prompt = <span class="hljs-string">&#x27;What can you do in Nuremberg, Germany? Give me 3 Tips&#x27;</span>

<span class="hljs-keyword">const</span> stream = hf.<span class="hljs-title function_">textGenerationStream</span>({ <span class="hljs-attr">inputs</span>: prompt })
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> r <span class="hljs-keyword">of</span> stream) { 
  <span class="hljs-comment">// yield the generated token</span>
  process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(r.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>)
}`,wrap:!1}}),_=new L({props:{title:"How does Streaming work under the hood?",local:"how-does-streaming-work-under-the-hood",headingTag:"h2"}}),{c(){M=i("meta"),A=l(),F=i("p"),O=l(),p(J.$$.fragment),K=l(),p(f.$$.fragment),ee=l(),g=i("p"),g.textContent=Ze,te=l(),u=i("div"),u.innerHTML=Ce,se=l(),U=i("p"),U.textContent=Ge,ne=l(),j=i("ul"),j.innerHTML=$e,le=l(),b=i("p"),b.innerHTML=Se,ae=l(),T=i("div"),T.innerHTML=Ve,ie=l(),w=i("div"),w.innerHTML=He,re=l(),p(v.$$.fragment),oe=l(),p(k.$$.fragment),pe=l(),I=i("p"),I.innerHTML=Ee,ce=l(),p(x.$$.fragment),he=l(),B=i("p"),B.innerHTML=We,me=l(),p(R.$$.fragment),de=l(),Z=i("p"),Z.innerHTML=Ne,ye=l(),p(C.$$.fragment),Me=l(),p(G.$$.fragment),ue=l(),$=i("p"),$.innerHTML=_e,Te=l(),p(S.$$.fragment),we=l(),p(V.$$.fragment),Je=l(),H=i("p"),H.innerHTML=ze,fe=l(),E=i("p"),E.innerHTML=Qe,ge=l(),W=i("p"),W.innerHTML=Ye,Ue=l(),p(N.$$.fragment),je=l(),p(_.$$.fragment),be=l(),z=i("p"),z.textContent=Xe,ve=l(),Q=i("p"),Q.textContent=Le,ke=l(),Y=i("ul"),Y.innerHTML=Fe,Ie=l(),X=i("p"),X.innerHTML=qe,xe=l(),q=i("p"),this.h()},l(e){const t=tt("svelte-u9bgzb",document.head);M=r(t,"META",{name:!0,content:!0}),t.forEach(s),A=a(e),F=r(e,"P",{}),De(F).forEach(s),O=a(e),c(J.$$.fragment,e),K=a(e),c(f.$$.fragment,e),ee=a(e),g=r(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-18otp1w"&&(g.textContent=Ze),te=a(e),u=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(u)!=="svelte-1mls61x"&&(u.innerHTML=Ce),se=a(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-24h65x"&&(U.textContent=Ge),ne=a(e),j=r(e,"UL",{"data-svelte-h":!0}),o(j)!=="svelte-1sljm14"&&(j.innerHTML=$e),le=a(e),b=r(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-doyuuq"&&(b.innerHTML=Se),ae=a(e),T=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-7ia471"&&(T.innerHTML=Ve),ie=a(e),w=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1wj2bw6"&&(w.innerHTML=He),re=a(e),c(v.$$.fragment,e),oe=a(e),c(k.$$.fragment,e),pe=a(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-j8caua"&&(I.innerHTML=Ee),ce=a(e),c(x.$$.fragment,e),he=a(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-wt9qrx"&&(B.innerHTML=We),me=a(e),c(R.$$.fragment,e),de=a(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1nblluv"&&(Z.innerHTML=Ne),ye=a(e),c(C.$$.fragment,e),Me=a(e),c(G.$$.fragment,e),ue=a(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-dr4syr"&&($.innerHTML=_e),Te=a(e),c(S.$$.fragment,e),we=a(e),c(V.$$.fragment,e),Je=a(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-16sqqc4"&&(H.innerHTML=ze),fe=a(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-slx97h"&&(E.innerHTML=Qe),ge=a(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-5nogh0"&&(W.innerHTML=Ye),Ue=a(e),c(N.$$.fragment,e),je=a(e),c(_.$$.fragment,e),be=a(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1wghvdx"&&(z.textContent=Xe),ve=a(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-m95rqi"&&(Q.textContent=Le),ke=a(e),Y=r(e,"UL",{"data-svelte-h":!0}),o(Y)!=="svelte-1vpfo5b"&&(Y.innerHTML=Fe),Ie=a(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-jbqwxg"&&(X.innerHTML=qe),xe=a(e),q=r(e,"P",{}),De(q).forEach(s),this.h()},h(){D(M,"name","hf:doc:metadata"),D(M,"content",lt),D(u,"class","flex justify-center"),D(T,"class","block dark:hidden"),D(w,"class","hidden dark:block")},m(e,t){st(document.head,M),n(e,A,t),n(e,F,t),n(e,O,t),h(J,e,t),n(e,K,t),h(f,e,t),n(e,ee,t),n(e,g,t),n(e,te,t),n(e,u,t),n(e,se,t),n(e,U,t),n(e,ne,t),n(e,j,t),n(e,le,t),n(e,b,t),n(e,ae,t),n(e,T,t),n(e,ie,t),n(e,w,t),n(e,re,t),h(v,e,t),n(e,oe,t),h(k,e,t),n(e,pe,t),n(e,I,t),n(e,ce,t),h(x,e,t),n(e,he,t),n(e,B,t),n(e,me,t),h(R,e,t),n(e,de,t),n(e,Z,t),n(e,ye,t),h(C,e,t),n(e,Me,t),h(G,e,t),n(e,ue,t),n(e,$,t),n(e,Te,t),h(S,e,t),n(e,we,t),h(V,e,t),n(e,Je,t),n(e,H,t),n(e,fe,t),n(e,E,t),n(e,ge,t),n(e,W,t),n(e,Ue,t),h(N,e,t),n(e,je,t),h(_,e,t),n(e,be,t),n(e,z,t),n(e,ve,t),n(e,Q,t),n(e,ke,t),n(e,Y,t),n(e,Ie,t),n(e,X,t),n(e,xe,t),n(e,q,t),Be=!0},p:Ae,i(e){Be||(m(J.$$.fragment,e),m(f.$$.fragment,e),m(v.$$.fragment,e),m(k.$$.fragment,e),m(x.$$.fragment,e),m(R.$$.fragment,e),m(C.$$.fragment,e),m(G.$$.fragment,e),m(S.$$.fragment,e),m(V.$$.fragment,e),m(N.$$.fragment,e),m(_.$$.fragment,e),Be=!0)},o(e){d(J.$$.fragment,e),d(f.$$.fragment,e),d(v.$$.fragment,e),d(k.$$.fragment,e),d(x.$$.fragment,e),d(R.$$.fragment,e),d(C.$$.fragment,e),d(G.$$.fragment,e),d(S.$$.fragment,e),d(V.$$.fragment,e),d(N.$$.fragment,e),d(_.$$.fragment,e),Be=!1},d(e){e&&(s(A),s(F),s(O),s(K),s(ee),s(g),s(te),s(u),s(se),s(U),s(ne),s(j),s(le),s(b),s(ae),s(T),s(ie),s(w),s(re),s(oe),s(pe),s(I),s(ce),s(he),s(B),s(me),s(de),s(Z),s(ye),s(Me),s(ue),s($),s(Te),s(we),s(Je),s(H),s(fe),s(E),s(ge),s(W),s(Ue),s(je),s(be),s(z),s(ve),s(Q),s(ke),s(Y),s(Ie),s(X),s(xe),s(q)),s(M),y(J,e),y(f,e),y(v,e),y(k,e),y(x,e),y(R,e),y(C,e),y(G,e),y(S,e),y(V,e),y(N,e),y(_,e)}}}const lt='{"title":"Streaming","local":"streaming","sections":[{"title":"What is Streaming?","local":"what-is-streaming","sections":[],"depth":2},{"title":"How to use Streaming?","local":"how-to-use-streaming","sections":[{"title":"Streaming with Python","local":"streaming-with-python","sections":[],"depth":3},{"title":"Streaming with cURL","local":"streaming-with-curl","sections":[],"depth":3},{"title":"Streaming with JavaScript","local":"streaming-with-javascript","sections":[],"depth":3}],"depth":2},{"title":"How does Streaming work under the hood?","local":"how-does-streaming-work-under-the-hood","sections":[],"depth":2}],"depth":1}';function at(Re){return Oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ct extends Ke{constructor(M){super(),et(this,M,at,nt,Pe,{})}}export{ct as component};
