import{s as fs,n as Is,o as Cs}from"../chunks/scheduler.85c25b89.js";import{S as Zs,i as Ws,g as p,s as a,r as i,A as $s,h as m,f as l,c as n,j as bs,u as o,x as h,k as Us,y as ks,a as e,v as r,d as M,t as c,w as J}from"../chunks/index.c9bcf812.js";import{C as A}from"../chunks/CodeBlock.94efc595.js";import{H as v}from"../chunks/Heading.3c6e5b17.js";function Bs(Ms){let w,S,Q,Y,T,H,j,cs='<strong>Residual Networks</strong>, or <strong>ResNets</strong>, learn residual functions with reference to the layer inputs, instead of learning unreferenced functions. Instead of hoping each few stacked layers directly fit a desired underlying mapping, residual nets let these layers fit a residual mapping. They stack <a href="https://paperswithcode.com/method/residual-block" rel="nofollow">residual blocks</a> ontop of each other to form network: e.g. a ResNet-50 has fifty layers using these blocks.',_,y,z,g,Js="To load a pretrained model:",X,d,F,u,hs="To load and preprocess the image:",D,b,L,U,ws="To get the model predictions:",q,f,P,I,Ts="To get the top-5 predictions class names:",K,C,O,Z,js="Replace the model name with the variant you want to use, e.g. <code>resnet18</code>. You can find the IDs in the model summaries at the top of this page.",ss,W,ys='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ts,$,ls,k,gs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",es,B,as,R,ds=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ns,x,ps,E,us='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ms,N,is,G,os,V,rs;return T=new v({props:{title:"ResNet",local:"resnet",headingTag:"h1"}}),y=new v({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),d=new A({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldDE4JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new A({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),f=new A({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new A({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),$=new v({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new A({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzbmV0MTgnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new v({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),N=new v({props:{title:"Citation",local:"citation",headingTag:"h2"}}),G=new A({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZIZVpSUzE1JTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCS2FpbWluZyUyMEhlJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwWGlhbmd5dSUyMFpoYW5nJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwU2hhb3FpbmclMjBSZW4lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBKaWFuJTIwU3VuJTdEJTJDJTBBJTIwJTIwdGl0bGUlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JEZWVwJTIwUmVzaWR1YWwlMjBMZWFybmluZyUyMGZvciUyMEltYWdlJTIwUmVjb2duaXRpb24lN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE1MTIuMDMzODUlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxNSU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxNTEyLjAzMzg1JTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTUxMi4wMzM4NSU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3QldlZCUyQyUyMDE3JTIwQXByJTIwMjAxOSUyMDE3JTNBMjMlM0E0NSUyMCUyQjAyMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGSGVaUlMxNS5iaWIlN0QlMkMlMEElMjAlMjBiaWJzb3VyY2UlMjAlM0QlMjAlN0JkYmxwJTIwY29tcHV0ZXIlMjBzY2llbmNlJTIwYmlibGlvZ3JhcGh5JTJDJTIwaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyU3RCUwQSU3RA==",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>HeZRS15,
  author    = {Kaiming He and
               Xiangyu Zhang and
               Shaoqing Ren and
               Jian Sun},
  title     = {Deep Residual Learning <span class="hljs-keyword">for</span> Image Recognition},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1512.03385</span>},
  year      = {<span class="hljs-number">2015</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1512.03385</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1512.03385</span>},
  timestamp = {Wed, <span class="hljs-number">17</span> Apr <span class="hljs-number">2019</span> <span class="hljs-number">17</span>:<span class="hljs-number">23</span>:<span class="hljs-number">45</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>HeZRS15.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),{c(){w=p("meta"),S=a(),Q=p("p"),Y=a(),i(T.$$.fragment),H=a(),j=p("p"),j.innerHTML=cs,_=a(),i(y.$$.fragment),z=a(),g=p("p"),g.textContent=Js,X=a(),i(d.$$.fragment),F=a(),u=p("p"),u.textContent=hs,D=a(),i(b.$$.fragment),L=a(),U=p("p"),U.textContent=ws,q=a(),i(f.$$.fragment),P=a(),I=p("p"),I.textContent=Ts,K=a(),i(C.$$.fragment),O=a(),Z=p("p"),Z.innerHTML=js,ss=a(),W=p("p"),W.innerHTML=ys,ts=a(),i($.$$.fragment),ls=a(),k=p("p"),k.textContent=gs,es=a(),i(B.$$.fragment),as=a(),R=p("p"),R.innerHTML=ds,ns=a(),i(x.$$.fragment),ps=a(),E=p("p"),E.innerHTML=us,ms=a(),i(N.$$.fragment),is=a(),i(G.$$.fragment),os=a(),V=p("p"),this.h()},l(s){const t=$s("svelte-u9bgzb",document.head);w=m(t,"META",{name:!0,content:!0}),t.forEach(l),S=n(s),Q=m(s,"P",{}),bs(Q).forEach(l),Y=n(s),o(T.$$.fragment,s),H=n(s),j=m(s,"P",{"data-svelte-h":!0}),h(j)!=="svelte-p6ybkz"&&(j.innerHTML=cs),_=n(s),o(y.$$.fragment,s),z=n(s),g=m(s,"P",{"data-svelte-h":!0}),h(g)!=="svelte-18ywhxh"&&(g.textContent=Js),X=n(s),o(d.$$.fragment,s),F=n(s),u=m(s,"P",{"data-svelte-h":!0}),h(u)!=="svelte-1c2ipa8"&&(u.textContent=hs),D=n(s),o(b.$$.fragment,s),L=n(s),U=m(s,"P",{"data-svelte-h":!0}),h(U)!=="svelte-1n9qsq1"&&(U.textContent=ws),q=n(s),o(f.$$.fragment,s),P=n(s),I=m(s,"P",{"data-svelte-h":!0}),h(I)!=="svelte-19cnvx1"&&(I.textContent=Ts),K=n(s),o(C.$$.fragment,s),O=n(s),Z=m(s,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-f9b41k"&&(Z.innerHTML=js),ss=n(s),W=m(s,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1wmi3ea"&&(W.innerHTML=ys),ts=n(s),o($.$$.fragment,s),ls=n(s),k=m(s,"P",{"data-svelte-h":!0}),h(k)!=="svelte-9sr7nh"&&(k.textContent=gs),es=n(s),o(B.$$.fragment,s),as=n(s),R=m(s,"P",{"data-svelte-h":!0}),h(R)!=="svelte-1kguc51"&&(R.innerHTML=ds),ns=n(s),o(x.$$.fragment,s),ps=n(s),E=m(s,"P",{"data-svelte-h":!0}),h(E)!=="svelte-1n0coha"&&(E.innerHTML=us),ms=n(s),o(N.$$.fragment,s),is=n(s),o(G.$$.fragment,s),os=n(s),V=m(s,"P",{}),bs(V).forEach(l),this.h()},h(){Us(w,"name","hf:doc:metadata"),Us(w,"content",Rs)},m(s,t){ks(document.head,w),e(s,S,t),e(s,Q,t),e(s,Y,t),r(T,s,t),e(s,H,t),e(s,j,t),e(s,_,t),r(y,s,t),e(s,z,t),e(s,g,t),e(s,X,t),r(d,s,t),e(s,F,t),e(s,u,t),e(s,D,t),r(b,s,t),e(s,L,t),e(s,U,t),e(s,q,t),r(f,s,t),e(s,P,t),e(s,I,t),e(s,K,t),r(C,s,t),e(s,O,t),e(s,Z,t),e(s,ss,t),e(s,W,t),e(s,ts,t),r($,s,t),e(s,ls,t),e(s,k,t),e(s,es,t),r(B,s,t),e(s,as,t),e(s,R,t),e(s,ns,t),r(x,s,t),e(s,ps,t),e(s,E,t),e(s,ms,t),r(N,s,t),e(s,is,t),r(G,s,t),e(s,os,t),e(s,V,t),rs=!0},p:Is,i(s){rs||(M(T.$$.fragment,s),M(y.$$.fragment,s),M(d.$$.fragment,s),M(b.$$.fragment,s),M(f.$$.fragment,s),M(C.$$.fragment,s),M($.$$.fragment,s),M(B.$$.fragment,s),M(x.$$.fragment,s),M(N.$$.fragment,s),M(G.$$.fragment,s),rs=!0)},o(s){c(T.$$.fragment,s),c(y.$$.fragment,s),c(d.$$.fragment,s),c(b.$$.fragment,s),c(f.$$.fragment,s),c(C.$$.fragment,s),c($.$$.fragment,s),c(B.$$.fragment,s),c(x.$$.fragment,s),c(N.$$.fragment,s),c(G.$$.fragment,s),rs=!1},d(s){s&&(l(S),l(Q),l(Y),l(H),l(j),l(_),l(z),l(g),l(X),l(F),l(u),l(D),l(L),l(U),l(q),l(P),l(I),l(K),l(O),l(Z),l(ss),l(W),l(ts),l(ls),l(k),l(es),l(as),l(R),l(ns),l(ps),l(E),l(ms),l(is),l(os),l(V)),l(w),J(T,s),J(y,s),J(d,s),J(b,s),J(f,s),J(C,s),J($,s),J(B,s),J(x,s),J(N,s),J(G,s)}}}const Rs='{"title":"ResNet","local":"resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function xs(Ms){return Cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qs extends Zs{constructor(w){super(),Ws(this,w,xs,Bs,fs,{})}}export{Qs as component};
