import{s as Jm,n as Ym,o as es}from"../chunks/scheduler.85c25b89.js";import{S as ts,i as as,g as a,s as o,r as d,A as rs,h as r,f as i,c as n,j as l,u as c,x as m,k as v,y as t,a as p,v as g,d as u,t as f,w as h}from"../chunks/index.c9837788.js";import{D as b}from"../chunks/Docstring.5c1d567f.js";import{H as Q,E as os}from"../chunks/EditOnGithub.b65eee75.js";function ns(di){let j,gr,Ya,ur,be,fr,_e,ci="This page contains the API reference documentation for learning rate optimizers included in <code>timm</code>.",hr,xe,vr,ye,br,_,$e,ho,Lt,gi="Create an optimizer instance via timm registry.",vo,At,ui=`Creates and configures an optimizer with appropriate parameter groups and settings.
Supports automatic parameter group creation for weight decay and layer-wise learning
rates, as well as custom parameter grouping.`,bo,Tt,fi="Examples:",_o,er,tr,we,Ce,xo,zt,hi="optimizer = create_optimizer_v2(model, ‘adamw’, lr=1e-3)",yo,ar,rr,Le,Ae,$o,Dt,vi=`optimizer = create_optimizer_v2(
…     model, ‘sgd’, lr=0.1, momentum=0.9, weight_decay=1e-4
… )`,wo,or,nr,Te,ze,Co,Pt,bi=`optimizer = create_optimizer_v2(
…     model, ‘adam’, lr=1e-3, layer_decay=0.7
… )`,Lo,ir,mr,De,Pe,Ao,Mt,_i=`def group_fn(model):
…     return [
…         {‘params’: model.backbone.parameters(), ‘lr’: 1e-4},
…         {‘params’: model.head.parameters(), ‘lr’: 1e-3}
…     ]
optimizer = create_optimizer_v2(
…     model, ‘sgd’, param_group_fn=group_fn
… )`,To,kt,xi=`Note:
Parameter group handling precedence:`,zo,qt,yi="<li>If param_group_fn is provided, it will be used exclusively</li> <li>If layer_decay is provided, layer-wise groups will be created</li> <li>If weight_decay &gt; 0 and filter_bias_and_bn is True, weight decay groups will be created</li> <li>Otherwise, all parameters will be in a single group</li>",_r,x,Me,Do,Et,$i="List available optimizer names, optionally filtered.",Po,Ot,wi=`List all registered optimizers, with optional filtering using wildcard patterns.
Optimizers can be filtered using include and exclude patterns, and can optionally
return descriptions with each optimizer name.`,Mo,Nt,Ci="Examples:",ko,It,Li=`<blockquote><blockquote><p>list_optimizers()
[‘adam’, ‘adamw’, ‘sgd’, …]</p></blockquote></blockquote>`,qo,Ft,Ai=`<blockquote><blockquote><p>list_optimizers([‘la<em>’, ‘nla</em>’])  # List lamb &amp; lars
[‘lamb’, ‘lambc’, ‘larc’, ‘lars’, ‘nlarc’, ‘nlars’]</p></blockquote></blockquote>`,Eo,Ht,Ti=`<blockquote><blockquote><p>list_optimizers(’<em>adam</em>’, exclude_filters=[‘bnb<em>’, ‘fused</em>’])  # Exclude bnb &amp; apex adam optimizers
[‘adam’, ‘adamax’, ‘adamp’, ‘adamw’, ‘nadam’, ‘nadamw’, ‘radam’]</p></blockquote></blockquote>`,Oo,Bt,zi=`<blockquote><blockquote><p>list_optimizers(with_description=True)  # Get descriptions
[(‘adabelief’, ‘Adapts learning rate based on gradient prediction error’),
(‘adadelta’, ‘torch.optim Adadelta, Adapts learning rates based on running windows of gradients’),
(‘adafactor’, ‘Memory-efficient implementation of Adam with factored gradients’),
…]</p></blockquote></blockquote>`,xr,C,ke,No,Gt,Di="Get optimizer class by name with option to bind default arguments.",Io,Rt,Pi=`Retrieves the optimizer class or a partial function with default arguments bound.
This allows direct instantiation of optimizers with their default configurations
without going through the full factory.`,Fo,St,Mi="Examples:",Ho,sr,lr,qe,Ee,Bo,Vt,ki=`SGD = get_optimizer_class(‘sgd’)  # nesterov=True bound
opt = SGD(model.parameters(), lr=0.1, momentum=0.9)`,Go,pr,dr,Oe,Ne,Ro,Wt,qi=`SGD = get_optimizer_class(‘sgd’)
opt = SGD(model.parameters(), lr=1e-3, momentum=0.9)`,yr,Ie,$r,L,Fe,So,Ut,Ei="Implements AdaBelief algorithm. Modified from Adam in PyTorch",Vo,Qt,Oi="reference: AdaBelief Optimizer, adapting stepsizes by the belief in observed gradients, NeurIPS 2020",Wo,jt,Ni=`For a complete table of recommended hyperparameters, see <a href="https://github.com/juntang-zhuang/Adabelief-Optimizer&#39;" rel="nofollow">https://github.com/juntang-zhuang/Adabelief-Optimizer’</a>
For example train/args for EfficientNet see these gists`,Uo,Kt,Ii='<li>link to train_scipt: <a href="https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037" rel="nofollow">https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037</a></li> <li>link to args.yaml: <a href="https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3" rel="nofollow">https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3</a></li>',Qo,Z,He,jo,Zt,Fi="Performs a single optimization step.",wr,A,Be,Ko,Xt,Hi="Implements Adafactor algorithm.",Zo,Jt,Bi=`This implementation is based on: <code>Adafactor: Adaptive Learning Rates with Sublinear Memory Cost</code>
(see <a href="https://arxiv.org/abs/1804.04235" rel="nofollow">https://arxiv.org/abs/1804.04235</a>)`,Xo,Yt,Gi=`Note that this optimizer internally adjusts the learning rate depending on the
<em>scale_parameter</em>, <em>relative_step</em> and <em>warmup_init</em> options.`,Jo,ea,Ri=`To use a manual (external) learning rate schedule you should set <code>scale_parameter=False</code> and
<code>relative_step=False</code>.`,Yo,X,Ge,en,ta,Si="Performs a single optimization step.",Cr,G,Re,tn,aa,Vi="PyTorch implementation of BigVision’s Adafactor variant with both single and multi tensor implementations.",an,ra,Wi='Adapted from <a href="https://github.com/google-research/big_vision" rel="nofollow">https://github.com/google-research/big_vision</a> by Ross Wightman',Lr,T,Se,rn,oa,Ui="Implements the AdaHessian algorithm from “ADAHESSIAN: An Adaptive Second OrderOptimizer for Machine Learning”",on,J,Ve,nn,na,Qi="Gets all parameters in all param_groups with gradients",mn,Y,We,sn,ia,ji="Computes the Hutchinson approximation of the hessian trace and accumulates it for each trainable parameter.",ln,ee,Ue,pn,ma,Ki="Performs a single optimization step.",dn,te,Qe,cn,sa,Zi="Zeros out the accumalated hessian traces.",Ar,je,Ke,Tr,q,Ze,gn,la,Xi="Implements a pytorch variant of Adan.",un,pa,Ji=`Adan was proposed in Adan: Adaptive Nesterov Momentum Algorithm for Faster Optimizing Deep Models
<a href="https://arxiv.org/abs/2208.06677" rel="nofollow">https://arxiv.org/abs/2208.06677</a>`,fn,ae,Xe,hn,da,Yi="Performs a single optimization step.",zr,R,Je,vn,ca,em='ADOPT: Modified Adam Can Converge with Any β2 with the Optimal Rate: <a href="https://arxiv.org/abs/2411.02853" rel="nofollow">https://arxiv.org/abs/2411.02853</a>',bn,re,Ye,_n,ga,tm="Perform a single optimization step.",Dr,P,et,xn,ua,am=`Implements a pure pytorch variant of FuseLAMB (NvLamb variant) optimizer from apex.optimizers.FusedLAMB
reference: <a href="https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py" rel="nofollow">https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py</a>`,yn,fa,rm="LAMB was proposed in <code>Large Batch Optimization for Deep Learning: Training BERT in 76 minutes</code>_.",$n,ha,om=`.. _Large Batch Optimization for Deep Learning - Training BERT in 76 minutes:
<a href="https://arxiv.org/abs/1904.00962" rel="nofollow">https://arxiv.org/abs/1904.00962</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,wn,oe,tt,Cn,va,nm="Performs a single optimization step.",Pr,E,at,Ln,ba,im="LaProp Optimizer",An,_a,mm='Paper: LaProp: Separating Momentum and Adaptivity in Adam, <a href="https://arxiv.org/abs/2002.04839" rel="nofollow">https://arxiv.org/abs/2002.04839</a>',Tn,ne,rt,zn,xa,sm="Performs a single optimization step.",Mr,O,ot,Dn,ya,lm="LARS for PyTorch",Pn,$a,pm='Paper: <code>Large batch training of Convolutional Networks</code> - <a href="https://arxiv.org/pdf/1708.03888.pdf" rel="nofollow">https://arxiv.org/pdf/1708.03888.pdf</a>',Mn,ie,nt,kn,wa,dm="Performs a single optimization step.",kr,S,it,qn,Ca,cm="Implements Lion algorithm.",En,me,mt,On,La,gm="Performs a single optimization step.",qr,st,lt,Er,w,pt,Nn,Aa,um=`MADGRAD_: A Momentumized, Adaptive, Dual Averaged Gradient Method for Stochastic
Optimization.`,In,Ta,fm='.. _MADGRAD: <a href="https://arxiv.org/abs/2101.11075" rel="nofollow">https://arxiv.org/abs/2101.11075</a>',Fn,za,hm=`MADGRAD is a general purpose optimizer that can be used in place of SGD or
Adam may converge faster and generalize better. Currently GPU-only.
Typically, the same learning rate schedule that is used for SGD or Adam may
be used. The overall learning rate is not comparable to either method and
should be determined by a hyper-parameter sweep.`,Hn,Da,vm=`MADGRAD requires less weight decay than other methods, often as little as
zero. Momentum values used for SGD or Adam’s beta1 should work here also.`,Bn,Pa,bm="On sparse problems both weight_decay and momentum should be set to 0.",Gn,se,dt,Rn,Ma,_m="Performs a single optimization step.",Or,N,ct,Sn,ka,xm="MARS Optimizer",Vn,qa,ym=`Paper: MARS: Unleashing the Power of Variance Reduction for Training Large Models
<a href="https://arxiv.org/abs/2411.10438" rel="nofollow">https://arxiv.org/abs/2411.10438</a>`,Wn,le,gt,Un,Ea,$m="Performs a single optimization step.",Nr,M,ut,Qn,Oa,wm="Implements NAdamW algorithm.",jn,Na,Cm=`See Table 1 in <a href="https://arxiv.org/abs/1910.05446" rel="nofollow">https://arxiv.org/abs/1910.05446</a> for the implementation of
the NAdam algorithm (there is also a comment in the code which highlights
the only difference of NAdamW and AdamW).
For further details regarding the algorithm we refer to
<code>Decoupled Weight Decay Regularization</code>_.`,Kn,Ia,Lm=`.. _Decoupled Weight Decay Regularization:
<a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,Zn,pe,ft,Xn,Fa,Am="Performs a single optimization step.",Ir,V,ht,Jn,Ha,Tm="Implements Novograd algorithm.",Yn,de,vt,ei,Ba,zm="Performs a single optimization step.",Fr,y,bt,ti,Ga,Dm="Implements RMSprop algorithm (TensorFlow style epsilon)",ai,Ra,Pm=`NOTE: This is a direct cut-and-paste of PyTorch RMSprop with eps applied before sqrt
and a few other modifications to closer match Tensorflow for matching hyper-params.`,ri,Sa,Mm="Noteworthy changes include:",oi,Va,km="<li>Epsilon applied inside square-root</li> <li>square_avg initialized to ones</li> <li>LR scaling of update accumulated in momentum buffer</li>",ni,Wa,qm=`Proposed by G. Hinton in his
<a href="http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf" rel="nofollow">course</a>.`,ii,Ua,Em=`The centered version first appears in <a href="https://arxiv.org/pdf/1308.0850v5.pdf" rel="nofollow">Generating Sequences
With Recurrent Neural Networks</a>.`,mi,ce,_t,si,Qa,Om="Performs a single optimization step.",Hr,xt,yt,Br,K,$t,li,ge,wt,pi,ja,Nm="Performs a single optimization step.",Gr,Ct,Rr,cr,Sr;return be=new Q({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),xe=new Q({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),ye=new Q({props:{title:"Factory functions",local:"timm.optim.create_optimizer_v2",headingTag:"h3"}}),$e=new b({props:{name:"timm.optim.create_optimizer_v2",anchor:"timm.optim.create_optimizer_v2",parameters:[{name:"model_or_params",val:": typing.Union[torch.nn.modules.module.Module, typing.Iterator[torch.nn.parameter.Parameter], typing.Iterator[typing.Dict[str, typing.Any]]]"},{name:"opt",val:": str = 'sgd'"},{name:"lr",val:": typing.Optional[float] = None"},{name:"weight_decay",val:": float = 0.0"},{name:"momentum",val:": float = 0.9"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"filter_bias_and_bn",val:": bool = True"},{name:"layer_decay",val:": typing.Optional[float] = None"},{name:"param_group_fn",val:": typing.Optional[typing.Callable[[torch.nn.modules.module.Module], typing.Union[typing.Iterator[torch.nn.parameter.Parameter], typing.Iterator[typing.Dict[str, typing.Any]]]]] = None"},{name:"**kwargs",val:": typing.Any"}],parametersDescription:[{anchor:"timm.optim.create_optimizer_v2.model_or_params",description:`<strong>model_or_params</strong> &#x2014; A PyTorch model or an iterable of parameters/parameter groups.
If a model is provided, parameters will be automatically extracted and grouped
based on the other arguments.`,name:"model_or_params"},{anchor:"timm.optim.create_optimizer_v2.opt",description:`<strong>opt</strong> &#x2014; Name of the optimizer to create (e.g., &#x2018;adam&#x2019;, &#x2018;adamw&#x2019;, &#x2018;sgd&#x2019;).
Use list_optimizers() to see available options.`,name:"opt"},{anchor:"timm.optim.create_optimizer_v2.lr",description:"<strong>lr</strong> &#x2014; Learning rate. If None, will use the optimizer&#x2019;s default.",name:"lr"},{anchor:"timm.optim.create_optimizer_v2.weight_decay",description:"<strong>weight_decay</strong> &#x2014; Weight decay factor. Will be used to create param groups if model_or_params is a model.",name:"weight_decay"},{anchor:"timm.optim.create_optimizer_v2.momentum",description:`<strong>momentum</strong> &#x2014; Momentum factor for optimizers that support it. Only used if the
chosen optimizer accepts a momentum parameter.`,name:"momentum"},{anchor:"timm.optim.create_optimizer_v2.foreach",description:`<strong>foreach</strong> &#x2014; Enable/disable foreach (multi-tensor) implementation if available.
If None, will use optimizer-specific defaults.`,name:"foreach"},{anchor:"timm.optim.create_optimizer_v2.filter_bias_and_bn",description:`<strong>filter_bias_and_bn</strong> &#x2014; If True, bias, norm layer parameters (all 1d params) will not have
weight decay applied. Only used when model_or_params is a model and
weight_decay &gt; 0.`,name:"filter_bias_and_bn"},{anchor:"timm.optim.create_optimizer_v2.layer_decay",description:`<strong>layer_decay</strong> &#x2014; Optional layer-wise learning rate decay factor. If provided,
learning rates will be scaled by layer_decay^(max_depth - layer_depth).
Only used when model_or_params is a model.`,name:"layer_decay"},{anchor:"timm.optim.create_optimizer_v2.param_group_fn",description:`<strong>param_group_fn</strong> &#x2014; Optional function to create custom parameter groups.
If provided, other parameter grouping options will be ignored.`,name:"param_group_fn"},{anchor:"timm.optim.create_optimizer_v2.*kwargs",description:"*<strong>*kwargs</strong> &#x2014; Additional optimizer-specific arguments (e.g., betas for Adam).",name:"*kwargs"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/_optim_factory.py#L876",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Configured optimizer instance.</p>
`}}),Ce=new Q({props:{title:"Basic usage with a model",local:"basic-usage-with-a-model",headingTag:"h1"}}),Ae=new Q({props:{title:"SGD with momentum and weight decay",local:"sgd-with-momentum-and-weight-decay",headingTag:"h1"}}),ze=new Q({props:{title:"Adam with layer-wise learning rate decay",local:"adam-with-layer-wise-learning-rate-decay",headingTag:"h1"}}),Pe=new Q({props:{title:"Custom parameter groups",local:"custom-parameter-groups",headingTag:"h1"}}),Me=new b({props:{name:"timm.optim.list_optimizers",anchor:"timm.optim.list_optimizers",parameters:[{name:"filter",val:": typing.Union[str, typing.List[str]] = ''"},{name:"exclude_filters",val:": typing.Optional[typing.List[str]] = None"},{name:"with_description",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.list_optimizers.filter",description:`<strong>filter</strong> &#x2014; Wildcard style filter string or list of filter strings
(e.g., &#x2018;adam<em>&#x2019; for all Adam variants, or [&#x2018;adam</em>&#x2019;, &#x2018;*8bit&#x2019;] for
Adam variants and 8-bit optimizers). Empty string means no filtering.`,name:"filter"},{anchor:"timm.optim.list_optimizers.exclude_filters",description:`<strong>exclude_filters</strong> &#x2014; Optional list of wildcard patterns to exclude. For example,
[&#x2019;<em>8bit&#x2019;, &#x2018;fused</em>&#x2019;] would exclude 8-bit and fused implementations.`,name:"exclude_filters"},{anchor:"timm.optim.list_optimizers.with_description",description:`<strong>with_description</strong> &#x2014; If True, returns tuples of (name, description) instead of
just names. Descriptions provide brief explanations of optimizer characteristics.`,name:"with_description"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/_optim_factory.py#L779",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of optimizer names as strings (e.g., [‘adam’, ‘adamw’, …])
If with_description is True:
List of tuples of (name, description) (e.g., [(‘adam’, ‘Adaptive Moment…’), …])</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If with_description is False</p>
`}}),ke=new b({props:{name:"timm.optim.get_optimizer_class",anchor:"timm.optim.get_optimizer_class",parameters:[{name:"name",val:": str"},{name:"bind_defaults",val:": bool = True"}],parametersDescription:[{anchor:"timm.optim.get_optimizer_class.name",description:"<strong>name</strong> &#x2014; Name of the optimizer to retrieve (e.g., &#x2018;adam&#x2019;, &#x2018;sgd&#x2019;)",name:"name"},{anchor:"timm.optim.get_optimizer_class.bind_defaults",description:`<strong>bind_defaults</strong> &#x2014; If True, returns a partial function with default arguments from OptimInfo bound.
If False, returns the raw optimizer class.`,name:"bind_defaults"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/_optim_factory.py#L839",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The optimizer class (e.g., torch.optim.Adam)
If bind_defaults is True:
A partial function with default arguments bound</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If bind_defaults is False</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If optimizer name is not found in registry</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),Ee=new Q({props:{title:"Get SGD with nesterov momentum default",local:"get-sgd-with-nesterov-momentum-default",headingTag:"h1"}}),Ne=new Q({props:{title:"Get raw optimizer class",local:"get-raw-optimizer-class",headingTag:"h1"}}),Ie=new Q({props:{title:"Optimizer Classes",local:"timm.optim.AdaBelief",headingTag:"h3"}}),Fe=new b({props:{name:"class timm.optim.AdaBelief",anchor:"timm.optim.AdaBelief",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-16"},{name:"weight_decay",val:" = 0"},{name:"amsgrad",val:" = False"},{name:"decoupled_decay",val:" = True"},{name:"fixed_decay",val:" = False"},{name:"rectify",val:" = True"},{name:"degenerated_to_sgd",val:" = True"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdaBelief.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdaBelief.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdaBelief.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-16)`,name:"eps"},{anchor:"timm.optim.AdaBelief.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.AdaBelief.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"},{anchor:"timm.optim.AdaBelief.decoupled_decay",description:`<strong>decoupled_decay</strong> (boolean, optional) &#x2014; (default: True) If set as True, then
the optimizer uses decoupled weight decay as in AdamW`,name:"decoupled_decay"},{anchor:"timm.optim.AdaBelief.fixed_decay",description:`<strong>fixed_decay</strong> (boolean, optional) &#x2014; (default: False) This is used when weight<em>decouple
is set as True.
When fixed_decay == True, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay$.
When fixed<em>decay == False, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay \\times lr$. Note that in this case, the
weight decay ratio decreases with learning rate (lr).`,name:"fixed_decay"},{anchor:"timm.optim.AdaBelief.rectify",description:`<strong>rectify</strong> (boolean, optional) &#x2014; (default: True) If set as True, then perform the rectified
update similar to RAdam`,name:"rectify"},{anchor:"timm.optim.AdaBelief.degenerated_to_sgd",description:`<strong>degenerated_to_sgd</strong> (boolean, optional) (default &#x2014;True) If set as True, then perform SGD update
when variance of gradient is high`,name:"degenerated_to_sgd"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adabelief.py#L6"}}),He=new b({props:{name:"step",anchor:"timm.optim.AdaBelief.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adabelief.py#L106"}}),Be=new b({props:{name:"class timm.optim.Adafactor",anchor:"timm.optim.Adafactor",parameters:[{name:"params",val:""},{name:"lr",val:" = None"},{name:"eps",val:" = 1e-30"},{name:"eps_scale",val:" = 0.001"},{name:"clip_threshold",val:" = 1.0"},{name:"decay_rate",val:" = -0.8"},{name:"betas",val:" = None"},{name:"weight_decay",val:" = 0.0"},{name:"scale_parameter",val:" = True"},{name:"warmup_init",val:" = False"},{name:"min_dim_size_to_factor",val:" = 32"}],parametersDescription:[{anchor:"timm.optim.Adafactor.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adafactor.lr",description:"<strong>lr</strong> (float, optional) &#x2014; external learning rate (default: None)",name:"lr"},{anchor:"timm.optim.Adafactor.eps",description:`<strong>eps</strong> (tuple[float, float]) &#x2014; regularization constants for square gradient
and parameter scale respectively (default: (1e-30, 1e-3))`,name:"eps"},{anchor:"timm.optim.Adafactor.clip_threshold",description:"<strong>clip_threshold</strong> (float) &#x2014; threshold of root mean square of final gradient update (default: 1.0)",name:"clip_threshold"},{anchor:"timm.optim.Adafactor.decay_rate",description:"<strong>decay_rate</strong> (float) &#x2014; coefficient used to compute running averages of square gradient (default: -0.8)",name:"decay_rate"},{anchor:"timm.optim.Adafactor.beta1",description:"<strong>beta1</strong> (float) &#x2014; coefficient used for computing running averages of gradient (default: None)",name:"beta1"},{anchor:"timm.optim.Adafactor.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Adafactor.scale_parameter",description:"<strong>scale_parameter</strong> (bool) &#x2014; if True, learning rate is scaled by root mean square of parameter (default: True)",name:"scale_parameter"},{anchor:"timm.optim.Adafactor.warmup_init",description:`<strong>warmup_init</strong> (bool) &#x2014; time-dependent learning rate computation depends on
whether warm-up initialization is being used (default: False)`,name:"warmup_init"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor.py#L17"}}),Ge=new b({props:{name:"step",anchor:"timm.optim.Adafactor.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adafactor.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor.py#L117"}}),Re=new b({props:{name:"class timm.optim.AdafactorBigVision",anchor:"timm.optim.AdafactorBigVision",parameters:[{name:"params",val:""},{name:"lr",val:": float = 1.0"},{name:"min_dim_size_to_factor",val:": int = 32"},{name:"decay_rate",val:": float = 0.8"},{name:"decay_offset",val:": int = 0"},{name:"beta2_cap",val:": float = 0.999"},{name:"momentum",val:": typing.Optional[float] = 0.9"},{name:"momentum_dtype",val:": typing.Union[str, torch.dtype] = torch.bfloat16"},{name:"eps",val:": typing.Optional[float] = None"},{name:"weight_decay",val:": float = 0.0"},{name:"clipping_threshold",val:": typing.Optional[float] = None"},{name:"unscaled_wd",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor_bv.py#L48"}}),Se=new b({props:{name:"class timm.optim.Adahessian",anchor:"timm.optim.Adahessian",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.1"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.0"},{name:"hessian_power",val:" = 1.0"},{name:"update_each",val:" = 1"},{name:"n_samples",val:" = 1"},{name:"avg_conv_kernel",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adahessian.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adahessian.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 0.1)",name:"lr"},{anchor:"timm.optim.Adahessian.betas",description:`<strong>betas</strong> ((float, float), optional) &#x2014; coefficients used for computing running averages of gradient and the
squared hessian trace (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Adahessian.eps",description:"<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve numerical stability (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Adahessian.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0.0)",name:"weight_decay"},{anchor:"timm.optim.Adahessian.hessian_power",description:"<strong>hessian_power</strong> (float, optional) &#x2014; exponent of the hessian trace (default: 1.0)",name:"hessian_power"},{anchor:"timm.optim.Adahessian.update_each",description:`<strong>update_each</strong> (int, optional) &#x2014; compute the hessian trace approximation only after <em>this</em> number of steps
(to save time) (default: 1)`,name:"update_each"},{anchor:"timm.optim.Adahessian.n_samples",description:"<strong>n_samples</strong> (int, optional) &#x2014; how many times to sample <code>z</code> for the approximation of the hessian trace (default: 1)",name:"n_samples"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L9"}}),Ve=new b({props:{name:"get_params",anchor:"timm.optim.Adahessian.get_params",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L74"}}),We=new b({props:{name:"set_hessian",anchor:"timm.optim.Adahessian.set_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L90"}}),Ue=new b({props:{name:"step",anchor:"timm.optim.Adahessian.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adahessian.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; a closure that reevaluates the model and returns the loss (default &#x2014; None)",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L118"}}),Qe=new b({props:{name:"zero_hessian",anchor:"timm.optim.Adahessian.zero_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L81"}}),Ke=new b({props:{name:"class timm.optim.AdamP",anchor:"timm.optim.AdamP",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"},{name:"nesterov",val:" = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adamp.py#L43"}}),Ze=new b({props:{name:"class timm.optim.Adan",anchor:"timm.optim.Adan",parameters:[{name:"params",val:""},{name:"lr",val:": float = 0.001"},{name:"betas",val:": typing.Tuple[float, float, float] = (0.98, 0.92, 0.99)"},{name:"eps",val:": float = 1e-08"},{name:"weight_decay",val:": float = 0.0"},{name:"no_prox",val:": bool = False"},{name:"foreach",val:": bool = True"}],parametersDescription:[{anchor:"timm.optim.Adan.params",description:"<strong>params</strong> &#x2014; Iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Adan.lr",description:"<strong>lr</strong> &#x2014; Learning rate.",name:"lr"},{anchor:"timm.optim.Adan.betas",description:"<strong>betas</strong> &#x2014; Coefficients used for first- and second-order moments.",name:"betas"},{anchor:"timm.optim.Adan.eps",description:"<strong>eps</strong> &#x2014; Term added to the denominator to improve numerical stability.",name:"eps"},{anchor:"timm.optim.Adan.weight_decay",description:"<strong>weight_decay</strong> &#x2014; Decoupled weight decay (L2 penalty)",name:"weight_decay"},{anchor:"timm.optim.Adan.no_prox",description:"<strong>no_prox</strong> &#x2014; How to perform the weight decay",name:"no_prox"},{anchor:"timm.optim.Adan.foreach",description:"<strong>foreach</strong> &#x2014; If True would use torch._foreach implementation. Faster but uses slightly more memory.",name:"foreach"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adan.py#L46"}}),Xe=new b({props:{name:"step",anchor:"timm.optim.Adan.step",parameters:[{name:"closure",val:" = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adan.py#L113"}}),Je=new b({props:{name:"class timm.optim.Adopt",anchor:"timm.optim.Adopt",parameters:[{name:"params",val:""},{name:"lr",val:": typing.Union[float, torch.Tensor] = 0.001"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.9999)"},{name:"eps",val:": float = 1e-06"},{name:"clip_exp",val:": typing.Optional[float] = 0.333"},{name:"weight_decay",val:": float = 0.0"},{name:"decoupled",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"maximize",val:": bool = False"},{name:"capturable",val:": bool = False"},{name:"differentiable",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adopt.py#L56"}}),Ye=new b({props:{name:"step",anchor:"timm.optim.Adopt.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adopt.step.closure",description:`<strong>closure</strong> (Callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adopt.py#L180"}}),et=new b({props:{name:"class timm.optim.Lamb",anchor:"timm.optim.Lamb",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"bias_correction",val:" = True"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-06"},{name:"weight_decay",val:" = 0.01"},{name:"grad_averaging",val:" = True"},{name:"max_grad_norm",val:" = 1.0"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lamb.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lamb.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate. (default: 1e-3)",name:"lr"},{anchor:"timm.optim.Lamb.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its norm. (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Lamb.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability. (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Lamb.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lamb.grad_averaging",description:`<strong>grad_averaging</strong> (bool, optional) &#x2014; whether apply (1-beta2) to grad when
calculating running averages of gradient. (default: True)`,name:"grad_averaging"},{anchor:"timm.optim.Lamb.max_grad_norm",description:"<strong>max_grad_norm</strong> (float, optional) &#x2014; value used to clip global grad norm (default: 1.0)",name:"max_grad_norm"},{anchor:"timm.optim.Lamb.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LAMBC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lamb.always_adapt",description:`<strong>always_adapt</strong> (boolean, optional) &#x2014; Apply adaptive learning rate to 0.0
weight decay parameter (default: False)`,name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lamb.py#L60"}}),tt=new b({props:{name:"step",anchor:"timm.optim.Lamb.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lamb.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lamb.py#L131"}}),at=new b({props:{name:"class timm.optim.LaProp",anchor:"timm.optim.LaProp",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.0004"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-15"},{name:"weight_decay",val:" = 0"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/laprop.py#L19"}}),rt=new b({props:{name:"step",anchor:"timm.optim.LaProp.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.LaProp.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/laprop.py#L48"}}),ot=new b({props:{name:"class timm.optim.Lars",anchor:"timm.optim.Lars",parameters:[{name:"params",val:""},{name:"lr",val:" = 1.0"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"trust_coeff",val:" = 0.001"},{name:"eps",val:" = 1e-08"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lars.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lars.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1.0).",name:"lr"},{anchor:"timm.optim.Lars.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.Lars.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lars.dampening",description:"<strong>dampening</strong> (float, optional) &#x2014; dampening for momentum (default: 0)",name:"dampening"},{anchor:"timm.optim.Lars.nesterov",description:"<strong>nesterov</strong> (bool, optional) &#x2014; enables Nesterov momentum (default: False)",name:"nesterov"},{anchor:"timm.optim.Lars.trust_coeff",description:"<strong>trust_coeff</strong> (float) &#x2014; trust coefficient for computing adaptive lr / trust_ratio (default: 0.001)",name:"trust_coeff"},{anchor:"timm.optim.Lars.eps",description:"<strong>eps</strong> (float) &#x2014; eps for division denominator (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Lars.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LARC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lars.always_adapt",description:"<strong>always_adapt</strong> (bool) &#x2014; always apply LARS LR adapt, otherwise only when group weight_decay != 0 (default: False)",name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lars.py#L17"}}),nt=new b({props:{name:"step",anchor:"timm.optim.Lars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lars.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lars.py#L75"}}),it=new b({props:{name:"class timm.optim.Lion",anchor:"timm.optim.Lion",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.0001"},{name:"betas",val:" = (0.9, 0.99)"},{name:"weight_decay",val:" = 0.0"},{name:"maximize",val:" = False"},{name:"foreach",val:" = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lion.py#L25"}}),mt=new b({props:{name:"step",anchor:"timm.optim.Lion.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lion.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lion.py#L69",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the loss.</p>
`}}),lt=new b({props:{name:"class timm.optim.Lookahead",anchor:"timm.optim.Lookahead",parameters:[{name:"base_optimizer",val:""},{name:"alpha",val:" = 0.5"},{name:"k",val:" = 6"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lookahead.py#L15"}}),pt=new b({props:{name:"class timm.optim.MADGRAD",anchor:"timm.optim.MADGRAD",parameters:[{name:"params",val:": typing.Any"},{name:"lr",val:": float = 0.01"},{name:"momentum",val:": float = 0.9"},{name:"weight_decay",val:": float = 0"},{name:"eps",val:": float = 1e-06"},{name:"decoupled_decay",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.params",description:`<strong>params</strong> (iterable) &#x2014;
Iterable of parameters to optimize or dicts defining parameter groups.`,name:"params"},{anchor:"timm.optim.MADGRAD.lr",description:`<strong>lr</strong> (float) &#x2014;
Learning rate (default: 1e-2).`,name:"lr"},{anchor:"timm.optim.MADGRAD.momentum",description:`<strong>momentum</strong> (float) &#x2014;
Momentum value in  the range [0,1) (default: 0.9).`,name:"momentum"},{anchor:"timm.optim.MADGRAD.weight_decay",description:`<strong>weight_decay</strong> (float) &#x2014;
Weight decay, i.e. a L2 penalty (default: 0).`,name:"weight_decay"},{anchor:"timm.optim.MADGRAD.eps",description:`<strong>eps</strong> (float) &#x2014;
Term added to the denominator outside of the root operation to improve numerical stability. (default: 1e-6).`,name:"eps"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/madgrad.py#L24"}}),dt=new b({props:{name:"step",anchor:"timm.optim.MADGRAD.step",parameters:[{name:"closure",val:": typing.Optional[typing.Callable[[], float]] = None"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/madgrad.py#L90"}}),ct=new b({props:{name:"class timm.optim.Mars",anchor:"timm.optim.Mars",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.003"},{name:"betas",val:" = (0.9, 0.99)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.0"},{name:"gamma",val:" = 0.025"},{name:"mars_type",val:" = 'adamw'"},{name:"optimize_1d",val:" = False"},{name:"lr_1d_factor",val:" = 1.0"},{name:"betas_1d",val:" = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/mars.py#L72"}}),gt=new b({props:{name:"step",anchor:"timm.optim.Mars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Mars.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/mars.py#L115"}}),ut=new b({props:{name:"class timm.optim.NAdamW",anchor:"timm.optim.NAdamW",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.01"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"capturable",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.NAdamW.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.NAdamW.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.NAdamW.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.NAdamW.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.NAdamW.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay coefficient (default: 1e-2)",name:"weight_decay"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nadamw.py#L15"}}),ft=new b({props:{name:"step",anchor:"timm.optim.NAdamW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NAdamW.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nadamw.py#L80"}}),ht=new b({props:{name:"class timm.optim.NvNovoGrad",anchor:"timm.optim.NvNovoGrad",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.95, 0.98)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"grad_averaging",val:" = False"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.NvNovoGrad.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.NvNovoGrad.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.95, 0.98))`,name:"betas"},{anchor:"timm.optim.NvNovoGrad.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.NvNovoGrad.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.NvNovoGrad.grad_averaging",description:"<strong>grad_averaging</strong> &#x2014; gradient averaging",name:"grad_averaging"},{anchor:"timm.optim.NvNovoGrad.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nvnovograd.py#L13"}}),vt=new b({props:{name:"step",anchor:"timm.optim.NvNovoGrad.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model",name:"closure"},{anchor:"timm.optim.NvNovoGrad.step.and",description:"<strong>and</strong> returns the loss. &#x2014;",name:"and"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nvnovograd.py#L66"}}),bt=new b({props:{name:"class timm.optim.RMSpropTF",anchor:"timm.optim.RMSpropTF",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.01"},{name:"alpha",val:" = 0.9"},{name:"eps",val:" = 1e-10"},{name:"weight_decay",val:" = 0"},{name:"momentum",val:" = 0.0"},{name:"centered",val:" = False"},{name:"decoupled_decay",val:" = False"},{name:"lr_in_momentum",val:" = True"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.RMSpropTF.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-2)",name:"lr"},{anchor:"timm.optim.RMSpropTF.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.RMSpropTF.alpha",description:"<strong>alpha</strong> (float, optional) &#x2014; smoothing (decay) constant (default: 0.9)",name:"alpha"},{anchor:"timm.optim.RMSpropTF.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-10)`,name:"eps"},{anchor:"timm.optim.RMSpropTF.centered",description:`<strong>centered</strong> (bool, optional)  &#x2014; if <code>True</code>, compute the centered RMSProp,
the gradient is normalized by an estimation of its variance`,name:"centered"},{anchor:"timm.optim.RMSpropTF.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.RMSpropTF.decoupled_decay",description:'<strong>decoupled_decay</strong> (bool, optional) &#x2014; decoupled weight decay as per <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>',name:"decoupled_decay"},{anchor:"timm.optim.RMSpropTF.lr_in_momentum",description:`<strong>lr_in_momentum</strong> (bool, optional) &#x2014; learning rate scaling is included in the momentum buffer
update as per defaults in Tensorflow`,name:"lr_in_momentum"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/rmsprop_tf.py#L14"}}),_t=new b({props:{name:"step",anchor:"timm.optim.RMSpropTF.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/rmsprop_tf.py#L89"}}),yt=new b({props:{name:"class timm.optim.SGDP",anchor:"timm.optim.SGDP",parameters:[{name:"params",val:""},{name:"lr",val:" = <required parameter>"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"eps",val:" = 1e-08"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/sgdp.py#L19"}}),$t=new b({props:{name:"class timm.optim.SGDW",anchor:"timm.optim.SGDW",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"differentiable",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/sgdw.py#L16"}}),wt=new b({props:{name:"step",anchor:"timm.optim.SGDW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.SGDW.step.closure",description:`<strong>closure</strong> (Callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/sgdw.py#L79"}}),Ct=new os({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/reference/optimizers.mdx"}}),{c(){j=a("meta"),gr=o(),Ya=a("p"),ur=o(),d(be.$$.fragment),fr=o(),_e=a("p"),_e.innerHTML=ci,hr=o(),d(xe.$$.fragment),vr=o(),d(ye.$$.fragment),br=o(),_=a("div"),d($e.$$.fragment),ho=o(),Lt=a("p"),Lt.textContent=gi,vo=o(),At=a("p"),At.textContent=ui,bo=o(),Tt=a("p"),Tt.textContent=fi,_o=o(),er=a("blockquote"),tr=a("blockquote"),we=a("blockquote"),d(Ce.$$.fragment),xo=o(),zt=a("p"),zt.textContent=hi,yo=o(),ar=a("blockquote"),rr=a("blockquote"),Le=a("blockquote"),d(Ae.$$.fragment),$o=o(),Dt=a("p"),Dt.textContent=vi,wo=o(),or=a("blockquote"),nr=a("blockquote"),Te=a("blockquote"),d(ze.$$.fragment),Co=o(),Pt=a("p"),Pt.textContent=bi,Lo=o(),ir=a("blockquote"),mr=a("blockquote"),De=a("blockquote"),d(Pe.$$.fragment),Ao=o(),Mt=a("p"),Mt.textContent=_i,To=o(),kt=a("p"),kt.textContent=xi,zo=o(),qt=a("ol"),qt.innerHTML=yi,_r=o(),x=a("div"),d(Me.$$.fragment),Do=o(),Et=a("p"),Et.textContent=$i,Po=o(),Ot=a("p"),Ot.textContent=wi,Mo=o(),Nt=a("p"),Nt.textContent=Ci,ko=o(),It=a("blockquote"),It.innerHTML=Li,qo=o(),Ft=a("blockquote"),Ft.innerHTML=Ai,Eo=o(),Ht=a("blockquote"),Ht.innerHTML=Ti,Oo=o(),Bt=a("blockquote"),Bt.innerHTML=zi,xr=o(),C=a("div"),d(ke.$$.fragment),No=o(),Gt=a("p"),Gt.textContent=Di,Io=o(),Rt=a("p"),Rt.textContent=Pi,Fo=o(),St=a("p"),St.textContent=Mi,Ho=o(),sr=a("blockquote"),lr=a("blockquote"),qe=a("blockquote"),d(Ee.$$.fragment),Bo=o(),Vt=a("p"),Vt.textContent=ki,Go=o(),pr=a("blockquote"),dr=a("blockquote"),Oe=a("blockquote"),d(Ne.$$.fragment),Ro=o(),Wt=a("p"),Wt.textContent=qi,yr=o(),d(Ie.$$.fragment),$r=o(),L=a("div"),d(Fe.$$.fragment),So=o(),Ut=a("p"),Ut.textContent=Ei,Vo=o(),Qt=a("p"),Qt.textContent=Oi,Wo=o(),jt=a("p"),jt.innerHTML=Ni,Uo=o(),Kt=a("ul"),Kt.innerHTML=Ii,Qo=o(),Z=a("div"),d(He.$$.fragment),jo=o(),Zt=a("p"),Zt.textContent=Fi,wr=o(),A=a("div"),d(Be.$$.fragment),Ko=o(),Xt=a("p"),Xt.textContent=Hi,Zo=o(),Jt=a("p"),Jt.innerHTML=Bi,Xo=o(),Yt=a("p"),Yt.innerHTML=Gi,Jo=o(),ea=a("p"),ea.innerHTML=Ri,Yo=o(),X=a("div"),d(Ge.$$.fragment),en=o(),ta=a("p"),ta.textContent=Si,Cr=o(),G=a("div"),d(Re.$$.fragment),tn=o(),aa=a("p"),aa.textContent=Vi,an=o(),ra=a("p"),ra.innerHTML=Wi,Lr=o(),T=a("div"),d(Se.$$.fragment),rn=o(),oa=a("p"),oa.textContent=Ui,on=o(),J=a("div"),d(Ve.$$.fragment),nn=o(),na=a("p"),na.textContent=Qi,mn=o(),Y=a("div"),d(We.$$.fragment),sn=o(),ia=a("p"),ia.textContent=ji,ln=o(),ee=a("div"),d(Ue.$$.fragment),pn=o(),ma=a("p"),ma.textContent=Ki,dn=o(),te=a("div"),d(Qe.$$.fragment),cn=o(),sa=a("p"),sa.textContent=Zi,Ar=o(),je=a("div"),d(Ke.$$.fragment),Tr=o(),q=a("div"),d(Ze.$$.fragment),gn=o(),la=a("p"),la.textContent=Xi,un=o(),pa=a("p"),pa.innerHTML=Ji,fn=o(),ae=a("div"),d(Xe.$$.fragment),hn=o(),da=a("p"),da.textContent=Yi,zr=o(),R=a("div"),d(Je.$$.fragment),vn=o(),ca=a("p"),ca.innerHTML=em,bn=o(),re=a("div"),d(Ye.$$.fragment),_n=o(),ga=a("p"),ga.textContent=tm,Dr=o(),P=a("div"),d(et.$$.fragment),xn=o(),ua=a("p"),ua.innerHTML=am,yn=o(),fa=a("p"),fa.innerHTML=rm,$n=o(),ha=a("p"),ha.innerHTML=om,wn=o(),oe=a("div"),d(tt.$$.fragment),Cn=o(),va=a("p"),va.textContent=nm,Pr=o(),E=a("div"),d(at.$$.fragment),Ln=o(),ba=a("p"),ba.textContent=im,An=o(),_a=a("p"),_a.innerHTML=mm,Tn=o(),ne=a("div"),d(rt.$$.fragment),zn=o(),xa=a("p"),xa.textContent=sm,Mr=o(),O=a("div"),d(ot.$$.fragment),Dn=o(),ya=a("p"),ya.textContent=lm,Pn=o(),$a=a("p"),$a.innerHTML=pm,Mn=o(),ie=a("div"),d(nt.$$.fragment),kn=o(),wa=a("p"),wa.textContent=dm,kr=o(),S=a("div"),d(it.$$.fragment),qn=o(),Ca=a("p"),Ca.textContent=cm,En=o(),me=a("div"),d(mt.$$.fragment),On=o(),La=a("p"),La.textContent=gm,qr=o(),st=a("div"),d(lt.$$.fragment),Er=o(),w=a("div"),d(pt.$$.fragment),Nn=o(),Aa=a("p"),Aa.textContent=um,In=o(),Ta=a("p"),Ta.innerHTML=fm,Fn=o(),za=a("p"),za.textContent=hm,Hn=o(),Da=a("p"),Da.textContent=vm,Bn=o(),Pa=a("p"),Pa.textContent=bm,Gn=o(),se=a("div"),d(dt.$$.fragment),Rn=o(),Ma=a("p"),Ma.textContent=_m,Or=o(),N=a("div"),d(ct.$$.fragment),Sn=o(),ka=a("p"),ka.textContent=xm,Vn=o(),qa=a("p"),qa.innerHTML=ym,Wn=o(),le=a("div"),d(gt.$$.fragment),Un=o(),Ea=a("p"),Ea.textContent=$m,Nr=o(),M=a("div"),d(ut.$$.fragment),Qn=o(),Oa=a("p"),Oa.textContent=wm,jn=o(),Na=a("p"),Na.innerHTML=Cm,Kn=o(),Ia=a("p"),Ia.innerHTML=Lm,Zn=o(),pe=a("div"),d(ft.$$.fragment),Xn=o(),Fa=a("p"),Fa.textContent=Am,Ir=o(),V=a("div"),d(ht.$$.fragment),Jn=o(),Ha=a("p"),Ha.textContent=Tm,Yn=o(),de=a("div"),d(vt.$$.fragment),ei=o(),Ba=a("p"),Ba.textContent=zm,Fr=o(),y=a("div"),d(bt.$$.fragment),ti=o(),Ga=a("p"),Ga.textContent=Dm,ai=o(),Ra=a("p"),Ra.textContent=Pm,ri=o(),Sa=a("p"),Sa.textContent=Mm,oi=o(),Va=a("ol"),Va.innerHTML=km,ni=o(),Wa=a("p"),Wa.innerHTML=qm,ii=o(),Ua=a("p"),Ua.innerHTML=Em,mi=o(),ce=a("div"),d(_t.$$.fragment),si=o(),Qa=a("p"),Qa.textContent=Om,Hr=o(),xt=a("div"),d(yt.$$.fragment),Br=o(),K=a("div"),d($t.$$.fragment),li=o(),ge=a("div"),d(wt.$$.fragment),pi=o(),ja=a("p"),ja.textContent=Nm,Gr=o(),d(Ct.$$.fragment),Rr=o(),cr=a("p"),this.h()},l(e){const s=rs("svelte-u9bgzb",document.head);j=r(s,"META",{name:!0,content:!0}),s.forEach(i),gr=n(e),Ya=r(e,"P",{}),l(Ya).forEach(i),ur=n(e),c(be.$$.fragment,e),fr=n(e),_e=r(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-1c6qm22"&&(_e.innerHTML=ci),hr=n(e),c(xe.$$.fragment,e),vr=n(e),c(ye.$$.fragment,e),br=n(e),_=r(e,"DIV",{class:!0});var $=l(_);c($e.$$.fragment,$),ho=n($),Lt=r($,"P",{"data-svelte-h":!0}),m(Lt)!=="svelte-1330e7"&&(Lt.textContent=gi),vo=n($),At=r($,"P",{"data-svelte-h":!0}),m(At)!=="svelte-9cjiwr"&&(At.textContent=ui),bo=n($),Tt=r($,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-kvfsh7"&&(Tt.textContent=fi),_o=n($),er=r($,"BLOCKQUOTE",{});var Im=l(er);tr=r(Im,"BLOCKQUOTE",{});var Fm=l(tr);we=r(Fm,"BLOCKQUOTE",{});var Vr=l(we);c(Ce.$$.fragment,Vr),xo=n(Vr),zt=r(Vr,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-180ncmf"&&(zt.textContent=hi),Vr.forEach(i),Fm.forEach(i),Im.forEach(i),yo=n($),ar=r($,"BLOCKQUOTE",{});var Hm=l(ar);rr=r(Hm,"BLOCKQUOTE",{});var Bm=l(rr);Le=r(Bm,"BLOCKQUOTE",{});var Wr=l(Le);c(Ae.$$.fragment,Wr),$o=n(Wr),Dt=r(Wr,"P",{"data-svelte-h":!0}),m(Dt)!=="svelte-6yrpk7"&&(Dt.textContent=vi),Wr.forEach(i),Bm.forEach(i),Hm.forEach(i),wo=n($),or=r($,"BLOCKQUOTE",{});var Gm=l(or);nr=r(Gm,"BLOCKQUOTE",{});var Rm=l(nr);Te=r(Rm,"BLOCKQUOTE",{});var Ur=l(Te);c(ze.$$.fragment,Ur),Co=n(Ur),Pt=r(Ur,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-1vmtu70"&&(Pt.textContent=bi),Ur.forEach(i),Rm.forEach(i),Gm.forEach(i),Lo=n($),ir=r($,"BLOCKQUOTE",{});var Sm=l(ir);mr=r(Sm,"BLOCKQUOTE",{});var Vm=l(mr);De=r(Vm,"BLOCKQUOTE",{});var Qr=l(De);c(Pe.$$.fragment,Qr),Ao=n(Qr),Mt=r(Qr,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-15ovmpe"&&(Mt.textContent=_i),Qr.forEach(i),Vm.forEach(i),Sm.forEach(i),To=n($),kt=r($,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-sgpn75"&&(kt.textContent=xi),zo=n($),qt=r($,"OL",{"data-svelte-h":!0}),m(qt)!=="svelte-psaz57"&&(qt.innerHTML=yi),$.forEach(i),_r=n(e),x=r(e,"DIV",{class:!0});var z=l(x);c(Me.$$.fragment,z),Do=n(z),Et=r(z,"P",{"data-svelte-h":!0}),m(Et)!=="svelte-1h2sspw"&&(Et.textContent=$i),Po=n(z),Ot=r(z,"P",{"data-svelte-h":!0}),m(Ot)!=="svelte-1tapwxe"&&(Ot.textContent=wi),Mo=n(z),Nt=r(z,"P",{"data-svelte-h":!0}),m(Nt)!=="svelte-kvfsh7"&&(Nt.textContent=Ci),ko=n(z),It=r(z,"BLOCKQUOTE",{"data-svelte-h":!0}),m(It)!=="svelte-m875zf"&&(It.innerHTML=Li),qo=n(z),Ft=r(z,"BLOCKQUOTE",{"data-svelte-h":!0}),m(Ft)!=="svelte-1mioyvo"&&(Ft.innerHTML=Ai),Eo=n(z),Ht=r(z,"BLOCKQUOTE",{"data-svelte-h":!0}),m(Ht)!=="svelte-ji9gfr"&&(Ht.innerHTML=Ti),Oo=n(z),Bt=r(z,"BLOCKQUOTE",{"data-svelte-h":!0}),m(Bt)!=="svelte-tvmm3x"&&(Bt.innerHTML=zi),z.forEach(i),xr=n(e),C=r(e,"DIV",{class:!0});var I=l(C);c(ke.$$.fragment,I),No=n(I),Gt=r(I,"P",{"data-svelte-h":!0}),m(Gt)!=="svelte-1rcjgrx"&&(Gt.textContent=Di),Io=n(I),Rt=r(I,"P",{"data-svelte-h":!0}),m(Rt)!=="svelte-13jhmtj"&&(Rt.textContent=Pi),Fo=n(I),St=r(I,"P",{"data-svelte-h":!0}),m(St)!=="svelte-kvfsh7"&&(St.textContent=Mi),Ho=n(I),sr=r(I,"BLOCKQUOTE",{});var Wm=l(sr);lr=r(Wm,"BLOCKQUOTE",{});var Um=l(lr);qe=r(Um,"BLOCKQUOTE",{});var jr=l(qe);c(Ee.$$.fragment,jr),Bo=n(jr),Vt=r(jr,"P",{"data-svelte-h":!0}),m(Vt)!=="svelte-1en25gb"&&(Vt.textContent=ki),jr.forEach(i),Um.forEach(i),Wm.forEach(i),Go=n(I),pr=r(I,"BLOCKQUOTE",{});var Qm=l(pr);dr=r(Qm,"BLOCKQUOTE",{});var jm=l(dr);Oe=r(jm,"BLOCKQUOTE",{});var Kr=l(Oe);c(Ne.$$.fragment,Kr),Ro=n(Kr),Wt=r(Kr,"P",{"data-svelte-h":!0}),m(Wt)!=="svelte-gfx8y2"&&(Wt.textContent=qi),Kr.forEach(i),jm.forEach(i),Qm.forEach(i),I.forEach(i),yr=n(e),c(Ie.$$.fragment,e),$r=n(e),L=r(e,"DIV",{class:!0});var F=l(L);c(Fe.$$.fragment,F),So=n(F),Ut=r(F,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-1hnunr4"&&(Ut.textContent=Ei),Vo=n(F),Qt=r(F,"P",{"data-svelte-h":!0}),m(Qt)!=="svelte-1cjb7xo"&&(Qt.textContent=Oi),Wo=n(F),jt=r(F,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-1347q2l"&&(jt.innerHTML=Ni),Uo=n(F),Kt=r(F,"UL",{"data-svelte-h":!0}),m(Kt)!=="svelte-12x3l9q"&&(Kt.innerHTML=Ii),Qo=n(F),Z=r(F,"DIV",{class:!0});var Zr=l(Z);c(He.$$.fragment,Zr),jo=n(Zr),Zt=r(Zr,"P",{"data-svelte-h":!0}),m(Zt)!=="svelte-1gr03w4"&&(Zt.textContent=Fi),Zr.forEach(i),F.forEach(i),wr=n(e),A=r(e,"DIV",{class:!0});var H=l(A);c(Be.$$.fragment,H),Ko=n(H),Xt=r(H,"P",{"data-svelte-h":!0}),m(Xt)!=="svelte-1j9mkxe"&&(Xt.textContent=Hi),Zo=n(H),Jt=r(H,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-1xvyiun"&&(Jt.innerHTML=Bi),Xo=n(H),Yt=r(H,"P",{"data-svelte-h":!0}),m(Yt)!=="svelte-1i7ubkr"&&(Yt.innerHTML=Gi),Jo=n(H),ea=r(H,"P",{"data-svelte-h":!0}),m(ea)!=="svelte-96f97i"&&(ea.innerHTML=Ri),Yo=n(H),X=r(H,"DIV",{class:!0});var Xr=l(X);c(Ge.$$.fragment,Xr),en=n(Xr),ta=r(Xr,"P",{"data-svelte-h":!0}),m(ta)!=="svelte-1gr03w4"&&(ta.textContent=Si),Xr.forEach(i),H.forEach(i),Cr=n(e),G=r(e,"DIV",{class:!0});var Ka=l(G);c(Re.$$.fragment,Ka),tn=n(Ka),aa=r(Ka,"P",{"data-svelte-h":!0}),m(aa)!=="svelte-19t8yzj"&&(aa.textContent=Vi),an=n(Ka),ra=r(Ka,"P",{"data-svelte-h":!0}),m(ra)!=="svelte-aajaln"&&(ra.innerHTML=Wi),Ka.forEach(i),Lr=n(e),T=r(e,"DIV",{class:!0});var B=l(T);c(Se.$$.fragment,B),rn=n(B),oa=r(B,"P",{"data-svelte-h":!0}),m(oa)!=="svelte-1cuo0rh"&&(oa.textContent=Ui),on=n(B),J=r(B,"DIV",{class:!0});var Jr=l(J);c(Ve.$$.fragment,Jr),nn=n(Jr),na=r(Jr,"P",{"data-svelte-h":!0}),m(na)!=="svelte-1jz1hl7"&&(na.textContent=Qi),Jr.forEach(i),mn=n(B),Y=r(B,"DIV",{class:!0});var Yr=l(Y);c(We.$$.fragment,Yr),sn=n(Yr),ia=r(Yr,"P",{"data-svelte-h":!0}),m(ia)!=="svelte-1y1oyzd"&&(ia.textContent=ji),Yr.forEach(i),ln=n(B),ee=r(B,"DIV",{class:!0});var eo=l(ee);c(Ue.$$.fragment,eo),pn=n(eo),ma=r(eo,"P",{"data-svelte-h":!0}),m(ma)!=="svelte-1gr03w4"&&(ma.textContent=Ki),eo.forEach(i),dn=n(B),te=r(B,"DIV",{class:!0});var to=l(te);c(Qe.$$.fragment,to),cn=n(to),sa=r(to,"P",{"data-svelte-h":!0}),m(sa)!=="svelte-4lvf5h"&&(sa.textContent=Zi),to.forEach(i),B.forEach(i),Ar=n(e),je=r(e,"DIV",{class:!0});var Km=l(je);c(Ke.$$.fragment,Km),Km.forEach(i),Tr=n(e),q=r(e,"DIV",{class:!0});var ue=l(q);c(Ze.$$.fragment,ue),gn=n(ue),la=r(ue,"P",{"data-svelte-h":!0}),m(la)!=="svelte-1vdc41k"&&(la.textContent=Xi),un=n(ue),pa=r(ue,"P",{"data-svelte-h":!0}),m(pa)!=="svelte-1vkysjq"&&(pa.innerHTML=Ji),fn=n(ue),ae=r(ue,"DIV",{class:!0});var ao=l(ae);c(Xe.$$.fragment,ao),hn=n(ao),da=r(ao,"P",{"data-svelte-h":!0}),m(da)!=="svelte-1gr03w4"&&(da.textContent=Yi),ao.forEach(i),ue.forEach(i),zr=n(e),R=r(e,"DIV",{class:!0});var Za=l(R);c(Je.$$.fragment,Za),vn=n(Za),ca=r(Za,"P",{"data-svelte-h":!0}),m(ca)!=="svelte-bxurot"&&(ca.innerHTML=em),bn=n(Za),re=r(Za,"DIV",{class:!0});var ro=l(re);c(Ye.$$.fragment,ro),_n=n(ro),ga=r(ro,"P",{"data-svelte-h":!0}),m(ga)!=="svelte-1siu6mf"&&(ga.textContent=tm),ro.forEach(i),Za.forEach(i),Dr=n(e),P=r(e,"DIV",{class:!0});var W=l(P);c(et.$$.fragment,W),xn=n(W),ua=r(W,"P",{"data-svelte-h":!0}),m(ua)!=="svelte-d5zqgn"&&(ua.innerHTML=am),yn=n(W),fa=r(W,"P",{"data-svelte-h":!0}),m(fa)!=="svelte-1wamkfv"&&(fa.innerHTML=rm),$n=n(W),ha=r(W,"P",{"data-svelte-h":!0}),m(ha)!=="svelte-dty621"&&(ha.innerHTML=om),wn=n(W),oe=r(W,"DIV",{class:!0});var oo=l(oe);c(tt.$$.fragment,oo),Cn=n(oo),va=r(oo,"P",{"data-svelte-h":!0}),m(va)!=="svelte-1gr03w4"&&(va.textContent=nm),oo.forEach(i),W.forEach(i),Pr=n(e),E=r(e,"DIV",{class:!0});var fe=l(E);c(at.$$.fragment,fe),Ln=n(fe),ba=r(fe,"P",{"data-svelte-h":!0}),m(ba)!=="svelte-1ky75u7"&&(ba.textContent=im),An=n(fe),_a=r(fe,"P",{"data-svelte-h":!0}),m(_a)!=="svelte-ee3cwp"&&(_a.innerHTML=mm),Tn=n(fe),ne=r(fe,"DIV",{class:!0});var no=l(ne);c(rt.$$.fragment,no),zn=n(no),xa=r(no,"P",{"data-svelte-h":!0}),m(xa)!=="svelte-1gr03w4"&&(xa.textContent=sm),no.forEach(i),fe.forEach(i),Mr=n(e),O=r(e,"DIV",{class:!0});var he=l(O);c(ot.$$.fragment,he),Dn=n(he),ya=r(he,"P",{"data-svelte-h":!0}),m(ya)!=="svelte-vzcsb8"&&(ya.textContent=lm),Pn=n(he),$a=r(he,"P",{"data-svelte-h":!0}),m($a)!=="svelte-euart9"&&($a.innerHTML=pm),Mn=n(he),ie=r(he,"DIV",{class:!0});var io=l(ie);c(nt.$$.fragment,io),kn=n(io),wa=r(io,"P",{"data-svelte-h":!0}),m(wa)!=="svelte-1gr03w4"&&(wa.textContent=dm),io.forEach(i),he.forEach(i),kr=n(e),S=r(e,"DIV",{class:!0});var Xa=l(S);c(it.$$.fragment,Xa),qn=n(Xa),Ca=r(Xa,"P",{"data-svelte-h":!0}),m(Ca)!=="svelte-pwyp7b"&&(Ca.textContent=cm),En=n(Xa),me=r(Xa,"DIV",{class:!0});var mo=l(me);c(mt.$$.fragment,mo),On=n(mo),La=r(mo,"P",{"data-svelte-h":!0}),m(La)!=="svelte-1gr03w4"&&(La.textContent=gm),mo.forEach(i),Xa.forEach(i),qr=n(e),st=r(e,"DIV",{class:!0});var Zm=l(st);c(lt.$$.fragment,Zm),Zm.forEach(i),Er=n(e),w=r(e,"DIV",{class:!0});var k=l(w);c(pt.$$.fragment,k),Nn=n(k),Aa=r(k,"P",{"data-svelte-h":!0}),m(Aa)!=="svelte-wmmdpx"&&(Aa.textContent=um),In=n(k),Ta=r(k,"P",{"data-svelte-h":!0}),m(Ta)!=="svelte-12dyngi"&&(Ta.innerHTML=fm),Fn=n(k),za=r(k,"P",{"data-svelte-h":!0}),m(za)!=="svelte-qjjdis"&&(za.textContent=hm),Hn=n(k),Da=r(k,"P",{"data-svelte-h":!0}),m(Da)!=="svelte-rosfou"&&(Da.textContent=vm),Bn=n(k),Pa=r(k,"P",{"data-svelte-h":!0}),m(Pa)!=="svelte-hlwvkn"&&(Pa.textContent=bm),Gn=n(k),se=r(k,"DIV",{class:!0});var so=l(se);c(dt.$$.fragment,so),Rn=n(so),Ma=r(so,"P",{"data-svelte-h":!0}),m(Ma)!=="svelte-1gr03w4"&&(Ma.textContent=_m),so.forEach(i),k.forEach(i),Or=n(e),N=r(e,"DIV",{class:!0});var ve=l(N);c(ct.$$.fragment,ve),Sn=n(ve),ka=r(ve,"P",{"data-svelte-h":!0}),m(ka)!=="svelte-yn9hq2"&&(ka.textContent=xm),Vn=n(ve),qa=r(ve,"P",{"data-svelte-h":!0}),m(qa)!=="svelte-1l0d0b"&&(qa.innerHTML=ym),Wn=n(ve),le=r(ve,"DIV",{class:!0});var lo=l(le);c(gt.$$.fragment,lo),Un=n(lo),Ea=r(lo,"P",{"data-svelte-h":!0}),m(Ea)!=="svelte-1gr03w4"&&(Ea.textContent=$m),lo.forEach(i),ve.forEach(i),Nr=n(e),M=r(e,"DIV",{class:!0});var U=l(M);c(ut.$$.fragment,U),Qn=n(U),Oa=r(U,"P",{"data-svelte-h":!0}),m(Oa)!=="svelte-3mtxcr"&&(Oa.textContent=wm),jn=n(U),Na=r(U,"P",{"data-svelte-h":!0}),m(Na)!=="svelte-797qvx"&&(Na.innerHTML=Cm),Kn=n(U),Ia=r(U,"P",{"data-svelte-h":!0}),m(Ia)!=="svelte-1qa39gq"&&(Ia.innerHTML=Lm),Zn=n(U),pe=r(U,"DIV",{class:!0});var po=l(pe);c(ft.$$.fragment,po),Xn=n(po),Fa=r(po,"P",{"data-svelte-h":!0}),m(Fa)!=="svelte-1gr03w4"&&(Fa.textContent=Am),po.forEach(i),U.forEach(i),Ir=n(e),V=r(e,"DIV",{class:!0});var Ja=l(V);c(ht.$$.fragment,Ja),Jn=n(Ja),Ha=r(Ja,"P",{"data-svelte-h":!0}),m(Ha)!=="svelte-5vv99d"&&(Ha.textContent=Tm),Yn=n(Ja),de=r(Ja,"DIV",{class:!0});var co=l(de);c(vt.$$.fragment,co),ei=n(co),Ba=r(co,"P",{"data-svelte-h":!0}),m(Ba)!=="svelte-1gr03w4"&&(Ba.textContent=zm),co.forEach(i),Ja.forEach(i),Fr=n(e),y=r(e,"DIV",{class:!0});var D=l(y);c(bt.$$.fragment,D),ti=n(D),Ga=r(D,"P",{"data-svelte-h":!0}),m(Ga)!=="svelte-1tqv0s5"&&(Ga.textContent=Dm),ai=n(D),Ra=r(D,"P",{"data-svelte-h":!0}),m(Ra)!=="svelte-g10xv4"&&(Ra.textContent=Pm),ri=n(D),Sa=r(D,"P",{"data-svelte-h":!0}),m(Sa)!=="svelte-1acg3vg"&&(Sa.textContent=Mm),oi=n(D),Va=r(D,"OL",{"data-svelte-h":!0}),m(Va)!=="svelte-15y6o6y"&&(Va.innerHTML=km),ni=n(D),Wa=r(D,"P",{"data-svelte-h":!0}),m(Wa)!=="svelte-1yvkj2h"&&(Wa.innerHTML=qm),ii=n(D),Ua=r(D,"P",{"data-svelte-h":!0}),m(Ua)!=="svelte-53x1ow"&&(Ua.innerHTML=Em),mi=n(D),ce=r(D,"DIV",{class:!0});var go=l(ce);c(_t.$$.fragment,go),si=n(go),Qa=r(go,"P",{"data-svelte-h":!0}),m(Qa)!=="svelte-1gr03w4"&&(Qa.textContent=Om),go.forEach(i),D.forEach(i),Hr=n(e),xt=r(e,"DIV",{class:!0});var Xm=l(xt);c(yt.$$.fragment,Xm),Xm.forEach(i),Br=n(e),K=r(e,"DIV",{class:!0});var uo=l(K);c($t.$$.fragment,uo),li=n(uo),ge=r(uo,"DIV",{class:!0});var fo=l(ge);c(wt.$$.fragment,fo),pi=n(fo),ja=r(fo,"P",{"data-svelte-h":!0}),m(ja)!=="svelte-1gr03w4"&&(ja.textContent=Nm),fo.forEach(i),uo.forEach(i),Gr=n(e),c(Ct.$$.fragment,e),Rr=n(e),cr=r(e,"P",{}),l(cr).forEach(i),this.h()},h(){v(j,"name","hf:doc:metadata"),v(j,"content",is),v(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){t(document.head,j),p(e,gr,s),p(e,Ya,s),p(e,ur,s),g(be,e,s),p(e,fr,s),p(e,_e,s),p(e,hr,s),g(xe,e,s),p(e,vr,s),g(ye,e,s),p(e,br,s),p(e,_,s),g($e,_,null),t(_,ho),t(_,Lt),t(_,vo),t(_,At),t(_,bo),t(_,Tt),t(_,_o),t(_,er),t(er,tr),t(tr,we),g(Ce,we,null),t(we,xo),t(we,zt),t(_,yo),t(_,ar),t(ar,rr),t(rr,Le),g(Ae,Le,null),t(Le,$o),t(Le,Dt),t(_,wo),t(_,or),t(or,nr),t(nr,Te),g(ze,Te,null),t(Te,Co),t(Te,Pt),t(_,Lo),t(_,ir),t(ir,mr),t(mr,De),g(Pe,De,null),t(De,Ao),t(De,Mt),t(_,To),t(_,kt),t(_,zo),t(_,qt),p(e,_r,s),p(e,x,s),g(Me,x,null),t(x,Do),t(x,Et),t(x,Po),t(x,Ot),t(x,Mo),t(x,Nt),t(x,ko),t(x,It),t(x,qo),t(x,Ft),t(x,Eo),t(x,Ht),t(x,Oo),t(x,Bt),p(e,xr,s),p(e,C,s),g(ke,C,null),t(C,No),t(C,Gt),t(C,Io),t(C,Rt),t(C,Fo),t(C,St),t(C,Ho),t(C,sr),t(sr,lr),t(lr,qe),g(Ee,qe,null),t(qe,Bo),t(qe,Vt),t(C,Go),t(C,pr),t(pr,dr),t(dr,Oe),g(Ne,Oe,null),t(Oe,Ro),t(Oe,Wt),p(e,yr,s),g(Ie,e,s),p(e,$r,s),p(e,L,s),g(Fe,L,null),t(L,So),t(L,Ut),t(L,Vo),t(L,Qt),t(L,Wo),t(L,jt),t(L,Uo),t(L,Kt),t(L,Qo),t(L,Z),g(He,Z,null),t(Z,jo),t(Z,Zt),p(e,wr,s),p(e,A,s),g(Be,A,null),t(A,Ko),t(A,Xt),t(A,Zo),t(A,Jt),t(A,Xo),t(A,Yt),t(A,Jo),t(A,ea),t(A,Yo),t(A,X),g(Ge,X,null),t(X,en),t(X,ta),p(e,Cr,s),p(e,G,s),g(Re,G,null),t(G,tn),t(G,aa),t(G,an),t(G,ra),p(e,Lr,s),p(e,T,s),g(Se,T,null),t(T,rn),t(T,oa),t(T,on),t(T,J),g(Ve,J,null),t(J,nn),t(J,na),t(T,mn),t(T,Y),g(We,Y,null),t(Y,sn),t(Y,ia),t(T,ln),t(T,ee),g(Ue,ee,null),t(ee,pn),t(ee,ma),t(T,dn),t(T,te),g(Qe,te,null),t(te,cn),t(te,sa),p(e,Ar,s),p(e,je,s),g(Ke,je,null),p(e,Tr,s),p(e,q,s),g(Ze,q,null),t(q,gn),t(q,la),t(q,un),t(q,pa),t(q,fn),t(q,ae),g(Xe,ae,null),t(ae,hn),t(ae,da),p(e,zr,s),p(e,R,s),g(Je,R,null),t(R,vn),t(R,ca),t(R,bn),t(R,re),g(Ye,re,null),t(re,_n),t(re,ga),p(e,Dr,s),p(e,P,s),g(et,P,null),t(P,xn),t(P,ua),t(P,yn),t(P,fa),t(P,$n),t(P,ha),t(P,wn),t(P,oe),g(tt,oe,null),t(oe,Cn),t(oe,va),p(e,Pr,s),p(e,E,s),g(at,E,null),t(E,Ln),t(E,ba),t(E,An),t(E,_a),t(E,Tn),t(E,ne),g(rt,ne,null),t(ne,zn),t(ne,xa),p(e,Mr,s),p(e,O,s),g(ot,O,null),t(O,Dn),t(O,ya),t(O,Pn),t(O,$a),t(O,Mn),t(O,ie),g(nt,ie,null),t(ie,kn),t(ie,wa),p(e,kr,s),p(e,S,s),g(it,S,null),t(S,qn),t(S,Ca),t(S,En),t(S,me),g(mt,me,null),t(me,On),t(me,La),p(e,qr,s),p(e,st,s),g(lt,st,null),p(e,Er,s),p(e,w,s),g(pt,w,null),t(w,Nn),t(w,Aa),t(w,In),t(w,Ta),t(w,Fn),t(w,za),t(w,Hn),t(w,Da),t(w,Bn),t(w,Pa),t(w,Gn),t(w,se),g(dt,se,null),t(se,Rn),t(se,Ma),p(e,Or,s),p(e,N,s),g(ct,N,null),t(N,Sn),t(N,ka),t(N,Vn),t(N,qa),t(N,Wn),t(N,le),g(gt,le,null),t(le,Un),t(le,Ea),p(e,Nr,s),p(e,M,s),g(ut,M,null),t(M,Qn),t(M,Oa),t(M,jn),t(M,Na),t(M,Kn),t(M,Ia),t(M,Zn),t(M,pe),g(ft,pe,null),t(pe,Xn),t(pe,Fa),p(e,Ir,s),p(e,V,s),g(ht,V,null),t(V,Jn),t(V,Ha),t(V,Yn),t(V,de),g(vt,de,null),t(de,ei),t(de,Ba),p(e,Fr,s),p(e,y,s),g(bt,y,null),t(y,ti),t(y,Ga),t(y,ai),t(y,Ra),t(y,ri),t(y,Sa),t(y,oi),t(y,Va),t(y,ni),t(y,Wa),t(y,ii),t(y,Ua),t(y,mi),t(y,ce),g(_t,ce,null),t(ce,si),t(ce,Qa),p(e,Hr,s),p(e,xt,s),g(yt,xt,null),p(e,Br,s),p(e,K,s),g($t,K,null),t(K,li),t(K,ge),g(wt,ge,null),t(ge,pi),t(ge,ja),p(e,Gr,s),g(Ct,e,s),p(e,Rr,s),p(e,cr,s),Sr=!0},p:Ym,i(e){Sr||(u(be.$$.fragment,e),u(xe.$$.fragment,e),u(ye.$$.fragment,e),u($e.$$.fragment,e),u(Ce.$$.fragment,e),u(Ae.$$.fragment,e),u(ze.$$.fragment,e),u(Pe.$$.fragment,e),u(Me.$$.fragment,e),u(ke.$$.fragment,e),u(Ee.$$.fragment,e),u(Ne.$$.fragment,e),u(Ie.$$.fragment,e),u(Fe.$$.fragment,e),u(He.$$.fragment,e),u(Be.$$.fragment,e),u(Ge.$$.fragment,e),u(Re.$$.fragment,e),u(Se.$$.fragment,e),u(Ve.$$.fragment,e),u(We.$$.fragment,e),u(Ue.$$.fragment,e),u(Qe.$$.fragment,e),u(Ke.$$.fragment,e),u(Ze.$$.fragment,e),u(Xe.$$.fragment,e),u(Je.$$.fragment,e),u(Ye.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(rt.$$.fragment,e),u(ot.$$.fragment,e),u(nt.$$.fragment,e),u(it.$$.fragment,e),u(mt.$$.fragment,e),u(lt.$$.fragment,e),u(pt.$$.fragment,e),u(dt.$$.fragment,e),u(ct.$$.fragment,e),u(gt.$$.fragment,e),u(ut.$$.fragment,e),u(ft.$$.fragment,e),u(ht.$$.fragment,e),u(vt.$$.fragment,e),u(bt.$$.fragment,e),u(_t.$$.fragment,e),u(yt.$$.fragment,e),u($t.$$.fragment,e),u(wt.$$.fragment,e),u(Ct.$$.fragment,e),Sr=!0)},o(e){f(be.$$.fragment,e),f(xe.$$.fragment,e),f(ye.$$.fragment,e),f($e.$$.fragment,e),f(Ce.$$.fragment,e),f(Ae.$$.fragment,e),f(ze.$$.fragment,e),f(Pe.$$.fragment,e),f(Me.$$.fragment,e),f(ke.$$.fragment,e),f(Ee.$$.fragment,e),f(Ne.$$.fragment,e),f(Ie.$$.fragment,e),f(Fe.$$.fragment,e),f(He.$$.fragment,e),f(Be.$$.fragment,e),f(Ge.$$.fragment,e),f(Re.$$.fragment,e),f(Se.$$.fragment,e),f(Ve.$$.fragment,e),f(We.$$.fragment,e),f(Ue.$$.fragment,e),f(Qe.$$.fragment,e),f(Ke.$$.fragment,e),f(Ze.$$.fragment,e),f(Xe.$$.fragment,e),f(Je.$$.fragment,e),f(Ye.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(at.$$.fragment,e),f(rt.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(it.$$.fragment,e),f(mt.$$.fragment,e),f(lt.$$.fragment,e),f(pt.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(gt.$$.fragment,e),f(ut.$$.fragment,e),f(ft.$$.fragment,e),f(ht.$$.fragment,e),f(vt.$$.fragment,e),f(bt.$$.fragment,e),f(_t.$$.fragment,e),f(yt.$$.fragment,e),f($t.$$.fragment,e),f(wt.$$.fragment,e),f(Ct.$$.fragment,e),Sr=!1},d(e){e&&(i(gr),i(Ya),i(ur),i(fr),i(_e),i(hr),i(vr),i(br),i(_),i(_r),i(x),i(xr),i(C),i(yr),i($r),i(L),i(wr),i(A),i(Cr),i(G),i(Lr),i(T),i(Ar),i(je),i(Tr),i(q),i(zr),i(R),i(Dr),i(P),i(Pr),i(E),i(Mr),i(O),i(kr),i(S),i(qr),i(st),i(Er),i(w),i(Or),i(N),i(Nr),i(M),i(Ir),i(V),i(Fr),i(y),i(Hr),i(xt),i(Br),i(K),i(Gr),i(Rr),i(cr)),i(j),h(be,e),h(xe,e),h(ye,e),h($e),h(Ce),h(Ae),h(ze),h(Pe),h(Me),h(ke),h(Ee),h(Ne),h(Ie,e),h(Fe),h(He),h(Be),h(Ge),h(Re),h(Se),h(Ve),h(We),h(Ue),h(Qe),h(Ke),h(Ze),h(Xe),h(Je),h(Ye),h(et),h(tt),h(at),h(rt),h(ot),h(nt),h(it),h(mt),h(lt),h(pt),h(dt),h(ct),h(gt),h(ut),h(ft),h(ht),h(vt),h(bt),h(_t),h(yt),h($t),h(wt),h(Ct,e)}}}const is='{"title":"Optimization","local":"optimization","sections":[{"title":"Optimizers","local":"optimizers","sections":[{"title":"Factory functions","local":"timm.optim.create_optimizer_v2","sections":[],"depth":3}],"depth":2}],"depth":1}';function ms(di){return es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cs extends ts{constructor(j){super(),as(this,j,ms,ns,Jm,{})}}export{cs as component};
