import{s as Xn,o as Rn,n as on}from"../chunks/scheduler.182ea377.js";import{S as Fn,i as En,g as l,s as i,r as f,A as Nn,h as r,f as n,c as a,j as M,u,x as d,k as I,y as o,a as s,v as g,d as h,t as _,w as b}from"../chunks/index.abf12888.js";import{T as Bn}from"../chunks/Tip.230e2334.js";import{D as P}from"../chunks/Docstring.93f6f462.js";import{C as an}from"../chunks/CodeBlock.57fe6e13.js";import{E as Yn}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as L}from"../chunks/Heading.16916d63.js";function Ln(j){let c,T="If you plan on using a scheduler that can clip samples, make sure to disable it by setting <code>clip_sample=False</code> in the scheduler as this can also have an adverse effect on generated samples. Additionally, the PIA checkpoints can be sensitive to the beta schedule of the scheduler. We recommend setting this to <code>linear</code>.";return{c(){c=l("p"),c.innerHTML=T},l(y){c=r(y,"P",{"data-svelte-h":!0}),d(c)!=="svelte-1a93myr"&&(c.innerHTML=T)},m(y,w){s(y,c,w)},p:on,d(y){y&&n(c)}}}function Sn(j){let c,T="FreeInit is not really free - the improved quality comes at the cost of extra computation. It requires sampling a few extra times depending on the <code>num_iters</code> parameter that is set when enabling it. Setting the <code>use_fast_sampling</code> parameter to <code>True</code> can improve the overall performance (at the cost of lower quality compared to when <code>use_fast_sampling=False</code> but still better results than vanilla video generation models).";return{c(){c=l("p"),c.innerHTML=T},l(y){c=r(y,"P",{"data-svelte-h":!0}),d(c)!=="svelte-xxwpr5"&&(c.innerHTML=T)},m(y,w){s(y,c,w)},p:on,d(y){y&&n(c)}}}function Dn(j){let c,T="Examples:",y,w,x;return w=new an({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    EulerDiscreteScheduler,
<span class="hljs-meta">... </span>    MotionAdapter,
<span class="hljs-meta">... </span>    PIAPipeline,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image
<span class="hljs-meta">&gt;&gt;&gt; </span>adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;../checkpoints/pia-diffusers&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = PIAPipeline.from_pretrained(<span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>, motion_adapter=adapter)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = EulerDiscreteScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/pix2pix/cat_6.png?download=true&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;cat in a hat&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality, deformed, distorted, disfigured, bad eyes, wrong lips,weird mouth, bad teeth, mutated hands and fingers, bad anatomy,wrong anatomy, amputation, extra limb, missing limb, floating,limbs, disconnected limbs, mutation, ugly, disgusting, bad_pictures, negative_hand-neg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(image=image, prompt=prompt, negative_prompt=negative_prompt, generator=generator)
<span class="hljs-meta">&gt;&gt;&gt; </span>frames = output.frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_gif(frames, <span class="hljs-string">&quot;pia-animation.gif&quot;</span>)`,wrap:!1}}),{c(){c=l("p"),c.textContent=T,y=i(),f(w.$$.fragment)},l(v){c=r(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),y=a(v),u(w.$$.fragment,v)},m(v,U){s(v,c,U),s(v,y,U),g(w,v,U),x=!0},p:on,i(v){x||(h(w.$$.fragment,v),x=!0)},o(v){_(w.$$.fragment,v),x=!1},d(v){v&&(n(c),n(y)),b(w,v)}}}function Hn(j){let c,T,y,w,x,v,U,De,S,sn='<a href="https://arxiv.org/abs/2312.13964" rel="nofollow">PIA: Your Personalized Image Animator via Plug-and-Play Modules in Text-to-Image Models</a> by Yiming Zhang, Zhening Xing, Yanhong Zeng, Youqing Fang, Kai Chen',He,D,ln="Recent advancements in personalized text-to-image (T2I) models have revolutionized content creation, empowering non-experts to generate stunning images with unique styles. While promising, adding realistic motions into these personalized images by text poses significant challenges in preserving distinct styles, high-fidelity details, and achieving motion controllability by text. In this paper, we present PIA, a Personalized Image Animator that excels in aligning with condition images, achieving motion controllability by text, and the compatibility with various personalized T2I models without specific tuning. To achieve these goals, PIA builds upon a base T2I model with well-trained temporal alignment layers, allowing for the seamless transformation of any personalized T2I model into an image animation model. A key component of PIA is the introduction of the condition module, which utilizes the condition frame and inter-frame affinity as input to transfer appearance information guided by the affinity hint for individual frame synthesis in the latent space. This design mitigates the challenges of appearance-related image alignment within and allows for a stronger focus on aligning with motion-related guidance.",ze,H,rn='<a href="https://pi-animator.github.io/" rel="nofollow">Project page</a>',qe,z,Qe,q,pn='<thead><tr><th>Pipeline</th> <th>Tasks</th> <th align="center">Demo</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py" rel="nofollow">PIAPipeline</a></td> <td><em>Image-to-Video Generation with PIA</em></td> <td align="center"></td></tr></tbody>',Oe,Q,Ke,O,dn='Motion Adapter checkpoints for PIA can be found under the <a href="https://huggingface.co/openmmlab/PIA-condition-adapter" rel="nofollow">OpenMMLab org</a>. These checkpoints are meant to work with any model based on Stable Diffusion 1.5',et,K,tt,ee,cn="PIA works with a MotionAdapter checkpoint and a Stable Diffusion 1.5 model checkpoint. The MotionAdapter is a collection of Motion Modules that are responsible for adding coherent motion across image frames. These modules are applied after the Resnet and Attention blocks in the Stable Diffusion UNet. In addition to the motion modules, PIA also replaces the input convolution layer of the SD 1.5 UNet model with a 9 channel input convolution layer.",nt,te,mn="The following example demonstrates how to use PIA to generate a video from a single image.",it,ne,at,ie,fn="Here are some sample outputs:",ot,ae,un=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pia-default-output.gif" alt="cat in a field" style="width: 300px;"/></center></td></tr></tbody>`,st,A,lt,oe,rt,se,gn='<a href="https://arxiv.org/abs/2312.07537" rel="nofollow">FreeInit: Bridging Initialization Gap in Video Diffusion Models</a> by Tianxing Wu, Chenyang Si, Yuming Jiang, Ziqi Huang, Ziwei Liu.',pt,le,hn="FreeInit is an effective method that improves temporal consistency and overall quality of videos generated using video-diffusion-models without any addition training. It can be applied to PIA, AnimateDiff, ModelScope, VideoCrafter and various other video generation models seamlessly at inference time, and works by iteratively refining the latent-initialization noise. More details can be found it the paper.",dt,re,_n="The following example demonstrates the usage of FreeInit.",ct,pe,mt,de,bn=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pia-freeinit-output-cat.gif" alt="cat in a field" style="width: 300px;"/></center></td></tr></tbody>`,ft,C,ut,ce,gt,p,me,Ut,Pe,yn="Pipeline for text-to-video generation.",$t,Ue,vn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Zt,$e,wn="The pipeline also inherits the following loading methods:",kt,Ze,Mn='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Gt,$,fe,jt,ke,In="The call function to the pipeline for generation.",At,W,Ct,V,ue,Wt,Ge,Tn="Disables the FreeInit mechanism if enabled.",Vt,B,ge,Bt,je,xn="Disables the FreeU mechanism if enabled.",Xt,X,he,Rt,Ae,Jn=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ft,R,_e,Et,Ce,Pn=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Nt,Z,be,Yt,We,Un='Enables the FreeInit mechanism as in <a href="https://arxiv.org/abs/2312.07537" rel="nofollow">https://arxiv.org/abs/2312.07537</a>.',Lt,Ve,$n='This implementation has been adapted from the <a href="https://github.com/TianxingWu/FreeInit" rel="nofollow">official repository</a>.',St,J,ye,Dt,Be,Zn='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Ht,Xe,kn="The suffixes after the scaling factors represent the stages where they are being applied.",zt,Re,Gn=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,qt,F,ve,Qt,Fe,jn=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Ot,E,we,Kt,Ee,An=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,en,N,Me,tn,Ne,Cn="Encodes the prompt into text encoder hidden states.",ht,Ie,Wn="<li>enable_freeu</li> <li>disable_freeu</li> <li>enable_free_init</li> <li>disable_free_init</li> <li>enable_vae_slicing</li> <li>disable_vae_slicing</li> <li>enable_vae_tiling</li> <li>disable_vae_tiling</li>",_t,Te,bt,k,xe,nn,Ye,Vn="Output class for PIAPipeline.",yt,Se,vt;return x=new L({props:{title:"Image-to-Video Generation with PIA (Personalized Image Animator)",local:"image-to-video-generation-with-pia-personalized-image-animator",headingTag:"h1"}}),U=new L({props:{title:"Overview",local:"overview",headingTag:"h2"}}),z=new L({props:{title:"Available Pipelines",local:"available-pipelines",headingTag:"h2"}}),Q=new L({props:{title:"Available checkpoints",local:"available-checkpoints",headingTag:"h2"}}),K=new L({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),ne=new an({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBNb3Rpb25BZGFwdGVyJTJDJTBBJTIwJTIwJTIwJTIwUElBUGlwZWxpbmUlMkMlMEEpJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMkMlMjBsb2FkX2ltYWdlJTBBJTBBYWRhcHRlciUyMCUzRCUyME1vdGlvbkFkYXB0ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5tbWxhYiUyRlBJQS1jb25kaXRpb24tYWRhcHRlciUyMiklMEFwaXBlJTIwJTNEJTIwUElBUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlNHMTYxMjIyJTJGUmVhbGlzdGljX1Zpc2lvbl9WNi4wX0IxX25vVkFFJTIyJTJDJTIwbW90aW9uX2FkYXB0ZXIlM0RhZGFwdGVyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwRXVsZXJEaXNjcmV0ZVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXBpcGUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBpeDJwaXglMkZjYXRfNi5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIlMEEpJTBBaW1hZ2UlMjAlM0QlMjBpbWFnZS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBcHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwaW4lMjBhJTIwZmllbGQlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJ3cm9uZyUyMHdoaXRlJTIwYmFsYW5jZSUyQyUyMGRhcmslMkMlMjBza2V0Y2hlcyUyQ3dvcnN0JTIwcXVhbGl0eSUyQ2xvdyUyMHF1YWxpdHklMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQW91dHB1dCUyMCUzRCUyMHBpcGUoaW1hZ2UlM0RpbWFnZSUyQyUyMHByb21wdCUzRHByb21wdCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciklMEFmcmFtZXMlMjAlM0QlMjBvdXRwdXQuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b19naWYoZnJhbWVzJTJDJTIwJTIycGlhLWFuaW1hdGlvbi5naWYlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    EulerDiscreteScheduler,
    MotionAdapter,
    PIAPipeline,
)
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;openmmlab/PIA-condition-adapter&quot;</span>)
pipe = PIAPipeline.from_pretrained(<span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>, motion_adapter=adapter, torch_dtype=torch.float16)

pipe.scheduler = EulerDiscreteScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()
pipe.enable_vae_slicing()

image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/pix2pix/cat_6.png?download=true&quot;</span>
)
image = image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
prompt = <span class="hljs-string">&quot;cat in a field&quot;</span>
negative_prompt = <span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>

generator = torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
output = pipe(image=image, prompt=prompt, generator=generator)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;pia-animation.gif&quot;</span>)`,wrap:!1}}),A=new Bn({props:{$$slots:{default:[Ln]},$$scope:{ctx:j}}}),oe=new L({props:{title:"Using FreeInit",local:"using-freeinit",headingTag:"h2"}}),pe=new an({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMERESU1TY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBNb3Rpb25BZGFwdGVyJTJDJTBBJTIwJTIwJTIwJTIwUElBUGlwZWxpbmUlMkMlMEEpJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMkMlMjBsb2FkX2ltYWdlJTBBJTBBYWRhcHRlciUyMCUzRCUyME1vdGlvbkFkYXB0ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5tbWxhYiUyRlBJQS1jb25kaXRpb24tYWRhcHRlciUyMiklMEFwaXBlJTIwJTNEJTIwUElBUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlNHMTYxMjIyJTJGUmVhbGlzdGljX1Zpc2lvbl9WNi4wX0IxX25vVkFFJTIyJTJDJTIwbW90aW9uX2FkYXB0ZXIlM0RhZGFwdGVyKSUwQSUwQSUyMyUyMGVuYWJsZSUyMEZyZWVJbml0JTBBJTIzJTIwUmVmZXIlMjB0byUyMHRoZSUyMGVuYWJsZV9mcmVlX2luaXQlMjBkb2N1bWVudGF0aW9uJTIwZm9yJTIwYSUyMGZ1bGwlMjBsaXN0JTIwb2YlMjBjb25maWd1cmFibGUlMjBwYXJhbWV0ZXJzJTBBcGlwZS5lbmFibGVfZnJlZV9pbml0KG1ldGhvZCUzRCUyMmJ1dHRlcndvcnRoJTIyJTJDJTIwdXNlX2Zhc3Rfc2FtcGxpbmclM0RUcnVlKSUwQSUwQSUyMyUyME1lbW9yeSUyMHNhdmluZyUyMG9wdGlvbnMlMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBcGlwZS5lbmFibGVfdmFlX3NsaWNpbmcoKSUwQSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZkaWZmdXNlcnMtaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXgycGl4JTJGY2F0XzYucG5nJTNGZG93bmxvYWQlM0R0cnVlJTIyJTBBKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQXByb21wdCUyMCUzRCUyMCUyMmNhdCUyMGluJTIwYSUyMGhhdCUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMndyb25nJTIwd2hpdGUlMjBiYWxhbmNlJTJDJTIwZGFyayUyQyUyMHNrZXRjaGVzJTJDd29yc3QlMjBxdWFsaXR5JTJDbG93JTIwcXVhbGl0eSUyMiUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBJTBBb3V0cHV0JTIwJTNEJTIwcGlwZShpbWFnZSUzRGltYWdlJTJDJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKSUwQWZyYW1lcyUyMCUzRCUyMG91dHB1dC5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX2dpZihmcmFtZXMlMkMlMjAlMjJwaWEtZnJlZWluaXQtYW5pbWF0aW9uLmdpZiUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    DDIMScheduler,
    MotionAdapter,
    PIAPipeline,
)
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;openmmlab/PIA-condition-adapter&quot;</span>)
pipe = PIAPipeline.from_pretrained(<span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>, motion_adapter=adapter)

<span class="hljs-comment"># enable FreeInit</span>
<span class="hljs-comment"># Refer to the enable_free_init documentation for a full list of configurable parameters</span>
pipe.enable_free_init(method=<span class="hljs-string">&quot;butterworth&quot;</span>, use_fast_sampling=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Memory saving options</span>
pipe.enable_model_cpu_offload()
pipe.enable_vae_slicing()

pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/pix2pix/cat_6.png?download=true&quot;</span>
)
image = image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
prompt = <span class="hljs-string">&quot;cat in a hat&quot;</span>
negative_prompt = <span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>

generator = torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

output = pipe(image=image, prompt=prompt, generator=generator)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;pia-freeinit-animation.gif&quot;</span>)`,wrap:!1}}),C=new Bn({props:{warning:!0,$$slots:{default:[Sn]},$$scope:{ctx:j}}}),ce=new L({props:{title:"PIAPipeline",local:"diffusers.PIAPipeline",headingTag:"h2"}}),me=new P({props:{name:"class diffusers.PIAPipeline",anchor:"diffusers.PIAPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": Union"},{name:"scheduler",val:": Union"},{name:"motion_adapter",val:": Optional = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.PIAPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.PIAPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.PIAPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.PIAPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.PIAPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.PIAPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L212"}}),fe=new P({props:{name:"__call__",anchor:"diffusers.PIAPipeline.__call__",parameters:[{name:"image",val:": Union"},{name:"prompt",val:": Union = None"},{name:"strength",val:": float = 1.0"},{name:"num_frames",val:": Optional = 16"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"motion_scale",val:": int = 0"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.PIAPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to be used for video generation.`,name:"image"},{anchor:"diffusers.PIAPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.PIAPipeline.__call__.strength",description:"<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014; Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1.",name:"strength"},{anchor:"diffusers.PIAPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.PIAPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.PIAPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.PIAPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.PIAPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.PIAPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.PIAPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.PIAPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.PIAPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.PIAPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PIAPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.
motion_scale &#x2014; (<code>int</code>, <em>optional</em>, defaults to 0):
Parameter that controls the amount and type of motion that is added to the image. Increasing the value increases the amount of motion, while specific
ranges of values control the type of motion that is added. Must be between 0 and 8.
Set between 0-2 to only increase the amount of motion.
Set between 3-5 to create looping motion.
Set between 6-8 to perform motion with image style transfer.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PIAPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code>, <code>PIL.Image</code> or
<code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.PIAPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.PIAPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.PIAPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.PIAPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.PIAPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeine class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L950",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),W=new Yn({props:{anchor:"diffusers.PIAPipeline.__call__.example",$$slots:{default:[Dn]},$$scope:{ctx:j}}}),ue=new P({props:{name:"disable_free_init",anchor:"diffusers.PIAPipeline.disable_free_init",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L620"}}),ge=new P({props:{name:"disable_freeu",anchor:"diffusers.PIAPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L568"}}),he=new P({props:{name:"disable_vae_slicing",anchor:"diffusers.PIAPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L520"}}),_e=new P({props:{name:"disable_vae_tiling",anchor:"diffusers.PIAPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L537"}}),be=new P({props:{name:"enable_free_init",anchor:"diffusers.PIAPipeline.enable_free_init",parameters:[{name:"num_iters",val:": int = 3"},{name:"use_fast_sampling",val:": bool = False"},{name:"method",val:": str = 'butterworth'"},{name:"order",val:": int = 4"},{name:"spatial_stop_frequency",val:": float = 0.25"},{name:"temporal_stop_frequency",val:": float = 0.25"},{name:"generator",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.PIAPipeline.enable_free_init.num_iters",description:`<strong>num_iters</strong> (<code>int</code>, <em>optional</em>, defaults to <code>3</code>) &#x2014;
Number of FreeInit noise re-initialization iterations.`,name:"num_iters"},{anchor:"diffusers.PIAPipeline.enable_free_init.use_fast_sampling",description:`<strong>use_fast_sampling</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to speedup sampling procedure at the cost of probably lower quality results. Enables
the &#x201C;Coarse-to-Fine Sampling&#x201D; strategy, as mentioned in the paper, if set to <code>True</code>.`,name:"use_fast_sampling"},{anchor:"diffusers.PIAPipeline.enable_free_init.method",description:`<strong>method</strong> (<code>str</code>, <em>optional</em>, defaults to <code>butterworth</code>) &#x2014;
Must be one of <code>butterworth</code>, <code>ideal</code> or <code>gaussian</code> to use as the filtering method for the
FreeInit low pass filter.`,name:"method"},{anchor:"diffusers.PIAPipeline.enable_free_init.order",description:`<strong>order</strong> (<code>int</code>, <em>optional</em>, defaults to <code>4</code>) &#x2014;
Order of the filter used in <code>butterworth</code> method. Larger values lead to <code>ideal</code> method behaviour
whereas lower values lead to <code>gaussian</code> method behaviour.`,name:"order"},{anchor:"diffusers.PIAPipeline.enable_free_init.spatial_stop_frequency",description:`<strong>spatial_stop_frequency</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.25</code>) &#x2014;
Normalized stop frequency for spatial dimensions. Must be between 0 to 1. Referred to as <code>d_s</code> in
the original implementation.`,name:"spatial_stop_frequency"},{anchor:"diffusers.PIAPipeline.enable_free_init.temporal_stop_frequency",description:`<strong>temporal_stop_frequency</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.25</code>) &#x2014;
Normalized stop frequency for temporal dimensions. Must be between 0 to 1. Referred to as <code>d_t</code> in
the original implementation.`,name:"temporal_stop_frequency"},{anchor:"diffusers.PIAPipeline.enable_free_init.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>, defaults to <code>0.25</code>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
FreeInit generation deterministic.`,name:"generator"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L576"}}),ye=new P({props:{name:"enable_freeu",anchor:"diffusers.PIAPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.PIAPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.PIAPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.PIAPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.PIAPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L545"}}),ve=new P({props:{name:"enable_vae_slicing",anchor:"diffusers.PIAPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L512"}}),we=new P({props:{name:"enable_vae_tiling",anchor:"diffusers.PIAPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L528"}}),Me=new P({props:{name:"encode_prompt",anchor:"diffusers.PIAPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.PIAPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.PIAPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.PIAPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.PIAPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.PIAPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PIAPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PIAPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.PIAPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L281"}}),Te=new L({props:{title:"PIAPipelineOutput",local:"diffusers.pipelines.pia.PIAPipelineOutput",headingTag:"h2"}}),xe=new P({props:{name:"class diffusers.pipelines.pia.PIAPipelineOutput",anchor:"diffusers.pipelines.pia.PIAPipelineOutput",parameters:[{name:"frames",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.pia.PIAPipelineOutput.frames",description:"<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[PIL.Image.Image]) &#x2014;",name:"frames"},{anchor:"diffusers.pipelines.pia.PIAPipelineOutput.Nested",description:"<strong>Nested</strong> list of length <code>batch_size</code> with denoised PIL image sequences of length <code>num_frames</code>, &#x2014;",name:"Nested"},{anchor:"diffusers.pipelines.pia.PIAPipelineOutput.NumPy",description:"<strong>NumPy</strong> array of shape `(batch_size, num_frames, channels, height, width, &#x2014;",name:"NumPy"},{anchor:"diffusers.pipelines.pia.PIAPipelineOutput.Torch",description:"<strong>Torch</strong> tensor of shape <code>(batch_size, num_frames, channels, height, width)</code>. &#x2014;",name:"Torch"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pia/pipeline_pia.py#L197"}}),{c(){c=l("meta"),T=i(),y=l("p"),w=i(),f(x.$$.fragment),v=i(),f(U.$$.fragment),De=i(),S=l("p"),S.innerHTML=sn,He=i(),D=l("p"),D.textContent=ln,ze=i(),H=l("p"),H.innerHTML=rn,qe=i(),f(z.$$.fragment),Qe=i(),q=l("table"),q.innerHTML=pn,Oe=i(),f(Q.$$.fragment),Ke=i(),O=l("p"),O.innerHTML=dn,et=i(),f(K.$$.fragment),tt=i(),ee=l("p"),ee.textContent=cn,nt=i(),te=l("p"),te.textContent=mn,it=i(),f(ne.$$.fragment),at=i(),ie=l("p"),ie.textContent=fn,ot=i(),ae=l("table"),ae.innerHTML=un,st=i(),f(A.$$.fragment),lt=i(),f(oe.$$.fragment),rt=i(),se=l("p"),se.innerHTML=gn,pt=i(),le=l("p"),le.textContent=hn,dt=i(),re=l("p"),re.textContent=_n,ct=i(),f(pe.$$.fragment),mt=i(),de=l("table"),de.innerHTML=bn,ft=i(),f(C.$$.fragment),ut=i(),f(ce.$$.fragment),gt=i(),p=l("div"),f(me.$$.fragment),Ut=i(),Pe=l("p"),Pe.textContent=yn,$t=i(),Ue=l("p"),Ue.innerHTML=vn,Zt=i(),$e=l("p"),$e.textContent=wn,kt=i(),Ze=l("ul"),Ze.innerHTML=Mn,Gt=i(),$=l("div"),f(fe.$$.fragment),jt=i(),ke=l("p"),ke.textContent=In,At=i(),f(W.$$.fragment),Ct=i(),V=l("div"),f(ue.$$.fragment),Wt=i(),Ge=l("p"),Ge.textContent=Tn,Vt=i(),B=l("div"),f(ge.$$.fragment),Bt=i(),je=l("p"),je.textContent=xn,Xt=i(),X=l("div"),f(he.$$.fragment),Rt=i(),Ae=l("p"),Ae.innerHTML=Jn,Ft=i(),R=l("div"),f(_e.$$.fragment),Et=i(),Ce=l("p"),Ce.innerHTML=Pn,Nt=i(),Z=l("div"),f(be.$$.fragment),Yt=i(),We=l("p"),We.innerHTML=Un,Lt=i(),Ve=l("p"),Ve.innerHTML=$n,St=i(),J=l("div"),f(ye.$$.fragment),Dt=i(),Be=l("p"),Be.innerHTML=Zn,Ht=i(),Xe=l("p"),Xe.textContent=kn,zt=i(),Re=l("p"),Re.innerHTML=Gn,qt=i(),F=l("div"),f(ve.$$.fragment),Qt=i(),Fe=l("p"),Fe.textContent=jn,Ot=i(),E=l("div"),f(we.$$.fragment),Kt=i(),Ee=l("p"),Ee.textContent=An,en=i(),N=l("div"),f(Me.$$.fragment),tn=i(),Ne=l("p"),Ne.textContent=Cn,ht=i(),Ie=l("ul"),Ie.innerHTML=Wn,_t=i(),f(Te.$$.fragment),bt=i(),k=l("div"),f(xe.$$.fragment),nn=i(),Ye=l("p"),Ye.textContent=Vn,yt=i(),Se=l("p"),this.h()},l(e){const t=Nn("svelte-u9bgzb",document.head);c=r(t,"META",{name:!0,content:!0}),t.forEach(n),T=a(e),y=r(e,"P",{}),M(y).forEach(n),w=a(e),u(x.$$.fragment,e),v=a(e),u(U.$$.fragment,e),De=a(e),S=r(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-nano8w"&&(S.innerHTML=sn),He=a(e),D=r(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-1jcs7ly"&&(D.textContent=ln),ze=a(e),H=r(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-q609lx"&&(H.innerHTML=rn),qe=a(e),u(z.$$.fragment,e),Qe=a(e),q=r(e,"TABLE",{"data-svelte-h":!0}),d(q)!=="svelte-5p4fpx"&&(q.innerHTML=pn),Oe=a(e),u(Q.$$.fragment,e),Ke=a(e),O=r(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1bi1ry7"&&(O.innerHTML=dn),et=a(e),u(K.$$.fragment,e),tt=a(e),ee=r(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-woui0n"&&(ee.textContent=cn),nt=a(e),te=r(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-wwfxrb"&&(te.textContent=mn),it=a(e),u(ne.$$.fragment,e),at=a(e),ie=r(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1pxzje"&&(ie.textContent=fn),ot=a(e),ae=r(e,"TABLE",{"data-svelte-h":!0}),d(ae)!=="svelte-1bzaluv"&&(ae.innerHTML=un),st=a(e),u(A.$$.fragment,e),lt=a(e),u(oe.$$.fragment,e),rt=a(e),se=r(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-a52po1"&&(se.innerHTML=gn),pt=a(e),le=r(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-bwalkj"&&(le.textContent=hn),dt=a(e),re=r(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1qq4ux4"&&(re.textContent=_n),ct=a(e),u(pe.$$.fragment,e),mt=a(e),de=r(e,"TABLE",{"data-svelte-h":!0}),d(de)!=="svelte-14f6rdp"&&(de.innerHTML=bn),ft=a(e),u(C.$$.fragment,e),ut=a(e),u(ce.$$.fragment,e),gt=a(e),p=r(e,"DIV",{class:!0});var m=M(p);u(me.$$.fragment,m),Ut=a(m),Pe=r(m,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-19ipoo4"&&(Pe.textContent=yn),$t=a(m),Ue=r(m,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-496sm0"&&(Ue.innerHTML=vn),Zt=a(m),$e=r(m,"P",{"data-svelte-h":!0}),d($e)!=="svelte-14s6m4u"&&($e.textContent=wn),kt=a(m),Ze=r(m,"UL",{"data-svelte-h":!0}),d(Ze)!=="svelte-jjuyoc"&&(Ze.innerHTML=Mn),Gt=a(m),$=r(m,"DIV",{class:!0});var G=M($);u(fe.$$.fragment,G),jt=a(G),ke=r(G,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-50j04k"&&(ke.textContent=In),At=a(G),u(W.$$.fragment,G),G.forEach(n),Ct=a(m),V=r(m,"DIV",{class:!0});var Je=M(V);u(ue.$$.fragment,Je),Wt=a(Je),Ge=r(Je,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-14r83"&&(Ge.textContent=Tn),Je.forEach(n),Vt=a(m),B=r(m,"DIV",{class:!0});var wt=M(B);u(ge.$$.fragment,wt),Bt=a(wt),je=r(wt,"P",{"data-svelte-h":!0}),d(je)!=="svelte-psupw6"&&(je.textContent=xn),wt.forEach(n),Xt=a(m),X=r(m,"DIV",{class:!0});var Mt=M(X);u(he.$$.fragment,Mt),Rt=a(Mt),Ae=r(Mt,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1s3c06i"&&(Ae.innerHTML=Jn),Mt.forEach(n),Ft=a(m),R=r(m,"DIV",{class:!0});var It=M(R);u(_e.$$.fragment,It),Et=a(It),Ce=r(It,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-pkn4ui"&&(Ce.innerHTML=Pn),It.forEach(n),Nt=a(m),Z=r(m,"DIV",{class:!0});var Le=M(Z);u(be.$$.fragment,Le),Yt=a(Le),We=r(Le,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1llfxku"&&(We.innerHTML=Un),Lt=a(Le),Ve=r(Le,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-1adhw15"&&(Ve.innerHTML=$n),Le.forEach(n),St=a(m),J=r(m,"DIV",{class:!0});var Y=M(J);u(ye.$$.fragment,Y),Dt=a(Y),Be=r(Y,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-1f3tmq1"&&(Be.innerHTML=Zn),Ht=a(Y),Xe=r(Y,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-xjijlp"&&(Xe.textContent=kn),zt=a(Y),Re=r(Y,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-hy0nzs"&&(Re.innerHTML=Gn),Y.forEach(n),qt=a(m),F=r(m,"DIV",{class:!0});var Tt=M(F);u(ve.$$.fragment,Tt),Qt=a(Tt),Fe=r(Tt,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-14bnrb6"&&(Fe.textContent=jn),Tt.forEach(n),Ot=a(m),E=r(m,"DIV",{class:!0});var xt=M(E);u(we.$$.fragment,xt),Kt=a(xt),Ee=r(xt,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-1xwrf7t"&&(Ee.textContent=An),xt.forEach(n),en=a(m),N=r(m,"DIV",{class:!0});var Jt=M(N);u(Me.$$.fragment,Jt),tn=a(Jt),Ne=r(Jt,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-16q0ax1"&&(Ne.textContent=Cn),Jt.forEach(n),m.forEach(n),ht=a(e),Ie=r(e,"UL",{"data-svelte-h":!0}),d(Ie)!=="svelte-1piu0vk"&&(Ie.innerHTML=Wn),_t=a(e),u(Te.$$.fragment,e),bt=a(e),k=r(e,"DIV",{class:!0});var Pt=M(k);u(xe.$$.fragment,Pt),nn=a(Pt),Ye=r(Pt,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-6skj8c"&&(Ye.textContent=Vn),Pt.forEach(n),yt=a(e),Se=r(e,"P",{}),M(Se).forEach(n),this.h()},h(){I(c,"name","hf:doc:metadata"),I(c,"content",zn),I($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){o(document.head,c),s(e,T,t),s(e,y,t),s(e,w,t),g(x,e,t),s(e,v,t),g(U,e,t),s(e,De,t),s(e,S,t),s(e,He,t),s(e,D,t),s(e,ze,t),s(e,H,t),s(e,qe,t),g(z,e,t),s(e,Qe,t),s(e,q,t),s(e,Oe,t),g(Q,e,t),s(e,Ke,t),s(e,O,t),s(e,et,t),g(K,e,t),s(e,tt,t),s(e,ee,t),s(e,nt,t),s(e,te,t),s(e,it,t),g(ne,e,t),s(e,at,t),s(e,ie,t),s(e,ot,t),s(e,ae,t),s(e,st,t),g(A,e,t),s(e,lt,t),g(oe,e,t),s(e,rt,t),s(e,se,t),s(e,pt,t),s(e,le,t),s(e,dt,t),s(e,re,t),s(e,ct,t),g(pe,e,t),s(e,mt,t),s(e,de,t),s(e,ft,t),g(C,e,t),s(e,ut,t),g(ce,e,t),s(e,gt,t),s(e,p,t),g(me,p,null),o(p,Ut),o(p,Pe),o(p,$t),o(p,Ue),o(p,Zt),o(p,$e),o(p,kt),o(p,Ze),o(p,Gt),o(p,$),g(fe,$,null),o($,jt),o($,ke),o($,At),g(W,$,null),o(p,Ct),o(p,V),g(ue,V,null),o(V,Wt),o(V,Ge),o(p,Vt),o(p,B),g(ge,B,null),o(B,Bt),o(B,je),o(p,Xt),o(p,X),g(he,X,null),o(X,Rt),o(X,Ae),o(p,Ft),o(p,R),g(_e,R,null),o(R,Et),o(R,Ce),o(p,Nt),o(p,Z),g(be,Z,null),o(Z,Yt),o(Z,We),o(Z,Lt),o(Z,Ve),o(p,St),o(p,J),g(ye,J,null),o(J,Dt),o(J,Be),o(J,Ht),o(J,Xe),o(J,zt),o(J,Re),o(p,qt),o(p,F),g(ve,F,null),o(F,Qt),o(F,Fe),o(p,Ot),o(p,E),g(we,E,null),o(E,Kt),o(E,Ee),o(p,en),o(p,N),g(Me,N,null),o(N,tn),o(N,Ne),s(e,ht,t),s(e,Ie,t),s(e,_t,t),g(Te,e,t),s(e,bt,t),s(e,k,t),g(xe,k,null),o(k,nn),o(k,Ye),s(e,yt,t),s(e,Se,t),vt=!0},p(e,[t]){const m={};t&2&&(m.$$scope={dirty:t,ctx:e}),A.$set(m);const G={};t&2&&(G.$$scope={dirty:t,ctx:e}),C.$set(G);const Je={};t&2&&(Je.$$scope={dirty:t,ctx:e}),W.$set(Je)},i(e){vt||(h(x.$$.fragment,e),h(U.$$.fragment,e),h(z.$$.fragment,e),h(Q.$$.fragment,e),h(K.$$.fragment,e),h(ne.$$.fragment,e),h(A.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(C.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(fe.$$.fragment,e),h(W.$$.fragment,e),h(ue.$$.fragment,e),h(ge.$$.fragment,e),h(he.$$.fragment,e),h(_e.$$.fragment,e),h(be.$$.fragment,e),h(ye.$$.fragment,e),h(ve.$$.fragment,e),h(we.$$.fragment,e),h(Me.$$.fragment,e),h(Te.$$.fragment,e),h(xe.$$.fragment,e),vt=!0)},o(e){_(x.$$.fragment,e),_(U.$$.fragment,e),_(z.$$.fragment,e),_(Q.$$.fragment,e),_(K.$$.fragment,e),_(ne.$$.fragment,e),_(A.$$.fragment,e),_(oe.$$.fragment,e),_(pe.$$.fragment,e),_(C.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(fe.$$.fragment,e),_(W.$$.fragment,e),_(ue.$$.fragment,e),_(ge.$$.fragment,e),_(he.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(ve.$$.fragment,e),_(we.$$.fragment,e),_(Me.$$.fragment,e),_(Te.$$.fragment,e),_(xe.$$.fragment,e),vt=!1},d(e){e&&(n(T),n(y),n(w),n(v),n(De),n(S),n(He),n(D),n(ze),n(H),n(qe),n(Qe),n(q),n(Oe),n(Ke),n(O),n(et),n(tt),n(ee),n(nt),n(te),n(it),n(at),n(ie),n(ot),n(ae),n(st),n(lt),n(rt),n(se),n(pt),n(le),n(dt),n(re),n(ct),n(mt),n(de),n(ft),n(ut),n(gt),n(p),n(ht),n(Ie),n(_t),n(bt),n(k),n(yt),n(Se)),n(c),b(x,e),b(U,e),b(z,e),b(Q,e),b(K,e),b(ne,e),b(A,e),b(oe,e),b(pe,e),b(C,e),b(ce,e),b(me),b(fe),b(W),b(ue),b(ge),b(he),b(_e),b(be),b(ye),b(ve),b(we),b(Me),b(Te,e),b(xe)}}}const zn='{"title":"Image-to-Video Generation with PIA (Personalized Image Animator)","local":"image-to-video-generation-with-pia-personalized-image-animator","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Available Pipelines","local":"available-pipelines","sections":[],"depth":2},{"title":"Available checkpoints","local":"available-checkpoints","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[],"depth":2},{"title":"Using FreeInit","local":"using-freeinit","sections":[],"depth":2},{"title":"PIAPipeline","local":"diffusers.PIAPipeline","sections":[],"depth":2},{"title":"PIAPipelineOutput","local":"diffusers.pipelines.pia.PIAPipelineOutput","sections":[],"depth":2}],"depth":1}';function qn(j){return Rn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ai extends Fn{constructor(c){super(),En(this,c,qn,Hn,Xn,{})}}export{ai as component};
