import{s as Ia,o as Ha,n as z}from"../chunks/scheduler.9bc65507.js";import{S as La,i as ja,g as i,s as n,r as g,A as Pa,h as m,f as o,c as r,j as T,u as f,x as b,k as x,y as t,a as d,v as u,d as h,t as $,w as _}from"../chunks/index.707bf1b6.js";import{T as Mo}from"../chunks/Tip.c2ecdbf4.js";import{D as A}from"../chunks/Docstring.570ddb64.js";import{C as Et}from"../chunks/CodeBlock.54a9f38d.js";import{E as qt}from"../chunks/ExampleCodeBlock.bc2be6bc.js";import{H,E as Ja}from"../chunks/EditOnGithub.922df6ba.js";function Ua(M){let l,y=`Transformers Agents is an experimental API which is subject to change at any time. Results returned by the agents
can vary as the APIs or underlying models are prone to change.`;return{c(){l=i("p"),l.textContent=y},l(p){l=m(p,"P",{"data-svelte-h":!0}),b(l)!=="svelte-1fgfei3"&&(l.textContent=y)},m(p,c){d(p,l,c)},p:z,d(p){p&&o(l)}}}function qa(M){let l,y="Example:",p,c,v;return c=new Et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiklMEFhZ2VudC5ydW4oJTIySXMlMjB0aGUlMjBmb2xsb3dpbmclMjAlNjB0ZXh0JTYwJTIwKGluJTIwU3BhbmlzaCklMjBwb3NpdGl2ZSUyMG9yJTIwbmVnYXRpdmUlM0YlMjIlMkMlMjB0ZXh0JTNEJTIyJUMyJUExRXN0ZSUyMGVzJTIwdW4lMjBBUEklMjBtdXklMjBhZ3JhZGFibGUhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>)
agent.run(<span class="hljs-string">&quot;Is the following \`text\` (in Spanish) positive or negative?&quot;</span>, text=<span class="hljs-string">&quot;¡Este es un API muy agradable!&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,p=n(),g(c.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=y),p=r(a),f(c.$$.fragment,a)},m(a,w){d(a,l,w),d(a,p,w),u(c,a,w),v=!0},p:z,i(a){v||(h(c.$$.fragment,a),v=!0)},o(a){$(c.$$.fragment,a),v=!1},d(a){a&&(o(l),o(p)),_(c,a)}}}function Ea(M){let l,y="Example:",p,c,v;return c=new Et({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTJDJTIwTG9jYWxBZ2VudCUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJiaWdjb2RlJTJGc3RhcmNvZGVyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQWFnZW50JTIwJTNEJTIwTG9jYWxBZ2VudChtb2RlbCUyQyUyMHRva2VuaXplciklMEFhZ2VudC5ydW4oJTIyRHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, LocalAgent

checkpoint = <span class="hljs-string">&quot;bigcode/starcoder&quot;</span>
model = AutoModelForCausalLM.from_pretrained(checkpoint, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.bfloat16)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)

agent = LocalAgent(model, tokenizer)
agent.run(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,p=n(),g(c.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=y),p=r(a),f(c.$$.fragment,a)},m(a,w){d(a,l,w),d(a,p,w),u(c,a,w),v=!0},p:z,i(a){v||(h(c.$$.fragment,a),v=!0)},o(a){$(c.$$.fragment,a),v=!1},d(a){a&&(o(l),o(p)),_(c,a)}}}function Za(M){let l,y="Example:",p,c,v;return c=new Et({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwTG9jYWxBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwTG9jYWxBZ2VudC5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRnN0YXJjb2RlciUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFhZ2VudC5ydW4oJTIyRHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LocalAgent

agent = LocalAgent.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.bfloat16)
agent.run(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,p=n(),g(c.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=y),p=r(a),f(c.$$.fragment,a)},m(a,w){d(a,l,w),d(a,p,w),u(c,a,w),v=!0},p:z,i(a){v||(h(c.$$.fragment,a),v=!0)},o(a){$(c.$$.fragment,a),v=!1},d(a){a&&(o(l),o(p)),_(c,a)}}}function Wa(M){let l,y=`The openAI models are used in generation mode, so even for the <code>chat()</code> API, it’s better to use models like
<code>&quot;text-davinci-003&quot;</code> over the chat-GPT variant. Proper support for chat-GPT models will come in a next version.`;return{c(){l=i("p"),l.innerHTML=y},l(p){l=m(p,"P",{"data-svelte-h":!0}),b(l)!=="svelte-3idp4e"&&(l.innerHTML=y)},m(p,c){d(p,l,c)},p:z,d(p){p&&o(l)}}}function Ra(M){let l,y="Example:",p,c,v;return c=new Et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME9wZW5BaUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBPcGVuQWlBZ2VudChtb2RlbCUzRCUyMnRleHQtZGF2aW5jaS0wMDMlMjIlMkMlMjBhcGlfa2V5JTNEeHh4KSUwQWFnZW50LnJ1biglMjJJcyUyMHRoZSUyMGZvbGxvd2luZyUyMCU2MHRleHQlNjAlMjAoaW4lMjBTcGFuaXNoKSUyMHBvc2l0aXZlJTIwb3IlMjBuZWdhdGl2ZSUzRiUyMiUyQyUyMHRleHQlM0QlMjIlQzIlQTFFc3RlJTIwZXMlMjB1biUyMEFQSSUyMG11eSUyMGFncmFkYWJsZSElMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OpenAiAgent

agent = OpenAiAgent(model=<span class="hljs-string">&quot;text-davinci-003&quot;</span>, api_key=xxx)
agent.run(<span class="hljs-string">&quot;Is the following \`text\` (in Spanish) positive or negative?&quot;</span>, text=<span class="hljs-string">&quot;¡Este es un API muy agradable!&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,p=n(),g(c.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=y),p=r(a),f(c.$$.fragment,a)},m(a,w){d(a,l,w),d(a,p,w),u(c,a,w),v=!0},p:z,i(a){v||(h(c.$$.fragment,a),v=!0)},o(a){$(c.$$.fragment,a),v=!1},d(a){a&&(o(l),o(p)),_(c,a)}}}function za(M){let l,y=`The openAI models are used in generation mode, so even for the <code>chat()</code> API, it’s better to use models like
<code>&quot;text-davinci-003&quot;</code> over the chat-GPT variant. Proper support for chat-GPT models will come in a next version.`;return{c(){l=i("p"),l.innerHTML=y},l(p){l=m(p,"P",{"data-svelte-h":!0}),b(l)!=="svelte-3idp4e"&&(l.innerHTML=y)},m(p,c){d(p,l,c)},p:z,d(p){p&&o(l)}}}function Ga(M){let l,y="Example:",p,c,v;return c=new Et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF6dXJlT3BlbkFpQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEF6dXJlQWlBZ2VudChkZXBsb3ltZW50X2lkJTNEJTIyRGF2aW5jaS0wMDMlMjIlMkMlMjBhcGlfa2V5JTNEeHh4JTJDJTIwcmVzb3VyY2VfbmFtZSUzRHl5eSklMEFhZ2VudC5ydW4oJTIySXMlMjB0aGUlMjBmb2xsb3dpbmclMjAlNjB0ZXh0JTYwJTIwKGluJTIwU3BhbmlzaCklMjBwb3NpdGl2ZSUyMG9yJTIwbmVnYXRpdmUlM0YlMjIlMkMlMjB0ZXh0JTNEJTIyJUMyJUExRXN0ZSUyMGVzJTIwdW4lMjBBUEklMjBtdXklMjBhZ3JhZGFibGUhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AzureOpenAiAgent

agent = AzureAiAgent(deployment_id=<span class="hljs-string">&quot;Davinci-003&quot;</span>, api_key=xxx, resource_name=yyy)
agent.run(<span class="hljs-string">&quot;Is the following \`text\` (in Spanish) positive or negative?&quot;</span>, text=<span class="hljs-string">&quot;¡Este es un API muy agradable!&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,p=n(),g(c.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=y),p=r(a),f(c.$$.fragment,a)},m(a,w){d(a,l,w),d(a,p,w),u(c,a,w),v=!0},p:z,i(a){v||(h(c.$$.fragment,a),v=!0)},o(a){$(c.$$.fragment,a),v=!1},d(a){a&&(o(l),o(p)),_(c,a)}}}function Va(M){let l,y="Example:",p,c,v;return c=new Et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiklMEFhZ2VudC5jaGF0KCUyMkRyYXclMjBtZSUyMGElMjBwaWN0dXJlJTIwb2YlMjByaXZlcnMlMjBhbmQlMjBsYWtlcyUyMiklMEElMEFhZ2VudC5jaGF0KCUyMlRyYW5zZm9ybSUyMHRoZSUyMHBpY3R1cmUlMjBzbyUyMHRoYXQlMjB0aGVyZSUyMGlzJTIwYSUyMHJvY2slMjBpbiUyMHRoZXJlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>)
agent.chat(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes&quot;</span>)

agent.chat(<span class="hljs-string">&quot;Transform the picture so that there is a rock in there&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,p=n(),g(c.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=y),p=r(a),f(c.$$.fragment,a)},m(a,w){d(a,l,w),d(a,p,w),u(c,a,w),v=!0},p:z,i(a){v||(h(c.$$.fragment,a),v=!0)},o(a){$(c.$$.fragment,a),v=!1},d(a){a&&(o(l),o(p)),_(c,a)}}}function Na(M){let l,y="Example:",p,c,v;return c=new Et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiklMEFhZ2VudC5ydW4oJTIyRHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>)
agent.run(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,p=n(),g(c.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=y),p=r(a),f(c.$$.fragment,a)},m(a,w){d(a,l,w),d(a,p,w),u(c,a,w),v=!0},p:z,i(a){v||(h(c.$$.fragment,a),v=!0)},o(a){$(c.$$.fragment,a),v=!1},d(a){a&&(o(l),o(p)),_(c,a)}}}function Da(M){let l,y=`Loading a tool means that you’ll download the tool and execute it locally.
ALWAYS inspect the tool you’re downloading before loading it within your runtime, as you would do when
installing a package using pip/npm/apt.`;return{c(){l=i("p"),l.textContent=y},l(p){l=m(p,"P",{"data-svelte-h":!0}),b(l)!=="svelte-1kcherd"&&(l.textContent=y)},m(p,c){d(p,l,c)},p:z,d(p){p&&o(l)}}}function Ya(M){let l,y=`Loading a tool from the Hub means that you’ll download the tool and execute it locally.
ALWAYS inspect the tool you’re downloading before loading it within your runtime, as you would do when
installing a package using pip/npm/apt.`;return{c(){l=i("p"),l.textContent=y},l(p){l=m(p,"P",{"data-svelte-h":!0}),b(l)!=="svelte-fpk7e5"&&(l.textContent=y)},m(p,c){d(p,l,c)},p:z,d(p){p&&o(l)}}}function Ba(M){let l,y,p,c,v,a,w,ko,Pe,Wr=`To learn more about agents and tools make sure to read the <a href="../transformers_agents">introductory guide</a>. This page
contains the API docs for the underlying classes.`,Co,Je,Io,Ue,Rr='We provide three types of agents: <a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.HfAgent">HfAgent</a> uses inference endpoints for opensource models, <a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.LocalAgent">LocalAgent</a> uses a model of your choice locally and <a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.OpenAiAgent">OpenAiAgent</a> uses OpenAI closed models.',Ho,qe,Lo,G,Ee,An,Zt,zr="Agent that uses an inference endpoint to generate code.",Mn,ae,jo,Ze,Po,P,We,kn,Wt,Gr="Agent that uses a local model and tokenizer to generate code.",Cn,se,In,B,Re,Hn,Rt,Vr="Convenience method to build a <code>LocalAgent</code> from a pretrained checkpoint.",Ln,le,Jo,ze,Uo,J,Ge,jn,zt,Nr="Agent that uses the openai API to generate code.",Pn,ie,Jn,me,qo,Ve,Eo,U,Ne,Un,Gt,Dr=`Agent that uses Azure OpenAI to generate code. See the <a href="https://learn.microsoft.com/en-us/azure/cognitive-services/openai/" rel="nofollow">official
documentation</a> to learn how to deploy an openAI
model on Azure`,qn,de,En,pe,Zo,De,Wo,L,Ye,Zn,Vt,Yr="Base class for all agents which contains the main API methods.",Wn,F,Be,Rn,Nt,Br="Sends a new request to the agent in a chat. Will use the previous ones in its history.",zn,ce,Gn,S,Fe,Vn,Dt,Fr="Sends a request to the agent.",Nn,ge,Dn,fe,Se,Yn,Yt,Sr='Clears the history of prior calls to <a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.Agent.chat">chat()</a>.',Ro,Qe,zo,Xe,Go,V,Oe,Bn,Bt,Qr="Main function to quickly load a tool, be it on the Hub or in the Transformers library.",Fn,ue,Vo,Ke,No,k,et,Sn,Ft,Xr=`A base class for the functions used by the agent. Subclass this and implement the <code>__call__</code> method as well as the
following class attributes:`,Qn,St,Or=`<li><strong>description</strong> (<code>str</code>) — A short description of what your tool does, the inputs it expects and the output(s) it
will return. For instance ‘This is a tool that downloads a file from a <code>url</code>. It takes the <code>url</code> as input, and
returns the text contained in the file’.</li> <li><strong>name</strong> (<code>str</code>) — A performative name that will be used for your tool in the prompt to the agent. For instance
<code>&quot;text-classifier&quot;</code> or <code>&quot;image_generator&quot;</code>.</li> <li><strong>inputs</strong> (<code>List[str]</code>) — The list of modalities expected for the inputs (in the same order as in the call).
Modalitiies should be <code>&quot;text&quot;</code>, <code>&quot;image&quot;</code> or <code>&quot;audio&quot;</code>. This is only used by <code>launch_gradio_demo</code> or to make a
nice space from your tool.</li> <li><strong>outputs</strong> (<code>List[str]</code>) — The list of modalities returned but the tool (in the same order as the return of the
call method). Modalitiies should be <code>&quot;text&quot;</code>, <code>&quot;image&quot;</code> or <code>&quot;audio&quot;</code>. This is only used by <code>launch_gradio_demo</code>
or to make a nice space from your tool.</li>`,Xn,Qt,Kr=`You can also override the method <a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.Tool.setup">setup()</a> if your tool as an expensive operation to perform before being
usable (such as loading a model). <a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.Tool.setup">setup()</a> will be called the first time you use your tool, but not at
instantiation.`,On,he,tt,Kn,Xt,ea='Creates a <a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.Tool">Tool</a> from a gradio tool.',er,Q,ot,tr,Ot,ta="Loads a tool defined on the Hub.",or,$e,nr,_e,nt,rr,Kt,oa="Upload the tool to the Hub.",ar,R,rt,sr,eo,na=`Saves the relevant code files for your tool so it can be pushed to the Hub. This will copy the code of your
tool in <code>output_dir</code> as well as autogenerate:`,lr,to,ra=`<li>a config file named <code>tool_config.json</code></li> <li>an <code>app.py</code> file so that your tool can be converted to a space</li> <li>a <code>requirements.txt</code> containing the names of the module used by your tool (as detected when inspecting its
code)</li>`,ir,oo,aa="You should only use this method to save tools that are defined in a separate module (not <code>__main__</code>).",mr,be,at,dr,no,sa=`Overwrite this method here for any operation that is expensive and needs to be executed before you start using
your tool. Such as loading a big model.`,Do,st,Yo,I,lt,pr,ro,la=`A <a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.Tool">Tool</a> tailored towards Transformer models. On top of the class attributes of the base class <a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.Tool">Tool</a>, you will
need to specify:`,cr,ao,ia=`<li><strong>model_class</strong> (<code>type</code>) — The class to use to load the model in this tool.</li> <li><strong>default_checkpoint</strong> (<code>str</code>) — The default checkpoint that should be used when the user doesn’t specify one.</li> <li><strong>pre_processor_class</strong> (<code>type</code>, <em>optional</em>, defaults to <a href="/docs/transformers/v4.40.0/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a>) — The class to use to load the
pre-processor</li> <li><strong>post_processor_class</strong> (<code>type</code>, <em>optional</em>, defaults to <a href="/docs/transformers/v4.40.0/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a>) — The class to use to load the
post-processor (when different from the pre-processor).</li>`,gr,ve,it,fr,so,ma="Uses the <code>post_processor</code> to decode the model output.",ur,ye,mt,hr,lo,da="Uses the <code>pre_processor</code> to prepare the inputs for the <code>model</code>.",$r,we,dt,_r,io,pa="Sends the inputs through the <code>model</code>.",br,Te,pt,vr,mo,ca="Instantiates the <code>pre_processor</code>, <code>model</code> and <code>post_processor</code> if necessary.",Bo,ct,Fo,q,gt,yr,po,ga='A <a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.Tool">Tool</a> that will make requests to an inference endpoint.',wr,xe,ft,Tr,co,fa=`You can override this method in your custom class of <a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.RemoteTool">RemoteTool</a> to apply some custom post-processing of the
outputs of the endpoint.`,xr,X,ut,Ar,go,ua=`Prepare the inputs received for the HTTP client sending data to the endpoint. Positional arguments will be
matched with the signature of the <code>tool_class</code> if it was provided at instantation. Images will be encoded into
bytes.`,Mr,fo,ha='You can override this method in your custom class of <a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.RemoteTool">RemoteTool</a>.',So,ht,Qo,O,$t,kr,uo,$a=`Launches a gradio demo for a tool. The corresponding tool class needs to properly implement the class attributes
<code>inputs</code> and <code>outputs</code>.`,Xo,_t,Oo,bt,_a=`Agents can handle any type of object in-between tools; tools, being completely multimodal, can accept and return
text, image, audio, video, among other types. In order to increase compatibility between tools, as well as to
correctly render these returns in ipython (jupyter, colab, ipython notebooks, …), we implement wrapper classes
around these types.`,Ko,vt,ba=`The wrapped objects should continue behaving as initially; a text object should still behave as a string, an image
object should still behave as a <code>PIL.Image</code>.`,en,yt,va="These types have three specific purposes:",tn,wt,ya=`<li>Calling <code>to_raw</code> on the type should return the underlying object</li> <li>Calling <code>to_string</code> on the type should return the object as a string: that can be the string in case of an <code>AgentText</code>
but will be the path of the serialized version of the object in other instances</li> <li>Displaying it in an ipython kernel should display the object correctly</li>`,on,Tt,nn,K,xt,Cr,ho,wa="Text type returned by the agent. Behaves as a string.",rn,At,an,E,Mt,Ir,$o,Ta="Image type returned by the agent. Behaves as a PIL.Image.",Hr,Ae,kt,Lr,_o,xa="Returns the “raw” version of that object. In the case of an AgentImage, it is a PIL.Image.",jr,Me,Ct,Pr,bo,Aa=`Returns the stringified version of that object. In the case of an AgentImage, it is a path to the serialized
version of the image.`,sn,It,ln,Z,Ht,Jr,vo,Ma="Audio type returned by the agent.",Ur,ke,Lt,qr,yo,ka="Returns the “raw” version of that object. It is a <code>torch.Tensor</code> object.",Er,Ce,jt,Zr,wo,Ca=`Returns the stringified version of that object. In the case of an AgentAudio, it is a path to the serialized
version of the audio.`,mn,Pt,dn,Ao,pn;return v=new H({props:{title:"Agents & Tools",local:"agents--tools",headingTag:"h1"}}),w=new Mo({props:{warning:!0,$$slots:{default:[Ua]},$$scope:{ctx:M}}}),Je=new H({props:{title:"Agents",local:"agents",headingTag:"h2"}}),qe=new H({props:{title:"HfAgent",local:"transformers.HfAgent",headingTag:"h3"}}),Ee=new A({props:{name:"class transformers.HfAgent",anchor:"transformers.HfAgent",parameters:[{name:"url_endpoint",val:""},{name:"token",val:" = None"},{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.HfAgent.url_endpoint",description:`<strong>url_endpoint</strong> (<code>str</code>) &#x2014;
The name of the url endpoint to use.`,name:"url_endpoint"},{anchor:"transformers.HfAgent.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated when
running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.HfAgent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.HfAgent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.HfAgent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/agents.py#L595"}}),ae=new qt({props:{anchor:"transformers.HfAgent.example",$$slots:{default:[qa]},$$scope:{ctx:M}}}),Ze=new H({props:{title:"LocalAgent",local:"transformers.LocalAgent",headingTag:"h3"}}),We=new A({props:{name:"class transformers.LocalAgent",anchor:"transformers.LocalAgent",parameters:[{name:"model",val:""},{name:"tokenizer",val:""},{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.LocalAgent.model",description:`<strong>model</strong> (<a href="/docs/transformers/v4.40.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>) &#x2014;
The model to use for the agent.`,name:"model"},{anchor:"transformers.LocalAgent.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/v4.40.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for the agent.`,name:"tokenizer"},{anchor:"transformers.LocalAgent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.LocalAgent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.LocalAgent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/agents.py#L666"}}),se=new qt({props:{anchor:"transformers.LocalAgent.example",$$slots:{default:[Ea]},$$scope:{ctx:M}}}),Re=new A({props:{name:"from_pretrained",anchor:"transformers.LocalAgent.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LocalAgent.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The name of a repo on the Hub or a local path to a folder containing both model and tokenizer.`,name:"pretrained_model_name_or_path"},{anchor:"transformers.LocalAgent.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Keyword arguments passed along to <a href="/docs/transformers/v4.40.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/agents.py#L711"}}),le=new qt({props:{anchor:"transformers.LocalAgent.from_pretrained.example",$$slots:{default:[Za]},$$scope:{ctx:M}}}),ze=new H({props:{title:"OpenAiAgent",local:"transformers.OpenAiAgent",headingTag:"h3"}}),Ge=new A({props:{name:"class transformers.OpenAiAgent",anchor:"transformers.OpenAiAgent",parameters:[{name:"model",val:" = 'text-davinci-003'"},{name:"api_key",val:" = None"},{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.OpenAiAgent.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;text-davinci-003&quot;</code>) &#x2014;
The name of the OpenAI model to use.`,name:"model"},{anchor:"transformers.OpenAiAgent.api_key",description:`<strong>api_key</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API key to use. If unset, will look for the environment variable <code>&quot;OPENAI_API_KEY&quot;</code>.`,name:"api_key"},{anchor:"transformers.OpenAiAgent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.OpenAiAgent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.OpenAiAgent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/agents.py#L371"}}),ie=new Mo({props:{warning:!0,$$slots:{default:[Wa]},$$scope:{ctx:M}}}),me=new qt({props:{anchor:"transformers.OpenAiAgent.example",$$slots:{default:[Ra]},$$scope:{ctx:M}}}),Ve=new H({props:{title:"AzureOpenAiAgent",local:"transformers.AzureOpenAiAgent",headingTag:"h3"}}),Ne=new A({props:{name:"class transformers.AzureOpenAiAgent",anchor:"transformers.AzureOpenAiAgent",parameters:[{name:"deployment_id",val:""},{name:"api_key",val:" = None"},{name:"resource_name",val:" = None"},{name:"api_version",val:" = '2022-12-01'"},{name:"is_chat_model",val:" = None"},{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.AzureOpenAiAgent.deployment_id",description:`<strong>deployment_id</strong> (<code>str</code>) &#x2014;
The name of the deployed Azure openAI model to use.`,name:"deployment_id"},{anchor:"transformers.AzureOpenAiAgent.api_key",description:`<strong>api_key</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API key to use. If unset, will look for the environment variable <code>&quot;AZURE_OPENAI_API_KEY&quot;</code>.`,name:"api_key"},{anchor:"transformers.AzureOpenAiAgent.resource_name",description:`<strong>resource_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of your Azure OpenAI Resource. If unset, will look for the environment variable
<code>&quot;AZURE_OPENAI_RESOURCE_NAME&quot;</code>.`,name:"resource_name"},{anchor:"transformers.AzureOpenAiAgent.api_version",description:`<strong>api_version</strong> (<code>str</code>, <em>optional</em>, default to <code>&quot;2022-12-01&quot;</code>) &#x2014;
The API version to use for this agent.`,name:"api_version"},{anchor:"transformers.AzureOpenAiAgent.is_chat_mode",description:`<strong>is_chat_mode</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether you are using a completion model or a chat model (see note above, chat models won&#x2019;t be as
efficient). Will default to <code>gpt</code> being in the <code>deployment_id</code> or not.`,name:"is_chat_mode"},{anchor:"transformers.AzureOpenAiAgent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.AzureOpenAiAgent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.AzureOpenAiAgent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/agents.py#L469"}}),de=new Mo({props:{warning:!0,$$slots:{default:[za]},$$scope:{ctx:M}}}),pe=new qt({props:{anchor:"transformers.AzureOpenAiAgent.example",$$slots:{default:[Ga]},$$scope:{ctx:M}}}),De=new H({props:{title:"Agent",local:"transformers.Agent",headingTag:"h3"}}),Ye=new A({props:{name:"class transformers.Agent",anchor:"transformers.Agent",parameters:[{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.Agent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.Agent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.Agent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/v4.40.0/en/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/agents.py#L196"}}),Be=new A({props:{name:"chat",anchor:"transformers.Agent.chat",parameters:[{name:"task",val:""},{name:"return_code",val:" = False"},{name:"remote",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Agent.chat.task",description:"<strong>task</strong> (<code>str</code>) &#x2014; The task to perform",name:"task"},{anchor:"transformers.Agent.chat.return_code",description:`<strong>return_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to just return code and not evaluate it.`,name:"return_code"},{anchor:"transformers.Agent.chat.remote",description:`<strong>remote</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use remote tools (inference endpoints) instead of local ones.`,name:"remote"},{anchor:"transformers.Agent.chat.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Any keyword argument to send to the agent when evaluating the code.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/agents.py#L268"}}),ce=new qt({props:{anchor:"transformers.Agent.chat.example",$$slots:{default:[Va]},$$scope:{ctx:M}}}),Fe=new A({props:{name:"run",anchor:"transformers.Agent.run",parameters:[{name:"task",val:""},{name:"return_code",val:" = False"},{name:"remote",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Agent.run.task",description:"<strong>task</strong> (<code>str</code>) &#x2014; The task to perform",name:"task"},{anchor:"transformers.Agent.run.return_code",description:`<strong>return_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to just return code and not evaluate it.`,name:"return_code"},{anchor:"transformers.Agent.run.remote",description:`<strong>remote</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use remote tools (inference endpoints) instead of local ones.`,name:"remote"},{anchor:"transformers.Agent.run.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Any keyword argument to send to the agent when evaluating the code.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/agents.py#L325"}}),ge=new qt({props:{anchor:"transformers.Agent.run.example",$$slots:{default:[Na]},$$scope:{ctx:M}}}),Se=new A({props:{name:"prepare_for_new_chat",anchor:"transformers.Agent.prepare_for_new_chat",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/agents.py#L310"}}),Qe=new H({props:{title:"Tools",local:"tools",headingTag:"h2"}}),Xe=new H({props:{title:"load_tool",local:"transformers.load_tool",headingTag:"h3"}}),Oe=new A({props:{name:"transformers.load_tool",anchor:"transformers.load_tool",parameters:[{name:"task_or_repo_id",val:""},{name:"model_repo_id",val:" = None"},{name:"remote",val:" = False"},{name:"token",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.load_tool.task_or_repo_id",description:`<strong>task_or_repo_id</strong> (<code>str</code>) &#x2014;
The task for which to load the tool or a repo ID of a tool on the Hub. Tasks implemented in Transformers
are:</p>
<ul>
<li><code>&quot;document-question-answering&quot;</code></li>
<li><code>&quot;image-captioning&quot;</code></li>
<li><code>&quot;image-question-answering&quot;</code></li>
<li><code>&quot;image-segmentation&quot;</code></li>
<li><code>&quot;speech-to-text&quot;</code></li>
<li><code>&quot;summarization&quot;</code></li>
<li><code>&quot;text-classification&quot;</code></li>
<li><code>&quot;text-question-answering&quot;</code></li>
<li><code>&quot;text-to-speech&quot;</code></li>
<li><code>&quot;translation&quot;</code></li>
</ul>`,name:"task_or_repo_id"},{anchor:"transformers.load_tool.model_repo_id",description:`<strong>model_repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Use this argument to use a different model than the default one for the tool you selected.`,name:"model_repo_id"},{anchor:"transformers.load_tool.remote",description:`<strong>remote</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use your tool by downloading the model or (if it is available) with an inference endpoint.`,name:"remote"},{anchor:"transformers.load_tool.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to identify you on hf.co. If unset, will use the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.load_tool.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Additional keyword arguments that will be split in two: all arguments relevant to the Hub (such as
<code>cache_dir</code>, <code>revision</code>, <code>subfolder</code>) will be used when downloading the files for your tool, and the others
will be passed along to its init.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/base.py#L637"}}),ue=new Mo({props:{warning:!0,$$slots:{default:[Da]},$$scope:{ctx:M}}}),Ke=new H({props:{title:"Tool",local:"transformers.Tool",headingTag:"h3"}}),et=new A({props:{name:"class transformers.Tool",anchor:"transformers.Tool",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/base.py#L82"}}),tt=new A({props:{name:"from_gradio",anchor:"transformers.Tool.from_gradio",parameters:[{name:"gradio_tool",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/base.py#L341"}}),ot=new A({props:{name:"from_hub",anchor:"transformers.Tool.from_hub",parameters:[{name:"repo_id",val:": str"},{name:"model_repo_id",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"remote",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Tool.from_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repo on the Hub where your tool is defined.`,name:"repo_id"},{anchor:"transformers.Tool.from_hub.model_repo_id",description:`<strong>model_repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If your tool uses a model and you want to use a different model than the default, you can pass a second
repo ID or an endpoint url to this argument.`,name:"model_repo_id"},{anchor:"transformers.Tool.from_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to identify you on hf.co. If unset, will use the token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.Tool.from_hub.remote",description:`<strong>remote</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use your tool by downloading the model or (if it is available) with an inference endpoint.`,name:"remote"},{anchor:"transformers.Tool.from_hub.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Additional keyword arguments that will be split in two: all arguments relevant to the Hub (such as
<code>cache_dir</code>, <code>revision</code>, <code>subfolder</code>) will be used when downloading the files for your tool, and the
others will be passed along to its init.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/base.py#L177"}}),$e=new Mo({props:{warning:!0,$$slots:{default:[Ya]},$$scope:{ctx:M}}}),nt=new A({props:{name:"push_to_hub",anchor:"transformers.Tool.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": str = 'Upload tool'"},{name:"private",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"create_pr",val:": bool = False"}],parametersDescription:[{anchor:"transformers.Tool.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your tool to. It should contain your organization name when
pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.Tool.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;Upload tool&quot;</code>) &#x2014;
Message to commit while pushing.`,name:"commit_message"},{anchor:"transformers.Tool.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.Tool.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.Tool.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/base.py#L297"}}),rt=new A({props:{name:"save",anchor:"transformers.Tool.save",parameters:[{name:"output_dir",val:""}],parametersDescription:[{anchor:"transformers.Tool.save.output_dir",description:"<strong>output_dir</strong> (<code>str</code>) &#x2014; The folder in which you want to save your tool.",name:"output_dir"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/base.py#L123"}}),at=new A({props:{name:"setup",anchor:"transformers.Tool.setup",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/base.py#L116"}}),st=new H({props:{title:"PipelineTool",local:"transformers.PipelineTool",headingTag:"h3"}}),lt=new A({props:{name:"class transformers.PipelineTool",anchor:"transformers.PipelineTool",parameters:[{name:"model",val:" = None"},{name:"pre_processor",val:" = None"},{name:"post_processor",val:" = None"},{name:"device",val:" = None"},{name:"device_map",val:" = None"},{name:"model_kwargs",val:" = None"},{name:"token",val:" = None"},{name:"**hub_kwargs",val:""}],parametersDescription:[{anchor:"transformers.PipelineTool.model",description:`<strong>model</strong> (<code>str</code> or <a href="/docs/transformers/v4.40.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the model, or the instantiated model. If unset, will default to the
value of the class attribute <code>default_checkpoint</code>.`,name:"model"},{anchor:"transformers.PipelineTool.pre_processor",description:`<strong>pre_processor</strong> (<code>str</code> or <code>Any</code>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the pre-processor, or the instantiated pre-processor (can be a
tokenizer, an image processor, a feature extractor or a processor). Will default to the value of <code>model</code> if
unset.`,name:"pre_processor"},{anchor:"transformers.PipelineTool.post_processor",description:`<strong>post_processor</strong> (<code>str</code> or <code>Any</code>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the post-processor, or the instantiated pre-processor (can be a
tokenizer, an image processor, a feature extractor or a processor). Will default to the <code>pre_processor</code> if
unset.`,name:"post_processor"},{anchor:"transformers.PipelineTool.device",description:`<strong>device</strong> (<code>int</code>, <code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device on which to execute the model. Will default to any accelerator available (GPU, MPS etc&#x2026;), the
CPU otherwise.`,name:"device"},{anchor:"transformers.PipelineTool.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>dict</code>, <em>optional</em>) &#x2014;
If passed along, will be used to instantiate the model.`,name:"device_map"},{anchor:"transformers.PipelineTool.model_kwargs",description:`<strong>model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Any keyword argument to send to the model instantiation.`,name:"model_kwargs"},{anchor:"transformers.PipelineTool.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated when
running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.PipelineTool.hub_kwargs",description:`<strong>hub_kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Any additional keyword argument to send to the methods that will load the data from the Hub.`,name:"hub_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/base.py#L444"}}),it=new A({props:{name:"decode",anchor:"transformers.PipelineTool.decode",parameters:[{name:"outputs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/base.py#L563"}}),mt=new A({props:{name:"encode",anchor:"transformers.PipelineTool.encode",parameters:[{name:"raw_inputs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/base.py#L550"}}),dt=new A({props:{name:"forward",anchor:"transformers.PipelineTool.forward",parameters:[{name:"inputs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/base.py#L556"}}),pt=new A({props:{name:"setup",anchor:"transformers.PipelineTool.setup",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/base.py#L524"}}),ct=new H({props:{title:"RemoteTool",local:"transformers.RemoteTool",headingTag:"h3"}}),gt=new A({props:{name:"class transformers.RemoteTool",anchor:"transformers.RemoteTool",parameters:[{name:"endpoint_url",val:" = None"},{name:"token",val:" = None"},{name:"tool_class",val:" = None"}],parametersDescription:[{anchor:"transformers.RemoteTool.endpoint_url",description:`<strong>endpoint_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The url of the endpoint to use.`,name:"endpoint_url"},{anchor:"transformers.RemoteTool.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated when
running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.RemoteTool.tool_class",description:`<strong>tool_class</strong> (<code>type</code>, <em>optional</em>) &#x2014;
The corresponding <code>tool_class</code> if this is a remote version of an existing tool. Will help determine when
the output should be converted to another type (like images).`,name:"tool_class"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/base.py#L357"}}),ft=new A({props:{name:"extract_outputs",anchor:"transformers.RemoteTool.extract_outputs",parameters:[{name:"outputs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/base.py#L420"}}),ut=new A({props:{name:"prepare_inputs",anchor:"transformers.RemoteTool.prepare_inputs",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/base.py#L377"}}),ht=new H({props:{title:"launch_gradio_demo",local:"transformers.launch_gradio_demo",headingTag:"h3"}}),$t=new A({props:{name:"transformers.launch_gradio_demo",anchor:"transformers.launch_gradio_demo",parameters:[{name:"tool_class",val:": Tool"}],parametersDescription:[{anchor:"transformers.launch_gradio_demo.tool_class",description:"<strong>tool_class</strong> (<code>type</code>) &#x2014; The class of the tool for which to launch the demo.",name:"tool_class"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/base.py#L584"}}),_t=new H({props:{title:"Agent Types",local:"agent-types",headingTag:"h2"}}),Tt=new H({props:{title:"AgentText",local:"transformers.tools.agent_types.AgentText",headingTag:"h3"}}),xt=new A({props:{name:"class transformers.tools.agent_types.AgentText",anchor:"transformers.tools.agent_types.AgentText",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/agent_types.py#L71"}}),At=new H({props:{title:"AgentImage",local:"transformers.tools.agent_types.AgentImage",headingTag:"h3"}}),Mt=new A({props:{name:"class transformers.tools.agent_types.AgentImage",anchor:"transformers.tools.agent_types.AgentImage",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/agent_types.py#L83"}}),kt=new A({props:{name:"to_raw",anchor:"transformers.tools.agent_types.AgentImage.to_raw",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/agent_types.py#L115"}}),Ct=new A({props:{name:"to_string",anchor:"transformers.tools.agent_types.AgentImage.to_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/agent_types.py#L126"}}),It=new H({props:{title:"AgentAudio",local:"transformers.tools.agent_types.AgentAudio",headingTag:"h3"}}),Ht=new A({props:{name:"class transformers.tools.agent_types.AgentAudio",anchor:"transformers.tools.agent_types.AgentAudio",parameters:[{name:"value",val:""},{name:"samplerate",val:" = 16000"}],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/agent_types.py#L155"}}),Lt=new A({props:{name:"to_raw",anchor:"transformers.tools.agent_types.AgentAudio.to_raw",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/agent_types.py#L186"}}),jt=new A({props:{name:"to_string",anchor:"transformers.tools.agent_types.AgentAudio.to_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.0/src/transformers/tools/agent_types.py#L198"}}),Pt=new Ja({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/main_classes/agent.md"}}),{c(){l=i("meta"),y=n(),p=i("p"),c=n(),g(v.$$.fragment),a=n(),g(w.$$.fragment),ko=n(),Pe=i("p"),Pe.innerHTML=Wr,Co=n(),g(Je.$$.fragment),Io=n(),Ue=i("p"),Ue.innerHTML=Rr,Ho=n(),g(qe.$$.fragment),Lo=n(),G=i("div"),g(Ee.$$.fragment),An=n(),Zt=i("p"),Zt.textContent=zr,Mn=n(),g(ae.$$.fragment),jo=n(),g(Ze.$$.fragment),Po=n(),P=i("div"),g(We.$$.fragment),kn=n(),Wt=i("p"),Wt.textContent=Gr,Cn=n(),g(se.$$.fragment),In=n(),B=i("div"),g(Re.$$.fragment),Hn=n(),Rt=i("p"),Rt.innerHTML=Vr,Ln=n(),g(le.$$.fragment),Jo=n(),g(ze.$$.fragment),Uo=n(),J=i("div"),g(Ge.$$.fragment),jn=n(),zt=i("p"),zt.textContent=Nr,Pn=n(),g(ie.$$.fragment),Jn=n(),g(me.$$.fragment),qo=n(),g(Ve.$$.fragment),Eo=n(),U=i("div"),g(Ne.$$.fragment),Un=n(),Gt=i("p"),Gt.innerHTML=Dr,qn=n(),g(de.$$.fragment),En=n(),g(pe.$$.fragment),Zo=n(),g(De.$$.fragment),Wo=n(),L=i("div"),g(Ye.$$.fragment),Zn=n(),Vt=i("p"),Vt.textContent=Yr,Wn=n(),F=i("div"),g(Be.$$.fragment),Rn=n(),Nt=i("p"),Nt.textContent=Br,zn=n(),g(ce.$$.fragment),Gn=n(),S=i("div"),g(Fe.$$.fragment),Vn=n(),Dt=i("p"),Dt.textContent=Fr,Nn=n(),g(ge.$$.fragment),Dn=n(),fe=i("div"),g(Se.$$.fragment),Yn=n(),Yt=i("p"),Yt.innerHTML=Sr,Ro=n(),g(Qe.$$.fragment),zo=n(),g(Xe.$$.fragment),Go=n(),V=i("div"),g(Oe.$$.fragment),Bn=n(),Bt=i("p"),Bt.textContent=Qr,Fn=n(),g(ue.$$.fragment),Vo=n(),g(Ke.$$.fragment),No=n(),k=i("div"),g(et.$$.fragment),Sn=n(),Ft=i("p"),Ft.innerHTML=Xr,Qn=n(),St=i("ul"),St.innerHTML=Or,Xn=n(),Qt=i("p"),Qt.innerHTML=Kr,On=n(),he=i("div"),g(tt.$$.fragment),Kn=n(),Xt=i("p"),Xt.innerHTML=ea,er=n(),Q=i("div"),g(ot.$$.fragment),tr=n(),Ot=i("p"),Ot.textContent=ta,or=n(),g($e.$$.fragment),nr=n(),_e=i("div"),g(nt.$$.fragment),rr=n(),Kt=i("p"),Kt.textContent=oa,ar=n(),R=i("div"),g(rt.$$.fragment),sr=n(),eo=i("p"),eo.innerHTML=na,lr=n(),to=i("ul"),to.innerHTML=ra,ir=n(),oo=i("p"),oo.innerHTML=aa,mr=n(),be=i("div"),g(at.$$.fragment),dr=n(),no=i("p"),no.textContent=sa,Do=n(),g(st.$$.fragment),Yo=n(),I=i("div"),g(lt.$$.fragment),pr=n(),ro=i("p"),ro.innerHTML=la,cr=n(),ao=i("ul"),ao.innerHTML=ia,gr=n(),ve=i("div"),g(it.$$.fragment),fr=n(),so=i("p"),so.innerHTML=ma,ur=n(),ye=i("div"),g(mt.$$.fragment),hr=n(),lo=i("p"),lo.innerHTML=da,$r=n(),we=i("div"),g(dt.$$.fragment),_r=n(),io=i("p"),io.innerHTML=pa,br=n(),Te=i("div"),g(pt.$$.fragment),vr=n(),mo=i("p"),mo.innerHTML=ca,Bo=n(),g(ct.$$.fragment),Fo=n(),q=i("div"),g(gt.$$.fragment),yr=n(),po=i("p"),po.innerHTML=ga,wr=n(),xe=i("div"),g(ft.$$.fragment),Tr=n(),co=i("p"),co.innerHTML=fa,xr=n(),X=i("div"),g(ut.$$.fragment),Ar=n(),go=i("p"),go.innerHTML=ua,Mr=n(),fo=i("p"),fo.innerHTML=ha,So=n(),g(ht.$$.fragment),Qo=n(),O=i("div"),g($t.$$.fragment),kr=n(),uo=i("p"),uo.innerHTML=$a,Xo=n(),g(_t.$$.fragment),Oo=n(),bt=i("p"),bt.textContent=_a,Ko=n(),vt=i("p"),vt.innerHTML=ba,en=n(),yt=i("p"),yt.textContent=va,tn=n(),wt=i("ul"),wt.innerHTML=ya,on=n(),g(Tt.$$.fragment),nn=n(),K=i("div"),g(xt.$$.fragment),Cr=n(),ho=i("p"),ho.textContent=wa,rn=n(),g(At.$$.fragment),an=n(),E=i("div"),g(Mt.$$.fragment),Ir=n(),$o=i("p"),$o.textContent=Ta,Hr=n(),Ae=i("div"),g(kt.$$.fragment),Lr=n(),_o=i("p"),_o.textContent=xa,jr=n(),Me=i("div"),g(Ct.$$.fragment),Pr=n(),bo=i("p"),bo.textContent=Aa,sn=n(),g(It.$$.fragment),ln=n(),Z=i("div"),g(Ht.$$.fragment),Jr=n(),vo=i("p"),vo.textContent=Ma,Ur=n(),ke=i("div"),g(Lt.$$.fragment),qr=n(),yo=i("p"),yo.innerHTML=ka,Er=n(),Ce=i("div"),g(jt.$$.fragment),Zr=n(),wo=i("p"),wo.textContent=Ca,mn=n(),g(Pt.$$.fragment),dn=n(),Ao=i("p"),this.h()},l(e){const s=Pa("svelte-u9bgzb",document.head);l=m(s,"META",{name:!0,content:!0}),s.forEach(o),y=r(e),p=m(e,"P",{}),T(p).forEach(o),c=r(e),f(v.$$.fragment,e),a=r(e),f(w.$$.fragment,e),ko=r(e),Pe=m(e,"P",{"data-svelte-h":!0}),b(Pe)!=="svelte-7mj07q"&&(Pe.innerHTML=Wr),Co=r(e),f(Je.$$.fragment,e),Io=r(e),Ue=m(e,"P",{"data-svelte-h":!0}),b(Ue)!=="svelte-b4kkgn"&&(Ue.innerHTML=Rr),Ho=r(e),f(qe.$$.fragment,e),Lo=r(e),G=m(e,"DIV",{class:!0});var ee=T(G);f(Ee.$$.fragment,ee),An=r(ee),Zt=m(ee,"P",{"data-svelte-h":!0}),b(Zt)!=="svelte-1uej11q"&&(Zt.textContent=zr),Mn=r(ee),f(ae.$$.fragment,ee),ee.forEach(o),jo=r(e),f(Ze.$$.fragment,e),Po=r(e),P=m(e,"DIV",{class:!0});var N=T(P);f(We.$$.fragment,N),kn=r(N),Wt=m(N,"P",{"data-svelte-h":!0}),b(Wt)!=="svelte-1q3iegi"&&(Wt.textContent=Gr),Cn=r(N),f(se.$$.fragment,N),In=r(N),B=m(N,"DIV",{class:!0});var te=T(B);f(Re.$$.fragment,te),Hn=r(te),Rt=m(te,"P",{"data-svelte-h":!0}),b(Rt)!=="svelte-1qh3hl2"&&(Rt.innerHTML=Vr),Ln=r(te),f(le.$$.fragment,te),te.forEach(o),N.forEach(o),Jo=r(e),f(ze.$$.fragment,e),Uo=r(e),J=m(e,"DIV",{class:!0});var D=T(J);f(Ge.$$.fragment,D),jn=r(D),zt=m(D,"P",{"data-svelte-h":!0}),b(zt)!=="svelte-182hy5g"&&(zt.textContent=Nr),Pn=r(D),f(ie.$$.fragment,D),Jn=r(D),f(me.$$.fragment,D),D.forEach(o),qo=r(e),f(Ve.$$.fragment,e),Eo=r(e),U=m(e,"DIV",{class:!0});var Y=T(U);f(Ne.$$.fragment,Y),Un=r(Y),Gt=m(Y,"P",{"data-svelte-h":!0}),b(Gt)!=="svelte-1eoncpw"&&(Gt.innerHTML=Dr),qn=r(Y),f(de.$$.fragment,Y),En=r(Y),f(pe.$$.fragment,Y),Y.forEach(o),Zo=r(e),f(De.$$.fragment,e),Wo=r(e),L=m(e,"DIV",{class:!0});var W=T(L);f(Ye.$$.fragment,W),Zn=r(W),Vt=m(W,"P",{"data-svelte-h":!0}),b(Vt)!=="svelte-1phtukb"&&(Vt.textContent=Yr),Wn=r(W),F=m(W,"DIV",{class:!0});var oe=T(F);f(Be.$$.fragment,oe),Rn=r(oe),Nt=m(oe,"P",{"data-svelte-h":!0}),b(Nt)!=="svelte-1s1qxmr"&&(Nt.textContent=Br),zn=r(oe),f(ce.$$.fragment,oe),oe.forEach(o),Gn=r(W),S=m(W,"DIV",{class:!0});var ne=T(S);f(Fe.$$.fragment,ne),Vn=r(ne),Dt=m(ne,"P",{"data-svelte-h":!0}),b(Dt)!=="svelte-1685qxi"&&(Dt.textContent=Fr),Nn=r(ne),f(ge.$$.fragment,ne),ne.forEach(o),Dn=r(W),fe=m(W,"DIV",{class:!0});var Jt=T(fe);f(Se.$$.fragment,Jt),Yn=r(Jt),Yt=m(Jt,"P",{"data-svelte-h":!0}),b(Yt)!=="svelte-myer6d"&&(Yt.innerHTML=Sr),Jt.forEach(o),W.forEach(o),Ro=r(e),f(Qe.$$.fragment,e),zo=r(e),f(Xe.$$.fragment,e),Go=r(e),V=m(e,"DIV",{class:!0});var re=T(V);f(Oe.$$.fragment,re),Bn=r(re),Bt=m(re,"P",{"data-svelte-h":!0}),b(Bt)!=="svelte-16uh3p8"&&(Bt.textContent=Qr),Fn=r(re),f(ue.$$.fragment,re),re.forEach(o),Vo=r(e),f(Ke.$$.fragment,e),No=r(e),k=m(e,"DIV",{class:!0});var C=T(k);f(et.$$.fragment,C),Sn=r(C),Ft=m(C,"P",{"data-svelte-h":!0}),b(Ft)!=="svelte-cca4c5"&&(Ft.innerHTML=Xr),Qn=r(C),St=m(C,"UL",{"data-svelte-h":!0}),b(St)!=="svelte-1lb1si5"&&(St.innerHTML=Or),Xn=r(C),Qt=m(C,"P",{"data-svelte-h":!0}),b(Qt)!=="svelte-bzumag"&&(Qt.innerHTML=Kr),On=r(C),he=m(C,"DIV",{class:!0});var Ut=T(he);f(tt.$$.fragment,Ut),Kn=r(Ut),Xt=m(Ut,"P",{"data-svelte-h":!0}),b(Xt)!=="svelte-1wp6hm4"&&(Xt.innerHTML=ea),Ut.forEach(o),er=r(C),Q=m(C,"DIV",{class:!0});var To=T(Q);f(ot.$$.fragment,To),tr=r(To),Ot=m(To,"P",{"data-svelte-h":!0}),b(Ot)!=="svelte-yy7b2c"&&(Ot.textContent=ta),or=r(To),f($e.$$.fragment,To),To.forEach(o),nr=r(C),_e=m(C,"DIV",{class:!0});var cn=T(_e);f(nt.$$.fragment,cn),rr=r(cn),Kt=m(cn,"P",{"data-svelte-h":!0}),b(Kt)!=="svelte-1u3gku9"&&(Kt.textContent=oa),cn.forEach(o),ar=r(C),R=m(C,"DIV",{class:!0});var Ie=T(R);f(rt.$$.fragment,Ie),sr=r(Ie),eo=m(Ie,"P",{"data-svelte-h":!0}),b(eo)!=="svelte-19evuwa"&&(eo.innerHTML=na),lr=r(Ie),to=m(Ie,"UL",{"data-svelte-h":!0}),b(to)!=="svelte-15of9ze"&&(to.innerHTML=ra),ir=r(Ie),oo=m(Ie,"P",{"data-svelte-h":!0}),b(oo)!=="svelte-msa4ge"&&(oo.innerHTML=aa),Ie.forEach(o),mr=r(C),be=m(C,"DIV",{class:!0});var gn=T(be);f(at.$$.fragment,gn),dr=r(gn),no=m(gn,"P",{"data-svelte-h":!0}),b(no)!=="svelte-63kthh"&&(no.textContent=sa),gn.forEach(o),C.forEach(o),Do=r(e),f(st.$$.fragment,e),Yo=r(e),I=m(e,"DIV",{class:!0});var j=T(I);f(lt.$$.fragment,j),pr=r(j),ro=m(j,"P",{"data-svelte-h":!0}),b(ro)!=="svelte-jm9sbl"&&(ro.innerHTML=la),cr=r(j),ao=m(j,"UL",{"data-svelte-h":!0}),b(ao)!=="svelte-170qi84"&&(ao.innerHTML=ia),gr=r(j),ve=m(j,"DIV",{class:!0});var fn=T(ve);f(it.$$.fragment,fn),fr=r(fn),so=m(fn,"P",{"data-svelte-h":!0}),b(so)!=="svelte-zkjq4t"&&(so.innerHTML=ma),fn.forEach(o),ur=r(j),ye=m(j,"DIV",{class:!0});var un=T(ye);f(mt.$$.fragment,un),hr=r(un),lo=m(un,"P",{"data-svelte-h":!0}),b(lo)!=="svelte-1vxzk80"&&(lo.innerHTML=da),un.forEach(o),$r=r(j),we=m(j,"DIV",{class:!0});var hn=T(we);f(dt.$$.fragment,hn),_r=r(hn),io=m(hn,"P",{"data-svelte-h":!0}),b(io)!=="svelte-1qgsi13"&&(io.innerHTML=pa),hn.forEach(o),br=r(j),Te=m(j,"DIV",{class:!0});var $n=T(Te);f(pt.$$.fragment,$n),vr=r($n),mo=m($n,"P",{"data-svelte-h":!0}),b(mo)!=="svelte-1ojxz66"&&(mo.innerHTML=ca),$n.forEach(o),j.forEach(o),Bo=r(e),f(ct.$$.fragment,e),Fo=r(e),q=m(e,"DIV",{class:!0});var He=T(q);f(gt.$$.fragment,He),yr=r(He),po=m(He,"P",{"data-svelte-h":!0}),b(po)!=="svelte-1d9nmqd"&&(po.innerHTML=ga),wr=r(He),xe=m(He,"DIV",{class:!0});var _n=T(xe);f(ft.$$.fragment,_n),Tr=r(_n),co=m(_n,"P",{"data-svelte-h":!0}),b(co)!=="svelte-ip9ol4"&&(co.innerHTML=fa),_n.forEach(o),xr=r(He),X=m(He,"DIV",{class:!0});var xo=T(X);f(ut.$$.fragment,xo),Ar=r(xo),go=m(xo,"P",{"data-svelte-h":!0}),b(go)!=="svelte-14yhe1"&&(go.innerHTML=ua),Mr=r(xo),fo=m(xo,"P",{"data-svelte-h":!0}),b(fo)!=="svelte-ip7nup"&&(fo.innerHTML=ha),xo.forEach(o),He.forEach(o),So=r(e),f(ht.$$.fragment,e),Qo=r(e),O=m(e,"DIV",{class:!0});var bn=T(O);f($t.$$.fragment,bn),kr=r(bn),uo=m(bn,"P",{"data-svelte-h":!0}),b(uo)!=="svelte-78dinl"&&(uo.innerHTML=$a),bn.forEach(o),Xo=r(e),f(_t.$$.fragment,e),Oo=r(e),bt=m(e,"P",{"data-svelte-h":!0}),b(bt)!=="svelte-jsq4jz"&&(bt.textContent=_a),Ko=r(e),vt=m(e,"P",{"data-svelte-h":!0}),b(vt)!=="svelte-1ixcu88"&&(vt.innerHTML=ba),en=r(e),yt=m(e,"P",{"data-svelte-h":!0}),b(yt)!=="svelte-1nfvcwf"&&(yt.textContent=va),tn=r(e),wt=m(e,"UL",{"data-svelte-h":!0}),b(wt)!=="svelte-ysem30"&&(wt.innerHTML=ya),on=r(e),f(Tt.$$.fragment,e),nn=r(e),K=m(e,"DIV",{class:!0});var vn=T(K);f(xt.$$.fragment,vn),Cr=r(vn),ho=m(vn,"P",{"data-svelte-h":!0}),b(ho)!=="svelte-57fhj7"&&(ho.textContent=wa),vn.forEach(o),rn=r(e),f(At.$$.fragment,e),an=r(e),E=m(e,"DIV",{class:!0});var Le=T(E);f(Mt.$$.fragment,Le),Ir=r(Le),$o=m(Le,"P",{"data-svelte-h":!0}),b($o)!=="svelte-1hsb0qs"&&($o.textContent=Ta),Hr=r(Le),Ae=m(Le,"DIV",{class:!0});var yn=T(Ae);f(kt.$$.fragment,yn),Lr=r(yn),_o=m(yn,"P",{"data-svelte-h":!0}),b(_o)!=="svelte-ybie7i"&&(_o.textContent=xa),yn.forEach(o),jr=r(Le),Me=m(Le,"DIV",{class:!0});var wn=T(Me);f(Ct.$$.fragment,wn),Pr=r(wn),bo=m(wn,"P",{"data-svelte-h":!0}),b(bo)!=="svelte-chc6sp"&&(bo.textContent=Aa),wn.forEach(o),Le.forEach(o),sn=r(e),f(It.$$.fragment,e),ln=r(e),Z=m(e,"DIV",{class:!0});var je=T(Z);f(Ht.$$.fragment,je),Jr=r(je),vo=m(je,"P",{"data-svelte-h":!0}),b(vo)!=="svelte-ckiqb6"&&(vo.textContent=Ma),Ur=r(je),ke=m(je,"DIV",{class:!0});var Tn=T(ke);f(Lt.$$.fragment,Tn),qr=r(Tn),yo=m(Tn,"P",{"data-svelte-h":!0}),b(yo)!=="svelte-10rnn1x"&&(yo.innerHTML=ka),Tn.forEach(o),Er=r(je),Ce=m(je,"DIV",{class:!0});var xn=T(Ce);f(jt.$$.fragment,xn),Zr=r(xn),wo=m(xn,"P",{"data-svelte-h":!0}),b(wo)!=="svelte-1xu9o93"&&(wo.textContent=Ca),xn.forEach(o),je.forEach(o),mn=r(e),f(Pt.$$.fragment,e),dn=r(e),Ao=m(e,"P",{}),T(Ao).forEach(o),this.h()},h(){x(l,"name","hf:doc:metadata"),x(l,"content",Fa),x(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){t(document.head,l),d(e,y,s),d(e,p,s),d(e,c,s),u(v,e,s),d(e,a,s),u(w,e,s),d(e,ko,s),d(e,Pe,s),d(e,Co,s),u(Je,e,s),d(e,Io,s),d(e,Ue,s),d(e,Ho,s),u(qe,e,s),d(e,Lo,s),d(e,G,s),u(Ee,G,null),t(G,An),t(G,Zt),t(G,Mn),u(ae,G,null),d(e,jo,s),u(Ze,e,s),d(e,Po,s),d(e,P,s),u(We,P,null),t(P,kn),t(P,Wt),t(P,Cn),u(se,P,null),t(P,In),t(P,B),u(Re,B,null),t(B,Hn),t(B,Rt),t(B,Ln),u(le,B,null),d(e,Jo,s),u(ze,e,s),d(e,Uo,s),d(e,J,s),u(Ge,J,null),t(J,jn),t(J,zt),t(J,Pn),u(ie,J,null),t(J,Jn),u(me,J,null),d(e,qo,s),u(Ve,e,s),d(e,Eo,s),d(e,U,s),u(Ne,U,null),t(U,Un),t(U,Gt),t(U,qn),u(de,U,null),t(U,En),u(pe,U,null),d(e,Zo,s),u(De,e,s),d(e,Wo,s),d(e,L,s),u(Ye,L,null),t(L,Zn),t(L,Vt),t(L,Wn),t(L,F),u(Be,F,null),t(F,Rn),t(F,Nt),t(F,zn),u(ce,F,null),t(L,Gn),t(L,S),u(Fe,S,null),t(S,Vn),t(S,Dt),t(S,Nn),u(ge,S,null),t(L,Dn),t(L,fe),u(Se,fe,null),t(fe,Yn),t(fe,Yt),d(e,Ro,s),u(Qe,e,s),d(e,zo,s),u(Xe,e,s),d(e,Go,s),d(e,V,s),u(Oe,V,null),t(V,Bn),t(V,Bt),t(V,Fn),u(ue,V,null),d(e,Vo,s),u(Ke,e,s),d(e,No,s),d(e,k,s),u(et,k,null),t(k,Sn),t(k,Ft),t(k,Qn),t(k,St),t(k,Xn),t(k,Qt),t(k,On),t(k,he),u(tt,he,null),t(he,Kn),t(he,Xt),t(k,er),t(k,Q),u(ot,Q,null),t(Q,tr),t(Q,Ot),t(Q,or),u($e,Q,null),t(k,nr),t(k,_e),u(nt,_e,null),t(_e,rr),t(_e,Kt),t(k,ar),t(k,R),u(rt,R,null),t(R,sr),t(R,eo),t(R,lr),t(R,to),t(R,ir),t(R,oo),t(k,mr),t(k,be),u(at,be,null),t(be,dr),t(be,no),d(e,Do,s),u(st,e,s),d(e,Yo,s),d(e,I,s),u(lt,I,null),t(I,pr),t(I,ro),t(I,cr),t(I,ao),t(I,gr),t(I,ve),u(it,ve,null),t(ve,fr),t(ve,so),t(I,ur),t(I,ye),u(mt,ye,null),t(ye,hr),t(ye,lo),t(I,$r),t(I,we),u(dt,we,null),t(we,_r),t(we,io),t(I,br),t(I,Te),u(pt,Te,null),t(Te,vr),t(Te,mo),d(e,Bo,s),u(ct,e,s),d(e,Fo,s),d(e,q,s),u(gt,q,null),t(q,yr),t(q,po),t(q,wr),t(q,xe),u(ft,xe,null),t(xe,Tr),t(xe,co),t(q,xr),t(q,X),u(ut,X,null),t(X,Ar),t(X,go),t(X,Mr),t(X,fo),d(e,So,s),u(ht,e,s),d(e,Qo,s),d(e,O,s),u($t,O,null),t(O,kr),t(O,uo),d(e,Xo,s),u(_t,e,s),d(e,Oo,s),d(e,bt,s),d(e,Ko,s),d(e,vt,s),d(e,en,s),d(e,yt,s),d(e,tn,s),d(e,wt,s),d(e,on,s),u(Tt,e,s),d(e,nn,s),d(e,K,s),u(xt,K,null),t(K,Cr),t(K,ho),d(e,rn,s),u(At,e,s),d(e,an,s),d(e,E,s),u(Mt,E,null),t(E,Ir),t(E,$o),t(E,Hr),t(E,Ae),u(kt,Ae,null),t(Ae,Lr),t(Ae,_o),t(E,jr),t(E,Me),u(Ct,Me,null),t(Me,Pr),t(Me,bo),d(e,sn,s),u(It,e,s),d(e,ln,s),d(e,Z,s),u(Ht,Z,null),t(Z,Jr),t(Z,vo),t(Z,Ur),t(Z,ke),u(Lt,ke,null),t(ke,qr),t(ke,yo),t(Z,Er),t(Z,Ce),u(jt,Ce,null),t(Ce,Zr),t(Ce,wo),d(e,mn,s),u(Pt,e,s),d(e,dn,s),d(e,Ao,s),pn=!0},p(e,[s]){const ee={};s&2&&(ee.$$scope={dirty:s,ctx:e}),w.$set(ee);const N={};s&2&&(N.$$scope={dirty:s,ctx:e}),ae.$set(N);const te={};s&2&&(te.$$scope={dirty:s,ctx:e}),se.$set(te);const D={};s&2&&(D.$$scope={dirty:s,ctx:e}),le.$set(D);const Y={};s&2&&(Y.$$scope={dirty:s,ctx:e}),ie.$set(Y);const W={};s&2&&(W.$$scope={dirty:s,ctx:e}),me.$set(W);const oe={};s&2&&(oe.$$scope={dirty:s,ctx:e}),de.$set(oe);const ne={};s&2&&(ne.$$scope={dirty:s,ctx:e}),pe.$set(ne);const Jt={};s&2&&(Jt.$$scope={dirty:s,ctx:e}),ce.$set(Jt);const re={};s&2&&(re.$$scope={dirty:s,ctx:e}),ge.$set(re);const C={};s&2&&(C.$$scope={dirty:s,ctx:e}),ue.$set(C);const Ut={};s&2&&(Ut.$$scope={dirty:s,ctx:e}),$e.$set(Ut)},i(e){pn||(h(v.$$.fragment,e),h(w.$$.fragment,e),h(Je.$$.fragment,e),h(qe.$$.fragment,e),h(Ee.$$.fragment,e),h(ae.$$.fragment,e),h(Ze.$$.fragment,e),h(We.$$.fragment,e),h(se.$$.fragment,e),h(Re.$$.fragment,e),h(le.$$.fragment,e),h(ze.$$.fragment,e),h(Ge.$$.fragment,e),h(ie.$$.fragment,e),h(me.$$.fragment,e),h(Ve.$$.fragment,e),h(Ne.$$.fragment,e),h(de.$$.fragment,e),h(pe.$$.fragment,e),h(De.$$.fragment,e),h(Ye.$$.fragment,e),h(Be.$$.fragment,e),h(ce.$$.fragment,e),h(Fe.$$.fragment,e),h(ge.$$.fragment,e),h(Se.$$.fragment,e),h(Qe.$$.fragment,e),h(Xe.$$.fragment,e),h(Oe.$$.fragment,e),h(ue.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(ot.$$.fragment,e),h($e.$$.fragment,e),h(nt.$$.fragment,e),h(rt.$$.fragment,e),h(at.$$.fragment,e),h(st.$$.fragment,e),h(lt.$$.fragment,e),h(it.$$.fragment,e),h(mt.$$.fragment,e),h(dt.$$.fragment,e),h(pt.$$.fragment,e),h(ct.$$.fragment,e),h(gt.$$.fragment,e),h(ft.$$.fragment,e),h(ut.$$.fragment,e),h(ht.$$.fragment,e),h($t.$$.fragment,e),h(_t.$$.fragment,e),h(Tt.$$.fragment,e),h(xt.$$.fragment,e),h(At.$$.fragment,e),h(Mt.$$.fragment,e),h(kt.$$.fragment,e),h(Ct.$$.fragment,e),h(It.$$.fragment,e),h(Ht.$$.fragment,e),h(Lt.$$.fragment,e),h(jt.$$.fragment,e),h(Pt.$$.fragment,e),pn=!0)},o(e){$(v.$$.fragment,e),$(w.$$.fragment,e),$(Je.$$.fragment,e),$(qe.$$.fragment,e),$(Ee.$$.fragment,e),$(ae.$$.fragment,e),$(Ze.$$.fragment,e),$(We.$$.fragment,e),$(se.$$.fragment,e),$(Re.$$.fragment,e),$(le.$$.fragment,e),$(ze.$$.fragment,e),$(Ge.$$.fragment,e),$(ie.$$.fragment,e),$(me.$$.fragment,e),$(Ve.$$.fragment,e),$(Ne.$$.fragment,e),$(de.$$.fragment,e),$(pe.$$.fragment,e),$(De.$$.fragment,e),$(Ye.$$.fragment,e),$(Be.$$.fragment,e),$(ce.$$.fragment,e),$(Fe.$$.fragment,e),$(ge.$$.fragment,e),$(Se.$$.fragment,e),$(Qe.$$.fragment,e),$(Xe.$$.fragment,e),$(Oe.$$.fragment,e),$(ue.$$.fragment,e),$(Ke.$$.fragment,e),$(et.$$.fragment,e),$(tt.$$.fragment,e),$(ot.$$.fragment,e),$($e.$$.fragment,e),$(nt.$$.fragment,e),$(rt.$$.fragment,e),$(at.$$.fragment,e),$(st.$$.fragment,e),$(lt.$$.fragment,e),$(it.$$.fragment,e),$(mt.$$.fragment,e),$(dt.$$.fragment,e),$(pt.$$.fragment,e),$(ct.$$.fragment,e),$(gt.$$.fragment,e),$(ft.$$.fragment,e),$(ut.$$.fragment,e),$(ht.$$.fragment,e),$($t.$$.fragment,e),$(_t.$$.fragment,e),$(Tt.$$.fragment,e),$(xt.$$.fragment,e),$(At.$$.fragment,e),$(Mt.$$.fragment,e),$(kt.$$.fragment,e),$(Ct.$$.fragment,e),$(It.$$.fragment,e),$(Ht.$$.fragment,e),$(Lt.$$.fragment,e),$(jt.$$.fragment,e),$(Pt.$$.fragment,e),pn=!1},d(e){e&&(o(y),o(p),o(c),o(a),o(ko),o(Pe),o(Co),o(Io),o(Ue),o(Ho),o(Lo),o(G),o(jo),o(Po),o(P),o(Jo),o(Uo),o(J),o(qo),o(Eo),o(U),o(Zo),o(Wo),o(L),o(Ro),o(zo),o(Go),o(V),o(Vo),o(No),o(k),o(Do),o(Yo),o(I),o(Bo),o(Fo),o(q),o(So),o(Qo),o(O),o(Xo),o(Oo),o(bt),o(Ko),o(vt),o(en),o(yt),o(tn),o(wt),o(on),o(nn),o(K),o(rn),o(an),o(E),o(sn),o(ln),o(Z),o(mn),o(dn),o(Ao)),o(l),_(v,e),_(w,e),_(Je,e),_(qe,e),_(Ee),_(ae),_(Ze,e),_(We),_(se),_(Re),_(le),_(ze,e),_(Ge),_(ie),_(me),_(Ve,e),_(Ne),_(de),_(pe),_(De,e),_(Ye),_(Be),_(ce),_(Fe),_(ge),_(Se),_(Qe,e),_(Xe,e),_(Oe),_(ue),_(Ke,e),_(et),_(tt),_(ot),_($e),_(nt),_(rt),_(at),_(st,e),_(lt),_(it),_(mt),_(dt),_(pt),_(ct,e),_(gt),_(ft),_(ut),_(ht,e),_($t),_(_t,e),_(Tt,e),_(xt),_(At,e),_(Mt),_(kt),_(Ct),_(It,e),_(Ht),_(Lt),_(jt),_(Pt,e)}}}const Fa='{"title":"Agents & Tools","local":"agents--tools","sections":[{"title":"Agents","local":"agents","sections":[{"title":"HfAgent","local":"transformers.HfAgent","sections":[],"depth":3},{"title":"LocalAgent","local":"transformers.LocalAgent","sections":[],"depth":3},{"title":"OpenAiAgent","local":"transformers.OpenAiAgent","sections":[],"depth":3},{"title":"AzureOpenAiAgent","local":"transformers.AzureOpenAiAgent","sections":[],"depth":3},{"title":"Agent","local":"transformers.Agent","sections":[],"depth":3}],"depth":2},{"title":"Tools","local":"tools","sections":[{"title":"load_tool","local":"transformers.load_tool","sections":[],"depth":3},{"title":"Tool","local":"transformers.Tool","sections":[],"depth":3},{"title":"PipelineTool","local":"transformers.PipelineTool","sections":[],"depth":3},{"title":"RemoteTool","local":"transformers.RemoteTool","sections":[],"depth":3},{"title":"launch_gradio_demo","local":"transformers.launch_gradio_demo","sections":[],"depth":3}],"depth":2},{"title":"Agent Types","local":"agent-types","sections":[{"title":"AgentText","local":"transformers.tools.agent_types.AgentText","sections":[],"depth":3},{"title":"AgentImage","local":"transformers.tools.agent_types.AgentImage","sections":[],"depth":3},{"title":"AgentAudio","local":"transformers.tools.agent_types.AgentAudio","sections":[],"depth":3}],"depth":2}],"depth":1}';function Sa(M){return Ha(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ns extends La{constructor(l){super(),ja(this,l,Sa,Ba,Ia,{})}}export{ns as component};
