import{s as Js,f as Is,o as zs,n as P}from"../chunks/scheduler.9bc65507.js";import{S as Zs,i as Ws,g as p,s as a,r as g,A as Bs,h as c,f as s,c as r,j as x,u as h,x as y,k as $,y as i,a as l,v as f,d as u,t as _,w as b}from"../chunks/index.707bf1b6.js";import{T as no}from"../chunks/Tip.c2ecdbf4.js";import{D as j}from"../chunks/Docstring.17db21ae.js";import{C as D}from"../chunks/CodeBlock.54a9f38d.js";import{E as je}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as I}from"../chunks/Heading.342b1fa6.js";function Vs(v){let o,T="Example:",m,d,M;return d=new D({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNpZ2xpcENvbmZpZyUyQyUyMFNpZ2xpcE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFNpZ2xpcENvbmZpZyUyMHdpdGglMjBnb29nbGUlMkZzaWdsaXAtYmFzZS1wYXRjaDE2LTIyNCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBTaWdsaXBDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBTaWdsaXBNb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwZ29vZ2xlJTJGc2lnbGlwLWJhc2UtcGF0Y2gxNi0yMjQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFNpZ2xpcE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZyUwQSUwQSUyMyUyMFdlJTIwY2FuJTIwYWxzbyUyMGluaXRpYWxpemUlMjBhJTIwU2lnbGlwQ29uZmlnJTIwZnJvbSUyMGElMjBTaWdsaXBUZXh0Q29uZmlnJTIwYW5kJTIwYSUyMFNpZ2xpcFZpc2lvbkNvbmZpZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBTaWdsaXBUZXh0Q29uZmlnJTJDJTIwU2lnbGlwVmlzaW9uQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFNpZ2xpcFRleHQlMjBhbmQlMjBTaWdsaXBWaXNpb24lMjBjb25maWd1cmF0aW9uJTBBY29uZmlnX3RleHQlMjAlM0QlMjBTaWdsaXBUZXh0Q29uZmlnKCklMEFjb25maWdfdmlzaW9uJTIwJTNEJTIwU2lnbGlwVmlzaW9uQ29uZmlnKCklMEElMEFjb25maWclMjAlM0QlMjBTaWdsaXBDb25maWcuZnJvbV90ZXh0X3Zpc2lvbl9jb25maWdzKGNvbmZpZ190ZXh0JTJDJTIwY29uZmlnX3Zpc2lvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SiglipConfig, SiglipModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SiglipConfig with google/siglip-base-patch16-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SiglipConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SiglipModel (with random weights) from the google/siglip-base-patch16-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SiglipModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also initialize a SiglipConfig from a SiglipTextConfig and a SiglipVisionConfig</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SiglipTextConfig, SiglipVisionConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SiglipText and SiglipVision configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text = SiglipTextConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>config_vision = SiglipVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>config = SiglipConfig.from_text_vision_configs(config_text, config_vision)`,wrap:!1}}),{c(){o=p("p"),o.textContent=T,m=a(),g(d.$$.fragment)},l(t){o=c(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-11lpom8"&&(o.textContent=T),m=r(t),h(d.$$.fragment,t)},m(t,w){l(t,o,w),l(t,m,w),f(d,t,w),M=!0},p:P,i(t){M||(u(d.$$.fragment,t),M=!0)},o(t){_(d.$$.fragment,t),M=!1},d(t){t&&(s(o),s(m)),b(d,t)}}}function Ns(v){let o,T="Example:",m,d,M;return d=new D({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNpZ2xpcFRleHRDb25maWclMkMlMjBTaWdsaXBUZXh0TW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU2lnbGlwVGV4dENvbmZpZyUyMHdpdGglMjBnb29nbGUlMkZzaWdsaXAtYmFzZS1wYXRjaDE2LTIyNCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBTaWdsaXBUZXh0Q29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU2lnbGlwVGV4dE1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBnb29nbGUlMkZzaWdsaXAtYmFzZS1wYXRjaDE2LTIyNCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwU2lnbGlwVGV4dE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SiglipTextConfig, SiglipTextModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SiglipTextConfig with google/siglip-base-patch16-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SiglipTextConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SiglipTextModel (with random weights) from the google/siglip-base-patch16-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SiglipTextModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=p("p"),o.textContent=T,m=a(),g(d.$$.fragment)},l(t){o=c(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-11lpom8"&&(o.textContent=T),m=r(t),h(d.$$.fragment,t)},m(t,w){l(t,o,w),l(t,m,w),f(d,t,w),M=!0},p:P,i(t){M||(u(d.$$.fragment,t),M=!0)},o(t){_(d.$$.fragment,t),M=!1},d(t){t&&(s(o),s(m)),b(d,t)}}}function Ps(v){let o,T="Example:",m,d,M;return d=new D({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNpZ2xpcFZpc2lvbkNvbmZpZyUyQyUyMFNpZ2xpcFZpc2lvbk1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFNpZ2xpcFZpc2lvbkNvbmZpZyUyMHdpdGglMjBnb29nbGUlMkZzaWdsaXAtYmFzZS1wYXRjaDE2LTIyNCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBTaWdsaXBWaXNpb25Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBTaWdsaXBWaXNpb25Nb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwZ29vZ2xlJTJGc2lnbGlwLWJhc2UtcGF0Y2gxNi0yMjQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFNpZ2xpcFZpc2lvbk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SiglipVisionConfig, SiglipVisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SiglipVisionConfig with google/siglip-base-patch16-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SiglipVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SiglipVisionModel (with random weights) from the google/siglip-base-patch16-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SiglipVisionModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=p("p"),o.textContent=T,m=a(),g(d.$$.fragment)},l(t){o=c(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-11lpom8"&&(o.textContent=T),m=r(t),h(d.$$.fragment,t)},m(t,w){l(t,o,w),l(t,m,w),f(d,t,w),M=!0},p:P,i(t){M||(u(d.$$.fragment,t),M=!0)},o(t){_(d.$$.fragment,t),M=!1},d(t){t&&(s(o),s(m)),b(d,t)}}}function Rs(v){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=p("p"),o.innerHTML=T},l(m){o=c(m,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(m,d){l(m,o,d)},p:P,d(m){m&&s(o)}}}function Gs(v){let o,T="Examples:",m,d,M;return d=new D({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnNpZ2xpcC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnNpZ2xpcC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEF0ZXh0cyUyMCUzRCUyMCU1QiUyMmElMjBwaG90byUyMG9mJTIwMiUyMGNhdHMlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMDIlMjBkb2dzJTIyJTVEJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0cyUyQyUyMGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxvZ2l0c19wZXJfaW1hZ2UlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0c19wZXJfaW1hZ2UlMEFwcm9icyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzX3Blcl9pbWFnZSklMjAlMjMlMjB0aGVzZSUyMGFyZSUyMHRoZSUyMHByb2JhYmlsaXRpZXMlMEFwcmludChmJTIyJTdCcHJvYnMlNUIwJTVEJTVCMCU1RCUzQS4xJTI1JTdEJTIwdGhhdCUyMGltYWdlJTIwMCUyMGlzJTIwJyU3QnRleHRzJTVCMCU1RCU3RCclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google/siglip-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/siglip-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>texts = [<span class="hljs-string">&quot;a photo of 2 cats&quot;</span>, <span class="hljs-string">&quot;a photo of 2 dogs&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=texts, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = torch.sigmoid(logits_per_image) <span class="hljs-comment"># these are the probabilities</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{probs[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]:<span class="hljs-number">.1</span>%}</span> that image 0 is &#x27;<span class="hljs-subst">{texts[<span class="hljs-number">0</span>]}</span>&#x27;&quot;</span>)
<span class="hljs-number">31.9</span>% that image <span class="hljs-number">0</span> <span class="hljs-keyword">is</span> <span class="hljs-string">&#x27;a photo of 2 cats&#x27;</span>`,wrap:!1}}),{c(){o=p("p"),o.textContent=T,m=a(),g(d.$$.fragment)},l(t){o=c(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=T),m=r(t),h(d.$$.fragment,t)},m(t,w){l(t,o,w),l(t,m,w),f(d,t,w),M=!0},p:P,i(t){M||(u(d.$$.fragment,t),M=!0)},o(t){_(d.$$.fragment,t),M=!1},d(t){t&&(s(o),s(m)),b(d,t)}}}function Ls(v){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=p("p"),o.innerHTML=T},l(m){o=c(m,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(m,d){l(m,o,d)},p:P,d(m){m&&s(o)}}}function qs(v){let o,T="Examples:",m,d,M;return d=new D({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZzaWdsaXAtYmFzZS1wYXRjaDE2LTIyNCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZzaWdsaXAtYmFzZS1wYXRjaDE2LTIyNCUyMiklMEElMEElMjMlMjBpbXBvcnRhbnQlM0ElMjBtYWtlJTIwc3VyZSUyMHRvJTIwc2V0JTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMjBhcyUyMHRoYXQncyUyMGhvdyUyMHRoZSUyMG1vZGVsJTIwd2FzJTIwdHJhaW5lZCUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMHRleHRfZmVhdHVyZXMlMjAlM0QlMjBtb2RlbC5nZXRfdGV4dF9mZWF0dXJlcygqKmlucHV0cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google/siglip-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/siglip-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># important: make sure to set padding=&quot;max_length&quot; as that&#x27;s how the model was trained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    text_features = model.get_text_features(**inputs)`,wrap:!1}}),{c(){o=p("p"),o.textContent=T,m=a(),g(d.$$.fragment)},l(t){o=c(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=T),m=r(t),h(d.$$.fragment,t)},m(t,w){l(t,o,w),l(t,m,w),f(d,t,w),M=!0},p:P,i(t){M||(u(d.$$.fragment,t),M=!0)},o(t){_(d.$$.fragment,t),M=!1},d(t){t&&(s(o),s(m)),b(d,t)}}}function Fs(v){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=p("p"),o.innerHTML=T},l(m){o=c(m,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(m,d){l(m,o,d)},p:P,d(m){m&&s(o)}}}function Xs(v){let o,T="Examples:",m,d,M;return d=new D({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnNpZ2xpcC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnNpZ2xpcC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZV9mZWF0dXJlcyUyMCUzRCUyMG1vZGVsLmdldF9pbWFnZV9mZWF0dXJlcygqKmlucHV0cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google/siglip-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/siglip-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    image_features = model.get_image_features(**inputs)`,wrap:!1}}),{c(){o=p("p"),o.textContent=T,m=a(),g(d.$$.fragment)},l(t){o=c(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=T),m=r(t),h(d.$$.fragment,t)},m(t,w){l(t,o,w),l(t,m,w),f(d,t,w),M=!0},p:P,i(t){M||(u(d.$$.fragment,t),M=!0)},o(t){_(d.$$.fragment,t),M=!1},d(t){t&&(s(o),s(m)),b(d,t)}}}function Hs(v){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=p("p"),o.innerHTML=T},l(m){o=c(m,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(m,d){l(m,o,d)},p:P,d(m){m&&s(o)}}}function Es(v){let o,T="Examples:",m,d,M;return d=new D({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTaWdsaXBUZXh0TW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMFNpZ2xpcFRleHRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGc2lnbGlwLWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGc2lnbGlwLWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBJTIzJTIwaW1wb3J0YW50JTNBJTIwbWFrZSUyMHN1cmUlMjB0byUyMHNldCUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTIwYXMlMjB0aGF0J3MlMjBob3clMjB0aGUlMjBtb2RlbCUyMHdhcyUyMHRyYWluZWQlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIyJTJDJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwZG9nJTIyJTVEJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsYXN0X2hpZGRlbl9zdGF0ZSUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFwb29sZWRfb3V0cHV0JTIwJTNEJTIwb3V0cHV0cy5wb29sZXJfb3V0cHV0JTIwJTIwJTIzJTIwcG9vbGVkJTIwKEVPUyUyMHRva2VuKSUyMHN0YXRlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SiglipTextModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SiglipTextModel.from_pretrained(<span class="hljs-string">&quot;google/siglip-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/siglip-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># important: make sure to set padding=&quot;max_length&quot; as that&#x27;s how the model was trained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled (EOS token) states</span>`,wrap:!1}}),{c(){o=p("p"),o.textContent=T,m=a(),g(d.$$.fragment)},l(t){o=c(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=T),m=r(t),h(d.$$.fragment,t)},m(t,w){l(t,o,w),l(t,m,w),f(d,t,w),M=!0},p:P,i(t){M||(u(d.$$.fragment,t),M=!0)},o(t){_(d.$$.fragment,t),M=!1},d(t){t&&(s(o),s(m)),b(d,t)}}}function Qs(v){let o,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=p("p"),o.innerHTML=T},l(m){o=c(m,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=T)},m(m,d){l(m,o,d)},p:P,d(m){m&&s(o)}}}function Ys(v){let o,T="Examples:",m,d,M;return d=new D({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFNpZ2xpcFZpc2lvbk1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBTaWdsaXBWaXNpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGc2lnbGlwLWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGc2lnbGlwLWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlZF9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQlMjAlMjAlMjMlMjBwb29sZWQlMjBmZWF0dXJlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, SiglipVisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SiglipVisionModel.from_pretrained(<span class="hljs-string">&quot;google/siglip-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/siglip-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled features</span>`,wrap:!1}}),{c(){o=p("p"),o.textContent=T,m=a(),g(d.$$.fragment)},l(t){o=c(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=T),m=r(t),h(d.$$.fragment,t)},m(t,w){l(t,o,w),l(t,m,w),f(d,t,w),M=!0},p:P,i(t){M||(u(d.$$.fragment,t),M=!0)},o(t){_(d.$$.fragment,t),M=!1},d(t){t&&(s(o),s(m)),b(d,t)}}}function Ds(v){let o,T,m,d,M,t,w,so,ke,Xn='The SigLIP model was proposed in <a href="https://arxiv.org/abs/2303.15343" rel="nofollow">Sigmoid Loss for Language Image Pre-Training</a> by Xiaohua Zhai, Basil Mustafa, Alexander Kolesnikov, Lucas Beyer. SigLIP proposes to replace the loss function used in <a href="clip">CLIP</a> by a simple pairwise sigmoid loss. This results in better performance in terms of zero-shot classification accuracy on ImageNet.',ao,Se,Hn="The abstract from the paper is the following:",ro,Ce,En="<em>We propose a simple pairwise Sigmoid loss for Language-Image Pre-training (SigLIP). Unlike standard contrastive learning with softmax normalization, the sigmoid loss operates solely on image-text pairs and does not require a global view of the pairwise similarities for normalization. The sigmoid loss simultaneously allows further scaling up the batch size, while also performing better at smaller batch sizes. Combined with Locked-image Tuning, with only four TPUv4 chips, we train a SigLiT model that achieves 84.5% ImageNet zero-shot accuracy in two days. The disentanglement of the batch size from the loss further allows us to study the impact of examples vs pairs and negative to positive ratio. Finally, we push the batch size to the extreme, up to one million, and find that the benefits of growing batch size quickly diminish, with a more reasonable batch size of 32k being sufficient.</em>",io,Ue,lo,Je,Qn='<li>Usage of SigLIP is similar to <a href="clip">CLIP</a>. The main difference is the training loss, which does not require a global view of all the pairwise similarities of images and texts within a batch. One needs to apply the sigmoid activation function to the logits, rather than the softmax.</li> <li>Training is not yet supported. If you want to fine-tune SigLIP or train from scratch, refer to the loss function from <a href="https://github.com/mlfoundations/open_clip/blob/73ad04ae7fb93ede1c02dc9040a828634cb1edf1/src/open_clip/loss.py#L307" rel="nofollow">OpenCLIP</a>, which leverages various <code>torch.distributed</code> utilities.</li> <li>When using the standalone <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipTokenizer">SiglipTokenizer</a>, make sure to pass <code>padding=&quot;max_length&quot;</code> as that’s how the model was trained. The multimodal <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipProcessor">SiglipProcessor</a> takes care of this behind the scenes.</li>',po,K,Yn,co,Ie,Dn='SigLIP evaluation results compared to CLIP. Taken from the <a href="https://arxiv.org/abs/2303.15343">original paper</a>.',mo,ze,An=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/google-research/big_vision/tree/main" rel="nofollow">here</a>.`,go,Ze,ho,We,On="There are 2 main ways to use SigLIP: either using the pipeline API, which abstracts away all the complexity for you, or by using the <code>SiglipModel</code> class yourself.",fo,Be,uo,Ve,Kn="The pipeline allows to use the model in a few lines of code:",_o,Ne,bo,Pe,yo,Re,es="If you want to do the pre- and postprocessing yourself, here’s how to do that:",Mo,Ge,To,Le,wo,U,qe,Lo,$t,ts=`<a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipConfig">SiglipConfig</a> is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipModel">SiglipModel</a>. It is used to
instantiate a Siglip model according to the specified arguments, defining the text model and vision model configs.
Instantiating a configuration with the defaults will yield a similar configuration to that of the Siglip
<a href="https://huggingface.co/google/siglip-base-patch16-224" rel="nofollow">google/siglip-base-patch16-224</a> architecture.`,qo,xt,os=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Fo,ee,Xo,te,Fe,Ho,jt,ns=`Instantiate a <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipConfig">SiglipConfig</a> (or a derived class) from siglip text model configuration and siglip vision
model configuration.`,vo,Xe,$o,z,He,Eo,kt,ss=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipTextModel">SiglipTextModel</a>. It is used to instantiate a
Siglip text encoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the text encoder of the Siglip
<a href="https://huggingface.co/google/siglip-base-patch16-224" rel="nofollow">google/siglip-base-patch16-224</a> architecture.`,Qo,St,as=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Yo,oe,xo,Ee,jo,Z,Qe,Do,Ct,rs=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipVisionModel">SiglipVisionModel</a>. It is used to instantiate a
Siglip vision encoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the vision encoder of the Siglip
<a href="https://huggingface.co/google/siglip-base-patch16-224" rel="nofollow">google/siglip-base-patch16-224</a> architecture.`,Ao,Ut,is=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Oo,ne,ko,Ye,So,k,De,Ko,Jt,ls='Construct a Siglip tokenizer. Based on <a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a>.',en,It,ds=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,tn,Y,Ae,on,zt,ps=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A sequence has the following format:`,nn,Zt,cs="<li>single sequence: <code>X &lt;/s&gt;</code></li> <li>pair of sequences: <code>A &lt;/s&gt; B &lt;/s&gt;</code></li>",sn,se,Oe,an,Wt,ms=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,rn,ae,Ke,ln,Bt,gs=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. T5 does not make
use of token type ids, therefore a list of zeros is returned.`,dn,Vt,et,Co,tt,Uo,H,ot,pn,Nt,hs="Constructs a SigLIP image processor.",cn,re,nt,mn,Pt,fs="Preprocess an image or batch of images.",Jo,st,Io,J,at,gn,Rt,us="Constructs a Siglip processor which wraps a Siglip image processor and a Siglip tokenizer into a single processor.",hn,Gt,_s=`<a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipProcessor">SiglipProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipTokenizer">SiglipTokenizer</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipProcessor.decode">decode()</a> for more information.`,fn,ie,rt,un,Lt,bs=`This method forwards all its arguments to SiglipTokenizer’s <a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,_n,le,it,bn,qt,ys=`This method forwards all its arguments to SiglipTokenizer’s <a href="/docs/transformers/main/en/model_doc/speech_to_text_2#transformers.Speech2Text2Tokenizer.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,zo,lt,Zo,S,dt,yn,Ft,Ms=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Mn,Xt,Ts=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Tn,R,pt,wn,Ht,ws='The <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipModel">SiglipModel</a> forward method, overrides the <code>__call__</code> special method.',vn,de,$n,pe,xn,G,ct,jn,Et,vs='The <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipModel">SiglipModel</a> forward method, overrides the <code>__call__</code> special method.',kn,ce,Sn,me,Cn,L,mt,Un,Qt,$s='The <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipModel">SiglipModel</a> forward method, overrides the <code>__call__</code> special method.',Jn,ge,In,he,Wo,gt,Bo,W,ht,zn,Yt,xs=`The text model from SigLIP without any head or projection on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Zn,Dt,js=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Wn,q,ft,Bn,At,ks='The <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipTextModel">SiglipTextModel</a> forward method, overrides the <code>__call__</code> special method.',Vn,fe,Nn,ue,Vo,ut,No,B,_t,Pn,Ot,Ss=`The vision model from SigLIP without any head or projection on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Rn,Kt,Cs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Gn,F,bt,Ln,eo,Us='The <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipVisionModel">SiglipVisionModel</a> forward method, overrides the <code>__call__</code> special method.',qn,_e,Fn,be,Po,to,Ro;return M=new I({props:{title:"SigLIP",local:"siglip",headingTag:"h1"}}),w=new I({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Ue=new I({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),Ze=new I({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),Be=new I({props:{title:"Pipeline API",local:"pipeline-api",headingTag:"h3"}}),Ne=new D({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMjMlMjBsb2FkJTIwcGlwZSUwQWltYWdlX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyemVyby1zaG90LWltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJnb29nbGUlMkZzaWdsaXAtYmFzZS1wYXRjaDE2LTIyNCUyMiklMEElMEElMjMlMjBsb2FkJTIwaW1hZ2UlMEF1cmwlMjAlM0QlMjAnaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyclMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEElMjMlMjBpbmZlcmVuY2UlMEFvdXRwdXRzJTIwJTNEJTIwaW1hZ2VfY2xhc3NpZmllcihpbWFnZSUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjIyJTIwY2F0cyUyMiUyQyUyMCUyMmElMjBwbGFuZSUyMiUyQyUyMCUyMmElMjByZW1vdGUlMjIlNUQpJTBBb3V0cHV0cyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQob3V0cHV0JTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwb3V0cHV0JTVCJTIybGFiZWwlMjIlNUQlMjAlN0QlMjBmb3IlMjBvdXRwdXQlMjBpbiUyMG91dHB1dHMlNUQlMEFwcmludChvdXRwdXRzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load pipe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_classifier = pipeline(task=<span class="hljs-string">&quot;zero-shot-image-classification&quot;</span>, model=<span class="hljs-string">&quot;google/siglip-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = image_classifier(image, candidate_labels=[<span class="hljs-string">&quot;2 cats&quot;</span>, <span class="hljs-string">&quot;a plane&quot;</span>, <span class="hljs-string">&quot;a remote&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(output[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: output[<span class="hljs-string">&quot;label&quot;</span>] } <span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> outputs]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1979</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;2 cats&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;a remote&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;a plane&#x27;</span>}]`,wrap:!1}}),Pe=new I({props:{title:"Using the model yourself",local:"using-the-model-yourself",headingTag:"h3"}}),Ge=new D({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnNpZ2xpcC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnNpZ2xpcC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEF0ZXh0cyUyMCUzRCUyMCU1QiUyMmElMjBwaG90byUyMG9mJTIwMiUyMGNhdHMlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMDIlMjBkb2dzJTIyJTVEJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0cyUyQyUyMGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxvZ2l0c19wZXJfaW1hZ2UlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0c19wZXJfaW1hZ2UlMEFwcm9icyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzX3Blcl9pbWFnZSklMjAlMjMlMjB0aGVzZSUyMGFyZSUyMHRoZSUyMHByb2JhYmlsaXRpZXMlMEFwcmludChmJTIyJTdCcHJvYnMlNUIwJTVEJTVCMCU1RCUzQS4xJTI1JTdEJTIwdGhhdCUyMGltYWdlJTIwMCUyMGlzJTIwJyU3QnRleHRzJTVCMCU1RCU3RCclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google/siglip-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/siglip-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>texts = [<span class="hljs-string">&quot;a photo of 2 cats&quot;</span>, <span class="hljs-string">&quot;a photo of 2 dogs&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=texts, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = torch.sigmoid(logits_per_image) <span class="hljs-comment"># these are the probabilities</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{probs[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]:<span class="hljs-number">.1</span>%}</span> that image 0 is &#x27;<span class="hljs-subst">{texts[<span class="hljs-number">0</span>]}</span>&#x27;&quot;</span>)
<span class="hljs-number">31.9</span>% that image <span class="hljs-number">0</span> <span class="hljs-keyword">is</span> <span class="hljs-string">&#x27;a photo of 2 cats&#x27;</span>`,wrap:!1}}),Le=new I({props:{title:"SiglipConfig",local:"transformers.SiglipConfig",headingTag:"h2"}}),qe=new j({props:{name:"class transformers.SiglipConfig",anchor:"transformers.SiglipConfig",parameters:[{name:"text_config",val:" = None"},{name:"vision_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SiglipConfig.text_config",description:`<strong>text_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipTextConfig">SiglipTextConfig</a>.`,name:"text_config"},{anchor:"transformers.SiglipConfig.vision_config",description:`<strong>vision_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipVisionConfig">SiglipVisionConfig</a>.`,name:"vision_config"},{anchor:"transformers.SiglipConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/configuration_siglip.py#L232"}}),ee=new je({props:{anchor:"transformers.SiglipConfig.example",$$slots:{default:[Vs]},$$scope:{ctx:v}}}),Fe=new j({props:{name:"from_text_vision_configs",anchor:"transformers.SiglipConfig.from_text_vision_configs",parameters:[{name:"text_config",val:": SiglipTextConfig"},{name:"vision_config",val:": SiglipVisionConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/configuration_siglip.py#L292",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipConfig"
>SiglipConfig</a></p>
`}}),Xe=new I({props:{title:"SiglipTextConfig",local:"transformers.SiglipTextConfig",headingTag:"h2"}}),He=new j({props:{name:"class transformers.SiglipTextConfig",anchor:"transformers.SiglipTextConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"hidden_size",val:" = 768"},{name:"intermediate_size",val:" = 3072"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"max_position_embeddings",val:" = 64"},{name:"hidden_act",val:" = 'gelu_pytorch_tanh'"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"attention_dropout",val:" = 0.0"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 49406"},{name:"eos_token_id",val:" = 49407"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SiglipTextConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the Siglip text model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipModel">SiglipModel</a>.`,name:"vocab_size"},{anchor:"transformers.SiglipTextConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.SiglipTextConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.SiglipTextConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.SiglipTextConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.SiglipTextConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.SiglipTextConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu_pytorch_tanh&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.SiglipTextConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.SiglipTextConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.SiglipTextConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The id of the padding token in the vocabulary.`,name:"pad_token_id"},{anchor:"transformers.SiglipTextConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 49406) &#x2014;
The id of the beginning-of-sequence token in the vocabulary.`,name:"bos_token_id"},{anchor:"transformers.SiglipTextConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 49407) &#x2014;
The id of the end-of-sequence token in the vocabulary.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/configuration_siglip.py#L31"}}),oe=new je({props:{anchor:"transformers.SiglipTextConfig.example",$$slots:{default:[Ns]},$$scope:{ctx:v}}}),Ee=new I({props:{title:"SiglipVisionConfig",local:"transformers.SiglipVisionConfig",headingTag:"h2"}}),Qe=new j({props:{name:"class transformers.SiglipVisionConfig",anchor:"transformers.SiglipVisionConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"intermediate_size",val:" = 3072"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"num_channels",val:" = 3"},{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 16"},{name:"hidden_act",val:" = 'gelu_pytorch_tanh'"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"attention_dropout",val:" = 0.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SiglipVisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.SiglipVisionConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.SiglipVisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.SiglipVisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.SiglipVisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input images.`,name:"num_channels"},{anchor:"transformers.SiglipVisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.SiglipVisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.SiglipVisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu_pytorch_tanh&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> \`<code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.SiglipVisionConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.SiglipVisionConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/configuration_siglip.py#L136"}}),ne=new je({props:{anchor:"transformers.SiglipVisionConfig.example",$$slots:{default:[Ps]},$$scope:{ctx:v}}}),Ye=new I({props:{title:"SiglipTokenizer",local:"transformers.SiglipTokenizer",headingTag:"h2"}}),De=new j({props:{name:"class transformers.SiglipTokenizer",anchor:"transformers.SiglipTokenizer",parameters:[{name:"vocab_file",val:""},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '</s>'"},{name:"additional_special_tokens",val:" = None"},{name:"sp_model_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"model_max_length",val:" = 64"},{name:"do_lower_case",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SiglipTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a <em>.spm</em> extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.SiglipTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.SiglipTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.SiglipTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.SiglipTokenizer.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"},{anchor:"transformers.SiglipTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"},{anchor:"transformers.SiglipTokenizer.model_max_length",description:`<strong>model_max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The maximum length (in number of tokens) for model inputs.`,name:"model_max_length"},{anchor:"transformers.SiglipTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/tokenization_siglip.py#L53"}}),Ae=new j({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.SiglipTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.SiglipTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.SiglipTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/tokenization_siglip.py#L237",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Oe=new j({props:{name:"get_special_tokens_mask",anchor:"transformers.SiglipTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.SiglipTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.SiglipTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.SiglipTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/tokenization_siglip.py#L173",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Ke=new j({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.SiglipTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.SiglipTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.SiglipTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/tokenization_siglip.py#L214",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of zeros.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),et=new j({props:{name:"save_vocabulary",anchor:"transformers.SiglipTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/tokenization_siglip.py#L374"}}),tt=new I({props:{title:"SiglipImageProcessor",local:"transformers.SiglipImageProcessor",headingTag:"h2"}}),ot=new j({props:{name:"class transformers.SiglipImageProcessor",anchor:"transformers.SiglipImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SiglipImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.SiglipImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the image after resizing. Can be overridden by <code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.SiglipImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.SiglipImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.SiglipImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.SiglipImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image by the specified mean and standard deviation. Can be overridden by
<code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.SiglipImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.5, 0.5, 0.5]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.SiglipImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.5, 0.5, 0.5]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/image_processing_siglip.py#L46"}}),nt=new j({props:{name:"preprocess",anchor:"transformers.SiglipImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SiglipImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.SiglipImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.SiglipImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.SiglipImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.SiglipImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.SiglipImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.SiglipImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.SiglipImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.SiglipImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.SiglipImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.SiglipImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SiglipImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/image_processing_siglip.py#L104"}}),st=new I({props:{title:"SiglipProcessor",local:"transformers.SiglipProcessor",headingTag:"h2"}}),at=new j({props:{name:"class transformers.SiglipProcessor",anchor:"transformers.SiglipProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.SiglipProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.SiglipProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipTokenizer">SiglipTokenizer</a>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/processing_siglip.py#L28"}}),rt=new j({props:{name:"batch_decode",anchor:"transformers.SiglipProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/processing_siglip.py#L131"}}),it=new j({props:{name:"decode",anchor:"transformers.SiglipProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/processing_siglip.py#L124"}}),lt=new I({props:{title:"SiglipModel",local:"transformers.SiglipModel",headingTag:"h2"}}),dt=new j({props:{name:"class transformers.SiglipModel",anchor:"transformers.SiglipModel",parameters:[{name:"config",val:": SiglipConfig"}],parametersDescription:[{anchor:"transformers.SiglipModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipConfig">SiglipConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/modeling_siglip.py#L966"}}),pt=new j({props:{name:"forward",anchor:"transformers.SiglipModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"return_loss",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SiglipModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SiglipModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SiglipModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SiglipModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltFeatureExtractor.__call__">CLIPImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.SiglipModel.forward.return_loss",description:`<strong>return_loss</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the contrastive loss.`,name:"return_loss"},{anchor:"transformers.SiglipModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SiglipModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SiglipModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/modeling_siglip.py#L1095",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.siglip.modeling_siglip.SiglipOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.siglip.configuration_siglip.SiglipConfig'&gt;</code>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.</li>
<li><strong>logits_per_image:(<code>torch.FloatTensor</code></strong> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text:(<code>torch.FloatTensor</code></strong> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds(<code>torch.FloatTensor</code></strong> of shape <code>(batch_size, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipTextModel"
>SiglipTextModel</a>.</li>
<li><strong>image_embeds(<code>torch.FloatTensor</code></strong> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipVisionModel"
>SiglipVisionModel</a>.</li>
<li><strong>text_model_output(<code>BaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipTextModel"
>SiglipTextModel</a>.</li>
<li><strong>vision_model_output(<code>BaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipVisionModel"
>SiglipVisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.siglip.modeling_siglip.SiglipOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),de=new no({props:{$$slots:{default:[Rs]},$$scope:{ctx:v}}}),pe=new je({props:{anchor:"transformers.SiglipModel.forward.example",$$slots:{default:[Gs]},$$scope:{ctx:v}}}),ct=new j({props:{name:"get_text_features",anchor:"transformers.SiglipModel.get_text_features",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SiglipModel.get_text_features.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SiglipModel.get_text_features.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SiglipModel.get_text_features.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SiglipModel.get_text_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SiglipModel.get_text_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SiglipModel.get_text_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/modeling_siglip.py#L996",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The text embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipTextModel"
>SiglipTextModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>text_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),ce=new no({props:{$$slots:{default:[Ls]},$$scope:{ctx:v}}}),me=new je({props:{anchor:"transformers.SiglipModel.get_text_features.example",$$slots:{default:[qs]},$$scope:{ctx:v}}}),mt=new j({props:{name:"get_image_features",anchor:"transformers.SiglipModel.get_image_features",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SiglipModel.get_image_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltFeatureExtractor.__call__">CLIPImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.SiglipModel.get_image_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SiglipModel.get_image_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SiglipModel.get_image_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/modeling_siglip.py#L1045",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The image embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipVisionModel"
>SiglipVisionModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),ge=new no({props:{$$slots:{default:[Fs]},$$scope:{ctx:v}}}),he=new je({props:{anchor:"transformers.SiglipModel.get_image_features.example",$$slots:{default:[Xs]},$$scope:{ctx:v}}}),gt=new I({props:{title:"SiglipTextModel",local:"transformers.SiglipTextModel",headingTag:"h2"}}),ht=new j({props:{name:"class transformers.SiglipTextModel",anchor:"transformers.SiglipTextModel",parameters:[{name:"config",val:": SiglipTextConfig"}],parametersDescription:[{anchor:"transformers.SiglipTextModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipConfig">SiglipConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/modeling_siglip.py#L768"}}),ft=new j({props:{name:"forward",anchor:"transformers.SiglipTextModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SiglipTextModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SiglipTextModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SiglipTextModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SiglipTextModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SiglipTextModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SiglipTextModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/modeling_siglip.py#L785",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.siglip.configuration_siglip.SiglipTextConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),fe=new no({props:{$$slots:{default:[Hs]},$$scope:{ctx:v}}}),ue=new je({props:{anchor:"transformers.SiglipTextModel.forward.example",$$slots:{default:[Es]},$$scope:{ctx:v}}}),ut=new I({props:{title:"SiglipVisionModel",local:"transformers.SiglipVisionModel",headingTag:"h2"}}),_t=new j({props:{name:"class transformers.SiglipVisionModel",anchor:"transformers.SiglipVisionModel",parameters:[{name:"config",val:": SiglipVisionConfig"}],parametersDescription:[{anchor:"transformers.SiglipVisionModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipConfig">SiglipConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/modeling_siglip.py#L909"}}),bt=new j({props:{name:"forward",anchor:"transformers.SiglipVisionModel.forward",parameters:[{name:"pixel_values",val:""},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SiglipVisionModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltFeatureExtractor.__call__">CLIPImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.SiglipVisionModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SiglipVisionModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SiglipVisionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/siglip/modeling_siglip.py#L924",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.siglip.configuration_siglip.SiglipVisionConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),_e=new no({props:{$$slots:{default:[Qs]},$$scope:{ctx:v}}}),be=new je({props:{anchor:"transformers.SiglipVisionModel.forward.example",$$slots:{default:[Ys]},$$scope:{ctx:v}}}),{c(){o=p("meta"),T=a(),m=p("p"),d=a(),g(M.$$.fragment),t=a(),g(w.$$.fragment),so=a(),ke=p("p"),ke.innerHTML=Xn,ao=a(),Se=p("p"),Se.textContent=Hn,ro=a(),Ce=p("p"),Ce.innerHTML=En,io=a(),g(Ue.$$.fragment),lo=a(),Je=p("ul"),Je.innerHTML=Qn,po=a(),K=p("img"),co=a(),Ie=p("small"),Ie.innerHTML=Dn,mo=a(),ze=p("p"),ze.innerHTML=An,go=a(),g(Ze.$$.fragment),ho=a(),We=p("p"),We.innerHTML=On,fo=a(),g(Be.$$.fragment),uo=a(),Ve=p("p"),Ve.textContent=Kn,_o=a(),g(Ne.$$.fragment),bo=a(),g(Pe.$$.fragment),yo=a(),Re=p("p"),Re.textContent=es,Mo=a(),g(Ge.$$.fragment),To=a(),g(Le.$$.fragment),wo=a(),U=p("div"),g(qe.$$.fragment),Lo=a(),$t=p("p"),$t.innerHTML=ts,qo=a(),xt=p("p"),xt.innerHTML=os,Fo=a(),g(ee.$$.fragment),Xo=a(),te=p("div"),g(Fe.$$.fragment),Ho=a(),jt=p("p"),jt.innerHTML=ns,vo=a(),g(Xe.$$.fragment),$o=a(),z=p("div"),g(He.$$.fragment),Eo=a(),kt=p("p"),kt.innerHTML=ss,Qo=a(),St=p("p"),St.innerHTML=as,Yo=a(),g(oe.$$.fragment),xo=a(),g(Ee.$$.fragment),jo=a(),Z=p("div"),g(Qe.$$.fragment),Do=a(),Ct=p("p"),Ct.innerHTML=rs,Ao=a(),Ut=p("p"),Ut.innerHTML=is,Oo=a(),g(ne.$$.fragment),ko=a(),g(Ye.$$.fragment),So=a(),k=p("div"),g(De.$$.fragment),Ko=a(),Jt=p("p"),Jt.innerHTML=ls,en=a(),It=p("p"),It.innerHTML=ds,tn=a(),Y=p("div"),g(Ae.$$.fragment),on=a(),zt=p("p"),zt.textContent=ps,nn=a(),Zt=p("ul"),Zt.innerHTML=cs,sn=a(),se=p("div"),g(Oe.$$.fragment),an=a(),Wt=p("p"),Wt.innerHTML=ms,rn=a(),ae=p("div"),g(Ke.$$.fragment),ln=a(),Bt=p("p"),Bt.textContent=gs,dn=a(),Vt=p("div"),g(et.$$.fragment),Co=a(),g(tt.$$.fragment),Uo=a(),H=p("div"),g(ot.$$.fragment),pn=a(),Nt=p("p"),Nt.textContent=hs,cn=a(),re=p("div"),g(nt.$$.fragment),mn=a(),Pt=p("p"),Pt.textContent=fs,Jo=a(),g(st.$$.fragment),Io=a(),J=p("div"),g(at.$$.fragment),gn=a(),Rt=p("p"),Rt.textContent=us,hn=a(),Gt=p("p"),Gt.innerHTML=_s,fn=a(),ie=p("div"),g(rt.$$.fragment),un=a(),Lt=p("p"),Lt.innerHTML=bs,_n=a(),le=p("div"),g(it.$$.fragment),bn=a(),qt=p("p"),qt.innerHTML=ys,zo=a(),g(lt.$$.fragment),Zo=a(),S=p("div"),g(dt.$$.fragment),yn=a(),Ft=p("p"),Ft.innerHTML=Ms,Mn=a(),Xt=p("p"),Xt.innerHTML=Ts,Tn=a(),R=p("div"),g(pt.$$.fragment),wn=a(),Ht=p("p"),Ht.innerHTML=ws,vn=a(),g(de.$$.fragment),$n=a(),g(pe.$$.fragment),xn=a(),G=p("div"),g(ct.$$.fragment),jn=a(),Et=p("p"),Et.innerHTML=vs,kn=a(),g(ce.$$.fragment),Sn=a(),g(me.$$.fragment),Cn=a(),L=p("div"),g(mt.$$.fragment),Un=a(),Qt=p("p"),Qt.innerHTML=$s,Jn=a(),g(ge.$$.fragment),In=a(),g(he.$$.fragment),Wo=a(),g(gt.$$.fragment),Bo=a(),W=p("div"),g(ht.$$.fragment),zn=a(),Yt=p("p"),Yt.innerHTML=xs,Zn=a(),Dt=p("p"),Dt.innerHTML=js,Wn=a(),q=p("div"),g(ft.$$.fragment),Bn=a(),At=p("p"),At.innerHTML=ks,Vn=a(),g(fe.$$.fragment),Nn=a(),g(ue.$$.fragment),Vo=a(),g(ut.$$.fragment),No=a(),B=p("div"),g(_t.$$.fragment),Pn=a(),Ot=p("p"),Ot.innerHTML=Ss,Rn=a(),Kt=p("p"),Kt.innerHTML=Cs,Gn=a(),F=p("div"),g(bt.$$.fragment),Ln=a(),eo=p("p"),eo.innerHTML=Us,qn=a(),g(_e.$$.fragment),Fn=a(),g(be.$$.fragment),Po=a(),to=p("p"),this.h()},l(e){const n=Bs("svelte-u9bgzb",document.head);o=c(n,"META",{name:!0,content:!0}),n.forEach(s),T=r(e),m=c(e,"P",{}),x(m).forEach(s),d=r(e),h(M.$$.fragment,e),t=r(e),h(w.$$.fragment,e),so=r(e),ke=c(e,"P",{"data-svelte-h":!0}),y(ke)!=="svelte-q93fk2"&&(ke.innerHTML=Xn),ao=r(e),Se=c(e,"P",{"data-svelte-h":!0}),y(Se)!=="svelte-vfdo9a"&&(Se.textContent=Hn),ro=r(e),Ce=c(e,"P",{"data-svelte-h":!0}),y(Ce)!=="svelte-1j0zyq6"&&(Ce.innerHTML=En),io=r(e),h(Ue.$$.fragment,e),lo=r(e),Je=c(e,"UL",{"data-svelte-h":!0}),y(Je)!=="svelte-opkafh"&&(Je.innerHTML=Qn),po=r(e),K=c(e,"IMG",{src:!0,alt:!0,width:!0}),co=r(e),Ie=c(e,"SMALL",{"data-svelte-h":!0}),y(Ie)!=="svelte-dh6egv"&&(Ie.innerHTML=Dn),mo=r(e),ze=c(e,"P",{"data-svelte-h":!0}),y(ze)!=="svelte-1ovki4s"&&(ze.innerHTML=An),go=r(e),h(Ze.$$.fragment,e),ho=r(e),We=c(e,"P",{"data-svelte-h":!0}),y(We)!=="svelte-kw3rvz"&&(We.innerHTML=On),fo=r(e),h(Be.$$.fragment,e),uo=r(e),Ve=c(e,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-1yjxirq"&&(Ve.textContent=Kn),_o=r(e),h(Ne.$$.fragment,e),bo=r(e),h(Pe.$$.fragment,e),yo=r(e),Re=c(e,"P",{"data-svelte-h":!0}),y(Re)!=="svelte-eza9ob"&&(Re.textContent=es),Mo=r(e),h(Ge.$$.fragment,e),To=r(e),h(Le.$$.fragment,e),wo=r(e),U=c(e,"DIV",{class:!0});var V=x(U);h(qe.$$.fragment,V),Lo=r(V),$t=c(V,"P",{"data-svelte-h":!0}),y($t)!=="svelte-1pquhrj"&&($t.innerHTML=ts),qo=r(V),xt=c(V,"P",{"data-svelte-h":!0}),y(xt)!=="svelte-o55m63"&&(xt.innerHTML=os),Fo=r(V),h(ee.$$.fragment,V),Xo=r(V),te=c(V,"DIV",{class:!0});var yt=x(te);h(Fe.$$.fragment,yt),Ho=r(yt),jt=c(yt,"P",{"data-svelte-h":!0}),y(jt)!=="svelte-abdf0u"&&(jt.innerHTML=ns),yt.forEach(s),V.forEach(s),vo=r(e),h(Xe.$$.fragment,e),$o=r(e),z=c(e,"DIV",{class:!0});var E=x(z);h(He.$$.fragment,E),Eo=r(E),kt=c(E,"P",{"data-svelte-h":!0}),y(kt)!=="svelte-1m8xm0e"&&(kt.innerHTML=ss),Qo=r(E),St=c(E,"P",{"data-svelte-h":!0}),y(St)!=="svelte-o55m63"&&(St.innerHTML=as),Yo=r(E),h(oe.$$.fragment,E),E.forEach(s),xo=r(e),h(Ee.$$.fragment,e),jo=r(e),Z=c(e,"DIV",{class:!0});var Q=x(Z);h(Qe.$$.fragment,Q),Do=r(Q),Ct=c(Q,"P",{"data-svelte-h":!0}),y(Ct)!=="svelte-7rf45m"&&(Ct.innerHTML=rs),Ao=r(Q),Ut=c(Q,"P",{"data-svelte-h":!0}),y(Ut)!=="svelte-o55m63"&&(Ut.innerHTML=is),Oo=r(Q),h(ne.$$.fragment,Q),Q.forEach(s),ko=r(e),h(Ye.$$.fragment,e),So=r(e),k=c(e,"DIV",{class:!0});var C=x(k);h(De.$$.fragment,C),Ko=r(C),Jt=c(C,"P",{"data-svelte-h":!0}),y(Jt)!=="svelte-xrmnfw"&&(Jt.innerHTML=ls),en=r(C),It=c(C,"P",{"data-svelte-h":!0}),y(It)!=="svelte-1c3t5ty"&&(It.innerHTML=ds),tn=r(C),Y=c(C,"DIV",{class:!0});var A=x(Y);h(Ae.$$.fragment,A),on=r(A),zt=c(A,"P",{"data-svelte-h":!0}),y(zt)!=="svelte-1wjq39d"&&(zt.textContent=ps),nn=r(A),Zt=c(A,"UL",{"data-svelte-h":!0}),y(Zt)!=="svelte-8gh3n2"&&(Zt.innerHTML=cs),A.forEach(s),sn=r(C),se=c(C,"DIV",{class:!0});var Mt=x(se);h(Oe.$$.fragment,Mt),an=r(Mt),Wt=c(Mt,"P",{"data-svelte-h":!0}),y(Wt)!=="svelte-1f4f5kp"&&(Wt.innerHTML=ms),Mt.forEach(s),rn=r(C),ae=c(C,"DIV",{class:!0});var Tt=x(ae);h(Ke.$$.fragment,Tt),ln=r(Tt),Bt=c(Tt,"P",{"data-svelte-h":!0}),y(Bt)!=="svelte-fl5ab0"&&(Bt.textContent=gs),Tt.forEach(s),dn=r(C),Vt=c(C,"DIV",{class:!0});var oo=x(Vt);h(et.$$.fragment,oo),oo.forEach(s),C.forEach(s),Co=r(e),h(tt.$$.fragment,e),Uo=r(e),H=c(e,"DIV",{class:!0});var O=x(H);h(ot.$$.fragment,O),pn=r(O),Nt=c(O,"P",{"data-svelte-h":!0}),y(Nt)!=="svelte-19glyt2"&&(Nt.textContent=hs),cn=r(O),re=c(O,"DIV",{class:!0});var wt=x(re);h(nt.$$.fragment,wt),mn=r(wt),Pt=c(wt,"P",{"data-svelte-h":!0}),y(Pt)!=="svelte-1x3yxsa"&&(Pt.textContent=fs),wt.forEach(s),O.forEach(s),Jo=r(e),h(st.$$.fragment,e),Io=r(e),J=c(e,"DIV",{class:!0});var N=x(J);h(at.$$.fragment,N),gn=r(N),Rt=c(N,"P",{"data-svelte-h":!0}),y(Rt)!=="svelte-yt9wur"&&(Rt.textContent=us),hn=r(N),Gt=c(N,"P",{"data-svelte-h":!0}),y(Gt)!=="svelte-uktko2"&&(Gt.innerHTML=_s),fn=r(N),ie=c(N,"DIV",{class:!0});var vt=x(ie);h(rt.$$.fragment,vt),un=r(vt),Lt=c(vt,"P",{"data-svelte-h":!0}),y(Lt)!=="svelte-1ucuehe"&&(Lt.innerHTML=bs),vt.forEach(s),_n=r(N),le=c(N,"DIV",{class:!0});var Go=x(le);h(it.$$.fragment,Go),bn=r(Go),qt=c(Go,"P",{"data-svelte-h":!0}),y(qt)!=="svelte-jppviw"&&(qt.innerHTML=ys),Go.forEach(s),N.forEach(s),zo=r(e),h(lt.$$.fragment,e),Zo=r(e),S=c(e,"DIV",{class:!0});var X=x(S);h(dt.$$.fragment,X),yn=r(X),Ft=c(X,"P",{"data-svelte-h":!0}),y(Ft)!=="svelte-6pahdo"&&(Ft.innerHTML=Ms),Mn=r(X),Xt=c(X,"P",{"data-svelte-h":!0}),y(Xt)!=="svelte-hswkmf"&&(Xt.innerHTML=Ts),Tn=r(X),R=c(X,"DIV",{class:!0});var ye=x(R);h(pt.$$.fragment,ye),wn=r(ye),Ht=c(ye,"P",{"data-svelte-h":!0}),y(Ht)!=="svelte-1giz8jp"&&(Ht.innerHTML=ws),vn=r(ye),h(de.$$.fragment,ye),$n=r(ye),h(pe.$$.fragment,ye),ye.forEach(s),xn=r(X),G=c(X,"DIV",{class:!0});var Me=x(G);h(ct.$$.fragment,Me),jn=r(Me),Et=c(Me,"P",{"data-svelte-h":!0}),y(Et)!=="svelte-1giz8jp"&&(Et.innerHTML=vs),kn=r(Me),h(ce.$$.fragment,Me),Sn=r(Me),h(me.$$.fragment,Me),Me.forEach(s),Cn=r(X),L=c(X,"DIV",{class:!0});var Te=x(L);h(mt.$$.fragment,Te),Un=r(Te),Qt=c(Te,"P",{"data-svelte-h":!0}),y(Qt)!=="svelte-1giz8jp"&&(Qt.innerHTML=$s),Jn=r(Te),h(ge.$$.fragment,Te),In=r(Te),h(he.$$.fragment,Te),Te.forEach(s),X.forEach(s),Wo=r(e),h(gt.$$.fragment,e),Bo=r(e),W=c(e,"DIV",{class:!0});var we=x(W);h(ht.$$.fragment,we),zn=r(we),Yt=c(we,"P",{"data-svelte-h":!0}),y(Yt)!=="svelte-1rx3ey7"&&(Yt.innerHTML=xs),Zn=r(we),Dt=c(we,"P",{"data-svelte-h":!0}),y(Dt)!=="svelte-hswkmf"&&(Dt.innerHTML=js),Wn=r(we),q=c(we,"DIV",{class:!0});var ve=x(q);h(ft.$$.fragment,ve),Bn=r(ve),At=c(ve,"P",{"data-svelte-h":!0}),y(At)!=="svelte-1kdkrlt"&&(At.innerHTML=ks),Vn=r(ve),h(fe.$$.fragment,ve),Nn=r(ve),h(ue.$$.fragment,ve),ve.forEach(s),we.forEach(s),Vo=r(e),h(ut.$$.fragment,e),No=r(e),B=c(e,"DIV",{class:!0});var $e=x(B);h(_t.$$.fragment,$e),Pn=r($e),Ot=c($e,"P",{"data-svelte-h":!0}),y(Ot)!=="svelte-14zwew2"&&(Ot.innerHTML=Ss),Rn=r($e),Kt=c($e,"P",{"data-svelte-h":!0}),y(Kt)!=="svelte-hswkmf"&&(Kt.innerHTML=Cs),Gn=r($e),F=c($e,"DIV",{class:!0});var xe=x(F);h(bt.$$.fragment,xe),Ln=r(xe),eo=c(xe,"P",{"data-svelte-h":!0}),y(eo)!=="svelte-1pjr3hd"&&(eo.innerHTML=Us),qn=r(xe),h(_e.$$.fragment,xe),Fn=r(xe),h(be.$$.fragment,xe),xe.forEach(s),$e.forEach(s),Po=r(e),to=c(e,"P",{}),x(to).forEach(s),this.h()},h(){$(o,"name","hf:doc:metadata"),$(o,"content",As),Is(K.src,Yn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/siglip_table.jpeg")||$(K,"src",Yn),$(K,"alt","drawing"),$(K,"width","600"),$(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){i(document.head,o),l(e,T,n),l(e,m,n),l(e,d,n),f(M,e,n),l(e,t,n),f(w,e,n),l(e,so,n),l(e,ke,n),l(e,ao,n),l(e,Se,n),l(e,ro,n),l(e,Ce,n),l(e,io,n),f(Ue,e,n),l(e,lo,n),l(e,Je,n),l(e,po,n),l(e,K,n),l(e,co,n),l(e,Ie,n),l(e,mo,n),l(e,ze,n),l(e,go,n),f(Ze,e,n),l(e,ho,n),l(e,We,n),l(e,fo,n),f(Be,e,n),l(e,uo,n),l(e,Ve,n),l(e,_o,n),f(Ne,e,n),l(e,bo,n),f(Pe,e,n),l(e,yo,n),l(e,Re,n),l(e,Mo,n),f(Ge,e,n),l(e,To,n),f(Le,e,n),l(e,wo,n),l(e,U,n),f(qe,U,null),i(U,Lo),i(U,$t),i(U,qo),i(U,xt),i(U,Fo),f(ee,U,null),i(U,Xo),i(U,te),f(Fe,te,null),i(te,Ho),i(te,jt),l(e,vo,n),f(Xe,e,n),l(e,$o,n),l(e,z,n),f(He,z,null),i(z,Eo),i(z,kt),i(z,Qo),i(z,St),i(z,Yo),f(oe,z,null),l(e,xo,n),f(Ee,e,n),l(e,jo,n),l(e,Z,n),f(Qe,Z,null),i(Z,Do),i(Z,Ct),i(Z,Ao),i(Z,Ut),i(Z,Oo),f(ne,Z,null),l(e,ko,n),f(Ye,e,n),l(e,So,n),l(e,k,n),f(De,k,null),i(k,Ko),i(k,Jt),i(k,en),i(k,It),i(k,tn),i(k,Y),f(Ae,Y,null),i(Y,on),i(Y,zt),i(Y,nn),i(Y,Zt),i(k,sn),i(k,se),f(Oe,se,null),i(se,an),i(se,Wt),i(k,rn),i(k,ae),f(Ke,ae,null),i(ae,ln),i(ae,Bt),i(k,dn),i(k,Vt),f(et,Vt,null),l(e,Co,n),f(tt,e,n),l(e,Uo,n),l(e,H,n),f(ot,H,null),i(H,pn),i(H,Nt),i(H,cn),i(H,re),f(nt,re,null),i(re,mn),i(re,Pt),l(e,Jo,n),f(st,e,n),l(e,Io,n),l(e,J,n),f(at,J,null),i(J,gn),i(J,Rt),i(J,hn),i(J,Gt),i(J,fn),i(J,ie),f(rt,ie,null),i(ie,un),i(ie,Lt),i(J,_n),i(J,le),f(it,le,null),i(le,bn),i(le,qt),l(e,zo,n),f(lt,e,n),l(e,Zo,n),l(e,S,n),f(dt,S,null),i(S,yn),i(S,Ft),i(S,Mn),i(S,Xt),i(S,Tn),i(S,R),f(pt,R,null),i(R,wn),i(R,Ht),i(R,vn),f(de,R,null),i(R,$n),f(pe,R,null),i(S,xn),i(S,G),f(ct,G,null),i(G,jn),i(G,Et),i(G,kn),f(ce,G,null),i(G,Sn),f(me,G,null),i(S,Cn),i(S,L),f(mt,L,null),i(L,Un),i(L,Qt),i(L,Jn),f(ge,L,null),i(L,In),f(he,L,null),l(e,Wo,n),f(gt,e,n),l(e,Bo,n),l(e,W,n),f(ht,W,null),i(W,zn),i(W,Yt),i(W,Zn),i(W,Dt),i(W,Wn),i(W,q),f(ft,q,null),i(q,Bn),i(q,At),i(q,Vn),f(fe,q,null),i(q,Nn),f(ue,q,null),l(e,Vo,n),f(ut,e,n),l(e,No,n),l(e,B,n),f(_t,B,null),i(B,Pn),i(B,Ot),i(B,Rn),i(B,Kt),i(B,Gn),i(B,F),f(bt,F,null),i(F,Ln),i(F,eo),i(F,qn),f(_e,F,null),i(F,Fn),f(be,F,null),l(e,Po,n),l(e,to,n),Ro=!0},p(e,[n]){const V={};n&2&&(V.$$scope={dirty:n,ctx:e}),ee.$set(V);const yt={};n&2&&(yt.$$scope={dirty:n,ctx:e}),oe.$set(yt);const E={};n&2&&(E.$$scope={dirty:n,ctx:e}),ne.$set(E);const Q={};n&2&&(Q.$$scope={dirty:n,ctx:e}),de.$set(Q);const C={};n&2&&(C.$$scope={dirty:n,ctx:e}),pe.$set(C);const A={};n&2&&(A.$$scope={dirty:n,ctx:e}),ce.$set(A);const Mt={};n&2&&(Mt.$$scope={dirty:n,ctx:e}),me.$set(Mt);const Tt={};n&2&&(Tt.$$scope={dirty:n,ctx:e}),ge.$set(Tt);const oo={};n&2&&(oo.$$scope={dirty:n,ctx:e}),he.$set(oo);const O={};n&2&&(O.$$scope={dirty:n,ctx:e}),fe.$set(O);const wt={};n&2&&(wt.$$scope={dirty:n,ctx:e}),ue.$set(wt);const N={};n&2&&(N.$$scope={dirty:n,ctx:e}),_e.$set(N);const vt={};n&2&&(vt.$$scope={dirty:n,ctx:e}),be.$set(vt)},i(e){Ro||(u(M.$$.fragment,e),u(w.$$.fragment,e),u(Ue.$$.fragment,e),u(Ze.$$.fragment,e),u(Be.$$.fragment,e),u(Ne.$$.fragment,e),u(Pe.$$.fragment,e),u(Ge.$$.fragment,e),u(Le.$$.fragment,e),u(qe.$$.fragment,e),u(ee.$$.fragment,e),u(Fe.$$.fragment,e),u(Xe.$$.fragment,e),u(He.$$.fragment,e),u(oe.$$.fragment,e),u(Ee.$$.fragment,e),u(Qe.$$.fragment,e),u(ne.$$.fragment,e),u(Ye.$$.fragment,e),u(De.$$.fragment,e),u(Ae.$$.fragment,e),u(Oe.$$.fragment,e),u(Ke.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(ot.$$.fragment,e),u(nt.$$.fragment,e),u(st.$$.fragment,e),u(at.$$.fragment,e),u(rt.$$.fragment,e),u(it.$$.fragment,e),u(lt.$$.fragment,e),u(dt.$$.fragment,e),u(pt.$$.fragment,e),u(de.$$.fragment,e),u(pe.$$.fragment,e),u(ct.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(mt.$$.fragment,e),u(ge.$$.fragment,e),u(he.$$.fragment,e),u(gt.$$.fragment,e),u(ht.$$.fragment,e),u(ft.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(ut.$$.fragment,e),u(_t.$$.fragment,e),u(bt.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),Ro=!0)},o(e){_(M.$$.fragment,e),_(w.$$.fragment,e),_(Ue.$$.fragment,e),_(Ze.$$.fragment,e),_(Be.$$.fragment,e),_(Ne.$$.fragment,e),_(Pe.$$.fragment,e),_(Ge.$$.fragment,e),_(Le.$$.fragment,e),_(qe.$$.fragment,e),_(ee.$$.fragment,e),_(Fe.$$.fragment,e),_(Xe.$$.fragment,e),_(He.$$.fragment,e),_(oe.$$.fragment,e),_(Ee.$$.fragment,e),_(Qe.$$.fragment,e),_(ne.$$.fragment,e),_(Ye.$$.fragment,e),_(De.$$.fragment,e),_(Ae.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(ot.$$.fragment,e),_(nt.$$.fragment,e),_(st.$$.fragment,e),_(at.$$.fragment,e),_(rt.$$.fragment,e),_(it.$$.fragment,e),_(lt.$$.fragment,e),_(dt.$$.fragment,e),_(pt.$$.fragment,e),_(de.$$.fragment,e),_(pe.$$.fragment,e),_(ct.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(mt.$$.fragment,e),_(ge.$$.fragment,e),_(he.$$.fragment,e),_(gt.$$.fragment,e),_(ht.$$.fragment,e),_(ft.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(ut.$$.fragment,e),_(_t.$$.fragment,e),_(bt.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),Ro=!1},d(e){e&&(s(T),s(m),s(d),s(t),s(so),s(ke),s(ao),s(Se),s(ro),s(Ce),s(io),s(lo),s(Je),s(po),s(K),s(co),s(Ie),s(mo),s(ze),s(go),s(ho),s(We),s(fo),s(uo),s(Ve),s(_o),s(bo),s(yo),s(Re),s(Mo),s(To),s(wo),s(U),s(vo),s($o),s(z),s(xo),s(jo),s(Z),s(ko),s(So),s(k),s(Co),s(Uo),s(H),s(Jo),s(Io),s(J),s(zo),s(Zo),s(S),s(Wo),s(Bo),s(W),s(Vo),s(No),s(B),s(Po),s(to)),s(o),b(M,e),b(w,e),b(Ue,e),b(Ze,e),b(Be,e),b(Ne,e),b(Pe,e),b(Ge,e),b(Le,e),b(qe),b(ee),b(Fe),b(Xe,e),b(He),b(oe),b(Ee,e),b(Qe),b(ne),b(Ye,e),b(De),b(Ae),b(Oe),b(Ke),b(et),b(tt,e),b(ot),b(nt),b(st,e),b(at),b(rt),b(it),b(lt,e),b(dt),b(pt),b(de),b(pe),b(ct),b(ce),b(me),b(mt),b(ge),b(he),b(gt,e),b(ht),b(ft),b(fe),b(ue),b(ut,e),b(_t),b(bt),b(_e),b(be)}}}const As='{"title":"SigLIP","local":"siglip","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Pipeline API","local":"pipeline-api","sections":[],"depth":3},{"title":"Using the model yourself","local":"using-the-model-yourself","sections":[],"depth":3}],"depth":2},{"title":"SiglipConfig","local":"transformers.SiglipConfig","sections":[],"depth":2},{"title":"SiglipTextConfig","local":"transformers.SiglipTextConfig","sections":[],"depth":2},{"title":"SiglipVisionConfig","local":"transformers.SiglipVisionConfig","sections":[],"depth":2},{"title":"SiglipTokenizer","local":"transformers.SiglipTokenizer","sections":[],"depth":2},{"title":"SiglipImageProcessor","local":"transformers.SiglipImageProcessor","sections":[],"depth":2},{"title":"SiglipProcessor","local":"transformers.SiglipProcessor","sections":[],"depth":2},{"title":"SiglipModel","local":"transformers.SiglipModel","sections":[],"depth":2},{"title":"SiglipTextModel","local":"transformers.SiglipTextModel","sections":[],"depth":2},{"title":"SiglipVisionModel","local":"transformers.SiglipVisionModel","sections":[],"depth":2}],"depth":1}';function Os(v){return zs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ra extends Zs{constructor(o){super(),Ws(this,o,Os,Ds,Js,{})}}export{ra as component};
