import{s as at,n as dt,o as lt}from"../chunks/scheduler.182ea377.js";import{S as ct,i as ut,g as i,s as r,r as p,A as pt,h as a,f as t,c as o,j as v,u as h,x as u,k as b,y as n,a as d,v as m,d as f,t as g,w as _}from"../chunks/index.abf12888.js";import{D as U}from"../chunks/Docstring.93f6f462.js";import{H as Ue}from"../chunks/Heading.16916d63.js";function ht(Be){let x,oe,ne,ie,w,ae,D,Re='<code>UniPCMultistepScheduler</code> is a training-free framework designed for fast sampling of diffusion models. It was introduced in <a href="https://huggingface.co/papers/2302.04867" rel="nofollow">UniPC: A Unified Predictor-Corrector Framework for Fast Sampling of Diffusion Models</a> by Wenliang Zhao, Lujia Bai, Yongming Rao, Jie Zhou, Jiwen Lu.',de,F,je=`It consists of a corrector (UniC) and a predictor (UniP) that share a unified analytical form and support arbitrary orders.
UniPC is by design model-agnostic, supporting pixel-space/latent-space DPMs on unconditional/conditional sampling. It can also be applied to both noise prediction and data prediction models. The corrector UniC can be also applied after any off-the-shelf solvers to increase the order of accuracy.`,le,L,Je="The abstract from the paper is:",ce,I,Ye='<em>Diffusion probabilistic models (DPMs) have demonstrated a very promising ability in high-resolution image synthesis. However, sampling from a pre-trained DPM usually requires hundreds of model evaluations, which is computationally expensive. Despite recent progress in designing high-order solvers for DPMs, there still exists room for further speedup, especially in extremely few steps (e.g., 5~10 steps). Inspired by the predictor-corrector for ODE solvers, we develop a unified corrector (UniC) that can be applied after any existing DPM sampler to increase the order of accuracy without extra model evaluations, and derive a unified predictor (UniP) that supports arbitrary order as a byproduct. Combining UniP and UniC, we propose a unified predictor-corrector framework called UniPC for the fast sampling of DPMs, which has a unified analytical form for any order and can significantly improve the sampling quality over previous methods. We evaluate our methods through extensive experiments including both unconditional and conditional sampling using pixel-space and latent-space DPMs. Our UniPC can achieve 3.87 FID on CIFAR10 (unconditional) and 7.51 FID on ImageNet 256times256 (conditional) with only 10 function evaluations. Code is available at <a href="https://github.com/wl-zhao/UniPC" rel="nofollow">https://github.com/wl-zhao/UniPC</a></em>.',ue,H,Ze='The original codebase can be found at <a href="https://github.com/wl-zhao/UniPC" rel="nofollow">wl-zhao/UniPC</a>.',pe,k,he,O,Ke="It is recommended to set <code>solver_order</code> to 2 for guide sampling, and <code>solver_order=3</code> for unconditional sampling.",me,E,Ge=`Dynamic thresholding from Imagen (<a href="https://huggingface.co/papers/2205.11487" rel="nofollow">https://huggingface.co/papers/2205.11487</a>) is supported, and for pixel-space
diffusion models, you can set both <code>predict_x0=True</code> and <code>thresholding=True</code> to use dynamic thresholding. This thresholding method is unsuitable for latent-space diffusion models such as Stable Diffusion.`,fe,N,ge,l,q,we,Y,Qe="<code>UniPCMultistepScheduler</code> is a training-free framework designed for the fast sampling of diffusion models.",De,Z,Xe=`This model inherits from <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a> and <a href="/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin">ConfigMixin</a>. Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.`,Fe,T,A,Le,K,et="Convert the model output to the corresponding type the UniPC algorithm needs.",Ie,P,V,He,G,tt="One step for the UniC (B(h) version).",ke,y,z,Oe,Q,st="One step for the UniP (B(h) version). Alternatively, <code>self.solver_p</code> is used if is specified.",Ee,$,W,Ne,X,nt=`Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep.`,qe,M,B,Ae,ee,rt="Sets the discrete timesteps used for the diffusion chain (to be run before inference).",Ve,S,R,ze,te,ot=`Predict the sample from the previous timestep by reversing the SDE. This function propagates the sample with
the multistep UniPC.`,_e,j,ve,C,J,We,se,it="Base class for the output of a scheduler’s <code>step</code> function.",be,re,xe;return w=new Ue({props:{title:"UniPCMultistepScheduler",local:"unipcmultistepscheduler",headingTag:"h1"}}),k=new Ue({props:{title:"Tips",local:"tips",headingTag:"h2"}}),N=new Ue({props:{title:"UniPCMultistepScheduler",local:"diffusers.UniPCMultistepScheduler",headingTag:"h2"}}),q=new U({props:{name:"class diffusers.UniPCMultistepScheduler",anchor:"diffusers.UniPCMultistepScheduler",parameters:[{name:"num_train_timesteps",val:": int = 1000"},{name:"beta_start",val:": float = 0.0001"},{name:"beta_end",val:": float = 0.02"},{name:"beta_schedule",val:": str = 'linear'"},{name:"trained_betas",val:": typing.Union[numpy.ndarray, typing.List[float], NoneType] = None"},{name:"solver_order",val:": int = 2"},{name:"prediction_type",val:": str = 'epsilon'"},{name:"thresholding",val:": bool = False"},{name:"dynamic_thresholding_ratio",val:": float = 0.995"},{name:"sample_max_value",val:": float = 1.0"},{name:"predict_x0",val:": bool = True"},{name:"solver_type",val:": str = 'bh2'"},{name:"lower_order_final",val:": bool = True"},{name:"disable_corrector",val:": typing.List[int] = []"},{name:"solver_p",val:": SchedulerMixin = None"},{name:"use_karras_sigmas",val:": typing.Optional[bool] = False"},{name:"timestep_spacing",val:": str = 'linspace'"},{name:"steps_offset",val:": int = 0"}],parametersDescription:[{anchor:"diffusers.UniPCMultistepScheduler.num_train_timesteps",description:`<strong>num_train_timesteps</strong> (<code>int</code>, defaults to 1000) &#x2014;
The number of diffusion steps to train the model.`,name:"num_train_timesteps"},{anchor:"diffusers.UniPCMultistepScheduler.beta_start",description:`<strong>beta_start</strong> (<code>float</code>, defaults to 0.0001) &#x2014;
The starting <code>beta</code> value of inference.`,name:"beta_start"},{anchor:"diffusers.UniPCMultistepScheduler.beta_end",description:`<strong>beta_end</strong> (<code>float</code>, defaults to 0.02) &#x2014;
The final <code>beta</code> value.`,name:"beta_end"},{anchor:"diffusers.UniPCMultistepScheduler.beta_schedule",description:`<strong>beta_schedule</strong> (<code>str</code>, defaults to <code>&quot;linear&quot;</code>) &#x2014;
The beta schedule, a mapping from a beta range to a sequence of betas for stepping the model. Choose from
<code>linear</code>, <code>scaled_linear</code>, or <code>squaredcos_cap_v2</code>.`,name:"beta_schedule"},{anchor:"diffusers.UniPCMultistepScheduler.trained_betas",description:`<strong>trained_betas</strong> (<code>np.ndarray</code>, <em>optional</em>) &#x2014;
Pass an array of betas directly to the constructor to bypass <code>beta_start</code> and <code>beta_end</code>.`,name:"trained_betas"},{anchor:"diffusers.UniPCMultistepScheduler.solver_order",description:`<strong>solver_order</strong> (<code>int</code>, default <code>2</code>) &#x2014;
The UniPC order which can be any positive integer. The effective order of accuracy is <code>solver_order + 1</code>
due to the UniC. It is recommended to use <code>solver_order=2</code> for guided sampling, and <code>solver_order=3</code> for
unconditional sampling.`,name:"solver_order"},{anchor:"diffusers.UniPCMultistepScheduler.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, defaults to <code>epsilon</code>, <em>optional</em>) &#x2014;
Prediction type of the scheduler function; can be <code>epsilon</code> (predicts the noise of the diffusion process),
<code>sample</code> (directly predicts the noisy sample<code>) or </code>v_prediction\` (see section 2.4 of <a href="https://imagen.research.google/video/paper.pdf" rel="nofollow">Imagen
Video</a> paper).`,name:"prediction_type"},{anchor:"diffusers.UniPCMultistepScheduler.thresholding",description:`<strong>thresholding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use the &#x201C;dynamic thresholding&#x201D; method. This is unsuitable for latent-space diffusion models such
as Stable Diffusion.`,name:"thresholding"},{anchor:"diffusers.UniPCMultistepScheduler.dynamic_thresholding_ratio",description:`<strong>dynamic_thresholding_ratio</strong> (<code>float</code>, defaults to 0.995) &#x2014;
The ratio for the dynamic thresholding method. Valid only when <code>thresholding=True</code>.`,name:"dynamic_thresholding_ratio"},{anchor:"diffusers.UniPCMultistepScheduler.sample_max_value",description:`<strong>sample_max_value</strong> (<code>float</code>, defaults to 1.0) &#x2014;
The threshold value for dynamic thresholding. Valid only when <code>thresholding=True</code> and <code>predict_x0=True</code>.`,name:"sample_max_value"},{anchor:"diffusers.UniPCMultistepScheduler.predict_x0",description:`<strong>predict_x0</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use the updating algorithm on the predicted x0.`,name:"predict_x0"},{anchor:"diffusers.UniPCMultistepScheduler.solver_type",description:`<strong>solver_type</strong> (<code>str</code>, default <code>bh2</code>) &#x2014;
Solver type for UniPC. It is recommended to use <code>bh1</code> for unconditional sampling when steps &lt; 10, and <code>bh2</code>
otherwise.`,name:"solver_type"},{anchor:"diffusers.UniPCMultistepScheduler.lower_order_final",description:`<strong>lower_order_final</strong> (<code>bool</code>, default <code>True</code>) &#x2014;
Whether to use lower-order solvers in the final steps. Only valid for &lt; 15 inference steps. This can
stabilize the sampling of DPMSolver for steps &lt; 15, especially for steps &lt;= 10.`,name:"lower_order_final"},{anchor:"diffusers.UniPCMultistepScheduler.disable_corrector",description:`<strong>disable_corrector</strong> (<code>list</code>, default <code>[]</code>) &#x2014;
Decides which step to disable the corrector to mitigate the misalignment between <code>epsilon_theta(x_t, c)</code>
and <code>epsilon_theta(x_t^c, c)</code> which can influence convergence for a large guidance scale. Corrector is
usually disabled during the first few steps.`,name:"disable_corrector"},{anchor:"diffusers.UniPCMultistepScheduler.solver_p",description:`<strong>solver_p</strong> (<code>SchedulerMixin</code>, default <code>None</code>) &#x2014;
Any other scheduler that if specified, the algorithm becomes <code>solver_p + UniC</code>.`,name:"solver_p"},{anchor:"diffusers.UniPCMultistepScheduler.use_karras_sigmas",description:`<strong>use_karras_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use Karras sigmas for step sizes in the noise schedule during the sampling process. If <code>True</code>,
the sigmas are determined according to a sequence of noise levels {&#x3C3;i}.`,name:"use_karras_sigmas"},{anchor:"diffusers.UniPCMultistepScheduler.timestep_spacing",description:`<strong>timestep_spacing</strong> (<code>str</code>, defaults to <code>&quot;linspace&quot;</code>) &#x2014;
The way the timesteps should be scaled. Refer to Table 2 of the <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and
Sample Steps are Flawed</a> for more information.`,name:"timestep_spacing"},{anchor:"diffusers.UniPCMultistepScheduler.steps_offset",description:`<strong>steps_offset</strong> (<code>int</code>, defaults to 0) &#x2014;
An offset added to the inference steps. You can use a combination of <code>offset=1</code> and
<code>set_alpha_to_one=False</code> to make the last step use step 0 for the previous alpha product like in Stable
Diffusion.`,name:"steps_offset"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_unipc_multistep.py#L74"}}),A=new U({props:{name:"convert_model_output",anchor:"diffusers.UniPCMultistepScheduler.convert_model_output",parameters:[{name:"model_output",val:": FloatTensor"},{name:"*args",val:""},{name:"sample",val:": FloatTensor = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.UniPCMultistepScheduler.convert_model_output.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from the learned diffusion model.`,name:"model_output"},{anchor:"diffusers.UniPCMultistepScheduler.convert_model_output.timestep",description:`<strong>timestep</strong> (<code>int</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.UniPCMultistepScheduler.convert_model_output.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_unipc_multistep.py#L352",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The converted model output.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),V=new U({props:{name:"multistep_uni_c_bh_update",anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_c_bh_update",parameters:[{name:"this_model_output",val:": FloatTensor"},{name:"*args",val:""},{name:"last_sample",val:": FloatTensor = None"},{name:"this_sample",val:": FloatTensor = None"},{name:"order",val:": int = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_c_bh_update.this_model_output",description:`<strong>this_model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The model outputs at <code>x_t</code>.`,name:"this_model_output"},{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_c_bh_update.this_timestep",description:`<strong>this_timestep</strong> (<code>int</code>) &#x2014;
The current timestep <code>t</code>.`,name:"this_timestep"},{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_c_bh_update.last_sample",description:`<strong>last_sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
The generated sample before the last predictor <code>x_{t-1}</code>.`,name:"last_sample"},{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_c_bh_update.this_sample",description:`<strong>this_sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
The generated sample after the last predictor <code>x_{t}</code>.`,name:"this_sample"},{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_c_bh_update.order",description:`<strong>order</strong> (<code>int</code>) &#x2014;
The <code>p</code> of UniC-p at this step. The effective order of accuracy should be <code>order + 1</code>.`,name:"order"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_unipc_multistep.py#L551",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The corrected sample tensor at the current timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),z=new U({props:{name:"multistep_uni_p_bh_update",anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_p_bh_update",parameters:[{name:"model_output",val:": FloatTensor"},{name:"*args",val:""},{name:"sample",val:": FloatTensor = None"},{name:"order",val:": int = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_p_bh_update.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from the learned diffusion model at the current timestep.`,name:"model_output"},{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_p_bh_update.prev_timestep",description:`<strong>prev_timestep</strong> (<code>int</code>) &#x2014;
The previous discrete timestep in the diffusion chain.`,name:"prev_timestep"},{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_p_bh_update.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"},{anchor:"diffusers.UniPCMultistepScheduler.multistep_uni_p_bh_update.order",description:`<strong>order</strong> (<code>int</code>) &#x2014;
The order of UniP at this timestep (corresponds to the <em>p</em> in UniPC-p).`,name:"order"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_unipc_multistep.py#L422",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),W=new U({props:{name:"scale_model_input",anchor:"diffusers.UniPCMultistepScheduler.scale_model_input",parameters:[{name:"sample",val:": FloatTensor"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.UniPCMultistepScheduler.scale_model_input.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
The input sample.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_unipc_multistep.py#L788",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A scaled input sample.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),B=new U({props:{name:"set_timesteps",anchor:"diffusers.UniPCMultistepScheduler.set_timesteps",parameters:[{name:"num_inference_steps",val:": int"},{name:"device",val:": typing.Union[str, torch.device] = None"}],parametersDescription:[{anchor:"diffusers.UniPCMultistepScheduler.set_timesteps.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>) &#x2014;
The number of diffusion steps used when generating samples with a pre-trained model.`,name:"num_inference_steps"},{anchor:"diffusers.UniPCMultistepScheduler.set_timesteps.device",description:`<strong>device</strong> (<code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device to which the timesteps should be moved to. If <code>None</code>, the timesteps are not moved.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_unipc_multistep.py#L210"}}),R=new U({props:{name:"step",anchor:"diffusers.UniPCMultistepScheduler.step",parameters:[{name:"model_output",val:": FloatTensor"},{name:"timestep",val:": int"},{name:"sample",val:": FloatTensor"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.UniPCMultistepScheduler.step.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from learned diffusion model.`,name:"model_output"},{anchor:"diffusers.UniPCMultistepScheduler.step.timestep",description:`<strong>timestep</strong> (<code>int</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.UniPCMultistepScheduler.step.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"},{anchor:"diffusers.UniPCMultistepScheduler.step.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/schedulers/dpm_discrete#diffusers.schedulers.scheduling_utils.SchedulerOutput">SchedulerOutput</a> or <code>tuple</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_unipc_multistep.py#L707",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If return_dict is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/schedulers/dpm_discrete#diffusers.schedulers.scheduling_utils.SchedulerOutput"
>SchedulerOutput</a> is returned, otherwise a
tuple is returned where the first element is the sample tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/schedulers/dpm_discrete#diffusers.schedulers.scheduling_utils.SchedulerOutput"
>SchedulerOutput</a> or <code>tuple</code></p>
`}}),j=new Ue({props:{title:"SchedulerOutput",local:"diffusers.schedulers.scheduling_utils.SchedulerOutput",headingTag:"h2"}}),J=new U({props:{name:"class diffusers.schedulers.scheduling_utils.SchedulerOutput",anchor:"diffusers.schedulers.scheduling_utils.SchedulerOutput",parameters:[{name:"prev_sample",val:": FloatTensor"}],parametersDescription:[{anchor:"diffusers.schedulers.scheduling_utils.SchedulerOutput.prev_sample",description:`<strong>prev_sample</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code> for images) &#x2014;
Computed sample <code>(x_{t-1})</code> of previous timestep. <code>prev_sample</code> should be used as next model input in the
denoising loop.`,name:"prev_sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_utils.py#L50"}}),{c(){x=i("meta"),oe=r(),ne=i("p"),ie=r(),p(w.$$.fragment),ae=r(),D=i("p"),D.innerHTML=Re,de=r(),F=i("p"),F.textContent=je,le=r(),L=i("p"),L.textContent=Je,ce=r(),I=i("p"),I.innerHTML=Ye,ue=r(),H=i("p"),H.innerHTML=Ze,pe=r(),p(k.$$.fragment),he=r(),O=i("p"),O.innerHTML=Ke,me=r(),E=i("p"),E.innerHTML=Ge,fe=r(),p(N.$$.fragment),ge=r(),l=i("div"),p(q.$$.fragment),we=r(),Y=i("p"),Y.innerHTML=Qe,De=r(),Z=i("p"),Z.innerHTML=Xe,Fe=r(),T=i("div"),p(A.$$.fragment),Le=r(),K=i("p"),K.textContent=et,Ie=r(),P=i("div"),p(V.$$.fragment),He=r(),G=i("p"),G.textContent=tt,ke=r(),y=i("div"),p(z.$$.fragment),Oe=r(),Q=i("p"),Q.innerHTML=st,Ee=r(),$=i("div"),p(W.$$.fragment),Ne=r(),X=i("p"),X.textContent=nt,qe=r(),M=i("div"),p(B.$$.fragment),Ae=r(),ee=i("p"),ee.textContent=rt,Ve=r(),S=i("div"),p(R.$$.fragment),ze=r(),te=i("p"),te.textContent=ot,_e=r(),p(j.$$.fragment),ve=r(),C=i("div"),p(J.$$.fragment),We=r(),se=i("p"),se.innerHTML=it,be=r(),re=i("p"),this.h()},l(e){const s=pt("svelte-u9bgzb",document.head);x=a(s,"META",{name:!0,content:!0}),s.forEach(t),oe=o(e),ne=a(e,"P",{}),v(ne).forEach(t),ie=o(e),h(w.$$.fragment,e),ae=o(e),D=a(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-1tyrzxd"&&(D.innerHTML=Re),de=o(e),F=a(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-16di28y"&&(F.textContent=je),le=o(e),L=a(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-1cwsb16"&&(L.textContent=Je),ce=o(e),I=a(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-yeqfi7"&&(I.innerHTML=Ye),ue=o(e),H=a(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1t9kf9n"&&(H.innerHTML=Ze),pe=o(e),h(k.$$.fragment,e),he=o(e),O=a(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-pt2glg"&&(O.innerHTML=Ke),me=o(e),E=a(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-1r792wh"&&(E.innerHTML=Ge),fe=o(e),h(N.$$.fragment,e),ge=o(e),l=a(e,"DIV",{class:!0});var c=v(l);h(q.$$.fragment,c),we=o(c),Y=a(c,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-lu1m8w"&&(Y.innerHTML=Qe),De=o(c),Z=a(c,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-linuuh"&&(Z.innerHTML=Xe),Fe=o(c),T=a(c,"DIV",{class:!0});var Ce=v(T);h(A.$$.fragment,Ce),Le=o(Ce),K=a(Ce,"P",{"data-svelte-h":!0}),u(K)!=="svelte-ixnexx"&&(K.textContent=et),Ce.forEach(t),Ie=o(c),P=a(c,"DIV",{class:!0});var Te=v(P);h(V.$$.fragment,Te),He=o(Te),G=a(Te,"P",{"data-svelte-h":!0}),u(G)!=="svelte-d0n1u7"&&(G.textContent=tt),Te.forEach(t),ke=o(c),y=a(c,"DIV",{class:!0});var Pe=v(y);h(z.$$.fragment,Pe),Oe=o(Pe),Q=a(Pe,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-s6vwmd"&&(Q.innerHTML=st),Pe.forEach(t),Ee=o(c),$=a(c,"DIV",{class:!0});var ye=v($);h(W.$$.fragment,ye),Ne=o(ye),X=a(ye,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1rkfgpx"&&(X.textContent=nt),ye.forEach(t),qe=o(c),M=a(c,"DIV",{class:!0});var $e=v(M);h(B.$$.fragment,$e),Ae=o($e),ee=a($e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-1vzm9q"&&(ee.textContent=rt),$e.forEach(t),Ve=o(c),S=a(c,"DIV",{class:!0});var Me=v(S);h(R.$$.fragment,Me),ze=o(Me),te=a(Me,"P",{"data-svelte-h":!0}),u(te)!=="svelte-5y602c"&&(te.textContent=ot),Me.forEach(t),c.forEach(t),_e=o(e),h(j.$$.fragment,e),ve=o(e),C=a(e,"DIV",{class:!0});var Se=v(C);h(J.$$.fragment,Se),We=o(Se),se=a(Se,"P",{"data-svelte-h":!0}),u(se)!=="svelte-6ojmkw"&&(se.innerHTML=it),Se.forEach(t),be=o(e),re=a(e,"P",{}),v(re).forEach(t),this.h()},h(){b(x,"name","hf:doc:metadata"),b(x,"content",mt),b(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){n(document.head,x),d(e,oe,s),d(e,ne,s),d(e,ie,s),m(w,e,s),d(e,ae,s),d(e,D,s),d(e,de,s),d(e,F,s),d(e,le,s),d(e,L,s),d(e,ce,s),d(e,I,s),d(e,ue,s),d(e,H,s),d(e,pe,s),m(k,e,s),d(e,he,s),d(e,O,s),d(e,me,s),d(e,E,s),d(e,fe,s),m(N,e,s),d(e,ge,s),d(e,l,s),m(q,l,null),n(l,we),n(l,Y),n(l,De),n(l,Z),n(l,Fe),n(l,T),m(A,T,null),n(T,Le),n(T,K),n(l,Ie),n(l,P),m(V,P,null),n(P,He),n(P,G),n(l,ke),n(l,y),m(z,y,null),n(y,Oe),n(y,Q),n(l,Ee),n(l,$),m(W,$,null),n($,Ne),n($,X),n(l,qe),n(l,M),m(B,M,null),n(M,Ae),n(M,ee),n(l,Ve),n(l,S),m(R,S,null),n(S,ze),n(S,te),d(e,_e,s),m(j,e,s),d(e,ve,s),d(e,C,s),m(J,C,null),n(C,We),n(C,se),d(e,be,s),d(e,re,s),xe=!0},p:dt,i(e){xe||(f(w.$$.fragment,e),f(k.$$.fragment,e),f(N.$$.fragment,e),f(q.$$.fragment,e),f(A.$$.fragment,e),f(V.$$.fragment,e),f(z.$$.fragment,e),f(W.$$.fragment,e),f(B.$$.fragment,e),f(R.$$.fragment,e),f(j.$$.fragment,e),f(J.$$.fragment,e),xe=!0)},o(e){g(w.$$.fragment,e),g(k.$$.fragment,e),g(N.$$.fragment,e),g(q.$$.fragment,e),g(A.$$.fragment,e),g(V.$$.fragment,e),g(z.$$.fragment,e),g(W.$$.fragment,e),g(B.$$.fragment,e),g(R.$$.fragment,e),g(j.$$.fragment,e),g(J.$$.fragment,e),xe=!1},d(e){e&&(t(oe),t(ne),t(ie),t(ae),t(D),t(de),t(F),t(le),t(L),t(ce),t(I),t(ue),t(H),t(pe),t(he),t(O),t(me),t(E),t(fe),t(ge),t(l),t(_e),t(ve),t(C),t(be),t(re)),t(x),_(w,e),_(k,e),_(N,e),_(q),_(A),_(V),_(z),_(W),_(B),_(R),_(j,e),_(J)}}}const mt='{"title":"UniPCMultistepScheduler","local":"unipcmultistepscheduler","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"UniPCMultistepScheduler","local":"diffusers.UniPCMultistepScheduler","sections":[],"depth":2},{"title":"SchedulerOutput","local":"diffusers.schedulers.scheduling_utils.SchedulerOutput","sections":[],"depth":2}],"depth":1}';function ft(Be){return lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends ct{constructor(x){super(),ut(this,x,ft,ht,at,{})}}export{xt as component};
